/* Serviços de Requisição, Incidente, OS e Procedimento*/

_TIPO_SERVICO_NEGOCIO = "N"; //br.com.centralit.citcorpore.util.Enumerados.TipoServico.SERVICO_NEGOCIO
_TIPO_SERVICO_APOIO = "A"; //br.com.centralit.citcorpore.util.Enumerados.TipoServico.SERVICO_APOIO
_TIPO_SERVICO_REQUISICAO = "R"; //br.com.centralit.citcorpore.util.Enumerados.TipoServico.SERVICO_REQUISICAO
_TIPO_SERVICO_INCIDENTE = "I"; //br.com.centralit.citcorpore.util.Enumerados.TipoServico.SERVICO_INCIDENTE
_TIPO_SERVICO_PROCEDIMENTO = "P"; //br.com.centralit.citcorpore.util.Enumerados.TipoServico.SERVICO_PROCEDIMENTO
_TIPO_CATEGORIA_INCIDENTE_REQUISICAO = "I"; //br.com.centralit.citcorpore.util.Enumerados.TipoCategoria.CATEGORIA_INCIDENTE_REQUISICAO
_TIPO_CATEGORIA_PROCEDIMENTO = "P"; //br.com.centralit.citcorpore.util.Enumerados.TipoCategoria.CATEGORIA_PROCEDIMENTO

$(function() {
	$("#inputFiltroServicoRequisicaoNegocio").keyup(function(event) {
		if (event.which == _TECLA_ENTER) {
			changeFiltroServicoRequisicaoNegocio($(event.currentTarget).val());
		}
	});

	$("#inputFiltroServicoIncidenteNegocio").keyup(function(event) {
		if (event.which == _TECLA_ENTER) {
			changeFiltroServicoIncidenteNegocio($(event.currentTarget).val());
		}
	});
	
	$("#inputFiltroServicoRequisicaoApoio").keyup(function(event) {
		if (event.which == _TECLA_ENTER) {
			changeFiltroServicoRequisicaoApoio($(event.currentTarget).val());
		}
	});
	
	$("#inputFiltroServicoIncidenteApoio").keyup(function(event) {
		if (event.which == _TECLA_ENTER) {
			changeFiltroServicoIncidenteApoio($(event.currentTarget).val());
		}
	});
	
	$("#inputFiltroServicoProcedimento").keyup(function(event) {
		if (event.which == _TECLA_ENTER) {
			changeFiltroServicoProcedimento($(event.currentTarget).val());
		}
	});

	definirAfters();
});

function carregarListaServicosRequisicaoIncidente(ref) {
	document.formCadastroServico.idServicoRelacionado.value = getServicoRelacionado();
	document.formCadastroServico.idPortfolioServico.value = document.form.idPortfolioServicoAtual.value;
	document.formCadastroServico.tipoServicoRelacionado.value = getTipoServicoRelacionado();
	if (ref.indexOf('Procedimento') > -1) {
		document.formCadastroServico.tipoServico.value = _TIPO_SERVICO_PROCEDIMENTO;
	} else if (ref.indexOf('Incidente') > -1) {
		document.formCadastroServico.tipoServico.value = _TIPO_SERVICO_INCIDENTE;
	} else if (ref.indexOf('Requisicao') > -1) {
		document.formCadastroServico.tipoServico.value = _TIPO_SERVICO_REQUISICAO;
	}
	document.formCadastroServico.fireEvent("load");
}

function getTipoServicoRelacionado() {
	if (getTipoTela() == 'servicoNegocio') {
		return _TIPO_SERVICO_NEGOCIO;
	}
	return _TIPO_SERVICO_APOIO;
}

function definirAfters(){
	document.formCadastroServico.afterRestore = function() {
		afterRestoreCadastroServico();
	}
	
	document.formCadastroServico.afterSave = function() {
		afterSaveCadastroServico();
	}
}

function afterRestoreCadastroServico(){
	if(Modal.isOpen('modal-portfolio-servico-requisicao-incidente')){
		JANELA_AGUARDE_MENU.hide();
	}else{
		JANELA_AGUARDE_MENU.show();
	}
}

function afterSaveCadastroServico() {
	if(Modal.isOpen('modal-portfolio-servico-requisicao-incidente')){
		Modal.close('modal-portfolio-servico-requisicao-incidente');
	}
}

function reloadFormCadastroServico(){
	// Força a arquitetura a recarregar os forms
	DEFINEALLPAGES_atribuiCaracteristicasCitAjax();

	definirAfters();
	definirValoresPadraoForm();

	$('.datepicker').removeClass('hasDatepicker').datepicker();
	
}

function limparCadastroServico(tipoServico){
	document.formCadastroServico.clear();
	inicializarCadastroServico(getTipoServicoRelacionado(), tipoServico);
	$('.portal-content').hide();
}

function excluirCadastroServico() {
	if (document.formCadastroServico.idServicoReqIncOS.value != "" && confirm(i18n_message("citcorpore.comum.deleta"))) {
		document.formCadastroServico.fireDelete("excluir");
	}
}

function voltarParaListaServicos() {
	if(Modal.isOpen('modal-portfolio-servico-requisicao-incidente')){
		Modal.close('modal-portfolio-servico-requisicao-incidente');
	}
}

function gravarCadastroServico(){
	if ($("[name='formCadastroServico'] #dispPortal").attr("value") == 'S') {
		if ($("[name='formCadastroServico'] #nomePortal").attr("value") == "") {
			notificacaoErro("", i18n_message("citcorpore.comum.campo_obrigatorio") + ": " + i18n_message("citcorpore.comum.nome"));
			return false;
		}
		
		if ($("[name='formCadastroServico'] #imagemPortal").attr("value") == "") {
			notificacaoErro("", i18n_message("citcorpore.comum.campo_obrigatorio") + ": " + i18n_message("citcorpore.comum.imagem"));
			return false;
		}
	}
	
	document.formCadastroServico.idServicoRelacionadoReqIncOS.value = getServicoRelacionado();
	document.formCadastroServico.idPortfolioServicoReqIncOS.value = document.form.idPortfolioServicoAtual.value;
	document.formCadastroServico.save();
}

function restoreCadastroServico(id){
	JANELA_AGUARDE_MENU.show();
	
	limparCadastroServico();
	document.formCadastroServico.fireEvent("definirDadosFixosServico");
	
	var idStr = id.toString();
	
	document.formCadastroServico.restore({
		idServico : idStr
	});
}

function editarServicoNegocioRequisicao(obj, idServicoRequisicao) {
	abrirPopupNovoServicoRequisicao();
	document.formCadastroServico.idServicoReqIncOS.value = idServicoRequisicao;
	document.formCadastroServico.fireEvent("definirDadosFixosServicoAndRestore");
}

function editarServicoNegocioIncidente(obj, idServicoRequisicao) {
	abrirPopupNovoServicoIncidente();
	document.formCadastroServico.idServicoReqIncOS.value = idServicoRequisicao;
	document.formCadastroServico.fireEvent("definirDadosFixosServicoAndRestore");
}

function editarServicoProcedimento(obj, idServicoRequisicao) {
	abrirPopupNovoServicoProcedimento();
	document.formCadastroServico.idServicoReqIncOS.value = idServicoRequisicao;
	document.formCadastroServico.fireEvent("definirDadosFixosServicoAndRestore");
}
/** Novo Serviço Requisição Negócio */
function clickNovoServicoRequisicao(){
	abrirPopupNovoServicoRequisicao();
	document.formCadastroServico.fireEvent("definirDadosFixosServico");
}

function abrirPopupNovoServicoRequisicao() {
	JANELA_AGUARDE_MENU.show();
	limparCadastroServico(_TIPO_SERVICO_REQUISICAO);

	$("#modal-portfolio-servico-requisicao-incidente .modal-header h3.title").text(i18n_message("gerenciaportfolio.cadastroServicoRequisicao"));
	Modal.oneHidden('modal-portfolio-servico-requisicao-incidente', beforeCloseNovoServicoRequisicao);
	Modal.open('modal-portfolio-servico-requisicao-incidente');
}

/** Vincular Serviço Requisição Negocio */
function clickVincularServicoRequisicaoNegocio(){
	document.formPesquisaServicoRequisicaoNegocio.whereDinamico = "sar.idservicorelacionado = " + getServicoRelacionado() + "AND s.idportfolioservico = " + getPortfolioServico();
	Modal.open('modal-portfolio-requisicao-servico-relacionado-negocio');
	Modal.oneHidden('modal-portfolio-requisicao-servico-relacionado-negocio', beforeCloseVincularServicoNegocioRequisicao);
}

function LOOKUP_SERVICOS_REQUISICOES_RELACIONADO_NEGOCIO_select(id, desc) {
	document.formCadastroServico.idServicoReqIncOS.value = id;
	document.formCadastroServico.idServicoRelacionado.value = getServicoRelacionado();

	document.formCadastroServico.fireEvent("recuperaServicoRelacionadoDeletado");
	Modal.close('modal-portfolio-requisicao-servico-relacionado-negocio');
}

function beforeCloseVincularServicoNegocioRequisicao(){
	limpar_LOOKUP_SERVICOS_REQUISICOES_RELACIONADO_NEGOCIO();
	
	$('#divDinamicoListaServicosRequisicaoNegocio').hide("blind", "fast",	function(){
		JANELA_AGUARDE_MENU.show();
		document.formCadastroServico.fireEvent("carregaTabelaServicosRequisicaoNegocio");
	});
}

/** Novo Serviço Incidente Negócio */
function clickNovoServicoIncidente(){
	abrirPopupNovoServicoIncidente();
	document.formCadastroServico.fireEvent("definirDadosFixosServico");
}

function abrirPopupNovoServicoIncidente() {
	JANELA_AGUARDE_MENU.show();
	limparCadastroServico(_TIPO_SERVICO_INCIDENTE);

	$("#modal-portfolio-servico-requisicao-incidente .modal-header h3.title").text(i18n_message("gerenciaportfolio.cadastroServicoIncidente"));
	Modal.oneHidden('modal-portfolio-servico-requisicao-incidente', beforeCloseNovoServicoIncidente);
	Modal.open('modal-portfolio-servico-requisicao-incidente');
}

/** Vincular Serviço Incidente Negócio */
function clickVincularServicoIncidenteNegocio(){
	document.formPesquisaServicoIncidenteNegocio.whereDinamico = "sar.idservicorelacionado = " + getServicoRelacionado() + "AND s.idportfolioservico = " + getPortfolioServico();
	
	Modal.open('modal-portfolio-incidente-relacionado-negocio');
	Modal.oneHidden('modal-portfolio-incidente-relacionado-negocio', beforeCloseVincularServicoNegocioIncidente);
}

function LOOKUP_SERVICOS_INCIDENTES_RELACIONADO_NEGOCIO_select(id, desc) {
	document.formCadastroServico.idServicoReqIncOS.value = id;
	document.formCadastroServico.idServicoRelacionado.value = getServicoRelacionado();

	document.formCadastroServico.fireEvent("recuperaServicoRelacionadoDeletado");
	Modal.close('modal-portfolio-incidente-relacionado-negocio');
}

function beforeCloseVincularServicoNegocioIncidente(){
	limpar_LOOKUP_SERVICOS_INCIDENTES_RELACIONADO_NEGOCIO();
	
	$('#divDinamicoListaServicosIncidenteNegocio').hide("blind", "fast",	function(){
		JANELA_AGUARDE_MENU.show();
		document.formCadastroServico.fireEvent("carregaTabelaServicosIncidenteNegocio");
	});
}

/** Novo Serviço Procedimento Negócio */
function clickNovoServicoProcedimento(){
	abrirPopupNovoServicoProcedimento();
	document.formCadastroServico.fireEvent("definirDadosFixosServico");
}

function abrirPopupNovoServicoProcedimento() {
	JANELA_AGUARDE_MENU.show();
	limparCadastroServico(_TIPO_SERVICO_PROCEDIMENTO);

	$("#modal-portfolio-servico-requisicao-incidente .modal-header h3.title").text(i18n_message("gerenciaportfolio.cadastroServicoProcedimento"));
	Modal.oneHidden('modal-portfolio-servico-requisicao-incidente', beforeCloseNovoServicoProcedimento);
	Modal.open('modal-portfolio-servico-requisicao-incidente');
}

/** Vincular Serviço Procedimento Negócio */
function clickVincularServicoProcedimentoNegocio(){
	document.formPesquisaServicoProcedimentoNegocio.whereDinamico = "sar.idservicorelacionado = " + getServicoRelacionado() + "AND s.idportfolioservico = " + getPortfolioServico();
	Modal.open('modal-portfolio-procedimento-relacionado-negocio');
	Modal.oneHidden('modal-portfolio-procedimento-relacionado-negocio', beforeCloseVincularServicoProcedimentoNegocio);
}

function LOOKUP_SERVICOS_PROCEDIMENTOS_RELACIONADO_NEGOCIO_select(id, desc) {
	document.formCadastroServico.idServicoReqIncOS.value = id;
	document.formCadastroServico.idServicoRelacionado.value = getServicoRelacionado();
	
	document.formCadastroServico.fireEvent("recuperaServicoRelacionadoDeletado");
	Modal.close('modal-portfolio-procedimento-relacionado-negocio');
}

function beforeCloseVincularServicoProcedimentoNegocio(){
	limpar_LOOKUP_SERVICOS_PROCEDIMENTOS_RELACIONADO_NEGOCIO();

	$('#divDinamicoListaServicosProcedimentoNegocio').hide("blind", "fast",	function(){
		JANELA_AGUARDE_MENU.show();
		document.formCadastroServico.fireEvent("carregaTabelaServicosProcedimento");
	});
}

function depoisDefinirDadosFixosServico(){

	$('#idTipoDemandaServicoReqIncOS').attr("readonly", "");
	$('#idTipoDemandaServicoReqIncOS > option').attr("disabled", "");
	
	if (document.formCadastroServico.tipoServicoReqIncOS.value == _TIPO_SERVICO_INCIDENTE) {
		$("#divIncidenteCritico").show();
	} else {
		$("#divIncidenteCritico").hide();
	}
	
	JANELA_AGUARDE_MENU.hide();
}

function beforeCloseNovoServicoRequisicao(){
	limparCadastroServico(_TIPO_SERVICO_REQUISICAO);
	
	if (getTipoTela() == 'servicoNegocio') {
		$('#divDinamicoListaServicosRequisicaoNegocio').hide("blind", "fast",	function(){
			JANELA_AGUARDE_MENU.show();
			document.formCadastroServico.fireEvent("carregaTabelaServicosRequisicaoNegocio");
		});
	} else {
		$('#divDinamicoListaServicosRequisicaoApoio').hide("blind", "fast",	function(){
			JANELA_AGUARDE_MENU.show();
			document.formCadastroServico.fireEvent("carregaTabelaServicosRequisicaoApoio");
		});
	}
}

function beforeCloseNovoServicoIncidente(){
	limparCadastroServico(_TIPO_SERVICO_INCIDENTE);
	
	if (getTipoTela() == 'servicoNegocio') {
		$('#divDinamicoListaServicosIncidenteNegocio').hide("blind", "fast",	function(){
			JANELA_AGUARDE_MENU.show();
			document.formCadastroServico.fireEvent("carregaTabelaServicosIncidenteNegocio");
		});
	} else {
		$('#divDinamicoListaServicosIncidenteApoio').hide("blind", "fast",	function(){
			JANELA_AGUARDE_MENU.show();
			document.formCadastroServico.fireEvent("carregaTabelaServicosIncidenteApoio");
		});
	}
}

function beforeCloseNovoServicoProcedimento(){
	limparCadastroServico(_TIPO_SERVICO_PROCEDIMENTO);
	
	if (getTipoTela() == 'servicoNegocio') {
		$('#divDinamicoListaServicosProcedimentoNegocio').hide("blind", "fast",	function(){
			JANELA_AGUARDE_MENU.show();
			document.formCadastroServico.fireEvent("carregaTabelaServicosProcedimento");
		});
	}
}

function depoisCarregarServicosRequisicaoNegocio(){
	JANELA_AGUARDE_MENU.hide();
	$('#divDinamicoListaServicosRequisicaoNegocio').show("blind", "fast",	function(){});
}

function depoisCarregarServicosIncidenteNegocio(){
	JANELA_AGUARDE_MENU.hide();
	$('#divDinamicoListaServicosIncidenteNegocio').show("blind", "fast",	function(){});
}

function depoisCarregarServicosRequisicaoApoio(){
	JANELA_AGUARDE_MENU.hide();
	$('#divDinamicoListaServicosRequisicaoApoio').show("blind", "fast",	function(){});
}

function depoisCarregarServicosIncidenteApoio(){
	JANELA_AGUARDE_MENU.hide();
	$('#divDinamicoListaServicosIncidenteApoio').show("blind", "fast",	function(){});
}

function depoisCarregarServicosProcedimento(){
	JANELA_AGUARDE_MENU.hide();
	$('#divDinamicoListaServicosProcedimentoNegocio').show("blind", "fast",	function(){});
}

/** Vincular Serviço Requisição associado ao serviço de apoio */
function clickVincularServicoRequisicaoApoio(){
	document.formPesquisaServicoApoioRequisicao.whereDinamico = "sar.idservicorelacionado = " + getServicoRelacionado() + "AND s.idportfolioservico = " + getPortfolioServico();
	Modal.open('modal-portfolio-requisicao-relacionado-apoio');
	Modal.oneHidden('modal-portfolio-requisicao-relacionado-apoio', beforeCloseVincularServicoApoioRequisicao);
}

function LOOKUP_SERVICOS_REQUISICOES_RELACIONADO_APOIO_select(id, desc) {
	document.formCadastroServico.idServicoReqIncOS.value = id;
	document.formCadastroServico.idServicoRelacionado.value = getServicoRelacionado();

	document.formCadastroServico.fireEvent("recuperaServicoRelacionadoDeletado");
	Modal.close('modal-portfolio-requisicao-relacionado-apoio');
}

function beforeCloseVincularServicoApoioRequisicao(){
	limpar_LOOKUP_SERVICOS_REQUISICOES_RELACIONADO_APOIO();
	
	$('#divDinamicoListaServicosRequisicaoApoio').hide("blind", "fast",	function(){
		JANELA_AGUARDE_MENU.show();
		document.formCadastroServico.fireEvent("carregaTabelaServicosRequisicaoApoio");
	});
}

/** Vincular Serviço Incidente associado ao serviço de apoio */
function clickVincularServicoIncidenteApoio(){
	document.formPesquisaServicoApoioIncidente.whereDinamico = "sar.idservicorelacionado = " + getServicoRelacionado() + "AND s.idportfolioservico = " + getPortfolioServico();
	
	Modal.open('modal-portfolio-incidente-relacionado-apoio');
	Modal.oneHidden('modal-portfolio-incidente-relacionado-apoio', beforeCloseVincularServicoApoioIncidente);
}

function LOOKUP_SERVICOS_INCIDENTES_RELACIONADO_APOIO_select(id, desc) {
	document.formCadastroServico.idServicoReqIncOS.value = id;
	document.formCadastroServico.idServicoRelacionado.value = getServicoRelacionado();

	document.formCadastroServico.fireEvent("recuperaServicoRelacionadoDeletado");
	Modal.close('modal-portfolio-incidente-relacionado-apoio');
}

function beforeCloseVincularServicoApoioIncidente(){
	limpar_LOOKUP_SERVICOS_INCIDENTES_RELACIONADO_APOIO();
	
	$('#divDinamicoListaServicosIncidenteApoio').hide("blind", "fast",	function(){
		JANELA_AGUARDE_MENU.show();
		document.formCadastroServico.fireEvent("carregaTabelaServicosIncidenteApoio");
	});
}


var valoresAntesLimparFormCadServico = function(tipoServico){ 
	/*Limpará todos os campos, exceto estes que não existirá campo específico: */
	var idPortfolio = document.formCadastroServico.idPortfolioServicoReqIncOS.value;
	var tipoServico = tipoServico;
	var idServicoRelacionado = document.formCadastroServico.idServicoRelacionadoReqIncOS.value;
	var paginaSelecionadaServico = document.formCadastroServico.paginaSelecionadaServicoReqIncOS.value;
	var filtroServico = document.formCadastroServico.filtroServicoReqIncOS.value;
	return {
		idPortfolio: idPortfolio,
		tipoServico: tipoServico,
		idServicoRelacionado: idServicoRelacionado,
		paginaSelecionadaServico: paginaSelecionadaServico,
		filtroServico: filtroServico
	};
};

function depoisLimparFormCadServico(valoresAntes){
	document.formCadastroServico.idPortfolioServicoReqIncOS.value = valoresAntes.idPortfolio;
	document.formCadastroServico.tipoServicoReqIncOS.value = valoresAntes.tipoServico;
	document.formCadastroServico.idServicoRelacionadoReqIncOS.value = valoresAntes.idServicoRelacionado;
	document.formCadastroServico.paginaSelecionadaServicoReqIncOS.value = valoresAntes.paginaSelecionadaServico;
	document.formCadastroServico.filtroServicoReqIncOS.value = valoresAntes.filtroServico;
}

function vincularServicoRequisicaoNegocio(){
	Modal.open('modal-portfolio-vincular-requisicao-negocio');
	Modal.oneHidden('modal-portfolio-vincular-requisicao-negocio', beforeCloseVincularServicoRequisicaoNegocio);
}

function depoisVincularServicoRequisicaoNegocio() {
	Modal.close('modal-portfolio-vincular-requisicao-negocio');
}

function beforeCloseVincularServicoRequisicaoNegocio() {
	limpar_LOOKUP_SERVICO_VINCULAR_REQUISICAO_NEGOCIO();
}

function vincularServicoIncidenteNegocio(){
	Modal.open('modal-portfolio-vincular-incidente-negocio');
	Modal.oneHidden('modal-portfolio-vincular-incidente-negocio', beforeCloseVincularServicoIncidenteNegocio);
}

function depoisVincularServicoIncidenteNegocio() {
	Modal.close('modal-portfolio-vincular-incidente-negocio');
}

function beforeCloseVincularServicoIncidenteNegocio() {
	limpar_LOOKUP_SERVICO_VINCULAR_INCIDENTE_NEGOCIO();
}

function vincularServicoRequisicaoApoio(){
	Modal.open('modal-portfolio-vincular-requisicao-apoio');
	Modal.oneHidden('modal-portfolio-vincular-requisicao-apoio', beforeCloseVincularServicoRequisicaoApoio);
}

function depoisVincularServicoRequisicaoApoio() {
	Modal.close('modal-portfolio-vincular-requisicao-apoio');
}

function beforeCloseVincularServicoRequisicaoApoio() {
	limpar_LOOKUP_SERVICO_VINCULAR_REQUISICAO_APOIO();
}

function vincularServicoIncidenteApoio(){
	Modal.open('modal-portfolio-vincular-incidente-apoio');
	Modal.oneHidden('modal-portfolio-vincular-incidente-apoio', beforeCloseVincularServicoIncidenteApoio);
}

function depoisVincularServicoIncidenteApoio() {
	Modal.close('modal-portfolio-vincular-incidente-apoio');
}

function beforeCloseVincularServicoIncidenteApoio() {
	limpar_LOOKUP_SERVICO_VINCULAR_INCIDENTE_APOIO();
}

function clickCategoria() {
	Modal.open('modal-selecionar-servico-categoria');
	limpar_LOOKUP_CATEGORIASERVICO();
	$("a[href=#tabPesquisaCategoria]").trigger('click');
	if (isServicoRequisicao() || isServicoIncidente()) {
		document.formCategoriaServico.fireEvent("setaCategoriaIncidenteRequisicao");
		document.formPesquisaCategoriaServico.pesqLockupLOOKUP_CATEGORIASERVICO_TIPOCATEGORIA.value = "'"+_TIPO_CATEGORIA_INCIDENTE_REQUISICAO+"'";
		$("#modal-selecionar-servico-categoria").data("tipo", "");
	} else if (isServicoProcedimento()) {
		document.formCategoriaServico.fireEvent("setaCategoriaProcedimento");
		document.formPesquisaCategoriaServico.pesqLockupLOOKUP_CATEGORIASERVICO_TIPOCATEGORIA.value = "'"+_TIPO_CATEGORIA_PROCEDIMENTO+"'";
		$("#modal-selecionar-servico-categoria").data("tipo", "");
	}

}

function selectCategoriaRequisicaoIncidente(id, desc) {
	document.formCadastroServico.idCategoriaServicoReqIncOS.value = id;
	document.formCadastroServico.nomeCategoriaServicoReqIncOS.value = desc;
	Modal.close('modal-selecionar-servico-categoria');
}

function isServicoRequisicao() {
	return document.formCadastroServico.tipoServicoReqIncOS.value == _TIPO_SERVICO_REQUISICAO;
}

function isServicoIncidente() {
	return document.formCadastroServico.tipoServicoReqIncOS.value == _TIPO_SERVICO_INCIDENTE;
}

function isServicoProcedimento() {
	return document.formCadastroServico.tipoServicoReqIncOS.value == _TIPO_SERVICO_PROCEDIMENTO;
}

function clickBaseConhecimento(){
	if ((document.formCadastroServico.tituloBaseConhecimentoReqIncOS.value != "") && (document.formCadastroServico.idBaseConhecimentoReqIncOS.value != "")) {
		if(confirm(i18n_message("gerenciaportfolio.script.alterar"))) {
			chamarPopupScriptOrientacaoBaseConhecimento();
		}
	} else {
		chamarPopupScriptOrientacaoBaseConhecimento();
	}
}

function chamarPopupScriptOrientacaoBaseConhecimento() {
	Modal.open('modal-portfolio-base-conhecimento');
}

function LOOKUP_BASECONHECIMENTO_select(id, desc) {
	document.formCadastroServico.idBaseConhecimentoReqIncOS.value = id;
	document.formCadastroServico.tituloBaseConhecimentoReqIncOS.value = desc;
	limpar_LOOKUP_BASECONHECIMENTO();
	Modal.close('modal-portfolio-base-conhecimento');
}

function limpaFiltroServicoRequisicaoNegocio() {
	$("#inputFiltroServicoRequisicaoNegocio").val("");
	changeFiltroServicoRequisicaoNegocio("");
}

function limpaFiltroServicoIncidenteNegocio() {
	$("#inputFiltroServicoIncidenteNegocio").val("");
	changeFiltroServicoIncidenteNegocio("");
}

function limpaFiltroServicoProcedimento() {
	$("#inputFiltroServicoProcedimento").val("");
	changeFiltroServicoRequisicaoNegocio("");
}

function limpaFiltroServicoRequisicaoApoio() {
	$("#inputFiltroServicoRequisicaoApoio").val("");
	changeFiltroServicoRequisicaoApoio("");
}

function limpaFiltroServicoIncidenteApoio() {
	$("#inputFiltroServicoIncidenteApoio").val("");
	changeFiltroServicoIncidenteApoio("");
}

function pesquisarFiltroServicoRequisicaoNegocio() {
	changeFiltroServicoRequisicaoNegocio($("#inputFiltroServicoRequisicaoNegocio").val());
}

function pesquisaFiltroServicoIncidenteNegocio() {
	changeFiltroServicoIncidenteNegocio($("#inputFiltroServicoIncidenteNegocio").val());
}

function pesquisaFiltroServicoProcedimento() {
	changeFiltroServicoProcedimento($("#inputFiltroServicoProcedimento").val());
}

function changeFiltroServicoRequisicaoNegocio(filtroServicoRequisicao) {
	document.formCadastroServico.paginaSelecionadaServicoReqIncOS.value = 0;
	document.formCadastroServico.filtroServicoReqIncOS.value = filtroServicoRequisicao;
	document.formCadastroServico.fireEvent("carregaTabelaServicosRequisicaoNegocio");
}

function changeFiltroServicoIncidenteNegocio(filtroServicoIncidente) {
	document.formCadastroServico.paginaSelecionadaServicoReqIncOS.value = 0;
	document.formCadastroServico.filtroServicoReqIncOS.value = filtroServicoIncidente;
	document.formCadastroServico.fireEvent("carregaTabelaServicosIncidenteNegocio");
}

function changeFiltroServicoProcedimento(filtroServicoProcedimento) {
	document.formCadastroServico.paginaSelecionadaServicoReqIncOS.value = 0;
	document.formCadastroServico.filtroServicoReqIncOS.value = filtroServicoProcedimento;
	document.formCadastroServico.fireEvent("carregaTabelaServicosProcedimento");
}

function changeFiltroServicoRequisicaoApoio(filtroServicoRequisicao) {
	document.formCadastroServico.paginaSelecionadaServicoReqIncOS.value = 0;
	document.formCadastroServico.filtroServicoReqIncOS.value = filtroServicoRequisicao;
	document.formCadastroServico.fireEvent("carregaTabelaServicosRequisicaoApoio");
}

function changeFiltroServicoIncidenteApoio(filtroServicoIncidente) {
	document.formCadastroServico.paginaSelecionadaServicoReqIncOS.value = 0;
	document.formCadastroServico.filtroServicoReqIncOS.value = filtroServicoIncidente;
	document.formCadastroServico.fireEvent("carregaTabelaServicosIncidenteApoio");
}

function pesquisaFiltroServicoRequisicaoApoio() {
	changeFiltroServicoRequisicaoApoio($("#inputFiltroServicoRequisicaoApoio").val());
}

function pesquisaFiltroServicoIncidenteApoio() {
	changeFiltroServicoIncidenteApoio($("#inputFiltroServicoIncidenteApoio").val());
}

function paginarServicosRequisicaoNegocio(paginaSelecionadaRequisicao) {
	$('#divDinamicoListaServicosRequisicaoNegocio').hide("blind", "fast",	function(){
		JANELA_AGUARDE_MENU.show();
		document.formCadastroServico.paginaSelecionadaServicoReqIncOS.value = paginaSelecionadaRequisicao;
		document.formCadastroServico.fireEvent("carregaTabelaServicosRequisicaoNegocio");
	});
}

function paginarServicosIncidenteNegocio(paginaSelecionadaIncidente) {
	$('#divDinamicoListaServicosIncidenteNegocio').hide("blind", "fast",	function(){
		JANELA_AGUARDE_MENU.show();
		document.formCadastroServico.paginaSelecionadaServicoReqIncOS.value = paginaSelecionadaIncidente;
		document.formCadastroServico.fireEvent("carregaTabelaServicosIncidenteNegocio");
	});
}

function paginarServicosProcedimentoNegocio(paginaSelecionadaProcedimento) {
	$('#divDinamicoListaServicosProcedimentoNegocio').hide("blind", "fast",	function(){
		JANELA_AGUARDE_MENU.show();
		document.formCadastroServico.paginaSelecionadaServicoReqIncOS.value = paginaSelecionadaProcedimento;
		document.formCadastroServico.fireEvent("carregaTabelaServicosProcedimento");
	});
}

function paginarServicosRequisicaoApoio(paginaSelecionadaRequisicao) {
	$('#divDinamicoListaServicosRequisicaoApoio').hide("blind", "fast",	function(){
		JANELA_AGUARDE_MENU.show();
		document.formCadastroServico.paginaSelecionadaServicoReqIncOS.value = paginaSelecionadaRequisicao;
		document.formCadastroServico.fireEvent("carregaTabelaServicosRequisicaoApoio");
	});
}

function paginarServicosIncidenteApoio(paginaSelecionadaIncidente) {
	$('#divDinamicoListaServicosIncidenteApoio').hide("blind", "fast",	function(){
		JANELA_AGUARDE_MENU.show();
		document.formCadastroServico.paginaSelecionadaServicoReqIncOS.value = paginaSelecionadaIncidente;
		document.formCadastroServico.fireEvent("carregaTabelaServicosIncidenteApoio");
	});
}

function desvincularServicoRequisicao(obj, idServicoRequisicao) {
	if (idServicoRequisicao > "" && confirm(i18n_message("gerenciaportfolio.desejaDesvincularServico"))) {
		document.formCadastroServico.idServicoReqIncOS.value = idServicoRequisicao;
		document.formCadastroServico.idServicoRelacionadoReqIncOS.value = getServicoRelacionado();
		document.formCadastroServico.idPortfolioServicoReqIncOS.value = getPortfolioServico();
		document.formCadastroServico.tipoServicoReqIncOS.value = _TIPO_SERVICO_REQUISICAO;
		document.formCadastroServico.tipoServicoRelacionado.value = getTipoServicoRelacionado();
		document.formCadastroServico.fireUpdate("desvincularServicoNegocioRequisicaoIncidente");
	}
}

function desvincularServicoIncidente(obj, idServicoIncidente) {
	if (idServicoIncidente > "" && confirm(i18n_message("gerenciaportfolio.desejaDesvincularServico"))) {
		document.formCadastroServico.idServicoReqIncOS.value = idServicoIncidente;
		document.formCadastroServico.idServicoRelacionadoReqIncOS.value = getServicoRelacionado();
		document.formCadastroServico.idPortfolioServicoReqIncOS.value = getPortfolioServico();
		document.formCadastroServico.tipoServicoReqIncOS.value = _TIPO_SERVICO_INCIDENTE;
		document.formCadastroServico.tipoServicoRelacionado.value = getTipoServicoRelacionado();
		document.formCadastroServico.fireUpdate("desvincularServicoNegocioRequisicaoIncidente");
	}
}

function desvincularServicoProcedimento(obj, idServicoProcedimento) {
	if (idServicoProcedimento > "" && confirm(i18n_message("gerenciaportfolio.desejaDesvincularServico"))) {
		document.formCadastroServico.idServicoReqIncOS.value = idServicoProcedimento;
		document.formCadastroServico.idServicoRelacionadoReqIncOS.value = getServicoRelacionado();
		document.formCadastroServico.idPortfolioServicoReqIncOS.value = getPortfolioServico();
		document.formCadastroServico.tipoServicoReqIncOS.value = _TIPO_SERVICO_PROCEDIMENTO;
		document.formCadastroServico.tipoServicoRelacionado.value = getTipoServicoRelacionado();
		document.formCadastroServico.fireUpdate("desvincularServicoNegocioRequisicaoIncidente");
	}
}

function definirValoresPadraoForm() {
	document.formCadastroServico.idServicoRelacionadoReqIncOS.value = getServicoRelacionado();
	document.formCadastroServico.idPortfolioServicoReqIncOS.value = getPortfolioServico();
}

function limparCampoScriptOrientacao() {
	if (document.formCadastroServico.tituloBaseConhecimentoReqIncOS.value != "" && document.formCadastroServico.idBaseConhecimentoReqIncOS.value != "") {
		if(confirm(i18n_message("gerenciaportfolio.script.limpar"))) {
			limparCampoScriptOrientacaoBaseConhecimento();
		}
	} else {
		limparCampoScriptOrientacaoBaseConhecimento();
	}
}

function limparCampoScriptOrientacaoBaseConhecimento() {
	document.getElementById("tituloBaseConhecimentoReqIncOS").value = "";
	document.getElementById("idBaseConhecimentoReqIncOS").value = "";
}

function inicializarCadastroServicoRequisicaoNegocio() {
	if(document.formCadastroServico) {
		inicializarCadastroServico(_TIPO_SERVICO_NEGOCIO, _TIPO_SERVICO_REQUISICAO);
		changeFiltroServicoRequisicaoNegocio('');
	}
}

function inicializarCadastroServicoIncidenteNegocio() {
	if(document.formCadastroServico) {
		inicializarCadastroServico(_TIPO_SERVICO_NEGOCIO, _TIPO_SERVICO_INCIDENTE);
		changeFiltroServicoIncidenteNegocio('');
	}
}

function inicializarCadastroServicoProcedimentoNegocio() {
	if(document.formCadastroServico) {
		inicializarCadastroServico(_TIPO_SERVICO_NEGOCIO, _TIPO_SERVICO_PROCEDIMENTO);
		changeFiltroServicoProcedimento('');
	}
}

function inicializarCadastroServicoRequisicaoApoio() {
	if(document.formCadastroServico) {
		inicializarCadastroServico(_TIPO_SERVICO_APOIO, _TIPO_SERVICO_REQUISICAO);
		changeFiltroServicoRequisicaoApoio('');
	}
}

function inicializarCadastroServicoIncidenteApoio() {
	if(document.formCadastroServico) {
		inicializarCadastroServico(_TIPO_SERVICO_APOIO, _TIPO_SERVICO_INCIDENTE);
		changeFiltroServicoIncidenteApoio('');
	}
}

function inicializarCadastroServicoRequisicaoContrato() {
	if(document.formCadastroServico) {
		inicializarCadastroServico(getTipoServicoRelacionado(), _TIPO_SERVICO_REQUISICAO);
		changeFiltroServicoRequisicaoContrato('');
	}
}

function inicializarCadastroServicoIncidenteContrato() {
	if(document.formCadastroServico) {
		inicializarCadastroServico(getTipoServicoRelacionado(), _TIPO_SERVICO_INCIDENTE);
		changeFiltroServicoIncidenteContrato('');
	}
}

function inicializarCadastroServicoProcedimentoContrato() {
	if(document.formCadastroServico) {
		inicializarCadastroServico(getTipoServicoRelacionado(), _TIPO_SERVICO_PROCEDIMENTO);
		changeFiltroServicoProcedimentoContrato('');
	}
}

function inicializarCadastroServico(tipoServicoRelacionado, tipoServico) {
	definirValoresPadraoForm()
	document.formCadastroServico.tipoServicoRelacionado.value = tipoServicoRelacionado;
	document.formCadastroServico.tipoServico.value = tipoServico;
}