_TECLA_ENTER = 13;
_SIM = 'S';
_NAO = 'N';

//br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes
_OCORRENCIA_SERVICO_ACAO_VINCULAR = "V";

$(function() {
	$(".inputFiltroServicoApoio").keyup(function(event) {
		if (event.which == _TECLA_ENTER) {
			changeFiltroServicoApoio($(event.currentTarget).val());
		}
	});

	if(document.formInfoServicoApoio) {
		carregarListaServicosApoio(document.formInfoServicoApoio);
	} else if(document.formCadastroServicoApoio) {
		document.formCadastroServicoApoio.afterRestore = function() {
			afterRestoreCadastroServicoApoio();
		}
		
		document.formCadastroServicoApoio.afterSave = function() {
			afterSaveServicoApoio(this);
		}
	}
	
});

function carregarListaServicosApoio(form) {
	form.tipoTela.value = getTipoTela();
	form.idServicoRelacionado.value = getServicoRelacionado();
	form.idPortfolioServico.value = document.form.idPortfolioServicoAtual.value;
	form.fireEvent("load");
}

function changeFaseServicoApoio(fase) {
	document.formCadastroServicoApoio.fireEvent('carregaComboStatusServico');
}

function clickNovoServicoApoio(fnAfterLoad) {
	removeFormCadastroServicoApoio();
	loadJspNovoServicoApoio(getFnAfterLoadJspNovoServicoApoio);
}

function getFnAfterLoadJspNovoServicoApoio() {
	document.formCadastroServicoApoio.tipoTela.value = getTipoTela();
	document.formCadastroServicoApoio.fireEvent("load");
	reloadFormCadastroServicoApoio(false);
	Modal.open('modal-portfolio-servico-apoio');
	Modal.oneHidden('modal-portfolio-servico-apoio', beforeCloseNovoServicoApoio);
	$("form[name='formCadastroServicoApoio']").data('popup', _SIM);
}

function loadJspNovoServicoApoio(fnAfterLoad) {
	var j = {};
	j.idDiv = "#divPopupCadastroServicoApoio";
	j.urlJsp = _SRC_PORTFOLIO + "gerenciamentoPortfolioCadastroServicoApoio/gerenciamentoPortfolioCadastroServicoApoio.jsp";
	j.functionAfterLoad = function() {
		fnAfterLoad();
	};
	loadJsp(j);
}

function beforeCloseNovoServicoApoio() {
	$("form[name='formCadastroServicoApoio']").data('popup', _NAO);
	reloadFormCadastroServicoApoio(true);
	$("#divPopupCadastroServicoApoio").html("");
	if(document.formInfoServicoApoio) {
		carregarListaServicosApoio(document.formInfoServicoApoio);
	}
}

function editarServicoApoio(obj, idServicoApoio) {
	loadJspNovoServicoApoio(function() {
		getFnAfterLoadJspNovoServicoApoio();
		
		var idStr = idServicoApoio.toString();
		document.formCadastroServicoApoio.restore({
			idServico : idStr,
			isEditar : 'S',
			tipoTela : getTipoTela()
		});
	});
	
}

function limpaFiltroServicoApoio() {
	$(".inputFiltroServicoApoio").val("");
	changeFiltroServicoApoio("");
}

function pesquisaFiltroServicoApoio(idInput) {
	changeFiltroServicoApoio($("#"+idInput).val());
}

function changeFiltroServicoApoio(filtroServicoApoio) {
	document.formInfoServicoApoio.tipoTela.value = getTipoTela();
	document.formInfoServicoApoio.paginaSelecionadaServicoApoio.value = 0;
	document.formInfoServicoApoio.filtroServicoApoio.value = filtroServicoApoio;
	document.formInfoServicoApoio.fireEvent("carregaTabelaServicosApoio");
}

function limparCadastroServicoApoio() {
	var idPortfolio = document.formCadastroServicoApoio.idPortfolioServicoApoio.value;
	var idServicoRelacionado = document.formCadastroServicoApoio.idServicoRelacionado.value;

	document.formCadastroServicoApoio.clear();

	document.formCadastroServicoApoio.idPortfolioServico.value = idPortfolio;
	document.formCadastroServicoApoio.idServicoRelacionado.value = idServicoRelacionado;
}

function gravarCadastroServicoApoio() {
	document.formCadastroServicoApoio.tipoTela.value = getTipoTela();
	document.formCadastroServicoApoio.idServicoRelacionado.value = getServicoRelacionado();
	document.formCadastroServicoApoio.save();
}

function loadAndRestoreCadastroServicoApoio(idServico) {
	document.formCadastroServicoApoio.tipoTela.value = getTipoTela();
	document.formCadastroServicoApoio.idServico.value = idServico;
	document.formCadastroServicoApoio.idServicoRelacionado.value = getServicoRelacionado();
	document.formCadastroServicoApoio.idPortfolioServico.value = document.form.idPortfolioServicoAtual.value;
	
	document.formCadastroServicoApoio.fireEvent("loadAndRestore");
}

function restoreCadastroServicoApoio(id) {
	JANELA_AGUARDE_MENU.show();
	
	limparCadastroServicoApoio();

	var idStr = id.toString();

	var idServicoRelacionadoStr;
	if (document.formCadastroServicoApoio.idServicoRelacionado.value) {
		idServicoRelacionadoStr = document.formCadastroServicoApoio.idServicoRelacionado.value
				.toString();
	} else {
		idServicoRelacionadoStr = idStr;
	}

	document.formCadastroServicoApoio.restore({
		idServico : idStr,
		idServicoRelacionado : idServicoRelacionadoStr,
		idPortfolioServico : getPortfolioServico()
	});
}

function excluirCadastroServicoApoio() {
	if (document.formCadastroServicoApoio.idServico.value != ""
			&& confirm(i18n_message("citcorpore.comum.deleta"))) {
		document.formCadastroServicoApoio.fireDelete("excluir");
	}
}

function clonarCadastroServicoApoio() {
	Modal.open('modal-portfolio-servico-apoio-clone');
}

function LOOKUP_SERVICOS_APOIO_CLONE_select(id, desc) {
	restoreCadastroServicoApoio(id);
}

function voltarParaListaServicoApoio() {
	if ($("form[name='formCadastroServicoApoio'").data('popup') == _SIM) {
		Modal.close('modal-portfolio-servico-apoio');
	}else{
		$(".breadCrumbServicoNegocio").trigger("click");
	}
	document.formCadastroServicoApoio.tipoTela.value = getTipoTela();
	document.formCadastroServicoApoio.fireEvent("carregaTabelaServicosApoio");
}

function LOOKUP_SERVICO_select(id, desc) {
	restoreCadastroServicoApoio(id);
}

function selectCategoriaApoio(id, desc) {
	document.formCadastroServicoApoio.idCategoriaServico.value = id;
	document.formCadastroServicoApoio.nomeCategoriaServico.value = desc;
	Modal.close('modal-selecionar-servico-categoria');
}

function clickCategoriaApoio() {
	limpar_LOOKUP_CATEGORIASERVICO();
	
	Modal.open('modal-selecionar-servico-categoria');
	$("#modal-selecionar-servico-categoria").data("tipo", "A");
	$("a[href=#tabPesquisaCategoria]").trigger('click');
	document.formCategoriaServico.fireEvent("setaCategoriaApoio");
	document.formPesquisaCategoriaServico.pesqLockupLOOKUP_CATEGORIASERVICO_TIPOCATEGORIA.value = "'A'";
}

function reloadFormCadastroServicoApoio(isRecarregarTabela) {
	// Força a arquitetura a recarregar os forms
	DEFINEALLPAGES_atribuiCaracteristicasCitAjax();

	document.formCadastroServicoApoio.afterRestore = function() {
		afterRestoreCadastroServicoApoio();
	}

	document.formCadastroServicoApoio.afterSave = function() {
		afterSaveServicoApoio(this);
	}

	document.formCadastroServicoApoio.clear();
	document.formCadastroServicoApoio.idPortfolioServico.value = getPortfolioServico();
	document.formCadastroServicoApoio.idServicoRelacionado.value = getServicoRelacionado();
	document.formCadastroServicoApoio.tipoServico.value = 'A';

	$('.datepicker').removeClass('hasDatepicker').datepicker();

	if (isRecarregarTabela) {
		document.formCadastroServicoApoio.tipoTela.value = getTipoTela();
		document.formCadastroServicoApoio.fireEvent("carregaTabelaServicosApoio");
	}
}

function afterRestoreCadastroServicoApoio() {
	if ($("form[name='formCadastroServicoApoio'").data('popup') == _NAO) {
		$('.tab-pane span[href="#detalhesServicoApoio"]').tab('show');

		$('#divServicoApoioInfo').show("slide", { direction: "right" }, "fast",	function(){});
		JANELA_AGUARDE_MENU.hide();
	}

	$("#faseServicoApoio").trigger('change');

	// No caso se for o restore de um clone
	if (Modal.isOpen('modal-portfolio-servico-apoio-clone')) {
		document.formCadastroServicoApoio.idServicoApoio.value = "";
		JANELA_AGUARDE_MENU.hide();
		Modal.close('modal-portfolio-servico-apoio-clone');
	}

}

function paginarServicosApoio(paginaSelecionadaApoio) {
	document.formCadastroServicoApoio.tipoTela.value = getTipoTela();
	document.formCadastroServicoApoio.paginaSelecionadaServicoApoio.value = paginaSelecionadaApoio;
	document.formCadastroServicoApoio.fireEvent("carregaTabelaServicosApoio");
}

function afterSaveServicoApoio(form) {
	document.formCadastroServicoApoio.tipoTela.value = getTipoTela();

	if ($(form).data('popup') == _SIM) {
		Modal.close('modal-portfolio-servico-apoio');
	}
}

function vincularServicoApoio() {
	limpar_LOOKUP_SERVICO_VINCULAR_APOIO();
	Modal.open('modal-portfolio-vincular-servico-apoio');
}

function beforeCloseVincularServicoNegocioApoio() {
	var elemento;
	if (getTipoTela() == 'servicoNegocio') {
		elemento = $('#divDinamicoListaServicosApoioNegocio');
	} else {
		elemento = $('#divDinamicoListaServicosApoioApoio');
	}
	elemento.hide("blind", "fast", function() {
		limpar_LOOKUP_SERVICO_VINCULAR_APOIO();
	});
}

function desvincularServicoApoio(obj, idServicoApoio) {
	if (idServicoApoio > ""
			&& confirm(i18n_message("gerenciaportfolio.desejaDesvincularServico"))) {
		document.formInfoServicoApoio.tipoTela.value = getTipoTela();
		document.formInfoServicoApoio.idServico.value = idServicoApoio;
		document.formInfoServicoApoio.idServicoRelacionado.value = getServicoRelacionado();
		document.formInfoServicoApoio.idPortfolioServico.value = getPortfolioServico();
		document.formInfoServicoApoio.fireEvent("desvincularServico");
	}
}

function depoisVincularServicos() {
	Modal.close('modal-portfolio-vincular-servico-apoio');
}

function salvarOcorrenciaServicoServicoApoio(idsServicoStr) {
	if (idsServicoStr) {
		document.formCadastroServicoApoio.idsServicoApoioOcorrenciaServico.value = idsServicoStr;
	}
	document.formCadastroServicoApoio.acaoServicoApoioOcorrenciaServico.value = _OCORRENCIA_SERVICO_ACAO_VINCULAR;
	document.formCadastroServicoApoio
			.fireInsert("salvarOcorrenciaServicoServicoApoio");
}

function removeFormCadastroServicoApoio() {
	var formularioCadastroServicoApoio = {};
	formularioCadastroServicoApoio.idDiv = ".formularioCadastroServicoApoio";
	formularioCadastroServicoApoio.urlJsp = "/pages/gerenciamentoPortfolio/gerenciamentoPortfolioCadastroServicoApoio/gerenciamentoPortfolioCadastroServicoApoio.jsp"; 
	formularioCadastroServicoApoio.urlJs = "/pages/gerenciamentoPortfolio/gerenciamentoPortfolioCadastroServicoApoio/js/gerenciamentoPortfolioCadastroServicoApoio.js";
	
	removeJsp(formularioCadastroServicoApoio);
	ControleAbas.setarDataLoaded("detalhesServicoApoio", "false");
}