_SIM = 'S';
_NAO = 'N';
_ANALISAR = 'AN';
_NEGOCIO = 'N';
_APROVAR = 'AP';
_TERMOABERTURA = 'C';

$(function() {
	document.formCadastroServicoNegocio.afterRestore = function() {
		afterRestoreCadastroServicoNegocio();
	}
	
	document.formCadastroServicoNegocio.afterSave = function() {
		afterSaveServicoNegocio(this);
	}
	
	$('#divInformacoesComplementares').html('<iframe id="fraInformacoesComplementares" name="fraInformacoesComplementares" src="about:blank" class="inativo iframeSemBorda" width="100%" height="100%" style="width: 99%; height: 100%; border: none; overflow: auto"></iframe>');
	$('.datepicker').removeClass('hasDatepicker').datepicker();
	$('#divClassificacaoServicoNegocioTxT').hide();
	
	inicializar();
	
});

function inicializar() {
	setarCampoObrigatorio("criticidadeServico", false);
	$(".classificacaoServicoNegocio").slideUp("fast", function(){
		setarCampoObrigatorio("tipoDeInvestimento", false);
		setarCampoObrigatorio("demandaServico", false);
		setarCampoObrigatorio("retornoFinanceiroServico", false);
	});
}

function changeFaseServico(fase) {
	document.formCadastroServicoNegocio.fireEvent('carregaComboStatusServico');
	
	if (fase == _ANALISAR) {
		$('#divClassificacaoServicoNegocioTxT').hide();
		$("#criticidadeServico").prop('disabled', false);
		setarCampoObrigatorio("criticidadeServico", true);
		
		$(".classificacaoServicoNegocio").slideDown("fast", function(){
			setarCampoObrigatorio("tipoDeInvestimento", true);
			setarCampoObrigatorio("demandaServico", true);
			setarCampoObrigatorio("retornoFinanceiroServico", true);
		});
	
	}else if(fase == _APROVAR || fase == _TERMOABERTURA){
		document.formCadastroServicoNegocio.fireEvent('montaHTMLClassificacaoServicoNegocioTxt');
		$(".classificacaoServicoNegocio").slideUp('fast', function(){
			$('#divClassificacaoServicoNegocioTxT').show();
			
			$("#criticidadeServico").prop('disabled', true);
			setarCampoObrigatorio("criticidadeServico", false);
			setarCampoObrigatorio("tipoDeInvestimento", false);
			setarCampoObrigatorio("demandaServico", false);
			setarCampoObrigatorio("retornoFinanceiroServico", false);
		});
		
	}else{
		$('#divClassificacaoServicoNegocioTxT').hide();
		$("#criticidadeServico").prop('disabled', true);
		document.getElementById("criticidadeServico").options[0].selected = true
		setarCampoObrigatorio("criticidadeServico", false);
		
		$(".classificacaoServicoNegocio").slideUp("fast", function(){
			setarCampoObrigatorio("tipoDeInvestimento", false);
			document.getElementById("tipoDeInvestimento").options[0].selected = true
			setarCampoObrigatorio("demandaServico", false);
			document.getElementById("demandaServico").options[0].selected = true
			setarCampoObrigatorio("retornoFinanceiroServico", false);
			document.getElementById("retornoFinanceiroServico").options[0].selected = true;
			
			$("#tipoDeInvestimentoTxt").text("");
			$("#demandaServicoTxt").text("");
			$("#retornoFinanceiroServicoTxt").text("");
		});
	}
}

function limparCadastroServicoNegocio(){
	var idPortfolio = document.formCadastroServicoNegocio.idPortfolioServico.value;
	document.formCadastroServicoNegocio.clear();
	document.formCadastroServicoNegocio.idPortfolioServico.value = idPortfolio;
}

function gravarCadastroServicoNegocio(){
	if ($("[name='formCadastroServicoNegocio'] #dispPortal").attr("value") == 'S') {
		if ($("[name='formCadastroServicoNegocio'] #nomePortal").attr("value") == "") {
			notificacaoErro("", i18n_message("citcorpore.comum.campo_obrigatorio") + ": " + i18n_message("citcorpore.comum.nome"));
			return false;
		}
		if ($("[name='formCadastroServicoNegocio'] #imagemPortal").attr("value") == "") {
			notificacaoErro("", i18n_message("citcorpore.comum.campo_obrigatorio") + ": " + i18n_message("citcorpore.comum.imagem"));
			return false;
		}
	}
	
	var informacoesComplementares_serialize = '';
	var link = $('#fraInformacoesComplementares').attr('src');
	try{
		informacoesComplementares_serialize = window.frames["fraInformacoesComplementares"].getObjetoSerializadoServico(document.formCadastroServicoNegocio.idServico.value);
	}catch(e){}
	if (document.formCadastroServicoNegocio.informacoesComplementares_serialize != undefined) {
		document.formCadastroServicoNegocio.informacoesComplementares_serialize.value = informacoesComplementares_serialize;
	}

	if (document.formCadastroServicoNegocio.save()) {
		parent.JANELA_AGUARDE_MENU.show();
	}
}

function restoreCadastroServicoNegocio(id){
	JANELA_AGUARDE_MENU.show();
	
	limparCadastroServicoNegocio();
	
	var idStr = id.toString();
	
	document.formCadastroServicoNegocio.restore({
		idServico : idStr
	});
}

function restoreCadastroServicoNegocioClone(id){
	JANELA_AGUARDE_MENU.show();
	
	limparCadastroServicoNegocio();
	
	var idStr = id.toString();

	var idPortfolioStr = document.formCadastroServicoNegocio.idPortfolioServico.value.toString();
	
	document.formCadastroServicoNegocio.restore({
		idServico : idStr,
		idPortfolioServico : idPortfolioStr
	});
}

function excluirCadastroServicoNegocio() {
	if (document.formCadastroServicoNegocio.idServico.value != "" && confirm(i18n_message("citcorpore.comum.deleta"))) {
		document.formCadastroServicoNegocio.fireDelete("excluir");
	}
}

function clonarCadastroServicoNegocio(){
	Modal.open('modal-portfolio-servico-negocio-clone');
}

function LOOKUP_SERVICOS_NEGOCIO_CLONE_select(id, desc){
	restoreCadastroServicoNegocioClone(id);
}

function voltarParaListaServicoNegocio() {
	if ($("form[name='formCadastroServicoNegocio'").data('popup') == _SIM) {
		Modal.close('modal-portfolio-servico-negocio');
		$("form[name='formCadastroServicoNegocio'").attr('data-popup', _NAO);
	}
	$(".breadCrumbPortfolio").trigger('click');
}

function LOOKUP_SERVICO_select(id, desc) {
	restoreCadastroServicoNegocio(id);
}

function selectCategoriaNegocio(id, desc) {
	document.formCadastroServicoNegocio.idCategoriaServico.value = id;
	document.formCadastroServicoNegocio.nomeCategoriaServico.value = desc;
	Modal.close('modal-selecionar-servico-categoria');
}

function clickCategoriaNegocio() {
	limpar_LOOKUP_CATEGORIASERVICO();
	
	Modal.open('modal-selecionar-servico-categoria');
	$("#modal-selecionar-servico-categoria").data("tipo", "N");
	$("a[href=#tabPesquisaCategoria]").trigger('click');
	document.formCategoriaServico.fireEvent("setaCategoriaNegocio");
	document.formPesquisaCategoriaServico.pesqLockupLOOKUP_CATEGORIASERVICO_TIPOCATEGORIA.value = "'N'";
}

function reloadFormCadastroServicoNegocio(isRecarregarTabela){
	// Força a arquitetura a recarregar os forms
	DEFINEALLPAGES_atribuiCaracteristicasCitAjax();

	document.formCadastroServicoNegocio.afterRestore = function() {
		afterRestoreCadastroServicoNegocio();
	}
	
	document.formCadastroServicoNegocio.afterSave = function() {
		afterSaveServicoNegocio(this);
	}

	document.formCadastroServicoNegocio.clear();
	document.formCadastroServicoNegocio.idPortfolioServico.value = getPortfolioServico();
	document.formCadastroServicoNegocio.tipoServico.value = _NEGOCIO;
	
	$('.datepicker').removeClass('hasDatepicker').datepicker();
	
	if (isRecarregarTabela) {
		$('#divDinamicoListaServicosNegocio').hide("blind", "fast",	function(){
			JANELA_AGUARDE_MENU.show();
			carregaTabelaServicosNegocio();
		});
	}
}

function afterRestoreCadastroServicoNegocio(){
	if(!Modal.isOpen('modal-portfolio-servico-negocio')){
		$('.tab-pane span[href="#detalhesServico"]').tab('show');
		JANELA_AGUARDE_MENU.hide();
		
		$('#divServicoNegocioInfo').show("slide", { direction: "right" }, "fast",	function(){
		});
	}
	
	$("#faseServico").trigger('change');
	$("a[href=#dadosServicoNegocio]").trigger('click');


	//No caso se for o restore de um clone
	if(Modal.isOpen('modal-portfolio-servico-negocio-clone')){
		JANELA_AGUARDE_MENU.hide();
		document.formCadastroServicoNegocio.idServico.value = "";
		Modal.close('modal-portfolio-servico-negocio-clone');
	}
}

function afterSaveServicoNegocio(form) {
	if(Modal.isOpen('modal-portfolio-servico-negocio')){
		Modal.close('modal-portfolio-servico-negocio');
	} else {
		$("a[href=#dadosServicoNegocio]").trigger('click');
	}
	JANELA_AGUARDE_MENU.hide();
	reloadAnexosServicoNegocio();
}

function abreFechaMaisMenos(obj, idMaisInfo) {

	if ($(obj).hasClass("circle_plus")) {
		$("#"+idMaisInfo).show("fast", function(){
			$("#"+idMaisInfo).css("display", "");
		});
		$(obj).removeClass("circle_plus");
		$(obj).addClass("circle_minus");
	} else {
		$(obj).removeClass("circle_minus");
		$(obj).addClass("circle_plus");
		$("#"+idMaisInfo).hide("fast", function(){
			$("#"+idMaisInfo).css("display", "none");
		});
	}
}

function onClickLabelAnexosServicoNegocio() {
	$("a[href=#documentosServicoNegocio]").trigger('click');
}

function reloadAnexosServicoNegocio() {
	document.formCadastroServicoNegocio.fireEvent("reloadAnexos");
}

function afterReloadAnexosServicoNegocio() {
	uploadServicoNegocio.refresh();
}

function exibirInformacoesComplementares(url) {
	if (url != '') {
		JANELA_AGUARDE_MENU.show();
		$("li.formularioDinamicoServicoNegocio").removeClass("hidden");
		document.getElementById('fraInformacoesComplementares').src = url;
	} else {
		try {
			JANELA_AGUARDE_MENU.hide();
		} catch (e) {
		}
		if (!$("li.formularioDinamicoServicoNegocio").hasClass("hidden")) {
			$("li.formularioDinamicoServicoNegocio").addClass("hidden");
		}
	}
}

function incluiInfoComplSeQuestionario(link){
	var str = new String(link);
	var res = str.search("visualizacaoQuestionario.load");
	if(res != -1){
		$("li.formularioDinamicoServicoNegocio").removeClass("hidden");
	}
}

function disableTemplateServico() {
	$("#idTemplateServico").attr("readOnly", "readOnly");
	$("#idTemplateServico option:not(:selected)").remove()
}

function changeTemplateServico() {
	document.formCadastroServicoNegocio.fireEvent('carregaInformacoesComplementaresViaJS');
}