_TECLA_ENTER = 13;
_OCORRENCIA_SERVICO_ACAO_ALTERAR = "A";

_TIPO_SERVICO_NEGOCIO = "N"; //br.com.centralit.citcorpore.util.Enumerados.TipoServico.SERVICO_NEGOCIO

$(function() {
	$("#inputFiltroContrato").keyup(function(event) {
		if (event.which == _TECLA_ENTER) {
			changeFiltroContrato($(event.currentTarget).val());
		}
	});
	
	document.formContratos.idServicoNegocioContrato.value = document.form.idServicoNegocioAtual.value;
	document.formContratos.idPortfolioServicoContrato.value = document.form.idPortfolioServicoAtual.value;
	document.formContratos.fireEvent("load");
});


function reloadFormCadastroContrato(){
	// Força a arquitetura a recarregar os forms
	DEFINEALLPAGES_atribuiCaracteristicasCitAjax();

	//Função disponível na tela de cadastro de contrato
	limparContrato();
	//reloadRadiosCadastroContrato();
	
	$('.datepicker').removeClass('hasDatepicker').datepicker();
	//setCheckedCadastroManualUsuario('S');
}

function clickNovoContrato(afterload){
	var j = {};
	j.idDiv = "#conteudo_popup_cadastro_contrato_apoio";
	j.urlJsp = "/pages/cadastroContrato/cadastroContratoConteudo/cadastroContratoConteudo.jsp";	
	removeJsp(j);
	
	j = {};
	j.idDiv = "#detalhesContrato";
	j.urlJsp = "/pages/cadastroContrato/cadastroContratoConteudo/cadastroContratoConteudo.jsp";	
	removeJsp(j);

	j = {};
	j.idDiv = "#conteudo_popup_cadastro_contrato";
	j.urlJsp = "/pages/cadastroContrato/cadastroContratoConteudo/cadastroContratoConteudo.jsp";
	j.functionAfterLoad = function() {
		document.formCadastroContrato.tipoTela.value = 'NEGOCIO'; 
		document.formCadastroContrato.fireEvent("load");

		//Esconde a tab da tela de contrao, pois existe uma tab para listagem
		$('#tabCadastroContrato').css("display", "none");
		
		reloadFormCadastroContrato();

		document.formCadastroContrato.afterSave = function() {
			afterSaveContrato();
		};
		
		Modal.open('modal-lookup-cadastro-contrato');
		document.formContratos.isEditar.value = 'N';
		
		if(typeof afterload != "undefined") afterload();
	};
	loadJsp(j);
}

function afterSaveContrato() {
	//if($("#POPUP_CADASTRO_CONTRATO").hasClass('ui-dialog-content') && $("#POPUP_CADASTRO_CONTRATO").dialog("isOpen")){
		if (document.formContratos.isEditar.value == 'N') {
			document.formContratos.idContratoVincular.value = document.formCadastroContrato.idContrato.value;
			document.formContratos.idServicoNegocioContrato.value = getServicoRelacionado();
			document.formContratos.fireEvent("vincularContratoAoServico");
		} else {
			document.formContratos.fireEvent("salvarOcorrenciaServicoContrato");
			changeFiltroContrato('');
		}

		//$("#POPUP_CADASTRO_CONTRATO").dialog("close");
		Modal.close('conteudo_popup_cadastro_contrato');
		
	//}
}
function fechaModalPesquisaContrato(){
	Modal.close('modal-lookup-pesquisa-contrato');
}

function inicializarDetalhesContrato() {
	setTimeout(function() {
		document.formCadastroContrato.tipoServicoPortfolio.value = _TIPO_SERVICO_NEGOCIO;
		document.formCadastroContrato.afterSave = function() {
			afterSaveContrato();
		};
		
		gravarContrato = function() {
			if (validarCamposContratosPrincipal()) {
				document.formCadastroContrato.tipoServicoPortfolio.value = _TIPO_SERVICO_NEGOCIO;
				document.formCadastroContrato.save();
			}
		};

		excluirContrato = function() {
			if (document.formCadastroContrato.idContrato.value > "" && confirm(i18n_message("citcorpore.comum.deleta"))) {
				document.formCadastroContrato.tipoServicoPortfolio.value = _TIPO_SERVICO_NEGOCIO;
				document.formCadastroContrato.fireUpdate("excluirContrato");
			}
		};
		
	}, 200);
}

function beforeClosePopupNovoContrato(){
	$('#divDinamicoTabelaContratos').hide("blind", "fast",	function(){
		JANELA_AGUARDE_MENU.show();
		
		var j = {};
		j.idDiv = "#conteudo_popup_cadastro_contrato";
		j.urlJsp = "/pages/cadastroContrato/cadastroContratoConteudo/cadastroContratoConteudo.jsp";
		
		removeJsp(j);
		
		document.formContratos.idServicoNegocioContrato.value = getServicoRelacionado();
		document.formContratos.fireEvent("carregaTabelaContratos");
	});
}

function editarContrato(obj, idContrato){
	afterload = function(){
		JANELA_AGUARDE_MENU.show();
		
		document.formContratos.idServicoNegocioContrato.value = getServicoRelacionado();
		document.formContratos.idsContratoOcorrenciaServico.value = idContrato;
		document.formContratos.acaoContratoOcorrenciaServico.value = _OCORRENCIA_SERVICO_ACAO_ALTERAR;
		document.formContratos.isEditar.value = 'S';
		
		restoreContrato(idContrato);
		
		document.formCadastroContrato.afterRestore = function() {
			afterRestoreCadastroContrato();
			JANELA_AGUARDE_MENU.hide();
		}
	}
	
	clickNovoContrato(afterload);
}

//Função que faz o restore a partir da tela de cadastro de contrato
function restoreContrato(idContrato){
	document.formCadastroContrato.fireEvent("load");
	//Função disponível na tela de cadastro de contrato
	limparContrato();
	
	var idStr = idContrato.toString();
	//Restore na tela de cadastro de contrato
	document.formCadastroContrato.restore({
		idContrato : idStr
	});
}

function desvincularContrato(idContrato){
	if (idContrato > "" && confirm(i18n_message("gerenciaportfolio.desejaDesvincularContrato"))) {
		document.formContratos.idContrato.value = idContrato;
		document.formContratos.idServicoNegocioContrato.value = getServicoRelacionado();
		document.formContratos.fireUpdate("desvincularContratoServico");
	}
}

function vincularContrato(){
	//criaDialog('M', 'dialogContratos', '');
	//$("#POPUP_CONTRATOS").dialog("open");
	Modal.open('modal-lookup-pesquisa-contrato');
}

function LOOKUP_CONTRATOS_VINCULAR_select(id, desc) {
	document.formContratos.idContratoVincular.value = id;
	document.formContratos.idServicoNegocioContrato.value = getServicoRelacionado();
	//$("#POPUP_CONTRATOS").dialog("close");
	fechaModalPesquisaContrato();
	document.formContratos.fireEvent("vincularContratoAoServico");
}

function limpaFiltroContrato() {
	$("#inputFiltroContrato").val("");
	changeFiltroContrato("");
}

function pesquisaFiltroContrato() {
	changeFiltroContrato($("#inputFiltroContrato").val());
}

function changeFiltroContrato(filtroContrato) {
	JANELA_AGUARDE_MENU.show();
	document.formContratos.paginaSelecionadaContrato.value = 0;
	document.formContratos.filtroContrato.value = filtroContrato;
	document.formContratos.idServicoNegocioContrato.value = getServicoRelacionado();
	document.formContratos.fireEvent("carregaTabelaContratos");
}

function paginarContratos(paginaSelecionadaContrato) {
	$('#divDinamicoTabelaContratos').hide("blind", "fast",	function(){
		JANELA_AGUARDE_MENU.show();
		document.formContratos.paginaSelecionadaContrato.value = paginaSelecionadaContrato;
		document.formContratos.fireEvent("carregaTabelaContratos");
	});
}

function depoisCarregarTabelaContratos(){
	JANELA_AGUARDE_MENU.hide();
	$('#divDinamicoTabelaContratos').show("blind", "fast",	function(){
		$("span[href='#tabTabelaANSC']").trigger('click');
	});
}

