_TECLA_ENTER = 13;
_TIPO_SERVICO_APOIO = "A"; //br.com.centralit.citcorpore.util.Enumerados.TipoServico.SERVICO_APOIO

$(function() {
	$("#inputFiltroContratoApoio").keyup(function(event) {
		if (event.which == _TECLA_ENTER) {
			changeFiltroContratoApoio($(event.currentTarget).val());
		}
	});
	
	document.formContratosApoio.idServicoApoioContrato.value = getServicoRelacionado();
	document.formContratosApoio.idPortfolioServicoContrato.value = document.form.idPortfolioServicoAtual.value;
	document.formContratosApoio.fireEvent("load");
});


function reloadFormCadastroContratoApoio(){
	// Força a arquitetura a recarregar os forms
	DEFINEALLPAGES_atribuiCaracteristicasCitAjax();

	//Função disponível na tela de cadastro de contrato
	limparContrato();
	
	$('.datepicker').removeClass('hasDatepicker').datepicker();
	setCheckedCadastroManualUsuario('S');
}

function clickNovoContratoApoio(afterload){
	var j = {};
	j.idDiv = "#conteudo_popup_cadastro_contrato";
	j.urlJsp = "/pages/cadastroContrato/cadastroContratoConteudo/cadastroContratoConteudo.jsp";
	removeJsp(j);
	
	j = {};
	j.idDiv = "#detalhesContrato";
	j.urlJsp = "/pages/cadastroContrato/cadastroContratoConteudo/cadastroContratoConteudo.jsp";
	removeJsp(j);
	
	j = {};
	j.idDiv = "#conteudo_popup_cadastro_contrato_apoio";
	j.urlJsp = "/pages/cadastroContrato/cadastroContratoConteudo/cadastroContratoConteudo.jsp";
	j.functionAfterLoad = function(){
		document.formCadastroContrato.tipoTela.value = 'APOIO';
		document.formCadastroContrato.fireEvent("load");
		
		//Esconde a tab da tela de contrao, pois existe uma tab para listagem
		$('#tabCadastroContrato').css("display", "none");
		
		reloadFormCadastroContratoApoio();
		
		document.formCadastroContrato.afterSave = function(){
			afterSaveContratoApoio();
		};
		
		Modal.open('modal-lookup-cadastro-contrato-apoio');
		Modal.oneHidden('modal-lookup-cadastro-contrato-apoio', beforeClosePopupNovoContratoApoio);
		document.formContratosApoio.isEditar.value = 'N';
		
		if(typeof afterload != "undefined") afterload();
	};
	loadJsp(j);
}

function inicializarDetalhesContrato() {
	setTimeout(function() {
		document.formCadastroContrato.tipoServicoPortfolio.value = _TIPO_SERVICO_APOIO;
		document.formCadastroContrato.afterSave = function() {
			afterSaveContratoApoio();
		};
		
		gravarContrato = function() {
			if (validarCamposContratosPrincipal()) {
				document.formCadastroContrato.tipoServicoPortfolio.value = _TIPO_SERVICO_APOIO;
				document.formCadastroContrato.save();
			}
		};

		excluirContrato = function() {
			if (document.formCadastroContrato.idContrato.value > "" && confirm(i18n_message("citcorpore.comum.deleta"))) {
				document.formCadastroContrato.tipoServicoPortfolio.value = _TIPO_SERVICO_APOIO;
				document.formCadastroContrato.fireUpdate("excluirContrato");
			}
		};
		
	}, 200);
}

function afterSaveContratoApoio() {
	if (document.formContratosApoio.isEditar.value == 'N') {
		document.formContratosApoio.idContratoApoioVincular.value = document.formCadastroContrato.idContrato.value;
		document.formContratosApoio.idServicoApoioContrato.value = getServicoRelacionado();
		document.formContratosApoio.fireInsert("vincularContratoAoServico");
	}

	Modal.close('modal-lookup-cadastro-contrato-apoio');
}

function beforeClosePopupNovoContratoApoio(){
	$('#divDinamicoTabelaContratosApoio').hide("blind", "fast",	function(){
		JANELA_AGUARDE_MENU.show();
		
		var j = {};
		j.idDiv = "#conteudo_popup_cadastro_contrato_apoio";
		j.urlJsp = "/pages/cadastroContrato/cadastroContratoConteudo/cadastroContratoConteudo.jsp";
		
		removeJsp(j);
		reloadFormCadastroContratoApoio();
		document.formContratosApoio.idServicoApoioContrato.value = getServicoRelacionado();
		document.formContratosApoio.fireEvent("carregaTabelaContratos");
	});
}

function editarContratoApoio(obj, idContrato){
	afterload = function(){
		JANELA_AGUARDE_MENU.show();
		
		document.formContratosApoio.isEditar.value = 'S';

		restoreContratoApoio(idContrato);
		
		document.formCadastroContrato.afterRestore = function() {
			afterRestoreCadastroContrato();
			JANELA_AGUARDE_MENU.hide();
		}
	}
	
	clickNovoContratoApoio(afterload);	
}

//Função que faz o restore a partir da tela de cadastro de contrato
function restoreContratoApoio(idContrato){
	//Função disponível na tela de cadastro de contrato
	limparContrato();
	
	var idStr = idContrato.toString();
	//Restore na tela de cadastro de contrato
	document.formCadastroContrato.restore({
		idContrato : idStr
	});
}

function desvincularContratoApoio(idContrato){
	if (idContrato > "" && confirm(i18n_message("gerenciaportfolio.desejaDesvincularContrato"))) {
		document.formContratosApoio.idContrato.value = idContrato;
		document.formContratosApoio.fireUpdate("desvincularContratoServico");
	}
}


function vincularContratoApoio(){
	
	var contratosVinculados = [];
	
	$('#tabelaContratos tbody').find('td:first-child').each(function() {
		contratosVinculados.push($(this).text());
	});
	
	if(contratosVinculados.length > 0){
		$('#contratosVinculados').val(contratosVinculados);
		document.formPesquisaContratoApoio.whereDinamico = "cont.idContrato not in (" + contratosVinculados.join() + ")" ;
	}
	
	Modal.open("modal-lookup-pesquisa-contrato-apoio");
}

function LOOKUP_CONTRATOS_APOIO_VINCULAR_select(id, desc) {
	document.formContratosApoio.idContratoApoioVincular.value = id;
	document.formContratosApoio.idServicoApoioContrato.value = getServicoRelacionado();
	fechaModalPesquisaContratoApoio();
	document.formContratosApoio.fireInsert("vincularContratoAoServico");
}

function fechaModalPesquisaContratoApoio(){
	limpar_LOOKUP_CONTRATOS_APOIO_VINCULAR();
	Modal.close("modal-lookup-pesquisa-contrato-apoio");
}

function limpaFiltroContratoApoio() {
	$("#inputFiltroContratoApoio").val("");
	changeFiltroContratoApoio("");
}

function changeFiltroContratoApoio(filtroContratoApoio) {
	JANELA_AGUARDE_MENU.show();
	document.formContratosApoio.paginaSelecionadaContratoApoio.value = 0;
	document.formContratosApoio.filtroContratoApoio.value = filtroContratoApoio;
	document.formContratosApoio.idServicoApoioContrato.value = getServicoRelacionado();
	document.formContratosApoio.fireEvent("carregaTabelaContratos");
}

function pesquisaFiltroContratoApoio(filtroContratoApoio) {
	changeFiltroContratoApoio($("#inputFiltroContratoApoio").val());
}

function paginarContratosApoio(paginaSelecionadaContratoApoio) {
	$('#divDinamicoTabelaContratosApoio').hide("blind", "fast",	function(){
		JANELA_AGUARDE_MENU.show();
		document.formContratosApoio.paginaSelecionadaContratoApoio.value = paginaSelecionadaContratoApoio;
		document.formContratosApoio.fireEvent("carregaTabelaContratos");
	});
}

function depoisCarregarTabelaContratosApoio(){
	JANELA_AGUARDE_MENU.hide();
	$('#divDinamicoTabelaContratosApoio').show("blind", "fast",	function(){
		$("span[href='#tabTabelaANSC']").trigger('click');
	});
}