$(function() {
	$("#inputFiltroContratoCalendario").keyup(function(event) {
		if (event.which == _TECLA_ENTER) {
			ContratoCalendario.changeFiltro($(event.currentTarget).val());
		}
	});

	if($(".breadcrumb li.breadCrumbContrato").length > 0) {
		document.formContratoCalendario.idServicoContrato.value = $(".breadcrumb li.breadCrumbContrato").attr("data-idservicocontrato");
	}
	
	if($(".breadcrumb li.breadCrumbContratoApoio").length > 0) {
		document.formContratoCalendario.idServicoContrato.value = $(".breadcrumb li.breadCrumbContratoApoio").attr("data-idservicocontrato");
	}
	document.formContratoCalendario.fireEvent("load");
});

var ContratoCalendario = {
	abrirPopup: function() {
		Modal.open('modal-lookup-contrato-calendario');
	},
	vincularCalendario: function(id, desc) {
		document.formContratoCalendario.idCalendario.value = id;
		document.formContratoCalendario.fireUpdate("adicionarCalendario");
	},
	desativarCalendario: function(idServicoContratoCalendario) {
		if (confirm(i18n_message("citcorpore.comum.confirmaDesativacao"))) {
			document.formContratoCalendario.idServicoContratoCalendario.value = idServicoContratoCalendario;
			document.formContratoCalendario.fireUpdate("desativarCalendario");
		}
	},
	limparFiltro: function() {
		$("#inputFiltroContratoCalendario").val("");
		this.changeFiltro("");
	},
	filtrar: function() {
		this.changeFiltro($("#inputFiltroContratoCalendario").val());
	},
	changeFiltro: function(filtroContratoCalendario) {
		document.formContratoCalendario.filtro.value = filtroContratoCalendario;
		document.formContratoCalendario.paginaSelecionada.value = 0;
		this.carregarTabela();
	},
	paginarServicoContratoCalendario: function(paginaSelecionada) {
		$('#divDinamicoListaContratoCalendarios').hide("blind", "fast",	function(){
			JANELA_AGUARDE_MENU.show();
			document.formContratoCalendario.paginaSelecionada.value = paginaSelecionada;
			// não pode usar o this pois essa função é adicionada no html
			ContratoCalendario.carregarTabela();
		});
	},
	carregarTabela: function() {
		document.formContratoCalendario.fireEvent("carregarTabelaServicoContratoCalendario");
	}
};

LOOKUP_CONTRATO_CALENDARIO_select = function(id, desc) {
	ContratoCalendario.vincularCalendario(id, desc);
	Modal.close('modal-lookup-contrato-calendario');
}