_TECLA_ENTER = 13;
_OCORRENCIA_SERVICO_ACAO_ALTERAR = "A";

$(function() {
	$("#inputFiltroHabilidade").keyup(function(event) {
		if (event.which == _TECLA_ENTER) {
			changeFiltroHabilidade($(event.currentTarget).val());
		}
	});
	
	document.formVincularHabilidade.idServico.value = document.form.idServicoNegocioAtual.value;
	document.formVincularHabilidade.fireEvent("load");
});

function pesquisaFiltroHabilidade(){
	changeFiltroHabilidade($("#inputFiltroHabilidade").val());
}

function atualizarListaIdsHabilidadesvinculadas() {
	document.formVincularHabilidade.listaIdsHabilidadesVinculadas.value = document.formVincularHabilidade.listaIdsHabilidadesVinculadas.value + document.formVincularHabilidade.colAllLOOKUP_SERVICO_VINCULAR_HABILIDADE.value;
}

var VincularHabilidade = {
	abrirPopup: function() {
		limpar_LOOKUP_SERVICO_VINCULAR_HABILIDADE();
		 
		// Lista dos ids dos processos negocios vinculados
		var idsHabilidadesvinculadas = this.getListaIdsHabilidadesvinculadas();
		
		// Se tiver alguma unidade vinculada acrescenta uma condição na lookup para que elas não sejam exibidas
		if(idsHabilidadesvinculadas.length > 0) {
			document.formLookupServicoVincularHabilidade.whereDinamico = "idHabilidade not in ("+ idsHabilidadesvinculadas+")";
		} else {
			document.formLookupServicoVincularHabilidade.whereDinamico = "";
		}
		
		Modal.open('modal-portfolio-vincular-habilidade');
	},
	
	fecharPopup: function() {
		Modal.close('modal-portfolio-vincular-habilidade');
	},
	
	desvincularHabilidadeFromServico : function(idHabilidadeVinculo, idHabilidade){
		if (confirm(i18n_message("gerenciaportfolioHabilidade.desejaDesvincularHabilidade"))) {
			JANELA_AGUARDE_MENU.show();
			
			// remove o processo negócio da lista de vinculados atualiza a lista
			document.formVincularHabilidade.listaIdsHabilidadesVinculadas.value = document.formVincularHabilidade.listaIdsHabilidadesVinculadas.value.replace(idHabilidadeVinculo+";", "");

			document.formVincularHabilidade.idHabilidadeVinculo.value = idHabilidadeVinculo;
			document.formVincularHabilidade.idsHabilidadeOcorrenciaServico.value = idHabilidade;
			document.formVincularHabilidade.fireUpdate("excluir");
			
			if($("#divDinamicoListaProcessosNegocio tbody tr").length < 1) {
				$("#divDinamicoListaProcessosNegocio").html("");
			}
				
		}
	},	
	
	getListaIdsHabilidadesvinculadas: function() {
		var idsHabilidadesvinculadas = $("#listaIdsHabilidadesVinculadas").val().split(";");
		idsHabilidadesvinculadas = idsHabilidadesvinculadas.slice(0, idsHabilidadesvinculadas.length-1);
		return idsHabilidadesvinculadas;
	},
	
	atualizarListaIdsHabilidadesvinculadas: function() {
		document.formVincularHabilidade.listaIdsHabilidadesVinculadas.value = document.formVincularHabilidade.listaIdsHabilidadesVinculadas.value + document.formVincularHabilidade.colAllLOOKUP_SERVICO_VINCULAR_HABILIDADE.value;
	},
	
	depoisMontarHTMLHabilidade: function(){
		JANELA_AGUARDE_MENU.hide();
		
		$('#divDinamicoListaHabilidade').show("blind", "fast",	function(){});
	},
	
	paginarHabilidade: function(paginaSelecionadaNegocio) {
		$('#divDinamicoListaHabilidade').hide("blind", "fast",	function(){
			JANELA_AGUARDE_MENU.show();
			document.formVincularHabilidade.paginaSelecionadaHabilidade.value = paginaSelecionadaNegocio;
			// não pode usar o this pois essa função é adicionada no html
			VincularHabilidade.carregarTabelaHabilidade();
		});
	},
	
	carregarTabelaHabilidade: function() {
		document.formVincularHabilidade.fireEvent("montarHTMLHabilidade");
	},
	
	abrirPopupHabilidade: function(idHabilidade){
		this.abrirPopupNovoHabilidade(idHabilidade);
		document.formCadastroHabilidade.idHabilidade.value = parseInt(idHabilidade);
		document.formCadastroHabilidade.fireEvent("restore");
	},
	
	abrirPopupNovoHabilidade: function(idHabilidade){
		$("#modal-portfolio-cadastrar-habilidade #divCadastroHabilidade").removeClass("span8");
		$("#modal-portfolio-cadastrar-habilidade #divCadastroHabilidade").addClass("span12");
		Modal.open('modal-portfolio-cadastrar-habilidade');
		Modal.oneHidden('modal-portfolio-cadastrar-habilidade', this.onHidePopupNovaHabilidade);
		$("#modal-portfolio-cadastrar-habilidade .tabsbar").css("display", "none");
		$("#modal-portfolio-cadastrar-habilidade button[name='btnExcluir']").css("display", "none");
		$("#modal-portfolio-cadastrar-habilidade .widget-collapse").attr('data-toggle', '');
		
		document.formCadastroHabilidade.afterSave = function() {
			// se for editar
			if(idHabilidade) {
				document.formVincularHabilidade.idsHabilidadeOcorrenciaServico.value = idHabilidade;
				document.formVincularHabilidade.acaoHabilidadeOcorrenciaServico.value = _OCORRENCIA_SERVICO_ACAO_ALTERAR = "A";;
				document.formVincularHabilidade.fireEvent("salvarOcorrenciaServicoHabilidade");
			}
		}
	},
	onHidePopupNovaHabilidade: function() {
		$("#modal-portfolio-cadastrar-habilidade #divCadastroHabilidade").removeClass("span12");
		$("#modal-portfolio-cadastrar-habilidade #divCadastroHabilidade").addClass("span8");
	}
}

function fechaAguarde(){
	JANELA_AGUARDE_MENU.hide();
}

function limpaFiltroHabilidade() {
	$("#inputFiltroHabilidade").val("");
	this.changeFiltroHabilidade("");
}

function changeFiltroHabilidade(filtroHabilidade) {
	JANELA_AGUARDE_MENU.show();
	document.formVincularHabilidade.filtroHabilidade.value = filtroHabilidade;
	document.formVincularHabilidade.fireEvent("preencheListaHabilidadeFiltro");
}