var mapa = null;

$(function() {
	escondeAbasEvmGerentes();

	if(document.formMapaDesenhoApoio && document.form && document.form.idServicoApoioAtual && document.form.idServicoApoioAtual.value) {
		document.formMapaDesenhoApoio.idServicoApoio.value = document.form.idServicoApoioAtual.value;
		document.formMapaDesenhoApoio.idPortfolioServico.value = document.form.idPortfolioServicoAtual.value;
		document.formMapaDesenhoApoio.fireEvent("load");
	}
});



function extrairVariavelDaUrl(nome){
	var valor = null;
	var identificador = null;
	try{
		var strUrl = document.URL;
		var params = strUrl.split("")[1];
		var variaveis = params.split("&");

		for(var i = 0; i < variaveis.length; i++){
			valor = variaveis[i].split("=")[1];
			identificador = variaveis[i].split("=")[0];

			if(identificador == nome){
				return valor;
			}

			valor = null;
		}
	}catch(e){}

	return null;
}

function atualizaServicoMapa(serealizado) {
	
	if(mapa)
		mapa.resetaLista();

	mapa = new MapaDesenhoServico(document.getElementById("mapaServicos"));
	mapa.configuraEventos();

	//Recupera o IC com apenas dois clicks. Atualmente utilizado apenas pelo gerenciamento de problema
	if(extrairVariavelDaUrl("selecaoIc") != null){
		mapa.addAfterDBClickItemEvent(function(item){
			parent.selecionaIcPeloMapa(item.idItemConfiguracao, item.identificacao + "-" + item.descricao);
			throw i18n_message("mapaDesenhoServico.itemRecuperadoPorPaginaPai");
		})
	}

	var lista = ObjectUtils.deserializeCollectionFromString(serealizado);
	var imgAux = null;
	var listaAux = [];
	for ( var i = 0; i < lista.length; i++) {
		imgAux = new ImagemItemConfiguracaoDTO(mapa.context, lista[i].caminhoImagem);
		imgAux.idImagemItemConfiguracao = lista[i].idImagemItemConfiguracao;
		imgAux.posx = parseInt(lista[i].posx);
		imgAux.posy = parseInt(lista[i].posy);
		imgAux.idServico = lista[i].idServico;
		imgAux.idItemConfiguracao = lista[i].idItemConfiguracao;
		imgAux.idImagemItemConfiguracaoPai = lista[i].idImagemItemConfiguracaoPai != "" ? lista[i].idImagemItemConfiguracaoPai : null;
		if(lista[i].idImagemItemConfiguracaoPaiColSerializado!= null && lista[i].idImagemItemConfiguracaoPaiColSerializado!= ""){
			var colImagemPai = ObjectUtils.deserializeCollectionFromString(lista[i].idImagemItemConfiguracaoPaiColSerializado);
			for(var j = 0; j< colImagemPai.length; j++){
				imgAux.idImagemItemConfiguracaoCol.push(colImagemPai[j]);
			}
		}
		imgAux.descricao = lista[i].descricao;
		imgAux.identificacao = lista[i].identificacao;
		imgAux.idGerenteEvm = lista[i].idGerenteEvm;
		imgAux.ferramentaConexaoEvm = lista[i].ferramentaConexaoEvm;
		listaAux[i] = imgAux;
	}
	
	$(('#mapaServicos')).resize(function() {
		mapa.redimensionaCanvas();
	});
	
	mapa.setListaItens(listaAux.slice());
};

/**
 * Quando o item começar a ser arrastado algumas informações
 * serão salvas para serem recuperadas pelo Mapa.
 * @param e
 * Evento dragstart.
 */
function dragstart(e) {
	if (document.formMapaDesenhoApoio.idServicoMapaApoio.value != ""){
		e.dataTransfer.setData("text", e.target.getAttribute("id"));
	}
}

function openDialog(idDialog) {
	$("#" + idDialog).dialog("open");
};

function openDialogFramePesquisaIC() {
	// inicializa a dialog caso a mesma já não tenha sido inicializada
	if(!$("#modal-mapa-desenho-apoio-pesquisar-ic").is('.ui-dialog-content')) {
		document.getElementById('popupitemc').src = ctx + '/pages/pesquisaItemConfiguracao/pesquisaItemConfiguracao.load?iframe=true&funcaoPaiFrame=recebeICMapaApoio';
	}
	Modal.open('modal-mapa-desenho-apoio-pesquisar-ic');
};

function openDialogFrameGerCorrelacao() {
	defineFrameCorrelacao();
	
	Modal.open('modal-mapa-desenho-apoio-gerente-correlacao');
	Modal.oneHidden('modal-mapa-desenho-apoio-gerente-correlacao',limpaFormCorrelacaoEventos);
};

function closeDialog(idDialog) {
	$("#" + idDialog).dialog("close");
};

function abaGerenteInventory(){
	JANELA_AGUARDE_MENU.show();
	var url = ctx + '/pages/evmGerenteInventory/evmGerenteInventory.load?iframe=true&iframeNoSearchNoEditICPai=true&fecharJanelaAguardePai=S';

	var idGerente = document.formMapaDesenhoApoio.idGerenteEvmMapaApoio.value.replace(/\D/g, "");
	if(idGerente>"") {
		 url += '&idGerenteEvm='+ idGerente;
	}
	
	var ferramenta = document.formMapaDesenhoApoio.ferramentaConexaoEvmMapaApoio.value;
	if(ferramenta>"") {
		 url += "&ferramentaConexaoEvm='" + ferramenta + "'";
	}
	
	var idIC = document.formMapaDesenhoApoio.idItemConfiguracaoMapaApoio.value.replace(/\D/g, "");
	if(idIC>"") {
		 url += '&idItemConfiguracaoPai='+ idIC;
	}
	
	document.getElementById('iframeGerenteInventory').src = url;
}

function abaGerenteZabbix(){
	JANELA_AGUARDE_MENU.show();
	var url = ctx + '/pages/evmGerenteZabbix/evmGerenteZabbix.load?iframe=true&iframeNoSearchNoEditICPai=true&fecharJanelaAguardePai=S';
	
	var idGerente = document.formMapaDesenhoApoio.idGerenteEvmMapaApoio.value.replace(/\D/g, "");
	if(idGerente>"") {
		 url += '&idGerenteEvm='+ idGerente;
	}
	
	var ferramenta = document.formMapaDesenhoApoio.ferramentaConexaoEvmMapaApoio.value;
	if(ferramenta>"") {
		 url += "&ferramentaConexaoEvm='" + ferramenta + "'";
	}
	
	var idIC = document.formMapaDesenhoApoio.idItemConfiguracaoMapaApoio.value.replace(/\D/g, "");
	if(idIC>"") {
		 url += '&idItemConfiguracaoPai='+ idIC;
	}

	document.getElementById('iframeGerenteZabbix').src = url;
}

function abaGerenteNagios(){
	JANELA_AGUARDE_MENU.show();
	var url = ctx + '/pages/evmGerenteNagios/evmGerenteNagios.load?iframe=true&iframeNoSearchNoEditICPai=true&fecharJanelaAguardePai=S';
	
	var idGerente = document.formMapaDesenhoApoio.idGerenteEvmMapaApoio.value.replace(/\D/g, "");
	if(idGerente>"") {
		 url += '&idGerenteEvm=' + idGerente;
	}
	
	var ferramenta = document.formMapaDesenhoApoio.ferramentaConexaoEvmMapaApoio.value;
	if(ferramenta>"") {
		 url += "&ferramentaConexaoEvm='" + ferramenta + "'";
	}
	
	var idIC = document.formMapaDesenhoApoio.idItemConfiguracaoMapaApoio.value.replace(/\D/g, "");
	if(idIC>"") {
		 url += '&idItemConfiguracaoPai=' + idIC;
	}

	document.getElementById('iframeGerenteNagios').src = url;
	
}

function onHideModalMapaDesenhoApoioIC() {
	document.getElementById('iframeGerenteInventory').src = '';
	document.getElementById('iframeGerenteZabbix').src = '';
	document.getElementById('iframeGerenteNagios').src = '';
}

function mostraAbasEvmGerentes(abaAtiva){
	
	//Mostra os gerentes e o botão de desvincular gerente
	$("#evmGerentes").show();
	$("#btDesvincularGerente").show();
	
	//Define a aba conforme o gerente
	if(abaAtiva!=null && abaAtiva>""){
		defineAbaAtiva(abaAtiva);
	}
	
}

function defineAbaAtiva(abaAtiva){
	//Recebe do banco de conexão do evm e define a aba que está o gerente
	switch (abaAtiva) {
	case "CITSMART_INVENTORY":
		abaGerenteInventory();
		$('.tabsbar a[href="#tab_gerente_1-3"]').tab('show');
	break;
	case "ZABBIX":
		abaGerenteZabbix();
		$('.tabsbar a[href="#tab_gerente_2-3"]').tab('show');
	break;
	case "NAGIOS":
		abaGerenteNagios();
		$('.tabsbar a[href="#tab_gerente_3-3"]').tab('show');
	break;
	default:
		limparAbasEvmGerentes();
	break;
	}
}

function escondeAbasEvmGerentes(){
	//Esconde os gerentes e também o botão de desvincular gerente
	$("#evmGerentes").hide();
	$("#btDesvincularGerente").hide();
}


function limparAbasEvmGerentes(){
	//Zera o conteúdo de todos os frames
	document.getElementById('iframeGerenteInventory').contentWindow.document.write("");
	document.getElementById('iframeGerenteZabbix').contentWindow.document.write("");
	document.getElementById('iframeGerenteNagios').contentWindow.document.write("");
	
	//Nenhuma aba fica escolhida
	document.getElementById("li_inventory").className = "";
	document.getElementById("li_zabbix").className = "";
	document.getElementById("li_nagios").className = "";
}

/**
 * Limpa campos específicos.
 */
function limpaFormItemConfiguracao() {

	document.formMapaDesenhoApoio.idItemConfiguracaoMapaApoio.value = "";
	document.formMapaDesenhoApoio.idGerenteEvmMapaApoio.value = "";
	document.formMapaDesenhoApoio.ferramentaConexaoEvmMapaApoio.value = "";

	document.formItemConfiguracaoMapaApoio.identificacaoICMapaApoio.value = "";
	document.formItemConfiguracaoMapaApoio.txtDescricaoMapaApoio.value = "";

	escondeAbasEvmGerentes();
	limparAbasEvmGerentes();
};

/**
 * Faz a seleção so item de configuração a partir da página de pesquisaItemConfiguracao
 */
function recebeICMapaApoio(idItem) {
	limpaFormItemConfiguracao();
	document.formMapaDesenhoApoio.idItemConfiguracaoMapaApoio.value = idItem;
	mostraAbasEvmGerentes(null);
	document.formMapaDesenhoApoio.fireEvent("selecionarItemConfigurcao");
	Modal.close("modal-mapa-desenho-apoio-pesquisar-ic");
};

function afterSelecionarItemConfiguracao(identificacaoIC){
	document.formItemConfiguracaoMapaApoio.identificacaoICMapaApoio.value = identificacaoIC;
}

//Método é chamado através do javascript da tela de cada gerente(Inventory, Zabbix e Nagios)
function gerenteSalvo(idGerente, ferramenta){
	if(document.formMapaDesenhoApoio.idGerenteEvmMapaApoio.value>""){
		//Exclui quando o serviço for associado à outro gerente
		if(idGerente != document.formMapaDesenhoApoio.idGerenteEvmMapaApoio.value){
			//Exclui o antigo gerente do IC
			excluirGerenteAtual(false);
		}
	}
	
	document.formMapaDesenhoApoio.idGerenteEvmMapaApoio.value = idGerente;
	document.formMapaDesenhoApoio.ferramentaConexaoEvmMapaApoio.value = ferramenta;
	document.formItemConfiguracaoMapaApoio.btSalvarMapaApoio.click();
	//mapa.salvarNovoItemConfiguracao();
	//mapa.salvarItemConfiguracao(false);
	//alert("Gerente salvo. IdGerente: "+idGerente+". Ferramenta: "+ferramenta);
	defineAbaAtiva(ferramenta);
}

function excluirGerenteAtual(seDesvinculaGerente){
	if(document.formMapaDesenhoApoio.idGerenteEvmMapaApoio.value>""){
		document.formMapaDesenhoApoio.fireDelete("excluirGerente");
		
		if(seDesvinculaGerente){
			limparAbasEvmGerentes();
			document.formMapaDesenhoApoio.idGerenteEvmMapaApoio.value = "";
			document.formMapaDesenhoApoio.ferramentaConexaoEvmMapaApoio.value = "";
			mapa.salvarItemConfiguracao(false);
		}
	}else{
		if(seDesvinculaGerente){
			alert(i18n_message("mapaDesenhoServico.semGerenteVinculado"));
		}
	}
}

//Método é chamado através do javascript da tela de gerente correlação de eventos
function gerenteCorrelacaoSalvo(idGerenteCorrelacao){
	
	document.formMapaDesenhoApoio.idGerenteCorrelacaoEvmMapaApoio.value = idGerenteCorrelacao;

	document.formMapaDesenhoApoio.fireInsert("salvarRelacaoGerenteCorrelacaoServico");
	
	//alert("Gerente de correlação salvo. IdGerenteCorrelacao: "+idGerenteCorrelacao);
	
	defineFrameCorrelacao();
}

function defineFrameCorrelacao(){
	var url = ctx + '/pages/evmGerenteCorrelacao/evmGerenteCorrelacao.load?iframe=true&iframeNoSearchNoEditICPai=true';
	
	var idGerenteCorrelacao = document.formMapaDesenhoApoio.idGerenteCorrelacaoEvmMapaApoio.value.replace(/\D/g, "");
	
	if(idGerenteCorrelacao>"") {
		 url += '&idGerenteCorrelacaoEvm='+ idGerenteCorrelacao;
	}
	
	document.getElementById('iframeGerenteCorrelacao').src = url;
}

function carregaCorrelacaoServico(){
	var idServicoMapaApoio = document.formMapaDesenhoApoio.idServicoMapaApoio.value;
	if(idServicoMapaApoio>""){
		document.formMapaDesenhoApoio.fireEvent("carregaCorrelacaoServico");
	}else{
		notificacaoI18N("citcorpore.comum.selecioneUmServico", '');
	}
}

function addEplCorrelacaoServico(){
	if(document.formMapaDesenhoApoio.valorComboCorrelacaoSelecionadoMapaApoio.value>""){
		document.formMapaDesenhoApoio.fireEvent("addEPLCorrelacaoServico");
	}else{
		alert(i18n_message("mapaDesenhoServico.nenhumICSelecionado"));
	}
	
}

function addEplInformation(eplInformation){
	var eplInfoFrameCorrelacao = window.frames['iframeGerenteCorrelacao'].document.getElementById('idEplInformation');
	if(eplInfoFrameCorrelacao){
		if(eplInfoFrameCorrelacao.value != ""){
			eplInformation = "\r\n\r\n"+eplInformation;
		}
		eplInfoFrameCorrelacao.value += eplInformation;
	}
}

function addEplWarning(eplWarning){
	var eplWarningFrameCorrelacao = window.frames['iframeGerenteCorrelacao'].document.getElementById('idEplWarning');
	if(eplWarningFrameCorrelacao){
		if(eplWarningFrameCorrelacao.value != ""){
			eplWarning = "\r\n\r\n"+eplWarning;
		}
		eplWarningFrameCorrelacao.value += eplWarning;
	}
}

function addEplException(eplException){
	var eplExceptionFrameCorrelacao = window.frames['iframeGerenteCorrelacao'].document.getElementById('idEplException');
	if(eplExceptionFrameCorrelacao){
		if(eplExceptionFrameCorrelacao.value != ""){
			eplException = "\r\n\r\n"+eplException;
		}
		eplExceptionFrameCorrelacao.value += eplException;
	}
}

function onChangeComboCorrelacao() {
	var opcoes = [], opcao;
	
	for (var i=0; i<this.options.length; i++) {
		opcao = this.options[i];
		if ( opcao.selected ) {
			//Como o combo é multiplo, add os selecionados
			opcoes.push(opcao);
		}
	}
	//Apesar de ser possível múltiplas opções, iremos validar com apenas uma
	if(opcoes.length==1){
		document.formMapaDesenhoApoio.valorComboCorrelacaoSelecionadoMapaApoio.value = opcoes[0].value;
	}else{
		document.formMapaDesenhoApoio.valorComboCorrelacaoSelecionadoMapaApoio.value = "";
		alert(i18n_message("mapaDesenhoServico.selecioneUnicoItemConfiguracao"));
	}
};

function limpaFormCorrelacaoEventos(){
	document.formMapaDesenhoApoio.valorComboCorrelacaoSelecionadoMapaApoio.value = "";
	$('#comboCorrelacao').empty();
}

function excluirGerenteCorrelacaoAtual(){
	if(document.formMapaDesenhoApoio.idGerenteCorrelacaoEvmMapaApoio.value>""){
		document.formMapaDesenhoApoio.fireDelete("excluirGerenteCorrelacao");

		document.formMapaDesenhoApoio.idGerenteCorrelacaoEvmMapaApoio.value = "";
		limpaFormCorrelacaoEventos();
		
		defineFrameCorrelacao();
		
		carregaCorrelacaoServico();
	}else{
		alert(i18n_message("mapaDesenhoServico.semGerenteVinculado"));
	}
}

function exibirItemConfiguracaoApoio(){
	idItem = document.formMapaDesenhoApoio.idItemConfiguracaoMapaApoio.value;
	if(idItem == undefined || idItem == null || idItem == ""){
		notificacaoErro('gerenciamentoPortfolio.mapaNegocio.favorEscolhaItemConfiguracao');
		return;
	}

	document.getElementById('iframeInformacaoItemConfiguracaoApoio').src = URL_SISTEMA+'pages/gerenciamentoItemConfiguracao/gerenciamentoItemConfiguracao.load?iframe=true&iFramInformacaoItemConfiguracao=true&idInfoItem=' + idItem;
	Modal.open('modal-mapa-desenho-apoio-exibir-ic');
}

function fechaModalGerenteCorrelacao(){
	Modal.close('modal-mapa-desenho-apoio-gerente-correlacao');
}

function fecharModalImpactoServicoMapa(){
	$("#modal-impacto-servico-mapa").dialog("close");
}
