var mapaNegocio = null;


$(function() {
	if(document.formMapaDesenhoNegocio && document.form && document.form.idServicoNegocioAtual && document.form.idServicoNegocioAtual.value) {
		document.formMapaDesenhoNegocio.idServicoNegocioMapaNegocio.value = document.form.idServicoNegocioAtual.value;
		document.formMapaDesenhoNegocio.idPortfolioServicoMapaNegocio.value = document.form.idPortfolioServicoAtual.value;
		document.formMapaDesenhoNegocio.fireEvent("load");
	}
});

function atualizaLookupServicosApoio(idPortfolio, tipoServico, idServicoNegocio){
	document.formPesquisaServicoApoioMapaNegocio.pesqLockupLOOKUP_SERVICO_MAPA_NEGOCIO_serv_idPortfolioServico.value = idPortfolio;
	document.formPesquisaServicoApoioMapaNegocio.pesqLockupLOOKUP_SERVICO_MAPA_NEGOCIO_serv_tipoServico.value = "'"+tipoServico+"'";
	document.formPesquisaServicoApoioMapaNegocio.pesqLockupLOOKUP_SERVICO_MAPA_NEGOCIO_auto_idServicoRelacionado.value = idServicoNegocio;
	document.formPesquisaServicoApoioMapaNegocio.whereDinamico = " serv.idservico NOT IN (SELECT idservicoapoio from mapanegocioitem where idservicoapoio is not null and idserviconegocio = "+idServicoNegocio+") ";
}

function atualizaMapaNegocio(serealizado) {
	mapaNegocio = new CanvasMapaNegocio(document.getElementById("mapaNegocio"));
	mapaNegocio.configuraEventos();

	var lista = ObjectUtils.deserializeCollectionFromString(serealizado);
	var imgAux = null;
	var listaAux = [];
	for ( var i = 0; i < lista.length; i++) {
		imgAux = new MapaNegocioItemDTO(mapaNegocio.context, lista[i].icone);
		imgAux.idMapaNegocioItem = lista[i].idMapaNegocioItem;
		imgAux.posx = parseInt(lista[i].posx);
		imgAux.posy = parseInt(lista[i].posy);
		imgAux.idServicoNegocio = lista[i].idServicoNegocio;
		imgAux.idServicoApoio = lista[i].idServicoApoio;
		imgAux.idItemConfiguracao = lista[i].idItemConfiguracao;
		if(lista[i].serializacaoRelacoesDTO!= null && lista[i].serializacaoRelacoesDTO!= ""){
			var listRelacoesDTO = ObjectUtils.deserializeCollectionFromString(lista[i].serializacaoRelacoesDTO);
			for(var j = 0; j< listRelacoesDTO.length; j++){
				imgAux.arrayRelacoesDTO.push(listRelacoesDTO[j]);
			}
		}
		imgAux.descricao = lista[i].descricao;
		imgAux.titulo = lista[i].titulo;
		listaAux[i] = imgAux;
	}
	
	$(('#mapaNegocio')).resize(function() {
		mapaNegocio.redimensionaCanvas();
	});
	
	mapaNegocio.setListaItens(listaAux.slice());
	document.formMapaDesenhoNegocio.serializacaoItensMapaNegocio.value = "";
};

function finalizaExclusaoItemMapaNegocio(serializado) {
	atualizaMapaNegocio(serializado);
	mapaNegocio.salvarMapaNegocio();
	mapaNegocio.limparFecharPopup();
};

/**
 * Quando o item começar a ser arrastado algumas informações
 * serão salvas para serem recuperadas pelo Mapa.
 * @param e
 * Evento dragstart.
 */
function dragstart(e) {
	if (document.formMapaDesenhoNegocio.idServicoNegocioMapaNegocio.value != ""){
		e.dataTransfer.setData("text", e.target.getAttribute("id"));
	}
}

function abrePopupEditarServico(){
	Modal.open('modal-mapa-desenho-negocio-lookup-servicos');
}

/**
 * Limpa campos específicos.
 */
function limpaFormEditarServicoMapaNegocio() {
	document.formMapaDesenhoNegocio.idServicoApoioMapaNegocio.value = "";

	document.formEditarServicoMapaNegocio.clear();
};

function limpaFormEditarICMapaNegocio() {
	$('#btGerentesICMapaNegocio').css('display', 'none');

	document.formMapaDesenhoNegocio.idItemConfiguracaoMapaNegocio.value = "";

	document.formEditarICMapaNegocio.clear();
}

function onHideModalMapaDesenhoNegocioIC() {
	limpaFormEditarICMapaNegocio();
	
	document.getElementById('iframeInventoryMapaNegocio').src = '';
	document.getElementById('iframeZabbixMapaNegocio').src = '';
	document.getElementById('iframeNagiosMapaNegocio').src = '';
}

function LOOKUP_SERVICO_MAPA_NEGOCIO_select(id, desc) {
	var camposLookupItem = desc.split("-");
	document.formMapaDesenhoNegocio.idServicoApoioMapaNegocio.value = id;
	document.formEditarServicoMapaNegocio.nomeServicoPopupEditarServico.value = camposLookupItem[0];
	document.formMapaDesenhoNegocio.fireEvent("servicoApoioSelecionado");
	Modal.close('modal-mapa-desenho-negocio-lookup-servicos')
};

function openDialogFramePesquisaICMapaNegocio() {
	limparAbasEvmGerentesMapaNegocio();
	document.getElementById('framePesquisaICMapaNegocio').src = ctx + "/pages/pesquisaItemConfiguracao/pesquisaItemConfiguracao.load?iframe=true&funcaoPaiFrame=recebeICMapaNegocio";
	Modal.open('modal-mapa-desenho-negocio-pesquisar-ic');
};

//Função chamada pelo frame pesquisaItemConfiguracao(nome passado pelo parametro da url).
function recebeICMapaNegocio(idIC){
	limpaFormEditarICMapaNegocio();

	document.formMapaDesenhoNegocio.idItemConfiguracaoMapaNegocio.value = idIC;

	JANELA_AGUARDE_MENU.show();
	document.formMapaDesenhoNegocio.fireEvent("itemConfiguracaoSelecionado");

	Modal.close('modal-mapa-desenho-negocio-pesquisar-ic');
}

function depoisSelecionarICMapaNegocio(identificacaoIC){
	document.formEditarICMapaNegocio.nomeICPopupEditarIC.value = identificacaoIC;
}

function limparAbasEvmGerentesMapaNegocio(){
	//Zera o conteúdo de todos os frames
	document.getElementById('iframeInventoryMapaNegocio').contentWindow.document.write("");
	document.getElementById('iframeZabbixMapaNegocio').contentWindow.document.write("");
	document.getElementById('iframeNagiosMapaNegocio').contentWindow.document.write("");
	
	//Nenhuma aba fica escolhida
	document.getElementById("li_inventory_mapanegocio").className = "";
	document.getElementById("li_zabbix_mapanegocio").className = "";
	document.getElementById("li_nagios_mapanegocio").className = "";
}

function abaInventoryMapaNegocio(idGerente, idIC){
	JANELA_AGUARDE_MENU.show();
	limparAbasEvmGerentesMapaNegocio();

	var url = ctx + '/pages/evmGerenteInventory/evmGerenteInventory.load?iframe=true&iframeNoSearchNoEditICPai=true&fecharJanelaAguardePai=S';

	if(idGerente>"") {
		 url += '&idGerenteEvm='+ idGerente;
	}

	if(idIC>"") {
		 url += '&idItemConfiguracaoPai='+ idIC;
	}else{
		if(document.formMapaDesenhoNegocio.idItemConfiguracaoMapaNegocio.value>""){
			url += '&idItemConfiguracaoPai=' + document.formMapaDesenhoNegocio.idItemConfiguracaoMapaNegocio.value;
		}
	}
	
	document.getElementById('iframeInventoryMapaNegocio').src = url;

	$('.tabsbar a[href="#tabInventoryMapaNegocio"]').tab('show');
}

function abaZabbixMapaNegocio(idGerente, idIC){
	JANELA_AGUARDE_MENU.show();
	limparAbasEvmGerentesMapaNegocio();

	var url = ctx + '/pages/evmGerenteZabbix/evmGerenteZabbix.load?iframe=true&iframeNoSearchNoEditICPai=true&fecharJanelaAguardePai=S';
	
	if(idGerente>"") {
		 url += '&idGerenteEvm='+ idGerente;
	}
	
	if(idIC>"") {
		 url += '&idItemConfiguracaoPai='+ idIC;
	}else{
		if(document.formMapaDesenhoNegocio.idItemConfiguracaoMapaNegocio.value>""){
			url += '&idItemConfiguracaoPai=' + document.formMapaDesenhoNegocio.idItemConfiguracaoMapaNegocio.value;
		}
	}

	document.getElementById('iframeZabbixMapaNegocio').src = url;

	$('.tabsbar a[href="#tabZabbixMapaNegocio"]').tab('show');
}

function abaNagiosMapaNegocio(idGerente, idIC){
	JANELA_AGUARDE_MENU.show();
	limparAbasEvmGerentesMapaNegocio();

	var url = ctx + '/pages/evmGerenteNagios/evmGerenteNagios.load?iframe=true&iframeNoSearchNoEditICPai=true&fecharJanelaAguardePai=S';
	
	if(idGerente>"") {
		 url += '&idGerenteEvm=' + idGerente;
	}
	
	if(idIC>"") {
		 url += '&idItemConfiguracaoPai=' + idIC;
	}else{
		if(document.formMapaDesenhoNegocio.idItemConfiguracaoMapaNegocio.value>""){
			url += '&idItemConfiguracaoPai=' + document.formMapaDesenhoNegocio.idItemConfiguracaoMapaNegocio.value;
		}
	}

	document.getElementById('iframeNagiosMapaNegocio').src = url;

	$('.tabsbar a[href="#tabNagiosMapaNegocio"]').tab('show');
}

function abrePopupGerentesMapaNegocio(){
	notificacaoI18N("mapaNegocio.multiplosGerentes", '');
	Modal.open('modal-mapa-desenho-negocio-escolher-gerente-evm');
}

function gerenteEscolhido(idGerente, idIC, ferramenta){
	Modal.close('modal-mapa-desenho-negocio-escolher-gerente-evm');

	switch (ferramenta) {
		case "CITSMART_INVENTORY":
			abaInventoryMapaNegocio(idGerente, idIC);
		break;
		case "ZABBIX":
			abaZabbixMapaNegocio(idGerente, idIC);
		break;
		case "NAGIOS":
			abaNagiosMapaNegocio(idGerente, idIC);
		break;
	}
}

function onClickBtGerentesEvm(){
	limparAbasEvmGerentesMapaNegocio();
	document.formMapaDesenhoNegocio.fireEvent("buscarGerentesIC");
}

function exibirItemConfiguracaoNegocio(){
	idItem = document.formMapaDesenhoNegocio.idItemConfiguracao.value;
	if(idItem == undefined || idItem == null || idItem == ""){
		notificacaoErro('gerenciamentoPortfolio.mapaNegocio.favorEscolhaItemConfiguracao');
		return;
	}

	document.getElementById('iframeInformacaoItemConfiguracaoNegocio').src = URL_SISTEMA+'pages/gerenciamentoItemConfiguracao/gerenciamentoItemConfiguracao.load?iframe=true&iFramInformacaoItemConfiguracao=true&idInfoItem=' + idItem;
	Modal.open('modal-mapa-desenho-negocio-exibir-ic');
}
