$(function() {
	$("#tabsServico span[href='#auditoriaServico']").on('click', function(ev){
		PortfolioOcorrencias.gerarOcorrencias();
	});
	
	document.formPortfolioOcorrenciasServico.idServico.value = document.form.idServicoNegocioAtual.value;
	document.formPortfolioOcorrenciasServico.fireEvent("load");
});

var PortfolioOcorrencias = {
	abreFechaMaisInformacoes: function(btClick) {
		var idOcorrencia = btClick.closest('tr').getAttribute('id');
		if ($(btClick).hasClass("circle_plus")) {
			$("#maisInfo"+idOcorrencia).show("fast");
			$(btClick).removeClass("circle_plus");
			$(btClick).addClass("circle_minus");
			$(btClick).attr("onmouseover", "abreTooltip(this, '"+i18n_message("citcorpore.comum.esconderInformações")+"')");
		} else {
			$(btClick).removeClass("circle_minus");
			$(btClick).addClass("circle_plus");
			$(btClick).attr("onmouseover", "abreTooltip(this, '"+i18n_message("citcorpore.comum.visualizarMaisInformações")+"')");
			$("#maisInfo"+idOcorrencia).hide("fast");
		}
	},
	
	gerarOcorrencias: function() {
		document.formPortfolioOcorrenciasServico.fireEvent("montarHTMLOcorrencia");
	},
	
	gravar: function() {
		if(document.formPortfolioOcorrenciasServico.save()) {
			JANELA_AGUARDE_MENU.show();
		}
		this.limparCadastro();
		JANELA_AGUARDE_MENU.hide();
	},
	
	limparCadastro: function() {
		document.formPortfolioOcorrenciasServico.descricaoOcorrencia.value = "";
		document.formPortfolioOcorrenciasServico.categoriaOcorrenciaServico.value = "";
	},
	
	depoisMontarHTMLOcorrencia: function(){
		JANELA_AGUARDE_MENU.hide();
		
		$('#divOcorrenciasPortfolioRegistradas').show("blind", "fast",	function(){});
	},
	
	limpaFiltroOcorrenciaServico: function() {
		document.formPortfolioOcorrenciasServico.categoriaFiltroOcorrenciaServico.value = "";
		document.formPortfolioOcorrenciasServico.dataFiltroInicioOcorrenciaServico.value = null;
		document.formPortfolioOcorrenciasServico.dataFiltroFimOcorrenciaServico.value = null;
		this.gerarOcorrencias();
	},
	
	filtrarOcorrenciaServico: function() {
		if (!DEFINEALLPAGES_validarElement(document.formPortfolioOcorrenciasServico.dataFiltroInicioOcorrenciaServico) || 
				!DEFINEALLPAGES_validarElement(document.formPortfolioOcorrenciasServico.dataFiltroFimOcorrenciaServico)) {
			return false;
		}
		
		this.gerarOcorrencias();
	},
	
	paginarOcorrenciaServico: function(paginaSelecionadaOcorrenciaServico) {
		$('#divOcorrenciasPortfolioRegistradas').hide("blind", "fast",	function(){
			JANELA_AGUARDE_MENU.show();
			document.formPortfolioOcorrenciasServico.paginaSelecionadaOcorrenciaServico.value = paginaSelecionadaOcorrenciaServico;
			PortfolioOcorrencias.gerarOcorrencias();
		});
	}
} 