_TECLA_ENTER = 13;
_SIM = 'S';
_NAO = 'N';
_OCORRENCIA_SERVICO_ACAO_ALTERAR = "A";

$(function() {
	$("#inputFiltroProcessoNegocio").keyup(function(event) {
		if (event.which == _TECLA_ENTER) {
			VincularProcessoNegocio.changeFiltroProcessoNegocio($(event.currentTarget).val());
		}
	});
	
	document.formVincularProcessoNegocio.idServico.value = document.form.idServicoNegocioAtual.value;
	document.formVincularProcessoNegocio.fireEvent("load");
});

var VincularProcessoNegocio = {
	abrirPopup: function() {
		limpar_LOOKUP_SERVICO_VINCULAR_PROCESSO_NEGOCIO();
		
		// Lista dos ids dos processos negocios vinculados
		var idsProcessosNegocioVinculados = this.getListaIdsProcessosNegocioVinculados();
		
		// Se tiver alguma unidade vinculada acrescenta uma condição na lookup para que elas não sejam exibidas
		if(idsProcessosNegocioVinculados.length > 0) {
			document.formLookupServicoVincularProcessoNegocio.whereDinamico = "idprocessonegocio not in ("+ idsProcessosNegocioVinculados+")";
		} else {
			document.formLookupServicoVincularProcessoNegocio.whereDinamico = "";
		}
		
		Modal.open("modal-portfolio-vincular-processo-negocio");
	},
	
	fecharPopup: function() {
		Modal.close("modal-portfolio-vincular-processo-negocio");
		this.atualizarListaIdsProcessosNegocioVinculados();
	},
	
	desvincularProcessoNegocioFromServico : function(btClick){
		if (permissaoGravar) {
			if (confirm(i18n_message("gerenciaportfolio.desejaDesvincularProcessoNegocio"))) {
				
				var trTable = btClick.closest('tr');
				var idProcessoNegocio = trTable.getAttribute('id');
				
				trTable.remove();
				
				// esconde o tooltip do botão desvincular
				fechaTooltip();
				
				// remove o processo negócio da lista de vinculados atualiza a lista
				document.formVincularProcessoNegocio.listaIdsProcessosNegocioVinculados.value = document.formVincularProcessoNegocio.listaIdsProcessosNegocioVinculados.value.replace(idProcessoNegocio+";", "");
				
				document.formVincularProcessoNegocio.idProcessoNegocio.value = idProcessoNegocio;
				document.formVincularProcessoNegocio.fireUpdate("desvincularProcessoNegocioFromServico");
				
				if($("#divDinamicoListaProcessosNegocio tbody tr").length < 1) {
					$("#divDinamicoListaProcessosNegocio").html("");
				}
			}
		} else {
			notificacaoErro('citcorpore.comum.permissaoFuncionalidade','');
		}
	},	
	
	getListaIdsProcessosNegocioVinculados: function() {
		var idsProcessosNegocioVinculados = document.formVincularProcessoNegocio.listaIdsProcessosNegocioVinculados.value.split(";");
		idsProcessosNegocioVinculados = idsProcessosNegocioVinculados.slice(0, idsProcessosNegocioVinculados.length-1);
		return idsProcessosNegocioVinculados;
	},
	
	atualizarListaIdsProcessosNegocioVinculados: function() {
		document.formVincularProcessoNegocio.listaIdsProcessosNegocioVinculados.value = document.formVincularProcessoNegocio.listaIdsProcessosNegocioVinculados.value + document.formVincularProcessoNegocio.colAllLOOKUP_SERVICO_VINCULAR_PROCESSO_NEGOCIO.value;
	},
	
	depoisMontarHTMLProcessoNegocio: function(){
		JANELA_AGUARDE_MENU.hide();
		
		$('#divDinamicoListaProcessosNegocio').show("blind", "fast",	function(){});
	},
	
	limpaFiltroProcessoNegocio: function() {
		$("#inputFiltroProcessoNegocio").val("");
		this.changeFiltroProcessoNegocio("");
	},

	filtrarProcessoNegocio: function() {
		this.changeFiltroProcessoNegocio($("#inputFiltroProcessoNegocio").val());
	},
	
	changeFiltroProcessoNegocio: function(filtroProcessoNegocio) {
		document.formVincularProcessoNegocio.filtroProcessoNegocio.value = filtroProcessoNegocio;
		document.formVincularProcessoNegocio.paginaSelecionadaProcessoNegocio.value = 0;
		this.carregarTabelaProcessoNegocio();
	},
	
	paginarProcessoNegocio: function(paginaSelecionadaNegocio) {
		$('#divDinamicoListaProcessosNegocio').hide("blind", "fast",	function(){
			JANELA_AGUARDE_MENU.show();
			document.formVincularProcessoNegocio.paginaSelecionadaProcessoNegocio.value = paginaSelecionadaNegocio;
			// não pode usar o this pois essa função é adicionada no html
			VincularProcessoNegocio.carregarTabelaProcessoNegocio();
		});
	},
	
	carregarTabelaProcessoNegocio: function() {
		document.formVincularProcessoNegocio.fireEvent("montarHTMLProcessoNegocio");
	},
	
	abrirPopupProcessoNegocio: function(idProcessoNegocio){
		document.formProcessoNegocio.fireEvent("load");
		document.formVincularProcessoNegocio.idProcessoNegocio.value = parseInt(idProcessoNegocio);
		document.formVincularProcessoNegocio.fireEvent("visualizarProcessoNegocio");
		Modal.open('modal-portfolio-visualizar-processo-negocio');
	},
	
	abrirPopupNovoProcessoNegocio: function(isEditar){
		if(!isEditar) {
			document.formProcessoNegocio.clear();
			document.formProcessoNegocio.fireEvent("load");
		}
		Modal.open("modal-portfolio-cadastrar-processo-negocio");
		$("#modal-portfolio-cadastrar-processo-negocio .tabsbar").css("display", "none");
		$("#modal-portfolio-cadastrar-processo-negocio button[name='btnExcluir']").css("display", "none");
		$("#modal-portfolio-cadastrar-processo-negocio .widget-collapse").attr('data-toggle', '');
		
		document.formProcessoNegocio.afterSave = function() {
			Modal.close("modal-portfolio-cadastrar-processo-negocio");
			$("#modal-portfolio-cadastrar-processo-negocio .tabsbar").css("display", "block");
			$("#modal-portfolio-cadastrar-processo-negocio button[name='btnExcluir']").css("display", "block");
			$("#modal-portfolio-cadastrar-processo-negocio .widget-collapse").attr('data-toggle', 'collapse-widget');

			if(!isEditar) {
				document.formVincularProcessoNegocio.colAllLOOKUP_SERVICO_VINCULAR_PROCESSO_NEGOCIO.value = document.formProcessoNegocio.idProcessoNegocio.value + ";";
				document.formVincularProcessoNegocio.fireEvent("vincularProcessosNegocioAoServico");
			} else {
				VincularProcessoNegocio.carregarTabelaProcessoNegocio();
				document.formVincularProcessoNegocio.acaoProcessoNegocioOcorrenciaServico.value = _OCORRENCIA_SERVICO_ACAO_ALTERAR;
				document.formVincularProcessoNegocio.idsProcessoNegocioOcorrenciaServico.value = document.formVincularProcessoNegocio.idProcessoNegocio.value;
				document.formVincularProcessoNegocio.fireInsert("salvarOcorrenciaServicoProcessoNegocio");
			}
			
			JANELA_AGUARDE_MENU.hide();
		}
	},

	editarProcessoNegocio: function() {
		this.abrirPopupNovoProcessoNegocio(true);
		Modal.close('modal-portfolio-visualizar-processo-negocio');
		var idStr = document.formVincularProcessoNegocio.idProcessoNegocio.value.toString();
		document.formProcessoNegocio.restore({
			idProcessoNegocio : idStr
		});
	}
}