_TIPO_SERVICO_REQUISICAO = "R"; //br.com.centralit.citcorpore.util.Enumerados.TipoServico.SERVICO_REQUISICAO
_TIPO_SERVICO_INCIDENTE = "I"; //br.com.centralit.citcorpore.util.Enumerados.TipoServico.SERVICO_INCIDENTE
_TIPO_SERVICO_PROCEDIMENTO = "P"; //br.com.centralit.citcorpore.util.Enumerados.TipoServico.SERVICO_PROCEDIMENTO

$(document.formVinculoServicoContrato).ready(function() {
	carregaRadioExpandir();
	carregaRadioReinicia();
});

function reloadFormVinculoServicoContrato(){
	// Força a arquitetura a recarregar os forms
	DEFINEALLPAGES_atribuiCaracteristicasCitAjax();

	definirAftersVinculoServicoContrato();

	$('.datepicker').removeClass('hasDatepicker').datepicker();
	
	setCheckedExpandirN();
	carregaRadioExpandir();
	carregaRadioReinicia();
}

$(function() {

	$("#inputFiltroServicoRequisicaoContrato").keyup(function(event) {
		if (event.which == _TECLA_ENTER) {
			changeFiltroServicoRequisicaoContrato($(event.currentTarget).val());
		}
	});

	$("#inputFiltroServicoIncidenteContrato").keyup(function(event) {
		if (event.which == _TECLA_ENTER) {
			changeFiltroServicoIncidenteContrato($(event.currentTarget).val());
		}
	});
	
	$("#inputFiltroServicoProcedimentoContrato").keyup(function(event) {
		if (event.which == _TECLA_ENTER) {
			changeFiltroServicoProcedimentoContrato($(event.currentTarget).val());
		}
	});

	definirAftersVinculoServicoContrato();
});

function definirAftersVinculoServicoContrato(){
	document.formVinculoServicoContrato.afterRestore = function() {
		mostraDivNomeServicoVinculo();

		if(Modal.isOpen('modal-portfolio-vinculo-servico-req-inc-contrato')){
			JANELA_AGUARDE_MENU.hide();
		}else{
			JANELA_AGUARDE_MENU.hide();
			$('#divServicoReqIncOSInfo').show("slide", { direction: "right" }, "fast",	function(){});
		}
	}
	
	document.formVinculoServicoContrato.afterSave = function() {
		JANELA_AGUARDE_MENU.hide();
	}
}

function gravarVinculoServicoContrato(){
	//Ao salvar, é precisso passar a lista de fluxos do form 'formVinculoServicoContratoFluxo' para o form 'formVinculoServicoContrato', para conseguir pegar no DTO no java.
	document.formVinculoServicoContrato.listaFluxosSerializados.value = document.formVinculoServicoContratoFluxo.listaTempFluxosSerializados.value;
	document.formVinculoServicoContrato.save();
}

function limparVinculoServicoContrato(){	
	var valoresAntes = valoresAntesLimparFormVincServContrato();
	
	$('#divDinamicoListaServicosVincular').html('');
	$('#divDinamicoFluxoServico').html('');
	document.formVinculoServicoContrato.clear();
	document.formVinculoServicoContratoFluxo.clear();
	limpar_LOOKUP_SERVICOS_VINCULAR_CONTRATO();
	
	setCheckedExpandirN();
	setCheckedReiniciaN();
	
	depoisLimparFormVincServContrato(valoresAntes);
}

/*
function excluirVinculoServicoContrato() {
	if (document.formVinculoServicoContrato.idServico.value != "" && confirm(i18n_message("citcorpore.comum.deleta"))) {
		document.formVinculoServicoContrato.fireDelete("excluir");
	}
}
*/

var valoresAntesLimparFormVincServContrato = function(){  
	/*Limpará todos os campos, exceto estes que não existirá campo específico: */
	var idContrato = document.formVinculoServicoContrato.idContratoVinculo.value;
	var idServicoRelacionado = document.formVinculoServicoContrato.idServicoRelacionadoVinculo.value;
	var idPortfolio = document.formVinculoServicoContrato.idPortfolioServicoVinculo.value;
	var paginaSelecionadaRequisicao = document.formVinculoServicoContrato.paginaSelecionadaRequisicaoVinculo.value;
	var filtroServicoRequisicao = document.formVinculoServicoContrato.filtroServicoRequisicaoVinculo.value;
	var paginaSelecionadaIncidente = document.formVinculoServicoContrato.paginaSelecionadaIncidenteVinculo.value;
	var filtroServicoIncidente = document.formVinculoServicoContrato.filtroServicoIncidenteVinculo.value;
	var isEditar = document.formVinculoServicoContrato.editar.value;

	return {
		idContrato: idContrato,
		idServicoRelacionado: idServicoRelacionado,
		idPortfolio: idPortfolio,
		paginaSelecionadaRequisicao: paginaSelecionadaRequisicao,
		filtroServicoRequisicao: filtroServicoRequisicao,
		paginaSelecionadaIncidente: paginaSelecionadaIncidente,
		filtroServicoIncidente: filtroServicoIncidente,
		isEditar: isEditar
	};
};

function depoisLimparFormVincServContrato(valoresAntes){
	document.formVinculoServicoContrato.idContratoVinculo.value = valoresAntes.idContrato;
	document.formVinculoServicoContrato.idServicoRelacionadoVinculo.value = valoresAntes.idServicoRelacionado;
	document.formVinculoServicoContrato.idPortfolioServicoVinculo.value = valoresAntes.idPortfolio;
	document.formVinculoServicoContrato.paginaSelecionadaRequisicaoVinculo.value = valoresAntes.paginaSelecionadaRequisicao;
	document.formVinculoServicoContrato.filtroServicoRequisicaoVinculo.value = valoresAntes.filtroServicoRequisicao;
	document.formVinculoServicoContrato.paginaSelecionadaIncidenteVinculo.value = valoresAntes.paginaSelecionadaIncidente;
	document.formVinculoServicoContrato.filtroServicoIncidenteVinculo.value = valoresAntes.filtroServicoIncidente;
	document.formVinculoServicoContrato.editar.value = valoresAntes.isEditar;
}

function vincularServicoRequisicaoContrato(isEditar){
	$('#buttonListaServicosContratos').attr("onclick", "abreLookupListaServicosContrato('"+_TIPO_SERVICO_REQUISICAO+"')");
	abrePopupVinculoServicosContrato(_TIPO_SERVICO_REQUISICAO);
	if(!isEditar) {
		document.formVinculoServicoContrato.editar.value = "N";
		carregaListaServicosVincularContrato(_TIPO_SERVICO_REQUISICAO);
	}
}

function vincularServicoIncidenteContrato(isEditar){
	$('#buttonListaServicosContratos').attr("onclick", "abreLookupListaServicosContrato('"+_TIPO_SERVICO_INCIDENTE+"')");
	abrePopupVinculoServicosContrato(_TIPO_SERVICO_INCIDENTE);
	if(!isEditar) {
		document.formVinculoServicoContrato.editar.value = "N";
		carregaListaServicosVincularContrato(_TIPO_SERVICO_INCIDENTE);
	}
}

function vincularServicoProcedimentoContrato(isEditar){
	$('#buttonListaServicosContratos').attr("onclick", "abreLookupListaServicosContrato('"+_TIPO_SERVICO_PROCEDIMENTO+"')");
	abrePopupVinculoServicosContrato(_TIPO_SERVICO_PROCEDIMENTO);
	if(!isEditar) {
		document.formVinculoServicoContrato.editar.value = "N";
		carregaListaServicosVincularContrato(_TIPO_SERVICO_PROCEDIMENTO);
	}
}

function carregaListaServicosVincularContrato(tipoServico) {
	document.formVinculoServicoContrato.tipoServico.value = tipoServico;
	document.formVinculoServicoContrato.idServicoRelacionado.value = getServicoRelacionado();
	document.formVinculoServicoContrato.idPortfolioServico.value = getPortfolioServico();
	
	document.formVinculoServicoContrato.fireEvent("carregaListaServicosVincularContrato");
}

function abrePopupVinculoServicosContrato(tipoServico){
	var valoresAntes = valoresAntesLimparFormVincServContrato();

	limparVinculoServicoContrato();

	var htmlDivFormVinculo = $('#divFormularioVinculoServicoContrato').html();

	$('#divFormularioVinculoServicoContrato').html('');
	$("#modal-portfolio-vinculo-servico-req-inc-contrato .modal-body").html(htmlDivFormVinculo);

	reloadFormVinculoServicoContrato();

	depoisLimparFormVincServContrato(valoresAntes);
	document.formVinculoServicoContrato.tipoServico.value = tipoServico;

	mostraDivListaServicosVinculo();
	
	Modal.open('modal-portfolio-vinculo-servico-req-inc-contrato');
	Modal.oneHidden('modal-portfolio-vinculo-servico-req-inc-contrato', beforeCloseVincularServicoReqIncContrato);
	
	var title = "";
	if (tipoServico == _TIPO_SERVICO_REQUISICAO) {
		title = "gerenciaportfolio.vincular.servicoRequisicao";
		$("#titleListaServicosContrato").text(i18n_message("gerenciaportfolio.tipoDemanda.requisicao"));
		$("#divCustoServico").show();
	} else if (tipoServico == _TIPO_SERVICO_INCIDENTE) {
		title = "gerenciaportfolio.vincular.servicoIncidente";
		$("#titleListaServicosContrato").text(i18n_message("gerenciaportfolio.tipoDemanda.incidente"));
		$("#divCustoServico").show();
	} else if (tipoServico == _TIPO_SERVICO_PROCEDIMENTO) {
		title = "gerenciaportfolio.vincular.servicoProcedimento";
		$("#titleListaServicosContrato").text(i18n_message("gerenciaportfolio.tipoDemanda.procedimento"));
		$("#divCustoServico").hide();
	}
	
	$("#modal-portfolio-vinculo-servico-req-inc-contrato .modal-header h3.title").text(i18n_message(title));
}

function beforeCloseVincularServicoReqIncContrato(){
	document.formVinculoServicoContrato.idServicoRelacionadoVinculo.value = getServicoRelacionado();
	var valoresAntes = valoresAntesLimparFormVincServContrato();
	var tipoServico = document.formVinculoServicoContrato.tipoServico.value;

	limparVinculoServicoContrato();

	var htmlPOPUP = $('#modal-portfolio-vinculo-servico-req-inc-contrato .modal-body').html();
	
	$('#modal-portfolio-vinculo-servico-req-inc-contrato .modal-body').html('');
	
	$("#divFormularioVinculoServicoContrato").html(htmlPOPUP);
	
	reloadFormVinculoServicoContrato();

	depoisLimparFormVincServContrato(valoresAntes);
	
	document.formVinculoServicoContrato.tipoServico.value = tipoServico;

	mostraDivNomeServicoVinculo();
	
	JANELA_AGUARDE_MENU.show();

	$('#divDinamicoListaServicosRequisicaoContrato').hide("blind", "fast",	function(){
		document.formVinculoServicoContrato.tipoServico.value = _TIPO_SERVICO_REQUISICAO;
		document.formVinculoServicoContrato.fireEvent("carregaTabelaServicosRequisicaoContrato");
	});

	$('#divDinamicoListaServicosIncidenteContrato').hide("blind", "fast",	function(){
		document.formVinculoServicoContrato.tipoServico.value = _TIPO_SERVICO_INCIDENTE;
		document.formVinculoServicoContrato.fireEvent("carregaTabelaServicosIncidenteContrato");
	});
	
	$('#divDinamicoListaServicoProcedimentoContrato').hide("blind", "fast",	function(){
		document.formVinculoServicoContrato.tipoServico.value = _TIPO_SERVICO_PROCEDIMENTO;
		document.formVinculoServicoContrato.fireEvent("carregaTabelaServicosProcedimentoContrato");
	});
}

function fecharPopupVincularServicoReqIncContrato() {
	if(Modal.isOpen('modal-portfolio-vinculo-servico-req-inc-contrato')){
		Modal.close('modal-portfolio-vinculo-servico-req-inc-contrato');
	}
}

function editarServicoRequisicaoContrato(obj, idContrato, idServico) {
	document.formVinculoServicoContrato.editar.value = "S";
	vincularServicoRequisicaoContrato(true);
	restoreVinculoServicoContrato(idContrato, idServico);
	atualizaListaIdsStrServicosContratoVinculados(idServico);
}

function editarServicoIncidenteContrato(obj, idContrato, idServico) {
	document.formVinculoServicoContrato.editar.value = "S";
	vincularServicoIncidenteContrato(true);
	restoreVinculoServicoContrato(idContrato, idServico);
	atualizaListaIdsStrServicosContratoVinculados(idServico);
}

function editarServicoProcedimentoContrato(obj, idContrato, idServico) {
	document.formVinculoServicoContrato.editar.value = "S";
	vincularServicoProcedimentoContrato(true);
	restoreVinculoServicoContrato(idContrato, idServico);
	atualizaListaIdsStrServicosContratoVinculados(idServico);
}

function abreLookupListaServicosContrato(tipoServico) {

	if((tipoServico == _TIPO_SERVICO_REQUISICAO) || (tipoServico == _TIPO_SERVICO_INCIDENTE) || (tipoServico == _TIPO_SERVICO_PROCEDIMENTO)){

		limpar_LOOKUP_SERVICOS_VINCULAR_CONTRATO();
		
		//métodos em gerenciamentoPorfolio.js
		var idServicoRelacionado = getServicoRelacionado();
		var idPortfolio = getPortfolioServico();
		var idContrato = document.formVinculoServicoContrato.idContratoVinculo.value;

		// Alterações nos filtros do formLookupServicosVincularContrato também deverão ser realizadas no método br.com.centralit.citcorpore.integracao.ServicoAutoRelacionamentoDao.listIdsServicosRelacionadosVincularContrato
		//Where para não listar os serviços já vinculados ao contrato
		document.formLookupServicosVincularContrato.whereDinamico = " serv.idservico NOT IN (SELECT idservico FROM servicocontrato WHERE idservico = serv.idservico and idcontrato = "+idContrato+" and (upper(deleted) = 'N' OR deleted is null) ) ";
		var idsServicosJaVinculados = getListaIdsServicosContratoVinculados();
		
		if(idsServicosJaVinculados && idsServicosJaVinculados.length > 0) {
			document.formLookupServicosVincularContrato.whereDinamico += " AND serv.idservico NOT IN ("+idsServicosJaVinculados+")";
		}
		
		document.formLookupServicosVincularContrato.pesqLockupLOOKUP_SERVICOS_VINCULAR_CONTRATO_serv_idPortfolioServico.value = idPortfolio;
		document.formLookupServicosVincularContrato.pesqLockupLOOKUP_SERVICOS_VINCULAR_CONTRATO_serv_tipoServico.value = "'"+tipoServico+"'";
		document.formLookupServicosVincularContrato.pesqLockupLOOKUP_SERVICOS_VINCULAR_CONTRATO_auto_idServicoRelacionado.value = "'"+idServicoRelacionado+"'";
		
		var title = "";
		if (tipoServico == _TIPO_SERVICO_REQUISICAO) {
			title = "gerenciaportfolio.vincular.servicoRequisicao";
		} else if (tipoServico == _TIPO_SERVICO_INCIDENTE) {
			title = "gerenciaportfolio.vincular.servicoIncidente";
		} else if (tipoServico == _TIPO_SERVICO_PROCEDIMENTO) {
			title = "gerenciaportfolio.vincular.servicoProcedimento";
		}
		
		$("#modal-portfolio-servicos-vincular-contrato h3.title").text(i18n_message(title));

		Modal.open('modal-portfolio-servicos-vincular-contrato');
	}

}

function depoisVincularListaServicosRequisicao(){
	Modal.close('modal-portfolio-servicos-vincular-contrato');
}

function desvincularServicoReqIncContrato(obj, idContrato, idServico, tipoServico){
	if (idContrato > "" && idServico > "" && confirm(i18n_message("gerenciaportfolio.desejaDesvincularServico"))) {
		document.formVinculoServicoContrato.idServicoSelecionado.value = idServico;
		document.formVinculoServicoContrato.tipoServico.value = tipoServico;
		JANELA_AGUARDE_MENU.show();
		document.formVinculoServicoContrato.fireUpdate("desvincularServicoReqIncContrato");
		document.formVinculoServicoContrato.idServicoSelecionado.value = "";
	}
}

function removerServicoAVincular(obj){
	var listaIdsServicosVinculados = document.formVinculoServicoContrato.listaIdsStrServicosContratoVinculados.value;
	
	if(listaIdsServicosVinculados){
		var linhaTabela = obj.closest('tr');
		
		listaIdsServicosVinculados = listaIdsServicosVinculados.replace($(linhaTabela).attr('data-idservico')+",", "");
		
		if(listaIdsServicosVinculados.length>0){
			linhaTabela.remove();
		}else{
			$('#tabelaServicosVincular').remove();
		}
		
		document.formVinculoServicoContrato.listaIdsStrServicosContratoVinculados.value = listaIdsServicosVinculados;
	}
}

function abrePopupFluxoServico(){
	Modal.open('modal-portfolio-vinculo-contrato-add-fluxo');
}

function gravarFluxoVinculoServicoContrato(){
	document.formVinculoServicoContratoFluxo.fireInsert("gravarFluxo");
}

function depoisGravarFluxo(listaFluxo){
	setaListaFluxo(listaFluxo);

	if(document.formVinculoServicoContratoFluxo.idTipoFluxoVinculo[0])
		document.formVinculoServicoContratoFluxo.idTipoFluxoVinculo[0].selected = true;
	
	if(document.formVinculoServicoContratoFluxo.idFaseVinculo[0])
		document.formVinculoServicoContratoFluxo.idFaseVinculo[0].selected = true;

	if(document.formVinculoServicoContratoFluxo.principalVinculo[0])
		document.formVinculoServicoContratoFluxo.principalVinculo[0].selected = true;

	Modal.close('modal-portfolio-vinculo-contrato-add-fluxo');
}

function setaListaFluxo(listaFluxo){
	//A lista é temporária pois quando gravar, vai passar do formVinculoServicoContratoFluxo para o formVinculoServicoContrato
	document.formVinculoServicoContratoFluxo.listaTempFluxosSerializados.value = listaFluxo;
}

function removerFluxoServico(obj){
	var listaFluxosSerializados = document.formVinculoServicoContratoFluxo.listaTempFluxosSerializados.value;
	
	if(listaFluxosSerializados){
		var listaFluxos = ObjectUtils.deserializeCollectionFromString(listaFluxosSerializados);
		
		if(listaFluxos){
			var linhaTabela = obj.closest('tr');
			
			var indiceSelecionado = (linhaTabela.rowIndex-1);
			
			listaFluxos.splice(indiceSelecionado, 1);
			
			document.formVinculoServicoContratoFluxo.listaTempFluxosSerializados.value = ObjectUtils.serializeObjects(listaFluxos);
			
			if(listaFluxos.length>0){
				linhaTabela.remove();
			}else{
				$('#tabelaFluxoServico').remove();
			}
		}
	}
}

function carregaRadioExpandir(){
	var rad = document.formVinculoServicoContrato.radioExpandirTela;
	var prev = null;
	for(var i = 0; i < rad.length; i++) {
		rad[i].onclick = function() {
		if(this !== prev) {
			prev = this;
		}
			onChangeRadioExpandir(this.value);
		};
	}
}

function carregaRadioReinicia(){
	var rad = document.formVinculoServicoContrato.reiniciaSlaRadio;
	var prev = null;
	for(var i = 0; i < rad.length; i++) {
		rad[i].onclick = function() {
		if(this !== prev) {
			prev = this;
		}
			onChangeRadioReinicia(this.value);
		};
	}
}

function onChangeRadioExpandir(valor){
	if(valor=='N'){
		setCheckedExpandirN();
	}
	
	if(valor=='S'){
		setCheckedExpandirS();
	}
}

function onChangeRadioReinicia(valor){
	if(valor=='N'){
		setCheckedReiniciaN();
	}
	
	if(valor=='S'){
		setCheckedReiniciaS();
	}
}

function setCheckedExpandirN(){
	document.formVinculoServicoContrato.expandirVinculo.value = 'N';

	$('span', $('#uniform-expandiTelaS')).removeClass("checked");
    $("#expandiTelaS").removeAttr("checked");
    
	$('span', $('#uniform-expandiTelaN')).addClass("checked");
	$('#expandiTelaN').attr("checked", "checked");
}

function setCheckedReiniciaN(){
	document.formVinculoServicoContrato.reiniciaSlaReabrir.value = 'N';
	
	$('span', $('#uniform-reiniciaSlaS')).removeClass("checked");
    $("#reiniciaSlaS").removeAttr("checked");
    
    $('span', $('#uniform-reiniciaSlaN')).addClass("checked");
	$('#reiniciaSlaN').attr("checked", "checked");
}

function setCheckedExpandirS(){
	document.formVinculoServicoContrato.expandirVinculo.value = 'S';

	$('span', $('#uniform-expandiTelaN')).removeClass("checked");
	$('#expandiTelaN').removeAttr("checked");

	$('span', $('#uniform-expandiTelaS')).addClass("checked");
	$("#expandiTelaS").attr("checked", "checked");
}

function setCheckedReiniciaS(){
	document.formVinculoServicoContrato.reiniciaSlaReabrir.value = 'S';

	$('span', $('#uniform-reiniciaSlaN')).removeClass("checked");
	$("#reiniciaSlaN").removeAttr("checked");
    
	$('span', $('#uniform-reiniciaSlaS')).addClass("checked");
	$('#reiniciaSlaS').attr("checked", "checked");
}

function restoreVinculoServicoContrato(id_contrato, id_servico){
	JANELA_AGUARDE_MENU.show();
	
	limparVinculoServicoContrato();
	
	var idContratoStr = id_contrato.toString();
	var idServicoStr = id_servico.toString();
	var idServicoRelacionadoStr = getServicoRelacionado().toString();
	var idPortfolioStr = getPortfolioServico().toString();
	
	document.formVinculoServicoContrato.restore({
		idContrato : idContratoStr,
		idServicoSelecionado: idServicoStr,
		idServicoRelacionado: idServicoRelacionadoStr,
		idPortfolioServico: idPortfolioStr
	});

}

function limpaFiltroServicoRequisicaoContrato() {
	$("#inputFiltroServicoRequisicaoContrato").val("");
	changeFiltroServicoRequisicaoContrato("");
}

function pesquisaFiltroServicoRequisicaoContrato() {
	changeFiltroServicoRequisicaoContrato($("#inputFiltroServicoRequisicaoContrato").val());
}

function changeFiltroServicoRequisicaoContrato(filtroServicoRequisicao) {
	document.formVinculoServicoContrato.paginaSelecionadaRequisicaoVinculo.value = 0;
	document.formVinculoServicoContrato.filtroServicoRequisicaoVinculo.value = filtroServicoRequisicao;
	document.formVinculoServicoContrato.tipoServico.value = _TIPO_SERVICO_REQUISICAO;
	document.formVinculoServicoContrato.fireEvent("carregaTabelaServicosRequisicaoContrato");
}

function paginarServicosRequisicaoContrato(paginaSelecionadaRequisicao) {
	$('#divDinamicoListaServicosRequisicaoContrato').hide("blind", "fast",	function(){
		JANELA_AGUARDE_MENU.show();
		document.formVinculoServicoContrato.paginaSelecionadaRequisicaoVinculo.value = paginaSelecionadaRequisicao;
		document.formVinculoServicoContrato.tipoServico.value = _TIPO_SERVICO_REQUISICAO;
		document.formVinculoServicoContrato.fireEvent("carregaTabelaServicosRequisicaoContrato");
	});
}

function limpaFiltroServicoIncidenteContrato() {
	$("#inputFiltroServicoIncidenteContrato").val("");
	changeFiltroServicoIncidenteContrato("");
}

function pesquisaFiltroServicoIncidenteContrato() {
	changeFiltroServicoIncidenteContrato($("#inputFiltroServicoIncidenteContrato").val());
}

function changeFiltroServicoIncidenteContrato(filtroServicoIncidente) {
	document.formVinculoServicoContrato.paginaSelecionadaIncidenteVinculo.value = 0;
	document.formVinculoServicoContrato.filtroServicoIncidenteVinculo.value = filtroServicoIncidente;
	document.formVinculoServicoContrato.tipoServico.value = _TIPO_SERVICO_INCIDENTE;
	document.formVinculoServicoContrato.fireEvent("carregaTabelaServicosIncidenteContrato");
}

function paginarServicosIncidenteContrato(paginaSelecionadaIncidente) {
	$('#divDinamicoListaServicosIncidenteContrato').hide("blind", "fast",	function(){
		JANELA_AGUARDE_MENU.show();
		document.formVinculoServicoContrato.paginaSelecionadaIncidenteVinculo.value = paginaSelecionadaIncidente;
		document.formVinculoServicoContrato.tipoServico.value = _TIPO_SERVICO_INCIDENTE;
		document.formVinculoServicoContrato.fireEvent("carregaTabelaServicosIncidenteContrato");
	});
}

function limpaFiltroServicoProcedimentoContrato() {
	$("#inputFiltroServicoProcedimentoContrato").val("");
	changeFiltroServicoProcedimentoContrato("");
}

function pesquisaFiltroServicoProcedimentoContrato() {
	changeFiltroServicoProcedimentoContrato($("#inputFiltroServicoProcedimentoContrato").val());
}

function changeFiltroServicoProcedimentoContrato(filtroServicoProcedimento) {
	document.formVinculoServicoContrato.paginaSelecionadaProcedimentoVinculo.value = 0;
	document.formVinculoServicoContrato.filtroServicoProcedimentoVinculo.value = filtroServicoProcedimento;
	document.formVinculoServicoContrato.tipoServico.value = _TIPO_SERVICO_PROCEDIMENTO;
	document.formVinculoServicoContrato.fireEvent("carregaTabelaServicosProcedimentoContrato");
}

function paginarServicosProcedimentoContrato(paginaSelecionadaProcedimento) {
	$('#divDinamicoListaServicoProcedimentoContrato').hide("blind", "fast",	function(){
		JANELA_AGUARDE_MENU.show();
		document.formVinculoServicoContrato.paginaSelecionadaIncidenteVinculo.value = paginaSelecionadaIncidente;
		document.formVinculoServicoContrato.tipoServico.value = _TIPO_SERVICO_PROCEDIMENTO;
		document.formVinculoServicoContrato.fireEvent("carregaTabelaServicosProcedimentoContrato");
	});
}

function depoisCarregarServicosRequisicaoContrato(){
	JANELA_AGUARDE_MENU.hide();
	$('#divDinamicoListaServicosRequisicaoContrato').show("blind", "fast",	function(){});
}

function depoisCarregarServicosIncidenteContrato(){
	JANELA_AGUARDE_MENU.hide();
	$('#divDinamicoListaServicosIncidenteContrato').show("blind", "fast",	function(){});
}

function depoisCarregarServicosProcedimentoContrato(){
	JANELA_AGUARDE_MENU.hide();
	$('#divDinamicoListaServicoProcedimentoContrato').show("blind", "fast",	function(){});
}

function mostraDivListaServicosVinculo(){
	$("#divListaServicosVinculoContrato").css("display", "");
	$("#divNomeServicoVinculoContrato").css("display", "none");
}

function mostraDivNomeServicoVinculo(){
	$("#divListaServicosVinculoContrato").css("display", "none");
	$("#divNomeServicoVinculoContrato").css("display", "");
}

function onClickTempoAtendimento() {
	Modal.open('modal-portfolio-vinculo-contrato-add-tempo-atendimento');
}

function LOOKUP_SERVICOCONTRATO_ACORDONIVELSERVICO_MULTINIVEL_GLOBAL_E_CLIENTE_select(id, desc){
	document.formVinculoServicoContrato.idServicoContratoTempoAtendimento.value = id;
	if(desc) {
		document.formVinculoServicoContrato.servicoContratoTempoAtendimento.value = desc.substring(0,desc.lastIndexOf("-")).trim();
	}
	Modal.close('modal-portfolio-vinculo-contrato-add-tempo-atendimento');
}

function openCloseCollapseWidget(that) {
	var widget = $(that).parent('.widget');
	if($(widget).attr('data-collapse-closed') == 'true') {
		$(widget).attr('data-collapse-closed', 'false');
		$(widget).children('.widget-body').show();
	} else{
		$(widget).attr('data-collapse-closed', 'true');
		$(widget).children('.widget-body').hide();
	}
}

function atualizaListaIdsStrServicosContratoVinculados(idsStrServicos) {
	document.formVinculoServicoContrato.listaIdsStrServicosContratoVinculados.value = document.formVinculoServicoContrato.listaIdsStrServicosContratoVinculados.value + idsStrServicos;
}

function montarTabelaVincularListaServicos(idsStrServicos) {
	atualizaListaIdsStrServicosContratoVinculados(idsStrServicos);
	document.formVinculoServicoContrato.fireEvent('geraTabelaServicosVincular');
}

function getListaIdsServicosContratoVinculados() {
	var idsServicosContratoVinculadas = document.formVinculoServicoContrato.listaIdsStrServicosContratoVinculados.value.split(",");
	idsServicosContratoVinculadas = idsServicosContratoVinculadas.slice(0, idsServicosContratoVinculadas.length-1);
	return idsServicosContratoVinculadas;
}