_TECLA_ENTER = 13;
_FUNIL = 'F';
_CATALOGO = 'C';
_OBSOLETO = 'O';
_NEGOCIO = 'N';

$(function() {
	var cadastroPortfolio = {};
	cadastroPortfolio.idDiv = "#divCadastroPortfolio";
	cadastroPortfolio.urlJsp = "/pages/gerenciamentoPortfolio/gerenciamentoPortfolioCadastroPortfolio/gerenciamentoPortfolioCadastroPortfolio.jsp"; 
	cadastroPortfolio.urlJs = "/pages/gerenciamentoPortfolio/gerenciamentoPortfolioCadastroPortfolio/js/gerenciamentoPortfolioCadastroPortfolio.js"; 
	cadastroPortfolio.urlCss = "/pages/gerenciamentoPortfolio/gerenciamentoPortfolioCadastroPortfolio/css/gerenciamentoPortfolioCadastroPortfolio.css"; 
	
	loadJsp(cadastroPortfolio);
	
	$("#inputFiltroServicoNegocio").keyup(function(event) {
		if (event.which == _TECLA_ENTER) {
			changeFiltroServicoNegocio($(event.currentTarget).val());
		}
	});
	
	$(".tabsbar li.include").on('click', function(event) {
		if ($(event.currentTarget).attr("data-ref") == 'servicosApoio') {
			carregarListaServicosApoio();
		} else {
			carregarListaServicosRequisicaoIncidente($(event.currentTarget).attr("data-ref"));
		}
	});
});

function collapseWidget(that) {
	$(that).parent().children('.widget-body').collapse('toggle');
}

function collapseWidgetCustom(origin, target) {
	var button = $(origin),
		widget = button.parents('.widget');
	
	if(button.hasClass('circle_plus')) {
		button.removeClass('circle_plus')
			.addClass('circle_minus')
		widget.find('.widget-body').fadeIn('fast');
	} else {
		button.removeClass('circle_minus')
			.addClass('circle_plus')
		widget.find('.widget-body').fadeOut('fast');
	}
}

function getDisplayBlocked() {
	var idDisplayBlocked = '';
	
	if($('#divCadastroPortfolio').css('display') == 'block') {
		idDisplayBlocked = '#divCadastroPortfolio';
	} else if($('#divServicosNegocio').css('display') == 'block') {
		idDisplayBlocked = '#divServicosNegocio';
	} else if($('#divServicoNegocioInfo').css('display') == 'block') {
		idDisplayBlocked = '#divServicoNegocioInfo';
	} else if($('#divServicoApoioInfo').css('display') == 'block') {
		idDisplayBlocked = '#divServicoApoioInfo';
	} else if($('#divContratoInfo').css('display') == 'block') {
		idDisplayBlocked = '#divContratoInfo';
	} else if($('#divServicoReqIncOSInfo').css('display') == 'block') {
		idDisplayBlocked = '#divServicoReqIncOSInfo';
	}
	
	return idDisplayBlocked;
}

function htmlNovoBreadCrumb(tipoBreadCrumb, id, descricao, data){
	var retornoHtml = "";
	
	if(tipoBreadCrumb=='P') {
		retornoHtml = "<li class=\"active breadCrumbPortfolio\" "+data+" onclick=\"onClickBreadCrumb(this, "+id+", '"+descricao+"');\" onmouseover=\"abreTooltip(this, 'gerenciaportfolio.breadcrumb.portfolio')\" onmouseout=\"fechaTooltip()\">"+descricao+"</li>";
	} else if(tipoBreadCrumb=='N') {
		retornoHtml = "<li class=\"active breadCrumbServicoNegocio\" "+data+" onclick=\"onClickBreadCrumb(this, "+id+", '"+descricao+"');\" onmouseover=\"abreTooltip(this, 'gerenciaportfolio.breadcrumb.servicosNegocio')\" onmouseout=\"fechaTooltip()\">"+descricao+"</li>";
	} else if(tipoBreadCrumb=='A') {
		retornoHtml = "<li class=\"active breadCrumbServicoApoio\" "+data+" onclick=\"onClickBreadCrumb(this, "+id+", '"+descricao+"');\" onmouseover=\"abreTooltip(this, 'gerenciaportfolio.breadcrumb.servicosApoio')\" onmouseout=\"fechaTooltip()\">"+descricao+"</li>";
	} else if(tipoBreadCrumb=='C') {
		retornoHtml = "<li class=\"active breadCrumbContrato\" "+data+" onclick=\"onClickBreadCrumb(this, "+id+", '"+descricao+"');\" onmouseover=\"abreTooltip(this, 'gerenciaportfolio.breadcrumb.contrato')\" onmouseout=\"fechaTooltip()\">"+descricao+"</li>";
	} else if(tipoBreadCrumb=='CA') {
		retornoHtml = "<li class=\"active breadCrumbContratoApoio\" "+data+" onclick=\"onClickBreadCrumb(this, "+id+", '"+descricao+"');\" onmouseover=\"abreTooltip(this, 'gerenciaportfolio.breadcrumb.contrato')\" onmouseout=\"fechaTooltip()\">"+descricao+"</li>";
	} else if(tipoBreadCrumb=='R') {
		retornoHtml = "<li class=\"active breadCrumbServicoRequisicao\" "+data+" onclick=\"onClickBreadCrumb(this, "+id+", '"+descricao+"');\" onmouseover=\"abreTooltip(this, 'gerenciaportfolio.breadcrumb.servicoRequisicao')\" onmouseout=\"fechaTooltip()\">"+descricao+"</li>";
	} else if(tipoBreadCrumb=='I') {
		retornoHtml = "<li class=\"active breadCrumbServicoIncidente\" "+data+" onclick=\"onClickBreadCrumb(this, "+id+", '"+descricao+"');\" onmouseover=\"abreTooltip(this, 'gerenciaportfolio.breadcrumb.incidente')\" onmouseout=\"fechaTooltip()\">"+descricao+"</li>";
	}
	
	return retornoHtml;
}

function onClickBreadCrumb(obj, id, descricao){
	if(!$(obj).hasClass("active")){
		removeAtivoBreadCrumb();
		$(obj).nextAll('li').remove();
		$(obj).addClass("active");
		
		if($(obj).hasClass("breadCrumbInicio")){
			
			$(getDisplayBlocked()).hide("slide", { direction: "right" }, "fast",	function(){
				$('#divCadastroPortfolio').show("slide", { direction: "left" }, "fast",	function(){
					//limpar todos os dados dos serviços
					$('#divDinamicoListaServicosNegocio').html('');
				});
			});
		}
		
		if($(obj).hasClass("breadCrumbPortfolio")){
			$(getDisplayBlocked()).hide("slide", { direction: "right" }, "fast",	function(){
				JANELA_AGUARDE_MENU.show();
				document.form.fireEvent("avancarPortfolio");
				setarCategoriaPortfolio('#statsFunil');
				$("#statsFunil").trigger("click");
			});
		}
		
		if($(obj).hasClass("breadCrumbServicoNegocio")){
			var displayBlocked = getDisplayBlocked();
			$(displayBlocked).hide("slide", { direction: "right" }, "fast",	function(){
				document.form.idServicoNegocioAtual.value = id;
				restoreCadastroServicoNegocio(id);
			});
			$("span[href='#detalhesServico']").trigger('click');
		}
		
		if($(obj).hasClass("breadCrumbContrato")){
			document.form.idContratoAtual.value = id;
			
			$(getDisplayBlocked()).hide("slide", { direction: "left" }, "fast",	function(){
				JANELA_AGUARDE_MENU.show();

				document.formCadastroContrato.afterRestore = function() {
					JANELA_AGUARDE_MENU.hide();
					$('#divContratoInfo').show("slide", { direction: "right" }, "fast",	function(){
						$("#liAuditoriaContrato").removeClass("hidden");
					});
				}
				
				//Chama método em gerenciamentoPortfolioContratos.js para fazer o restore da tela de cadastro de contrato
				restoreContrato(id);
				
				document.formContratos.idContrato.value = id;
				document.formContratos.idPortfolioServicoContrato.value = getPortfolioServico();
				document.formContratos.idServicoNegocioContrato.value = getServicoNegocio();
				document.formContratos.fireEvent("restoreDemaisDadosContrato");
			});
			
			$("span[href='#detalhesContrato']").trigger('click');
		}
		
		if($(obj).hasClass("breadCrumbContratoApoio")){
			
			document.form.idContratoAtual.value = id;
			
			$(getDisplayBlocked()).hide("slide", { direction: "left" }, "fast",	function(){
				JANELA_AGUARDE_MENU.show();
				
				document.formCadastroContrato.afterRestore = function() {
					JANELA_AGUARDE_MENU.hide();
					$('#divContratoInfo').show("slide", { direction: "right" }, "fast",	function(){
						$("#liAuditoriaContrato").removeClass("hidden");
					});
				}
				
				//Chama método em gerenciamentoPortfolioContratos.js para fazer o restore da tela de cadastro de contrato
				restoreContratoApoio(id);
				
				document.formContratosApoio.idContrato.value = id;
				document.formContratosApoio.idPortfolioServicoContrato.value = getPortfolioServico();
				document.formContratosApoio.idServicoApoioContrato.value = getServicoRelacionado();
				document.formContratosApoio.fireEvent("restoreDemaisDadosContratoApoio");
			});
			
			$("span[href='#detalhesContrato']").trigger('click');
		}
		
		if($(obj).hasClass("breadCrumbServicoApoio")){
			$("#tabsServicoApoio li.dinamico").each(function(index, element) {
				ControleAbas.setarDataLoaded($(this).attr("data-ref"), "false");
			});
			
			$(getDisplayBlocked()).hide("slide", { direction: "right" }, "fast",	function(){
				$('#divServicoApoioInfo').show("slide", { direction: "right" }, "fast",	function(){
					if (getTipoTela() == 'servicoNegocio') {
						$('#divDinamicoListaServicosApoioNegocio').html('');
					} else {
						$('#divDinamicoListaServicosApoioApoio').html('');
					}
					restoreCadastroServicoApoio(id);
				});
			});
			
			atualizaLookupServicosVincular();
			$("span[href='#detalhesServicoApoio']").trigger('click');
		}
		
		if($(obj).hasClass("breadCrumbServicoRequisicao")){
			notificacao("Fazer restore do serviço de requisição " + descricao, "");
		}
	}
}

function removeAtivoBreadCrumb(){
	$("#breadcrumb > li.active ").remove();
}

function addBreadCrumbPortfolio(idPortfolio, nomePortfolio){
	var objInicio ='#breadcrumb li.breadCrumbInicio';
	$(objInicio).removeClass("active");
	$(objInicio).nextAll('li').remove();
	
	var data = "";
	$('#breadcrumb').html($('#breadcrumb').html()+htmlNovoBreadCrumb('P', idPortfolio, nomePortfolio, data));
	$("#breadcrumb .breadCrumbPortfolio span.categoria").html("(" + $(".statsServicosNegocio.primary span.txt").html() + ")");
}

function addBreadCrumbServicoNegocio(idServicoNegocio, descricaoServicoNegocio){
	var objPortfolio ='#breadcrumb li.breadCrumbPortfolio';
	$(objPortfolio).removeClass("active");
	$(objPortfolio).nextAll('li').remove();
	
	var data = "data-idservicorelacionado='"+ idServicoNegocio + "'";
	$('#breadcrumb').html($('#breadcrumb').html()+htmlNovoBreadCrumb('N', idServicoNegocio, descricaoServicoNegocio, data));
}

function addBreadCrumbContrato(idContrato, numeroContrato){
	var idServicoRelacionado = getServicoRelacionado();
	var objAllBreadCrumb ='#breadcrumb li';
	$(objAllBreadCrumb  ).removeClass("active");
	
	var data = "data-idserviconegocio='"+document.form.idServicoNegocioAtual.value + "'";
	data += " data-idcontrato='" + idContrato + "'";
	data += " data-idservicorelacionado='"  + idServicoRelacionado + "'";
	data += " data-idservicocontrato=''";
	
	var tipoContrato = 'C';
	if (document.form.idServicoNegocioAtual.value != idServicoRelacionado) {
		tipoContrato = 'CA';
	}
	
	$('#breadcrumb').html($('#breadcrumb').html()+htmlNovoBreadCrumb(tipoContrato, idContrato, numeroContrato, data));
}

function addBreadCrumbServicoApoio(idServicoApoio, nomeServicoApoio){
	var objAllBreadCrumb ='#breadcrumb li';
	$(objAllBreadCrumb  ).removeClass("active");
	
	var data = "data-idservicorelacionado=" + idServicoApoio;
	$('#breadcrumb').html($('#breadcrumb').html()+htmlNovoBreadCrumb('A', idServicoApoio, nomeServicoApoio, data));
}

function addBreadCrumbServicoReqIncOs(idServicoReqIncOs, nomeServicoReqIncOs, tipoServico){
	var objAllBreadCrumb ='#breadcrumb li';
	$(objAllBreadCrumb  ).removeClass("active");
	
	var data = "data-idservicorelacionado=" + idServicoReqIncOs;
	$('#breadcrumb').html($('#breadcrumb').html()+htmlNovoBreadCrumb(tipoServico, idServicoReqIncOs, nomeServicoReqIncOs, data));
}

function changeCategoriaPortfolio(obj){
	setarCategoriaPortfolio(obj);
	JANELA_AGUARDE_MENU.show();
	carregaTabelaServicosNegocio();

	if (getCategoriaPortfolio() == _FUNIL) {
		$("#btnNovoServicoNegocio").show();
	} else {
		$("#btnNovoServicoNegocio").hide();
	}
}

function setarCategoriaPortfolio(elemento) {
	$(".statsServicosNegocio.primary ").removeClass("primary");
	$(".statsServicosNegocio > span.count").removeClass("label-success");
	
	$(elemento).addClass("primary");
	$(elemento).find("span.count").addClass("label-success");
	
	$("#breadcrumb .breadCrumbPortfolio span.categoria").html("(" + $(".statsServicosNegocio.primary span.txt").html() + ")");
}

function avancarPortfolio(obj, idPortfolio, descricaoPortfolio) {
	addBreadCrumbPortfolio(idPortfolio, descricaoPortfolio);
	document.form.idPortfolioServicoAtual.value = idPortfolio;
	
	$(getDisplayBlocked()).hide("slide", { direction: "left" }, "fast",	function(){
		JANELA_AGUARDE_MENU.show();
		document.form.fireEvent("avancarPortfolio");
		
		if($("#divServicosNegocio .conteudo").attr("data-loaded") == "false") {
			var j = {};
			j.idDiv = "#divServicosNegocio .conteudo";
			j.urlJsp = _SRC_PORTFOLIO + "gerenciamentoPortfolioServicoNegocio/gerenciamentoPortfolioServicoNegocio.jsp";
			j.functionAfterLoad = function() {
				document.form.fireEvent('load');
				$("#divServicosNegocio .conteudo").attr("data-loaded", "true");
				$("#statsFunil").trigger("click");
			};
			loadJsp(j);
		} else {
			$("#statsFunil").trigger("click");
		}
		
	});
}

function avancarServicoNegocio(obj, idServico, nomeServico) {
	addBreadCrumbServicoNegocio(idServico, nomeServico);
	document.form.idServicoNegocioAtual.value = idServico;
	
	removeFormularioCadatroServicoNegocio();
	
	$(getDisplayBlocked()).hide("slide", { direction: "left" }, "fast",	function(){
		$('#divDinamicoListaServicosNegocio').html('');
		$('#divServicoNegocioInfo').show();
		var j = {};
		j.idDiv = "#divServicoNegocioInfo";
		j.urlJsp = _SRC_PORTFOLIO + "gerenciamentoPortfolioInfoServicoNegocio/gerenciamentoPortfolioInfoServicoNegocio.jsp";
		j.urlJs = [_SRC_PORTFOLIO + "js/gerenciamentoPortfolioControleAbas.js"]
		j.functionAfterLoad = function() {
			$("#tabsServico li.dinamico").each(function(index, element) {
				var ref = $(this).attr("data-ref");
				ControleAbas.setarDataLoaded(ref, "false");
			});
			
			ControleAbas.carregarAbaServicoNegocio("detalhesServico", "afterLoadAvancarServicoNegocio();");
		};
		loadJsp(j);
	});
	
}

function afterLoadAvancarServicoNegocio() {
	setTimeout(function() {
		restoreCadastroServicoNegocio(document.form.idServicoNegocioAtual.value);
	}, 200);
	
	$("span[href='#detalhesServico']").trigger('click');
	atualizaLookupServicosVincular();
}

function avancarContrato(obj, idContrato, numeroContrato){
	addBreadCrumbContrato(idContrato, numeroContrato);
	document.form.idContratoAtual.value = idContrato;
	$(getDisplayBlocked()).hide("slide", { direction: "left" }, "fast",	function(){
		$("#liAuditoriaContrato").removeClass("hidden");
		$('#divContratoInfo').show();
		
		var j = {};
		j.idDiv = "#conteudo_popup_cadastro_contrato";
		j.urlJsp = "/pages/cadastroContrato/cadastroContratoConteudo/cadastroContratoConteudo.jsp";
		
		removeJsp(j);
		
		j = {};
		j.idDiv = "#divContratoInfo";
		j.urlJsp = _SRC_PORTFOLIO + "gerenciamentoPortfolioInfoContrato/gerenciamentoPortfolioInfoContrato.jsp";
		j.urlJs = [_SRC_PORTFOLIO + "js/gerenciamentoPortfolioControleAbas.js"]
		j.functionAfterLoad = function() {
			$("#tabsContrato li.dinamico").each(function(index, element) {
				var ref = $(this).attr("data-ref");
				ControleAbas.setarDataLoaded(ref, "false");
			});
			
			ControleAbas.carregarAbaContrato("detalhesContrato", "afterLoadAvancarContrato("+idContrato+");");
			
			$("[href='#servicosProcedimentos']").parent("li").show();
		};
		loadJsp(j);
	});
}

function afterLoadAvancarContrato(idContrato) {
	JANELA_AGUARDE_MENU.show();

	//Esconde a tab da tela de contrao, pois existe uma tab para listagem
	$('#tabCadastroContrato').css("display", "none");

	document.formContratos.idContrato.value = idContrato;
	document.formContratos.idPortfolioServicoContrato.value = getPortfolioServico();
	document.formContratos.idServicoNegocioContrato.value = getServicoNegocio();
	document.formContratos.fireEvent("restoreDemaisDadosContrato");
	
	//Chama método em gerenacimentoPortfolioContratos.js para fazer o restore da tela de cadastro de contrato
	restoreContrato(idContrato);
	
	document.formCadastroContrato.afterRestore = function() {
		JANELA_AGUARDE_MENU.hide();
		carregarContratoAbaAns();
	}
	
	document.formCadastroContrato.afterSave = function() {}
	$(document.formCadastroContrato.btnLimpar).hide();
	
	$("span[href='#detalhesContrato']").trigger('click')
}

function carregarContratoAbaAns() {
	var afterLoad = "document.formAcordoNivelServicoTemplate.fireEvent('load');";
	loadJsp("#divConteudoAns", "/pages/acordoNivelServicoTemplate/acordoNivelServicoTemplateConteudo.jsp", "/pages/acordoNivelServicoTemplate/js/acordoNivelServicoTemplate.js", "/pages/acordoNivelServicoTemplate/css/acordoNivelServicoTemplate.css", afterLoad)
}

function avancarContratoApoio(obj, idContrato, numeroContrato){
	addBreadCrumbContrato(idContrato, numeroContrato);
	document.form.idContratoAtual.value = idContrato;
	$(getDisplayBlocked()).hide("slide", { direction: "left" }, "fast",	function(){
		$("#liAuditoriaContrato").removeClass("hidden");
		$('#divContratoInfo').show();
		
		var j = {};
		j.idDiv = "#conteudo_popup_cadastro_contrato_apoio";
		j.urlJsp = "/pages/cadastroContrato/cadastroContratoConteudo/cadastroContratoConteudo.jsp";	
		removeJsp(j);
		
		j = {};
		j.idDiv = "#divContratoInfo";
		j.urlJsp = _SRC_PORTFOLIO + "gerenciamentoPortfolioInfoContrato/gerenciamentoPortfolioInfoContrato.jsp";
		j.urlJs = [_SRC_PORTFOLIO + "js/gerenciamentoPortfolioControleAbas.js"]
		j.functionAfterLoad = function() {
			$("#tabsContrato li.dinamico").each(function(index, element) {
				var ref = $(this).attr("data-ref");
				ControleAbas.setarDataLoaded(ref, "false");
			});
			
			ControleAbas.carregarAbaContrato("detalhesContrato", "afterLoadAvancarContratoApoio("+idContrato+");");
			
			$("[href='#servicosProcedimentos']").parent("li").hide();
		};
		loadJsp(j);
	});
}

function afterLoadAvancarContratoApoio(idContrato) {
	JANELA_AGUARDE_MENU.show();
	
	//Esconde a tab da tela de contrao, pois existe uma tab para listagem
	$('#tabCadastroContrato').css("display", "none");
	
	document.formContratosApoio.idContrato.value = idContrato;
	document.formContratosApoio.idPortfolioServicoContrato.value = getPortfolioServico();
	document.formContratosApoio.idServicoApoioContrato.value = getServicoRelacionado();
	document.formContratosApoio.fireEvent("restoreDemaisDadosContratoApoio");
	
	//Chama método em gerenciamentoPortfolioContratosApoio.js para fazer o restore da tela de cadastro de contrato
	restoreContratoApoio(idContrato);
	
	document.formCadastroContrato.afterRestore = function() {
		JANELA_AGUARDE_MENU.hide();
	}
	
	$("span[href='#contratosApoio']").trigger('click')
}

function avancarServicoApoio(obj, idServico, nomeServico) {
	document.form.idServicoApoioAtual.value = idServico;
	addBreadCrumbServicoApoio(idServico, nomeServico);
	removeFormServicoApoio();
	removeFormInfoServicoApoio();
	removeFormMapaDesenhoApoio();
	
	$(getDisplayBlocked()).hide("slide", { direction: "left" }, "fast",	function(){
		$('#divServicoApoioInfo').show();
		
		var j = {};
		j.idDiv = "#divServicoApoioInfo";
		j.urlJsp = _SRC_PORTFOLIO + "gerenciamentoPortfolioInfoServicoApoio/gerenciamentoPortfolioInfoServicoApoio.jsp";
		j.urlJs = [_SRC_PORTFOLIO + "js/gerenciamentoPortfolioControleAbas.js"]
		j.functionAfterLoad = function() {
			$("#tabsServicoApoio li.dinamico").each(function(index, element) {
				var ref = $(this).attr("data-ref");
				ControleAbas.setarDataLoaded(ref, "false");
			});
			
			ControleAbas.carregarAbaServicoApoio("detalhesServicoApoio", "afterLoadAvancarServicoApoio();");
		};
		loadJsp(j);
	});
}

function afterLoadAvancarServicoApoio() {
	if (getTipoTela() == 'servicoNegocio') {
		$('#divDinamicoListaServicosApoioNegocio').html('');
	} else {
		$('#divDinamicoListaServicosApoioApoio').html('');
	}
	
	$("span[href='#detalhesServicoApoio']").trigger('click');
	atualizaLookupServicosVincular();
}

function avancarServicoRequisicaoContrato(obj, idContrato, idServico, nomeServico) {
	addBreadCrumbServicoReqIncOs(idServico, nomeServico, 'R');
	$("#divCustoServico").show();
	$(getDisplayBlocked()).hide("slide", { direction: "left" }, "fast",	function(){
		restoreVinculoServicoContrato(idContrato, idServico);
		atualizaListaIdsStrServicosContratoVinculados(idServico);
	});
}

function avancarServicoIncidenteContrato(obj, idContrato, idServico, nomeServico) {
	addBreadCrumbServicoReqIncOs(idServico, nomeServico, 'I');
	$("#divCustoServico").show();
	$(getDisplayBlocked()).hide("slide", { direction: "left" }, "fast",	function(){
		restoreVinculoServicoContrato(idContrato, idServico);
		atualizaListaIdsStrServicosContratoVinculados(idServico);
	});
}

function avancarServicoProcedimentoContrato(obj, idContrato, idServico, nomeServico) {
	addBreadCrumbServicoReqIncOs(idServico, nomeServico, 'I');
	$("#divCustoServico").hide();
	$(getDisplayBlocked()).hide("slide", { direction: "left" }, "fast",	function(){
		restoreVinculoServicoContrato(idContrato, idServico);
		atualizaListaIdsStrServicosContratoVinculados(idServico);
	});
}

function getPortfolioServico() {
	return document.form.idPortfolioServicoAtual.value;
}

function getCategoriaPortfolio() {
	return $(".statsServicosNegocio.primary").data('categoriaportfolio');
}

function getServicoNegocio(){
	return $("ol#breadcrumb li.breadCrumbServicoNegocio").data('idservicorelacionado');
}

function getServicoRelacionado() {
	return $("ol#breadcrumb li.active").data('idservicorelacionado');
}

function getTipoTela() {
	var tipoTela = "";
	if ($("ol#breadcrumb li.active").hasClass("breadCrumbServicoNegocio")) {
		tipoTela = "servicoNegocio";
	} else if ($("ol#breadcrumb li.active").hasClass("breadCrumbServicoApoio")) {
		tipoTela = "servicoApoio";
	}
	
	return tipoTela;
}

function atualizaLookupServicosVincular(){
	var whereDinamicoVinculoServicos = "(serv.idservico not in (select idservico from servicoautorelacionamento where datafim is null))";
		
	var whereDinamicoVinculoServicosApoio = 
		"(serv.idservico not in (select idservico from servicoautorelacionamento subauto where subauto.idservicorelacionado = " 
		+ getServicoRelacionado() 
		+ " and datafim is null))"
	
	// Serviços de Apoio
	document.formPesquisaServicoApoioVincular.whereDinamico = whereDinamicoVinculoServicosApoio;
	document.formPesquisaServicoApoioVincular.pesqLockupLOOKUP_SERVICO_VINCULAR_APOIO_serv_idPortfolioServico.value = getPortfolioServico();
	document.formPesquisaServicoApoioVincular.pesqLockupLOOKUP_SERVICO_VINCULAR_APOIO_serv_idServico.value = getServicoRelacionado();
	document.formPesquisaServicoApoioVincular.pesqLockupLOOKUP_SERVICO_VINCULAR_APOIO_serv_tipoServico.value = "'A'";
	// Serviços de Requisição
	document.formPesquisaServicoVincularRequisicaoNegocio.whereDinamico = whereDinamicoVinculoServicos;
	document.formPesquisaServicoVincularRequisicaoNegocio.pesqLockupLOOKUP_SERVICO_VINCULAR_REQUISICAO_NEGOCIO_serv_idPortfolioServico.value = getPortfolioServico();
	document.formPesquisaServicoVincularRequisicaoNegocio.pesqLockupLOOKUP_SERVICO_VINCULAR_REQUISICAO_NEGOCIO_serv_idServico.value = getServicoRelacionado();
	document.formPesquisaServicoVincularRequisicaoNegocio.pesqLockupLOOKUP_SERVICO_VINCULAR_REQUISICAO_NEGOCIO_serv_tipoServico.value = "'R'";
	//Serviços de Incidente
	document.formPesquisaServicoVincularIncidenteNegocio.whereDinamico = whereDinamicoVinculoServicos;
	document.formPesquisaServicoVincularIncidenteNegocio.pesqLockupLOOKUP_SERVICO_VINCULAR_INCIDENTE_NEGOCIO_serv_idPortfolioServico.value = getPortfolioServico();
	document.formPesquisaServicoVincularIncidenteNegocio.pesqLockupLOOKUP_SERVICO_VINCULAR_INCIDENTE_NEGOCIO_serv_idServico.value = getServicoRelacionado();
	document.formPesquisaServicoVincularIncidenteNegocio.pesqLockupLOOKUP_SERVICO_VINCULAR_INCIDENTE_NEGOCIO_serv_tipoServico.value = "'I'";
	
	// Serviços de Requisição - APOIO
	document.formPesquisaServicoVincularRequisicaoApoio.whereDinamico = whereDinamicoVinculoServicos;
	document.formPesquisaServicoVincularRequisicaoApoio.pesqLockupLOOKUP_SERVICO_VINCULAR_REQUISICAO_APOIO_serv_idPortfolioServico.value = getPortfolioServico();
	document.formPesquisaServicoVincularRequisicaoApoio.pesqLockupLOOKUP_SERVICO_VINCULAR_REQUISICAO_APOIO_serv_idServico.value = getServicoRelacionado();
	document.formPesquisaServicoVincularRequisicaoApoio.pesqLockupLOOKUP_SERVICO_VINCULAR_REQUISICAO_APOIO_serv_tipoServico.value = "'R'";
	//Serviços de Incidente - APOIO
	document.formPesquisaServicoVincularIncidenteApoio.whereDinamico = whereDinamicoVinculoServicos;
	document.formPesquisaServicoVincularIncidenteApoio.pesqLockupLOOKUP_SERVICO_VINCULAR_INCIDENTE_APOIO_serv_idPortfolioServico.value = getPortfolioServico();
	document.formPesquisaServicoVincularIncidenteApoio.pesqLockupLOOKUP_SERVICO_VINCULAR_INCIDENTE_APOIO_serv_idServico.value = getServicoRelacionado();
	document.formPesquisaServicoVincularIncidenteApoio.pesqLockupLOOKUP_SERVICO_VINCULAR_INCIDENTE_APOIO_serv_tipoServico.value = "'I'";
}

function setarCampoObrigatorio(idCampo, isObrigatorio) {
	if (isObrigatorio) {
		$("#" + idCampo).addClass('Valid[Required]').siblings().addClass('campoObrigatorio');
	} else {
		$("#" + idCampo).removeClass('Valid[Required]').siblings().removeClass('campoObrigatorio');
		document.getElementById(idCampo).validacao = '';
	}
	
	DEFINEALLPAGES_generateConfiguracaoCampos();
}

/** XXX ------------ FORM SERVICO NEGOCIO ---------------- * */

function carregaTabelaServicosNegocio(){
	document.formServicoNegocio.categoriaPortfolio.value = getCategoriaPortfolio();
	document.formServicoNegocio.idPortfolioServico.value = getPortfolioServico();
	document.formServicoNegocio.ascDesc.value = $("#comboAscDesc").val();
	document.formServicoNegocio.ordenarPor.value = $("#comboOrdenarPor").val();
	document.formServicoNegocio.fireEvent("carregaTabelaServicosNegocio");
}

function clickNovoServicoNegocio(idServicoNegocio){
	$(".formularioServicoNegocio").html("");
	
	var servicoNegocio = {};
	servicoNegocio.idDiv = "#modal-portfolio-servico-negocio .formularioServicoNegocio";
	servicoNegocio.urlJsp = "/pages/gerenciamentoPortfolio/gerenciamentoPortfolioCadastroServicoNegocio/gerenciamentoPortfolioCadastroServicoNegocio.jsp"; 
	servicoNegocio.urlJs = "/pages/gerenciamentoPortfolio/gerenciamentoPortfolioCadastroServicoNegocio/js/gerenciamentoPortfolioCadastroServicoNegocio.js";
	servicoNegocio.functionAfterLoad = "afterLoadNovoServicoNegocio(" + idServicoNegocio + ");"; 
	
	
	loadJsp(servicoNegocio);
}

function afterLoadNovoServicoNegocio(idServicoNegocio) {
	document.formCadastroServicoNegocio.fireEvent("load");
	openModalServicoNegocio();
	document.formCadastroServicoNegocio.idPortfolioServico.value = getPortfolioServico();
	document.formCadastroServicoNegocio.tipoServico.value = _NEGOCIO;
	if (idServicoNegocio != 0) {
		var idStr = idServicoNegocio.toString();
		document.formCadastroServicoNegocio.restore({
			idServico : idStr,
			isEditar : 'S'
		});
	}
}

function openModalServicoNegocio() {
	Modal.oneHidden("modal-portfolio-servico-negocio", beforeCloseServicoNegocio);
	$("#modal-portfolio-servico-negocio .dadosServicoNegocioConteudo").removeClass("span8");
	$("#modal-portfolio-servico-negocio .dadosServicoNegocioConteudo").addClass("span12");
	Modal.open("modal-portfolio-servico-negocio");
	$("form[name='formCadastroServicoNegocio'").attr('data-popup', 'S');
}

function beforeCloseServicoNegocio() {
	$("#modal-portfolio-servico-negocio .dadosServicoNegocioConteudo").removeClass("span12");
	$("#modal-portfolio-servico-negocio .dadosServicoNegocioConteudo").addClass("span8");
	carregaTabelaServicosNegocio();
}

function editarServicoNegocio(obj, idServicoNegocio) {
	clickNovoServicoNegocio(idServicoNegocio);
}

function limpaFiltroServicoNegocio() {
	$("#inputFiltroServicoNegocio").val("");
	changeFiltroServicoNegocio("");
}

function pesquisaFiltroServicoNegocio() {
	changeFiltroServicoNegocio($("#inputFiltroServicoNegocio").val());
}

function changeFiltroServicoNegocio(filtroServicoNegocio) {
	document.formServicoNegocio.filtroServicoNegocio.value = filtroServicoNegocio;
	document.formServicoNegocio.paginaSelecionadaServicoNegocio.value = 0;
	carregaTabelaServicosNegocio();
}

function depoisMontarHTMLServicosNegocio(){
	JANELA_AGUARDE_MENU.hide();
	
	$('#divDinamicoListaServicosNegocio').show("blind", "fast",	function(){});
	
	$('#divServicosNegocio').show("slide", { direction: "right" }, "fast",	function(){
	});
}

function paginarServicosNegocio(paginaSelecionadaNegocio) {
	$('#divDinamicoListaServicosNegocio').hide("blind", "fast",	function(){
		JANELA_AGUARDE_MENU.show();
		document.formServicoNegocio.paginaSelecionadaServicoNegocio.value = paginaSelecionadaNegocio;
		carregaTabelaServicosNegocio();
	});
}

function depoisCarregarTabelaServicosNegocio(){
	JANELA_AGUARDE_MENU.hide();
	$('#divDinamicoListaServicosNegocio').show("blind", "fast",	function(){});
	
	if (getCategoriaPortfolio() == _CATALOGO || getCategoriaPortfolio() == _OBSOLETO) {
		$("table .faseServico").hide();
	} else {
		$("table .faseServico").show();
	}
}

function removeFormularioCadatroServicoNegocio() {
	removeJsp({
		idDiv: ".formularioServicoNegocio", 
		urlJsp: "/pages/gerenciamentoPortfolio/gerenciamentoPortfolioCadastroServicoNegocio/gerenciamentoPortfolioCadastroServicoNegocio.jsp", 
		urlJs: "/pages/gerenciamentoPortfolio/gerenciamentoPortfolioCadastroServicoNegocio/js/gerenciamentoPortfolioCadastroServicoNegocio.js"
	});
}

function removeFormCadastroServicoApoio() {
	removeJspFromAba(
		"detalhesServicoApoio", 
		".formularioCadastroServicoApoio", 
		"/pages/gerenciamentoPortfolio/gerenciamentoPortfolioCadastroServicoApoio/gerenciamentoPortfolioCadastroServicoApoio.jsp", 
		"/pages/gerenciamentoPortfolio/gerenciamentoPortfolioCadastroServicoApoio/js/gerenciamentoPortfolioCadastroServicoApoio.js"
	);
}

function removeFormServicoApoio() {
	removeJspFromAba(
		"servicosApoio", 
		".formularioServicoApoio", 
		"/pages/gerenciamentoPortfolio/gerenciamentoPortfolioServicoApoio/gerenciamentoPortfolioServicoApoio.jsp", 
		"/pages/gerenciamentoPortfolio/gerenciamentoPortfolioCadastroServicoApoio/js/gerenciamentoPortfolioCadastroServicoApoio.js"
	);
}

function removeFormInfoServicoApoio() {
	removeJspFromAba(
		"servicosApoioN", 
		".formularioInfoServicoApoio", 
		"/pages/gerenciamentoPortfolio/gerenciamentoPortfolioServicoApoioApoio/gerenciamentoPortfolioServicoApoioApoio.jsp", 
		"/pages/gerenciamentoPortfolio/gerenciamentoPortfolioCadastroServicoApoio/js/gerenciamentoPortfolioCadastroServicoApoio.js"
	);
}

function removeFormMapaDesenhoApoio() {
	removeJspFromAba(
		"ativosSevicoApoio", 
		"#ativosSevicoApoio", 
		"/pages/gerenciamentoPortfolio/gerenciamentoPortfolioMapaDesenhoApoio/gerenciamentoPortfolioMapaDesenhoApoio.jsp", 
		["/pages/gerenciamentoPortfolio/gerenciamentoPortfolioMapaDesenhoApoio/js/gerenciamentoPortfolioMapaDesenhoApoioCanvas.js", 
		 "/pages/gerenciamentoPortfolio/gerenciamentoPortfolioMapaDesenhoApoio/js/gerenciamentoPortfolioMapaDesenhoApoio.js"]
	);
}

function removeJspFromAba(nomeAba, idDivAba, urlJspAba, urlJsAba) {
	removeJsp({
		idDiv: idDivAba,
		urlJsp: urlJspAba,
		urlJs: urlJsAba
	});
	ControleAbas.setarDataLoaded(nomeAba, "false");
}

$("body").on("click", ".carousel li", function() {
	$(this).parents("form").find(".carousel li").css("border", "1px solid #fff");
	$(this).css("border", "1px solid #777");
	$(this).parents("form").find(".carousel li").removeClass('selected');
	$(this).addClass('selected');
	
	$(this).parents("form").find("#imagemPortal").attr("value", $(this).find("img").attr("src"));
});

function setImagePortalInWidget(imagesUrl) {
	var html = '';
	html += '<ul class="carousel">';
	if(imagesUrl) {
		for(var i = 0; i < imagesUrl.length; i++) {
			html += '	<li data-value="' + imagesUrl[i] + '"><img src="' + imagesUrl[i] + '" alt=" " /></li>';
		}
	}
	html += '</ul>';
	$('.portal-images-widget .widget-body').html(html);
}

$("body").on("change", "#disponivelPortal, #dispPortal", function() {
	$(this).parents("form").find("#nomePortal").attr("value", "");
	$(this).parents("form").find("#descricaoPortal").attr("value", "");
	
	$(this).parents("form").find(".carousel li").css("border", "1px solid #fff");
	$(this).parents("form").find(".carousel li").removeClass('selected');
	$(this).parents("form").find("#imagemPortal").attr("value", "");
	
	if ($(this).attr("value") == 'S') {
		$(".portal-content").show();
	} else {
		$(".portal-content").hide();
	}
	
	Modal.adjust("modal-portfolio-cadastro");
});