_SRC_PORTFOLIO = "/pages/gerenciamentoPortfolio/";

$(function() {
	$("#tabsServico li.dinamico").on('click', function(event) {
		ControleAbas.carregarAbaServicoNegocio($(event.currentTarget).attr("data-ref"));
	});
	$("#tabsServicoApoio li.dinamico").on('click', function(event) {
		ControleAbas.carregarAbaServicoApoio($(event.currentTarget).attr("data-ref"));
	});
	$("#tabsContrato li.dinamico").on('click', function(event) {
		ControleAbas.carregarAbaContrato($(event.currentTarget).attr("data-ref"));
	});
});

var AbasServicoNegocio = {
	detalhesServico : { 
		idDiv : "#detalhesServico .tabConteudo",
		urlJsp : _SRC_PORTFOLIO + "gerenciamentoPortfolioCadastroServicoNegocio/gerenciamentoPortfolioCadastroServicoNegocio.jsp",
		urlJs : [_SRC_PORTFOLIO + "gerenciamentoPortfolioCadastroServicoNegocio/js/gerenciamentoPortfolioCadastroServicoNegocio.js"]
	},
	requisitoNivelServico : { 
		idDiv : "#requisitoNivelServico .tabConteudo",
		urlJsp : _SRC_PORTFOLIO + "gerenciamentoPortfolioRNS/gerenciamentoPortfolioRNS.jsp",
		urlJs : [_SRC_PORTFOLIO + "gerenciamentoPortfolioRNS/js/gerenciamentoPortfolioRNS.js"]
	},
	atributosFinanceiros : {
		idDiv : "#atributosFinanceiros .tabConteudo",
		urlJsp : _SRC_PORTFOLIO + "gerenciamentoPortfolioAtributosFinanceiros/gerenciamentoPortfolioAtributosFinanceiros.jsp",
		urlJs : [_SRC_PORTFOLIO + "gerenciamentoPortfolioAtributosFinanceiros/js/gerenciamentoPortfolioAtributosFinanceiros.js",
			   _SRC_PORTFOLIO + "gerenciamentoPortfolioAtributosFinanceiros/cadastroTipoFinanceiro/js/cadastroTipoFinanceiro.js"],
		urlCss : [_SRC_PORTFOLIO + "gerenciamentoPortfolioAtributosFinanceiros/css/gerenciamentoPortfolioAtributosFinanceiros.css"]
	},
	casoDeNegocio : {
		idDiv : "#casoDeNegocio .tabConteudo",
		urlJsp : _SRC_PORTFOLIO + "gerenciamentoPortfolioCasoNegocio/gerenciamentoPortfolioCasoNegocio.jsp",
		urlJs : [_SRC_PORTFOLIO + "gerenciamentoPortfolioCasoNegocio/js/gerenciamentoPortfolioCasoNegocio.js"]
	},
	mapaDesenhoNegocio : {
		idDiv : "#mapaDesenhoNegocio .tabConteudo",
		urlJsp : _SRC_PORTFOLIO + "gerenciamentoPortfolioMapaDesenhoNegocio/gerenciamentoPortfolioMapaDesenhoNegocio.jsp",
		urlJs : [_SRC_PORTFOLIO + "gerenciamentoPortfolioMapaDesenhoNegocio/js/gerenciamentoPortfolioMapaDesenhoNegocioCanvas.js",
				 _SRC_PORTFOLIO + "gerenciamentoPortfolioMapaDesenhoNegocio/js/gerenciamentoPortfolioMapaDesenhoNegocio.js"],
		urlCss : [_SRC_PORTFOLIO + "/gerenciamentoPortfolioMapaDesenhoNegocio/css/gerenciamentoPortfolioMapaDesenhoNegocio.css"]
	},
	processosNegocio : {
		idDiv : "#processosNegocio .tabConteudo",
		urlJsp : _SRC_PORTFOLIO + "gerenciamentoPortfolioProcessoNegocio/gerenciamentoPortfolioProcessoNegocio.jsp",
		urlJs : [_SRC_PORTFOLIO + "gerenciamentoPortfolioProcessoNegocio/js/gerenciamentoPortfolioProcessoNegocio.js",
			   "/pages/processoNegocio/js/processoNegocio.js",
			   "/cit/objects/ProcessoNegocioTiposFluxoDTO.js",
			   "/cit/objects/ProcessoNegocioUnidadesDTO.js"],
		urlCss : [_SRC_PORTFOLIO + "gerenciamentoPortfolioProcessoNegocio/css/gerenciamentoPortfolioProcessoNegocio.css",
			   "/pages/processoNegocio/css/processoNegocio.css"]
	},
	servicosApoio : {
		idDiv : "#servicosApoio .tabConteudo",
		urlJsp : _SRC_PORTFOLIO + "gerenciamentoPortfolioServicoApoio/gerenciamentoPortfolioServicoApoio.jsp",
		urlJs : [_SRC_PORTFOLIO + "gerenciamentoPortfolioCadastroServicoApoio/js/gerenciamentoPortfolioCadastroServicoApoio.js"],
		functionAfterLoad : "removeFormInfoServicoApoio();"
	},
	donoNegocio : { 
		idDiv : "#donoNegocio .tabConteudo",
		urlJsp : _SRC_PORTFOLIO + "gerenciamentoPortfolioDonoNegocio/gerenciamentoPortfolioDonoNegocio.jsp",
		urlJs : [_SRC_PORTFOLIO + "gerenciamentoPortfolioDonoNegocio/js/gerenciamentoPortfolioDonoNegocio.js"]
	},
	businessUser : { 
		idDiv : "#businessUser .tabConteudo",
		urlJsp : _SRC_PORTFOLIO + "gerenciamentoPortfolioBusinessUser/gerenciamentoPortfolioBusinessUser.jsp",
		urlJs : [_SRC_PORTFOLIO + "gerenciamentoPortfolioBusinessUser/js/gerenciamentoPortfolioBusinessUser.js"]
	},
	servicoRequisicaoNegocio : { 
		idDiv : "#servicoRequisicaoNegocio .tabConteudo",
		urlJsp : _SRC_PORTFOLIO + "gerenciamentoPortfolioServicoRequisicaoNegocio/gerenciamentoPortfolioServicoRequisicaoNegocio.jsp",
		urlJs : _SRC_PORTFOLIO + "gerenciamentoPortfolioCadastroServico/js/gerenciamentoPortfolioCadastroServico.js",
		functionAfterLoad : "inicializarCadastroServicoRequisicaoNegocio();"
	},
	aplicacoesNegocio : { 
		idDiv : "#aplicacoesNegocio .tabConteudo",
		urlJsp : _SRC_PORTFOLIO + "gerenciamentoPortfolioAplicacoes/gerenciamentoPortfolioAplicacoes.jsp",
		urlJs : [_SRC_PORTFOLIO + "gerenciamentoPortfolioAplicacoes/js/gerenciamentoPortfolioAplicacoes.js",
			   "/pages/cadastroAplicacao/js/cadastroAplicacao.js",
			   "/cit/objects/AplicacaoRequisitoDTO.js",
			   "/cit/objects/AplicacaoClienteDTO.js"],
		urlCss : ["/pages/cadastroAplicacao/css/cadastroAplicacao.css"]
	},
	esquemaDados : { 
		idDiv : "#esquemaDados .tabConteudo",
		urlJsp : _SRC_PORTFOLIO + "gerenciamentoPortfolioEsquemaDados/gerenciamentoPortfolioEsquemaDados.jsp",
		urlJs : [_SRC_PORTFOLIO + "gerenciamentoPortfolioEsquemaDados/js/gerenciamentoPortfolioEsquemaDados.js"],
		urlCss : [""]
	},
	servicoIncidenteNegocio : { 
		idDiv : "#servicoIncidenteNegocio .tabConteudo",
		urlJsp : _SRC_PORTFOLIO + "gerenciamentoPortfolioServicoIncidenteNegocio/gerenciamentoPortfolioServicoIncidenteNegocio.jsp",
		urlJs : _SRC_PORTFOLIO + "gerenciamentoPortfolioCadastroServico/js/gerenciamentoPortfolioCadastroServico.js",
		functionAfterLoad : "inicializarCadastroServicoIncidenteNegocio();"
	},
	servicoProcedimento : { 
		idDiv : "#servicoProcedimento .tabConteudo",
		urlJsp : _SRC_PORTFOLIO + "gerenciamentoPortfolioServicoProcedimento/gerenciamentoPortfolioServicoProcedimento.jsp",
		urlJs : _SRC_PORTFOLIO + "gerenciamentoPortfolioCadastroServico/js/gerenciamentoPortfolioCadastroServico.js",
		functionAfterLoad : "inicializarCadastroServicoProcedimentoNegocio();"
	},
	contratos : { 
		idDiv : "#contratos .tabConteudo",
		urlJsp : _SRC_PORTFOLIO + "gerenciamentoPortfolioContratos/gerenciamentoPortfolioContratos.jsp",
		urlJs : [_SRC_PORTFOLIO + "gerenciamentoPortfolioContratos/js/gerenciamentoPortfolioContratos.js",
			   "/pages/cadastroContrato/js/cadastroContrato.js",
			   "/pages/cadastroContrato/js/cadastroContratoControleFormula.js",
			   "/pages/cadastroContrato/js/cadastroContratoControleGrupo.js",
			   "/pages/cadastroContrato/js/cadastroContratoControleMatriz.js",
			   "/pages/cadastroContrato/js/cadastroContratoControleNivelServico.js",
			   "/pages/cadastroContrato/js/cadastroContratoControlePerfil.js",
			   "/pages/cadastroContrato/js/cadastroContratoControleProduto.js",
			   "/pages/cadastroContrato/js/cadastroContratoControleUnidade.js",
			   "/pages/cadastroContrato/js/cadastroContratoControleTable.js",
			   "/pages/cadastroContrato/js/cadastroContratoControleLookups.js",
			   "/cit/objects/AcordoNivelServicoContratoDTO.js",
			   "/cit/objects/ComplexidadeDTO.js",
			   "/cit/objects/ContratoPerfilDTO.js",
			   "/cit/objects/ProdutoContratoDTO.js",
			   "/cit/objects/MatrizContratoDTO.js",
			   "/cit/objects/ContratoFormulaOsDTO.js",
			   "/cit/objects/ContratosGruposDTO.js",
			   "/cit/objects/ContratosUnidadesDTO.js"],
		urlCss : ["/pages/cadastroContrato/css/cadastroContrato.css"]
	},
	proprietarios : {
		idDiv : "#proprietarios .tabConteudo",
		urlJsp : _SRC_PORTFOLIO + "gerenciamentoPortfolioProprietarios/gerenciamentoPortfolioProprietarios.jsp",
		urlJs : [_SRC_PORTFOLIO + "gerenciamentoPortfolioProprietarios/js/gerenciamentoPortfolioProprietarios.js"]
	},
	conhecimento : {
		idDiv : "#conhecimento .tabConteudo",
		urlJsp : _SRC_PORTFOLIO + "gerenciamentoPortfolioConhecimento/gerenciamentoPortfolioConhecimento.jsp",
		urlJs : [_SRC_PORTFOLIO + "gerenciamentoPortfolioConhecimento/js/gerenciamentoPortfolioConhecimento.js"]
	},
	habilidadeRecurso : {
		idDiv : "#habilidadeRecurso .tabConteudo",
		urlJsp : _SRC_PORTFOLIO + "gerenciamentoPortfolioHabilidade/gerenciamentoPortfolioHabilidade.jsp",
		urlJs : [_SRC_PORTFOLIO + "gerenciamentoPortfolioHabilidade/js/gerenciamentoPortfolioHabilidade.js",
			   "/pages/cadastroHabilidade/js/cadastroHabilidade.js",
			   "/cit/objects/VinculoHabilidadeColaboradorDTO.js"]
	},
	auditoriaServico : {
		idDiv : "#auditoriaServico .tabConteudo",
		urlJsp : _SRC_PORTFOLIO + "gerenciamentoPortfolioOcorrenciasServico/gerenciamentoPortfolioOcorrenciasServico.jsp",
		urlJs : [_SRC_PORTFOLIO + "gerenciamentoPortfolioOcorrenciasServico/js/gerenciamentoPortfolioOcorrenciasServico.js"],
		urlCss : [_SRC_PORTFOLIO + "gerenciamentoPortfolioOcorrenciasServico/css/gerenciamentoPortfolioOcorrenciasServico.css"]
	},
	indicadorCapacidade : {
		idDiv : "#indicadorCapacidade .tabConteudo",
		urlJsp : _SRC_PORTFOLIO + "gerenciamentoPortfolioIndicadorCapacidade/gerenciamentoPortfolioIndicadorCapacidade.jsp",
		urlJs : [_SRC_PORTFOLIO + "gerenciamentoPortfolioIndicadorCapacidade/js/gerenciamentoPortfolioIndicadorCapacidade.js"
				 ,_SRC_PORTFOLIO + "gerenciamentoPortfolioIndicadorCapacidade/indicadoresCapacidade/js/indicadoresCapacidade.js"],
		urlCss : [_SRC_PORTFOLIO + "gerenciamentoPortfolioIndicadorCapacidade/css/gerenciamentoPortfolioIndicadorCapacidade.css"]
	},
	atributoDemanda : {
		idDiv : "#atributoDemanda .tabConteudo",
		urlJsp : _SRC_PORTFOLIO + "gerenciamentoPortfolioAtributoDemanda/gerenciamentoPortfolioAtributoDemanda.jsp",
		urlJs : [_SRC_PORTFOLIO + "gerenciamentoPortfolioAtributoDemanda/js/gerenciamentoPortfolioAtributoDemanda.js"
				 ,_SRC_PORTFOLIO + "gerenciamentoPortfolioAtributoDemanda/importarAtributoDemanda/js/importarAtributoDemanda.js"],
		urlCss : [_SRC_PORTFOLIO + "gerenciamentoPortfolioAtributoDemanda/css/gerenciamentoPortfolioAtributoDemanda.css"]
	}
}

var AbasServicoApoio = {
		detalhesServicoApoio : {
			idDiv : "#detalhesServicoApoio .tabConteudo",
			urlJsp : _SRC_PORTFOLIO + "gerenciamentoPortfolioCadastroServicoApoio/gerenciamentoPortfolioCadastroServicoApoio.jsp",
			urlJs : [_SRC_PORTFOLIO + "gerenciamentoPortfolioCadastroServicoApoio/js/gerenciamentoPortfolioCadastroServicoApoio.js"],
			functionAfterLoad : "removeFormInfoServicoApoio();loadAndRestoreCadastroServicoApoio(getServicoRelacionado());"
		},
		ativosSevicoApoio : {
			idDiv : "#ativosSevicoApoio .tabConteudo",
			urlJsp : _SRC_PORTFOLIO + "gerenciamentoPortfolioMapaDesenhoApoio/gerenciamentoPortfolioMapaDesenhoApoio.jsp",
			urlJs : [_SRC_PORTFOLIO + "gerenciamentoPortfolioMapaDesenhoApoio/js/gerenciamentoPortfolioMapaDesenhoApoioCanvas.js",
					_SRC_PORTFOLIO + "gerenciamentoPortfolioMapaDesenhoApoio/js/gerenciamentoPortfolioMapaDesenhoApoio.js" ]
		},
		servicosApoioN : {
			idDiv : "#servicosApoioN .tabConteudo",
			urlJsp : _SRC_PORTFOLIO + "gerenciamentoPortfolioServicoApoioApoio/gerenciamentoPortfolioServicoApoioApoio.jsp",
			urlJs : [_SRC_PORTFOLIO + "gerenciamentoPortfolioCadastroServicoApoio/js/gerenciamentoPortfolioCadastroServicoApoio.js"],
			functionAfterLoad : "removeFormCadastroServicoApoio();carregarListaServicosApoio(document.formInfoServicoApoio);"
		},
		servicoRequisicaoApoio : {
			idDiv : "#servicoRequisicaoApoio .tabConteudo",
			urlJsp : _SRC_PORTFOLIO + "gerenciamentoPortfolioServicoRequisicaoApoio/gerenciamentoPortfolioServicoRequisicaoApoio.jsp",
			urlJs : [_SRC_PORTFOLIO + "gerenciamentoPortfolioCadastroServico/js/gerenciamentoPortfolioCadastroServico.js"],
			functionAfterLoad : "inicializarCadastroServicoRequisicaoApoio();"
		},
		servicoIncidenteApoio : {
			idDiv : "#servicoIncidenteApoio .tabConteudo",
			urlJsp : _SRC_PORTFOLIO + "gerenciamentoPortfolioServicoIncidenteApoio/gerenciamentoPortfolioServicoIncidenteApoio.jsp",
			urlJs : [_SRC_PORTFOLIO + "gerenciamentoPortfolioCadastroServico/js/gerenciamentoPortfolioCadastroServico.js"],
			functionAfterLoad : "inicializarCadastroServicoIncidenteApoio();"
		},
		contratosApoio : { 
			idDiv : "#contratosApoio .tabConteudo",
			urlJsp : _SRC_PORTFOLIO + "gerenciamentoPortfolioContratosApoio/gerenciamentoPortfolioContratosApoio.jsp",
			urlJs : [_SRC_PORTFOLIO + "gerenciamentoPortfolioContratosApoio/js/gerenciamentoPortfolioContratosApoio.js",
					"/pages/cadastroContrato/js/cadastroContrato.js",
					"/pages/cadastroContrato/js/cadastroContratoControleFormula.js",
					"/pages/cadastroContrato/js/cadastroContratoControleGrupo.js",
					"/pages/cadastroContrato/js/cadastroContratoControleMatriz.js",
					"/pages/cadastroContrato/js/cadastroContratoControleNivelServico.js",
					"/pages/cadastroContrato/js/cadastroContratoControlePerfil.js",
					"/pages/cadastroContrato/js/cadastroContratoControleProduto.js",
					"/pages/cadastroContrato/js/cadastroContratoControleUnidade.js",
					"/pages/cadastroContrato/js/cadastroContratoControleTable.js",
					"/pages/cadastroContrato/js/cadastroContratoControleLookups.js",
					"/cit/objects/AcordoNivelServicoContratoDTO.js",
					"/cit/objects/ComplexidadeDTO.js",
					"/cit/objects/ContratoPerfilDTO.js",
					"/cit/objects/ProdutoContratoDTO.js",
					"/cit/objects/MatrizContratoDTO.js",
					"/cit/objects/ContratoFormulaOsDTO.js",
					"/cit/objects/ContratosGruposDTO.js",
					"/cit/objects/ContratosUnidadesDTO.js"],
			urlCss : ["/pages/cadastroContrato/css/cadastroContrato.css"]
		},
	}

var AbasContrato = {
	detalhesContrato : { 
		idDiv : "#detalhesContrato .tabConteudo",
		urlJsp : _SRC_PORTFOLIO + "gerenciamentoPortfolioContratosDetalhes/gerenciamentoPortfolioContratosDetalhes.jsp",
		urlJs : ["/pages/cadastroContrato/js/cadastroContrato.js"],
		urlCss : ["/pages/cadastroContrato/css/cadastroContrato.css"],
		functionAfterLoad : "inicializarDetalhesContrato();"
	},
	servicosRequisicoes : { 
		idDiv : "#servicosRequisicoes .tabConteudo",
		urlJsp : _SRC_PORTFOLIO + "gerenciamentoPortfolioContratosServicoRequisicao/gerenciamentoPortfolioContratosServicoRequisicao.jsp",
		urlJs : [_SRC_PORTFOLIO + "gerenciamentoPortfolioCadastroServico/js/gerenciamentoPortfolioCadastroServico.js", 
		         _SRC_PORTFOLIO + "gerenciamentoPortfolioVinculoServicoContrato/js/gerenciamentoPortfolioVinculoServicoContrato.js"],
		functionAfterLoad : "inicializarCadastroServicoRequisicaoContrato();"
	},
	servicosIncidentes : { 
		idDiv : "#servicosIncidentes .tabConteudo",
		urlJsp : _SRC_PORTFOLIO + "gerenciamentoPortfolioContratosServicoIncidente/gerenciamentoPortfolioContratosServicoIncidente.jsp",
		urlJs : [_SRC_PORTFOLIO + "gerenciamentoPortfolioCadastroServico/js/gerenciamentoPortfolioCadastroServico.js", 
		         _SRC_PORTFOLIO + "gerenciamentoPortfolioVinculoServicoContrato/js/gerenciamentoPortfolioVinculoServicoContrato.js"],
		functionAfterLoad : "inicializarCadastroServicoIncidenteContrato();"
	},
	servicosProcedimentos : { 
		idDiv : "#servicosProcedimentos .tabConteudo",
		urlJsp : _SRC_PORTFOLIO + "gerenciamentoPortfolioContratosServicoProcedimento/gerenciamentoPortfolioContratosServicoProcedimento.jsp",
		urlJs : [_SRC_PORTFOLIO + "gerenciamentoPortfolioCadastroServico/js/gerenciamentoPortfolioCadastroServico.js", 
		         _SRC_PORTFOLIO + "gerenciamentoPortfolioVinculoServicoContrato/js/gerenciamentoPortfolioVinculoServicoContrato.js"],
		functionAfterLoad : "inicializarCadastroServicoProcedimentoContrato();"
	},
	custoDisponibilidade : { 
		idDiv : "#custoDisponibilidade .tabConteudo",
		urlJsp : _SRC_PORTFOLIO + "gerenciamentoPortfolioContratosCustoDisponibilidade/gerenciamentoPortfolioContratosCustoDisponibilidade.jsp",
		urlJs : [_SRC_PORTFOLIO + "gerenciamentoPortfolioContratosCustoDisponibilidade/js/gerenciamentoPortfolioContratosCustoDisponibilidade.js"],
		urlCss : [_SRC_PORTFOLIO + "gerenciamentoPortfolioContratosCustoDisponibilidade/css/gerenciamentoPortfolioContratosCustoDisponibilidade.css"]
	},
	servicoContratoANS : { 
		idDiv : "#servicoContratoANS .tabConteudo",
		urlJsp : _SRC_PORTFOLIO + "gerenciamentoPortfolioServicoContratoANS/gerenciamentoPortfolioServicoContratoANS.jsp",
		urlJs : [_SRC_PORTFOLIO + "gerenciamentoPortfolioServicoContratoANS/js/gerenciamentoPortfolioServicoContratoANS.js"]
	},
	contratoCalendario : { 
		idDiv : "#contratoCalendario .tabConteudo",
		urlJsp : _SRC_PORTFOLIO + "gerenciamentoPortfolioContratosCalendario/gerenciamentoPortfolioContratosCalendario.jsp",
		urlJs : [_SRC_PORTFOLIO + "gerenciamentoPortfolioContratosCalendario/js/gerenciamentoPortfolioContratosCalendario.js"],
		urlCss : [_SRC_PORTFOLIO + "gerenciamentoPortfolioContratosCalendario/css/gerenciamentoPortfolioContratosCalendario.css"]
	}
}

var ControleAbas = {
	carregarAbaServicoNegocio : function(referencia, afterLoad) {
		if (ControleAbas.getTabConteudo(referencia).attr("data-loaded") == "false") {
			var j = AbasServicoNegocio[referencia];
			
			if (j != undefined) {
				if(!j.functionAfterLoad) {
					j.functionAfterLoad = "";
				}
				j.functionAfterLoad += "ControleAbas.setarDataLoaded(\"" + referencia + "\", \"true\");";
				if (afterLoad != undefined) {
					j.functionAfterLoad += afterLoad;
				}
				loadJsp(j);
			}
		}
	},
	carregarAbaServicoApoio : function(referencia, afterLoad) {
		if (ControleAbas.getTabConteudo(referencia).attr("data-loaded") == "false") {
			var j = AbasServicoApoio[referencia];
			
			if (j != undefined) {
				if(!j.functionAfterLoad) {
					j.functionAfterLoad = "";
				}
				j.functionAfterLoad += "ControleAbas.setarDataLoaded(\"" + referencia + "\", \"true\");";
				if (afterLoad != undefined) {
					j.functionAfterLoad += afterLoad;
				}
				loadJsp(j);
			}
		}
	},
	carregarAbaContrato : function(referencia, afterLoad) {
		if (ControleAbas.getTabConteudo(referencia).attr("data-loaded") == "false") {
			var j = AbasContrato[referencia];
			
			if (j != undefined) {
				if(!j.functionAfterLoad) {
					j.functionAfterLoad = "";
				}
				j.functionAfterLoad += "ControleAbas.setarDataLoaded(\"" + referencia + "\", \"true\");";
				if (afterLoad != undefined) {
					j.functionAfterLoad += afterLoad;
				}
				loadJsp(j);
			}
		}
	},
	setarDataLoaded : function(referencia, loaded) {
		ControleAbas.getTabConteudo(referencia).attr("data-loaded", loaded);
	},
	getTabConteudo : function(referencia) {
		return $("#" + referencia + " .tabConteudo");
	}
}