var popup;
popup = new PopupManager(1000, 900, citctx + "/pages/");

var popupPesquisaProblema = new PopupManager(1084, 1084, citctx + "/pages/");
popupPesquisaProblema.titulo = i18n_message("citcorpore.comum.pesquisarapida");

$(document).ready(function() {
	Modal.onHidden('modal-cadastrar-problema', redimensionaModalProblemaOnHidden);
	Modal.onShown('modal-cadastrar-problema', redimensionaModalProblemaOnShown);
	
	$('[data-toggle="popover"]').popover();
	
	$("#resize-window").on("click", function() {
		if ($("#resize-window").hasClass("resize_full")) {
			$("#resize-window").removeClass("resize_full").addClass("resize_small");
			$("#footer, .navbar.main").fadeOut(100, function() {
				$("#content").addClass('p0');
			});
		} else {
			$("#resize-window").removeClass("resize_small").addClass("resize_full");
			$("#content").removeClass('p0');
			$("#footer, .navbar.main").fadeIn();
		}
	});

	if (idProblema) {
		visualizarSolicitacao(idProblema);
	} else {
		document.getElementById('fraRequisicaoProblema').src = "about:blank";
	}
});

function GrupoQtde() {
	this.id = '';
	this.qtde = 0;
}

prepararSuspensao = function(idProblema) {
	JANELA_AGUARDE_MENU.show();
	document.getElementById('fraVisao').src = "about:blank";
	document.getElementById('fraVisao').src = citctx
			+ "/pages/suspensaoProblema/suspensaoProblema.load?idProblema="
			+ idProblema;
	
	Modal.open('modal-problema-visao');
	$("#modal-problema-visao h3").text(i18n_message("problema.suspenderProblema"));
};

reativarProblema = function(idProblema) {
	if (!confirm(i18n_message("gerencia.confirm.reativacaoSolicitacao"))) {
		return;
	}

	JANELA_AGUARDE_MENU.show();
	document.form.idProblema.value = idProblema;
	document.form.fireEvent('reativaProblema');
};

agendaAtividade = function(idProblema) {
	JANELA_AGUARDE_MENU.show();
	document.getElementById('fraVisao').src = "about:blank";
	document.getElementById('fraVisao').src = citctx
			+ "/pages/agendarAtividadeProblema/agendarAtividadeProblema.load?idProblema="
			+ idProblema;
	
	Modal.open('modal-problema-visao');
	$("#modal-problema-visao h3").text(i18n_message("gerenciaservico.agendaratividade"));
};

capturarTarefa = function(responsavel, idTarefa, idProblema) {
	JANELA_AGUARDE_MENU.show();
	var msg = "";
	if (responsavel == '') {
		msg = i18n_message("gerencia.confirm.atribuicaotarefa") + " " + login + "?";
	} else {
		msg = i18n_message("gerencia.confirm.atribuicaotarefa_1") + " "
				+ responsavel + " "
				+ i18n_message("gerencia.confirm.atribuicaotarefa_2") + " "
				+ login	+ i18n_message("gerencia.confirm.atribuicaotarefa_3");
	}

	if (!confirm(msg)) {
		JANELA_AGUARDE_MENU.hide();
		return;
	}
	
	document.form.idTarefa.value = idTarefa;
	document.form.idProblema.value = idProblema;
	document.form.fireEvent('capturaTarefa');
};

prepararExecucaoTarefa = function(idTarefa, idProblema, acao) {
	JANELA_AGUARDE_MENU.show();
	document.getElementById('fraRequisicaoProblema').src = "about:blank";
	document.form.idTarefa.value = idTarefa;
	document.form.acaoFluxo.value = acao;
	document.form.idProblema.value = idProblema;
	document.form.fireEvent('preparaExecucaoTarefa');
};

exibirUrl = function(titulo, url) {

	document.getElementById('fraProblema').src = "";
	document.getElementById('fraProblema').src = citctx + "/" + url;
	JANELA_AGUARDE_MENU.show();

	Modal.open('modal-cadastrar-problema');
	$("#modal-cadastrar-problema h3").text(titulo);

};

var dadosGrafico;
var dadosGrafico2;
var dadosGerais;
exibirGraficos = function(json_tarefas) {
	var qtdeAtrasadas = 0;
	var qtdeSuspensas = 0;
	var qtdeEmAndamento = 0;
	var qtdePri1 = 0;
	var qtdePri2 = 0;
	var qtdePri3 = 0;
	var qtdePri4 = 0;
	var qtdePri5 = 0;
	var qtdeItens = 0;
	var colGrupoSol = new HashMap();

	arrayTarefas = ObjectUtils
			.deserializeCollectionFromStringSemQuebraEnter(json_tarefas);
	for (var i = 0; i < arrayTarefas.length; i++) {
		var tarefaDto = arrayTarefas[i];
		tarefaDto.problemaDto = ObjectUtils
				.deserializeObject(tarefaDto.problema_serialize);
		tarefaDto.elementoFluxoDto = ObjectUtils
				.deserializeObject(tarefaDto.elementoFluxo_serialize);
	}

	var strTableTemposSLA = '';
	strTableTemposSLA += "<img width='20' height='20' ";
	strTableTemposSLA += "alt='" + i18n_message('ativaotemporizador')
			+ "' id='imgAtivaTimer' style='opacity:0.5;display:none' ";
	strTableTemposSLA += "title='"
			+ i18n_message('citcorpore.comum.ativadestemporizador') + "' ";
	strTableTemposSLA += "src='" + citctx
			+ "/template_new/images/cronometro.png'/>";
	strTableTemposSLA += "<table class=\"table\" cellpadding=\"0\" cellspacing=\"0\">";
	strTableTemposSLA = strTableTemposSLA + "<tr><td><b>"
			+ i18n_message('gerenciaservico.slasandamento')
			+ "</b></td></tr>";

	for (var i = 0; i < arrayTarefas.length; i++) {
		var idProblema = "";
		var solicitante = "";
		var titulo = "";
		var contrato = "";
		var dataHoraCaptura = "";
		var nomeCriador = "";
		var nomeProprietario = "";
		var status = "";
		var prioridade = "";
		var dataHoraLimite = "";
		var nomeGrupoAtual = "";

		var tarefaDto = arrayTarefas[i];
		var problemaDto = tarefaDto.problemaDto;
		if (problemaDto != null) {

			if (problemaDto.prioridade == '1') {
				qtdePri1++;
			}
			if (problemaDto.prioridade == '2') {
				qtdePri2++;
			}
			if (problemaDto.prioridade == '3') {
				qtdePri3++;
			}
			if (problemaDto.prioridade == '4') {
				qtdePri4++;
			}
			if (problemaDto.prioridade == '5') {
				qtdePri5++;
			}

			var grupoNome = problemaDto.nomeGrupoAtual;
			if (grupoNome == null) {
				grupoNome = ' --'
						+ i18n_message("citcorpore.comum.aclassificar")
						+ '--';
			}

			idProblema = "" + problemaDto.idProblema;
			solicitante = "" + problemaDto.solicitante;

			prioridade = "" + problemaDto.prioridade;
			dataHoraCaptura = problemaDto.dataHoraCapturaStr;

			if (problemaDto.idStatus != 7) {
				dataHoraLimite = problemaDto.dataHoraLimiteStr;
			}

			var auxGrp = colGrupoSol.get(grupoNome);
			if (auxGrp != undefined) {
				auxGrp.qtde++;
			} else {
				var grupoQtde = new GrupoQtde();
				grupoQtde.id = grupoNome;
				grupoQtde.qtde = 1;
				colGrupoSol.set(grupoNome, grupoQtde);
			}

			nomeGrupoAtual = problemaDto.nomeGrupoAtual;

			if (parseFloat(problemaDto.atrasoSLA) > 0.0
					&& problemaDto.idStatus != 7 ) {
				qtdeAtrasadas++;
			} else if (problemaDto.idStatus == 7
					&& tarefaDto.reativar == 'S') {
				qtdeSuspensas++;
			} else {
				qtdeEmAndamento++;
				if (qtdeItens < 15) {
					strTableTemposSLA = strTableTemposSLA
							+ "<tr><td>N.o <b>" + problemaDto.idProblema
							+ "</b>: <label id='tempoRestante"
							+ problemaDto.idProblema + "'></label>";
					strTableTemposSLA = strTableTemposSLA
							+ "<div id='barraProgresso"
							+ problemaDto.idProblema + "'></div></td></tr>";
				}
				qtdeItens++;
			}
		}
	}

	strTableTemposSLA = strTableTemposSLA + '</table>';
	if (qtdeAtrasadas > 0 || qtdeSuspensas > 0 || qtdeEmAndamento > 0) {
		var info = '';

		if (qtdeAtrasadas > 0) {
			info += ' <font color="red"><b>' + qtdeAtrasadas + ' </b>'
					+ i18n_message("problema.problemas_atrasado")
					+ '</font><br>';
		}

		if (qtdeSuspensas > 0) {
			info += ' <b>' + qtdeSuspensas + ' </b>'
					+ i18n_message("problema.problemas_suspenso");
		}

		if (document.getElementById('fraRequisicaoProblema').src == "about:blank") {
			dadosGrafico = [{label: i18n_message('gerenciaservico.emandamento'), data: qtdeEmAndamento}, {label: i18n_message('gerenciaservico.suspensas'), data: qtdeSuspensas},{label:  i18n_message('gerenciaservico.atrasadas'), data: qtdeAtrasadas}];
			dadosGrafico2 = [{label: '1', data: qtdePri1}, {label: '2', data: qtdePri2}, {label: '3', data: qtdePri3}, {label: '4', data: qtdePri4}, {label: '5', data: qtdePri5}];
			window.setTimeout(atualizaGrafico, 1000);
			window.setTimeout(atualizaGrafico2, 1000);

			var colArray = colGrupoSol.toArray();
			dadosGerais = new Array();
			if (colArray) {
				for (var iAux = 0; iAux < colArray.length; iAux++) {
					dadosGerais[iAux] = {label: colArray[iAux].id, data: colArray[iAux].qtde};
				}
			}
			window.setTimeout(atualizaGrafico3, 1000);
		}
	}
};

function atualizaGrafico() {
	UtilCharts.pieChart.data = dadosGrafico;
	UtilCharts.pieChart.init("divGrafico");
}
function atualizaGrafico2() {
	UtilCharts.pieChart.data = dadosGrafico2;
	UtilCharts.pieChart.init("divGrafico2");
}
function atualizaGrafico3() {
	UtilCharts.pieChart.data = dadosGerais;
	UtilCharts.pieChart.init("divGrafico3");
}

atualizarListaTarefas = function() {
	$("#divConteudoLista").append("<div class='carregando'></div>");
	document.form.idProblemaSel.value = document.formPesquisa.idProblemaSel.value;
	document.form.fireEvent('exibeTarefas')
}

visualizarSolicitacao = function(idProblema) {
	document.getElementById('fraProblema').src = "";
	document.getElementById('fraProblema').src = citctx + PAGE_CADASTRO
			+ "?idProblema=" + idProblema
			+ "&escalar=N&alterarSituacao=N&editar=RO";
	JANELA_AGUARDE_MENU.show();
	
	Modal.open('modal-cadastrar-problema');
	$("#modal-cadastrar-problema h3").text(i18n_message('citcorpore.comum.visualizar'));
}

voltar = function() {
	JANELA_AGUARDE_MENU.show();
	if (document.getElementById('fraRequisicaoProblema').src == "about:blank") {
		window.location = citctx + '/pages/index/index.load';
	} else {
		window.location = citctx
				+ '/pages/gerenciamentoProblemas/gerenciamentoProblemas.load';
	}
};

editarSolicitacao = function(idProblema) {
	document.getElementById('fraRequisicaoProblema').src = "about:blank";
	document.getElementById('fraRequisicaoProblema').src = citctx + PAGE_CADASTRO
			+ "?idProblema=" + idProblema + "&escalar=S&alterarSituacao=N";
};

fecharProblema = function() {
	document.getElementById('fraRequisicaoProblema').src = "about:blank";
	document.form.fireEvent('exibeTarefas');
};

fecharVisao = function() {
	Modal.close('modal-problema-visao');
	document.getElementById('fraRequisicaoProblema').src = "about:blank";
	document.form.fireEvent('exibeTarefas');
};

abrirSolicitacao = function() {
	document.getElementById('fraProblema').src = "";
	document.getElementById('fraProblema').src = citctx + PAGE_CADASTRO;
	JANELA_AGUARDE_MENU.show();

	Modal.open('modal-cadastrar-problema');
	$("#modal-cadastrar-problema h3").text(i18n_message('categoriaProblema.cadastro'));
};

fechaPopupProblema = function() {
	Modal.close('modal-cadastrar-problema');
}

function disableEnterKey(e) {
	var key;

	if (window.event)
		key = window.event.keyCode; // IE
	else
		key = e.which; // firefox

	if (key == 13)
		return false;
	else
		return true;
}

function resize_iframe() {
	var height = window.innerWidth;// Firefox
	if (document.body.clientHeight) {
		height = document.body.clientHeight;// IE
	}
	document.getElementById("fraRequisicaoProblema").style.height = parseInt(height
			- document.getElementById("fraRequisicaoProblema").offsetTop - 135)
			+ "px";
}

abrePopupPesquisa = function() {
	document.getElementById('frameCadastroRapido').src = citctx + "/pages/pesquisaProblema/pesquisaProblema.load?iframe=true";
	Modal.open('modal-pesquisar-problema');
	$("#modal-pesquisar-problema h3").text(i18n_message('pesquisaProblema.pesquisaProblema'));

}

function atualizaPagina() {
	if (document.getElementById('chkAtualiza').checked) {
		atualizarListaTarefas();
	}

}

function initReports(data, tipo) {
	if (tipo == 'E') {
		$(".gp-relatorios-especificos").each(function() {
			var idEspecifico = "${idespecifico}";
			var dataEspecifico = data;
			while(dataEspecifico.indexOf(idEspecifico) > -1) {
				dataEspecifico = dataEspecifico.replace(idEspecifico, $(this).data("idespecifico"));
			}
			
			$(this).attr("data-content", dataEspecifico);
		});
		
		$(".gp-relatorios-especificos").popover();
	} else {
		document.getElementById('gp-relatorios').style.visibility = "visible";
		$("#gp-relatorios").attr("data-content", data);
	}
}

function openReport(tipoConsulta, idConsulta, nomeConsulta, tipo, idEspecifico) {
	var src = "";
	document.getElementById('fraProblema').src = "";
	
	if (tipo == 'E') {
		src = getPathReportEspecificoByTipoConsultaAndIdConsulta(tipoConsulta, idConsulta, idEspecifico);
	} else {
		src = getPathReportByTipoConsultaAndIdConsulta(tipoConsulta, idConsulta);
	}
	
	document.getElementById('fraProblema').src = src;
	
	Modal.open('modal-cadastrar-problema');
	$("#modal-cadastrar-problema h3").text(nomeConsulta);
}

/* Agendador de atualizacao. */
window.setInterval(atualizaPagina, 30000);

function configuraCamposResponsivosTabelaProblemas() {
	var camposHidden = [1,2,3,4,5,8];
	var clazz = "hidden-phone hidden-tablet";
	
	$.each($("#divConteudoLista th"),function(idx,val) {
		if ($.inArray(idx, camposHidden) > -1) {
			$(this).addClass(clazz);
			$("#divConteudoLista td:nth-child(" + (idx + 1) + ")").addClass(clazz);
		}
	});
}

function redimensionaModalProblema(obj) {
	if ($(obj).hasClass("resize_full")) {
		$(obj).removeClass("resize_full").addClass("resize_small");
		ajustarModalProblemaMaior();
	} else {
		$(obj).removeClass("resize_small").addClass("resize_full");
		ajustarModalProblemaPadrao();
	}
}

function redimensionaModalProblemaOnShown() {
	$(this).attr('primary-height', $(this).css('height'));
	redimensionaModalProblemaOnEvent(this);
}

function redimensionaModalProblemaOnHidden() {
	redimensionaModalProblemaOnEvent(this);
	
	$('#modal-cadastrar-problema').css({ 'display': '' });
}

function redimensionaModalProblemaOnEvent(that) {
	var elRedimensionar = $(that).find('.redimensionar');
	
	if ($(elRedimensionar).hasClass("resize_full")) {
		$(elRedimensionar).removeClass("resize_full").addClass("resize_small");
	}
	
	ajustarModalProblemaMaior();
}

function ajustarModalProblemaPadrao(){
	var height = $('#modal-cadastrar-problema').attr('primary-height');
	var marginTop = 'auto';
	
	if(height != null) {
		height = height.replace(/[^0-9\.]+/g, "");
		
		if(height != "") {
			height = parseInt(height);
			height = -height/2;
			marginTop = height+"px !important;";
		}
	}
	
	$('#modal-cadastrar-problema').attr('style', 'display: block; top: 50%; max-width: 80%; margin-top: '+marginTop);
	
	$('#modal-cadastrar-problema .modal-body').css({
		'max-height': '500px',
		'height': '500px'
	});
	
	$('#modal-cadastrar-problema').removeClass('modal-size-full');
}

function ajustarModalProblemaMaior(){
	$('#modal-cadastrar-problema').css({
		'top': '0',
		'bottom': '0',
		'max-height': '95%',
		'max-width': '95%',
		'margin-top': ''
	});

	$('#modal-cadastrar-problema .modal-body').css({
		'max-height': '95%',
		'height': '95%'
	});
	
	$('#modal-cadastrar-problema').addClass('modal-size-full');
}