var myDropzone;

$(document).ready(function() {
	$("#telefoneContatoCadastroRapido").keypress(function(e) {
		if(NumberUtil.retornaSomenteNumero(e)){ 
			mascararElementoInput(this, aplicarMascaraNaAcaoOnKeyPress);
		}else{
			return false;
		}
	});
	
	$("#telefoneContatoCadastroRapido").blur(function() {
		calculaEMontagemMascaraTelefone(this);
	});
	
	$("body").on("click", ".mostrar-mais-opcoes", function() {
		if ($(".mais-opcoes").hasClass("opened")) {
			$(".mais-opcoes").slideUp();
			$(".mais-opcoes").removeClass("opened");
			$(".mostrar-mais-opcoes .material-icons").text("expand_more");
		} else {
			$(".mais-opcoes").slideDown();
			$(".mais-opcoes").addClass("opened");
			$(".mostrar-mais-opcoes .material-icons").text("expand_less");
		}
	});
	
	$("body").on("click", ".solicitacao-mostrar-mais-detalhes", function() {
		var el = $(this).parents(".box-generic").find(".content-row");
		
		if (el.hasClass("opened")) {
			el.animate({
				height: "41px"
			}, 400, function(){
				el.removeClass("opened");
				el.css("height", "41px");
				$(".solicitacao-mostrar-mais-detalhes .material-icons").text("expand_more");
			});
		} else {
			var autoHeight = el.css('height', 'auto').height();
			el.height("41px");
			
			el.stop().animate({ height: autoHeight }, 400, function() {
				el.addClass("opened");
				el.css("height", "auto");
				$(".solicitacao-mostrar-mais-detalhes .material-icons").text("expand_less");
			});
		}
	});
	
	$("#visualizacaoDetalhada").on("click", function() {
		var el = $(".box-generic .content-row");
		
		el.addClass("opened");
		el.css("height", "auto");
		$(".solicitacao-mostrar-mais-detalhes .material-icons").text("expand_less");
	});
	
	$("#visualizacaoResumida").on("click", function() {
		var el = $(".box-generic .content-row");
		
		el.removeClass("opened");
		el.css("height", "41px");
		$(".solicitacao-mostrar-mais-detalhes .material-icons").text("expand_more");
	});
	
	$("#cadastroRapido").on("click", function() {
		$("#formCadastroRapido").find("input:text, input:hidden, select, textarea").val("");
		$("#formCadastroRapido").find('input:radio, input:checkbox').removeAttr('checked').removeAttr('selected');
		
		$("#tdResultadoSLAPrevisto").attr("style", "");
		$("#tdResultadoSLAPrevisto").text("N/A");
		
		$("#idContratoCadastroRapido").empty();
		$("#itensConfiguracaoSelecionados").html("<div class='nenhum-selecionado'>" + i18n_message("citcorpore.comum.nenhumaSelecao") + "</div><div class='clearfix'></div>");
		
		//Reinicia a dropzone para limpar os anexos antigos.
		myDropzone.destroy();
		inicializaDropzone();
		
		document.formCadastroRapido.fireEvent("loadCadastroRapido");
		
		Modal.open("modal-cadastro-rapido");
	});
	
	$('#modal-cadastro-rapido').on('hidden', function () {
		document.formCadastroRapido.fireEvent("unloadCadastroRapido");
	});
	
	$("#cadastroTemplate").on("click", function() {
		$(".templates").slideDown();
	});
	
	$('#idSolicitante').select2({
		minimumInputLength: 0,
		allowClear: true,
		placeholder: i18n_message("citcorpore.comum.selecione"),
		ajax: {
			quietMillis: 150,
			url: URL_SISTEMA + 'pages/autoCompleteSolicitante/autoCompleteSolicitante.load',
			dataType: 'json',
			data: function (term) {
				return {
					q : term,
					query: term, 
					contrato : $("#idContrato").val(),
					colection : true
				};
			},
			results: function (data, page) {
				return { results: data };
			}
		},
		formatResult: function(exercise) {
			return exercise.nome + (exercise.cpf != undefined && exercise.cpf != '' ? " - " + exercise.cpf : "");
		},
		formatSelection: function(exercise) {
			return exercise.nome + (exercise.cpf != undefined && exercise.cpf != '' ? " - " + exercise.cpf : "");
		},
		id: function(exercise) {
			return exercise.idEmpregado;
		}
	});
	
	$('#idResponsavelAtual').select2({
		minimumInputLength: 0,
		allowClear: true,
		placeholder: i18n_message("citcorpore.comum.selecione"),
		ajax: {
			quietMillis: 150,
			url: URL_SISTEMA + 'pages/autoCompleteResponsavel/autoCompleteResponsavel.load',
			dataType: 'json',
			data: function (term) {
				return {
					q : term,
					query: term, 
					contrato : $("#idContrato").val(),
					colection : true
				};
			},
			results: function (data, page) {
				return { results: data };
			}
		},
		formatResult: function(exercise) {
			return exercise.nomeUsuario;
		},
		formatSelection: function(exercise) {
			return exercise.nomeUsuario;
		},
		id: function(exercise) {
			return exercise.idUsuario;
		}
	});
	
	$(document).on("click", function(e) {
		var el = $(e.target);
		
		if (el.parents("#s2id_idSolicitante").length == 0) {
			$("#idSolicitante").select2("close");
		}
		
		if (el.parents("#s2id_idResponsavelAtual").length == 0) {
			$("#idResponsavelAtual").select2("close");
		}
		
		if (el.parents("#s2id_idSolicitanteCadastroRapido").length == 0) {
			$("#idSolicitanteCadastroRapido").select2("close");
		}
		
		$('[data-toggle="popover"]').each(function () {
			if (!$(this).is(e.target) && $(this).has(e.target).length === 0 && $('.popover').has(e.target).length === 0) {
				$(this).popover('hide');
			}
		});
		
		if (el.parents(".cadastro-template-wrapper").length == 0 && el.parents("#cadastroTemplate").length == 0 && el.parents(".templates").length == 0) {
			$(".templates").slideUp();
		}
	});
	
	$( "#POPUP_SERVICO" ).dialog({
		width: 1500,
		height: 900,
		modal: true,
		autoOpen: false,
		resizable: false,
		show: "fade",
		hide: "fade"
	});
	
	$('#btnAtualizarGraficos').click(function(){
		renderizarGraficos();
	});
	
	$("#resize-window").on("click", function() {
		if ($("#resize-window").hasClass("resize_full")) {
			$("#resize-window").removeClass("resize_full").addClass("resize_small");
			$("#footer, .navbar.main").fadeOut(100, function() {
				$("#content").addClass('p0');
			});
		} else {
			$("#resize-window").removeClass("resize_small").addClass("resize_full");
			$("#content").removeClass('p0');
			$("#footer, .navbar.main").fadeIn();
		}
	});
	
	$(".solicitacao-mais-opcoes .leadcontainer .dropdown-lead").live("click", function(e) {
		var _this = $(this);
		var _element = _this.parent().parent();
		
		$(".solicitacao-mais-opcoes").each(function() {
			$(this).removeClass("open");
		});
		
		_element.addClass("open");
		
		e.stopPropagation();
	});
	
	$('#mensagem_insercao').on('hidden', function () {
		Modal.close("modal-cadastro-rapido");
		carregaListaServico();
	});

	$("#idSolicitacao").keypress(function(el) {
		var key = (el.charCode) ? el.charCode
				: ((el.which) ? el.which : el.keyCode);

		if (key >= 48 && key <= 58) {
			return true;
		}

		if (key == 8 || key == 46) {
			return true;
		}

		var keysCrtl = [ 65, 67, 86, 88, 97, 99, 118,
				120 ];

		if (el.ctrlKey && keysCrtl.indexOf(key) >= 0) {
			return true;
		}

		return false;
	});
	
	/*
	 * Configuração Dropzone
	 */
	inicializaDropzone();
});

function inicializaDropzone() {
	Dropzone.autoDiscover = false;

	myDropzone = new Dropzone("div.dropzone", {
		url: ctx + "/pages/upload/upload.load",
		addRemoveLinks : true,
		paramName : "file_uploadAnexos",
		maxFilesize : (parseInt(TAMANHO_MAXIMO_UPLOAD) / (1024*1024)),
		accept: function(file, done) { //Validações ao adicionar um arquivo.
			if (file.size <= 0) {
				done(i18n_message("citcorpore.comum.uploadArquivoMuitoPequeno"));
			} else { done(); }
		}
	});
	
	myDropzone.on("removedfile", function(file) {
		$.post(ctx + "/pages/uploadExcluir/uploadExcluir.load", { nameFile: file.name });
	});
}

function renderizarGraficos() {
	JANELA_AGUARDE_MENU.show();
	document.formGerenciamento.fireEvent('renderizarGraficos');
}

function initReports(data, tipo) {
	if (tipo == 'E') {
		$(".gir-relatorios-especificos").each(function() {
			var idEspecifico = "${idespecifico}";
			var dataEspecifico = data;
			while(dataEspecifico.indexOf(idEspecifico) > -1) {
				dataEspecifico = dataEspecifico.replace(idEspecifico, $(this).data("idespecifico"));
			}
			
			$(this).attr("data-content", dataEspecifico);
		});
	} else {
		document.getElementById('gir-relatorios').style.visibility = "visible";
		$("#gir-relatorios").attr("data-content", data);
	}
}

function openReport(tipoConsulta, idConsulta, nomeConsulta, tipo, idEspecifico) {
	var src = "";
	document.getElementById('fraServico').src = "";
	if (tipo == 'E') {
		src = getPathReportEspecificoByTipoConsultaAndIdConsulta(tipoConsulta, idConsulta, idEspecifico);
	} else {
		src = getPathReportByTipoConsultaAndIdConsulta(tipoConsulta, idConsulta);
	}
	
	document.getElementById('fraServico').src = src;

	$("#POPUP_SERVICO").dialog({
		width : "80%",
		height : $(window).height() - 100,
		title : nomeConsulta,
	});

	$("#POPUP_SERVICO").dialog('open');
}

function abrirMaisOpcoes(_this) {
	$(_this).parent().parent().prop("class", "btn-group solicitacao-mais-opcoes dropup open"); 
}

/**
Adicionado para fechar o moldal  apos carregar a grid de solicita�oes.grid de solicita��o.
* 
* @author maycon.fernandes
* @since 25/10/2013 14:35
*/
function fecharModal(){
	$('#modal_novaSolicitacao').modal('hide');
	$('#modal_reclassificarSolicitacao').modal('hide');
	$('#modal_criarSubSolicitacao').modal('hide');
	$('#modal_exibirDelegacaoTarefa').modal('hide');
	$('#modal_suspender').modal('hide');
	$('#modal_alterarSLA').modal('hide');
}

function inicializaPopover(){
	$('.informacoesSolicitante').popover({placement: 'top', animation: true, trigger: 'click', html: true});
	$('.gir-relatorios-especificos').popover({placement: 'left', animation: true, trigger: 'focus', html: true});
}

function prepararExecucaoTarefa(idTarefa,idSolicitacao,acao) {
	janelaAguarde();
	document.form.idSolicitacaoSel.value = idSolicitacao;
	document.form.idTarefa.value = idTarefa;
	document.form.acaoFluxo.value = acao;
	document.form.fireEvent('preparaExecucaoTarefa');
}

function modalTemplatesSolicitacaoServico() {
	document.form.fireEvent("carregarTemplates");
	$('#modal_templatesSolicitacaoServico').modal('show');
}

function modalNovaSolicitacaoServico(){
	document.getElementById('frameNovaSolicitacao').src =  URL_SISTEMA+'pages/solicitacaoServicoMultiContratos/solicitacaoServicoMultiContratos.load';
	$('#modal_novaSolicitacao').modal('show');
	ajustarPadraoCitsmart();
}

function visualizarSolicitacao(idSolicitacaoServico, idTarefa) {
	document.getElementById('frameNovaSolicitacao').src =  URL_SISTEMA+'pages/solicitacaoServicoMultiContratos/solicitacaoServicoMultiContratos.load?idSolicitacaoServico='+idSolicitacaoServico+'&idTarefa='+idTarefa+'&escalar=N&alterarSituacao=N&editar=N&acaoFluxo=V';
	$('#modal_novaSolicitacao').modal('show');
}

function chamarPesquisaSolicitacoes(){
	document.getElementById('framePesquisaGeralSolicitacao').src = URL_SISTEMA+'pages/pesquisaSolicitacoesServicos/pesquisaSolicitacoesServicos.load?iframe=true';
	$('#modal_pesquisaGeralSolicitacao').modal('show');
}

function chamarAgendaGrid(){
	document.getElementById('frameAgendaAtvPeriodicas').src = URL_SISTEMA+'pages/agendaAtvPeriodicas/agendaAtvPeriodicas.load?noVoltar=true';
	$('#modal_agenda').modal('show');
}

function chamarSuspenderReativarSolicitacaoGrid(){
	document.getElementById('frameSuspenderReativarSolicitacao').src = URL_SISTEMA+'pages/suspensaoReativacaoSolicitacao/suspensaoReativacaoSolicitacao.load?noVoltar=true&iframe=true';
	$('#modal_SuspenderReativarSolicitacao').modal('show');
}

function chamarModalDescricaoSolicitacao(descricao, idSolicitacaoServico ){
	$('#contentDescricaoSolicitacao').html('<h3>'+ i18n_message('solicitacaoServico.solicitacao')+'&nbsp;&nbsp;'+idSolicitacaoServico+'</h3><br><div class=\"box-generic\"><div class=\"descricaoModal\">'+descricao+'</div></div>');
	$('#modal_descricaoSolicitacao').modal('show');
}

function prepararMudancaSLA(idTarefa, idSolicitacao) {
	document.getElementById('frameAlterarSLA').src =  URL_SISTEMA+'pages/mudarSLA/mudarSLA.load?iframe=true&idSolicitacaoServico=' + idSolicitacao + '&idTarefa=' + idTarefa
	$('#modal_alterarSLA').modal('show');
}

function agendaAtividade(idSolicitacao) {
	document.getElementById('frameAgendarAtividade').src =  URL_SISTEMA+'pages/agendarAtividade/agendarAtividade.load?iframe=true&idSolicitacaoServico='+idSolicitacao;
	$('#modal_agendarAtividade').modal('show');
}

function exibirUrl(titulo, url) {
	document.getElementById('frameNovaSolicitacao').src = '../../' + url;
	$('#modal_novaSolicitacao').modal('show');
}

function reclassificarSolicitacao(idTarefa, idSolicitacao) {
	JANELA_AGUARDE_MENU.show();
	document.getElementById('frameReclassificarSolicitacao').src = URL_SISTEMA+'pages/solicitacaoServicoMultiContratos/solicitacaoServicoMultiContratos.load?idSolicitacaoServico='+idSolicitacao+'&idTarefa='+idTarefa+'&reclassificar=S&visualizarPasso=C';
	$('#modal_reclassificarSolicitacao').modal('show');
};

function exibirDelegacaoTarefa(idTarefa, idSolicitacao, nomeTarefa) {
	document.getElementById('frameExibirDelegacaoTarefa').src =  URL_SISTEMA+'pages/delegacaoTarefa/delegacaoTarefa.load?iframe=true&idSolicitacaoServico='+idSolicitacao+'&idTarefa='+idTarefa+'&nomeTarefa='+nomeTarefa;
	$('#modal_exibirDelegacaoTarefa').modal('show');
}

function prepararSuspensao(idTarefa, idSolicitacao) {
	document.getElementById('frameExibirSuspender').src =  URL_SISTEMA+'pages/suspensaoSolicitacao/suspensaoSolicitacao.load?iframe=true&idSolicitacaoServico='+idSolicitacao+'&idTarefa='+idTarefa;
	$('#modal_suspender').modal('show');
}

function adicionarIdContratoNaLookup(id){
	document.getElementById('pesqLockupLOOKUP_SOLICITANTE_IDCONTRATO').value = id;
}

function carregarModalDuplicarSolicitacao(idSolicitacao) {
	document.formInformacoesContato.clear();
	document.formInformacoesContato.idSolicitacaoServico.value = idSolicitacao;
	
	document.formInformacoesContato.fireEvent('carregarModalDuplicarSolicitacao');
	$('#modal_criarSubSolicitacao').modal('show');
}

function LOOKUP_SOLICITANTE_select(id, desc){
	document.formInformacoesContato.idSolicitante.value = id;
	$('#modal_lookupSolicitante').modal('hide');
}

function duplicarSolicitacao(){
	if (document.formInformacoesContato.idOrigem.value == '') {
		alert(i18n_message("citcorpore.comum.origem") + ': ' + i18n_message("citcorpore.comum.campo_obrigatorio"));
		document.formInformacoesContato.idOrigem.focus();
		return;
	}
	if (document.formInformacoesContato.nomeSolicitante.value == '') {
		alert(i18n_message("solicitacaoServico.nomeDoSolicitante") + ': ' + i18n_message("citcorpore.comum.campo_obrigatorio"));
		document.formInformacoesContato.nomeSolicitante.focus();
		return;
	}
	if (document.formInformacoesContato.emailcontato.value == '') {
		alert(i18n_message("solicitacaoServico.emailContato") + ': ' + i18n_message("citcorpore.comum.campo_obrigatorio"));
		document.formInformacoesContato.emailcontato.focus();
		return;
	}
	if (document.formInformacoesContato.idUnidade.value == '') {
		alert(i18n_message("unidade.unidade") + ': ' + i18n_message("citcorpore.comum.campo_obrigatorio"));
		document.formInformacoesContato.idUnidade.focus();
		return;
	}
	if (document.formInformacoesContato.telefonecontato.value == '') {
			alert(i18n_message("solicitacaoServico.telefoneDoContato") + ': ' + i18n_message("citcorpore.comum.campo_obrigatorio"));
			document.formInformacoesContato.telefonecontato.focus();
			return;
	}
	if(ValidaEmail()) {
		JANELA_AGUARDE_MENU.show();
		document.formInformacoesContato.fireEvent("duplicarSolicitacao");
	}
}

function chamaPopupCadastroOrigemSub(){
	if (document.formInformacoesContato.idContrato.value == ''){
		alert(i18n_message("solicitacaoservico.validacao.contrato"));
		return;
	}
	var idContrato = 0;
	try{
		idContrato = document.formInformacoesContato.idContrato.value;
	}catch(e){
	}
	document.getElementById('frameExibirOrigemSub').src = URL_SISTEMA+'pages/origemAtendimento/origemAtendimento.load?iframe=true&idContrato='+idContrato+'&subSolicitacao=S';
	$('#modal_origem_sub').modal('show');
}

function preencherComboOrigem() {
	document.form.fireEvent('chamaComboOrigem');
}

function montaParametrosAutocompleteSol(idContrato){
	var completeSolicitante = $('#nomeSolicitante').autocomplete({ 
		serviceUrl:'pages/autoCompleteSolicitante/autoCompleteSolicitante.load',
		noCache: true,
		onSelect: function(value, data){
			document.formInformacoesContato.idSolicitante.value = data;
			document.formInformacoesContato.nomeSolicitante.value = value;
			document.formInformacoesContato.nomecontato.value = data;
			document.formInformacoesContato.fireEvent("restaurarSolicitanteEmDuplicarSolicitacao");
		}
	});
	
	completeSolicitante.setOptions({params: {contrato: idContrato} });
}

function exibirSubSolicitacoes(idSolicitacaoServico){
	document.formIncidentesRelacionados.idSolicitacaoIncRel.value = idSolicitacaoServico;
	document.formIncidentesRelacionados.fireEvent("abrirListaDeSubSolicitacoes");
	$('#modal_exibirSubSolicitaces').modal('show');
}

function reativarSolicitacao(idTarefa, idSolicitacao) {
	if (!confirm(i18n_message("gerencia.confirm.reativacaoSolicitacao"))) 
		return;
	document.form.idSolicitacaoSel.value = idSolicitacao;
	document.form.idTarefa.value = idTarefa;
	document.form.fireEvent('reativaSolicitacao'); 
}

function capturarTarefa(responsavelAtual, idTarefa) {
	var msg = "";
	if (responsavelAtual == '') {
		msg = i18n_message("gerencia.confirm.atribuicaotarefa") + " " + nomeUsuario + "?";
	} else {
		msg = i18n_message("gerencia.confirm.atribuicaotarefa_1") + " " + responsavelAtual + " " 
			+ i18n_message("gerencia.confirm.atribuicaotarefa_2") + " " + nomeUsuario
			+ i18n_message("gerencia.confirm.atribuicaotarefa_3");
	}
	
	$('#modal_confirm .modal-body').html(msg);
	$('#modal_confirm .modal-footer .confirm').attr("onclick", "confirmar(" + idTarefa + ");");
	
	$('#modal_confirm').modal('show');
}

function confirmar(idTarefa) {
	JANELA_AGUARDE_MENU.show();
	document.form.idTarefa.value = idTarefa;
	document.form.fireEvent('capturaTarefa');
}

function modalSolicitacoesFilhas(idSolicitacaoPai){
	document.getElementById('idSolicitacaoSel').value = idSolicitacaoPai;
	document.form.fireEvent('abrirListaDeSubSolicitacoes');
	$('#modal_solicitacaofilha').modal('show');
}

function visualizarSolicitacaoPaiEnvio(idSolicitacaoServico, idTarefa) {
	document.getElementById('frameNovaSolicitacao').src =  URL_SISTEMA+'pages/solicitacaoServicoMultiContratos/solicitacaoServicoMultiContratos.load?idSolicitacaoServico='+idSolicitacaoServico+'&idTarefa='+idTarefa+'&escalar=N&alterarSituacao=N&editar=N&acaoFluxo=V';
	$('#modal_novaSolicitacao').modal('show');
}

function visualizarSolicitacaoPaiEnvioDoAction(idSolicitacaoServico) {
	document.getElementById('idSolicitacaoSel').value = idSolicitacaoServico;
	document.form.fireEvent('buscarItemTtrabalhoSolicitacao');
}

function redimensionaJanela(obj) {
	if ($(obj).hasClass("resize_full")) {
		$(obj).removeClass("resize_full").addClass("resize_small");
		ajustarTemplate();
	} else {
		$(obj).removeClass("resize_small").addClass("resize_full");
		ajustarPadraoCitsmart();
	}
}

function ValidaEmail() {
	var email = $("#emailcontato").val();
	var emailValido=/^.+@.+\..{2,}$/;

	if(!emailValido.test(email)) {
		alert(i18n_message("solicitacaoServico.emailContato") + ': ' + i18n_message("citcorpore.validacao.emailInvalido"));
		document.formInformacoesContato.emailcontato.focus();
		return false;
	}
	return true;
}

function renderizarResumoSolicitacoes() {
	JANELA_AGUARDE_MENU.show();
	document.form.fireEvent('exibirResumoSolicitacoes');
}

function pesquisarItensDeConfiguracaoRelacionados(idSolicitacaoPai){
	document.getElementById('idSolicitacaoSel').value = idSolicitacaoPai;
	document.form.fireEvent('pesquisarItensDeConfiguracaoRelacionados');
}

function pesquisarAnexos(idSolicitacaoPai){
	document.getElementById('idSolicitacaoSel').value = idSolicitacaoPai;
	document.form.fireEvent('pesquisarAnexos');
}

function popupAtivos(id){
	var idItem = id;
	
	document.getElementById('iframeInformacaoItemConfiguracao').src = URL_SISTEMA+'pages/gerenciamentoItemConfiguracao/gerenciamentoItemConfiguracao.load?iframe=true&iFramInformacaoItemConfiguracao=true&idInfoItem=' + idItem;
	$("#modal_informacaoItemConfiguracao").modal("show");
}

function ajustarTemplate(){
	$('#modal_novaSolicitacao').css({
		'width': '97%',
		'height': 'auto',
		'margin-top': '0% !important',
		'margin-left': '-48.5%'
	});
	
	$('#modal_novaSolicitacao .modal-body').css('max-height', '92%');
	$('#frameNovaSolicitacao').attr('style', 'min-height: 865px !important;');
}

function ajustarPadraoCitsmart(){
	$('#modal_novaSolicitacao').css({
		'width': '80%',
		'height': 'auto',
		'margin-top': '0% !important',
		'margin-left': '-40% '
	});
	
	$('#modal_novaSolicitacao .modal-body').css('max-height', '700px');
	$('#frameNovaSolicitacao').attr('style', 'min-height: 690px !important;');
}

function paginarItens(paginaSelecionada) {
	if (paginaSelecionada <= -1) {
		paginaSelecionada = 1;
	}
	janelaAguarde();
	document.formGerenciamento.paginaSelecionada.value = paginaSelecionada;
	document.formGerenciamento.fireEvent('paginarItens');
}

function atualizarLista() {
	janelaAguarde();
	document.form.fireEvent('atualizarLista');
}

function atualizarListaPorQtdItens() {
	janelaAguarde();
	$('#paginaSelecionada').val('1');
	document.formGerenciamento.fireEvent('atualizarLista');
}

function atualizarListaPorOrdem(ordenacao, ordem) {
	janelaAguarde();
	document.formGerenciamento.ordenacaoAsc.value = ordem;
	document.formGerenciamento.nomeCampoOrdenacao.value = ordenacao;
	document.formGerenciamento.fireEvent('atualizarLista');
}

function janelaAguarde() {
	JANELA_AGUARDE_MENU.show();
}

function fechaJanelaAguarde() {
	JANELA_AGUARDE_MENU.hide();
}

function carregarValorClasse(valor, classe) {
	divs = document.getElementsByClassName(classe);
	[].slice.call(divs).forEach(function(div) {
		div.innerHTML = valor;
	});
}

function refreshTelaGerenciamento() {
	JANELA_AGUARDE_MENU.show();
	document.formGerenciamento.fireEvent('pesquisarItensFiltro');
}

function carregaListaServico(){
	pesquisarItensFiltro();
}

function pesquisarItensFiltro() {
	janelaAguarde();
	var numero_idSolicitacao_ = NumberUtil.apenasNumeros(document.formGerenciamento.idSolicitacao.value);
	document.formGerenciamento.idSolicitacao.value = numero_idSolicitacao_;
	document.formGerenciamento.fireEvent('pesquisarItensFiltro');
}

function atualizaPagina() {
	if ($("#atualizacaoAutomatica").hasClass("active")) {
		$('#paginaSelecionada').val('1');
		var numero_idSolicitacao_ = NumberUtil.apenasNumeros(document.formGerenciamento.idSolicitacao.value);
		document.formGerenciamento.idSolicitacao.value = numero_idSolicitacao_;
		document.formGerenciamento.fireEvent('atualizacaoAutomatica');
	}
}

window.setInterval(atualizaPagina, 30000);

/*
 * Gráficos
 */

var dadosGrafico;
var dadosGrafico2;
var dadosGrafico4;
var dadosGerais;
var scriptTemposSLA = '';
var temporizador;
exibirGraficos = function(json_tarefas) {
	var tarefas = [];
	// json_tarefas = '';
	// $("#ajaxX").text(json_tarefas);
	var qtdeAtrasadas = 0;
	var qtdeSuspensas = 0;
	var qtdeEmAndamento = 0;
	var qtdePri1 = 0;
	var qtdePri2 = 0;
	var qtdePri3 = 0;
	var qtdePri4 = 0;
	var qtdePri5 = 0;
	var qtdeItens = 0;
	var colGrupoSol = new HashMap();
	scriptTemposSLA = "";

	arrayTarefas = ObjectUtils
			.deserializeCollectionFromStringSemQuebraEnter(json_tarefas);
	for (var i = 0; i < arrayTarefas.length; i++) {
		var tarefaDto = arrayTarefas[i];
		tarefaDto.solicitacaoDto = ObjectUtils
				.deserializeObject(tarefaDto.solicitacao_serialize);
		tarefaDto.elementoFluxoDto = ObjectUtils
				.deserializeObject(tarefaDto.elementoFluxo_serialize);
	}

	var strTableTemposSLA = '';
	strTableTemposSLA += "<img width='20' height='20' ";
	strTableTemposSLA += "alt='" + i18n_message('ativaotemporizador')
			+ "' id='imgAtivaTimer' style='opacity:0.5;display:none' ";
	strTableTemposSLA += "title='"
			+ i18n_message('citcorpore.comum.ativadestemporizador') + "' ";
	strTableTemposSLA += "src='" + contextoAplicacao
			+ "/template_new/images/cronometro.png'/>";
	strTableTemposSLA += "<table class=\"table\" cellpadding=\"0\" cellspacing=\"0\">";
	strTableTemposSLA = strTableTemposSLA + "<tr><td><b>"
			+ i18n_message('gerenciaservico.slasandamento') + "</b></td></tr>";
	inicializarTemporizador();
	for (var i = 0; i < arrayTarefas.length; i++) {
		var idSolicitacaoServico = "";
		var contrato = "";
		var responsavel = "";
		var servico = "";
		var solicitante = "";
		var prioridade = "";
		var situacao = "";
		var sla = "";
		var dataHoraSolicitacao = "";
		var dataHoraLimite = "";
		var grupoAtual = "";
		var farolAux = "";

		var tarefaDto = arrayTarefas[i];
		var solicitacaoDto = tarefaDto.solicitacaoDto;
		if (solicitacaoDto != null) {
			if (solicitacaoDto.prioridade == '1') {
				qtdePri1++;
			}
			if (solicitacaoDto.prioridade == '2') {
				qtdePri2++;
			}
			if (solicitacaoDto.prioridade == '3') {
				qtdePri3++;
			}
			if (solicitacaoDto.prioridade == '4') {
				qtdePri4++;
			}
			if (solicitacaoDto.prioridade == '5') {
				qtdePri5++;
			}
			var grupoNome = solicitacaoDto.grupoAtual;
			if (grupoNome == null) {
				grupoNome = '-- '
						+ i18n_message("citcorpore.comum.aclassificar") + '--';
			}
			var auxGrp = colGrupoSol.get(grupoNome);
			if (auxGrp != undefined) {
				auxGrp.qtde++;
			} else {
				var grupoQtde = new GrupoQtde();
				grupoQtde.id = grupoNome;
				grupoQtde.qtde = 1;
				colGrupoSol.set(grupoNome, grupoQtde);
			}

			idSolicitacaoServico = "" + solicitacaoDto.idSolicitacaoServico;
			responsavel = "" + trocaBarra(solicitacaoDto.responsavel);
			contrato = "" + trocaBarra(solicitacaoDto.contrato);
			servico = "" + trocaBarra(solicitacaoDto.servico);
			solicitante = "" + trocaBarra(solicitacaoDto.solicitanteUnidade);
			if (solicitacaoDto.prazoHH < 10)
				sla = "0";
			sla += solicitacaoDto.prazoHH + ":";
			if (solicitacaoDto.prazoMM < 10)
				sla += "0";
			sla += solicitacaoDto.prazoMM;
			prioridade = "" + solicitacaoDto.prioridade;
			dataHoraSolicitacao = solicitacaoDto.dataHoraSolicitacaoStr;
			if (solicitacaoDto.situacaoSLA == situacaoSLA_A) {
				dataHoraLimite = solicitacaoDto.dataHoraLimiteStr;
			}
			grupoAtual = trocaBarra(solicitacaoDto.grupoAtual);

			if (parseFloat(solicitacaoDto.atrasoSLA) > parseFloat("0,00")
					&& solicitacaoDto.idStatus != situacaoSolicitacaoServico_Suspensa
					&& solicitacaoDto.idStatus != situacaoSolicitacaoServico_Cancelada) {
				qtdeAtrasadas++;
			} else if (solicitacaoDto.idStatus == situacaoSolicitacaoServico_Suspensa) {
				qtdeSuspensas++;
			} else {
				qtdeEmAndamento++;
				if (qtdeItens < 15) {
					if (solicitacaoDto.slaACombinar
							&& solicitacaoDto.slaACombinar != 'S'
							&& solicitacaoDto.situacaoSLA == 'A') {
						scriptTemposSLA += "temporizador.addOuvinte(new Solicitacao('tempoRestante"
								+ solicitacaoDto.idSolicitacaoServico
								+ "', "
								+ "'barraProgresso"
								+ solicitacaoDto.idSolicitacaoServico
								+ "', "
								+ "'"
								+ solicitacaoDto.dataHoraInicioSLAStr
								+ "', '"
								+ solicitacaoDto.dataHoraLimiteToString
								+ "'));";
						strTableTemposSLA = strTableTemposSLA
								+ "<tr><td>N.o <b>"
								+ solicitacaoDto.idSolicitacaoServico
								+ "</b>: <label class='crono' id='tempoRestante"
								+ solicitacaoDto.idSolicitacaoServico
								+ "'></label>";
						strTableTemposSLA = strTableTemposSLA
								+ "<div id='barraProgresso"
								+ solicitacaoDto.idSolicitacaoServico
								+ "'></div></td></tr>";
					} else if (solicitacaoDto.slaACombinar
							&& solicitacaoDto.slaACombinar == 'S') {
						strTableTemposSLA = strTableTemposSLA
								+ "<tr><td>N.o <b>"
								+ solicitacaoDto.idSolicitacaoServico
								+ "</b>: <label id='tempoRestante"
								+ solicitacaoDto.idSolicitacaoServico
								+ "'><font color='red'>"
								+ i18n_message('citcorpore.comum.acombinar')
								+ " </font></label>";
					} else if (solicitacaoDto.situacaoSLA == 'N') {
						strTableTemposSLA = strTableTemposSLA
								+ "<tr><td>N.o <b>"
								+ solicitacaoDto.idSolicitacaoServico
								+ "</b>: <label id='tempoRestante"
								+ solicitacaoDto.idSolicitacaoServico
								+ "'><font color='red'>"
								+ i18n_message('citcorpore.comum.naoIniciado')
								+ " </font></label>";
					} else if (solicitacaoDto.situacaoSLA == 'S') {
						strTableTemposSLA = strTableTemposSLA
								+ "<tr><td>N.o <b>"
								+ solicitacaoDto.idSolicitacaoServico
								+ "</b>: <label id='tempoRestante"
								+ solicitacaoDto.idSolicitacaoServico
								+ "'><font color='red'>"
								+ i18n_message('citcorpore.comum.suspenso')
								+ " </font></label>";
					}
				}
				qtdeItens++;
			}
		}
		tarefas[i] = {
			iniciar : tarefaDto.executar,
			executar : tarefaDto.executar,
			delegar : tarefaDto.delegar,
			idSolicitacaoServico : idSolicitacaoServico,
			contrato : contrato,
			responsavel : responsavel,
			servico : servico,
			solicitanteUnidade : solicitante,
			prioridade : prioridade,
			dataHoraSolicitacao : dataHoraSolicitacao,
			descricao : trocaBarra(tarefaDto.elementoFluxoDto.documentacao),
			status : "",
			atraso : solicitacaoDto.atrasoSLA,
			sla : sla,
			atrasoSLA : "",
			dataHoraLimite : dataHoraLimite,
			responsavelAtual : tarefaDto.responsavelAtual,
			compartilhamento : tarefaDto.compartilhamento,
			grupoAtual : grupoAtual
		}
	}
	strTableTemposSLA = strTableTemposSLA + '</table>';
	if (qtdeAtrasadas > 0 || qtdeSuspensas > 0 || qtdeEmAndamento > 0) {
		var info = '';
		if (qtdeAtrasadas > 0) {
			info += ' <font color="red"><b>'
					+ qtdeAtrasadas
					+ '</b> '
					+ i18n_message("solicitacaoServico.solicitacoes_incidentes_atrasado")
					+ '</font><br>';
		}
		if (qtdeSuspensas > 0) {
			info += ' <b>'
					+ qtdeSuspensas
					+ '</b>'
					+ i18n_message("solicitacaoServico.solicitacoes_incidentes_suspenso");
		}
		info = i18n_message("solicitacaoServico.existem")
				+ ' <br>'
				+ info
				+ '<br><div id="divTemposSLA" style="height:280px; overflow:auto;">'
				+ strTableTemposSLA + '</div>';
		info = '<table cellpadding="0" cellspacing="0"><tr><td style="width:15px">&nbsp;</td><td style="vertical-align: top; width: 100%; height: 250px">'
				+ info + '</td></tr></table>';
		document.getElementById('tdAvisosSol').innerHTML = info;
		dadosGrafico = [ {
			label : i18n_message('citcorpore.comum.normal'),
			data : qtdeEmAndamento
		}, {
			label : i18n_message('citcorpore.comum.suspensa'),
			data : qtdeSuspensas
		}, {
			label : i18n_message('citcorpore.comum.vencido'),
			data : qtdeAtrasadas
		} ];
		dadosGrafico2 = [ {
			label : " 1 ",
			data : qtdePri1
		}, {
			label : " 2 ",
			data : qtdePri2
		}, {
			label : " 3 ",
			data : qtdePri3
		}, {
			label : " 4 ",
			data : qtdePri4
		}, {
			label : " 5 ",
			data : qtdePri5
		} ];
		window.setTimeout(atualizaGrafico, 1000);
		window.setTimeout(atualizaGrafico2, 1000);

		var colArray = colGrupoSol.toArray();
		dadosGerais = new Array();
		if (colArray) {
			for (var iAux = 0; iAux < colArray.length; iAux++) {
				dadosGerais[iAux] = {
					label : colArray[iAux].id,
					data : colArray[iAux].qtde
				};
			}
		}
		window.setTimeout(atualizaGrafico3, 1000);
		document.formGerenciamento.quantidadeAtrasadas.value = qtdeAtrasadas;
		document.formGerenciamento.quantidadeTotal.value = (qtdeEmAndamento
				+ qtdeSuspensas + qtdeAtrasadas);
	}

	JANELA_AGUARDE_MENU.hide();
};

function atualizaGrafico() {
	plotaGrafico(dadosGrafico, "divGrafico");
	eval(scriptTemposSLA);
	temporizador.init();
	temporizador.ativarDesativarTimer();
}
function atualizaGrafico2(){
	plotaGrafico(dadosGrafico2, "divGrafico2");
}
function atualizaGrafico3(){
	plotaGrafico(dadosGerais, "divGrafico3");
}

function plotaGrafico(dados, idDiv) {
	var div = '#' + idDiv;
	$.plot(div, dados, {
		series : {
			pie : {
				innerRadius : 0.0,
				show : true,
				highlight : {
					opacity : 0.1
				},
				radius : 1,
				stroke : {
					color : '#fff',
					width : 8
				},
				startAngle : 2,
				combine : {
					color : '#EEE',
					threshold : 0.05
				},
				label : {
					show : true,
					radius : 1,
					formatter : function(label, series) {
						return '<div class="label label-inverse">' + label
								+ '&nbsp;' + Math.round(series.percent)
								+ '%</div>';
					}
				}
			},
			grow : {
				active : true
			},
			legend : {
				show : false
			},
			grid : {
				hoverable : true,
				clickable : true

			},
			colors : [],
			tooltip : true,
			tooltipOpts : {
				content : "%s : %y.1" + "%",
				shifts : {
					x : -30,
					y : -50
				},
				defaultTheme : true
			}
		}
	});
}

function GrupoQtde() {
	this.id = '';
	this.qtde = 0;
}

function trocaBarra(txt) {
	var x = new String(txt);
	x = x.replace(/{{BARRA}}/g, '\\');
	return x;
}

function inicializarTemporizador(){
	if(temporizador == null){
		temporizador = new Temporizador("imgAtivaTimer");
	} else {
		temporizador = null;
		try{
			temporizador.listaTimersAtivos = [];
		}catch(e){}
		try{
			temporizador.listaTimersAtivos.length = 0;
		}catch(e){}
		temporizador = new Temporizador("imgAtivaTimer");
	}
}

/*
 * Cadastro Rapido
 */

var completeServico;
var completeServicoNegocioTecnico;
var completeSolicitante;
var completeUnidade;

var parametroFiltrarCategoriaServico = false;

$(document).ready(function() {
	$('#servicoBuscaCadastroRapido').on('click', function(){
		montaParametrosAutocompleteServico();
	});
	
	completeSolicitante = $('#nomeSolicitanteCadastroRapido').autocomplete({ 
		serviceUrl:'pages/autoCompleteSolicitante/autoCompleteSolicitante.load',
		noCache: true,
		onSelect: function(value, data){
			$('#idSolicitanteCadastroRapido').val(data);
			$('#nomeSolicitanteCadastroRapido').val(value);
			$('#nomeContatoCadastroRapido').val(value);
			
			document.formCadastroRapido.fireEvent("restaurarSolicitante");
			document.formCadastroRapido.fireEvent("carregaContratosCadastroRapido");
			document.formCadastroRapido.fireEvent("carregaItemConfiguracaoSolicitante");
		}
	});
	
	completeServicoNegocioTecnico = $('#servicoNegocioTecnicoBuscaCadastroRapido').on("focus", function (event) {
		montaParametrosAutocompleteServicoNegocioTecnico();
		if (verificaSeContratoEstaVazio() || verificaSeCatalogoEstaVazio()) {
			lancarErroContratoOuCatalogoSelecionados();
			event.preventDefault();
		}
	}).autocomplete({
		serviceUrl:'pages/autoCompleteServicoNegocioTecnico/autoCompleteServicoNegocioTecnico.load',
		noCache: true,
		onSelect: function(value, data){
			$('#idServicoNegocioTecnicoBuscaCadastroRapido').val(data);
			$('#servicoNegocioTecnicoBuscaCadastroRapido').val(value);
		}
	});
	
	completeServico = $('#servicoBuscaCadastroRapido').on("focus", function (event) {
		montaParametrosAutocompleteServico();
	}).autocomplete({
		serviceUrl:'pages/autoCompleteServico/autoCompleteServico.load',
		noCache: true,
		onSelect: function(value, data){
			$('#idServicoCadastroRapido').val(data);
			$('#servicoBuscaCadastroRapido').val(value);
			
			document.formCadastroRapido.fireEvent('verificaImpactoUrgencia');
			document.formCadastroRapido.fireEvent('carregaBaseConhecimentoAssoc');
			document.formCadastroRapido.fireEvent('verificaGrupoExecutor');
			
			calcularSLA();
			carregaFiltrosServico();
		}
	});
});

function montaParametrosAutocompleteUnidade(){
	var contrato = $("#idContratoCadastroRapido").val();
	completeUnidade.setOptions({params: {idContrato: contrato} });
}

function geraAutoComplete(){
	completeUnidade = $('#unidadeDesCadastroRapido').autocomplete({
		serviceUrl : 'pages/autoCompleteUnidade/autoCompleteUnidade.load',
		noCache : true,
		onSelect : function(value, data) {
			$('#idUnidadeCadastroRapido').val(data);
			$('#unidadeDesCadastroRapido').val(value.replace(/-*/, ""));
			changeUnidade();
		}
	});
}

function montaParametrosAutocompleteServico(){
	var tipoDemanda = $("#idTipoDemandaServicoCadastroRapido").val();
	var contrato = $("#idContratoCadastroRapido").val();
	var categoria = $("#idCategoriaServicoCadastroRapido").val();
	var pTipoServico = $("#idTipoCatalogoServicoSolicitacaoCadastroRapido").val();
	var pIdServico = $('#idServicoNegocioTecnicoBuscaCadastroRapido').val();
	
	if(!isUtilizaCategoriaServico()){
		categoria = "";
	}
	
	completeServico.setOptions({params: {contrato: contrato, tipoDemanda: tipoDemanda, categoria : categoria, tipoServicoNegocioTecnico : pTipoServico, idServicoNegocioTecnico : pIdServico} });
	completeSolicitante.setOptions({params: {contrato: contrato} });
}

function montaParametrosAutocompleteServicoNegocioTecnico(){
	var pContrato =  $("#idContratoCadastroRapido").val();
	var pTipoServico = $("#idTipoCatalogoServicoSolicitacaoCadastroRapido").val();
	
	completeServicoNegocioTecnico.setOptions({params: {contrato: pContrato, tipoServico: pTipoServico} });
}

function ocultarCheckboxUtilizarCategoriaServico() {
	parametroFiltrarCategoriaServico = true;
	$("#checkUtilizaCategoriaServico").remove();
	$(".divCategoriaServico").removeClass("span8").addClass("span12");
}

function isUtilizaCategoriaServico() {
	if (parametroFiltrarCategoriaServico && $("#idCategoriaServicoCadastroRapido").val() != '') {
		return true;
	}
	
	return $("#utilizaCategoriaServicoCadastroRapido").is(":checked");
}

function changeCatalogoServicoSolicitacao() {
	montaParametrosAutocompleteServicoNegocioTecnico();
	limparServicoNegocioTecnico();
	limparServico();
	limparCampoServiceBusca();
}

function changeTipoSolicitacaoServico() {
	montaParametrosAutocompleteServico();
	limparCampoServiceBusca();
}

function eventoStartLoading(evt) {
	if( evt.keyCode != 37 && evt.keyCode != 38 && evt.keyCode != 39 && evt.keyCode != 40){
		startLoading();
	}
}

function startLoading() {
	$('#tdResultadoSLAPrevisto').text('');
	var servicoBusca = document.formCadastroRapido.servicoBuscaCadastroRapido.value;
	if(servicoBusca != ''){
		document.getElementById('divMini_loading').style.display = 'block';
	} else {
		document.getElementById('divMini_loading').style.display = 'none';
	}
}

function stopLoading() {
	document.getElementById('divMini_loading').style.display = 'none';
}

function stopSLAPrevisto(){
	$('#tdResultadoSLAPrevisto').text('');
}

function exibeCalculoSLA(valor, cor) {
	stopLoading();
	$('#tdResultadoSLAPrevisto').text(valor);
	
	if (cor == '#e5e5e5') {
		$('#tdResultadoSLAPrevisto').css("background-color", "#e5e5e5");
		$('#tdResultadoSLAPrevisto').css("color", "black");
	} else {
		$('#tdResultadoSLAPrevisto').css("background-color", cor);
		$('#tdResultadoSLAPrevisto').css("color", "white");
	}
}

function calcularSLA() {
	startLoading();
	var temp = 'var statusDisabledUrgencia = document.formCadastroRapido.urgenciaCadastroRapido.disabled;';
	temp += 'var statusDisabledImpacto = document.formCadastroRapido.impactoCadastroRapido.disabled;';
	temp += 'document.formCadastroRapido.urgenciaCadastroRapido.disabled = false;';
	temp += 'document.formCadastroRapido.impactoCadastroRapido.disabled = false;';
	temp += 'document.formCadastroRapido.fireEvent("calculaSLA");';
	temp += 'document.formCadastroRapido.urgenciaCadastroRapido.disabled = statusDisabledUrgencia;';
	temp += 'document.formCadastroRapido.impactoCadastroRapido.disabled = statusDisabledImpacto;';
	temp += 'JANELA_AGUARDE_MENU.hide();';
	setTimeout(temp, 1500);
}

function limparServico(){
	$('#servicoBuscaCadastroRapido').val('');
	$("#idServicoCadastroRapido").val( '' );
}

function limparServicoNegocioTecnico(){
	$("#idServicoNegocioTecnicoBuscaCadastroRapido").val('');
	$("#servicoNegocioTecnicoBuscaCadastroRapido").val('');
	montaParametrosAutocompleteServico();
}

function limparCampoServiceBusca() {
	document.formCadastroRapido.servicoBuscaCadastroRapido.value = '';
}

function carregaCategoriaServico(){
	if($("#utilizaCategoriaServicoCadastroRapido").is(":checked")){
		JANELA_AGUARDE_MENU.show();
		document.formCadastroRapido.fireEvent("carregarComboCategoriaServico");
	} else {
		$("#idCategoriaServicoCadastroRapido").attr('disabled', true).addClass('disabled');
		$("#idCategoriaServicoCadastroRapido").empty();
	}
	
	limparServico();
}

function depoisCarregarComboCategoria() {
	JANELA_AGUARDE_MENU.hide();
	$("#idCategoriaServicoCadastroRapido").attr('disabled', false).removeClass('disabled');
}

function carregaFiltrosServico() {
	document.formCadastroRapido.fireEvent("definirFiltrosServico");
}

function verificaSeContratoEstaVazio() {
	if ($("#idContratoCadastroRapido").val() == '') {
		return true;
	}
	
	return false;
}

function verificaSeCatalogoEstaVazio() {
	if ($("#idTipoCatalogoServicoSolicitacaoCadastroRapido").val() == '') {
		return true;
	}
	
	return false;
}

function verificaSeTipoSolicitacaoEstaVazio() {
	if ($("#idTipoDemandaServicoCadastroRapido").val() == '') {
		return true;
	}
	
	return false;
}

function changeContrato() {
	montaParametrosAutocompleteServico();
	montaParametrosAutocompleteServicoNegocioTecnico();
	verificaTipoDeAcordoDoContrato();
}
function changeUnidade() {
	document.formCadastroRapido.fireEvent('verificaImpactoUrgencia');
	calcularSLA();
}

function verificaTipoDeAcordoDoContrato() {
	document.formCadastroRapido.fireEvent("verificaTipoDeAcordoDoContrato");
}

function buscarTodosServicosNegocioTecnico() {
	if (verificaSeContratoEstaVazio() || verificaSeCatalogoEstaVazio()) {
		lancarErroContratoOuCatalogoSelecionados();
	} else {
		$('#filtroTableServicosNegocioTecnico').val("");
		$('#filtroTableServicosNegocioTecnico').focus();
		
		var idTipoCatalogoServicoSolicitacaoCadastroRapidoStats = document.formCadastroRapido.idTipoCatalogoServicoSolicitacaoCadastroRapido.disabled;
		document.formCadastroRapido.idTipoCatalogoServicoSolicitacaoCadastroRapido.disabled = false;
		
		document.formCadastroRapido.fireEvent('listarServicosNegocioTecnico', function() {
			document.formCadastroRapido.idTipoCatalogoServicoSolicitacaoCadastroRapido.disabled = idTipoCatalogoServicoSolicitacaoCadastroRapidoStats;
		});
		
		JANELA_AGUARDE_MENU.show();
	}
}

function selecionarServicoNegocioTecnico(row, obj){
	JANELA_AGUARDE_MENU.show();
	
	$('#idServicoNegocioTecnicoBuscaCadastroRapido').val(obj.idServico);
	$('#servicoNegocioTecnicoBuscaCadastroRapido').val(obj.nomeServico);
	
	limparServico();
	stopSLAPrevisto();
	
	$('#modal_infoServicosNegocioTecnico').modal('hide');
	
	JANELA_AGUARDE_MENU.hide();
}

function buscarTodosServicos(){
	$('#filtroTableServicos').val("");
	$('#filtroTableServicos').focus();
	document.formCadastroRapido.fireEvent('listarServicos');
	
	JANELA_AGUARDE_MENU.show();
}

function selecionarServico(row, obj){
	JANELA_AGUARDE_MENU.show();
	
	$('#idServicoCadastroRapido').val(obj.idServico);
	$('#servicoBuscaCadastroRapido').val(obj.nomeServico);
	
	document.formCadastroRapido.fireEvent('verificaImpactoUrgencia');
	calcularSLA();
	
	$('#modal_infoServicos').modal('hide');
	carregaFiltrosServico();
	
	JANELA_AGUARDE_MENU.hide();
}

function verificaImpactoUrgencia() {
	document.formCadastroRapido.fireEvent('verificaImpactoUrgencia');
}

function loadTemplate() {
	document.formCadastroRapido.fireEvent('loadTemplate');
}

function depoisListarServicos() {
	JANELA_AGUARDE_MENU.hide();
}

function lancarErroContratoOuCatalogoSelecionados(){
	notificacaoI18N("citcorpore.comum.impossivelRealizarConsulta", "solicitacaoServico.verifiqueContratoOuCatalogo");
}

function abrirModalPesquisaItemConfiguracao(){
	document.getElementById('framePesquisaItemConfiguracao').src = URL_SISTEMA+'pages/pesquisaItemConfiguracao/pesquisaItemConfiguracao.load?iframe=true';
	$('#modal_pesquisaItemConfiguracao').modal('show');
}

function selectedItemConfiguracao(idItemCfg, identificacao) {
	$("#itensConfiguracaoSelecionados .nenhum-selecionado").remove();
	
	var idsItemConfiguracaoCadastroRapido = [];
	if ($("#idsItemConfiguracaoCadastroRapido").attr("value") != "") {
		idsItemConfiguracaoCadastroRapido = JSON.parse($("#idsItemConfiguracaoCadastroRapido").attr("value"));
		
		var index = idsItemConfiguracaoCadastroRapido.indexOf(parseInt(idItemCfg));
		if (index != -1) {
			$('#modal_pesquisaItemConfiguracao').modal('hide');
			return;
		}
		
		idsItemConfiguracaoCadastroRapido.push(idItemCfg);
	} else {
		idsItemConfiguracaoCadastroRapido.push(idItemCfg);
	}
	
	$("#idsItemConfiguracaoCadastroRapido").attr("value", JSON.stringify(idsItemConfiguracaoCadastroRapido));
	
	$('<div class="ic-item" data-ic="' + idItemCfg + '"><i class="material-icons md-14" onclick="removeItemConfiguracao(this)">cancel</i>' + identificacao + '</div>').insertBefore('#itensConfiguracaoSelecionados .clearfix');
	
	//document.formCadastroRapido.fireEvent("restoreItemConfiguracao");
	
	$('#modal_pesquisaItemConfiguracao').modal('hide');
}

function removeItemConfiguracao(_this) {
	var idItemConfiguracao = $(_this).parent(".ic-item").attr("data-ic");
	
	var idsItemConfiguracaoCadastroRapido = [];
	if ($("#idsItemConfiguracaoCadastroRapido").attr("value") != "") {
		idsItemConfiguracaoCadastroRapido = JSON.parse($("#idsItemConfiguracaoCadastroRapido").attr("value"));
	}
	
	var index = idsItemConfiguracaoCadastroRapido.indexOf(parseInt(idItemConfiguracao));
	if (index != -1) {
		idsItemConfiguracaoCadastroRapido.splice(index, 1);
	}
	
	$("#idsItemConfiguracaoCadastroRapido").attr("value", JSON.stringify(idsItemConfiguracaoCadastroRapido));
	
	if (idsItemConfiguracaoCadastroRapido.length <= 0) {
		$('<div class="nenhum-selecionado">' + i18n_message("citcorpore.comum.nenhumaSelecao") + '</div>').insertBefore('#itensConfiguracaoSelecionados .clearfix');
	}
	
	$(_this).parent(".ic-item").remove();
}

function gravarCadastroRapido() {
	if (validaForm()) {
		JANELA_AGUARDE_MENU.show();
		
		var idTipoCatalogoServicoSolicitacaoCadastroRapidoStats = document.formCadastroRapido.idTipoCatalogoServicoSolicitacaoCadastroRapido.disabled;
		var impactoCadastroRapido = document.formCadastroRapido.impactoCadastroRapido.disabled;
		var urgenciaCadastroRapido = document.formCadastroRapido.urgenciaCadastroRapido.disabled;
		
		document.formCadastroRapido.idTipoCatalogoServicoSolicitacaoCadastroRapido.disabled = false;
		document.formCadastroRapido.impactoCadastroRapido.disabled = false;
		document.formCadastroRapido.urgenciaCadastroRapido.disabled = false;
		
		document.formCadastroRapido.fireEvent('gravarCadastroRapido', function() {
			document.formCadastroRapido.idTipoCatalogoServicoSolicitacaoCadastroRapido.disabled = idTipoCatalogoServicoSolicitacaoCadastroRapidoStats;
			document.formCadastroRapido.impactoCadastroRapido.disabled = impactoCadastroRapido;
			document.formCadastroRapido.urgenciaCadastroRapido.disabled = urgenciaCadastroRapido;
		});
	}
}

function validaForm() {
	if ($("#nomeSolicitanteCadastroRapido").val() == '' || $("#idSolicitanteCadastroRapido").val() == '') {
		alert(i18n_message("solicitacaoServico.solicitante") + ": " + i18n_message("citcorpore.comum.campo_obrigatorio"));
		return;
	}
	
	var emailContatoCadastroRapido = $("#emailContatoCadastroRapido").val();
	if (emailContatoCadastroRapido == '') {
		alert(i18n_message("citcorpore.comum.email") + ": " + i18n_message("citcorpore.comum.campo_obrigatorio"));
		return;
	}
	if (emailContatoCadastroRapido != '') {
		if (!/\b[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\.[A-Za-z]{2,4}\b/.test(emailContatoCadastroRapido)) {
			alert(i18n_message("citcorpore.validacao.emailInvalido"));
			return;
		}
	}
	
	if ($("#idTipoDemandaServicoCadastroRapido").val() == '') {
		alert(i18n_message("solicitacaoServico.tipo") + ": " + i18n_message("citcorpore.comum.campo_obrigatorio"));
		return;
	}
	
	if ($("#servicoBuscaCadastroRapido").val() == '' || $("#idServicoCadastroRapido").val() == '') {
		alert(i18n_message("solicitacaoServico.requisicaoIncidente") + ": " + i18n_message("citcorpore.comum.campo_obrigatorio"));
		return;
	}
	
	if ($("#idContratoCadastroRapido").val() == '') {
		alert(i18n_message("contrato.contrato") + ": " + i18n_message("citcorpore.comum.campo_obrigatorio"));
		return;
	}
	
	if ($("#idUnidadeCadastroRapido").val() == '' || $("#idUnidadeCadastroRapido").val() == '0') {
		alert(i18n_message("unidade.unidade") + ": " + i18n_message("citcorpore.comum.campo_obrigatorio"));
		return;
	}
	
	if ($("#idOrigemContatoCadastroRapido").val() == '') {
		alert(i18n_message("citcorpore.comum.origemNovoLayout") + ": " + i18n_message("citcorpore.comum.campo_obrigatorio"));
		return;
	}
	
	if ($("#impactoCadastroRapido").val() == '') {
		alert(i18n_message("solicitacaoServico.impacto") + ": " + i18n_message("citcorpore.comum.campo_obrigatorio"));
		return;
	}
	
	if ($("#urgenciaCadastroRapido").val() == '') {
		alert(i18n_message("solicitacaoServico.urgencia") + ": " + i18n_message("citcorpore.comum.campo_obrigatorio"));
		return;
	}
	
	if ($("#descricaoCadastroRapido").val() == '') {
		alert(i18n_message("solicitacaoServico.descricao") + ": " + i18n_message("citcorpore.comum.campo_obrigatorio"));
		return;
	}
	
	if ($("#idStatusCadastroRapido").val() == 4 && $("#respostaCadastroRapido").val() == '') {
		alert(i18n_message("solicitacaoservico.solucaoResposta") + ": " + i18n_message("citcorpore.comum.campo_obrigatorio"));
		return;
	}

	return true;
}

function changeContrato() {
	document.formCadastroRapido.fireEvent("carregaUnidadeCadastroRapido");
	document.formCadastroRapido.fireEvent("verificaImpactoUrgencia");
}

function mostraMensagemInsercao(msg){
	document.getElementById('divInsercao').innerHTML = msg;
	$("#mensagem_insercao").modal("show");
}

function carregaScript() {
	JANELA_AGUARDE_MENU.show();
	
	document.formCadastroRapido.fireEvent('carregaBaseConhecimentoAssoc');
	
	$('#modal_script').modal('show');
}

function fecharModalNovaSolicitacao(){
	$('#modal_novaSolicitacao').modal('hide');
	$('#modal_reclassificarSolicitacao').modal('hide');
}

function fecharModalAgendarAtividade() {
	$('#modal_agendarAtividade').modal('hide');
}

function obtemArquivoTemporario(path){
	window.location = ctx + '/pages/visualizarUploadTemp/visualizarUploadTemp.load?path=' + path;
}

function abrirCadastroRapido(idTemplate) {
	Modal.close("modal_templatesSolicitacaoServico");
	
	$("#formCadastroRapido").find("input:text, input:hidden, select, textarea").val("");
	$("#formCadastroRapido").find('input:radio, input:checkbox').removeAttr('checked').removeAttr('selected');
	
	$("#tdResultadoSLAPrevisto").attr("style", "");
	$("#tdResultadoSLAPrevisto").text("N/A");
	
	$("#idContratoCadastroRapido").empty();
	$("#itensConfiguracaoSelecionados").html("<div class='nenhum-selecionado'>" + i18n_message("citcorpore.comum.nenhumaSelecao") + "</div><div class='clearfix'></div>");
	
	//Reinicia a dropzone para limpar os anexos antigos.
	myDropzone.destroy();
	inicializaDropzone();
	
	$("#formCadastroRapido #idTemplate").attr("value", idTemplate);
	
	document.formCadastroRapido.fireEvent("loadCadastroRapido");
	
	Modal.open("modal-cadastro-rapido");
}

function habilitaCheckCategoriaServico(){
	$( "#uniform-utilizaCategoriaServicoCadastroRapido span" ).addClass("checked");
	$( "#idCategoriaServicoCadastroRapido" ).removeClass("disabled");
}
function desabilitaCheckCategoriaServico(){
	$( "#uniform-utilizaCategoriaServicoCadastroRapido span" ).removeClass("checked");
	$("#idCategoriaServicoCadastroRapido").attr('disabled', true).addClass('disabled');
}

function chamarSuspenderReativarSolicitacaoGrid(){
	document.getElementById('frameSuspenderReativarSolicitacao').src = URL_SISTEMA+'pages/suspensaoReativacaoSolicitacao/suspensaoReativacaoSolicitacao.load?noVoltar=true&iframe=true';
	$('#modal_SuspenderReativarSolicitacao').modal('show');
}

function fecharModalSuspensaoReativacaoSolicitacao(){
	$('#modal_SuspenderReativarSolicitacao').modal('hide');
}

function refreshView() {
	if ($("#visualizacaoDetalhada").hasClass("active")) {
		$("#visualizacaoDetalhada").trigger("click");
	}
}