var objTab = null;

addEvent(window, "load", load, false);
function load() {
	document.form.afterRestore = function() {
		$('.tabsbar a[href="#tabCadastroJornadaTrabalho"]').tab('show');

	}
}

function JornadaTrabalhoDTO() {
	return {
		setInicio1 : function(inicio1) {
			if(inicio1.trim() != '') {
				inicio1 = moment(inicio1, 'hh:mm A').format('HH:mm');
			}
			this.inicio1 = inicio1;
		},
		setTermino1 : function(termino1) {
			if(termino1.trim() != '') {
				termino1 = moment(termino1, 'hh:mm A').format('HH:mm');
			}
			this.termino1 = termino1;
		},
		setInicio2 : function(inicio2) {
			if(inicio2.trim() != '') {
				inicio2 = moment(inicio2, 'hh:mm A').format('HH:mm');
			}
			this.inicio2 = inicio2;
		},
		setTermino2 : function(termino2) {
			if(termino2.trim() != '') {
				termino2 = moment(termino2, 'hh:mm A').format('HH:mm');
			}
			this.termino2 = termino2;
		},
		setInicio3 : function(inicio3) {
			if(inicio3.trim() != '') {
				inicio3 = moment(inicio3, 'hh:mm A').format('HH:mm');
			}
			this.inicio3 = inicio3;
		},
		setTermino3 : function(termino3) {
			if(termino3.trim() != '') {
				termino3 = moment(termino3, 'hh:mm A').format('HH:mm');
			}
			this.termino3 = termino3;
		},
		setInicio4 : function(inicio4) {
			if(inicio4.trim() != '') {
				inicio4 = moment(inicio4, 'hh:mm A').format('HH:mm');
			}
			this.inicio4 = inicio4;
		},
		setTermino4 : function(termino4) {
			if(termino4.trim() != '') {
				termino4 = moment(termino4, 'hh:mm A').format('HH:mm');
			}
			this.termino4 = termino4;
		},
		setInicio5 : function(inicio5) {
			if(inicio5.trim() != '') {
				inicio5 = moment(inicio5, 'hh:mm A').format('HH:mm');
			}
			this.inicio5 = inicio5;
		},
		setTermino5 : function(termino5) {
			if(termino5.trim() != '') {
				termino5 = moment(termino5, 'hh:mm A').format('HH:mm');
			}
			this.termino5 = termino5;
		},
	}
}

$(function() {
	onChangeTipoHorario();
});

function limpar() {
	document.form.clear();
	onChangeTipoHorario();
}

function maskTime24hs() {
	changeFormatData('hh:mm A', 'HH:mm');
	
	$('.time').mask('Hh:Mm', {
		translation : {
			'H' : {pattern : /[0-2]/},
			'h' : {pattern : /[0-9]/},
			'M' : {pattern : /[0-5]/},
			'm' : {pattern : /[0-9]/}
		}
	});
	
};

function maskTimeAmPm() {
	changeFormatData('HH:mm', 'hh:mm A');
	
	$('.time').mask('Hh:Mm Pp', {
		translation : {
			'H' : {	pattern : /[0-1]/},
			'h' : {pattern : /[0-9]/},
			'M' : {pattern : /[0-5]/},
			'm' : {pattern : /[0-9]/},
			'P' : {pattern : /[AaPp]/},
			'p' : {pattern : /[Mm]/}
		}
	});
	
};

function changeFormatData(formatoDataAtual, formatoDataMudar) {
	var inicio1 = $("#inicio1").val();
	var termino1 = $("#termino1").val();
	var inicio2 = $("#inicio2").val();
	var termino2 = $("#termino2").val();
	var inicio3 = $("#inicio3").val();
	var termino3 = $("#termino3").val();
	var inicio4 = $("#inicio4").val();
	var termino4 = $("#termino4").val();
	var inicio5 = $("#inicio5").val();
	var termino5 = $("#termino5").val();
	
	$('.time').unmask();
	
	if(inicio1 != "") {
		$("#inicio1").val(moment(inicio1, formatoDataAtual).format(formatoDataMudar));
	}
	
	if(termino1 != "") {
		$("#termino1").val(moment(termino1, formatoDataAtual).format(formatoDataMudar));
	}
	if(inicio2 != "") {
		$("#inicio2").val(moment(inicio2, formatoDataAtual).format(formatoDataMudar));
	}
	
	if(termino2 != "") {
		$("#termino2").val(moment(termino2, formatoDataAtual).format(formatoDataMudar));
	}
	
	if(inicio3 != "") {
		$("#inicio3").val(moment(inicio3, formatoDataAtual).format(formatoDataMudar));
	}
	
	if(termino3 != "") {
		$("#termino3").val(moment(termino3, formatoDataAtual).format(formatoDataMudar));
	}
	
	if(inicio4 != "") {
		$("#inicio4").val(moment(inicio4, formatoDataAtual).format(formatoDataMudar));
	}
	
	if(termino4 != "") {
		$("#termino4").val(moment(termino4, formatoDataAtual).format(formatoDataMudar));
	}
	
	if(inicio5 != "") {
		$("#inicio5").val(moment(inicio5, formatoDataAtual).format(formatoDataMudar));
	}
	
	if(termino5 != "") {
		$("#termino5").val(moment(termino5, formatoDataAtual).format(formatoDataMudar));
	}
}

function onChangeTipoHorario() {
	if($("#tipoHorario").val() == 1) {
		maskTime24hs();
	} else {
		maskTimeAmPm();
	}
}

function excluir() {
	var idJornadaTrabalho = document.getElementById("idJornada");
	if (idJornadaTrabalho != null && idJornadaTrabalho.value == 0) {
		alert(i18n_message("citcorpore.comum.necessarioSelecionarRegistro"));
		return false;
	}
	if (confirm(i18n_message("citcorpore.comum.deleta")))
		document.form.fireEvent("delete");
}

function LOOKUP_JORNADATRABALHO_select(id, desc) {
	document.form.restore({
		idJornada : id
	});
}

function isHoraValida(start, end, num) {
	var dateFormat = $("#tipoHorario").val() == 1 ? 'HH:mm' : 'hh:mm A';
	var validarStart = true;
	var validarEnd = true;
	
	if(start.trim() == '') {
		validarStart = false;
	}
	
	if(end.trim() == '') {
		validarEnd = false;
	}
	
	if(start.trim() == '' && end.trim() != '') {
		notificacaoErro(["jornadaTrabalho.horaInicio", " ".concat(num)], "citcorpore.comum.validacao.horainicio");
		return false;
	} else if(start.trim() != '' && end.trim() == '') {
		notificacaoErro(["jornadaTrabalho.horaFim", " ".concat(num)], "citcorpore.comum.validacao.horafim");
		return false;
	}
	
	if($("#tipoHorario").val() == 1) {
		if(validarStart && !/^(0[0-9]|1[0-9]|2[0-3]):[0-5][0-9]$/.test(start)) {
			notificacaoErro(["jornadaTrabalho.horaInicio", " ".concat(num)], "citcorpore.comum.horaInvalida");
			return false;
		} else if(validarEnd && !/^(0[0-9]|1[0-9]|2[0-4]):[0-5][0-9]$/.test(end)) {
			notificacaoErro(["jornadaTrabalho.horaFim", " ".concat(num)], "citcorpore.comum.horaInvalida");
			return false;
		}
	} else {
		if(validarStart && !(/^(0[1-9]|1[0-2]):[0-5][0-9]$/.test(start.substring(0,5)) && /^[aApP][mM]$/.test(start.substring(6,8))) ) {
			notificacaoErro(["jornadaTrabalho.horaInicio", " ".concat(num)], "jornadaTrabalho.horaInvalidaAmPm");
			return false;
		} else if(validarEnd && !(/^(0[1-9]|1[0-2]):[0-5][0-9]$/.test(end.substring(0,5)) && /^[aApP][mM]$/.test(end.substring(6,8))) ) {
			notificacaoErro(["jornadaTrabalho.horaFim", " ".concat(num)], "jornadaTrabalho.horaInvalidaAmPm");
			return false;
		}
	}
	
	var start = moment(start, dateFormat);
	var end = moment(end, dateFormat);
	
	if (validarStart && !start.isValid()) {
		notificacaoErro(["jornadaTrabalho.horaInicio", " ".concat(num)], "citcorpore.comum.horaInvalida");
		return false;
	} else if (validarEnd && !end.isValid()) {
		notificacaoErro(["jornadaTrabalho.horaFim", " ".concat(num)], "citcorpore.comum.horaInvalida");
		return false;
	}
	
	return true;
}

function gravar(){
	if (isHoraValida($("#inicio1").val(), $("#termino1").val(), "1") && isHoraValida($("#inicio2").val(), $("#termino2").val(), "2") 
			&& isHoraValida($("#inicio3").val(), $("#termino3").val(), "3") && isHoraValida($("#inicio4").val(), $("#termino4").val(), "4") && isHoraValida($("#inicio5").val(), $("#termino5").val(), "5")){
		
		if($("#tipoHorario").val() == 2) {
			var joJornadaTrabalho = new JornadaTrabalhoDTO();
			joJornadaTrabalho.setInicio1($("#inicio1").val());
			joJornadaTrabalho.setTermino1($("#termino1").val());
			joJornadaTrabalho.setInicio2($("#inicio2").val());
			joJornadaTrabalho.setTermino2($("#termino2").val());
			joJornadaTrabalho.setInicio3($("#inicio3").val());
			joJornadaTrabalho.setTermino3($("#termino3").val());
			joJornadaTrabalho.setInicio4($("#inicio4").val());
			joJornadaTrabalho.setTermino4($("#termino4").val());
			joJornadaTrabalho.setInicio5($("#inicio5").val());
			joJornadaTrabalho.setTermino5($("#termino5").val());
			
			document.form.json.value = JSON.stringify(joJornadaTrabalho);
		}
		
		document.form.save();
	}
}