function load() {
	if (window.location != window.top.location) {
		window.top.location = window.location;
	}

	$("#user").focus();
}
addEvent(window, "load", load, false);

var LOGIN = {
	signIn: function() {
		window.location = URL_SISTEMA+"pages/index/index.load";
	},
	validation: function() {
		if($.browser.msie && $.browser.version < 10) {
			LOGIN.close_wait();
		} else {
			LOGIN.wait();
			document.form.save();
			$("#user").focus();
		}
	},
	wait: function() {
		JANELA_AGUARDE_MENU.show();
	},
	close_wait: function() {
		JANELA_AGUARDE_MENU.hide();
	},
	load: {
		language: function(locale) {
			document.getElementById('locale').value = locale;
		  	document.formInternacionaliza.fireEvent('internacionaliza');
		  	window.location.reload();
		},
		contacts: function(telefones, emails) {
			var html = '';
			
			if(!StringUtils.isBlank(telefones)) {
				var telefonesParts = telefones.split(';');
				
				html += '<h4>' + i18n_message('citcorpore.comum.telefone') + '</h4>';
				html += '<div class="contact-item-container">';
				for(var i = 0; i < telefonesParts.length; i++) {
					html += '<p class="glyphicons phone"><i></i>' + telefonesParts[i] + '</p>';
				}
				html += '</div>';
			}
			if(!StringUtils.isBlank(emails)) {
				var emailsParts = emails.split(';');
				
				html += '<h4>' + i18n_message('citcorpore.comum.email') + '</h4>';
				html += '<div class="contact-item-container">';
				for(var i = 0; i < emailsParts.length; i++) {
					html += '<p class="glyphicons envelope"><i></i><a href="mailto:' + emailsParts[i] + '?Subject=[' + i18n_message('citcorpore.comum.suporte') + ']">' + emailsParts[i] + '</a></p>';
				}
				html += '</div>';
			}
			
			$('#modal-contacts .modal-body').html(html);
			Modal.open('modal-contacts');
		},
		insertMessage: function(msg) {
			$('#insert-message-modal .modal-body').html(msg);
			Modal.open('insert-message-modal');
		}
	},
	set: {
		language: function() {
			if(!locale) {
				locale = 'pt';
			}
			$('.language.' + locale).addClass('active');
		}
	},
	requestKey: function() {
		document.formValidarChaveSeguranca.fireEvent("gerarChaveInicial", function() {
			window.open(CENTRAL_CITSMART + "/cadastro/#/cadastro?k=" + $("#genKey").attr("value"), '_blank');
		});
	},
	validateKey: function() {
		if ($("#chave").attr("value") == "") {
			alert(i18n_message("validarChaveSeguranca.validacaoNaoRealizada"));
		} else {
			document.formValidarChaveSeguranca.fireEvent("validarChave");
		}
	}
};

LOGIN.set.language();