var mapa = null;

addEvent(window, "load", load, false);

$(".popup").dialog({
	width : "50%",
	height : window.screen.height/2,
	modal : true,
	autoOpen : false,
	resizable : false,
	show : "fade",
	hide : "fade",
	beforeClose : limpaFormItemConfiguracao
});

function load() {
	mapa = new Canvas(document.getElementById("mapaProcessoNegocio"));
	mapa.configuraEventos();
};

$(('#mapaProcessoNegocio')).resize(function() {
	mapa.redimensionaCanvas();
});

function atualizaProcessoNegocioMapa(serealizado) {
	mapa.resetaLista();
	mapa = new Canvas(document.getElementById("mapaProcessoNegocio"));
	mapa.configuraEventos();

	var lista = ObjectUtils.deserializeCollectionFromString(serealizado);
	var imgAux = null;
	var listaAux = [];
	for ( var i = 0; i < lista.length; i++) {
		imgAux = new MapaDesenhoCatalogoNegocioImagemDTO(mapa.context, lista[i].caminhoImagem);
		imgAux.idCatalogoNegocioMapaImg = lista[i].idCatalogoNegocioMapaImg;
		imgAux.posx = parseInt(lista[i].posx);
		imgAux.posy = parseInt(lista[i].posy);
		imgAux.idCatalogoNegocio = lista[i].idCatalogoNegocio;
		imgAux.idServico = lista[i].idServico;
		if(lista[i].serializacaoListPaisCatNegImgRelacaoDTOs!= null && lista[i].serializacaoListPaisCatNegImgRelacaoDTOs!= ""){
			var listImagemRelacaoDTO_pai = ObjectUtils.deserializeCollectionFromString(lista[i].serializacaoListPaisCatNegImgRelacaoDTOs);
			for(var j = 0; j< listImagemRelacaoDTO_pai.length; j++){
				imgAux.arrayProcessoNegocioImagemRelacaoDTO_pais.push(listImagemRelacaoDTO_pai[j]);
			}
		}
		imgAux.descricao = lista[i].descricao;
		imgAux.nomeServico = lista[i].nomeServico;
		listaAux[i] = imgAux;
	}
	mapa.setListaItens(listaAux.slice());
	document.getElementById("serializacaoListCatalogoNegocioImagem").value = "";
};

function finalizaExclusaoImagemProcessoNegocio(serializado) {
	atualizaProcessoNegocioMapa(serializado);
	mapa.salvarProcessoNegocio();
	mapa.limparFecharPopup();
};

/**
 * Quando o item começar a ser arrastado algumas informações
 * serão salvas para serem recuperadas pelo Mapa.
 * @param e
 * Evento dragstart.
 */
function dragstart(e) {
	if (document.form.idCatalogoNegocio.value != ""){
		e.dataTransfer.setData("text", e.target.getAttribute("id"));
	}
}

/**
 * Mostra e esconde uma popup.
 */
function togglePopup(id, openClose) {
	$("#" + id).dialog(openClose);
	limpaFormItemConfiguracao();
};

/**
 * Mostra e esconde uma popup.
 */
function togglePopupFrame(id, link, openClose) {
	if(link > "")
		document.getElementById('popupitemc').src = link + '?iframe=true';
	else
		document.getElementById('popupitemc').src = ctx + link;

	$("#" + id).dialog(openClose);
	limpaFormItemConfiguracao();
};

/**
 * Limpa campos específicos.
 */
function limpaFormItemConfiguracao() {
	document.form.idServico.value = "";
	document.getElementById("nomeServico").value = "";
	document.getElementById("txtDescricao").value = "";
};

function LOOKUP_CATALOGOSERVICO_select(id, desc) {
	document.getElementById("serializacaoListCatalogoNegocioImagem").value = "";
	var camposLookupServico = desc.split("-");
	document.getElementById("nomeProcessoNegocio").innerHTML = desc;
	document.form.idCatalogoNegocio.value = id;
	document.form.fireEvent("selecionarProcessoNegocio");
	$('.tabsbar a[href="#tab1-3"]').tab('show');
};

function LOOKUP_SERVICO_DESENHO_select(id, desc) {
	var camposLookupItem = desc.split("-");
	document.form.idServico.value = id;
	document.getElementById("nomeServico").value = camposLookupItem[0];
	document.form.fireEvent("selecionarServico");
	togglePopup("POPUP_SERVICO", "close");
};
