
var TipoLinha = {RETA : 0, DOIS_PONTOS : 1, TRES_PONTOS : 2};

var ACIMA = 0;
var DIREITA = 1;
var ABAIXO = 2;
var ESQUERDA = 3;

function Canvas(_canvas){
	this.canvas = _canvas;
	this.context = this.canvas.getContext("2d");
	this.listaItens = [];
	this.listaItens.length = 0;
	this.canvas.width = document.getElementById('mapaProcessoNegocio').offsetWidth;
	this.canvas.height = document.getElementById('mapaProcessoNegocio').offsetHeight;

	var self = this;
	var tipoLinha = TipoLinha.TRES_PONTOS;
	
	var itemSelecionado = null;
	var salvo = false;
	
	var afterDBClickItemEvents = [];

	var setSalvo = function(bool){
		salvo = bool;
	}
	
	this.redimensionaCanvas = function(){
		this.canvas.width = document.getElementById('mapaProcessoNegocio').offsetWidth;
		this.canvas.height = document.getElementById('mapaProcessoNegocio').offsetHeight;
		atualizarCanvas();
	}
	
	this.addAfterDBClickItemEvent = function(funcao){
		afterDBClickItemEvents.push(funcao);
	}
	
	var fireDBClickEvents = function(item){
		if(afterDBClickItemEvents == null){
			return;
		}
		
		for(var i = 0; i < afterDBClickItemEvents.length; i++){
			var f = afterDBClickItemEvents[i];
			f(item);
		}
	}
	
	this.salvarProcessoNegocio = function() {
		setSalvo(true);
		if (document.form.idCatalogoNegocio.value == null || document.form.idCatalogoNegocio.value == "") {
			
			$.growl.notice({ message: i18n_message("citcorpore.comum.selecioneUmServico") });
			return;
		}
		
		for(var i = 0; i< mapa.listaItens.length;i++){
			mapa.listaItens[i].serializacaoListPaisCatNegImgRelacaoDTOs = ObjectUtils.serializeObjects(mapa.listaItens[i].arrayProcessoNegocioImagemRelacaoDTO_pais);
		}
		var listaSerializada = ObjectUtils.serializeObjects(mapa.listaItens);
		document.form.serializacaoListCatalogoNegocioImagem.value = listaSerializada;
		document.form.fireEvent("salvarProcessoNegocio");
	};
	
	this.imprimirDesenhoMapaProcessoNegocio = function(){
		 if(document.form.idCatalogoNegocio.value == null || document.form.idCatalogoNegocio.value == ""){
			 $.growl.notice({ message: i18n_message("citcorpore.comum.selecioneUmServico") });
			 } else {
				 document.getElementById('tabs').style.display = 'none';
				 document.getElementById('menu-botoes').style.display = 'none';
				 document.getElementById('menu-icones').style.display = 'none';
				 window.print();
				 document.getElementById('tabs').style.display = 'block';
				 document.getElementById('menu-botoes').style.display = 'block';
				 document.getElementById('menu-icones').style.display = 'block';
			 }
		};

	this.resetaLista = function(){
		this.listaItens = [];
	};
	
	this.configuraEventos = function(){
		//eventos para prevenir bugs
		this.canvas.addEventListener("dragenter", prevent, true);
		this.canvas.addEventListener("dragover", handleDragOver, true);
		this.canvas.addEventListener("dragexit", prevent, true);
		//quando um item for solto dentro do canvas
		this.canvas.addEventListener("drop", droped, true);

		this.canvas.addEventListener("dblclick", dblclick, true);
		this.canvas.addEventListener("mousedown", mouseDown, true);
		this.canvas.addEventListener("mouseup", mouseUp, true);
		//se o mouse sair do canvas executo a a��o de mouse up e a a��o de arrastar termina
		this.canvas.addEventListener("mouseout", mouseUp, true);
	}
	
	// drag over
    function handleDragOver(event) {
        event.stopPropagation();
        event.preventDefault();
        self.canvas.style.background = '#EDEDED';
    }

	/**
	 * Evento de click que ser� tratado posteriormente para edi��o.
	 * @param e
	 * Evento de click.
	 * @returns
	 */
	var dblclick = function(e){
		itemSelecionado = findItemByPosition(getRelativeCursorPoint(e));
		
		if(itemSelecionado != null){			
			fireDBClickEvents(itemSelecionado.objeto);

			$("#POPUP_EDITAR_SERVICO").dialog("open");			

			var btSalvar = document.getElementById("btSalvar");
			var btExcluir = document.getElementById("btExcluir");
			var editarItemConfiguracao = document.getElementById("POPUP_EDITAR_SERVICO");

			btExcluir.style.display = "block";
			document.form.idCatalogoNegocioMapaImg.value = itemSelecionado.objeto.idCatalogoNegocioMapaImg;
			document.form.idServico.value = itemSelecionado.objeto.idServico;
			document.getElementById("nomeServico").value = itemSelecionado.objeto.nomeServico;
			document.getElementById("txtDescricao").value = itemSelecionado.objeto.descricao;		
			btSalvar.onclick = function(){
				itemSelecionado.objeto.idServico = document.form.idServico.value;	
				itemSelecionado.objeto.nomeServico = document.getElementById("nomeServico").value;
				itemSelecionado.objeto.descricao = document.getElementById("txtDescricao").value;
				self.limparFecharPopup();			
				self.salvarProcessoNegocio();
			};			
			btExcluir.onclick = function(){
				if(itemSelecionado.objeto.idCatalogoNegocioMapaImg != 0){					
					document.form.idCatalogoNegocioMapaImg.value = itemSelecionado.objeto.idCatalogoNegocioMapaImg;
					document.form.fireEvent("excluirProcessoNegocioImagem");				
				} else {
					self.listaItens.splice(itemSelecionado.index, 1);
					atualizarCanvas();
					self.salvarProcessoNegocio();
					self.limparFecharPopup();
				}			
			};		
		}
		
	};
	
	var mouseDown = function(e) {
		//A funcionalidade s� funcionar� se esse evento for criado aqui.
		self.canvas.addEventListener("mousemove", mouseClickedMove, false);
		itemSelecionado = findItemByPosition(getRelativeCursorPoint(e));
	};
	
	/**
	 * Quando o mouse se mover (cada mil�metro), se houver
	 * um item selecionado executa ações de movimento.
	 * @param e
	 * Evento.
	 */
	var posicaoMouse;
	var mouseClickedMove = function(e) {
		self.canvas.style.cursor = 'move';	
		posicaoMouse = getRelativeCursorPoint(e);
		if(itemSelecionado != null){
			/*
			 * Se o usuário tiver clicado na área de opces da figura, uma
			 * linha será tra�ada do ponto da imagem até o ponto do mouse.
			 */
			atualizarCanvas();
			if(itemSelecionado.opcoes){	
				self.context.beginPath(); 
				var centroXAreaOpcoes = itemSelecionado.objeto.posx + 
										itemSelecionado.objeto.areaOpcoes.posx + 
										(itemSelecionado.objeto.areaOpcoes.width/2);
				var centroYAreaOpcoes = itemSelecionado.objeto.posy + 
										itemSelecionado.objeto.areaOpcoes.posy + 
										(itemSelecionado.objeto.areaOpcoes.height/2);
				self.context.moveTo(centroXAreaOpcoes ,centroYAreaOpcoes);
				self.context.lineTo(posicaoMouse.x, posicaoMouse.y);
				self.context.stroke();
				self.context.closePath();
			} else {		
				var limiteTempX = (self.canvas.width - itemSelecionado.objeto.width);
				var limiteTempY = (self.canvas.height - itemSelecionado.objeto.height);		
				itemSelecionado.objeto.posx = parseInt(posicaoMouse.x <= limiteTempX ? (posicaoMouse.x - itemSelecionado.objeto.width/2) : limiteTempX);
				itemSelecionado.objeto.posy = parseInt(posicaoMouse.y <= limiteTempY ? (posicaoMouse.y - itemSelecionado.objeto.height/2): limiteTempY);	
			}		
		}		
	};
	
	/**
	 * Quando o mouse n�o estiver mais sendo pressionado, armazena
	 * algumas configura��es e finaliza a a��o de arrastar.
	 * @param e
	 * Evento.
	 */
	var mouseUp = function(e) {
		self.canvas.removeEventListener("mousemove", mouseClickedMove, false);		
		//Verifica se a linha foi solta em cima de um outro item para torn�-lo filho.
		if(itemSelecionado != null && itemSelecionado.opcoes){
			//Conclui o desenho da linha, caso haja.
			var filho = findItemByPosition(getRelativeCursorPoint(e));			
			if(filho != null && filho.objeto.idCatalogoNegocioMapaImg != itemSelecionado.objeto.idCatalogoNegocioMapaImg){
				if(itemSelecionado.objeto.idCatalogoNegocioMapaImg == 0){
					 $.growl.notice({ message: i18n_message("mapaDesenhoServico.esteItemAindaNaoFoiSalvo") });
				} else {
					var idCatalogoNegocioMapaImgPai = itemSelecionado.objeto.idCatalogoNegocioMapaImg;
					var idCatalogoNegocioMapaImgFilho = filho.objeto.idCatalogoNegocioMapaImg;
					var catalogoNegocioImagemRelacaoDTO = new MapaDesenhoCatalogoNegocioImagemRelacaoDTO(idCatalogoNegocioMapaImgFilho, idCatalogoNegocioMapaImgPai);
					filho.objeto.arrayProcessoNegocioImagemRelacaoDTO_pais.push(catalogoNegocioImagemRelacaoDTO);

				}
			}
		}
		self.canvas.style.cursor = 'default';
		self.canvas.style.background = '';
		atualizarCanvas();
	};
	
	/**
	 * Executador em eventos espec�ficos para evitar bugs.
	 * @param e
	 * Evento.
	 */
	var prevent = function(e) {
		e.preventDefault();
		if (e.stopPropagation) {
			// this code is for Mozilla and Opera
			e.stopPropagation();
		} else if (window.e) {
			// this code is for IE
			window.e.cancelBubble = true;
		}
		return false;
	};

	/**
	 * Quando um item do menu � solto dentro do canvas
	 * anexa este novo item com configura��es default.
	 * @param e
	 * Evento.
	 */
	var droped = function(e) {
		prevent(e);
		 self.canvas.style.background = '';
		if(UtilMapa.trim(document.getElementById("idCatalogoNegocio").value) == ""){
			 $.growl({ title: i18n_message("citcorpore.comum.aviso"), message: i18n_message("citcorpore.comum.selecioneUmCatalogo") });
			return;
		}		
		/*
		 * Pega o id passado no dataTransfer do objeto MenuItemConfiguracao
		 * e busca o elemento da p�gina que tenha esse id para copi�-lo para o canvas.
		 */
		var imagemObj = document.getElementById(e.dataTransfer.getData("text"));	
		if(imagemObj == null){
			 $.growl.notice({ message: i18n_message("mapaDesenhoServico.itemInvalido") });
			return;
		}
		var classValue = imagemObj.getAttribute('class');		
		//Mapa s� aceita objetos da classe itemInMenu.	
		if (classValue.indexOf("itemInMenu") >= 0) {
			var editarItemConfiguracao = document.getElementById("POPUP_EDITAR_SERVICO");
			$("#POPUP_EDITAR_SERVICO").dialog("open");
			var btSalvar = document.getElementById("btSalvar");
			/*
			 * S� ser� efetivado o anexo do item quando usu�rio clicar em SALVAR. 
			 */
			btSalvar.onclick = function(){	
				if(document.getElementById("nomeServico").value == ""){
					$.growl.notice({ message: i18n_message("mapaDesenhoServico.selecioneItemConfiguracao") });
					return
				}
				var catalogoNegocioImagemRelacaoDTO = new MapaDesenhoCatalogoNegocioImagemDTO(self.context, imagemObj.getAttribute('src'));
				catalogoNegocioImagemRelacaoDTO.idCatalogoNegocio = document.getElementById("idCatalogoNegocio").value;
				catalogoNegocioImagemRelacaoDTO.idServico = document.getElementById("idServico").value
				catalogoNegocioImagemRelacaoDTO.nomeServico = document.getElementById("nomeServico").value
				catalogoNegocioImagemRelacaoDTO.descricao = document.getElementById("txtDescricao").value
				var cursorPoint = getRelativeCursorPoint(e);
				catalogoNegocioImagemRelacaoDTO.posx = parseInt(cursorPoint.x);
				catalogoNegocioImagemRelacaoDTO.posy = parseInt(cursorPoint.y);
				catalogoNegocioImagemRelacaoDTO.carregaDesenhaImagem();
				self.listaItens.push(catalogoNegocioImagemRelacaoDTO);
				self.limparFecharPopup();
				self.salvarProcessoNegocio();
			}
		}
	};
	
	this.setListaItens = function(novaLista){
		this.listaItens = novaLista;
		for(var i = 0 ; i < this.listaItens.length; i++){
			this.listaItens[i].carregaDesenhaImagem();
		}
		//espera meio segundo para dar tempo de carregar tudo certinho.
		//posteriormente tratar com um 'preloader'.
		var tout = setTimeout(atualizarCanvas, 500);
	};
	
	
	/**
	 * Apaga todo que est no canvas e desenha novamente.
	 * � assim que s�o feitas as anima��es de arrastar os itens.
	 */
	var atualizarCanvas = function() {	
		//limpa toda a tela.
		self.context.save();
		self.context.clearRect(0, 0, self.canvas.width, self.canvas.height);
		self.context.restore();
		/*
		 * Como a imagem j� foi carregada posteriormente, aqui
		 * apenas percorre a lista redesenhando estes itens.
		 * Assim ganha-se muito em desempenho.
		 */
		for ( var i = 0; i < self.listaItens.length; i++) {
			if(self.listaItens[i] == null){
				continue;
			}
			if (self.listaItens[i].arrayProcessoNegocioImagemRelacaoDTO_pais != null && self.listaItens[i].arrayProcessoNegocioImagemRelacaoDTO_pais.length > 0) {
				for(var j = 0; j < self.listaItens[i].arrayProcessoNegocioImagemRelacaoDTO_pais.length; j++){
					var imgPai = findImagemById(self.listaItens[i].arrayProcessoNegocioImagemRelacaoDTO_pais[j].idCatalogoNegocioMapaImgPai);
					if (imgPai != null) {
						connectPoints(imgPai.objeto, self.listaItens[i]);
					}
				}
			}			
			self.listaItens[i].desenhaImagemJaCarregada();
			self.listaItens[i].desenhaDescricao();
			self.listaItens[i].desenhaAreaOpcoes();
		}
	}
	
	
	/**
	 * Identifica uma imagemItemConfiguracao na lista pelo id.
	 * @param id
	 * id do item pesquisado. 
	 */
	var findImagemById = function(id) {
		var i = 0;
		for (i = 0; i < self.listaItens.length; i++) {
			if (self.listaItens[i] != null) {
				if (self.listaItens[i].idCatalogoNegocioMapaImg == id) {
					return {
						objeto : self.listaItens[i],
						index : i
					}
				}
			}
		}
	};
	
	/**
	 * Identifica um elemento no mapa de acordo
	 * com as coordenadas passadas.
	 * @param posicao
	 * Um objeto an�nimo com caracter�sticas x e y.
	 * Exemplo: posicao = {x:50, y:100}
	 */
	var findItemByPosition = function(posicao){		
		var opcoes = false;
		var itemRetorno = null;
		var i = null;
		for(i = 0; i < self.listaItens.length; i++){			
			if(self.listaItens[i] != null){
				if(posicao.x >= self.listaItens[i].posx && posicao.x <= self.listaItens[i].getPosX2() && 
				   posicao.y >= self.listaItens[i].posy && posicao.y <= self.listaItens[i].getPosY2()){					
					//o retorno � um objeto an�nimo com a posi��o do objeto na lista e o objeto em si.
					itemRetorno = self.listaItens[i];
					break;
				}			
				if(posicao.x >= (self.listaItens[i].posx + self.listaItens[i].areaOpcoes.posx) && 
				   posicao.x <= (self.listaItens[i].posx + self.listaItens[i].areaOpcoes.posx + self.listaItens[i].areaOpcoes.width) &&
				   posicao.y >= (self.listaItens[i].posy + self.listaItens[i].areaOpcoes.posy) && 
				   posicao.y <= (self.listaItens[i].posy + self.listaItens[i].areaOpcoes.posy + self.listaItens[i].areaOpcoes.height)){
					
					opcoes = true; 
					itemRetorno = self.listaItens[i];
					break;
				}
			}
		}
		return itemRetorno == null ? null : {
			objeto : itemRetorno,
			index : i,
			opcoes : opcoes
		}
	};

	/**
	 * Desenha a linha com base nas configura��es do enum TipoLinha.
	 * @param pai
	 * @param filho
	 * @returns
	 */
	var connectPoints = function(pai, filho){		
		self.context.beginPath();
		
		var centralXPai = pai.posx + pai.areaOpcoes.posx + (pai.areaOpcoes.width/2);
		var centralYPai = pai.posy + pai.areaOpcoes.posy + (pai.areaOpcoes.height/2);
		var centralXFilho = filho.posx + filho.areaOpcoes.posx + (filho.areaOpcoes.width/2);
		var centralYFilho = filho.posy + filho.areaOpcoes.posy + (filho.areaOpcoes.height/2);	
		var meioX;
		var meioY;
		self.context.moveTo(centralXPai,centralYPai);
		switch(tipoLinha){
			case TipoLinha.TRES_PONTOS :
				meioX = centralXPai+(centralXFilho - centralXPai)/2; 
				meioY = centralYPai+(centralYFilho - centralYPai)/2;
				self.context.lineTo(meioX, centralYPai);
				self.context.lineTo(meioX, meioY);
				self.context.lineTo(centralXFilho, meioY);
				self.context.lineTo(centralXFilho, centralYFilho);
				break;
			case TipoLinha.DOIS_PONTOS :	
				self.context.lineTo(filho.getXCentral(), pai.getYCentral());
				self.context.lineTo(filho.getXCentral(), filho.getYCentral());
				break;
			case TipoLinha.RETA :		
				self.context.lineTo(filho.getXCentral(), filho.getYCentral());
				break;
		}		
		
		self.context.arc(centralXFilho, centralYFilho,10,0,Math.PI*2,true);
		self.context.stroke();
		self.context.closePath();
		
		var pontoPai = new Point(centralXFilho, meioY);
		var pontoFilho = new Point(centralXFilho,centralYFilho);
		desenharSeta(self.context,pontoPai, pontoFilho);
	};	
	
	function desenharSeta(ctx,fromPoint,toPoint){
		var dx = toPoint.x - fromPoint.x;
		var dy = toPoint.y - fromPoint.y;
		
        var length = Math.sqrt(dx * dx + dy * dy);
        var unitDx = dx / length;
        var unitDy = dy / length;
        //Tamanho seta
        var tamanhoSeta = 5;
 
        var pontoSeta1 = new Point(
            (toPoint.x - unitDx * tamanhoSeta - unitDy * tamanhoSeta),
            (toPoint.y - unitDy * tamanhoSeta + unitDx * tamanhoSeta));
        var pontoSeta2 = new Point(
            (toPoint.x - unitDx * tamanhoSeta + unitDy * tamanhoSeta),
            (toPoint.y - unitDy * tamanhoSeta - unitDx * tamanhoSeta));
        	
        insereSeta(ctx,toPoint,pontoSeta1,pontoSeta2,dy);
	}
		
	function insereSeta(ctx,toPoint,pontoSeta1,pontoSeta2,valorY){
		 ctx.beginPath();
		 if(valorY > 0){
			 ctx.moveTo(toPoint.x,toPoint.y-10);
			 ctx.lineTo(pontoSeta1.x,pontoSeta1.y-10);
			 ctx.lineTo(pontoSeta2.x,pontoSeta2.y-10);
			 ctx.lineTo(toPoint.x,toPoint.y-9);
		 }else{
			 ctx.moveTo(toPoint.x,toPoint.y+9);
			 ctx.lineTo(pontoSeta1.x,pontoSeta1.y+10);
			 ctx.lineTo(pontoSeta2.x,pontoSeta2.y+10);
			 ctx.lineTo(toPoint.x,toPoint.y+10); 
		 }
		 
		 ctx.fillStyle = 'black';
		 ctx.fill();
		 ctx.stroke();
		 ctx.closePath();
	}
		
	function Point(x, y) {
		  this.x = x;
		  this.y = y;
	}
	
	/**
	 * 
	 * @returns
	 */	
	this.limparFecharPopup = function(){
		var editarItemConfiguracao = document.getElementById("POPUP_EDITAR_SERVICO");
		document.form.idServico.value = "";
		document.getElementById("nomeServico").value = "";
		document.getElementById("txtDescricao").value = "";
		var btExcluir = document.getElementById("btExcluir");
		btExcluir.style.display = "none";
		document.form.idCatalogoNegocioMapaImg.value = "";
		$("#POPUP_EDITAR_SERVICO").dialog("close");
	}
	
	/**
	 * Retorna a posi��o do cursor relativa ao canvas.
	 * @param evt
	 * Evento de mouse.
	 */
	var getRelativeCursorPoint = function(evt) {
		var canvas = document.getElementById('mapaProcessoNegocio');
		
		var rect = canvas.getBoundingClientRect(), root = document.documentElement;

		var mouseX = evt.clientX - rect.left - root.scrollLeft;
		var mouseY = evt.clientY - rect.top - root.scrollTop;
		
		return {
			x: mouseX,
			y: mouseY
		};
	};
};

function MapaDesenhoCatalogoNegocioImagemDTO(_context, _caminho){
	this.idCatalogoNegocioMapaImg = 0;
	this.idCatalogoNegocio;
    this.idServico;
    this.arrayProcessoNegocioImagemRelacaoDTO_pais = [];
    this.serializacaoListPaisCatNegImgRelacaoDTOs;
    this.caminhoImagem = _caminho;
    this.nomeServico;	
    this.descricao;
    this.posicaoSeta;

    this.posx;
	this.posy;
	this.width;
	this.height;
	
	this.context = _context;
	var pastaImagens = "imagens/";	
	this.areaOpcoes = {
		width : 15,
		height : 15,
		posx : 48,
		posy : 48
	};
	
	this.opcoesDescricao = {
		widthDescricaoMaximo : 200,
		font : "16px Times New Roman",
		style : "Gray",
		posy : 5	
	};
	
	this.imageObj = null;
	var self = this;
	
	this.getPosX2 = function(){
		return this.posx + this.width;
	};
	
	this.getPosY2 = function(){
		return this.posy + this.height;
	};
	
	this.getXCentral = function(){
		return this.posx + (this.width/2);
	};
	
	this.getYCentral = function(){
		return this.posy + (this.height/2);
	};
	
	/**
	 * Desenha bordas em torno da imagem.
	 */
	this.desenharBorda = function() {
		this.context.beginPath();	
		this.context.moveTo(this.posx, this.posy);
		this.context.stroke();
		this.context.closePath();
	};
	
	this.desenhaAreaOpcoes = function(){	
		this.context.beginPath();	
		this.context.fillStyle = "#000000";	
		this.context.fillRect((this.posx + this.areaOpcoes.posx),
							  (this.posy + this.areaOpcoes.posy),
							  this.areaOpcoes.width, 
							  this.areaOpcoes.height);
		this.context.fill();
		this.context.stroke();
		this.context.closePath();
	};
	
	this.desenhaDescricao = function(){
		var widthDescricao = this.context.measureText(this.nomeServico).width;
		var posX;
		
		var nomeServico = this.nomeServico;
		
		if (widthDescricao > this.opcoesDescricao.widthDescricaoMaximo) {
			var lengthDescricao = this.nomeServico.length;
			if (lengthDescricao > 50) {
				nomeServico = this.nomeServico.substring(0,16) + " (...) " + this.nomeServico.substring((lengthDescricao - 17),lengthDescricao);
			} else {
				nomeServico = this.nomeServico.substring(0,35) + "...";
			}
		}
		
		widthDescricao = this.context.measureText(nomeServico).width;
		
		posX = this.posx - ((widthDescricao - this.width)/2)
		var posY = (this.posy - this.opcoesDescricao.posy);
		
		this.context.beginPath();	
		this.context.font = this.opcoesDescricao.font;
		this.context.fillStyle = this.opcoesDescricao.style;
		this.context.fillText(nomeServico, posX, posY);
		this.context.closePath();
	};
	
	/**
	 * Mostra uma imagem na tela.
	 * 
	 * @param myImage
	 * Objeto da classe MyImage com as propriedades da imagem.
	 */
	this.carregaDesenhaImagem = function() {
		this.imageObj = new Image();
		//ao carregar, torna vis�vel
		this.imageObj.onload = function() {
			self.desenhaImagemJaCarregada();
			self.width = self.imageObj.width;
			self.height = self.imageObj.height;
			self.desenhaDescricao();
			self.desenhaAreaOpcoes();
		};
		this.imageObj.src = this.caminhoImagem;
	};
	
	/**
	 * Apenas para tornar a imagem vis�veis ap�s o carregamento. 
	 */
	this.desenhaImagemJaCarregada = function() {
		if (this.height != null && this.width != null) {
			this.context.drawImage(this.imageObj, this.posx, this.posy, this.width, this.height);
		} else {
			this.context.drawImage(this.imageObj, this.posx, this.posy);
		}
	};
};

function MapaDesenhoCatalogoNegocioImagemRelacaoDTO(idCatalogoNegocioMapaImgFilho, idCatalogoNegocioMapaImgPai){
	this.idCatalogoNegocioMapaImgFilho = idCatalogoNegocioMapaImgFilho;
	this.idCatalogoNegocioMapaImgPai = idCatalogoNegocioMapaImgPai;
}

var UtilMapa = {
	/**
	 * Elimina espa�os em branco em qualquer lugar da string
	 * @param str
	 * String a ser modificada.
	 */
	trim : function(str){
		var novaStr = "";
		for(var i = 0 ; i<str.length; i++){
			novaStr += str.charAt(i) == ' ' ? '' : str.charAt(i); 
		}
		return novaStr;
	},		
	/**
	 * Mostra uma mensagem definida em um componente definido por um tempo
	 * definido.
	 * @param componenteId
	 * Id do componente onde a mensagem ser� colocada.
	 * @param segundos
	 * Tempo em segundos que a mensagem ficar� na tela.
	 * @param texto
	 * Texto que dever� aparecer no componente pelo tempo determinado.
	 */
	mostrarMsgTemporaria : function(componenteId, segundos, texto){
		var t;
		var componente = document.getElementById(componenteId);			
		componente.innerText = texto;			
		t = setTimeout(function(){
			componente.innerText = '';
		}, segundos*1000);
	}
}