var mapa = null;
addEvent(window, "load", load, false);

$(".dialogEditarIC").dialog({
	width : "75%",
	height : 3*(window.screen.height)/4,
	modal : true,
	autoOpen : false,
	resizable : true,
	show : "fade",
	hide : "fade",
	beforeClose : limpaFormItemConfiguracao
});

$(".dialogPesquisarIC").dialog({
	width : "66%",
	height : 2*(window.screen.height)/3,
	modal : true,
	autoOpen : false,
	resizable : false,
	show : "fade",
	hide : "fade"
});

$(".dialogCorrelacaoEventos").dialog({
	width : "75%",
	height : 3*(window.screen.height)/4,
	modal : true,
	autoOpen : false,
	resizable : true,
	show : "fade",
	hide : "fade",
	beforeClose : limpaFormCorrelacaoEventos
});

function load() {

	mapa = new MapaDesenhoServico(document.getElementById("mapaServicos"));
	mapa.configuraEventos();
	
	escondeAbasEvmGerentes();
};

$(('#mapaServicos')).resize(function() {
	mapa.redimensionaCanvas();
});

function extrairVariavelDaUrl(nome){
	var valor = null;
	var identificador = null;
	try{
		var strUrl = document.URL;
		var params = strUrl.split("")[1];
		var variaveis = params.split("&");

		for(var i = 0; i < variaveis.length; i++){
			valor = variaveis[i].split("=")[1];
			identificador = variaveis[i].split("=")[0];

			if(identificador == nome){
				return valor;
			}

			valor = null;
		}
	}catch(e){}

	return null;
}

function atualizaServicoMapa(serealizado) {
	mapa.resetaLista();
	mapa = new MapaDesenhoServico(document.getElementById("mapaServicos"));
	mapa.configuraEventos();

	//Recupera o IC com apenas dois clicks. Atualmente utilizado apenas pelo gerenciamento de problema
	if(extrairVariavelDaUrl("selecaoIc") != null){
		mapa.addAfterDBClickItemEvent(function(item){
			parent.selecionaIcPeloMapa(item.idItemConfiguracao, item.identificacao + "-" + item.descricao);
			throw i18n_message("mapaDesenhoServico.itemRecuperadoPorPaginaPai");
		})
	}

	var lista = ObjectUtils.deserializeCollectionFromString(serealizado);
	var imgAux = null;
	var listaAux = [];
	for ( var i = 0; i < lista.length; i++) {
		imgAux = new ImagemItemConfiguracaoDTO(mapa.context, lista[i].caminhoImagem);
		imgAux.idImagemItemConfiguracao = lista[i].idImagemItemConfiguracao;
		imgAux.posx = parseInt(lista[i].posx);
		imgAux.posy = parseInt(lista[i].posy);
		imgAux.idServico = lista[i].idServico;
		imgAux.idItemConfiguracao = lista[i].idItemConfiguracao;
		imgAux.idImagemItemConfiguracaoPai = lista[i].idImagemItemConfiguracaoPai != "" ? lista[i].idImagemItemConfiguracaoPai : null;
		if(lista[i].idImagemItemConfiguracaoPaiColSerializado!= null && lista[i].idImagemItemConfiguracaoPaiColSerializado!= ""){
			var colImagemPai = ObjectUtils.deserializeCollectionFromString(lista[i].idImagemItemConfiguracaoPaiColSerializado);
			for(var j = 0; j< colImagemPai.length; j++){
				imgAux.idImagemItemConfiguracaoCol.push(colImagemPai[j]);
			}
		}
		imgAux.descricao = lista[i].descricao;
		imgAux.identificacao = lista[i].identificacao;
		imgAux.idGerenteEvm = lista[i].idGerenteEvm;
		imgAux.ferramentaConexaoEvm = lista[i].ferramentaConexaoEvm;
		listaAux[i] = imgAux;
	}
	mapa.setListaItens(listaAux.slice());
	//document.getElementById("listaItensConfiguracaoSerializada").value = "";
};

/**
 * Quando o item começar a ser arrastado algumas informações
 * serão salvas para serem recuperadas pelo Mapa.
 * @param e
 * Evento dragstart.
 */
function dragstart(e) {
	if (document.form.idServico.value != ""){
		e.dataTransfer.setData("text", e.target.getAttribute("id"));
	}
}

function openDialog(idDialog) {
	$("#" + idDialog).dialog("open");
};

function openDialogFramePesquisaIC(idDialog) {
	document.getElementById('popupitemc').src = ctx + '/pages/pesquisaItemConfiguracao/pesquisaItemConfiguracao.load?iframe=true';
	openDialog(idDialog);
};

function openDialogFrameGerCorrelacao(idDialog) {
	defineFrameCorrelacao();
	
	openDialog(idDialog);
};

function closeDialog(idDialog) {
	$("#" + idDialog).dialog("close");
};

function abaGerenteInventory(){
	var url = ctx + '/pages/evmGerenteInventory/evmGerenteInventory.load?iframe=true&iframeNoSearchNoEditICPai=true';

	var idGerente = document.getElementById('idGerenteEvm').value.replace(/\D/g, "");
	if(idGerente>"") {
		 url += '&idGerenteEvm='+ idGerente;
	}
	
	var ferramenta = document.getElementById('ferramentaConexaoEvm').value;
	if(ferramenta>"") {
		 url += "&ferramentaConexaoEvm='" + ferramenta + "'";
	}
	
	var idIC = document.getElementById('idItemConfiguracao').value.replace(/\D/g, "");
	if(idIC>"") {
		 url += '&idItemConfiguracaoPai='+ idIC;
	}
	
	document.getElementById('iframeGerenteInventory').src = url;
}

function abaGerenteZabbix(){
	var url = ctx + '/pages/evmGerenteZabbix/evmGerenteZabbix.load?iframe=true&iframeNoSearchNoEditICPai=true';
	
	var idGerente = document.getElementById('idGerenteEvm').value.replace(/\D/g, "");
	if(idGerente>"") {
		 url += '&idGerenteEvm='+ idGerente;
	}
	
	var ferramenta = document.getElementById('ferramentaConexaoEvm').value;
	if(ferramenta>"") {
		 url += "&ferramentaConexaoEvm='" + ferramenta + "'";
	}
	
	var idIC = document.getElementById('idItemConfiguracao').value.replace(/\D/g, "");
	if(idIC>"") {
		 url += '&idItemConfiguracaoPai='+ idIC;
	}

	document.getElementById('iframeGerenteZabbix').src = url;
}

function abaGerenteNagios(){
	var url = ctx + '/pages/evmGerenteNagios/evmGerenteNagios.load?iframe=true&iframeNoSearchNoEditICPai=true';
	
	var idGerente = document.getElementById('idGerenteEvm').value.replace(/\D/g, "");
	if(idGerente>"") {
		 url += '&idGerenteEvm=' + idGerente;
	}
	
	var ferramenta = document.getElementById('ferramentaConexaoEvm').value;
	if(ferramenta>"") {
		 url += "&ferramentaConexaoEvm='" + ferramenta + "'";
	}
	
	var idIC = document.getElementById('idItemConfiguracao').value.replace(/\D/g, "");
	if(idIC>"") {
		 url += '&idItemConfiguracaoPai=' + idIC;
	}

	document.getElementById('iframeGerenteNagios').src = url;
	
}

function mostraAbasEvmGerentes(abaAtiva){
	
	//Mostra os gerentes e o botão de desvincular gerente
	document.getElementById("evmGerentes").style.display="block";
	document.getElementById("btDesvincularGerente").style.display="block";
	
	//Define a aba conforme o gerente
	if(abaAtiva!=null && abaAtiva>""){
		defineAbaAtiva(abaAtiva);
	}
	
}

function defineAbaAtiva(abaAtiva){
	//Recebe do banco de conexão do evm e define a aba que está o gerente
	switch (abaAtiva) {
	case "CITSMART_INVENTORY":
		abaGerenteInventory();
		$('.tabsbar a[href="#tab_gerente_1-3"]').tab('show');
	break;
	case "ZABBIX":
		abaGerenteZabbix();
		$('.tabsbar a[href="#tab_gerente_2-3"]').tab('show');
	break;
	case "NAGIOS":
		abaGerenteNagios();
		$('.tabsbar a[href="#tab_gerente_3-3"]').tab('show');
	break;
	default:
		limparAbasEvmGerentes();
	break;
	}
}

function escondeAbasEvmGerentes(){
	//Esconde os gerentes e também o botão de desvincular gerente
	document.getElementById("evmGerentes").style.display="none";
	document.getElementById("btDesvincularGerente").style.display="none";
	
}


function limparAbasEvmGerentes(){
	//Zera o conteúdo de todos os frames
	document.getElementById('iframeGerenteInventory').contentWindow.document.write("");
	document.getElementById('iframeGerenteZabbix').contentWindow.document.write("");
	document.getElementById('iframeGerenteNagios').contentWindow.document.write("");
	
	//Nenhuma aba fica escolhida
	document.getElementById("li_inventory").className = "";
	document.getElementById("li_zabbix").className = "";
	document.getElementById("li_nagios").className = "";
}

/**
 * Limpa campos específicos.
 */
function limpaFormItemConfiguracao() {
	document.form.idItemConfiguracao.value = "";
	document.getElementById("identificacao").value = "";
	document.getElementById("txtDescricao").value = "";
	document.getElementById("idGerenteEvm").value = "";
	document.getElementById("ferramentaConexaoEvm").value = "";
	escondeAbasEvmGerentes();
	limparAbasEvmGerentes();
};

function LOOKUP_SERVICO_DESENHO_select(id, desc) {
	document.getElementById("listaItensConfiguracaoSerializada").value = "";
	var camposLookupServico = desc.split("-");
	document.getElementById("nomeServico").innerHTML = desc;
	document.form.idServico.value = id;
	document.form.fireEvent("selecionarServico");
	$('.tabsbar a[href="#tab1-3"]').tab('show');
};
/**
 * Faz a seleção so item de configuração a partir da página de pesquisaItemConfiguracao
 */
function selectedItemConfiguracao(idItem) {
	limpaFormItemConfiguracao();
	document.form.idItemConfiguracao.value = idItem;
	mostraAbasEvmGerentes(null);
	document.form.fireEvent("selecionarItemConfigurcao");
	Modal.close('modal-mapa-desenho-apoio-pesquisar-ic');
};

/**
 * Faz a seleção so item de configuração a partir da página de pesquisaItemConfiguracao
 */
function selectedItemConfiguracao(idItem) {
	limpaFormItemConfiguracao();
	document.form.idItemConfiguracao.value = idItem;
	mostraAbasEvmGerentes(null);
	document.form.fireEvent("selecionarItemConfigurcao");
	Modal.close('modal-mapa-desenho-apoio-pesquisar-ic');
};

function defineFrameCorrelacao(){
	var url = ctx + '/pages/evmGerenteCorrelacao/evmGerenteCorrelacao.load?iframe=true&iframeNoSearchNoEditICPai=true';
	
	var idGerenteCorrelacao = document.getElementById('idGerenteCorrelacaoEvm').value.replace(/\D/g, "");
	
	if(idGerenteCorrelacao>"") {
		 url += '&idGerenteCorrelacaoEvm='+ idGerenteCorrelacao;
	}
	
	document.getElementById('iframeGerenteCorrelacao').src = url;
}

function carregaCorrelacaoServico(){
	openDialogFrameGerCorrelacao('POPUP_GERENTE_CORRELACAO');
}
