    addEvent(window, "load", load, false);
    
    function load(){
    	document.form.afterRestore = function () {
    		$('.tabsbar a[href="#tab-cadastro-midia-software"]').tab('show');
    	}
    }

    var Modal = {
		open : function(element) {
			$("#" + element).modal('show');
		},
		close : function(element) {
			$("#" + element).modal('hide');
		},
		clear : function(element) {
			$("#" + element).find("form").find(
					"input[type=text], input[type=hidden], textarea").val("");
		},
		controller : {
			data : [],
			set : function(key, value) {
				Modal.controller.data[key] = value;
			},
			get : function(key) {
				return Modal.controller.data[key];
			}
		}
    }
	
    function LOOKUP_MIDIASOFTWARE_select(id,desc){
		document.form.restore({idMidiaSoftware:id});
	}
	
    function excluir() {
		if (document.getElementById("idMidiaSoftware").value != "") {
			if (confirm( i18n_message("midiaSoftware.confirme.excluir"))) {
				document.form.fireEvent("excluir");
			}
		}
	}
    
    function limpar(){
		document.form.clear();
		$("#divMidiaSoftwareChave").html('<h5>'+i18n_message('midiaSoftware.nenhumaLicencaAdicionada')+'</h5>');
		$("#divConhecimento").html('<h5>'+i18n_message('citcorpore.comum.nenhumConhecimentoVinculado')+'</h5>');
	}

	function calculaQtdeLicencas() {
		var tabela = document.getElementById('tblMidiaSoftwareChave');
		if (tabela!=null){
			var count = $("#divMidiaSoftwareChave tbody tr").length;
			document.getElementById("licencas").value = count;
		} else {
			document.getElementById("licencas").value = 0;
		}
	}

	function limpaCamposLicenca(){
		document.form.chave.value = "";
		document.form.qtdPermissoes.value = "";
		document.getElementById("chave").focus();
		calculaQtdeLicencas();
	}
	
	addMidiaSoftwareChave = function() {
		if(StringUtils.isBlank(document.form.chave.value) || document.form.chave.value == null){
			document.getElementById("chave").focus();
			return;
		}
		if(StringUtils.isBlank(document.form.qtdPermissoes.value) || document.form.qtdPermissoes.value == 0){
			document.form.qtdPermissoes.value = 1;
		}		
		
		if($("#divMidiaSoftwareChave tbody tr").length < 1) {
			document.form.fireEvent("addTabelaMidiaSoftwareChave");
		} else {
			encontrou = false;
			$('#tblMidiaSoftwareChave tbody tr').each(function () {
				if (document.form.chave.value == $(this).find('td:eq(0)').text()) {
					encontrou = true;
				}
			});
			
			if (encontrou){
				notificacaoErro('midiaSoftware.chaveJaCadastrada','');
			} else {
				document.form.fireEvent("addLinhaTabelaMidiaSoftwareChave");
			}
		}
	}
	
	removerMidiaSoftwareChaveFromTable = function(btClick) {
		if (confirm(i18n_message("citcorpore.comum.deleta"))) {
			
			var trTable = btClick.closest('tr');
			
			trTable.remove();
			
			limpaCamposLicenca();
			
			// esconde o tooltip do botão
			fechaTooltip();
		}
	}
	
	vincularConhecimento = function(){
		JANELA_AGUARDE_MENU.show();
		if (document.getElementById('pesquisa').value!=''){
			document.form.fireEvent('pesquisaLucene');
		} else {
			JANELA_AGUARDE_MENU.hide();
		}
	}
	
	escolherBaseConhecimentoFromTable = function(btClick){
		var trTable = btClick.closest('tr');
		
		document.getElementById('idBaseConhecimento').value = $(trTable).find('td:eq(0)').text();
		document.getElementById('titulo').value = $(trTable).find('td:eq(1)').text();
		
		if($("#divConhecimento tbody tr").length < 1) {
			document.form.fireEvent("addTabelaBaseConhecimento");
		} else {
			encontrou = false;
			$('#tblBaseConhecimento tbody tr').each(function () {
				if (document.getElementById('idBaseConhecimento').value == $(this).find('td:eq(0)').text()) {
					encontrou = true;
				}
			});
			
			if (encontrou){
				notificacaoErro('baseConhecimento.conhecimentoJaVinculado','');
			} else {
				document.form.fireEvent("addLinhaTabelaBaseConhecimento");
			}
		}
	}
	
	removerBaseConhecimentoFromTable = function(btClick) {
		if (confirm(i18n_message("citcorpore.comum.deleta"))) {
			
			var trTable = btClick.closest('tr');
			
			trTable.remove();
			
			// esconde o tooltip do botão
			fechaTooltip();
		}
	}
	
	serializarListaMidiaSoftwareChave = function(){
		var listaMidiaSoftwareChave = [];
		
		$('#tblMidiaSoftwareChave tbody tr').each(function () {
		    listaMidiaSoftwareChave.push({
		    	idMidiaSoftwareChave : $(this).id,
		    	chave : $(this).find('td:eq(0)').text(),
		    	qtdPermissoes :  $(this).find('td:eq(1)').text()
		    });
		});
		
		document.form.midiaSoftwareChaveSerializada.value = ObjectUtils.serializeObjects(listaMidiaSoftwareChave);
		
		return true;
	}
	
	serializarListaConhecimentosSerializados = function(){
		var listaConhecimentosSerializados = [];
		
		$('#tblBaseConhecimento tbody tr').each(function () {
			listaConhecimentosSerializados.push({
				idConhecimentoMidiaSoftware : $(this).id,
				idBaseConhecimento : $(this).find('td:eq(0)').text()
		    });
		});
		
		document.form.conhecimentosSerializados.value = ObjectUtils.serializeObjects(listaConhecimentosSerializados);
		
		return true;
	}
	
	function salvar() {
		serializarListaMidiaSoftwareChave();
		serializarListaConhecimentosSerializados();
		document.form.save();
	}
