_TECLA_ENTER = 13;

$('#inputFiltroWebService').unbind('keypress').bind('keypress', function(evt){
	if(evt.keyCode == _TECLA_ENTER){
		filtrarWebService();
	}
});

abrirModalPesquisaGrupo = function(){
	Modal.open('modal-pesquisa-grupo');
};

fechaModalPesquisaGrupo = function(){
	Modal.close('modal-pesquisa-grupo');
};

LOOKUP_GRUPO_select = function (id, desc) {
	var tbl = document.getElementById('tabelaGrupos');
	var lastRowBefore = tbl.rows.length;
	
	document.formMobileGerenciamentoDeWebServices.idGrupo.value = id;
	addGridGrupo(id, formataNomeGrupoSelecionado(desc));

	var lastRowAfter = tbl.rows.length;
	
	if(lastRowBefore != lastRowAfter){
		this.gravar();
	}
	
	fechaModalPesquisaGrupo();
	limpar_LOOKUP_GRUPO();
};

formataNomeGrupoSelecionado = function(grupo){
	var arrGrupo = grupo.split(" - ");
	arrGrupo.pop();
	return arrGrupo.toString().replace(",", " - ");
};


addGridGrupo = function(id, nomeGrupo) {
	var tbl = document.getElementById('tabelaGrupos');
	tbl.style.display = 'block';
	var lastRow = tbl.rows.length;

	$('#divTabelaGrupos').show();
	var obj = new CIT_GrupoDTO();
	obj.idGrupo = id;
	obj.nomeGrupo = nomeGrupo;

	HTMLUtils.addRow('tabelaGrupos', document.formMobileGerenciamentoDeWebServices, null, obj, ['','idGrupo','nomeGrupo'], ['idGrupo'], i18n_message('citcorpore.comum.registroJaAdicionado'), [gerarButtonDeleteGrupo], null, null, false);
	novoItem();
	HTMLUtils.applyStyleClassInAllCells('tabelaGrupo', 'celulaGrid');
	
};

novoItem = function() {
	document.formMobileGerenciamentoDeWebServices.rowIndex.value = "";
};

gerarButtonDeleteGrupo = function(row) {
	var message = i18n_message("citsmartMobile.configuracaoWebservices.desvincularGrupo");
	row.cells[0].innerHTML = '<img id="imgDelInfo" style="cursor: pointer;" title="' + message + '" src="' + ctx + '/imagens/delete.png" onclick="deleteLinha(\'tabelaGrupos\', this.parentNode.parentNode.rowIndex, $(this).parent().next(\'td\').text());">'
};

deleteLinha = function(table, index, idGrupo) {
	if (table === "tabelaGrupos") {
		if (confirm(i18n_message("citsmartMobile.configuracaoWebservices.desejaRealmenteDesvincularGrupo"))) {
			JANELA_AGUARDE_MENU.show();
			
			document.formMobileGerenciamentoDeWebServices.rowIndex.value = index;
			document.formMobileGerenciamentoDeWebServices.idGrupo.value = idGrupo;
			document.formMobileGerenciamentoDeWebServices.fireDelete('unlinkGroupInWebServices', function(){
				if(document.getElementById('tabelaGrupos').rows.length < 2)
					$('#divTabelaGrupos').hide();
			});
		}
	}
};

deleteAllRows = function() {
	var tabela = document.getElementById('tabelaGrupos');
	var count = tabela.rows.length;

	while (count > 1) {
		tabela.deleteRow(count - 1);
		count--;
	}
	$('#divTabelaGrupos').hide();
};

gravar = function(){
	var objs = HTMLUtils.getObjectsByTableId('tabelaGrupos');
	document.formMobileGerenciamentoDeWebServices.colGrupoSerialize.value = ObjectUtils.serializeObjects(objs);
	
	if($('#colGrupoSerialize').val() != null && $('#colGrupoSerialize').val() != undefined && $('#colGrupoSerialize').val() != ""){
		JANELA_AGUARDE_MENU.show();
		document.formMobileGerenciamentoDeWebServices.save();
	}else{
		alert(i18n_message("citsmartMobile.configuracaoWebservices.necessarioInserirAoMenosUmGrupo"));
	}
};

filtrarWebService = function(){    
    document.formMobileGerenciamentoDeWebServices.textoPesquisado.value = $("#inputFiltroWebService").val();
    document.formMobileGerenciamentoDeWebServices.fireEvent("filtrarWebService");
};

limparFiltroWebServices = function(){
	 $("#textoPesquisado").val("");
	 $("#inputFiltroWebService").val("");
	 document.formMobileGerenciamentoDeWebServices.fireEvent("filtrarWebService");
};


/*IFRAME OPERACAOREST/OPERACAOREST.LOAD */
showWebService = function(idRestOperation) {
	document.getElementById('iframeWebService').src = "";
	document.getElementById('iframeWebService').src = URL_SISTEMA+'pages/operacaoRest/operacaoRest.load?iframe=true&editar=RO&idRestOperation=' + idRestOperation;
	JANELA_AGUARDE_MENU.show();
	
	Modal.open('modal-webservice');
	$('.modalTitle').text(i18n_message("citcorpore.comum.visualizar"));
}

fechaModalWebService = function(){
	Modal.close('modal-webservice');
}

editWebService = function(idRestOperation){
	document.getElementById('iframeWebService').src = "";
	document.getElementById('iframeWebService').src = URL_SISTEMA+'pages/operacaoRest/operacaoRest.load?iframe=true&editar=UPD&idRestOperation=' + idRestOperation;
	JANELA_AGUARDE_MENU.show();
	
	Modal.open('modal-webservice');
	$('.modalTitle').text(i18n_message("citcorpore.comum.editar"));
};