_ENTER = 13;

$(window).load(function(){
	popup = new PopupManager(1000, 900, ctx+"/pages/");
	document.form.afterRestore = function() {
		$('.tabs').tabs('select', 0);
	}

	$("#filtroIdentificacao").keypress(function(event) {
		if (event.which == _ENTER) {
			event.preventDefault();
			pesquisar();
		}
	});
	
	$('#conteudoiframeInformacaoItemConfiguracao').html('<iframe id="iframeInformacaoItemConfiguracao" src="about:blank" width="99%" height="530" class="iframeSemBorda"></iframe>');
});

$( document.form ).ready(function() {
	HTMLUtils.focusInFirstActivateField(document.form);
});

$(function() {
	$('.datepicker').datepicker();
});

aguarde = function() {
	JANELA_AGUARDE_MENU.show();
}

fechar_aguarde = function() {
	JANELA_AGUARDE_MENU.hide();
}

function pesquisar() {
	document.form.paginaSelecionada.value = 1;
	pesquisarIC();
}

function pesquisarIC(){
	var dataInicio = document.getElementById("dataInicio").value;
	var dataFim = document.getElementById("dataFim").value;

	if (dataInicio != '' || dataFim != '') {
		if (DateTimeUtil.isValidDate(dataInicio) == false) {
			notificacaoI18N("citcorpore.comum.impossivelRealizarConsulta", "citcorpore.comum.datainvalida");
 			document.getElementById("dataInicio").value = '';
			return false;
		}

		if (DateTimeUtil.isValidDate(dataFim) == false) {
			notificacaoI18N("citcorpore.comum.impossivelRealizarConsulta", "citcorpore.comum.dataFinalInvalida");
	 		document.getElementById("dataFim").value = '';
			return false;
		}

		if (!validaData(dataInicio, dataFim) ) {
			return false;
		}
	}
	aguarde();
	document.form.fireEvent("pesquisarItemConfiguracao");
}

function limpar() {
	document.form.clear();
	
	$('#filtroFilhos').removeAttr('checked');
	$('#filtroFilhos').parent().css("left", "-50%");
	
	limparGrid();
}

function verificarExpiracao() {
	document.form.fireEvent('verificarExpiracao');
}

function LOOKUP_GRUPOITEMCONFIGURACAO_select(id, desc) {
	document.form.idGrupoItemConfiguracao.value = id;
	document.form.nomeGrupoItemConfiguracao.value = desc;
	Modal.close('modal-item-configuracao-grupo');
}

function consultarGrupoItemConfiguracao(){
	Modal.open('modal-item-configuracao-grupo');
}

function validaData(dataInicio, dataFim) {
	if (typeof(locale) === "undefined") locale = '';

	var dtInicio = new Date();
	var dtFim = new Date();

	var dtInicioConvert = '';
	var dtFimConvert = '';
	var dtInicioSplit = dataInicio.split("/");
	var dtFimSplit = dataFim.split("/");

	if (locale == 'en') {
		dtInicioConvert = dtInicioSplit[2] + "/" + dtInicioSplit[0] + "/" + dtInicioSplit[1];
		dtFimConvert = dtFimSplit[2] + "/" + dtFimSplit[0] + "/" + dtFimSplit[1];
	} else {
		dtInicioConvert = dtInicioSplit[2] + "/" + dtInicioSplit[1] + "/" + dtInicioSplit[0];
		dtFimConvert = dtFimSplit[2] + "/" + dtFimSplit[1] + "/" + dtFimSplit[0];
	}

	dtInicio.setTime(Date.parse(dtInicioConvert)).setFullYear;
	dtFim.setTime(Date.parse(dtFimConvert)).setFullYear;

	if (dtInicio > dtFim){
		notificacaoI18N("citcorpore.comum.impossivelRealizarConsulta", "citcorpore.comum.dataInicioMenorFinal");
		return false;
	}else
		return true;
}

function limparGrid(){
	$("#divDinamicoPesquisaItemConfiguracao").empty();
}

function paginarItemConfiguracao(paginaSelecionada) {
	$('#divDinamicoPesquisaItemConfiguracao').hide("blind", "fast",	function(){
		aguarde();
		document.form.paginaSelecionada.value = paginaSelecionada;
		pesquisarIC();
	});
}

function depoisCarregarTabelaItemConfiguracao() {
	fechar_aguarde();
	$('#divDinamicoPesquisaItemConfiguracao').show("blind", "fast",	function(){});
}

function popupAtivos(idItem, identificacao) {
	if (iframe != null) {
		/*
		* author: rodrigo.guilherme
		* Agora é possível definir um nome para a função que receberá o IC, passando-a por parâmetro. Caso não seja passado, funcionará como o padrão anterior.
		*/
		if(funcaoPaiFrame){
			var nomeFuncao = "parent."+funcaoPaiFrame+"("+idItem+")";
			var funcao = new Function(nomeFuncao);
			funcao();
		}else{
			// caso não haja o segundo parâmetro, continua como estava anteriormente (cai no else)
			if(typeof identificacao !== "undefined") {
				parent.selectedItemConfiguracao(idItem, identificacao);
			} else {
				parent.selectedItemConfiguracao(idItem);
			}
		}
	} else {
		exibirDialogInformacoes(idItem);
	}
}

function exibirDialogInformacoes(idItem) {
	var frame = document.getElementById("iframeInformacaoItemConfiguracao");

	var frameDoc = frame.contentDocument || frame.contentWindow.document;
	frameDoc.documentElement.innerHTML = "";

	frame.src = ctx
			+ '/pages/gerenciamentoItemConfiguracao/gerenciamentoItemConfiguracao.load?iframe=true&iFramInformacaoItemConfiguracao=true&idInfoItem='
			+ idItem;
	
	Modal.open('modal_informacaoItemConfiguracao');
}

function ocultarAreaExibirFilhos() {
	$("#divExibirFilhos").hide();
}