$(document)
		.ready(function() {
			$("#idFornecedor").change(function() {
				var idFornecedor = $('#idFornecedor').val();
				carregarContratos();
			});

			$("#tipoResponsavelObjetivo").on("change", function() {
				// Limpar
				$("#idRespObj").attr("value", "");
				$("#idGrupoRespObj").attr("value", "");
				$("#responsavelObjetivo").attr("value", "");

				// Apontar quem são os IDs do momento para a lookup
				$('#idResponsavel').val("#idRespObj");
				$('#nomeResponsavel').val("#responsavelObjetivo");
				$('#idGrupo').val("#idGrupoRespObj");
				$('#tipoResponsavel').val("#tipoResponsavelObjetivo");
			});

			$("#tipoResponsavelAcao").on("change", function() {
				// Limpar
				$("#idRespAcao").attr("value", "");
				$("#idGrupoRespAcao").attr("value", "");
				$("#responsavelAcao").attr("value", "");

				// Apontar quem são os IDs do momento para a lookup
				$('#idResponsavel').val("#idRespAcao");
				$('#nomeResponsavel').val("#responsavelAcao");
				$('#idGrupo').val("#idGrupoRespAcao");
				$('#tipoResponsavel').val("#tipoResponsavelAcao");
			});

			$("#tipoResponsavelMonitoramento").on("change", function() {
				// Limpar
				$("#idRespMon").attr("value", "");
				$("#idGrupoRespMon").attr("value", "");
				$("#responsavelMonitoramento").attr("value", "");

				// Apontar quem são os IDs do momento para a lookup
				$('#idResponsavel').val("#idRespMon");
				$('#nomeResponsavel').val("#responsavelMonitoramento");
				$('#idGrupo').val("#idGrupoRespMon");
				$('#tipoResponsavel').val("#tipoResponsavelMonitoramento");
			});

			$("#responsavelObjetivo")
					.on("click", function() {
						if ($("#tipoResponsavelObjetivo").attr("value") == "") {
							alert(i18n_message("gerenciamentoitemconfiguracao.selecioneresponsavel"));
						} else {
							if ($("#tipoResponsavelObjetivo").attr("value") == "U") {
								Modal.open($("#modal-responsavel"));
							} else if ($("#tipoResponsavelObjetivo").attr("value") == "G") {
								Modal.open($("#modal-responsavel-grupo"));
							}
						}
					});

			$("#responsavelAcao")
					.on("click", function() {
						if ($("#tipoResponsavelAcao").attr("value") == "") {
							alert(i18n_message("gerenciamentoitemconfiguracao.selecioneresponsavel"));
						} else {
							if ($("#tipoResponsavelAcao").attr("value") == "U") {
								Modal.open($("#modal-responsavel"));
							} else if ($("#tipoResponsavelAcao").attr("value") == "G") {
								Modal.open($("#modal-responsavel-grupo"));
							}
						}
					});

			$("#responsavelMonitoramento")
					.on("click", function() {
						if ($("#tipoResponsavelMonitoramento").attr("value") == "") {
							alert(i18n_message("gerenciamentoitemconfiguracao.selecioneresponsavel"));
						} else {
							if ($("#tipoResponsavelMonitoramento")
									.attr("value") == "U") {
								Modal.open($("#modal-responsavel"));
							} else if ($("#tipoResponsavelMonitoramento").attr("value") == "G") {
								Modal.open($("#modal-responsavel-grupo"));
							}
						}
					});

			$('.datepicker').datepicker();
			$('#btnExcluirPlano').hide();
		});

function gravarPlano() {
	if ($('#titulo').val().trim() != '' && $('#dataInicioPlano').val().trim() != '' && $('#dataFimPlano').val().trim() != '') {
		document.form.fireEvent('gravarPlano');
	} else {
		alert(i18n_message('acordoNivelServico.informarCampos'));
	}
}

function excluirPlano() {
	if (confirm(i18n_message('gerenciamentoitemconfiguracao.mensagemexcluir'))) {
		JANELA_AGUARDE_MENU.show();
		document.form.fireEvent('excluirPlano');
		limparPlano();
		$('#btnExcluirPlano').hide();
	}
}

function editarPlano() {
	JANELA_AGUARDE_MENU.show();
	$('#btnExcluirPlano').show();
	document.form.fireEvent('editarPlano');
	carregarObjetivos();
	carregarContratos();
	$('#conteudo').show();
	$('#subconteudo').hide();
}

function limparPlano() {
	$('#btnGravarPlano').html(i18n_message('citcorpore.comum.gravar'));
	document.formAcao.clear();
	document.formMonitoramento.clear();
	document.formObjetivo.clear();
	document.form.clear();
	$('#conteudo').hide();
}

function LOOKUP_PLANO_DE_MELHORIA_select(id, desc) {
	JANELA_AGUARDE_MENU.show();
	document.form.idPlanoMelhoria.value = id;	
	editarPlano();
	$("a[href=#tabCadastro]").trigger('click');
	JANELA_AGUARDE_MENU.hide();
}

function carregarObjetivos() {
	$('#objetivos').empty();
	document.form.fireEvent('carregarObjetivos');
}

function gravarObjetivo() {
	if ($('#tituloObjetivo').val().trim() != '') {

		document.formObjetivo.idObjetivoMonitoramento.value = document.form.idObjetivoMonitoramento.value;
		document.formObjetivo.idObjetivoPlanoMelhoria.value = document.form.idObjetivoPlanoMelhoria.value;
		document.formObjetivo.idAcaoPlanoMelhoria.value = document.form.idAcaoPlanoMelhoria.value;
		document.formObjetivo.idPlanoMelhoria.value = document.form.idPlanoMelhoria.value;
		document.formObjetivo.fireEvent('gravarObjetivo');

	} else {
		alert(i18n_message('acordoNivelServico.informarCampos'));
	}
}

function editarObjetivo(id) {
	JANELA_AGUARDE_MENU.show();
	document.form.idObjetivoPlanoMelhoria.value = id;
	document.form.fireEvent('editarObjetivo');
	abrirModalObjetivo();
}

function abrirModalObjetivo() {
	criaDialog('P', 'modalObjetivo', function() {
		document.formObjetivo.clear();
		document.form.fireEvent('refreshTables');
	});
	$("#modalObjetivo").dialog("open");
}

function abrirModalNovoObjetivo() {
	document.formObjetivo.clear();
	document.form.idObjetivoPlanoMelhoria.value = null;
	abrirModalObjetivo();
}

function selecionarObjetivo(id) {
	document.form.idObjetivoPlanoMelhoria.value = id;
	document.formMonitoramento.idObjetivoPlanoMelhoria.value = id;
	document.formAcao.idObjetivoPlanoMelhoria.value = id;
	document.form.fireEvent('refreshTables');
	$('#subconteudo').show();
	exibirBotaoCadastrarAcao();
}

function excluirObjetivo(id) {
	if (confirm(i18n_message('gerenciamentoitemconfiguracao.mensagemexcluir'))) {
		document.form.idObjetivoPlanoMelhoria.value = id;
		document.form.fireEvent('excluirObjetivo');
	}
}

function fecharModalObjetivo() {
	$("#modalObjetivo").dialog("close");
}

function alertaAoDeletar() {
	alert(i18n_message('planoMelhoria.objetivo.alerta'));
}

function gravarAcao() {
	if ($('#tituloAcao').val().trim() != '' && $('#dataInicioAcao').val().trim() != '' && $('#dataFimAcao').val().trim() != '') {

		document.formAcao.idObjetivoMonitoramento.value = document.form.idObjetivoMonitoramento.value;
		document.formAcao.idObjetivoPlanoMelhoria.value = document.form.idObjetivoPlanoMelhoria.value;
		document.formAcao.idAcaoPlanoMelhoria.value = document.form.idAcaoPlanoMelhoria.value;
		document.formAcao.idPlanoMelhoria.value = document.form.idPlanoMelhoria.value;
		document.formAcao.fireEvent('gravarAcao');

	} else {
		alert(i18n_message('acordoNivelServico.informarCampos'));
	}
}

function limparResponsavelAcao() {
	$('#responsavelAcao').val('');
	$('#tipoResponsavelAcao').val('0');
	$("#idGrupoRespAcao").val('');
	$("#idRespAcao").val('');
}

function editarAcao(id) {
	JANELA_AGUARDE_MENU.show();
	document.form.idAcaoPlanoMelhoria.value = id;
	document.form.fireEvent('editarAcao');
	abrirModalAcao();
}

function fecharModalAcao() {
	$("#modalAcao").dialog("close");
	document.formAcao.tituloAcao.value = null;
	document.formAcao.detalhamentoAcao.value = null;
	document.formAcao.dataInicioPlano.value = null;
	document.formAcao.dataFimPlano.value = null;
	document.formAcao.responsavelAcao.value = null;
}

function exibirBotaoCadastrarAcao() {
	$('#cadastrarAcao').show();
	$('#cadastrarMonitoramento').show();

	$('#listaVaziaAcoes').hide();
	$('#listaVaziaMonitoramento').hide();
}

function abrirModalAcao() {
	criaDialog('P', 'modalAcao', function() {
		document.form.idAcaoPlanoMelhoria.value = null;
		document.formAcao.clear();
	});
	$("#modalAcao").dialog("open");
}

function excluirAcao(id) {
	if (confirm(i18n_message('gerenciamentoitemconfiguracao.mensagemexcluir'))) {
		document.form.idAcaoPlanoMelhoria.value = id;
		document.form.fireEvent('excluirAcao');
	}
}

function isMonitoramentoValido() {
	if (document.formMonitoramento.tituloMonitoramento.value != '' && 
		document.formMonitoramento.tituloMonitoramento.value != null && 
		document.formMonitoramento.fatorCriticoSucesso.value != '' && 
		document.formMonitoramento.fatorCriticoSucesso.value != null) {
		
		document.formMonitoramento.idPlanoMelhoria.value = document.form.idPlanoMelhoria.value;
		document.formMonitoramento.idObjetivoPlanoMelhoria.value = document.form.idObjetivoPlanoMelhoria.value;
		document.formMonitoramento.idObjetivoMonitoramento.value = document.form.idObjetivoMonitoramento.value;
		return true;
	} else {
		alert(i18n_message('acordoNivelServico.informarCampos'));
		return false;
	}	
}

function gravarMonitoramentoComValidacaoDeKpi() {
	if(isMonitoramentoValido()) {
		document.formMonitoramento.fireEvent('gravarMonitoramentoComValidacaoDeKpi');
	}
}

function abrirModalMonitoramento() {
	criaDialog('M', 'modalMonitoramento', function() {
		var tempIdObjetivoMonitoramento = idObjetivoMonitoramento.value;
		var tempFatorCriticoSucesso = fatorCriticoSucesso.value;
		var tempTituloMonitoramento = tituloMonitoramento.value;
		
		if(tempIdObjetivoMonitoramento != null && tempIdObjetivoMonitoramento != '') {
			if((tempTituloMonitoramento == null || tempTituloMonitoramento == '')
				&& (tempFatorCriticoSucesso == null || tempFatorCriticoSucesso == ''))  {
				excluirMonitoramentoSemValidacao(tempIdObjetivoMonitoramento);
			} else {
				tratamentoAoFecharModalMonitoramento();
			}
		}
	});
	document.formMonitoramento.clear();
	$("#modalMonitoramento").dialog("open");
	$("#boxKpi").show();
}

function editarMonitoramento(id) {
	JANELA_AGUARDE_MENU.show();
	document.form.idObjetivoMonitoramento.value = id;

	document.formMonitoramento.idPlanoMelhoria.value = document.form.idPlanoMelhoria.value;
	document.formMonitoramento.idObjetivoPlanoMelhoria.value = document.form.idObjetivoPlanoMelhoria.value;
	document.formMonitoramento.idObjetivoMonitoramento.value = id;
	document.formMonitoramento.kpi.value = null;
	
	document.form.fireEvent('editarMonitoramento');
	abrirModalMonitoramento();
}

function fecharModalMonitoramento() {
	$("#modalMonitoramento").dialog("close");
	tratamentoAoFecharModalMonitoramento();
}

function tratamentoAoFecharModalMonitoramento() {
	document.form.idObjetivoMonitoramento.value = null;
	limparMonitoramento();
	document.form.fireEvent('atualizarTabelaMonitoramento');
}

function excluirMonitoramento(id) {
	if (confirm(i18n_message('gerenciamentoitemconfiguracao.mensagemexcluir'))) {
		excluirMonitoramentoSemValidacao(id);
	}
}

function excluirMonitoramentoSemValidacao(id) {
	document.form.idObjetivoMonitoramento.value = id;
	document.form.fireEvent('excluirMonitoramento');
}

function limparMonitoramento() {
	document.formMonitoramento.tituloMonitoramento.value = '';
	document.formMonitoramento.fatorCriticoSucesso.value = '';
	document.formMonitoramento.metrica.value = '';
	document.formMonitoramento.medicaoMonitoramento.value = '';
	document.formMonitoramento.relatorios.value = '';
	document.formMonitoramento.responsavelMonitoramento.value = '';
	document.formMonitoramento.idObjetivoMonitoramento.value = '';
}  

function gravarKpi() {
	if (isMonitoramentoValido()) {
		if(isKpiValido()) { // Se deixar os dois na mesma validação, poderá disparar 2 alertas idênticos
			if(document.formMonitoramento.idObjetivoMonitoramento.value != null && document.formMonitoramento.idObjetivoMonitoramento.value != '') {
				document.formMonitoramento.fireEvent('gravarKpi');
			} else {
				document.formMonitoramento.fireEvent('gravarPrimeiroKpi');
			}
			
			document.formMonitoramento.kpi.value = null;
		}
	}
}

function isKpiValido() {
	if(document.formMonitoramento.kpi.value != null && document.formMonitoramento.kpi.value != '') {
		return true;
	} else {
		alert(i18n_message('acordoNivelServico.informarCampos'));
		return false;
	}
}

function excluirKpi(id) {
	if (confirm(i18n_message('gerenciamentoitemconfiguracao.mensagemexcluir'))) {
		document.formMonitoramento.idKpiObjetivoMonitoramento.value = id;
		document.formMonitoramento.fireEvent('excluirKpi');
	}
}

function carregarContratos() {
	$("#idContrato").empty();
	document.form.fireEvent('carregarContratos');
}

function LOOKUP_RESPONSAVEL_select(id, desc) {
	$($('#idResponsavel').val()).attr("value", id);
	$($('#nomeResponsavel').val()).attr("value", desc);
	$($('#idGrupo').val()).val('');

	Modal.close($("#modal-responsavel"));
}

function LOOKUP_RESPONSAVEL_GRUPO_select(id, desc) {
	$($('#idResponsavel').val()).val('');
	$($('#nomeResponsavel').val()).attr("value", desc);
	$($('#idGrupo').val()).attr("value", id);

	Modal.close($("#modal-responsavel-grupo"));
}

function limparResponsavelObjetivo() {
	$('#responsavelObjetivo').val('');
	$('#tipoResponsavelObjetivo').val('0');
	$("#idGrupoRespObj").val('');
	$("#idRespObj").val('');
}

function gerarRelatorioEmPDF() {
	JANELA_AGUARDE_MENU.show();
	document.form.fireEvent('gerarRelatorioEmPDF');
}

var Modal = {
init : function(_element, header, body, footer) {
	_element.find('.title').html(header);
	_element.find('.modal-body').html(body);
	_element.find('.modal-footer').html(footer);
},

open : function(_element) {
	_element.modal('show');
},

close : function(_element) {
	_element.modal('hide');
},

clear : function(_element) {
	_element.find('.title').html("");
	_element.find('.modal-body').html("");
	_element.find('.modal-footer').html("");
}
}