addEvent(window, "load", load, false);
function load() {
	$('#data').datepicker('option', 'onSelect', function() {
		$(this).focus();
	});
}

function getObjetoSerializado() {
	
	var obj = new CIT_PrestacaoContasViagemDTO();
	var integrante = new CIT_IntegranteViagemDTO();

	integrante.idSolicitacaoServico = $('#idSolicitacaoServico').val();
	integrante.idEmpregado = $('#idEmpregado').val();
	integrante.idRespPrestacaoContas = $('#idRespPrestacaoContas').val();
	integrante.idTarefa = $('#idTarefa').val();

	HTMLUtils.setValuesObject(document.form, obj);
	var itemPrestacaoContas = HTMLUtils.getObjectsByTableId('tabelaItemPrestacaoContasViagem');

	obj.itensPrestacaoContasViagemSerialize = ObjectUtils.serializeObjects(itemPrestacaoContas);
	obj.integranteSerialize = ObjectUtils.serializeObjects(integrante);

	return ObjectUtils.serializeObject(obj);
	
}

/* Funcoes para salvar itens */
function adicionarItem() {
	var numeroDocumento = document.getElementById("numeroDocumento").value;
	var data = document.getElementById("data").value;
	var nomeFornecedor = document.getElementById("nomeFornecedor").value;
	var valor = document.getElementById("valor").value;
	var descricao = document.getElementById("descricao").value;

	if (StringUtils.isBlank(StringUtils.trim(numeroDocumento))) {
		alert(i18n_message("rh.alertOCampo") + ' [' + i18n_message("prestacaoContas.numeroNf")+'] '+i18n_message("rh.alertEObrigatorio")+'!');
		return;
	}

	if (StringUtils.isBlank(StringUtils.trim(data))) {
		alert(i18n_message("rh.alertOCampo") + ' [' + i18n_message("prestacaoContas.dataEmissaoNf")+'] '+i18n_message("rh.alertEObrigatorio")+'!');
		return;
	}

	if (StringUtils.isBlank(StringUtils.trim(nomeFornecedor))) {
		alert(i18n_message("rh.alertOCampo") + ' [' + i18n_message("prestacaoContas.estabelecimentoEmissorNf")+'] '+i18n_message("rh.alertEObrigatorio")+'!');
		return;
	}

	if (StringUtils.isBlank(StringUtils.trim(valor))) {
		alert(i18n_message("rh.alertOCampo") + ' [' + i18n_message("prestacaoContas.valorNf")+'] '+i18n_message("rh.alertEObrigatorio")+'!');
		return;
	}

	if(StringUtils.isBlank(StringUtils.trim(descricao))) {
		alert(i18n_message("rh.alertOCampo") + ' [' + i18n_message("prestacaoContas.descricaoDespesa")+'] '+i18n_message("rh.alertEObrigatorio")+'!');
		return;
	}

	addLinhaTabelaItem(nomeFornecedor, numeroDocumento, data, valor, descricao);

	atualizarValores();
}

function addLinhaTabelaItem(nomeFornecedor, numeroDocumento, data, valor, descricao) {
	
	var obj = new CIT_ItemPrestacaoContasViagemDTO();
	var rowIndex = document.getElementById("rowIndexItemPrestacaoContas").value;
	var valorAux = valor.replace(",", ".");;
	var totalJaLancado = document.getElementById("totalLancamentos").value.replace(",", ".");

	obj.numeroDocumento = numeroDocumento;
	obj.data = data;
	obj.nomeFornecedor = nomeFornecedor;
	obj.valor = valor;
	obj.valorAux = valorAux;
	obj.descricao = descricao;

	if(StringUtils.isBlank(StringUtils.trim(rowIndex)) || rowIndex == null) {
		HTMLUtils.addRow('tabelaItemPrestacaoContasViagem', document.form, null, obj, ["numeroDocumento", "data", "nomeFornecedor", "valor", "descricao", ""],
				null, null, [gerarButtonsTable], null, null, false);

		document.getElementById("totalLancamentosAux").value = substituirPontoPorVirgula(parseFloat(totalJaLancado) + parseFloat(valorAux));
	} else {
		var itemPrestacaoContas = HTMLUtils.getObjectByTableIndex("tabelaItemPrestacaoContasViagem", rowIndex);

		document.getElementById("totalLancamentosAux").value = substituirPontoPorVirgula(parseFloat(totalJaLancado) - parseFloat(itemPrestacaoContas.valorAux) + parseFloat(valorAux));

		obj.idItemPrestContasViagem = itemPrestacaoContas.idItemPrestContasViagem;
		obj.idPrestacaoContasViagem = itemPrestacaoContas.idPrestacaoContasViagem;

		if(itemPrestacaoContas.numeroDocumento == obj.numeroDocumento) {
			HTMLUtils.updateRow('tabelaItemPrestacaoContasViagem', document.form, null, obj, ["numeroDocumento", "data", "nomeFornecedor", "valor", "descricao", ""],
					null, '', [gerarButtonsTable], null, null, document.getElementById("rowIndexItemPrestacaoContas").value, false);
		} else {
			HTMLUtils.updateRow('tabelaItemPrestacaoContasViagem', document.form, null, obj, ["numeroDocumento", "data", "nomeFornecedor", "valor", "descricao", ""],
					null, null, [gerarButtonsTable], null, null, document.getElementById("rowIndexItemPrestacaoContas").value, false);
		}
	}
	
}

function gerarButtonsTable(row) {
	row.cells[5].innerHTML += "<a href='#' class='btn-action btn-success glyphicons edit titulo' title="+ i18n_message('requisicaoViagem.editarItem') +" onclick='editarLinhaTabela(this.parentNode.parentNode.rowIndex);' ><i></i></a> ";
	row.cells[5].innerHTML += "<a href='#' class='btn-action glyphicons btn-danger titulo remove_2' title="+ i18n_message('requisicaoViagem.excluirItem') +" onclick='removeLinhaTabela(this.parentNode.parentNode.rowIndex);' ><i></i></a>";
}

function removeLinhaTabela(rowIndex) {
	
	if (window.confirm(i18n_message("citcorpore.comum.deleta"))) {
		var obj = HTMLUtils.getObjectByTableIndex("tabelaItemPrestacaoContasViagem", rowIndex);

		var totalJaLancado = document.getElementById("totalLancamentos").value.replace(',', '.');
		document.getElementById("totalLancamentosAux").value = substituirPontoPorVirgula(parseFloat(totalJaLancado) - parseFloat(obj.valorAux));

		document.getElementById('retirarValor').value = "S";
		document.getElementById('valor').value = obj.valor;
		
		if(obj.idItemPrestContasViagem) {
			document.getElementById("idItemPrestacaoContasViagem").value = obj.idItemPrestContasViagem;
			document.form.fireEvent("removeItemPrestacaoContasViagem");
		} else {
			atualizarValores();
		}

		HTMLUtils.deleteRow("tabelaItemPrestacaoContasViagem", rowIndex);
	}
	
}

function editarLinhaTabela(rowIndex) {
	var obj = HTMLUtils.getObjectByTableIndex("tabelaItemPrestacaoContasViagem", rowIndex);

	document.getElementById("numeroDocumento").value = obj.numeroDocumento;
	document.getElementById("data").value = obj.data;
	document.getElementById("nomeFornecedor").value = obj.nomeFornecedor;
	document.getElementById("valor").value = (obj.valor).replace('.', '');
	document.getElementById("descricao").value = obj.descricao;

	document.getElementById("rowIndexItemPrestacaoContas").value = rowIndex;
}

function atualizarValores() {
	document.form.fireEvent('atualizarValores');
}

function limparCamposFormulario() {
	document.getElementById("numeroDocumento").value = "";
	document.getElementById("data").value = "";
	document.getElementById("nomeFornecedor").value = "";
	document.getElementById("valor").value = "";
	document.getElementById("valorAux").value = "";
	document.getElementById("descricao").value = "";
	document.getElementById("rowIndexItemPrestacaoContas").value = "";
}

function gravarPrestacaoContasImprimirRelatorio() {
	var itensPrestacaoContas = HTMLUtils.getObjectsByTableId('tabelaItemPrestacaoContasViagem');
	
	if(itensPrestacaoContas.length > 0) {
		var itemPrestacaoContas = HTMLUtils.getObjectsByTableId('tabelaItemPrestacaoContasViagem');
		
		var integrante = new CIT_IntegranteViagemDTO();
		integrante.idSolicitacaoServico = $('#idSolicitacaoServico').val();
		integrante.idEmpregado = $('#idEmpregado').val();
		integrante.idRespPrestacaoContas = $('#idRespPrestacaoContas').val();
		integrante.idTarefa = $('#idTarefa').val();
		
		document.getElementById("itensPrestacaoContasViagemSerialize").value = ObjectUtils.serializeObjects(itemPrestacaoContas);
		document.getElementById("integranteSerialize").value = ObjectUtils.serializeObject(integrante);
		
		document.form.fireEvent("gravarPrestacaoContasImprimirRelatorio");
	} else {
		alert('Nao ha itens!');
	}
}

// Masks
$('.format-money').maskMoney({
	thousands: '',
	decimal: ','
});

/**
 * Troca . por ,
 * No Controler do Java deve ser passado o numero fracionado com , ao invés do .
 * 
 * @param numero
 * @returns
 * 
 * Ex: numero = 20.25
 * numero = substituirPontoPorVirgula(numero)
 * numero = 20,25
 */
function substituirPontoPorVirgula(numero){
	
	if(numero != null && numero != "" && !isNaN(numero)){
		return numero.toString().replace(".",",")
	} else return numero;
	
}