var tabelaRelacionamentoICs;
var tabelaRelacionamentoSolicitacaoServico;

$(document).ready( function() {

	$('#telefoneContato').mask('(999) 9999-9999');

	$("#addSolicitante").click(function() {
		if (document.form.idContrato.value == '') {
			alert(i18n_message("contrato.alerta.informe_contrato"));
			document.form.idContrato.focus();
			return;
		}
		var y = document.getElementsByName("btnLimparLOOKUP_SOL_CONTRATO");
		y[0].style.display = 'none';
		Modal.open('modal-problema-add-solicitante', removeModalOverflowClass);
	});
	
	$("#nomeCategoriaOcorrencia").click(function() {
		Modal.open('modal-problema-ocorrencias-add-categoria', removeModalOverflowClass);
	});
	
	$("#nomeOrigemOcorrencia").click(function() {
		Modal.open('modal-problema-ocorrencias-add-origem', removeModalOverflowClass);
	});

	initTabelasRelacionamentos();
	
	$("#addSolicitacaoServico").click(function() {
		Modal.open('modal-problema-add-solicitacao-servico', removeModalOverflowClass);
	});

	$("#addImgSolicitacaoServico").click(function() {
		Modal.open('modal-problema-add-solicitacao-servico', removeModalOverflowClass);
	});
	
	//geber.costa Inserido no começo para ocultar a aba de Revisão, por padrão a prioridade é 5, e a aba de Revisão de problema grave deve ficar inativa , somente mudará quando a prioridade for 1 ou 2.
	atualizaPrioridade();
	});

function onkeypressUnidadeDes() {
	document.getElementById("idUnidade").value = "0";
}

function limpaCampoServicoNegocio() {
	$("#idServicoNegocio").val("");
	$('#servicoNegocio').val("");
}

/** Monta os parametros para a buscas do autocomplete* */
function montaParametrosAutocompleteUnidade() {
	$("#unidadeDes").autocomplete({
		source : function(request, response) {
			$.ajax({
				url : "pages/autoCompleteUnidade/autoCompleteUnidade.load",
				dataType : "json",
				data : {
					query : request.term,
					colection : 1,
					idContrato : document.form.idContrato.value
				},
				success : function(data) {
					response($.map(data, function(item) {
						return {
							label : item.nome,
							value : item.nome.replace(/-*/, ""),
							id : item.idUnidade,
						};
					}));
				}
			});
		},
		minLength : 3,
		select : function(e, ui) {
			$('#idUnidade').val(ui.item.id);
			document.form.fireEvent("preencherComboLocalidade");
		}
	});
}

function montaParametrosAutocompleteServicoNegocio() {
	$("#servicoNegocio").autocomplete({
		source : function(request, response) {
			$.ajax({
				url : 'pages/autoCompleteServicoNegocioTecnico/autoCompleteServicoNegocioTecnico.load',
				dataType : "json",
				data : {
					query : request.term,
					colection : 1,
					contrato : document.form.idContrato.value,
					tipoServico: document.form.catalogoServico.value,
					categoriaServicoNegocio: document.form.categoriaServico.value
				},
				success : function(data) {
					var retorno = [];
					for(var i = 0; i < data.data.length; i++){
						retorno.push({
							label: data.suggestions[i],
							value: data.suggestions[i],
							id: data.data[i]
						});
					}
					response(retorno);
				}
			});
		},
		minLength : 3,
		select : function(e, ui) {
			$('#idServicoNegocio').val(ui.item.id);
		}
	});
}

function verificaSeContratoEstaVazio(){
	return $('#idContrato').val() === null || $('#idContrato').val() === undefined || $('#idContrato').val() === '';
}

function verificaSeCatalogoEstaVazio(){
	return $('#catalogoServico').val() === null || $('#catalogoServico').val() === undefined || $('#catalogoServico').val() === '';
}

function lancarErroContratoOuCatalogoSelecionados(){
	alert(i18n_message('problema.msgAlertaBuscarServico'));
}

function setarDescricao() {
	var txt = $("#DescricaoAuxliar").text();
	$("#DescricaoAuxliar").empty();
	$("#descricao").val(txt)
}

/*
 * Funções de inicialização
 */
function initTabelasRelacionamentos() {
	// ICs
	tabelaRelacionamentoICs = new CITTable("tblICs", [ "idItemConfiguracao", "nomeItemConfiguracao", "descricaoProblema" ], []);
	tabelaRelacionamentoICs.setInsereBotaoExcluir(true, ctx + "/imagens/delete.png");
	
	// Incidentes
	tabelaRelacionamentoSolicitacaoServico = new CITTable( "tblSolicitacaoServico", [ "idSolicitacaoServico", "nomeServico" ], []);
	tabelaRelacionamentoSolicitacaoServico.setInsereBotaoExcluir(true, ctx + "/imagens/delete.png");
	
	// Mudancas
	tabelaRelacionamentoMudancas = new CITTable("tblRDM", [ "idRequisicaoMudanca", "titulo", "descrStatus" ], []);
	tabelaRelacionamentoMudancas.setInsereBotaoExcluir(true, ctx + "/imagens/delete.png");
}

function fecharProblema() {
	Modal.close('modal-problema-add-solicitacao-servico');
}

function LOOKUP_SOLICITACAOSERVICO_select(id, numero, desc) {
	addLinhaTabelaSolicitacaoServico(id, desc, true);
}

function addLinhaTabelaSolicitacaoServico(id, desc, valida) {
	var tbl = document.getElementById('tblSolicitacaoServico');
	tbl.style.display = '';
	var lastRow = tbl.rows.length;
	if (valida) {
		if (!validaAddLinhaTabelaSolicitacaoServico(lastRow, id)) {
			return;
		}
	}

	tabelaRelacionamentoSolicitacaoServico.addObject([ id, desc ]);

	document.form.solicitacaoServicoSerializado.value = ObjectUtils.serializeObjects(tabelaRelacionamentoSolicitacaoServico.getTableObjects());

	Modal.close('modal-problema-add-solicitacao-servico');
}

function validaAddLinhaTabelaSolicitacaoServico(lastRow, id) {
	var listaSolicitacaoServico = ObjectUtils
			.deserializeCollectionFromString(document.form.solicitacaoServicoSerializado.value);

	if (lastRow > 1) {
		for (var i = 0; i < listaSolicitacaoServico.length; i++) {
			if (listaSolicitacaoServico[i].idSolicitacaoServico == id) {
				alert(i18n_message("citcorpore.comum.registroJaAdicionado"));
				return false;
			}
		}
	}
	return true;
}

/*
 * Funções de apoio
 */

function mostrarFormulario() {
	limpar(document.form);
}

function atualizaPrioridade() {
	var impacto = document.getElementById('impacto').value;
	var urgencia = document.getElementById('urgencia').value;

	/*
	 * geber.costa a aba de Revisão de Problema Grave depende da prioridade , sempre que muda a prioridade irá mudar ou não a disponibilidade dos campos da aba
	 */

	if (urgencia == "B") {
		if (impacto == "B") {
			document.form.prioridade.value = 5;
		} else if (impacto == "M") {
			document.form.prioridade.value = 4;
		} else if (impacto == "A") {
			document.form.prioridade.value = 3;
		}
	}

	if (urgencia == "M") {
		if (impacto == "B") {
			document.form.prioridade.value = 4;
		} else if (impacto == "M") {
			document.form.prioridade.value = 3;
		} else if (impacto == "A") {
			document.form.prioridade.value = 2;
		}
	}

	if (urgencia == "A") {
		if (impacto == "B") {
			document.form.prioridade.value = 3;
		} else if (impacto == "M") {

			document.form.prioridade.value = 2;
		} else if (impacto == "A") {
			document.form.prioridade.value = 1;

		}
	}
}

/*
 * Funções auxílio CRUD
 */

function limpar(form) {
	try {
		form.clear();
		parent.fecharPopup(); 
	} catch (e) {
	}
}

function validarDatas() {

	var inputs = document.getElementsByClassName("datepicker");
	var input = null;
	var errorMsg = i18n_message("citcorpore.comum.nenhumaDataDeveSerInferiorHoje");

	for (var i = 0; i < inputs.length; i++) {
		input = inputs[i];

		if (input == null) {
			continue;
		}

		if (comparaComDataAtual(input) < 0) {
			alert(errorMsg);
			input.focus();
			throw errorMsg;
		}
	}
}

// Função chamada em requisicaoMudanca
function fecharMudanca() {
	Modal.close('modal-problema-nova-mudanca');
}

function gravar() {
    if ($.isEmptyObject($("#idContrato").val())) {
	alert(i18n_message("problema.contrato") + " : " + i18n_message("citcorpore.comum.campo_obrigatorio"));
	return;
    }

    if ($.isEmptyObject($("#idUnidade").val())) {
	alert(i18n_message("unidade.unidade") + " : " + i18n_message("citcorpore.comum.campo_obrigatorio"));
	return;
    }
    
    if ($.isNumeric(idDeBaseConhecimento)) {
	$("#idBaseConhecimento").val(parseInt(idDeBaseConhecimento));
    }
    
    $("#itensConfiguracaoRelacionadosSerializado").val(ObjectUtils.serializeObjects(tabelaRelacionamentoICs.getTableObjects()));
    $("#solicitacaoServicoSerializado").val(ObjectUtils.serializeObjects(tabelaRelacionamentoSolicitacaoServico.getTableObjects()));
    $("#requisicaoMudancaSerializado").val(ObjectUtils.serializeObjects(tabelaRelacionamentoMudancas.getTableObjects()));
    serializaProblema();
    serializaConhecimento();

    var informacoesComplementares_serialize = '';
    try {
	informacoesComplementares_serialize = window.frames["fraInformacoesComplementares"].getObjetoSerializado();
    } catch (e) {
	console.log(e);
    }

    $("#informacoesComplementares_serialize").val(informacoesComplementares_serialize);
    //validarDatas();

    $("[class*='Valid']").on('focus.collapseOnFocus', collapseWidgetOnFocus);

	document.form.save();
	}


function restaurar() {
	var listaICs = ObjectUtils
			.deserializeCollectionFromString(document.form.itensConfiguracaoRelacionadosSerializado.value);
	var listaSolicitacaoServico = ObjectUtils
			.deserializeCollectionFromString(document.form.solicitacaoServicoSerializado.value);
	var listaRequisicaoMudanca = ObjectUtils
			.deserializeCollectionFromString(document.form.requisicaoMudancaSerializado.value);
	limpaListasRelacionamentos();

	if (listaICs.length > 0) {
		for (var i = 0; i < listaICs.length; i++) {
			tabelaRelacionamentoICs
					.addObject([
							listaICs[i].idItemConfiguracao,
							listaICs[i].nomeItemConfiguracao,
							listaICs[i].descricaoProblema,
							getBotaoMostrarServicosRelacionados(listaICs[i].idItemConfiguracao) ]);

		}
	}
	if (listaSolicitacaoServico.length > 0) {
		for (var i = 0; i < listaSolicitacaoServico.length; i++) {
			tabelaRelacionamentoSolicitacaoServico.addObject([
					listaSolicitacaoServico[i].idSolicitacaoServico,
					listaSolicitacaoServico[i].nomeServico, ]);

		}
	}

	if (listaRequisicaoMudanca.length > 0) {
		for (var i = 0; i < listaRequisicaoMudanca.length; i++) {
			tabelaRelacionamentoMudancas.addObject([
					listaRequisicaoMudanca[i].idRequisicaoMudanca,
					listaRequisicaoMudanca[i].titulo,
					listaRequisicaoMudanca[i].descrStatus]);

		}
	}
	/*
	 * geber.costa
	 * 
	 * Na hora de restaurar o problema será verificado a prioridade para validar
	 * a aba de Revisão de problema de Grave
	 */
	atualizaPrioridade();

}

function getBotaoMostrarServicosRelacionados(idItemConfiguracao) {
	var botao = new Image();

	botao.src = ctx + "/template_new/images/icons/small/grey/magnifying_glass.png";
	botao.setAttribute("style", "cursor: pointer;");
	botao.id = idItemConfiguracao;
	botao.addEventListener("click", function(evt) {
		$("#popupServicosRelacionados").dialog("open");
	}, true);

	return botao;
}

function mostrarServicosRelacionados(idItemConfiguracao) {
	alert(idItemConfiguracao);
}

function deletar() {
	if (confirm(i18n_message("problema.deseja_deletar"))) {
		document.form.fireEvent("delete");
	}
}

function restaurarRegistro(idRegistro) {
	mostrarFormulario();
	document.form.fireEvent("restore");
}

/*
 * Funções de relacionamento
 */

// adicionar ics
function selectedItemConfiguracao(id) {
	document.getElementById('hiddenIdItemConfiguracao').value = id;

	var tbl = document.getElementById('tblICs');
	tbl.style.display = '';
	var lastRow = tbl.rows.length;
		if (!validaAddLinhaTabelaItemConfiguracao(lastRow, id)) {
			return;
		}
		
	Modal.open('modal-problema-desc-ic', removeModalOverflowClass);
	}

function addLinhaTabelaItemConfiguracao(id, desc) {
	var descProblema = document.getElementById('hiddenDescricaoItemConfiguracao').value;

	if (descProblema != null) {
		tabelaRelacionamentoICs.addObject([ id, desc, descProblema]);
		document.form.itensConfiguracaoRelacionadosSerializado.value = ObjectUtils.serializeObjects(tabelaRelacionamentoICs.getTableObjects());
		Modal.close('modal-problema-add-ic');
	}
}

function fecharPopupDescricaoItemConf(){
	Modal.close('modal-problema-desc-ic');
	document.getElementById('hiddenDescricaoItemConfiguracao').value = document.getElementById('descricaoItemConfiguracao').value;
	document.form.fireEvent("restaurarItemConfiguracao");
}

function validaAddLinhaTabelaItemConfiguracao(lastRow, id) {
	var listaICs = ObjectUtils
			.deserializeCollectionFromString(document.form.itensConfiguracaoRelacionadosSerializado.value);

	if (lastRow > 1) {
		for (var i = 0; i < listaICs.length; i++) {
			if (listaICs[i].idItemConfiguracao == id) {
				alert(i18n_message("citcorpore.comum.registroJaAdicionado"));
				return false;
			}
		}
	}
	return true;
}

function LOOKUP_PROBLEMA_EMEXECUCAO_select(id, desc) {
	document.form.idProblemaRelacionado.value = id;
	document.form.fireEvent('atualizaGridProblemaRelacionados');
}

exibeIconesProblema = function(row, obj) {
	var id = obj.idProblema;
	obj.sequenciaOS = row.rowIndex;
	row.cells[3].innerHTML = '<img src="' + ctx + '/imagens/delete.png" border="0" onclick="excluiProblema(this.parentNode.parentNode.rowIndex,this)" style="cursor:pointer" />'
};

exibeIconesConhecimento = function(row, obj) {
	var id = obj.idProblema;
	obj.sequenciaOS = row.rowIndex;
	row.cells[3].innerHTML = '<img src="' + ctx + '/imagens/delete.png" border="0" onclick="excluiConhecimento(this.parentNode.parentNode.rowIndex,this)" style="cursor:pointer" />'
};

excluiProblema = function(indice) {
	if (indice > 0 && confirm(i18n_message("citcorpore.comum.confirmaExclusao"))) {
		HTMLUtils.deleteRow('tblProblema', indice);
	}
}

excluiConhecimento = function(indice) {
	if (indice > 0 && confirm(i18n_message("citcorpore.comum.confirmaExclusao"))) {
		HTMLUtils.deleteRow('tblConhecimento', indice);
	}
}

function cadastrarProblema() {
	document.getElementById('iframeEditarCadastrarProblema').src = ctx + "/pages/problema/problema.load?iframe=true&relacionarProblema=S&tarefaAssociada=N";
	Modal.open('modal-problema-novo-problema', removeModalOverflowClass);
}

function cadastrarBaseConhecimento() {
	document.getElementById('iframeBaseConhecimento').src = ctx + "/pages/baseConhecimento/baseConhecimento.load?iframe=true&relacionarConhecimento=S&tarefaAssociada=N";
	Modal.open('modal-problema-novo-conhecimento', removeModalOverflowClass);
}

function LOOKUP_MUDANCA_select(id, desc) {
	addLinhaTabelaMudanca(id, desc, true);
}

function addLinhaTabelaMudanca(id, desc, valida) {
	var tbl = document.getElementById('tblRDM');
	tbl.style.display = '';
	var lastRow = tbl.rows.length;
	if (valida) {
		if (!validaAddLinhaTabelaMudanca(lastRow, id)) {
			return;
		}
	}

	var camposLookupItem = desc.split("-");
	tabelaRelacionamentoMudancas.addObject([ id, camposLookupItem[1], camposLookupItem[2] ]);

	document.form.requisicaoMudancaSerializado.value = ObjectUtils.serializeObjects(tabelaRelacionamentoMudancas.getTableObjects());

	Modal.close('modal-problema-add-mudanca');
}

function validaAddLinhaTabelaMudanca(lastRow, id) {
	var listaRequisicaoMudanca = ObjectUtils
			.deserializeCollectionFromString(document.form.requisicaoMudancaSerializado.value);

	if (lastRow > 1) {
		for (var i = 0; i < listaRequisicaoMudanca.length; i++) {
			if (listaRequisicaoMudanca[i].idRequisicaoMudanca == id) {
				alert(i18n_message("citcorpore.comum.registroJaAdicionado"));
				return false;
			}
		}
	}
	return true;
}

function addProblemaRelacionado() {
	Modal.open('modal-problema-add-problema', removeModalOverflowClass);
}

function fecharModalProblema() {
	Modal.close('modal-problema-add-problema');
}

function alternaVisibilidadePropsBase() {
	var check = document.getElementById("adicionarBDCE");
	var propsBaseConhecimento = null;

	if (check.checked) {
		propsBaseConhecimento = document
				.getElementById("propsBaseConhecimento");
		$("#propsBaseConhecimento").show("clip");
	} else {
		$("#propsBaseConhecimento").hide("clip");
	}
}

fechar = function() {
	parent.fecharProblema();
	parent.fechaPopupProblema();
}

function fecharProblema() {
	Modal.close('modal-problema-novo-problema');
}

function addGridProblemaRelacionado(id) {
	document.form.idProblemaRelacionado.value = id;
	document.form.fireEvent('atualizaGridProblemaRelacionados');

}

function getServicos() {
	document.form.fireEvent('carregaServicosMulti');
}

function setaValorLookup(obj, callFromLoad) {
	limpaCampoServicoNegocio();
	document.form.idSolicitante.value = '';
	document.form.solicitante.value = '';
	document.form.emailContato.value = '';
	document.form.nomeContato.value = '';
	document.form.telefoneContato.value = '';
	document.form.observacao.value = '';
	document.form.ramal.value = '';
	document.getElementById('idLocalidade').options.length = 0;
	document.getElementById("idUnidade").value = "0";

	if (document.getElementById("unidadeDes") != null) {
		document.getElementById("unidadeDes").value = "";
	}

	document.getElementById('pesqLockupLOOKUP_SOL_CONTRATO_IDCONTRATO').value = '';
	document.getElementById('pesqLockupLOOKUP_SOL_CONTRATO_IDCONTRATO').value = (typeof (obj) == "object" ? obj.value : obj);

	if(!callFromLoad) {
		document.form.fireEvent("atualizaServicos");
	}
}

function LOOKUP_SOL_CONTRATO_select(id, desc) {
	document.form.idSolicitante.value = id;
	document.form.fireEvent("restoreColaboradorSolicitante");
}

function mostrarEscondeRegExec() {
	if (document.getElementById('divMostraRegistroExecucao').style.display == 'none') {
		document.getElementById('divMostraRegistroExecucao').style.display = '';
		document.getElementById('btnAddRegExec').innerHTML = i18n_message("solicitacaoServico.addregistroexecucao_menos");
	} else {
		document.getElementById('divMostraRegistroExecucao').style.display = 'none';
		document.getElementById('btnAddRegExec').innerHTML = i18n_message("solicitacaoServico.addregistroexecucao_mais");
	}
}

function gravarErroConhecido() {
	var idProblema = document.form.idProblema.value;
	document.getElementById('iframeBaseConhecimento').src = ctx + "/pages/baseConhecimento/baseConhecimento.load?iframe=true&tipoDocumentoExt=E&idProblema=" + idProblema;
	Modal.open('modal-problema-novo-conhecimento', removeModalOverflowClass);
}

function vincularConhecimento(){
	Modal.open('modal-problema-add-conhecimento', removeModalOverflowClass);
}

function LOOKUP_BASECONHECIMENTO_PUBLICADOS_select(id, desc){
	document.form.idConhecimento.value = id;
	document.form.fireEvent('atualizaGridConhecimentoRelacionado'); 
}

function fecharBaseConhecimento() {
	Modal.close('modal-problema-novo-conhecimento');
	document.form.fireEvent("atualizaGridProblema");
}

exibeIconesEditarBaseConhecimento = function(row, obj) {
	var id = obj.idBaseConhecimento;
	var idProblemaBaseConhecimentoRelacionado = obj.idProblemaBaseConhecimentoRelacionado;
	obj.sequenciaOS = row.rowIndex;
	row.cells[1].innerHTML = i18n_message(obj.status);

	var botoesErroConhecido = "<img id='btEditBaseConhecimento' src='" + ctx + "/imagens/edit.png' border='0' onclick='editarBaseConhecimento("+ id + ")' style='cursor:pointer' />&nbsp;&nbsp;";
	botoesErroConhecido += "<img id='btDeleteErroConhecido' src='" + ctx + "/imagens/delete.png' border='0' onclick='excluirErroConhecido("+ id + ", " + idProblemaBaseConhecimentoRelacionado + ")' style='cursor:pointer' />";
	row.cells[2].innerHTML = botoesErroConhecido;
	document.form.idErrosConhecidosStr.value = document.form.idErrosConhecidosStr.value + "|" + id + "|";
}

/*
 * geber.costa validador do checkbox acompanhamento
 */
function validarAcompanhamento() {

	if (document.getElementById('acompanhamento').checked == "N") {
		window.alert("sem acompanhamento!");
	} else if (document.getElementById('acompanhamento').checked == "S") {
		window.alert("com acompanhamento!");
	}
}

function editarBaseConhecimento(idBaseConhecimento) {
	var idProblema = document.form.idProblema.value;
	document.getElementById('iframeBaseConhecimento').src = ctx + "/pages/baseConhecimento/baseConhecimento.load?iframe=true&erroConhecido=S&idBaseConhecimento=" + idBaseConhecimento + "&idProblema=" + idProblema;
	Modal.open('modal-problema-novo-conhecimento', removeModalOverflowClass);

}

function excluirErroConhecido(idBaseConhecimento, idProblemaBaseConhecimentoRelacionado) {
	if(window.confirm(i18n_message('citcorpore.comum.deleta'))) {
		document.form.idErroConhecidoSelecionado.value = idBaseConhecimento;
		document.form.idProblemaBaseConhecimentoRelacionado.value = idProblemaBaseConhecimentoRelacionado;
		document.form.fireEvent('deleteErroConhecido');
	}
}

function limpaListasRelacionamentos() {
	tabelaRelacionamentoICs.limpaLista();
	tabelaRelacionamentoSolicitacaoServico.limpaLista();
	tabelaRelacionamentoMudancas.limpaLista();

}

this.limpaLista = function() {
	tableObjects.length = 0;
	tableObjects = null;
	tableObjects = [];
	limpaTabela();
}

var limpaTabela = function() {
	while (getTabela().rows.length > 1) {
		getTabela().deleteRow(1);
	}
}

function gravarEContinuar() {
	document.form.acaoFluxo.value = acaoIniciar;
	gravar();
}

var ACTUAL_PHASE_REGISTERED = '1';
function gravarEFinalizar() {
	var gravarEFinalizarInner = function() {
		document.form.acaoFluxo.value = acaoExecutar;
		document.form.fecharItensRelacionados.value = "N";

		if ($("input[name='status']:checked").val() == '18') {
			verificarItensRelacionados(true)
		} else {
			document.form.fireEvent('validacaoAvancaFluxo');
		}
	};

	if(document.form.idActualPhase.value === ACTUAL_PHASE_REGISTERED) {
		gravarEFinalizarInner();
	} else if($('#causaRaiz').val() === null || $('#causaRaiz').val() === undefined || $('#causaRaiz').val() === ""){
		alert(i18n_message("problema.mensagem.informeCausaRaiz"));
	
	}else if(validaSolucaoContorno()){
		gravarEFinalizarInner();
	}else{
		alert(i18n_message("problema.mensagem.informeSolucaoContorno"));
	}
}

//verifica se uma solução de contorno foi adicionada
function validaSolucaoContorno(){
	var cont = 0;
	$('#tblSolContorno tr').each(function(){
		cont++;
	});
	if(cont > 1)
		return true; 
	else
		return false;
}

function verificarItensRelacionados(validarItem) {
	if (validarItem) {
		document.form.fireEvent("verificarItensRelacionados");
		document.form.fecharItensRelacionados.value = "N";
	} else {
		if (confirm(i18n_message("citcorpore.comum.fecharItemRelacionados"))) {
			document.form.fecharItensRelacionados.value = "S";
			document.form.fireEvent('validacaoAvancaFluxo');
		} else {
			document.form.fecharItensRelacionados.value = "N";
			document.form.fireEvent('validacaoAvancaFluxo');
		}
	}
}

function informaNumeroSolicitacao(numero) {
	$('#tituloSolicitacao').removeClass('inativo');
	document.getElementById('tituloSolicitacao').innerHTML = '<label class="strong">'+ i18n_message("citcorpore.comum.n")+': ' + numero + '</label>';
}

function abreCadastroCategoriaProblema() {
	document.getElementById('iframeNovaMudanca').src = ctx + "/pages/categoriaProblema/categoriaProblema.load?iframe=true";
	Modal.open('modal-problema-nova-mudanca', function() {
		removeModalOverflowClass();
		document.form.fireEvent('alimentaComboCatProblemaAposCadastro');
	});
}


function abrirPopupSolContorno() {
	Modal.open('modal-problema-solucao-contorno', removeModalOverflowClass);
}

function fecharSolContorno() {
	Modal.close('modal-problema-solucao-contorno');
}

function gravarSolContorno() {
	var tituloSolucaoContorno = $('#tituloSolCon').val()
	$('#tituloSolucaoContorno').val(tituloSolucaoContorno);
	var solucaoContorno = $('#descSolCon').val();
	$('#solucaoContorno').val(solucaoContorno);
	document.form.fireEvent("gravarSolContorno");
}

function abrirPopupSolDefinitiva() {
	Modal.open('modal-problema-solucao-definitiva', removeModalOverflowClass);
}

function fecharSolDefinitiva() {
	Modal.close('modal-problema-solucao-definitiva');
}

function gravarSolDefinitiva() {
	var tituloSolucaoDefinitiva = $('#tituloSolDefinitiva').val()
	$('#tituloSolucaoDefinitiva').val(tituloSolucaoDefinitiva);
	var solucaoDefinitiva = $('#descSolDefinitiva').val();
	$('#solucaoDefinitiva').val(solucaoDefinitiva);
	document.form.fireEvent("gravarSolDefinitiva");
}

function fecharFrameProblema() {
	limpar(document.form);
	parent.fecharFrameProblema();
}

function carregarInformacoesComplementares() {
	document.form.fireEvent('carregaInformacoesComplementares');
}

function exibirInformacoesComplementares(url) {
	if (url != '') {
		JANELA_AGUARDE_MENU.show();
		document.getElementById('divInformacoesComplementares').style.display = '';
		document.getElementById('fraInformacoesComplementares').src = url;
	} else {
		try {
			escondeJanelaAguarde();
		} catch (e) {
		}
		document.getElementById('divInformacoesComplementares').style.display = 'none';
	}
}

function exibirInformacoesAprovacao(url) {
	if (url != '') {
		var urlAtual = window.location;
		urlAtual = urlAtual.toString();
		var n = urlAtual.indexOf("pages/");
		n = n + 6;
		var urlFinal = urlAtual.substring(0, n);
		url = urlFinal + url;
		JANELA_AGUARDE_MENU.show();
		document.getElementById('divInformacoesComplementares').style.display = '';
		document.getElementById('fraInformacoesComplementares').src = url;
	} else {
		try {
			escondeJanelaAguarde();
		} catch (e) {
		}
		document.getElementById('divInformacoesComplementares').style.display = 'none';
	}
}

function escondeJanelaAguarde() {
	JANELA_AGUARDE_MENU.hide();
}

function mostraMensagemInsercao(msg, id) {
	document.getElementById('divMensagemInsercao').innerHTML = msg;
	Modal.open('modal-problema-info-insercao');
	Modal.onHidden('modal-problema-info-insercao', fechar);
}

function verificaRelacionado(idproblema) {
	if (relacionarProblema != null && relacionarProblema == "S") {
		parent.addGridProblemaRelacionado(idproblema);
	}
}

function verificaContrato() {
	if (document.form.idContrato.value == '') {
		alert(i18n_message("solicitacaoservico.validacao.contrato"));
		return;
	}
}
function restoreImpactoUrgenciaPorTipoProblema() {
	document.form.fireEvent('restoreImpactoUrgenciaPorCategoriaProblema');
}

/*
 * Thiago Fernandes - 01/11/2013 08:30 - Sol. 121468 - Popup para cadastro nova
 * solicitação serviço
 */
function fecharModalNovaSolicitacao() {
	Modal.close('modal-problema-nova-solicitacao-servico');
}

function fecharModalFilha() {
	Modal.close('modal-problema-nova-solicitacao-servico');
}

function pesquisarItensFiltro() {
	Modal.close('modal-problema-nova-solicitacao-servico');
}

function abrirPopupNovaSolicitacaoServico() {
	document.getElementById('iframeNovaSolicitacao').src = ctx + "/pages/solicitacaoServicoMultiContratos/solicitacaoServicoMultiContratos.load?iframe=true";
	Modal.open('modal-problema-nova-solicitacao-servico', removeModalOverflowClass);
}

function abrirModalPesquisaItemConfiguracao() {
	document.getElementById('framePesquisaItemConfiguracao').src = ctx + "/pages/pesquisaItemConfiguracao/pesquisaItemConfiguracao.load?iframe=true";
	Modal.open('modal-problema-add-ic', removeModalOverflowClass);
}

function serializaProblema() {
	var problemas = HTMLUtils.getObjectsByTableId('tblProblema');
	document.form.colItensProblema_Serialize.value = ObjectUtils
			.serializeObjects(problemas);
}

function serializaConhecimento() {
	var arrConhecimento = [];

	var baseConhecimentos = HTMLUtils.getObjectsByTableId('tblConhecimento');
	if(baseConhecimentos !== null && baseConhecimentos !== undefined
		&& baseConhecimentos.length > 0){
		for(var i = 0; i < baseConhecimentos.length; i++){
			arrConhecimento.push(baseConhecimentos[i]);
		}
	}

	var errosConhecidos = HTMLUtils.getObjectsByTableId('tblErrosConhecidos');
	var idErrosConhecidosStr = "";
	if(errosConhecidos !== null && errosConhecidos !== undefined
		&& errosConhecidos.length > 0){
		for(var i = 0; i < errosConhecidos.length; i++){
			arrConhecimento.push(errosConhecidos[i]);
			idErrosConhecidosStr = "|" + errosConhecidos[i].idBaseConhecimento + "|";
		}
	}

	document.form.idErrosConhecidosStr.value = idErrosConhecidosStr;
	document.form.colItensBaseConhecimento_Serialize.value = ObjectUtils.serializeObjects(arrConhecimento);
}

function setEmail() {
	if (document.form.idContrato.value == '') {
		alert(i18n_message("contrato.alerta.informe_contrato"));
		return;
	}

	document.formEmail.idContrato.value = document.form.idContrato.value;
	JANELA_AGUARDE_MENU.show();
	document.formEmail.fireEvent('loadMails');
}

function setDescricao(descricao) {
	descricao = stripHtml(descricao);
	descricao = descricao.replace(/<!--[\s\S]*?-->/g, "");
	descricao = descricao.trim();

	document.form.descricao.value = descricao;
}

function copiaEmail(messageNumber) {
	JANELA_AGUARDE_MENU.show();
	document.formEmail.emailMessageId.value = document
			.getElementById('emailMessageId' + messageNumber).value;
	document.formEmail.fireEvent('readMail');
}

function fechaModalLeituraEmail() {
	$("#POPUP_leituraEmails").dialog("close");
}

function toggleClass(classe, type) {
	if (type == 'show') {
		$('.' + classe).show();
	} else if (type == 'hide') {
		$('.' + classe).hide();
	}
}

function stripHtml(html) {
	var tmp = document.createElement("DIV");
	tmp.innerHTML = html;
	return tmp.textContent || tmp.innerText || "";
}

function htmlDecode(input) {
	var e = document.createElement('div');
	e.innerHTML = input;
	return e.childNodes.length === 0 ? "" : e.childNodes[0].nodeValue;
}

function imprimirCadastroPdf() {
	JANELA_AGUARDE_MENU.show();
	document.form.fireEvent('imprimirCadastroPdf');
}

function buscarTodosServicosNegocio() {
	var pIdContrato = $("#idContrato").val();
	var pTipoServico = $("#catalogoServico").val();
	var pCategoriaServicoNegocio = $("#categoriaServico").val();
	

	if (verificaSeContratoEstaVazio() || verificaSeCatalogoEstaVazio()) {
		lancarErroContratoOuCatalogoSelecionados();
    } else {
		JANELA_AGUARDE_MENU.show();
    	$('#tipoCatalogo').val(pTipoServico);
		$('#filtroTableServicosNegocioTecnico').val("");
		$('#filtroTableServicosNegocioTecnico').focus();
		document.form.fireEvent('listarServicosNegocioTecnico');
    }
}

function adicionaItensTabelaServicoNegocio(objetoJSON){
	var listServicoNegocio = JSON.parse(objetoJSON);
	var tabela = ""
	for(var i = 0; i < listServicoNegocio.length; i++){
		tabela += "<tr onclick=\"restauraServicoNegocio(" + listServicoNegocio[i].idServico + ")\" >";
		tabela += "<td>";
		tabela += listServicoNegocio[i].idServico;
		tabela += "</td>";
		tabela += "<td>";
		tabela += listServicoNegocio[i].nomeServico;
		tabela += "</td>";
		tabela += "</tr>";
	}
	$('#tblListaServicosNegocioTecnico').find('tbody').append(tabela);
}

function restauraServicoNegocio(idServicoNegocio){
	$('#idServicoNegocio').val(idServicoNegocio);
	document.form.fireEvent('restoreServicoNegocio');
}

function carregaUnidade() {
	document.form.fireEvent("carregaUnidade");
}


/**
 * Anexos
 */

function abrirAnexosProblema() {
	document.form.fireEvent("verificarParametroAnexos");
	Modal.open('modal-problema-anexos', removeModalOverflowClass);
}


/**
 * Ocorrências
 */

function abrirOcorrenciasProblema() {
	document.formOcorrenciaProblema.clear();
	document.formOcorrenciaProblema.idProblema.value = document.form.idProblema.value;
	document.formOcorrenciaProblema.fireEvent('load');
	document.getElementById('divRelacaoOcorrencias').innerHTML = i18n_message("citcorpore.comum.aguardecarregando");
	Modal.open('modal-problema-ocorrencias', removeModalOverflowClass);
}

function salvarOcorrenciaProblema() {
	document.formOcorrenciaProblema.descricao.value = document.formOcorrenciaProblema.descricao1.value;
	if (document.getElementById("idOcorrencia").value != null && document.getElementById("idOcorrencia").value != "") {
		alert(i18n_message("gerenciaservico.suspensaosolicitacao.validacao.alteraregistroocorrencia"));
	} else {
		document.formOcorrenciaProblema.save();
	}
}

function abrirPopupCadastroCategoriaOcorrencia() {
	document.getElementById('iframeOcorrenciasReqMudancaCategoria').src = ctx + "/pages/categoriaOcorrencia/categoriaOcorrencia.load?iframe=true";
	Modal.open('modal-problema-ocorrencias-nova-categoria', removeModalOverflowClass);
}

function abrirPopupCadastroOrigemOcorrencia() {
	document.getElementById('iframeOcorrenciasReqMudancaOrigem').src = ctx + "/pages/origemOcorrencia/origemOcorrencia.load?iframe=true";
	Modal.open('modal-problema-ocorrencias-nova-origem', removeModalOverflowClass);
}

function LOOKUP_CATEGORIA_OCORRENCIA_select(id, desc) {
	$('#idCategoriaOcorrencia').val(id);
	$('#nomeCategoriaOcorrencia').val(desc);
	Modal.close('modal-problema-ocorrencias-add-categoria');
}

function LOOKUP_ORIGEM_OCORRENCIA_select(id, desc) {
	$('#idOrigemOcorrencia').val(id);
	$('#nomeOrigemOcorrencia').val(desc);
	Modal.close('modal-problema-ocorrencias-add-origem');
}

/**
 * Base Conhecimento
 */

function visualizarBaseConhecimento() {
	document.getElementById('iframeBaseConhecimentoView').src = ctx + "/pages/baseConhecimentoView/baseConhecimentoView.load?iframe=true";
	Modal.open('modal-problema-view-conhecimento', removeModalOverflowClass);
}


/**
 * Solicitante
 */

function abrirModalNovoSolicitante(){
	var idContrato = document.form.idContrato.value;
	document.getElementById('iframeNovoColaborador').src = ctx + "/pages/empregado/empregado.load?iframe=true&idContrato="+idContrato;
	Modal.open('modal-problema-novo-solicitante', removeModalOverflowClass);
}

function abrirPopupNovaRequisicaoMudanca() {
	document.getElementById('iframeNovaMudanca').src = ctx + "/pages/requisicaoMudanca/requisicaoMudanca.load?iframe=true";
	Modal.open('modal-problema-nova-mudanca', removeModalOverflowClass);
};

function abrirPopupAddRequisicaoMudanca() {
	Modal.open('modal-problema-add-mudanca', removeModalOverflowClass);
}


/**
 * COMUM
 */

function removeModalOverflowClass() {
	$(this).removeClass("modal-overflow");
	$(this).addClass("t5");
}

function collapseWidget(that) {
	closeAllCollapseWidget();
	$(that).parent().children('.widget-body').collapse('toggle');
}

function collapseWidgetOnFocus() {
	$("[class*='Valid']").off('focus.collapseOnFocus', collapseWidgetOnFocus);
	var widget = $(this).closest('.widget');
	if($(widget).attr('data-collapse-closed') == 'true') {
		closeAllCollapseWidget();
		$(widget).children('.widget-body').collapse('toggle');
	}
}

function openCollapseWidget(that) {
	if($(that).attr('data-collapse-closed') == 'true') {
		closeAllCollapseWidget();
		$(that).children('.widget-body').collapse('toggle');
	}
}

function closeAllCollapseWidget() {
	$('.widget.dentro').each(function(indice, elemento) {
		if($(elemento).attr('data-collapse-closed') == 'false') {
			$(elemento).children('.widget-body').collapse('toggle');
		}
	});
}

function setValorTextArea(id, texto, isWysi) {
	if (isWysi == "S") {
		$(id).data("wysihtml5").editor.setValue(texto);
	} else {
		$(id).html(texto);
	}
}