$(function() {
	definirAfters();
});

/**
 * Funções para after do restore e save
 */
function definirAfters(){
	document.formProcessoNegocio.afterRestore = function() {
		ProcessoNegocio.inicializar();
		JANELA_AGUARDE_MENU.hide();
	};
	
	document.formProcessoNegocio.afterSave = function() {
		ProcessoNegocio.limpar();
		JANELA_AGUARDE_MENU.hide();
	};
}

/**
 * Processo Negócio
 */
var ProcessoNegocio = {
	inicializar: function() {
		$('.tabsbar a[href="#tabProcessoNegocioCadastro"]').tab('show');
	},
	
	gravar: function() {
		JANELA_AGUARDE_MENU.show();
	    if (!TipoFluxo.tratar()){
	        return;
	    }

	    if(!document.formProcessoNegocio.save()) {
	    	JANELA_AGUARDE_MENU.hide();
	    }    
	},
	
	excluir: function() {
		if (document.formProcessoNegocio.idProcessoNegocio.value != "" && confirm(i18n_message("citcorpore.comum.deleta"))) {
			document.formProcessoNegocio.fireEvent("excluir");
		} 	
	},
	
	limpar: function() {
		document.formProcessoNegocio.clear();
		exibeMsgNenhumVinculoTabela("divTabelaProcessoNegocioUnidade", "processoNegocio.nenhumaUnidadeVinculada");
		limpar_LOOKUP_PROCESSONEGOCIO();
		this.inicializar();
	},
	
	restore : function(id){
		JANELA_AGUARDE_MENU.show();
		document.formProcessoNegocio.restore({idProcessoNegocio:id});			
	}
}

/**
 * Vincular Tipo Fluxo
 */
var TipoFluxo = {
	tratar: function() {
		var inputsTiposFluxosVinculados = $("[name=idTipoFluxo]:checked");
		var qtdTiposFluxoVinculados = inputsTiposFluxosVinculados.length;
		var listaProcessoNegocioTiposFluxo = [];
		var processoNegocioTiposFluxoDTO = null;		
		
		if(qtdTiposFluxoVinculados > 0) {
			for(var i = 0; i < qtdTiposFluxoVinculados; i++) {
				processoNegocioTiposFluxoDTO = new CIT_ProcessoNegocioTiposFluxoDTO();
				processoNegocioTiposFluxoDTO.idTipoFluxo = parseInt($(inputsTiposFluxosVinculados[i]).val());
				listaProcessoNegocioTiposFluxo.push(processoNegocioTiposFluxoDTO);
			}
			document.formProcessoNegocio.listaProcessoNegocioTiposFluxo_Serialize.value = ObjectUtils.serializeObjects(listaProcessoNegocioTiposFluxo);
		}
        
        return true;
	},
	
	limparCheckbox: function() {
		if(document.formProcessoNegocio.idTipoFluxo != undefined){
	        for(i = 0, len = document.formProcessoNegocio.idTipoFluxo.length; i < len; i++){
	            document.formProcessoNegocio.idTipoFluxo[i].checked = false;
	        }
	    }
	}		
}

/**
 * Vincular Unidade
 */
var Unidade = {
	abrirModal: function(){
		limpar_LOOKUP_PROCESSO_NEGOCIO_VINCULAR_UNIDADE();
		
		// Lista dos ids das unidades vinculadas
		var idsUnidadesVinculadas = this.getListaIdUnidadesVinculadas();
		
		// Se tiver alguma unidade vinculada acrescenta uma condição na lookup para que elas não sejam exibidas
		if(idsUnidadesVinculadas.length > 0) {
			document.formPesquisaUnidadeProcessoNegocio.whereDinamico = "idunidade not in ("+ idsUnidadesVinculadas+")";
		} else {
			document.formPesquisaUnidadeProcessoNegocio.whereDinamico = "";
		}
		
		Modal.open("modal-processo-negocio-unidades");
	},
	
	fecharModal: function() {
		Modal.close("modal-processo-negocio-unidades");
	},
	
	removerUnidadeFromTable : function(btClick){
		if (confirm(i18n_message("citcorpore.comum.deleta"))) {
			
			var trTable = btClick.closest('tr');
			var idUnidade = trTable.getAttribute('id');
			
			trTable.remove();
			
			// esconde o tooltip do botão desvincular unidade
			fechaTooltip();
			
			// remove a unidade da lista de lookup
			document.formProcessoNegocio.listaIdsUnidadesVinculadas.value = document.formProcessoNegocio.listaIdsUnidadesVinculadas.value.replace(idUnidade+";", "");
			this.serializarListaIdsUnidadesVinculadas();
			
			if($("#divTabelaProcessoNegocioUnidade tbody tr").length < 1)
				exibeMsgNenhumVinculoTabela("divTabelaProcessoNegocioUnidade", "processoNegocio.nenhumaUnidadeVinculada");
		}
	},
	
	atualizarListaIdsUnidadesVinculadas: function() {
		document.formProcessoNegocio.listaIdsUnidadesVinculadas.value = document.formProcessoNegocio.listaIdsUnidadesVinculadas.value + document.formProcessoNegocio.colAllLOOKUP_PROCESSO_NEGOCIO_VINCULAR_UNIDADE.value;
		this.serializarListaIdsUnidadesVinculadas();
	},	
	
	getListaIdUnidadesVinculadas: function() {
		var idsUnidadesVinculadas = document.formProcessoNegocio.listaIdsUnidadesVinculadas.value.split(";");
		idsUnidadesVinculadas = idsUnidadesVinculadas.slice(0, idsUnidadesVinculadas.length-1);
		return idsUnidadesVinculadas;
	},
	
	montarTabelaUnidades: function() {
		this.atualizarListaIdsUnidadesVinculadas();
		document.formProcessoNegocio.fireEvent("montarTabelaUnidades");
	},
	
	serializarListaIdsUnidadesVinculadas: function(){
		var idsUnidadesVinculadas = this.getListaIdUnidadesVinculadas();
		var listaProcessoNegocioUnidades = [];
		var processoNegocioUnidadesDTO = null;		

		for(var i = 0, len = idsUnidadesVinculadas.length; i < len; i++) {
			processoNegocioUnidadesDTO = new CIT_ProcessoNegocioUnidadesDTO();
			processoNegocioUnidadesDTO.idUnidade = parseInt(idsUnidadesVinculadas[i]);
			listaProcessoNegocioUnidades.push(processoNegocioUnidadesDTO);
		}
		
		document.formProcessoNegocio.listaProcessoNegocioUnidades_Serialize.value = ObjectUtils.serializeObjects(listaProcessoNegocioUnidades);
        
        return true;
	}
}

function exibeMsgNenhumVinculoTabela(nomeTabela, chaveMensagem) {
	$("#"+nomeTabela).html('<h4>'+i18n_message(chaveMensagem)+'</h4>');		
}

function LOOKUP_PROCESSONEGOCIO_select(id, desc) {
	ProcessoNegocio.restore(id);
}

/**
 * Vincular Cliente
 * */
function clickVinculaCliente(){
	Modal.open("modal-processo-negocio-cliente");
}

function LOOKUP_CLIENTE_PROCESSO_NEGOCIO_select(id, desc) {
	document.formProcessoNegocio.idCliente.value = id;
	var nomeCliente = desc.split(' - ');
	document.formProcessoNegocio.processoNegocioCliente.value = nomeCliente[0];
	
	Modal.close("modal-processo-negocio-cliente");
}

/**
 * Vincular Autoridade
 */
// TODO [deborah.ferreira][13/01/2016] Verificar Necessidade
/**
var seqAutoridade = '';
incluirAutoridade = function() {
    GRID_AUTORIDADES.addRow();
    seqAutoridade = NumberUtil.zerosAEsquerda(GRID_AUTORIDADES.getMaxIndex(),5);
    eval('document.formProcessoNegocio.idNivelAutoridade' + seqAutoridade + '.focus()');
}

exibeAutoridade = function(serializeAutoridade) {
    if (seqAutoridade != '') {
        if (!StringUtils.isBlank(serializeAutoridade)) {
            var obj = new CIT_ProcessoNivelAutoridadeDTO();
            obj = ObjectUtils.deserializeObject(serializeAutoridade);
            try{
                eval('HTMLUtils.setValue("idNivelAutoridade' + seqAutoridade + '",' + obj.idNivelAutoridade + ')');
            }catch(e){
            }
            eval('document.formProcessoNegocio.permiteAprovacaoPropria' + seqAutoridade + '.value = "' + obj.permiteAprovacaoPropria + '"');
            eval('document.formProcessoNegocio.antecedenciaMinimaAprovacao' + seqAutoridade + '.value = "' + obj.antecedenciaMinimaAprovacao + '"');
        }
    }
}

getAutoridade = function(seq) {
    var obj = new CIT_ProcessoNivelAutoridadeDTO();

    seqAutoridade = NumberUtil.zerosAEsquerda(seq,5);
    obj.sequencia = seq;
    obj.idNivelAutoridade = parseInt(eval('document.formProcessoNegocio.idNivelAutoridade' + seqAutoridade + '.value'));
    obj.permiteAprovacaoPropria = eval('document.formProcessoNegocio.permiteAprovacaoPropria' + seqAutoridade + '.value');
    try{
        obj.antecedenciaMinimaAprovacao = eval('document.formProcessoNegocio.antecedenciaMinimaAprovacao' + seqAutoridade + '.value');
    }catch(e){
    	obj.antecedenciaMinimaAprovacao = 0;
    }
    return obj;
}

verificarAutoridade = function(seq) {
    var idNivelAutoridade = eval('document.formProcessoNegocio.idNivelAutoridade' + seq + '.value');
    var count = GRID_AUTORIDADES.getMaxIndex();
    for (var i = 1; i <= count; i++){
        if (parseInt(seq) != i) {
             var trObj = document.getElementById('GRID_AUTORIDADES_TD_' + NumberUtil.zerosAEsquerda(i,5));
             if (!trObj){
                continue;
             }
             var idAux = eval('document.formProcessoNegocio.idNivelAutoridade' + NumberUtil.zerosAEsquerda(i,5) + '.value');
             if (idAux == idNivelAutoridade) {
                  alert(i18n_message("citcorpore.comum.registroJaAdicionado"));
                  eval('document.formProcessoNegocio.idNivelAutoridade' + seq + '.focus()');
                  return false;
             }
        }
    }
    return true;
}

function tratarAutoridades(){
    //try{
        var count = GRID_AUTORIDADES.getMaxIndex();
        var contadorAux = 0;
        var objs = new Array();
        for (var i = 1; i <= count; i++){
            var trObj = document.getElementById('GRID_AUTORIDADES_TD_' + NumberUtil.zerosAEsquerda(i,5));
            if (!trObj){
                continue;
            }

            var obj = getAutoridade(i);
            if (parseInt(obj.idNivelAutoridade) > 0) {
                if  (!verificarAutoridade(NumberUtil.zerosAEsquerda(i,5))) {
                    return false;
                }
                objs[contadorAux] = obj;
                contadorAux = contadorAux + 1;
            }else{
                alert(i18n_message("citcorpore.comum.nenhumaSelecao"));
                eval('document.formProcessoNegocio.idNivelAutoridade' + NumberUtil.zerosAEsquerda(i,5) + '.focus()');
                return false;
            }
        }
        document.formProcessoNegocio.colAutoridades_Serialize.value = ObjectUtils.serializeObjects(objs);
        return true;
    //}catch(e){
    //}
}
**/