addEvent(window, "load", load, false);
function load(){
	document.formProjeto.afterRestore = function () {
		$('.tabsbar a[href="#tabCadastroProjeto"]').tab('show');
	};
}
$(function() {
	$('.mask-numero').mask("#0", {reverse: true});
	$('.mask-moeda').mask("#.##0,00", {reverse: true});
	$("#addRecurso").click(function() {
		var idsRecursoProjetoVinculado = Projeto.recursoProjeto.getListaRecursoProjetoVinculado();
		
		if(idsRecursoProjetoVinculado.length > 0) {
			document.formProjetoPesquisaEmpregado.whereDinamico = 'idEmpregado not in ('+idsRecursoProjetoVinculado+')';
		}
		
		Modal.open('modal-lookup-projeto-empregado');
	});

	$("#addAssinaturasAprovacoes").click(function() {
		var idsAssinaturaAprovacaoVinculado = Projeto.assinaturaAprovacao.getListaAssinaturaAprovacaoVinculado();
		
		if(idsAssinaturaAprovacaoVinculado.length > 0) {
			document.formProjetoPesquisaAssinaturaEmpregado.whereDinamico = 'idEmpregado not in ('+idsAssinaturaAprovacaoVinculado+')';
		}
		Modal.open('modal-lookup-projeto-empregado-assinatura');
	});
	$("#adicionarMudanca").click(function() {
		Modal.open('modal-lookup-projeto-mudanca');
	});
	$("#adicionarLiberacao").click(function() {
		Modal.open('modal-lookup-projeto-liberacao');
	});
	
});


var Projeto = {
	validarVinculoOrdemServico : function(obj) {
		if (document.getElementById('vinculoOS').checked) {
			var msg = '';
			
			if ($("#idServicoContrato").val() == '') {
				msg = i18n_message('problema.servico');
			}
			if ($("#numero").val() == '') {
				if (msg != '') {
					msg += "<br/>";
				}
				msg += i18n_message('citcorpore.comum.numero');
			}
			if ($("#nomeAreaRequisitante").val() == '') {
				if (msg != '') {
					msg += "<br/>";
				}
				msg += i18n_message('citcorpore.comum.areaRequisitante');
			}
			
			if (msg != '') {
				notificacaoErro('citcorpore.comum.camposObrigatorios', msg);
				return false;
			}
		}
		
		return true;
	},
	appendTbody: function(idTbody, contentHtml) {
		$("#"+idTbody).append(contentHtml);
	},
	salvar: function(){
		Projeto.recursoProjeto.serializarListaRecursoProjeto();
		Projeto.assinaturaAprovacao.serializarListaAssinaturaAprovacao();
		
		if (Projeto.validarVinculoOrdemServico()) {
			return document.formProjeto.save();
		}
	},
	limpar: function(){
		document.formProjeto.clear();
		document.getElementById('divProjetoOS').style.display = 'none';
		this.exibeMsgNenhumVinculoTabela("divLinhasBase", "projeto.nenhumaLinhaBase");
		this.exibeMsgNenhumVinculoTabela("divRecursoProjetoConteudo", "projeto.nenhumRecursoAdicionado");
		this.exibeMsgNenhumVinculoTabela("divAssinaturaAprovacaoConteudo", "projeto.nenhumaAssinaturaAprovacaoAdicionada");
	},
	limparMudanca: function(){
		document.formProjeto.idRequisicaoMudanca.value = '';
		document.formProjeto.adicionarMudanca.value = '';
	},
	limparLiberacao: function(){
		document.formProjeto.idLiberacao.value = '';
		document.formProjeto.adicionarLiberacao.value = '';
	},
	verificaVinculoOS: function(obj){
		if (obj.checked){
			document.getElementById('divProjetoOS').style.display = 'block';
			document.formProjeto.fireEvent('carregaInfoOS');
		}else{
			document.getElementById('divProjetoOS').style.display = 'none';
			Projeto.limparVinculacoesOS();
		}
	},
	registrarAutorizacao: function(idLnBase){
		document.formAutorizacao.idLinhaBaseProjeto.value = idLnBase;
		document.formAutorizacao.idProjetoAutorizacao.value = document.formProjeto.idProjeto.value;
		document.formAutorizacao.justificativaMudanca.value = '';
		
		criaDialog('PP', 'dialogProjetoRegAutMudanca', '');
		$("#POPUP_PROJETO_REG_AUT_MUDANCA").dialog("open");
	},
	salvarAutMudanca: function(){
		document.formAutorizacao.fireEvent('gravarAutorizMudanca');
	},
	excluir: function() {
		if (document.getElementById("idProjeto").value != "") {
			if (confirm(i18n_message("citcorpore.comum.deleta"))){
				document.formProjeto.fireEvent("delete");
			}
		}
	},
	limparVinculacoesOS: function(){
		$('#idServicoContrato').val("");
		$('#nomeAreaRequisitante').val("");
		$('#numero').val("");
		$('#dataEmissao').val("");
		$('#demanda').val("");
		$('#objetivo').val("");
	},
	exibeMsgNenhumVinculoTabela: function(nomeTabela, chaveMensagem) {
		$("#"+nomeTabela).html('<h5>'+i18n_message(chaveMensagem)+'</h5>');	
	},
	
	recursoProjeto: {
		removerRecursoProjetoFromTable: function(btClick) {
			if (confirm(i18n_message("citcorpore.comum.deleta"))) {
				
				var trTable = btClick.closest('tr');
				var idProjeto = trTable.getAttribute('id');
				
				trTable.remove();
				
				// esconde o tooltip do botão
				fechaTooltip();
				
				if($("#divRecursoProjetoConteudo tbody tr").length < 1)
					Projeto.exibeMsgNenhumVinculoTabela("divRecursoProjetoConteudo", "projeto.nenhumRecursoAdicionado");
			}
		},
		addRecursoProjeto: function(idEmpregado, nomeEmpregado) {
			document.formProjeto.idEmpregadoRecursoProjeto.value = idEmpregado;
			document.formProjeto.nomeEmpregadoRecursoProjeto.value = nomeEmpregado;
			document.formProjeto.custoHoraRecursoProjeto.value = null;
			if($("#divRecursoProjetoConteudo tbody tr").length < 1) {
				document.formProjeto.fireEvent("addTabelaRecursoProjeto");
			} else {
				document.formProjeto.fireEvent("addLinhaTabelaRecursoProjeto");
			}
		},
		
		serializarListaRecursoProjeto: function(){
			var listaTrRecursoProjeto = $("#tbodyTabelaRecursoProjeto tr");
			var listaRecursoProjeto = [];
			var custoHora = '';
			
			for(var i = 0, len = listaTrRecursoProjeto.length; i < len; i++) {
				custoHora = $(listaTrRecursoProjeto[i]).find('input[name="custoHora"]').val();
				if(custoHora.trim() == '') {
					custoHora = null;
				}
				listaRecursoProjeto.push({
					idEmpregado:listaTrRecursoProjeto[i].id,
					custoHora: custoHora
				});
			}
			
			document.formProjeto.colRecursosSerialize.value = ObjectUtils.serializeObjects(listaRecursoProjeto);
			
			return true;
		},
		
		getListaRecursoProjetoVinculado: function(){
			var listaTrRecursoProjeto = $("#tbodyTabelaRecursoProjeto tr");
			var listaRecursoProjetoVinculado = "";
			
			for(var i = 0, len = listaTrRecursoProjeto.length; i < len; i++) {
				listaRecursoProjetoVinculado = listaRecursoProjetoVinculado.concat(listaTrRecursoProjeto[i].id);
				if(i < len-1) {
					listaRecursoProjetoVinculado = listaRecursoProjetoVinculado.concat(',');
				}
			}
			
			return listaRecursoProjetoVinculado;
		}
	},
	
	assinaturaAprovacao: {
		removerAssinaturaAprovacaoFromTable: function(btClick) {
			if (confirm(i18n_message("citcorpore.comum.deleta"))) {
				
				var trTable = btClick.closest('tr');
				var idProjeto = trTable.getAttribute('id');
				
				trTable.remove();
				
				// esconde o tooltip do botão
				fechaTooltip();
				
				if($("#divAssinaturaAprovacaoConteudo tbody tr").length < 1)
					Projeto.exibeMsgNenhumVinculoTabela("divAssinaturaAprovacaoConteudo", "projeto.nenhumaAssinaturaAprovacaoAdicionada");
			}
		},
		addAssinaturaAprovacao: function(idEmpregado, nomeEmpregado) {
			document.formProjeto.idEmpregadoAssinaturaAprovacao.value = idEmpregado;
			document.formProjeto.nomeEmpregadoAssinaturaAprovacao.value = nomeEmpregado;
			document.formProjeto.papelAssinaturaAprovacao.value = null;
			document.formProjeto.ordemAssinaturaAprovacao.value = null;
			if($("#divAssinaturaAprovacaoConteudo tbody tr").length < 1) {
				document.formProjeto.fireEvent("addTabelaAssinaturaAprovacao");
			} else {
				document.formProjeto.fireEvent("addLinhaTabelaAssinaturaAprovacao");
			}
		},
		
		serializarListaAssinaturaAprovacao: function(){
			var listaTr = $("#tbodyTabelaAssinaturaAprovacao tr");
			var listaAssinaturaAprovacao = [];
			
			for(var i = 0, len = listaTr.length; i < len; i++) {
				listaAssinaturaAprovacao.push({
					idEmpregadoAssinatura:listaTr[i].id,
					papel: $(listaTr[i]).find('input[name="papel"]').val(),
					ordem: $(listaTr[i]).find('input[name="ordem"]').val()
				});
			}
			
			document.formProjeto.colAssinaturasSerialize.value = ObjectUtils.serializeObjects(listaAssinaturaAprovacao);
			
			return true;
		},
		
		getListaAssinaturaAprovacaoVinculado: function(){
			var listaTr = $("#tbodyTabelaAssinaturaAprovacao tr");
			var listaIds = "";
			
			for(var i = 0, len = listaTr.length; i < len; i++) {
				listaIds = listaIds.concat(listaTr[i].id);
				if(i < len-1) {
					listaIds = listaIds.concat(',');
				}
			}
			
			return listaIds;
		}
	}
};


/*
 * LOOKUPS
 */

function LOOKUP_PROJETO_select(id,desc){
	document.formProjeto.restore({idProjeto:id});
}

function LOOKUP_PROJETO_EMPREGADO_select(idEmpregado, nomeEmpregado){
	Projeto.recursoProjeto.addRecursoProjeto(idEmpregado, nomeEmpregado);
	Modal.close('modal-lookup-projeto-empregado');
}

function LOOKUP_PROJETO_EMPREGADO_ASSINATURA_select(idEmpregado, nomeEmpregado){
	Projeto.assinaturaAprovacao.addAssinaturaAprovacao(idEmpregado, nomeEmpregado);
	Modal.close('modal-lookup-projeto-empregado-assinatura');
}

function LOOKUP_PROJETO_MUDANCA_select(id, desc){
	document.formProjeto.idRequisicaoMudanca.value = id;
	document.formProjeto.adicionarMudanca.value = desc;
	Modal.close('modal-lookup-projeto-mudanca');
}

function LOOKUP_PROJETO_LIBERACAO_select(id, desc){
	document.formProjeto.idLiberacao.value = id;
	document.formProjeto.adicionarLiberacao.value = desc;
	Modal.close('modal-lookup-projeto-liberacao');
}

