var objTab = null;
var completeServicoNegocioTecnico;
var completeServico;

addEvent(window, "load", load, false);

function load() {
	document.form.afterRestore = function() {
		$("a[href=#dadosRegraEscalonamento]").trigger('click');
	}

	$('#servicoBusca').on('click', function(){
		montaParametrosAutocompleteServico();
	});
	
	completeServico = $('#servicoBusca').on("focus", function (event) {
		if (verificaSeContratoEstaVazio()) {
			lancarErroContratoSelecionado();
			event.preventDefault();
		}
	}).autocomplete({
		serviceUrl:'pages/autoCompleteServico/autoCompleteServico.load',
		noCache: true,
		onSelect: function(value, data){
			$('#idServico').val(data);
			$('#servicoBusca').val(value);
			carregaFiltrosServico();
		}
	});
	
	completeServicoNegocioTecnico = $('#servicoNegocioTecnicoBusca').on("focus", function (event) {
		if (verificaSeContratoEstaVazio() || verificaSeCatalogoEstaVazio()) {
			lancarErroContratoOuCatalogoSelecionados();
			event.preventDefault();
		}
	}).autocomplete({
		serviceUrl:'pages/autoCompleteServicoNegocioTecnico/autoCompleteServicoNegocioTecnico.load',
		noCache: true,
		onSelect: function(value, data){
			$('#idServicoNegocioTecnicoBusca').val(data);
			$('#servicoNegocioTecnicoBusca').val(value);
		}
	});
	
}

function montaParametrosAutocompleteServico(){
 	var contrato =  $("#idContrato").val() ;
 	var pTipoServico = $("#idTipoCatalogoServicoSolicitacao").val();
 	var pIdServico = $('#idServicoNegocioTecnicoBusca').val();
 	var pTipoDemanda = $('#idTipoDemandaServico').val();
	
 	completeServico.setOptions({params: {contrato: contrato, tipoServicoNegocioTecnico : pTipoServico, idServicoNegocioTecnico : pIdServico, tipoDemanda : pTipoDemanda} });
}

function montaParametrosAutocompleteServicoNegocioTecnico(){
	var pContrato =  $("#idContrato").val();
	var pTipoServico = $("#idTipoCatalogoServico").val();
	
	completeServicoNegocioTecnico.setOptions({params: {contrato: pContrato, tipoServico: pTipoServico} });
}

function carregaFiltrosServico() {
	if (verificaSeServicoNegocioTecnicoEstaVazio()) {
		document.form.fireEvent("definirFiltrosServico");
	}
}

function verificaSeContratoEstaVazio() {
	if ($("#idContrato").val() == '') {
		return true;
	}
	
	return false;
}

function verificaSeCatalogoEstaVazio() {
	if ($("#idTipoCatalogoServico").val() == '') {
		return true;
	}
	
	return false;
}

function verificaSeServicoNegocioTecnicoEstaVazio() {
	if ($("#servicoNegocioTecnicoBusca").val() == '') {
		return true;
	}
	
	return false;
}

function excluir() {
	if (confirm(i18n_message("citcorpore.comum.deleta"))) {
		document.form.fireEvent("excluir");
	}
}

function LOOKUP_REGRAESCALONAMENTO_select(idParam, desc) {
	document.form.restore({
		idRegraEscalonamento : idParam
	});
}

function LOOKUP_GRUPO_select(id, desc) {
	document.getElementById("idGrupo").value = id;
	document.getElementById("grupo").value = desc;
	$("#POPUP_GRUPO").dialog("close");
}

function LOOKUP_SOLICITANTE_select(id, desc) {
	document.getElementById("idSolicitante").value = id;
	document.getElementById("nomeSolicitante").value = desc;
	$("#POPUP_SOLICITANTE").dialog("close");
}

function abrePopupGrupo() {
	criaDialog('M', 'dialogGrupo', '');
	$("#POPUP_GRUPO").dialog("open");
}

function abrePopupSolicitante() {
	criaDialog('M', 'dialogSolicitante', '');
	$("#POPUP_SOLICITANTE").dialog("open");
}

function addGrupoExecutor() {
	if (document.getElementById('idGrupoAtual').value == "") {
		notificacaoErro("citcorpore.comum.naoFoiPossivelAdicionar", "regraEscalonamento.alerta.informeGrupoExecutor");
		return;
	} else if (document.getElementById('prazoExecucao').value == "") {
		notificacaoErro("citcorpore.comum.naoFoiPossivelAdicionar", "regraEscalonamento.alerta.informePrazoExecucao");
		return;
	} else if (document.getElementById('tipoDataEscalonamento').value == "") {
		notificacaoErro("citcorpore.comum.naoFoiPossivelAdicionar", "regraEscalonamento.alerta.informeEscalonarPor");
		return;
	}
	
	var obj = new CIT_EscalonamentoDTO();
	obj.idGrupoExecutor = document.getElementById('idGrupoAtual').value;
	obj.descricao = document.getElementById('idGrupoAtual').options[document.getElementById('idGrupoAtual').selectedIndex].text;
	obj.prazoExecucao = document.getElementById('prazoExecucao').value;
	obj.idPrioridade = document.getElementById('idPrioridade').value;
	obj.tipoDataEscalonamento = document.getElementById('tipoDataEscalonamento').value;
	obj.escalonarPor = document.getElementById('tipoDataEscalonamento').options[document.getElementById('tipoDataEscalonamento').selectedIndex].text;
	
	if (obj.idPrioridade != '') {
		obj.descrPrioridade = document.getElementById('idPrioridade').options[document.getElementById('idPrioridade').selectedIndex].text;
	}

	HTMLUtils.addRow('tblGrupoExecutor', document.form, '', obj, 
			[ '', 'descricao', 'prazoExecucao', 'escalonarPor', 'descrPrioridade' ], 
			[ "idGrupoExecutor" ],
			i18n_message("regraEscalonamento.alerta.grupoJaAdicionado"),
			[ gerarImgDelGrupoExecutor ], 
			null, null, false);

}

function deleteLinha(table, index) {
	if (index > 0 && confirm(i18n_message("regraEscalonamento.alerta.exclusaoEscalonamento"))) {
		HTMLUtils.deleteRow(table, index);
	}
}

function gerarImgDelGrupoExecutor(row, obj) {
	row.cells[0].innerHTML = '<img src="'
			+ ctx
			+ '/imagens/delete.png" style="cursor: pointer;" onclick="deleteLinha(\'tblGrupoExecutor\', this.parentNode.parentNode.rowIndex);"/>';
}

function internacionalizaEscalonarPor(row, obj) {
	row.cells[3].innerHTML = i18n_message(obj.escalonarPor);
}

function serializaTabelaGrupos() {
	var itens = HTMLUtils.getObjectsByTableId('tblGrupoExecutor');
	document.form.grupos_serialize.value = ObjectUtils.serializeObjects(itens);
}

function limpar() {
	document.form.clear();
	HTMLUtils.deleteAllRows("tblGrupoExecutor");
}

function salvar() {

	serializaTabelaGrupos();

	if (document.getElementById("tempoExecucao").value == "" && document.getElementById("idTipoGerenciamento").value == 1) {
		notificacaoErro("citcorpore.comum.camposObrigatorios", "regraEscalonamento.alerta.informePrazoRestanteExecucao");
		document.getElementById("tempoExecucao").focus();
		return;
	}
	if (document.form.enviarEmail.value == "S" && (document.getElementById("intervaloNotificacao").value == "" || document.getElementById("tipoDataNotificacaoEmail").value == "")) {
		notificacaoErro("citcorpore.comum.camposObrigatorios", "regraEscalonamento.alerta.informeIntervaloNotificacaoEmail");
		return;
	}
	
	if (document.form.criaProblema.value == "S" && (document.getElementById("prazoCriarProblema").value == "" || document.getElementById("tipoDataProblema").value == "")) {
		notificacaoErro("citcorpore.comum.camposObrigatorios", "regraEscalonamento.alerta.informePrazoCriarProblema");
		return;
	}
	
	if(document.form.grupos_serialize.value == null || document.form.grupos_serialize.value == ""){
		notificacaoErro("citcorpore.comum.camposObrigatorios", "regraEscalonamento.cadastro");
		return;
	}
	
	document.form.save();
}

function mensagemCreate(){
	notificacao(i18n_message("MSG05"));
}

function mensagemUpdate(){
	notificacao(i18n_message("MSG06"));
}

function limparCampoServico() {
	document.getElementById("servicoBusca").value = "";
	document.getElementById("idServico").value = "";
}
function limparCampoGrupo() {
	document.getElementById("grupo").value = "";
	document.getElementById("idGrupo").value = "";
}
function limparCampoNomeSolicitante() {
	document.getElementById("nomeSolicitante").value = "";
	document.getElementById("idSolicitante").value = "";
}

function limparServicoNegocioTecnico(){
	$("#idServicoNegocioTecnicoBusca").val('');
	$("#servicoNegocioTecnicoBusca").val('');
	montaParametrosAutocompleteServico();
}

function changeCatalogoServico() {
	montaParametrosAutocompleteServicoNegocioTecnico();
	limparServicoNegocioTecnico();
	limparCampoServico();
}

function changeContrato() {
	montaParametrosAutocompleteServico();
	montaParametrosAutocompleteServicoNegocioTecnico();
}

function buscarTodosServicosNegocioTecnico() {
	var pIdContrato = $("#idContrato").val();
	var pTipoServico = $("#idTipoCatalogoServico").val();
	
	if (verificaSeContratoEstaVazio() || verificaSeCatalogoEstaVazio()) {
		lancarErroContratoOuCatalogoSelecionados();
    } else {
    	JANELA_AGUARDE_MENU.show();
		document.form.tipoServico.value = pTipoServico;
		document.form.idContrato.value = pIdContrato;
		
		$('#filtroTableServicosNegocioTecnico').val("");
		$('#filtroTableServicosNegocioTecnico').focus();
		document.form.fireEvent('listarServicosNegocioTecnico');
    }
}

function buscarTodosServicos() {
	var pIdContrato = $("#idContrato").val();
	var pTipoServico = $("#idTipoCatalogoServico").val();
 	var pIdServicoNegocioTecnico = $('#idServicoNegocioTecnicoBusca').val();
 	
	if (pIdContrato != '') {
		JANELA_AGUARDE_MENU.show();
		document.form.idContrato.value = pIdContrato;

		if (pTipoServico != '') {
			document.form.idServicoNegocioTecnico.value = pIdServicoNegocioTecnico;
		}
		
		$('#filtroTableServicos').val("");
		$('#filtroTableServicos').focus();
		document.form.fireEvent('listarServicos');
	} else {
		lancarErroContratoSelecionado();
	}
}


function selecionarServicoNegocioTecnico(row, obj){
	JANELA_AGUARDE_MENU.show()
	$('#idServicoNegocioTecnicoBusca').val(obj.idServico);
	$('#servicoNegocioTecnicoBusca').val(obj.nomeServico);
	JANELA_AGUARDE_MENU.hide()
	$('#modal_listarServicosNegocioTecnico').modal('hide');
}

function selecionarServico(row, obj){
	JANELA_AGUARDE_MENU.show()
	$('#idServico').val(obj.idServico);
	$('#servicoBusca').val(obj.nomeServico);
	JANELA_AGUARDE_MENU.hide()
	$('#modal_listarServicos').modal('hide');
	document.form.idContrato.value =  $("#idContrato").val();
	carregaFiltrosServico();
}

function lancarErroContratoOuCatalogoSelecionados(){
	notificacaoErro("citcorpore.comum.impossivelRealizarConsulta", "regraEscalonamento.verifiqueContratoOuCatalogoSelecionados");
}

function lancarErroContratoSelecionado() {
	notificacaoErro("citcorpore.comum.impossivelRealizarConsulta", "contrato.alerta.informe_contrato");
}

function depoisListarServicos() {
	JANELA_AGUARDE_MENU.hide();
}

$("#idTipoGerenciamento").change(function (){
	if($("#idTipoGerenciamento").val() === "1"){
		$("label[for='tempoExecucao']").addClass("campoObrigatorio");
		$("#tempoExecucao").addClass("Valid[Required]");
	}else{
		$("label[for='tempoExecucao']").removeClass("campoObrigatorio");
		$("#tempoExecucao").removeClass("Valid[Required]");
		document.form.tempoExecucao.validacao = null;
	}
});

$("#enviarEmail").change(function (){
	if($("#enviarEmail").val() === "S"){
		$("label[for='intervaloNotificacao']").addClass("campoObrigatorio");
		$("label[for='tipoDataNotificacaoEmail']").addClass("campoObrigatorio");
		$("#intervaloNotificacao").addClass("Valid[Required]");
	}else{
		$("label[for='intervaloNotificacao']").removeClass("campoObrigatorio");
		$("label[for='tipoDataNotificacaoEmail']").removeClass("campoObrigatorio");
		$("#intervaloNotificacao").removeClass("Valid[Required]");
		document.form.intervaloNotificacao.validacao = null;
	}
});

$("#criaProblema").change(function (){
	if($("#criaProblema").val() === "S"){
		$("label[for='prazoCriarProblema']").addClass("campoObrigatorio");
		$("label[for='tipoDataProblema']").addClass("campoObrigatorio");
		$("#prazoCriarProblema").addClass("Valid[Required]");
	}else{
		$("label[for='prazoCriarProblema']").removeClass("campoObrigatorio");
		$("label[for='tipoDataProblema']").removeClass("campoObrigatorio");
		$("#prazoCriarProblema").removeClass("Valid[Required]");
		document.form.prazoCriarProblema.validacao = null;
	}
});