var tabelaRelacionamentoICs;
var tabelaRelacionamentoServicos;
var tabelaRelacionamentoLiberacao;
var tabelaRelacionamentoBaseConhecimento;
var tabelaProblema;
var tabelaRelacionamentoSolicitacaoServico;
var tabelaRisco;
var tabelaGrupo;
var count = 0;
var idItemConfiguracao;
var descricaoItemConfiguracao;
var descricaoTratada;
var autocompleteUnidade;

$(document).ready(function () {
	Modal.onShown('modal-requisicao-mudanca-votacao-proposta', removeModalOverflowClass);
	Modal.onShown('modal-requisicao-mudanca-votacao-req-mudanca', removeModalOverflowClass);
	Modal.onShown('modal-requisicao-mudanca-servico', removeModalOverflowClass);
	Modal.onShown('modal-requisicao-mudanca-ic', removeModalOverflowClass);
	Modal.onShown('modal-requisicao-mudanca-problema', removeModalOverflowClass);
	Modal.onShown('modal-requisicao-mudanca-solicitacao', removeModalOverflowClass);
	Modal.onShown('modal-requisicao-mudanca-risco', removeModalOverflowClass);
	Modal.onShown('modal-requisicao-mudanca-liberacao', removeModalOverflowClass);
	Modal.onShown('modal-requisicao-mudanca-grupo', removeModalOverflowClass);
	Modal.onShown('modal-requisicao-mudanca-conhecimento', removeModalOverflowClass);
	Modal.onShown('modal-requisicao-mudanca-papel-responsabilidade', removeModalOverflowClass);
	Modal.onShown('modal-requisicao-mudanca-checklist', removeModalOverflowClass);
	Modal.onShown('modal-requisicao-mudanca-plano-reversao', removeModalOverflowClass);
	Modal.onShown('modal-requisicao-mudanca-historico', removeModalOverflowClass);
	
	$('#horaAgendamentoFinal').mask('99:99');
	$('#horaAgendamentoInicial').mask('99:99');
	$('#telefoneContato').mask(phoneMaskBehavior, phoneOptions);
	initTabelasRelacionamentos();
	
	$("#addSolicitante").click(function() {
		if (document.form.idContrato.value == ''){
			alert(i18n_message("contrato.alerta.informe_contrato"));
			return;
		}
		Modal.open('modal-requisicao-mudanca-add-solicitante', removeModalOverflowClass);
	});

	$("#addSolicitacaoServico").click(function() {
		Modal.open('modal-requisicao-mudanca-add-solicitacao', removeModalOverflowClass);
	});
	
	$("#nomeCategoriaOcorrencia").click(function() {
		Modal.open('modal-requisicao-mudanca-ocorrencias-add-categoria', removeModalOverflowClass);
	});
	
	$("#nomeOrigemOcorrencia").click(function() {
		Modal.open('modal-requisicao-mudanca-ocorrencias-add-origem', removeModalOverflowClass);
	});
});

var phoneMaskBehavior = function (val) {
  return val.replace(/\D/g, '').length === 12 ? '(000) 00000-0000' : '(000) 0000-00009';
},
phoneOptions = {
  onKeyPress: function(val, e, field, options) {
      field.mask(phoneMaskBehavior.apply({}, arguments), options);
    }
};

	

function setInfoSolicitacao(numero, fase) {
	var info = '<label class="strong">'+ i18n_message("citcorpore.comum.n")+': ' + numero + '</label>';
	
	if(fase) {
		info = info +'<label class="strong">' + i18n_message("citcorpore.comum.fase") + '</label><p>&nbsp;' + fase + '</p>';
	}
	document.getElementById('tituloSolicitacao').innerHTML = info;
}

/** autocomplete unidade **/ 
function montaParametrosAutocompleteUnidade(){
	var contrato = $("#idContrato").val();
	autocompleteUnidade.setOptions({params: {idContrato: contrato} });
}

function geraAutoCompleteUnidade(){
	autocompleteUnidade = $('#unidadeDes').autocomplete({
		serviceUrl : 'pages/autoCompleteUnidade/autoCompleteUnidade.load',
		noCache : true,
		onSelect : function(value, data) {
			$('#idUnidade').val(data);
			$('#unidadeDes').val(value.replace(/-*/, ""));
				}
			});
		}

function setarDescricao(){
	var txt = $("#DescricaoAuxliar").text();
	$("#DescricaoAuxliar").empty();
	$("#descricao").val(txt)
}

function zerarContadores(){
	 count = 0 ;
}

function marcarCheckbox(elementos){
	var arrayIds = new Array();
	arrayIds = elementos;
	for ( var i = 0; i <= arrayIds.length; i++) {
		var posicao = arrayIds[i];
		$("#posicao").attr("checked",true);
	}
	
}

function mostraMensagemInsercao(msg){
	document.getElementById('divMensagemInsercao').innerHTML = msg;
	Modal.open('modal-requisicao-mudanca-info-insercao', removeModalOverflowClass);
}

function initTabelasRelacionamentos() {

	/* ICs */
	tabelaRelacionamentoICs = new CITTable("tblICs", [ "idItemConfiguracao", "nomeItemConfiguracao", "descricao" ], []);
	tabelaRelacionamentoICs.setInsereBotaoInformacoes(true, ctx + "/imagens/order.png");
	if (display == "") {
		tabelaRelacionamentoICs.setInsereBotaoExcluir(true, ctx + "/imagens/delete.png");
	} else {
		tabelaRelacionamentoICs.setInsereBotaoExcluir(false, ctx + "/imagens/delete.png");
	}

	/* Solicitacaoservico */
	tabelaRelacionamentoSolicitacaoServico = new CITTable("tblSolicitacaoServico", [ "idSolicitacaoServico", "nomeServico" ], []);
	if (display == "") {
		tabelaRelacionamentoSolicitacaoServico.setInsereBotaoExcluir(true, ctx + "/imagens/delete.png");
	} else {
		tabelaRelacionamentoSolicitacaoServico.setInsereBotaoExcluir(false, ctx + "/imagens/delete.png");
	}

	/* servicos */
	tabelaRelacionamentoServicos = new CITTable("tblServicos", [ "idServico", "Nome", "Descricao", "Mapa" ], []);
	if (display == "") {
		tabelaRelacionamentoServicos.setInsereBotaoExcluir(true, ctx + "/imagens/delete.png");
	} else {
		tabelaRelacionamentoServicos.setInsereBotaoExcluir(false, ctx + "/imagens/delete.png");
	}

	/* problemas */
	tabelaProblema = new CITTable("tblProblema", [ "idProblema", "titulo", "descrStatus", "Editar" ], []);
	if (display == "") {
		tabelaProblema.setInsereBotaoExcluir(true, ctx + "/imagens/delete.png");
	} else {
		tabelaProblema.setInsereBotaoExcluir(false, ctx + "/imagens/delete.png");
	}

	/* Liberação */
	tabelaRelacionamentoLiberacao = new CITTable("tblLiberacao", [ "idLiberacao", "titulo", "descricao", "status" ], []);
	if (display == "") {
		tabelaRelacionamentoLiberacao.setInsereBotaoExcluir(true, ctx + "/imagens/delete.png");
	} else {
		tabelaRelacionamentoLiberacao.setInsereBotaoExcluir(false, ctx + "/imagens/delete.png");
	}

	/* Base Conhecimento */
	tabelaRelacionamentoBaseConhecimento = new CITTable("tblBaseConhecimento", [ "idBaseConhecimento", "titulo" ], []);
	if (display == "") {
		tabelaRelacionamentoBaseConhecimento.setInsereBotaoExcluir(true, ctx + "/imagens/delete.png");
	} else {
		tabelaRelacionamentoBaseConhecimento.setInsereBotaoExcluir(false, ctx + "/imagens/delete.png");
	}

	/* Risco */
	tabelaRisco = new CITTable("tblRisco", [ "idRisco", "nomeRisco", "detalhamento" ], []);
	if (display == "") {
		tabelaRisco.setInsereBotaoExcluir(true, ctx + "/imagens/delete.png");
	} else {
		tabelaRisco.setInsereBotaoExcluir(false, ctx + "/imagens/delete.png");
	}

	/* Grupo */
	tabelaGrupo = new CITTable("tblGrupo", [ "idGrupo", "nomeGrupo" ], []);
	if (display == "") {
		tabelaGrupo.setInsereBotaoExcluir(true, ctx + "/imagens/delete.png");
	} else {
		tabelaGrupo.setInsereBotaoExcluir(false, ctx + "/imagens/delete.png");
	}
}

function LOOKUP_SOL_CONTRATO_select(id, desc){
	document.form.idSolicitante.value = id;
	document.form.fireEvent("restoreColaboradorSolicitante");
}

function setaValorLookup(obj){
	document.form.idSolicitante.value = '';
	document.form.nomeSolicitante.value = '';
	document.form.emailSolicitante.value = '';
	document.form.nomeContato.value = '';
	document.form.telefoneContato.value = '';
	document.form.observacao.value = '';
	document.form.ramal.value = '';
	document.getElementById('idLocalidade').options.length = 0;
	document.getElementById('pesqLockupLOOKUP_SOL_CONTRATO_IDCONTRATO').value = '';
	document.getElementById('pesqLockupLOOKUP_SOL_CONTRATO_IDCONTRATO').value = obj.value;
	document.form.fireEvent('carregaUnidade');
	document.getElementById("idUnidade").value= "0";
	if (document.getElementById("unidadeDes")!=null){
		document.getElementById("unidadeDes").value= "";
	}
}

function deleteLinha(table, index){
	if (confirm(i18n_message("citcorpore.comum.confirmaExclusao"))) {
		teste = 'true';
		HTMLUtils.deleteRow(table, index);
		return;
	}
	teste = '';
}

function gravarEContinuar() {
	document.form.acaoFluxo.value = acaoIniciar;
	gravar();
}

function gravarEFinalizar() {
	document.form.acaoFluxo.value = acaoExecutar;
	document.form.fecharItensRelacionados.value = "N";
	var FASE_AVALIACAO = '6';
	if (document.form.idPhase.value == FASE_AVALIACAO) {
		verificarItensRelacionados(true)
	} else {
		gravar();
	}
}

function verificarItensRelacionados(validarItem) {
	if (validarItem) {
		document.form.fireEvent("verificarItensRelacionados");
		document.form.fecharItensRelacionados.value = "N";
	} else {
		if (confirm(i18n_message("citcorpore.comum.fecharItemRelacionadosMudanca"))) {
			document.form.fecharItensRelacionados.value = "S";
			gravar();
		} else {
			document.form.fecharItensRelacionados.value = "N";
			gravar();
		}
	}
}

function limpaListasRelacionamentos(){
	if (tabelaRelacionamentoICs!=undefined){
		tabelaRelacionamentoICs.limpaLista();
	}
	if (tabelaRelacionamentoServicos!=undefined){
		tabelaRelacionamentoServicos.limpaLista();
	}
	if (tabelaProblema!=undefined){
		tabelaProblema.limpaLista();
	}
	if (tabelaRelacionamentoSolicitacaoServico!=undefined){
		tabelaRelacionamentoSolicitacaoServico.limpaLista();
	}
	if (tabelaRelacionamentoLiberacao!=undefined){
		tabelaRelacionamentoLiberacao.limpaLista();
	}
	if (tabelaRelacionamentoBaseConhecimento!=undefined){
		tabelaRelacionamentoBaseConhecimento.limpaLista();
	}
	if (tabelaRisco!=undefined){
		tabelaRisco.limpaLista();
	}
	if (tabelaGrupo!=undefined){
		tabelaGrupo.limpaLista();
	}
}

/** INFLUENCIA PRIORIDADE */
function atualizaPrioridade(){
	
	var impacto = document.getElementById('nivelImpacto').value;
	var urgencia = document.getElementById('nivelUrgencia').value;
	
	if (urgencia == "B"){
		if (impacto == "B"){
			document.form.prioridade.value = 5;
		}else if (impacto == "M"){
			document.form.prioridade.value = 4;
		}else if (impacto == "A"){
			document.form.prioridade.value = 3;
		}
	}
	
	if (urgencia == "M"){
		if (impacto == "B"){
			document.form.prioridade.value = 4;
		}else if (impacto == "M"){
			document.form.prioridade.value = 3;
		}else if (impacto == "A"){
			document.form.prioridade.value = 2;
		}
	}
	
	if (urgencia == "A"){
		if (impacto == "B"){
			document.form.prioridade.value = 3;
		}else if (impacto == "M"){
			document.form.prioridade.value = 2;
		}else if (impacto == "A"){
			document.form.prioridade.value = 1;
		}
	}
}

/*
 * Funções auxílio CRUD
 */

function limpar(form){
	try{
		form.clear();
		inicializarTipoMudanca();
	}catch(e){}
	
	limpaListasRelacionamentos();
}

function validarDatas(){
	var inputs = document.getElementsByClassName("datepicker");
	var input = null;
	var errorMsg = i18n_message("citcorpore.comum.dataNaoDeveSerInferiorAtual") ;
	
	for(var i = 0; i < inputs.length; i++){
		input = inputs[i];

		if(input == null){
			continue;
		}
		
		if(comparaComDataAtual(input) < 0){
			alert(errorMsg);
			input.focus();
			throw errorMsg;
		}
	}
}

function gerarRelatorioPDF() {
	document.form.fireEvent("imprimirRelatorioReqMudanca");
}

/**
 * Ajusta dados dos textareas com fckeditor antes de gravar.
 */
function gravar(){
	
	if (document.getElementById('idTipoMudanca').value == null || document.getElementById('idTipoMudanca').value == undefined || document.getElementById('idTipoMudanca').value == '0' || document.getElementById('idTipoMudanca').value == '' || document.getElementById('idTipoMudanca').value == ' '){
		alert(i18n_message("citcorpore.comum.tipo")+": "+i18n_message("citcorpore.comum.campo_obrigatorio"));
		return;
	}
	
	// Solicitante
	if (document.getElementById('idSolicitante').value == null || document.getElementById('idSolicitante').value == undefined || document.getElementById('idSolicitante').value == '0' || document.getElementById('idSolicitante').value == '' || document.getElementById('idSolicitante').value == ' '){
		alert(i18n_message("solicitacaoServico.solicitante")+": "+i18n_message("citcorpore.comum.campo_obrigatorio"));
		openCollapseWidget($('#widgetSolicitante'));
		return;
	}

	if (document.getElementById('contato').value == null || document.getElementById('contato').value == undefined || document.getElementById('contato').value == '' || document.getElementById('contato').value == ' '){
		alert(i18n_message("solicitacaoServico.nomeDoContato")+": "+i18n_message("citcorpore.comum.campo_obrigatorio"));
		openCollapseWidget($('#widgetSolicitante'));
		return;
	}

	if (document.getElementById('emailSolicitante').value == null || document.getElementById('emailSolicitante').value == undefined || document.getElementById('emailSolicitante').value == '' || document.getElementById('emailSolicitante').value == ' '){
		alert(i18n_message("citcorpore.comum.email")+": "+i18n_message("citcorpore.comum.campo_obrigatorio"));
		openCollapseWidget($('#widgetSolicitante'));
		return;
	}
	
	if (document.getElementById('idUnidade').value == null || document.getElementById('idUnidade').value == undefined || document.getElementById('idUnidade').value == '0' || document.getElementById('idUnidade').value == '' || document.getElementById('idUnidade').value == ' '){
		alert(i18n_message("unidade.unidade")+": "+i18n_message("citcorpore.comum.campo_obrigatorio"));
		openCollapseWidget($('#widgetSolicitante'));
		return;
	}
	
	// Informações da Requisição
	if (document.getElementById('titulo').value == null || document.getElementById('titulo').value == undefined || document.getElementById('titulo').value == '' || document.getElementById('titulo').value == ' '){
		alert(i18n_message("citcorpore.comum.titulo")+": "+i18n_message("citcorpore.comum.campo_obrigatorio"));
		openCollapseWidget($('#widgetInfoRequisicao'));
		return;
	}
	
	if (document.getElementById('idGrupoAtual').value == null || document.getElementById('idGrupoAtual').value == undefined || document.getElementById('idGrupoAtual').value == '0' || document.getElementById('idGrupoAtual').value == '' || document.getElementById('idGrupoAtual').value == ' '){
		alert(i18n_message("citcorpore.comum.grupoExecutor")+": "+i18n_message("citcorpore.comum.campo_obrigatorio"));
		openCollapseWidget($('#widgetInfoRequisicao'));
		return;
	}

	if (document.getElementById('descricao').value == null || document.getElementById('descricao').value == undefined || document.getElementById('descricao').value == '' || document.getElementById('descricao').value == ' '){
		alert(i18n_message("citcorpore.comum.descricao")+": "+i18n_message("citcorpore.comum.campo_obrigatorio"));
		openCollapseWidget($('#widgetInfoRequisicao'));
		return;
	}

	if (document.getElementById('dataHoraInicioAgendada').value != '' && document.getElementById('horaAgendamentoInicial').value == '') {
		alert(i18n_message("requisicaoMudanca.informacaoHoraInicialAgendada"));
		document.getElementById('horaAgendamentoInicial').focus();
		openCollapseWidget($('#widgetInfoRequisicao'));
		return;
	}
	
	if (document.getElementById('dataHoraInicioAgendada').value == '' && document.getElementById('horaAgendamentoInicial').value != '') {
		alert(i18n_message("requisicaoMudanca.informacaoDataInicioAgendada"));
		document.getElementById('dataHoraInicioAgendada').focus();
		openCollapseWidget($('#widgetInfoRequisicao'));
		return;
	}
	
	if (document.getElementById('dataHoraTerminoAgendada').value != '' && document.getElementById('horaAgendamentoFinal').value == '') {
		alert(i18n_message("requisicaoMudanca.informacaoHoraFinalAgendada"));
		document.getElementById('horaAgendamentoFinal').focus();
		openCollapseWidget($('#widgetInfoRequisicao'));
		return;
	}
	
	if (document.getElementById('dataHoraTerminoAgendada').value == '' && document.getElementById('horaAgendamentoFinal').value != '') {
		alert(i18n_message("requisicaoMudanca.informacaoDataTerminoAgendada"));
		document.getElementById('dataHoraTerminoAgendada').focus();
		openCollapseWidget($('#widgetInfoRequisicao'));
		return;
	}

	if (document.getElementById('dataHoraInicioAgendada').value != '' && document.getElementById('dataHoraTerminoAgendada').value == '') {
		alert(i18n_message("requisicaoMudanca.informacaoDataTerminoAgendada"));
		document.getElementById('dataHoraTerminoAgendada').focus();
		openCollapseWidget($('#widgetInfoRequisicao'));
		return;
	}
	
	if (document.getElementById('dataHoraTerminoAgendada').value != '' && document.getElementById('dataHoraInicioAgendada').value == '') {
		alert(i18n_message("requisicaoMudanca.informacaoDataInicioAgendada"));
		document.getElementById('dataHoraInicioAgendada').focus();
		openCollapseWidget($('#widgetInfoRequisicao'));
		return;
	}
	
	if(document.getElementById('dataHoraInicioAgendada').value != null && document.getElementById('dataHoraInicioAgendada').value !== ""
		&& !isDateValid(document.getElementById('dataHoraInicioAgendada').value)){
		alert(i18n_message("requisicaoMudanca.inicioAgendada") + ": " + i18n_message("citcorpore.validacao.dataInvalida"));
		openCollapseWidget($('#widgetInfoRequisicao'));
		return;
	}

	if(document.getElementById('dataHoraTerminoAgendada').value != null && document.getElementById('dataHoraTerminoAgendada').value !== ""
		&& !isDateValid(document.getElementById('dataHoraTerminoAgendada').value)){
		alert(i18n_message("requisicaoMudanca.terminoAgendada") + ": " + i18n_message("citcorpore.validacao.dataInvalida"));
		openCollapseWidget($('#widgetInfoRequisicao'));
		return;
	}

	if(document.getElementById('horaAgendamentoInicial').value != null && document.getElementById('horaAgendamentoInicial').value !== ""
		&& !isHourValid(document.getElementById('horaAgendamentoInicial').value)){
		alert(i18n_message("requisicaoMudanca.horaAgendamentoInicial") + ": " + i18n_message("citcorpore.validacao.horaInvalida"));
		openCollapseWidget($('#widgetInfoRequisicao'));
		return;
	}

	if(document.getElementById('horaAgendamentoFinal').value != null && document.getElementById('horaAgendamentoFinal').value !== ""
		&& !isHourValid(document.getElementById('horaAgendamentoFinal').value)){
		alert(i18n_message("requisicaoMudanca.horaAgendamentoFinal") + ": " + i18n_message("citcorpore.validacao.horaInvalida"));
		openCollapseWidget($('#widgetInfoRequisicao'));
		return;
	}

	if(document.getElementById('horaAgendamentoInicial').value != null && document.getElementById('horaAgendamentoInicial').value !== ""
		&& !isMinuteValid(document.getElementById('horaAgendamentoInicial').value)){
		alert(i18n_message("requisicaoMudanca.horaAgendamentoInicial") + ": " + i18n_message("citcorpore.validacao.minutoInvalido"));
		openCollapseWidget($('#widgetInfoRequisicao'));
		return;
	}

	if(document.getElementById('horaAgendamentoFinal').value != null && document.getElementById('horaAgendamentoFinal').value !== ""
		&& !isMinuteValid(document.getElementById('horaAgendamentoFinal').value)){
		alert(i18n_message("requisicaoMudanca.horaAgendamentoFinal") + ": " + i18n_message("citcorpore.validacao.minutoInvalido"));
		openCollapseWidget($('#widgetInfoRequisicao'));
		return;
	}

	if(document.getElementById('dataAceitacao').value != null && document.getElementById('dataAceitacao').value !== ""
		&& !isDateValid(document.getElementById('dataAceitacao').value)){
		alert(i18n_message("requisicaoMudanca.aceitacao") + ": " + i18n_message("citcorpore.validacao.dataInvalida"));
		openCollapseWidget($('#widgetInfoRequisicao'));
		return;
	}

	if(document.getElementById('dataVotacao').value != null && document.getElementById('dataVotacao').value !== ""
		&& !isDateValid(document.getElementById('dataVotacao').value)){
		alert(i18n_message("requisicaoMudanca.votacao") + ": " + i18n_message("citcorpore.validacao.dataInvalida"));
		openCollapseWidget($('#widgetInfoRequisicao'));
		return;
	}

	if(document.getElementById('dataHoraConclusao').value != null && document.getElementById('dataHoraConclusao').value !== ""
		&& !isDateValid(document.getElementById('dataHoraConclusao').value)){
		alert(i18n_message("requisicaoMudanca.conclusao") + ": " + i18n_message("citcorpore.validacao.dataInvalida"));
		openCollapseWidget($('#widgetInfoRequisicao'));
		return;
	}

	// Fechamento
	var statusAtual;
			
	for (var i = 0; i < document.getElementsByName('idStatus').length; i++) {
		if (document.getElementsByName('idStatus')[i].checked) {
			statusAtual = document.getElementsByName('idStatus')[i].value;
		}
	}
	var STATUS_CONCLUIDO = '12';
	if (statusAtual == STATUS_CONCLUIDO){
		if (document.form.fechamento.value == '' || document.form.fechamento.value == ' '){
			alert(i18n_message("citcorpore.comum.informeFechamento"));
			openCollapseWidget($('#widgetFechamento'));
			return;				
		}
	}
	

	if ($.isNumeric(idDeBaseConhecimento)) {
		$("#idBaseConhecimento").val(parseInt(idDeBaseConhecimento));
	}
	document.form.itensConfiguracaoRelacionadosSerializado.value = ObjectUtils.serializeObjects(tabelaRelacionamentoICs.getTableObjects());
	document.form.servicosRelacionadosSerializado.value = ObjectUtils.serializeObjects(tabelaRelacionamentoServicos.getTableObjects());
	document.form.problemaSerializado.value = ObjectUtils.serializeObjects(tabelaProblema.getTableObjects());
	document.form.solicitacaoServicoSerializado.value = ObjectUtils.serializeObjects(tabelaRelacionamentoSolicitacaoServico.getTableObjects());
	document.form.liberacoesRelacionadosSerializado.value = ObjectUtils.serializeObjects(tabelaRelacionamentoLiberacao.getTableObjects());
	document.form.conhecimentosRelacionadosSerializado.value = ObjectUtils.serializeObjects(tabelaRelacionamentoBaseConhecimento.getTableObjects());
	document.form.riscoSerializado.value = ObjectUtils.serializeObjects(tabelaRisco.getTableObjects());
	document.form.grupoMudancaSerializado.value = ObjectUtils.serializeObjects(tabelaGrupo.getTableObjects());
	
	serializaResponsavel();
	serializaAprovacoesProposta();
	serializaAprovacoesMudanca();

	var informacoesComplementares_serialize = '';
	try{
		informacoesComplementares_serialize = window.frames["fraInformacoesComplementares"].getObjetoSerializado();
	}catch(e){}
	if (document.form.informacoesComplementares_serialize != undefined) {
		document.form.informacoesComplementares_serialize.value = informacoesComplementares_serialize;
	}
	
	$("#contato").prop("disabled", false);
	$("#idGrupoComite").prop("disabled", false);
	$("#idGrupoAtual").prop("disabled", false);
	$("#idTipoMudanca").prop("disabled", false);
	$("#addSolicitante").prop("disabled", false);
	$("#idContrato").prop("disabled", false);
	

	if(document.form.idRequisicaoMudanca) {
		//validarDatas();
	}
	
	document.form.save();

	JANELA_AGUARDE_MENU.show();
}


function restaurar(){
	var listaICs = ObjectUtils.deserializeCollectionFromString(document.form.itensConfiguracaoRelacionadosSerializado.value);
	var listaSolicitacaoServico = ObjectUtils.deserializeCollectionFromString(document.form.solicitacaoServicoSerializado.value);
	var listaServicos = ObjectUtils.deserializeCollectionFromString(document.form.servicosRelacionadosSerializado.value);
	var listaProblema = ObjectUtils.deserializeCollectionFromString(document.form.problemaSerializado.value);
	var listaLiberacoes = ObjectUtils.deserializeCollectionFromString(document.form.liberacoesRelacionadosSerializado.value);
	var listaConhecimentos = ObjectUtils.deserializeCollectionFromString(document.form.conhecimentosRelacionadosSerializado.value);
	var listaRisco = ObjectUtils.deserializeCollectionFromString(document.form.riscoSerializado.value);
	var listaGrupo = ObjectUtils.deserializeCollectionFromString(document.form.grupoMudancaSerializado.value);
	limpaListasRelacionamentos();
	
	for(var i = 0; i < listaICs.length; i++){
		tabelaRelacionamentoICs.addObject([listaICs[i].idItemConfiguracao, listaICs[i].nomeItemConfiguracao , listaICs[i].descricao]);
	}

	for(var i = 0; i < listaServicos.length; i++){
		tabelaRelacionamentoServicos.addObject([listaServicos[i].idServico, listaServicos[i].nome , listaServicos[i].descricao, getBotaoVisualizarMapa(listaServicos[i].idServico)]);
	}
	
	for(var i = 0; i < listaLiberacoes.length; i++){
		tabelaRelacionamentoLiberacao.addObject([listaLiberacoes[i].idLiberacao, listaLiberacoes[i].titulo , listaLiberacoes[i].descricao,listaLiberacoes[i].status]);
	}
	
	for(var i = 0; i < listaConhecimentos.length; i++){
		tabelaRelacionamentoBaseConhecimento.addObject([listaConhecimentos[i].idBaseConhecimento, listaConhecimentos[i].titulo]);
	}
	
	if(listaSolicitacaoServico.length > 0){
		for(var i = 0; i < listaSolicitacaoServico.length; i++){
			tabelaRelacionamentoSolicitacaoServico.addObject([listaSolicitacaoServico[i].idSolicitacaoServico, listaSolicitacaoServico[i].nomeServico]);
		}
	}
	
	if(listaProblema.length > 0){
		for(var i = 0; i < listaProblema.length; i++){
			tabelaProblema.addObject([listaProblema[i].idProblema, listaProblema[i].titulo, listaProblema[i].descrStatus, getBotaoEditarProblema(listaProblema[i].idProblema)]);
		}
	} 	
	
	if(listaRisco.length > 0){
		for(var i = 0; i < listaRisco.length; i++){
			tabelaRisco.addObject([listaRisco[i].idRisco, listaRisco[i].nomeRisco, listaRisco[i].detalhamento]);
		}
	}
	if(listaGrupo.length > 0){
		for(var i = 0; i < listaGrupo.length; i++){
			tabelaGrupo.addObject([listaGrupo[i].idGrupo, listaGrupo[i].nomeGrupo]);
		}
	}
}

function deletar(){
	document.form.fireEvent("delete");
}

/** Ajusta dados dos textareas com fckeditor ao restaurar. */
function restauraFckEditores(){
	var textAreaList = document.getElementsByTagName("textarea");

	for(var i = 0; i < textAreaList.length; i++){
		if(textAreaList[i].id != null){
			
			fckEditorAux = FCKeditorAPI.GetInstance( textAreaList[i].id );
			
			if(fckEditorAux != null){
				try{
					fckEditorAux.SetData(document.getElementById( textAreaList[i].id ).value);
				}catch(e){}
			}
		}	
	}
}

/*
 * Funções de relacionamento
 */

 /*
	 * Adicionado por David, para validar a aba de item de configuração
	 */
function LOOKUP_ITEMCONFIGURACAO_select(id, desc) {
	idItemConfiguracao = id;
	descricaoItemConfiguracao = desc;
	addLinhaTabelaItemConfiguracao(id, desc, true);

}

function addLinhaTabelaItemConfiguracao(id, desc, valida){
	var resultado = true;;
	var tbl = document.getElementById('tblICs');
	tbl.style.display = '';
	var lastRow = tbl.rows.length;
	if (valida){
		resultado = validaAddLinhaTabelaItemConfiguracao(lastRow, id);
		if (!resultado){
			return resultado;
		}
	}
	return resultado;
	
}

function validaAddLinhaTabelaItemConfiguracao(lastRow, id){
	var listaICs = ObjectUtils.deserializeCollectionFromString(document.form.itensConfiguracaoRelacionadosSerializado.value);
	
	if (lastRow > 1){
		for(var i = 0; i < listaICs.length; i++){
			if (listaICs[i].idItemConfiguracao == id){
				alert(i18n_message("citcorpore.comum.registroJaAdicionado"));
				return false;
			}
		}
	} 
	return true;
}

function abrirModalPesquisaItemConfiguracao(){
	document.getElementById('framePesquisaItemConfiguracao').src = ctx + "/pages/pesquisaItemConfiguracao/pesquisaItemConfiguracao.load?iframe=true";
	Modal.open('modal-requisicao-mudanca-add-ic', removeModalOverflowClass);
}

// adicionar problema

function LOOKUP_LIBERACAO_MUDANCA_select(id, desc) {
	document.getElementById('liberacao#idRequisicaoLiberacao').value = id;
	document.form.fireEvent("inserirRequisicaoLiberacao");
};


function LOOKUP_CONHECIMENTO_RELACIONADO_select(id, desc) {
	document.getElementById('baseConhecimento#idBaseConhecimento').value = id;
	document.form.fireEvent("inserirRequisicaoBaseConhecimento");
};

function LOOKUP_BASECONHECIMENTO_select(id, desc) {
	document.getElementById('baseConhecimento#idBaseConhecimento').value = id;
	document.form.fireEvent("inserirRequisicaoBaseConhecimento");
};

// adicionar problema
function LOOKUP_PROBLEMA_select(id, desc) {
	addLinhaTabelaProblema(id, desc, true);
};

function LOOKUP_GRUPO_select(id, desc) {
	addLinhaTabelaGrupo(id, desc, true);
};

function addLinhaTabelaProblema(id, desc, valida){
	var tbl = document.getElementById('tblProblema');
	tbl.style.display = '';
	var lastRow = tbl.rows.length;
	if (valida){
		if (!validaAddLinhaTabelaProblema(lastRow, id)){
			return;
		}
	}
	
	desc = desc.replace(/['"]*/g, '');
	
	var camposLookupProblema = desc.split("-");
	tabelaProblema.addObject([id, camposLookupProblema[1], camposLookupProblema[2], getBotaoEditarProblema(id)]);
	
	document.form.problemaSerializado.value = ObjectUtils.serializeObjects(tabelaProblema.getTableObjects());
	
	Modal.close('modal-requisicao-mudanca-add-problema');
}

function removeBotaoEditarProblemaNaTblProblema(){
	if (tabelaProblema!=undefined){
		if (tabelaProblema.getTableList() != ""){
			tabelaProblema.getTableList()[0][3] = "";
			tabelaProblema.montaTabela();
		}
	}
}

function validaAddLinhaTabelaProblema(lastRow, id){
	var listaProblema = ObjectUtils.deserializeCollectionFromString(document.form.problemaSerializado.value);
	
	if (lastRow > 1){
		for(var i = 0; i < listaProblema.length; i++){
			if (listaProblema[i].idProblema == id){
				alert(i18n_message("citcorpore.comum.registroJaAdicionado"));
				return false;
			}
		}
	} 
	return true;
}

function getBotaoVisualizarMapa(id){
	var botaoVisualizarMapa = new Image();

	botaoVisualizarMapa.src = ctx + '/template_new/images/icons/small/grey/magnifying_glass.png';
	botaoVisualizarMapa.setAttribute("style", "cursor: pointer;");
	botaoVisualizarMapa.id = id;
	botaoVisualizarMapa.addEventListener("click", function(evt){
		document.getElementById('frameMapaDesenhoServico').src = ctx + "/pages/mapaDesenhoServico/mapaDesenhoServico.load?iframe=true&idServico=" + this.id;
		Modal.open('modal-requisicao-mudanca-mapa-desenho-servico', removeModalOverflowClass);
	}, true);

	return botaoVisualizarMapa;
}

// adicionar Risco
function LOOKUP_RISCO_select(id, desc) {
	addLinhaTabelaRisco(id, desc, true);
};

/*
 * Funções alimentação tabelas de relacionamento
 */

 /**
 * Renderiza tabela a partir de lista.
 * 
 * @param _idCITTable
 *            id da tabela a ser tratada
 * @param _fields
 *            Lista de campos correspondentes ao banco de dados
 * @param _tableObjects
 *            Lista de itens. Deve corresponder aos campos de
 *            _fields
 */
 var contador = 0;
 function CITTable(_idCITTable, _fields, _tableObjects){
	var self = this;
	var idCITTable = _idCITTable;
	var fields = _fields;
	var tableObjects = _tableObjects;
	var tabela = null;
	
	var insereBtExcluir = true;
	var insereBtInformacoes  = true;
	var imgBotaoExcluir;
	var imgBotaoInformacoes;

	this.onDeleteRow = function(deletedItem){};

	this.getTableList = function(){
		return tableObjects;
	}

	/**
	 * Transforma a lista da tabela em uma lista de objetos de acordo com o 'fields' passado.
	 */
	this.getTableObjects = function(){
		var objects = [];
		var object = {};

		for(var j = 0; j < tableObjects.length; j++){
			for(var i = 0 ; i < fields.length; i++){
				eval("object." + fields[i] + " = '" + tableObjects[j][i] + "'");
			}
			objects.push(object);
			object = {};
		}
		
		return objects;
	}

	this.setTableObjects = function(objects){
		tableObjects = objects;
		this.montaTabela();
	}
	
	this.addObject = function(object){
		tableObjects.push(object);
		this.montaTabela();
	}

	this.limpaLista = function(){
		tableObjects.length = 0;
		tableObjects = null;
		tableObjects = [];
		limpaTabela();
	}
	
	var limpaTabela = function(){
		while (getTabela().rows.length > 1){
			getTabela().deleteRow(1); 
		}
	}
	
	this.montaTabela = function(){
		var linha;
		var celula;
		
		limpaTabela();

		var idItemConfiguracao;
		
		for(var i = tableObjects.length - 1; i >= 0; i--){
			
			var j = 0;
			linha = getTabela().insertRow(1);

			for(j = 0; j < fields.length; j++){
				celula = linha.insertCell(j);
	
				// tratamento caso seja um componente ao invés de texto
				try{
					celula.appendChild(tableObjects[i][j]);
				}catch(e){
					celula.innerHTML = tableObjects[i][j];
				}
			}

			if(insereBtExcluir){
				var btAux = getCopiaBotaoExcluir();
				var celExcluir = linha.insertCell(j);
				
				btAux.setAttribute("id", i);
				btAux.addEventListener("click", function(evt){
					// ao disparar o evento, considerará o id do botão
					self.removeObject(this.id);
					self.onDeleteRow(this);
				}, false);
				celExcluir.appendChild(btAux);
			}
			
			
			if(idCITTable == "tblICs"){
				
				if(insereBtInformacoes){
					var btAux = getCopiaBotaoInformacoes();
					var celInformacoes = linha.insertCell(j);
					btAux.setAttribute("id", i);
					
					btAux.addEventListener("click", function(evt){
						carregaPaginaIC(this.id);
					}, false);
					celInformacoes.appendChild(btAux);
				}	
			}
		}
	}
	
	this.removeObject = function(indice){
		removeObjectDaLista(indice);
		this.montaTabela();
	}

	/**
	 * Remove item e organiza lista
	 */
	var removeObjectDaLista = function(indice){
		tableObjects[indice] = null;
		var novaLista = [];
		for(var i = 0 ; i < tableObjects.length; i++){
			if(tableObjects[i] != null){
				novaLista.push(tableObjects[i]);
			}
		}
		tableObjects = novaLista;
	}

	var getCopiaBotaoExcluir = function(){
		var novoBotao = new Image();
		novoBotao.setAttribute("style", "cursor: pointer;");
		novoBotao.src = imgBotaoExcluir;
		return novoBotao;
	}
	
	var getCopiaBotaoInformacoes = function(){
		var novoBotao = new Image();
		novoBotao.setAttribute("style", "cursor: pointer;");
		novoBotao.src = imgBotaoInformacoes;
		return novoBotao;
	}

	var setImgPathBotaoExcluir = function(src){
		imgBotaoExcluir = src;
	}
	
	var setImgPathBotaoInformacoes = function(src){
		imgBotaoInformacoes= src;
	}

	var getTabela = function(){
		if(tabela == null){
			tabela = document.getElementById(idCITTable);
		}
		return tabela;
	}

	this.setInsereBotaoExcluir = function(bool, imgSrc){
		insereBtExcluir = bool;
		setImgPathBotaoExcluir(imgSrc);
	}
	
	this.setInsereBotaoInformacoes = function(bool, imgSrc){
		insereBtInformacoes = bool;
		setImgPathBotaoInformacoes(imgSrc);
	}
}
	
fechar = function(){
	parent.fecharMudanca();
}	

function mostrarEscondeRegExec(){
	if (document.getElementById('divMostraRegistroExecucao').style.display == 'none'){
		document.getElementById('divMostraRegistroExecucao').style.display = '';
		document.getElementById('btnAddRegExec').innerHTML = i18n_message("solicitacaoServico.addregistroexecucao_menos");
	}else{
		document.getElementById('divMostraRegistroExecucao').style.display = 'none';
		document.getElementById('btnAddRegExec').innerHTML = i18n_message("solicitacaoServico.addregistroexecucao_mais");
	}
}

function getBotaoEditarProblema(id){
	var botaoVisualizarProblemas = new Image();

	botaoVisualizarProblemas.src = ctx + '/imagens/viewCadastro.png';
	botaoVisualizarProblemas.setAttribute("style", "cursor: pointer;");
	botaoVisualizarProblemas.id = id;
	botaoVisualizarProblemas.addEventListener("click", function(evt){CarregarProblema(id)}, true);

	return botaoVisualizarProblemas;
}
	
function CarregarProblema(idProblema){
	document.getElementById('iframeEditarProblema').src = ctx + "/pages/problema/problema.load?iframe=true&chamarTelaProblema=S&acaoFluxo=E&idProblema="+idProblema;
	Modal.open('modal-requisicao-mudanca-editar-problema', removeModalOverflowClass);
}


function fecharFrameProblema(){
	Modal.close('modal-requisicao-mudanca-editar-problema');
}

function teste() {
	document.form.fireEvent('tratarCaracterItemConfiguracao');
}

/**
 * INFORMAÇÕES COMPLEMENTARES (TEMPLATE/QUESTIONARIO)
 */
function exibirInformacoesComplementares(url) {
	if (url != '') {
		JANELA_AGUARDE_MENU.show();
		document.getElementById('fraInformacoesComplementares').src = ctx + '' + url;
	} else {
		try {
			escondeJanelaAguarde();
		} catch (e) {
		}
		document.getElementById('divInformacoesComplementares').style.display = 'none';
	}
}

function exibeJanelaAguarde() {
	JANELA_AGUARDE_MENU.show();
}

function escondeJanelaAguarde() {
	JANELA_AGUARDE_MENU.hide();
}

function abrirModalNovoSolicitante(){
	var idContrato = document.form.idContrato.value;
	document.getElementById('iframeNovoColaborador').src = ctx + "/pages/empregado/empregado.load?iframe=true&idContrato="+idContrato;
	
	Modal.open('modal-requisicao-mudanca-novo-solicitante');
}

function abreModalOcorrencia(editarVisualizar) {
	document.getElementById('frameCadastroOcorrenciaSolicitacao').src = URL_SISTEMA+'pages/ocorrenciaSolicitacao/ocorrenciaSolicitacao.load?iframe=true&idSolicitacaoServico='+document.form.idSolicitacaoServico.value+'&visualizar='+editarVisualizar;
	Modal.open('modal-requisicao-mudanca-ocorrencia');
}

function fecharAddSolicitante(){
	Modal.close('modal-requisicao-mudanca-novo-solicitante');
}

function atualizarLista() {
	Modal.close('modal-requisicao-mudanca-add-solicitacao');
}

function abrirPopupNovoTipoRequisicaoMudanca(){
	document.getElementById('iframeNovoTipoRequisicaoMudanca').src = ctx + "/pages/tipoMudanca/tipoMudanca.load?iframe=true";
	Modal.open('modal-requisicao-mudanca-novo-tipo');
	Modal.onHidden('modal-requisicao-mudanca-novo-tipo', function() {
		document.form.fireEvent('preencherComboTipoMudanca');
	});
}

function abrirPopupNovaUnidade(){
	document.getElementById('iframeNovaUnidade').src = ctx + "/pages/unidade/unidade.load?iframe=true";
	Modal.open('modal-requisicao-mudanca-nova-unidade');
	Modal.onHidden('modal-requisicao-mudanca-nova-unidade', function() {
		document.form.fireEvent('carregaUnidade');
	});
}

function abrirPopupNovaLocalidade(){
	document.getElementById('iframeNovaLocalidade').src = ctx + "/pages/localidade/localidade.load?iframe=true";
	Modal.open('modal-requisicao-mudanca-nova-localidade');
	Modal.onHidden('modal-requisicao-mudanca-nova-localidade', function() {
		document.form.fireEvent('preencherComboLocalidade');
	});
}

function abrirPopupNovoGrupo(){
	document.getElementById('iframeNovoGrupo').src = ctx + "/pages/grupo/grupo.load?iframe=true";
	Modal.open('modal-requisicao-mudanca-novo-grupo');
	Modal.onHidden('modal-requisicao-mudanca-novo-grupo', function() {
		if(document.form.idRequisicaoMudanca.value == ""){
			document.form.fireEvent('preencherComboGrupoExecutor');
			document.form.fireEvent('preencherComboComite');
		}
	});
}

function abrirAbaPlanoDeReversao() {
	alert(i18n_message("informeAnexoReversao"));
	JANELA_AGUARDE_MENU.hide();
	$('.tabs').tabs('select', 12);
}

function resize_iframe() {}

function imprimirCadastroReqMudancaPdf(){
	JANELA_AGUARDE_MENU.show();
	document.form.fireEvent('imprimirCadastroPdf');
}

/**
 * Votação da Proposta
 */

function addLinhaTabelaAprovacaoProposta(idEmpregado,nomeEmpregado,comentario,dataHoraVotacao,validacao,valida){
	var tbl = document.getElementById('tabelaAprovacoesProposta');
	tbl.style.display = '';
	var lastRow = tbl.rows.length;
	var row = tbl.insertRow(lastRow);
	var  disabled = '';
	if(validacao == 'true' ){
		disabled =  'disabled = "true"';
	}
	
	if (dataHoraVotacao == null || dataHoraVotacao == 'null' || dataHoraVotacao == 'undefined') {
		dataHoraVotacao = i18n_message('requisicaoMudanca.aindaNaoVotou');
	}
	
	count++;
	coluna = row.insertCell(0);
	coluna.innerHTML ='<input id="idEmpregadoProposta' + count + '" type="hidden" name="idEmpregadoProposta" value="' + idEmpregado + '"/><input  value = "'+nomeEmpregado+'"  type="hidden" name="nomeEmpregadoProposta" id="nomeEmpregadoProposta' + count + '" />';
	coluna = row.insertCell(1);
	coluna.innerHTML = nomeEmpregado ;
	coluna = row.insertCell(2);
	coluna.innerHTML = "<span  style='padding-right: 30px;'><input "+disabled+"  style='margin-right: 5px;' type='radio' id='votoAProposta" + count + "' name='votoProposta" + count + "' value='A'  />"+i18n_message("citcorpore.comum.aprovada")+"</span>" +
	"<span style='padding-right: 30px;'><input "+disabled+" style='margin-right: 5px;' type='radio' id='votoRProposta" + count + "' name='votoProposta" + count + "' value='R' />"+i18n_message("citcorpore.comum.rejeitada")+"</span>";
	coluna = row.insertCell(3);
	coluna.innerHTML =  '<input  '+disabled+'  value="'+comentario+'" name="comentarioProposta' + count + '" id="comentarioProposta' + count + '" size="100"  type="text" maxlength="200" />'
	coluna = row.insertCell(4);
	var input ='<input  value="'+dataHoraVotacao+'" name="dataHoraVotacaoProposta' + count + '" id="dataHoraVotacaoProposta' + count + '" size="100"  type="hidden" maxlength="200" />';
	coluna.innerHTML = dataHoraVotacao + input;
}

function AprovacaoPropostaDTO(idEmpregado,nomeEmpregado,dataHoraVotacao,voto,comentario,i){
	this.idEmpregado = idEmpregado; 
	this.nomeEmpregado = nomeEmpregado; 
	this.dataHoraVotacao = dataHoraVotacao
	this.voto = voto; 
	this.comentario = comentario; 
}
	
function serializaAprovacoesProposta(){
	var tabela = document.getElementById('tabelaAprovacoesProposta');
	var count = tabela.rows.length;
	var listaDeAprovacoes = [];
	for(var i = 1; i < count ; i++){
		var voto =  '';
		if (document.getElementById('idEmpregadoProposta' + i) != "" && document.getElementById('idEmpregadoProposta' + i) != null){
		var idEmpregado = document.getElementById('idEmpregadoProposta' + i).value;
		var nomeEmpregado = document.getElementById('nomeEmpregadoProposta' + i).value;
		var dataHoraVotacao = document.getElementById('dataHoraVotacaoProposta' + i).value;
		if ($('#votoAProposta' + i).is(":checked")){
			voto = "A";
		} else{
			if ($('#votoRProposta' + i).is(":checked")){
				voto = "R";
			} 
		}
		
		var comentario = document.getElementById('comentarioProposta' + i).value;
		var aprovacaoProposta = new AprovacaoPropostaDTO(idEmpregado, nomeEmpregado, dataHoraVotacao, voto, comentario,i);
		listaDeAprovacoes.push(aprovacaoProposta);
		}
	}
	var serializa = ObjectUtils.serializeObjects(listaDeAprovacoes);
	document.form.aprovacaoPropostaServicoSerializado.value = serializa;
}

function deleteAllRowsProposta() {
	var tabela = document.getElementById('tabelaAprovacoesProposta');
	var count = tabela.rows.length;

	while (count > 1) {
		tabela.deleteRow(count - 1);
		count--;
	}
}

function atribuirCheckedVotoProposta(voto){
	if (voto == "A" && voto != null){
		$('#votoAProposta' + count).attr('checked', true);
	} else{
		if (voto == "R" && voto != null){
			$('#votoRProposta' + count).attr('checked', true);
		} 
	}
}

/**
 * Votação da Requisição de Mudança
 */

function AprovacaoMudancaDTO(idEmpregado,nomeEmpregado,dataHoraVotacao,voto,comentario,i){
	this.idEmpregado = idEmpregado; 
	this.nomeEmpregado = nomeEmpregado; 
	this.dataHoraVotacao = dataHoraVotacao
	this.voto = voto; 
	this.comentario = comentario; 
}

function serializaAprovacoesMudanca(){
	var tabela = document.getElementById('tabelaAprovacoesMudanca');
	var count = tabela.rows.length;
	var listaDeAprovacoes = [];
	for(var i = 1; i < count ; i++){
		var voto =  '';
		if (document.getElementById('idEmpregadoMudanca' + i) != "" && document.getElementById('idEmpregadoMudanca' + i) != null){
 			var idEmpregado = document.getElementById('idEmpregadoMudanca' + i).value;
 			var nomeEmpregado = document.getElementById('nomeEmpregadoMudanca' + i).value;
 			var dataHoraVotacao = document.getElementById('dataHoraVotacaoMudanca' + i).value;
 			if ($('#votoAMudanca' + i).is(":checked")){
 				voto = "A";
			} else{
				if ($('#votoRMudanca' + i).is(":checked")){
					voto = "R";
				} 
			}
 			
 			
 			var comentario = document.getElementById('comentarioMudanca' + i).value;
 			var aprovacaoMudanca = new AprovacaoMudancaDTO(idEmpregado, nomeEmpregado, dataHoraVotacao, voto, comentario,i);
 			listaDeAprovacoes.push(aprovacaoMudanca);
		}
	} 	
	
	var serializa = ObjectUtils.serializeObjects(listaDeAprovacoes);
	document.form.aprovacaoMudancaServicoSerializado.value = serializa;
}

function addLinhaTabelaAprovacaoMudanca(idEmpregado,nomeEmpregado,comentario,dataHoraVotacao,validacao,valida){
	var tbl = document.getElementById('tabelaAprovacoesMudanca');
	tbl.style.display = '';
	var lastRow = tbl.rows.length;
	var row = tbl.insertRow(lastRow);
	var  disabled = '';
	if(validacao == 'true' ){
		disabled =  'disabled = "true"';
	}
	
	if (dataHoraVotacao == null || dataHoraVotacao == 'null' || dataHoraVotacao == 'undefined') {
		dataHoraVotacao = i18n_message('requisicaoMudanca.aindaNaoVotou');
	}
	
	count++;
	coluna = row.insertCell(0);
	coluna.innerHTML ='<input id="idEmpregadoMudanca' + count + '" type="hidden" name="idEmpregadoMudanca" value="' + idEmpregado + '"/><input  value = "'+nomeEmpregado+'"  type="hidden" id="nomeEmpregadoMudanca' + count + '" />';
	coluna = row.insertCell(1);
	coluna.innerHTML = nomeEmpregado ;
	coluna = row.insertCell(2);
	coluna.innerHTML = '<span  style="padding-right: 30px;"><input '+disabled+'  style="margin-right: 5px;" type="radio" id="votoAMudanca' + count + '" name="votoMudanca' + count + '" value="A"  />'+i18n_message("citcorpore.comum.aprovada")+'</span>' +
	'<span style="padding-right: 30px;"><input '+disabled+' style="margin-right: 5px;" type="radio" id="votoRMudanca' + count + '" name="votoMudanca' + count + '" value="R" />'+i18n_message("citcorpore.comum.rejeitada")+'</span>';
	coluna = row.insertCell(3);
	coluna.innerHTML =  '<input  '+disabled+'  value="'+comentario+'" name="comentarioMudanca' + count + '" id="comentarioMudanca' + count + '" size="100"  type="text" maxlength="200" />'
	coluna = row.insertCell(4);
	var input ='<input  value="'+dataHoraVotacao+'" name="dataHoraVotacaoMudanca' + count + '" id="dataHoraVotacaoMudanca' + count + '" size="100"  type="hidden" maxlength="200" />';
	coluna.innerHTML = dataHoraVotacao + input;
}

function deleteAllRowsMudanca() {
	var tabela = document.getElementById('tabelaAprovacoesMudanca');
	var count = tabela.rows.length;

	while (count > 1) {
		tabela.deleteRow(count - 1);
		count--;
	}
}

function validacaoComportamentoPorTipoMudanca() {
	document.form.fireEvent('validacaoComportamentoPorTipoMudanca');
}

function restoreImpactoUrgenciaPorTipoMudanca(){
	document.form.fireEvent('restoreImpactoUrgenciaPorTipoMudanca');
}

function inicializarTipoMudanca() {
	if(document.form.idTipoMudancaDefault) {
		$('#idTipoMudanca').val(document.form.idTipoMudancaDefault.value);
		exibirEsconderCategoriaMudanca(true);
	}
}

function setTipoMudancaDefault(idTipoMudancaDefault) {
	document.form.idTipoMudancaDefault.value = idTipoMudancaDefault;
	$('#idTipoMudanca').val(idTipoMudancaDefault);
}

function onChangeTipoMudanca() {
	validacaoComportamentoPorTipoMudanca();
	restoreImpactoUrgenciaPorTipoMudanca();
}

function exibirEsconderCategoriaMudanca(isExibir) {
	if(isExibir) {
		$('#nomeCategoriaMudanca').attr('disabled', false);
		$('#div_categoria').show();
		$('#div_ehProposta').show();
	} else {
		$('#nomeCategoriaMudanca').attr('disabled',true);
		$('#div_categoria').hide();
		$('#div_ehProposta').hide();
	}
}

function exibirEsconderComiteConsultivoMudanca(isExibir) {
	if(isExibir) {
		$('#idGrupoComite').attr('disabled', false);
		$('#grupoComiteConsultivoMudanca').show();
	} else {
		$('#idGrupoComite').attr('disabled',true);
		$('#grupoComiteConsultivoMudanca').hide();
	}
}

function exibirEsconderVotacao(isExibirVotacaoProposta, isExibirVotacaoMudanca) {
	if(isExibirVotacaoProposta) {
		$('#divVotacaoProposta').show();
	} else {
		$('#divVotacaoProposta').hide();
	}
	
	if(isExibirVotacaoMudanca) {
		$('#divVotacaoRequisicaoMudanca').show();
	} else {
		$('#divVotacaoRequisicaoMudanca').hide();
	}
}

function atribuirCheckedVotoMudanca(voto){
	if (voto == "A" && voto != null){
		$('#votoAMudanca' + count).attr('checked', true);
	} else{
		if (voto == "R" && voto != null){
			$('#votoRMudanca' + count).attr('checked', true);
		} 
	}
}

/**
 * Relacionar Item de Configuração
 */

//Função chamada em pesquisaItemConfiguracao.js após usuário selecionar um item de configuração em #modal-requisicao-mudanca-add-ic
function selectedItemConfiguracao(id){
	idItemConfiguracao = id;
	document.getElementById('hiddenIdItemConfiguracao').value = id;
	var tbl = document.getElementById('tblICs');
	tbl.style.display = '';
	var lastRow = tbl.rows.length;
	var resultado = true;
	resultado = validaAddLinhaTabelaItemConfiguracao(lastRow, id);
	
	if (resultado == true){
		Modal.open('modal-requisicao-mudanca-desc-ic', removeModalOverflowClass);
	}else{
		return;
	}
}

function fecharPopupDescricaoItemConf(){
	document.getElementById('hiddenDescricaoItemConfiguracao').value = document.getElementById('descricaoItemConfiguracao').value;
	document.form.fireEvent('tratarCaracterItemConfiguracao');
	Modal.close('modal-requisicao-mudanca-desc-ic');
}

	
function atualizarTabelaRelacionarItemConfiguracao(itemTratado, desc){
	var descricao = document.getElementById('hiddenDescricaoItemConfiguracao').value;
	descricaoItemConfiguracao = desc;
	var registroJaEssisteTabela = addLinhaTabelaItemConfiguracao(idItemConfiguracao, desc, true);
	if (registroJaEssisteTabela == false) {
		return;
	}
	tabelaRelacionamentoICs.addObject([idItemConfiguracao, descricaoItemConfiguracao, descricao]);
	document.form.itensConfiguracaoRelacionadosSerializado.value = ObjectUtils.serializeObjects(tabelaRelacionamentoICs.getTableObjects());
	
	fecharItemRequisicao();
	
	document.getElementById('descricaoItemConfiguracao').value = "";
	idItemConfiguracao = "";
	descricaoItemConfiguracao = "";
}

function fecharItemRequisicao() {
	Modal.close('modal-requisicao-mudanca-add-ic');
}

// Informçãoes

carregaPaginaIC = function(idLinha){
	var listaICs = ObjectUtils.deserializeCollectionFromString(document.form.itensConfiguracaoRelacionadosSerializado.value); 	
	var idItemConfiguracao = listaICs[idLinha].idItemConfiguracao;
	
	document.getElementById('fraInfosItemConfig').src = "about:blank";
	document.getElementById('fraInfosItemConfig').src = ctx + '/pages/gerenciamentoItemConfiguracao/gerenciamentoItemConfiguracao.load?iframe=true&iFramInformacaoItemConfiguracao=true&idInfoItem=' + idItemConfiguracao; 
	
	Modal.open('modal-requisicao-mudanca-info-ic', removeModalOverflowClass);
}

/**
 * Relacionar Serviços
 */

function adicionarServico(){
	abrePopupServicos();	
}

function abrePopupServicos(){
	Modal.open('modal-requisicao-mudanca-add-servico', removeModalOverflowClass);
}

/**
 * Relacionar Serviços
 */

function abrePopupProblema(){
	limpar_LOOKUP_PROBLEMA();
	Modal.open('modal-requisicao-mudanca-add-problema', removeModalOverflowClass);
}

function adicionarProblema(){
	abrePopupProblema();
	//é necessário serializar para que requisicaoMudanca.java possa trabalhar com quantidade atualizada de linhas na grid.
	serializaProblema();
}

function serializaProblema(){
	//Serializando para pode trabalhar com quantidade atual de linhas na grid
	document.form.problemaSerializado.value = ObjectUtils.serializeObjects(tabelaProblema.getTableObjects()); 
}

//TODO[deborah.ferreira] Verificar nome da modal
function fecharProblema(){
	Modal.close('modal-requisicao-mudanca-add-solicitacao');
}

function LOOKUP_SERVICO_select(id, desc) {
	addLinhaTabelaServicos(id, desc, true);

};

function addLinhaTabelaServicos(id, desc, valida){
	var tbl = document.getElementById('tblServicos');
	tbl.style.display = '';
	var lastRow = tbl.rows.length;
	if (valida){
		if (!validaAddLinhaTabelaServicos(lastRow, id)){
			return;
		}
	}
	
	var camposLookupServico = desc.split("-");
	tabelaRelacionamentoServicos.addObject([id, camposLookupServico[0], camposLookupServico[1], getBotaoVisualizarMapa(id)]);	
	
	document.form.servicosRelacionadosSerializado.value = ObjectUtils.serializeObjects(tabelaRelacionamentoServicos.getTableObjects());
	
	Modal.close('modal-requisicao-mudanca-add-servico');
	
}

function validaAddLinhaTabelaServicos(lastRow, id){
	var listaServicos = ObjectUtils.deserializeCollectionFromString(document.form.servicosRelacionadosSerializado.value);
	
	if (lastRow > 1){
		for(var i = 0; i < listaServicos.length; i++){
			if (listaServicos[i].idServico == id){
				alert(i18n_message("citcorpore.comum.registroJaAdicionado"));
				return false;
			}
		}
	} 
	return true;
}

/**
 * Relacionar Incidentes/Requisições
 */

function abrirPopupNovaSolicitacaoServico(){
	document.getElementById('iframeNovaSolicitacao').src = ctx + "/pages/solicitacaoServicoMultiContratos/solicitacaoServicoMultiContratos.load?iframe=true";
	Modal.open('modal-requisicao-mudanca-nova-solicitacao', removeModalOverflowClass);
}

function fecharModalNovaSolicitacao() {
	Modal.close('modal-requisicao-mudanca-nova-solicitacao');
}

function fecharModalFilha() {
	Modal.close('modal-requisicao-mudanca-nova-solicitacao');
}

function pesquisarItensFiltro() {
	Modal.close('modal-requisicao-mudanca-nova-solicitacao');
}

function LOOKUP_SOLICITACAOSERVICO_select(id, id2, desc){
	addLinhaTabelaSolicitacaoServico(id, desc, true);
	
}
	
function addLinhaTabelaSolicitacaoServico(id, desc, valida){
	var tbl = document.getElementById('tblSolicitacaoServico');
	tbl.style.display = '';
	var lastRow = tbl.rows.length;
	if (valida){
		if (!validaAddLinhaTabelaSolicitacaoServico(lastRow, id)){
			return;
		}
	}
	
	tabelaRelacionamentoSolicitacaoServico.addObject([id, desc]);
	
	document.form.solicitacaoServicoSerializado.value = ObjectUtils.serializeObjects(tabelaRelacionamentoSolicitacaoServico.getTableObjects());
	
	Modal.close('modal-requisicao-mudanca-add-solicitacao');
	
}

function validaAddLinhaTabelaSolicitacaoServico(lastRow, id){
	var listaSolicitacaoServico = ObjectUtils.deserializeCollectionFromString(document.form.solicitacaoServicoSerializado.value);
	
	if (lastRow > 1){
		for(var i = 0; i < listaSolicitacaoServico.length; i++){
			if (listaSolicitacaoServico[i].idSolicitacaoServico == id){
				alert(i18n_message("citcorpore.comum.registroJaAdicionado"));
				return false;
			}
		}
	} 
	return true;
}

/**
 * Risco
 */

function addLinhaTabelaRisco(id, desc, valida){
	var tbl = document.getElementById('tblRisco');
	tbl.style.display = '';
	var lastRow = tbl.rows.length;
	if (valida){
		if (!validaAddLinhaTabelaRisco(lastRow, id)){
			return;
		}
	}
	
	var camposLookupRisco = desc.split("-");
	tabelaRisco.addObject([id, camposLookupRisco[0], camposLookupRisco[1]]);
	
	document.form.riscoSerializado.value = ObjectUtils.serializeObjects(tabelaRisco.getTableObjects());
	
	Modal.close('modal-requisicao-mudanca-add-risco');
	
}

function validaAddLinhaTabelaRisco(lastRow, id){
	var listaRisco = ObjectUtils.deserializeCollectionFromString(document.form.riscoSerializado.value);
	
	if (lastRow > 1){
		for(var i = 0; i < listaRisco.length; i++){
			if (listaRisco[i].idRisco == id){
				alert(i18n_message("citcorpore.comum.registroJaAdicionado"));
				return false;
			}
		}
	} 
	return true;
}

function abrePopupRisco(){
	Modal.open('modal-requisicao-mudanca-add-risco', removeModalOverflowClass);
}

function adicionarRisco(){
	abrePopupRisco();
}

function chamaPopupCadastroRisco(){
	document.getElementById('iframeNovoRisco').src = ctx + "/pages/risco/risco.load?iframe=true";
	Modal.open('modal-requisicao-mudanca-novo-risco', removeModalOverflowClass);
}

/**
 * Liberação
 */

//Adiciona a linha da liberação
function adicionaLiberacaoMudanca(idLiberacao,titulo,descricao,status){
	
	// Faz a validação para verificar pelo id que o registro já está adicionado
	var tbl = document.getElementById('tblLiberacao');
	tbl.style.display = '';
	var lastRow = tbl.rows.length;
	var valida = true;
	if (valida){
		if (!validaAddLinhaTabelaLiberacao(lastRow, idLiberacao)){
			return;
		}
	}
	
	tabelaRelacionamentoLiberacao.addObject([idLiberacao, titulo, descricao,status], [getBotaoVisualizarMapa(idLiberacao)]);	
	
	document.form.liberacoesRelacionadosSerializado.value = ObjectUtils.serializeObjects(tabelaRelacionamentoLiberacao.getTableObjects());
	
	Modal.close('modal-requisicao-mudanca-add-liberacao');
}

function validaAddLinhaTabelaLiberacao(lastRow, id){
	var listaLiberacoes = ObjectUtils.deserializeCollectionFromString(document.form.liberacoesRelacionadosSerializado.value);
	
	if (lastRow > 1){
		for(var i = 0; i < listaLiberacoes.length; i++){
			if (listaLiberacoes[i].idLiberacao == id){
				alert(i18n_message("citcorpore.comum.registroJaAdicionado"));
				return false;
			}
		}
	} 
	return true;
}

function adicionarLiberacao() {
	abrePopupLiberacao();
}

function abrePopupLiberacao(){
	Modal.open('modal-requisicao-mudanca-add-liberacao', removeModalOverflowClass);
}

/**
 * Grupo
 */

function adicionarGrupo() {
	abrePopupGrupo();
}

function abrePopupGrupo(){
	Modal.open('modal-requisicao-mudanca-add-grupo', removeModalOverflowClass);
}

function addLinhaTabelaGrupo(id, desc, valida){
	var tbl = document.getElementById('tblGrupo');
	tbl.style.display = '';
	var lastRow = tbl.rows.length;
	if (valida){
		if (!validaAddLinhaTabelaGrupo(lastRow, id)){
			return;
		}
	}
	
	desc = desc.replace(/['"]*/g, '');
	
	var camposLookupGrupo = desc.split("-");
	tabelaGrupo.addObject([id, camposLookupGrupo[0]]);
	
	document.form.grupoMudancaSerializado.value = ObjectUtils.serializeObjects(tabelaGrupo.getTableObjects());
	
	Modal.close('modal-requisicao-mudanca-add-grupo');
	
}

function validaAddLinhaTabelaGrupo(lastRow, id){
	var listaGrupo = ObjectUtils.deserializeCollectionFromString(document.form.grupoMudancaSerializado.value);
	
	if (lastRow > 1){
		for(var i = 0; i < listaGrupo.length; i++){
			if (listaGrupo[i].idGrupo == id){
				alert(i18n_message("citcorpore.comum.registroJaAdicionado"));
				return false;
			}
		}
	} 
	return true;
}

/**
 * Base de Conhecimento
 */

function cadastrarBaseConhecimento() {
	document.getElementById('iframeBaseConhecimento').src = ctx + "/pages/baseConhecimento/baseConhecimento.load?iframe=true&relacionarConhecimento=S&tarefaAssociada=N";
	Modal.open('modal-requisicao-mudanca-novo-conhecimento', removeModalOverflowClass);
}

function visualizarBaseConhecimento() {
	document.getElementById('iframeBaseConhecimentoView').src = ctx + "/pages/baseConhecimentoView/baseConhecimentoView.load?iframe=true";
	Modal.open('modal-requisicao-mudanca-view-conhecimento', removeModalOverflowClass);
}

// Função chamada em baseConhecimento.js
function fecharBaseConhecimento() {
	Modal.close('modal-requisicao-mudanca-novo-conhecimento');
}

function abrePopupConhecimento(){
	Modal.open('modal-requisicao-mudanca-add-conhecimento', removeModalOverflowClass);
}

function adicionarConhecimento() {
	abrePopupConhecimento();
}

function adicionarConhecimentoMudanca(idBaseConhecimento, titulo){
	var tbl = document.getElementById('tblBaseConhecimento');
	tbl.style.display = '';
	var lastRow = tbl.rows.length;
	var valida = true;
	if (valida && !validaAddLinhaTabelaConhecimento(lastRow, idBaseConhecimento)){
		return;
	}
	
	tabelaRelacionamentoBaseConhecimento.addObject([idBaseConhecimento, titulo], [getBotaoVisualizarMapa(idBaseConhecimento)]);	
	
	document.form.conhecimentosRelacionadosSerializado.value = ObjectUtils.serializeObjects(tabelaRelacionamentoBaseConhecimento.getTableObjects());
	
	Modal.close('modal-requisicao-mudanca-add-conhecimento');
}

function validaAddLinhaTabelaConhecimento(lastRow, id){
	var listaConhecimentos = ObjectUtils.deserializeCollectionFromString(document.form.conhecimentosRelacionadosSerializado.value);
	
	if (lastRow > 1){
		for(var i = 0; i < listaConhecimentos.length; i++){
			if (listaConhecimentos[i].idBaseConhecimento == id){
				alert(i18n_message("citcorpore.comum.registroJaAdicionado"));
				return false;
			}
		}
	} 
	return true;
}

/**
 * Papéis/Responsalbilidades
 */

function adicionarResponsavel(){
	Modal.open('modal-requisicao-mudanca-papel-add-responsabilidade', removeModalOverflowClass);
}

function addResponsavel(id, nome, cargo, tel, email ){
	var obj = new CIT_RequisicaoMudancaResponsavelDTO();

	if ((cargo == "") || (cargo == undefined)) {
		cargo = "N/A"
	}

	if ((tel == "") || (tel == "undefined-undefined")) {
		tel = "N/A"
	}

	if ((email == "") || (email == undefined)) {
		email = "N/A"
	}

	document.getElementById('responsavel#idResponsavel').value = id;
	document.getElementById('responsavel#nomeResponsavel').value = nome;
	document.getElementById('responsavel#nomeCargo').value = cargo;
	document.getElementById('responsavel#telResponsavel').value = tel;
	document.getElementById('responsavel#emailResponsavel').value = email;
	document.getElementById('responsavel#papelResponsavel').value = prompt(i18n_message("citcorpore.comum.papel"), "");

	HTMLUtils.addRow('tblResponsavel', document.form, 'responsavel', obj, [ "", "idResponsavel", "nomeResponsavel", "nomeCargo", "telResponsavel", "emailResponsavel", "papelResponsavel" ],
			[ "idResponsavel" ], null, [ gerarImgDelResponsavel ], null, null, false);

	Modal.close('modal-requisicao-mudanca-papel-add-responsabilidade');
}


function gerarImgDelResponsavel(row, obj) {

	var linkExcluir = '<a title="' + i18n_message("citcorpore.comum.excluir")
			+ '" onclick="deleteLinha(\'tblResponsavel\', this.parentNode.parentNode.rowIndex);"  style="cursor: pointer;" class=\"btn-action glyphicons remove_2 btn-default\"><i></i></a>';

	row.cells[0].innerHTML = linkExcluir;
};

function serializaResponsavel(){
	var responsavel = HTMLUtils.getObjectsByTableId('tblResponsavel');
	document.form.responsavel_serialize.value =  ObjectUtils.serializeObjects(responsavel);
}


function LOOKUP_RESPONSAVEL_select(id, desc) {
	var str = desc.split('-');
	addResponsavel(id, str[0], str[1], str[2] + "-" + str[3], str[4]);
}


/**
 * Histórico de Mudança
 */

function loadHistoricoMudanca() {
	document.form.fireEvent('mostraHistoricoMudanca');
	Modal.open('modal-requisicao-mudanca-historico');
}

function restaurarHistorico(id){
	document.formHistoricoMudanca.idHistoricoMudanca.value = id;
	if(confirm(i18n_message("itemConfiguracaoTree.restaurarVersao")))
		document.form.fireEvent("restaurarBaseline");
}

function onClickTrTableHistoricoMudanca(that) {
	var s = $(that).attr('id').split('-');
	if(s[0]=="even")
		$( "#sel-" + s[1] ).toggle();
	else if(s[0]=="evenM")
		$( "#selM-" + s[1] ).toggle();
	else if(s[0]=="evenP")
		$( "#selP-" + s[1] ).toggle();
}

/**
 * Anexos
 */

function abrirAnexosRequisicaoMudanca() {
	document.form.fireEvent("verificarParametroAnexos");
	Modal.open('modal-requisicao-mudanca-anexos', removeModalOverflowClass);
}


/**
 * Ocorrências
 */

function abrirOcorrenciasRequisicaoMudanca() {
	document.formOcorrenciaMudanca.clear();
	document.formOcorrenciaMudanca.idRequisicaoMudanca.value = document.form.idRequisicaoMudanca.value;
	document.formOcorrenciaMudanca.fireEvent('load');
	document.getElementById('divRelacaoOcorrencias').innerHTML = i18n_message("citcorpore.comum.aguardecarregando");
	Modal.open('modal-requisicao-mudanca-ocorrencias', removeModalOverflowClass);
}

function salvarOcorrenciaRequisicaoMudanca() {
	document.formOcorrenciaMudanca.descricao.value = document.formOcorrenciaMudanca.descricao1.value;
	if (document.getElementById("idOcorrencia").value != null && document.getElementById("idOcorrencia").value != "") {
		alert(i18n_message("gerenciaservico.suspensaosolicitacao.validacao.alteraregistroocorrencia"));
	} else {
		document.formOcorrenciaMudanca.save();
	}
}

function abrirPopupCadastroCategoriaOcorrencia() {
	document.getElementById('iframeOcorrenciasReqMudancaCategoria').src = ctx + "/pages/categoriaOcorrencia/categoriaOcorrencia.load?iframe=true";
	Modal.open('modal-requisicao-mudanca-ocorrencias-nova-categoria', removeModalOverflowClass);
}

function abrirPopupCadastroOrigemOcorrencia() {
	document.getElementById('iframeOcorrenciasReqMudancaOrigem').src = ctx + "/pages/origemOcorrencia/origemOcorrencia.load?iframe=true";
	Modal.open('modal-requisicao-mudanca-ocorrencias-nova-origem', removeModalOverflowClass);
}

function LOOKUP_CATEGORIA_OCORRENCIA_select(id, desc) {
	$('#idCategoriaOcorrencia').val(id);
	$('#nomeCategoriaOcorrencia').val(desc);
	Modal.close('modal-requisicao-mudanca-ocorrencias-add-categoria');
}

function LOOKUP_ORIGEM_OCORRENCIA_select(id, desc) {
	$('#idOrigemOcorrencia').val(id);
	$('#nomeOrigemOcorrencia').val(desc);
	Modal.close('modal-requisicao-mudanca-ocorrencias-add-origem');
}


/**
 * COMUM
 */

function removeModalOverflowClass() {
	$(this).removeClass("modal-overflow");
	$(this).addClass("t5");
}

function collapseWidget(that) {
	closeAllCollapseWidget();
	$(that).parent().children('.widget-body').collapse('toggle');
}

function openCollapseWidget(that) {
	if($(that).attr('data-collapse-closed') == 'true') {
		closeAllCollapseWidget();
		$(that).children('.widget-body').collapse('toggle');
	}
}

function closeAllCollapseWidget() {
	$('.widget.dentro').each(function(indice, elemento) {
		if($(elemento).attr('data-collapse-closed') == 'false') {
			$(elemento).children('.widget-body').collapse('toggle');
		}
	});
}

function setValorTextArea(id, texto, isWysi) {
	if (isWysi == "S") {
		$(id).data("wysihtml5").editor.setValue(texto);
	} else {
		$(id).html(texto);
	}
}

function fecharMsgInsercao() {
	fechar();
}

function desabilitaEditar(){
	$(".edicao").hide();
}