/*
* The MIT License
*
* Copyright (c) 2015, Sebastian Sdorra
*
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
*/

'use strict';

/**
* @ngdoc object
* @name adf.locale#adfLocale
* @description
*
* Holds settings and values for framework supported locales
*/
angular.module('adf.locale')
.constant('adfLocale',
  {
    defaultLocale: 'pt',
    frameworkLocales: {
		'pt': {
			ADF_COMMON_CLOSE: 'Fechar',
			ADF_COMMON_DELETE: 'Remover',
			ADF_COMMON_TITLE: 'Título',
			ADF_COMMON_CANCEL: 'Cancelar',
			ADF_COMMON_APPLY: 'Aplicar',
			ADF_COMMON_EDIT_DASHBOARD: 'Editar dashboard',
			ADF_EDIT_DASHBOARD_STRUCTURE_LABEL: 'Estrutura',
			ADF_DASHBOARD_TITLE_TOOLTIP_MENU: 'Exibir/Esconder menu',
			ADF_DASHBOARD_TITLE_TOOLTIP_ADD: 'Adicionar novo widget',
			ADF_DASHBOARD_TITLE_TOOLTIP_SAVE: 'Salvar alterações',
			ADF_DASHBOARD_TITLE_TOOLTIP_EDIT_MODE: 'Habilitar modo edição',
			ADF_DASHBOARD_TITLE_TOOLTIP_UNDO: 'Desfazer alterações',
			ADF_WIDGET_ADD_HEADER: 'Adicionar novo widget',
			ADF_WIDGET_DELETE_CONFIRM_MESSAGE: 'Você tem certeza que deseja remover este widget?',
			ADF_WIDGET_TOOLTIP_REFRESH: 'Recarregar conteúdo do widget',
			ADF_WIDGET_TOOLTIP_TOGGLE_FILTER: 'Exibir/Esconder filtros',
			ADF_WIDGET_TOOLTIP_MOVE: 'Alterar posição do widget',
			ADF_WIDGET_TOOLTIP_COLLAPSE: 'Esconder widget',
			ADF_WIDGET_TOOLTIP_EXPAND: 'Exibir widget',
			ADF_WIDGET_TOOLTIP_EDIT: 'Editar configurações do widget',
			ADF_WIDGET_TOOLTIP_FULLSCREEN: 'Tela cheia',
			ADF_WIDGET_TOOLTIP_REMOVE: 'Remover widget',
			ADF_WIDGET_EMPTY: 'Nenhum widget foi encontrado',
			ADF_WIDGET_ERRO: 'Erro'
		},
		'en': {
			ADF_COMMON_CLOSE: 'Close',
			ADF_COMMON_DELETE: 'Delete',
			ADF_COMMON_TITLE: 'Title',
			ADF_COMMON_CANCEL: 'Cancel',
			ADF_COMMON_APPLY: 'Apply',
			ADF_COMMON_EDIT_DASHBOARD: 'Edit dashboard',
			ADF_EDIT_DASHBOARD_STRUCTURE_LABEL: 'Structure',
			ADF_DASHBOARD_TITLE_TOOLTIP_MENU: 'Show/Hide menu',
			ADF_DASHBOARD_TITLE_TOOLTIP_ADD: 'Add new widget',
			ADF_DASHBOARD_TITLE_TOOLTIP_SAVE: 'Save changes',
			ADF_DASHBOARD_TITLE_TOOLTIP_EDIT_MODE: 'Enable edit mode',
			ADF_DASHBOARD_TITLE_TOOLTIP_UNDO: 'Undo changes',
			ADF_WIDGET_ADD_HEADER: 'Add new widget',
			ADF_WIDGET_DELETE_CONFIRM_MESSAGE: 'Are you sure you want to delete this widget ?',
			ADF_WIDGET_TOOLTIP_REFRESH: 'Reload widget Content',
			ADF_WIDGET_TOOLTIP_TOGGLE_FILTER: 'Expand/Collapse filters',
			ADF_WIDGET_TOOLTIP_MOVE: 'Change widget location',
			ADF_WIDGET_TOOLTIP_COLLAPSE: 'Collapse widget',
			ADF_WIDGET_TOOLTIP_EXPAND: 'Expand widget',
			ADF_WIDGET_TOOLTIP_EDIT: 'Edit widget configuration',
			ADF_WIDGET_TOOLTIP_FULLSCREEN: 'Fullscreen widget',
			ADF_WIDGET_TOOLTIP_REMOVE: 'Remove widget',
			ADF_WIDGET_EMPTY: 'No widget was found',
			ADF_WIDGET_ERRO: 'Error'
		},
		'es': {
			ADF_COMMON_CLOSE: 'Cerca',
			ADF_COMMON_DELETE: 'Eliminar',
			ADF_COMMON_TITLE: 'Título',
			ADF_COMMON_CANCEL: 'Cancelar',
			ADF_COMMON_APPLY: 'Aplicar',
			ADF_COMMON_EDIT_DASHBOARD: 'Modificar dashboard',
			ADF_EDIT_DASHBOARD_STRUCTURE_LABEL: 'Estructura',
			ADF_DASHBOARD_TITLE_TOOLTIP_MENU: 'Visualizar/Ocultar menú',
			ADF_DASHBOARD_TITLE_TOOLTIP_ADD: 'Añadir nuevo widget',
			ADF_DASHBOARD_TITLE_TOOLTIP_SAVE: 'Guardar los cambios',
			ADF_DASHBOARD_TITLE_TOOLTIP_EDIT_MODE: 'Activar el modo de edición',
			ADF_DASHBOARD_TITLE_TOOLTIP_UNDO: 'Deshacer los cambios',
			ADF_WIDGET_ADD_HEADER: 'Añadir nuevo widget',
			ADF_WIDGET_DELETE_CONFIRM_MESSAGE: '¿Está seguro de que desea eliminar este widget?',
			ADF_WIDGET_TOOLTIP_REFRESH: 'Actualizar contenido del widget',
			ADF_WIDGET_TOOLTIP_TOGGLE_FILTER: 'Visualizar/Ocultar filtros',
			ADF_WIDGET_TOOLTIP_MOVE: 'Cambio de posición del widget',
			ADF_WIDGET_TOOLTIP_COLLAPSE: 'Ocultar widget',
			ADF_WIDGET_TOOLTIP_EXPAND: 'Visualizar widget',
			ADF_WIDGET_TOOLTIP_EDIT: 'Editar la configuración del widget',
			ADF_WIDGET_TOOLTIP_FULLSCREEN: 'Pantalla completa',
			ADF_WIDGET_TOOLTIP_REMOVE: 'Eliminar widget',
			ADF_WIDGET_EMPTY: 'No se encontró widget',
			ADF_WIDGET_ERRO: 'Error'
		}
    }
  }
);
