/* *
 * The MIT License
 *
 * Copyright (c) 2015, Sebastian Sdorra
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
'use strict';

angular.module('panel-smart-decisions', ['adf', 'LocalStorageModule'])
.controller('panelSmartDecisionsCtrl', function($scope, localStorageService){
	var name = 'panel-smart-decisions';
	var model = localStorageService.get(name);

	if (!model) {
		// set default model for demo purposes
		model = {
			title: i18n_message("citcorpore.comum.smartDecisions"),
			structure: "12/4-4-4",
			rows: [{
				columns: [{
					styleClass: "col-md-12",
					widgets: []
				}]
			},
			{
				columns: [{
					styleClass: "col-md-4",
					widgets: []
				},
				{
					styleClass: "col-md-4",
					widgets: []
				},
				{
					styleClass: "col-md-4",
					widgets: []
				}]
			}]
		};
	}
	
	$scope.name = name;
	$scope.model = model;
	$scope.collapsible = true;
	$scope.maximizable = true;
	$scope.categories = true;
	
	$scope.widgetFilter = function(w, t, m){
		var exists = false;
		if (t === 'smart-report') {
			angular.forEach($scope.model.rows, function(row, rowKey){
				angular.forEach(row.columns, function(column, columnKey){
					angular.forEach(column.widgets, function(widget, widgetKey){
						if (widget.idSmartReport === w.idSmartReport) {
							exists = true;
						}
					});
				});
			});
			
			return exists === false;
		} else {
			angular.forEach($scope.model.rows, function(row, rowKey){
				angular.forEach(row.columns, function(column, columnKey){
					angular.forEach(column.widgets, function(widget, widgetKey){
						if (widget.type === t) {
							exists = true;
						}
					});
				});
			});
			
			return exists === false;
		}
	};
	
	$scope.$on('adfDashboardChanged', function (event, name, model) {
		localStorageService.set(name, model);
		
		document.formController.panel.value = name;
		document.formController.model.value = JSON.stringify(model);
		document.formController.fireEvent("saveUserConfigByPanel");
	});
	
	angular.element(document).ready(function () {
		DEFINEALLPAGES_atribuiCaracteristicasCitAjaxForm($("#formSocketIO")[0], function() {
			$("#formSocketIO")[0].fireEvent("addListeners");
		});
	});
});
