/*
 * The MIT License
 *
 * Copyright (c) 2015, Sebastian Sdorra
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
'use strict';

angular.module('smartDecisions', [
	'ui.bootstrap',
	'adf',
	'adf.structures.base',
	'adf.widget.linklist',
	'adf.widget.solicitacoes-por-servico',
	'adf.widget.dashboard-processos',
	'adf.widget.dashboard-solicitacoes',
	//'adf.widget.dashboard-usuarios',
	'adf.widget.itens-configuracao-softwares',
	'adf.widget.smart-report',
	'LocalStorageModule',
	'panel-acesso-rapido',
	'panel-smart-decisions',
	'ngRoute'
])
.config(function(dashboardProvider, $routeProvider, localStorageServiceProvider){
	dashboardProvider.widgetsPath('widgets/');
	localStorageServiceProvider.setPrefix('adf');
	
	if (locale == undefined) {
		locale = "pt";
	}
	
	dashboardProvider.setLocale(locale);

	$routeProvider.when('/acesso-rapido', {
		templateUrl: 'partials/acesso-rapido.html',
		controller: 'panelAcessoRapidoCtrl'
	}).when('/smart-decisions', {
		templateUrl: 'partials/smart-decisions.html',
		controller: 'panelSmartDecisionsCtrl'
	});
})
.controller('navigationCtrl', function($scope, $location){
	$scope.navClass = function(page) {
		var currentRoute = $location.path().substring(1) || 'acesso-rapido';
		
		//TODO disparar ação de alteração de rota
		
		return page === currentRoute || new RegExp(page).test(currentRoute) ? 'active' : '';
	};
});