/* *
 * The MIT License
 *
 * Copyright (c) 2015, Sebastian Sdorra
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

'use strict';

angular.module('adf.widget.dashboard-processos', ['adf.provider'])
.config(["dashboardProvider", function(dashboardProvider){
	dashboardProvider.widget('dashboard-processos', {
		idWidget: 1,
		title: i18n_message("smartDecisions.dashboardProcessos.titulo"),
		description: i18n_message("smartDecisions.dashboardProcessos.descricao") + ".",
		image: cit_ctx + "/imagens/smart-decisions/Graph-02-128.png",
		templateUrl: '{widgetsPath}/dashboard-processos/src/view.jsp',
		controller: ["$scope", function($scope){
			angular.element(document).ready(function () {
				DEFINEALLPAGES_atribuiCaracteristicasCitAjaxForm($("#formDashboardProcessos")[0], function() {
					$scope.loading = true;
					$("#formDashboardProcessos")[0].fireEvent("dashboardProcessos");
				});
			});
			
			$scope.loading = false;
			
			$scope.calendar = {
				opened: false,
				model : new Date(),
				dateFormat: 'MM/yyyy',
				dateOptions: { 
					minMode: 'month'
				},
				open: function() {
					$scope.calendar.opened = true;
				}
			};
			
			$scope.today = function() {
				$scope.calendar.model = new Date();
			};
			
			$scope.clear = function() {
				$scope.calendar.model = null;
			};
			
			$scope.build = function(t, d, o) {
				$scope.loading = false;
				$scope.$apply();
				
				var data = JSON.parse(d);
				var options = JSON.parse(o);
				
				$.each(data.datasets, function(i, val) {
					data.datasets[i].backgroundColor = UtilSmartReport.randomColor();
				});
				
				options.tooltips = {
					mode : "label",
					callbacks: {
						beforeTitle: function() {
							return i18n_message("citcorpore.texto.tempo.Dia") + ": ";
						}
					}
				};
				
				$("#dashboard-processos .filter").slideUp(function() {
					if ($scope.chart != undefined) {
						$scope.chart.destroy();
					}
					
					$scope.chart = new Chart($("#formDashboardProcessos #canvas-dashboard-processos")[0].getContext("2d"), {
						type : t,
						data : data,
						options : options
					});
				});
			};
			
			$scope.generate = function(s) {
				if (!$scope.loading) {
					if (DEFINEALLPAGES_validarForm($("#formDashboardProcessos")[0])) {
						$scope.loading = true;
						$("#formDashboardProcessos")[0].fireEvent("dashboardProcessos");
					}
				}
			};
		}],
		isEditable : false,
		hasFilter : true,
		reload : true,
		category: i18n_message("smartDecisions.widgets")
	});
}]);