/* *
 * The MIT License
 *
 * Copyright (c) 2015, Sebastian Sdorra
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

'use strict';

angular.module('adf.widget.dashboard-solicitacoes', ['adf.provider'])
.config(["dashboardProvider", function(dashboardProvider){
	dashboardProvider.widget('dashboard-solicitacoes', {
		idWidget: 5,
		title: i18n_message("smartDecisions.dashboardSolicitacoes.titulo"),
		description: i18n_message("smartDecisions.dashboardSolicitacoes.descricao") + ".",
		image: cit_ctx + "/imagens/smart-decisions/Table-128.png",
		templateUrl: '{widgetsPath}/dashboard-solicitacoes/src/view.jsp',
		controller: ["$scope", "$interval", "$window", function($scope, $interval, $window){
			angular.element(document).ready(function () {
				DEFINEALLPAGES_atribuiCaracteristicasCitAjaxForm($("#formDashboardSolicitacoes")[0], function() {
					$("#formDashboardSolicitacoes")[0].fireEvent("dashboardSolicitacoes");
					
					/*$interval(function() {
						$("#formDashboardSolicitacoes")[0].fireEvent("dashboardSolicitacoes");
					}, 5000);*/
				});
				
				if (window.WebSocket) {
					$scope.ws = new WebSocket("ws://" + window.location.host + cit_ctx + "/websocket/dashboardSolicitacoes");
					
					$scope.ws.onmessage = function(event) {
						$scope.build(event.data);
					};
					
					$scope.ws.onerror = function(event) {
						console.log('Error: WebSocket not supported by the server');
					};
					
					$scope.$on('adfWidgetRemovedFromColumn', function() {
						$scope.ws.close();
						$scope.ws = undefined;
					});
				} else {
					console.log('Error: WebSocket not supported by the browser');
				}
			});
			
			$scope.ws = undefined;
			$scope.data = [];
			
			$scope.build = function(d) {
				$scope.data = JSON.parse(d);
				$scope.$apply();
			};
		}],
		isEditable : false,
		hasFilter : false,
		reload : true,
		category: i18n_message("smartDecisions.widgets")
	});
}]);