/* *
 * The MIT License
 *
 * Copyright (c) 2015, Sebastian Sdorra
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

'use strict';

angular.module('adf.widget.dashboard-usuarios', ['adf.provider'])
.config(["dashboardProvider", function(dashboardProvider){
	dashboardProvider.widget('dashboard-usuarios', {
		title: i18n_message("smartDecisions.dashboardUsuarios.titulo"),
		description: i18n_message("smartDecisions.dashboardUsuarios.descricao") + ".",
		templateUrl: '{widgetsPath}/dashboard-usuarios/src/view.jsp',
		controller: ["$scope", function($scope){
			var url = "http://" + hostname + ":3000";
			var socket =  io.connect(url);
			socket.on('connect', function() {
				// exemplo para outras implementações
				// disparado quando a conexão é realizada
			});
			socket.on('message', function(data, ackServerCallback) {
				// exemplo para outras implementações
				// disparado pelo lado server, no método AckRequest.sendAckData
			});
			socket.on('disconnect', function() {
				// exemplo para outras implementações
				// disparado quando a conexão é encerrada
			});
			
			socket.on('setDataDashboardUsuarios', function(d, ackServerCallback, arg1) {
				$scope.data = JSON.parse(d.json);
				$scope.$apply();
			});
			
			var jsonObject = {'@class': 'br.com.centralit.citcorpore.util.DataSocketIO'};
			socket.emit('registerClientDashboardUsuarios', jsonObject, function(arg1, arg2) {
				
			});
			
			/*$scope.sendMessage = function() {
				var jsonObject = {'@class': 'br.com.centralit.citcorpore.util.DataSocketIO'};
				socket.emit('registerClientDashboardUsuarios', jsonObject, function(arg1, arg2) {
					
				});
			}
			
			$scope.sendMessage();*/
		}],
		isEditable : false,
		hasFilter : false,
		reload : true,
		category: i18n_message("menu.gerencia.usuarios")
	});
}]);