/* *
 * The MIT License
 *
 * Copyright (c) 2015, Sebastian Sdorra
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

'use strict';

angular.module('adf.widget.itens-configuracao-softwares', ['adf.provider'])
.config(["dashboardProvider", function(dashboardProvider){
	dashboardProvider.widget('itens-configuracao-softwares', {
		idWidget: 4,
		title: i18n_message("smartDecisions.softwaresInstalados.titulo"),
		description: i18n_message("smartDecisions.softwaresInstalados.descricao") + ".",
		image: cit_ctx + "/imagens/smart-decisions/Bullets-128.png",
		templateUrl: '{widgetsPath}/itens-configuracao-softwares/src/view.jsp',
		controller: ["$scope", function($scope){
			angular.element(document).ready(function () {
				DEFINEALLPAGES_atribuiCaracteristicasCitAjaxForm($("#formItensConfiguracaoSoftwares")[0], function() {
					$scope.loading = true;
					$("#formItensConfiguracaoSoftwares")[0].fireEvent("itensConfiguracaoSoftwares");
				});
			});
			
			$scope.loading = false;
			$scope.ics = [];
			
			$scope.calendar = {
				opened: false,
				model : new Date(),
				dateFormat: 'MM/yyyy',
				dateOptions: { 
					minMode: 'month'
				},
				open: function() {
					$scope.calendar.opened = true;
				}
			};
			
			$scope.today = function() {
				$scope.calendar.model = new Date();
			};
			
			$scope.clear = function() {
				$scope.calendar.model = null;
			};
			
			$scope.build = function(d) {
				$scope.loading = false;

				$("#itens-configuracao-softwares .filter").slideUp(function() {
					$scope.ics = JSON.parse(d);;
					$scope.$apply();
				});
			};
			
			$scope.generate = function(s) {
				if (!$scope.loading) {
					if (DEFINEALLPAGES_validarForm($("#formItensConfiguracaoSoftwares")[0])) {
						$scope.loading = true;
						$("#formItensConfiguracaoSoftwares")[0].fireEvent("itensConfiguracaoSoftwares");
					}
				}
			};
		}],
		isEditable : false,
		hasFilter : true,
		reload : true,
		category: i18n_message("smartDecisions.widgets")
	});
}]);