/* *
 * The MIT License
 *
 * Copyright (c) 2015, Sebastian Sdorra
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

'use strict';

angular.module('adf.widget.smart-report', ['adf.provider'])
.config(["dashboardProvider", function(dashboardProvider){
	dashboardProvider.widget('smart-report', {
		idSmartReport: null,
		title: 'title',
		description: 'description',
		image: cit_ctx + "/imagens/smart-decisions/Braces-01-128.png",
		templateUrl: '{widgetsPath}/smart-report/src/view.jsp',
		controller: ["$scope", "$compile", function($scope, $compile){
			$scope.$compile = $compile;
			$scope.idSmartReport = $scope.$parent.model.idSmartReport;
			
			$scope.element;
			$scope.dt = [];
			$scope.elements = [];
			
			$scope.today = function() {
				if ($scope.element !== undefined) {
					$scope.dt[$scope.element] = new Date();
				}
			};
			
			$scope.today();

			$scope.clear = function() {
				if ($scope.element !== undefined) {
					$scope.dt[$scope.element] = null;
				}
			};

			$scope.dateOptions = {
				//dateDisabled: disabled,
				formatYear: 'yyyy',
				maxDate: new Date(new Date().getFullYear()+10, 12, 31),
				startingDay: 1
			};

			$scope.open = function(uuid) {
				$scope.element = uuid;
				
				if ($scope.elements[uuid] == undefined) {
					$scope.elements[uuid] = { opened : false };
				}
				$scope.elements[uuid].opened = true;
			};

			$scope.setInitialDate = function(element, year, month, day) {
				if (element !== undefined) {
					$scope.dt[element] = new Date(year, month, day);
				}
			};
			
			$scope.setDate = function(year, month, day) {
				if ($scope.element !== undefined) {
					$scope.dt[$scope.element] = new Date(year, month, day);
				}
			};

			$scope.formats = ['dd/MM/yyyy', 'MM/dd/yyyy'];
			
			if (locale == "en") {
				$scope.format = $scope.formats[1];
			} else {
				$scope.format = $scope.formats[0];
			}
			
  			//TODO funções de controle do widget
  			angular.element(document).ready(function () {
  				var _id = $scope.$parent.model.idSmartReport;
  				DEFINEALLPAGES_atribuiCaracteristicasCitAjaxForm($(UtilSmartReport.formSelector(_id))[0], function() {
  					$(UtilSmartReport.formSelector(_id))[0].idSmartReport.value = _id;
  					$(UtilSmartReport.formSelector(_id))[0].fireEvent("loadReport");
  				});
  			});
		}],
		isEditable : false,
		reload : true,
		hasFilter : true,
		category: i18n_message("smartReports.titulo")
	});
}]);