/* *
 * The MIT License
 *
 * Copyright (c) 2015, Sebastian Sdorra
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

'use strict';

angular.module('adf.widget.solicitacoes-por-servico', ['adf.provider'])
.config(["dashboardProvider", function(dashboardProvider){
	dashboardProvider.widget('solicitacoes-por-servico', {
		idWidget: 2,
		title: i18n_message("smartDecisions.solicitacoesPorServico.titulo"),
		description: i18n_message("smartDecisions.solicitacoesPorServico.descricao") + ".",
		image: cit_ctx + "/imagens/smart-decisions/Pie-Chart-128.png",
		templateUrl: '{widgetsPath}/solicitacoes-por-servico/src/view.jsp',
		controller: ["$scope", function($scope){
			angular.element(document).ready(function () {
				DEFINEALLPAGES_atribuiCaracteristicasCitAjaxForm($("#formSolicitacoesPorServico")[0], function() {
					$scope.loading = true;
					$("#formSolicitacoesPorServico")[0].fireEvent("solicitacoesPorServico");
				});
			});
			
			$scope.data = {};
			$scope.options = {};
			$scope.loading = false;
			$scope.showBackButton = false;
			
			$scope.calendar = {
				dataInicio : {
					open: function() {
						$scope.calendar.dataInicio.opened = true;
					},
					opened: false,
					model : new Date().setMonth(new Date().getMonth() - 1)
				},
				dataFim : {
					open: function() {
						$scope.calendar.dataFim.opened = true;
					},
					opened: false,
					model : new Date()
				},
				dateFormat: 'dd/MM/yyyy',
				dateOptions: {
					maxDate: new Date(new Date().getFullYear()+10, 12, 31),
					startingDay: 1
				}
			};
			
			if (locale == "en") {s
				$scope.calendar.dateFormat = 'MM/dd/yyyy';
			} else {
				$scope.calendar.dateFormat = 'dd/MM/yyyy';
			}
			
			$scope.today = function() {
				if ($scope.calendar.dataInicio.opened) {
					$scope.calendar.dataInicio.model = new Date();
				}
				if ($scope.calendar.dataFim.opened) {
					$scope.calendar.dataFim.model = new Date();
				}
			};
			
			$scope.clear = function() {
				if ($scope.calendar.dataInicio.opened) {
					$scope.calendar.dataInicio.model = null;
				}
				if ($scope.calendar.dataFim.opened) {
					$scope.calendar.dataFim.model = null;
				}
			};
			
			$scope.build = function(t, d, o) {
				$scope.data = JSON.parse(d);
				$scope.options = JSON.parse(o);
				
				$scope.loading = false;
				$scope.$apply();
				
				if (!_.isEmpty($scope.data.datasets)) {
					$.each($scope.data.datasets, function(i, val) {
						$scope.data.datasets[i].backgroundColor = [];
						for (var int = 0; int < $scope.data.datasets[i].data.length; int++) {
							$scope.data.datasets[i].backgroundColor.push(UtilSmartReport.randomColor());
						}
					});
					
					$("#solicitacoes-por-servico .filter").slideUp(function() {
						if ($scope.chart != undefined) {
							$scope.chart.destroy();
						}
						
						var canvas = $("#formSolicitacoesPorServico #canvas-solicitacoes-por-servico")[0];
						var ctx = $("#formSolicitacoesPorServico #canvas-solicitacoes-por-servico")[0].getContext("2d");
						
						$scope.chart = new Chart(ctx, {
							type : t,
							data : $scope.data,
							options : $scope.options
						});
						
						if ($("#formSolicitacoesPorServico #idServicoNegocioSolicitacoesPorServico").attr("value") != "") {
							$scope.showBackButton = true;
						} else {
							$scope.showBackButton = false;
						}
						
						$scope.$apply();
						
						$("#formSolicitacoesPorServico #canvas-solicitacoes-por-servico").on("click", function(e) {
							if ($("#formSolicitacoesPorServico #idServicoNegocioSolicitacoesPorServico").attr("value") == "") {
								var activePoints = $scope.chart.getElementsAtEvent(e);
								
								if (activePoints[0] && activePoints[0]._chart) {
									var index = _.findIndex(activePoints[0]._chart.config.data.labels, function(o) { return o == activePoints[0]._model.label; });
									
									var id = activePoints[0]._chart.config.data.ids[index];
									$("#formSolicitacoesPorServico #idServicoNegocioSolicitacoesPorServico").attr("value", id);
									
									$scope.generate();
								}
							}
						});
					});
				}
			};
			
			$scope.generate = function(s) {
				if (!$scope.loading) {
					if (DEFINEALLPAGES_validarForm($("#formSolicitacoesPorServico")[0])) {
						$scope.loading = true;
						$("#formSolicitacoesPorServico")[0].fireEvent("solicitacoesPorServico");
					}
				}
			};
			
			$scope.back = function() {
				$("#formSolicitacoesPorServico #idServicoNegocioSolicitacoesPorServico").attr("value", "");
				$scope.generate();
			}
		}],
		isEditable : false,
		hasFilter : true,
		reload : true,
		category: i18n_message("smartDecisions.widgets")
	});
}]);