/*
 * The MIT License
 *
 * Copyright (c) 2015, Sebastian Sdorra
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
'use strict';

angular.module('smartDecisionsConfigurations', [
	'ui.bootstrap',
	'ngRoute'
])
.config(function($routeProvider){
	if (locale == undefined) {
		locale = "pt";
	}
	
	$routeProvider.when('/', {
		templateUrl: 'partials/configurations.jsp',
		controller: 'smartDecisionsConfigurationsCtrl'
	}).when('/editWidget/:id', {
		templateUrl: 'partials/editWidget.jsp',
		controller: 'smartDecisionsConfigurationsEditWidgetCtrl'
	}).otherwise({
		redirectTo: '/'
	});
})
.controller('smartDecisionsConfigurationsCtrl', function($scope, $location) {
	$scope.widgets = [];
	
	DEFINEALLPAGES_atribuiCaracteristicasCitAjaxForm(document.formController, function() {
		document.formController.fireEvent("loadConfigurations");
	});
	
	$scope.setWidgets = function(data) {
		$scope.widgets = JSON.parse(data);
		$scope.$apply();
	};
})
.controller('smartDecisionsConfigurationsEditWidgetCtrl', function($scope, $routeParams, $location) {
	$scope.widget = {};
	
	$("#formController #idWidget").attr("value", $routeParams.id);
	
	DEFINEALLPAGES_atribuiCaracteristicasCitAjaxForm(document.formController, function() {
		document.formController.fireEvent("editWidget");
	});
	
	$scope.setWidget = function(data) {
		$scope.widget = JSON.parse(data);
		$scope.$apply();
	};
	
	$scope.addGroup = function() {
		$("#formController #colAllLOOKUP_GRUPO").attr("value", "");
		checkados_LOOKUP_GRUPO = '';
		limpar_LOOKUP_GRUPO();
		
		if ($scope.widget.groups !== undefined && $scope.widget.groups.length > 0) {
			var whereIn = "";
			
			_.forEach($scope.widget.groups, function(group, key) {
				if (whereIn != "") {
					whereIn += ",";
				}
				whereIn += group.id;
			});
			
			document.formGrupos.whereDinamico = "idgrupo not in (" + whereIn + ")";
		} else {
			document.formGrupos.whereDinamico = "";
		}
		
		$('#modal-grupo').modal('show');
	};
	
	$scope.removeGroup = function(g) {
		if ($scope.widget != undefined && $scope.widget.groups != undefined) {
			_.remove($scope.widget.groups, function (group) {
				return group.id === g.id
			});
		}
	};
	
	$scope.save = function() {
		$("#formController #json").attr("value", JSON.stringify($scope.widget));
		document.formController.fireEvent("saveWidget");
	};
	
	$scope.setGroup = function(data) {
		if (data != "") {
			var group = JSON.parse(data);
			
			if ($scope.widget != undefined) {
				if ($scope.widget.groups == undefined) {
					$scope.widget.groups = [];
				}
				
				$scope.widget.groups.push(group);
				
				$scope.$apply();
			}
		}
		
		$('#modal-grupo').modal('hide');
	};
});
