var myDropzone;

$(document).ready(function() {
	/*
	 * Configuração Dropzone
	 */
	DZ.init("");
});

var Navigation = {
	show : function(_this) {
		if ($(_this).attr("data-ref") == "gerenciamento-servicos") {
			$(".base-conhecimento").slideUp();
			$(".faq").slideUp();
			$(".meus-pedidos").slideUp();
			$(".minhas-solicitacoes").slideUp();
			
			$("#formGerenciamentoServicos .breadcrumb .home").trigger("click");
			$(".gerenciamento-servicos").slideDown();
			$("#gerenciamento-servicos").addClass("menuTopSelected");
			$("#meus-pedidos").removeClass("menuTopSelected");
			$("#minhas-solicitacoes").removeClass("menuTopSelected");
		} else if ($(_this).attr("data-ref") == "base-conhecimento") {
			$(".gerenciamento-servicos").slideUp();
			$(".faq").slideUp();
			$(".meus-pedidos").slideUp();
			$(".minhas-solicitacoes").slideUp();
			BaseConhecimento.load();
			$(".base-conhecimento").slideDown();
			
		} else if ($(_this).attr("data-ref") == "faq") {
			$(".base-conhecimento").slideUp();
			$(".gerenciamento-servicos").slideUp();
			$(".meus-pedidos").slideUp();
			$(".minhas-solicitacoes").slideUp();
			
			FAQ.load();
			$(".faq").slideDown();
		} else if ($(_this).attr("data-ref") == "meus-pedidos") {
			$(".base-conhecimento").slideUp();
			$(".gerenciamento-servicos").slideUp();
			$(".faq").slideUp();
			$(".minhas-solicitacoes").slideUp();
			
			MeusPedidos.load();
			$(".meus-pedidos").slideDown();
			$("#gerenciamento-servicos").removeClass("menuTopSelected");
			$("#meus-pedidos").addClass("menuTopSelected");
			$("#minhas-solicitacoes").removeClass("menuTopSelected");
		} else if ($(_this).attr("data-ref") == "minhas-solicitacoes") {
			$(".base-conhecimento").slideUp();
			$(".gerenciamento-servicos").slideUp();
			$(".faq").slideUp();
			$(".meus-pedidos").slideUp();
			
			MinhasSolicitacoes.load();
			$(".minhas-solicitacoes").slideDown();
			$("#gerenciamento-servicos").removeClass("menuTopSelected");
			$("#meus-pedidos").removeClass("menuTopSelected");
			$("#minhas-solicitacoes").addClass("menuTopSelected");
		}
	}
};

var Breadcrumb = {
	add : function(t, a) {
		$(".breadcrumb").children("li").addClass("clickable").removeClass("active");
		$(".breadcrumb").children("li").last().find("a").attr("onclick", a);
		
		$(".breadcrumb").append("<li class='active'><a href='javascript: return false;'>" + t + "</a></li>");
	},
	remove : function(_this) {
		$(_this).parent("li").nextAll().remove();
		$(_this).parent("li").addClass("active").removeClass("clickable");
	}
};

var DZ = {
	init : function(uuid) {
		Dropzone.autoDiscover = false;

		myDropzone = new Dropzone("div.dropzone", {
			url: ctx + "/pages/upload/upload.load?uuid=" + uuid,
			addRemoveLinks : true,
			paramName : "file_uploadAnexos",
			maxFilesize : (parseInt(TAMANHO_MAXIMO_UPLOAD) / (1024*1024)),
			accept: function(file, done) { //Validações ao adicionar um arquivo.
				if (file.size <= 0) {
					done(i18n_message("citcorpore.comum.uploadArquivoMuitoPequeno"));
				} else { done(); }
			}
		});
		
		myDropzone.on("removedfile", function(file) {
			if (!DZ.isDestroying) {
				$.post(ctx + "/pages/uploadExcluir/uploadExcluir.load?uuid=" + uuid, { nameFile: file.name });
			}
		});
	},
	reset : function() {
		DZ.isDestroying = true;
		myDropzone.destroy();
		DZ.isDestroying = false;
	},
	isDestroying : false
}

var GerenciamentoServicos = {
	catalogos : {
		open : function(idCatalogoServico) {
			JANELA_AGUARDE_MENU.show();
			
			$("#idCatalogoServico").attr("value", idCatalogoServico);
			
			document.formGerenciamentoServicos.fireEvent("openCatalogosServico", function() {
				Breadcrumb.add($("#nomeCatalogoServico").attr("value"), 'GerenciamentoServicos.catalogo.back(this);');
			});
		},
		search : function() {
			JANELA_AGUARDE_MENU.show();
			
			document.formGerenciamentoServicos.fireEvent("loadCatalogosServico");
		},
		back : function(_this) {
			JANELA_AGUARDE_MENU.show();
			
			document.formGerenciamentoServicos.fireEvent("loadCatalogosServico", function() {
				Breadcrumb.remove(_this);
			});
		}
	},
	catalogo : {
		servicos : {
			open : function(idServicoNegocio) {
				JANELA_AGUARDE_MENU.show();
				
				$("#idServicoNegocio").attr("value", idServicoNegocio);
				
				document.formGerenciamentoServicos.fireEvent("openServicoNegocio", function() {
					Breadcrumb.add($("#nomeServicoNegocio").attr("value"), 'GerenciamentoServicos.servico.back(this);');
				});
			},
			search : function() {
				JANELA_AGUARDE_MENU.show();
				
				document.formGerenciamentoServicos.fireEvent("searchServicoNegocio");
			}
		},
		avaliacoes : {
			
		},
		informacoes : {
			
		},
		back : function(_this) {
			JANELA_AGUARDE_MENU.show();
			
			$("#idCatalogoServico").attr("value", "");
			$("#nomeCatalogoServico").attr("value", "");
			
			document.formGerenciamentoServicos.fireEvent("loadCatalogosServico", function() {
				Breadcrumb.remove(_this);
			});
		}
	},
	servico : {
		atividades : {
			open : function(idServico, idQuestionario, questionarioObrigatorio) {
				var uuid = UUID.random();
				
				$('#modal-add-service #uuid').attr("value", uuid);
				$('#modal-add-service #idServico').attr("value", idServico);
				$('#modal-add-service #idQuestionario').attr("value", (idQuestionario == undefined ? "" : idQuestionario));
				$('#modal-add-service #questionarioObrigatorio').attr("value", questionarioObrigatorio);
				$('#modal-add-service #questionarioRespondido').attr("value", "false");
				$("#modal-add-service #requestStatus").attr("value", "");

				document.formAddServico.fireEvent("carregaContratosPedido");
				
				if (idQuestionario != undefined) {
					$("#modal-add-service #btn-responder-questionario").prop("disabled", false);
					$("#modal-add-service #btn-responder-questionario").show();
					$("#questionario").attr("src", "../../pages/visualizacaoQuestionario/visualizacaoQuestionario.load?modo=edicao&idQuestionario=" + idQuestionario + "&respostaObrigatoria=" + questionarioObrigatorio);
				} else {
					$("#modal-add-service #btn-responder-questionario").prop("disabled", true);
					$("#modal-add-service #btn-responder-questionario").hide();
				}
				
				//Reinicia a dropzone para limpar os anexos antigos.
				DZ.reset();
				
				DZ.init(uuid);
			},
			validate: function($btn) {
				$btn.text($btn.attr("data-load"));
				$btn.prop("disabled", true);

				if ($("#modal-add-service #idContrato").val() == "") {
					Notification.show("#alert-danger", i18n_message("citcorpore.comum.campo_obrigatorio") + ": " + i18n_message("citcorpore.comum.contrato"), "display:none;", "#modal-add-service .modal-body");
					
					$btn.text($btn.attr("data-orig"));
					$btn.prop("disabled", false);
					
					return false;
				} else if ($("#modal-add-service #solicitacaoObservacao").val() == "") {
					Notification.show("#alert-danger", i18n_message("citcorpore.comum.campo_obrigatorio") + ": " + i18n_message("portal.carrinho.observacao"), "display:none;", "#modal-add-service .modal-body");
					
					$btn.text($btn.attr("data-orig"));
					$btn.prop("disabled", false);
					
					return false;
				} else if ($("#modal-add-service #questionarioObrigatorio").attr("value") == "true" && $("#modal-add-service #questionarioRespondido").attr("value") == "false") {
					Notification.show("#alert-danger", i18n_message("portal.respondaQuestionarioAntesProsseguir"), "display:none;", "#modal-add-service .modal-body");
					
					$btn.text($btn.attr("data-orig"));
					$btn.prop("disabled", false);
					
					return false;
				}

				return true;
			},
			add : function() {
				var $btn = $("#btn-add-servico");
				if(!GerenciamentoServicos.servico.atividades.validate($btn)) {
					return false;
				}

				document.formAddServico.fireEvent("adicionaSolicitacaoServico", function() {
					if ($("#formAddServico #requestStatus").attr("value") == "true") {
						Notification.show("#alert-success", i18n_message("portal.solicitacaoAdicionada"), "display:none;position: absolute;top: 10px;z-index: 9999;left: 10px;right: 10px;", ".alert-container");
						
						$("#modal-add-service").modal('hide');
					} else {
						Notification.show("#alert-danger", i18n_message("portal.naoFoiPossivelRealizarSolicitacao"), "display:none;", "#modal-add-service .modal-body");
					}
					
					$btn.text($btn.attr("data-orig"));
					$btn.prop("disabled", false);
				});
			},
			addAndFinish: function() {
				var $btn = $("#btn-add-servico-and-finish");
				if(!GerenciamentoServicos.servico.atividades.validate($btn)) {
					return false;
				}

				document.formAddServico.fireEvent("adicionaSolicitacaoServico", function() {
					if ($("#formAddServico #requestStatus").attr("value") == "true") {
						Notification.show("#alert-success", i18n_message("portal.solicitacaoAdicionada"), "display:none;position: absolute;top: 10px;z-index: 9999;left: 10px;right: 10px;", ".alert-container");

						$("#modal-add-service").modal('hide');
						Navigation.show($('[data-ref="meus-pedidos"]'));
						setTimeout(function() {
							MeusPedidos.save();
						}, 1000);
					} else {
						Notification.show("#alert-danger", i18n_message("portal.naoFoiPossivelRealizarSolicitacao"), "display:none;", "#modal-add-service .modal-body");
					}
					
					$btn.text($btn.attr("data-orig"));
					$btn.prop("disabled", false);
				});
			},
			search : function() {
				JANELA_AGUARDE_MENU.show();
				
				document.formGerenciamentoServicos.fireEvent("searchAtividades");
			},
			contrato : {
				load : function(_this) {
					$("#formAddServico #idContrato").attr("value", $(_this).find(":selected").attr("value"));
				}
			},
			questionario : {
				save : function() {
					if (!GerenciamentoServicos.servico.atividades.questionario.validate()) {
						return;
					}
					
					if (confirm(i18n_message("portal.servico.confirmQuestionario"))) {
						window.frames["questionario"].getObjetoSerializadoPortalCitsmart($('#modal-add-service #uuid').attr("value"));
						
						$("#modal-add-service #questionarioRespondido").attr("value", "true");
						$("#modal-questionario").modal('hide');
						$("#modal-add-service #btn-responder-questionario").prop("disabled", true);
					}
				},
				validate : function() {
					if (window.frames["questionario"]) {
						try {
							return window.frames["questionario"].validar();
						} catch (e) {
							return true;
						}
					} else {
						return true;
					}
				}
			}
		},
		avaliacao : {
			open : function(idServico) {
				$("#formAvaliacaoServico #idServicoAvaliacao").attr("value", idServico);
				$('#modal-avaliacao-servico').modal('show');
			},
			save : function() {
				var $btn = $("#btn-add-avaliacao-servico");
				
				$btn.text($btn.attr("data-load"));
				$btn.prop("disabled", true);
				
				document.formAvaliacaoServico.fireEvent("saveAvaliacaoServico", function() {
					if ($('#formAvaliacaoServico #requestStatus').attr("value") == "true") {
						Notification.show("#alert-success", i18n_message("portal.obrigadoPelaOpiniao"), "display:none;position: absolute;top: 10px;z-index: 9999;left: 10px;right: 10px;", ".alert-container");
						
						$("#modal-avaliacao-servico").modal("hide");
						
						document.formGerenciamentoServicos.fireEvent("carregaAvaliacoes");
					} else {
						Notification.show("#alert-danger", i18n_message("citcorpore.comum.erroGravacao"), "display:none;", "#modal-avaliacao-servico .modal-body");
					}
					
					$btn.text($btn.attr("data-orig"));
					$btn.prop("disabled", false);
					
					$('#formAvaliacaoServico #requestStatus').attr("value", "");
				});
				
			},
			star : function(_this) {
				var _parent = $(_this).parent();
				var _number = $(_this).attr("data-number");
				
				$("#formAvaliacaoServico #notaAvaliacao").attr("value", _number);
				
				_parent.find(".material-icons").text("star_border");
				for (var i = _number; i >= 1; i--) {
					_parent.find(".material-icons[data-number='" + i + "']").text("star");
				}
			}
		},
		back : function(_this) {
			JANELA_AGUARDE_MENU.show();
			
			$("#idServicoNegocio").attr("value", "");
			$("#nomeServicoNegocio").attr("value", "");
			
			document.formGerenciamentoServicos.fireEvent("openCatalogosServico", function() {
				Breadcrumb.remove(_this);
			});
		}
	}
};

var MeusPedidos = {
	total: 0,
	load : function() {
		JANELA_AGUARDE_MENU.show();
		
		document.formMeusPedidos.fireEvent("loadMeusPedidos");
	},
	save : function() {
		if (confirm(i18n_message("portal.confirmaFinalizacaoSolicitacaoServico"))) {
			JANELA_AGUARDE_MENU.show();
			
			document.formMeusPedidos.fireEvent("saveMeusPedidos", function() {
				if ($('#formMeusPedidos #requestStatus').attr("value") == "true") {
					$("#modal-solicitacoes-criadas").modal('show');
				} else {
					Notification.show("#alert-danger", i18n_message("portal.naoFoiPossivelRealizarSolicitacao") + ($('#formMeusPedidos #requestMessage').attr("value") != "" ? "<br>" + $('#formMeusPedidos #requestMessage').attr("value") : ""), "display:none;position: absolute;top: 10px;z-index: 9999;left: 10px;right: 10px;", ".alert-container");
				}
				
				$('#formMeusPedidos #requestStatus').attr("value", "");
			});
		}
	},
	remove : function(_this) {
		if (confirm(i18n_message("citcorpore.comum.confirmaExclusao"))) {
			JANELA_AGUARDE_MENU.show();
			
			$pedido = $(_this).parents(".pedido");
			
			$("#formMeusPedidos #uuid").attr("value", $pedido.attr("data-uuid"));
			
			document.formMeusPedidos.fireEvent("removePedido", function() {
				if ($('#formMeusPedidos #requestStatus').attr("value") == "true") {
					$("#formMeusPedidos #uuid").attr("value", "");

					if ($("#meus-pedidos-content div.pedido").length <= 0) {
						$("#meus-pedidos-content").html("<div class='row'><div class='col-md-12 text-center'>" + i18n_message("MSG04") + "</div></div>");
					}
				} else {
					Notification.show("#alert-danger", i18n_message("portal.naoFoiPossivelRealizarSolicitacao"), "display:none;position: absolute;top: 10px;z-index: 9999;left: 10px;right: 10px;", ".alert-container");
				}
				
				$('#formMeusPedidos #requestStatus').attr("value", "");
			});
		}
	},
	badge : {
		update : function(q) {
			MeusPedidos.total = q;
			$("#navbar ul.nav li a[data-ref='meus-pedidos'] span.badge").html(q);
		}
	}
};

var MinhasSolicitacoes = {
	load : function(_this) {
		JANELA_AGUARDE_MENU.show();
		
		$("#formMinhasSolicitacoes #paginaAtualSolicitacoes").attr("value", (_this == null || _this == undefined ? 1 : $(_this).attr("data-page")));
		
		document.formMinhasSolicitacoes.fireEvent("loadMinhasSolicitacoes");
	},
	ocorrencia : {
		open : function(idSolicitacaoServico) {
			$("#formRegistroOcorrencia #idSolicitacaoOcorrencia").attr("value", idSolicitacaoServico);
			
			document.formRegistroOcorrencia.fireEvent("carregaRegistroOcorrencia");
		},
		categoria : {
			open : function() {
				$('#modal-categoria-ocorrencia').modal('show');
			}
		},
		origem : {
			open : function() {
				$('#modal-origem-ocorrencia').modal('show');
			}
		},
		save : function() {
			var $btn = $("#btn-add-registro-ocorrencia");
			
			$btn.text($btn.attr("data-load"));
			$btn.prop("disabled", true);
			
			if ($('#formRegistroOcorrencia #idCategoriaOcorrencia').attr("value") == "") {
				Notification.show("#alert-danger", i18n_message("citcorpore.comum.campo_obrigatorio") + ": " + i18n_message("citcorpore.comum.categoria"), "display:none;", "#modal-registro-ocorrencia .modal-body");
				
				$btn.text($btn.attr("data-orig"));
				$btn.prop("disabled", false);
				
				return false;
			}
			
			if ($('#formRegistroOcorrencia #idOrigemOcorrencia').attr("value") == "") {
				Notification.show("#alert-danger", i18n_message("citcorpore.comum.campo_obrigatorio") + ": " + i18n_message("citcorpore.comum.origem"), "display:none;", "#modal-registro-ocorrencia .modal-body");
				
				$btn.text($btn.attr("data-orig"));
				$btn.prop("disabled", false);
				
				return false;
			}
			
			if ($('#formRegistroOcorrencia #ocorrencia').val() == "") {
				Notification.show("#alert-danger", i18n_message("citcorpore.comum.campo_obrigatorio") + ": " + i18n_message("citcorpore.comum.ocorrencia"), "display:none;", "#modal-registro-ocorrencia .modal-body");
				
				$btn.text($btn.attr("data-orig"));
				$btn.prop("disabled", false);
				
				return false;
			}
			
			if ($('#formRegistroOcorrencia #informacoesContato').val() == "") {
				Notification.show("#alert-danger", i18n_message("citcorpore.comum.campo_obrigatorio") + ": " + i18n_message("solicitacaoServico.informacaoContato"), "display:none;", "#modal-registro-ocorrencia .modal-body");
				
				$btn.text($btn.attr("data-orig"));
				$btn.prop("disabled", false);
				
				return false;
			}
			
			document.formRegistroOcorrencia.fireEvent("saveRegistroOcorrencia", function() {
				if ($('#formRegistroOcorrencia #requestStatus').attr("value") == "true") {
					Notification.show("#alert-success", i18n_message("portal.ocorrenciaRegistrada"), "display:none;position: absolute;top: 10px;z-index: 9999;left: 10px;right: 10px;", ".alert-container");
					
					$("#modal-registro-ocorrencia").modal("hide");
				} else {
					Notification.show("#alert-danger", i18n_message("citcorpore.comum.erroGravacao"), "display:none;", "#modal-registro-ocorrencia .modal-body");
				}
				
				$btn.text($btn.attr("data-orig"));
				$btn.prop("disabled", false);
				
				$('#formRegistroOcorrencia #requestStatus').attr("value", "");
			});
		}
	},
	opiniao : {
		open : function(idSolicitacaoServico) {
			$("#formRegistroOpiniao #idSolicitacaoOpiniao").attr("value", idSolicitacaoServico);
		},
		save : function() {
			var $btn = $("#btn-add-registro-opiniao");
			
			$btn.text($btn.attr("data-load"));
			$btn.prop("disabled", true);
			
			if ($('#formRegistroOpiniao #observacoesOpiniao').val() == "") {
				Notification.show("#alert-danger", i18n_message("citcorpore.comum.campo_obrigatorio") + ": " + i18n_message("citcorpore.comum.observacoes"), "display:none;", "#modal-registro-opiniao .modal-body");
				
				$btn.text($btn.attr("data-orig"));
				$btn.prop("disabled", false);
				
				return false;
			}
			
			document.formRegistroOpiniao.fireEvent("saveRegistroOpiniao", function() {
				if ($('#formRegistroOpiniao #requestStatus').attr("value") == "true") {
					Notification.show("#alert-success", i18n_message("portal.obrigadoPelaOpiniao"), "display:none;position: absolute;top: 10px;z-index: 9999;left: 10px;right: 10px;", ".alert-container");
					
					$("#modal-registro-opiniao").modal("hide");
				} else {
					Notification.show("#alert-danger", i18n_message("citcorpore.comum.erroGravacao"), "display:none;", "#modal-registro-opiniao .modal-body");
				}
				
				$btn.text($btn.attr("data-orig"));
				$btn.prop("disabled", false);
				
				$('#formRegistroOpiniao #requestStatus').attr("value", "");
			});
		}
	},
	pesquisaSatisfacao : {
		open : function(idSolicitacaoServico) {
			$("#formPesquisaSatisfacao #idSolicitacaoPesquisaSatisfacao").attr("value", idSolicitacaoServico);
			
			document.formPesquisaSatisfacao.fireEvent("carregaPesquisaSatisfacao");
		},
		save : function() {
			var $btn = $("#btn-add-pesquisa-satisfacao");
			
			$btn.text($btn.attr("data-load"));
			$btn.prop("disabled", true);
			
			if ($('#formPesquisaSatisfacao #notaPesquisaSatisfacao').find(":selected").attr("value") == "") {
				Notification.show("#alert-danger", i18n_message("citcorpore.comum.campo_obrigatorio") + ": " + i18n_message("comentarios.avaliacao"), "display:none;", "#modal-pesquisa-satisfacao .modal-body");
				
				$btn.text($btn.attr("data-orig"));
				$btn.prop("disabled", false);
				
				return false;
			}
			
			if ($('#formPesquisaSatisfacao #comentarioPesquisaSatisfacao').val() == "" && ($('#formPesquisaSatisfacao #notaPesquisaSatisfacao').find(":selected").attr("value") == 1 || $('#formPesquisaSatisfacao #notaPesquisaSatisfacao').find(":selected").attr("value") == 2)) {
				Notification.show("#alert-danger", i18n_message("portal.comenteSuaAvaliacao"), "display:none;", "#modal-pesquisa-satisfacao .modal-body");
				
				$btn.text($btn.attr("data-orig"));
				$btn.prop("disabled", false);
				
				return false;
			}
			
			document.formPesquisaSatisfacao.fireEvent("savePesquisaSatisfacao", function() {
				if ($('#formPesquisaSatisfacao #requestStatus').attr("value") == "true") {
					Notification.show("#alert-success", i18n_message("pesquisasatisfacao.pesquisasatisfacao.mensagemSatisfacao"), "display:none;position: absolute;top: 10px;z-index: 9999;left: 10px;right: 10px;", ".alert-container");
					
					$("#modal-pesquisa-satisfacao").modal("hide");
				} else {
					Notification.show("#alert-danger", i18n_message("citcorpore.comum.erroGravacao"), "display:none;", "#modal-pesquisa-satisfacao .modal-body");
				}
				
				$btn.text($btn.attr("data-orig"));
				$btn.prop("disabled", false);
				
				$('#formPesquisaSatisfacao #requestStatus').attr("value", "");
			});
		}
	}
};

var Notification = {
	_timeout: function() {},
	_lastMessage: '',
	show : function(template, mensagem, style, element) {
		var _lastMessage = template + mensagem + element;
		if(_lastMessage !== Notification._lastMessage) {
			Notification._lastMessage = _lastMessage;

			var template = Template($(template).html(), {
				mensagem : mensagem,
				style : style
			});
			
			$(element).prepend(template);
			$(element + " > .alert").slideDown(function() {
				clearTimeout(Notification._timeout);
				Notification._timeout = window.setTimeout(function() {
					Notification._lastMessage = '';

					$(element + " > .alert").slideUp(function() {
						$(element + " > .alert").remove();
					});
				}, 4000);
			});
		}
	}
};

function LOOKUP_CATEGORIA_OCORRENCIA_select(id, desc) {
	$('#formRegistroOcorrencia #idCategoriaOcorrencia').val(id);
	$('#formRegistroOcorrencia #nomeCategoriaOcorrencia').val(desc);
	
	$('#modal-categoria-ocorrencia').modal('hide');
}

function LOOKUP_ORIGEM_OCORRENCIA_select(id, desc) {
	$('#formRegistroOcorrencia #idOrigemOcorrencia').val(id);
	$('#formRegistroOcorrencia #nomeOrigemOcorrencia').val(desc);
	
	$('#modal-origem-ocorrencia').modal('hide');
}

var BaseConhecimento = {
	load : function(_this) {
		JANELA_AGUARDE_MENU.show();
		
		$("#paginaAtualBaseConhecimento").attr("value", (_this == null || _this == undefined ? 1 : $(_this).attr("data-page")));
		
		document.formBaseConhecimento.fireEvent("loadBaseConhecimento");
	},
	open : function(id) {
		window.open(URL_SISTEMA + '/pages/baseConhecimentoView/baseConhecimentoView.load?iframeView=true&idBaseConhecimento=' + id);
	}
};

var FAQ = {
	load : function(_this) {
		JANELA_AGUARDE_MENU.show();
		
		$("#paginaAtualFAQ").attr("value", (_this == null || _this == undefined ? 1 : $(_this).attr("data-page")));
		
		document.formFAQ.fireEvent("loadFAQ");
	}
};

/*
 * Listeners
 */

$('#back-button').on('click', function() {
	var $btn = $(this).button('loading');
	
	setTimeout(function() {
		$btn.button('reset');
	}, 4000);
});

$("body").on("click", ".solicitacao-mostrar-mais-detalhes", function() {
	var that = $(this);
	var el = $(this).parents(".box-generic").find(".content-row");
	
	if (el.hasClass("opened")) {
		el.animate({
			height: "41px"
		}, 400, function(){
			el.removeClass("opened");
			el.css("height", "41px");
			that.find(".material-icons").text("expand_more");
		});
	} else {
		var autoHeight = el.css('height', 'auto').height();
		el.height("41px");
		
		el.stop().animate({ height: autoHeight }, 400, function() {
			el.addClass("opened");
			el.css("height", "auto");
			that.find(".material-icons").text("expand_less");
		});
	}
});

$('.nav a:not(.dropdown-toggle)').on('click', function() {
	if ($(".navbar-toggle").is(":visible")) {
		$('.navbar-toggle').click();
	}
});

$(".gerenciamento-servicos-nav li a").off("click");
$("body").on("click", ".gerenciamento-servicos-nav li a", function(e) {
	_ref = $(this).attr("data-ref");
	
	$(".gerenciamento-servicos-nav li").removeClass("active");
	$(this).parent("li").addClass("active");
	
	$(".gerenciamento-servicos-nav-content > div").hide();
	if (!$(".gerenciamento-servicos-nav-content div[data-ref='" + _ref + "']").is(":visible")) {
		$(".gerenciamento-servicos-nav-content div[data-ref='" + _ref + "']").show();
	}
});

$('#formGerenciamentoServicos').on('keypress', function(e) {
	var keyCode = e.keyCode || e.which;
	if (keyCode === 13) {
		if ($("#idServicoNegocio").attr("value") != "") {
			GerenciamentoServicos.servico.atividades.search();
		} else if ($("#idCatalogoServico").attr("value") != "") {
			GerenciamentoServicos.catalogo.servicos.search();
		} else {
			GerenciamentoServicos.catalogos.search();
		}
		
		return false;
	}
});

$('#formBaseConhecimento').on('keypress', function(e) {
	var keyCode = e.keyCode || e.which;
	if (keyCode === 13) {
		BaseConhecimento.load();
		return false;
	}
});

$('#formFAQ').on('keypress', function(e) {
	var keyCode = e.keyCode || e.which;
	if (keyCode === 13) {
		FAQ.load();
		return false;
	}
});

$('#formMinhasSolicitacoes').on('keypress', function(e) {
	var keyCode = e.keyCode || e.which;
	if (keyCode === 13) {
		MinhasSolicitacoes.load();
		return false;
	}
});

$('#modal-add-service').on('hide.bs.modal', function (e) {
	$('#modal-add-service #uuid').attr("value", "");
	$('#modal-add-service #idServico').attr("value", "");
	$('#modal-add-service #idContrato').attr("value", "");
	$('#modal-add-service #idQuestionario').attr("value", "");
	$('#modal-add-service #questionarioObrigatorio').attr("value", "");
	$('#modal-add-service #questionarioObrigatorio').attr("value", "false");
	$('#modal-add-service #solicitacaoObservacao').val("");
	$('#modal-add-service #idContratoSelect').find('option').remove();
	$('#modal-add-service .contrato-select').addClass("dn");
	
	$("#modal-add-service #btn-responder-questionario").prop("disabled", true);
	$("#modal-add-service #btn-responder-questionario").hide();
	
	$("#modal-add-service #requestStatus").attr("value", "");
	
	$("#questionario").attr("src", "about:blank");
});

$('#modal-solicitacoes-criadas').on('hide.bs.modal', function (e) {
	$("#modal-solicitacoes-criadas #solicitacoes-criadas-content").html("");
});

$('#modal-registro-ocorrencia').on('hide.bs.modal', function (e) {
	$("#modal-registro-ocorrencia #idOcorrencia").attr("value", "");
	$("#modal-registro-ocorrencia #idSolicitacaoOcorrencia").attr("value", "");
	$("#modal-registro-ocorrencia #idCategoriaOcorrencia").attr("value", "");
	$("#modal-registro-ocorrencia #idOrigemOcorrencia").attr("value", "");
	
	$("#modal-registro-ocorrencia #nomeCategoriaOcorrencia").val("");
	$("#modal-registro-ocorrencia #nomeOrigemOcorrencia").val("");
	$("#modal-registro-ocorrencia #descricaoOcorrencia").val("");
	$("#modal-registro-ocorrencia #ocorrencia").val("");
	$("#modal-registro-ocorrencia #informacoesContatoOcorrencia").val("");
	$("#modal-registro-ocorrencia #notificarResponsavelOcorrencia").prop('checked', false);
});

$('#modal-avaliacao-servico').on('hide.bs.modal', function (e) {
	$("#formAvaliacaoServico #notaPesquisaSatisfacao").attr("value", "5");
	$("#formAvaliacaoServico #comentarioAvaliacao").val("");
	$("#formAvaliacaoServico").find(".material-icons").text("star");
});
