addEvent(window, "load", load, false);

var sample;
var parametros;
var sql;
var script;
var jsp;
var template;

function load() {
	document.form.afterRestore = function() {
		$("#tipoConsulta").trigger('change');
		$('#tipoRelatorio').trigger('change');

		$(".pesquisaRelatorios").hide();
		$(".cadastroRelatorios").show();
		JANELA_AGUARDE_MENU.hide();
	};
	
	CONSTRUTOR.configuraButtonRadioTipoApresentacao();
	CONSTRUTOR.configuraSelectModuloApresentacao();

	$("#div-sql").show();
	$("#div-script").hide();
	$("#div-jsp").hide();
	$("#div-template").show();
	$("#btnGerarTemplate").show();
}

function changePage(paginaSelecionada) {
	$('#divDinamicoTabelaRelatorios').hide("blind", "fast",	function(){
		JANELA_AGUARDE_MENU.show();
		document.form.paginaSelecionada.value = paginaSelecionada;
		carregaTabelaRelatorios();
	});
}

function stopOthersEvents(event) {
	event.preventDefault();
	event.stopPropagation();
}

function carregaTabelaRelatorios() {
	document.form.fireEvent('carregaTabelaRelatorios');
}

var CONSTRUTOR = {
	novo : function() {
		setTimeout(function() {
			CONSTRUTOR.limpar();
		}, 100);
		$(".pesquisaRelatorios").hide();
		$(".cadastroRelatorios").show();
	},
	voltarPesquisa : function() {
		this.limpar();
		$(".pesquisaRelatorios").show();
		$(".cadastroRelatorios").hide();
	},
	restore : function(id) {
		JANELA_AGUARDE_MENU.show();
		document.form.restore({idSmartReport:id});
	},
	configuraButtonRadioTipoApresentacao : function() {
		$(".radioTipoExibicao button").on("click", function(ev){
			if (ev.currentTarget.value == UtilSmartReport.TipoExibicao.ESPECIFICO) {
				$("#slModuloExibicao").data("placeholder", i18n_message("construtorconsultas.moduloExibicao.selecioneUmModulo"));
				$("#slModuloExibicao").select2();
				if ($("#slModuloExibicao").val() != null && $("#slModuloExibicao").val().length > 1) {
					$("#slModuloExibicao").select2("val", "");
				}
				$("#slModuloExibicao").prop("disabled", false);
			} else if (ev.currentTarget.value == UtilSmartReport.TipoExibicao.GERAL){
				$("#slModuloExibicao").data("placeholder", i18n_message("construtorconsultas.moduloExibicao.selecioneUmOuMaisModulos"));
				$("#slModuloExibicao").select2();
				$("#slModuloExibicao").prop("disabled", false);
			} else {
				$("#slModuloExibicao").prop("disabled", true);
				$("#slModuloExibicao").data("placeholder", "");
				$("#slModuloExibicao").select2("val", "");
			}
		});
	},
	configuraSelectModuloApresentacao: function() {
		addEvent(window, "mousedown", CONSTRUTOR.click, false);
		$("#slModuloExibicao").select2();
		$("#slModuloExibicao").on("select2-open", function() { 
			$(this).data("open", true);
		});
		$("#slModuloExibicao").on("select2-close", function() { 
			$(this).data("open", false);
		});
		$("#slModuloExibicao").on("select2-selecting", function() { 
			if ($(".radioTipoExibicao .active").val() == UtilSmartReport.TipoExibicao.ESPECIFICO) {
				if ($("#slModuloExibicao").val() != null && $("#slModuloExibicao").val().length > 0 ) {
					$("#slModuloExibicao").select2("val", "");
				}
			}
		});
	},
	click : function() {
		if ($("#slModuloExibicao").data("open")) {
			$("#slModuloExibicao").select2("close");
		}
	},
	defineValueTipoExibicao : function() {
		document.form.tipoExibicao.value = $(".radioTipoExibicao .active").val();
	},
	defineValueModuloExibicao : function() {
		if ($(".radioTipoExibicao .active").val() == UtilSmartReport.TipoExibicao.NENHUM) {
			document.form.moduloExibicao.value = '';
		} else {
			var moduloExibicao = $("#slModuloExibicao").val();
			if (moduloExibicao != null) {
				document.form.moduloExibicao.value = moduloExibicao.toString();
			} else {
				document.form.moduloExibicao.value = "";
			}
		}
		document.form.tipoExibicao.value = $(".radioTipoExibicao .active").val();
	},
	defineComportamentoRadioTipoExibicao : function(valor) {
		$(".radioTipoExibicao button[value='" + valor + "']").trigger("click");
	},
	defineComportamentoSelectModuloExibicao : function(valor) {
		var valor = valor.split(",");
		$("#slModuloExibicao").select2("val", valor);
	},
	gravar : function() {
		if (this.validarModuloExibicao()) {
			this.defineValueTipoExibicao();
			this.defineValueModuloExibicao();
			
			CM.transformToTextArea();
			CM.setValues();
			
			document.form.save();
		}
	},
	excluir : function() {
		if (document.form.idSmartReport.value > "" && confirm(i18n_message("citcorpore.comum.deleta"))) {
			document.form.fireDelete("delete");
		}
	},
	limpar : function() {
		try{
			CM.transformToTextArea();
			CM.initComponents();
			CM.clearComponents();
			CM.configureSizeComponents();
		} catch(e) {
			CM.initComponents();
			CM.clearComponents();
			CM.configureSizeComponents();
		}
		document.form.clear();
		$("#tipoConsulta").trigger('change');
		this.defineComportamentoRadioTipoExibicao(UtilSmartReport.TipoExibicao.NENHUM);
		$("#divTabelaGrupos").html('<h4>'+i18n_message("construtorconsultas.nenhumGrupoVinculado")+'</h4>');
		document.form.listaIdsGruposVinculados.value = "";
		load();
	},
	validarModuloExibicao : function () {
		if ($("#slModuloExibicao").val() == null || $("#slModuloExibicao").val().length == 0) {
			if ($(".radioTipoExibicao .active").val() == UtilSmartReport.TipoExibicao.GERAL) {
				notificacaoI18N("citcorpore.comum.camposObrigatorios", "construtorconsultas.moduloExibicao.selecioneUmOuMaisModulos");
				$("#slModuloExibicao").focus();
				return false;
			} else if ($(".radioTipoExibicao .active").val() == UtilSmartReport.TipoExibicao.ESPECIFICO) { 
				notificacaoI18N("citcorpore.comum.camposObrigatorios", "construtorconsultas.moduloExibicao.selecioneUmModulo");
				$("#slModuloExibicao").focus();
				return false;
			} else if ($(".radioTipoExibicao .active").val() == UtilSmartReport.TipoExibicao.NENHUM) {
				return true;
			}
		}
		
		return true;
	},
	load : function() {
		if(!document.form.idSmartReport.value) {
			notificacaoErro('questionario.alerta', 'construtorconsultas.gravarAntes');
			return;
		}
		
		$("[name=formSmartReport]").attr("id", "formSmartReport" + document.form.idSmartReport.value);
		
		$('#modal-smart-report .modal-body .widget-params').addClass('hidden');
		$('#modal-smart-report .modal-body .modal-body-content').empty();
		
		if ($("#identificacao").attr("value") == "") {
			notificacaoErro('', i18n_message("citcorpore.comum.campo_obrigatorio") + ": " + i18n_message("construtorconsultas.identificacao") + ".");
		} else if ($("#descricao").attr("value") == "") {
			notificacaoErro('', i18n_message("citcorpore.comum.campo_obrigatorio") + ": " + i18n_message("construtorconsultas.descricao") + ".");
		} else {
			CM.setValues();
			document.form.exibirParametroIdEspecifico.value = "sim";
			document.form.fireEvent("loadReport");
		}
	},
	gerarTemplate : function() {
		$("#parametros").attr("value", parametros.getValue());
		$("#sql").attr("value", sql.getValue());
		$("#script").attr("value", script.getValue());
		$("#jsp").attr("value", jsp.getValue());
		$("#template").attr("value", template.getValue());
		
		document.form.fireEvent("gerarTemplate");
	},
	buildTemplate : function(html) {
		template.setValue(html);
	},
	importReport: function() {
		document.getElementById('fileImport').value = '';
		document.getElementById('fileImport').click();
	},
	importReportCallback: function() {
		if(window.confirm(i18n_message('smartReportGenerators.confirmaImportarRelatorio'))) {
			document.getElementById('formImportSubmit').click();
		}
	},
	exportReport: function() {
		if(!document.form.idSmartReport.value) {
			notificacaoErro('questionario.alerta', 'construtorconsultas.gravarAntes');
			return;
		}
		if(window.confirm(i18n_message('smartReportGenerators.confirmaExportarRelatorio'))) {
			var pageExport = window.open(URL_SISTEMA + 'pages/smartReportGenerator/smartReportGenerator.load?action=EXPORT&idSmartReport=' + document.form.idSmartReport.value, '_blank');
			setTimeout(function() {
				pageExport.close();
			}, 100);
		}
	}
};

var CM = {
	initComponents : function() {
		this.initParametros();
		this.initSQL();
		this.initScript();
		this.initJSP();
		this.initTemplate();
	},
	clearComponents : function() {
		parametros.setValue('');
		sql.setValue('');
		script.setValue('');
		jsp.setValue('');
		template.setValue('');
	},
	configureSizeComponents : function() {
		parametros.setSize('100%', '600px');
		sql.setSize('100%', '600px');
		script.setSize('100%', '600px');
		jsp.setSize('100%', '600px');
		template.setSize('100%', '600px');
	},
	transformToTextArea : function() {
		parametros.toTextArea();
		sql.toTextArea();
		script.toTextArea();
		jsp.toTextArea();
		template.toTextArea();
	},
	redrawComponents : function() {
		parametros.redraw();
		sql.redraw();
		script.redraw();
		jsp.redraw();
		template.redraw();
	},
	setValues : function() {
		$("#parametros").attr("value", parametros.getValue());
		$("#sql").attr("value", sql.getValue());
		$("#script").attr("value", script.getValue());
		$("#jsp").attr("value", jsp.getValue());
		$("#template").attr("value", template.getValue());
	},
	initParametros : function() {
		parametros = CodeMirror.fromTextArea(document.getElementById("cm-parametros"), {
			lineNumbers : true,
			matchBrackets : true,
			highlightSelectionMatches : {
				showToken : /\w/,
				annotateScrollbar : true
			},
			mode : "xml",
			extraKeys : {
				"'<'": completeAfter,
				"'/'": completeIfAfterLt,
				"' '": completeIfInTag,
				"'='": completeIfInTag,
				"Ctrl-Space" : "autocomplete",
				"F11": function(cm) {
					cm.setOption("fullScreen", !cm.getOption("fullScreen"));
				},
				"Esc": function(cm) {
					if (cm.getOption("fullScreen")) cm.setOption("fullScreen", false);
				}
			},
			hintOptions : {
				schemaInfo : tags
			}
		});
	},
	initSQL : function() {
		sql = CodeMirror.fromTextArea(document.getElementById("cm-sql"), {
			lineNumbers : true,
			matchBrackets : true,
			highlightSelectionMatches : {
				showToken : /\w/,
				annotateScrollbar : true
			},
			mode : "text/x-sql",
			hintOptions : {
				hint : params
			},
			extraKeys : {
				"Ctrl-Space" : "autocomplete",
				"F11": function(cm) {
					cm.setOption("fullScreen", !cm.getOption("fullScreen"));
				},
				"Esc": function(cm) {
					if (cm.getOption("fullScreen")) cm.setOption("fullScreen", false);
				}
			}
		});
	},
	initScript : function() {
		script = CodeMirror.fromTextArea(document.getElementById("cm-script"), {
			lineNumbers : true,
			matchBrackets : true,
			highlightSelectionMatches : {
				showToken : /\w/,
				annotateScrollbar : true
			},
			mode : "text/x-java",
			hintOptions : {
				hint : params
			},
			extraKeys : {
				"Ctrl-Space" : "autocomplete",
				"F11": function(cm) {
					cm.setOption("fullScreen", !cm.getOption("fullScreen"));
				},
				"Esc": function(cm) {
					if (cm.getOption("fullScreen")) cm.setOption("fullScreen", false);
				}
			}
		});
	},
	initJSP : function() {
		jsp = CodeMirror.fromTextArea(document.getElementById("cm-jsp"), {
			lineNumbers : true,
			matchBrackets : true,
			highlightSelectionMatches : {
				showToken : /\w/,
				annotateScrollbar : true
			},
			mode: "application/x-jsp",
			extraKeys: {
				"Ctrl-J": "toMatchingTag",
				"F11": function(cm) {
					cm.setOption("fullScreen", !cm.getOption("fullScreen"));
				},
				"Esc": function(cm) {
					if (cm.getOption("fullScreen")) cm.setOption("fullScreen", false);
				}
			}
		});
	},
	initTemplate : function() {
		template = CodeMirror.fromTextArea(document.getElementById("cm-template"), {
			lineNumbers : true,
			matchBrackets : true,
			highlightSelectionMatches : {
				showToken : /\w/,
				annotateScrollbar : true
			},
			mode: "text/html",
			extraKeys: {
				"Ctrl-J": "toMatchingTag",
				"F11": function(cm) {
					cm.setOption("fullScreen", !cm.getOption("fullScreen"));
				},
				"Esc": function(cm) {
					if (cm.getOption("fullScreen")) cm.setOption("fullScreen", false);
				}
			}
		});
	},
	update : function(_var, _value) {
		_var.setValue(_value);
		setTimeout(function() {
			_var.refresh();
		}, 1);
	}
};

var tags = {
	"!top" : [ "PARAMETERS" ],
	PARAMETERS : {
		children : ["PARAM"]
	},
	PARAM : {
		attrs : {
			name : "",
			type : ["java.sql.Date", "java.lang.Integer", "java.lang.Double", "java.lang.String", "java.lang.StringBuilder"],
			typeHTML : ["select", "checkbox", "text", "textarea"],
			description : "",
			mandatory : ["true", "false"],
			default : ["{TODAY}", "{DAY_AGO}", "{WEEK_AGO}", "{MONTH_AGO}", "{YEAR_AGO}", "{LAST_MONTH}", "{CURRENT_MONTH}", "{LAST_YEAR}", "{CURRENT_YEAR}"],
			
		},
		children : ["OPTION", "OPTIONS"]
	},
	OPTION : {
		attrs : {
			value : "",
			text : "",
		},
		children : []
	},
	OPTIONS : {
		attrs : {
			type : ["SQL"],
			onload : ["true", "false"]
		},
		children : []
	}
};

function completeAfter(cm, pred) {
	var cur = cm.getCursor();
	if (!pred || pred())
		setTimeout(function() {
			if (!cm.state.completionActive)
				cm.showHint({
					completeSingle : false
				});
		}, 100);
	return CodeMirror.Pass;
}
function completeIfAfterLt(cm) {
	return completeAfter(cm, function() {
		var cur = cm.getCursor();
		return cm.getRange(CodeMirror.Pos(cur.line, cur.ch - 1), cur) == "<";
	});
}
function completeIfInTag(cm) {
	return completeAfter(
			cm,
			function() {
				var tok = cm.getTokenAt(cm.getCursor());
				if (tok.type == "string"
						&& (!/['"]/.test(tok.string
								.charAt(tok.string.length - 1)) || tok.string.length == 1))
					return false;
				var inner = CodeMirror.innerMode(cm.getMode(), tok.state).state;
				return inner.tagName;
			});
}

var params = function(cm, option) {
	return new Promise(function(accept) {
		setTimeout(function() {
			var cursor = cm.getCursor(), line = cm.getLine(cursor.line);
			var start = cursor.ch, end = cursor.ch;
			
			var paramList = [];
			
			if ($(".radioTipoExibicao .active").val() == UtilSmartReport.TipoExibicao.ESPECIFICO) {
				paramList.push("{SPECIFIC_ID}");
			}
			
			var prefix = 'PARAM.';
			var sufix = '';
			
			if ($("#tipoConsulta").val() == UtilSmartReport.QueryTypes.RHINOSCRIPT) {
				paramList.push("HTML_RESULT");
				paramList.push("QUERY_RESULT");
				paramList.push("RETURN_COLUMNS");
				
				prefix = 'hashParametros.get("' + prefix;
				sufix = '")';
			} else {
				prefix = '{' + prefix;
				sufix = '}';
			}
			
			if (parametros.getValue()  != "") {
				var xml = '';
				try {
					xml = $.parseXML(parametros.getValue());
				}catch(e) {
					notificacaoErro('', i18n_message('smartReportGenerators.xmlInvalido'));
				}
				
				$(xml).find("PARAM,param").each(function () {
					paramList.push(prefix + this.attributes.name.value + sufix);
				});
			}

			return accept({
				list : paramList,
				from : CodeMirror.Pos(cursor.line, start),
				to : CodeMirror.Pos(cursor.line, end)
			});
		}, 100);
	})
};

var Grupo = {
	abrirModal: function(){
		limpar_LOOKUP_GRUPO();
		
		// Lista dos ids dos grupos vinculados
		var idsGruposVinculados = this.getListaIdGruposVinculados();
		
		// Se tiver algum grupo vinculado acrescenta uma condição na lookup para que eles não sejam exibidos
		if(idsGruposVinculados.length > 0) {
			document.formGrupos.whereDinamico = "idgrupo not in ("+ idsGruposVinculados+")";
		} else {
			document.formGrupos.whereDinamico = "";
		}
		
		Modal.open("modal-grupo");
	},
	
	fecharModal: function() {
		Modal.close("modal-grupo");
	},
	
	removerGrupoFromTable : function(btClick){
		if (confirm(i18n_message("citcorpore.comum.deleta"))) {
			
			var trTable = btClick.closest('tr');
			var idGrupo = trTable.getAttribute('id');
			
			trTable.remove();
			
			// esconde o tooltip do botão desvincular grupo
			fechaTooltip();
			
			// remove o grupo da lista de lookup
			document.form.listaIdsGruposVinculados.value = document.form.listaIdsGruposVinculados.value.replace(idGrupo+";", "");
			this.serializarListaIdsGruposVinculados();
			
			if($("#divTabelaGrupos tbody tr").length < 1) {
				$("#divTabelaGrupos").html('<h4>'+i18n_message("construtorconsultas.nenhumGrupoVinculado")+'</h4>');
			}
		}
	},
	
	atualizarListaIdsGruposVinculados: function() {
		document.form.listaIdsGruposVinculados.value = document.form.listaIdsGruposVinculados.value + document.form.colAllLOOKUP_GRUPO.value;
		this.serializarListaIdsGruposVinculados();
	},	
	
	getListaIdGruposVinculados: function() {
		var idsGruposVinculados = document.form.listaIdsGruposVinculados.value.split(";");
		idsGruposVinculados = idsGruposVinculados.slice(0, idsGruposVinculados.length-1);
		return idsGruposVinculados;
	},
	
	montarTabelaGrupos: function() {
		this.atualizarListaIdsGruposVinculados();
		document.form.fireEvent("montarTabelaGrupos");
	},
	
	serializarListaIdsGruposVinculados: function(){
		var idsGruposVinculados = this.getListaIdGruposVinculados();
		var listaSmartReportGrupo = [];
		var smartReportGrupoDTO = null;		

		for(var i = 0, len = idsGruposVinculados.length; i < len; i++) {
			smartReportGrupoDTO = new CIT_SmartReportGrupoDTO();
			smartReportGrupoDTO.idGrupo = parseInt(idsGruposVinculados[i]);
			listaSmartReportGrupo.push(smartReportGrupoDTO);
		}
		
		document.form.listaSmartReportGrupo_Serialize.value = ObjectUtils.serializeObjects(listaSmartReportGrupo);

		return true;
	}
}

/*
 * Listeners
 */
$("#tipoConsulta").on("change", function() {
	if ($(this).attr("value") == UtilSmartReport.QueryTypes.SQL) {
		script.setValue("");
		jsp.setValue("");
		
		$("#div-sql").show();
		$("#div-script").hide();
		$("#div-jsp").hide();
	} else if ($(this).attr("value") == UtilSmartReport.QueryTypes.RHINOSCRIPT) {
		sql.setValue("");
		jsp.setValue("");
		
		$("#div-sql").hide();
		$("#div-script").show();
		$("#div-jsp").hide();
	} else if ($(this).attr("value") == UtilSmartReport.QueryTypes.JSP) {
		sql.setValue("");
		script.setValue("");
		
		$("#div-sql").hide();
		$("#div-script").hide();
		$("#div-jsp").show();
	}
	
	CM.transformToTextArea();
	setTimeout(function() {
		CM.initComponents();
		CM.configureSizeComponents();
	}, 100);

	document.form.fireEvent("carregaTipoRelatorio", function() {
		if ($("#tipoRelatorio").attr("value") == UtilSmartReport.ReportTypes.TEMPLATE) {
			$("#div-template").show();
			$("#btnGerarTemplate").show();
		} else {
			template.setValue("");
			$("#div-template").hide();
			$("#btnGerarTemplate").hide();
		}
	});
});

$("#tipoRelatorio").on("change", function() {
	if ($("#tipoRelatorio").attr("value") == UtilSmartReport.ReportTypes.TEMPLATE) {
		$("#div-template").show();
		$("#btnGerarTemplate").show();
	} else {
		template.setValue("");
		$("#div-template").hide();
		$("#btnGerarTemplate").hide();
	}
});

