document.formSmartReport.afterRestore = function() {
	JANELA_AGUARDE_MENU.hide();
};

$('#smart-reports-menu-search-input').autocomplete({ 
	serviceUrl:'pages/autoCompleteSmartReport/autoCompleteSmartReport.load',
	noCache: true,
	onSelect: function(value, data){
		var datas = data.split('|');
		SMART_REPORTS.loadReport(datas[0]);
		SMART_REPORTS.load.reportCategoryItems(datas[1]);
	}
});

var configureAutoComplete = function(value) {
	if(value && value.length > 0) {
		$('#smart-reports-menu-search-input').addClass('filled');
	} else {
		$('#smart-reports-menu-search-input').removeClass('filled');
	}
};

var clearAutoCompleteInput = function() {
	$('#smart-reports-menu-search-input').val('');
	$('#smart-reports-menu-search-input').removeClass('filled');
};

var idSmartReportSelected = 0;

var SMART_REPORTS = {
	load: {
		reportCategories: function(reportCategories) {
			var html = '';
			for(var i = 0; i < reportCategories.length; i++) {
				html += '	<li class="hasSubmenu menu_report_category_item " id="menu_report_category_item_' + reportCategories[i].id + '">';
				html += '		<a data-toggle="collapse" ';
				html += '			onclick="SMART_REPORTS.load.reportCategoryItems(' + reportCategories[i].id + ')" '; 
				html += '			href="#menu_report_category_' + reportCategories[i].id + '"><i class="material-icons md-20">' + reportCategories[i].icon + '</i><span>' + i18n_message(reportCategories[i].key) + '</span></a>';
				html += '		<span class="count">' + reportCategories[i].total + '</span>';
				html += '	</li>';
			}
			
			$('#smart-reports-menu-nav').empty().append(html);
		},
		reportCategoryItems: function(reportCategoryId) {
			$('.menu_report_category_item:not(#menu_report_category_item_' + reportCategoryId + ')').removeClass('active');
			$('.menu_report_category_item > ul:not(#menu_report_category_' + reportCategoryId + ')').collapse('hide');
			if(!$('#menu_report_category_item_' + reportCategoryId).hasClass('active')) {
				$('#menu_report_category_item_' + reportCategoryId).addClass('active');
				$('#idCategoria').val(reportCategoryId);
				
				JANELA_AGUARDE_MENU.show();
				document.formSmartReport.fireEvent('carregaRelatoriosByIdCategoria', function() {
					JANELA_AGUARDE_MENU.hide();
				});
			} else {
				$('#menu_report_category_item_' + reportCategoryId).removeClass('active');
			}
		}
	},
	set: {
		reportCategoryItems: function(relatorios) {
			if(relatorios && relatorios.length) {
				var menuReportCategoryItem = $('#menu_report_category_item_' + $('#idCategoria').val()),
					menuReportCategory = $('#menu_report_category_' + $('#idCategoria').val());
				
				menuReportCategoryItem.find('.count').empty().append(relatorios.length);
				
				menuReportCategoryItem.addClass('loaded');
				
				if(menuReportCategory && menuReportCategory.length) {
					menuReportCategory.remove();
				}
				
				var html = '';
				html += '<ul id="menu_report_category_' + $('#idCategoria').val() + '" class="collapse">';
				for(var i = 0; i < relatorios.length; i++) {
					html += '<li id="menu_report_category_report_' + relatorios[i].idSmartReport + '" class="menu_report_category_report';
					if(relatorios[i].idSmartReport == idSmartReportSelected) {
						html += ' current';
					}
					html += '">';
					html += '	<a href="javascript:;" onclick="SMART_REPORTS.loadReport(' + relatorios[i].idSmartReport + ')"><span>' + relatorios[i].identificacao + '</span></a>';
					html += '</li>';
				}
				html += '</ul>';
				
				menuReportCategoryItem.append(html);
				
				menuReportCategory = $('#menu_report_category_' + $('#idCategoria').val())
				menuReportCategory.collapse('show');
			}
		}
	},
	print: function (){
		var elementToPrint = $('#smart-reports-container-content .widget-body');
		
		if($('#smart-reports-container-content .widget-body #canvas').length > 0) {
			$('#canvas-clone').remove();
			var canvasElement = $('#smart-reports-container-content .widget-body #canvas');
			var img = convertCanvasToImage(document.getElementById('canvas'));
			img.id = 'canvas-clone';
			canvasElement.after(img);
		} else if($('#smart-reports-container-content .widget-body iframe').length > 0) {
			elementToPrint = $('#smart-reports-container-content .widget-body iframe').contents().find('body');
		}
		
		elementToPrint.printElement({
			printMode : 'popup',
			leaveOpen : true,
			pageTitle : 'CITSmart - ' + i18n_message('smartReports.titulo'),
			iframeElementOptions:{classNameToAdd : 'ui-corner-all resBusca smart-report-print'},
			printBodyOptions: {
				classNameToAdd : 'smart-report-print'
			}
		});
	},
	search: {
		reports: function(e, value) {
			var search = value + String.fromCharCode(e.which);
		}
	},
	loadReport : function(idSmartReport) {
		idSmartReportSelected = idSmartReport;
		$("[name=formSmartReport]").attr("id", "formSmartReport" + idSmartReport);
		
		$('.menu_report_category_report').removeClass('current');
		$('#idSmartReport').val(idSmartReport);
		$('#smart-reports-container-content').removeClass('hidden');
		$('#smart-reports-container-params').addClass('hidden');
		$('#smart-reports-container-params .widget-body .body-params').empty();
		$('#smart-reports-container-content .widget-body .widget-body-inner').empty();
		
		document.formSmartReport.exibirParametroIdEspecifico.value = "sim";
		
		JANELA_AGUARDE_MENU.show();
		document.formSmartReport.fireEvent("loadReport", function() {
			$('#menu_report_category_report_' + idSmartReport).addClass('current');
			JANELA_AGUARDE_MENU.hide();
		});
	}
};