var _tipoGlobal = "global";
var _tipoCliente = "cliente";
var _tipoRequisicaoIncidente = "requisicao-incidente";

var _tabelaUnidade = "unidade";
var _tabelaEmpregado = "empregado";

$(function() {
	definirAfters();
	$(".maskMin").mask('Mm', {
		translation : {
			'M' : {pattern : /[0-5]/},
			'm' : {pattern : /[0-9]/}
		}
	});
});

/**
 * Funções para after do restore e save
 */
function definirAfters(){
	document.formTempoAtendimento.afterRestore = function() {
		$("#tab-cadastro").click();
		if(document.formTempoAtendimento.tipoAcordo.value){
			TipoTempoAtendimento.changeTipoAtendimento(document.formTempoAtendimento.tipoAcordo.value, false, false);
		}
		Tree.refresh();
		Tree.openCheckeds();
		JANELA_AGUARDE_MENU.hide();
	}
	
	document.formTempoAtendimento.afterSave = function() {
		JANELA_AGUARDE_MENU.hide();
		inicializarValoresTempoAtendimento();
	}
}

function inicializarValoresTempoAtendimento() {
	$("[id^=taHora]").val(0);
	$("[id^=taMinuto]").val(0);
}

/**
 * Funções e Event Handlers para a árvore de requisições/incidentes.
 */

$(document).ready(function() {
	Tree.toggleAllRadios();
});

/**
 * Métodos para tratar dos tipos diferentes de Tempo de Atendimento
 */

var ANS = {
	salvar : function(){
		var _tipoAcordo = document.formTempoAtendimento.tipoAcordo.value;

		if((_tipoAcordo == _tipoGlobal) || (_tipoAcordo == _tipoCliente) || (_tipoAcordo == _tipoRequisicaoIncidente)){
			JANELA_AGUARDE_MENU.show();


			if((_tipoAcordo == _tipoGlobal) || (_tipoAcordo == _tipoCliente)){
				var contratosChecked = [];
				var servicosChecked = [];
				var checados = [];
				
				$("input[type='checkbox'][name='checkboxServicoContrato'][checked='checked']").each(function() {
					checados.push(this.value);
				});

				$("input[type='checkbox'][name='checkboxContrato'][checked='checked']").each(function() {
					if(!($("#"+$(this).attr('data-ref')).size() > 0)) {
						contratosChecked.push(this.value);
					}
				});
				
				$("input[type='checkbox'][name='checkboxServico'][checked='checked']").each(function() {
					if(!($("#"+$(this).attr('data-ref')).size() > 0)) {
						servicosChecked.push($(this).attr('data-idcontrato') + "-" + this.value);
					}
				});
				document.formTempoAtendimento.listaIdsServicosContratosStr.value = checados;
				document.formTempoAtendimento.listaIdsServicosRelacionadosServicoContratoStr.value = servicosChecked;
				document.formTempoAtendimento.listaIdsContratosRelacionadosServicoContratoStr.value = contratosChecked;
			}else{
				document.formTempoAtendimento.listaIdsServicosContratosStr.value = "";
				document.formTempoAtendimento.listaIdsServicosRelacionadosServicoContratoStr.value = "";
				document.formTempoAtendimento.listaIdsContratosRelacionadosServicoContratoStr.value = "";
			}

			if(_tipoAcordo == _tipoCliente){
				var idContratoSelecionado = $("input[type='radio'][name='radioContratos']:checked").val();

				if(idContratoSelecionado){
					document.formTempoAtendimento.idContrato.value = idContratoSelecionado;
				}else{
					notificacao(i18n_message("tempoAtendimento.impossivelContinuar"), i18n_message("tempoAtendimento.selecioneContrato"));
					JANELA_AGUARDE_MENU.hide();
					return;
				}
			}else{
				document.formTempoAtendimento.idContrato.value = "";
			}

			if((_tipoAcordo == _tipoRequisicaoIncidente)){
				var idServicoContratoSelecionado = $("input[type='radio'][name='radioServicoContrato']:checked").val();
				if(idServicoContratoSelecionado){
					document.formTempoAtendimento.idServicoContrato.value = idServicoContratoSelecionado;
				}else{
					notificacao(i18n_message("tempoAtendimento.impossivelContinuar"), i18n_message("tempoAtendimento.selecioneReqInc"));
					JANELA_AGUARDE_MENU.hide();
					return;
				}
			}else{
				document.formTempoAtendimento.idServicoContrato.value = "";
			}
			
			//serialização de unidade e sua respectiva prioridade, DTO = TempoAtendimentoUnidadeDTO
			serializaPrioridadeUnidade();
			
			//serialização de empregado e sua respectiva prioridade, DTO = TempoAtendimentoEmpregadoDTO
			serializaPrioridadeEmpregado();

			if(!document.formTempoAtendimento.save()){
				JANELA_AGUARDE_MENU.hide();
			}
		}

	},
	limpar : function(){
		document.formTempoAtendimento.clear();

		$(".tipo-tempoatendimento").removeClass("primary");

		ANS.limparTabelas();

		JANELA_AGUARDE_MENU.show();
		document.formTempoAtendimento.fireEvent("selecionaTipoAcordoPadrao");
	},
	limparTabelas : function(){
		$('#requisicoes-incidentes-list').html('');

		document.formTempoAtendimento.nomeUnidade.value = "";
		document.formTempoAtendimento.comboPrioridadeUnidade.value = "";
		document.formTempoAtendimento.listaUnidades.value = "";
		$('#tableUnidade tbody').html('');
		$('#tabelaUnidade').hide();

		document.formTempoAtendimento.nomeEmpregado.value = ""
		document.formTempoAtendimento.comboPrioridadeEmpregado.value = "";
		document.formTempoAtendimento.listaEmpregados.value = "";
		$('#tableEmpregado tbody').html('');
		$('#tabelaEmpregado').hide();
	},
	excluir : function(){
		if (document.formTempoAtendimento.idAcordoNivelServico.value != "" && confirm(i18n_message("citcorpore.comum.deleta"))) {
			document.formTempoAtendimento.fireEvent("excluir");
		}
	},
	restore : function(id){
		JANELA_AGUARDE_MENU.show();
		document.formTempoAtendimento.restore({idAcordoNivelServico:id});
	}
}

var TipoTempoAtendimento = {
	changeTipoAtendimento : function(_tipoAcordo, _ifReloadTree, _ifCleanTables) {

		$(".tipo-tempoatendimento").removeClass("primary");
		$("#tipo-tempoatendimento-"+_tipoAcordo).addClass("primary");

		if(_ifCleanTables)
			ANS.limparTabelas();

		document.formTempoAtendimento.tipoAcordo.value = _tipoAcordo;

		if(_tipoAcordo == _tipoGlobal){
			$("#requisicoes-incidentes-list").addClass(_tipoGlobal);

			if(_ifReloadTree){
				JANELA_AGUARDE_MENU.show();
				document.formTempoAtendimento.fireEvent("onChangeGenerateTree");
			}
		}

		if (_tipoAcordo == _tipoCliente) {
			$("#requisicoes-incidentes-list").addClass(_tipoCliente);

			if(_ifReloadTree){
				JANELA_AGUARDE_MENU.show();
				document.formTempoAtendimento.fireEvent("onChangeGenerateTree");
			}
		}else{
			document.formTempoAtendimento.idContrato.value = "";
		}

		if((_tipoAcordo == _tipoRequisicaoIncidente)){
			
			$("#requisicoes-incidentes-list").addClass(_tipoRequisicaoIncidente);

			if(_ifReloadTree){
				JANELA_AGUARDE_MENU.show();
				document.formTempoAtendimento.fireEvent("onChangeGenerateTree");
			}
		}else{
			document.formTempoAtendimento.idServicoContrato.value = "";
		}

		TipoTempoAtendimento.showHideUnidadeUsuario(_tipoAcordo);
	},
	showHideUnidadeUsuario : function(_tipoAcordo){
		if(_tipoAcordo == _tipoGlobal){
			$("#divisao-unidade").css("display", "none");
			$("#divisao-empregado").css("display", "none");
		}

		if( (_tipoAcordo == _tipoCliente) || (_tipoAcordo == _tipoRequisicaoIncidente) ){
			$("#divisao-unidade").css("display", "block");
			$("#divisao-empregado").css("display", "block");
		}
	},
	geraContentTipoContrato: function(that, tipoAcordoContrato) {
		if($(that).attr('data-hidden') == 'true') {
			if(!($(that).attr('data-load') == 'true')) {
				document.formTempoAtendimento.jsonTempoAtendimento.value = JSON.stringify({
					'tipoAcordoContrato': tipoAcordoContrato
				});
				document.formTempoAtendimento.fireEvent('generateContratosTree');
				$(that).attr('data-load', 'true');
			}else {
				this.showHide('tableOfContentsContratos'+tipoAcordoContrato);
			}
			$(that).attr('data-hidden', 'false');
		} else {
			this.showHide('tableOfContentsContratos'+tipoAcordoContrato);
			$(that).attr('data-hidden', 'true');
		}
	},
	geraContentContrato: function(that, tipoAcordoContrato, idContrato) {
		var _tipoAcordo = document.formTempoAtendimento.tipoAcordo.value;
		
		if($(that).attr('data-hidden') == 'true') {
			if(!($(that).attr('data-load') == 'true')) {
				var isChecked = false;
				
				if(_tipoAcordo == _tipoGlobal) {
					isChecked = $("input[type='checkbox'][data-ref='tableOfContentsContrato"+idContrato+"']").prop("checked")
				}
				
				document.formTempoAtendimento.jsonTempoAtendimento.value = JSON.stringify({
					'tipoAcordoContrato': tipoAcordoContrato,
					'idContrato': idContrato,
					'isChecked': isChecked
				});
				
				document.formTempoAtendimento.fireEvent('generateServicosTree');
				$(that).attr('data-load', 'true');
			} else {
				this.showHide('tableOfContentsContrato'+idContrato);
			}
			$(that).attr('data-hidden', 'false');
		} else {
			this.showHide('tableOfContentsContrato'+idContrato);
			$(that).attr('data-hidden', 'true');
		}
	},
	geraContentServico: function(that, tipoAcordoContrato, idContrato, idServicoContrato, idServico, idPortfolio) {
		var _tipoAcordo = document.formTempoAtendimento.tipoAcordo.value;
		
		if($(that).attr('data-hidden') == 'true') {
			if(!($(that).attr('data-load') == 'true')) {
				var isChecked = false;
				
				if(_tipoAcordo == _tipoGlobal || _tipoAcordo == _tipoCliente) {
					isChecked = $("input[type='checkbox'][data-ref='tableOfContentsServico"+idServico+ "Contrato" + idContrato+"']").prop("checked")
				}
				
				document.formTempoAtendimento.jsonTempoAtendimento.value = JSON.stringify({
					'tipoAcordoContrato': tipoAcordoContrato,
					'idContrato': idContrato,
					'idServicoContrato': idServicoContrato,
					'idServico': idServico,
					'idPortfolio': idPortfolio,
					'isChecked': isChecked
				});
				document.formTempoAtendimento.fireEvent('generateServicosContentTree');
				$(that).attr('data-load', 'true');
			}else {
				this.showHide('tableOfContentsServico'+idServico+ "Contrato" + idContrato);
			}
			$(that).attr('data-hidden', 'false');
		} else {
			this.showHide('tableOfContentsServico'+idServico+ "Contrato" + idContrato);
			$(that).attr('data-hidden', 'true');
		}
	},
	showHide: function(id) {
		this.showHideElement($('#'+id));
	},
	showHideElement: function(el) {
		if($(el).length > 0) {
			if($(el).css("display").indexOf("none") >= 0) {
				$(el).css("display", "");
				Tree.refresh();
			} else {
				$(el).css("display", "none");
			}
		}
	}
	
}

var PesquisaLookup = {
	changeTipo : function(_tipoPesquisa){
		$(".tipo-pesquisa").removeClass("primary");
		$("#"+_tipoPesquisa).addClass("primary");
		$("#lookups").children().css("display", "none");

		if(_tipoPesquisa == 'tipo-pesquisa-global'){
			$("#lookup-global").css("display", "block");
		}else if(_tipoPesquisa == 'tipo-pesquisa-cliente'){
			$("#lookup-cliente").css("display", "block");
		}else if(_tipoPesquisa == 'tipo-pesquisa-requisicao-incidente'){
			$("#lookup-requisicao-incidente").css("display", "block");
		}
	}
}

/* INÍCIO - FUNÇÕES RESPONSÁVEIS POR UNIDADE E SUA PRIORIDADE RESPECTIVA */
 function insereRowUnidade(idUnidade, nomeUnidade, prioridade){
	$('#tabelaUnidade').show();
	var tabela = document.getElementById('tableBodyUnidade');
	var lastRow = tabela.rows.length;
	var row = tabela.insertRow(lastRow);
	
	var coluna = row.insertCell(0);
	coluna.innerHTML = idUnidade;
	coluna.innerHTML += '<input type="hidden" id="idUnidade'+ idUnidade +'" name="idUnidade" value="' + idUnidade + '" />';
	
	coluna = row.insertCell(1);
	coluna.innerHTML = nomeUnidade;
	
	coluna = row.insertCell(2);
	coluna.innerHTML =  prioridade;
	coluna.innerHTML += '<input type="hidden" id="prioridadeValorUnidade' + idUnidade + '" name="prioridadeValorUnidade" value="' + prioridade + '" />';
	
	coluna = row.insertCell(3);
	if(permissaoDelete){
		coluna.innerHTML = '<a onclick=\"removeLinhaTabela(\'tableUnidade\', this.parentNode.parentNode.rowIndex);\" class=\"btn btn-action glyphicons remove_2 btn-danger\" id="btnExcluirUnidade' + idUnidade + '"><i></i></a>';
	}
	
	$('#prioridadeValorUnidade'+idUnidade).closest('td').addClass('center');
	$('#btnExcluirUnidade'+idUnidade).closest('td').addClass('center');
}
	
function removeLinhaTabela(idTabela, rowIndex) {
	if (confirm(i18n_message("citcorpore.comum.deleta"))) {
		HTMLUtils.deleteRow(idTabela, rowIndex);

		var tabela;
		if(idTabela == 'tableUnidade'){
			tabela = document.getElementById('tableBodyUnidade');
		}else if(idtabela == 'tableEmpregado'){
			tabela = document.getElementById('tableBodyEmpregado');
		}
		if(tabela.rows.length < 1){
			$('#'+idTabela).closest('div').hide();
		}
	}
}

function verificaSeJaInseridoNaTabelaUnidade(id){
	var cont = 0;
	$('#tabelaUnidade tbody tr').find('input[name="idUnidade"]').each(function(){
		if($(this).val() == id){
			cont++;
		}
	});
	
	if(cont > 0){
		return true;
	}else{
		return false;
	}
}

function serializaPrioridadeUnidade(){
	var count = 0;
	var prioridadeUnidade = new Array();
	var idAcordoNivelServico = $('#idAcordoNivelServico').val();
	
	$('#tableUnidade tbody tr').each(function(){
		var idUnidade = $(this).find('input[name="idUnidade"]').val();
		var prioridade = $(this).find('input[name="prioridadeValorUnidade"]').val();
		var TempoAtendimentoUnidadeDTO = new CIT_TempoAtendimentoUnidadeDTO();
		
		if(idUnidade && prioridade){
			TempoAtendimentoUnidadeDTO.idUnidade = idUnidade;
			TempoAtendimentoUnidadeDTO.idAcordoNivelServico = idAcordoNivelServico;
			TempoAtendimentoUnidadeDTO.prioridade = prioridade;
			
			prioridadeUnidade[count] = TempoAtendimentoUnidadeDTO;
			count = count + 1;
		}
	});
	var prioridadeUnidadeSerializados = ObjectUtils.serializeObjects(prioridadeUnidade);
	document.formTempoAtendimento.prioridadeUnidadeSerializados.value = prioridadeUnidadeSerializados;
	
	return true;
}
/* FIM - FUNÇÕES RESPONSÁVEIS POR UNIDADE E SUA PRIORIDADE RESPECTIVA */

/* INÍCIO - FUNÇÕES RESPONSÁVEIS POR EMPREGADO E SUA PRIORIDADE RESPECTIVA */
function insereRowEmpregado(idEmpregado, nomeEmpregado, prioridade){

	$('#tabelaEmpregado').show();
	var tabela = document.getElementById('tableBodyEmpregado');
	var lastRow = tabela.rows.length;
	var row = tabela.insertRow(lastRow);
	
	var coluna = row.insertCell(0);
	coluna.innerHTML = idEmpregado;
	coluna.innerHTML += '<input type="hidden" id="idEmpregado'+ idEmpregado +'" name="idEmpregado" value="' + idEmpregado + '" />';
	
	coluna = row.insertCell(1);
	coluna.innerHTML = nomeEmpregado;
	
	coluna = row.insertCell(2);
	coluna.innerHTML =  prioridade;
	coluna.innerHTML += '<input type="hidden" id="prioridadeValorEmpregado' + idEmpregado + '" name="prioridadeValorEmpregado" value="' + prioridade + '" />';
	
	coluna = row.insertCell(3);
	if(permissaoDelete){
		coluna.innerHTML = '<a onclick="removeLinhaTabela(\'tableEmpregado\', this.parentNode.parentNode.rowIndex);" class="btn btn-action glyphicons remove_2 btn-danger" id="btnExcluirEmpregado' + idEmpregado + '"><i></i></a>';
	}
	
	$('#prioridadeValorEmpregado'+idEmpregado).closest('td').addClass('center');
	$('#btnExcluirEmpregado'+idEmpregado).closest('td').addClass('center');
	
}
	
function verificaSeJaInseridoNaTabelaEmpregado(id){
	var cont = 0;
	$('#tabelaEmpregado tbody tr').find('input[name="idEmpregado"]').each(function(){
		if($(this).val() == id){
			cont++;
		}
	});

	if(cont > 0){
		return true;
	}else{
		return false;
	}
}

function serializaPrioridadeEmpregado(){
	var count = 0;
	var prioridadeEmpregado = new Array();
	var idAcordoNivelServico = $('#idAcordoNivelServico').val();
	
	$('#tableEmpregado tbody tr').each(function(){
		var idEmpregado = $(this).find('input[name="idEmpregado"]').val();
		var prioridade = $(this).find('input[name="prioridadeValorEmpregado"]').val();
		var TempoAtendimentoEmpregadoDTO = new CIT_TempoAtendimentoEmpregadoDTO();
		
		if(idEmpregado && prioridade){
			TempoAtendimentoEmpregadoDTO.idEmpregado = idEmpregado;
			TempoAtendimentoEmpregadoDTO.idAcordoNivelServico = idAcordoNivelServico;
			TempoAtendimentoEmpregadoDTO.prioridade = prioridade;
			
			prioridadeEmpregado[count] = TempoAtendimentoEmpregadoDTO;
			count = count + 1;
		}
	});
	var prioridadeEmpregadoSerializados = ObjectUtils.serializeObjects(prioridadeEmpregado);
	document.formTempoAtendimento.prioridadeEmpregadoSerializados.value = prioridadeEmpregadoSerializados;
	
	return true;
}
/* FIM - FUNÇÕES RESPONSÁVEIS POR EMPREGADO E SUA PRIORIDADE RESPECTIVA */


var Unidade = {
	selecionarUnidade : function(){
		var comboUnidadesHierarquia = document.getElementById("comboUnidadesHierarquia");
		if(comboUnidadesHierarquia){
			var idUnidadeSelecionada = comboUnidadesHierarquia.options[comboUnidadesHierarquia.selectedIndex].value;
			var nomeUnidadeSelecionada = comboUnidadesHierarquia.options[comboUnidadesHierarquia.selectedIndex].text;
			
			if(idUnidadeSelecionada && idUnidadeSelecionada > ""){
				document.formTempoAtendimento.nomeUnidade.value = nomeUnidadeSelecionada;
				document.formTempoAtendimento.idUnidadeVincular.value = idUnidadeSelecionada;
				Unidade.fecharModal();
			}else{
				notificacao(i18n_message("controle.UnidadeObrigatorio"), '');
			}
		}else{
			notificacao(i18n_message("controle.UnidadeObrigatorio"), '');
		}
	},
	addPrioridade : function(){
		var comboPrioridadeUnidade = document.getElementById("comboPrioridadeUnidade");
		var prioridadeUnidadeVincular = comboPrioridadeUnidade.options[comboPrioridadeUnidade.selectedIndex].value;
		document.formTempoAtendimento.prioridadeUnidadeVincular.value = prioridadeUnidadeVincular;

	},
	//Usado quando o parametro 61: "Vincula contratos à unidade" está setado como vazio ou "N"
	adicionar : function(idUnidadeSelecionada, nomeUnidadeSelecionada){
		var nomeUnidadeFormatado = nomeUnidadeSelecionada.split(' - ');
		
		document.formTempoAtendimento.nomeUnidade.value = nomeUnidadeFormatado[0];
		document.formTempoAtendimento.idUnidadeVincular.value = idUnidadeSelecionada;
		Unidade.fecharModal();
	},	
	adicionarPorHierarquia : function(){
		var nomeUnidadeSelecionada = document.formTempoAtendimento.nomeUnidade.value;
		var idUnidadeSelecionada = document.formTempoAtendimento.idUnidadeVincular.value;
		var prioridadeUnidade = document.formTempoAtendimento.prioridadeUnidadeVincular.value;

		if((nomeUnidadeSelecionada != null && nomeUnidadeSelecionada != undefined && nomeUnidadeSelecionada != "") &&
				(idUnidadeSelecionada != null && idUnidadeSelecionada != undefined && idUnidadeSelecionada != "")){

			if(prioridadeUnidade != null && prioridadeUnidade != undefined && prioridadeUnidade != ""){
				if(verificaSeJaInseridoNaTabelaUnidade(idUnidadeSelecionada)){
					alert(i18n_message("citcorpore.comum.registroJaAdicionado"));
				}else{
					insereRowUnidade(idUnidadeSelecionada, nomeUnidadeSelecionada, prioridadeUnidade);
				}
				
				document.formTempoAtendimento.nomeUnidade.value = "";
				document.formTempoAtendimento.idUnidadeVincular.value = "";
				document.formTempoAtendimento.prioridadeUnidadeVincular.value = "";
				document.formTempoAtendimento.comboPrioridadeUnidade.value = "";
			}else{
				notificacao(i18n_message("tempoAtendimento.prioridadeUnidadeObrigatorio"), '');
			}

		}else{
			notificacao(i18n_message("controle.UnidadeObrigatorio"), '');
		}
	},
	remover : function(btClick){
		if (confirm(i18n_message("citcorpore.comum.deleta"))) {
			var listaUnidadesSerializados = document.formTempoAtendimento.listaUnidades.value;
			
			var novaListaUnidadesSerializadas = Serializacao.removeElemento(btClick, listaUnidadesSerializados);

			if(novaListaUnidadesSerializadas!=undefined){
				document.formTempoAtendimento.listaUnidades.value = novaListaUnidadesSerializadas;

				if(novaListaUnidadesSerializadas==""){
					//$("#tabelaUnidade").html('');
				}
			}else{
				alert(i18n_message("tempoAtendimento.erroRemoverUnidade"));
			}
		}

	},
	defineLookupUnidade : function(){
		var _tipoAcordo = document.formTempoAtendimento.tipoAcordo.value;

		if(_tipoAcordo == _tipoCliente){
			var idContratoSelecionado = $("input[type='radio'][name='radioContratos']:checked").val();

			if(idContratoSelecionado){
				document.formTempoAtendimento.idContrato.value = idContratoSelecionado;
				JANELA_AGUARDE_MENU.show();
				document.formTempoAtendimento.fireEvent("defineLookupUnidade");
			}else{
				notificacao(i18n_message("tempoAtendimento.impossivelContinuar"), i18n_message("tempoAtendimento.selecioneContrato"));
			}
		}

		if(_tipoAcordo == _tipoRequisicaoIncidente){
			var idServicoContratoSelecionado = $("input[type='radio'][name='radioServicoContrato']:checked").val();
			if(idServicoContratoSelecionado){
				document.formTempoAtendimento.idServicoContrato.value = idServicoContratoSelecionado;
				JANELA_AGUARDE_MENU.show();
				document.formTempoAtendimento.fireEvent("defineLookupUnidade");
			}else{
				notificacao(i18n_message("tempoAtendimento.impossivelContinuar"), i18n_message("tempoAtendimento.selecioneReqInc"));
			}
		}
	},
	openModalUnidade : function(){
		Modal.open('M', 'modal-unidade', 'POPUP_UNIDADE');
	},
	openModalUnidadeContrato : function(idContrato){
		Modal.open('P', 'modal-unidade-contrato', 'POPUP_UNIDADE_CONTRATO');
	},
	fecharModal : function(){
		if($("#POPUP_UNIDADE").hasClass('ui-dialog-content') && $("#POPUP_UNIDADE").dialog("isOpen")){
			Modal.close('POPUP_UNIDADE');
		}

		if($("#POPUP_UNIDADE_CONTRATO").hasClass('ui-dialog-content') && $("#POPUP_UNIDADE_CONTRATO").dialog("isOpen")){
			Modal.close('POPUP_UNIDADE_CONTRATO');
		}
	}
}

var Empregado = {
	addInTableEmpregado : function(){
		var idEmpregadoSelecionado = document.formTempoAtendimento.idEmpregadoVincular.value;
		var prioridadeSelecionada = document.formTempoAtendimento.prioridadeEmpregadoVincular.value;
		var nomeEmpregadoSelecionado = document.formTempoAtendimento.nomeEmpregado.value;
		
		if((nomeEmpregadoSelecionado != null && nomeEmpregadoSelecionado != undefined && nomeEmpregadoSelecionado != "") &&
				(idEmpregadoSelecionado != null && idEmpregadoSelecionado != undefined && idEmpregadoSelecionado != "")){

			if(prioridadeSelecionada != null && prioridadeSelecionada != undefined && prioridadeSelecionada != ""){
				if(verificaSeJaInseridoNaTabelaEmpregado(idEmpregadoSelecionado)){
					alert(i18n_message("citcorpore.comum.registroJaAdicionado"));
				}else{
					insereRowEmpregado(idEmpregadoSelecionado, nomeEmpregadoSelecionado, prioridadeSelecionada);
				}
				
				document.formTempoAtendimento.idEmpregadoVincular.value = "";
				document.formTempoAtendimento.prioridadeEmpregadoVincular.value = "";
				document.formTempoAtendimento.nomeEmpregado.value = "";
				document.formTempoAtendimento.comboPrioridadeEmpregado.value = "";
			}else{
				notificacao(i18n_message("tempoAtendimento.prioridadeEmpregadoObrigatorio"), '');
			}

		}else{
			notificacao(i18n_message("controle.UnidadeObrigatorio"), '');
		}
			
	},
	adicionar : function(id, desc){

		var idEmpregadoSelecionado = id;
		var nomeEmpregadoSelecionado = desc;
		
		if(idEmpregadoSelecionado && nomeEmpregadoSelecionado > ""){
			document.formTempoAtendimento.nomeEmpregado.value = nomeEmpregadoSelecionado;
			document.formTempoAtendimento.idEmpregadoVincular.value = idEmpregadoSelecionado;
			Modal.close('POPUP_EMPREGADO');
		}else{
			notificacao(i18n_message("centroResultado.informeNomeEmpregado"), '');
		}
	},
	remover : function(btClick){
		if (confirm(i18n_message("citcorpore.comum.deleta"))) {
			var listaEmpregadosSerializados = document.formTempoAtendimento.listaEmpregados.value;
			
			var novaListaEmpregadosSerializadas = Serializacao.removeElemento(btClick, listaEmpregadosSerializados);

			if(novaListaEmpregadosSerializadas!=undefined){
				document.formTempoAtendimento.listaEmpregados.value = novaListaEmpregadosSerializadas;
				
				if(novaListaEmpregadosSerializadas==""){
					$("#tabelaEmpregado").html('');
				}
			}else{
				alert(i18n_message("tempoAtendimento.erroRemoverEmpregado"));
			}
		}
	},
	addPrioridade : function(){
		var comboPrioridadeEmpregado = document.getElementById("comboPrioridadeEmpregado");
		var prioridadeEmpregadoVincular = comboPrioridadeEmpregado.options[comboPrioridadeEmpregado.selectedIndex].value;
		document.formTempoAtendimento.prioridadeEmpregadoVincular.value = prioridadeEmpregadoVincular;
	}
}

var Serializacao = {
	removeElemento : function(btClick, listaObjetosSerializados){
		if(listaObjetosSerializados){
			var listaObjetos = ObjectUtils.deserializeCollectionFromString(listaObjetosSerializados);
			
			if(listaObjetos){
				var linhaTabela = btClick.closest('tr');
				
				var indiceSelecionado = (linhaTabela.rowIndex-1);
				
				linhaTabela.remove();

				listaObjetos.splice(indiceSelecionado, 1);

				var novaListaObjetosSerializados = ObjectUtils.serializeObjects(listaObjetos);
				
				return novaListaObjetosSerializados;
			}
		}

		return undefined;
	}
}

/**
 * Métodos para controle do modal.
 */

var Modal = {
	open : function(_tam, _classe, _id) {
		criaDialog(_tam, _classe, '');
		$("#"+_id).dialog("open");
	},
	close : function(_id) {
		$("#"+_id).dialog("close");
	}
}

/**
 * Funções e Event Handlers diversos para a tela.
 */

$("#resize-window").on("click", function() {
	if ($("#resize-window").hasClass("resize_full")) {
		$("#resize-window").removeClass("resize_full").addClass("resize_small");
		$("#footer, .navbar.main").fadeOut(100, function() {
			$("#content").addClass('p0');
		});
	} else {
		$("#resize-window").removeClass("resize_small").addClass("resize_full");
		$("#content").removeClass('p0');
		$("#footer, .navbar.main").fadeIn();
	}
});

function LOOKUP_UNIDADE_select(id, desc) {
	Unidade.adicionar(id, desc);
}

function LOOKUP_UNIDADE_CONTRATO_select(id, desc) {
	Unidade.adicionar(id);
}

function LOOKUP_EMPREGADOS_select(id, desc) {
	Empregado.adicionar(id, desc);
}

function LOOKUP_ACORDONIVELSERVICO_MULTINIVEL_GLOBAL_select(id,desc){
	ANS.restore(id);
}

function LOOKUP_ACORDONIVELSERVICO_MULTINIVEL_CLIENTE_select(id,desc){
	ANS.restore(id);
}

function LOOKUP_ACORDONIVELSERVICO_MULTINIVEL_REQUISICAO_INCIDENTE_select(id,desc){
	ANS.restore(id);
}

/**
 * Métodos para a árvore de requisições/incidentes
 */

var Tree = {
	toggleCheckboxes : function(_this) {
		return new Promise(function(resolve){
			var _reference = $(_this).attr("data-ref");
			
			if ($(_this).prop("checked")) {
				$(_this).attr("checked", true); //Redundante mas necessário devido a limitações do layout (ao clicar no checkbox do layout comprado o js não atribui checked=checked no elemento).
				
				$("#requisicoes-incidentes-list .option-check .checker input[type='checkbox'][data-owner='" + _reference + "']").attr("checked", true);
				$("#requisicoes-incidentes-list .option-check .checker input[type='checkbox'][data-owner='" + _reference + "']").parent().addClass("checked");
			} else {
				$(_this).attr("checked", false); //Redundante mas necessário devido a limitações do layout (ao clicar no checkbox do layout comprado o js não atribui checked=checked no elemento).
				
				$("#requisicoes-incidentes-list .option-check input[type='checkbox'][data-owner='" + _reference + "']").attr("checked", false);
				$("#requisicoes-incidentes-list .option-check .checker input[type='checkbox'][data-owner='" + _reference + "']").parent().removeClass("checked");
			}
			
			$("#requisicoes-incidentes-list .option-check .checker input[type='checkbox'][data-owner='" + _reference + "']").each(function() {
				Tree.toggleCheckboxes(this);
			});
			
			resolve();
		});
		
	},
	toggleClick : function(_this) {
		var _element = $(_this).parent().find(".option-check .checker input[type='checkbox'], .option-radio .radio input[type='radio']");

		if (_element != undefined) {
			if (_element.is(":checkbox")) {
				if (!_element.prop("disabled")) {
					_element.attr("checked", !_element.prop("checked"));
					
					if (_element.parent().hasClass("checked")) _element.parent().removeClass("checked");
					else _element.parent().addClass("checked");
				}
			} else if (_element.is(":radio")) {
				var _name = _element.attr("name");
				$("input[type='radio'][name='" + _name + "']").attr("checked", false);
				$("input[type='radio'][name='" + _name + "']").parent().removeClass("checked");

				_element.attr("checked", true);
				_element.parent().addClass("checked");
			}
		}
	},
	toggleAllRadios : function() {
		$("#requisicoes-incidentes-list .option-radio .radio input[type='radio']").each(function() {
			Tree.toggleChildren(this);
		});
	},
	toggleChildren : function(_this) {
		var _reference = $(_this).attr("data-ref");
		
		if ($(_this).prop("checked")) {
			$("#" + _reference).find(".option-check .checker input[type='checkbox']").attr("disabled", false);
			$("#" + _reference).find(".option-check .checker input[type='checkbox']").parent().parent().removeClass("disabled");
		} else {
			$("#" + _reference).find(".option-check .checker input[type='checkbox']").attr("checked", false);
			$("#" + _reference).find(".option-check .checker input[type='checkbox']").parent().removeClass("checked");
			
			$("#" + _reference).find(".option-check .checker input[type='checkbox']").attr("disabled", true);
			$("#" + _reference).find(".option-check .checker input[type='checkbox']").parent().parent().addClass("disabled");
		}
	},
	refresh : function() {
		if ($('.uniformjs').length) {
			$('.uniformjs').find("select, button, textarea").uniform();
			$('.uniformjs').find(".option-check > input").uniform();
		}
		
		Tree.toggleAllRadios();
		
		$("#requisicoes-incidentes-list.cliente").unbind().on("click", ".option-radio .radio input[type='radio']", function() {
			$("#requisicoes-incidentes-list .option-radio .radio input[type='radio']").attr("checked", false);
			$(this).attr("checked", true); 

			$("#requisicoes-incidentes-list .option-radio .radio input[type='radio']").each(function() {
				Tree.toggleChildren(this);
			});
		});

		$("#requisicoes-incidentes-list").unbind().on("click", ".option-check .checker input[type='checkbox']", function(i, el) {
			var _this = $(this);
			JANELA_AGUARDE_MENU.show()
			setTimeout(function(){waitAllCheck(_this)},50);
		});
	},
	openCheckeds : function(){

		if($("input[type='checkbox'][name='checkboxServicoContrato'][checked='checked']") && $("input[type='checkbox'][name='checkboxServicoContrato'][checked='checked']").size()>0){
			$("input[type='checkbox'][name='checkboxServicoContrato'][checked='checked']").each(function() {
				Tree.openAbove(this);
			});	
		}

		if($("input[type='radio'][name='radioServicoContrato'][checked='checked']") && $("input[type='radio'][name='radioServicoContrato'][checked='checked']").size()>0){
			$("input[type='radio'][name='radioServicoContrato'][checked='checked']").each(function() {
				Tree.openAbove(this);
			});	
		}
	},
	openAbove : function(_element){
		var ul = $(_element).parent().closest("ul");
		if($(ul)[0] && ($(ul)[0] != $(_element)[0])){
			Tree.openTree(ul);
		}
	},
	openTree : function(_element){
		if($('#requisicoes-incidentes-list').find(_element).length > 0){
			if($(_element).css("display").indexOf("none") >= 0) {
				$(_element).css("display", "");
			}
			Tree.openAbove($(_element).closest("ul"));
		}
	}
}

waitAllCheck = function(_this){
	Tree.toggleCheckboxes(_this).then(function(){
		JANELA_AGUARDE_MENU.hide();
	});
}
