var ws = undefined;

$(function() {
	if (window.WebSocket) {
		ws = new WebSocket("ws://" + window.location.host + cit_ctx + "/websocket");
		
		ws.onmessage = function(event) {
			$("#messages").append(event.data + "<br />");
		};
		
		ws.onerror = function(event) {
			console.log('Error: WebSocket not supported by the server');
		};
		
		window.addEventListener('beforeunload', function(event) {
			ws.close();
			ws = null;
		});
	} else {
		console.log('Error: WebSocket not supported by the browser');
	}

	$('#input input').keydown(inputKeyDownHandler);
	$('#input input').focus();
});

function inputKeyDownHandler(event) {
	if (event.which != 13) {
		return true;
	}
	event.preventDefault();
	
	if ($('#input input').val() != "") {
		ws.send(_.escape($('#input input').val()));
		$('#input input').val("");
	} else {
		alert("Digita alguma coisa né tião...");
		return false;
	}

}