CREATE TABLE [origematendimento](
	[idorigem] [bigint] NOT NULL,
	[descricao] [varchar](100) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idorigem] ASC
)
) ON [PRIMARY];

INSERT [origematendimento] ([idorigem], [descricao]) VALUES (1, N'Service Desk');
INSERT [origematendimento] ([idorigem], [descricao]) VALUES (2, N'Internet');
INSERT [origematendimento] ([idorigem], [descricao]) VALUES (3, N'E-mail');
INSERT [origematendimento] ([idorigem], [descricao]) VALUES (4, N'Operador');
INSERT [origematendimento] ([idorigem], [descricao]) VALUES (5, N'3º Nivel');
INSERT [origematendimento] ([idorigem], [descricao]) VALUES (6, N'2º Nivel');

CREATE TABLE [contatoproblema](
	[idcontatoproblema] [int] NOT NULL,
	[nomecontato] [varchar](100) NULL,
	[telefonecontato] [varchar](100) NULL,
	[emailcontato] [varchar](200) NULL,
	[observacao] [text] NULL,
	[idlocalidade] [int] NULL,
	[ramal] [varchar](5) NULL,
 CONSTRAINT [pk_contatoproblema] PRIMARY KEY CLUSTERED 
(
	[idcontatoproblema] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE TABLE [calendario](
	[idcalendario] [int] NOT NULL,
	[descricao] [varchar](70) NULL,
	[consideraferiados] [char](1) NULL,
	[idjornadaseg] [int] NULL,
	[idjornadater] [int] NULL,
	[idjornadaqua] [int] NULL,
	[idjornadaqui] [int] NULL,
	[idjornadasex] [int] NULL,
	[idjornadasab] [int] NULL,
	[idjornadadom] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[idcalendario] ASC
)
) ON [PRIMARY];

INSERT [calendario] ([idcalendario], [descricao], [consideraferiados], [idjornadaseg], [idjornadater], [idjornadaqua], [idjornadaqui], [idjornadasex], [idjornadasab], [idjornadadom]) VALUES (1, N'Padrão', N'S', 1, 1, 1, 1, 1, NULL, NULL);

CREATE TABLE [faseservico](
	[idfase] [bigint] NOT NULL,
	[nomefase] [varchar](70) NOT NULL,
	[fasecaptura] [char](1) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idfase] ASC
)
) ON [PRIMARY];

INSERT [faseservico] ([idfase], [nomefase], [fasecaptura]) VALUES (1, N'Captura', N'S');
INSERT [faseservico] ([idfase], [nomefase], [fasecaptura]) VALUES (2, N'Execução', N'N');

CREATE TABLE [empregados](
	[idempregado] [int] NOT NULL,
	[nome] [varchar](80) NOT NULL,
	[nomeprocura] [varchar](80) NULL,
	[datanascimento] [date] NULL,
	[sexo] [char](1) NULL,
	[cpf] [varchar](14) NULL,
	[rg] [varchar](15) NULL,
	[dataemissaorg] [date] NULL,
	[idtiposangue] [int] NULL,
	[orgexpedidor] [varchar](15) NULL,
	[iduforgexpedidor] [int] NULL,
	[pai] [varchar](50) NULL,
	[mae] [varchar](50) NULL,
	[conjuge] [varchar](50) NULL,
	[observacoes] [text] NULL,
	[estadocivil] [smallint] NULL,
	[email] [varchar](200) NULL,
	[datacadastro] [date] NULL,
	[fumante] [char](1) NULL,
	[ctpsnumero] [varchar](15) NULL,
	[ctpsserie] [varchar](10) NULL,
	[ctpsiduf] [int] NULL,
	[ctpsdataemissao] [date] NULL,
	[nit] [varchar](20) NULL,
	[dataadmissao] [date] NULL,
	[datademissao] [date] NULL,
	[tipo] [char](1) NULL,
	[idsituacaofuncional] [int] NOT NULL,
	[custoporhora] [real] NULL,
	[custototalmes] [real] NULL,
	[valorsalario] [real] NULL,
	[valorProdutividadeMedia] [real] NULL,
	[valorPlanoSaudeMedia] [real] NULL,
	[valorVTraMedia] [real] NULL,
	[valorVRefMedia] [real] NULL,
	[agencia] [varchar](10) NULL,
	[contasalario] [varchar](20) NULL,
	[idunidade] [int] NULL,
	[datafim] [date] NULL,
	[telefone] [varchar](45) NULL,
	[idcargo] [int] NULL,
	[vinculaAContratos] [char](1) NULL,
	[ramal] [varchar](5) NULL,
PRIMARY KEY CLUSTERED 
(
	[idempregado] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_cargo_funcionario] ON [empregados] 
(
	[idcargo] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_EMPUNIDADE] ON [empregados] 
(
	[idunidade] ASC
)ON [PRIMARY];

INSERT [empregados] ([idempregado], [nome], [nomeprocura], [datanascimento], [sexo], [cpf], [rg], [dataemissaorg], [idtiposangue], [orgexpedidor], [iduforgexpedidor], [pai], [mae], [conjuge], [observacoes], [estadocivil], [email], [datacadastro], [fumante], [ctpsnumero], [ctpsserie], [ctpsiduf], [ctpsdataemissao], [nit], [dataadmissao], [datademissao], [tipo], [idsituacaofuncional], [custoporhora], [custototalmes], [valorsalario], [valorProdutividadeMedia], [valorPlanoSaudeMedia], [valorVTraMedia], [valorVRefMedia], [agencia], [contasalario], [idunidade], [datafim], [telefone], [idcargo], [vinculaAContratos], [ramal]) VALUES (1, N'Administrador', N'Administrador', CAST(0x26350B00 AS Date), N'M', N'', N'', NULL, 0, N'', NULL, N'', N'', N'', N'', NULL, N'citsmart_instalador_mysql@centralit.com.br', NULL, NULL, N'', N'', NULL, NULL, N'', CAST(0x26350B00 AS Date), NULL, N'E', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, N'', N'', 1, NULL, N'3242-4433', 1, NULL, NULL);
INSERT [empregados] ([idempregado], [nome], [nomeprocura], [datanascimento], [sexo], [cpf], [rg], [dataemissaorg], [idtiposangue], [orgexpedidor], [iduforgexpedidor], [pai], [mae], [conjuge], [observacoes], [estadocivil], [email], [datacadastro], [fumante], [ctpsnumero], [ctpsserie], [ctpsiduf], [ctpsdataemissao], [nit], [dataadmissao], [datademissao], [tipo], [idsituacaofuncional], [custoporhora], [custototalmes], [valorsalario], [valorProdutividadeMedia], [valorPlanoSaudeMedia], [valorVTraMedia], [valorVRefMedia], [agencia], [contasalario], [idunidade], [datafim], [telefone], [idcargo], [vinculaAContratos], [ramal]) VALUES (2, N'Default', N'Default', CAST(0x26350B00 AS Date), N'M', N'', N'', NULL, 0, N'', NULL, N'', N'', N'', N'', NULL, N'citsmart_instalador_mysql@centralit.com.br', NULL, NULL, N'', N'', NULL, NULL, N'', CAST(0x26350B00 AS Date), NULL, N'E', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, N'', N'', 1, NULL, N'3242-4433', 2, NULL, NULL);
INSERT [empregados] ([idempregado], [nome], [nomeprocura], [datanascimento], [sexo], [cpf], [rg], [dataemissaorg], [idtiposangue], [orgexpedidor], [iduforgexpedidor], [pai], [mae], [conjuge], [observacoes], [estadocivil], [email], [datacadastro], [fumante], [ctpsnumero], [ctpsserie], [ctpsiduf], [ctpsdataemissao], [nit], [dataadmissao], [datademissao], [tipo], [idsituacaofuncional], [custoporhora], [custototalmes], [valorsalario], [valorProdutividadeMedia], [valorPlanoSaudeMedia], [valorVTraMedia], [valorVRefMedia], [agencia], [contasalario], [idunidade], [datafim], [telefone], [idcargo], [vinculaAContratos], [ramal]) VALUES (3, N'Consultor', N'Consultor', CAST(0x26350B00 AS Date), N'M', N'', N'', NULL, 0, N'', NULL, N'', N'', N'', N'', NULL, N'contact@citsmart.com', NULL, NULL, N'', N'', NULL, NULL, N'', CAST(0x26350B00 AS Date), NULL, N'E', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, N'', N'', 1, NULL, N'3242-4433', 1, NULL, NULL);

CREATE TABLE [bpm_itemtrabalhofluxo](
	[iditemtrabalho] [bigint] NOT NULL,
	[idinstancia] [bigint] NOT NULL,
	[idelemento] [bigint] NOT NULL,
	[idresponsavelatual] [int] NULL,
	[datahoracriacao] [datetime] NOT NULL,
	[datahorainicio] [datetime] NULL,
	[situacao] [char](20) NOT NULL,
	[datahorafinalizacao] [datetime] NULL,
	[datahoraexecucao] [datetime] NULL,
PRIMARY KEY CLUSTERED 
(
	[iditemtrabalho] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_107] ON [bpm_itemtrabalhofluxo] 
(
	[idinstancia] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_110] ON [bpm_itemtrabalhofluxo] 
(
	[idresponsavelatual] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_112] ON [bpm_itemtrabalhofluxo] 
(
	[idelemento] ASC
)ON [PRIMARY];

CREATE TABLE [solicitacaoservico](
	[idsolicitacaoservico] [bigint] NOT NULL,
	[idfaseatual] [bigint] NULL,
	[idtipoproblema] [bigint] NULL,
	[idgrupoatual] [int] NULL,
	[idprioridade] [bigint] NULL,
	[idorigem] [bigint] NULL,
	[idresponsavel] [int] NULL,
	[idsolicitante] [int] NULL,
	[atendimentopresencial] [char](1) NULL,
	[datahorasolicitacao] [datetime] NOT NULL,
	[datahoralimite] [datetime] NULL,
	[prazohh] [smallint] NULL,
	[prazomm] [smallint] NULL,
	[descricao] [text] NOT NULL,
	[resposta] [text] NULL,
	[datahorainicio] [datetime] NULL,
	[datahorafim] [datetime] NULL,
	[situacao] [varchar](20) NOT NULL,
	[deleted] [char](1) NULL,
	[idcontatosolicitacaoservico] [int] NULL,
	[idservicocontrato] [bigint] NULL,
	[idunidade] [int] NULL,
	[idcausaincidente] [int] NULL,
	[idcategoriasolucao] [int] NULL,
	[idtipodemandaservico] [int] NULL,
	[iditemconfiguracao] [int] NULL,
	[iditemconfiguracaofilho] [int] NULL,
	[idsolicitacaopai] [int] NULL,
	[detalhamentocausa] [text] NULL,
	[seqreabertura] [int] NULL,
	[detalhamentocausa____] [text] NULL,
	[enviaEmailCriacao] [char](1) NULL,
	[enviaEmailFinalizacao] [char](1) NULL,
	[enviaEmailAcoes] [char](1) NULL,
	[idgruponivel1] [int] NULL,
	[solucaoTemporaria] [char](1) NULL,
	[idsolicitacaoservicoorigem] [bigint] NULL,
	[idCalendario] [int] NULL,
	[houveMudanca] [char](1) NULL,
	[slaACombinar] [char](1) NULL,
	[prazohhAnterior] [smallint] NULL,
	[prazommAnterior] [smallint] NULL,
	[tempodecorridohh] [smallint] NULL,
	[tempodecorridomm] [smallint] NULL,
	[datahorasuspensao] [datetime] NULL,
	[datahorareativacao] [datetime] NULL,
	[impacto] [char](1) NULL,
	[urgencia] [char](1) NULL,
	[tempoCapturaHH] [smallint] NULL,
	[tempoCapturaMM] [smallint] NULL,
	[tempoAtrasoHH] [smallint] NULL,
	[tempoAtrasoMM] [smallint] NULL,
	[tempoAtendimentoHH] [smallint] NULL,
	[tempoAtendimentoMM] [smallint] NULL,
	[dataHoraCaptura] [datetime] NULL,
	[idbaseconhecimento] [int] NULL,
	[idacordonivelservico] [int] NULL,
	[idSolicitacaoRelacionada] [int] NULL,
	[descricaosemformatacao] [text] NULL,
	[datahorainiciosla] [datetime] NULL,
	[idultimaaprovacao] [int] NULL,
	[situacaosla] [char](1) NULL,
	[datahorasuspensaosla] [datetime] NULL,
	[datahorareativacaosla] [datetime] NULL,
	[prazocapturahh] [int] NULL,
	[prazocapturamm] [int] NULL,
	[idtarefaencerramento] [bigint] NULL,
PRIMARY KEY CLUSTERED 
(
	[idsolicitacaoservico] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_ref_sol_servCTRData] ON [solicitacaoservico] 
(
	[datahorasolicitacao] ASC,
	[idservicocontrato] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_ref_sol_servData] ON [solicitacaoservico] 
(
	[datahorasolicitacao] ASC,
	[idsolicitante] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_100] ON [solicitacaoservico] 
(
	[idtipoproblema] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_103] ON [solicitacaoservico] 
(
	[idservicocontrato] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_104] ON [solicitacaoservico] 
(
	[idorigem] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_105] ON [solicitacaoservico] 
(
	[idresponsavel] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_111] ON [solicitacaoservico] 
(
	[idsolicitante] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_120] ON [solicitacaoservico] 
(
	[idfaseatual] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_123] ON [solicitacaoservico] 
(
	[idunidade] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_138] ON [solicitacaoservico] 
(
	[idgrupoatual] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_531] ON [solicitacaoservico] 
(
	[idcausaincidente] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_532] ON [solicitacaoservico] 
(
	[idcategoriasolucao] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_550] ON [solicitacaoservico] 
(
	[idgruponivel1] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_561] ON [solicitacaoservico] 
(
	[idCalendario] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_95] ON [solicitacaoservico] 
(
	[idprioridade] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_solicitacao_aprovacao_idx] ON [solicitacaoservico] 
(
	[idultimaaprovacao] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_solicitacaoserv_contato] ON [solicitacaoservico] 
(
	[idcontatosolicitacaoservico] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_tarefa_encerramento_idx] ON [solicitacaoservico] 
(
	[idtarefaencerramento] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [idbaseconhecimento] ON [solicitacaoservico] 
(
	[idbaseconhecimento] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [idx_idacordonivelservico] ON [solicitacaoservico] 
(
	[idacordonivelservico] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [idx_iditemconfiguracao] ON [solicitacaoservico] 
(
	[iditemconfiguracao] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [idx_iditemconfiguracaofilho] ON [solicitacaoservico] 
(
	[iditemconfiguracaofilho] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [idx_idsolicitacaopai] ON [solicitacaoservico] 
(
	[idsolicitacaopai] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [idx_idsolicitacaorelacionada] ON [solicitacaoservico] 
(
	[idSolicitacaoRelacionada] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [idx_idsolicitacaoservicoorigem] ON [solicitacaoservico] 
(
	[idsolicitacaoservicoorigem] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [idx_idtipodemandaservico] ON [solicitacaoservico] 
(
	[idtipodemandaservico] ASC
)ON [PRIMARY];

CREATE TABLE [problema](
	[idproblema] [int] NOT NULL,
	[status] [varchar](40) NULL,
	[prioridade] [int] NULL,
	[idcriador] [int] NULL,
	[idproprietario] [int] NULL,
	[titulo] [varchar](255) NULL,
	[descricao] [varchar](1000) NULL,
	[idcategoriaproblema] [int] NULL,
	[impacto] [varchar](10) NULL,
	[urgencia] [varchar](10) NULL,
	[proativoreativo] [varchar](15) NULL,
	[datahoralimitesolucionar] [date] NULL,
	[msgerroassociada] [varchar](1000) NULL,
	[idproblemaitemconfiguracao] [int] NULL,
	[idproblemamudanca] [int] NULL,
	[idproblemaincidente] [int] NULL,
	[datahorainicio] [date] NULL,
	[datahorafim] [date] NULL,
	[solucaodefinitiva] [varchar](4000) NULL,
	[adicionarbdce] [varchar](1) NULL,
	[statusbaseconhecimento] [varchar](1) NULL,
	[idpastabaseconhecimento] [int] NULL,
	[causaraiz] [varchar](4000) NULL,
	[solucaocontorno] [varchar](4000) NULL,
	[idbaseconhecimento] [int] NULL,
	[severidade] [varchar](15) NULL,
	[idgrupo] [int] NULL,
	[idservico] [int] NULL,
	[idcontrato] [int] NULL,
	[idservicocontrato] [int] NULL,
	[idprioridade] [int] NULL,
	[datahoralimite] [datetime] NULL,
	[datahorasolicitacao] [datetime] NULL,
	[prazoHH] [int] NULL,
	[prazoMM] [int] NULL,
	[slaACombinar] [char](1) NULL,
	[acoescorretas] [text] NULL,
	[acoesincorretas] [text] NULL,
	[melhoriasfuturas] [text] NULL,
	[recorrenciaproblema] [text] NULL,
	[responsabilidadeterceiros] [text] NULL,
	[datahoracaptura] [datetime] NULL,
	[datahorainiciosla] [datetime] NULL,
	[datahorareativacao] [datetime] NULL,
	[datahorareativacaosla] [datetime] NULL,
	[datahorasuspensao] [datetime] NULL,
	[datahorasuspensaosla] [datetime] NULL,
	[enviaemailacoes] [char](1) NULL,
	[enviaemailcriacao] [char](1) NULL,
	[enviaemailfinalizacao] [char](1) NULL,
	[idcalendario] [int] NULL,
	[idfaseatual] [bigint] NULL,
	[idsolicitacaoservico] [bigint] NULL,
	[idsolicitante] [int] NULL,
	[resposta] [text] NULL,
	[seqreabertura] [int] NULL,
	[situacaosla] [char](1) NULL,
	[tempoatendimentohh] [smallint] NULL,
	[tempoatendimentomm] [smallint] NULL,
	[tempoatrasohh] [smallint] NULL,
	[tempoatrasomm] [smallint] NULL,
	[tempocapturahh] [smallint] NULL,
	[tempocapturamm] [smallint] NULL,
	[tempodecorridohh] [smallint] NULL,
	[tempodecorridomm] [smallint] NULL,
	[idorigematendimento] [bigint] NULL,
	[diagnostico] [varchar](4000) NULL,
	[fechamento] [varchar](1000) NULL,
	[idcontatoproblema] [int] NULL,
	[acompanhamento] [char](1) NULL,
	[grave] [char](1) NULL,
	[precisamudanca] [char](1) NULL,
	[faseatual] [varchar](100) NULL,
	[idcausa] [int] NULL,
	[confirmasolucaocontorno] [varchar](1) NULL,
	[idunidade] [int] NULL,
	[enviaemailprazosolucionarexpirou] [char](1) NULL,
	[fase] [varchar](100) NULL,
	[idcategoriasolucao] [int] NULL,
	[precisasolucaocontorno] [char](1) NULL,
	[resolvido] [char](1) NULL,
PRIMARY KEY CLUSTERED 
(
	[idproblema] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_idx_idproblema] ON [problema] 
(
	[idproblema] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_612] ON [problema] 
(
	[idproblemaitemconfiguracao] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_614] ON [problema] 
(
	[idproblemamudanca] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_616] ON [problema] 
(
	[idcategoriaproblema] ASC
)ON [PRIMARY];

CREATE TRIGGER [problema_setCurrentTime] ON  [problema]
FOR UPDATE
AS
BEGIN
	SET NOCOUNT ON; 
	UPDATE tbl
	SET datahoralimite = GETDATE()
	FROM problema AS tbl
	INNER JOIN inserted AS i
		ON tbl.idproblema = i.idproblema; 
END;

CREATE TABLE [ocorrenciaproblema](
	[idocorrencia] [int] NOT NULL,
	[iditemtrabalho] [bigint] NULL,
	[idjustificativa] [int] NULL,
	[idproblema] [int] NULL,
	[dataregistro] [date] NULL,
	[horaregistro] [varchar](5) NULL,
	[registradopor] [varchar](100) NULL,
	[descricao] [varchar](200) NULL,
	[datainicio] [date] NULL,
	[datafim] [date] NULL,
	[complementojustificativa] [text] NULL,
	[dadosproblema] [text] NULL,
	[informacoescontato] [text] NULL,
	[categoria] [varchar](20) NULL,
	[origem] [char](1) NULL,
	[tempogasto] [smallint] NULL,
	[ocorrencia] [text] NULL,
	[idcategoriaocorrencia] [int] NULL,
	[idorigemocorrencia] [int] NULL,
 CONSTRAINT [pk_ocorrenciaproblema] PRIMARY KEY CLUSTERED 
(
	[idocorrencia] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE TABLE [validacaorequisicaoproblema](
	[idvalidacaorequisicaoproblema] [int] NOT NULL,
	[observacaoproblema] [text] NULL,
	[datainicio] [date] NOT NULL,
	[datafim] [date] NULL,
	[idproblema] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[idvalidacaorequisicaoproblema] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE TABLE [solucaodefinitiva](
	[idsolucaodefinitiva] [int] NOT NULL,
	[titulo] [varchar](120) NOT NULL,
	[descricao] [text] NOT NULL,
	[datahoracriacao] [datetime] NULL,
	[idproblema] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[idsolucaodefinitiva] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE TABLE [solucaocontorno](
	[idsolucaocontorno] [int] NOT NULL,
	[titulo] [varchar](120) NOT NULL,
	[descricao] [text] NOT NULL,
	[datahoracriacao] [datetime] NULL,
	[idproblema] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[idsolucaocontorno] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE TABLE [criterioavaliacao](
	[idcriterio] [int] NOT NULL,
	[descricao] [varchar](100) NOT NULL,
	[aplicavelcotacao] [char](1) NOT NULL,
	[aplicavelavaliacaosolicitante] [char](1) NOT NULL,
	[aplicavelavaliacaocomprador] [char](1) NOT NULL,
	[aplicavelqualificacaofornecedor] [char](1) NOT NULL,
	[tipoavaliacao] [char](1) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idcriterio] ASC
)
) ON [PRIMARY];

CREATE TABLE [endereco](
	[idendereco] [int] NOT NULL,
	[logradouro] [varchar](200) NULL,
	[numero] [varchar](20) NULL,
	[complemento] [varchar](200) NULL,
	[bairro] [varchar](200) NULL,
	[idcidade] [int] NULL,
	[idpais] [int] NULL,
	[cep] [varchar](8) NULL,
	[iduf] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[idendereco] ASC
)
) ON [PRIMARY];

INSERT [endereco] ([idendereco], [logradouro], [numero], [complemento], [bairro], [idcidade], [idpais], [cep], [iduf]) VALUES (1, NULL, NULL, NULL, NULL, 971, 1, NULL, 4);

CREATE TABLE [fornecedor](
	[idfornecedor] [bigint] NOT NULL,
	[razaosocial] [varchar](100) NOT NULL,
	[nomefantasia] [varchar](70) NULL,
	[cnpj] [varchar](14) NULL,
	[email] [varchar](255) NULL,
	[observacao] [text] NULL,
	[deleted] [char](1) NULL,
	[telefone] [varchar](20) NULL,
	[fax] [varchar](20) NULL,
	[nomeContato] [varchar](100) NULL,
	[inscricaoEstadual] [varchar](25) NULL,
	[inscricaoMunicipal] [varchar](25) NULL,
	[idendereco] [int] NULL,
	[tipopessoa] [char](1) NULL,
PRIMARY KEY CLUSTERED 
(
	[idfornecedor] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_forn_end] ON [fornecedor] 
(
	[idendereco] ASC
)ON [PRIMARY];

INSERT [fornecedor] ([idfornecedor], [razaosocial], [nomefantasia], [cnpj], [email], [observacao], [deleted], [telefone], [fax], [nomeContato], [inscricaoEstadual], [inscricaoMunicipal], [idendereco], [tipopessoa]) VALUES (1, N'Fornecedor 1', N'Seu Fornecedor', NULL, N'', N'', NULL, NULL, NULL, N'', N'', N'', 1, N' ');

CREATE TABLE [cotacao](
	[idcotacao] [int] NOT NULL,
	[identificacao] [varchar](100) NULL,
	[idempresa] [int] NOT NULL,
	[idresponsavel] [int] NOT NULL,
	[situacao] [varchar](25) NOT NULL,
	[datahoracadastro] [datetime] NOT NULL,
	[observacoes] [text] NULL,
	[datafinalprevista] [date] NULL,
PRIMARY KEY CLUSTERED 
(
	[idcotacao] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_633] ON [cotacao] 
(
	[idempresa] ASC
)ON [PRIMARY];

CREATE TABLE [pedidocompra](
	[idpedido] [int] NOT NULL,
	[idempresa] [int] NOT NULL,
	[idfornecedor] [bigint] NOT NULL,
	[datapedido] [date] NOT NULL,
	[dataprevistaentrega] [date] NULL,
	[numeropedido] [varchar](25) NOT NULL,
	[identificacaoentrega] [varchar](25) NULL,
	[valorfrete] [decimal](8, 2) NULL,
	[valorseguro] [decimal](8, 2) NULL,
	[numeronf] [varchar](25) NULL,
	[outrasdespesas] [decimal](8, 2) NULL,
	[situacao] [varchar](20) NOT NULL,
	[idcotacao] [int] NULL,
	[idenderecoentrega] [int] NULL,
	[dataentrega] [date] NULL,
	[observacoes] [text] NULL,
PRIMARY KEY CLUSTERED 
(
	[idpedido] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_638] ON [pedidocompra] 
(
	[idfornecedor] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_706] ON [pedidocompra] 
(
	[idcotacao] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_707] ON [pedidocompra] 
(
	[idenderecoentrega] ASC
)ON [PRIMARY];

CREATE TABLE [alcada](
	[idalcada] [int] NOT NULL,
	[nomealcada] [varchar](70) NOT NULL,
	[situacao] [char](1) NOT NULL,
	[tipoalcada] [varchar](40) NULL,
PRIMARY KEY CLUSTERED 
(
	[idalcada] ASC
)
) ON [PRIMARY];

CREATE TABLE [justificativaparecer](
	[idjustificativa] [int] NOT NULL,
	[descricaojustificativa] [varchar](100) NOT NULL,
	[situacao] [char](1) NULL,
	[aplicavelrequisicao] [char](1) NULL,
	[aplicavelcotacao] [char](1) NULL,
	[aplicavelinspecao] [char](1) NULL,
PRIMARY KEY CLUSTERED 
(
	[idjustificativa] ASC
)
) ON [PRIMARY];

CREATE TABLE [parecer](
	[idparecer] [int] NOT NULL,
	[idjustificativa] [int] NULL,
	[idalcada] [int] NULL,
	[idresponsavel] [int] NOT NULL,
	[datahoraparecer] [datetime] NOT NULL,
	[complementojustificativa] [text] NULL,
	[aprovado] [char](1) NOT NULL,
	[observacoes] [text] NULL,
PRIMARY KEY CLUSTERED 
(
	[idparecer] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_35] ON [parecer] 
(
	[idjustificativa] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_650] ON [parecer] 
(
	[idalcada] ASC
)ON [PRIMARY];

CREATE TABLE [cotacaoitemrequisicao](
	[idcoletapreco] [int] NOT NULL,
	[iditemrequisicaoproduto] [int] NOT NULL,
	[idparecer] [int] NULL,
	[iditemtrabalhoaprovacao] [bigint] NULL,
	[idsolicitacaoservico] [bigint] NULL,
	[iditemtrabalhoinspecao] [bigint] NULL,
	[idcotacao] [int] NULL,
	[quantidade] [decimal](8, 2) NOT NULL,
	[situacao] [char](25) NULL,
	[quantidadeentregue] [decimal](8, 2) NULL,
	[iditemtrabalho] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[idcoletapreco] ASC,
	[iditemrequisicaoproduto] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_688] ON [cotacaoitemrequisicao] 
(
	[idcotacao] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_694] ON [cotacaoitemrequisicao] 
(
	[idparecer] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_699] ON [cotacaoitemrequisicao] 
(
	[iditemtrabalhoaprovacao] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [iditemrequisicaoproduto] ON [cotacaoitemrequisicao] 
(
	[iditemrequisicaoproduto] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [iditemtrabalhoinspecao] ON [cotacaoitemrequisicao] 
(
	[iditemtrabalhoinspecao] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [idsolicitacaoservico] ON [cotacaoitemrequisicao] 
(
	[idsolicitacaoservico] ASC
)ON [PRIMARY];

CREATE TABLE [entregaitemrequisicao](
	[identrega] [int] NOT NULL,
	[idpedido] [int] NOT NULL,
	[idcoletapreco] [int] NOT NULL,
	[iditemrequisicaoproduto] [int] NOT NULL,
	[idsolicitacaoservico] [bigint] NULL,
	[quantidadeentregue] [decimal](8, 2) NOT NULL,
	[iditemtrabalho] [bigint] NULL,
	[idparecer] [int] NULL,
	[situacao] [varchar](25) NOT NULL,
	[observacoes] [text] NULL,
PRIMARY KEY CLUSTERED 
(
	[identrega] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_701] ON [entregaitemrequisicao] 
(
	[idpedido] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_702] ON [entregaitemrequisicao] 
(
	[idcoletapreco] ASC,
	[iditemrequisicaoproduto] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_711] ON [entregaitemrequisicao] 
(
	[idsolicitacaoservico] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_712] ON [entregaitemrequisicao] 
(
	[iditemtrabalho] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_719] ON [entregaitemrequisicao] 
(
	[idparecer] ASC
)ON [PRIMARY];

CREATE TABLE [inspecaoentregaitem](
	[identrega] [int] NOT NULL,
	[idcriterio] [int] NOT NULL,
	[idresponsavel] [int] NULL,
	[datahorainspecao] [datetime] NOT NULL,
	[avaliacao] [varchar](25) NULL,
	[observacoes] [nvarchar](1) NULL,
PRIMARY KEY CLUSTERED 
(
	[identrega] ASC,
	[idcriterio] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_713] ON [inspecaoentregaitem] 
(
	[idresponsavel] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_714] ON [inspecaoentregaitem] 
(
	[idcriterio] ASC
)ON [PRIMARY];

CREATE TRIGGER [inspecaoentregaitem_setCurrentTime] ON  [inspecaoentregaitem]
FOR UPDATE
AS
BEGIN
	SET NOCOUNT ON; 
	UPDATE tbl
	SET datahorainspecao = GETDATE()
	FROM inspecaoentregaitem AS tbl
	INNER JOIN inserted AS i
		ON tbl.identrega = i.identrega; 
END;

CREATE TABLE [itemcotacao](
	[iditemcotacao] [int] NOT NULL,
	[idcotacao] [int] NULL,
	[idproduto] [int] NULL,
	[tipoidentificacao] [char](1) NOT NULL,
	[quantidade] [decimal](8, 2) NULL,
	[situacao] [varchar](20) NULL,
	[datahoralimite] [datetime] NOT NULL,
	[idcategoriaproduto] [int] NULL,
	[idunidademedida] [int] NULL,
	[descricaoitem] [varchar](200) NOT NULL,
	[especificacoes] [nvarchar](1) NULL,
	[marcapreferencial] [varchar](100) NULL,
	[precoaproximado] [decimal](8, 2) NULL,
	[solicitacoesatendidas] [text] NULL,
	[resultadovalidacao] [char](1) NULL,
	[mensagensvalidacao] [text] NULL,
	[pesopreco] [int] NULL,
	[pesoprazoentrega] [int] NULL,
	[pesoprazopagto] [int] NULL,
	[pesotaxajuros] [int] NULL,
	[pesoprazogarantia] [int] NULL,
	[exigefornecedorqualificado] [char](1) NULL,
PRIMARY KEY CLUSTERED 
(
	[iditemcotacao] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE TABLE [itemconfiguracaoevento](
	[iditemconfiguracaoevento] [int] NOT NULL,
	[idbaseitemconfiguracao] [int] NULL,
	[iditemconfiguracao] [int] NULL,
	[idevento] [int] NOT NULL,
	[tipoexecucao] [char](1) NULL,
	[gerarquando] [char](1) NOT NULL,
	[data] [date] NOT NULL,
	[hora] [char](4) NULL,
	[linhacomando] [varchar](255) NULL,
	[linhacomandolinux] [varchar](255) NULL
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_ITEMBASEITEMCONFIGURACAO] ON [itemconfiguracaoevento] 
(
	[idbaseitemconfiguracao] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_ITEMCONFIGURACAO] ON [itemconfiguracaoevento] 
(
	[iditemconfiguracao] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_ITEMEVENTO] ON [itemconfiguracaoevento] 
(
	[idevento] ASC
)ON [PRIMARY];

CREATE TABLE [itemconfiguracao](
	[iditemconfiguracao] [int] NOT NULL,
	[identificacao] [varchar](400) NOT NULL,
	[iditemconfiguracaopai] [int] NULL,
	[idtipoitemconfiguracao] [int] NULL,
	[datainicio] [date] NOT NULL,
	[datafim] [date] NULL,
	[idgrupoitemconfiguracao] [int] NULL,
	[idproprietario] [int] NULL,
	[dataexpiracao] [date] NULL,
	[versao] [varchar](50) NULL,
	[familia] [varchar](250) NULL,
	[classe] [varchar](250) NULL,
	[localidade] [varchar](250) NULL,
	[status] [int] NULL,
	[criticidade] [int] NULL,
	[numeroSerie] [varchar](45) NULL,
	[idMudanca] [int] NULL,
	[idProblema] [int] NULL,
	[IdIncidente] [int] NULL,
	[idMidiaSoftware] [int] NULL,
	[impacto] [varchar](255) NULL,
	[urgencia] [varchar](255) NULL,
	[idbaseconhecimento] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[iditemconfiguracao] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_idbaseconhecimento_itemconfiguracao] ON [itemconfiguracao] 
(
	[idbaseconhecimento] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_idproprietario] ON [itemconfiguracao] 
(
	[idproprietario] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_itemconf_associati_itemconf] ON [itemconfiguracao] 
(
	[iditemconfiguracaopai] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_itemconf_reference_tipoitem] ON [itemconfiguracao] 
(
	[idtipoitemconfiguracao] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [idgrupoitemconfiguracao] ON [itemconfiguracao] 
(
	[idgrupoitemconfiguracao] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_ICPAI] ON [itemconfiguracao] 
(
	[identificacao] ASC,
	[iditemconfiguracaopai] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_ITEMCONF] ON [itemconfiguracao] 
(
	[iditemconfiguracao] ASC,
	[iditemconfiguracaopai] ASC,
	[idtipoitemconfiguracao] ASC,
	[datafim] ASC
)ON [PRIMARY];

CREATE TABLE [itemcfgsolicitacaoserv](
	[iditemconfiguracao] [int] NULL,
	[idsolicitacaoservico] [bigint] NULL,
	[datainicio] [date] NULL,
	[datafim] [date] NULL
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_itemcfgs_reference_itemconf] ON [itemcfgsolicitacaoserv] 
(
	[iditemconfiguracao] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_itemcfgs_reference_solicita] ON [itemcfgsolicitacaoserv] 
(
	[idsolicitacaoservico] ASC
)ON [PRIMARY];

CREATE TABLE [informacoescontratoperfseg](
	[idinformacoescontratoconfig] [int] NOT NULL,
	[idperfilseguranca] [int] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idinformacoescontratoconfig] ASC,
	[idperfilseguranca] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_INFORMACOESPERFILSEGURANCA] ON [informacoescontratoperfseg] 
(
	[idperfilseguranca] ASC
)ON [PRIMARY];

CREATE TABLE [informacoescontratoconfig](
	[idinformacoescontratoconfig] [int] NOT NULL,
	[idinformacoescontratoconfigpai] [int] NULL,
	[nome] [varchar](50) NOT NULL,
	[descricao] [varchar](70) NOT NULL,
	[funcionalidadepath] [varchar](255) NULL,
	[funcitem] [char](1) NOT NULL,
	[idquestionario] [int] NULL,
	[idempresa] [int] NOT NULL,
	[situacao] [char](1) NOT NULL,
	[ordem] [smallint] NULL,
	[infoadicional] [text] NULL,
	[funcadicionalaposgravacao] [varchar](255) NULL,
	[chamarfuncaddaposgravar] [char](1) NULL,
	[chamarfuncaddhistorico] [char](1) NULL,
	[iconefunchistorico] [varchar](255) NULL,
	[iconefunchistoricofinal] [varchar](255) NULL,
	[validacoes] [text] NULL,
	[segurancaunidade] [char](1) NULL,
	[segurancaunidadepcmso] [char](1) NULL,
	[segurancaunidadeenferm] [char](1) NULL,
PRIMARY KEY CLUSTERED 
(
	[idinformacoescontratoconfig] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_INFORMACOESCONTRATOCONFIGPAI] ON [informacoescontratoconfig] 
(
	[idinformacoescontratoconfigpai] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_INFORMACOESEMPRESA] ON [informacoescontratoconfig] 
(
	[idempresa] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_INFORMACOESQUESTIONARIO] ON [informacoescontratoconfig] 
(
	[idquestionario] ASC
)ON [PRIMARY];

CREATE TABLE [informacaoservico](
	[idInformacaoServico] [bigint] NOT NULL,
	[idServico] [bigint] NOT NULL,
	[usuario] [varchar](255) NULL,
	[titulo] [varchar](255) NULL,
	[texto] [varchar](255) NULL,
	[situacao] [varchar](255) NULL,
	[deleted] [varchar](255) NULL,
PRIMARY KEY CLUSTERED 
(
	[idInformacaoServico] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [FK3107D1C6B3CD587F] ON [informacaoservico] 
(
	[idServico] ASC
)ON [PRIMARY];

CREATE TABLE [infocatalogoservico](
	[idinfocatalogoservico] [int] NOT NULL,
	[idcatalogoservico] [int] NULL,
	[descinfocatalogoservico] [text] NULL,
	[nomeinfocatalogoservico] [varchar](200) NULL,
PRIMARY KEY CLUSTERED 
(
	[idinfocatalogoservico] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_infocata_reference_catalago] ON [infocatalogoservico]
(
	[idcatalogoservico] ASC
)ON [PRIMARY];

CREATE TABLE [historicovalor](
	[idhistoricovalor] [int] NOT NULL,
	[idvalor] [int] NOT NULL,
	[iditemconfiguracao] [int] NULL,
	[idcaracteristica] [int] NULL,
	[valorstr] [varchar](4000) NULL,
	[valorlongo] [text] NULL,
	[valordecimal] [decimal](18, 4) NULL,
	[valordate] [date] NULL,
	[idbaseitemconfiguracao] [int] NULL,
	[datahoraalteracao] [datetime] NOT NULL,
	[idautoralteracao] [int] NOT NULL,
	[baseline] [varchar](30) NULL,
	[idHistoricoIC] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[idhistoricovalor] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_valor] ON [historicovalor] 
(
	[idvalor] ASC
)ON [PRIMARY];

CREATE TABLE [historicotentativa](
	[idhistoricotentativa] [int] NOT NULL,
	[iditemconfiguracao] [int] NULL,
	[idbaseitemconfiguracao] [int] NULL,
	[idevento] [int] NULL,
	[idempregado] [int] NULL,
	[descricao] [varchar](255) NULL,
	[data] [date] NULL,
	[hora] [char](4) NULL,
PRIMARY KEY CLUSTERED 
(
	[idhistoricotentativa] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [BASEITEMCONFIGURACAO] ON [historicotentativa] 
(
	[idhistoricotentativa] ASC,
	[idbaseitemconfiguracao] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [EMPREGADO] ON [historicotentativa] 
(
	[idhistoricotentativa] ASC,
	[idempregado] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [EVENTO] ON [historicotentativa] 
(
	[idhistoricotentativa] ASC,
	[idevento] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [FK_Reference_130] ON [historicotentativa] 
(
	[iditemconfiguracao] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [FK_Reference_131] ON [historicotentativa] 
(
	[idbaseitemconfiguracao] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [FK_Reference_133] ON [historicotentativa] 
(
	[idevento] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [FK_Reference_136] ON [historicotentativa] 
(
	[idempregado] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [ITEMCONFIGURACAO] ON [historicotentativa] 
(
	[idhistoricotentativa] ASC,
	[iditemconfiguracao] ASC
)ON [PRIMARY];

CREATE TABLE [importancianegocio](
	[idimportancianegocio] [int] NOT NULL,
	[idempresa] [int] NOT NULL,
	[nomeimportancianegocio] [varchar](100) NOT NULL,
	[situacao] [char](1) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idimportancianegocio] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_IMPORTANCIAEMPRESA] ON [importancianegocio] 
(
	[idempresa] ASC
)ON [PRIMARY];

INSERT [importancianegocio] ([idimportancianegocio], [idempresa], [nomeimportancianegocio], [situacao]) VALUES (1, 1, N'Baixa', N'A');
INSERT [importancianegocio] ([idimportancianegocio], [idempresa], [nomeimportancianegocio], [situacao]) VALUES (3, 1, N'Média', N'A');
INSERT [importancianegocio] ([idimportancianegocio], [idempresa], [nomeimportancianegocio], [situacao]) VALUES (4, 1, N'Alta', N'A');
INSERT [importancianegocio] ([idimportancianegocio], [idempresa], [nomeimportancianegocio], [situacao]) VALUES (10, 1, N'A combinar', N'A');
INSERT [importancianegocio] ([idimportancianegocio], [idempresa], [nomeimportancianegocio], [situacao]) VALUES (11, 1, N'Normal', N'A');

CREATE TABLE [importanciaconhecimentousuario](
	[idbaseconhecimento] [int] NOT NULL,
	[idusuario] [int] NOT NULL,
	[grauimportanciausuario] [varchar](45) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idbaseconhecimento] ASC,
	[idusuario] ASC
)
) ON [PRIMARY];

CREATE TABLE [importanciaconhecimentogrupo](
	[idbaseconhecimento] [int] NOT NULL,
	[idgrupo] [int] NOT NULL,
	[grauimportanciagrupo] [varchar](45) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idbaseconhecimento] ASC,
	[idgrupo] ASC
)
) ON [PRIMARY];

CREATE TABLE [impacto](
	[idImpacto] [int] NOT NULL,
	[nivelImpacto] [varchar](100) NOT NULL,
	[siglaImpacto] [char](2) NULL,
PRIMARY KEY CLUSTERED 
(
	[idImpacto] ASC
)
) ON [PRIMARY];

INSERT [impacto] ([idImpacto], [nivelImpacto], [siglaImpacto]) VALUES (1, N'Altíssimo', N'AL');
INSERT [impacto] ([idImpacto], [nivelImpacto], [siglaImpacto]) VALUES (2, N'Alto', N'A ');
INSERT [impacto] ([idImpacto], [nivelImpacto], [siglaImpacto]) VALUES (3, N'Elevado', N'E ');
INSERT [impacto] ([idImpacto], [nivelImpacto], [siglaImpacto]) VALUES (4, N'Médio', N'M ');
INSERT [impacto] ([idImpacto], [nivelImpacto], [siglaImpacto]) VALUES (5, N'Baixo', N'B ');

CREATE TABLE [imagemservicorelacionado](
	[idimagemservicorelacionado] [int] NOT NULL,
	[idservico] [int] NULL,
	[idservicorelacionado] [int] NULL,
	[posx] [int] NULL,
	[posy] [int] NULL,
	[descricao] [varchar](256) NULL,
	[caminhoimagem] [varchar](256) NULL,
	[idimagemservicorelacionadopai] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[idimagemservicorelacionado] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_IMAGEMITEMSERVICO] ON [imagemservicorelacionado] 
(
	[idservico] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_IMAGEMSERVICORELACIONADO] ON [imagemservicorelacionado] 
(
	[idservicorelacionado] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_IMAGEMSERVICORELACIONADOPAI] ON [imagemservicorelacionado] 
(
	[idimagemservicorelacionadopai] ASC
)ON [PRIMARY];

CREATE TABLE [imagemitemconfiguracao](
	[idimagemitemconfiguracao] [int] NOT NULL,
	[idservico] [int] NULL,
	[iditemconfiguracao] [int] NULL,
	[posx] [int] NULL,
	[posy] [int] NULL,
	[descricao] [varchar](256) NULL,
	[caminhoimagem] [varchar](256) NULL,
	[idimagemitemconfiguracaopai] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[idimagemitemconfiguracao] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_IMAGEMITEMCONFIGURACAO] ON [imagemitemconfiguracao] 
(
	[iditemconfiguracao] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_IMAGEMITEMCONFIGURACAOPAI] ON [imagemitemconfiguracao] 
(
	[idimagemitemconfiguracaopai] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_IMAGEMITEMSERVICO] ON [imagemitemconfiguracao] 
(
	[idservico] ASC
)ON [PRIMARY];

CREATE TABLE [imagemhistorico](
	[idimagem] [int] NOT NULL,
	[data] [date] NOT NULL,
	[nomearquivo] [varchar](255) NOT NULL,
	[observacao] [text] NULL,
	[idcontrato] [int] NOT NULL,
	[idprofissional] [int] NULL,
	[idempresa] [int] NULL,
	[aba] [varchar](30) NULL,
PRIMARY KEY CLUSTERED 
(
	[idimagem] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_121] ON [imagemhistorico] 
(
	[data] ASC,
	[idcontrato] ASC,
	[idprofissional] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [ix_imagemhistorico] ON [imagemhistorico] 
(
	[idcontrato] ASC,
	[data] ASC
)ON [PRIMARY];

CREATE TABLE [htmlcodevisao](
	[idhtmlcodevisao] [bigint] NOT NULL,
	[idvisao] [bigint] NOT NULL,
	[htmlcodetype] [char](30) NOT NULL,
	[htmlcode] [text] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idhtmlcodevisao] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_121] ON [htmlcodevisao] 
(
	[idvisao] ASC
)ON [PRIMARY];

CREATE TABLE [instalacao](
	[idinstalacao] [bigint] NOT NULL,
   	[sucesso] [char](1), 
   	[passo] [char](255),
PRIMARY KEY CLUSTERED
(
	[idinstalacao] ASC
)
) ON [PRIMARY];

CREATE TABLE [liberacaoproblema](
	[idliberacao] [int] NULL,
	[idproblema] [int] NOT NULL,
	[idhistoricoliberacao] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[idproblema] ASC
)
) ON [PRIMARY];

CREATE TABLE [liberacaomudanca](
	[idliberacao] [int] NOT NULL,
	[idrequisicaomudanca] [int] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idliberacao] ASC,
	[idrequisicaomudanca] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_710] ON [liberacaomudanca] 
(
	[idrequisicaomudanca] ASC
)ON [PRIMARY];

CREATE TABLE [liberacao](
	[idliberacao] [int] NOT NULL,
	[idsolicitante] [int] NOT NULL,
	[idresponsavel] [int] NULL,
	[titulo] [varchar](100) NOT NULL,
	[descricao] [text] NOT NULL,
	[datainicial] [date] NOT NULL,
	[datafinal] [date] NOT NULL,
	[dataliberacao] [date] NULL,
	[situacao] [char](1) NULL,
	[risco] [char](1) NOT NULL,
	[versao] [varchar](25) NULL,
	[idcontrato] [int] NULL,
	[seqreabertura] [smallint] NULL,
	[enviaemailcriacao] [varchar](1) NULL,
	[enviaemailacoes] [varchar](1) NULL,
	[tempoatrasohh] [smallint] NULL,
	[tempoatrasomm] [smallint] NULL,
	[tempocapturahh] [smallint] NULL,
	[tempocapturamm] [smallint] NULL,
	[datahoratermino] [datetime] NULL,
	[datahoraconclusao] [datetime] NULL,
	[status] [varchar](45) NULL,
	[tempodecorridohh] [smallint] NULL,
	[tempodecorridomm] [smallint] NULL,
	[tempoatendimentohh] [smallint] NULL,
	[tempoatendimentomm] [smallint] NULL,
	[datahoracaptura] [datetime] NULL,
	[datahorareativacao] [datetime] NULL,
	[datahorainicio] [datetime] NULL,
	[idcalendario] [int] NULL,
	[datahorasuspensao] [datetime] NULL,
	[enviaemailfinalizacao] [varchar](1) NULL,
	[prazohh] [smallint] NULL,
	[prazomm] [smallint] NULL,
	[idproprietario] [int] NOT NULL,
	[datahorainicioagendada] [datetime] NULL,
	[datahoraterminoagendada] [datetime] NULL,
	[idtipoliberacao] [int] NULL,
	[idGrupoAtual] [int] NULL,
	[prioridade] [int] NULL,
	[nivelurgencia] [varchar](255) NULL,
	[nivelimpacto] [varchar](255) NULL,
	[idaprovador] [int] NULL,
	[datahoraaprovacao] [datetime] NULL,
	[fechamento] [text] NULL,
	[idgruponivel1] [int] NULL,
	[idGrupoAprovador] [int] NULL,
	[idcontatorequisicaoliberacao] [int] NULL,
	[idultimaaprovacao] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[idliberacao] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_720] ON [liberacao] 
(
	[idsolicitante] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_721] ON [liberacao] 
(
	[idresponsavel] ASC
)ON [PRIMARY];

CREATE TABLE [justificativasolicitacao](
	[idjustificativa] [int] NOT NULL,
	[descricaojustificativa] [varchar](100) NOT NULL,
	[suspensao] [char](1) NOT NULL,
	[situacao] [char](1) NOT NULL,
	[deleted] [char](1) NULL,
	[aprovacao] [char](1) NULL,
PRIMARY KEY CLUSTERED 
(
	[idjustificativa] ASC
)
) ON [PRIMARY];

INSERT [justificativasolicitacao] ([idjustificativa], [descricaojustificativa], [suspensao], [situacao], [deleted], [aprovacao]) VALUES (1, N'teste', N't', N'a', N'n', N'N');

CREATE TABLE [justificativaproblema](
	[idjustificativaproblema] [int] NOT NULL,
	[descricaoproblema] [varchar](100) NOT NULL,
	[suspensao] [char](1) NOT NULL,
	[situacao] [char](1) NOT NULL,
	[aprovacao] [char](1) NULL,
	[deleted] [char](1) NULL,
 CONSTRAINT [pk_justificativaproblema] PRIMARY KEY CLUSTERED 
(
	[idjustificativaproblema] ASC
)
) ON [PRIMARY];

CREATE TABLE [justificativamudanca](
	[idjustificativamudanca] [int] NOT NULL,
	[descricaojustificativa] [varchar](100) NOT NULL,
	[suspensao] [char](1) NOT NULL,
	[situacao] [char](1) NOT NULL,
	[aprovacao] [char](1) NULL,
	[deleted] [char](1) NULL,
PRIMARY KEY CLUSTERED 
(
	[idjustificativamudanca] ASC
)
) ON [PRIMARY];

CREATE TABLE [justificativaliberacao](
	[idjustificativaliberacao] [int] NOT NULL,
	[descricaojustificativa] [varchar](100) NOT NULL,
	[suspensao] [char](1) NOT NULL,
	[situacao] [char](1) NOT NULL,
	[aprovacao] [char](1) NULL,
	[deleted] [char](1) NULL,
PRIMARY KEY CLUSTERED 
(
	[idjustificativaliberacao] ASC
)
) ON [PRIMARY];

CREATE TABLE [justificacaofalha](
	[idjustificacaofalha] [int] NOT NULL,
	[iditemconfiguracao] [int] NULL,
	[idbaseitemconfiguracao] [int] NULL,
	[idevento] [int] NULL,
	[idempregado] [int] NULL,
	[idhistoricotentativa] [int] NULL,
	[descricao] [text] NULL,
	[data] [date] NULL,
	[hora] [char](4) NULL,
PRIMARY KEY CLUSTERED 
(
	[idjustificacaofalha] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [FK_Reference_137] ON [justificacaofalha] 
(
	[idhistoricotentativa] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_JUSTIFICACAOBASEITEMCONFIGURACAO] ON [justificacaofalha] 
(
	[idbaseitemconfiguracao] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_JUSTIFICACAOEMPREGADO] ON [justificacaofalha] 
(
	[idempregado] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_JUSTIFICACAOEVENTO] ON [justificacaofalha] 
(
	[idevento] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_JUSTIFICACAOITEMCONFIGURACAO] ON [justificacaofalha] 
(
	[iditemconfiguracao] ASC
)ON [PRIMARY];

CREATE TABLE [jornadatrabalho](
	[idjornada] [int] NOT NULL,
	[descricao] [varchar](70) NOT NULL,
	[inicio1] [char](5) NULL,
	[termino1] [char](5) NULL,
	[inicio2] [char](5) NULL,
	[termino2] [char](5) NULL,
	[inicio3] [char](5) NULL,
	[termino3] [char](5) NULL,
	[inicio4] [char](5) NULL,
	[termino4] [char](5) NULL,
	[inicio5] [char](5) NULL,
	[termino5] [char](5) NULL,
	[cargahoraria] [char](5) NULL,
	[datainicio] [date] NULL,
	[datafim] [date] NULL,
PRIMARY KEY CLUSTERED 
(
	[idjornada] ASC
)
) ON [PRIMARY];

INSERT [jornadatrabalho] ([idjornada], [descricao], [inicio1], [termino1], [inicio2], [termino2], [inicio3], [termino3], [inicio4], [termino4], [inicio5], [termino5], [cargahoraria], [datainicio], [datafim]) VALUES (1, N'Service Desk (Semana)', N'08:00', N'20:00', N'     ', N'     ', N'     ', N'     ', N'     ', N'     ', N'     ', N'     ', N'12:00', NULL, NULL);
INSERT [jornadatrabalho] ([idjornada], [descricao], [inicio1], [termino1], [inicio2], [termino2], [inicio3], [termino3], [inicio4], [termino4], [inicio5], [termino5], [cargahoraria], [datainicio], [datafim]) VALUES (2, N'Service Desk (Fim de semana)', N'08:00', N'15:00', N'     ', N'     ', N'     ', N'     ', N'     ', N'     ', N'     ', N'     ', N'07:00', NULL, NULL);

CREATE TABLE [itemrequisicaoproduto](
	[iditemrequisicaoproduto] [int] NOT NULL,
	[idsolicitacaoservico] [int] NOT NULL,
	[idparecervalidacao] [int] NULL,
	[idparecerautorizacao] [int] NULL,
	[idcategoriaproduto] [int] NULL,
	[idunidademedida] [int] NULL,
	[idproduto] [int] NULL,
	[iditemcotacao] [int] NULL,
	[descricaoitem] [varchar](200) NOT NULL,
	[especificacoes] [nvarchar](1) NULL,
	[quantidade] [decimal](8, 2) NOT NULL,
	[marcapreferencial] [varchar](100) NULL,
	[precoaproximado] [decimal](8, 2) NULL,
	[situacao] [varchar](30) NULL,
	[percvariacaopreco] [decimal](8, 2) NULL,
	[qtdeaprovada] [decimal](8, 2) NULL,
	[tipoatendimento] [char](1) NOT NULL,
	[tipoidentificacao] [char](1) NOT NULL,
	[aprovacotacao] [char](1) NULL,
	[qtdecotada] [decimal](8, 2) NULL,
	[valoraprovado] [decimal](8, 2) NULL,
PRIMARY KEY CLUSTERED 
(
	[iditemrequisicaoproduto] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_625] ON [itemrequisicaoproduto] 
(
	[idsolicitacaoservico] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_643] ON [itemrequisicaoproduto] 
(
	[idparecervalidacao] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_644] ON [itemrequisicaoproduto] 
(
	[idparecerautorizacao] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_669] ON [itemrequisicaoproduto] 
(
	[idproduto] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_676] ON [itemrequisicaoproduto] 
(
	[idunidademedida] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_677] ON [itemrequisicaoproduto] 
(
	[idcategoriaproduto] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_692] ON [itemrequisicaoproduto] 
(
	[iditemcotacao] ASC
)ON [PRIMARY];

CREATE TABLE [matrizprioridade](
	[idMatrizPrioridade] [int] NOT NULL,
	[siglaImpacto] [char](2) NOT NULL,
	[siglaUrgencia] [char](2) NOT NULL,
	[valorPrioridade] [int] NOT NULL,
	[idcontrato] [int] NULL,
	[deleted] [char](1) NULL,
PRIMARY KEY CLUSTERED 
(
	[idMatrizPrioridade] ASC
)
) ON [PRIMARY];

INSERT [matrizprioridade] ([idMatrizPrioridade], [siglaImpacto], [siglaUrgencia], [valorPrioridade], [idcontrato], [deleted]) VALUES (1, N'AL', N'B ', 2, NULL, N' ');
INSERT [matrizprioridade] ([idMatrizPrioridade], [siglaImpacto], [siglaUrgencia], [valorPrioridade], [idcontrato], [deleted]) VALUES (2, N'AL', N'M ', 2, NULL, N' ');
INSERT [matrizprioridade] ([idMatrizPrioridade], [siglaImpacto], [siglaUrgencia], [valorPrioridade], [idcontrato], [deleted]) VALUES (3, N'AL', N'A ', 1, NULL, N' ');
INSERT [matrizprioridade] ([idMatrizPrioridade], [siglaImpacto], [siglaUrgencia], [valorPrioridade], [idcontrato], [deleted]) VALUES (4, N'AL', N'C ', 1, NULL, N' ');
INSERT [matrizprioridade] ([idMatrizPrioridade], [siglaImpacto], [siglaUrgencia], [valorPrioridade], [idcontrato], [deleted]) VALUES (5, N'A ', N'B ', 3, NULL, N' ');
INSERT [matrizprioridade] ([idMatrizPrioridade], [siglaImpacto], [siglaUrgencia], [valorPrioridade], [idcontrato], [deleted]) VALUES (6, N'A ', N'M ', 2, NULL, N' ');
INSERT [matrizprioridade] ([idMatrizPrioridade], [siglaImpacto], [siglaUrgencia], [valorPrioridade], [idcontrato], [deleted]) VALUES (7, N'A ', N'A ', 2, NULL, N' ');
INSERT [matrizprioridade] ([idMatrizPrioridade], [siglaImpacto], [siglaUrgencia], [valorPrioridade], [idcontrato], [deleted]) VALUES (8, N'A ', N'C ', 1, NULL, N' ');
INSERT [matrizprioridade] ([idMatrizPrioridade], [siglaImpacto], [siglaUrgencia], [valorPrioridade], [idcontrato], [deleted]) VALUES (9, N'E ', N'B ', 3, NULL, N' ');
INSERT [matrizprioridade] ([idMatrizPrioridade], [siglaImpacto], [siglaUrgencia], [valorPrioridade], [idcontrato], [deleted]) VALUES (10, N'E ', N'M ', 3, NULL, N' ');
INSERT [matrizprioridade] ([idMatrizPrioridade], [siglaImpacto], [siglaUrgencia], [valorPrioridade], [idcontrato], [deleted]) VALUES (11, N'E ', N'A ', 2, NULL, N' ');
INSERT [matrizprioridade] ([idMatrizPrioridade], [siglaImpacto], [siglaUrgencia], [valorPrioridade], [idcontrato], [deleted]) VALUES (12, N'E ', N'C ', 2, NULL, N' ');
INSERT [matrizprioridade] ([idMatrizPrioridade], [siglaImpacto], [siglaUrgencia], [valorPrioridade], [idcontrato], [deleted]) VALUES (13, N'M ', N'B ', 4, NULL, N' ');
INSERT [matrizprioridade] ([idMatrizPrioridade], [siglaImpacto], [siglaUrgencia], [valorPrioridade], [idcontrato], [deleted]) VALUES (14, N'M ', N'M ', 3, NULL, N' ');
INSERT [matrizprioridade] ([idMatrizPrioridade], [siglaImpacto], [siglaUrgencia], [valorPrioridade], [idcontrato], [deleted]) VALUES (15, N'M ', N'A ', 3, NULL, N' ');
INSERT [matrizprioridade] ([idMatrizPrioridade], [siglaImpacto], [siglaUrgencia], [valorPrioridade], [idcontrato], [deleted]) VALUES (16, N'M ', N'C ', 2, NULL, N' ');
INSERT [matrizprioridade] ([idMatrizPrioridade], [siglaImpacto], [siglaUrgencia], [valorPrioridade], [idcontrato], [deleted]) VALUES (17, N'B ', N'B ', 5, NULL, N' ');
INSERT [matrizprioridade] ([idMatrizPrioridade], [siglaImpacto], [siglaUrgencia], [valorPrioridade], [idcontrato], [deleted]) VALUES (18, N'B ', N'M ', 4, NULL, N' ');
INSERT [matrizprioridade] ([idMatrizPrioridade], [siglaImpacto], [siglaUrgencia], [valorPrioridade], [idcontrato], [deleted]) VALUES (19, N'B ', N'A ', 3, NULL, N' ');
INSERT [matrizprioridade] ([idMatrizPrioridade], [siglaImpacto], [siglaUrgencia], [valorPrioridade], [idcontrato], [deleted]) VALUES (20, N'B ', N'C ', 3, NULL, N' ');

CREATE TABLE [logdados](
	[idlog] [int] IDENTITY(1,1) NOT NULL,
	[dtatualizacao] [date] NULL,
	[operacao] [varchar](100) NULL,
	[dados] [text] NULL,
	[idusuario] [int] NULL,
	[localorigem] [varchar](255) NULL,
	[nometabela] [varchar](255) NULL,
	[logdadoscol] [varchar](45) NULL,
	[datalog] [datetime] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idlog] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE TABLE [inventarioxml](
	[idinventarioxml] [int] NOT NULL,
	[conteudo] [text] NULL,
	[idnetmap] [int] NULL,
	[datainicial] [date] NULL,
	[datafinal] [date] NULL,
	[nome] [varchar](256) NULL,
PRIMARY KEY CLUSTERED 
(
	[idinventarioxml] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_INVENTARIONETMAP] ON [inventarioxml] 
(
	[idnetmap] ASC
)ON [PRIMARY];

CREATE TABLE [localidade](
	[idlocalidade] [int] NOT NULL,
	[nomelocalidade] [varchar](255) NULL,
	[datainicio] [date] NULL,
	[datafim] [date] NULL,
PRIMARY KEY CLUSTERED 
(
	[idlocalidade] ASC
)
) ON [PRIMARY];

CREATE TABLE [localexecucaoservico](
	[idlocalexecucaoservico] [int] NOT NULL,
	[nomelocalexecucaoservico] [varchar](70) NOT NULL,
	[deleted] [char](1) NULL,
PRIMARY KEY CLUSTERED 
(
	[idlocalexecucaoservico] ASC
)
) ON [PRIMARY];

INSERT [localexecucaoservico] ([idlocalexecucaoservico], [nomelocalexecucaoservico], [deleted]) VALUES (1, N'Interno', N'N');
INSERT [localexecucaoservico] ([idlocalexecucaoservico], [nomelocalexecucaoservico], [deleted]) VALUES (2, N'Externo', N'N');
INSERT [localexecucaoservico] ([idlocalexecucaoservico], [nomelocalexecucaoservico], [deleted]) VALUES (4, N'Interno/Externo', NULL);

CREATE TABLE [lingua](
	[idlingua] [int] NOT NULL,
	[nome] [varchar](245) NULL,
	[sigla] [varchar](245) NULL,
	[datainicio] [date] NULL,
	[datafim] [date] NULL,
PRIMARY KEY CLUSTERED 
(
	[idlingua] ASC
)
) ON [PRIMARY]

INSERT [lingua] ([idlingua], [nome], [sigla], [datainicio], [datafim]) VALUES (1, N'Português', N'PT', CAST(0xB1360B00 AS Date), NULL);
INSERT [lingua] ([idlingua], [nome], [sigla], [datainicio], [datafim]) VALUES (2, N'Inglês', N'EN', CAST(0xB1360B00 AS Date), NULL);
INSERT [lingua] ([idlingua], [nome], [sigla], [datainicio], [datafim]) VALUES (3, N'Espanol',N'ES',CAST(0xB1360B00 AS Date),null);
CREATE TABLE [execucaobatch](
	[idexecucaobatch] [int] NOT NULL,
	[idprocessamentobatch] [int] NOT NULL,
	[conteudo] [text] NOT NULL,
	[datahora] [datetime] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idexecucaobatch] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE TABLE [execucaoatividadeperiodica](
	[idexecucaoatividadeperiodica] [int] NOT NULL,
	[idatividadeperiodica] [int] NOT NULL,
	[dataprogramada] [date] NOT NULL,
	[horaprogramada] [char](5) NULL,
	[situacao] [char](1) NOT NULL,
	[detalhamento] [text] NULL,
	[usuario] [char](1) NULL,
	[idempregado] [int] NULL,
	[dataexecucao] [date] NULL,
	[horaexecucao] [char](5) NULL,
	[dataregistro] [date] NULL,
	[horaregistro] [char](5) NULL,
	[idprogramacaoatividade] [int] NULL,
	[idmotivosuspensao] [int] NULL,
	[complementomotivosuspensao] [text] NULL,
PRIMARY KEY CLUSTERED 
(
	[idexecucaoatividadeperiodica] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE TABLE [excecaoempregado](
	[idevento] [int] NOT NULL,
	[idempregado] [int] NOT NULL,
	[idgrupo] [int] NULL,
	[idunidade] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[idevento] ASC,
	[idempregado] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_EXCECAOEMPREGADO] ON [excecaoempregado] 
(
	[idempregado] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_EXCECAOGRUPO] ON [excecaoempregado] 
(
	[idgrupo] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_EXCECAOUNIDADE] ON [excecaoempregado] 
(
	[idunidade] ASC
)ON [PRIMARY];

CREATE TABLE [excecaocalendario](
	[idexcecaocalendario] [int] NOT NULL,
	[idcalendario] [int] NOT NULL,
	[idjornada] [int] NULL,
	[tipo] [char](1) NOT NULL,
	[datainicio] [date] NOT NULL,
	[datatermino] [date] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idexcecaocalendario] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_540] ON [excecaocalendario] 
(
	[idcalendario] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_541] ON [excecaocalendario] 
(
	[idjornada] ASC
)ON [PRIMARY];

CREATE TABLE [eventounidade](
	[idunidade] [int] NULL,
	[idevento] [int] NULL
) ON [PRIMARY];

CREATE TABLE [eventomonitoramento](
	[ideventomonitoramento] [int] NOT NULL,
	[nomeevento] [varchar](255) NOT NULL,
	[detalhamento] [text] NULL,
	[criadopor] [varchar](255) NULL,
	[modificadopor] [varchar](255) NULL,
	[datacriacao] [date] NULL,
	[ultmodificacao] [date] NULL,
PRIMARY KEY CLUSTERED 
(
	[ideventomonitoramento] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE TABLE [eventomonitconhecimento](
	[ideventomonitoramento] [int] NOT NULL,
	[idbaseconhecimento] [int] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[ideventomonitoramento] ASC,
	[idbaseconhecimento] ASC
)
) ON [PRIMARY];

CREATE TABLE [eventoitemconfiguracao](
	[idevento] [int] NOT NULL,
	[iditemconfiguracao] [int] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idevento] ASC,
	[iditemconfiguracao] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [iditemconfiguracao] ON [eventoitemconfiguracao] 
(
	[iditemconfiguracao] ASC
)ON [PRIMARY];

CREATE TABLE [eventogrupo](
	[idevento] [int] NULL,
	[idgrupo] [int] NULL
) ON [PRIMARY];

CREATE TABLE [eventoempregado](
	[idevento] [int] NOT NULL,
	[idempregado] [int] NOT NULL,
	[idgrupo] [int] NULL,
	[idunidade] [int] NULL,
	[iditemconfiguracaopai] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[idevento] ASC,
	[idempregado] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_EVENTOEMPREGADO] ON [eventoempregado] 
(
	[idempregado] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_EVENTOGRUPO] ON [eventoempregado] 
(
	[idgrupo] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_EVENTOUNIDADE] ON [eventoempregado] 
(
	[idunidade] ASC
)ON [PRIMARY];

CREATE TABLE [evento](
	[idevento] [int] NOT NULL,
	[idempresa] [int] NOT NULL,
	[descricao] [varchar](255) NOT NULL,
	[ligarcasodesl] [char](1) NOT NULL,
	[datainicio] [date] NULL,
	[datafim] [date] NULL,
	[usuario] [varchar](256) NULL,
	[senha] [varchar](256) NULL,
PRIMARY KEY CLUSTERED 
(
	[idevento] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_EVENTOEMPRESA] ON [evento] 
(
	[idempresa] ASC
)ON [PRIMARY];

CREATE TABLE [etapas](
	[idetapa] [int] NOT NULL,
	[idfluxo] [int] NOT NULL,
	[idetapapai] [int] NULL,
	[nomeetapa] [varchar](70) NOT NULL,
	[ordem] [smallint] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idetapa] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_ETAPAFLUXO] ON [etapas] 
(
	[idfluxo] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_ETAPASETAPAPAI] ON [etapas] 
(
	[idetapapai] ASC
)ON [PRIMARY];

CREATE TABLE [externalconnection](
	[idexternalconnection] [int] NOT NULL,
	[nome] [varchar](80) NOT NULL,
	[tipo] [char](1) NOT NULL,
	[urljdbc] [varchar](255) NULL,
	[jdbcdbname] [varchar](255) NULL,
	[jdbcdriver] [varchar](255) NULL,
	[jdbcuser] [varchar](255) NULL,
	[jdbcpassword] [varchar](255) NULL,
	[filename] [varchar](500) NULL,
	[schemadb] [varchar](255) NULL,
	[deleted] [char](1) NULL,
PRIMARY KEY CLUSTERED 
(
	[idexternalconnection] ASC
)
) ON [PRIMARY];

CREATE TABLE [execucaosolicitacao](
	[idexecucao] [bigint] NOT NULL,
	[idsolicitacaoservico] [bigint] NULL,
	[idfase] [bigint] NULL,
	[idinstanciafluxo] [bigint] NULL,
	[idfluxo] [bigint] NULL,
	[prazohh] [smallint] NULL,
	[prazomm] [smallint] NULL,
	[seqreabertura] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[idexecucao] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_116] ON [execucaosolicitacao] 
(
	[idsolicitacaoservico] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_118] ON [execucaosolicitacao] 
(
	[idfase] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_128] ON [execucaosolicitacao] 
(
	[idfluxo] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_130] ON [execucaosolicitacao] 
(
	[idinstanciafluxo] ASC
)ON [PRIMARY];

INSERT [execucaosolicitacao] ([idexecucao], [idsolicitacaoservico], [idfase], [idinstanciafluxo], [idfluxo], [prazohh], [prazomm], [seqreabertura]) VALUES (1, 1, 2, 1, 3, 0, 0, NULL);
INSERT [execucaosolicitacao] ([idexecucao], [idsolicitacaoservico], [idfase], [idinstanciafluxo], [idfluxo], [prazohh], [prazomm], [seqreabertura]) VALUES (2, 2, 2, 2, 3, 0, 0, NULL);
INSERT [execucaosolicitacao] ([idexecucao], [idsolicitacaoservico], [idfase], [idinstanciafluxo], [idfluxo], [prazohh], [prazomm], [seqreabertura]) VALUES (3, 3, 2, 3, 3, 0, 0, NULL);
INSERT [execucaosolicitacao] ([idexecucao], [idsolicitacaoservico], [idfase], [idinstanciafluxo], [idfluxo], [prazohh], [prazomm], [seqreabertura]) VALUES (4, 4, 2, 4, 3, 0, 0, NULL);

CREATE TABLE [execucaoproblema](
	[idexecucao] [bigint] NOT NULL,
	[idproblema] [bigint] NULL,
	[idfase] [bigint] NULL,
	[idinstanciafluxo] [bigint] NULL,
	[idfluxo] [bigint] NULL,
	[prazohh] [smallint] NULL,
	[prazomm] [smallint] NULL,
	[seqreabertura] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[idexecucao] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_execprob_fase] ON [execucaoproblema] 
(
	[idfase] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_execprob_fluxo] ON [execucaoproblema] 
(
	[idfluxo] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_execprob_instanciafluxo] ON [execucaoproblema] 
(
	[idinstanciafluxo] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_execprob_problema] ON [execucaoproblema] 
(
	[idproblema] ASC
)ON [PRIMARY];

CREATE TABLE [execucaodemanda](
	[idexecucao] [int] NOT NULL,
	[iddemanda] [int] NOT NULL,
	[idatividade] [int] NOT NULL,
	[idempregadoexecutor] [int] NULL,
	[idempregadoreceptor] [int] NULL,
	[relato] [text] NULL,
	[qtdehoras] [decimal](18, 3) NULL,
	[situacao] [char](1) NOT NULL,
	[grupoexecutor] [varchar](20) NULL,
	[terminoprevisto] [date] NULL,
	[terminoreal] [date] NULL,
PRIMARY KEY CLUSTERED 
(
	[idexecucao] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_EXECUCAOATIVIDADE] ON [execucaodemanda] 
(
	[idatividade] ASC
)ON [PRIMARY];

CREATE TABLE [empresa](
	[idempresa] [int] NOT NULL,
	[nomeempresa] [varchar](150) NOT NULL,
	[detalhamento] [text] NULL,
	[datainicio] [date] NULL,
	[datafim] [date] NULL,
PRIMARY KEY CLUSTERED 
(
	[idempresa] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

INSERT [empresa] ([idempresa], [nomeempresa], [detalhamento], [datainicio], [datafim]) VALUES (1, N'Default', N'', CAST(0xE0360B00 AS Date), NULL);

CREATE TABLE [empregadoitemconfiguracao](
	[idusuario] [int] NOT NULL,
	[iditemconfiguracao] [int] NOT NULL,
	[idempregado] [int] NULL,
	[datainicio] [date] NOT NULL,
	[datafim] [date] NULL,
PRIMARY KEY CLUSTERED 
(
	[idusuario] ASC,
	[iditemconfiguracao] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_EMPREGADO] ON [empregadoitemconfiguracao] 
(
	[idempregado] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_EMPREGADOITEMCONFIGURACAO] ON [empregadoitemconfiguracao] 
(
	[iditemconfiguracao] ASC
)ON [PRIMARY];

CREATE TABLE [emailsolicitacaoservico](
	[messageid] [varchar](500) NOT NULL,
	[situacao] [varchar](25) NOT NULL,
	[idemailsolicitacaoservico] [int] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idemailsolicitacaoservico] ASC
)
) ON [PRIMARY];

CREATE TABLE [historicoic](
	[idhistoricoic] [int] NOT NULL,
	[iditemconfiguracao] [int] NOT NULL,
	[identificacao] [varchar](400) NOT NULL,
	[iditemconfiguracaopai] [int] NULL,
	[idtipoitemconfiguracao] [int] NULL,
	[idgrupoitemconfiguracao] [int] NULL,
	[idproprietario] [int] NULL,
	[versao] [varchar](250) NULL,
	[familia] [varchar](250) NULL,
	[idfamiliaitemconfiguracao] [int] NULL,
	[classe] [varchar](250) NULL,
	[idclasseitemconfiguracao] [int] NULL,
	[localidade] [varchar](250) NULL,
	[status] [int] NULL,
	[criticidade] [int] NULL,
	[numeroSerie] [varchar](45) NULL,
	[dataExpiracao] [date] NULL,
	[idMudanca] [int] NULL,
	[idProblema] [int] NULL,
	[IdIncidente] [int] NULL,
	[idautoralteracao] [int] NOT NULL,
	[datahoraalteracao] [datetime] NOT NULL,
	[baseline] [varchar](30) NULL,
	[restauracao] [int] NULL,
	[idMidiaSoftware] [int] NULL,
	[impacto] [varchar](255) NULL,
	[urgencia] [varchar](255) NULL,
	[historicoVersao] [decimal](15, 3) NULL,
PRIMARY KEY CLUSTERED 
(
	[idhistoricoic] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_autoralteracao] ON [historicoic] 
(
	[idautoralteracao] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_classeitemconfiguracao] ON [historicoic] 
(
	[idclasseitemconfiguracao] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_familiaitemconfiguracao] ON [historicoic] 
(
	[idfamiliaitemconfiguracao] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_itemconfiguracao] ON [historicoic] 
(
	[iditemconfiguracao] ASC
)ON [PRIMARY];

CREATE TABLE [historicoexecucao](
	[idhistorico] [int] NOT NULL,
	[idexecucao] [int] NOT NULL,
	[data] [date] NOT NULL,
	[situacao] [char](1) NOT NULL,
	[idempregadoexecutor] [int] NOT NULL,
	[detalhamento] [text] NULL,
	[hora] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[idhistorico] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_historic_reference_execucao] ON [historicoexecucao] 
(
	[idexecucao] ASC
)ON [PRIMARY];

CREATE TABLE [historicobaseconhecimento](
	[idhistoricobaseconhecimento] [int] NOT NULL,
	[idbaseconhecimento] [int] NOT NULL,
	[idpasta] [int] NULL,
	[datainicio] [date] NULL,
	[datafim] [date] NULL,
	[titulo] [varchar](256) NULL,
	[conteudo] [text] NULL,
	[status] [char](1) NULL,
	[idbaseconhecimentopai] [int] NULL,
	[dataexpiracao] [date] NULL,
	[versao] [varchar](45) NULL,
	[idusuarioautor] [int] NULL,
	[idusuarioaprovador] [int] NULL,
	[fontereferencia] [varchar](255) NULL,
	[idnotificacao] [int] NULL,
	[datapublicacao] [date] NULL,
	[justificativaobservacao] [varchar](500) NULL,
	[faq] [varchar](45) NULL,
	[origem] [char](1) NULL,
	[arquivado] [varchar](45) NULL,
	[idusuarioalteracao] [int] NULL,
	[datahoraalteracao] [datetime] NULL,
	[conteudosemformatacao] [text] NULL,
PRIMARY KEY CLUSTERED 
(
	[idhistoricobaseconhecimento] ASC,
	[idbaseconhecimento] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

INSERT [historicobaseconhecimento] ([idhistoricobaseconhecimento], [idbaseconhecimento], [idpasta], [datainicio], [datafim], [titulo], [conteudo], [status], [idbaseconhecimentopai], [dataexpiracao], [versao], [idusuarioautor], [idusuarioaprovador], [fontereferencia], [idnotificacao], [datapublicacao], [justificativaobservacao], [faq], [origem], [arquivado], [idusuarioalteracao], [datahoraalteracao], [conteudosemformatacao]) VALUES (1, 1, 1, CAST(0xF5360B00 AS Date), NULL, N'Conhecimento 1', N'Descri&ccedil;&atilde;o Conhecimento 1<br />', N'S', NULL, CAST(0x6D390B00 AS Date), N'1.0', 1, 1, N'Conhecimento 1', NULL, CAST(0xF5360B00 AS Date), N'Justificativa Conhecimento 1', NULL, N'1', N'N', 1, CAST('2013-04-05 13:40:00' AS datetime), NULL);
INSERT [historicobaseconhecimento] ([idhistoricobaseconhecimento], [idbaseconhecimento], [idpasta], [datainicio], [datafim], [titulo], [conteudo], [status], [idbaseconhecimentopai], [dataexpiracao], [versao], [idusuarioautor], [idusuarioaprovador], [fontereferencia], [idnotificacao], [datapublicacao], [justificativaobservacao], [faq], [origem], [arquivado], [idusuarioalteracao], [datahoraalteracao], [conteudosemformatacao]) VALUES (2, 2, 2, CAST(0xF5360B00 AS Date), NULL, N'Conhecimento 2', N'Descri&ccedil;&atilde;o Conhecimento 2<br />', N'S', NULL, CAST(0x6D390B00 AS Date), N'1.0', 1, 1, N'', NULL, CAST(0xF5360B00 AS Date), N'Justificativa Conhecimento 2', NULL, N'1', N'N', 1, CAST('2013-04-05 13:40:00' AS datetime), NULL);
INSERT [historicobaseconhecimento] ([idhistoricobaseconhecimento], [idbaseconhecimento], [idpasta], [datainicio], [datafim], [titulo], [conteudo], [status], [idbaseconhecimentopai], [dataexpiracao], [versao], [idusuarioautor], [idusuarioaprovador], [fontereferencia], [idnotificacao], [datapublicacao], [justificativaobservacao], [faq], [origem], [arquivado], [idusuarioalteracao], [datahoraalteracao], [conteudosemformatacao]) VALUES (3, 3, 1, CAST(0xF5360B00 AS Date), NULL, N'FAQ 1', N'Resposta FAQ 1<br />', N'S', NULL, CAST(0x6D390B00 AS Date), N'1.0', 1, 1, N'FAQ 1', NULL, CAST(0xF5360B00 AS Date), N'Justificativa FAQ 1', N'S', N'1', N'N', 1, CAST('2013-04-05 13:40:00' AS datetime), NULL);
INSERT [historicobaseconhecimento] ([idhistoricobaseconhecimento], [idbaseconhecimento], [idpasta], [datainicio], [datafim], [titulo], [conteudo], [status], [idbaseconhecimentopai], [dataexpiracao], [versao], [idusuarioautor], [idusuarioaprovador], [fontereferencia], [idnotificacao], [datapublicacao], [justificativaobservacao], [faq], [origem], [arquivado], [idusuarioalteracao], [datahoraalteracao], [conteudosemformatacao]) VALUES (4, 4, 2, CAST(0xF5360B00 AS Date), NULL, N'FAQ 2', N'Resposta FAQ 2', N'S', NULL, CAST(0x6D390B00 AS Date), N'1.0', 1, 1, N'FAQ 2', NULL, CAST(0xF5360B00 AS Date), N'Justificativa FAQ 2', N'S', N'1', N'N', 1, CAST('2013-04-05 13:40:00' AS datetime), NULL);

CREATE TABLE [hilosequences](
	[SEQUENCENAME] [varchar](50) NOT NULL,
	[HIGHVALUES] [int] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[SEQUENCENAME] ASC
)
) ON [PRIMARY];

CREATE TABLE [grupovisaocamposnegocioligacao](
	[idgrupovisaocamposnegocioligaca] [bigint] NOT NULL,
	[idgrupovisao] [bigint] NOT NULL,
	[idcamposobjetonegocio] [bigint] NOT NULL,
	[idcamposobjetonegocioligacao] [bigint] NULL,
	[tipoligacao] [char](1) NOT NULL,
	[filtro] [text] NULL,
	[descricao] [varchar](400) NULL,
PRIMARY KEY CLUSTERED 
(
	[idgrupovisaocamposnegocioligaca] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_84] ON [grupovisaocamposnegocioligacao] 
(
	[idgrupovisao] ASC,
	[idcamposobjetonegocio] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_85] ON [grupovisaocamposnegocioligacao] 
(
	[idcamposobjetonegocioligacao] ASC
)ON [PRIMARY];

CREATE TABLE [grupovisaocamposnegocioinfosql](
	[idgrupovisaocamposnegocioinfosql] [bigint] NOT NULL,
	[idgrupovisao] [bigint] NOT NULL,
	[idcamposobjetonegocio] [bigint] NOT NULL,
	[campo] [varchar](150) NOT NULL,
	[tipoligacao] [char](1) NOT NULL,
	[filtro] [text] NULL,
	[descricao] [varchar](400) NULL,
PRIMARY KEY CLUSTERED 
(
	[idgrupovisaocamposnegocioinfosql] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_86] ON [grupovisaocamposnegocioinfosql] 
(
	[idgrupovisao] ASC,
	[idcamposobjetonegocio] ASC
)ON [PRIMARY];

CREATE TABLE [grupovisaocamposnegocio](
	[idgrupovisao] [bigint] NOT NULL,
	[idcamposobjetonegocio] [bigint] NOT NULL,
	[descricaonegocio] [varchar](500) NOT NULL,
	[tiponegocio] [varchar](20) NOT NULL,
	[ordem] [int] NOT NULL,
	[situacao] [char](1) NOT NULL,
	[obrigatorio] [char](1) NOT NULL,
	[tamanho] [smallint] NOT NULL,
	[decimais] [smallint] NOT NULL,
	[tipoligacao] [char](1) NULL,
	[textosql] [text] NULL,
	[tamanhoparapesq] [smallint] NULL,
	[formula] [text] NULL,
	[visivel] [char](1) NOT NULL,
	[htmlcode] [text] NULL,
PRIMARY KEY CLUSTERED 
(
	[idgrupovisao] ASC,
	[idcamposobjetonegocio] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_77] ON [grupovisaocamposnegocio] 
(
	[idcamposobjetonegocio] ASC
)ON [PRIMARY];

CREATE TABLE [grupovisao](
	[idgrupovisao] [bigint] NOT NULL,
	[idvisao] [bigint] NOT NULL,
	[descricaogrupovisao] [varchar](500) NOT NULL,
	[forma] [char](1) NOT NULL,
	[ordem] [int] NOT NULL,
	[situacao] [char](1) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idgrupovisao] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_75] ON [grupovisao] 
(
	[idvisao] ASC
)ON [PRIMARY];

INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (3, 7, N'Visão de Empresa', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (7, 8, N'Listagem de Empregados', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (8, 9, N'Endereços', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (12, 10, N'Grupos de Segurança do Empregado', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (15, 5, N'Visão Empregados', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (19, 13, N'Listagem de Fluxos', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (114, 39, N'Pesquisa Causa de Incidentes', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (120, 45, N'$grupo.recursos.lista', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (121, 46, N'$nagios.conexao.listagem', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (122, 47, N'$requisitosla.pesquisasla', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (123, 48, N'$visao.listagemAcordoNivelServico', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (124, 22, N'$visao.listagemClientes', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (125, 49, N'$visao.listagemConexoesExternas', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (126, 25, N'$visao.listagemContratos', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (127, 50, N'$visao.listagemEmpregados', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (128, 51, N'$visao.listagemFluxos', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (129, 52, N'$visao.listagemFluxoTrabalho', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (130, 24, N'$visao.listagemFornecedores', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (131, 35, N'$visao.listagemLocalExecucaoServico', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (132, 18, N'$visao.listagemServicosCriacao', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (133, 31, N'$visao.listagemTipoEventoServico', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (134, 53, N'$visao.pesquisaCategoriaSolucao', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (135, 41, N'$visao.pesquisaCausaIncidentes', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (136, 43, N'$visao.pesquisaGrupoAtividadePeriodica', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (137, 37, N'$visao.pesquisaJustificativaSolicitacao', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (138, 33, N'$visao.pesquisaTipoSolicitacaoServico', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (139, 54, N'$contrato.historicoauditoria', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (140, 55, N'$grupo.recursos', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (141, 32, N'$menu.nome.tipoSolicitacaoServico', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (142, 56, N'$nagios.conexao.titulo', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (143, 57, N'$requisitosla.sla', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (144, 58, N'$sla.historicoauditoria', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (145, 59, N'$sla.listacontratosvinculadosano', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (146, 60, N'$sla.listacontratosvinculadoscliente', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (147, 61, N'$sla.listacontratosvinculadosterceiro', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (148, 62, N'$slarequisitosla.titulo', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (149, 63, N'$sla.revisar.revisar', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (150, 28, N'$visao.acordoNivelServicoContrato', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (151, 14, N'$visao.cadastroFluxos', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (152, 64, N'$visao.complexidades', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (153, 29, N'$visao.fluxoServico', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (154, 65, N'$visao.historicoAuditoriaServico', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (155, 66, N'$visao.vincularSlaServico', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (156, 67, N'$visao.acordoGeral', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (157, 26, N'$visao.acordoNivelServico', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (158, 15, N'$visao.analiseIncidente', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (159, 16, N'$visao.atendimento', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (160, 27, N'$visao.atividadesServico', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (161, 30, N'$visao.CadastroTipoEventoServico', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (162, 40, N'$visao.categoriaSolucao', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (163, 38, N'$visao.causaIncidentes', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (164, 21, N'$visao.clientes', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (165, 68, N'$visao.conexoesExternas', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (166, 20, N'$visao.contratos', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (167, 17, N'$visao.criacaoServicos', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (168, 69, N'$visao.enderecos', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (169, 23, N'$visao.fornecedores', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (170, 42, N'$visao.grupoAtividadePeriodica', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (171, 70, N'$visao.gruposSegurancaEmpregados', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (172, 12, N'$visao.incidente', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (173, 36, N'$visao.justificativaSolicitacao', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (174, 34, N'$visao.localExecucaoServico', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (175, 19, N'$visao.servicoContrato', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (176, 44, N'$visao.servicoContratoMulti', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (177, 71, N'$visao.visaoEmpregados', N'1', 0, N'A');
INSERT [grupovisao] ([idgrupovisao], [idvisao], [descricaogrupovisao], [forma], [ordem], [situacao]) VALUES (178, 72, N'$visao.visaoEmpresa', N'1', 0, N'A');

CREATE TABLE [gruposempregados](
	[idgrupo] [int] NOT NULL,
	[idempregado] [int] NOT NULL,
	[enviaemail] [char](1) NULL,
PRIMARY KEY CLUSTERED 
(
	[idgrupo] ASC,
	[idempregado] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_GRUPOSEMPREGADO] ON [gruposempregados] 
(
	[idempregado] ASC
)ON [PRIMARY];

INSERT [gruposempregados] ([idgrupo], [idempregado], [enviaemail]) VALUES (2, 1, N'N');
INSERT [gruposempregados] ([idgrupo], [idempregado], [enviaemail]) VALUES (2, 2, N'N');
INSERT [gruposempregados] ([idgrupo], [idempregado], [enviaemail]) VALUES (2, 3, N'N');
INSERT [gruposempregados] ([idgrupo], [idempregado], [enviaemail]) VALUES (3, 1, N'N');
INSERT [gruposempregados] ([idgrupo], [idempregado], [enviaemail]) VALUES (3, 3, N'N');
INSERT [gruposempregados] ([idgrupo], [idempregado], [enviaemail]) VALUES (4, 1, N'N');
INSERT [gruposempregados] ([idgrupo], [idempregado], [enviaemail]) VALUES (4, 3, N'N');
INSERT [gruposempregados] ([idgrupo], [idempregado], [enviaemail]) VALUES (16, 3, N'N');
INSERT [gruposempregados] ([idgrupo], [idempregado], [enviaemail]) VALUES (17, 1, N'N');
INSERT [gruposempregados] ([idgrupo], [idempregado], [enviaemail]) VALUES (17, 3, N'N');
INSERT [gruposempregados] ([idgrupo], [idempregado], [enviaemail]) VALUES (18, 1, N'N');
INSERT [gruposempregados] ([idgrupo], [idempregado], [enviaemail]) VALUES (19, 1, N'N');
INSERT [gruposempregados] ([idgrupo], [idempregado], [enviaemail]) VALUES (19, 3, N'N');

CREATE TABLE [gruposemails](
	[idgrupo] [int] NOT NULL,
	[idempregado] [int] NULL,
	[nome] [varchar](80) NULL,
	[email] [varchar](200) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idgrupo] ASC,
	[email] ASC
)
) ON [PRIMARY];

CREATE TABLE [gruporecursos](
	[idgruporecurso] [int] NOT NULL,
	[nomegruporecurso] [varchar](70) NOT NULL,
	[situacao] [char](1) NOT NULL,
	[deleted] [char](1) NULL,
PRIMARY KEY CLUSTERED 
(
	[idgruporecurso] ASC
)
) ON [PRIMARY];

CREATE TABLE [grupoquestionario](
	[idgrupoquestionario] [int] NOT NULL,
	[idquestionario] [int] NOT NULL,
	[nomegrupoquestionario] [varchar](80) NOT NULL,
	[ordem] [smallint] NULL,
PRIMARY KEY CLUSTERED 
(
	[idgrupoquestionario] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_GRUPOQUESTQUESTIONARIO] ON [grupoquestionario] 
(
	[idquestionario] ASC
)ON [PRIMARY];

CREATE TABLE [grupoitemconfiguracao](
	[idgrupoitemconfiguracao] [int] NOT NULL,
	[nomegrupoitemconfiguracao] [varchar](100) NOT NULL,
	[datainicio] [date] NOT NULL,
	[datafim] [date] NULL,
	[email] [varchar](50) NULL,
	[emailgrupoitemconfiguracao] [varchar](256) NULL,
	[idGrupoItemConfiguracaoPai] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[idgrupoitemconfiguracao] ASC
)
) ON [PRIMARY];

CREATE TABLE [grupoatvperiodica](
	[idgrupoatvperiodica] [int] NOT NULL,
	[nomegrupoatvperiodica] [varchar](256) NOT NULL,
	[descgrupoatvperiodica] [text] NULL,
	[datainicio] [date] NOT NULL,
	[datafim] [date] NULL,
	[deleted] [char](1) NULL,
PRIMARY KEY CLUSTERED 
(
	[idgrupoatvperiodica] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE TABLE [grupo](
	[idgrupo] [int] NOT NULL,
	[idempresa] [int] NOT NULL,
	[nome] [varchar](255) NOT NULL,
	[datainicio] [date] NOT NULL,
	[datafim] [date] NULL,
	[descricao] [text] NULL,
	[servicedesk] [char](1) NULL,
	[sigla] [varchar](20) NULL,
	[abertura] [varchar](45) NULL,
	[encerramento] [varchar](45) NULL,
	[andamento] [varchar](45) NULL,
	[comiteconsultivomudanca] [varchar](1) NULL,
PRIMARY KEY CLUSTERED 
(
	[idgrupo] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_GRUPOEMPRESA] ON [grupo] 
(
	[idempresa] ASC
)ON [PRIMARY];

INSERT [grupo] ([idgrupo], [idempresa], [nome], [datainicio], [datafim], [descricao], [servicedesk], [sigla], [abertura], [encerramento], [andamento], [comiteconsultivomudanca]) VALUES (1, 1, N'Desenvolvimento', CAST(0x26350B00 AS Date), NULL, N'Esse grupo possui perfil de acesso Supervisão.', N'N', N'DES', NULL, NULL, NULL, N'');
INSERT [grupo] ([idgrupo], [idempresa], [nome], [datainicio], [datafim], [descricao], [servicedesk], [sigla], [abertura], [encerramento], [andamento], [comiteconsultivomudanca]) VALUES (2, 1, N'1º NíVEL', CAST(0x26350B00 AS Date), NULL, N'Atendimento de 1º Nível.', N'S', N'SDNIVEL1', NULL, NULL, NULL, N'');
INSERT [grupo] ([idgrupo], [idempresa], [nome], [datainicio], [datafim], [descricao], [servicedesk], [sigla], [abertura], [encerramento], [andamento], [comiteconsultivomudanca]) VALUES (3, 1, N'2º NíVEL', CAST(0x26350B00 AS Date), NULL, N'Atendimento de 2º Nível.', N'S', N'SDNIVEL2', NULL, NULL, NULL, N'');
INSERT [grupo] ([idgrupo], [idempresa], [nome], [datainicio], [datafim], [descricao], [servicedesk], [sigla], [abertura], [encerramento], [andamento], [comiteconsultivomudanca]) VALUES (4, 1, N'3º NíVEL - Infraestrutura', CAST(0x26350B00 AS Date), NULL, N'Atendimento de 3º Nível - Infraestrutura', N'S', N'SDNIVEL3Infra', NULL, NULL, NULL, N'');
INSERT [grupo] ([idgrupo], [idempresa], [nome], [datainicio], [datafim], [descricao], [servicedesk], [sigla], [abertura], [encerramento], [andamento], [comiteconsultivomudanca]) VALUES (5, 1, N'Qualidade', CAST(0x26350B00 AS Date), NULL, N'Alterado por valdoílo para teste.', N'S', N'QUALIDADE', NULL, NULL, NULL, N'');
INSERT [grupo] ([idgrupo], [idempresa], [nome], [datainicio], [datafim], [descricao], [servicedesk], [sigla], [abertura], [encerramento], [andamento], [comiteconsultivomudanca]) VALUES (6, 1, N'Gestores Internos', CAST(0x26350B00 AS Date), NULL, N'Gestores Internos', N'S', N'GESTORES', NULL, NULL, NULL, N'');
INSERT [grupo] ([idgrupo], [idempresa], [nome], [datainicio], [datafim], [descricao], [servicedesk], [sigla], [abertura], [encerramento], [andamento], [comiteconsultivomudanca]) VALUES (7, 1, N'Coordenadores Externos', CAST(0x26350B00 AS Date), NULL, N'Coordenadores Externos', N'N', N'COORD_EXT', NULL, NULL, NULL, N'');
INSERT [grupo] ([idgrupo], [idempresa], [nome], [datainicio], [datafim], [descricao], [servicedesk], [sigla], [abertura], [encerramento], [andamento], [comiteconsultivomudanca]) VALUES (16, 1, N'3º NíVEL - Aplicação', CAST(0x26350B00 AS Date), NULL, N'3º NíVEL - Aplicação', N'S', N'SDNIVEL3Apli', NULL, NULL, NULL, N'');
INSERT [grupo] ([idgrupo], [idempresa], [nome], [datainicio], [datafim], [descricao], [servicedesk], [sigla], [abertura], [encerramento], [andamento], [comiteconsultivomudanca]) VALUES (17, 1, N'3º NíVEL - Sistemas', CAST(0x26350B00 AS Date), NULL, N'3º NíVEL - Sistemas', N'S', N'SDNIVEL3Sist', NULL, NULL, NULL, N'');
INSERT [grupo] ([idgrupo], [idempresa], [nome], [datainicio], [datafim], [descricao], [servicedesk], [sigla], [abertura], [encerramento], [andamento], [comiteconsultivomudanca]) VALUES (18, 1, N'Coordenador', CAST(0x26350B00 AS Date), NULL, N'Coordenador de Infraestrutura', N'S', N'COORDENAÇÃO', NULL, NULL, NULL, N'');
INSERT [grupo] ([idgrupo], [idempresa], [nome], [datainicio], [datafim], [descricao], [servicedesk], [sigla], [abertura], [encerramento], [andamento], [comiteconsultivomudanca]) VALUES (19, 1, N'3º NíVEL - Telefonia', CAST(0x26350B00 AS Date), NULL, N'3º NíVEL - Telefonia', N'N', N'SDNIVEL3Telefonia', NULL, NULL, NULL, N'');
INSERT [grupo] ([idgrupo], [idempresa], [nome], [datainicio], [datafim], [descricao], [servicedesk], [sigla], [abertura], [encerramento], [andamento], [comiteconsultivomudanca]) VALUES (20, 1, N'Gerentes', CAST(0x26350B00 AS Date), NULL, N'', N'S', N'GER', NULL, NULL, NULL, N'');

CREATE TABLE [glosaservicocontrato](
	[idglosaservicocontrato] [bigint] NOT NULL,
	[idservicocontrato] [bigint] NOT NULL,
	[quantidadeglosa] [int] NULL,
	[datafim] [date] NULL,
PRIMARY KEY CLUSTERED 
(
	[idglosaservicocontrato] ASC
)
) ON [PRIMARY];

CREATE TABLE [glosaos](
	[idglosaos] [int] NOT NULL,
	[idos] [int] NOT NULL,
	[datacriacao] [date] NOT NULL,
	[dataultmodificacao] [date] NOT NULL,
	[descricaoglosa] [text] NOT NULL,
	[ocorrencias] [text] NULL,
	[percaplicado] [decimal](15, 3) NOT NULL,
	[custoglosa] [decimal](15, 3) NOT NULL,
	[numeroOcorrencias] [decimal](15, 3) NULL,
	[idacordonivelservico] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[idglosaos] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_504] ON [glosaos] 
(
	[idos] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_618] ON [glosaos] 
(
	[idacordonivelservico] ASC
)ON [PRIMARY];

CREATE TABLE [galeriaimagens](
	[idimagem] [int] NOT NULL,
	[idcategoriagaleriaimagem] [int] NOT NULL,
	[nomeimagem] [varchar](255) NOT NULL,
	[descricaoimagem] [varchar](70) NULL,
	[detalhamento] [text] NULL,
	[extensao] [varchar](15) NULL,
PRIMARY KEY CLUSTERED 
(
	[idimagem] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_GALERIACATERIAGALERIAIMAGEM] ON [galeriaimagens] 
(
	[idcategoriagaleriaimagem] ASC
)ON [PRIMARY];

CREATE TABLE [fluxos](
	[idfluxo] [int] NOT NULL,
	[nomefluxo] [varchar](70) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idfluxo] ASC
)
) ON [PRIMARY];

CREATE TABLE [fluxo](
	[idfluxo] [int] NOT NULL,
	[nomefluxo] [varchar](70) NOT NULL,
	[descricao] [text] NULL,
PRIMARY KEY CLUSTERED 
(
	[idfluxo] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE TABLE [feriado](
	[idferiado] [int] NOT NULL,
	[data] [date] NOT NULL,
	[descricao] [varchar](100) NULL,
	[abrangencia] [char](1) NULL,
	[iduf] [int] NULL,
	[idcidade] [int] NULL,
	[recorrente] [char](1) NULL,
PRIMARY KEY CLUSTERED 
(
	[idferiado] ASC
)
) ON [PRIMARY];

CREATE TABLE [faturaos](
	[idfatura] [int] NOT NULL,
	[idos] [int] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idfatura] ASC,
	[idos] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_508] ON [faturaos] 
(
	[idos] ASC
)ON [PRIMARY];

CREATE TABLE [faturaapuracaoans](
	[idfaturaapuracaoans] [int] NOT NULL,
	[idfatura] [int] NOT NULL,
	[idacordonivelservicocontrato] [int] NOT NULL,
	[valorapurado] [decimal](15, 3) NULL,
	[detalhamento] [text] NULL,
	[percentualglosa] [decimal](15, 3) NULL,
	[valorglosa] [decimal](15, 3) NULL,
	[dataapuracao] [date] NULL,
PRIMARY KEY CLUSTERED 
(
	[idfaturaapuracaoans] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_510] ON [faturaapuracaoans] 
(
	[idfatura] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_511] ON [faturaapuracaoans] 
(
	[idacordonivelservicocontrato] ASC
)ON [PRIMARY];

CREATE TABLE [fatura](
	[idfatura] [int] NOT NULL,
	[idcontrato] [int] NOT NULL,
	[datainicial] [date] NOT NULL,
	[datafinal] [date] NOT NULL,
	[descricaofatura] [varchar](150) NULL,
	[valorcotacaomoeda] [decimal](15, 3) NOT NULL,
	[datacriacao] [date] NOT NULL,
	[dataultmodificacao] [date] NOT NULL,
	[valorprevistosomaos] [decimal](15, 3) NULL,
	[valorsomaglosasos] [decimal](15, 3) NULL,
	[valorexecutadosomaos] [decimal](15, 3) NULL,
	[observacao] [text] NULL,
	[aprovacaogestor] [text] NULL,
	[aprovacaofiscal] [text] NULL,
	[saldoprevisto] [decimal](15, 3) NULL,
	[situacaofatura] [char](1) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idfatura] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_505] ON [fatura] 
(
	[idcontrato] ASC
)ON [PRIMARY];

CREATE TABLE [formula](
	[idformula] [int] NOT NULL,
	[identificador] [varchar](120) NOT NULL,
	[nome] [varchar](120) NOT NULL,
	[conteudo] [text] NULL,
	[datacriacao] [date] NULL,
PRIMARY KEY CLUSTERED 
(
	[idformula] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE UNIQUE NONCLUSTERED INDEX [ix_identificador] ON [formula] 
(
	[identificador] ASC
)ON [PRIMARY];

INSERT [formula] ([idformula], [identificador], [nome], [conteudo], [datacriacao]) VALUES (1, N'Calculo de ANS Padrão', N'Calculo de ANS Padrão', N'if (faturaDTO.getFieldANS() == \"valorGlosa\"){   var percGlosa = (FormulasUtil.getDoubleValueFromGrid(request,   faturaDTO.getSeqANS(),  \"valorGlosa\") / faturaDTO.getValorExecutadoSomaOS()) * 100;    FormulasUtil.setDoubleValueFromGrid(document,  faturaDTO.getSeqANS(),  \"percentualGlosa\", percGlosa );}else{   var valorGlosa = faturaDTO.getValorExecutadoSomaOS() * (FormulasUtil.getDoubleValueFromGrid(request,   faturaDTO.getSeqANS(),  \"percentualGlosa\") / 100);   FormulasUtil.setDoubleValueFromGrid(document,  faturaDTO.getSeqANS(),  \"valorGlosa\", valorGlosa);}', NULL);
INSERT [formula] ([idformula], [identificador], [nome], [conteudo], [datacriacao]) VALUES (2, N'CalculoGLOSAOS', N'Calculo Glosa OS', N'if (osDTO.getFieldANS() == \"custoGlosa\"){   var percGlosa = (FormulasUtil.getDoubleValueFromGrid(request,   osDTO.getSeqANS(),  \"custoGlosa\") / osDTO.getExecutadoOS()) * 100;    FormulasUtil.setDoubleValueFromGrid(document,  osDTO.getSeqANS(),  \"percAplicado\", percGlosa ); }else{    var valorGlosa = osDTO.getExecutadoOS() * (FormulasUtil.getDoubleValueFromGrid(request,   osDTO.getSeqANS(),  \"percAplicado\") / 100);    FormulasUtil.setDoubleValueFromGrid(document,  osDTO.getSeqANS(),  \"custoGlosa\", valorGlosa);}', NULL);

CREATE TABLE [historicoliberacao](
	[idhistoricoliberacao] [int] NOT NULL,
	[idexecutormodificacao] [int] NOT NULL,
	[datahoraModificacao] [datetime] NOT NULL,
	[tipoModificacao] [varchar](1) NULL,
	[historicoVersao] [float] NULL,
	[idliberacao] [int] NOT NULL,
	[idsolicitante] [int] NOT NULL,
	[idresponsavel] [int] NULL,
	[titulo] [varchar](100) NOT NULL,
	[descricao] [text] NOT NULL,
	[datainicial] [date] NOT NULL,
	[datafinal] [date] NOT NULL,
	[dataliberacao] [date] NULL,
	[situacao] [char](1) NOT NULL,
	[risco] [char](1) NOT NULL,
	[versao] [varchar](25) NULL,
	[seqreabertura] [smallint] NULL,
	[enviaemailcriacao] [varchar](1) NULL,
	[enviaemailacoes] [varchar](1) NULL,
	[tempoatrasohh] [smallint] NULL,
	[tempoatrasomm] [smallint] NULL,
	[tempocapturahh] [smallint] NULL,
	[tempocapturamm] [smallint] NULL,
	[datahoratermino] [datetime] NOT NULL,
	[datahoraconclusao] [datetime] NOT NULL,
	[status] [varchar](45) NULL,
	[tempodecorridohh] [smallint] NULL,
	[tempodecorridomm] [smallint] NULL,
	[tempoatendimentohh] [smallint] NULL,
	[tempoatendimentomm] [smallint] NULL,
	[datahoracaptura] [datetime] NOT NULL,
	[datahorareativacao] [datetime] NOT NULL,
	[datahorainicio] [datetime] NOT NULL,
	[idcalendario] [int] NULL,
	[datahorasuspensao] [datetime] NOT NULL,
	[enviaemailfinalizacao] [varchar](1) NULL,
	[prazohh] [smallint] NULL,
	[prazomm] [smallint] NULL,
	[idproprietario] [int] NOT NULL,
	[datahorainicioagendada] [datetime] NOT NULL,
	[datahoraterminoagendada] [datetime] NOT NULL,
	[idtipoliberacao] [int] NULL,
	[idGrupoAtual] [int] NULL,
	[idcontatorequisicaoliberacao] [int] NULL,
	[telefonecontato] [varchar](45) NULL,
	[ramal] [varchar](5) NULL,
	[observacao] [text] NULL,
	[idunidade] [int] NULL,
	[nomecontato2] [varchar](80) NULL,
	[emailcontato] [varchar](200) NULL,
	[Idlocalidade] [int] NULL,
	[baseline] [varchar](30) NULL,
 CONSTRAINT [historicoliberacao_pkey] PRIMARY KEY CLUSTERED 
(
	[idhistoricoliberacao] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE TABLE [accountLines](
	[id] [int] NOT NULL,
	[someField] [int] NULL,
	[ts] [datetime] NULL,
PRIMARY KEY CLUSTERED 
(
	[id] ASC
)
) ON [PRIMARY];

INSERT [accountLines] ([id], [someField], [ts]) VALUES (1, 1, CAST('2013-04-05 13:40:00' AS DateTime));
INSERT [accountLines] ([id], [someField], [ts]) VALUES (2, 5, CAST('2013-04-05 13:40:00' AS DateTime));

CREATE TABLE [acordonivelservico](
	[idacordonivelservico] [bigint] NOT NULL,
	[idservicocontrato] [bigint] NULL,
	[idprioridadepadrao] [bigint] NULL,
	[situacao] [char](1) NOT NULL,
	[titulosla] [varchar](500) NOT NULL,
	[disponibilidade] [decimal](15, 3) NULL,
	[descricaosla] [text] NULL,
	[escoposla] [text] NULL,
	[datainicio] [date] NOT NULL,
	[datafim] [date] NULL,
	[avaliarem] [date] NULL,
	[tipo] [char](1) NULL,
	[deleted] [char](1) NULL,
	[valorLimite] [decimal](15, 3) NULL,
	[detalheGlosa] [text] NULL,
	[detalheLimiteGlosa] [text] NULL,
	[unidadeValorLimite] [varchar](150) NULL,
	[impacto] [char](1) NULL,
	[urgencia] [char](1) NULL,
	[permiteMudarImpUrg] [char](1) NULL,
	[idFormula] [int] NULL,
	[contatos] [text] NULL,
	[criadoEm] [datetime] NOT NULL,
	[criadoPor] [varchar](30) NULL,
	[modificadoEm] [datetime] NULL,
	[modificadoPor] [varchar](30) NULL,
	[tempoauto] [decimal](15, 3) NULL,
	[idprioridadeauto1] [int] NULL,
	[idprioridadeauto2] [int] NULL,
	[idprioridadeauto3] [int] NULL,
	[idprioridadeauto4] [int] NULL,
	[idprioridadeauto5] [int] NULL,
	[idgrupo1] [int] NULL,
	[idgrupo2] [int] NULL,
	[idgrupo3] [int] NULL,
	[idgrupo4] [int] NULL,
	[idgrupo5] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[idacordonivelservico] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_102] ON [acordonivelservico] 
(
	[idprioridadepadrao] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_39] ON [acordonivelservico] 
(
	[idservicocontrato] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_572] ON [acordonivelservico] 
(
	[idFormula] ASC
)ON [PRIMARY];

INSERT [acordonivelservico] ([idacordonivelservico], [idservicocontrato], [idprioridadepadrao], [situacao], [titulosla], [disponibilidade], [descricaosla], [escoposla], [datainicio], [datafim], [avaliarem], [tipo], [deleted], [valorLimite], [detalheGlosa], [detalheLimiteGlosa], [unidadeValorLimite], [impacto], [urgencia], [permiteMudarImpUrg], [idFormula], [contatos], [criadoEm], [criadoPor], [modificadoEm], [modificadoPor], [tempoauto], [idprioridadeauto1], [idprioridadeauto2], [idprioridadeauto3], [idprioridadeauto4], [idprioridadeauto5], [idgrupo1], [idgrupo2], [idgrupo3], [idgrupo4], [idgrupo5]) VALUES (1, NULL, NULL, N'A', N'SLA 1', NULL, N'Descrição do Acordo de Nível de Servico 1', N'', CAST(0xEE360B00 AS Date), NULL, CAST(0x6D390B00 AS Date), N'T', N'N', NULL, N'', N'', N'', N'B', N'B', N'S', NULL, N'', CAST('2013-04-05 13:40:00' AS datetime), NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT [acordonivelservico] ([idacordonivelservico], [idservicocontrato], [idprioridadepadrao], [situacao], [titulosla], [disponibilidade], [descricaosla], [escoposla], [datainicio], [datafim], [avaliarem], [tipo], [deleted], [valorLimite], [detalheGlosa], [detalheLimiteGlosa], [unidadeValorLimite], [impacto], [urgencia], [permiteMudarImpUrg], [idFormula], [contatos], [criadoEm], [criadoPor], [modificadoEm], [modificadoPor], [tempoauto], [idprioridadeauto1], [idprioridadeauto2], [idprioridadeauto3], [idprioridadeauto4], [idprioridadeauto5], [idgrupo1], [idgrupo2], [idgrupo3], [idgrupo4], [idgrupo5]) VALUES (2, NULL, NULL, N'A', N'SLA 2', NULL, N'Descrição do Acordo de Nível de Servico 1', N'', CAST(0xEE360B00 AS Date), NULL, CAST(0x6D390B00 AS Date), N'T', N'N', NULL, N'', N'', N'', N'B', N'B', N'S', NULL, N'', CAST('2013-04-05 13:40:00' AS datetime), NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT [acordonivelservico] ([idacordonivelservico], [idservicocontrato], [idprioridadepadrao], [situacao], [titulosla], [disponibilidade], [descricaosla], [escoposla], [datainicio], [datafim], [avaliarem], [tipo], [deleted], [valorLimite], [detalheGlosa], [detalheLimiteGlosa], [unidadeValorLimite], [impacto], [urgencia], [permiteMudarImpUrg], [idFormula], [contatos], [criadoEm], [criadoPor], [modificadoEm], [modificadoPor], [tempoauto], [idprioridadeauto1], [idprioridadeauto2], [idprioridadeauto3], [idprioridadeauto4], [idprioridadeauto5], [idgrupo1], [idgrupo2], [idgrupo3], [idgrupo4], [idgrupo5]) VALUES (3, NULL, NULL, N'A', N'SLA 3', NULL, N'Descrição do Acordo de Nível de Servico 3', N'', CAST(0xEE360B00 AS Date), NULL, CAST(0x6D390B00 AS Date), N'T', N'N', NULL, N'', N'', N'', N'B', N'B', N'S', NULL, N'', CAST('2013-04-05 13:40:00' AS datetime), NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);

CREATE TABLE [anexomudanca](
	[idanexomudanca] [int] NOT NULL,
	[idmudanca] [int] NULL,
	[datainicio] [date] NULL,
	[datafim] [date] NULL,
	[nome] [varchar](256) NULL,
	[link] [varchar](256) NULL,
	[extensao] [varchar](10) NULL,
	[descricao] [varchar](256) NULL,
PRIMARY KEY CLUSTERED 
(
	[idanexomudanca] ASC
)
) ON [PRIMARY];

CREATE TABLE [anexoincidente](
	[idanexoincidente] [int] NOT NULL,
	[idincidente] [int] NOT NULL,
	[datainicio] [date] NOT NULL,
	[datafim] [date] NULL,
	[nome] [varchar](256) NOT NULL,
	[link] [varchar](256) NOT NULL,
	[extensao] [varchar](10) NULL,
	[descricao] [varchar](256) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idanexoincidente] ASC
)
) ON [PRIMARY];

CREATE TABLE [anexobaseconhecimento](
	[idanexobaseconhecimento] [int] NOT NULL,
	[idbaseconhecimento] [int] NULL,
	[datainicio] [date] NOT NULL,
	[datafim] [date] NULL,
	[nome] [varchar](256) NOT NULL,
	[link] [varchar](256) NOT NULL,
	[extensao] [varchar](10) NOT NULL,
	[descricao] [varchar](256) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idanexobaseconhecimento] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_ANEXOBASECONHECIMENTO] ON [anexobaseconhecimento] 
(
	[idbaseconhecimento] ASC
)ON [PRIMARY];

CREATE TABLE [anexo](
	[idanexo] [int] NOT NULL,
	[idexecucaoatividade] [int] NULL,
	[nome] [varchar](256) NOT NULL,
	[descricao] [text] NULL,
	[extensao] [varchar](256) NOT NULL,
	[link] [varchar](256) NOT NULL,
	[path] [varchar](256) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idanexo] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_ANEXOEXECUCAOATIVIDADE] ON [anexo] 
(
	[idexecucaoatividade] ASC
)ON [PRIMARY];

CREATE TABLE [aprovacaorequisicaoliberacao](
	[idaprovacaorequisicaoliberacao] [int] NOT NULL,
	[idrequisicaoliberacao] [bigint] NOT NULL,
	[idtarefa] [bigint] NULL,
	[idresponsavel] [int] NOT NULL,
	[datahora] [datetime] NULL,
	[idjustificativa] [int] NULL,
	[complementojustificativa] [text] NULL,
	[observacoes] [text] NULL,
	[aprovacao] [char](1) NOT NULL,
 CONSTRAINT [idaprovacaorequisicao] PRIMARY KEY CLUSTERED 
(
	[idaprovacaorequisicaoliberacao] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE TABLE [acordonivelservicocontrato](
	[idacordonivelservicocontrato] [int] NOT NULL,
	[idcontrato] [int] NOT NULL,
	[descricaoacordo] [varchar](200) NOT NULL,
	[detalhamentoacordo] [text] NULL,
	[valorlimite] [decimal](15, 3) NOT NULL,
	[unidadevalorlimite] [varchar](200) NULL,
	[datainicio] [date] NOT NULL,
	[datafim] [date] NULL,
	[descricaoglosa] [text] NULL,
	[deleted] [char](1) NULL,
	[idFormula] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[idacordonivelservicocontrato] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_509] ON [acordonivelservicocontrato] 
(
	[idcontrato] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_573] ON [acordonivelservicocontrato] 
(
	[idFormula] ASC
)ON [PRIMARY];

CREATE TABLE [auditoriaitemconfiguracao](
	[idauditoria] [int] NOT NULL,
	[iditemconfiguracao] [int] NULL,
	[idempregado] [int] NULL,
	[data] [date] NOT NULL,
	[hora] [char](4) NULL,
	[ocorr] [text] NULL,
PRIMARY KEY CLUSTERED 
(
	[idauditoria] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_AUDITEMPREGADO] ON [auditoriaitemconfiguracao] 
(
	[idempregado] ASC
)ON [PRIMARY]

CREATE NONCLUSTERED INDEX [INDEX_AUDTITEMCONFIGURACAO] ON [auditoriaitemconfiguracao] 
(
	[iditemconfiguracao] ASC
)ON [PRIMARY];

CREATE TABLE [auditoria](
	[idauditoria] [int] NOT NULL,
	[iditemconfiguracao] [int] NULL,
	[idusuario] [int] NULL,
	[data] [date] NOT NULL,
	[hora] [char](4) NULL,
	[ocorr] [text] NULL,
PRIMARY KEY CLUSTERED 
(
	[idauditoria] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_AUDITORIAITEMCONFIGURACAO] ON [auditoria] 
(
	[iditemconfiguracao] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_AUDITORIAUSUARIO] ON [auditoria] 
(
	[idusuario] ASC
)ON [PRIMARY];

CREATE TABLE [atividadesservicocontrato](
	[idatividadeservicocontrato] [bigint] NOT NULL,
	[idservicocontrato] [bigint] NOT NULL,
	[descricaoatividade] [text] NOT NULL,
	[obsatividade] [text] NULL,
	[custoatividade] [decimal](18, 3) NULL,
	[complexidade] [char](5) NULL,
	[deleted] [char](1) NULL,
	[hora] [decimal](10, 2) NULL,
	[quantidade] [int] NULL,
	[periodo] [char](5) NULL,
	[tipocusto] [char](1) NULL,
	[formula] [text] NULL,
	[contabilizar] [char](1) NULL,
	[idservicocontratocontabil] [bigint] NULL,
PRIMARY KEY CLUSTERED 
(
	[idatividadeservicocontrato] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_127] ON [atividadesservicocontrato] 
(
	[idservicocontrato] ASC
)ON [PRIMARY];

CREATE TABLE [atividadesos](
	[idatividadesos] [bigint] NOT NULL,
	[idos] [int] NOT NULL,
	[sequencia] [smallint] NULL,
	[idatividadeservicocontrato] [bigint] NULL,
	[descricaoatividade] [text] NOT NULL,
	[obsatividade] [text] NULL,
	[custoatividade] [decimal](18, 3) NULL,
	[glosaatividade] [decimal](18, 3) NULL,
	[complexidade] [char](5) NULL,
	[deleted] [char](1) NULL,
	[qtdeexecutada] [decimal](15, 3) NULL,
	[formula] [text] NULL,
	[contabilizar] [char](1) NULL,
	[idservicocontratocontabil] [bigint] NULL,
PRIMARY KEY CLUSTERED 
(
	[idatividadesos] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_128] ON [atividadesos] 
(
	[idos] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_129] ON [atividadesos] 
(
	[idatividadeservicocontrato] ASC
)ON [PRIMARY];

CREATE TABLE [atividadesfluxos](
	[idatividade] [int] NOT NULL,
	[idfluxo] [int] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idatividade] ASC,
	[idfluxo] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_ATIVIDADESFLUXO] ON [atividadesfluxos] 
(
	[idfluxo] ASC
)ON [PRIMARY];

CREATE TABLE [atividades](
	[idatividade] [int] NOT NULL,
	[idetapa] [int] NOT NULL,
	[idtipoatividade] [int] NOT NULL,
	[idatividadeproxima] [int] NULL,
	[nomeatividade] [varchar](100) NOT NULL,
	[ordem] [smallint] NOT NULL,
	[grupoexecutor] [varchar](20) NULL,
PRIMARY KEY CLUSTERED 
(
	[idatividade] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_ATIVIDADEPROXIMA] ON [atividades] 
(
	[idatividadeproxima] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_ATIVIDADESETAPA] ON [atividades] 
(
	[idetapa] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_ATIVIDADESTIPOATIVIDADE] ON [atividades] 
(
	[idtipoatividade] ASC
)ON [PRIMARY];

CREATE TABLE [bpm_atribuicaofluxo](
	[idatribuicao] [bigint] NOT NULL,
	[iditemtrabalho] [bigint] NOT NULL,
	[tipo] [varchar](20) NULL,
	[datahora] [datetime] NOT NULL,
	[idusuario] [int] NULL,
	[idgrupo] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[idatribuicao] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_119] ON [bpm_atribuicaofluxo] 
(
	[iditemtrabalho] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_135] ON [bpm_atribuicaofluxo] 
(
	[idusuario] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_137] ON [bpm_atribuicaofluxo] 
(
	[idgrupo] ASC
)ON [PRIMARY];

CREATE TABLE [botaoacaovisao](
	[idbotaoacaovisao] [bigint] NOT NULL,
	[idvisao] [bigint] NOT NULL,
	[texto] [varchar](120) NOT NULL,
	[acao] [char](1) NOT NULL,
	[script] [text] NULL,
	[hint] [varchar](120) NULL,
	[icone] [varchar](120) NULL,
	[ordem] [smallint] NULL,
PRIMARY KEY CLUSTERED 
(
	[idbotaoacaovisao] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_97] ON [botaoacaovisao] 
(
	[idvisao] ASC
)ON [PRIMARY];

CREATE TABLE [bibliotecasexternas](
	[idbibliotecasexterna] [bigint] NOT NULL,
	[nome] [varchar](500) NOT NULL,
	[caminho] [varchar](500) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idbibliotecasexterna] ASC
)
) ON [PRIMARY];

CREATE TABLE [baseitemconfiguracao](
	[idbaseitemconfiguracao] [int] NOT NULL,
	[idtipoitemconfiguracao] [int] NULL,
	[nomebaseitemconfiguracao] [varchar](256) NOT NULL,
	[executavel] [varchar](256) NOT NULL,
	[datainicio] [date] NOT NULL,
	[datafim] [date] NULL,
	[tipoexecucao] [char](1) NULL,
	[comando] [varchar](256) NULL,
PRIMARY KEY CLUSTERED 
(
	[idbaseitemconfiguracao] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_BASETIPOITEMCONFIGURACAO] ON [baseitemconfiguracao] 
(
	[idtipoitemconfiguracao] ASC
)ON [PRIMARY];

CREATE TABLE [baseconhecimentorelacionado](
	[idbaseconhecimento] [int] NOT NULL,
	[idbaseconhecimentorelacionado] [int] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idbaseconhecimento] ASC,
	[idbaseconhecimentorelacionado] ASC
)
) ON [PRIMARY];

CREATE TABLE [bpm_historicoitemtrabalho](
	[idhistoricoitemtrabalho] [bigint] NOT NULL,
	[iditemtrabalho] [bigint] NOT NULL,
	[idresponsavel] [int] NULL,
	[idusuario] [int] NULL,
	[idgrupo] [int] NULL,
	[datahora] [datetime] NOT NULL,
	[acao] [varchar](10) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idhistoricoitemtrabalho] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_52] ON [bpm_historicoitemtrabalho] 
(
	[iditemtrabalho] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_53] ON [bpm_historicoitemtrabalho] 
(
	[idresponsavel] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_54] ON [bpm_historicoitemtrabalho] 
(
	[idusuario] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_55] ON [bpm_historicoitemtrabalho] 
(
	[idgrupo] ASC
)ON [PRIMARY];

CREATE TABLE [bpm_fluxo](
	[idfluxo] [bigint] NOT NULL,
	[versao] [varchar](10) NOT NULL,
	[idtipofluxo] [int] NULL,
	[variaveis] [text] NULL,
	[conteudoxml] [text] NULL,
	[datainicio] [date] NOT NULL,
	[datafim] [date] NULL,
PRIMARY KEY CLUSTERED 
(
	[idfluxo] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_115] ON [bpm_fluxo] 
(
	[idtipofluxo] ASC
)ON [PRIMARY];

CREATE TABLE [bpm_elementofluxo](
	[idelemento] [bigint] NOT NULL,
	[idfluxo] [bigint] NOT NULL,
	[tipoelemento] [varchar](20) NOT NULL,
	[subtipo] [varchar](20) NULL,
	[nome] [varchar](50) NULL,
	[documentacao] [text] NULL,
	[tipointeracao] [char](1) NULL,
	[url] [varchar](150) NULL,
	[visao] [varchar](150) NULL,
	[grupos] [text] NULL,
	[usuarios] [text] NULL,
	[acaoentrada] [text] NULL,
	[acaosaida] [text] NULL,
	[script] [text] NULL,
	[textoemail] [text] NULL,
	[nomefluxoencadeado] [varchar](100) NULL,
	[posx] [float] NULL,
	[posy] [float] NULL,
	[altura] [float] NULL,
	[largura] [float] NULL,
	[modeloemail] [varchar](20) NULL,
	[template] [varchar](40) NULL,
	[intervalo] [int] NULL,
	[condicaodisparo] [text] NULL,
	[multiplasinstancias] [char](1) NULL,
	[destinatariosemail] [text] NULL,
	[contabilizasla] [char](1) NULL,
	[percexecucao] [float] NULL,
PRIMARY KEY CLUSTERED 
(
	[idelemento] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_126] ON [bpm_elementofluxo] 
(
	[idfluxo] ASC
)ON [PRIMARY];

CREATE TABLE [bpm_instanciafluxo](
	[idinstancia] [bigint] NOT NULL,
	[idfluxo] [bigint] NOT NULL,
	[datahoracriacao] [datetime] NOT NULL,
	[situacao] [varchar](20) NULL,
	[datahorafinalizacao] [datetime] NULL,
PRIMARY KEY CLUSTERED 
(
	[idinstancia] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_122] ON [bpm_instanciafluxo] 
(
	[idfluxo] ASC
)ON [PRIMARY];

CREATE TABLE [cargos](
	[idcargo] [int] NOT NULL,
	[nomecargo] [varchar](256) NOT NULL,
	[datainicio] [date] NOT NULL,
	[datafim] [date] NULL,
PRIMARY KEY CLUSTERED 
(
	[idcargo] ASC
)
) ON [PRIMARY];

INSERT [cargos] ([idcargo], [nomecargo], [datainicio], [datafim]) VALUES (1, N'Administrador do Sistema', CAST(0x26350B00 AS Date), NULL);
INSERT [cargos] ([idcargo], [nomecargo], [datainicio], [datafim]) VALUES (2, N'Default', CAST(0x26350B00 AS Date), NULL);
INSERT [cargos] ([idcargo], [nomecargo], [datainicio], [datafim]) VALUES (3, N'Coordenador HelpDesk', CAST(0xE8350B00 AS Date), NULL);

CREATE TABLE [caracteristica](
	[idcaracteristica] [int] NOT NULL,
	[idempresa] [int] NOT NULL,
	[nomecaracteristica] [varchar](255) NOT NULL,
	[tagcaracteristica] [varchar](255) NULL,
	[descricao] [varchar](4000) NULL,
	[tipo] [char](2) NULL,
	[datainicio] [date] NOT NULL,
	[datafim] [date] NULL,
	[sistema] [char](1) NULL,
PRIMARY KEY CLUSTERED 
(
	[idcaracteristica] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_CEMPRESA] ON [caracteristica] 
(
	[idempresa] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_CNOMECARACTERISTICA] ON [caracteristica] 
(
	[nomecaracteristica] ASC
)ON [PRIMARY];

CREATE TABLE [camposobjetonegocio](
	[idcamposobjetonegocio] [bigint] NOT NULL,
	[idobjetonegocio] [bigint] NOT NULL,
	[nome] [varchar](100) NOT NULL,
	[nomedb] [varchar](100) NOT NULL,
	[pk] [char](1) NOT NULL,
	[sequence] [char](1) NOT NULL,
	[unico] [char](1) NOT NULL,
	[tipodb] [char](20) NOT NULL,
	[obrigatorio] [char](1) NOT NULL,
	[situacao] [char](1) NOT NULL,
	[precisiondb] [bigint] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idcamposobjetonegocio] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_72] ON [camposobjetonegocio] 
(
	[idobjetonegocio] ASC
)ON [PRIMARY];

CREATE TABLE [campoobjrelacionado](
	[idcampoobjrelacionado] [bigint] NOT NULL,
	[idrelacobjetonegocio] [bigint] NOT NULL,
	[idcamposobjetonegociopai] [bigint] NOT NULL,
	[idcamposobjetonegociofilho] [bigint] NOT NULL,
	[situacao] [char](1) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idcampoobjrelacionado] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_80] ON [campoobjrelacionado] 
(
	[idrelacobjetonegocio] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_81] ON [campoobjrelacionado] 
(
	[idcamposobjetonegociopai] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_82] ON [campoobjrelacionado] 
(
	[idcamposobjetonegociofilho] ASC
)ON [PRIMARY];

CREATE TABLE [bpm_tipofluxo](
	[idtipofluxo] [int] NOT NULL,
	[nomefluxo] [varchar](70) NOT NULL,
	[descricao] [text] NULL,
	[nomeclassefluxo] [varchar](255) NULL,
PRIMARY KEY CLUSTERED 
(
	[idtipofluxo] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE TABLE [bpm_sequenciafluxo](
	[idelementoorigem] [bigint] NOT NULL,
	[idelementodestino] [bigint] NOT NULL,
	[idfluxo] [bigint] NOT NULL,
	[nomeclasseorigem] [varchar](100) NULL,
	[nomeclassedestino] [varchar](100) NULL,
	[condicao] [text] NULL,
	[idconexaoorigem] [smallint] NULL,
	[idconexaodestino] [smallint] NULL,
	[bordax] [float] NULL,
	[borday] [float] NULL,
	[posicaoalterada] [char](1) NULL,
	[nome] [varchar](100) NULL,
PRIMARY KEY CLUSTERED 
(
	[idelementoorigem] ASC,
	[idelementodestino] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_133] ON [bpm_sequenciafluxo] 
(
	[idelementodestino] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_134] ON [bpm_sequenciafluxo] 
(
	[idfluxo] ASC
)ON [PRIMARY];

CREATE TABLE [bpm_objetoinstanciafluxo](
	[idobjetoinstancia] [bigint] NOT NULL,
	[iditemtrabalho] [bigint] NULL,
	[idinstancia] [bigint] NOT NULL,
	[idobjetonegocio] [bigint] NULL,
	[nomeobjeto] [varchar](100) NULL,
	[nomeclasse] [varchar](100) NULL,
	[tipoassociacao] [char](1) NOT NULL,
	[campochave] [char](1) NOT NULL,
	[objetoprincipal] [char](1) NOT NULL,
	[nometabelabd] [varchar](120) NULL,
	[nomecampobd] [varchar](100) NULL,
	[tipocampobd] [varchar](20) NULL,
	[valor] [text] NULL,
PRIMARY KEY CLUSTERED 
(
	[idobjetoinstancia] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_106] ON [bpm_objetoinstanciafluxo] 
(
	[idobjetonegocio] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_109] ON [bpm_objetoinstanciafluxo] 
(
	[iditemtrabalho] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_127] ON [bpm_objetoinstanciafluxo] 
(
	[idinstancia] ASC
)ON [PRIMARY];

CREATE TABLE [condicaooperacao](
	[idcondicaooperacao] [int] NOT NULL,
	[idempresa] [int] NOT NULL,
	[nomecondicaooperacao] [varchar](150) NOT NULL,
	[datainicio] [date] NOT NULL,
	[datafim] [date] NULL,
PRIMARY KEY CLUSTERED 
(
	[idcondicaooperacao] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_CONDEMPRESA] ON [condicaooperacao] 
(
	[idempresa] ASC
)ON [PRIMARY];

INSERT [condicaooperacao] ([idcondicaooperacao], [idempresa], [nomecondicaooperacao], [datainicio], [datafim]) VALUES (1, 1, N'24 X 7', CAST(0x26350B00 AS Date), NULL);
INSERT [condicaooperacao] ([idcondicaooperacao], [idempresa], [nomecondicaooperacao], [datainicio], [datafim]) VALUES (2, 1, N'Horário Comercial', CAST(0x26350B00 AS Date), NULL);

CREATE TABLE [complexidade](
	[idcontrato] [int] NOT NULL,
	[complexidade] [char](1) NOT NULL,
	[valorcomplexidade] [decimal](10, 2) NULL,
	[deleted] [char](1) NULL,
PRIMARY KEY CLUSTERED 
(
	[idcontrato] ASC,
	[complexidade] ASC
)
) ON [PRIMARY];

CREATE TABLE [comentarios](
	[idcomentario] [int] NOT NULL,
	[idbaseconhecimento] [int] NOT NULL,
	[comentario] [text] NOT NULL,
	[nome] [varchar](255) NOT NULL,
	[nota] [varchar](45) NOT NULL,
	[email] [varchar](70) NOT NULL,
	[datainicio] [date] NOT NULL,
	[datafim] [date] NULL,
PRIMARY KEY CLUSTERED 
(
	[idcomentario] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_comentario_baseconhecimento] ON [comentarios] 
(
	[idbaseconhecimento] ASC
)ON [PRIMARY];

CREATE TABLE [comandosistemaoperacional](
	[id] [int] NOT NULL,
	[idcomando] [int] NOT NULL,
	[idsistemaoperacional] [int] NOT NULL,
	[comando] [varchar](255) NOT NULL,
	[sistemaoperacional] [varchar](255) NULL,
	[comandosistemaoperacional] [varchar](255) NULL,
PRIMARY KEY CLUSTERED 
(
	[id] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_comando] ON [comandosistemaoperacional] 
(
	[idcomando] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_COMANDOSISTEMAOPERACIONAL] ON [comandosistemaoperacional] 
(
	[idsistemaoperacional] ASC
)ON [PRIMARY];

CREATE TABLE [comando](
	[id] [int] NOT NULL,
	[descricao] [varchar](400) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[id] ASC
)
) ON [PRIMARY];

CREATE TABLE [categoriagaleriaimagem](
	[idcategoriagaleriaimagem] [int] NOT NULL,
	[nomecategoria] [varchar](70) NOT NULL,
	[datafim] [date] NULL,
	[datainicio] [date] NULL,
PRIMARY KEY CLUSTERED 
(
	[idcategoriagaleriaimagem] ASC
)
) ON [PRIMARY];

CREATE TABLE [categoriapost](
	[idcategoriapost] [int] NOT NULL,
	[idcategoriapostPai] [int] NULL,
	[nomecategoria] [varchar](255) NULL,
	[datainicio] [date] NULL,
	[datafim] [date] NULL,
PRIMARY KEY CLUSTERED 
(
	[idcategoriapost] ASC
)
) ON [PRIMARY];

CREATE TABLE [categoriaocorrencia](
	[idcategoriaocorrencia] [int] NOT NULL,
	[nome] [varchar](20) NOT NULL,
	[dataInicio] [date] NOT NULL,
	[dataFim] [date] NULL,
PRIMARY KEY CLUSTERED 
(
	[idcategoriaocorrencia] ASC
)
) ON [PRIMARY];

CREATE TABLE [aprovacaosolicitacaoservico](
	[idaprovacaosolicitacaoservico] [int] NOT NULL,
	[idsolicitacaoservico] [bigint] NOT NULL,
	[idtarefa] [bigint] NULL,
	[idresponsavel] [int] NOT NULL,
	[datahora] [datetime] NULL,
	[idjustificativa] [int] NULL,
	[complementojustificativa] [text] NULL,
	[observacoes] [text] NULL,
	[aprovacao] [char](1) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idaprovacaosolicitacaoservico] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_aprovacao_justificativa_idx] ON [aprovacaosolicitacaoservico] 
(
	[idjustificativa] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_aprovacao_responsavel_idx] ON [aprovacaosolicitacaoservico] 
(
	[idresponsavel] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_aprovacao_solicitacao_idx] ON [aprovacaosolicitacaoservico] 
(
	[idsolicitacaoservico] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_aprovacao_tarefa_idx] ON [aprovacaosolicitacaoservico] 
(
	[idtarefa] ASC
)ON [PRIMARY];

CREATE TABLE [colecao](
	[idcolecao] [int] NOT NULL,
	[nome] [varchar](256) NULL,
	[idteste] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[idcolecao] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_idteste] ON [colecao] 
(
	[idteste] ASC
)ON [PRIMARY];

CREATE TABLE [clientes](
	[idcliente] [int] NOT NULL,
	[nomerazaosocial] [varchar](70) NOT NULL,
	[nomefantasia] [varchar](70) NULL,
	[cpfcnpj] [varchar](14) NULL,
	[observacoes] [text] NULL,
	[situacao] [char](1) NOT NULL,
	[deleted] [char](1) NULL,
PRIMARY KEY CLUSTERED 
(
	[idcliente] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

INSERT [clientes] ([idcliente], [nomerazaosocial], [nomefantasia], [cpfcnpj], [observacoes], [situacao], [deleted]) VALUES (1, N'Cliente 1', N'Cliente 1', N'', N'', N'A', NULL);

CREATE TABLE [cidades](
	[idcidade] [int] NOT NULL,
	[nomecidade] [varchar](45) NOT NULL,
	[iduf] [int] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idcidade] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_cidades_1] ON [cidades] 
(
	[iduf] ASC
)ON [PRIMARY];

INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1, N'Acrelândia', 9);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2, N'Assis Brasil', 9);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5, N'Capixaba', 9);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (6, N'Cruzeiro do Sul', 9);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (7, N'Epitaciolândia', 9);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (8, N'Feijó', 9);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (9, N'Jordão', 9);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (10, N'Mâncio Lima', 9);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (11, N'Manoel Urbano', 9);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (12, N'Marechal Thaumaturgo', 9);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (13, N'Plácido de Castro', 9);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (14, N'Porto Acre', 9);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (15, N'Porto Walter', 9);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (16, N'Rio Branco', 9);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (17, N'Rodrigues Alves', 9);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (18, N'Santa Rosa do Purus', 9);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (19, N'Sena Madureira', 9);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (20, N'Senador Guiomard', 9);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (21, N'Tarauacá', 9);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (22, N'Xapuri', 9);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (23, N'Água Branca', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (24, N'Anadia', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (25, N'Arapiraca', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (26, N'Atalaia', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (27, N'Barra de Santo Antônio', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (28, N'Barra de São Miguel', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (29, N'Batalha', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (30, N'Belém', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (31, N'Belo Monte', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (32, N'Boca da Mata', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (33, N'Branquinha', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (34, N'Cacimbinhas', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (35, N'Cajueiro', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (36, N'Campestre', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (37, N'Campo Alegre', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (38, N'Campo Grande', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (39, N'Canapi', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (40, N'Capela', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (41, N'Carneiros', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (42, N'Chã Preta', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (43, N'Coité do Nóia', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (44, N'Colônia Leopoldina', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (45, N'Coqueiro Seco', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (46, N'Coruripe', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (47, N'Craíbas', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (48, N'Delmiro Gouveia', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (49, N'Dois Riachos', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (50, N'Estrela de Alagoas', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (51, N'Feira Grande', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (52, N'Feliz Deserto', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (53, N'Flexeiras', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (54, N'Girau do Ponciano', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (55, N'Ibateguara', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (56, N'Igaci', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (57, N'Igreja Nova', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (58, N'Inhapi', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (59, N'Jacaré dos Homens', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (60, N'Jacuípe', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (61, N'Japaratinga', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (62, N'Jaramataia', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (63, N'Joaquim Gomes', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (64, N'Jundiá', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (65, N'Junqueiro', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (66, N'Lagoa da Canoa', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (67, N'Limoeiro de Anadia', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (68, N'Maceió', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (69, N'Major Isidoro', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (70, N'Mar Vermelho', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (71, N'Maragogi', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (72, N'Maravilha', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (73, N'Marechal Deodoro', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (74, N'Maribondo', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (75, N'Mata Grande', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (76, N'Matriz de Camaragibe', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (77, N'Messias', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (78, N'Minador do Negrão', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (79, N'Monteirópolis', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (80, N'Murici', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (81, N'Novo Lino', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (82, N'Olho dágua das Flores', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (83, N'Olho dágua do Casado', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (84, N'Olho dágua Grande', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (85, N'Olivença', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (86, N'Ouro Branco', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (87, N'Palestina', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (88, N'Palmeira dos Índios', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (89, N'Pão de Açúcar', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (90, N'Pariconha', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (91, N'Paripueira', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (92, N'Passo de Camaragibe', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (93, N'Paulo Jacinto', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (94, N'Penedo', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (95, N'Piaçabuçu', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (96, N'Pilar', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (97, N'Pindoba', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (98, N'Piranhas', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (99, N'Poço das Trincheiras', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (100, N'Porto Calvo', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (101, N'Porto de Pedras', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (102, N'Porto Real do Colégio', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (103, N'Quebrangulo', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (104, N'Rio Largo', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (105, N'Roteiro', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (106, N'Santa Luzia do Norte', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (107, N'Santana do Ipanema', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (108, N'Santana do Mundaú', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (109, N'São Brás', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (110, N'São José da Laje', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (111, N'São José da Tapera', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (112, N'São Luís do Quitunde', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (113, N'São Miguel dos Campos', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (114, N'São Miguel dos Milagres', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (115, N'São Sebastião', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (116, N'Satuba', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (117, N'Senador Rui Palmeira', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (118, N'Tanque dArca', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (119, N'Taquarana', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (120, N'Teotônio Vilela', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (121, N'Traipu', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (122, N'União dos Palmares', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (123, N'Viçosa', 10);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (124, N'Amapá',  11);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (125, N'Calçoene',  11);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (126, N'Cutias',  11);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (127, N'Ferreira Gomes',  11);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (128, N'Itaubal',  11);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (129, N'Laranjal do Jari',  11);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (130, N'Macapá',  11);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (131, N'Mazagão',  11);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (132, N'Oiapoque',  11);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (133, N'Pedra Branca do Amaparí',  11);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (134, N'Porto Grande',  11);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (135, N'Pracuúba',  11);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (136, N'Santana',  11);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (137, N'Serra do Navio',  11);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (138, N'Tartarugalzinho',  11);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (139, N'Vitória do Jari',  11);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (140, N'Alvarães',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (141, N'Amaturá',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (142, N'Anamã',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (143, N'Anori',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (144, N'Apuí',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (145, N'Atalaia do Norte',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (146, N'Autazes',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (147, N'Barcelos',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (148, N'Barreirinha',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (149, N'Benjamin Constant',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (150, N'Beruri',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (151, N'Boa Vista do Ramos',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (152, N'Boca do Acre',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (153, N'Borba',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (154, N'Caapiranga',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (155, N'Canutama',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (156, N'Carauari',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (157, N'Careiro',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (158, N'Careiro da Várzea',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (159, N'Coari',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (160, N'Codajás',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (161, N'Eirunepé',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (162, N'Envira',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (163, N'Fonte Boa',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (164, N'Guajará',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (165, N'Humaitá',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (166, N'Ipixuna',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (167, N'Iranduba',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (168, N'Itacoatiara',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (169, N'Itamarati',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (170, N'Itapiranga',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (171, N'Japurá',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (172, N'Juruá',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (173, N'Jutaí',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (174, N'Lábrea',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (175, N'Manacapuru',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (176, N'Manaquiri',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (177, N'Manaus',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (178, N'Manicoré',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (179, N'Maraã',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (180, N'Maués',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (181, N'Nhamundá',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (182, N'Nova Olinda do Norte',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (183, N'Novo Airão',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (184, N'Novo Aripuanã',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (185, N'Parintins',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (186, N'Pauini',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (187, N'Presidente Figueiredo',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (188, N'Rio Preto da Eva',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (189, N'Santa Isabel do Rio Negro',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (190, N'Santo Antônio do Içá',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (191, N'São Gabriel da Cachoeira',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (192, N'São Paulo de Olivença',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (193, N'São Sebastião do Uatumã',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (194, N'Silves',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (195, N'Tabatinga',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (196, N'Tapauá',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (197, N'Tefé',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (198, N'Tonantins',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (199, N'Uarini',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (200, N'Urucará',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (201, N'Urucurituba',  12);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (202, N'Abaíra',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (203, N'Abaré',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (204, N'Acajutiba',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (205, N'Adustina',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (206, N'Água Fria',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (207, N'Aiquara',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (208, N'Alagoinhas',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (209, N'Alcobaça',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (210, N'Almadina',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (211, N'Amargosa',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (212, N'Amélia Rodrigues',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (213, N'América Dourada',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (214, N'Anagé',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (215, N'Andaraí',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (216, N'Andorinha',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (217, N'Angical',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (218, N'Anguera',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (219, N'Antas',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (220, N'Antônio Cardoso',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (221, N'Antônio Gonçalves',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (222, N'Aporá',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (223, N'Apuarema',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (224, N'Araças',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (225, N'Aracatu',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (226, N'Araci',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (227, N'Aramari',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (228, N'Arataca',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (229, N'Aratuípe',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (230, N'Aurelino Leal',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (231, N'Baianópolis',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (232, N'Baixa Grande',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (233, N'Banzaê',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (234, N'Barra',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (235, N'Barra da Estiva',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (236, N'Barra do Choça',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (237, N'Barra do Mendes',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (238, N'Barra do Rocha',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (239, N'Barreiras',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (240, N'Barro Alto',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (241, N'Belmonte',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (242, N'Belo Campo',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (243, N'Biritinga',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (244, N'Boa Nova',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (245, N'Boa Vista do Tupim',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (246, N'Bom Jesus da Lapa',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (247, N'Bom Jesus da Serra',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (248, N'Boninal',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (249, N'Bonito',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (250, N'Boquira',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (251, N'Botuporã',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (252, N'Brejões',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (253, N'Brejolândia',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (254, N'Brotas de Macaúbas',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (255, N'Brumado',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (256, N'Buerarema',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (257, N'Buritirama',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (258, N'Caatiba',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (259, N'Cabaceiras do Paraguaçu',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (260, N'Cachoeira',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (261, N'Caculé',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (262, N'Caém',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (263, N'Caetanos',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (264, N'Caetité',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (265, N'Cafarnaum',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (266, N'Cairu',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (267, N'Caldeirão Grande',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (268, N'Camacan',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (269, N'Camaçari',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (270, N'Camamu',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (271, N'Campo Alegre de Lourdes',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (272, N'Campo Formoso',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (273, N'Canápolis',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (274, N'Canarana',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (275, N'Canavieiras',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (276, N'Candeal',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (277, N'Candeias',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (278, N'Candiba',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (279, N'Cândido Sales',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (280, N'Cansanção',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (281, N'Canudos',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (282, N'Capela do Alto Alegre',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (283, N'Capim Grosso',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (284, N'Caraíbas',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (285, N'Caravelas',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (286, N'Cardeal da Silva',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (287, N'Carinhanha',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (288, N'Casa Nova',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (289, N'Castro Alves',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (290, N'Catolândia',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (291, N'Catu',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (292, N'Caturama',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (293, N'Central',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (294, N'Chorrochó',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (295, N'Cícero Dantas',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (296, N'Cipó',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (297, N'Coaraci',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (298, N'Cocos',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (299, N'Conceição da Feira',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (300, N'Conceição do Almeida',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (301, N'Conceição do Coité',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (302, N'Conceição do Jacuípe',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (303, N'Conde',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (304, N'Condeúba',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (305, N'Contendas do Sincorá',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (306, N'Coração de Maria',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (307, N'Cordeiros',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (308, N'Coribe',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (309, N'Coronel João Sá',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (310, N'Correntina',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (311, N'Cotegipe',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (312, N'Cravolândia',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (313, N'Crisópolis',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (314, N'Cristópolis',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (315, N'Cruz das Almas',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (316, N'Curaçá',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (317, N'Dário Meira',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (318, N'Dias dávila',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (319, N'Dom Basílio',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (320, N'Dom Macedo Costa',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (321, N'Elísio Medrado',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (322, N'Encruzilhada',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (323, N'Entre Rios',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (324, N'Ã?rico Cardoso',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (325, N'Esplanada',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (326, N'Euclides da Cunha',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (327, N'Eunápolis',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (328, N'Fátima',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (329, N'Feira da Mata',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (330, N'Feira de Santana',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (331, N'Filadélfia',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (332, N'Firmino Alves',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (333, N'Floresta Azul',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (334, N'Formosa do Rio Preto',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (335, N'Gandu',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (336, N'Gavião',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (337, N'Gentio do Ouro',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (338, N'Glória',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (339, N'Gongogi',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (340, N'Governador Lomanto Júnior',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (341, N'Governador Mangabeira',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (342, N'Guajeru',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (343, N'Guanambi',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (344, N'Guaratinga',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (345, N'Heliópolis',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (346, N'Iaçu',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (347, N'Ibiassucê',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (348, N'Ibicaraí',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (349, N'Ibicoara',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (350, N'Ibicuí',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (351, N'Ibipeba',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (352, N'Ibipitanga',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (353, N'Ibiquera',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (354, N'Ibirapitanga',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (355, N'Ibirapuã',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (356, N'Ibirataia',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (357, N'Ibitiara',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (358, N'Ibititá',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (359, N'Ibotirama',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (360, N'Ichu',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (361, N'Igaporã',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (362, N'Igrapiúna',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (363, N'Iguaí',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (364, N'Ilhéus',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (365, N'Inhambupe',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (366, N'Ipecaetá',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (367, N'Ipiaú',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (368, N'Ipirá',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (369, N'Ipupiara',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (370, N'Irajuba',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (371, N'Iramaia',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (372, N'Iraquara',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (373, N'Irará',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (374, N'Irecê',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (375, N'Itabela',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (376, N'Itaberaba',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (377, N'Itabuna',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (378, N'Itacaré',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (379, N'Itaeté',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (380, N'Itagi',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (381, N'Itagibá',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (382, N'Itagimirim',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (383, N'Itaguaçu da Bahia',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (384, N'Itaju do Colônia',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (385, N'Itajuípe',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (386, N'Itamaraju',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (387, N'Itamari',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (388, N'Itambé',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (389, N'Itanagra',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (390, N'Itanhém',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (391, N'Itaparica',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (392, N'Itapé',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (393, N'Itapebi',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (394, N'Itapetinga',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (395, N'Itapicuru',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (396, N'Itapitanga',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (397, N'Itaquara',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (398, N'Itarantim',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (399, N'Itatim',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (400, N'Itiruçu',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (401, N'Itiúba',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (402, N'Itororó',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (403, N'Ituaçu',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (404, N'Ituberá',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (405, N'Iuiú',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (406, N'Jaborandi',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (407, N'Jacaraci',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (408, N'Jacobina',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (409, N'Jaguaquara',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (410, N'Jaguarari',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (411, N'Jaguaripe',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (412, N'Jandaíra',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (413, N'Jequié',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (414, N'Jeremoabo',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (415, N'Jiquiriçá',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (416, N'Jitaúna',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (417, N'João Dourado',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (418, N'Juazeiro',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (419, N'Jucuruçu',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (420, N'Jussara',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (421, N'Jussari',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (422, N'Jussiape',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (423, N'Lafaiete Coutinho',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (424, N'Lagoa Real',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (425, N'Laje',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (426, N'Lajedão',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (427, N'Lajedinho',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (428, N'Lajedo do Tabocal',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (429, N'Lamarão',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (430, N'Lapão',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (431, N'Lauro de Freitas',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (432, N'Lençóis',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (433, N'Licínio de Almeida',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (434, N'Livramento de Nossa Senhora',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (435, N'Macajuba',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (436, N'Macarani',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (437, N'Macaúbas',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (438, N'Macururé',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (439, N'Madre de Deus',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (440, N'Maetinga',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (441, N'Maiquinique',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (442, N'Mairi',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (443, N'Malhada',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (444, N'Malhada de Pedras',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (445, N'Manoel Vitorino',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (446, N'Mansidão',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (447, N'Maracás',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (448, N'Maragogipe',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (449, N'Maraú',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (450, N'Marcionílio Souza',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (451, N'Mascote',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (452, N'Mata de São João',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (453, N'Matina',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (454, N'Medeiros Neto',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (455, N'Miguel Calmon',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (456, N'Milagres',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (457, N'Mirangaba',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (458, N'Mirante',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (459, N'Monte Santo',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (460, N'Morpará',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (461, N'Morro do Chapéu',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (462, N'Mortugaba',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (463, N'Mucugê',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (464, N'Mucuri',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (465, N'Mulungu do Morro',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (466, N'Mundo Novo',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (467, N'Muniz Ferreira',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (468, N'Muquém de São Francisco',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (469, N'Muritiba',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (470, N'Mutuípe',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (471, N'Nazaré',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (472, N'Nilo Peçanha',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (473, N'Nordestina',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (474, N'Nova Canaã',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (475, N'Nova Fátima',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (476, N'Nova Ibiá',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (477, N'Nova Itarana',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (478, N'Nova Redenção',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (479, N'Nova Soure',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (480, N'Nova Viçosa',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (481, N'Novo Horizonte',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (482, N'Novo Triunfo',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (483, N'Olindina',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (484, N'Oliveira dos Brejinhos',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (485, N'Ouriçangas',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (486, N'Ourolândia',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (487, N'Palmas de Monte Alto',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (488, N'Palmeiras',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (489, N'Paramirim',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (490, N'Paratinga',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (491, N'Paripiranga',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (492, N'Pau Brasil',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (493, N'Paulo Afonso',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (494, N'Pé de Serra',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (495, N'Pedrão',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (496, N'Pedro Alexandre',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (497, N'Piatã',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (498, N'Pilão Arcado',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (499, N'Pindaí',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (500, N'Pindobaçu',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (501, N'Pintadas',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (502, N'Piraí do Norte',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (503, N'Piripá',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (504, N'Piritiba',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (505, N'Planaltino',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (506, N'Planalto',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (507, N'Poções',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (508, N'Pojuca',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (509, N'Ponto Novo',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (510, N'Porto Seguro',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (511, N'Potiraguá',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (512, N'Prado',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (513, N'Presidente Dutra',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (514, N'Presidente Jânio Quadros',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (515, N'Presidente Tancredo Neves',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (516, N'Queimadas',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (517, N'Quijingue',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (518, N'Quixabeira',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (519, N'Rafael Jambeiro',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (520, N'Remanso',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (521, N'Retirolândia',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (522, N'Riachão das Neves',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (523, N'Riachão do Jacuípe',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (524, N'Riacho de Santana',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (525, N'Ribeira do Amparo',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (526, N'Ribeira do Pombal',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (527, N'Ribeirão do Largo',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (528, N'Rio de Contas',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (529, N'Rio do Antônio',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (530, N'Rio do Pires',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (531, N'Rio Real',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (532, N'Rodelas',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (533, N'Ruy Barbosa',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (534, N'Salinas da Margarida',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (535, N'Salvador',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (536, N'Santa Bárbara',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (537, N'Santa Brígida',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (538, N'Santa Cruz Cabrália',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (539, N'Santa Cruz da Vitória',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (540, N'Santa Inês',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (541, N'Santa Luzia',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (542, N'Santa Maria da Vitória',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (543, N'Santa Rita de Cássia',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (544, N'Santa Teresinha',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (545, N'Santaluz',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (546, N'Santana',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (547, N'Santanópolis',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (548, N'Santo Amaro',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (549, N'Santo Antônio de Jesus',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (550, N'Santo Estêvão',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (551, N'São Desidério',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (552, N'São Domingos',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (553, N'São Felipe',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (554, N'São Félix',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (555, N'São Félix do Coribe',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (556, N'São Francisco do Conde',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (557, N'São Gabriel',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (558, N'São Gonçalo dos Campos',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (559, N'São José da Vitória',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (560, N'São José do Jacuípe',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (561, N'São Miguel das Matas',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (562, N'São Sebastião do Passé',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (563, N'Sapeaçu',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (564, N'Sátiro Dias',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (565, N'Saubara',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (566, N'Saúde',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (567, N'Seabra',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (568, N'Sebastião Laranjeiras',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (569, N'Senhor do Bonfim',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (570, N'Sento Sé',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (571, N'Serra do Ramalho',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (572, N'Serra Dourada',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (573, N'Serra Preta',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (574, N'Serrinha',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (575, N'Serrolândia',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (576, N'Simões Filho',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (577, N'Sítio do Mato',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (578, N'Sítio do Quinto',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (579, N'Sobradinho',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (580, N'Souto Soares',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (581, N'Tabocas do Brejo Velho',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (582, N'Tanhaçu',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (583, N'Tanque Novo',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (584, N'Tanquinho',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (585, N'Taperoá',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (586, N'Tapiramutá',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (587, N'Teixeira de Freitas',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (588, N'Teodoro Sampaio',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (589, N'Teofilândia',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (590, N'Teolândia',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (591, N'Terra Nova',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (592, N'Tremedal',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (593, N'Tucano',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (594, N'Uauá',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (595, N'Ubaíra',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (596, N'Ubaitaba',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (597, N'Ubatã',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (598, N'Uibaí',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (599, N'Umburanas',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (600, N'Una',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (601, N'Urandi',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (602, N'Uruçuca',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (603, N'Utinga',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (604, N'Valença',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (605, N'Valente',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (606, N'Várzea da Roça',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (607, N'Várzea do Poço',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (608, N'Várzea Nova',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (609, N'Varzedo',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (610, N'Vera Cruz',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (611, N'Vereda',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (612, N'Vitória da Conquista',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (613, N'Wagner',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (614, N'Wanderley',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (615, N'Wenceslau Guimarães',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (616, N'Xique-Xique',  13);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (617, N'Abaiara',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (618, N'Acarapé',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (619, N'Acaraú',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (620, N'Acopiara',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (621, N'Aiuaba',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (622, N'Alcântaras',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (623, N'Altaneira',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (624, N'Alto Santo',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (625, N'Amontada',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (626, N'Antonina do Norte',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (627, N'Apuiarés',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (628, N'Aquiraz',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (629, N'Aracati',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (630, N'Aracoiaba',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (631, N'Ararendá',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (632, N'Araripe',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (633, N'Aratuba',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (634, N'Arneiroz',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (635, N'Assaré',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (636, N'Aurora',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (637, N'Baixio',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (638, N'Banabuiú',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (639, N'Barbalha',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (640, N'Barreira',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (641, N'Barro',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (642, N'Barroquinha',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (643, N'Baturité',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (644, N'Beberibe',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (645, N'Bela Cruz',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (646, N'Boa Viagem',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (647, N'Brejo Santo',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (648, N'Camocim',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (649, N'Campos Sales',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (650, N'Canindé',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (651, N'Capistrano',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (652, N'Caridade',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (653, N'Cariré',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (654, N'Caririaçu',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (655, N'Cariús',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (656, N'Carnaubal',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (657, N'Cascavel',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (658, N'Catarina',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (659, N'Catunda',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (660, N'Caucaia',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (661, N'Cedro',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (662, N'Chaval',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (663, N'Choró',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (664, N'Chorozinho',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (665, N'Coreaú',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (666, N'Crateús',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (667, N'Crato',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (668, N'Croatá',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (669, N'Cruz',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (670, N'Deputado Irapuan Pinheiro',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (671, N'Ererê',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (672, N'Eusébio',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (673, N'Farias Brito',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (674, N'Forquilha',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (675, N'Fortaleza',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (676, N'Fortim',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (677, N'Frecheirinha',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (678, N'General Sampaio',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (679, N'Graça',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (680, N'Granja',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (681, N'Granjeiro',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (682, N'Groaíras',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (683, N'Guaiúba',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (684, N'Guaraciaba do Norte',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (685, N'Guaramiranga',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (686, N'Hidrolândia',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (687, N'Horizonte',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (688, N'Ibaretama',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (689, N'Ibiapina',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (690, N'Ibicuitinga',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (691, N'Icapuí',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (692, N'Icó',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (693, N'Iguatu',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (694, N'Independência',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (695, N'Ipaporanga',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (696, N'Ipaumirim',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (697, N'Ipu',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (698, N'Ipueiras',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (699, N'Iracema',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (700, N'Irauçuba',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (701, N'Itaiçaba',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (702, N'Itaitinga',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (703, N'Itapagé',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (704, N'Itapipoca',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (705, N'Itapiúna',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (706, N'Itarema',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (707, N'Itatira',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (708, N'Jaguaretama',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (709, N'Jaguaribara',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (710, N'Jaguaribe',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (711, N'Jaguaruana',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (712, N'Jardim',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (713, N'Jati',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (714, N'Jijoca de Jericoacoara',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (715, N'Juazeiro do Norte',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (716, N'Jucás',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (717, N'Lavras da Mangabeira',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (718, N'Limoeiro do Norte',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (719, N'Madalena',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (720, N'Maracanaú',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (721, N'Maranguape',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (722, N'Marco',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (723, N'Martinópole',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (724, N'Massapê',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (725, N'Mauriti',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (726, N'Meruoca',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (727, N'Milagres',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (728, N'Milhã',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (729, N'Miraíma',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (730, N'Missão Velha',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (731, N'Mombaça',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (732, N'Monsenhor Tabosa',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (733, N'Morada Nova',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (734, N'Moraújo',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (735, N'Morrinhos',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (736, N'Mucambo',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (737, N'Mulungu',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (738, N'Nova Olinda',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (739, N'Nova Russas',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (740, N'Novo Oriente',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (741, N'Ocara',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (742, N'Orós',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (743, N'Pacajus',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (744, N'Pacatuba',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (745, N'Pacoti',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (746, N'Pacujá',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (747, N'Palhano',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (748, N'Palmácia',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (749, N'Paracuru',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (750, N'Paraipaba',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (751, N'Parambu',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (752, N'Paramoti',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (753, N'Pedra Branca',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (754, N'Penaforte',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (755, N'Pentecoste',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (756, N'Pereiro',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (757, N'Pindoretama',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (758, N'Piquet Carneiro',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (759, N'Pires Ferreira',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (760, N'Poranga',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (761, N'Porteiras',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (762, N'Potengi',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (763, N'Potiretama',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (764, N'Quiterianópolis',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (765, N'Quixadá',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (766, N'Quixelô',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (767, N'Quixeramobim',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (768, N'Quixeré',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (769, N'Redenção',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (770, N'Reriutaba',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (771, N'Russas',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (772, N'Saboeiro',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (773, N'Salitre',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (774, N'Santa Quitéria',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (775, N'Santana do Acaraú',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (776, N'Santana do Cariri',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (777, N'São Benedito',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (778, N'São Gonçalo do Amarante',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (779, N'São João do Jaguaribe',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (780, N'São Luís do Curu',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (781, N'Senador Pompeu',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (782, N'Senador Sá',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (783, N'Sobral',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (784, N'Solonópole',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (785, N'Tabuleiro do Norte',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (786, N'Tamboril',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (787, N'Tarrafas',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (788, N'Tauá',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (789, N'Tejuçuoca',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (790, N'Tianguá',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (791, N'Trairi',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (792, N'Tururu',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (793, N'Ubajara',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (794, N'Umari',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (795, N'Umirim',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (796, N'Uruburetama',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (797, N'Uruoca',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (798, N'Varjota',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (799, N'Várzea Alegre',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (800, N'Viçosa do Ceará',  14);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (801, N'Brasília', 1);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (802, N'Afonso Cláudio', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (803, N'Água Doce do Norte', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (804, N'Águia Branca', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (805, N'Alegre', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (806, N'Alfredo Chaves', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (807, N'Alto Rio Novo', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (808, N'Anchieta', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (809, N'Apiacá', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (810, N'Aracruz', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (811, N'Atilio Vivacqua', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (812, N'Baixo Guandu', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (813, N'Barra de São Francisco', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (814, N'Boa Esperança', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (815, N'Bom Jesus do Norte', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (816, N'Brejetuba', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (817, N'Cachoeiro de Itapemirim', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (818, N'Cariacica', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (819, N'Castelo', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (820, N'Colatina', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (821, N'Conceição da Barra', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (822, N'Conceição do Castelo', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (823, N'Divino de São Lourenço', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (824, N'Domingos Martins', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (825, N'Dores do Rio Preto', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (826, N'Ecoporanga', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (827, N'Fundão', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (828, N'Guaçuí', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (829, N'Guarapari', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (830, N'Ibatiba', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (831, N'Ibiraçu', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (832, N'Ibitirama', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (833, N'Iconha', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (834, N'Irupi', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (835, N'Itaguaçu', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (836, N'Itapemirim', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (837, N'Itarana', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (838, N'Iúna', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (839, N'Jaguaré', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (840, N'Jerônimo Monteiro', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (841, N'João Neiva', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (842, N'Laranja da Terra', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (843, N'Linhares', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (844, N'Mantenópolis', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (845, N'Marataízes', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (846, N'Marechal Floriano', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (847, N'Marilândia', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (848, N'Mimoso do Sul', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (849, N'Montanha', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (850, N'Mucurici', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (851, N'Muniz Freire', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (852, N'Muqui', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (853, N'Nova Venécia', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (854, N'Pancas', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (855, N'Pedro Canário', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (856, N'Pinheiros', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (857, N'Piúma', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (858, N'Ponto Belo', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (859, N'Presidente Kennedy', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (860, N'Rio Bananal', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (861, N'Rio Novo do Sul', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (862, N'Santa Leopoldina', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (863, N'Santa Maria de Jetibá', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (864, N'Santa Teresa', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (865, N'São Domingos do Norte', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (866, N'São Gabriel da Palha', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (867, N'São José do Calçado', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (868, N'São Mateus', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (869, N'São Roque do Canaã', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (870, N'Serra', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (871, N'Sooretama', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (872, N'Vargem Alta', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (873, N'Venda Nova do Imigrante', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (874, N'Viana', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (875, N'Vila Pavão', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (876, N'Vila Valério', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (877, N'Vila Velha', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (878, N'Vitória', 8);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (879, N'Abadia de Goiás', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (880, N'Abadiânia', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (881, N'Acreúna', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (882, N'Adelândia', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (883, N'Água Fria de Goiás', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (884, N'Água Limpa', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (885, N'Águas Lindas de Goiás', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (886, N'Alexânia', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (887, N'Aloândia', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (888, N'Alto Horizonte', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (889, N'Alto Paraíso de Goiás', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (890, N'Alvorada do Norte', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (891, N'Amaralina', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (892, N'Americano do Brasil', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (893, N'Amorinópolis', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (894, N'Anápolis', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (895, N'Anhanguera', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (896, N'Anicuns', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (897, N'Aparecida de Goiânia', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (898, N'Aparecida do Rio Doce', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (899, N'Aporé', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (900, N'Araçu', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (901, N'Aragarças', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (902, N'Aragoiânia', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (903, N'Araguapaz', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (904, N'Arenópolis', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (905, N'Aruanã', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (906, N'Aurilândia', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (907, N'Avelinópolis', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (908, N'Baliza', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (909, N'Barro Alto', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (910, N'Bela Vista de Goiás', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (911, N'Bom Jardim de Goiás', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (912, N'Bom Jesus de Goiás', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (913, N'Bonfinópolis', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (914, N'Bonópolis', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (915, N'Brazabrantes', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (916, N'Britânia', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (917, N'Buriti Alegre', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (918, N'Buriti de Goiás', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (919, N'Buritinópolis', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (920, N'Cabeceiras', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (921, N'Cachoeira Alta', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (922, N'Cachoeira de Goiás', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (923, N'Cachoeira Dourada', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (924, N'Caçu', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (925, N'Caiapônia', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (926, N'Caldas Novas', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (927, N'Caldazinha', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (928, N'Campestre de Goiás', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (929, N'Campinaçu', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (930, N'Campinorte', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (931, N'Campo Alegre de Goiás', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (932, N'Campos Belos', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (933, N'Campos Verdes', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (934, N'Carmo do Rio Verde', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (935, N'Castelândia', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (936, N'Catalão', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (937, N'Caturaí', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (938, N'Cavalcante', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (939, N'Ceres', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (940, N'Cezarina', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (941, N'Chapadão do Céu', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (942, N'Cidade Ocidental', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (943, N'Cocalzinho de Goiás', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (944, N'Colinas do Sul', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (945, N'Córrego do Ouro', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (946, N'Corumbá de Goiás', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (947, N'Corumbaíba', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (948, N'Cristalina', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (949, N'Cristianópolis', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (950, N'Crixás', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (951, N'Cromínia', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (952, N'Cumari', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (953, N'Damianópolis', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (954, N'Damolândia', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (955, N'Davinópolis', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (956, N'Diorama', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (957, N'Divinópolis de Goiás', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (958, N'Doverlândia', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (959, N'Edealina', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (960, N'Edéia', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (961, N'Estrela do Norte', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (962, N'Faina', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (963, N'Fazenda Nova', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (964, N'Firminópolis', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (965, N'Flores de Goiás', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (966, N'Formosa', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (967, N'Formoso', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (968, N'Goianápolis', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (969, N'Goiandira', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (970, N'Goianésia', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (971, N'Goiânia', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (972, N'Goianira', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (973, N'Goiás', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (974, N'Goiatuba', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (975, N'Gouvelândia', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (976, N'Guapó', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (977, N'Guaraíta', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (978, N'Guarani de Goiás', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (979, N'Guarinos', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (980, N'Heitoraí', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (981, N'Hidrolândia', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (982, N'Hidrolina', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (983, N'Iaciara', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (984, N'Inaciolândia', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (985, N'Indiara', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (986, N'Inhumas', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (987, N'Ipameri', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (988, N'Iporá', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (989, N'Israelândia', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (990, N'Itaberaí', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (991, N'Itaguari', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (992, N'Itaguaru', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (993, N'Itajá', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (994, N'Itapaci', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (995, N'Itapirapuã', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (996, N'Itapuranga', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (997, N'Itarumã', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (998, N'Itauçu', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (999, N'Itumbiara', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1000, N'Ivolândia', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1001, N'Jandaia', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1002, N'Jaraguá', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1003, N'Jataí', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1004, N'Jaupaci', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1005, N'Jesúpolis', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1006, N'Joviânia', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1007, N'Jussara', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1008, N'Leopoldo de Bulhões', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1009, N'Luziânia', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1010, N'Mairipotaba', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1011, N'Mambaí', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1012, N'Mara Rosa', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1013, N'Marzagão', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1014, N'Matrinchã', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1015, N'Maurilândia', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1016, N'Mimoso de Goiás', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1017, N'Minaçu', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1018, N'Mineiros', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1019, N'Moiporá', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1020, N'Monte Alegre de Goiás', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1021, N'Montes Claros de Goiás', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1022, N'Montividiu', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1023, N'Montividiu do Norte', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1024, N'Morrinhos', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1025, N'Morro Agudo de Goiás', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1026, N'Mossâmedes', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1027, N'Mozarlândia', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1028, N'Mundo Novo', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1029, N'Mutunópolis', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1030, N'Nazário', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1031, N'Nerópolis', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1032, N'Niquelândia', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1033, N'Nova América', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1034, N'Nova Aurora', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1035, N'Nova Crixás', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1036, N'Nova Glória', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1037, N'Nova Iguaçu de Goiás', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1038, N'Nova Roma', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1039, N'Nova Veneza', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1040, N'Novo Brasil', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1041, N'Novo Gama', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1042, N'Novo Planalto', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1043, N'Orizona', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1044, N'Ouro Verde de Goiás', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1045, N'Ouvidor', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1046, N'Padre Bernardo', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1047, N'Palestina de Goiás', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1048, N'Palmeiras de Goiás', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1049, N'Palmelo', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1050, N'Palminópolis', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1051, N'Panamá', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1052, N'Paranaiguara', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1053, N'Paraúna', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1054, N'Perolândia', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1055, N'Petrolina de Goiás', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1056, N'Pilar de Goiás', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1057, N'Piracanjuba', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1058, N'Piranhas', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1059, N'Pirenópolis', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1060, N'Pires do Rio', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1061, N'Planaltina', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1062, N'Pontalina', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1063, N'Porangatu', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1064, N'Porteirão', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1065, N'Portelândia', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1066, N'Posse', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1067, N'Professor Jamil', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1068, N'Quirinópolis', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1069, N'Rialma', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1070, N'Rianápolis', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1071, N'Rio Quente', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1072, N'Rio Verde', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1073, N'Rubiataba', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1074, N'Sanclerlândia', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1075, N'Santa Bárbara de Goiás', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1076, N'Santa Cruz de Goiás', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1077, N'Santa Fé de Goiás', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1078, N'Santa Helena de Goiás', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1079, N'Santa Isabel', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1080, N'Santa Rita do Araguaia', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1081, N'Santa Rita do Novo Destino', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1082, N'Santa Rosa de Goiás', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1083, N'Santa Tereza de Goiás', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1084, N'Santa Terezinha de Goiás', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1085, N'Santo Antônio da Barra', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1086, N'Santo Antônio de Goiás', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1087, N'Santo Antônio do Descoberto', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1088, N'São Domingos', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1089, N'São Francisco de Goiás', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1090, N'São João dAliança', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1091, N'São João da Paraúna', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1092, N'São Luís de Montes Belos', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1093, N'São Luíz do Norte', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1094, N'São Miguel do Araguaia', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1095, N'São Miguel do Passa Quatro', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1096, N'São Patrício', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1097, N'São Simão', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1098, N'Senador Canedo', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1099, N'Serranópolis', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1100, N'Silvânia', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1101, N'Simolândia', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1102, N'Sítio dAbadia', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1103, N'Taquaral de Goiás', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1104, N'Teresina de Goiás', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1105, N'Terezópolis de Goiás', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1106, N'Três Ranchos', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1107, N'Trindade', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1108, N'Trombas', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1109, N'Turvânia', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1110, N'Turvelândia', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1111, N'Uirapuru', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1112, N'Uruaçu', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1113, N'Uruana', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1114, N'Urutaí', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1115, N'Valparaíso de Goiás', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1116, N'Varjão', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1117, N'Vianópolis', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1118, N'Vicentinópolis', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1119, N'Vila Boa', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1120, N'Vila Propício', 4);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1121, N'Açailândia', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1122, N'Afonso Cunha', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1123, N'Água Doce do Maranhão', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1124, N'Alcântara', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1125, N'Aldeias Altas', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1126, N'Altamira do Maranhão', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1127, N'Alto Alegre do Maranhão', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1128, N'Alto Alegre do Pindaré', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1129, N'Alto Parnaíba', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1130, N'Amapá do Maranhão', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1131, N'Amarante do Maranhão', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1132, N'Anajatuba', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1133, N'Anapurus', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1134, N'Apicum-Açu', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1135, N'Araguanã', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1136, N'Araioses', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1137, N'Arame', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1138, N'Arari', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1139, N'Axixá', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1140, N'Bacabal', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1141, N'Bacabeira', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1142, N'Bacuri', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1143, N'Bacurituba', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1144, N'Balsas', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1145, N'Barão de Grajaú', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1146, N'Barra do Corda', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1147, N'Barreirinhas', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1148, N'Bela Vista do Maranhão', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1149, N'Belágua', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1150, N'Benedito Leite', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1151, N'Bequimão', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1152, N'Bernardo do Mearim', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1153, N'Boa Vista do Gurupi', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1154, N'Bom Jardim', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1155, N'Bom Jesus das Selvas', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1156, N'Bom Lugar', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1157, N'Brejo', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1158, N'Brejo de Areia', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1159, N'Buriti', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1160, N'Buriti Bravo', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1161, N'Buriticupu', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1162, N'Buritirana', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1163, N'Cachoeira Grande', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1164, N'Cajapió', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1165, N'Cajari', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1166, N'Campestre do Maranhão', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1167, N'Cândido Mendes', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1168, N'Cantanhede', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1169, N'Capinzal do Norte', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1170, N'Carolina', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1171, N'Carutapera', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1172, N'Caxias', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1173, N'Cedral', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1174, N'Central do Maranhão', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1175, N'Centro do Guilherme', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1176, N'Centro Novo do Maranhão', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1177, N'Chapadinha', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1178, N'Cidelândia', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1179, N'Codó', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1180, N'Coelho Neto', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1181, N'Colinas', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1182, N'Conceição do Lago-Açu', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1183, N'Coroatá', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1184, N'Cururupu', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1185, N'Davinópolis', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1186, N'Dom Pedro', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1187, N'Duque Bacelar', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1188, N'Esperantinópolis', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1189, N'Estreito', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1190, N'Feira Nova do Maranhão', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1191, N'Fernando Falcão', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1192, N'Formosa da Serra Negra', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1193, N'Fortaleza dos Nogueiras', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1194, N'Fortuna', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1195, N'Godofredo Viana', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1196, N'Gonçalves Dias', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1197, N'Governador Archer', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1198, N'Governador Edison Lobão', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1199, N'Governador Eugênio Barros', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1200, N'Governador Luiz Rocha', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1201, N'Governador Newton Bello', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1202, N'Governador Nunes Freire', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1203, N'Graça Aranha', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1204, N'Grajaú', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1205, N'Guimarães', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1206, N'Humberto de Campos', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1207, N'Icatu', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1208, N'Igarapé do Meio', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1209, N'Igarapé Grande', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1210, N'Imperatriz', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1211, N'Itaipava do Grajaú', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1212, N'Itapecuru Mirim', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1213, N'Itinga do Maranhão', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1214, N'Jatobá', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1215, N'Jenipapo dos Vieiras', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1216, N'João Lisboa', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1217, N'Joselândia', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1218, N'Junco do Maranhão', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1219, N'Lago da Pedra', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1220, N'Lago do Junco', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1221, N'Lago dos Rodrigues', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1222, N'Lago Verde', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1223, N'Lagoa do Mato', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1224, N'Lagoa Grande do Maranhão', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1225, N'Lajeado Novo', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1226, N'Lima Campos', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1227, N'Loreto', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1228, N'Luís Domingues', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1229, N'Magalhães de Almeida', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1230, N'Maracaçumé', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1231, N'Marajá do Sena', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1232, N'Maranhãozinho', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1233, N'Mata Roma', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1234, N'Matinha', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1235, N'Matões', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1236, N'Matões do Norte', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1237, N'Milagres do Maranhão', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1238, N'Mirador', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1239, N'Miranda do Norte', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1240, N'Mirinzal', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1241, N'Monção', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1242, N'Montes Altos', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1243, N'Morros', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1244, N'Nina Rodrigues', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1245, N'Nova Colinas', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1246, N'Nova Iorque', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1247, N'Nova Olinda do Maranhão', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1248, N'Olho dágua das Cunhãs', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1249, N'Olinda Nova do Maranhão', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1250, N'Paço do Lumiar', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1251, N'Palmeirândia', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1252, N'Paraibano', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1253, N'Parnarama', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1254, N'Passagem Franca', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1255, N'Pastos Bons', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1256, N'Paulino Neves', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1257, N'Paulo Ramos', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1258, N'Pedreiras', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1259, N'Pedro do Rosário', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1260, N'Penalva', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1261, N'Peri Mirim', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1262, N'Peritoró', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1263, N'Pindaré-Mirim', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1264, N'Pinheiro', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1265, N'Pio XII', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1266, N'Pirapemas', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1267, N'Poção de Pedras', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1268, N'Porto Franco', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1269, N'Porto Rico do Maranhão', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1270, N'Presidente Dutra', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1271, N'Presidente Juscelino', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1272, N'Presidente Médici', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1273, N'Presidente Sarney', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1274, N'Presidente Vargas', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1275, N'Primeira Cruz', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1276, N'Raposa', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1277, N'Riachão', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1278, N'Ribamar Fiquene', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1279, N'Rosário', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1280, N'Sambaíba', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1281, N'Santa Filomena do Maranhão', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1282, N'Santa Helena', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1283, N'Santa Inês', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1284, N'Santa Luzia', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1285, N'Santa Luzia do Paruá', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1286, N'Santa Quitéria do Maranhão', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1287, N'Santa Rita', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1288, N'Santana do Maranhão', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1289, N'Santo Amaro do Maranhão', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1290, N'Santo Antônio dos Lopes', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1291, N'São Benedito do Rio Preto', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1292, N'São Bento', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1293, N'São Bernardo', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1294, N'São Domingos do Azeitão', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1295, N'São Domingos do Maranhão', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1296, N'São Félix de Balsas', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1297, N'São Francisco do Brejão', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1298, N'São Francisco do Maranhão', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1299, N'São João Batista', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1300, N'São João do Carú', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1301, N'São João do Paraíso', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1302, N'São João do Soter', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1303, N'São João dos Patos', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1304, N'São José de Ribamar', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1305, N'São José dos Basílios', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1306, N'São Luís', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1307, N'São Luís Gonzaga do Maranhão', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1308, N'São Mateus do Maranhão', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1309, N'São Pedro da Água Branca', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1310, N'São Pedro dos Crentes', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1311, N'São Raimundo das Mangabeiras', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1312, N'São Raimundo do Doca Bezerra', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1313, N'São Roberto', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1314, N'São Vicente Ferrer', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1315, N'Satubinha', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1316, N'Senador Alexandre Costa', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1317, N'Senador La Rocque', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1318, N'Serrano do Maranhão', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1319, N'Sítio Novo', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1320, N'Sucupira do Norte', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1321, N'Sucupira do Riachão', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1322, N'Tasso Fragoso', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1323, N'Timbiras', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1324, N'Timon', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1325, N'Trizidela do Vale', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1326, N'Tufilândia', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1327, N'Tuntum', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1328, N'Turiaçu', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1329, N'Turilândia', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1330, N'Tutóia', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1331, N'Urbano Santos', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1332, N'Vargem Grande', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1333, N'Viana', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1334, N'Vila Nova dos Martírios', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1335, N'Vitória do Mearim', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1336, N'Vitorino Freire', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1337, N'Zé Doca', 15);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1338, N'Acorizal', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1339, N'Água Boa', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1340, N'Alta Floresta', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1341, N'Alto Araguaia', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1342, N'Alto Boa Vista', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1343, N'Alto Garças', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1344, N'Alto Paraguai', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1345, N'Alto Taquari', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1346, N'Apiacás', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1347, N'Araguaiana', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1348, N'Araguainha', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1349, N'Araputanga', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1350, N'Arenápolis', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1351, N'Aripuanã', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1352, N'Barão de Melgaço', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1353, N'Barra do Bugres', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1354, N'Barra do Garças', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1355, N'Brasnorte', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1356, N'Cáceres', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1357, N'Campinápolis', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1358, N'Campo Novo do Parecis', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1359, N'Campo Verde', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1360, N'Campos de Júlio', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1361, N'Canabrava do Norte', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1362, N'Canarana', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1363, N'Carlinda', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1364, N'Castanheira', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1365, N'Chapada dos Guimarães', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1366, N'Cláudia', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1367, N'Cocalinho', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1368, N'Colíder', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1369, N'Comodoro', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1370, N'Confresa', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1371, N'Cotriguaçu', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1372, N'Cuiabá', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1373, N'Denise', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1374, N'Diamantino', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1375, N'Dom Aquino', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1376, N'Feliz Natal', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1377, N'Figueirópolis dOeste', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1378, N'Gaúcha do Norte', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1379, N'General Carneiro', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1380, N'Glória dOeste', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1381, N'Guarantã do Norte', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1382, N'Guiratinga', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1383, N'Indiavaí', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1384, N'Itaúba', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1385, N'Itiquira', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1386, N'Jaciara', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1387, N'Jangada', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1388, N'Jauru', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1389, N'Juara', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1390, N'Juína', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1391, N'Juruena', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1392, N'Juscimeira', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1393, N'Lambari dOeste', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1394, N'Lucas do Rio Verde', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1395, N'Luciára', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1396, N'Marcelândia', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1397, N'Matupá', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1398, N'Mirassol dOeste', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1399, N'Nobres', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1400, N'Nortelândia', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1401, N'Nossa Senhora do Livramento', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1402, N'Nova Bandeirantes', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1403, N'Nova Brasilândia', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1404, N'Nova Canaã do Norte', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1405, N'Nova Guarita', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1406, N'Nova Lacerda', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1407, N'Nova Marilândia', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1408, N'Nova Maringá', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1409, N'Nova Monte Verde', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1410, N'Nova Mutum', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1411, N'Nova Olímpia', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1412, N'Nova Ubiratã', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1413, N'Nova Xavantina', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1414, N'Novo Horizonte do Norte', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1415, N'Novo Mundo', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1416, N'Novo São Joaquim', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1417, N'Paranaíta', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1418, N'Paranatinga', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1419, N'Pedra Preta', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1420, N'Peixoto de Azevedo', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1421, N'Planalto da Serra', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1422, N'Poconé', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1423, N'Pontal do Araguaia', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1424, N'Ponte Branca', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1425, N'Pontes e Lacerda', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1426, N'Porto Alegre do Norte', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1427, N'Porto dos Gaúchos', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1428, N'Porto Esperidião', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1429, N'Porto Estrela', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1430, N'Poxoréo', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1431, N'Primavera do Leste', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1432, N'Querência', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1433, N'Reserva do Cabaçal', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1434, N'Ribeirão Cascalheira', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1435, N'Ribeirãozinho', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1436, N'Rio Branco', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1437, N'Rondonópolis', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1438, N'Rosário Oeste', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1439, N'Salto do Céu', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1440, N'Santa Carmem', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1441, N'Santa Terezinha', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1442, N'Santo Afonso', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1443, N'Santo Antônio do Leverger', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1444, N'São Félix do Araguaia', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1445, N'São José do Povo', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1446, N'São José do Rio Claro', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1447, N'São José do Xingu', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1448, N'São José dos Quatro Marcos', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1449, N'São Pedro da Cipa', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1450, N'Sapezal', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1451, N'Sinop', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1452, N'Sorriso', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1453, N'Tabaporã', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1454, N'Tangará da Serra', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1455, N'Tapurah', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1456, N'Terra Nova do Norte', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1457, N'Tesouro', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1458, N'Torixoréu', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1459, N'União do Sul', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1460, N'Várzea Grande', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1461, N'Vera', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1462, N'Vila Bela da Santíssima Trindade', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1463, N'Vila Rica', 16);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1464, N'Água Clara', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1465, N'Alcinópolis', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1466, N'Amambaí', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1467, N'Anastácio', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1468, N'Anaurilândia', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1469, N'Angélica', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1470, N'Antônio João', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1471, N'Aparecida do Taboado', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1472, N'Aquidauana', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1473, N'Aral Moreira', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1474, N'Bandeirantes', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1475, N'Bataguassu', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1476, N'Bataiporã', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1477, N'Bela Vista', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1478, N'Bodoquena', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1479, N'Bonito', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1480, N'Brasilândia', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1481, N'Caarapó', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1482, N'Camapuã', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1483, N'Campo Grande', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1484, N'Caracol', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1485, N'Cassilândia', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1486, N'Chapadão do Sul', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1487, N'Corguinho', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1488, N'Coronel Sapucaia', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1489, N'Corumbá', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1490, N'Costa Rica', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1491, N'Coxim', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1492, N'Deodápolis', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1493, N'Dois Irmãos do Buriti', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1494, N'Douradina', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1495, N'Dourados', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1496, N'Eldorado', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1497, N'Fátima do Sul', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1498, N'Glória de Dourados', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1499, N'Guia Lopes da Laguna', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1500, N'Iguatemi', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1501, N'Inocência', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1502, N'Itaporã', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1503, N'Itaquiraí', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1504, N'Ivinhema', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1505, N'Japorã', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1506, N'Jaraguari', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1507, N'Jardim', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1508, N'Jateí', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1509, N'Juti', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1510, N'Ladário', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1511, N'Laguna Carapã', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1512, N'Maracaju', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1513, N'Miranda', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1514, N'Mundo Novo', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1515, N'Naviraí', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1516, N'Nioaque', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1517, N'Nova Alvorada do Sul', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1518, N'Nova Andradina', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1519, N'Novo Horizonte do Sul', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1520, N'Paranaíba', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1521, N'Paranhos', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1522, N'Pedro Gomes', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1523, N'Ponta Porã', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1524, N'Porto Murtinho', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1525, N'Ribas do Rio Pardo', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1526, N'Rio Brilhante', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1527, N'Rio Negro', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1528, N'Rio Verde de Mato Grosso', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1529, N'Rochedo', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1530, N'Santa Rita do Pardo', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1531, N'São Gabriel do Oeste', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1532, N'Selvíria', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1533, N'Sete Quedas', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1534, N'Sidrolândia', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1535, N'Sonora', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1536, N'Tacuru', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1537, N'Taquarussu', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1538, N'Terenos', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1539, N'Três Lagoas', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1540, N'Vicentina', 17);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1541, N'Abadia dos Dourados', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1542, N'Abaeté', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1543, N'Abre Campo', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1544, N'Acaiaca', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1545, N'Açucena', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1546, N'Água Boa', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1547, N'Água Comprida', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1548, N'Aguanil', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1549, N'Águas Formosas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1550, N'Águas Vermelhas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1551, N'Aimorés', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1552, N'Aiuruoca', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1553, N'Alagoa', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1554, N'Albertina', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1555, N'Além Paraíba', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1556, N'Alfenas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1557, N'Alfredo Vasconcelos', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1558, N'Almenara', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1559, N'Alpercata', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1560, N'Alpinópolis', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1561, N'Alterosa', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1562, N'Alto Caparaó', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1563, N'Alto Jequitibá', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1564, N'Alto Rio Doce', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1565, N'Alvarenga', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1566, N'Alvinópolis', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1567, N'Alvorada de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1568, N'Amparo do Serra', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1569, N'Andradas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1570, N'Andrelândia', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1571, N'Angelândia', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1572, N'Antônio Carlos', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1573, N'Antônio Dias', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1574, N'Antônio Prado de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1575, N'Araçaí', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1576, N'Aracitaba', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1577, N'Araçuaí', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1578, N'Araguari', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1579, N'Arantina', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1580, N'Araponga', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1581, N'Araporã', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1582, N'Arapuá', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1583, N'Araújos', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1584, N'Araxá', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1585, N'Arceburgo', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1586, N'Arcos', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1587, N'Areado', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1588, N'Argirita', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1589, N'Aricanduva', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1590, N'Arinos', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1591, N'Astolfo Dutra', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1592, N'Ataléia', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1593, N'Augusto de Lima', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1594, N'Baependi', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1595, N'Baldim', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1596, N'Bambuí', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1597, N'Bandeira', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1598, N'Bandeira do Sul', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1599, N'Barão de Cocais', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1600, N'Barão de Monte Alto', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1601, N'Barbacena', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1602, N'Barra Longa', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1603, N'Barroso', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1604, N'Bela Vista de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1605, N'Belmiro Braga', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1606, N'Belo Horizonte', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1607, N'Belo Oriente', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1608, N'Belo Vale', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1609, N'Berilo', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1610, N'Berizal', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1611, N'Bertópolis', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1612, N'Betim', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1613, N'Bias Fortes', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1614, N'Bicas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1615, N'Biquinhas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1616, N'Boa Esperança', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1617, N'Bocaina de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1618, N'Bocaiúva', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1619, N'Bom Despacho', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1620, N'Bom Jardim de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1621, N'Bom Jesus da Penha', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1622, N'Bom Jesus do Amparo', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1623, N'Bom Jesus do Galho', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1624, N'Bom Repouso', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1625, N'Bom Sucesso', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1626, N'Bonfim', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1627, N'Bonfinópolis de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1628, N'Bonito de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1629, N'Borda da Mata', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1630, N'Botelhos', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1631, N'Botumirim', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1632, N'Brás Pires', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1633, N'Brasilândia de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1634, N'Brasília de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1635, N'Brasópolis', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1636, N'Braúnas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1637, N'Brumadinho', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1638, N'Bueno Brandão', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1639, N'Buenópolis', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1640, N'Bugre', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1641, N'Buritis', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1642, N'Buritizeiro', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1643, N'Cabeceira Grande', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1644, N'Cabo Verde', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1645, N'Cachoeira da Prata', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1646, N'Cachoeira de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1647, N'Cachoeira de Pajeú', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1648, N'Cachoeira Dourada', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1649, N'Caetanópolis', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1650, N'Caeté', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1651, N'Caiana', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1652, N'Cajuri', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1653, N'Caldas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1654, N'Camacho', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1655, N'Camanducaia', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1656, N'Cambuí', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1657, N'Cambuquira', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1658, N'Campanário', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1659, N'Campanha', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1660, N'Campestre', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1661, N'Campina Verde', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1662, N'Campo Azul', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1663, N'Campo Belo', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1664, N'Campo do Meio', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1665, N'Campo Florido', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1666, N'Campos Altos', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1667, N'Campos Gerais', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1668, N'Cana Verde', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1669, N'Canaã', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1670, N'Canápolis', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1671, N'Candeias', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1672, N'Cantagalo', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1673, N'Caparaó', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1674, N'Capela Nova', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1675, N'Capelinha', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1676, N'Capetinga', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1677, N'Capim Branco', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1678, N'Capinópolis', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1679, N'Capitão Andrade', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1680, N'Capitão Enéas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1681, N'Capitólio', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1682, N'Caputira', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1683, N'Caraí', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1684, N'Caranaíba', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1685, N'Carandaí', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1686, N'Carangola', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1687, N'Caratinga', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1688, N'Carbonita', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1689, N'Careaçu', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1690, N'Carlos Chagas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1691, N'Carmésia', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1692, N'Carmo da Cachoeira', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1693, N'Carmo da Mata', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1694, N'Carmo de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1695, N'Carmo do Cajuru', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1696, N'Carmo do Paranaíba', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1697, N'Carmo do Rio Claro', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1698, N'Carmópolis de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1699, N'Carneirinho', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1700, N'Carrancas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1701, N'Carvalhópolis', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1702, N'Carvalhos', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1703, N'Casa Grande', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1704, N'Cascalho Rico', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1705, N'Cássia', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1706, N'Cataguases', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1707, N'Catas Altas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1708, N'Catas Altas da Noruega', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1709, N'Catuji', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1710, N'Catuti', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1711, N'Caxambu', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1712, N'Cedro do Abaeté', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1713, N'Central de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1714, N'Centralina', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1715, N'Chácara', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1716, N'Chalé', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1717, N'Chapada do Norte', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1718, N'Chapada Gaúcha', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1719, N'Chiador', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1720, N'Cipotânea', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1721, N'Claraval', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1722, N'Claro dos Poções', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1723, N'Cláudio', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1724, N'Coimbra', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1725, N'Coluna', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1726, N'Comendador Gomes', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1727, N'Comercinho', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1728, N'Conceição da Aparecida', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1729, N'Conceição da Barra de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1730, N'Conceição das Alagoas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1731, N'Conceição das Pedras', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1732, N'Conceição de Ipanema', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1733, N'Conceição do Mato Dentro', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1734, N'Conceição do Pará', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1735, N'Conceição do Rio Verde', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1736, N'Conceição dos Ouros', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1737, N'Cônego Marinho', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1738, N'Confins', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1739, N'Congonhal', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1740, N'Congonhas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1741, N'Congonhas do Norte', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1742, N'Conquista', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1743, N'Conselheiro Lafaiete', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1744, N'Conselheiro Pena', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1745, N'Consolação', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1746, N'Contagem', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1747, N'Coqueiral', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1748, N'Coração de Jesus', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1749, N'Cordisburgo', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1750, N'Cordislândia', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1751, N'Corinto', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1752, N'Coroaci', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1753, N'Coromandel', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1754, N'Coronel Fabriciano', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1755, N'Coronel Murta', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1756, N'Coronel Pacheco', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1757, N'Coronel Xavier Chaves', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1758, N'Córrego Danta', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1759, N'Córrego do Bom Jesus', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1760, N'Córrego Fundo', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1761, N'Córrego Novo', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1762, N'Couto de Magalhães de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1763, N'Crisólita', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1764, N'Cristais', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1765, N'Cristália', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1766, N'Cristiano Otoni', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1767, N'Cristina', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1768, N'Crucilândia', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1769, N'Cruzeiro da Fortaleza', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1770, N'Cruzília', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1771, N'Cuparaque', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1772, N'Curral de Dentro', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1773, N'Curvelo', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1774, N'Datas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1775, N'Delfim Moreira', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1776, N'Delfinópolis', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1777, N'Delta', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1778, N'Descoberto', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1779, N'Desterro de Entre Rios', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1780, N'Desterro do Melo', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1781, N'Diamantina', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1782, N'Diogo de Vasconcelos', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1783, N'Dionísio', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1784, N'Divinésia', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1785, N'Divino', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1786, N'Divino das Laranjeiras', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1787, N'Divinolândia de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1788, N'Divinópolis', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1789, N'Divisa Alegre', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1790, N'Divisa Nova', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1791, N'Divisópolis', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1792, N'Dom Bosco', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1793, N'Dom Cavati', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1794, N'Dom Joaquim', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1795, N'Dom Silvério', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1796, N'Dom Viçoso', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1797, N'Dona Eusébia', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1798, N'Dores de Campos', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1799, N'Dores de Guanhães', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1800, N'Dores do Indaiá', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1801, N'Dores do Turvo', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1802, N'Doresópolis', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1803, N'Douradoquara', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1804, N'Durandé', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1805, N'Elói Mendes', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1806, N'Engenheiro Caldas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1807, N'Engenheiro Navarro', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1808, N'Entre Folhas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1809, N'Entre Rios de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1810, N'Ervália', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1811, N'Esmeraldas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1812, N'Espera Feliz', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1813, N'Espinosa', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1814, N'Espírito Santo do Dourado', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1815, N'Estiva', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1816, N'Estrela Dalva', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1817, N'Estrela do Indaiá', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1818, N'Estrela do Sul', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1819, N'Eugenópolis', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1820, N'Ewbank da Câmara', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1821, N'Extrema', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1822, N'Fama', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1823, N'Faria Lemos', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1824, N'Felício dos Santos', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1825, N'Felisburgo', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1826, N'Felixlândia', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1827, N'Fernandes Tourinho', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1828, N'Ferros', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1829, N'Fervedouro', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1830, N'Florestal', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1831, N'Formiga', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1832, N'Formoso', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1833, N'Fortaleza de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1834, N'Fortuna de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1835, N'Francisco Badaró', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1836, N'Francisco Dumont', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1837, N'Francisco Sá', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1838, N'Franciscópolis', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1839, N'Frei Gaspar', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1840, N'Frei Inocêncio', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1841, N'Frei Lagonegro', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1842, N'Fronteira', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1843, N'Fronteira dos Vales', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1844, N'Fruta de Leite', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1845, N'Frutal', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1846, N'Funilândia', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1847, N'Galiléia', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1848, N'Gameleiras', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1849, N'Glaucilândia', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1850, N'Goiabeira', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1851, N'Goianá', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1852, N'Gonçalves', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1853, N'Gonzaga', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1854, N'Gouveia', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1855, N'Governador Valadares', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1856, N'Grão Mogol', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1857, N'Grupiara', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1858, N'Guanhães', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1859, N'Guapé', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1860, N'Guaraciaba', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1861, N'Guaraciama', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1862, N'Guaranésia', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1863, N'Guarani', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1864, N'Guarará', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1865, N'Guarda-Mor', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1866, N'Guaxupé', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1867, N'Guidoval', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1868, N'Guimarânia', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1869, N'Guiricema', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1870, N'Gurinhatã', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1871, N'Heliodora', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1872, N'Iapu', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1873, N'Ibertioga', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1874, N'Ibiá', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1875, N'Ibiaí', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1876, N'Ibiracatu', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1877, N'Ibiraci', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1878, N'Ibirité', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1879, N'Ibitiúra de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1880, N'Ibituruna', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1881, N'Icaraí de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1882, N'Igarapé', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1883, N'Igaratinga', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1884, N'Iguatama', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1885, N'Ijaci', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1886, N'Ilicínea', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1887, N'Imbé de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1888, N'Inconfidentes', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1889, N'Indaiabira', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1890, N'Indianópolis', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1891, N'Ingaí', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1892, N'Inhapim', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1893, N'Inhaúma', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1894, N'Inimutaba', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1895, N'Ipaba', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1896, N'Ipanema', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1897, N'Ipatinga', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1898, N'Ipiaçu', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1899, N'Ipuiúna', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1900, N'Iraí de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1901, N'Itabira', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1902, N'Itabirinha de Mantena', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1903, N'Itabirito', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1904, N'Itacambira', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1905, N'Itacarambi', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1906, N'Itaguara', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1907, N'Itaipé', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1908, N'Itajubá', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1909, N'Itamarandiba', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1910, N'Itamarati de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1911, N'Itambacuri', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1912, N'Itambé do Mato Dentro', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1913, N'Itamogi', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1914, N'Itamonte', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1915, N'Itanhandu', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1916, N'Itanhomi', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1917, N'Itaobim', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1918, N'Itapagipe', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1919, N'Itapecerica', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1920, N'Itapeva', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1921, N'Itatiaiuçu', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1922, N'Itaú de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1923, N'Itaúna', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1924, N'Itaverava', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1925, N'Itinga', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1926, N'Itueta', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1927, N'Ituiutaba', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1928, N'Itumirim', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1929, N'Iturama', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1930, N'Itutinga', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1931, N'Jaboticatubas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1932, N'Jacinto', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1933, N'Jacuí', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1934, N'Jacutinga', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1935, N'Jaguaraçu', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1936, N'Jaíba', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1937, N'Jampruca', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1938, N'Janaúba', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1939, N'Januária', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1940, N'Japaraíba', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1941, N'Japonvar', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1942, N'Jeceaba', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1943, N'Jenipapo de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1944, N'Jequeri', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1945, N'Jequitaí', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1946, N'Jequitibá', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1947, N'Jequitinhonha', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1948, N'Jesuânia', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1949, N'Joaíma', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1950, N'Joanésia', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1951, N'João Monlevade', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1952, N'João Pinheiro', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1953, N'Joaquim Felício', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1954, N'Jordânia', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1955, N'José Gonçalves de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1956, N'José Raydan', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1957, N'Josenópolis', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1958, N'Juatuba', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1959, N'Juiz de Fora', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1960, N'Juramento', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1961, N'Juruaia', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1962, N'Juvenília', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1963, N'Ladainha', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1964, N'Lagamar', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1965, N'Lagoa da Prata', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1966, N'Lagoa dos Patos', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1967, N'Lagoa Dourada', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1968, N'Lagoa Formosa', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1969, N'Lagoa Grande', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1970, N'Lagoa Santa', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1971, N'Lajinha', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1972, N'Lambari', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1973, N'Lamim', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1974, N'Laranjal', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1975, N'Lassance', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1976, N'Lavras', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1977, N'Leandro Ferreira', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1978, N'Leme do Prado', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1979, N'Leopoldina', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1980, N'Liberdade', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1981, N'Lima Duarte', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1982, N'Limeira do Oeste', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1983, N'Lontra', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1984, N'Luisburgo', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1985, N'Luislândia', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1986, N'Luminárias', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1987, N'Luz', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1988, N'Machacalis', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1989, N'Machado', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1990, N'Madre de Deus de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1991, N'Malacacheta', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1992, N'Mamonas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1993, N'Manga', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1994, N'Manhuaçu', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1995, N'Manhumirim', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1996, N'Mantena', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1997, N'Mar de Espanha', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1998, N'Maravilhas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (1999, N'Maria da Fé', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2000, N'Mariana', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2001, N'Marilac', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2002, N'Mário Campos', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2003, N'Maripá de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2004, N'Marliéria', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2005, N'Marmelópolis', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2006, N'Martinho Campos', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2007, N'Martins Soares', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2008, N'Mata Verde', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2009, N'Materlândia', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2010, N'Mateus Leme', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2011, N'Mathias Lobato', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2012, N'Matias Barbosa', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2013, N'Matias Cardoso', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2014, N'Matipó', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2015, N'Mato Verde', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2016, N'Matozinhos', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2017, N'Matutina', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2018, N'Medeiros', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2019, N'Medina', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2020, N'Mendes Pimentel', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2021, N'Mercês', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2022, N'Mesquita', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2023, N'Minas Novas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2024, N'Minduri', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2025, N'Mirabela', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2026, N'Miradouro', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2027, N'Miraí', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2028, N'Miravânia', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2029, N'Moeda', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2030, N'Moema', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2031, N'Monjolos', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2032, N'Monsenhor Paulo', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2033, N'Montalvânia', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2034, N'Monte Alegre de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2035, N'Monte Azul', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2036, N'Monte Belo', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2037, N'Monte Carmelo', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2038, N'Monte Formoso', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2039, N'Monte Santo de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2040, N'Monte Sião', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2041, N'Montes Claros', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2042, N'Montezuma', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2043, N'Morada Nova de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2044, N'Morro da Garça', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2045, N'Morro do Pilar', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2046, N'Munhoz', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2047, N'Muriaé', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2048, N'Mutum', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2049, N'Muzambinho', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2050, N'Nacip Raydan', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2051, N'Nanuque', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2052, N'Naque', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2053, N'Natalândia', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2054, N'Natércia', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2055, N'Nazareno', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2056, N'Nepomuceno', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2057, N'Ninheira', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2058, N'Nova Belém', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2059, N'Nova Era', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2060, N'Nova Lima', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2061, N'Nova Módica', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2062, N'Nova Ponte', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2063, N'Nova Porteirinha', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2064, N'Nova Resende', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2065, N'Nova Serrana', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2066, N'Nova União', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2067, N'Novo Cruzeiro', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2068, N'Novo Oriente de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2069, N'Novorizonte', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2070, N'Olaria', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2071, N'Olhos-dágua', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2072, N'Olímpio Noronha', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2073, N'Oliveira', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2074, N'Oliveira Fortes', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2075, N'Onça de Pitangui', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2076, N'Oratórios', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2077, N'Orizânia', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2078, N'Ouro Branco', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2079, N'Ouro Fino', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2080, N'Ouro Preto', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2081, N'Ouro Verde de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2082, N'Padre Carvalho', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2083, N'Padre Paraíso', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2084, N'Pai Pedro', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2085, N'Paineiras', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2086, N'Pains', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2087, N'Paiva', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2088, N'Palma', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2089, N'Palmópolis', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2090, N'Papagaios', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2091, N'Pará de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2092, N'Paracatu', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2093, N'Paraguaçu', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2094, N'Paraisópolis', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2095, N'Paraopeba', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2096, N'Passa Quatro', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2097, N'Passa Tempo', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2098, N'Passa-Vinte', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2099, N'Passabém', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2100, N'Passos', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2101, N'Patis', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2102, N'Patos de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2103, N'Patrocínio', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2104, N'Patrocínio do Muriaé', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2105, N'Paula Cândido', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2106, N'Paulistas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2107, N'Pavão', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2108, N'Peçanha', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2109, N'Pedra Azul', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2110, N'Pedra Bonita', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2111, N'Pedra do Anta', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2112, N'Pedra do Indaiá', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2113, N'Pedra Dourada', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2114, N'Pedralva', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2115, N'Pedras de Maria da Cruz', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2116, N'Pedrinópolis', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2117, N'Pedro Leopoldo', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2118, N'Pedro Teixeira', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2119, N'Pequeri', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2120, N'Pequi', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2121, N'Perdigão', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2122, N'Perdizes', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2123, N'Perdões', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2124, N'Periquito', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2125, N'Pescador', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2126, N'Piau', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2127, N'Piedade de Caratinga', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2128, N'Piedade de Ponte Nova', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2129, N'Piedade do Rio Grande', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2130, N'Piedade dos Gerais', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2131, N'Pimenta', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2132, N'Pingo-dágua', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2133, N'Pintópolis', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2134, N'Piracema', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2135, N'Pirajuba', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2136, N'Piranga', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2137, N'Piranguçu', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2138, N'Piranguinho', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2139, N'Pirapetinga', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2140, N'Pirapora', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2141, N'Piraúba', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2142, N'Pitangui', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2143, N'Piumhi', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2144, N'Planura', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2145, N'Poço Fundo', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2146, N'Poços de Caldas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2147, N'Pocrane', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2148, N'Pompéu', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2149, N'Ponte Nova', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2150, N'Ponto Chique', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2151, N'Ponto dos Volantes', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2152, N'Porteirinha', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2153, N'Porto Firme', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2154, N'Poté', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2155, N'Pouso Alegre', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2156, N'Pouso Alto', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2157, N'Prados', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2158, N'Prata', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2159, N'Pratápolis', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2160, N'Pratinha', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2161, N'Presidente Bernardes', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2162, N'Presidente Juscelino', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2163, N'Presidente Kubitschek', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2164, N'Presidente Olegário', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2165, N'Prudente de Morais', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2166, N'Quartel Geral', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2167, N'Queluzito', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2168, N'Raposos', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2169, N'Raul Soares', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2170, N'Recreio', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2171, N'Reduto', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2172, N'Resende Costa', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2173, N'Resplendor', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2174, N'Ressaquinha', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2175, N'Riachinho', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2176, N'Riacho dos Machados', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2177, N'Ribeirão das Neves', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2178, N'Ribeirão Vermelho', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2179, N'Rio Acima', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2180, N'Rio Casca', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2181, N'Rio do Prado', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2182, N'Rio Doce', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2183, N'Rio Espera', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2184, N'Rio Manso', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2185, N'Rio Novo', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2186, N'Rio Paranaíba', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2187, N'Rio Pardo de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2188, N'Rio Piracicaba', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2189, N'Rio Pomba', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2190, N'Rio Preto', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2191, N'Rio Vermelho', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2192, N'Ritápolis', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2193, N'Rochedo de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2194, N'Rodeiro', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2195, N'Romaria', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2196, N'Rosário da Limeira', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2197, N'Rubelita', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2198, N'Rubim', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2199, N'Sabará', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2200, N'Sabinópolis', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2201, N'Sacramento', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2202, N'Salinas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2203, N'Salto da Divisa', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2204, N'Santa Bárbara', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2205, N'Santa Bárbara do Leste', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2206, N'Santa Bárbara do Monte Verde', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2207, N'Santa Bárbara do Tugúrio', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2208, N'Santa Cruz de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2209, N'Santa Cruz de Salinas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2210, N'Santa Cruz do Escalvado', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2211, N'Santa Efigênia de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2212, N'Santa Fé de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2213, N'Santa Helena de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2214, N'Santa Juliana', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2215, N'Santa Luzia', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2216, N'Santa Margarida', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2217, N'Santa Maria de Itabira', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2218, N'Santa Maria do Salto', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2219, N'Santa Maria do Suaçuí', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2220, N'Santa Rita de Caldas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2221, N'Santa Rita de Ibitipoca', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2222, N'Santa Rita de Jacutinga', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2223, N'Santa Rita de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2224, N'Santa Rita do Itueto', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2225, N'Santa Rita do Sapucaí', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2226, N'Santa Rosa da Serra', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2227, N'Santa Vitória', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2228, N'Santana da Vargem', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2229, N'Santana de Cataguases', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2230, N'Santana de Pirapama', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2231, N'Santana do Deserto', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2232, N'Santana do Garambéu', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2233, N'Santana do Jacaré', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2234, N'Santana do Manhuaçu', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2235, N'Santana do Paraíso', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2236, N'Santana do Riacho', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2237, N'Santana dos Montes', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2238, N'Santo Antônio do Amparo', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2239, N'Santo Antônio do Aventureiro', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2240, N'Santo Antônio do Grama', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2241, N'Santo Antônio do Itambé', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2242, N'Santo Antônio do Jacinto', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2243, N'Santo Antônio do Monte', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2244, N'Santo Antônio do Retiro', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2245, N'Santo Antônio do Rio Abaixo', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2246, N'Santo Hipólito', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2247, N'Santos Dumont', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2248, N'São Bento Abade', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2249, N'São Brás do Suaçuí', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2250, N'São Domingos das Dores', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2251, N'São Domingos do Prata', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2252, N'São Félix de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2253, N'São Francisco', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2254, N'São Francisco de Paula', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2255, N'São Francisco de Sales', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2256, N'São Francisco do Glória', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2257, N'São Geraldo', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2258, N'São Geraldo da Piedade', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2259, N'São Geraldo do Baixio', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2260, N'São Gonçalo do Abaeté', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2261, N'São Gonçalo do Pará', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2262, N'São Gonçalo do Rio Abaixo', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2263, N'São Gonçalo do Rio Preto', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2264, N'São Gonçalo do Sapucaí', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2265, N'São Gotardo', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2266, N'São João Batista do Glória', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2267, N'São João da Lagoa', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2268, N'São João da Mata', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2269, N'São João da Ponte', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2270, N'São João das Missões', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2271, N'São João del Rei', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2272, N'São João do Manhuaçu', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2273, N'São João do Manteninha', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2274, N'São João do Oriente', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2275, N'São João do Pacuí', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2276, N'São João do Paraíso', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2277, N'São João Evangelista', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2278, N'São João Nepomuceno', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2279, N'São Joaquim de Bicas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2280, N'São José da Barra', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2281, N'São José da Lapa', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2282, N'São José da Safira', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2283, N'São José da Varginha', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2284, N'São José do Alegre', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2285, N'São José do Divino', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2286, N'São José do Goiabal', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2287, N'São José do Jacuri', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2288, N'São José do Mantimento', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2289, N'São Lourenço', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2290, N'São Miguel do Anta', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2291, N'São Pedro da União', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2292, N'São Pedro do Suaçuí', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2293, N'São Pedro dos Ferros', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2294, N'São Romão', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2295, N'São Roque de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2296, N'São Sebastião da Bela Vista', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2297, N'São Sebastião da Vargem Alegre', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2298, N'São Sebastião do Anta', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2299, N'São Sebastião do Maranhão', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2300, N'São Sebastião do Oeste', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2301, N'São Sebastião do Paraíso', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2302, N'São Sebastião do Rio Preto', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2303, N'São Sebastião do Rio Verde', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2304, N'São Thomé das Letras', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2305, N'São Tiago', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2306, N'São Tomás de Aquino', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2307, N'São Vicente de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2308, N'Sapucaí-Mirim', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2309, N'Sardoá', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2310, N'Sarzedo', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2311, N'Sem-Peixe', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2312, N'Senador Amaral', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2313, N'Senador Cortes', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2314, N'Senador Firmino', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2315, N'Senador José Bento', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2316, N'Senador Modestino Gonçalves', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2317, N'Senhora de Oliveira', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2318, N'Senhora do Porto', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2319, N'Senhora dos Remédios', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2320, N'Sericita', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2321, N'Seritinga', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2322, N'Serra Azul de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2323, N'Serra da Saudade', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2324, N'Serra do Salitre', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2325, N'Serra dos Aimorés', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2326, N'Serrania', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2327, N'Serranópolis de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2328, N'Serranos', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2329, N'Serro', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2330, N'Sete Lagoas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2331, N'Setubinha', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2332, N'Silveirânia', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2333, N'Silvianópolis', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2334, N'Simão Pereira', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2335, N'Simonésia', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2336, N'Sobrália', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2337, N'Soledade de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2338, N'Tabuleiro', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2339, N'Taiobeiras', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2340, N'Taparuba', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2341, N'Tapira', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2342, N'Tapiraí', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2343, N'Taquaraçu de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2344, N'Tarumirim', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2345, N'Teixeiras', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2346, N'Teófilo Otoni', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2347, N'Timóteo', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2348, N'Tiradentes', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2349, N'Tiros', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2350, N'Tocantins', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2351, N'Tocos do Moji', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2352, N'Toledo', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2353, N'Tombos', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2354, N'Três Corações', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2355, N'Três Marias', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2356, N'Três Pontas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2357, N'Tumiritinga', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2358, N'Tupaciguara', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2359, N'Turmalina', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2360, N'Turvolândia', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2361, N'Ubá', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2362, N'Ubaí', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2363, N'Ubaporanga', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2364, N'Uberaba', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2365, N'Uberlândia', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2366, N'Umburatiba', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2367, N'Unaí', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2368, N'União de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2369, N'Uruana de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2370, N'Urucânia', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2371, N'Urucuia', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2372, N'Vargem Alegre', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2373, N'Vargem Bonita', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2374, N'Vargem Grande do Rio Pardo', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2375, N'Varginha', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2376, N'Varjão de Minas', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2377, N'Várzea da Palma', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2378, N'Varzelândia', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2379, N'Vazante', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2380, N'Verdelândia', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2381, N'Veredinha', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2382, N'Veríssimo', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2383, N'Vermelho Novo', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2384, N'Vespasiano', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2385, N'Viçosa', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2386, N'Vieiras', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2387, N'Virgem da Lapa', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2388, N'Virgínia', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2389, N'Virginópolis', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2390, N'Virgolândia', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2391, N'Visconde do Rio Branco', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2392, N'Volta Grande', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2393, N'Wenceslau Braz', 6);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2394, N'Abaetetuba', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2395, N'Abel Figueiredo', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2396, N'Acará', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2397, N'Afuá', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2398, N'Água Azul do Norte', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2399, N'Alenquer', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2400, N'Almeirim', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2401, N'Altamira', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2402, N'Anajás', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2403, N'Ananindeua', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2404, N'Anapu', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2405, N'Augusto Corrêa', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2406, N'Aurora do Pará', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2407, N'Aveiro', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2408, N'Bagre', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2409, N'Baião', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2410, N'Bannach', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2411, N'Barcarena', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2412, N'Belém', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2413, N'Belterra', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2414, N'Benevides', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2415, N'Bom Jesus do Tocantins', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2416, N'Bonito', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2417, N'Bragança', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2418, N'Brasil Novo', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2419, N'Brejo Grande do Araguaia', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2420, N'Breu Branco', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2421, N'Breves', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2422, N'Bujaru', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2423, N'Cachoeira do Arari', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2424, N'Cachoeira do Piriá', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2425, N'Cametá', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2426, N'Canaã dos Carajás', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2427, N'Capanema', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2428, N'Capitão Poço', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2429, N'Castanhal', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2430, N'Chaves', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2431, N'Colares', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2432, N'Conceição do Araguaia', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2433, N'Concórdia do Pará', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2434, N'Cumaru do Norte', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2435, N'Curionópolis', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2436, N'Curralinho', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2437, N'Curuá', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2438, N'Curuçá', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2439, N'Dom Eliseu', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2440, N'Eldorado dos Carajás', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2441, N'Faro', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2442, N'Floresta do Araguaia', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2443, N'Garrafão do Norte', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2444, N'Goianésia do Pará', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2445, N'Gurupá', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2446, N'Igarapé-Açu', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2447, N'Igarapé-Miri', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2448, N'Inhangapi', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2449, N'Ipixuna do Pará', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2450, N'Irituia', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2451, N'Itaituba', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2452, N'Itupiranga', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2453, N'Jacareacanga', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2454, N'Jacundá', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2455, N'Juruti', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2456, N'Limoeiro do Ajuru', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2457, N'Mãe do Rio', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2458, N'Magalhães Barata', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2459, N'Marabá', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2460, N'Maracanã', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2461, N'Marapanim', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2462, N'Marituba', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2463, N'Medicilândia', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2464, N'Melgaço', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2465, N'Mocajuba', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2466, N'Moju', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2467, N'Monte Alegre', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2468, N'Muaná', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2469, N'Nova Esperança do Piriá', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2470, N'Nova Ipixuna', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2471, N'Nova Timboteua', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2472, N'Novo Progresso', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2473, N'Novo Repartimento', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2474, N'Ã?bidos', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2475, N'Oeiras do Pará', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2476, N'Oriximiná', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2477, N'Ourém', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2478, N'Ourilândia do Norte', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2479, N'Pacajá', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2480, N'Palestina do Pará', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2481, N'Paragominas', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2482, N'Parauapebas', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2483, N'Pau dArco', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2484, N'Peixe-Boi', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2485, N'Piçarra', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2486, N'Placas', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2487, N'Ponta de Pedras', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2488, N'Portel', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2489, N'Porto de Moz', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2490, N'Prainha', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2491, N'Primavera', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2492, N'Quatipuru', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2493, N'Redenção', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2494, N'Rio Maria', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2495, N'Rondon do Pará', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2496, N'Rurópolis', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2497, N'Salinópolis', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2498, N'Salvaterra', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2499, N'Santa Bárbara do Pará', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2500, N'Santa Cruz do Arari', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2501, N'Santa Isabel do Pará', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2502, N'Santa Luzia do Pará', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2503, N'Santa Maria das Barreiras', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2504, N'Santa Maria do Pará', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2505, N'Santana do Araguaia', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2506, N'Santarém', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2507, N'Santarém Novo', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2508, N'Santo Antônio do Tauá', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2509, N'São Caetano de Odivelas', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2510, N'São Domingos do Araguaia', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2511, N'São Domingos do Capim', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2512, N'São Félix do Xingu', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2513, N'São Francisco do Pará', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2514, N'São Geraldo do Araguaia', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2515, N'São João da Ponta', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2516, N'São João de Pirabas', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2517, N'São João do Araguaia', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2518, N'São Miguel do Guamá', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2519, N'São Sebastião da Boa Vista', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2520, N'Sapucaia', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2521, N'Senador José Porfírio', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2522, N'Soure', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2523, N'Tailândia', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2524, N'Terra Alta', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2525, N'Terra Santa', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2526, N'Tomé-Açu', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2527, N'Tracuateua', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2528, N'Trairão', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2529, N'Tucumã', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2530, N'Tucuruí', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2531, N'Ulianópolis', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2532, N'Uruará', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2533, N'Vigia', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2534, N'Viseu', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2535, N'Vitória do Xingu', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2536, N'Xinguara', 19);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2537, N'Água Branca', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2538, N'Aguiar', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2539, N'Alagoa Grande', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2540, N'Alagoa Nova', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2541, N'Alagoinha', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2542, N'Alcantil', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2543, N'Algodão de Jandaíra', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2544, N'Alhandra', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2545, N'Amparo', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2546, N'Aparecida', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2547, N'Araçagi', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2548, N'Arara', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2549, N'Araruna', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2550, N'Areia', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2551, N'Areia de Baraúnas', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2552, N'Areial', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2553, N'Aroeiras', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2554, N'Assunção', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2555, N'Baía da Traição', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2556, N'Bananeiras', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2557, N'Baraúna', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2558, N'Barra de Santa Rosa', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2559, N'Barra de Santana', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2560, N'Barra de São Miguel', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2561, N'Bayeux', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2562, N'Belém', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2563, N'Belém do Brejo do Cruz', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2564, N'Bernardino Batista', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2565, N'Boa Ventura', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2566, N'Boa Vista', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2567, N'Bom Jesus', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2568, N'Bom Sucesso', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2569, N'Bonito de Santa Fé', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2570, N'Boqueirão', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2571, N'Borborema', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2572, N'Brejo do Cruz', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2573, N'Brejo dos Santos', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2574, N'Caaporã', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2575, N'Cabaceiras', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2576, N'Cabedelo', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2577, N'Cachoeira dos Índios', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2578, N'Cacimba de Areia', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2579, N'Cacimba de Dentro', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2580, N'Cacimbas', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2581, N'Caiçara', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2582, N'Cajazeiras', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2583, N'Cajazeirinhas', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2584, N'Caldas Brandão', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2585, N'Camalaú', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2586, N'Campina Grande', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2587, N'Campo de Santana', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2588, N'Capim', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2589, N'Caraúbas', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2590, N'Carrapateira', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2591, N'Casserengue', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2592, N'Catingueira', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2593, N'Catolé do Rocha', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2594, N'Caturité', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2595, N'Conceição', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2596, N'Condado', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2597, N'Conde', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2598, N'Congo', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2599, N'Coremas', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2600, N'Coxixola', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2601, N'Cruz do Espírito Santo', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2602, N'Cubati', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2603, N'Cuité', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2604, N'Cuité de Mamanguape', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2605, N'Cuitegi', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2606, N'Curral de Cima', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2607, N'Curral Velho', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2608, N'Damião', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2609, N'Desterro', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2610, N'Diamante', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2611, N'Dona Inês', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2612, N'Duas Estradas', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2613, N'Emas', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2614, N'Esperança', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2615, N'Fagundes', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2616, N'Frei Martinho', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2617, N'Gado Bravo', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2618, N'Guarabira', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2619, N'Gurinhém', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2620, N'Gurjão', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2621, N'Ibiara', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2622, N'Igaracy', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2623, N'Imaculada', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2624, N'Ingá', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2625, N'Itabaiana', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2626, N'Itaporanga', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2627, N'Itapororoca', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2628, N'Itatuba', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2629, N'Jacaraú', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2630, N'Jericó', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2631, N'João Pessoa', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2632, N'Juarez Távora', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2633, N'Juazeirinho', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2634, N'Junco do Seridó', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2635, N'Juripiranga', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2636, N'Juru', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2637, N'Lagoa', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2638, N'Lagoa de Dentro', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2639, N'Lagoa Seca', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2640, N'Lastro', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2641, N'Livramento', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2642, N'Logradouro', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2643, N'Lucena', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2644, N'Mãe dágua', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2645, N'Malta', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2646, N'Mamanguape', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2647, N'Manaíra', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2648, N'Marcação', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2649, N'Mari', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2650, N'Marizópolis', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2651, N'Massaranduba', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2652, N'Mataraca', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2653, N'Matinhas', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2654, N'Mato Grosso', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2655, N'Maturéia', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2656, N'Mogeiro', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2657, N'Montadas', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2658, N'Monte Horebe', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2659, N'Monteiro', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2660, N'Mulungu', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2661, N'Natuba', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2662, N'Nazarezinho', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2663, N'Nova Floresta', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2664, N'Nova Olinda', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2665, N'Nova Palmeira', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2666, N'Olho dágua', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2667, N'Olivedos', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2668, N'Ouro Velho', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2669, N'Parari', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2670, N'Passagem', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2671, N'Patos', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2672, N'Paulista', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2673, N'Pedra Branca', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2674, N'Pedra Lavrada', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2675, N'Pedras de Fogo', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2676, N'Pedro Régis', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2677, N'Piancó', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2678, N'Picuí', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2679, N'Pilar', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2680, N'Pilões', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2681, N'Pilõezinhos', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2682, N'Pirpirituba', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2683, N'Pitimbu', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2684, N'Pocinhos', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2685, N'Poço Dantas', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2686, N'Poço de José de Moura', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2687, N'Pombal', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2688, N'Prata', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2689, N'Princesa Isabel', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2690, N'Puxinanã', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2691, N'Queimadas', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2692, N'Quixabá', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2693, N'Remígio', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2694, N'Riachão', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2695, N'Riachão do Bacamarte', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2696, N'Riachão do Poço', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2697, N'Riacho de Santo Antônio', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2698, N'Riacho dos Cavalos', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2699, N'Rio Tinto', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2700, N'Salgadinho', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2701, N'Salgado de São Félix', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2702, N'Santa Cecília', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2703, N'Santa Cruz', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2704, N'Santa Helena', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2705, N'Santa Inês', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2706, N'Santa Luzia', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2707, N'Santa Rita', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2708, N'Santa Teresinha', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2709, N'Santana de Mangueira', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2710, N'Santana dos Garrotes', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2711, N'Santarém', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2712, N'Santo André', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2713, N'São Bentinho', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2714, N'São Bento', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2715, N'São Domingos de Pombal', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2716, N'São Domingos do Cariri', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2717, N'São Francisco', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2718, N'São João do Cariri', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2719, N'São João do Rio do Peixe', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2720, N'São João do Tigre', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2721, N'São José da Lagoa Tapada', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2722, N'São José de Caiana', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2723, N'São José de Espinharas', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2724, N'São José de Piranhas', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2725, N'São José de Princesa', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2726, N'São José do Bonfim', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2727, N'São José do Brejo do Cruz', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2728, N'São José do Sabugi', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2729, N'São José dos Cordeiros', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2730, N'São José dos Ramos', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2731, N'São Mamede', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2732, N'São Miguel de Taipu', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2733, N'São Sebastião de Lagoa de Roça', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2734, N'São Sebastião do Umbuzeiro', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2735, N'Sapé', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2736, N'Seridó', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2737, N'Serra Branca', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2738, N'Serra da Raiz', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2739, N'Serra Grande', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2740, N'Serra Redonda', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2741, N'Serraria', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2742, N'Sertãozinho', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2743, N'Sobrado', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2744, N'Solânea', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2745, N'Soledade', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2746, N'Sossêgo', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2747, N'Sousa', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2748, N'Sumé', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2749, N'Taperoá', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2750, N'Tavares', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2751, N'Teixeira', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2752, N'Tenório', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2753, N'Triunfo', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2754, N'Uiraúna', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2755, N'Umbuzeiro', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2756, N'Várzea', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2757, N'Vieirópolis', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2758, N'Vista Serrana', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2759, N'Zabelê', 18);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2760, N'Abatiá', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2761, N'Adrianópolis', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2762, N'Agudos do Sul', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2763, N'Almirante Tamandaré', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2764, N'Altamira do Paraná', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2765, N'Alto Paraná', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2766, N'Alto Piquiri', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2767, N'Altônia', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2768, N'Alvorada do Sul', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2769, N'Amaporã', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2770, N'Ampére', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2771, N'Anahy', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2772, N'Andirá', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2773, N'Ã?ngulo', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2774, N'Antonina', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2775, N'Antônio Olinto', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2776, N'Apucarana', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2777, N'Arapongas', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2778, N'Arapoti', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2779, N'Arapuã', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2780, N'Araruna', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2781, N'Araucária', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2782, N'Ariranha do Ivaí', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2783, N'Assaí', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2784, N'Assis Chateaubriand', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2785, N'Astorga', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2786, N'Atalaia', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2787, N'Balsa Nova', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2788, N'Bandeirantes', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2789, N'Barbosa Ferraz', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2790, N'Barra do Jacaré', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2791, N'Barracão', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2792, N'Bela Vista da Caroba', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2793, N'Bela Vista do Paraíso', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2794, N'Bituruna', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2795, N'Boa Esperança', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2796, N'Boa Esperança do Iguaçu', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2797, N'Boa Ventura de São Roque', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2798, N'Boa Vista da Aparecida', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2799, N'Bocaiúva do Sul', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2800, N'Bom Jesus do Sul', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2801, N'Bom Sucesso', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2802, N'Bom Sucesso do Sul', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2803, N'Borrazópolis', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2804, N'Braganey', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2805, N'Brasilândia do Sul', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2806, N'Cafeara', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2807, N'Cafelândia', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2808, N'Cafezal do Sul', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2809, N'Califórnia', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2810, N'Cambará', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2811, N'Cambé', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2812, N'Cambira', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2813, N'Campina da Lagoa', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2814, N'Campina do Simão', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2815, N'Campina Grande do Sul', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2816, N'Campo Bonito', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2817, N'Campo do Tenente', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2818, N'Campo Largo', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2819, N'Campo Magro', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2820, N'Campo Mourão', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2821, N'Cândido de Abreu', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2822, N'Candói', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2823, N'Cantagalo', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2824, N'Capanema', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2825, N'Capitão Leônidas Marques', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2826, N'Carambeí', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2827, N'Carlópolis', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2828, N'Cascavel', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2829, N'Castro', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2830, N'Catanduvas', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2831, N'Centenário do Sul', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2832, N'Cerro Azul', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2833, N'Céu Azul', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2834, N'Chopinzinho', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2835, N'Cianorte', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2836, N'citsmart_homologacao.dbo.cidades Gaúcha', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2837, N'Clevelândia', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2838, N'Colombo', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2839, N'Colorado', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2840, N'Congonhinhas', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2841, N'Conselheiro Mairinck', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2842, N'Contenda', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2843, N'Corbélia', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2844, N'Cornélio Procópio', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2845, N'Coronel Domingos Soares', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2846, N'Coronel Vivida', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2847, N'Corumbataí do Sul', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2848, N'Cruz Machado', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2849, N'Cruzeiro do Iguaçu', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2850, N'Cruzeiro do Oeste', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2851, N'Cruzeiro do Sul', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2852, N'Cruzmaltina', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2853, N'Curitiba', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2854, N'Curiúva', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2855, N'Diamante dOeste', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2856, N'Diamante do Norte', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2857, N'Diamante do Sul', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2858, N'Dois Vizinhos', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2859, N'Douradina', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2860, N'Doutor Camargo', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2861, N'Doutor Ulysses', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2862, N'Enéas Marques', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2863, N'Engenheiro Beltrão', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2864, N'Entre Rios do Oeste', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2865, N'Esperança Nova', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2866, N'Espigão Alto do Iguaçu', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2867, N'Farol', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2868, N'Faxinal', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2869, N'Fazenda Rio Grande', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2870, N'Fênix', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2871, N'Fernandes Pinheiro', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2872, N'Figueira', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2873, N'Flor da Serra do Sul', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2874, N'Floraí', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2875, N'Floresta', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2876, N'Florestópolis', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2877, N'Flórida', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2878, N'Formosa do Oeste', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2879, N'Foz do Iguaçu', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2880, N'Foz do Jordão', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2881, N'Francisco Alves', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2882, N'Francisco Beltrão', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2883, N'General Carneiro', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2884, N'Godoy Moreira', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2885, N'Goioerê', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2886, N'Goioxim', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2887, N'Grandes Rios', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2888, N'Guaíra', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2889, N'Guairaçá', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2890, N'Guamiranga', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2891, N'Guapirama', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2892, N'Guaporema', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2893, N'Guaraci', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2894, N'Guaraniaçu', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2895, N'Guarapuava', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2896, N'Guaraqueçaba', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2897, N'Guaratuba', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2898, N'Honório Serpa', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2899, N'Ibaiti', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2900, N'Ibema', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2901, N'Ibiporã', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2902, N'Icaraíma', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2903, N'Iguaraçu', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2904, N'Iguatu', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2905, N'Imbaú', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2906, N'Imbituva', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2907, N'Inácio Martins', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2908, N'Inajá', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2909, N'Indianópolis', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2910, N'Ipiranga', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2911, N'Iporã', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2912, N'Iracema do Oeste', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2913, N'Irati', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2914, N'Iretama', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2915, N'Itaguajé', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2916, N'Itaipulândia', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2917, N'Itambaracá', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2918, N'Itambé', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2919, N'Itapejara dOeste', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2920, N'Itaperuçu', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2921, N'Itaúna do Sul', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2922, N'Ivaí', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2923, N'Ivaiporã', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2924, N'Ivaté', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2925, N'Ivatuba', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2926, N'Jaboti', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2927, N'Jacarezinho', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2928, N'Jaguapitã', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2929, N'Jaguariaíva', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2930, N'Jandaia do Sul', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2931, N'Janiópolis', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2932, N'Japira', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2933, N'Japurá', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2934, N'Jardim Alegre', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2935, N'Jardim Olinda', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2936, N'Jataizinho', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2937, N'Jesuítas', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2938, N'Joaquim Távora', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2939, N'Jundiaí do Sul', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2940, N'Juranda', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2941, N'Jussara', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2942, N'Kaloré', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2943, N'Lapa', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2944, N'Laranjal', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2945, N'Laranjeiras do Sul', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2946, N'Leópolis', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2947, N'Lidianópolis', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2948, N'Lindoeste', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2949, N'Loanda', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2950, N'Lobato', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2951, N'Londrina', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2952, N'Luiziana', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2953, N'Lunardelli', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2954, N'Lupionópolis', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2955, N'Mallet', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2956, N'Mamborê', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2957, N'Mandaguaçu', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2958, N'Mandaguari', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2959, N'Mandirituba', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2960, N'Manfrinópolis', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2961, N'Mangueirinha', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2962, N'Manoel Ribas', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2963, N'Marechal Cândido Rondon', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2964, N'Maria Helena', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2965, N'Marialva', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2966, N'Marilândia do Sul', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2967, N'Marilena', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2968, N'Mariluz', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2969, N'Maringá', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2970, N'Mariópolis', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2971, N'Maripá', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2972, N'Marmeleiro', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2973, N'Marquinho', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2974, N'Marumbi', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2975, N'Matelândia', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2976, N'Matinhos', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2977, N'Mato Rico', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2978, N'Mauá da Serra', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2979, N'Medianeira', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2980, N'Mercedes', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2981, N'Mirador', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2982, N'Miraselva', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2983, N'Missal', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2984, N'Moreira Sales', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2985, N'Morretes', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2986, N'Munhoz de Melo', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2987, N'Nossa Senhora das Graças', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2988, N'Nova Aliança do Ivaí', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2989, N'Nova América da Colina', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2990, N'Nova Aurora', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2991, N'Nova Cantu', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2992, N'Nova Esperança', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2993, N'Nova Esperança do Sudoeste', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2994, N'Nova Fátima', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2995, N'Nova Laranjeiras', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2996, N'Nova Londrina', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2997, N'Nova Olímpia', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2998, N'Nova Prata do Iguaçu', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (2999, N'Nova Santa Bárbara', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3000, N'Nova Santa Rosa', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3001, N'Nova Tebas', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3002, N'Novo Itacolomi', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3003, N'Ortigueira', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3004, N'Ourizona', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3005, N'Ouro Verde do Oeste', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3006, N'Paiçandu', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3007, N'Palmas', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3008, N'Palmeira', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3009, N'Palmital', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3010, N'Palotina', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3011, N'Paraíso do Norte', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3012, N'Paranacity', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3013, N'Paranaguá', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3014, N'Paranapoema', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3015, N'Paranavaí', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3016, N'Pato Bragado', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3017, N'Pato Branco', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3018, N'Paula Freitas', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3019, N'Paulo Frontin', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3020, N'Peabiru', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3021, N'Perobal', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3022, N'Pérola', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3023, N'Pérola dOeste', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3024, N'Piên', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3025, N'Pinhais', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3026, N'Pinhal de São Bento', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3027, N'Pinhalão', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3028, N'Pinhão', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3029, N'Piraí do Sul', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3030, N'Piraquara', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3031, N'Pitanga', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3032, N'Pitangueiras', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3033, N'Planaltina do Paraná', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3034, N'Planalto', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3035, N'Ponta Grossa', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3036, N'Pontal do Paraná', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3037, N'Porecatu', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3038, N'Porto Amazonas', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3039, N'Porto Barreiro', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3040, N'Porto Rico', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3041, N'Porto Vitória', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3042, N'Prado Ferreira', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3043, N'Pranchita', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3044, N'Presidente Castelo Branco', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3045, N'Primeiro de Maio', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3046, N'Prudentópolis', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3047, N'Quarto Centenário', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3048, N'Quatiguá', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3049, N'Quatro Barras', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3050, N'Quatro Pontes', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3051, N'Quedas do Iguaçu', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3052, N'Querência do Norte', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3053, N'Quinta do Sol', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3054, N'Quitandinha', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3055, N'Ramilândia', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3056, N'Rancho Alegre', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3057, N'Rancho Alegre dOeste', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3058, N'Realeza', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3059, N'Rebouças', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3060, N'Renascença', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3061, N'Reserva', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3062, N'Reserva do Iguaçu', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3063, N'Ribeirão Claro', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3064, N'Ribeirão do Pinhal', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3065, N'Rio Azul', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3066, N'Rio Bom', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3067, N'Rio Bonito do Iguaçu', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3068, N'Rio Branco do Ivaí', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3069, N'Rio Branco do Sul', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3070, N'Rio Negro', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3071, N'Rolândia', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3072, N'Roncador', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3073, N'Rondon', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3074, N'Rosário do Ivaí', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3075, N'Sabáudia', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3076, N'Salgado Filho', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3077, N'Salto do Itararé', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3078, N'Salto do Lontra', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3079, N'Santa Amélia', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3080, N'Santa Cecília do Pavão', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3081, N'Santa Cruz de Monte Castelo', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3082, N'Santa Fé', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3083, N'Santa Helena', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3084, N'Santa Inês', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3085, N'Santa Isabel do Ivaí', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3086, N'Santa Izabel do Oeste', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3087, N'Santa Lúcia', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3088, N'Santa Maria do Oeste', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3089, N'Santa Mariana', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3090, N'Santa Mônica', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3091, N'Santa Tereza do Oeste', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3092, N'Santa Terezinha de Itaipu', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3093, N'Santana do Itararé', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3094, N'Santo Antônio da Platina', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3095, N'Santo Antônio do Caiuá', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3096, N'Santo Antônio do Paraíso', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3097, N'Santo Antônio do Sudoeste', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3098, N'Santo Inácio', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3099, N'São Carlos do Ivaí', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3100, N'São Jerônimo da Serra', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3101, N'São João', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3102, N'São João do Caiuá', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3103, N'São João do Ivaí', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3104, N'São João do Triunfo', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3105, N'São Jorge dOeste', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3106, N'São Jorge do Ivaí', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3107, N'São Jorge do Patrocínio', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3108, N'São José da Boa Vista', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3109, N'São José das Palmeiras', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3110, N'São José dos Pinhais', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3111, N'São Manoel do Paraná', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3112, N'São Mateus do Sul', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3113, N'São Miguel do Iguaçu', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3114, N'São Pedro do Iguaçu', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3115, N'São Pedro do Ivaí', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3116, N'São Pedro do Paraná', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3117, N'São Sebastião da Amoreira', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3118, N'São Tomé', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3119, N'Sapopema', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3120, N'Sarandi', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3121, N'Saudade do Iguaçu', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3122, N'Sengés', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3123, N'Serranópolis do Iguaçu', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3124, N'Sertaneja', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3125, N'Sertanópolis', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3126, N'Siqueira Campos', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3127, N'Sulina', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3128, N'Tamarana', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3129, N'Tamboara', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3130, N'Tapejara', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3131, N'Tapira', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3132, N'Teixeira Soares', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3133, N'Telêmaco Borba', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3134, N'Terra Boa', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3135, N'Terra Rica', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3136, N'Terra Roxa', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3137, N'Tibagi', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3138, N'Tijucas do Sul', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3139, N'Toledo', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3140, N'Tomazina', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3141, N'Três Barras do Paraná', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3142, N'Tunas do Paraná', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3143, N'Tuneiras do Oeste', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3144, N'Tupãssi', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3145, N'Turvo', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3146, N'Ubiratã', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3147, N'Umuarama', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3148, N'União da Vitória', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3149, N'Uniflor', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3150, N'Uraí', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3151, N'Ventania', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3152, N'Vera Cruz do Oeste', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3153, N'Verê', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3154, N'Vila Alta', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3155, N'Virmond', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3156, N'Vitorino', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3157, N'Wenceslau Braz', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3158, N'Xambrê', 7);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3159, N'Abreu e Lima', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3160, N'Afogados da Ingazeira', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3161, N'Afrânio', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3162, N'Agrestina', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3163, N'Água Preta', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3164, N'Águas Belas', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3165, N'Alagoinha', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3166, N'Aliança', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3167, N'Altinho', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3168, N'Amaraji', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3169, N'Angelim', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3170, N'Araçoiaba', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3171, N'Araripina', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3172, N'Arcoverde', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3173, N'Barra de Guabiraba', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3174, N'Barreiros', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3175, N'Belém de Maria', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3176, N'Belém de São Francisco', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3177, N'Belo Jardim', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3178, N'Betânia', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3179, N'Bezerros', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3180, N'Bodocó', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3181, N'Bom Conselho', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3182, N'Bom Jardim', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3183, N'Bonito', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3184, N'Brejão', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3185, N'Brejinho', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3186, N'Brejo da Madre de Deus', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3187, N'Buenos Aires', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3188, N'Buíque', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3189, N'Cabo de Santo Agostinho', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3190, N'Cabrobó', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3191, N'Cachoeirinha', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3192, N'Caetés', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3193, N'Calçado', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3194, N'Calumbi', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3195, N'Camaragibe', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3196, N'Camocim de São Félix', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3197, N'Camutanga', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3198, N'Canhotinho', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3199, N'Capoeiras', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3200, N'Carnaíba', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3201, N'Carnaubeira da Penha', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3202, N'Carpina', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3203, N'Caruaru', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3204, N'Casinhas', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3205, N'Catende', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3206, N'Cedro', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3207, N'Chã de Alegria', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3208, N'Chã Grande', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3209, N'Condado', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3210, N'Correntes', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3211, N'Cortês', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3212, N'Cumaru', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3213, N'Cupira', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3214, N'Custódia', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3215, N'Dormentes', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3216, N'Escada', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3217, N'Exu', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3218, N'Feira Nova', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3219, N'Fernando de Noronha', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3220, N'Ferreiros', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3221, N'Flores', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3222, N'Floresta', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3223, N'Frei Miguelinho', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3224, N'Gameleira', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3225, N'Garanhuns', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3226, N'Glória do Goitá', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3227, N'Goiana', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3228, N'Granito', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3229, N'Gravatá', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3230, N'Iati', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3231, N'Ibimirim', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3232, N'Ibirajuba', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3233, N'Igarassu', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3234, N'Iguaraci', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3235, N'Inajá', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3236, N'Ingazeira', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3237, N'Ipojuca', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3238, N'Ipubi', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3239, N'Itacuruba', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3240, N'Itaíba', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3241, N'Itamaracá', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3242, N'Itambé', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3243, N'Itapetim', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3244, N'Itapissuma', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3245, N'Itaquitinga', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3246, N'Jaboatão dos Guararapes', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3247, N'Jaqueira', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3248, N'Jataúba', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3249, N'Jatobá', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3250, N'João Alfredo', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3251, N'Joaquim Nabuco', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3252, N'Jucati', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3253, N'Jupi', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3254, N'Jurema', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3255, N'Lagoa do Carro', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3256, N'Lagoa do Itaenga', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3257, N'Lagoa do Ouro', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3258, N'Lagoa dos Gatos', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3259, N'Lagoa Grande', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3260, N'Lajedo', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3261, N'Limoeiro', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3262, N'Macaparana', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3263, N'Machados', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3264, N'Manari', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3265, N'Maraial', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3266, N'Mirandiba', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3267, N'Moreilândia', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3268, N'Moreno', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3269, N'Nazaré da Mata', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3270, N'Olinda', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3271, N'Orobó', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3272, N'Orocó', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3273, N'Ouricuri', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3274, N'Palmares', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3275, N'Palmeirina', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3276, N'Panelas', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3277, N'Paranatama', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3278, N'Parnamirim', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3279, N'Passira', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3280, N'Paudalho', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3281, N'Paulista', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3282, N'Pedra', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3283, N'Pesqueira', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3284, N'Petrolândia', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3285, N'Petrolina', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3286, N'Poção', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3287, N'Pombos', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3288, N'Primavera', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3289, N'Quipapá', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3290, N'Quixaba', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3291, N'Recife', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3292, N'Riacho das Almas', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3293, N'Ribeirão', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3294, N'Rio Formoso', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3295, N'Sairé', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3296, N'Salgadinho', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3297, N'Salgueiro', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3298, N'Saloá', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3299, N'Sanharó', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3300, N'Santa Cruz', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3301, N'Santa Cruz da Baixa Verde', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3302, N'Santa Cruz do Capibaribe', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3303, N'Santa Filomena', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3304, N'Santa Maria da Boa Vista', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3305, N'Santa Maria do Cambucá', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3306, N'Santa Terezinha', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3307, N'São Benedito do Sul', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3308, N'São Bento do Una', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3309, N'São Caitano', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3310, N'São João', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3311, N'São Joaquim do Monte', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3312, N'São José da Coroa Grande', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3313, N'São José do Belmonte', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3314, N'São José do Egito', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3315, N'São Lourenço da Mata', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3316, N'São Vicente Ferrer', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3317, N'Serra Talhada', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3318, N'Serrita', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3319, N'Sertânia', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3320, N'Sirinhaém', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3321, N'Solidão', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3322, N'Surubim', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3323, N'Tabira', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3324, N'Tacaimbó', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3325, N'Tacaratu', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3326, N'Tamandaré', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3327, N'Taquaritinga do Norte', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3328, N'Terezinha', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3329, N'Terra Nova', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3330, N'Timbaúba', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3331, N'Toritama', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3332, N'Tracunhaém', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3333, N'Trindade', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3334, N'Triunfo', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3335, N'Tupanatinga', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3336, N'Tuparetama', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3337, N'Venturosa', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3338, N'Verdejante', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3339, N'Vertente do Lério', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3340, N'Vertentes', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3341, N'Vicência', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3342, N'Vitória de Santo Antão', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3343, N'Xexéu', 20);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3344, N'Acauã', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3345, N'Agricolândia', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3346, N'Água Branca', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3347, N'Alagoinha do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3348, N'Alegrete do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3349, N'Alto Longá', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3350, N'Altos', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3351, N'Alvorada do Gurguéia', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3352, N'Amarante', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3353, N'Angical do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3354, N'Anísio de Abreu', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3355, N'Antônio Almeida', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3356, N'Aroazes', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3357, N'Arraial', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3358, N'Assunção do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3359, N'Avelino Lopes', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3360, N'Baixa Grande do Ribeiro', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3361, N'Barra dAlcântara', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3362, N'Barras', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3363, N'Barreiras do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3364, N'Barro Duro', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3365, N'Batalha', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3366, N'Bela Vista do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3367, N'Belém do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3368, N'Beneditinos', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3369, N'Bertolínia', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3370, N'Betânia do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3371, N'Boa Hora', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3372, N'Bocaina', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3373, N'Bom Jesus', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3374, N'Bom Princípio do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3375, N'Bonfim do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3376, N'Boqueirão do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3377, N'Brasileira', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3378, N'Brejo do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3379, N'Buriti dos Lopes', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3380, N'Buriti dos Montes', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3381, N'Cabeceiras do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3382, N'Cajazeiras do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3383, N'Cajueiro da Praia', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3384, N'Caldeirão Grande do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3385, N'Campinas do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3386, N'Campo Alegre do Fidalgo', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3387, N'Campo Grande do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3388, N'Campo Largo do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3389, N'Campo Maior', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3390, N'Canavieira', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3391, N'Canto do Buriti', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3392, N'Capitão de Campos', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3393, N'Capitão Gervásio Oliveira', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3394, N'Caracol', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3395, N'Caraúbas do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3396, N'Caridade do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3397, N'Castelo do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3398, N'Caxingó', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3399, N'Cocal', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3400, N'Cocal de Telha', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3401, N'Cocal dos Alves', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3402, N'Coivaras', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3403, N'Colônia do Gurguéia', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3404, N'Colônia do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3405, N'Conceição do Canindé', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3406, N'Coronel José Dias', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3407, N'Corrente', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3408, N'Cristalândia do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3409, N'Cristino Castro', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3410, N'Curimatá', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3411, N'Currais', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3412, N'Curral Novo do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3413, N'Curralinhos', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3414, N'Demerval Lobão', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3415, N'Dirceu Arcoverde', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3416, N'Dom Expedito Lopes', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3417, N'Dom Inocêncio', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3418, N'Domingos Mourão', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3419, N'Elesbão Veloso', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3420, N'Eliseu Martins', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3421, N'Esperantina', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3422, N'Fartura do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3423, N'Flores do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3424, N'Floresta do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3425, N'Floriano', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3426, N'Francinópolis', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3427, N'Francisco Ayres', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3428, N'Francisco Macedo', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3429, N'Francisco Santos', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3430, N'Fronteiras', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3431, N'Geminiano', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3432, N'Gilbués', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3433, N'Guadalupe', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3434, N'Guaribas', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3435, N'Hugo Napoleão', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3436, N'Ilha Grande', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3437, N'Inhuma', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3438, N'Ipiranga do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3439, N'Isaías Coelho', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3440, N'Itainópolis', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3441, N'Itaueira', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3442, N'Jacobina do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3443, N'Jaicós', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3444, N'Jardim do Mulato', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3445, N'Jatobá do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3446, N'Jerumenha', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3447, N'João Costa', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3448, N'Joaquim Pires', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3449, N'Joca Marques', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3450, N'José de Freitas', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3451, N'Juazeiro do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3452, N'Júlio Borges', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3453, N'Jurema', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3454, N'Lagoa Alegre', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3455, N'Lagoa de São Francisco', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3456, N'Lagoa do Barro do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3457, N'Lagoa do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3458, N'Lagoa do Sítio', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3459, N'Lagoinha do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3460, N'Landri Sales', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3461, N'Luís Correia', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3462, N'Luzilândia', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3463, N'Madeiro', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3464, N'Manoel Emídio', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3465, N'Marcolândia', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3466, N'Marcos Parente', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3467, N'Massapê do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3468, N'Matias Olímpio', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3469, N'Miguel Alves', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3470, N'Miguel Leão', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3471, N'Milton Brandão', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3472, N'Monsenhor Gil', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3473, N'Monsenhor Hipólito', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3474, N'Monte Alegre do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3475, N'Morro Cabeça no Tempo', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3476, N'Morro do Chapéu do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3477, N'Murici dos Portelas', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3478, N'Nazaré do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3479, N'Nossa Senhora de Nazaré', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3480, N'Nossa Senhora dos Remédios', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3481, N'Nova Santa Rita', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3482, N'Novo Oriente do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3483, N'Novo Santo Antônio', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3484, N'Oeiras', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3485, N'Olho dágua do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3486, N'Padre Marcos', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3487, N'Paes Landim', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3488, N'Pajeú do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3489, N'Palmeira do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3490, N'Palmeirais', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3491, N'Paquetá', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3492, N'Parnaguá', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3493, N'Parnaíba', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3494, N'Passagem Franca do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3495, N'Patos do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3496, N'Paulistana', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3497, N'Pavussu', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3498, N'Pedro II', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3499, N'Pedro Laurentino', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3500, N'Picos', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3501, N'Pimenteiras', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3502, N'Pio IX', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3503, N'Piracuruca', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3504, N'Piripiri', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3505, N'Porto', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3506, N'Porto Alegre do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3507, N'Prata do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3508, N'Queimada Nova', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3509, N'Redenção do Gurguéia', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3510, N'Regeneração', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3511, N'Riacho Frio', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3512, N'Ribeira do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3513, N'Ribeiro Gonçalves', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3514, N'Rio Grande do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3515, N'Santa Cruz do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3516, N'Santa Cruz dos Milagres', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3517, N'Santa Filomena', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3518, N'Santa Luz', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3519, N'Santa Rosa do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3520, N'Santana do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3521, N'Santo Antônio de Lisboa', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3522, N'Santo Antônio dos Milagres', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3523, N'Santo Inácio do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3524, N'São Braz do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3525, N'São Félix do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3526, N'São Francisco de Assis do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3527, N'São Francisco do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3528, N'São Gonçalo do Gurguéia', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3529, N'São Gonçalo do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3530, N'São João da Canabrava', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3531, N'São João da Fronteira', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3532, N'São João da Serra', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3533, N'São João da Varjota', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3534, N'São João do Arraial', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3535, N'São João do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3536, N'São José do Divino', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3537, N'São José do Peixe', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3538, N'São José do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3539, N'São Julião', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3540, N'São Lourenço do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3541, N'São Luis do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3542, N'São Miguel da Baixa Grande', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3543, N'São Miguel do Fidalgo', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3544, N'São Miguel do Tapuio', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3545, N'São Pedro do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3546, N'São Raimundo Nonato', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3547, N'Sebastião Barros', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3548, N'Sebastião Leal', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3549, N'Sigefredo Pacheco', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3550, N'Siõµes', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3551, N'Simplício Mendes', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3552, N'Socorro do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3553, N'Sussuapara', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3554, N'Tamboril do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3555, N'Tanque do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3556, N'Teresina', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3557, N'União', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3558, N'Uruçuí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3559, N'Valença do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3560, N'Várzea Branca', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3561, N'Várzea Grande', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3562, N'Vera Mendes', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3563, N'Vila Nova do Piauí', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3564, N'Wall Ferraz', 21);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3565, N'Angra dos Reis', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3566, N'Aperibé', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3567, N'Araruama', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3568, N'Areal', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3569, N'Armação dos Búzios', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3570, N'Arraial do Cabo', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3571, N'Barra do Piraí', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3572, N'Barra Mansa', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3573, N'Belford Roxo', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3574, N'Bom Jardim', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3575, N'Bom Jesus do Itabapoana', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3576, N'Cabo Frio', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3577, N'Cachoeiras de Macacu', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3578, N'Cambuci', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3579, N'Campos dos Goytacazes', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3580, N'Cantagalo', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3581, N'Carapebus', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3582, N'Cardoso Moreira', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3583, N'Carmo', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3584, N'Casimiro de Abreu', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3585, N'Comendador Levy Gasparian', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3586, N'Conceição de Macabu', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3587, N'Cordeiro', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3588, N'Duas Barras', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3589, N'Duque de Caxias', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3590, N'Engenheiro Paulo de Frontin', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3591, N'Guapimirim', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3592, N'Iguaba Grande', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3593, N'Itaboraí', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3594, N'Itaguaí', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3595, N'Italva', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3596, N'Itaocara', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3597, N'Itaperuna', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3598, N'Itatiaia', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3599, N'Japeri', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3600, N'Laje do Muriaé', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3601, N'Macaé', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3602, N'Macuco', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3603, N'Magé', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3604, N'Mangaratiba', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3605, N'Maricá', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3606, N'Mendes', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3607, N'Miguel Pereira', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3608, N'Miracema', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3609, N'Natividade', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3610, N'Nilópolis', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3611, N'Niterói', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3612, N'Nova Friburgo', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3613, N'Nova Iguaçu', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3614, N'Paracambi', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3615, N'Paraíba do Sul', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3616, N'Parati', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3617, N'Paty do Alferes', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3618, N'Petrópolis', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3619, N'Pinheiral', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3620, N'Piraí', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3621, N'Porciúncula', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3622, N'Porto Real', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3623, N'Quatis', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3624, N'Queimados', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3625, N'Quissamã', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3626, N'Resende', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3627, N'Rio Bonito', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3628, N'Rio Claro', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3629, N'Rio das Flores', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3630, N'Rio das Ostras', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3631, N'Rio de Janeiro', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3632, N'Santa Maria Madalena', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3633, N'Santo Antônio de Pádua', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3634, N'São Fidélis', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3635, N'São Francisco de Itabapoana', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3636, N'São Gonçalo', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3637, N'São João da Barra', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3638, N'São João de Meriti', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3639, N'São José de Ubá', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3640, N'São José do Vale do Rio Preto', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3641, N'São Pedro da Aldeia', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3642, N'São Sebastião do Alto', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3643, N'Sapucaia', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3644, N'Saquarema', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3645, N'Seropédica', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3646, N'Silva Jardim', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3647, N'Sumidouro', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3648, N'Tanguá', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3649, N'Teresópolis', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3650, N'Trajano de Morais', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3651, N'Três Rios', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3652, N'Valença', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3653, N'Varre-Sai', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3654, N'Vassouras', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3655, N'Volta Redonda', 3);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3656, N'Acari', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3657, N'Açu', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3658, N'Afonso Bezerra', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3659, N'Água Nova', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3660, N'Alexandria', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3661, N'Almino Afonso', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3662, N'Alto do Rodrigues', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3663, N'Angicos', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3664, N'Antônio Martins', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3665, N'Apodi', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3666, N'Areia Branca', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3667, N'Arês', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3668, N'Augusto Severo', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3669, N'Baía Formosa', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3670, N'Baraúna', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3671, N'Barcelona', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3672, N'Bento Fernandes', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3673, N'Bodó', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3674, N'Bom Jesus', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3675, N'Brejinho', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3676, N'Caiçara do Norte', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3677, N'Caiçara do Rio do Vento', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3678, N'Caicó', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3679, N'Campo Redondo', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3680, N'Canguaretama', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3681, N'Caraúbas', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3682, N'Carnaúba dos Dantas', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3683, N'Carnaubais', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3684, N'Ceará-Mirim', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3685, N'Cerro Corá', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3686, N'Coronel Ezequiel', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3687, N'Coronel João Pessoa', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3688, N'Cruzeta', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3689, N'Currais Novos', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3690, N'Doutor Severiano', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3691, N'Encanto', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3692, N'Equador', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3693, N'Espírito Santo', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3694, N'Extremoz', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3695, N'Felipe Guerra', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3696, N'Fernando Pedroza', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3697, N'Florânia', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3698, N'Francisco Dantas', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3699, N'Frutuoso Gomes', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3700, N'Galinhos', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3701, N'Goianinha', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3702, N'Governador Dix-Sept Rosado', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3703, N'Grossos', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3704, N'Guamaré', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3705, N'Ielmo Marinho', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3706, N'Ipanguaçu', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3707, N'Ipueira', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3708, N'Itajá', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3709, N'Itaú', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3710, N'Jaçanã', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3711, N'Jandaíra', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3712, N'Janduís', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3713, N'Januário Cicco', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3714, N'Japi', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3715, N'Jardim de Angicos', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3716, N'Jardim de Piranhas', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3717, N'Jardim do Seridó', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3718, N'João Câmara', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3719, N'João Dias', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3720, N'José da Penha', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3721, N'Jucurutu', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3722, N'Lagoa dAnta', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3723, N'Lagoa de Pedras', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3724, N'Lagoa de Velhos', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3725, N'Lagoa Nova', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3726, N'Lagoa Salgada', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3727, N'Lajes', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3728, N'Lajes Pintadas', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3729, N'Lucrécia', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3730, N'Luís Gomes', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3731, N'Macaíba', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3732, N'Macau', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3733, N'Major Sales', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3734, N'Marcelino Vieira', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3735, N'Martins', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3736, N'Maxaranguape', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3737, N'Messias Targino', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3738, N'Montanhas', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3739, N'Monte Alegre', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3740, N'Monte das Gameleiras', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3741, N'Mossoró', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3742, N'Natal', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3743, N'Nísia Floresta', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3744, N'Nova Cruz', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3745, N'Olho-dágua do Borges', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3746, N'Ouro Branco', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3747, N'Paraná', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3748, N'Paraú', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3749, N'Parazinho', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3750, N'Parelhas', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3751, N'Parnamirim', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3752, N'Passa e Fica', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3753, N'Passagem', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3754, N'Patu', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3755, N'Pau dos Ferros', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3756, N'Pedra Grande', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3757, N'Pedra Preta', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3758, N'Pedro Avelino', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3759, N'Pedro Velho', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3760, N'Pendências', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3761, N'Pilões', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3762, N'Poço Branco', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3763, N'Portalegre', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3764, N'Porto do Mangue', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3765, N'Presidente Juscelino', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3766, N'Pureza', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3767, N'Rafael Fernandes', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3768, N'Rafael Godeiro', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3769, N'Riacho da Cruz', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3770, N'Riacho de Santana', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3771, N'Riachuelo', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3772, N'Rio do Fogo', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3773, N'Rodolfo Fernandes', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3774, N'Ruy Barbosa', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3775, N'Santa Cruz', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3776, N'Santa Maria', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3777, N'Santana do Matos', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3778, N'Santana do Seridó', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3779, N'Santo Antônio', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3780, N'São Bento do Norte', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3781, N'São Bento do Trairí', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3782, N'São Fernando', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3783, N'São Francisco do Oeste', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3784, N'São Gonçalo do Amarante', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3785, N'São João do Sabugi', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3786, N'São José de Mipibu', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3787, N'São José do Campestre', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3788, N'São José do Seridó', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3789, N'São Miguel', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3790, N'São Miguel de Touros', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3791, N'São Paulo do Potengi', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3792, N'São Pedro', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3793, N'São Rafael', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3794, N'São Tomé', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3795, N'São Vicente', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3796, N'Senador Elói de Souza', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3797, N'Senador Georgino Avelino', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3798, N'Serra de São Bento', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3799, N'Serra do Mel', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3800, N'Serra Negra do Norte', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3801, N'Serrinha', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3802, N'Serrinha dos Pintos', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3803, N'Severiano Melo', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3804, N'Sítio Novo', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3805, N'Taboleiro Grande', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3806, N'Taipu', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3807, N'Tangará', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3808, N'Tenente Ananias', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3809, N'Tenente Laurentino Cruz', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3810, N'Tibau', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3811, N'Tibau do Sul', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3812, N'Timbaúba dos Batistas', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3813, N'Touros', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3814, N'Triunfo Potiguar', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3815, N'Umarizal', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3816, N'Upanema', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3817, N'Várzea', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3818, N'Venha-Ver', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3819, N'Vera Cruz', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3820, N'Viçosa', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3821, N'Vila Flor', 22);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3822, N'Água Santa', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3823, N'Agudo', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3824, N'Ajuricaba', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3825, N'Alecrim', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3826, N'Alegrete', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3827, N'Alegria', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3828, N'Alpestre', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3829, N'Alto Alegre', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3830, N'Alto Feliz', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3831, N'Alvorada', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3832, N'Amaral Ferrador', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3833, N'Ametista do Sul', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3834, N'André da Rocha', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3835, N'Anta Gorda', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3836, N'Antônio Prado', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3837, N'Arambaré', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3838, N'Araricá', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3839, N'Aratiba', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3840, N'Arroio do Meio', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3841, N'Arroio do Sal', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3842, N'Arroio do Tigre', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3843, N'Arroio dos Ratos', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3844, N'Arroio Grande', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3845, N'Arvorezinha', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3846, N'Augusto Pestana', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3847, N'Áurea', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3848, N'Bagé', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3849, N'Balneário Pinhal', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3850, N'Barão', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3851, N'Barão de Cotegipe', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3852, N'Barão do Triunfo', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3853, N'Barra do Guarita', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3854, N'Barra do Quaraí', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3855, N'Barra do Ribeiro', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3856, N'Barra do Rio Azul', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3857, N'Barra Funda', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3858, N'Barracão', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3859, N'Barros Cassal', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3860, N'Benjamin Constant do Sul', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3861, N'Bento Gonçalves', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3862, N'Boa Vista das Missões', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3863, N'Boa Vista do Buricá', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3864, N'Boa Vista do Sul', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3865, N'Bom Jesus', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3866, N'Bom Princípio', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3867, N'Bom Progresso', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3868, N'Bom Retiro do Sul', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3869, N'Boqueirão do Leão', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3870, N'Bossoroca', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3871, N'Braga', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3872, N'Brochier', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3873, N'Butiá', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3874, N'Caçapava do Sul', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3875, N'Cacequi', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3876, N'Cachoeira do Sul', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3877, N'Cachoeirinha', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3878, N'Cacique Doble', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3879, N'Caibaté', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3880, N'Caiçara', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3881, N'Camaquã', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3882, N'Camargo', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3883, N'Cambará do Sul', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3884, N'Campestre da Serra', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3885, N'Campina das Missões', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3886, N'Campinas do Sul', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3887, N'Campo Bom', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3888, N'Campo Novo', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3889, N'Campos Borges', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3890, N'Candelária', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3891, N'Cândido Godói', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3892, N'Candiota', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3893, N'Canela', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3894, N'Canguçu', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3895, N'Canoas', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3896, N'Capão da Canoa', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3897, N'Capão do Leão', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3898, N'Capela de Santana', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3899, N'Capitão', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3900, N'Capivari do Sul', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3901, N'Caraá', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3902, N'Carazinho', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3903, N'Carlos Barbosa', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3904, N'Carlos Gomes', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3905, N'Casca', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3906, N'Caseiros', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3907, N'Catuípe', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3908, N'Caxias do Sul', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3909, N'Centenário', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3910, N'Cerrito', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3911, N'Cerro Branco', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3912, N'Cerro Grande', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3913, N'Cerro Grande do Sul', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3914, N'Cerro Largo', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3915, N'Chapada', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3916, N'Charqueadas', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3917, N'Charrua', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3918, N'Chiapeta', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3919, N'Chuí', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3920, N'Chuvisca', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3921, N'Cidreira', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3922, N'Ciríaco', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3923, N'Colinas', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3924, N'Colorado', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3925, N'Condor', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3926, N'Constantina', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3927, N'Coqueiros do Sul', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3928, N'Coronel Barros', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3929, N'Coronel Bicaco', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3930, N'Cotiporã', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3931, N'Coxilha', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3932, N'Crissiumal', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3933, N'Cristal', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3934, N'Cristal do Sul', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3935, N'Cruz Alta', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3936, N'Cruzeiro do Sul', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3937, N'David Canabarro', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3938, N'Derrubadas', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3939, N'Dezesseis de Novembro', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3940, N'Dilermando de Aguiar', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3941, N'Dois Irmãos', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3942, N'Dois Irmãos das Missões', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3943, N'Dois Lajeados', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3944, N'Dom Feliciano', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3945, N'Dom Pedrito', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3946, N'Dom Pedro de Alcântara', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3947, N'Dona Francisca', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3948, N'Doutor Maurício Cardoso', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3949, N'Doutor Ricardo', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3950, N'Eldorado do Sul', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3951, N'Encantado', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3952, N'Encruzilhada do Sul', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3953, N'Engenho Velho', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3954, N'Entre Rios do Sul', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3955, N'Entre-Ijuís', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3956, N'Erebango', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3957, N'Erechim', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3958, N'Ernestina', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3959, N'Erval Grande', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3960, N'Erval Seco', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3961, N'Esmeralda', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3962, N'Esperança do Sul', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3963, N'Espumoso', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3964, N'Estação', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3965, N'Estância Velha', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3966, N'Esteio', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3967, N'Estrela', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3968, N'Estrela Velha', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3969, N'Eugênio de Castro', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3970, N'Fagundes Varela', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3971, N'Farroupilha', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3972, N'Faxinal do Soturno', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3973, N'Faxinalzinho', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3974, N'Fazenda Vilanova', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3975, N'Feliz', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3976, N'Flores da Cunha', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3977, N'Floriano Peixoto', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3978, N'Fontoura Xavier', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3979, N'Formigueiro', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3980, N'Fortaleza dos Valos', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3981, N'Frederico Westphalen', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3982, N'Garibaldi', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3983, N'Garruchos', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3984, N'Gaurama', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3985, N'General Câmara', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3986, N'Gentil', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3987, N'Getúlio Vargas', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3988, N'Giruá', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3989, N'Glorinha', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3990, N'Gramado', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3991, N'Gramado dos Loureiros', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3992, N'Gramado Xavier', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3993, N'Gravataí', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3994, N'Guabiju', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3995, N'Guaíba', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3996, N'Guaporé', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3997, N'Guarani das Missões', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3998, N'Harmonia', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (3999, N'Herval', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4000, N'Herveiras', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4001, N'Horizontina', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4002, N'Hulha Negra', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4003, N'Humaitá', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4004, N'Ibarama', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4005, N'Ibiaçá', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4006, N'Ibiraiaras', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4007, N'Ibirapuitã', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4008, N'Ibirubá', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4009, N'Igrejinha', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4010, N'Ijuí', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4011, N'Ilópolis', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4012, N'Imbé', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4013, N'Imigrante', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4014, N'Independência', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4015, N'Inhacorá', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4016, N'Ipê', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4017, N'Ipiranga do Sul', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4018, N'Iraí', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4019, N'Itaara', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4020, N'Itacurubi', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4021, N'Itapuca', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4022, N'Itaqui', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4023, N'Itatiba do Sul', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4024, N'Ivorá', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4025, N'Ivoti', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4026, N'Jaboticaba', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4027, N'Jacutinga', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4028, N'Jaguarão', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4029, N'Jaguari', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4030, N'Jaquirana', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4031, N'Jari', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4032, N'Jóia', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4033, N'Júlio de Castilhos', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4034, N'Lagoa dos Três Cantos', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4035, N'Lagoa Vermelha', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4036, N'Lagoão', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4037, N'Lajeado', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4038, N'Lajeado do Bugre', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4039, N'Lavras do Sul', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4040, N'Liberato Salzano', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4041, N'Lindolfo Collor', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4042, N'Linha Nova', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4043, N'Maçambara', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4044, N'Machadinho', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4045, N'Mampituba', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4046, N'Manoel Viana', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4047, N'Maquiné', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4048, N'Maratá', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4049, N'Marau', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4050, N'Marcelino Ramos', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4051, N'Mariana Pimentel', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4052, N'Mariano Moro', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4053, N'Marques de Souza', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4054, N'Mata', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4055, N'Mato Castelhano', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4056, N'Mato Leitão', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4057, N'Maximiliano de Almeida', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4058, N'Minas do Leão', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4059, N'Miraguaí', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4060, N'Montauri', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4061, N'Monte Alegre dos Campos', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4062, N'Monte Belo do Sul', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4063, N'Montenegro', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4064, N'Mormaço', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4065, N'Morrinhos do Sul', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4066, N'Morro Redondo', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4067, N'Morro Reuter', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4068, N'Mostardas', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4069, N'Muçum', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4070, N'Muitos Capões', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4071, N'Muliterno', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4072, N'Não-Me-Toque', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4073, N'Nicolau Vergueiro', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4074, N'Nonoai', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4075, N'Nova Alvorada', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4076, N'Nova Araçá', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4077, N'Nova Bassano', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4078, N'Nova Boa Vista', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4079, N'Nova Bréscia', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4080, N'Nova Candelária', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4081, N'Nova Esperança do Sul', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4082, N'Nova Hartz', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4083, N'Nova Pádua', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4084, N'Nova Palma', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4085, N'Nova Petrópolis', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4086, N'Nova Prata', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4087, N'Nova Ramada', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4088, N'Nova Roma do Sul', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4089, N'Nova Santa Rita', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4090, N'Novo Barreiro', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4091, N'Novo Cabrais', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4092, N'Novo Hamburgo', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4093, N'Novo Machado', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4094, N'Novo Tiradentes', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4095, N'Osório', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4096, N'Paim Filho', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4097, N'Palmares do Sul', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4098, N'Palmeira das Missões', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4099, N'Palmitinho', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4100, N'Panambi', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4101, N'Pantano Grande', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4102, N'Paraí', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4103, N'Paraíso do Sul', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4104, N'Pareci Novo', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4105, N'Parobé', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4106, N'Passa Sete', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4107, N'Passo do Sobrado', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4108, N'Passo Fundo', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4109, N'Paverama', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4110, N'Pedro Osório', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4111, N'Pejuçara', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4112, N'Pelotas', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4113, N'Picada Café', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4114, N'Pinhal', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4115, N'Pinhal Grande', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4116, N'Pinheirinho do Vale', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4117, N'Pinheiro Machado', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4118, N'Pirapó', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4119, N'Piratini', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4120, N'Planalto', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4121, N'Poço das Antas', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4122, N'Pontão', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4123, N'Ponte Preta', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4124, N'Portão', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4125, N'Porto Alegre', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4126, N'Porto Lucena', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4127, N'Porto Mauá', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4128, N'Porto Vera Cruz', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4129, N'Porto Xavier', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4130, N'Pouso Novo', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4131, N'Presidente Lucena', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4132, N'Progresso', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4133, N'Protásio Alves', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4134, N'Putinga', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4135, N'Quaraí', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4136, N'Quevedos', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4137, N'Quinze de Novembro', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4138, N'Redentora', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4139, N'Relvado', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4140, N'Restinga Seca', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4141, N'Rio dos Índios', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4142, N'Rio Grande', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4143, N'Rio Pardo', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4144, N'Riozinho', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4145, N'Roca Sales', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4146, N'Rodeio Bonito', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4147, N'Rolante', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4148, N'Ronda Alta', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4149, N'Rondinha', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4150, N'Roque Gonzales', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4151, N'Rosário do Sul', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4152, N'Sagrada Família', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4153, N'Saldanha Marinho', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4154, N'Salto do Jacuí', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4155, N'Salvador das Missões', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4156, N'Salvador do Sul', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4157, N'Sananduva', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4158, N'Santa Bárbara do Sul', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4159, N'Santa Clara do Sul', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4160, N'Santa Cruz do Sul', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4161, N'Santa Maria', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4162, N'Santa Maria do Herval', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4163, N'Santa Rosa', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4164, N'Santa Tereza', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4165, N'Santa Vitória do Palmar', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4166, N'Santana da Boa Vista', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4167, N'Santana do Livramento', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4168, N'Santiago', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4169, N'Santo Ã?ngelo', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4170, N'Santo Antônio da Patrulha', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4171, N'Santo Antônio das Missões', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4172, N'Santo Antônio do Palma', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4173, N'Santo Antônio do Planalto', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4174, N'Santo Augusto', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4175, N'Santo Cristo', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4176, N'Santo Expedito do Sul', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4177, N'São Borja', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4178, N'São Domingos do Sul', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4179, N'São Francisco de Assis', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4180, N'São Francisco de Paula', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4181, N'São Gabriel', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4182, N'São Jerônimo', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4183, N'São João da Urtiga', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4184, N'São João do Polêsine', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4185, N'São Jorge', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4186, N'São José das Missões', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4187, N'São José do Herval', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4188, N'São José do Hortêncio', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4189, N'São José do Inhacorá', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4190, N'São José do Norte', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4191, N'São José do Ouro', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4192, N'São José dos Ausentes', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4193, N'São Leopoldo', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4194, N'São Lourenço do Sul', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4195, N'São Luiz Gonzaga', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4196, N'São Marcos', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4197, N'São Martinho', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4198, N'São Martinho da Serra', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4199, N'São Miguel das Missões', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4200, N'São Nicolau', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4201, N'São Paulo das Missões', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4202, N'São Pedro da Serra', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4203, N'São Pedro do Butiá', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4204, N'São Pedro do Sul', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4205, N'São Sebastião do Caí', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4206, N'São Sepé', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4207, N'São Valentim', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4208, N'São Valentim do Sul', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4209, N'São Valério do Sul', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4210, N'São Vendelino', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4211, N'São Vicente do Sul', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4212, N'Sapiranga', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4213, N'Sapucaia do Sul', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4214, N'Sarandi', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4215, N'Seberi', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4216, N'Sede Nova', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4217, N'Segredo', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4218, N'Selbach', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4219, N'Senador Salgado Filho', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4220, N'Sentinela do Sul', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4221, N'Serafina Corrêa', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4222, N'Sério', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4223, N'Sertão', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4224, N'Sertão Santana', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4225, N'Sete de Setembro', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4226, N'Severiano de Almeida', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4227, N'Silveira Martins', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4228, N'Sinimbu', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4229, N'Sobradinho', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4230, N'Soledade', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4231, N'Tabaí', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4232, N'Tapejara', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4233, N'Tapera', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4234, N'Tapes', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4235, N'Taquara', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4236, N'Taquari', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4237, N'Taquaruçu do Sul', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4238, N'Tavares', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4239, N'Tenente Portela', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4240, N'Terra de Areia', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4241, N'Teutônia', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4242, N'Tiradentes do Sul', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4243, N'Toropi', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4244, N'Torres', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4245, N'Tramandaí', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4246, N'Travesseiro', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4247, N'Três Arroios', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4248, N'Três Cachoeiras', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4249, N'Três Coroas', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4250, N'Três de Maio', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4251, N'Três Forquilhas', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4252, N'Três Palmeiras', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4253, N'Três Passos', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4254, N'Trindade do Sul', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4255, N'Triunfo', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4256, N'Tucunduva', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4257, N'Tunas', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4258, N'Tupanci do Sul', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4259, N'Tupanciretã', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4260, N'Tupandi', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4261, N'Tuparendi', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4262, N'Turuçu', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4263, N'Ubiretama', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4264, N'União da Serra', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4265, N'Unistalda', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4266, N'Uruguaiana', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4267, N'Vacaria', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4268, N'Vale do Sol', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4269, N'Vale Real', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4270, N'Vale Verde', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4271, N'Vanini', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4272, N'Venâncio Aires', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4273, N'Vera Cruz', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4274, N'Veranópolis', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4275, N'Vespasiano Correa', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4276, N'Viadutos', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4277, N'Viamão', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4278, N'Vicente Dutra', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4279, N'Victor Graeff', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4280, N'Vila Flores', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4281, N'Vila Lângaro', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4282, N'Vila Maria', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4283, N'Vila Nova do Sul', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4284, N'Vista Alegre', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4285, N'Vista Alegre do Prata', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4286, N'Vista Gaúcha', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4287, N'Vitória das Missões', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4288, N'Xangri-lá', 23);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4289, N'Alta Floresta dOeste', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4290, N'Alto Alegre dos Parecis', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4291, N'Alto Paraíso', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4292, N'Alvorada dOeste', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4293, N'Ariquemes', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4294, N'Buritis', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4295, N'Cabixi', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4296, N'Cacaulândia', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4297, N'Cacoal', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4298, N'Campo Novo de Rondônia', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4299, N'Candeias do Jamari', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4300, N'Castanheiras', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4301, N'Cerejeiras', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4302, N'Chupinguaia', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4303, N'Colorado do Oeste', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4304, N'Corumbiara', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4305, N'Costa Marques', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4306, N'Cujubim', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4307, N'Espigão dOeste', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4308, N'Governador Jorge Teixeira', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4309, N'Guajará-Mirim', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4310, N'Itapuã do Oeste', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4311, N'Jaru', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4312, N'Ji-Paraná', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4313, N'Machadinho dOeste', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4314, N'Ministro Andreazza', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4315, N'Mirante da Serra', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4316, N'Monte Negro', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4317, N'Nova Brasilândia dOeste', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4318, N'Nova Mamoré', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4319, N'Nova União', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4320, N'Novo Horizonte do Oeste', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4321, N'Ouro Preto do Oeste', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4322, N'Parecis', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4323, N'Pimenta Bueno', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4324, N'Pimenteiras do Oeste', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4325, N'Porto Velho', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4326, N'Presidente Médici', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4327, N'Primavera de Rondônia', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4328, N'Rio Crespo', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4329, N'Rolim de Moura', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4330, N'Santa Luzia dOeste', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4331, N'São Felipe dOeste', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4332, N'São Francisco do Guaporé', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4333, N'São Miguel do Guaporé', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4334, N'Seringueiras', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4335, N'Teixeirópolis', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4336, N'Theobroma', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4337, N'Urupá', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4338, N'Vale do Anari', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4339, N'Vale do Paraíso', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4340, N'Vilhena', 24);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4341, N'Alto Alegre', 25);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4342, N'Amajari', 25);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4343, N'Boa Vista', 25);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4344, N'Bonfim', 25);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4345, N'Cantá', 25);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4346, N'Caracaraí', 25);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4347, N'Caroebe', 25);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4348, N'Iracema', 25);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4349, N'Mucajaí', 25);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4350, N'Normandia', 25);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4351, N'Pacaraima', 25);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4352, N'Rorainópolis', 25);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4353, N'São João da Baliza', 25);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4354, N'São Luiz', 25);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4355, N'Uiramutã', 25);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4356, N'Abdon Batista', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4357, N'Abelardo Luz', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4358, N'Agrolândia', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4359, N'Agronômica', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4360, N'Água Doce', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4361, N'Águas de Chapecó', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4362, N'Águas Frias', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4363, N'Águas Mornas', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4364, N'Alfredo Wagner', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4365, N'Alto Bela Vista', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4366, N'Anchieta', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4367, N'Angelina', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4368, N'Anita Garibaldi', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4369, N'Anitápolis', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4370, N'Antônio Carlos', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4371, N'Apiúna', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4372, N'Arabutã', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4373, N'Araquari', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4374, N'Araranguá', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4375, N'Armazém', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4376, N'Arroio Trinta', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4377, N'Arvoredo', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4378, N'Ascurra', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4379, N'Atalanta', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4380, N'Aurora', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4381, N'Balneário Arroio do Silva', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4382, N'Balneário Barra do Sul', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4383, N'Balneário Camboriú', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4384, N'Balneário Gaivota', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4385, N'Bandeirante', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4386, N'Barra Bonita', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4387, N'Barra Velha', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4388, N'Bela Vista do Toldo', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4389, N'Belmonte', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4390, N'Benedito Novo', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4391, N'Biguaçu', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4392, N'Blumenau', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4393, N'Bocaina do Sul', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4394, N'Bom Jardim da Serra', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4395, N'Bom Jesus', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4396, N'Bom Jesus do Oeste', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4397, N'Bom Retiro', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4398, N'Bombinhas', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4399, N'Botuverá', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4400, N'Braço do Norte', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4401, N'Braço do Trombudo', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4402, N'Brunópolis', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4403, N'Brusque', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4404, N'Caçador', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4405, N'Caibi', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4406, N'Calmon', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4407, N'Camboriú', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4408, N'Campo Alegre', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4409, N'Campo Belo do Sul', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4410, N'Campo Erê', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4411, N'Campos Novos', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4412, N'Canelinha', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4413, N'Canoinhas', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4414, N'Capão Alto', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4415, N'Capinzal', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4416, N'Capivari de Baixo', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4417, N'Catanduvas', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4418, N'Caxambu do Sul', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4419, N'Celso Ramos', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4420, N'Cerro Negro', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4421, N'Chapadão do Lageado', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4422, N'Chapecó', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4423, N'Cocal do Sul', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4424, N'Concórdia', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4425, N'Cordilheira Alta', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4426, N'Coronel Freitas', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4427, N'Coronel Martins', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4428, N'Correia Pinto', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4429, N'Corupá', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4430, N'Criciúma', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4431, N'Cunha Porã', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4432, N'Cunhataí', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4433, N'Curitibanos', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4434, N'Descanso', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4435, N'Dionísio Cerqueira', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4436, N'Dona Emma', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4437, N'Doutor Pedrinho', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4438, N'Entre Rios', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4439, N'Ermo', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4440, N'Erval Velho', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4441, N'Faxinal dos Guedes', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4442, N'Flor do Sertão', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4443, N'Florianópolis', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4444, N'Formosa do Sul', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4445, N'Forquilhinha', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4446, N'Fraiburgo', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4447, N'Frei Rogério', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4448, N'Galvão', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4449, N'Garopaba', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4450, N'Garuva', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4451, N'Gaspar', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4452, N'Governador Celso Ramos', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4453, N'Grão Pará', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4454, N'Gravatal', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4455, N'Guabiruba', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4456, N'Guaraciaba', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4457, N'Guaramirim', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4458, N'Guarujá do Sul', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4459, N'Guatambú', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4460, N'Herval dOeste', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4461, N'Ibiam', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4462, N'Ibicaré', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4463, N'Ibirama', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4464, N'Içara', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4465, N'Ilhota', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4466, N'Imaruí', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4467, N'Imbituba', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4468, N'Imbuia', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4469, N'Indaial', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4470, N'Iomerê', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4471, N'Ipira', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4472, N'Iporã do Oeste', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4473, N'Ipuaçu', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4474, N'Ipumirim', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4475, N'Iraceminha', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4476, N'Irani', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4477, N'Irati', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4478, N'Irineópolis', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4479, N'Itá', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4480, N'Itaiópolis', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4481, N'Itajaí', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4482, N'Itapema', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4483, N'Itapiranga', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4484, N'Itapoá', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4485, N'Ituporanga', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4486, N'Jaborá', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4487, N'Jacinto Machado', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4488, N'Jaguaruna', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4489, N'Jaraguá do Sul', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4490, N'Jardinópolis', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4491, N'Joaçaba', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4492, N'Joinville', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4493, N'José Boiteux', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4494, N'Jupiá', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4495, N'Lacerdópolis', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4496, N'Lages', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4497, N'Laguna', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4498, N'Lajeado Grande', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4499, N'Laurentino', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4500, N'Lauro Muller', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4501, N'Lebon Régis', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4502, N'Leoberto Leal', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4503, N'Lindóia do Sul', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4504, N'Lontras', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4505, N'Luiz Alves', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4506, N'Luzerna', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4507, N'Macieira', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4508, N'Mafra', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4509, N'Major Gercino', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4510, N'Major Vieira', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4511, N'Maracajá', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4512, N'Maravilha', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4513, N'Marema', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4514, N'Massaranduba', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4515, N'Matos Costa', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4516, N'Meleiro', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4517, N'Mirim Doce', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4518, N'Modelo', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4519, N'Mondaí', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4520, N'Monte Carlo', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4521, N'Monte Castelo', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4522, N'Morro da Fumaça', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4523, N'Morro Grande', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4524, N'Navegantes', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4525, N'Nova Erechim', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4526, N'Nova Itaberaba', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4527, N'Nova Trento', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4528, N'Nova Veneza', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4529, N'Novo Horizonte', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4530, N'Orleans', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4531, N'Otacílio Costa', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4532, N'Ouro', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4533, N'Ouro Verde', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4534, N'Paial', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4535, N'Painel', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4536, N'Palhoça', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4537, N'Palma Sola', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4538, N'Palmeira', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4539, N'Palmitos', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4540, N'Papanduva', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4541, N'Paraíso', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4542, N'Passo de Torres', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4543, N'Passos Maia', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4544, N'Paulo Lopes', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4545, N'Pedras Grandes', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4546, N'Penha', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4547, N'Peritiba', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4548, N'Petrolândia', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4549, N'Piçarras', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4550, N'Pinhalzinho', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4551, N'Pinheiro Preto', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4552, N'Piratuba', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4553, N'Planalto Alegre', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4554, N'Pomerode', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4555, N'Ponte Alta', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4556, N'Ponte Alta do Norte', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4557, N'Ponte Serrada', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4558, N'Porto Belo', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4559, N'Porto União', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4560, N'Pouso Redondo', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4561, N'Praia Grande', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4562, N'Presidente Castelo Branco', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4563, N'Presidente Getúlio', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4564, N'Presidente Nereu', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4565, N'Princesa', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4566, N'Quilombo', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4567, N'Rancho Queimado', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4568, N'Rio das Antas', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4569, N'Rio do Campo', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4570, N'Rio do Oeste', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4571, N'Rio do Sul', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4572, N'Rio dos Cedros', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4573, N'Rio Fortuna', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4574, N'Rio Negrinho', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4575, N'Rio Rufino', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4576, N'Riqueza', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4577, N'Rodeio', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4578, N'Romelândia', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4579, N'Salete', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4580, N'Saltinho', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4581, N'Salto Veloso', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4582, N'Sangão', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4583, N'Santa Cecília', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4584, N'Santa Helena', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4585, N'Santa Rosa de Lima', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4586, N'Santa Rosa do Sul', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4587, N'Santa Terezinha', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4588, N'Santa Terezinha do Progresso', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4589, N'Santiago do Sul', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4590, N'Santo Amaro da Imperatriz', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4591, N'São Bento do Sul', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4592, N'São Bernardino', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4593, N'São Bonifácio', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4594, N'São Carlos', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4595, N'São Cristovão do Sul', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4596, N'São Domingos', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4597, N'São Francisco do Sul', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4598, N'São João Batista', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4599, N'São João do Itaperiú', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4600, N'São João do Oeste', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4601, N'São João do Sul', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4602, N'São Joaquim', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4603, N'São José', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4604, N'São José do Cedro', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4605, N'São José do Cerrito', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4606, N'São Lourenço do Oeste', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4607, N'São Ludgero', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4608, N'São Martinho', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4609, N'São Miguel da Boa Vista', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4610, N'São Miguel do Oeste', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4611, N'São Pedro de Alcântara', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4612, N'Saudades', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4613, N'Schroeder', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4614, N'Seara', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4615, N'Serra Alta', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4616, N'Siderópolis', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4617, N'Sombrio', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4618, N'Sul Brasil', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4619, N'Taió', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4620, N'Tangará', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4621, N'Tigrinhos', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4622, N'Tijucas', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4623, N'Timbé do Sul', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4624, N'Timbó', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4625, N'Timbó Grande', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4626, N'Três Barras', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4627, N'Treviso', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4628, N'Treze de Maio', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4629, N'Treze Tílias', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4630, N'Trombudo Central', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4631, N'Tubarão', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4632, N'Tunápolis', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4633, N'Turvo', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4634, N'União do Oeste', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4635, N'Urubici', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4636, N'Urupema', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4637, N'Urussanga', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4638, N'Vargeão', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4639, N'Vargem', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4640, N'Vargem Bonita', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4641, N'Vidal Ramos', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4642, N'Videira', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4643, N'Vitor Meireles', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4644, N'Witmarsum', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4645, N'Xanxerê', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4646, N'Xavantina', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4647, N'Xaxim', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4648, N'Zortéa', 26);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4649, N'Adamantina', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4650, N'Adolfo', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4651, N'Aguaí', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4652, N'Águas da Prata', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4653, N'Águas de Lindóia', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4654, N'Águas de Santa Bárbara', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4655, N'Águas de São Pedro', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4656, N'Agudos', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4657, N'Alambari', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4658, N'Alfredo Marcondes', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4659, N'Altair', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4660, N'Altinópolis', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4661, N'Alto Alegre', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4662, N'Alumínio', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4663, N'Álvares Florence', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4664, N'Álvares Machado', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4665, N'Álvaro de Carvalho', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4666, N'Alvinlândia', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4667, N'Americana', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4668, N'Américo Brasiliense', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4669, N'Américo de Campos', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4670, N'Amparo', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4671, N'Analândia', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4672, N'Andradina', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4673, N'Angatuba', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4674, N'Anhembi', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4675, N'Anhumas', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4676, N'Aparecida', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4677, N'Aparecida dOeste', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4678, N'Apiaí', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4679, N'Araçariguama', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4680, N'Araçatuba', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4681, N'Araçoiaba da Serra', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4682, N'Aramina', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4683, N'Arandu', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4684, N'Arapeí', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4685, N'Araraquara', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4686, N'Araras', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4687, N'Arco-íris', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4688, N'Arealva', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4689, N'Areias', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4690, N'Areiópolis', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4691, N'Ariranha', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4692, N'Artur Nogueira', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4693, N'Arujá', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4694, N'Aspásia', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4695, N'Assis', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4696, N'Atibaia', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4697, N'Auriflama', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4698, N'Avaí', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4699, N'Avanhandava', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4700, N'Avaré', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4701, N'Bady Bassitt', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4702, N'Balbinos', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4703, N'Bálsamo', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4704, N'Bananal', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4705, N'Barão de Antonina', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4706, N'Barbosa', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4707, N'Bariri', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4708, N'Barra Bonita', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4709, N'Barra do Chapéu', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4710, N'Barra do Turvo', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4711, N'Barretos', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4712, N'Barrinha', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4713, N'Barueri', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4714, N'Bastos', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4715, N'Batatais', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4716, N'Bauru', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4717, N'Bebedouro', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4718, N'Bento de Abreu', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4719, N'Bernardino de Campos', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4720, N'Bertioga', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4721, N'Bilac', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4722, N'Birigui', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4723, N'Biritiba-Mirim', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4724, N'Boa Esperança do Sul', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4725, N'Bocaina', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4726, N'Bofete', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4727, N'Boituva', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4728, N'Bom Jesus dos Perdões', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4729, N'Bom Sucesso de Itararé', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4730, N'Borá', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4731, N'Boracéia', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4732, N'Borborema', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4733, N'Borebi', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4734, N'Botucatu', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4735, N'Bragança Paulista', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4736, N'Braúna', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4737, N'Brejo Alegre', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4738, N'Brodowski', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4739, N'Brotas', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4740, N'Buri', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4741, N'Buritama', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4742, N'Buritizal', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4743, N'Cabrália Paulista', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4744, N'Cabreúva', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4745, N'Caçapava', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4746, N'Cachoeira Paulista', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4747, N'Caconde', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4748, N'Cafelândia', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4749, N'Caiabu', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4750, N'Caieiras', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4751, N'Caiuá', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4752, N'Cajamar', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4753, N'Cajati', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4754, N'Cajobi', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4755, N'Cajuru', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4756, N'Campina do Monte Alegre', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4757, N'Campinas', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4758, N'Campo Limpo Paulista', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4759, N'Campos do Jordão', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4760, N'Campos Novos Paulista', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4761, N'Cananéia', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4762, N'Canas', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4763, N'Cândido Mota', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4764, N'Cândido Rodrigues', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4765, N'Canitar', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4766, N'Capão Bonito', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4767, N'Capela do Alto', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4768, N'Capivari', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4769, N'Caraguatatuba', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4770, N'Carapicuíba', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4771, N'Cardoso', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4772, N'Casa Branca', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4773, N'Cássia dos Coqueiros', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4774, N'Castilho', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4775, N'Catanduva', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4776, N'Catiguá', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4777, N'Cedral', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4778, N'Cerqueira César', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4779, N'Cerquilho', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4780, N'Cesário Lange', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4781, N'Charqueada', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4782, N'Chavantes', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4783, N'Clementina', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4784, N'Colina', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4785, N'Colômbia', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4786, N'Conchal', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4787, N'Conchas', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4788, N'Cordeirópolis', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4789, N'Coroados', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4790, N'Coronel Macedo', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4791, N'Corumbataí', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4792, N'Cosmópolis', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4793, N'Cosmorama', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4794, N'Cotia', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4795, N'Cravinhos', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4796, N'Cristais Paulista', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4797, N'Cruzália', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4798, N'Cruzeiro', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4799, N'Cubatão', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4800, N'Cunha', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4801, N'Descalvado', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4802, N'Diadema', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4803, N'Dirce Reis', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4804, N'Divinolândia', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4805, N'Dobrada', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4806, N'Dois Córregos', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4807, N'Dolcinópolis', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4808, N'Dourado', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4809, N'Dracena', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4810, N'Duartina', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4811, N'Dumont', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4812, N'Echaporã', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4813, N'Eldorado', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4814, N'Elias Fausto', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4815, N'Elisiário', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4816, N'Embaúba', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4817, N'Embu', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4818, N'Embu-Guaçu', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4819, N'Emilianópolis', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4820, N'Engenheiro Coelho', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4821, N'Espírito Santo do Pinhal', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4822, N'Espírito Santo do Turvo', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4823, N'Estiva Gerbi', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4824, N'Estrela dOeste', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4825, N'Estrela do Norte', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4826, N'Euclides da Cunha Paulista', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4827, N'Fartura', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4828, N'Fernando Prestes', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4829, N'Fernandópolis', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4830, N'Fernão', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4831, N'Ferraz de Vasconcelos', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4832, N'Flora Rica', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4833, N'Floreal', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4834, N'Florínia', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4835, N'Flórida Paulista', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4836, N'Franca', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4837, N'Francisco Morato', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4838, N'Franco da Rocha', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4839, N'Gabriel Monteiro', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4840, N'Gália', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4841, N'Garça', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4842, N'Gastão Vidigal', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4843, N'Gavião Peixoto', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4844, N'General Salgado', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4845, N'Getulina', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4846, N'Glicério', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4847, N'Guaiçara', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4848, N'Guaimbê', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4849, N'Guaíra', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4850, N'Guapiaçu', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4851, N'Guapiara', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4852, N'Guará', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4853, N'Guaraçaí', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4854, N'Guaraci', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4855, N'Guarani dOeste', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4856, N'Guarantã', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4857, N'Guararapes', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4858, N'Guararema', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4859, N'Guaratinguetá', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4860, N'Guareí', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4861, N'Guariba', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4862, N'Guarujá', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4863, N'Guarulhos', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4864, N'Guatapará', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4865, N'Guzolândia', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4866, N'Herculândia', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4867, N'Holambra', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4868, N'Hortolândia', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4869, N'Iacanga', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4870, N'Iacri', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4871, N'Iaras', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4872, N'Ibaté', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4873, N'Ibirá', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4874, N'Ibirarema', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4875, N'Ibitinga', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4876, N'Ibiúna', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4877, N'Icém', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4878, N'Iepê', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4879, N'Igaraçu do Tietê', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4880, N'Igarapava', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4881, N'Igaratá', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4882, N'Iguape', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4883, N'Ilha Comprida', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4884, N'Ilha Solteira', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4885, N'Ilhabela', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4886, N'Indaiatuba', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4887, N'Indiana', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4888, N'Indiaporã', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4889, N'Inúbia Paulista', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4890, N'Ipauçu', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4891, N'Iperó', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4892, N'Ipeúna', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4893, N'Ipiguá', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4894, N'Iporanga', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4895, N'Ipuã', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4896, N'Iracemápolis', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4897, N'Irapuã', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4898, N'Irapuru', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4899, N'Itaberá', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4900, N'Itaí', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4901, N'Itajobi', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4902, N'Itaju', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4903, N'Itanhaém', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4904, N'Itaóca', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4905, N'Itapecerica da Serra', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4906, N'Itapetininga', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4907, N'Itapeva', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4908, N'Itapevi', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4909, N'Itapira', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4910, N'Itapirapuã Paulista', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4911, N'Itápolis', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4912, N'Itaporanga', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4913, N'Itapuí', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4914, N'Itapura', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4915, N'Itaquaquecetuba', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4916, N'Itararé', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4917, N'Itariri', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4918, N'Itatiba', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4919, N'Itatinga', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4920, N'Itirapina', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4921, N'Itirapuã', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4922, N'Itobi', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4923, N'Itu', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4924, N'Itupeva', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4925, N'Ituverava', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4926, N'Jaborandi', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4927, N'Jaboticabal', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4928, N'Jacareí', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4929, N'Jaci', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4930, N'Jacupiranga', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4931, N'Jaguariúna', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4932, N'Jales', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4933, N'Jambeiro', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4934, N'Jandira', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4935, N'Jardinópolis', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4936, N'Jarinu', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4937, N'Jaú', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4938, N'Jeriquara', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4939, N'Joanópolis', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4940, N'João Ramalho', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4941, N'José Bonifácio', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4942, N'Júlio Mesquita', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4943, N'Jumirim', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4944, N'Jundiaí', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4945, N'Junqueirópolis', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4946, N'Juquiá', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4947, N'Juquitiba', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4948, N'Lagoinha', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4949, N'Laranjal Paulista', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4950, N'Lavínia', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4951, N'Lavrinhas', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4952, N'Leme', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4953, N'Lençóis Paulista', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4954, N'Limeira', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4955, N'Lindóia', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4956, N'Lins', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4957, N'Lorena', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4958, N'Lourdes', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4959, N'Louveira', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4960, N'Lucélia', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4961, N'Lucianópolis', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4962, N'Luís Antônio', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4963, N'Luiziânia', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4964, N'Lupércio', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4965, N'Lutécia', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4966, N'Macatuba', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4967, N'Macaubal', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4968, N'Macedônia', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4969, N'Magda', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4970, N'Mairinque', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4971, N'Mairiporã', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4972, N'Manduri', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4973, N'Marabá Paulista', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4974, N'Maracaí', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4975, N'Marapoama', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4976, N'Mariápolis', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4977, N'Marília', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4978, N'Marinópolis', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4979, N'Martinópolis', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4980, N'Matão', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4981, N'Mauá', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4982, N'Mendonça', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4983, N'Meridiano', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4984, N'Mesópolis', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4985, N'Miguelópolis', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4986, N'Mineiros do Tietê', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4987, N'Mira Estrela', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4988, N'Miracatu', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4989, N'Mirandópolis', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4990, N'Mirante do Paranapanema', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4991, N'Mirassol', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4992, N'Mirassolândia', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4993, N'Mococa', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4994, N'Mogi das Cruzes', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4995, N'Mogi Guaçu', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4996, N'Mogi-Mirim', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4997, N'Mombuca', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4998, N'Monções', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (4999, N'Mongaguá', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5000, N'Monte Alegre do Sul', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5001, N'Monte Alto', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5002, N'Monte Aprazível', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5003, N'Monte Azul Paulista', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5004, N'Monte Castelo', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5005, N'Monte Mor', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5006, N'Monteiro Lobato', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5007, N'Morro Agudo', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5008, N'Morungaba', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5009, N'Motuca', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5010, N'Murutinga do Sul', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5011, N'Nantes', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5012, N'Narandiba', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5013, N'Natividade da Serra', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5014, N'Nazaré Paulista', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5015, N'Neves Paulista', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5016, N'Nhandeara', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5017, N'Nipoã', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5018, N'Nova Aliança', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5019, N'Nova Campina', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5020, N'Nova Canaã Paulista', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5021, N'Nova Castilho', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5022, N'Nova Europa', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5023, N'Nova Granada', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5024, N'Nova Guataporanga', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5025, N'Nova Independência', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5026, N'Nova Luzitânia', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5027, N'Nova Odessa', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5028, N'Novais', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5029, N'Novo Horizonte', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5030, N'Nuporanga', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5031, N'Ocauçu', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5032, N'Ã?leo', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5033, N'Olímpia', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5034, N'Onda Verde', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5035, N'Oriente', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5036, N'Orindiúva', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5037, N'Orlândia', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5038, N'Osasco', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5039, N'Oscar Bressane', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5040, N'Osvaldo Cruz', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5041, N'Ourinhos', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5042, N'Ouro Verde', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5043, N'Ouroeste', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5044, N'Pacaembu', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5045, N'Palestina', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5046, N'Palmares Paulista', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5047, N'Palmeira dOeste', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5048, N'Palmital', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5049, N'Panorama', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5050, N'Paraguaçu Paulista', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5051, N'Paraibuna', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5052, N'Paraíso', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5053, N'Paranapanema', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5054, N'Paranapuã', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5055, N'Parapuã', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5056, N'Pardinho', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5057, N'Pariquera-Açu', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5058, N'Parisi', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5059, N'Patrocínio Paulista', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5060, N'Paulicéia', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5061, N'Paulínia', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5062, N'Paulistânia', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5063, N'Paulo de Faria', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5064, N'Pederneiras', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5065, N'Pedra Bela', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5066, N'Pedranópolis', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5067, N'Pedregulho', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5068, N'Pedreira', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5069, N'Pedrinhas Paulista', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5070, N'Pedro de Toledo', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5071, N'Penápolis', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5072, N'Pereira Barreto', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5073, N'Pereiras', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5074, N'Peruíbe', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5075, N'Piacatu', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5076, N'Piedade', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5077, N'Pilar do Sul', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5078, N'Pindamonhangaba', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5079, N'Pindorama', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5080, N'Pinhalzinho', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5081, N'Piquerobi', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5082, N'Piquete', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5083, N'Piracaia', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5084, N'Piracicaba', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5085, N'Piraju', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5086, N'Pirajuí', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5087, N'Pirangi', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5088, N'Pirapora do Bom Jesus', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5089, N'Pirapozinho', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5090, N'Pirassununga', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5091, N'Piratininga', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5092, N'Pitangueiras', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5093, N'Planalto', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5094, N'Platina', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5095, N'Poá', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5096, N'Poloni', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5097, N'Pompéia', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5098, N'Pongaí', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5099, N'Pontal', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5100, N'Pontalinda', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5101, N'Pontes Gestal', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5102, N'Populina', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5103, N'Porangaba', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5104, N'Porto Feliz', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5105, N'Porto Ferreira', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5106, N'Potim', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5107, N'Potirendaba', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5108, N'Pracinha', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5109, N'Pradópolis', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5110, N'Praia Grande', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5111, N'Pratânia', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5112, N'Presidente Alves', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5113, N'Presidente Bernardes', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5114, N'Presidente Epitácio', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5115, N'Presidente Prudente', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5116, N'Presidente Venceslau', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5117, N'Promissão', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5118, N'Quadra', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5119, N'Quatá', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5120, N'Queiroz', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5121, N'Queluz', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5122, N'Quintana', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5123, N'Rafard', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5124, N'Rancharia', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5125, N'Redenção da Serra', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5126, N'Regente Feijó', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5127, N'Reginópolis', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5128, N'Registro', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5129, N'Restinga', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5130, N'Ribeira', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5131, N'Ribeirão Bonito', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5132, N'Ribeirão Branco', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5133, N'Ribeirão Corrente', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5134, N'Ribeirão do Sul', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5135, N'Ribeirão dos Índios', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5136, N'Ribeirão Grande', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5137, N'Ribeirão Pires', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5138, N'Ribeirão Preto', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5139, N'Rifaina', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5140, N'Rincão', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5141, N'Rinópolis', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5142, N'Rio Claro', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5143, N'Rio das Pedras', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5144, N'Rio Grande da Serra', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5145, N'Riolândia', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5146, N'Riversul', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5147, N'Rosana', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5148, N'Roseira', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5149, N'Rubiácea', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5150, N'Rubinéia', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5151, N'Sabino', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5152, N'Sagres', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5153, N'Sales', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5154, N'Sales Oliveira', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5155, N'Salesópolis', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5156, N'Salmourão', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5157, N'Saltinho', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5158, N'Salto', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5159, N'Salto de Pirapora', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5160, N'Salto Grande', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5161, N'Sandovalina', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5162, N'Santa Adélia', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5163, N'Santa Albertina', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5164, N'Santa Bárbara dOeste', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5165, N'Santa Branca', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5166, N'Santa Clara dOeste', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5167, N'Santa Cruz da Conceição', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5168, N'Santa Cruz da Esperança', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5169, N'Santa Cruz das Palmeiras', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5170, N'Santa Cruz do Rio Pardo', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5171, N'Santa Ernestina', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5172, N'Santa Fé do Sul', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5173, N'Santa Gertrudes', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5174, N'Santa Isabel', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5175, N'Santa Lúcia', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5176, N'Santa Maria da Serra', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5177, N'Santa Mercedes', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5178, N'Santa Rita dOeste', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5179, N'Santa Rita do Passa Quatro', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5180, N'Santa Rosa de Viterbo', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5181, N'Santa Salete', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5182, N'Santana da Ponte Pensa', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5183, N'Santana de Parnaíba', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5184, N'Santo Anastácio', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5185, N'Santo André', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5186, N'Santo Antônio da Alegria', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5187, N'Santo Antônio de Posse', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5188, N'Santo Antônio do Aracanguá', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5189, N'Santo Antônio do Jardim', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5190, N'Santo Antônio do Pinhal', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5191, N'Santo Expedito', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5192, N'Santópolis do Aguapeí', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5193, N'Santos', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5194, N'São Bento do Sapucaí', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5195, N'São Bernardo do Campo', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5196, N'São Caetano do Sul', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5197, N'São Carlos', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5198, N'São Francisco', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5199, N'São João da Boa Vista', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5200, N'São João das Duas Pontes', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5201, N'São João de Iracema', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5202, N'São João do Pau dAlho', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5203, N'São Joaquim da Barra', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5204, N'São José da Bela Vista', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5205, N'São José do Barreiro', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5206, N'São José do Rio Pardo', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5207, N'São José do Rio Preto', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5208, N'São José dos Campos', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5209, N'São Lourenço da Serra', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5210, N'São Luís do Paraitinga', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5211, N'São Manuel', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5212, N'São Miguel Arcanjo', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5213, N'São Paulo', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5214, N'São Pedro', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5215, N'São Pedro do Turvo', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5216, N'São Roque', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5217, N'São Sebastião', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5218, N'São Sebastião da Grama', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5219, N'São Simão', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5220, N'São Vicente', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5221, N'Sarapuí', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5222, N'Sarutaiá', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5223, N'Sebastianópolis do Sul', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5224, N'Serra Azul', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5225, N'Serra Negra', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5226, N'Serrana', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5227, N'Sertãozinho', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5228, N'Sete Barras', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5229, N'Severínia', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5230, N'Silveiras', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5231, N'Socorro', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5232, N'Sorocaba', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5233, N'Sud Mennucci', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5234, N'Sumaré', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5235, N'Suzanápolis', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5236, N'Suzano', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5237, N'Tabapuã', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5238, N'Tabatinga', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5239, N'Taboão da Serra', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5240, N'Taciba', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5241, N'Taguaí', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5242, N'Taiaçu', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5243, N'Taiúva', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5244, N'Tambaú', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5245, N'Tanabi', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5246, N'Tapiraí', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5247, N'Tapiratiba', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5248, N'Taquaral', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5249, N'Taquaritinga', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5250, N'Taquarituba', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5251, N'Taquarivaí', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5252, N'Tarabai', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5253, N'Tarumã', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5254, N'Tatuí', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5255, N'Taubaté', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5256, N'Tejupá', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5257, N'Teodoro Sampaio', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5258, N'Terra Roxa', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5259, N'Tietê', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5260, N'Timburi', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5261, N'Torre de Pedra', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5262, N'Torrinha', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5263, N'Trabiju', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5264, N'Tremembé', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5265, N'Três Fronteiras', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5266, N'Tuiuti', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5267, N'Tupã', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5268, N'Tupi Paulista', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5269, N'Turiúba', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5270, N'Turmalina', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5271, N'Ubarana', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5272, N'Ubatuba', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5273, N'Ubirajara', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5274, N'Uchoa', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5275, N'União Paulista', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5276, N'Urânia', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5277, N'Uru', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5278, N'Urupês', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5279, N'Valentim Gentil', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5280, N'Valinhos', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5281, N'Valparaíso', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5282, N'Vargem', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5283, N'Vargem Grande do Sul', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5284, N'Vargem Grande Paulista', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5285, N'Várzea Paulista', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5286, N'Vera Cruz', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5287, N'Vinhedo', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5288, N'Viradouro', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5289, N'Vista Alegre do Alto', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5290, N'Vitória Brasil', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5291, N'Votorantim', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5292, N'Votuporanga', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5293, N'Zacarias', 2);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5294, N'Amparo de São Francisco', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5295, N'Aquidabã', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5296, N'Aracaju', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5297, N'Arauá', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5298, N'Areia Branca', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5299, N'Barra dos Coqueiros', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5300, N'Boquim', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5301, N'Brejo Grande', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5302, N'Campo do Brito', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5303, N'Canhoba', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5304, N'Canindé de São Francisco', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5305, N'Capela', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5306, N'Carira', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5307, N'Carmópolis', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5308, N'Cedro de São João', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5309, N'Cristinápolis', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5310, N'Cumbe', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5311, N'Divina Pastora', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5312, N'Estância', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5313, N'Feira Nova', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5314, N'Frei Paulo', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5315, N'Gararu', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5316, N'General Maynard', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5317, N'Gracho Cardoso', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5318, N'Ilha das Flores', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5319, N'Indiaroba', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5320, N'Itabaiana', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5321, N'Itabaianinha', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5322, N'Itabi', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5323, N'Itaporanga dAjuda', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5324, N'Japaratuba', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5325, N'Japoatã', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5326, N'Lagarto', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5327, N'Laranjeiras', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5328, N'Macambira', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5329, N'Malhada dos Bois', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5330, N'Malhador', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5331, N'Maruim', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5332, N'Moita Bonita', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5333, N'Monte Alegre de Sergipe', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5334, N'Muribeca', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5335, N'Neópolis', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5336, N'Nossa Senhora Aparecida', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5337, N'Nossa Senhora da Glória', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5338, N'Nossa Senhora das Dores', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5339, N'Nossa Senhora de Lourdes', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5340, N'Nossa Senhora do Socorro', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5341, N'Pacatuba', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5342, N'Pedra Mole', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5343, N'Pedrinhas', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5344, N'Pinhão', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5345, N'Pirambu', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5346, N'Poço Redondo', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5347, N'Poço Verde', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5348, N'Porto da Folha', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5349, N'Propriá', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5350, N'Riachão do Dantas', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5351, N'Riachuelo', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5352, N'Ribeirópolis', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5353, N'Rosário do Catete', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5354, N'Salgado', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5355, N'Santa Luzia do Itanhy', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5356, N'Santa Rosa de Lima', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5357, N'Santana do São Francisco', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5358, N'Santo Amaro das Brotas', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5359, N'São Cristóvão', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5360, N'São Domingos', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5361, N'São Francisco', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5362, N'São Miguel do Aleixo', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5363, N'Simão Dias', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5364, N'Siriri', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5365, N'Telha', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5366, N'Tobias Barreto', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5367, N'Tomar do Geru', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5368, N'Umbaúba', 27);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5369, N'Abreulândia', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5370, N'Aguiarnópolis', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5371, N'Aliança do Tocantins', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5372, N'Almas', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5373, N'Alvorada', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5374, N'Ananás', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5375, N'Angico', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5376, N'Aparecida do Rio Negro', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5377, N'Aragominas', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5378, N'Araguacema', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5379, N'Araguaçu', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5380, N'Araguaína', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5381, N'Araguanã', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5382, N'Araguatins', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5383, N'Arapoema', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5384, N'Arraias', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5385, N'Augustinópolis', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5386, N'Aurora do Tocantins', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5387, N'Axixá do Tocantins', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5388, N'Babaçulândia', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5389, N'Bandeirantes do Tocantins', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5390, N'Barra do Ouro', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5391, N'Barrolândia', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5392, N'Bernardo Sayão', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5393, N'Bom Jesus do Tocantins', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5394, N'Brasilândia do Tocantins', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5395, N'Brejinho de Nazaré', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5396, N'Buriti do Tocantins', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5397, N'Cachoeirinha', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5398, N'Campos Lindos', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5399, N'Cariri do Tocantins', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5400, N'Carmolândia', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5401, N'Carrasco Bonito', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5402, N'Caseara', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5403, N'Centenário', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5404, N'Chapada da Natividade', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5405, N'Chapada de Areia', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5406, N'Colinas do Tocantins', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5407, N'Colméia', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5408, N'Combinado', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5409, N'Conceição do Tocantins', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5410, N'Couto de Magalhães', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5411, N'Cristalândia', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5412, N'Crixás do Tocantins', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5413, N'Darcinópolis', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5414, N'Dianópolis', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5415, N'Divinópolis do Tocantins', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5416, N'Dois Irmãos do Tocantins', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5417, N'Dueré', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5418, N'Esperantina', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5419, N'Fátima', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5420, N'Figueirópolis', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5421, N'Filadélfia', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5422, N'Formoso do Araguaia', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5423, N'Fortaleza do Tabocão', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5424, N'Goianorte', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5425, N'Goiatins', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5426, N'Guaraí', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5427, N'Gurupi', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5428, N'Ipueiras', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5429, N'Itacajá', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5430, N'Itaguatins', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5431, N'Itapiratins', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5432, N'Itaporã do Tocantins', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5433, N'Jaú do Tocantins', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5434, N'Juarina', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5435, N'Lagoa da Confusão', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5436, N'Lagoa do Tocantins', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5437, N'Lajeado', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5438, N'Lavandeira', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5439, N'Lizarda', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5440, N'Luzinópolis', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5441, N'Marianópolis do Tocantins', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5442, N'Mateiros', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5443, N'Maurilândia do Tocantins', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5444, N'Miracema do Tocantins', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5445, N'Miranorte', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5446, N'Monte do Carmo', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5447, N'Monte Santo do Tocantins', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5448, N'Muricilândia', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5449, N'Natividade', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5450, N'Nazaré', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5451, N'Nova Olinda', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5452, N'Nova Rosalândia', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5453, N'Novo Acordo', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5454, N'Novo Alegre', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5455, N'Novo Jardim', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5456, N'Oliveira de Fátima', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5457, N'Palmas', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5458, N'Palmeirante', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5459, N'Palmeiras do Tocantins', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5460, N'Palmeirópolis', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5461, N'Paraíso do Tocantins', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5462, N'Paranã', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5463, N'Pau dArco', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5464, N'Pedro Afonso', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5465, N'Peixe', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5466, N'Pequizeiro', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5467, N'Pindorama do Tocantins', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5468, N'Piraquê', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5469, N'Pium', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5470, N'Ponte Alta do Bom Jesus', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5471, N'Ponte Alta do Tocantins', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5472, N'Porto Alegre do Tocantins', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5473, N'Porto Nacional', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5474, N'Praia Norte', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5475, N'Presidente Kennedy', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5476, N'Pugmil', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5477, N'Recursolândia', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5478, N'Riachinho', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5479, N'Rio da Conceição', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5480, N'Rio dos Bois', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5481, N'Rio Sono', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5482, N'Sampaio', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5483, N'Sandolândia', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5484, N'Santa Fé do Araguaia', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5485, N'Santa Maria do Tocantins', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5486, N'Santa Rita do Tocantins', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5487, N'Santa Rosa do Tocantins', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5488, N'Santa Tereza do Tocantins', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5489, N'Santa Terezinha do Tocantins', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5490, N'São Bento do Tocantins', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5491, N'São Félix do Tocantins', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5492, N'São Miguel do Tocantins', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5493, N'São Salvador do Tocantins', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5494, N'São Sebastião do Tocantins', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5495, N'São Valério da Natividade', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5496, N'Silvanópolis', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5497, N'Sítio Novo do Tocantins', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5498, N'Sucupira', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5499, N'Taguatinga', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5500, N'Taipas do Tocantins', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5501, N'Talismã', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5502, N'Tocantínia', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5503, N'Tocantinópolis', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5504, N'Tupirama', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5505, N'Tupiratins', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5506, N'Wanderlândia', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5507, N'Xambioá', 5);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5508, N'Brazlandia', 1);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5509, N'Candangolandia', 1);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5510, N'Ceilandia', 1);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5511, N'Cruzeiro', 1);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5512, N'Gama', 1);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5513, N'Guara', 1);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5514, N'Lago Norte', 1);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5515, N'Lago Sul', 1);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5516, N'Nucleo Bandeirante', 1);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5517, N'Paranoa', 1);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5518, N'Planaltina', 1);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5519, N'Recanto das Emas', 1);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5520, N'Riacho Fundo', 1);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5521, N'Samambaia', 1);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5522, N'Santa Maria', 1);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5523, N'Sao Sebastiao', 1);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5524, N'Sobradinho', 1);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5525, N'Taguatinga', 1);
INSERT [cidades] ([idcidade], [nomecidade], [iduf]) VALUES (5526, N'Abadia de Goiás', 4);

CREATE TABLE [centroresultado](
	[idcentroresultado] [int] NOT NULL,
	[codigocentroresultado] [varchar](25) NOT NULL,
	[nomecentroresultado] [varchar](200) NOT NULL,
	[idcentroresultadopai] [int] NULL,
	[permiterequisicaoproduto] [char](1) NULL,
	[situacao] [char](1) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idcentroresultado] ASC
)
) ON [PRIMARY];

CREATE TABLE [causaincidente](
	[idcausaincidente] [int] NOT NULL,
	[idcausaincidentepai] [int] NULL,
	[descricaocausa] [varchar](100) NOT NULL,
	[datainicio] [date] NOT NULL,
	[datafim] [date] NULL,
	[deleted] [char](1) NULL,
PRIMARY KEY CLUSTERED 
(
	[idcausaincidente] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_56] ON [causaincidente] 
(
	[idcausaincidentepai] ASC
)ON [PRIMARY];

INSERT [causaincidente] ([idcausaincidente], [idcausaincidentepai], [descricaocausa], [datainicio], [datafim], [deleted]) VALUES (1, NULL, N'Software', CAST(0x26350B00 AS Date), NULL, NULL);
INSERT [causaincidente] ([idcausaincidente], [idcausaincidentepai], [descricaocausa], [datainicio], [datafim], [deleted]) VALUES (2, 1, N'Instalação ineficaz', CAST(0x26350B00 AS Date), NULL, NULL);
INSERT [causaincidente] ([idcausaincidente], [idcausaincidentepai], [descricaocausa], [datainicio], [datafim], [deleted]) VALUES (3, 1, N'Configuração', CAST(0x26350B00 AS Date), NULL, NULL);
INSERT [causaincidente] ([idcausaincidente], [idcausaincidentepai], [descricaocausa], [datainicio], [datafim], [deleted]) VALUES (4, 1, N'Falta de Treinamento', CAST(0x26350B00 AS Date), NULL, NULL);
INSERT [causaincidente] ([idcausaincidente], [idcausaincidentepai], [descricaocausa], [datainicio], [datafim], [deleted]) VALUES (5, NULL, N'Hardware', CAST(0x26350B00 AS Date), NULL, NULL);
INSERT [causaincidente] ([idcausaincidente], [idcausaincidentepai], [descricaocausa], [datainicio], [datafim], [deleted]) VALUES (6, 5, N'Defeito', CAST(0x26350B00 AS Date), NULL, NULL);
INSERT [causaincidente] ([idcausaincidente], [idcausaincidentepai], [descricaocausa], [datainicio], [datafim], [deleted]) VALUES (7, 5, N'Configuração', CAST(0x26350B00 AS Date), NULL, NULL);
INSERT [causaincidente] ([idcausaincidente], [idcausaincidentepai], [descricaocausa], [datainicio], [datafim], [deleted]) VALUES (8, 5, N'Uso Indevido', CAST(0x26350B00 AS Date), NULL, NULL);
INSERT [causaincidente] ([idcausaincidente], [idcausaincidentepai], [descricaocausa], [datainicio], [datafim], [deleted]) VALUES (9, 5, N'Outros', CAST(0x26350B00 AS Date), NULL, N'n');
INSERT [causaincidente] ([idcausaincidente], [idcausaincidentepai], [descricaocausa], [datainicio], [datafim], [deleted]) VALUES (10, 1, N'Erro no aplicativo', CAST(0x26350B00 AS Date), NULL, NULL);
INSERT [causaincidente] ([idcausaincidente], [idcausaincidentepai], [descricaocausa], [datainicio], [datafim], [deleted]) VALUES (11, 1, N'Lentidão', CAST(0x26350B00 AS Date), NULL, NULL);
INSERT [causaincidente] ([idcausaincidente], [idcausaincidentepai], [descricaocausa], [datainicio], [datafim], [deleted]) VALUES (12, 1, N'Erro na configuração', CAST(0x26350B00 AS Date), NULL, NULL);
INSERT [causaincidente] ([idcausaincidente], [idcausaincidentepai], [descricaocausa], [datainicio], [datafim], [deleted]) VALUES (13, 5, N'Erro na configuração', CAST(0x26350B00 AS Date), NULL, N'y');
INSERT [causaincidente] ([idcausaincidente], [idcausaincidentepai], [descricaocausa], [datainicio], [datafim], [deleted]) VALUES (14, 9, N'Mudança não planejada', CAST(0x26350B00 AS Date), NULL, NULL);

CREATE TABLE [categoriasolucao](
	[idcategoriasolucao] [int] NOT NULL,
	[idcategoriasolucaopai] [int] NULL,
	[descricaocategoriasolucao] [varchar](100) NOT NULL,
	[datainicio] [date] NOT NULL,
	[datafim] [date] NULL,
	[deleted] [char](1) NULL,
PRIMARY KEY CLUSTERED 
(
	[idcategoriasolucao] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_57] ON [categoriasolucao] 
(
	[idcategoriasolucaopai] ASC
)ON [PRIMARY];

INSERT [categoriasolucao] ([idcategoriasolucao], [idcategoriasolucaopai], [descricaocategoriasolucao], [datainicio], [datafim], [deleted]) VALUES (1, NULL, N'Software', CAST(0x26350B00 AS Date), NULL, N'n');
INSERT [categoriasolucao] ([idcategoriasolucao], [idcategoriasolucaopai], [descricaocategoriasolucao], [datainicio], [datafim], [deleted]) VALUES (2, 1, N'Ajuste de configuração de software', CAST(0x26350B00 AS Date), NULL, N'n');
INSERT [categoriasolucao] ([idcategoriasolucao], [idcategoriasolucaopai], [descricaocategoriasolucao], [datainicio], [datafim], [deleted]) VALUES (3, 1, N'Nova Instalação', CAST(0x26350B00 AS Date), NULL, NULL);
INSERT [categoriasolucao] ([idcategoriasolucao], [idcategoriasolucaopai], [descricaocategoriasolucao], [datainicio], [datafim], [deleted]) VALUES (4, 1, N'Remoção de arquivos temporários', CAST(0x26350B00 AS Date), NULL, N'n');
INSERT [categoriasolucao] ([idcategoriasolucao], [idcategoriasolucaopai], [descricaocategoriasolucao], [datainicio], [datafim], [deleted]) VALUES (5, 1, N'Ajuste no sistema operacional', CAST(0x26350B00 AS Date), NULL, N'n');
INSERT [categoriasolucao] ([idcategoriasolucao], [idcategoriasolucaopai], [descricaocategoriasolucao], [datainicio], [datafim], [deleted]) VALUES (6, NULL, N'Hardware', CAST(0x26350B00 AS Date), NULL, N'y');
INSERT [categoriasolucao] ([idcategoriasolucao], [idcategoriasolucaopai], [descricaocategoriasolucao], [datainicio], [datafim], [deleted]) VALUES (7, 6, N'Reparo no hardware', CAST(0x26350B00 AS Date), NULL, N'n');
INSERT [categoriasolucao] ([idcategoriasolucao], [idcategoriasolucaopai], [descricaocategoriasolucao], [datainicio], [datafim], [deleted]) VALUES (8, 6, N'Substituição de hardware', CAST(0x26350B00 AS Date), NULL, N'n');
INSERT [categoriasolucao] ([idcategoriasolucao], [idcategoriasolucaopai], [descricaocategoriasolucao], [datainicio], [datafim], [deleted]) VALUES (9, 6, N'Manutenção preventiva', CAST(0x26350B00 AS Date), NULL, N'n');
INSERT [categoriasolucao] ([idcategoriasolucao], [idcategoriasolucaopai], [descricaocategoriasolucao], [datainicio], [datafim], [deleted]) VALUES (10, NULL, N'Ajuste na configuração do aplicativo', CAST(0x26350B00 AS Date), NULL, NULL);
INSERT [categoriasolucao] ([idcategoriasolucao], [idcategoriasolucaopai], [descricaocategoriasolucao], [datainicio], [datafim], [deleted]) VALUES (11, NULL, N'Ajustes nas configurações do sistema', CAST(0x26350B00 AS Date), NULL, NULL);
INSERT [categoriasolucao] ([idcategoriasolucao], [idcategoriasolucaopai], [descricaocategoriasolucao], [datainicio], [datafim], [deleted]) VALUES (12, NULL, N'Atualização no sistema operacional', CAST(0x26350B00 AS Date), NULL, NULL);
INSERT [categoriasolucao] ([idcategoriasolucao], [idcategoriasolucaopai], [descricaocategoriasolucao], [datainicio], [datafim], [deleted]) VALUES (13, NULL, N'Aplicação de service pack', CAST(0x26350B00 AS Date), NULL, NULL);
INSERT [categoriasolucao] ([idcategoriasolucao], [idcategoriasolucaopai], [descricaocategoriasolucao], [datainicio], [datafim], [deleted]) VALUES (14, NULL, N'Ajuste na configuração do browser', CAST(0x26350B00 AS Date), NULL, NULL);
INSERT [categoriasolucao] ([idcategoriasolucao], [idcategoriasolucaopai], [descricaocategoriasolucao], [datainicio], [datafim], [deleted]) VALUES (15, NULL, N'Novas parametrizações', CAST(0x26350B00 AS Date), NULL, NULL);
INSERT [categoriasolucao] ([idcategoriasolucao], [idcategoriasolucaopai], [descricaocategoriasolucao], [datainicio], [datafim], [deleted]) VALUES (16, NULL, N'Reconfiguração de parâmetros de rede', CAST(0x26350B00 AS Date), NULL, NULL);
INSERT [categoriasolucao] ([idcategoriasolucao], [idcategoriasolucaopai], [descricaocategoriasolucao], [datainicio], [datafim], [deleted]) VALUES (17, NULL, N'Liberação de regras no firewall', CAST(0x26350B00 AS Date), NULL, NULL);
INSERT [categoriasolucao] ([idcategoriasolucao], [idcategoriasolucaopai], [descricaocategoriasolucao], [datainicio], [datafim], [deleted]) VALUES (18, NULL, N'Alteração de regras no firewall', CAST(0x26350B00 AS Date), NULL, NULL);
INSERT [categoriasolucao] ([idcategoriasolucao], [idcategoriasolucaopai], [descricaocategoriasolucao], [datainicio], [datafim], [deleted]) VALUES (19, NULL, N'Exclusão de regras no firewall', CAST(0x26350B00 AS Date), NULL, NULL);
INSERT [categoriasolucao] ([idcategoriasolucao], [idcategoriasolucaopai], [descricaocategoriasolucao], [datainicio], [datafim], [deleted]) VALUES (20, NULL, N'Liberação de página no proxy', CAST(0x26350B00 AS Date), NULL, NULL);
INSERT [categoriasolucao] ([idcategoriasolucao], [idcategoriasolucaopai], [descricaocategoriasolucao], [datainicio], [datafim], [deleted]) VALUES (21, NULL, N'Criação de usuários', CAST(0x26350B00 AS Date), NULL, NULL);
INSERT [categoriasolucao] ([idcategoriasolucao], [idcategoriasolucaopai], [descricaocategoriasolucao], [datainicio], [datafim], [deleted]) VALUES (22, NULL, N'Mudança de perfil', CAST(0x26350B00 AS Date), NULL, NULL);
INSERT [categoriasolucao] ([idcategoriasolucao], [idcategoriasolucaopai], [descricaocategoriasolucao], [datainicio], [datafim], [deleted]) VALUES (23, NULL, N'Backup e Restore', CAST(0x26350B00 AS Date), NULL, NULL);
INSERT [categoriasolucao] ([idcategoriasolucao], [idcategoriasolucaopai], [descricaocategoriasolucao], [datainicio], [datafim], [deleted]) VALUES (24, NULL, N'Software', CAST(0x26350B00 AS Date), NULL, N'y');

CREATE TABLE [categoriaservico](
	[idcategoriaservico] [int] NOT NULL,
	[idcategoriaservicopai] [int] NULL,
	[idempresa] [int] NOT NULL,
	[nomecategoriaservico] [varchar](100) NOT NULL,
	[datainicio] [date] NULL,
	[datafim] [date] NULL,
	[nomeCategoriaServicoConcatenado] [varchar](1024) NULL,
	[nomeCatServicoConcatenado] [varchar](520) NULL,
PRIMARY KEY CLUSTERED 
(
	[idcategoriaservico] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_CATERIASERVICOPAI] ON [categoriaservico] 
(
	[idcategoriaservicopai] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_CATEMPRESA] ON [categoriaservico] 
(
	[idempresa] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [index_nomecateg] ON [categoriaservico] 
(
	[nomeCategoriaServicoConcatenado] ASC
)ON [PRIMARY];

INSERT [categoriaservico] ([idcategoriaservico], [idcategoriaservicopai], [idempresa], [nomecategoriaservico], [datainicio], [datafim], [nomeCategoriaServicoConcatenado], [nomeCatServicoConcatenado]) VALUES (1, NULL, 1, N'Categoria de Serviço 1', CAST(0xEF360B00 AS Date), NULL, N'Categoria de Serviço 1', NULL);

CREATE TABLE [categoriaquestionario](
	[idcategoriaquestionario] [int] NOT NULL,
	[nomecategoriaquestionario] [varchar](50) NOT NULL,
	[idempresa] [int] NOT NULL,
	[compartilhada] [char](1) NULL,
PRIMARY KEY CLUSTERED 
(
	[idcategoriaquestionario] ASC
)
) ON [PRIMARY];

INSERT [categoriaquestionario] ([idcategoriaquestionario], [nomecategoriaquestionario], [idempresa], [compartilhada]) VALUES (1, N'CONTRATOS', 1, N'N');

CREATE TABLE [categoriaproduto](
	[idcategoria] [int] NOT NULL,
	[idcategoriapai] [int] NULL,
	[nomecategoria] [varchar](100) NOT NULL,
	[situacao] [char](1) NOT NULL,
	[pesocotacaopreco] [int] NULL,
	[pesocotacaoprazoentrega] [int] NULL,
	[pesocotacaoprazopagto] [int] NULL,
	[pesocotacaotaxajuros] [int] NULL,
	[pesocotacaoprazogarantia] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[idcategoria] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_670] ON [categoriaproduto] 
(
	[idcategoriapai] ASC
)ON [PRIMARY];

CREATE TABLE [contratos_hist](
	[idcontrato_hist] [int] NOT NULL,
	[idcontrato] [int] NOT NULL,
	[idcliente] [int] NOT NULL,
	[idmoeda] [int] NULL,
	[idfornecedor] [bigint] NOT NULL,
	[numero] [varchar](30) NOT NULL,
	[objeto] [text] NOT NULL,
	[datacontrato] [date] NOT NULL,
	[valorestimado] [decimal](18, 3) NULL,
	[tipotempoestimado] [char](1) NULL,
	[tempoestimado] [int] NULL,
	[tipo] [char](1) NOT NULL,
	[situacao] [char](1) NOT NULL,
	[cotacaomoeda] [decimal](18, 3) NULL,
	[cadastromanualusuario] [char](1) NULL,
	[deleted] [char](1) NULL,
	[idgruposolicitante] [int] NULL,
	[datafimcontrato] [date] NULL,
	[criadoem] [datetime] NOT NULL,
	[criadopor] [varchar](256) NULL,
	[modificadoem] [datetime] NOT NULL,
	[modificadopor] [varchar](256) NULL,
	[conteudodados] [text] NULL,
PRIMARY KEY CLUSTERED 
(
	[idcontrato_hist] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_26_2] ON [contratos_hist] 
(
	[idmoeda] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_3_2] ON [contratos_hist] 
(
	[idcliente] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_60_2] ON [contratos_hist] 
(
	[idfornecedor] ASC
)ON [PRIMARY];

INSERT [contratos_hist] ([idcontrato_hist], [idcontrato], [idcliente], [idmoeda], [idfornecedor], [numero], [objeto], [datacontrato], [valorestimado], [tipotempoestimado], [tempoestimado], [tipo], [situacao], [cotacaomoeda], [cadastromanualusuario], [deleted], [idgruposolicitante], [datafimcontrato], [criadoem], [criadopor], [modificadoem], [modificadopor], [conteudodados]) VALUES (1, 1, 1, 1, 1, N'1', N'Descrição do Contrato', CAST(0xEE360B00 AS Date), CAST(1000000.000 AS Decimal(18, 3)), NULL, NULL, N'C', N'A', CAST(1.000 AS Decimal(18, 3)), NULL, NULL, 2, CAST(0x6D390B00 AS Date), CAST('2013-04-05 13:40:00' AS datetime), N'Administrador', CAST('2013-04-05 13:40:00' AS datetime), N'Administrador', N'JSONDATA: TRUE\nTIPO: C\nNUMERO: 1\nNOCACHE: Tue Apr 02 2013 13:26:45 GMT-0300 (Hora oficial do Brasil)\nIDFORNECEDOR: 1\nKEYCONTROL: \nDINAMICVIEWSJSON_TEMPDATA: \nVALORESTIMADO: 1.000.000,00\nIDCLIENTE: 1\nCADASTROMANUALUSUARIO: N\nCOTACAOMOEDA: 1,00\nIDCONTRATO: 1\nDINAMICVIEWSTABLESVINC: \"TABLE_SEARCH_28\",\"TABLE_SEARCH_64\"\nDINAMICVIEWSACAOPESQUISASELECIONADA: \nDATAFIMCONTRATO: 31/12/2014\nOBJETO: Descrição do Contrato\nIDMOEDA: 1\nDATACONTRATO: 01/04/2013\nACAOFLUXO: \nMODOEXIBICAO: N\nIDGRUPOSOLICITANTE: 2\nSESSION.NUMERO_CONTRATO_EDICAO: null\nDINAMICVIEWSIDVISAOPESQUISASELECIONADA: \nDINAMICVIEWSJSON_DATA: \nIDFLUXO: \nJSONMATRIZ: \nDINAMICVIEWSIDVISAO: 20\nSESSION.DINAMICVIEWS_SAVEINFO: null\nIDTAREFA: \nSITUACAO: A\nDINAMICVIEWSDADOSADICIONAIS: {}\n');

CREATE TABLE [contratos](
	[idcontrato] [int] NOT NULL,
	[idcliente] [int] NOT NULL,
	[idmoeda] [int] NULL,
	[idfornecedor] [bigint] NOT NULL,
	[numero] [varchar](30) NOT NULL,
	[objeto] [text] NOT NULL,
	[datacontrato] [date] NOT NULL,
	[valorestimado] [decimal](18, 3) NULL,
	[tipotempoestimado] [char](1) NULL,
	[tempoestimado] [int] NULL,
	[tipo] [char](1) NOT NULL,
	[situacao] [char](1) NOT NULL,
	[cotacaomoeda] [decimal](18, 3) NULL,
	[cadastromanualusuario] [char](1) NULL,
	[deleted] [char](1) NULL,
	[idgruposolicitante] [int] NULL,
	[datafimcontrato] [date] NULL,
PRIMARY KEY CLUSTERED 
(
	[idcontrato] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_26] ON [contratos] 
(
	[idmoeda] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_3] ON [contratos] 
(
	[idcliente] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_60] ON [contratos] 
(
	[idfornecedor] ASC
)ON [PRIMARY];

INSERT [contratos] ([idcontrato], [idcliente], [idmoeda], [idfornecedor], [numero], [objeto], [datacontrato], [valorestimado], [tipotempoestimado], [tempoestimado], [tipo], [situacao], [cotacaomoeda], [cadastromanualusuario], [deleted], [idgruposolicitante], [datafimcontrato]) VALUES (1, 1, 1, 1, N'1', N'Descrição do Contrato', CAST(0xEE360B00 AS Date), CAST(1000000.000 AS Decimal(18, 3)), NULL, NULL, N'C', N'A', CAST(1.000 AS Decimal(18, 3)), N'N', NULL, 2, CAST(0x6D390B00 AS Date));

CREATE TABLE [contratoquestionarios](
	[idcontratoquestionario] [int] NOT NULL,
	[idquestionario] [int] NOT NULL,
	[idcontrato] [int] NOT NULL,
	[dataquestionario] [date] NOT NULL,
	[idprofissional] [int] NULL,
	[idempresa] [int] NULL,
	[aba] [varchar](30) NULL,
	[situacao] [char](1) NULL,
	[situacaocomplemento] [char](1) NULL,
	[datahoragrav] [date] NULL,
	[migrado] [char](1) NULL,
	[conteudoimpresso] [text] NULL,
	[idmigracao] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[idcontratoquestionario] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_CONTRATOCONTRATO] ON [contratoquestionarios] 
(
	[idcontrato] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_CONTRATOEMPRESA] ON [contratoquestionarios] 
(
	[idempresa] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_CONTRATOMIGRACAO] ON [contratoquestionarios] 
(
	[idmigracao] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_CONTRATOPROFISSIONAL] ON [contratoquestionarios] 
(
	[idprofissional] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_CONTRATOQUESTIONARIO] ON [contratoquestionarios] 
(
	[idquestionario] ASC
)ON [PRIMARY];

CREATE TABLE [contatosolicitacaoservico](
	[idcontatosolicitacaoservico] [int] NOT NULL,
	[nomecontato] [varchar](70) NOT NULL,
	[telefonecontato] [varchar](70) NULL,
	[emailcontato] [varchar](120) NOT NULL,
	[localizacaofisica] [text] NULL,
	[idlocalidade] [int] NULL,
	[ramal] [varchar](5) NULL,
PRIMARY KEY CLUSTERED 
(
	[idcontatosolicitacaoservico] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_622] ON [contatosolicitacaoservico] 
(
	[idlocalidade] ASC
)ON [PRIMARY];

INSERT [contatosolicitacaoservico] ([idcontatosolicitacaoservico], [nomecontato], [telefonecontato], [emailcontato], [localizacaofisica], [idlocalidade], [ramal]) VALUES (1, N'Default', N'3242-4433', N'citsmart_instalador_mysql@centralit.com.br', N'', NULL, NULL);
INSERT [contatosolicitacaoservico] ([idcontatosolicitacaoservico], [nomecontato], [telefonecontato], [emailcontato], [localizacaofisica], [idlocalidade], [ramal]) VALUES (2, N'Default', N'3242-4433', N'citsmart_instalador_mysql@centralit.com.br', N'', NULL, NULL);
INSERT [contatosolicitacaoservico] ([idcontatosolicitacaoservico], [nomecontato], [telefonecontato], [emailcontato], [localizacaofisica], [idlocalidade], [ramal]) VALUES (3, N'Consultor', N'3242-4433', N'citsmart_instalador_mysql@centralit.com.br', N'', NULL, NULL);
INSERT [contatosolicitacaoservico] ([idcontatosolicitacaoservico], [nomecontato], [telefonecontato], [emailcontato], [localizacaofisica], [idlocalidade], [ramal]) VALUES (4, N'Consultor', N'3242-4433', N'citsmart_instalador_mysql@centralit.com.br', N'', NULL, NULL);

CREATE TABLE [contatorequisicaomudanca](
	[idcontatorequisicaomudanca] [int] NOT NULL,
	[nomecontato] [varchar](100) NULL,
	[telefonecontato] [varchar](100) NULL,
	[emailcontato] [varchar](200) NULL,
	[observacao] [text] NULL,
	[idlocalidade] [int] NULL,
	[ramal] [varchar](5) NULL,
PRIMARY KEY CLUSTERED 
(
	[idcontatorequisicaomudanca] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE TABLE [contatorequisicaoliberacao](
	[idcontatorequisicaoliberacao] [int] NOT NULL,
	[nomecontato] [varchar](70) NULL,
	[telefonecontato] [varchar](20) NULL,
	[emailcontato] [varchar](120) NULL,
	[observacao] [text] NULL,
	[idlocalidade] [int] NULL,
	[ramal] [varchar](4) NULL,
	[idunidade] [int] NULL,
 CONSTRAINT [contatorequisicaoliberacao_pkey] PRIMARY KEY CLUSTERED 
(
	[idcontatorequisicaoliberacao] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE TABLE [contatocliente](
	[idcontatocliente] [int] NOT NULL,
	[idcliente] [int] NOT NULL,
	[nome] [varchar](80) NOT NULL,
	[telefones] [varchar](100) NULL,
	[email] [varchar](255) NULL,
	[departamento] [varchar](100) NULL,
	[observacoes] [text] NULL,
	[datainicio] [date] NULL,
	[datafim] [date] NULL,
PRIMARY KEY CLUSTERED 
(
	[idcontatocliente] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_CONTATOCLIENTE] ON [contatocliente] 
(
	[idcliente] ASC
)ON [PRIMARY];

CREATE TABLE [controlequestionarios](
	[idcontrolequestionario] [int] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idcontrolequestionario] ASC
)
) ON [PRIMARY];

CREATE TABLE [demandas](
	[iddemanda] [int] NOT NULL,
	[idcontrato] [int] NULL,
	[idsituacaodemanda] [int] NOT NULL,
	[idtipodemanda] [int] NOT NULL,
	[idprojeto] [int] NULL,
	[iddemandapai] [int] NULL,
	[idfluxo] [int] NOT NULL,
	[previsaoinicio] [date] NULL,
	[datainicio] [date] NULL,
	[previsaofim] [date] NULL,
	[datafim] [date] NULL,
	[detalhamento] [text] NULL,
	[prioridade] [char](1) NOT NULL,
	[expectativafim] [date] NULL,
	[datacadastro] [date] NULL,
	[complexidade] [int] NULL,
	[custototal] [decimal](18, 3) NULL,
	[observacao] [text] NULL,
	[idos] [int] NULL,
	[glosa] [decimal](15, 3) NULL,
PRIMARY KEY CLUSTERED 
(
	[iddemanda] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_DEMANDACONTRATO] ON [demandas] 
(
	[idcontrato] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_DEMANDADEMANDAPAI] ON [demandas] 
(
	[iddemandapai] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_DEMANDAFLUXO] ON [demandas] 
(
	[idfluxo] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_DEMANDAPROJETO] ON [demandas] 
(
	[idprojeto] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_DEMANDASITUACAODEMANDA] ON [demandas] 
(
	[idsituacaodemanda] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_DEMANDATIPODEMANDA] ON [demandas] 
(
	[idtipodemanda] ASC
)ON [PRIMARY];

CREATE TABLE [criterioitemcotacao](
	[iditemcotacao] [int] NOT NULL,
	[idcriterio] [int] NOT NULL,
	[peso] [int] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idcriterio] ASC,
	[iditemcotacao] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_724] ON [criterioitemcotacao] 
(
	[iditemcotacao] ASC
)ON [PRIMARY];

CREATE TABLE [controleged](
	[idcontroleged] [int] NOT NULL,
	[idtabela] [smallint] NOT NULL,
	[id] [int] NOT NULL,
	[nomearquivo] [varchar](255) NOT NULL,
	[descricaoarquivo] [varchar](255) NULL,
	[extensaoarquivo] [varchar](5) NULL,
	[datahora] [datetime] NOT NULL,
	[pasta] [varchar](255) NULL,
	[conteudoarquivo] [varbinary](max) NULL,
PRIMARY KEY CLUSTERED 
(
	[idcontroleged] ASC
)
) ON [PRIMARY];

CREATE TABLE [contratosunidades](
	[idunidade] [int] NOT NULL,
	[idcontrato] [int] NOT NULL,
	[contratosunidadescol] [varchar](45) NULL,
PRIMARY KEY CLUSTERED 
(
	[idunidade] ASC,
	[idcontrato] ASC
)
) ON [PRIMARY];

CREATE TABLE [contratosgrupos](
	[idgrupo] [int] NOT NULL,
	[idcontrato] [int] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idgrupo] ASC,
	[idcontrato] ASC
)
) ON [PRIMARY];

INSERT [contratosgrupos] ([idgrupo], [idcontrato]) VALUES (2, 1);
INSERT [contratosgrupos] ([idgrupo], [idcontrato]) VALUES (3, 1);
INSERT [contratosgrupos] ([idgrupo], [idcontrato]) VALUES (4, 1);
INSERT [contratosgrupos] ([idgrupo], [idcontrato]) VALUES (16, 1);
INSERT [contratosgrupos] ([idgrupo], [idcontrato]) VALUES (17, 1);
INSERT [contratosgrupos] ([idgrupo], [idcontrato]) VALUES (19, 1);

CREATE TABLE [contratoscolaboradores](
	[idempregado] [int] NOT NULL,
	[idcontrato] [int] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idempregado] ASC,
	[idcontrato] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_569] ON [contratoscolaboradores] 
(
	[idcontrato] ASC
)ON [PRIMARY];

CREATE TABLE [tabfederacaodados](
	[nometabela] [varchar](255) NOT NULL,
	[chavefinal] [varchar](255) NOT NULL,
	[chaveoriginal] [varchar](255) NOT NULL,
	[origem] [varchar](255) NOT NULL,
	[criacao] [datetime] NOT NULL,
	[ultatualiz] [datetime] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[nometabela] ASC,
	[chavefinal] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [ix_tab_orig_chvorig] ON [tabfederacaodados] 
(
	[origem] ASC,
	[nometabela] ASC,
	[chaveoriginal] ASC
)ON [PRIMARY];

CREATE TABLE [solicitacaoservicoproblema](
	[idproblema] [int] NULL,
	[idsolicitacaoservico] [int] NULL
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_solicita_reference_solicita] ON [solicitacaoservicoproblema] 
(
	[idsolicitacaoservico] ASC
)ON [PRIMARY];

CREATE TABLE [timers](
	[TIMERID] [varchar](80) NOT NULL,
	[TARGETID] [varchar](250) NOT NULL,
	[INITIALDATE] [datetime] NOT NULL,
	[TIMERINTERVAL] [bigint] NULL,
	[INSTANCEPK] [varbinary](1) NULL,
	[INFO] [varbinary](1) NULL,
PRIMARY KEY CLUSTERED 
(
	[TIMERID] ASC,
	[TARGETID] ASC
)
) ON [PRIMARY];

CREATE TABLE [testedatahora](
	[datahoraatual] [datetime] NOT NULL,
	[valor] [varchar](50) NULL
) ON [PRIMARY]

INSERT [testedatahora] ([datahoraatual], [valor]) VALUES (CAST('2013-04-05 13:40:00' AS datetime), N'');

CREATE TABLE [tempoacordonivelservico](
	[idacordonivelservico] [bigint] NOT NULL,
	[idprioridade] [bigint] NOT NULL,
	[idfase] [bigint] NOT NULL,
	[tempohh] [int] NOT NULL,
	[tempomm] [int] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idacordonivelservico] ASC,
	[idprioridade] ASC,
	[idfase] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_50] ON [tempoacordonivelservico] 
(
	[idprioridade] ASC
)ON [PRIMARY];

INSERT [tempoacordonivelservico] ([idacordonivelservico], [idprioridade], [idfase], [tempohh], [tempomm]) VALUES (1, 1, 1, 0, 0);
INSERT [tempoacordonivelservico] ([idacordonivelservico], [idprioridade], [idfase], [tempohh], [tempomm]) VALUES (1, 1, 2, 0, 0);
INSERT [tempoacordonivelservico] ([idacordonivelservico], [idprioridade], [idfase], [tempohh], [tempomm]) VALUES (1, 2, 1, 0, 0);
INSERT [tempoacordonivelservico] ([idacordonivelservico], [idprioridade], [idfase], [tempohh], [tempomm]) VALUES (1, 2, 2, 0, 0);
INSERT [tempoacordonivelservico] ([idacordonivelservico], [idprioridade], [idfase], [tempohh], [tempomm]) VALUES (1, 3, 1, 0, 0);
INSERT [tempoacordonivelservico] ([idacordonivelservico], [idprioridade], [idfase], [tempohh], [tempomm]) VALUES (1, 3, 2, 0, 0);
INSERT [tempoacordonivelservico] ([idacordonivelservico], [idprioridade], [idfase], [tempohh], [tempomm]) VALUES (1, 4, 1, 0, 0);
INSERT [tempoacordonivelservico] ([idacordonivelservico], [idprioridade], [idfase], [tempohh], [tempomm]) VALUES (1, 4, 2, 0, 0);
INSERT [tempoacordonivelservico] ([idacordonivelservico], [idprioridade], [idfase], [tempohh], [tempomm]) VALUES (1, 5, 1, 0, 0);
INSERT [tempoacordonivelservico] ([idacordonivelservico], [idprioridade], [idfase], [tempohh], [tempomm]) VALUES (1, 5, 2, 0, 0);
INSERT [tempoacordonivelservico] ([idacordonivelservico], [idprioridade], [idfase], [tempohh], [tempomm]) VALUES (2, 1, 1, 0, 0);
INSERT [tempoacordonivelservico] ([idacordonivelservico], [idprioridade], [idfase], [tempohh], [tempomm]) VALUES (2, 1, 2, 0, 0);
INSERT [tempoacordonivelservico] ([idacordonivelservico], [idprioridade], [idfase], [tempohh], [tempomm]) VALUES (2, 2, 1, 0, 0);
INSERT [tempoacordonivelservico] ([idacordonivelservico], [idprioridade], [idfase], [tempohh], [tempomm]) VALUES (2, 2, 2, 0, 0);
INSERT [tempoacordonivelservico] ([idacordonivelservico], [idprioridade], [idfase], [tempohh], [tempomm]) VALUES (2, 3, 1, 0, 0);
INSERT [tempoacordonivelservico] ([idacordonivelservico], [idprioridade], [idfase], [tempohh], [tempomm]) VALUES (2, 3, 2, 0, 0);
INSERT [tempoacordonivelservico] ([idacordonivelservico], [idprioridade], [idfase], [tempohh], [tempomm]) VALUES (2, 4, 1, 0, 0);
INSERT [tempoacordonivelservico] ([idacordonivelservico], [idprioridade], [idfase], [tempohh], [tempomm]) VALUES (2, 4, 2, 0, 0);
INSERT [tempoacordonivelservico] ([idacordonivelservico], [idprioridade], [idfase], [tempohh], [tempomm]) VALUES (2, 5, 1, 0, 0);
INSERT [tempoacordonivelservico] ([idacordonivelservico], [idprioridade], [idfase], [tempohh], [tempomm]) VALUES (2, 5, 2, 0, 0);
INSERT [tempoacordonivelservico] ([idacordonivelservico], [idprioridade], [idfase], [tempohh], [tempomm]) VALUES (3, 1, 1, 0, 0);
INSERT [tempoacordonivelservico] ([idacordonivelservico], [idprioridade], [idfase], [tempohh], [tempomm]) VALUES (3, 1, 2, 0, 0);
INSERT [tempoacordonivelservico] ([idacordonivelservico], [idprioridade], [idfase], [tempohh], [tempomm]) VALUES (3, 2, 1, 0, 0);
INSERT [tempoacordonivelservico] ([idacordonivelservico], [idprioridade], [idfase], [tempohh], [tempomm]) VALUES (3, 2, 2, 0, 0);
INSERT [tempoacordonivelservico] ([idacordonivelservico], [idprioridade], [idfase], [tempohh], [tempomm]) VALUES (3, 3, 1, 0, 0);
INSERT [tempoacordonivelservico] ([idacordonivelservico], [idprioridade], [idfase], [tempohh], [tempomm]) VALUES (3, 3, 2, 0, 0);
INSERT [tempoacordonivelservico] ([idacordonivelservico], [idprioridade], [idfase], [tempohh], [tempomm]) VALUES (3, 4, 1, 0, 0);
INSERT [tempoacordonivelservico] ([idacordonivelservico], [idprioridade], [idfase], [tempohh], [tempomm]) VALUES (3, 4, 2, 0, 0);
INSERT [tempoacordonivelservico] ([idacordonivelservico], [idprioridade], [idfase], [tempohh], [tempomm]) VALUES (3, 5, 1, 0, 0);
INSERT [tempoacordonivelservico] ([idacordonivelservico], [idprioridade], [idfase], [tempohh], [tempomm]) VALUES (3, 5, 2, 0, 0);

CREATE TABLE [templatesolicitacaoservico](
	[idtemplate] [int] NOT NULL,
	[identificacao] [varchar](40) NOT NULL,
	[nometemplate] [varchar](200) NOT NULL,
	[nomeclassedto] [varchar](255) NULL,
	[nomeclasseaction] [varchar](255) NULL,
	[nomeclasseservico] [varchar](255) NULL,
	[urlrecuperacao] [varchar](255) NULL,
	[scriptaposrecuperacao] [text] NULL,
	[habilitadirecionamento] [char](1) NULL,
	[habilitasituacao] [char](1) NULL,
	[habilitasolucao] [char](1) NULL,
	[alturadiv] [int] NULL,
	[habilitaurgenciaimpacto] [char](1) NULL,
	[habilitanotificacaoemail] [char](1) NULL,
	[habilitaproblema] [char](1) NULL,
	[habilitamudanca] [char](1) NULL,
	[habilitaitemconfiguracao] [char](1) NULL,
	[habilitasolicitacaorelacionada] [char](1) NULL,
	[habilitagravarecontinuar] [char](1) NULL,
	[idquestionario] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[idtemplate] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

INSERT [templatesolicitacaoservico] ([idtemplate], [identificacao], [nometemplate], [nomeclassedto], [nomeclasseaction], [nomeclasseservico], [urlrecuperacao], [scriptaposrecuperacao], [habilitadirecionamento], [habilitasituacao], [habilitasolucao], [alturadiv], [habilitaurgenciaimpacto], [habilitanotificacaoemail], [habilitaproblema], [habilitamudanca], [habilitaitemconfiguracao], [habilitasolicitacaorelacionada], [habilitagravarecontinuar], [idquestionario]) VALUES (10, N'AprovacaoSolicitacaoServico', N'Aprovaçãoo da Solicitaçãoo de Serviço', N'br.com.centralit.citcorpore.bean.AprovacaoSolicitacaoServicoDTO', N'br.com.centralit.citcorpore.ajaxForms.AprovacaoSolicitacaoServico', N'br.com.centralit.citcorpore.negocio.AprovacaoSolicitacaoServicoServiceEjb', N'/pages/aprovacaoSolicitacaoServico/aprovacaoSolicitacaoServico.load', NULL, N'N', N'N', N'N', 250, N'N', N'N', N'N', N'N', N'N', N'N', N'S', NULL);

CREATE TABLE [tipoitemconfiguracao](
	[idtipoitemconfiguracao] [int] NOT NULL,
	[idempresa] [int] NOT NULL,
	[nometipoitemconfiguracao] [varchar](255) NOT NULL,
	[tagtipoitemconfiguracao] [varchar](50) NULL,
	[datainicio] [date] NOT NULL,
	[datafim] [date] NULL,
	[sistema] [char](1) NULL,
	[categoria] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[idtipoitemconfiguracao] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_TIPOEMPRESA] ON [tipoitemconfiguracao] 
(
	[idempresa] ASC
)ON [PRIMARY];

CREATE TABLE [tipoitemcfgcaracteristica](
	[id] [int] NOT NULL,
	[idtipoitemconfiguracao] [int] NOT NULL,
	[idcaracteristica] [int] NOT NULL,
	[datainicio] [date] NULL,
	[datafim] [date] NULL,
	[nameinfoagente] [varchar](255) NULL,
PRIMARY KEY CLUSTERED 
(
	[id] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_TIPOCARACTERISTICA] ON [tipoitemcfgcaracteristica] 
(
	[idcaracteristica] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_TIPOCARC] ON [tipoitemcfgcaracteristica] 
(
	[idtipoitemconfiguracao] ASC,
	[idcaracteristica] ASC,
	[nameinfoagente] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_TIPOITEMCONFIGURACAO] ON [tipoitemcfgcaracteristica] 
(
	[idtipoitemconfiguracao] ASC
)ON [PRIMARY];

CREATE TABLE [tipoeventoservico](
	[idtipoeventoservico] [int] NOT NULL,
	[nometipoeventoservico] [varchar](70) NOT NULL,
	[deleted] [char](1) NULL,
PRIMARY KEY CLUSTERED 
(
	[idtipoeventoservico] ASC
)
) ON [PRIMARY];

INSERT [tipoeventoservico] ([idtipoeventoservico], [nometipoeventoservico], [deleted]) VALUES (1, N'EVENTUAL', NULL);
INSERT [tipoeventoservico] ([idtipoeventoservico], [nometipoeventoservico], [deleted]) VALUES (19, N'DIÁRIO', NULL);
INSERT [tipoeventoservico] ([idtipoeventoservico], [nometipoeventoservico], [deleted]) VALUES (30, N'SEMANAL', NULL);
INSERT [tipoeventoservico] ([idtipoeventoservico], [nometipoeventoservico], [deleted]) VALUES (31, N'MENSAL', NULL);
INSERT [tipoeventoservico] ([idtipoeventoservico], [nometipoeventoservico], [deleted]) VALUES (32, N'SEMESTRAL', NULL);
INSERT [tipoeventoservico] ([idtipoeventoservico], [nometipoeventoservico], [deleted]) VALUES (33, N'ANUAL', NULL);

CREATE TABLE [tipodemandaservico](
	[idtipodemandaservico] [int] NOT NULL,
	[nometipodemandaservico] [varchar](70) NOT NULL,
	[classificacao] [char](1) NULL,
	[deleted] [char](1) NULL,
PRIMARY KEY CLUSTERED 
(
	[idtipodemandaservico] ASC
)
) ON [PRIMARY];

INSERT [tipodemandaservico] ([idtipodemandaservico], [nometipodemandaservico], [classificacao], [deleted]) VALUES (1, N'Requisição', N'R', NULL);
INSERT [tipodemandaservico] ([idtipodemandaservico], [nometipodemandaservico], [classificacao], [deleted]) VALUES (2, N'O.S. (Ordem de Serviço)', N'O', NULL);
INSERT [tipodemandaservico] ([idtipodemandaservico], [nometipodemandaservico], [classificacao], [deleted]) VALUES (3, N'Incidente', N'I', NULL);

CREATE TABLE [tipodemanda](
	[idtipodemanda] [int] NOT NULL,
	[nometipodemanda] [varchar](40) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idtipodemanda] ASC
)
) ON [PRIMARY];

CREATE TABLE [tipocomplexidade](
	[complexidade] [char](1) NOT NULL,
	[desctipocomplexidade] [varchar](50) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[complexidade] ASC
)
) ON [PRIMARY];

INSERT [tipocomplexidade] ([complexidade], [desctipocomplexidade]) VALUES (N'A', N'Alta');
INSERT [tipocomplexidade] ([complexidade], [desctipocomplexidade]) VALUES (N'B', N'Baixa');
INSERT [tipocomplexidade] ([complexidade], [desctipocomplexidade]) VALUES (N'E', N'Especialista');
INSERT [tipocomplexidade] ([complexidade], [desctipocomplexidade]) VALUES (N'I', N'Intermediária');
INSERT [tipocomplexidade] ([complexidade], [desctipocomplexidade]) VALUES (N'M', N'Mediana');

CREATE TABLE [timesheet](
	[idtimesheet] [int] NOT NULL,
	[iddemanda] [int] NULL,
	[idempregado] [int] NOT NULL,
	[idprojeto] [int] NULL,
	[qtdehoras] [decimal](18, 3) NOT NULL,
	[data] [date] NOT NULL,
	[custoporhora] [decimal](18, 3) NOT NULL,
	[detalhamento] [text] NULL,
PRIMARY KEY CLUSTERED 
(
	[idtimesheet] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_TIMESHEETDEMANDA] ON [timesheet] 
(
	[iddemanda] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_TIMESHEETEMPREGADO] ON [timesheet] 
(
	[idempregado] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_TIMESHEETPROJETO] ON [timesheet] 
(
	[idprojeto] ASC
)ON [PRIMARY];

CREATE TABLE [tipoproblemaatendimento](
	[idtipoproblema] [bigint] NOT NULL,
	[idtipoproblemapai] [bigint] NULL,
	[descricaoproblema] [text] NOT NULL,
	[situacao] [char](1) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idtipoproblema] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE TABLE [tipoos](
	[idclassificacaoos] [int] NOT NULL,
	[idcontrato] [int] NULL,
	[descricao] [varchar](150) NOT NULL,
	[detalhamento] [text] NULL,
PRIMARY KEY CLUSTERED 
(
	[idclassificacaoos] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_TIPOOSCONTRATO] ON [tipoos] 
(
	[idcontrato] ASC
)ON [PRIMARY];

CREATE TABLE [tipounidade](
	[idtipounidade] [int] NOT NULL,
	[idempresa] [int] NOT NULL,
	[nometipounidade] [varchar](80) NOT NULL,
	[datainicio] [date] NULL,
	[datafim] [date] NULL,
PRIMARY KEY CLUSTERED 
(
	[idtipounidade] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_TIPOUNIDADEEMPRESA] ON [tipounidade] 
(
	[idempresa] ASC
)ON [PRIMARY];

CREATE TABLE [tiposoftware](
	[idtiposoftware] [int] NOT NULL,
	[nome] [varchar](200) NULL,
PRIMARY KEY CLUSTERED 
(
	[idtiposoftware] ASC
)
) ON [PRIMARY];

INSERT [tiposoftware] ([idtiposoftware], [nome]) VALUES (1, N'Anti-virus');
INSERT [tiposoftware] ([idtiposoftware], [nome]) VALUES (2, N'Auxiliar de escritório');
INSERT [tiposoftware] ([idtiposoftware], [nome]) VALUES (3, N'Comunicador Instantâneo');
INSERT [tiposoftware] ([idtiposoftware], [nome]) VALUES (4, N'Editor de Imagem');
INSERT [tiposoftware] ([idtiposoftware], [nome]) VALUES (5, N'Editor de Texto');
INSERT [tiposoftware] ([idtiposoftware], [nome]) VALUES (6, N'Navegador');
INSERT [tiposoftware] ([idtiposoftware], [nome]) VALUES (7, N'Sistema Operacional');
INSERT [tiposoftware] ([idtiposoftware], [nome]) VALUES (8, N'Outros');

CREATE TABLE [tiposervico](
	[idtiposervico] [int] NOT NULL,
	[idempresa] [int] NOT NULL,
	[nometiposervico] [varchar](300) NOT NULL,
	[situacao] [char](1) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idtiposervico] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_TIPOSERVICOEMPRESA] ON [tiposervico] 
(
	[idempresa] ASC
)ON [PRIMARY];

INSERT [tiposervico] ([idtiposervico], [idempresa], [nometiposervico], [situacao]) VALUES (1, 1, N'A DEFINIR', N'A');

CREATE TABLE [tiposatividades](
	[idtipoatividade] [int] NOT NULL,
	[descricaotipoatividade] [varchar](50) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idtipoatividade] ASC
)
) ON [PRIMARY];

CREATE TABLE [usuarioitemconfiguracao](
	[idusuario] [int] NOT NULL,
	[iditemconfiguracao] [int] NOT NULL,
	[datainicio] [date] NOT NULL,
	[datafim] [date] NULL,
PRIMARY KEY CLUSTERED 
(
	[idusuario] ASC,
	[iditemconfiguracao] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_USUARIOITEMCONFIGURACAO] ON [usuarioitemconfiguracao] 
(
	[iditemconfiguracao] ASC
)ON [PRIMARY];

CREATE TABLE [usuario](
	[idusuario] [int] NOT NULL,
	[idunidade] [int] NULL,
	[idempregado] [int] NOT NULL,
	[idempresa] [int] NOT NULL,
	[login] [varchar](256) NULL,
	[nome] [varchar](256) NULL,
	[senha] [varchar](300) NULL,
	[status] [char](1) NULL,
	[ldap] [char](1) NULL,
	[ultimoacessoportal] [date] NULL,
PRIMARY KEY CLUSTERED 
(
	[idusuario] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_USEMPREGADO] ON [usuario] 
(
	[idempregado] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_USEMPRESA] ON [usuario] 
(
	[idempresa] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_USUNIDADE] ON [usuario] 
(
	[idunidade] ASC
)ON [PRIMARY];

INSERT [usuario] ([idusuario], [idunidade], [idempregado], [idempresa], [login], [nome], [senha], [status], [ldap], [ultimoacessoportal]) VALUES (1, NULL, 1, 1, N'admin', N'Administrador', N'511574e821fa42fb7d31796ab74c1c721098a0df', N'A', NULL, NULL);
INSERT [usuario] ([idusuario], [idunidade], [idempregado], [idempresa], [login], [nome], [senha], [status], [ldap], [ultimoacessoportal]) VALUES (2, NULL, 2, 1, N'default', N'Default', N'40bd001563085fc35165329ea1ff5c5ecbdbbeef', N'A', NULL, NULL);
INSERT [usuario] ([idusuario], [idunidade], [idempregado], [idempresa], [login], [nome], [senha], [status], [ldap], [ultimoacessoportal]) VALUES (3, NULL, 3, 1, N'consultor', N'Consultor', N'04a991894ac6cdd7ef06d049feb9f0b9cc6c9004', N'A', NULL, NULL);

CREATE TABLE [urgencia](
	[idUrgencia] [int] NOT NULL,
	[nivelUrgencia] [varchar](100) NOT NULL,
	[siglaUrgencia] [char](2) NULL,
PRIMARY KEY CLUSTERED 
(
	[idUrgencia] ASC
)
) ON [PRIMARY];

INSERT [urgencia] ([idUrgencia], [nivelUrgencia], [siglaUrgencia]) VALUES (1, N'Crítica', N'C ');
INSERT [urgencia] ([idUrgencia], [nivelUrgencia], [siglaUrgencia]) VALUES (2, N'Alta', N'A ');
INSERT [urgencia] ([idUrgencia], [nivelUrgencia], [siglaUrgencia]) VALUES (3, N'Média', N'M ');
INSERT [urgencia] ([idUrgencia], [nivelUrgencia], [siglaUrgencia]) VALUES (4, N'Baixa', N'B ');

CREATE TABLE [unidadesaccservicos](
	[idunidade] [int] NOT NULL,
	[idservico] [bigint] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idunidade] ASC,
	[idservico] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_571] ON [unidadesaccservicos] 
(
	[idservico] ASC
)ON [PRIMARY];

CREATE TABLE [unidademedida](
	[idunidademedida] [int] NOT NULL,
	[nomeunidademedida] [varchar](100) NOT NULL,
	[siglaunidademedida] [varchar](10) NOT NULL,
	[situacao] [char](1) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idunidademedida] ASC
)
) ON [PRIMARY];

CREATE TABLE [unidadebaseitemconfiguracao](
	[idbaseitemconfiguracao] [int] NOT NULL,
	[idunidade] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[idbaseitemconfiguracao] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_UNIDADE] ON [unidadebaseitemconfiguracao] 
(
	[idunidade] ASC
)ON [PRIMARY];

CREATE TABLE [visaorelacionada](
	[idvisaorelacionada] [bigint] NOT NULL,
	[idvisaopai] [bigint] NOT NULL,
	[idvisaofilha] [bigint] NOT NULL,
	[idobjetonegocionn] [bigint] NULL,
	[ordem] [int] NOT NULL,
	[titulo] [varchar](500) NOT NULL,
	[situacao] [char](1) NOT NULL,
	[tipovinculacao] [char](1) NOT NULL,
	[acaoemselecaopesquisa] [char](2) NULL,
PRIMARY KEY CLUSTERED 
(
	[idvisaorelacionada] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_78] ON [visaorelacionada] 
(
	[idvisaopai] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_90] ON [visaorelacionada] 
(
	[idobjetonegocionn] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_visaorel_ref2_visao] ON [visaorelacionada] 
(
	[idvisaofilha] ASC
)ON [PRIMARY];

CREATE TABLE [visao](
	[idvisao] [bigint] NOT NULL,
	[descricao] [varchar](120) NOT NULL,
	[tipovisao] [char](2) NOT NULL,
	[situacao] [char](1) NOT NULL,
	[classename] [varchar](500) NULL,
	[identificador] [varchar](100) NULL,
PRIMARY KEY CLUSTERED 
(
	[idvisao] ASC
)
) ON [PRIMARY];

CREATE TABLE [vinculovisao](
	[idvisaorelacionada] [bigint] NOT NULL,
	[seq] [int] NOT NULL,
	[tipovinculo] [char](1) NOT NULL,
	[idgrupovisaopai] [bigint] NULL,
	[idcamposobjetonegociopai] [bigint] NULL,
	[idgrupovisaofilho] [bigint] NULL,
	[idcamposobjetonegociofilho] [bigint] NULL,
	[idcamposobjetonegociopainn] [bigint] NULL,
	[idcamposobjetonegociofilhonn] [bigint] NULL,
PRIMARY KEY CLUSTERED 
(
	[idvisaorelacionada] ASC,
	[seq] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_vinculov_ref1_camposob] ON [vinculovisao] 
(
	[idcamposobjetonegociopainn] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_vinculov_ref1_grupovis] ON [vinculovisao] 
(
	[idgrupovisaofilho] ASC,
	[idcamposobjetonegociofilho] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_vinculov_ref2_camposob] ON [vinculovisao] 
(
	[idcamposobjetonegociofilhonn] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_vinculov_ref2_grupovis] ON [vinculovisao] 
(
	[idgrupovisaopai] ASC,
	[idcamposobjetonegociopai] ASC
)ON [PRIMARY];

CREATE TABLE [vinculaosincidente](
	[idos] [int] NOT NULL,
	[idsolicitacaoservico] [bigint] NOT NULL,
	[idatividadesos] [bigint] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idos] ASC,
	[idsolicitacaoservico] ASC
)
) ON [PRIMARY];

CREATE TABLE [versao](
	[idversao] [int] NOT NULL,
	[nomeversao] [varchar](100) NOT NULL,
	[idusuario] INT,
PRIMARY KEY CLUSTERED 
(
	[idversao] ASC
)
) ON [PRIMARY];

CREATE UNIQUE NONCLUSTERED INDEX [idversao] ON [versao] 
(
	[idversao] ASC
)ON [PRIMARY];

CREATE UNIQUE NONCLUSTERED INDEX [nomeversao] ON [versao] 
(
	[nomeversao] ASC
)ON [PRIMARY];

INSERT [versao] ([idversao], [nomeversao]) VALUES (1, N'2.0.5');

CREATE TABLE [valorvisaocamposnegocio](
	[idvalorvisaocamposnegocio] [bigint] NOT NULL,
	[idgrupovisao] [bigint] NOT NULL,
	[idcamposobjetonegocio] [bigint] NOT NULL,
	[valor] [varchar](500) NOT NULL,
	[situacao] [char](1) NOT NULL,
	[descricao] [varchar](500) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idvalorvisaocamposnegocio] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_83] ON [valorvisaocamposnegocio] 
(
	[idgrupovisao] ASC,
	[idcamposobjetonegocio] ASC
)ON [PRIMARY];

CREATE TABLE [valorajusteglosa](
	[idservicocontrato] [bigint] NOT NULL,
	[idacordonivelservico] [bigint] NOT NULL,
	[quantidadefalhas] [int] NULL,
	[valorajuste] [decimal](10, 2) NULL,
	[deleted] [char](1) NULL
) ON [PRIMARY];

CREATE TABLE [valor](
	[idvalor] [int] NOT NULL,
	[iditemconfiguracao] [int] NULL,
	[idcaracteristica] [int] NULL,
	[valorstr] [varchar](4000) NULL,
	[valorlongo] [text] NULL,
	[valordecimal] [decimal](18, 4) NULL,
	[valordate] [date] NULL,
	[idbaseitemconfiguracao] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[idvalor] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_VBASEITEMCONFIG] ON [valor] 
(
	[idbaseitemconfiguracao] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_VCARACTERISTICA] ON [valor] 
(
	[idcaracteristica] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_VCONSULTA3] ON [valor] 
(
	[iditemconfiguracao] ASC,
	[idcaracteristica] ASC,
	[idbaseitemconfiguracao] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_VITEMCONFIGURACAO] ON [valor] 
(
	[iditemconfiguracao] ASC
)ON [PRIMARY];

CREATE TABLE [objetonegocio](
	[idobjetonegocio] [bigint] NOT NULL,
	[nomeobjetonegocio] [varchar](500) NOT NULL,
	[nometabeladb] [varchar](120) NOT NULL,
	[situacao] [char](1) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idobjetonegocio] ASC
)
) ON [PRIMARY];

CREATE TABLE [notificacaoservico](
	[idNotificacao] [int] NULL,
	[idServico] [int] NULL
) ON [PRIMARY];

CREATE TABLE [parametroscontrato](
	[idcontrato] [int] NOT NULL,
	[nomeparametro] [varchar](100) NOT NULL,
	[valorparametro] [text] NULL,
PRIMARY KEY CLUSTERED 
(
	[idcontrato] ASC,
	[nomeparametro] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE TABLE [parametros](
	[nomeparametro] [varchar](70) NOT NULL,
	[idempresa] [int] NOT NULL,
	[modulo] [varchar](200) NULL,
	[valor] [varchar](200) NULL,
	[detalhamento] [varchar](200) NULL
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_PARAMETROSEMPRESA] ON [parametros] 
(
	[idempresa] ASC
)ON [PRIMARY];

CREATE TABLE [parametrocorpore](
	[idparametrocorpore] [int] NOT NULL,
	[nomeparametrocorpore] [varchar](200) NOT NULL,
	[valor] [text] NOT NULL,
	[idempresa] [int] NOT NULL,
	[datainicio] [date] NOT NULL,
	[datafim] [date] NULL,
	[tipodado] [varchar](50) NULL,
PRIMARY KEY CLUSTERED 
(
	[idparametrocorpore] ASC
)
) ON [PRIMARY];

INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (0, N'ORIGEM - Configuração de Origem de Informações (para federação de dados)', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (1, N'Diretorio Arquivo NetMap', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (2, N'Faixa de Ip', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (3, N'No Pesquisa', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (4, N'Atributo Pesquisa', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (5, N'CAMINHO_INSTALADORES', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (6, N'Diretorio XML Agente', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (7, N'Periodo para fazer inventario dias', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (8, N'Caminho Nmap', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (9, N'ID Grupo NÃ­vel 1', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (10, N'Email origem das notificações de solicitações de serviço', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (11, N'Exige autenticação para envio de email', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (12, N'UsuÃ¡rio para autenticação de email', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (13, N'Senha para autenticação de email', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (14, N'SMTP para envio de email', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (15, N'GED Interno (S/N)', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (16, N'GED Interno em Banco de Dados (S/N)', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (17, N'GED Externo - Classe de tratamento', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (18, N'GED Diretorio', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (19, N'Nome da Empresa', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (20, N'BASE CONHECIMENTO - Pasta de armazenamento', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (21, N'BASECONHECIMENTO - Pasta de armazenamento arquivos LUCENE', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (22, N'MÃ?TODO DE AUTENTICAÃ?Ã?O (1 - Próprio, 2 - LDAP)', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (23, N'SMTP LEITURA - Servidor de entrada de emails do Service Desk', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (24, N'SMTP LEITURA - Caixa de entrada de emails do Service Desk', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (25, N'SMTP LEITURA - Senha da Caixa de entrada de emails do Service Desk', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (26, N'SMTP LEITURA - Provider do servidor de emails do Service Desk (imaps, pops, imap, pop, etc)', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (27, N'SMTP LEITURA - Porta do servidor de emails do Service Desk', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (28, N'SMTP LEITURA - Pasta da caixa de entrada de emails do Service Desk', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (29, N'Nome do fluxo padrão para serviços', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (30, N'ID da fase padrão para execução de serviços', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (31, N'Envia email na execução dos fluxos de solicitações/incidentes', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (32, N'DB - nome do SCHEMA do Banco de dados', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (33, N'URL de acesso ao sistema', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (34, N'LDAP - URL de acesso ao ActiveDirectory. Exemplo: ldap://10.2.1.2:389', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (35, N'LDAP - String com dominio do AD. Exemplo: dc=empresa,dc=com,dc=br', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (36, N'DomÃ­nio de e-mail. (@empresa.com.br)', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (37, N'LDAP - Login para consultar informações de usuÃ¡rios do LDAP(deve-se cadastrar também a senha).', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (38, N'LDAP - Senha para consultar informações de usuÃ¡rios do LDAP(deve-se cadastrar também o login).', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (39, N'LDAP - Id do perfil de acesso que serÃ¡ setado automaticamente caso o usuÃ¡rio não possua nenhum.', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (40, N'Faz o controle de acessos do catalogo de serviço por unidade (S/N) ?', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (41, N'Faz o controle de vinculo de colaboradores aos contratos (S/N) ?', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (42, N'Pagina para cadastro de solicitações de serviço (serÃ¡ usado o padrão caso não seja informado)', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (43, N'LDAP - Sufixo dominio', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (44, N'Diretório Upload repositório path', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (45, N'LDAP - ID Grupo Padrão.', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (46, N'PÃ¡gina de Login usando o Portal', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (47, N'Nome do fluxo padrão para mudanças', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (48, N'Validar permissões de botões (gravar, excluir e pesquisar) (S/N).', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (49, N'Gravar nome UsuÃ¡rio e Nome Empregado a partir do Last Name? (S/N).', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (50, N'Aceitar Valor 0 (Zero) para quantidade e custo da atividade?', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (51, N'FORMULA GLOSA OS - Código Padrão', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (52, N'Ativar log no sistema (''true'' ou ''false'')', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (53, N'Tipos: ''CIT_LOG'' (arquivo de log), ''DB_LOG'' (grava no banco)', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (54, N'Caminho da pasta que ficarÃ¡ o arquivo de LOG', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (55, N'Nome do arquivo de log', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (56, N'Extensão do arquivo de log', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (57, N'ID do modelo de e-mail que serÃ¡ enviado para o grupo de destino ao escalar uma solicitação.', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (58, N'Notificar o grupo ao receber uma escalação de solicitação de serviço (S e N).', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (59, N'PATRIMÃ?NIOP - ID Tipo Item Configuração.', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (60, N'Grupo de novos itens de configuração.', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (61, N'Vincula contratos a unidade', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (62, N'Identifica o id do serviço para solicitações de serviços e incidentes (Ex: A Ser Classificado )', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (63, N'[Parametro Depreciado] Pagina para cadastro de solicitações de serviço pelo Portal (Default: ''/pages/solicitacaoServicoPortal/solicitacaoServicoPortal.load'')', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (64, N'LDAP - Atributo LDAP para obter NOME DO COLABORADOR? (DisplayName, CN, SN ...).', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (65, N'Identifica o id de origem do chamado padrão da solicitação de serviço ', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (66, N'Idioma padrão do sistema(Ex: EN=InglÃªs)?', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (67, N'LDAP - Filtro LDAP na busca? (Default: (&(objectCategory=person)(objectClass=user))).', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (68, N'LDAP - Mostrar botão de buscar no AD na tela de incidentes.(Default: ''N'')', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (69, N'Validar campos Causa e Categoria da Solução da pÃ¡gina solicitação serviço obrigatorios(Default: N)', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (70, N'Mostrar botões de importação e exportação do xml no cadastro de menus. (Default: S)', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (71, N'ParÃ¢metro para ler o arquivo XML padrão de menus. (Default: N)', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (72, N'SMTP LEITURA - Limite de emails carregados em Solicitação Serviço', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (73, N'Avisar, com antecedÃªncia, a quantidade de dias que restam para a expiração da licença. (Default: 90 dias)', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (74, N'Enviar e-mail para grupo ou proprietÃ¡rio do item configuração. (1: Grupo 2: proprietÃ¡rio).', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (75, N'ID do modelo de e-mail para envio de notificação de licença próximo da expiração', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (76, N'Nome do DomÃ­nio da Rede (exemplo: EMPRESA, CORPORACAO)', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (78, N'Avisar, com antecedÃªncia, a quantidade de dias que restam para a expiração do conhecimento.  (Default: 90 dias)', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (79, N'ID do modelo de e-mail para envio de notificação de criação de pasta', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (80, N'ID do modelo de e-mail para envio de notificação de atualização de pasta', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (81, N'ID do modelo de e-mail para envio de notificação de exclusão de pasta', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (82, N'ID do modelo de e-mail para envio de notificação de criação de conhecimento', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (83, N'ID do modelo de e-mail para envio de notificação de atualização de conhecimento', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (84, N'ID do modelo de e-mail para envio de notificação de exclusão de conhecimento', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (85, N'Verificação de vinculo de mudança relacionada ao Item de configuração (Default: S)', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (86, N'Mostrar Categoria de serviço em Incidente default(S)', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (87, N'Modelo de criação de IC', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (88, N'Modelo de alteração de IC)', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (89, N'Modelo de alteração de IC de grupo', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (90, N'Envio de e-mails de Notificação de ICs (1-Grupo, 2-Proprietario, 3-Todos) (Default: 1)', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (91, N'SMTP GMAIL - Envio e recebimento de e-mails utilizando GMAIL? (S e N)', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (92, N'Nome fase ciclo de vida desenvolvimento Item Configuração (Default: ICs em Desenvolvimento)', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (93, N'Nome fase ciclo de vida produção Item Configuração (Default: ICs em Produção', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (94, N'Nome fase ciclo de vida homologação Item Configuração (Default: ICs em Homologação)', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (95, N'Nome InventÃ¡rio (Default: InventÃ¡rio)', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (96, N'ID do grupo de desenvolvimento Item Configuração (Ex: 1)', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (97, N'ID do grupo de produção Item Configuração (Ex: 2)', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (98, N'ID do grupo de homologação Item Configuração (Ex: 3)', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (99, N'ID do grupo de inventario Item Configuração (Ex: 4)', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (100, N'ID do grupo padrão para atendimento de requisições de produtos', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (101, N'Percentual mÃ¡ximo de variação de preço para cotação', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (102, N'LDAP - NÃºmero mÃ¡ximo de colaboradores retornados na rotina de sincronização com AD? ', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (103, N'ID do modelo de e-mail para envio de notificação de alteracao de serviço', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (104, N'Calcular a prioridade da solicitação dinamicamente usando a fórmula cadastrada. (Default: ''N'')', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (105, N'ID da origem que será setado como padrão ao criar um novo incidente', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (106, N'Determina automaticamente a urgência e impacto das requisições de produto', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (107, N'Peso padrão para critério PREÇO na cotação', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (108, N'Peso padrão para critério PRAZO DE ENTREGA na cotação', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (109, N'Peso padrão para critério PRAZO DE PAGAMENTO na cotação', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (110, N'Peso padrão para critério PRAZO DE GARANTIA na cotação', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (111, N'Peso padrão para critério TAXA DE JUROS na cotação', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (112, N'Path do Arquivo de Status do Nagios', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (113, N'ID do modelo de e-mail para escalação automÃ¡tica', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (114, N'Permite que um empregado da área de compras faça requisição de produto', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (115, N'Tirar vinculo de localidade física com unidade ?(S/N)(Default: N)', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (116, N'ID do modelo de e-mail para alteração da senha de acesso ao CITSmart', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (117, N'Informar o caminho para salvar a tabela LOGDADOS', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (118, N'[Portal] ID do Contrato padrão para abertura de chamados.', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (119, N'Tipo de captura de solicitações/Incidentes (1-Na execução, 2-No direcionamento) (Default: 1)', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (120, N'ID do modelo de e-mail para envio de notificação para o comitê de consultivo de mudanças', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (121, N'Faz o controle de Configuração para o openLDAP (S/N)(Default: N)', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);
INSERT [parametrocorpore] ([idparametrocorpore], [nomeparametrocorpore], [valor], [idempresa], [datainicio], [datafim], [tipodado]) VALUES (122, N'ID do modelo de e-mail que será enviado para o grupo de destino ao escalar uma requisição mudança', N' ', 1, CAST(0xF5360B00 AS Date), NULL, NULL);

CREATE TABLE [palavragemea](
	[idpalavragemea] [int] NOT NULL,
	[palavra] [varchar](256) NOT NULL,
	[palavracorrespondente] [varchar](256) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idpalavragemea] ASC
)
) ON [PRIMARY];

CREATE TABLE [pais](
	[idpais] [int] NOT NULL,
	[nomepais] [varchar](200) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idpais] ASC
)
) ON [PRIMARY];

INSERT [pais] ([idpais], [nomepais]) VALUES (1, N'Brasil');

CREATE TABLE [osatividadeperiodica](
	[idatividadeperiodica] [int] NULL,
	[idos] [int] NULL
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_579] ON [osatividadeperiodica] 
(
	[idatividadeperiodica] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_580] ON [osatividadeperiodica] 
(
	[idos] ASC
)ON [PRIMARY];

CREATE TABLE [os](
	[idos] [int] NOT NULL,
	[idcontrato] [int] NOT NULL,
	[idclassificacaoos] [int] NULL,
	[idservicocontrato] [bigint] NULL,
	[numero] [varchar](20) NULL,
	[ano] [int] NULL,
	[datainicio] [date] NOT NULL,
	[datafim] [date] NOT NULL,
	[demanda] [text] NOT NULL,
	[objetivo] [text] NULL,
	[situacaoos] [int] NULL,
	[nomearearequisitante] [varchar](150) NULL,
	[obsfinalizacao] [text] NULL,
	[quantidadeglosasanterior] [int] NULL,
	[quantidade] [int] NULL,
	[idospai] [int] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_22] ON [os] 
(
	[idcontrato] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_24] ON [os] 
(
	[idclassificacaoos] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_27] ON [os] 
(
	[idservicocontrato] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_619] ON [os] 
(
	[idospai] ASC
)ON [PRIMARY];

CREATE TABLE [origemocorrencia](
	[idorigemocorrencia] [int] NOT NULL,
	[nome] [varchar](256) NOT NULL,
	[dataInicio] [date] NOT NULL,
	[dataFim] [date] NULL,
PRIMARY KEY CLUSTERED 
(
	[idorigemocorrencia] ASC
)
) ON [PRIMARY];

CREATE TABLE [notificacao](
	[idnotificacao] [int] NOT NULL,
	[titulo] [varchar](255) NULL,
	[tiponotificacao] [char](1) NULL,
	[datainicio] [date] NULL,
	[datafim] [date] NULL,
	[origemnotificacao] [char](1) NOT NULL,
	[idContrato] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[idnotificacao] ASC
)
) ON [PRIMARY];

CREATE TABLE [netmap](
	[idnetmap] [int] NOT NULL,
	[ip] [varchar](50) NULL,
	[mask] [varchar](50) NULL,
	[mac] [varchar](50) NULL,
	[date_] [date] NULL,
	[nome] [varchar](150) NULL,
PRIMARY KEY CLUSTERED 
(
	[idnetmap] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_NETMAPIP] ON [netmap] 
(
	[idnetmap] ASC
)ON [PRIMARY];

CREATE TABLE [nagiosconexao](
	[idnagiosconexao] [int] NOT NULL,
	[nome] [varchar](255) NOT NULL,
	[nomejndi] [varchar](255) NULL,
	[criadopor] [varchar](255) NULL,
	[modificadopor] [varchar](255) NULL,
	[datacriacao] [date] NULL,
	[ultmodificacao] [date] NULL,
	[deleted] [char](1) NULL,
PRIMARY KEY CLUSTERED 
(
	[idnagiosconexao] ASC
)
) ON [PRIMARY];

CREATE TABLE [motivosuspensaoativid](
	[idmotivo] [int] NOT NULL,
	[descricao] [varchar](100) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idmotivo] ASC
)
) ON [PRIMARY];

CREATE TABLE [moedas](
	[idmoeda] [int] NOT NULL,
	[nomemoeda] [varchar](50) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idmoeda] ASC
)
) ON [PRIMARY];

INSERT [moedas] ([idmoeda], [nomemoeda]) VALUES (1, N'Real');
INSERT [moedas] ([idmoeda], [nomemoeda]) VALUES (2, N'UST');

CREATE TABLE [modelosemails](
	[idmodeloemail] [int] NOT NULL,
	[titulo] [varchar](100) NOT NULL,
	[texto] [text] NOT NULL,
	[situacao] [char](1) NOT NULL,
	[identificador] [varchar](20) NULL,
PRIMARY KEY CLUSTERED 
(
	[idmodeloemail] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

INSERT [modelosemails] ([idmodeloemail], [titulo], [texto], [situacao], [identificador]) VALUES (1, N'Solicitação registrada -  ${IDSOLICITACAOSERVICO}', N'Senhor(a) ${NOMECONTATO},<br /><br />Informamos que a sua solicita&ccedil;&atilde;o foi registrada em ${DATAHORASOLICITACAOSTR}, conforme os dados abaixo:<br /><br /><strong>N&uacute;mero:</strong> ${IDSOLICITACAOSERVICO}<br /><strong>Tipo:</strong> ${DEMANDA}<br /><strong>Servi&ccedil;o:</strong> ${SERVICO}<br /><br /><strong>Descri&ccedil;&atilde;o:</strong> <br />${DESCRICAO}<br /><br />Atenciosamente,<br /><br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda<br /><br /><br /><br /><br /><br />', N'A', NULL);
INSERT [modelosemails] ([idmodeloemail], [titulo], [texto], [situacao], [identificador]) VALUES (2, N'Solicitação atendida - ${IDSOLICITACAOSERVICO}', N'Senhor(a) ${NOMECONTATO},<br /><br />Informamos que a sua solicita&ccedil;&atilde;o foi atendida em ${DATAHORAFIM}, conforme os dados abaixo:<br /><br /><strong>N&uacute;mero:</strong> ${IDSOLICITACAOSERVICO}<br /><strong>Tipo:</strong> ${DEMANDA}<br /><strong>Servi&ccedil;o:</strong> ${SERVICO}<br /><br /><strong>Descri&ccedil;&atilde;o:</strong> <br />${DESCRICAO}<br /><br /><strong>Resposta do grupo solucionador:</strong><br />${RESPOSTA}<br /><br />${LINKPESQUISASATISFACAO}<br />Caso a solu&ccedil;&atilde;o n&atilde;o lhe atenda, a solicita&ccedil;&atilde;o poder&aacute; ser reaberta.<br /><br />Atenciosamente,<br /><br />Central IT&nbsp;Tecnologia da Informa&ccedil;&atilde;o Ltda<br />', N'A', NULL);
INSERT [modelosemails] ([idmodeloemail], [titulo], [texto], [situacao], [identificador]) VALUES (3, N'Solicitação em atendimento - ${IDSOLICITACAOSERVICO}', N'Senhor(a) ${NOMECONTATO},<br /><br />Informamos que a sua solicita&ccedil;&atilde;o registrada ${DATAHORASOLICITACAOSTR} est&aacute; em atendimento, conforme os dados abaixo:<br /><br /><strong>N&uacute;mero:</strong> ${IDSOLICITACAOSERVICO}<br /><strong>Tipo:</strong> ${DEMANDA}<br /><strong>Servi&ccedil;o:</strong> ${SERVICO}<br /><br /><strong>Descri&ccedil;&atilde;o:</strong> <br />${DESCRICAO}<br /><strong><br />Tarefa executada:</strong> ${NOMETAREFA}<br /><strong>Grupo de atendimento:</strong> ${GRUPOATUAL}<br /><br />Atenciosamente,<br /><br />Central IT&nbsp;Tecnologia da Informa&ccedil;&atilde;o Ltda<br />', N'A', NULL);
INSERT [modelosemails] ([idmodeloemail], [titulo], [texto], [situacao], [identificador]) VALUES (6, N'Validade do Item configuração - ${IDENTIFICACAO}', N'Informamos que o item de configura&ccedil;&atilde;o identificado como ${IDENTIFICACAO} expirar&aacute; no dia&nbsp;${DATAEXPIRACAO}.<br /><br /><br />Atenciosamente,<br /><br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.<br />', N'A', N'');
INSERT [modelosemails] ([idmodeloemail], [titulo], [texto], [situacao], [identificador]) VALUES (7, N'Validade do documento - ${TITULO}', N'Informamos que o documento titulado como ${TITULO} expirar&aacute; no dia&nbsp;${DATAEXPIRACAO}.<br /><br /><br />Atenciosamente,<br /><br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.<br />', N'A', N'bc');
INSERT [modelosemails] ([idmodeloemail], [titulo], [texto], [situacao], [identificador]) VALUES (8, N'Criação da Pasta - ${NOME}', N'Informamos que foi criado a pasta ${NOME}.<br /><br /><br />Atenciosamente,<br /><br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.<br />', N'A', N'cp');
INSERT [modelosemails] ([idmodeloemail], [titulo], [texto], [situacao], [identificador]) VALUES (9, N'Alteração da Pasta - ${NOME}', N'Informamos que a pasta ${NOME} foi alterada.<br /><br /><br />Atenciosamente,<br /><br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.<br />', N'A', N'ap');
INSERT [modelosemails] ([idmodeloemail], [titulo], [texto], [situacao], [identificador]) VALUES (10, N'Exclusão da pasta - ${NOME}', N'Informamos que a pasta ${NOME} foi exclu&iacute;da.<br /><br /><br />Atenciosamente,<br /><br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.', N'A', N'ep');
INSERT [modelosemails] ([idmodeloemail], [titulo], [texto], [situacao], [identificador]) VALUES (11, N'Criação do documento - ${TITULO}', N'Informamos que foi criado o documento ${TITULO}.<br /><br /><br />Atenciosamente,<br /><br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.<br />', N'A', N'cc');
INSERT [modelosemails] ([idmodeloemail], [titulo], [texto], [situacao], [identificador]) VALUES (12, N'Alteração do documento - ${TITULO}', N'Informamos que o documento ${TITULO} foi alterado.<br /><br /><br />Atenciosamente,<br /><br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.<br />', N'A', N'ac');
INSERT [modelosemails] ([idmodeloemail], [titulo], [texto], [situacao], [identificador]) VALUES (13, N'Exclusão do documento - ${TITULO}', N'Informamos que o documento ${TITULO} foi exclu&iacute;do.<br /><br /><br />Atenciosamente,<br /><br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.<br />', N'A', N'ec');
INSERT [modelosemails] ([idmodeloemail], [titulo], [texto], [situacao], [identificador]) VALUES (14, N'Alteração do Item configuração - ${IDENTIFICACAO}', N'Informamos que o item de configura&ccedil;&atilde;o identificado como ${IDENTIFICACAO} sofreu altera&ccedil;&atilde;o.<br /><br /><br />Atenciosamente,<br /><br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.', N'A', N'alteracaoIC');
INSERT [modelosemails] ([idmodeloemail], [titulo], [texto], [situacao], [identificador]) VALUES (15, N'Alteração do Item configuração para Grupo- ${IDENTIFICACAO}', N'Informamos que o item de configura&ccedil;&atilde;o identificado como ${IDENTIFICACAO} foi alterado para o Grupo ${NOMEGRUPOITEMCONFIGURACAO}<br /><br />Atenciosamente,<br /><br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.', N'A', N'alteracaoICGrupo');
INSERT [modelosemails] ([idmodeloemail], [titulo], [texto], [situacao], [identificador]) VALUES (16, N'Criação do Item configuração - ${IDENTIFICACAO}', N'Informamos a cria&ccedil;&atilde;o do item de configura&ccedil;&atilde;o identificado como ${IDENTIFICACAO} .<br /><br /><br />Atenciosamente,<br /><br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.', N'A', N'CriacaoIC');
INSERT [modelosemails] ([idmodeloemail], [titulo], [texto], [situacao], [identificador]) VALUES (17, N'Alteração Serviço - ${NOMESERVICO}', N'Informamos que o servi&ccedil;o identificado como ${NOMESERVICO} sofreu altera&ccedil;&atilde;o.<br /><br /><br />Atenciosamente,<br /><br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.', N'A', N'alteracaoServico');
INSERT [modelosemails] ([idmodeloemail], [titulo], [texto], [situacao], [identificador]) VALUES (31, N'Problema Registrado  -  ${IDPROBLEMA}', N'Senhor(a) ${SOLICITANTE},<br /><br />Informamos que o Problema Criado, foi registrado em ${DATAHORACAPTURA}, conforme os dados abaixo:<br /><strong><br />N&uacute;mero:</strong> ${IDPROBLEMA}<br /><strong>Tipo:</strong> ${PROATIVOREATIVO}<br /><strong>T&iacute;tulo:</strong> ${TITULO}<br /><br /><strong>Descri&ccedil;&atilde;o:</strong> ${DESCRICAO}<br /><br />Atenciosamente,<br /><br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.', N'A', N'registroProblema');
INSERT [modelosemails] ([idmodeloemail], [titulo], [texto], [situacao], [identificador]) VALUES (32, N'Problema em Andamento  -  ${IDPROBLEMA}', N'Senhor(a) ${SOLICITANTE},<br /><br />Informamos que o Problema criado em ${DATAHORACAPTURA} esta em atendimento, conforme os dados abaixo:<br /><strong><br />N&uacute;mero:</strong> ${IDPROBLEMA}<br /><strong>T&iacute;tulo:</strong> ${TITULO}<br /><br /><strong>Descri&ccedil;&atilde;o:</strong>&nbsp;<br />${TITULO}<br /><strong><br /></strong>${DESCRICAO}<br /><br /><strong>Grupo de atendimento:</strong>&nbsp;${NOMEGRUPOATUAL}<br /><br />Atenciosamente,<br /><br />Central IT&nbsp;Tecnologia da Informa&ccedil;&atilde;o Ltda', N'A', N'andamentoProblema');
INSERT [modelosemails] ([idmodeloemail], [titulo], [texto], [situacao], [identificador]) VALUES (33, N'Problema Finalizado -  ${IDPROBLEMA}', N'Senhor(a) ${SOLICITANTE},<br /><br />Informamos que o Problema ${IDPROBLEMA},&nbsp; foi finalizado em ${DATAHORACONCLUSAO}, conforme os dados abaixo:<br /><strong><br />N&uacute;mero:</strong> ${IDPROBLEMA}<br /><strong>Tipo:</strong> ${PROATIVOREATIVO}<br /><strong>T&iacute;tulo:</strong> ${TITULO}<br /><br /><br /><strong>Status:</strong>${STATUS}<br /><strong>Descri&ccedil;&atilde;o:</strong> ${DESCRICAO}<br /><br />Atenciosamente,<br /><br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.', N'A', N'finalizadoProblema');
INSERT [modelosemails] ([idmodeloemail], [titulo], [texto], [situacao], [identificador]) VALUES (34, N'Problema encaminhado para seu GRUPO DE TRABALHO', N'&nbsp;A solicita&ccedil;&atilde;o abaixo foi encaminhada para seu Grupo de Trabalho:<div>&nbsp;</div><div>N&uacute;mero: ${IDPROBLEMA}</div><div>Tipo: ${PROATIVOREATIVO}</div><div><strong>T&iacute;tulo:</strong> ${TITULO}</div><div>&nbsp;</div><div>Descri&ccedil;&atilde;o:&nbsp;</div><div>${DESCRICAO}</div><div>&nbsp;</div><div>Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.</div>', N'A', N'grupoProblema');
INSERT [modelosemails] ([idmodeloemail], [titulo], [texto], [situacao], [identificador]) VALUES (38, N'requisições problemas com prazo expirados', N'<br />informamos que existem&nbsp;requisi&ccedil;&otilde;es problemas com prazo para contornar ou solucionar expirados.<br /><br /><br />atenciosamente.<br />central it&nbsp;tecnologia da informa&ccedil;&atilde;o ltda.<br /><br />', N'a', N'problemaprazocontexp');
INSERT [modelosemails] ([idmodeloemail], [titulo], [texto], [situacao], [identificador]) VALUES (50, N'Registro de Liberação  -  ${IDREQUISICAOLIBERACAO}', N'Senhor(a) ${NOMESOLICITANTE},<br /><br />Informamos que a sua Requisi&ccedil;&atilde;o de Libera&ccedil;&atilde;o foi registrada em ${DATAHORAINICIOSTR}, conforme os dados abaixo:<br /><br />N&uacute;mero: ${IDREQUISICAOLIBERACAO}<br />Tipo: ${TIPO}<br />T&iacute;tulo: ${TITULO}<br /><br />Descri&ccedil;&atilde;o: ${DESCRICAO}<br /><br />Atenciosamente,<br /><br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.<br /><br /><br />', N'A', N'regestroLib');
INSERT [modelosemails] ([idmodeloemail], [titulo], [texto], [situacao], [identificador]) VALUES (51, N'Requisição Liberação finalizada  -  ${IDREQUISICAOLIBERACAO}', N'Senhor(a) ${NOMESOLICITANTE},<br /><br />Informamos que a sua Requisi&ccedil;&atilde;o de libera&ccedil;&atilde;o foi finalizada em ${DATAHORACONCLUSAO}, conforme os dados abaixo:<br /><br />N&uacute;mero: ${IDREQUISICAOLIBERACAO}<br />Tipo: ${TIPO}<br />T&iacute;tulo: ${TITULO}<br /><br />Status:${STATUS}<br />Descri&ccedil;&atilde;o:<br />${DESCRICAO}<br /><br /><br />Atenciosamente,<br /><br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.<br />', N'A', N'liberacaoFinalizada');
INSERT [modelosemails] ([idmodeloemail], [titulo], [texto], [situacao], [identificador]) VALUES (52, N'Requisição Liberação em andamento- ${IDREQUISICAOLIBERACAO}', N'Senhor(a) ${NOMESOLICITANTE},<br /><br />Informamos que a requisi&ccedil;&atilde;o de libera&ccedil;&atilde;o registrada em ${DATAHORAINICIOSTR} est&aacute; em atendimento, conforme os dados abaixo:<br /><br />N&uacute;mero: ${IDREQUISICAOLIBERACAO}<br />T&iacute;tulo: ${TITULO}<br /><br />Descri&ccedil;&atilde;o: <br />${TITULO}<br /><br />${DESCRICAO}<br /><br />Grupo de atendimento: ${NOMEGRUPOATUAL}<br /><br />Atenciosamente,<br /><br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda<br />', N'A', N'liberacaoEmAndamento');

CREATE TABLE [midiasoftware](
	[idmidiasoftware] [int] NOT NULL,
	[nome] [varchar](200) NOT NULL,
	[endfisico] [varchar](500) NULL,
	[versao] [varchar](20) NULL,
	[endlogico] [varchar](200) NULL,
	[licencas] [int] NULL,
	[idmidia] [int] NULL,
	[idtiposoftware] [int] NULL,
	[datainicio] [date] NULL,
	[datafim] [date] NULL,
PRIMARY KEY CLUSTERED 
(
	[idmidiasoftware] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_midia] ON [midiasoftware] 
(
	[idmidia] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_tiposoftware] ON [midiasoftware] 
(
	[idtiposoftware] ASC
)ON [PRIMARY];

CREATE TABLE [midia](
	[idmidia] [int] NOT NULL,
	[nome] [varchar](200) NULL,
	[midiacol] [varchar](45) NULL,
PRIMARY KEY CLUSTERED 
(
	[idmidia] ASC
)
) ON [PRIMARY];

INSERT [midia] ([idmidia], [nome], [midiacol]) VALUES (1, N'Blu-ray', NULL);
INSERT [midia] ([idmidia], [nome], [midiacol]) VALUES (2, N'Cartão de Memória', NULL);
INSERT [midia] ([idmidia], [nome], [midiacol]) VALUES (3, N'CD', NULL);
INSERT [midia] ([idmidia], [nome], [midiacol]) VALUES (4, N'Disquete', NULL);
INSERT [midia] ([idmidia], [nome], [midiacol]) VALUES (5, N'DVD', NULL);
INSERT [midia] ([idmidia], [nome], [midiacol]) VALUES (6, N'Fita Magnética', NULL);
INSERT [midia] ([idmidia], [nome], [midiacol]) VALUES (7, N'HD', NULL);
INSERT [midia] ([idmidia], [nome], [midiacol]) VALUES (8, N'Pen drive', NULL);
INSERT [midia] ([idmidia], [nome], [midiacol]) VALUES (9, N'Outros', NULL);

CREATE TABLE [meucatalogo](
	[idusuario] [int] NOT NULL,
	[idservico] [int] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idusuario] ASC,
	[idservico] ASC
)
) ON [PRIMARY];

CREATE TABLE [menu](
	[idmenu] [int] NOT NULL,
	[idmenupai] [int] NULL,
	[nome] [varchar](256) NOT NULL,
	[datainicio] [date] NOT NULL,
	[datafim] [date] NULL,
	[descricao] [varchar](256) NULL,
	[ordem] [int] NULL,
	[link] [varchar](256) NULL,
	[imagem] [varchar](256) NULL,
	[horizontal] [varchar](10) NULL,
	[menurapido] [varchar](45) NULL,
PRIMARY KEY CLUSTERED 
(
	[idmenu] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [index_link] ON [menu] 
(
	[link] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [index_menu_link] ON [menu] 
(
	[link] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [index_menu_nome] ON [menu] 
(
	[nome] ASC,
	[ordem] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [index_menu_rapido] ON [menu] 
(
	[menurapido] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_MENUPAI] ON [menu] 
(
	[idmenupai] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [index_nome] ON [menu] 
(
	[nome] ASC,
	[ordem] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [index_rapido] ON [menu] 
(
	[menurapido] ASC
)ON [PRIMARY];

CREATE TABLE [portal](
	[idportal] [int] NOT NULL,
	[iditem] [int] NULL,
	[posicaox] [float] NULL,
	[posicaoy] [float] NULL,
	[idusuario] [int] NOT NULL,
	[largura] [float] NULL,
	[altura] [float] NULL,
	[data] [date] NULL,
	[hora] [datetime] NOT NULL,
	[coluna] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[idportal] ASC
)
) ON [PRIMARY];

CREATE TABLE [planomelhoria](
	[idplanomelhoria] [int] NOT NULL,
	[idfornecedor] [int] NULL,
	[idcontrato] [int] NULL,
	[titulo] [varchar](100) NOT NULL,
	[datainicio] [date] NOT NULL,
	[datafim] [date] NULL,
	[objetivo] [text] NULL,
	[visaogeral] [text] NULL,
	[escopo] [text] NULL,
	[visao] [text] NULL,
	[missao] [text] NULL,
	[datacriacao] [date] NULL,
	[notas] [text] NULL,
	[criadopor] [varchar](40) NULL,
	[modificadopor] [varchar](40) NULL,
	[ultmodificacao] [date] NULL,
	[situacao] [char](1) NULL,
PRIMARY KEY CLUSTERED 
(
	[idplanomelhoria] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [ix_pm_contrato] ON [planomelhoria] 
(
	[idcontrato] ASC,
	[idfornecedor] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [ix_pm_forn] ON [planomelhoria] 
(
	[idfornecedor] ASC
)ON [PRIMARY];

CREATE TABLE [pessoa](
	[tokenidentificacao] [varchar](20) NOT NULL,
	[nome] [varchar](200) NULL,
	[cpf] [varchar](20) NULL,
PRIMARY KEY CLUSTERED 
(
	[tokenidentificacao] ASC
)
) ON [PRIMARY];

CREATE TABLE [pesquisasatisfacao](
	[idpesquisasatisfacao] [int] NOT NULL,
	[idsolicitacaoservico] [bigint] NOT NULL,
	[nota] [int] NOT NULL,
	[comentario] [text] NULL,
PRIMARY KEY CLUSTERED 
(
	[idpesquisasatisfacao] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_542] ON [pesquisasatisfacao] 
(
	[idsolicitacaoservico] ASC
)ON [PRIMARY];

CREATE TABLE [permissoesfluxo](
	[idgrupo] [int] NOT NULL,
	[idtipofluxo] [int] NOT NULL,
	[criar] [char](1) NOT NULL,
	[executar] [char](1) NOT NULL,
	[delegar] [char](1) NOT NULL,
	[suspender] [char](1) NOT NULL,
	[reativar] [char](1) NULL,
	[alterarsla] [char](1) NULL,
	[reabrir] [char](1) NULL,
PRIMARY KEY CLUSTERED 
(
	[idgrupo] ASC,
	[idtipofluxo] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_108] ON [permissoesfluxo] 
(
	[idtipofluxo] ASC
)ON [PRIMARY];

CREATE TABLE [perfilseguranca](
	[idperfilseguranca] [int] NOT NULL,
	[nomeperfilseguranca] [varchar](15) NOT NULL,
	[descperfilseguranca] [varchar](70) NULL,
PRIMARY KEY CLUSTERED 
(
	[idperfilseguranca] ASC
)
) ON [PRIMARY];

CREATE TABLE [perfilacessousuario](
	[datainicio] [date] NOT NULL,
	[idusuario] [int] NOT NULL,
	[idperfil] [int] NOT NULL,
	[datafim] [date] NULL,
PRIMARY KEY CLUSTERED 
(
	[idusuario] ASC,
	[idperfil] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_PERFIL] ON [perfilacessousuario] 
(
	[idperfil] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_PERFILUSUARIO] ON [perfilacessousuario] 
(
	[idusuario] ASC
)ON [PRIMARY];

INSERT [perfilacessousuario] ([datainicio], [idusuario], [idperfil], [datafim]) VALUES (CAST(0x26350B00 AS Date), 1, 1, NULL);
INSERT [perfilacessousuario] ([datainicio], [idusuario], [idperfil], [datafim]) VALUES (CAST(0x26350B00 AS Date), 2, 2, NULL);
INSERT [perfilacessousuario] ([datainicio], [idusuario], [idperfil], [datafim]) VALUES (CAST(0x26350B00 AS Date), 3, 1, NULL);

CREATE TABLE [perfilacessosituacaoos](
	[idperfil] [int] NOT NULL,
	[situacaoos] [int] NOT NULL,
	[datainicio] [date] NOT NULL,
	[datafim] [date] NULL,
PRIMARY KEY CLUSTERED 
(
	[idperfil] ASC,
	[situacaoos] ASC
)
) ON [PRIMARY];

INSERT [perfilacessosituacaoos] ([idperfil], [situacaoos], [datainicio], [datafim]) VALUES (1, 1, CAST(0x1D360B00 AS Date), NULL);
INSERT [perfilacessosituacaoos] ([idperfil], [situacaoos], [datainicio], [datafim]) VALUES (1, 2, CAST(0x1D360B00 AS Date), NULL);
INSERT [perfilacessosituacaoos] ([idperfil], [situacaoos], [datainicio], [datafim]) VALUES (1, 3, CAST(0x1D360B00 AS Date), NULL);
INSERT [perfilacessosituacaoos] ([idperfil], [situacaoos], [datainicio], [datafim]) VALUES (1, 4, CAST(0x1D360B00 AS Date), NULL);
INSERT [perfilacessosituacaoos] ([idperfil], [situacaoos], [datainicio], [datafim]) VALUES (1, 5, CAST(0x1D360B00 AS Date), NULL);
INSERT [perfilacessosituacaoos] ([idperfil], [situacaoos], [datainicio], [datafim]) VALUES (1, 6, CAST(0x1D360B00 AS Date), NULL);
INSERT [perfilacessosituacaoos] ([idperfil], [situacaoos], [datainicio], [datafim]) VALUES (1, 7, CAST(0x1D360B00 AS Date), NULL);

CREATE TABLE [perfilacessosituacaofatura](
	[idperfil] [int] NOT NULL,
	[situacaofatura] [char](1) NOT NULL,
	[datainicio] [date] NOT NULL,
	[datafim] [date] NULL,
PRIMARY KEY CLUSTERED 
(
	[idperfil] ASC,
	[situacaofatura] ASC
)
) ON [PRIMARY];

INSERT [perfilacessosituacaofatura] ([idperfil], [situacaofatura], [datainicio], [datafim]) VALUES (1, N'1', CAST(0x1D360B00 AS Date), NULL);
INSERT [perfilacessosituacaofatura] ([idperfil], [situacaofatura], [datainicio], [datafim]) VALUES (1, N'2', CAST(0x1D360B00 AS Date), NULL);
INSERT [perfilacessosituacaofatura] ([idperfil], [situacaofatura], [datainicio], [datafim]) VALUES (1, N'3', CAST(0x1D360B00 AS Date), NULL);
INSERT [perfilacessosituacaofatura] ([idperfil], [situacaofatura], [datainicio], [datafim]) VALUES (1, N'4', CAST(0x1D360B00 AS Date), NULL);
INSERT [perfilacessosituacaofatura] ([idperfil], [situacaofatura], [datainicio], [datafim]) VALUES (1, N'5', CAST(0x1D360B00 AS Date), NULL);
INSERT [perfilacessosituacaofatura] ([idperfil], [situacaofatura], [datainicio], [datafim]) VALUES (1, N'6', CAST(0x1D360B00 AS Date), NULL);
INSERT [perfilacessosituacaofatura] ([idperfil], [situacaofatura], [datainicio], [datafim]) VALUES (1, N'7', CAST(0x1D360B00 AS Date), NULL);

CREATE TABLE [perfilacessopasta](
	[idperfil] [int] NOT NULL,
	[idpasta] [int] NOT NULL,
	[datainicio] [date] NOT NULL,
	[datafim] [date] NULL,
	[aprovabaseconhecimento] [char](1) NULL,
	[permiteleitura] [char](1) NULL,
	[permiteleituragravacao] [char](1) NULL,
PRIMARY KEY CLUSTERED 
(
	[idperfil] ASC,
	[idpasta] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_PERFILPASTA] ON [perfilacessopasta] 
(
	[idpasta] ASC
)ON [PRIMARY];

INSERT [perfilacessopasta] ([idperfil], [idpasta], [datainicio], [datafim], [aprovabaseconhecimento], [permiteleitura], [permiteleituragravacao]) VALUES (1, 1, CAST(0xF2360B00 AS Date), NULL, N'S', N'N', N'S');
INSERT [perfilacessopasta] ([idperfil], [idpasta], [datainicio], [datafim], [aprovabaseconhecimento], [permiteleitura], [permiteleituragravacao]) VALUES (1, 2, CAST(0xF2360B00 AS Date), NULL, N'S', N'N', N'S');
INSERT [perfilacessopasta] ([idperfil], [idpasta], [datainicio], [datafim], [aprovabaseconhecimento], [permiteleitura], [permiteleituragravacao]) VALUES (1, 3, CAST(0xF2360B00 AS Date), NULL, N'S', N'N', N'S');
INSERT [perfilacessopasta] ([idperfil], [idpasta], [datainicio], [datafim], [aprovabaseconhecimento], [permiteleitura], [permiteleituragravacao]) VALUES (1, 4, CAST(0xF2360B00 AS Date), NULL, N'S', N'N', N'S');
INSERT [perfilacessopasta] ([idperfil], [idpasta], [datainicio], [datafim], [aprovabaseconhecimento], [permiteleitura], [permiteleituragravacao]) VALUES (2, 1, CAST(0xF2360B00 AS Date), NULL, N'N', N'S', N'N');
INSERT [perfilacessopasta] ([idperfil], [idpasta], [datainicio], [datafim], [aprovabaseconhecimento], [permiteleitura], [permiteleituragravacao]) VALUES (2, 2, CAST(0xF2360B00 AS Date), NULL, N'N', N'S', N'N');
INSERT [perfilacessopasta] ([idperfil], [idpasta], [datainicio], [datafim], [aprovabaseconhecimento], [permiteleitura], [permiteleituragravacao]) VALUES (2, 3, CAST(0xF2360B00 AS Date), NULL, N'N', N'S', N'N');
INSERT [perfilacessopasta] ([idperfil], [idpasta], [datainicio], [datafim], [aprovabaseconhecimento], [permiteleitura], [permiteleituragravacao]) VALUES (2, 4, CAST(0xF2360B00 AS Date), NULL, N'N', N'S', N'N');
INSERT [perfilacessopasta] ([idperfil], [idpasta], [datainicio], [datafim], [aprovabaseconhecimento], [permiteleitura], [permiteleituragravacao]) VALUES (3, 1, CAST(0xF2360B00 AS Date), NULL, N'S', N'N', N'S');
INSERT [perfilacessopasta] ([idperfil], [idpasta], [datainicio], [datafim], [aprovabaseconhecimento], [permiteleitura], [permiteleituragravacao]) VALUES (3, 2, CAST(0xF2360B00 AS Date), NULL, N'S', N'N', N'S');
INSERT [perfilacessopasta] ([idperfil], [idpasta], [datainicio], [datafim], [aprovabaseconhecimento], [permiteleitura], [permiteleituragravacao]) VALUES (3, 3, CAST(0xF2360B00 AS Date), NULL, N'S', N'N', N'S');
INSERT [perfilacessopasta] ([idperfil], [idpasta], [datainicio], [datafim], [aprovabaseconhecimento], [permiteleitura], [permiteleituragravacao]) VALUES (3, 4, CAST(0xF2360B00 AS Date), NULL, N'S', N'N', N'S');
INSERT [perfilacessopasta] ([idperfil], [idpasta], [datainicio], [datafim], [aprovabaseconhecimento], [permiteleitura], [permiteleituragravacao]) VALUES (4, 1, CAST(0xF2360B00 AS Date), NULL, N'N', N'S', N'N');
INSERT [perfilacessopasta] ([idperfil], [idpasta], [datainicio], [datafim], [aprovabaseconhecimento], [permiteleitura], [permiteleituragravacao]) VALUES (4, 2, CAST(0xF2360B00 AS Date), NULL, N'N', N'S', N'N');
INSERT [perfilacessopasta] ([idperfil], [idpasta], [datainicio], [datafim], [aprovabaseconhecimento], [permiteleitura], [permiteleituragravacao]) VALUES (4, 3, CAST(0xF2360B00 AS Date), NULL, N'N', N'S', N'N');
INSERT [perfilacessopasta] ([idperfil], [idpasta], [datainicio], [datafim], [aprovabaseconhecimento], [permiteleitura], [permiteleituragravacao]) VALUES (4, 4, CAST(0xF2360B00 AS Date), NULL, N'N', N'S', N'N');
INSERT [perfilacessopasta] ([idperfil], [idpasta], [datainicio], [datafim], [aprovabaseconhecimento], [permiteleitura], [permiteleituragravacao]) VALUES (5, 1, CAST(0xF2360B00 AS Date), NULL, N'S', N'N', N'S');
INSERT [perfilacessopasta] ([idperfil], [idpasta], [datainicio], [datafim], [aprovabaseconhecimento], [permiteleitura], [permiteleituragravacao]) VALUES (5, 2, CAST(0xF2360B00 AS Date), NULL, N'S', N'N', N'S');
INSERT [perfilacessopasta] ([idperfil], [idpasta], [datainicio], [datafim], [aprovabaseconhecimento], [permiteleitura], [permiteleituragravacao]) VALUES (5, 3, CAST(0xF2360B00 AS Date), NULL, N'S', N'N', N'S');
INSERT [perfilacessopasta] ([idperfil], [idpasta], [datainicio], [datafim], [aprovabaseconhecimento], [permiteleitura], [permiteleituragravacao]) VALUES (5, 4, CAST(0xF2360B00 AS Date), NULL, N'S', N'N', N'S');
INSERT [perfilacessopasta] ([idperfil], [idpasta], [datainicio], [datafim], [aprovabaseconhecimento], [permiteleitura], [permiteleituragravacao]) VALUES (6, 1, CAST(0xF2360B00 AS Date), NULL, N'N', N'S', N'N');
INSERT [perfilacessopasta] ([idperfil], [idpasta], [datainicio], [datafim], [aprovabaseconhecimento], [permiteleitura], [permiteleituragravacao]) VALUES (6, 2, CAST(0xF2360B00 AS Date), NULL, N'N', N'S', N'N');
INSERT [perfilacessopasta] ([idperfil], [idpasta], [datainicio], [datafim], [aprovabaseconhecimento], [permiteleitura], [permiteleituragravacao]) VALUES (6, 3, CAST(0xF2360B00 AS Date), NULL, N'N', N'S', N'N');
INSERT [perfilacessopasta] ([idperfil], [idpasta], [datainicio], [datafim], [aprovabaseconhecimento], [permiteleitura], [permiteleituragravacao]) VALUES (6, 4, CAST(0xF2360B00 AS Date), NULL, N'N', N'S', N'N');
INSERT [perfilacessopasta] ([idperfil], [idpasta], [datainicio], [datafim], [aprovabaseconhecimento], [permiteleitura], [permiteleituragravacao]) VALUES (7, 1, CAST(0xF2360B00 AS Date), NULL, N'N', N'S', N'N');
INSERT [perfilacessopasta] ([idperfil], [idpasta], [datainicio], [datafim], [aprovabaseconhecimento], [permiteleitura], [permiteleituragravacao]) VALUES (7, 2, CAST(0xF2360B00 AS Date), NULL, N'N', N'S', N'N');
INSERT [perfilacessopasta] ([idperfil], [idpasta], [datainicio], [datafim], [aprovabaseconhecimento], [permiteleitura], [permiteleituragravacao]) VALUES (7, 3, CAST(0xF2360B00 AS Date), NULL, N'N', N'S', N'N');
INSERT [perfilacessopasta] ([idperfil], [idpasta], [datainicio], [datafim], [aprovabaseconhecimento], [permiteleitura], [permiteleituragravacao]) VALUES (7, 4, CAST(0xF2360B00 AS Date), NULL, N'N', N'S', N'N');
INSERT [perfilacessopasta] ([idperfil], [idpasta], [datainicio], [datafim], [aprovabaseconhecimento], [permiteleitura], [permiteleituragravacao]) VALUES (15, 1, CAST(0xF2360B00 AS Date), NULL, N'N', N'S', N'N');
INSERT [perfilacessopasta] ([idperfil], [idpasta], [datainicio], [datafim], [aprovabaseconhecimento], [permiteleitura], [permiteleituragravacao]) VALUES (15, 2, CAST(0xF2360B00 AS Date), NULL, N'N', N'S', N'N');
INSERT [perfilacessopasta] ([idperfil], [idpasta], [datainicio], [datafim], [aprovabaseconhecimento], [permiteleitura], [permiteleituragravacao]) VALUES (15, 3, CAST(0xF2360B00 AS Date), NULL, N'N', N'S', N'N');
INSERT [perfilacessopasta] ([idperfil], [idpasta], [datainicio], [datafim], [aprovabaseconhecimento], [permiteleitura], [permiteleituragravacao]) VALUES (15, 4, CAST(0xF2360B00 AS Date), NULL, N'N', N'S', N'N');
INSERT [perfilacessopasta] ([idperfil], [idpasta], [datainicio], [datafim], [aprovabaseconhecimento], [permiteleitura], [permiteleituragravacao]) VALUES (18, 1, CAST(0xF2360B00 AS Date), NULL, N'N', N'S', N'N');
INSERT [perfilacessopasta] ([idperfil], [idpasta], [datainicio], [datafim], [aprovabaseconhecimento], [permiteleitura], [permiteleituragravacao]) VALUES (18, 2, CAST(0xF2360B00 AS Date), NULL, N'N', N'S', N'N');
INSERT [perfilacessopasta] ([idperfil], [idpasta], [datainicio], [datafim], [aprovabaseconhecimento], [permiteleitura], [permiteleituragravacao]) VALUES (18, 3, CAST(0xF2360B00 AS Date), NULL, N'N', N'S', N'N');
INSERT [perfilacessopasta] ([idperfil], [idpasta], [datainicio], [datafim], [aprovabaseconhecimento], [permiteleitura], [permiteleituragravacao]) VALUES (18, 4, CAST(0xF2360B00 AS Date), NULL, N'N', N'S', N'N');

CREATE TABLE [perfilacessomenu](
	[idperfilacesso] [int] NULL,
	[idmenu] [int] NULL,
	[pesquisa] [char](1) NOT NULL,
	[grava] [char](1) NOT NULL,
	[deleta] [char](1) NOT NULL,
	[datainicio] [date] NOT NULL,
	[datafim] [date] NULL
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [FK_Reference_138] ON [perfilacessomenu] 
(
	[idperfilacesso] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [FK_Reference_139] ON [perfilacessomenu] 
(
	[idmenu] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_ACESSOMENU2] ON [perfilacessomenu] 
(
	[datafim] ASC
)ON [PRIMARY];

CREATE TABLE [perfilacessogrupo](
	[idperfil] [int] NOT NULL,
	[idgrupo] [int] NOT NULL,
	[datainicio] [date] NOT NULL,
	[datafim] [date] NULL,
PRIMARY KEY CLUSTERED 
(
	[idperfil] ASC,
	[idgrupo] ASC,
	[datainicio] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_PERFILGRUPO] ON [perfilacessogrupo] 
(
	[idgrupo] ASC
)ON [PRIMARY];

INSERT [perfilacessogrupo] ([idperfil], [idgrupo], [datainicio], [datafim]) VALUES (1, 2, CAST(0x26350B00 AS Date), NULL);
INSERT [perfilacessogrupo] ([idperfil], [idgrupo], [datainicio], [datafim]) VALUES (4, 5, CAST(0x26350B00 AS Date), NULL);
INSERT [perfilacessogrupo] ([idperfil], [idgrupo], [datainicio], [datafim]) VALUES (5, 6, CAST(0x26350B00 AS Date), NULL);
INSERT [perfilacessogrupo] ([idperfil], [idgrupo], [datainicio], [datafim]) VALUES (5, 7, CAST(0x26350B00 AS Date), NULL);
INSERT [perfilacessogrupo] ([idperfil], [idgrupo], [datainicio], [datafim]) VALUES (5, 18, CAST(0x26350B00 AS Date), NULL);
INSERT [perfilacessogrupo] ([idperfil], [idgrupo], [datainicio], [datafim]) VALUES (5, 20, CAST(0x26350B00 AS Date), NULL);
INSERT [perfilacessogrupo] ([idperfil], [idgrupo], [datainicio], [datafim]) VALUES (7, 1, CAST(0x26350B00 AS Date), NULL);
INSERT [perfilacessogrupo] ([idperfil], [idgrupo], [datainicio], [datafim]) VALUES (15, 4, CAST(0x26350B00 AS Date), NULL);
INSERT [perfilacessogrupo] ([idperfil], [idgrupo], [datainicio], [datafim]) VALUES (15, 16, CAST(0x26350B00 AS Date), NULL);
INSERT [perfilacessogrupo] ([idperfil], [idgrupo], [datainicio], [datafim]) VALUES (15, 17, CAST(0x26350B00 AS Date), NULL);
INSERT [perfilacessogrupo] ([idperfil], [idgrupo], [datainicio], [datafim]) VALUES (15, 19, CAST(0x26350B00 AS Date), NULL);
INSERT [perfilacessogrupo] ([idperfil], [idgrupo], [datainicio], [datafim]) VALUES (18, 3, CAST(0x26350B00 AS Date), NULL);

CREATE TABLE [perfilacesso](
	[idperfil] [int] NOT NULL,
	[datainicio] [date] NOT NULL,
	[datafim] [date] NULL,
	[nome] [varchar](256) NOT NULL,
	[acessosistemacitsmart] [char](1) DEFAULT 'S',
PRIMARY KEY CLUSTERED 
(
	[idperfil] ASC
)
) ON [PRIMARY];

INSERT [perfilacesso] ([idperfil], [datainicio], [datafim], [nome]) VALUES (1, CAST(0x26350B00 AS Date), NULL, N'Administrador');
INSERT [perfilacesso] ([idperfil], [datainicio], [datafim], [nome]) VALUES (2, CAST(0xE0360B00 AS Date), NULL, N'Atendimento 1º NÍVEL');
INSERT [perfilacesso] ([idperfil], [datainicio], [datafim], [nome]) VALUES (3, CAST(0x26350B00 AS Date), NULL, N'Supervisão');
INSERT [perfilacesso] ([idperfil], [datainicio], [datafim], [nome]) VALUES (4, CAST(0x26350B00 AS Date), NULL, N'Qualidade');
INSERT [perfilacesso] ([idperfil], [datainicio], [datafim], [nome]) VALUES (5, CAST(0x26350B00 AS Date), NULL, N'Coordenação');
INSERT [perfilacesso] ([idperfil], [datainicio], [datafim], [nome]) VALUES (6, CAST(0x26350B00 AS Date), NULL, N'Usuário');
INSERT [perfilacesso] ([idperfil], [datainicio], [datafim], [nome]) VALUES (7, CAST(0x26350B00 AS Date), NULL, N'Desenvolvimento');
INSERT [perfilacesso] ([idperfil], [datainicio], [datafim], [nome]) VALUES (15, CAST(0x26350B00 AS Date), NULL, N'Atendimento 3º NÍVEL');
INSERT [perfilacesso] ([idperfil], [datainicio], [datafim], [nome]) VALUES (18, CAST(0x26350B00 AS Date), NULL, N'Atendimento 2º NÍVEL');

CREATE TABLE [ocorrencias](
	[idocorrencia] [int] NOT NULL,
	[iddemanda] [int] NOT NULL,
	[ocorrencia] [text] NULL,
	[tipoocorrencia] [char](1) NOT NULL,
	[respostaocorrencia] [text] NULL,
	[data] [date] NOT NULL,
	[idempregado] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[idocorrencia] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_OCORRENCIASDEMANDA] ON [ocorrencias] 
(
	[iddemanda] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_OCORRENCIASEMPREGADO] ON [ocorrencias] 
(
	[idempregado] ASC
)ON [PRIMARY];

CREATE TABLE [opiniao](
	[idopiniao] [int] NOT NULL,
	[idusuario] [int] NULL,
	[idsolicitacao] [int] NULL,
	[tipo] [varchar](50) NULL,
	[observacoes] [varchar](250) NULL,
	[data] [date] NULL,
	[hora] [datetime] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idopiniao] ASC
)
) ON [PRIMARY];

CREATE TABLE [prioridadeservicounidade](
	[idunidade] [int] NOT NULL,
	[idservicocontrato] [bigint] NOT NULL,
	[idprioridade] [bigint] NULL,
	[datainicio] [date] NOT NULL,
	[datafim] [date] NULL,
PRIMARY KEY CLUSTERED 
(
	[idunidade] ASC,
	[idservicocontrato] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_101] ON [prioridadeservicounidade] 
(
	[idservicocontrato] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_99] ON [prioridadeservicounidade] 
(
	[idprioridade] ASC
)ON [PRIMARY];

CREATE TABLE [prioridadeacordonivelservico](
	[idunidade] [int] NOT NULL,
	[idacordonivelservico] [bigint] NOT NULL,
	[idprioridade] [bigint] NULL,
	[datainicio] [date] NOT NULL,
	[datafim] [date] NULL,
PRIMARY KEY CLUSTERED 
(
	[idunidade] ASC,
	[idacordonivelservico] ASC
)
) ON [PRIMARY];

CREATE TABLE [prioridade](
	[idprioridade] [int] NOT NULL,
	[idempresa] [int] NULL,
	[nomeprioridade] [varchar](100) NOT NULL,
	[situacao] [char](1) NOT NULL,
	[grupoprioridade] [char](3) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idprioridade] ASC
)
) ON [PRIMARY];

INSERT INTO [prioridade] ([idprioridade], [idempresa], [nomeprioridade], [situacao], [grupoprioridade]) VALUES (1, 1, '1', 'A', '');
INSERT INTO [prioridade] ([idprioridade], [idempresa], [nomeprioridade], [situacao], [grupoprioridade]) VALUES (2, 1, '2', 'A', '');
INSERT INTO [prioridade] ([idprioridade], [idempresa], [nomeprioridade], [situacao], [grupoprioridade]) VALUES (3, 1, '3', 'A', '');
INSERT INTO [prioridade] ([idprioridade], [idempresa], [nomeprioridade], [situacao], [grupoprioridade]) VALUES (4, 1, '4', 'A', '');
INSERT INTO [prioridade] ([idprioridade], [idempresa], [nomeprioridade], [situacao], [grupoprioridade]) VALUES (5, 1, '5', 'A', '');

CREATE NONCLUSTERED INDEX [INDEX_PRIORIDADEEMPRESA] ON [prioridade] 
(
	[idempresa] ASC
)ON [PRIMARY];

CREATE TABLE [processamentobatch](
	[idprocessamentobatch] [int] NOT NULL,
	[descricao] [varchar](256) NULL,
	[expressaocron] [varchar](40) NOT NULL,
	[conteudo] [text] NULL,
	[tipo] [char](1) NOT NULL,
	[situacao] [char](1) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idprocessamentobatch] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

INSERT [processamentobatch] ([idprocessamentobatch], [descricao], [expressaocron], [conteudo], [tipo], [situacao]) VALUES (1, N'Execução da Rotina de Inventario', N'', N'br.com.centralit.citcorpore.quartz.job.DisparaInventario', N'C', N'A');
INSERT [processamentobatch] ([idprocessamentobatch], [descricao], [expressaocron], [conteudo], [tipo], [situacao]) VALUES (2, N'Verifica e avisa a data de expiração de um item de configuração', N'', N'br.com.centralit.citcorpore.quartz.job.VerificaValidadeLicenca', N'C', N'A');
INSERT [processamentobatch] ([idprocessamentobatch], [descricao], [expressaocron], [conteudo], [tipo], [situacao]) VALUES (3, N'Backup LogDados', N'', N'br.com.centralit.citcorpore.quartz.job.ExecutaBackupLogDados', N'C', N'A');
INSERT [processamentobatch] ([idprocessamentobatch], [descricao], [expressaocron], [conteudo], [tipo], [situacao]) VALUES (4, N'Replicar o conteÃºdo do campo descricao da tabela solicitacaoservico para o campo descricaosemformatacao', N'', N'br.com.centralit.citcorpore.quartz.job.EventoPopulaDescricaoSolicitacao', N'C', N'A');
INSERT [processamentobatch] ([idprocessamentobatch], [descricao], [expressaocron], [conteudo], [tipo], [situacao]) VALUES (5, N'Replicar o conteudo do campo conteudo da  tabela base conhecimento para o campo conteudosemformatcao', N'', N'br.com.centralit.citcorpore.quartz.job.EventoPopulaConteudoBaseConhecimento', N'C', N'A');

CREATE TABLE [procedimentotecnico](
	[idprocedimentotecnico] [int] NOT NULL,
	[nomeprocedimentotecnico] [varchar](255) NOT NULL,
	[textoprocedimentotecnico] [text] NULL,
	[datainicio] [date] NOT NULL,
	[datafim] [date] NULL,
PRIMARY KEY CLUSTERED 
(
	[idprocedimentotecnico] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE TABLE [problemamudanca](
	[idproblemamudanca] [int] NOT NULL,
	[idproblema] [int] NOT NULL,
	[idrequisicaomudanca] [int] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idproblemamudanca] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_611] ON [problemamudanca] 
(
	[idrequisicaomudanca] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_615] ON [problemamudanca] 
(
	[idproblema] ASC
)ON [PRIMARY];

CREATE TABLE [problemaitemconfiguracao](
	[idproblemaitemconfiguracao] [int] NOT NULL,
	[idproblema] [int] NOT NULL,
	[iditemconfiguracao] [int] NOT NULL,
	[descricaoproblema] [text] NULL,
PRIMARY KEY CLUSTERED 
(
	[idproblemaitemconfiguracao] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_610] ON [problemaitemconfiguracao] 
(
	[iditemconfiguracao] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_613] ON [problemaitemconfiguracao] 
(
	[idproblema] ASC
)ON [PRIMARY];

CREATE TABLE [pasta](
	[idpasta] [int] NOT NULL,
	[nome] [varchar](256) NULL,
	[datainicio] [date] NULL,
	[datafim] [date] NULL,
	[idpastapai] [int] NULL,
	[idnotificacao] [int] NULL,
	[herdapermissoes] [char](1) NULL,
PRIMARY KEY CLUSTERED 
(
	[idpasta] ASC
)
) ON [PRIMARY];

INSERT INTO [pasta] ([idpasta], [nome], [datainicio], [datafim], [idpastapai], [idnotificacao], [herdapermissoes]) VALUES (1, 'Pasta 1', NULL, NULL, NULL, NULL, NULL);
INSERT INTO [pasta] ([idpasta], [nome], [datainicio], [datafim], [idpastapai], [idnotificacao], [herdapermissoes]) VALUES (2, 'Pasta 2', NULL, NULL, NULL, NULL, NULL);

CREATE NONCLUSTERED INDEX [INDEX_PASTAPAI] ON [pasta] 
(
	[idpastapai] ASC
)ON [PRIMARY];

CREATE TABLE [requisicaoliberacaoitemconfiguracao](
	[idrequisicaoliberacaoitemconfiguracao] [int] NOT NULL,
	[idrequisicaoliberacao] [int] NULL,
	[iditemconfiguracao] [int] NULL,
	[descricao] [varchar](100) NULL,
	[idhistoricoliberacao] [int] NULL,
 CONSTRAINT [requisicaoliberacaoic_pkey] PRIMARY KEY CLUSTERED 
(
	[idrequisicaoliberacaoitemconfiguracao] ASC
)
) ON [PRIMARY];

CREATE TABLE [relacobjetonegocio](
	[idrelacobjetonegocio] [bigint] NOT NULL,
	[idobjetonegociopai] [bigint] NOT NULL,
	[idobjetonegociofilho] [bigint] NOT NULL,
	[situacao] [char](1) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idrelacobjetonegocio] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_73] ON [relacobjetonegocio] 
(
	[idobjetonegociopai] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_74] ON [relacobjetonegocio] 
(
	[idobjetonegociofilho] ASC
)ON [PRIMARY];

CREATE TABLE [reaberturasolicitacao](
	[idsolicitacaoservico] [bigint] NOT NULL,
	[seqreabertura] [int] NOT NULL,
	[idresponsavel] [int] NULL,
	[datahora] [datetime] NOT NULL,
	[observacoes] [text] NULL,
PRIMARY KEY CLUSTERED 
(
	[idsolicitacaoservico] ASC,
	[seqreabertura] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_542] ON [reaberturasolicitacao] 
(
	[idresponsavel] ASC
)ON [PRIMARY];

CREATE TABLE [questionario](
	[idquestionario] [int] NOT NULL,
	[idquestionarioorigem] [int] NULL,
	[idcategoriaquestionario] [int] NOT NULL,
	[nomequestionario] [varchar](50) NOT NULL,
	[idempresa] [int] NOT NULL,
	[ativo] [char](1) NULL,
PRIMARY KEY CLUSTERED 
(
	[idquestionario] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_QUESTIONARIOCATERIAQUESTIONARIO] ON [questionario] 
(
	[idcategoriaquestionario] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_QUESTIONARIOORIGEM] ON [questionario] 
(
	[idquestionarioorigem] ASC
)ON [PRIMARY];

CREATE TABLE [questaoquestionario](
	[idquestaoquestionario] [int] NOT NULL,
	[idgrupoquestionario] [int] NULL,
	[idquestaoagrupadora] [int] NULL,
	[idquestaocompartilhada] [int] NULL,
	[idquestaoorigem] [int] NULL,
	[tipo] [char](1) NOT NULL,
	[tituloquestaoquestionario] [text] NULL,
	[tipoquestao] [char](1) NOT NULL,
	[sexoquestao] [char](1) NOT NULL,
	[sequenciaquestao] [int] NOT NULL,
	[valordefault] [text] NULL,
	[textoinicial] [text] NULL,
	[tamanho] [int] NULL,
	[decimais] [int] NULL,
	[inforesposta] [char](1) NULL,
	[valoresreferencia] [text] NULL,
	[unidade] [text] NULL,
	[obrigatoria] [char](1) NOT NULL,
	[ponderada] [char](1) NULL,
	[qtdelinhas] [int] NULL,
	[qtdecolunas] [int] NULL,
	[cabecalholinhas] [char](1) NULL,
	[cabecalhocolunas] [char](1) NULL,
	[nomelistagem] [varchar](30) NULL,
	[ultimovalor] [char](1) NULL,
	[idsubquestionario] [int] NULL,
	[abaresultsubform] [varchar](200) NULL,
	[sigla] [varchar](100) NULL,
	[imprime] [char](1) NULL,
	[calculada] [char](1) NULL,
	[editavel] [char](1) NULL,
	[valorpermitido1] [decimal](15, 5) NULL,
	[valorpermitido2] [decimal](15, 5) NULL,
	[aplicavelcrianca] [char](1) NULL,
	[aplicavelidoso] [char](1) NULL,
	[aplicaveladulto] [char](1) NULL,
	[aplicaveladolescente] [char](1) NULL,
	[idimagem] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[idquestaoquestionario] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_QUESTAOAGRUPADORA] ON [questaoquestionario] 
(
	[idquestaoagrupadora] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_QUESTAOCOMPARTILHADA] ON [questaoquestionario] 
(
	[idquestaocompartilhada] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_QUESTAOGRUPOQUESTIONARIO] ON [questaoquestionario] 
(
	[idgrupoquestionario] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_QUESTAOIMAGEM] ON [questaoquestionario] 
(
	[idimagem] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_QUESTAOORIGEM] ON [questaoquestionario] 
(
	[idquestaoorigem] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_SUBQUESTIONARIO] ON [questaoquestionario] 
(
	[idsubquestionario] ASC
)ON [PRIMARY];

CREATE TABLE [projetos](
	[idprojeto] [int] NOT NULL,
	[idcliente] [int] NOT NULL,
	[idcontrato] [int] NULL,
	[nomeprojeto] [varchar](70) NOT NULL,
	[detalhamento] [text] NULL,
	[situacao] [char](1) NOT NULL,
	[valorestimado] [decimal](18, 3) NOT NULL,
	[idprojetopai] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[idprojeto] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_idprojetopai_idx] ON [projetos] 
(
	[idprojetopai] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_PROJETOCONTRATO] ON [projetos] 
(
	[idcontrato] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_PROJETOSCLIENTE] ON [projetos] 
(
	[idcliente] ASC
)ON [PRIMARY];

CREATE TABLE [programacaoatividade](
	[idprogramacaoatividade] [int] NOT NULL,
	[idatividadeperiodica] [int] NOT NULL,
	[tipoagendamento] [char](1) NOT NULL,
	[datainicio] [date] NOT NULL,
	[datafim] [date] NULL,
	[duracaoestimada] [int] NULL,
	[periodicidadediaria] [int] NULL,
	[periodicidadesemanal] [int] NULL,
	[periodicidademensal] [int] NULL,
	[dia] [int] NULL,
	[diautil] [int] NULL,
	[diasemana] [int] NULL,
	[seqdiasemana] [int] NULL,
	[seg] [char](1) NULL,
	[ter] [char](1) NULL,
	[qua] [char](1) NULL,
	[qui] [char](1) NULL,
	[sex] [char](1) NULL,
	[sab] [char](1) NULL,
	[dom] [char](1) NULL,
	[jan] [char](1) NULL,
	[fev] [char](1) NULL,
	[mar] [char](1) NULL,
	[abr] [char](1) NULL,
	[mai] [char](1) NULL,
	[jun] [char](1) NULL,
	[jul] [char](1) NULL,
	[ago] [char](1) NULL,
	[setem] [char](1) NULL,
	[outub] [char](1) NULL,
	[nov] [char](1) NULL,
	[dez] [char](1) NULL,
	[repeticao] [char](1) NULL,
	[repeticaointervalo] [int] NULL,
	[repeticaotipointervalo] [char](1) NULL,
	[horainicio] [char](4) NULL,
	[horafim] [char](4) NULL,
	[idatividadesos] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[idprogramacaoatividade] ASC
)
) ON [PRIMARY];

CREATE TABLE [registro](
	[idregistro] [int] NOT NULL,
	[tokenidentificacao] [varchar](20) NOT NULL,
	[datahora] [datetime] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idregistro] ASC
)
) ON [PRIMARY];

CREATE TABLE [regioes](
	[idregioes] [int] NOT NULL,
	[nome] [varchar](45) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idregioes] ASC
)
) ON [PRIMARY];

CREATE UNIQUE NONCLUSTERED INDEX [nome_UNIQUE] ON [regioes] 
(
	[nome] ASC
)ON [PRIMARY];

CREATE TABLE [scriptsvisao](
	[idscriptsvisao] [bigint] NOT NULL,
	[idvisao] [bigint] NOT NULL,
	[typeexecute] [char](1) NOT NULL,
	[scrypttype] [char](30) NOT NULL,
	[script] [text] NULL,
	[scriptlanguage] [varchar](30) NULL,
PRIMARY KEY CLUSTERED 
(
	[idscriptsvisao] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_96] ON [scriptsvisao] 
(
	[idvisao] ASC
)ON [PRIMARY];

CREATE TABLE [scripts](
	[descricao] [text] NULL,
	[datafim] [date] NULL,
	[datainicio] [date] NOT NULL,
	[historico] [text] NULL,
	[idscript] [int] NOT NULL,
	[nome] [varchar](255) NULL,
	[sqlquery] [text] NULL,
	[tipo] [varchar](10) NULL,
	[idversao] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[idscript] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE TABLE [risco](
	[idrisco] [int] NOT NULL,
	[nomerisco] [varchar](150) NOT NULL,
	[detalhamento] [text] NULL,
	[nivelrisco] [int] NULL,
	[datainicio] [date] NULL,
	[datafim] [date] NULL,
 CONSTRAINT [risco_pkey] PRIMARY KEY CLUSTERED 
(
	[idrisco] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE TABLE [revisarsla](
	[idrevisarsla] [bigint] NOT NULL,
	[idacordonivelservico] [bigint] NOT NULL,
	[datarevisao] [date] NOT NULL,
	[detalherevisao] [text] NULL,
	[observacao] [varchar](200) NULL,
	[deleted] [char](1) NULL,
PRIMARY KEY CLUSTERED 
(
	[idrevisarsla] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE TABLE [resultadosesperados](
	[idservicocontrato] [bigint] NOT NULL,
	[idacordonivelservico] [bigint] NOT NULL,
	[descricaoresultados] [varchar](1000) NULL,
	[limites] [varchar](200) NULL,
	[glosa] [varchar](200) NULL,
	[limiteglosa] [varchar](200) NULL,
	[deleted] [char](1) NULL
) ON [PRIMARY];

CREATE TABLE [respostaitemquestionarioopcoes](
	[idrespostaitemquestionario] [int] NOT NULL,
	[idopcaorespostaquestionario] [int] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idrespostaitemquestionario] ASC,
	[idopcaorespostaquestionario] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_REPOSTAOPCAORESPOSTAQUESTIONARIO] ON [respostaitemquestionarioopcoes] 
(
	[idopcaorespostaquestionario] ASC
)ON [PRIMARY];

CREATE TABLE [respostaitemquestionariocids](
	[idrespostaitemquestionariocid] [int] NOT NULL,
	[idrespostaitemquestionario] [int] NOT NULL,
	[idcid] [int] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idrespostaitemquestionariocid] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_REPOSTACID] ON [respostaitemquestionariocids] 
(
	[idcid] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_RESPOSTAITEMQUESTIONARIO] ON [respostaitemquestionariocids] 
(
	[idrespostaitemquestionario] ASC
)ON [PRIMARY];

CREATE TABLE [respostaitemquestionarioanexos](
	[idrespostaitmquestionarioanexo] [int] NOT NULL,
	[idrespostaitemquestionario] [int] NOT NULL,
	[caminhoanexo] [varchar](255) NOT NULL,
	[observacao] [text] NULL,
PRIMARY KEY CLUSTERED 
(
	[idrespostaitmquestionarioanexo] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_RESPOSTAITEMQUESTIONARIO] ON [respostaitemquestionarioanexos] 
(
	[idrespostaitemquestionario] ASC
)ON [PRIMARY];

CREATE TABLE [respostaitemquestionario](
	[idrespostaitemquestionario] [int] NOT NULL,
	[ididentificadorresposta] [int] NOT NULL,
	[idquestaoquestionario] [int] NOT NULL,
	[sequencialresposta] [int] NULL,
	[respostatextual] [text] NULL,
	[respostapercentual] [decimal](15, 5) NULL,
	[respostavalor] [decimal](15, 5) NULL,
	[respostavalor2] [decimal](15, 5) NULL,
	[respostanumero] [decimal](13, 0) NULL,
	[respostanumero2] [decimal](13, 0) NULL,
	[respostadata] [date] NULL,
	[respostahora] [varchar](4) NULL,
	[respostapressaosistolica] [smallint] NULL,
	[respostapressaodiastolica] [smallint] NULL,
	[respostames] [smallint] NULL,
	[respostaano] [smallint] NULL,
	[respostapeso] [decimal](15, 5) NULL,
	[respostaaltura] [decimal](15, 5) NULL,
	[respostaimc] [decimal](15, 5) NULL,
	[respostadum] [date] NULL,
	[respostaciclomenstrual] [smallint] NULL,
	[respostamediafaselutea] [smallint] NULL,
	[respostadpp] [date] NULL,
	[respostaidlistagem] [varchar](10) NULL,
	[idatestado] [int] NULL,
	[respostadpppeladum] [date] NULL,
	[respostadia] [smallint] NULL,
PRIMARY KEY CLUSTERED 
(
	[idrespostaitemquestionario] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_IDENTIFICADORRESPOSTA] ON [respostaitemquestionario] 
(
	[ididentificadorresposta] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_REPOSTAATESTADO] ON [respostaitemquestionario] 
(
	[idatestado] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_RESPOSTAQUESTAOQUESTIONARIO] ON [respostaitemquestionario] 
(
	[idquestaoquestionario] ASC
)ON [PRIMARY];

CREATE TABLE [responsabilidade](
	[idresponsabilidade] [int] NOT NULL,
	[idempregado] [int] NULL,
	[idcontrato] [int] NOT NULL,
	[idcontatocliente] [int] NULL,
	[idservicocontrato] [int] NULL,
	[produtoatv] [varchar](400) NOT NULL,
	[detalhamento] [text] NULL,
	[participacao] [varchar](400) NULL,
PRIMARY KEY CLUSTERED 
(
	[idresponsabilidade] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_RESPONSABILIDADECONTATOCLIENTE] ON [responsabilidade] 
(
	[idcontatocliente] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_RESPONSABILIDADECONTRATO] ON [responsabilidade] 
(
	[idcontrato] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_RESPONSABILIDADEEMPREGADO] ON [responsabilidade] 
(
	[idempregado] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_RESPONSABILIDADESERVICOCONTRATO] ON [responsabilidade] 
(
	[idservicocontrato] ASC
)ON [PRIMARY];

CREATE TABLE [servico_hist](
	[idhistoricoservico] [bigint] NOT NULL,
	[idservico] [bigint] NOT NULL,
	[idcategoriaservico] [int] NOT NULL,
	[idsituacaoservico] [int] NOT NULL,
	[idtiposervico] [int] NULL,
	[idimportancianegocio] [int] NULL,
	[idempresa] [bigint] NOT NULL,
	[idtipoeventoservico] [int] NULL,
	[idtipodemandaservico] [int] NULL,
	[idlocalexecucaoservico] [int] NULL,
	[nomeservico] [varchar](500) NOT NULL,
	[detalheservico] [text] NULL,
	[objetivo] [text] NULL,
	[passosservico] [text] NULL,
	[datainicio] [date] NULL,
	[linkprocesso] [varchar](500) NULL,
	[descricaoprocesso] [text] NULL,
	[tipodescprocess] [char](1) NULL,
	[dispportal] [char](1) NULL,
	[quadroorientportal] [text] NULL,
	[deleted] [char](1) NULL,
	[detalhesServico] [varchar](255) NULL,
	[siglaAbrev] [varchar](150) NULL,
	[idbaseconhecimento] [int] NULL,
	[idtemplatesolicitacao] [int] NULL,
	[idtemplateacompanhamento] [int] NULL,
	[criadoEm] [datetime] NOT NULL,
	[criadoPor] [varchar](255) NULL,
	[modificadoEm] [datetime] NOT NULL,
	[modificadoPor] [varchar](255) NULL,
	[conteudodados] [text] NULL,
PRIMARY KEY CLUSTERED 
(
	[idhistoricoservico] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE TABLE [situacaoservico](
	[idsituacaoservico] [int] NOT NULL,
	[idempresa] [int] NOT NULL,
	[nomesituacaoservico] [varchar](100) NOT NULL,
	[datainicio] [date] NULL,
	[datafim] [date] NULL,
PRIMARY KEY CLUSTERED 
(
	[idsituacaoservico] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_SITUACAOEMPRESA] ON [situacaoservico] 
(
	[idempresa] ASC
)ON [PRIMARY];

INSERT [situacaoservico] ([idsituacaoservico], [idempresa], [nomesituacaoservico], [datainicio], [datafim]) VALUES (-999, 1, N'Em Análise', NULL, NULL);
INSERT [situacaoservico] ([idsituacaoservico], [idempresa], [nomesituacaoservico], [datainicio], [datafim]) VALUES (1, 1, N'Ativo', NULL, NULL);
INSERT [situacaoservico] ([idsituacaoservico], [idempresa], [nomesituacaoservico], [datainicio], [datafim]) VALUES (2, 1, N'Inativo', NULL, NULL);
INSERT [situacaoservico] ([idsituacaoservico], [idempresa], [nomesituacaoservico], [datainicio], [datafim]) VALUES (3, 1, N'Em criação', NULL, NULL);
INSERT [situacaoservico] ([idsituacaoservico], [idempresa], [nomesituacaoservico], [datainicio], [datafim]) VALUES (4, 1, N'Em desenho', NULL, NULL);

CREATE TABLE [situacaodemanda](
	[idsituacaodemanda] [int] NOT NULL,
	[nomesituacao] [varchar](40) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idsituacaodemanda] ASC
)
) ON [PRIMARY];

CREATE TABLE [sistemaoperacional](
	[id] [int] NOT NULL,
	[nome] [varchar](255) NULL,
PRIMARY KEY CLUSTERED 
(
	[id] ASC
)
) ON [PRIMARY];

CREATE TABLE [servicos](
	[idservico] [int] NOT NULL,
	[nomeServico] [varchar](255) NULL,
	[detalhesServico] [varchar](255) NULL,
	[objetivo] [varchar](255) NULL,
	[passosServico] [varchar](255) NULL,
	[dataInicio] [varchar](255) NULL,
	[linkProcesso] [varchar](255) NULL,
	[descricaoProcesso] [varchar](255) NULL,
	[tipoDescProcess] [varchar](255) NULL,
	[dispPortal] [varchar](255) NULL,
	[quadroOrientPortal] [varchar](255) NULL,
	[deleted] [varchar](255) NULL,
PRIMARY KEY CLUSTERED 
(
	[idservico] ASC
)
) ON [PRIMARY];

CREATE TABLE [servicocontrato](
	[idservicocontrato] [bigint] NOT NULL,
	[idservico] [bigint] NOT NULL,
	[idcontrato] [int] NOT NULL,
	[idcondicaooperacao] [int] NULL,
	[datainicio] [date] NOT NULL,
	[datafim] [date] NULL,
	[observacao] [text] NULL,
	[custo] [decimal](18, 3) NULL,
	[restricoespressup] [text] NULL,
	[objetivo] [text] NULL,
	[permiteslanocadinc] [char](1) NULL,
	[linkprocesso] [varchar](500) NULL,
	[descricaoprocesso] [text] NULL,
	[tipodescprocess] [char](1) NULL,
	[deleted] [char](1) NULL,
	[arearequisitante] [varchar](150) NULL,
	[idgruponivel1] [int] NULL,
	[idModeloEmailCriacao] [int] NULL,
	[idModeloEmailFinalizacao] [int] NULL,
	[idModeloEmailAcoes] [int] NULL,
	[idgrupoexecutor] [int] NULL,
	[idcalendario] [int] NULL,
	[permSLATempoACombinar] [char](1) NULL,
	[permMudancaSLA] [char](1) NULL,
	[permMudancaCalendario] [char](1) NULL,
	[idgrupoaprovador] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[idservicocontrato] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_38] ON [servicocontrato] 
(
	[idcondicaooperacao] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_40] ON [servicocontrato] 
(
	[idservico] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_41] ON [servicocontrato] 
(
	[idcontrato] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_546] ON [servicocontrato] 
(
	[idgruponivel1] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_547] ON [servicocontrato] 
(
	[idModeloEmailCriacao] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_548] ON [servicocontrato] 
(
	[idModeloEmailFinalizacao] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_549] ON [servicocontrato] 
(
	[idModeloEmailAcoes] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_559] ON [servicocontrato] 
(
	[idgrupoexecutor] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_560] ON [servicocontrato] 
(
	[idcalendario] ASC
)ON [PRIMARY];

INSERT [servicocontrato] ([idservicocontrato], [idservico], [idcontrato], [idcondicaooperacao], [datainicio], [datafim], [observacao], [custo], [restricoespressup], [objetivo], [permiteslanocadinc], [linkprocesso], [descricaoprocesso], [tipodescprocess], [deleted], [arearequisitante], [idgruponivel1], [idModeloEmailCriacao], [idModeloEmailFinalizacao], [idModeloEmailAcoes], [idgrupoexecutor], [idcalendario], [permSLATempoACombinar], [permMudancaSLA], [permMudancaCalendario], [idgrupoaprovador]) VALUES (1, 1, 1, 2, CAST(0xEE360B00 AS Date), NULL, N'', NULL, N'', N'', NULL, N'', N'', NULL, NULL, N'', NULL, 17, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL);
INSERT [servicocontrato] ([idservicocontrato], [idservico], [idcontrato], [idcondicaooperacao], [datainicio], [datafim], [observacao], [custo], [restricoespressup], [objetivo], [permiteslanocadinc], [linkprocesso], [descricaoprocesso], [tipodescprocess], [deleted], [arearequisitante], [idgruponivel1], [idModeloEmailCriacao], [idModeloEmailFinalizacao], [idModeloEmailAcoes], [idgrupoexecutor], [idcalendario], [permSLATempoACombinar], [permMudancaSLA], [permMudancaCalendario], [idgrupoaprovador]) VALUES (2, 2, 1, 2, CAST(0xEE360B00 AS Date), NULL, N'', NULL, N'', N'', NULL, N'', N'', NULL, NULL, N'', 2, 17, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL);
INSERT [servicocontrato] ([idservicocontrato], [idservico], [idcontrato], [idcondicaooperacao], [datainicio], [datafim], [observacao], [custo], [restricoespressup], [objetivo], [permiteslanocadinc], [linkprocesso], [descricaoprocesso], [tipodescprocess], [deleted], [arearequisitante], [idgruponivel1], [idModeloEmailCriacao], [idModeloEmailFinalizacao], [idModeloEmailAcoes], [idgrupoexecutor], [idcalendario], [permSLATempoACombinar], [permMudancaSLA], [permMudancaCalendario], [idgrupoaprovador]) VALUES (3, 3, 1, 2, CAST(0xEE360B00 AS Date), NULL, N'', NULL, N'', N'', NULL, N'', N'', NULL, NULL, N'', 2, 17, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL);
INSERT [servicocontrato] ([idservicocontrato], [idservico], [idcontrato], [idcondicaooperacao], [datainicio], [datafim], [observacao], [custo], [restricoespressup], [objetivo], [permiteslanocadinc], [linkprocesso], [descricaoprocesso], [tipodescprocess], [deleted], [arearequisitante], [idgruponivel1], [idModeloEmailCriacao], [idModeloEmailFinalizacao], [idModeloEmailAcoes], [idgrupoexecutor], [idcalendario], [permSLATempoACombinar], [permMudancaSLA], [permMudancaCalendario], [idgrupoaprovador]) VALUES (4, 4, 1, 2, CAST(0xEE360B00 AS Date), NULL, N'', NULL, N'', N'', NULL, N'', N'', NULL, NULL, N'', 2, 17, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL);
INSERT [servicocontrato] ([idservicocontrato], [idservico], [idcontrato], [idcondicaooperacao], [datainicio], [datafim], [observacao], [custo], [restricoespressup], [objetivo], [permiteslanocadinc], [linkprocesso], [descricaoprocesso], [tipodescprocess], [deleted], [arearequisitante], [idgruponivel1], [idModeloEmailCriacao], [idModeloEmailFinalizacao], [idModeloEmailAcoes], [idgrupoexecutor], [idcalendario], [permSLATempoACombinar], [permMudancaSLA], [permMudancaCalendario], [idgrupoaprovador]) VALUES (5, 5, 1, 2, CAST(0xEE360B00 AS Date), NULL, N'', NULL, N'', N'', NULL, N'', N'', NULL, NULL, N'', 2, 17, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL);

CREATE TRIGGER [servico_hist_setCurrentTime] ON  [servico_hist]
FOR UPDATE
AS
BEGIN
	SET NOCOUNT ON; 
	UPDATE tbl
	SET criadoEm = GETDATE()
	FROM servico_hist AS tbl
	INNER JOIN inserted AS i
		ON tbl.idhistoricoservico = i.idhistoricoservico; 
END;

CREATE TABLE [requisitosla](
	[idrequisitosla] [int] NOT NULL,
	[idempregado] [int] NULL,
	[requisitadoem] [date] NULL,
	[assunto] [varchar](200) NOT NULL,
	[detalhamento] [text] NULL,
	[situacao] [char](1) NOT NULL,
	[criadopor] [varchar](255) NULL,
	[criadoem] [datetime] NOT NULL,
	[modificadopor] [varchar](255) NULL,
	[modificadoem] [datetime] NOT NULL,
	[deleted] [char](1) NULL,
PRIMARY KEY CLUSTERED 
(
	[idrequisitosla] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_552] ON [requisitosla] 
(
	[idempregado] ASC
)ON [PRIMARY];

CREATE TABLE [requisicaoproduto](
	[idsolicitacaoservico] [int] NOT NULL,
	[idprojeto] [int] NULL,
	[idcentrocusto] [int] NULL,
	[idenderecoentrega] [int] NULL,
	[finalidade] [char](1) NOT NULL,
	[rejeitada] [char](1) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idsolicitacaoservico] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_626] ON [requisicaoproduto] 
(
	[idprojeto] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_628] ON [requisicaoproduto] 
(
	[idenderecoentrega] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_646] ON [requisicaoproduto] 
(
	[idcentrocusto] ASC
)ON [PRIMARY];

CREATE TABLE [servico](
	[idservico] [bigint] NOT NULL,
	[idcategoriaservico] [int] NOT NULL,
	[idsituacaoservico] [int] NOT NULL,
	[idtiposervico] [int] NULL,
	[idimportancianegocio] [int] NULL,
	[idempresa] [bigint] NOT NULL,
	[idtipoeventoservico] [int] NULL,
	[idtipodemandaservico] [int] NULL,
	[idlocalexecucaoservico] [int] NULL,
	[nomeservico] [varchar](500) NOT NULL,
	[detalheservico] [text] NULL,
	[objetivo] [text] NULL,
	[passosservico] [text] NULL,
	[datainicio] [date] NULL,
	[linkprocesso] [varchar](500) NULL,
	[descricaoprocesso] [text] NULL,
	[tipodescprocess] [char](1) NULL,
	[dispportal] [char](1) NULL,
	[quadroorientportal] [text] NULL,
	[deleted] [char](1) NULL,
	[detalhesServico] [varchar](255) NULL,
	[siglaAbrev] [varchar](150) NULL,
	[idbaseconhecimento] [int] NULL,
	[idtemplatesolicitacao] [int] NULL,
	[idtemplateacompanhamento] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[idservico] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_124] ON [servico] 
(
	[idtipoeventoservico] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_125] ON [servico] 
(
	[idtipodemandaservico] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_126] ON [servico] 
(
	[idlocalexecucaoservico] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_34] ON [servico] 
(
	[idcategoriaservico] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_35] ON [servico] 
(
	[idsituacaoservico] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_36] ON [servico] 
(
	[idtiposervico] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_37] ON [servico] 
(
	[idimportancianegocio] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_42] ON [servico] 
(
	[idempresa] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_567] ON [servico] 
(
	[idbaseconhecimento] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_642] ON [servico] 
(
	[idtemplateacompanhamento] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [FK7643C6BFC4080A57] ON [servico] 
(
	[idcategoriaservico] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [FK7643C6BFC86EB082] ON [servico] 
(
	[idcategoriaservico] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [idtemplatesolicitacao] ON [servico] 
(
	[idtemplatesolicitacao] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [index_nome] ON [servico] 
(
	[nomeservico] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [index_servico_idcatservico] ON [servico] 
(
	[idcategoriaservico] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [index_servico_idsitservico] ON [servico] 
(
	[idsituacaoservico] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [index_servico_idtiposervico] ON [servico] 
(
	[idtiposervico] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [index_servico_nomeservico] ON [servico] 
(
	[nomeservico] ASC
)ON [PRIMARY];

INSERT [dbo].[servico] ([idservico], [idcategoriaservico], [idsituacaoservico], [idtiposervico], [idimportancianegocio], [idempresa], [idtipoeventoservico], [idtipodemandaservico], [idlocalexecucaoservico], [nomeservico], [detalheservico], [objetivo], [passosservico], [datainicio], [linkprocesso], [descricaoprocesso], [tipodescprocess], [dispportal], [quadroorientportal], [deleted], [detalhesServico], [siglaAbrev], [idbaseconhecimento], [idtemplatesolicitacao], [idtemplateacompanhamento]) VALUES (1, 1, 1, 1, 10, 1, 33, 3, 4, N'Serviço 1', N'Descrição do Serviço 1', N'', NULL, CAST('2013-04-05 13:40:00' AS DateTime), N'', N'', NULL, N'S', NULL, NULL, NULL, N'', NULL, NULL, NULL);
INSERT [dbo].[servico] ([idservico], [idcategoriaservico], [idsituacaoservico], [idtiposervico], [idimportancianegocio], [idempresa], [idtipoeventoservico], [idtipodemandaservico], [idlocalexecucaoservico], [nomeservico], [detalheservico], [objetivo], [passosservico], [datainicio], [linkprocesso], [descricaoprocesso], [tipodescprocess], [dispportal], [quadroorientportal], [deleted], [detalhesServico], [siglaAbrev], [idbaseconhecimento], [idtemplatesolicitacao], [idtemplateacompanhamento]) VALUES (2, 1, 1, 1, 10, 1, 33, 3, 4, N'Serviço 2', N'Descrição do Serviço 2', N'', NULL, CAST('2013-04-05 13:40:00' AS DateTime), N'', N'', NULL, N'S', NULL, NULL, NULL, N'', NULL, NULL, NULL);
INSERT [dbo].[servico] ([idservico], [idcategoriaservico], [idsituacaoservico], [idtiposervico], [idimportancianegocio], [idempresa], [idtipoeventoservico], [idtipodemandaservico], [idlocalexecucaoservico], [nomeservico], [detalheservico], [objetivo], [passosservico], [datainicio], [linkprocesso], [descricaoprocesso], [tipodescprocess], [dispportal], [quadroorientportal], [deleted], [detalhesServico], [siglaAbrev], [idbaseconhecimento], [idtemplatesolicitacao], [idtemplateacompanhamento]) VALUES (3, 1, 1, 1, 10, 1, 33, 3, 4, N'Serviço 3', N'Descrição do Serviço 3', N'', NULL, CAST('2013-04-05 13:40:00' AS DateTime), N'', N'', NULL, N'S', NULL, NULL, NULL, N'', NULL, NULL, NULL);
INSERT [dbo].[servico] ([idservico], [idcategoriaservico], [idsituacaoservico], [idtiposervico], [idimportancianegocio], [idempresa], [idtipoeventoservico], [idtipodemandaservico], [idlocalexecucaoservico], [nomeservico], [detalheservico], [objetivo], [passosservico], [datainicio], [linkprocesso], [descricaoprocesso], [tipodescprocess], [dispportal], [quadroorientportal], [deleted], [detalhesServico], [siglaAbrev], [idbaseconhecimento], [idtemplatesolicitacao], [idtemplateacompanhamento]) VALUES (4, 1, 1, 1, 10, 1, 33, 1, 4, N'Serviço 4', N'Descrição do Serviço 4', N'', NULL, CAST('2013-04-05 13:40:00' AS DateTime), N'', N'', NULL, N'S', NULL, NULL, NULL, N'', NULL, NULL, NULL);
INSERT [dbo].[servico] ([idservico], [idcategoriaservico], [idsituacaoservico], [idtiposervico], [idimportancianegocio], [idempresa], [idtipoeventoservico], [idtipodemandaservico], [idlocalexecucaoservico], [nomeservico], [detalheservico], [objetivo], [passosservico], [datainicio], [linkprocesso], [descricaoprocesso], [tipodescprocess], [dispportal], [quadroorientportal], [deleted], [detalhesServico], [siglaAbrev], [idbaseconhecimento], [idtemplatesolicitacao], [idtemplateacompanhamento]) VALUES (5, 1, 1, 1, 10, 1, 33, 1, 4, N'Serviço 5', N'Descrição do Serviço 5', N'', NULL, CAST('2013-04-05 13:40:00' AS DateTime), N'', N'', NULL, N'S', NULL, NULL, NULL, N'', NULL, NULL, NULL);

CREATE TABLE [recurso](
	[idrecurso] [int] NOT NULL,
	[idgruporecurso] [int] NOT NULL,
	[idrecursopai] [int] NULL,
	[nomerecurso] [varchar](150) NOT NULL,
	[datainicio] [date] NOT NULL,
	[datafim] [date] NULL,
	[tipoatualizacao] [char](1) NOT NULL,
	[deleted] [char](1) NULL,
	[idnagiosconexao] [int] NULL,
	[hostName] [varchar](255) NULL,
	[serviceName] [varchar](255) NULL,
	[horaInicioFunc] [varchar](5) NULL,
	[horaFimFunc] [varchar](5) NULL,
	[idCalendario] [int] NULL,
	[statusaberturainc] [varchar](255) NULL,
	[idsolicitante] [int] NULL,
	[emailaberturainc] [varchar](255) NULL,
	[descricaoabertinc] [text] NULL,
	[impacto] [char](1) NULL,
	[urgencia] [char](1) NULL,
	[idgrupo] [int] NULL,
	[idorigem] [bigint] NULL,
	[idservicocontrato] [bigint] NULL,
	[ideventomonitoramento] [int] NULL,
	[iditemconfiguracao] [int] NULL,
	[statusalerta] [varchar](255) NULL,
	[emailsalerta] [text] NULL,
	[descricaoalerta] [text] NULL,
PRIMARY KEY CLUSTERED 
(
	[idrecurso] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_ref_evt_rec] ON [recurso] 
(
	[ideventomonitoramento] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_ref_grp_rec] ON [recurso] 
(
	[idgrupo] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_ref_grprec] ON [recurso] 
(
	[idgruporecurso] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_ref_ic_rec] ON [recurso] 
(
	[iditemconfiguracao] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_ref_orig_rec] ON [recurso] 
(
	[idorigem] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_ref_rec_calend] ON [recurso] 
(
	[idCalendario] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_ref_rec_nagios] ON [recurso] 
(
	[idnagiosconexao] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_ref_sc_rec] ON [recurso] 
(
	[idservicocontrato] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_ref_solic_rec] ON [recurso] 
(
	[idsolicitante] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_605] ON [recurso] 
(
	[idrecursopai] ASC
)ON [PRIMARY];

CREATE TABLE [solicitacaoservicoevtmon](
	[idsolicitacaoservico] [bigint] NOT NULL,
	[ideventomonitoramento] [int] NOT NULL,
	[idrecurso] [int] NULL,
	[nomehost] [varchar](255) NULL,
	[nomeservice] [varchar](255) NULL,
	[infoadd] [text] NULL,
PRIMARY KEY CLUSTERED 
(
	[idsolicitacaoservico] ASC,
	[ideventomonitoramento] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_ref_evtmon] ON [solicitacaoservicoevtmon] 
(
	[ideventomonitoramento] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_ref_recevtmon] ON [solicitacaoservicoevtmon] 
(
	[idrecurso] ASC
)ON [PRIMARY];

CREATE TRIGGER [reaberturasolicitacao_setCurrentTime] ON  [reaberturasolicitacao]
FOR UPDATE
AS
BEGIN
	SET NOCOUNT ON; 
	UPDATE tbl
	SET datahora = GETDATE()
	FROM reaberturasolicitacao AS tbl
	INNER JOIN inserted AS i
		ON tbl.idsolicitacaoservico = i.idsolicitacaoservico; 
END;

CREATE TABLE [post](
	[idPost] [int] NOT NULL,
	[titulo] [varchar](255) NULL,
	[descricao] [text] NULL,
	[conteudo] [text] NULL,
	[imagem] [varchar](255) NULL,
	[idCategoriaPost] [int] NULL,
	[dataInicio] [date] NULL,
	[dataFim] [date] NULL,
PRIMARY KEY CLUSTERED 
(
	[idPost] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_post_1_idx] ON [post] 
(
	[idCategoriaPost] ASC
)ON [PRIMARY];

CREATE TRIGGER [portal_setCurrentTime] ON  [portal]
FOR UPDATE
AS
BEGIN
	SET NOCOUNT ON; 
	UPDATE tbl
	SET hora = GETDATE()
	FROM portal AS tbl
	INNER JOIN inserted AS i
		ON tbl.idportal = i.idportal; 
END;

CREATE TABLE [ocorrenciasolicitacao](
	[idocorrencia] [int] NOT NULL,
	[idjustificativa] [int] NULL,
	[idsolicitacaoservico] [bigint] NULL,
	[iditemtrabalho] [bigint] NULL,
	[dataregistro] [date] NULL,
	[horaregistro] [varchar](5) NULL,
	[registradopor] [varchar](100) NULL,
	[descricao] [varchar](500) NULL,
	[datainicio] [date] NULL,
	[datafim] [date] NULL,
	[complementojustificativa] [text] NULL,
	[dadossolicitacao] [text] NULL,
	[informacoescontato] [text] NULL,
	[categoria] [varchar](20) NULL,
	[origem] [char](1) NULL,
	[tempogasto] [smallint] NULL,
	[ocorrencia] [text] NULL,
	[idcategoriaocorrencia] [int] NULL,
	[idorigemocorrencia] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[idocorrencia] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_562] ON [ocorrenciasolicitacao] 
(
	[idjustificativa] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_564] ON [ocorrenciasolicitacao] 
(
	[idsolicitacaoservico] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_565] ON [ocorrenciasolicitacao] 
(
	[iditemtrabalho] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [idcategoriaocorrencia] ON [ocorrenciasolicitacao] 
(
	[idcategoriaocorrencia] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [idorigemocorrencia] ON [ocorrenciasolicitacao] 
(
	[idorigemocorrencia] ASC
)ON [PRIMARY];

INSERT [ocorrenciasolicitacao] ([idocorrencia], [idjustificativa], [idsolicitacaoservico], [iditemtrabalho], [dataregistro], [horaregistro], [registradopor], [descricao], [datainicio], [datafim], [complementojustificativa], [dadossolicitacao], [informacoescontato], [categoria], [origem], [tempogasto], [ocorrencia], [idcategoriaocorrencia], [idorigemocorrencia]) VALUES (1, NULL, 1, NULL, CAST(0xF2360B00 AS Date), N'09:40', N'Consultor', N'Registro da Solicitação', CAST(0xF2360B00 AS Date), CAST(0xF2360B00 AS Date), NULL, N'{\"idSolicitacaoServico\":1,\"idContatoSolicitacaoServico\":1,\"idServicoContrato\":1,\"idSolicitante\":2,\"idOrigem\":1,\"idPrioridade\":5,\"filtroADPesq\":\"\",\"idUnidade\":1,\"dataHoraSolicitacao\":\"Apr 5, 2013 9:40:01 AM\",\"prazoCapturaHH\":0,\"prazoCapturaMM\":0,\"prazoHH\":0,\"prazoMM\":0,\"descricao\":\"Descri\\u0026ccedil;\\u0026atilde;o do Incidente ou Requisi\\u0026ccedil;\\u0026atilde;o\\u003cbr /\\u003e\",\"resposta\":\"\",\"dataHoraInicio\":\"Apr 5, 2013 9:40:01 AM\",\"situacao\":\"EmAndamento\",\"seqReabertura\":0,\"enviaEmailCriacao\":\"S\",\"enviaEmailFinalizacao\":\"S\",\"slaACombinar\":\"S\",\"idCalendario\":1,\"tempoDecorridoHH\":0,\"tempoDecorridoMM\":0,\"situacaoSLA\":\"N\",\"descrSituacao\":\"Em andamento\",\"atrasoSLA\":0.0,\"idContrato\":1,\"solicitante\":\"Default\",\"dataHoraSolicitacaoStr\":\"05/04/2013 09:40\",\"usuarioDto\":{\"idUsuario\":3,\"idEmpregado\":3,\"idPerfilAcessoUsuario\":1,\"idEmpresa\":1,\"login\":\"consultor\",\"nomeUsuario\":\"Consultor\",\"status\":\"A\",\"grupos\":[\"SDNIVEL1\",\"SDNIVEL2\",\"SDNIVEL3Apli\",\"SDNIVEL3Infra\",\"SDNIVEL3Sist\",\"SDNIVEL3Telefonia\"],\"locale\":\"\",\"colGrupos\":[{\"idGrupo\":2,\"nome\":\"1º NÍVEL\",\"sigla\":\"SDNIVEL1\",\"serviceDesk\":\"S\"},{\"idGrupo\":3,\"nome\":\"2º NÍVEL\",\"sigla\":\"SDNIVEL2\",\"serviceDesk\":\"S\"},{\"idGrupo\":16,\"nome\":\"3º NÍVEL - Aplicação\",\"sigla\":\"SDNIVEL3Apli\",\"serviceDesk\":\"S\"},{\"idGrupo\":4,\"nome\":\"3º NÍVEL - Infraestrutura\",\"sigla\":\"SDNIVEL3Infra\",\"serviceDesk\":\"S\"},{\"idGrupo\":17,\"nome\":\"3º NÍVEL - Sistemas\",\"sigla\":\"SDNIVEL3Sist\",\"serviceDesk\":\"S\"},{\"idGrupo\":19,\"nome\":\"3º NÍVEL - Telefonia\",\"sigla\":\"SDNIVEL3Telefonia\",\"serviceDesk\":\"N\"}]},\"acaoFluxo\":\"\",\"idTipoDemandaServico\":3,\"idServico\":1,\"itemConfiguracao\":\"\",\"messageId\":\"\",\"nomecontato\":\"Default\",\"telefonecontato\":\"3242-4433\",\"emailcontato\":\"citsmart_instalador_mysql@centralit.com.br\",\"observacao\":\"\",\"reclassificar\":\"\",\"escalar\":\"\",\"alterarSituacao\":\"\",\"detalhamentoCausa\":\"\",\"solucaoTemporaria\":\"N\",\"nomeServico\":\"Serviço 1\",\"ramal\":\"\",\"idAcordoNivelServico\":1,\"registradoPor\":\"Consultor\",\"registroexecucao\":\"\",\"impacto\":\"B\",\"urgencia\":\"B\",\"descricaoSemFormatacao\":\"Descrição do Incidente ou Requisição\",\"idResponsavel\":3,\"idGrupoAtual\":2,\"idGrupoNivel1\":2}', N'{\"idcontatosolicitacaoservico\":1,\"nomecontato\":\"Default\",\"telefonecontato\":\"3242-4433\",\"emailcontato\":\"citsmart_instalador_mysql@centralit.com.br\",\"observacao\":\"\"}', N'Criacao', N'O', 0, NULL, NULL, NULL);
INSERT [ocorrenciasolicitacao] ([idocorrencia], [idjustificativa], [idsolicitacaoservico], [iditemtrabalho], [dataregistro], [horaregistro], [registradopor], [descricao], [datainicio], [datafim], [complementojustificativa], [dadossolicitacao], [informacoescontato], [categoria], [origem], [tempogasto], [ocorrencia], [idcategoriaocorrencia], [idorigemocorrencia]) VALUES (2, NULL, 1, NULL, CAST(0xF2360B00 AS Date), N'09:40', N'AutomÃ¡tico', N'Inicio do SLA', CAST(0xF2360B00 AS Date), CAST(0xF2360B00 AS Date), NULL, N'{\"idSolicitacaoServico\":1,\"idContatoSolicitacaoServico\":1,\"idServicoContrato\":1,\"idSolicitante\":2,\"idOrigem\":1,\"idPrioridade\":5,\"filtroADPesq\":\"\",\"idUnidade\":1,\"idFaseAtual\":2,\"dataHoraSolicitacao\":\"Apr 5, 2013 9:40:01 AM\",\"prazoCapturaHH\":0,\"prazoCapturaMM\":0,\"prazoHH\":0,\"prazoMM\":0,\"descricao\":\"Descri\\u0026ccedil;\\u0026atilde;o do Incidente ou Requisi\\u0026ccedil;\\u0026atilde;o\\u003cbr /\\u003e\",\"resposta\":\"\",\"dataHoraInicio\":\"Apr 5, 2013 9:40:01 AM\",\"situacao\":\"EmAndamento\",\"seqReabertura\":0,\"enviaEmailCriacao\":\"S\",\"enviaEmailFinalizacao\":\"S\",\"slaACombinar\":\"S\",\"idCalendario\":1,\"tempoDecorridoHH\":0,\"tempoDecorridoMM\":0,\"situacaoSLA\":\"A\",\"dataHoraInicioSLA\":\"Apr 5, 2013 9:40:01 AM\",\"descrSituacao\":\"Em andamento\",\"dataHoraLimite\":\"Apr 5, 2013 9:40:00 AM\",\"dataHoraLimiteStr\":\"05/04/2013 09:40\",\"dataHoraInicioSLAStr\":\"05/04/2013 09:40:01\",\"atrasoSLA\":0.0,\"idContrato\":1,\"solicitante\":\"Default\",\"dataHoraSolicitacaoStr\":\"05/04/2013 09:40\",\"usuarioDto\":{\"idUsuario\":3,\"idEmpregado\":3,\"idPerfilAcessoUsuario\":1,\"idEmpresa\":1,\"login\":\"consultor\",\"nomeUsuario\":\"Consultor\",\"status\":\"A\",\"grupos\":[\"SDNIVEL1\",\"SDNIVEL2\",\"SDNIVEL3Apli\",\"SDNIVEL3Infra\",\"SDNIVEL3Sist\",\"SDNIVEL3Telefonia\"],\"locale\":\"\",\"colGrupos\":[{\"idGrupo\":2,\"nome\":\"1º NÍVEL\",\"sigla\":\"SDNIVEL1\",\"serviceDesk\":\"S\"},{\"idGrupo\":3,\"nome\":\"2º NÍVEL\",\"sigla\":\"SDNIVEL2\",\"serviceDesk\":\"S\"},{\"idGrupo\":16,\"nome\":\"3º NÍVEL - Aplicação\",\"sigla\":\"SDNIVEL3Apli\",\"serviceDesk\":\"S\"},{\"idGrupo\":4,\"nome\":\"3º NÍVEL - Infraestrutura\",\"sigla\":\"SDNIVEL3Infra\",\"serviceDesk\":\"S\"},{\"idGrupo\":17,\"nome\":\"3º NÍVEL - Sistemas\",\"sigla\":\"SDNIVEL3Sist\",\"serviceDesk\":\"S\"},{\"idGrupo\":19,\"nome\":\"3º NÍVEL - Telefonia\",\"sigla\":\"SDNIVEL3Telefonia\",\"serviceDesk\":\"N\"}]},\"grupoAtual\":\"SDNIVEL1\",\"grupoNivel1\":\"SDNIVEL1\",\"acaoFluxo\":\"\",\"idTipoDemandaServico\":3,\"idServico\":1,\"itemConfiguracao\":\"\",\"messageId\":\"\",\"nomecontato\":\"Default\",\"telefonecontato\":\"3242-4433\",\"emailcontato\":\"citsmart_instalador_mysql@centralit.com.br\",\"observacao\":\"\",\"reclassificar\":\"\",\"escalar\":\"\",\"alterarSituacao\":\"\",\"detalhamentoCausa\":\"\",\"solucaoTemporaria\":\"N\",\"nomeServico\":\"Serviço 1\",\"ramal\":\"\",\"idAcordoNivelServico\":1,\"registradoPor\":\"Consultor\",\"registroexecucao\":\"\",\"impacto\":\"B\",\"urgencia\":\"B\",\"descricaoSemFormatacao\":\"Descrição do Incidente ou Requisição\",\"idResponsavel\":3,\"idGrupoAtual\":2,\"idGrupoNivel1\":2}', NULL, N'InicioSLA', N'O', 0, NULL, NULL, NULL);
INSERT [ocorrenciasolicitacao] ([idocorrencia], [idjustificativa], [idsolicitacaoservico], [iditemtrabalho], [dataregistro], [horaregistro], [registradopor], [descricao], [datainicio], [datafim], [complementojustificativa], [dadossolicitacao], [informacoescontato], [categoria], [origem], [tempogasto], [ocorrencia], [idcategoriaocorrencia], [idorigemocorrencia]) VALUES (3, NULL, 2, NULL, CAST(0xF2360B00 AS Date), N'09:43', N'Consultor', N'Registro da Solicitação', CAST(0xF2360B00 AS Date), CAST(0xF2360B00 AS Date), NULL, N'{\"idSolicitacaoServico\":2,\"idContatoSolicitacaoServico\":2,\"idServicoContrato\":4,\"idSolicitante\":2,\"idOrigem\":1,\"idPrioridade\":5,\"filtroADPesq\":\"\",\"idUnidade\":1,\"dataHoraSolicitacao\":\"Apr 5, 2013 9:43:39 AM\",\"prazoCapturaHH\":0,\"prazoCapturaMM\":0,\"prazoHH\":0,\"prazoMM\":0,\"descricao\":\"Descri\\u0026ccedil;\\u0026atilde;o do Incidente ou Requisi\\u0026ccedil;\\u0026atilde;o\",\"resposta\":\"\",\"dataHoraInicio\":\"Apr 5, 2013 9:43:39 AM\",\"situacao\":\"EmAndamento\",\"seqReabertura\":0,\"enviaEmailCriacao\":\"S\",\"enviaEmailFinalizacao\":\"S\",\"slaACombinar\":\"S\",\"idCalendario\":1,\"tempoDecorridoHH\":0,\"tempoDecorridoMM\":0,\"situacaoSLA\":\"N\",\"descrSituacao\":\"Em andamento\",\"atrasoSLA\":0.0,\"idContrato\":1,\"solicitante\":\"Default\",\"dataHoraSolicitacaoStr\":\"05/04/2013 09:43\",\"usuarioDto\":{\"idUsuario\":3,\"idEmpregado\":3,\"idPerfilAcessoUsuario\":1,\"idEmpresa\":1,\"login\":\"consultor\",\"nomeUsuario\":\"Consultor\",\"status\":\"A\",\"grupos\":[\"SDNIVEL1\",\"SDNIVEL2\",\"SDNIVEL3Apli\",\"SDNIVEL3Infra\",\"SDNIVEL3Sist\",\"SDNIVEL3Telefonia\"],\"locale\":\"\",\"colGrupos\":[{\"idGrupo\":2,\"nome\":\"1º NÍVEL\",\"sigla\":\"SDNIVEL1\",\"serviceDesk\":\"S\"},{\"idGrupo\":3,\"nome\":\"2º NÍVEL\",\"sigla\":\"SDNIVEL2\",\"serviceDesk\":\"S\"},{\"idGrupo\":16,\"nome\":\"3º NÍVEL - Aplicação\",\"sigla\":\"SDNIVEL3Apli\",\"serviceDesk\":\"S\"},{\"idGrupo\":4,\"nome\":\"3º NÍVEL - Infraestrutura\",\"sigla\":\"SDNIVEL3Infra\",\"serviceDesk\":\"S\"},{\"idGrupo\":17,\"nome\":\"3º NÍVEL - Sistemas\",\"sigla\":\"SDNIVEL3Sist\",\"serviceDesk\":\"S\"},{\"idGrupo\":19,\"nome\":\"3º NÍVEL - Telefonia\",\"sigla\":\"SDNIVEL3Telefonia\",\"serviceDesk\":\"N\"}]},\"acaoFluxo\":\"\",\"idTipoDemandaServico\":1,\"idServico\":4,\"itemConfiguracao\":\"\",\"messageId\":\"\",\"nomecontato\":\"Default\",\"telefonecontato\":\"3242-4433\",\"emailcontato\":\"citsmart_instalador_mysql@centralit.com.br\",\"observacao\":\"\",\"reclassificar\":\"\",\"escalar\":\"\",\"alterarSituacao\":\"\",\"detalhamentoCausa\":\"\",\"solucaoTemporaria\":\"N\",\"nomeServico\":\"Serviço 4\",\"ramal\":\"\",\"idAcordoNivelServico\":2,\"registradoPor\":\"Consultor\",\"registroexecucao\":\"\",\"impacto\":\"B\",\"urgencia\":\"B\",\"descricaoSemFormatacao\":\"Descrição do Incidente ou Requisição\",\"idResponsavel\":3,\"idGrupoAtual\":2,\"idGrupoNivel1\":2}', N'{\"idcontatosolicitacaoservico\":2,\"nomecontato\":\"Default\",\"telefonecontato\":\"3242-4433\",\"emailcontato\":\"citsmart_instalador_mysql@centralit.com.br\",\"observacao\":\"\"}', N'Criacao', N'O', 0, NULL, NULL, NULL);
INSERT [ocorrenciasolicitacao] ([idocorrencia], [idjustificativa], [idsolicitacaoservico], [iditemtrabalho], [dataregistro], [horaregistro], [registradopor], [descricao], [datainicio], [datafim], [complementojustificativa], [dadossolicitacao], [informacoescontato], [categoria], [origem], [tempogasto], [ocorrencia], [idcategoriaocorrencia], [idorigemocorrencia]) VALUES (4, NULL, 2, NULL, CAST(0xF2360B00 AS Date), N'09:43', N'AutomÃ¡tico', N'Inicio do SLA', CAST(0xF2360B00 AS Date), CAST(0xF2360B00 AS Date), NULL, N'{\"idSolicitacaoServico\":2,\"idContatoSolicitacaoServico\":2,\"idServicoContrato\":4,\"idSolicitante\":2,\"idOrigem\":1,\"idPrioridade\":5,\"filtroADPesq\":\"\",\"idUnidade\":1,\"idFaseAtual\":2,\"dataHoraSolicitacao\":\"Apr 5, 2013 9:43:39 AM\",\"prazoCapturaHH\":0,\"prazoCapturaMM\":0,\"prazoHH\":0,\"prazoMM\":0,\"descricao\":\"Descri\\u0026ccedil;\\u0026atilde;o do Incidente ou Requisi\\u0026ccedil;\\u0026atilde;o\",\"resposta\":\"\",\"dataHoraInicio\":\"Apr 5, 2013 9:43:39 AM\",\"situacao\":\"EmAndamento\",\"seqReabertura\":0,\"enviaEmailCriacao\":\"S\",\"enviaEmailFinalizacao\":\"S\",\"slaACombinar\":\"S\",\"idCalendario\":1,\"tempoDecorridoHH\":0,\"tempoDecorridoMM\":0,\"situacaoSLA\":\"A\",\"dataHoraInicioSLA\":\"Apr 5, 2013 9:43:39 AM\",\"descrSituacao\":\"Em andamento\",\"dataHoraLimite\":\"Apr 5, 2013 9:43:00 AM\",\"dataHoraLimiteStr\":\"05/04/2013 09:43\",\"dataHoraInicioSLAStr\":\"05/04/2013 09:43:39\",\"atrasoSLA\":0.0,\"idContrato\":1,\"solicitante\":\"Default\",\"dataHoraSolicitacaoStr\":\"05/04/2013 09:43\",\"usuarioDto\":{\"idUsuario\":3,\"idEmpregado\":3,\"idPerfilAcessoUsuario\":1,\"idEmpresa\":1,\"login\":\"consultor\",\"nomeUsuario\":\"Consultor\",\"status\":\"A\",\"grupos\":[\"SDNIVEL1\",\"SDNIVEL2\",\"SDNIVEL3Apli\",\"SDNIVEL3Infra\",\"SDNIVEL3Sist\",\"SDNIVEL3Telefonia\"],\"locale\":\"\",\"colGrupos\":[{\"idGrupo\":2,\"nome\":\"1º NÍVEL\",\"sigla\":\"SDNIVEL1\",\"serviceDesk\":\"S\"},{\"idGrupo\":3,\"nome\":\"2º NÍVEL\",\"sigla\":\"SDNIVEL2\",\"serviceDesk\":\"S\"},{\"idGrupo\":16,\"nome\":\"3º NÍVEL - Aplicação\",\"sigla\":\"SDNIVEL3Apli\",\"serviceDesk\":\"S\"},{\"idGrupo\":4,\"nome\":\"3º NÍVEL - Infraestrutura\",\"sigla\":\"SDNIVEL3Infra\",\"serviceDesk\":\"S\"},{\"idGrupo\":17,\"nome\":\"3º NÍVEL - Sistemas\",\"sigla\":\"SDNIVEL3Sist\",\"serviceDesk\":\"S\"},{\"idGrupo\":19,\"nome\":\"3º NÍVEL - Telefonia\",\"sigla\":\"SDNIVEL3Telefonia\",\"serviceDesk\":\"N\"}]},\"grupoAtual\":\"SDNIVEL1\",\"grupoNivel1\":\"SDNIVEL1\",\"acaoFluxo\":\"\",\"idTipoDemandaServico\":1,\"idServico\":4,\"itemConfiguracao\":\"\",\"messageId\":\"\",\"nomecontato\":\"Default\",\"telefonecontato\":\"3242-4433\",\"emailcontato\":\"citsmart_instalador_mysql@centralit.com.br\",\"observacao\":\"\",\"reclassificar\":\"\",\"escalar\":\"\",\"alterarSituacao\":\"\",\"detalhamentoCausa\":\"\",\"solucaoTemporaria\":\"N\",\"nomeServico\":\"Serviço 4\",\"ramal\":\"\",\"idAcordoNivelServico\":2,\"registradoPor\":\"Consultor\",\"registroexecucao\":\"\",\"impacto\":\"B\",\"urgencia\":\"B\",\"descricaoSemFormatacao\":\"Descrição do Incidente ou Requisição\",\"idResponsavel\":3,\"idGrupoAtual\":2,\"idGrupoNivel1\":2}', NULL, N'InicioSLA', N'O', 0, NULL, NULL, NULL);
INSERT [ocorrenciasolicitacao] ([idocorrencia], [idjustificativa], [idsolicitacaoservico], [iditemtrabalho], [dataregistro], [horaregistro], [registradopor], [descricao], [datainicio], [datafim], [complementojustificativa], [dadossolicitacao], [informacoescontato], [categoria], [origem], [tempogasto], [ocorrencia], [idcategoriaocorrencia], [idorigemocorrencia]) VALUES (5, NULL, 3, NULL, CAST(0xF2360B00 AS Date), N'09:46', N'Default', N'Registro da Solicitação', CAST(0xF2360B00 AS Date), CAST(0xF2360B00 AS Date), NULL, N'{\"idSolicitacaoServico\":3,\"idContatoSolicitacaoServico\":3,\"idServicoContrato\":5,\"idSolicitante\":3,\"idOrigem\":1,\"idPrioridade\":5,\"filtroADPesq\":\"\",\"idUnidade\":1,\"dataHoraSolicitacao\":\"Apr 5, 2013 9:46:04 AM\",\"prazoCapturaHH\":0,\"prazoCapturaMM\":0,\"prazoHH\":0,\"prazoMM\":0,\"descricao\":\"Descri\\u0026ccedil;\\u0026atilde;o do Incidente ou Requisi\\u0026ccedil;\\u0026atilde;o\",\"resposta\":\"\",\"dataHoraInicio\":\"Apr 5, 2013 9:46:04 AM\",\"situacao\":\"Cancelada\",\"seqReabertura\":0,\"enviaEmailCriacao\":\"S\",\"enviaEmailFinalizacao\":\"S\",\"slaACombinar\":\"S\",\"idCalendario\":1,\"tempoDecorridoHH\":0,\"tempoDecorridoMM\":0,\"situacaoSLA\":\"N\",\"descrSituacao\":\"Cancelada\",\"atrasoSLA\":0.0,\"idContrato\":1,\"solicitante\":\"Consultor\",\"dataHoraSolicitacaoStr\":\"05/04/2013 09:46\",\"usuarioDto\":{\"idUsuario\":2,\"idEmpregado\":2,\"idPerfilAcessoUsuario\":2,\"idEmpresa\":1,\"login\":\"default\",\"nomeUsuario\":\"Default\",\"status\":\"A\",\"grupos\":[\"SDNIVEL1\",\"SDNIVEL2\",\"SDNIVEL3Apli\",\"SDNIVEL3Infra\",\"SDNIVEL3Sist\",\"SDNIVEL3Telefonia\"],\"locale\":\"\",\"colGrupos\":[{\"idGrupo\":2,\"nome\":\"1º NÍVEL\",\"sigla\":\"SDNIVEL1\",\"serviceDesk\":\"S\"},{\"idGrupo\":3,\"nome\":\"2º NÍVEL\",\"sigla\":\"SDNIVEL2\",\"serviceDesk\":\"S\"},{\"idGrupo\":16,\"nome\":\"3º NÍVEL - Aplicação\",\"sigla\":\"SDNIVEL3Apli\",\"serviceDesk\":\"S\"},{\"idGrupo\":4,\"nome\":\"3º NÍVEL - Infraestrutura\",\"sigla\":\"SDNIVEL3Infra\",\"serviceDesk\":\"S\"},{\"idGrupo\":17,\"nome\":\"3º NÍVEL - Sistemas\",\"sigla\":\"SDNIVEL3Sist\",\"serviceDesk\":\"S\"},{\"idGrupo\":19,\"nome\":\"3º NÍVEL - Telefonia\",\"sigla\":\"SDNIVEL3Telefonia\",\"serviceDesk\":\"N\"}]},\"acaoFluxo\":\"\",\"idTipoDemandaServico\":1,\"idServico\":5,\"itemConfiguracao\":\"\",\"messageId\":\"\",\"nomecontato\":\"Consultor\",\"telefonecontato\":\"3242-4433\",\"emailcontato\":\"citsmart_instalador_mysql@centralit.com.br\",\"observacao\":\"\",\"reclassificar\":\"\",\"escalar\":\"\",\"alterarSituacao\":\"\",\"detalhamentoCausa\":\"\",\"solucaoTemporaria\":\"N\",\"nomeServico\":\"Serviço 5\",\"ramal\":\"\",\"idAcordoNivelServico\":3,\"registradoPor\":\"Default\",\"registroexecucao\":\"\",\"impacto\":\"B\",\"urgencia\":\"B\",\"descricaoSemFormatacao\":\"Descrição do Incidente ou Requisição\",\"idResponsavel\":2,\"idGrupoAtual\":3,\"idGrupoNivel1\":2}', N'{\"idcontatosolicitacaoservico\":3,\"nomecontato\":\"Consultor\",\"telefonecontato\":\"3242-4433\",\"emailcontato\":\"citsmart_instalador_mysql@centralit.com.br\",\"observacao\":\"\"}', N'Criacao', N'O', 0, NULL, NULL, NULL);
INSERT [ocorrenciasolicitacao] ([idocorrencia], [idjustificativa], [idsolicitacaoservico], [iditemtrabalho], [dataregistro], [horaregistro], [registradopor], [descricao], [datainicio], [datafim], [complementojustificativa], [dadossolicitacao], [informacoescontato], [categoria], [origem], [tempogasto], [ocorrencia], [idcategoriaocorrencia], [idorigemocorrencia]) VALUES (6, NULL, 3, NULL, CAST(0xF2360B00 AS Date), N'09:46', N'AutomÃ¡tico', N'Encerramento da Solicitação', CAST(0xF2360B00 AS Date), CAST(0xF2360B00 AS Date), NULL, N'{\"idSolicitacaoServico\":3,\"idContatoSolicitacaoServico\":3,\"idServicoContrato\":5,\"idSolicitante\":3,\"idOrigem\":1,\"idPrioridade\":5,\"filtroADPesq\":\"\",\"idUnidade\":1,\"idFaseAtual\":2,\"dataHoraSolicitacao\":\"Apr 5, 2013 9:46:04 AM\",\"prazoCapturaHH\":0,\"prazoCapturaMM\":0,\"prazoHH\":0,\"prazoMM\":0,\"descricao\":\"Descri\\u0026ccedil;\\u0026atilde;o do Incidente ou Requisi\\u0026ccedil;\\u0026atilde;o\",\"resposta\":\"\",\"dataHoraInicio\":\"Apr 5, 2013 9:46:04 AM\",\"dataHoraFim\":\"Apr 5, 2013 9:46:04 AM\",\"situacao\":\"Cancelada\",\"seqReabertura\":0,\"enviaEmailCriacao\":\"S\",\"enviaEmailFinalizacao\":\"S\",\"slaACombinar\":\"S\",\"idCalendario\":1,\"tempoDecorridoHH\":0,\"tempoDecorridoMM\":0,\"situacaoSLA\":\"N\",\"descrSituacao\":\"Cancelada\",\"atrasoSLA\":0.0,\"idContrato\":1,\"solicitante\":\"Consultor\",\"dataHoraSolicitacaoStr\":\"05/04/2013 09:46\",\"usuarioDto\":{\"idUsuario\":2,\"idEmpregado\":2,\"idPerfilAcessoUsuario\":2,\"idEmpresa\":1,\"login\":\"default\",\"nomeUsuario\":\"Default\",\"status\":\"A\",\"grupos\":[\"SDNIVEL1\",\"SDNIVEL2\",\"SDNIVEL3Apli\",\"SDNIVEL3Infra\",\"SDNIVEL3Sist\",\"SDNIVEL3Telefonia\"],\"locale\":\"\",\"colGrupos\":[{\"idGrupo\":2,\"nome\":\"1º NÍVEL\",\"sigla\":\"SDNIVEL1\",\"serviceDesk\":\"S\"},{\"idGrupo\":3,\"nome\":\"2º NÍVEL\",\"sigla\":\"SDNIVEL2\",\"serviceDesk\":\"S\"},{\"idGrupo\":16,\"nome\":\"3º NÍVEL - Aplicação\",\"sigla\":\"SDNIVEL3Apli\",\"serviceDesk\":\"S\"},{\"idGrupo\":4,\"nome\":\"3º NÍVEL - Infraestrutura\",\"sigla\":\"SDNIVEL3Infra\",\"serviceDesk\":\"S\"},{\"idGrupo\":17,\"nome\":\"3º NÍVEL - Sistemas\",\"sigla\":\"SDNIVEL3Sist\",\"serviceDesk\":\"S\"},{\"idGrupo\":19,\"nome\":\"3º NÍVEL - Telefonia\",\"sigla\":\"SDNIVEL3Telefonia\",\"serviceDesk\":\"N\"}]},\"grupoAtual\":\"SDNIVEL2\",\"grupoNivel1\":\"SDNIVEL1\",\"acaoFluxo\":\"\",\"idTipoDemandaServico\":1,\"idServico\":5,\"itemConfiguracao\":\"\",\"messageId\":\"\",\"nomecontato\":\"Consultor\",\"telefonecontato\":\"3242-4433\",\"emailcontato\":\"citsmart_instalador_mysql@centralit.com.br\",\"observacao\":\"\",\"reclassificar\":\"\",\"escalar\":\"\",\"alterarSituacao\":\"\",\"detalhamentoCausa\":\"\",\"solucaoTemporaria\":\"N\",\"nomeServico\":\"Serviço 5\",\"ramal\":\"\",\"idAcordoNivelServico\":3,\"registradoPor\":\"Default\",\"registroexecucao\":\"\",\"impacto\":\"B\",\"urgencia\":\"B\",\"tempoCapturaHH\":0,\"tempoCapturaMM\":0,\"tempoAtrasoHH\":0,\"tempoAtrasoMM\":0,\"descricaoSemFormatacao\":\"Descrição do Incidente ou Requisição\",\"idResponsavel\":2,\"idGrupoAtual\":3,\"idGrupoNivel1\":2}', NULL, N'Encerramento', N'O', 0, NULL, NULL, NULL);
INSERT [ocorrenciasolicitacao] ([idocorrencia], [idjustificativa], [idsolicitacaoservico], [iditemtrabalho], [dataregistro], [horaregistro], [registradopor], [descricao], [datainicio], [datafim], [complementojustificativa], [dadossolicitacao], [informacoescontato], [categoria], [origem], [tempogasto], [ocorrencia], [idcategoriaocorrencia], [idorigemocorrencia]) VALUES (7, NULL, 3, NULL, CAST(0xF2360B00 AS Date), N'09:46', N'AutomÃ¡tico', N'Inicio do SLA', CAST(0xF2360B00 AS Date), CAST(0xF2360B00 AS Date), NULL, N'{\"idSolicitacaoServico\":3,\"idContatoSolicitacaoServico\":3,\"idServicoContrato\":5,\"idSolicitante\":3,\"idOrigem\":1,\"idPrioridade\":5,\"filtroADPesq\":\"\",\"idUnidade\":1,\"idFaseAtual\":2,\"dataHoraSolicitacao\":\"Apr 5, 2013 9:46:04 AM\",\"prazoCapturaHH\":0,\"prazoCapturaMM\":0,\"prazoHH\":0,\"prazoMM\":0,\"descricao\":\"Descri\\u0026ccedil;\\u0026atilde;o do Incidente ou Requisi\\u0026ccedil;\\u0026atilde;o\",\"resposta\":\"\",\"dataHoraInicio\":\"Apr 5, 2013 9:46:04 AM\",\"dataHoraFim\":\"Apr 5, 2013 9:46:04 AM\",\"situacao\":\"Cancelada\",\"seqReabertura\":0,\"enviaEmailCriacao\":\"S\",\"enviaEmailFinalizacao\":\"S\",\"slaACombinar\":\"S\",\"idCalendario\":1,\"tempoDecorridoHH\":0,\"tempoDecorridoMM\":0,\"situacaoSLA\":\"A\",\"dataHoraInicioSLA\":\"Apr 5, 2013 9:46:04 AM\",\"descrSituacao\":\"Cancelada\",\"dataHoraLimite\":\"Apr 5, 2013 9:46:00 AM\",\"dataHoraLimiteStr\":\"05/04/2013 09:46\",\"dataHoraInicioSLAStr\":\"05/04/2013 09:46:04\",\"atrasoSLA\":0.0,\"idContrato\":1,\"solicitante\":\"Consultor\",\"dataHoraSolicitacaoStr\":\"05/04/2013 09:46\",\"usuarioDto\":{\"idUsuario\":2,\"idEmpregado\":2,\"idPerfilAcessoUsuario\":2,\"idEmpresa\":1,\"login\":\"default\",\"nomeUsuario\":\"Default\",\"status\":\"A\",\"grupos\":[\"SDNIVEL1\",\"SDNIVEL2\",\"SDNIVEL3Apli\",\"SDNIVEL3Infra\",\"SDNIVEL3Sist\",\"SDNIVEL3Telefonia\"],\"locale\":\"\",\"colGrupos\":[{\"idGrupo\":2,\"nome\":\"1º NÍVEL\",\"sigla\":\"SDNIVEL1\",\"serviceDesk\":\"S\"},{\"idGrupo\":3,\"nome\":\"2º NÍVEL\",\"sigla\":\"SDNIVEL2\",\"serviceDesk\":\"S\"},{\"idGrupo\":16,\"nome\":\"3º NÍVEL - Aplicação\",\"sigla\":\"SDNIVEL3Apli\",\"serviceDesk\":\"S\"},{\"idGrupo\":4,\"nome\":\"3º NÍVEL - Infraestrutura\",\"sigla\":\"SDNIVEL3Infra\",\"serviceDesk\":\"S\"},{\"idGrupo\":17,\"nome\":\"3º NÍVEL - Sistemas\",\"sigla\":\"SDNIVEL3Sist\",\"serviceDesk\":\"S\"},{\"idGrupo\":19,\"nome\":\"3º NÍVEL - Telefonia\",\"sigla\":\"SDNIVEL3Telefonia\",\"serviceDesk\":\"N\"}]},\"grupoAtual\":\"SDNIVEL2\",\"grupoNivel1\":\"SDNIVEL1\",\"acaoFluxo\":\"\",\"idTipoDemandaServico\":1,\"idServico\":5,\"itemConfiguracao\":\"\",\"messageId\":\"\",\"nomecontato\":\"Consultor\",\"telefonecontato\":\"3242-4433\",\"emailcontato\":\"citsmart_instalador_mysql@centralit.com.br\",\"observacao\":\"\",\"reclassificar\":\"\",\"escalar\":\"\",\"alterarSituacao\":\"\",\"detalhamentoCausa\":\"\",\"solucaoTemporaria\":\"N\",\"nomeServico\":\"Serviço 5\",\"ramal\":\"\",\"idAcordoNivelServico\":3,\"registradoPor\":\"Default\",\"registroexecucao\":\"\",\"impacto\":\"B\",\"urgencia\":\"B\",\"tempoCapturaHH\":0,\"tempoCapturaMM\":0,\"tempoAtrasoHH\":0,\"tempoAtrasoMM\":0,\"descricaoSemFormatacao\":\"Descrição do Incidente ou Requisição\",\"idResponsavel\":2,\"idGrupoAtual\":3,\"idGrupoNivel1\":2}', NULL, N'InicioSLA', N'O', 0, NULL, NULL, NULL);
INSERT [ocorrenciasolicitacao] ([idocorrencia], [idjustificativa], [idsolicitacaoservico], [iditemtrabalho], [dataregistro], [horaregistro], [registradopor], [descricao], [datainicio], [datafim], [complementojustificativa], [dadossolicitacao], [informacoescontato], [categoria], [origem], [tempogasto], [ocorrencia], [idcategoriaocorrencia], [idorigemocorrencia]) VALUES (8, NULL, 3, NULL, CAST(0xF2360B00 AS Date), N'09:46', N'AutomÃ¡tico', N'Encerramento da Solicitação', CAST(0xF2360B00 AS Date), CAST(0xF2360B00 AS Date), NULL, N'{\"idSolicitacaoServico\":3,\"idContatoSolicitacaoServico\":3,\"idServicoContrato\":5,\"idSolicitante\":3,\"idOrigem\":1,\"idPrioridade\":5,\"filtroADPesq\":\"\",\"idUnidade\":1,\"idFaseAtual\":2,\"dataHoraSolicitacao\":\"Apr 5, 2013 9:46:04 AM\",\"prazoCapturaHH\":0,\"prazoCapturaMM\":0,\"prazoHH\":0,\"prazoMM\":0,\"descricao\":\"Descri\\u0026ccedil;\\u0026atilde;o do Incidente ou Requisi\\u0026ccedil;\\u0026atilde;o\",\"resposta\":\"\",\"dataHoraInicio\":\"Apr 5, 2013 9:46:04 AM\",\"dataHoraFim\":\"Apr 5, 2013 9:46:04 AM\",\"situacao\":\"Cancelada\",\"seqReabertura\":0,\"enviaEmailCriacao\":\"S\",\"enviaEmailFinalizacao\":\"S\",\"slaACombinar\":\"S\",\"idCalendario\":1,\"tempoDecorridoHH\":0,\"tempoDecorridoMM\":0,\"situacaoSLA\":\"A\",\"dataHoraInicioSLA\":\"Apr 5, 2013 9:46:04 AM\",\"descrSituacao\":\"Cancelada\",\"dataHoraLimite\":\"Apr 5, 2013 9:46:00 AM\",\"dataHoraLimiteStr\":\"05/04/2013 09:46\",\"dataHoraInicioSLAStr\":\"05/04/2013 09:46:04\",\"atrasoSLA\":0.0,\"idContrato\":1,\"solicitante\":\"Consultor\",\"dataHoraSolicitacaoStr\":\"05/04/2013 09:46\",\"usuarioDto\":{\"idUsuario\":2,\"idEmpregado\":2,\"idPerfilAcessoUsuario\":2,\"idEmpresa\":1,\"login\":\"default\",\"nomeUsuario\":\"Default\",\"status\":\"A\",\"grupos\":[\"SDNIVEL1\",\"SDNIVEL2\",\"SDNIVEL3Apli\",\"SDNIVEL3Infra\",\"SDNIVEL3Sist\",\"SDNIVEL3Telefonia\"],\"locale\":\"\",\"colGrupos\":[{\"idGrupo\":2,\"nome\":\"1º NÍVEL\",\"sigla\":\"SDNIVEL1\",\"serviceDesk\":\"S\"},{\"idGrupo\":3,\"nome\":\"2º NÍVEL\",\"sigla\":\"SDNIVEL2\",\"serviceDesk\":\"S\"},{\"idGrupo\":16,\"nome\":\"3º NÍVEL - Aplicação\",\"sigla\":\"SDNIVEL3Apli\",\"serviceDesk\":\"S\"},{\"idGrupo\":4,\"nome\":\"3º NÍVEL - Infraestrutura\",\"sigla\":\"SDNIVEL3Infra\",\"serviceDesk\":\"S\"},{\"idGrupo\":17,\"nome\":\"3º NÍVEL - Sistemas\",\"sigla\":\"SDNIVEL3Sist\",\"serviceDesk\":\"S\"},{\"idGrupo\":19,\"nome\":\"3º NÍVEL - Telefonia\",\"sigla\":\"SDNIVEL3Telefonia\",\"serviceDesk\":\"N\"}]},\"grupoAtual\":\"SDNIVEL2\",\"grupoNivel1\":\"SDNIVEL1\",\"acaoFluxo\":\"\",\"idTipoDemandaServico\":1,\"idServico\":5,\"itemConfiguracao\":\"\",\"messageId\":\"\",\"nomecontato\":\"Consultor\",\"telefonecontato\":\"3242-4433\",\"emailcontato\":\"citsmart_instalador_mysql@centralit.com.br\",\"observacao\":\"\",\"reclassificar\":\"\",\"escalar\":\"\",\"alterarSituacao\":\"\",\"detalhamentoCausa\":\"\",\"solucaoTemporaria\":\"N\",\"nomeServico\":\"Serviço 5\",\"ramal\":\"\",\"idAcordoNivelServico\":3,\"registradoPor\":\"Default\",\"registroexecucao\":\"\",\"impacto\":\"B\",\"urgencia\":\"B\",\"tempoCapturaHH\":0,\"tempoCapturaMM\":0,\"tempoAtrasoHH\":0,\"tempoAtrasoMM\":0,\"tempoAtendimentoHH\":0,\"tempoAtendimentoMM\":0,\"descricaoSemFormatacao\":\"Descrição do Incidente ou Requisição\",\"idResponsavel\":2,\"idGrupoAtual\":3,\"idGrupoNivel1\":2}', NULL, N'Encerramento', N'O', 0, NULL, NULL, NULL);
INSERT [ocorrenciasolicitacao] ([idocorrencia], [idjustificativa], [idsolicitacaoservico], [iditemtrabalho], [dataregistro], [horaregistro], [registradopor], [descricao], [datainicio], [datafim], [complementojustificativa], [dadossolicitacao], [informacoescontato], [categoria], [origem], [tempogasto], [ocorrencia], [idcategoriaocorrencia], [idorigemocorrencia]) VALUES (9, NULL, 4, NULL, CAST(0xF2360B00 AS Date), N'10:13', N'Default', N'Registro da Solicitação', CAST(0xF2360B00 AS Date), CAST(0xF2360B00 AS Date), NULL, N'{\"idSolicitacaoServico\":4,\"idContatoSolicitacaoServico\":4,\"idServicoContrato\":5,\"idSolicitante\":3,\"idOrigem\":1,\"idPrioridade\":5,\"filtroADPesq\":\"\",\"idUnidade\":1,\"dataHoraSolicitacao\":\"Apr 5, 2013 10:13:17 AM\",\"prazoCapturaHH\":0,\"prazoCapturaMM\":0,\"prazoHH\":0,\"prazoMM\":0,\"descricao\":\"Descri\\u0026ccedil;\\u0026atilde;o do Incidente ou Requisi\\u0026ccedil;\\u0026atilde;o\\u003cbr /\\u003e\",\"resposta\":\"\",\"dataHoraInicio\":\"Apr 5, 2013 10:13:17 AM\",\"situacao\":\"EmAndamento\",\"seqReabertura\":0,\"enviaEmailCriacao\":\"S\",\"enviaEmailFinalizacao\":\"S\",\"slaACombinar\":\"S\",\"idCalendario\":1,\"tempoDecorridoHH\":0,\"tempoDecorridoMM\":0,\"situacaoSLA\":\"N\",\"descrSituacao\":\"Em andamento\",\"atrasoSLA\":0.0,\"idContrato\":1,\"solicitante\":\"Consultor\",\"dataHoraSolicitacaoStr\":\"05/04/2013 10:13\",\"usuarioDto\":{\"idUsuario\":2,\"idEmpregado\":2,\"idPerfilAcessoUsuario\":2,\"idEmpresa\":1,\"login\":\"default\",\"nomeUsuario\":\"Default\",\"status\":\"A\",\"grupos\":[\"SDNIVEL1\",\"SDNIVEL2\",\"SDNIVEL3Apli\",\"SDNIVEL3Infra\",\"SDNIVEL3Sist\",\"SDNIVEL3Telefonia\"],\"locale\":\"\",\"colGrupos\":[{\"idGrupo\":2,\"nome\":\"1º NÍVEL\",\"sigla\":\"SDNIVEL1\",\"serviceDesk\":\"S\"},{\"idGrupo\":3,\"nome\":\"2º NÍVEL\",\"sigla\":\"SDNIVEL2\",\"serviceDesk\":\"S\"},{\"idGrupo\":16,\"nome\":\"3º NÍVEL - Aplicação\",\"sigla\":\"SDNIVEL3Apli\",\"serviceDesk\":\"S\"},{\"idGrupo\":4,\"nome\":\"3º NÍVEL - Infraestrutura\",\"sigla\":\"SDNIVEL3Infra\",\"serviceDesk\":\"S\"},{\"idGrupo\":17,\"nome\":\"3º NÍVEL - Sistemas\",\"sigla\":\"SDNIVEL3Sist\",\"serviceDesk\":\"S\"},{\"idGrupo\":19,\"nome\":\"3º NÍVEL - Telefonia\",\"sigla\":\"SDNIVEL3Telefonia\",\"serviceDesk\":\"N\"}]},\"acaoFluxo\":\"\",\"idTipoDemandaServico\":1,\"idServico\":5,\"itemConfiguracao\":\"\",\"messageId\":\"\",\"nomecontato\":\"Consultor\",\"telefonecontato\":\"3242-4433\",\"emailcontato\":\"citsmart_instalador_mysql@centralit.com.br\",\"observacao\":\"\",\"reclassificar\":\"\",\"escalar\":\"\",\"alterarSituacao\":\"\",\"detalhamentoCausa\":\"\",\"solucaoTemporaria\":\"N\",\"nomeServico\":\"Serviço 5\",\"ramal\":\"\",\"idAcordoNivelServico\":3,\"registradoPor\":\"Default\",\"registroexecucao\":\"\",\"impacto\":\"B\",\"urgencia\":\"B\",\"descricaoSemFormatacao\":\"Descrição do Incidente ou Requisição\",\"idResponsavel\":2,\"idGrupoAtual\":3,\"idGrupoNivel1\":2}', N'{\"idcontatosolicitacaoservico\":4,\"nomecontato\":\"Consultor\",\"telefonecontato\":\"3242-4433\",\"emailcontato\":\"citsmart_instalador_mysql@centralit.com.br\",\"observacao\":\"\"}', N'Criacao', N'O', 0, NULL, NULL, NULL);
INSERT [ocorrenciasolicitacao] ([idocorrencia], [idjustificativa], [idsolicitacaoservico], [iditemtrabalho], [dataregistro], [horaregistro], [registradopor], [descricao], [datainicio], [datafim], [complementojustificativa], [dadossolicitacao], [informacoescontato], [categoria], [origem], [tempogasto], [ocorrencia], [idcategoriaocorrencia], [idorigemocorrencia]) VALUES (10, NULL, 4, NULL, CAST(0xF2360B00 AS Date), N'10:13', N'AutomÃ¡tico', N'Inicio do SLA', CAST(0xF2360B00 AS Date), CAST(0xF2360B00 AS Date), NULL, N'{\"idSolicitacaoServico\":4,\"idContatoSolicitacaoServico\":4,\"idServicoContrato\":5,\"idSolicitante\":3,\"idOrigem\":1,\"idPrioridade\":5,\"filtroADPesq\":\"\",\"idUnidade\":1,\"idFaseAtual\":2,\"dataHoraSolicitacao\":\"Apr 5, 2013 10:13:17 AM\",\"prazoCapturaHH\":0,\"prazoCapturaMM\":0,\"prazoHH\":0,\"prazoMM\":0,\"descricao\":\"Descri\\u0026ccedil;\\u0026atilde;o do Incidente ou Requisi\\u0026ccedil;\\u0026atilde;o\\u003cbr /\\u003e\",\"resposta\":\"\",\"dataHoraInicio\":\"Apr 5, 2013 10:13:17 AM\",\"situacao\":\"EmAndamento\",\"seqReabertura\":0,\"enviaEmailCriacao\":\"S\",\"enviaEmailFinalizacao\":\"S\",\"slaACombinar\":\"S\",\"idCalendario\":1,\"tempoDecorridoHH\":0,\"tempoDecorridoMM\":0,\"situacaoSLA\":\"A\",\"dataHoraInicioSLA\":\"Apr 5, 2013 10:13:18 AM\",\"descrSituacao\":\"Em andamento\",\"dataHoraLimite\":\"Apr 5, 2013 10:13:00 AM\",\"dataHoraLimiteStr\":\"05/04/2013 10:13\",\"dataHoraInicioSLAStr\":\"05/04/2013 10:13:18\",\"atrasoSLA\":0.0,\"idContrato\":1,\"solicitante\":\"Consultor\",\"dataHoraSolicitacaoStr\":\"05/04/2013 10:13\",\"usuarioDto\":{\"idUsuario\":2,\"idEmpregado\":2,\"idPerfilAcessoUsuario\":2,\"idEmpresa\":1,\"login\":\"default\",\"nomeUsuario\":\"Default\",\"status\":\"A\",\"grupos\":[\"SDNIVEL1\",\"SDNIVEL2\",\"SDNIVEL3Apli\",\"SDNIVEL3Infra\",\"SDNIVEL3Sist\",\"SDNIVEL3Telefonia\"],\"locale\":\"\",\"colGrupos\":[{\"idGrupo\":2,\"nome\":\"1º NÍVEL\",\"sigla\":\"SDNIVEL1\",\"serviceDesk\":\"S\"},{\"idGrupo\":3,\"nome\":\"2º NÍVEL\",\"sigla\":\"SDNIVEL2\",\"serviceDesk\":\"S\"},{\"idGrupo\":16,\"nome\":\"3º NÍVEL - Aplicação\",\"sigla\":\"SDNIVEL3Apli\",\"serviceDesk\":\"S\"},{\"idGrupo\":4,\"nome\":\"3º NÍVEL - Infraestrutura\",\"sigla\":\"SDNIVEL3Infra\",\"serviceDesk\":\"S\"},{\"idGrupo\":17,\"nome\":\"3º NÍVEL - Sistemas\",\"sigla\":\"SDNIVEL3Sist\",\"serviceDesk\":\"S\"},{\"idGrupo\":19,\"nome\":\"3º NÍVEL - Telefonia\",\"sigla\":\"SDNIVEL3Telefonia\",\"serviceDesk\":\"N\"}]},\"grupoAtual\":\"SDNIVEL2\",\"grupoNivel1\":\"SDNIVEL1\",\"acaoFluxo\":\"\",\"idTipoDemandaServico\":1,\"idServico\":5,\"itemConfiguracao\":\"\",\"messageId\":\"\",\"nomecontato\":\"Consultor\",\"telefonecontato\":\"3242-4433\",\"emailcontato\":\"citsmart_instalador_mysql@centralit.com.br\",\"observacao\":\"\",\"reclassificar\":\"\",\"escalar\":\"\",\"alterarSituacao\":\"\",\"detalhamentoCausa\":\"\",\"solucaoTemporaria\":\"N\",\"nomeServico\":\"Serviço 5\",\"ramal\":\"\",\"idAcordoNivelServico\":3,\"registradoPor\":\"Default\",\"registroexecucao\":\"\",\"impacto\":\"B\",\"urgencia\":\"B\",\"descricaoSemFormatacao\":\"Descrição do Incidente ou Requisição\",\"idResponsavel\":2,\"idGrupoAtual\":3,\"idGrupoNivel1\":2}', NULL, N'InicioSLA', N'O', 0, NULL, NULL, NULL);

CREATE TABLE [ocorrencialiberacao](
	[idocorrencia] [int] NOT NULL,
	[iditemtrabalho] [bigint] NULL,
	[idjustificativa] [int] NULL,
	[idrequisicaoliberacao] [int] NULL,
	[dataregistro] [date] NULL,
	[horaregistro] [varchar](5) NULL,
	[registradopor] [varchar](100) NULL,
	[descricao] [varchar](200) NULL,
	[datainicio] [date] NULL,
	[datafim] [date] NULL,
	[complementojustificativa] [text] NULL,
	[dadosliberacao] [text] NULL,
	[informacoescontato] [text] NULL,
	[categoria] [varchar](20) NULL,
	[origem] [char](1) NULL,
	[tempogasto] [smallint] NULL,
	[ocorrencia] [text] NULL,
	[idcategoriaocorrencia] [int] NULL,
	[idorigemocorrencia] [int] NULL,
 CONSTRAINT [ocorrencialiberacao_pkey] PRIMARY KEY CLUSTERED 
(
	[idocorrencia] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [ocorrencialiberacao_iditemtrabalho_idx] ON [ocorrencialiberacao] 
(
	[iditemtrabalho] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [ocorrencialiberacao_idjustificativa_idx] ON [ocorrencialiberacao] 
(
	[idjustificativa] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [ocorrencialiberacao_idrequisicaoliberacao_idx] ON [ocorrencialiberacao] 
(
	[idrequisicaoliberacao] ASC
)ON [PRIMARY];

CREATE TABLE [matrizvisao](
	[idmatriz] [bigint] NOT NULL,
	[idvisao] [bigint] NULL,
	[idobjetonegocio] [bigint] NULL,
	[idcamposobjetonegocio1] [bigint] NULL,
	[idcamposobjetonegocio2] [bigint] NULL,
	[idcamposobjetonegocio3] [bigint] NULL,
	[strinfo] [text] NULL,
	[nomecampo1] [varchar](255) NULL,
	[nomecampo2] [varchar](255) NULL,
	[nomecampo3] [varchar](255) NULL,
	[descricaocampo1] [varchar](255) NULL,
	[descricaocampo2] [varchar](255) NULL,
	[descricaocampo3] [varchar](255) NULL,
PRIMARY KEY CLUSTERED 
(
	[idmatriz] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_620] ON [matrizvisao] 
(
	[idvisao] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_621] ON [matrizvisao] 
(
	[idobjetonegocio] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_622] ON [matrizvisao] 
(
	[idcamposobjetonegocio1] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_623] ON [matrizvisao] 
(
	[idcamposobjetonegocio2] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_624] ON [matrizvisao] 
(
	[idcamposobjetonegocio3] ASC
)ON [PRIMARY];

CREATE TRIGGER [opiniao_setCurrentTime] ON  [opiniao]
FOR UPDATE
AS
BEGIN
	SET NOCOUNT ON; 
	UPDATE tbl
	SET hora = GETDATE()
	FROM opiniao AS tbl
	INNER JOIN inserted AS i
		ON tbl.idopiniao = i.idopiniao; 
END;

CREATE TABLE [notificacaousuario](
	[idnotificacao] [int] NULL,
	[idusuario] [int] NULL
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_alertaus_reference_alerta] ON [notificacaousuario] 
(
	[idnotificacao] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_alertaus_reference_usuario] ON [notificacaousuario] 
(
	[idusuario] ASC
)ON [PRIMARY];

CREATE TRIGGER [logdados_setCurrentTime] ON  [logdados]
FOR UPDATE
AS
BEGIN
	SET NOCOUNT ON; 
	UPDATE ld
	SET datalog = GETDATE()
	FROM logdados AS ld
	INNER JOIN inserted AS i
		ON ld.idlog = i.idlog; 
END;

CREATE TABLE [notificacaogrupo](
	[idnotificacao] [int] NULL,
	[idgrupo] [int] NULL
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_alertagr_reference_alerta] ON [notificacaogrupo] 
(
	[idnotificacao] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_alertagr_reference_grupo] ON [notificacaogrupo] 
(
	[idgrupo] ASC
)ON [PRIMARY];

CREATE TABLE [objetivoplanomelhoria](
	[idobjetivoplanomelhoria] [int] NOT NULL,
	[idplanomelhoria] [int] NOT NULL,
	[tituloobjetivo] [varchar](255) NOT NULL,
	[detalhamento] [text] NULL,
	[resultadoesperado] [text] NULL,
	[medicao] [varchar](255) NULL,
	[responsavel] [varchar](255) NULL,
	[criadopor] [varchar](255) NULL,
	[modificadopor] [varchar](255) NULL,
	[datacriacao] [date] NULL,
	[ultmodificacao] [date] NULL,
PRIMARY KEY CLUSTERED 
(
	[idobjetivoplanomelhoria] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [ix_obj_pm_id] ON [objetivoplanomelhoria] 
(
	[idplanomelhoria] ASC
)ON [PRIMARY];

CREATE TRIGGER [registro_setCurrentTime] ON  [registro]
FOR UPDATE
AS
BEGIN
	SET NOCOUNT ON; 
	UPDATE tbl
	SET datahora = GETDATE()
	FROM registro AS tbl
	INNER JOIN inserted AS i
		ON tbl.idregistro = i.idregistro; 
END;

CREATE TABLE [valorservicocontrato](
	[idservicocontrato] [bigint] NULL,
	[idservico] [int] NULL,
	[valorServico] [decimal](18, 2) NULL,
	[datainicio] [date] NULL,
	[datafim] [date] NULL,
	[idvalorservicocontrato] [int] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idvalorservicocontrato] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_665] ON [valorservicocontrato] 
(
	[idservicocontrato] ASC
)ON [PRIMARY];

CREATE TABLE [unidade](
	[idunidade] [int] NOT NULL,
	[idunidadepai] [int] NULL,
	[idtipounidade] [int] NULL,
	[idempresa] [int] NOT NULL,
	[nome] [varchar](255) NOT NULL,
	[datainicio] [date] NOT NULL,
	[datafim] [date] NULL,
	[descricao] [text] NULL,
	[email] [varchar](40) NULL,
	[idendereco] [int] NULL,
	[aceitaentregaproduto] [char](1) NULL,
PRIMARY KEY CLUSTERED 
(
	[idunidade] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_unid_end] ON [unidade] 
(
	[idendereco] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_UNEMPRESA] ON [unidade] 
(
	[idempresa] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_UNTIPOUNIDADE] ON [unidade] 
(
	[idtipounidade] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_UNUNIDADEPAI] ON [unidade] 
(
	[idunidadepai] ASC
)ON [PRIMARY];

INSERT [unidade] ([idunidade], [idunidadepai], [idtipounidade], [idempresa], [nome], [datainicio], [datafim], [descricao], [email], [idendereco], [aceitaentregaproduto]) VALUES (1, NULL, NULL, 1, N'Default', CAST(0x26350B00 AS Date), NULL, N'', N'', NULL, NULL);

CREATE TABLE [ufs](
	[iduf] [int] NOT NULL,
	[nomeuf] [varchar](50) NOT NULL,
	[siglauf] [varchar](2) NOT NULL,
	[idregioes] [varchar](45) NULL,
	[idpais] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[iduf] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_uf_pais] ON [ufs] 
(
	[idpais] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_ufs] ON [ufs] 
(
	[idregioes] ASC
)ON [PRIMARY];

INSERT [ufs] ([iduf], [nomeuf], [siglauf], [idregioes], [idpais]) VALUES (0, N' -- Indefinida -- ', N'--', NULL, 1);
INSERT [ufs] ([iduf], [nomeuf], [siglauf], [idregioes], [idpais]) VALUES (1, N'Distrito Federal', N'DF', NULL, 1);
INSERT [ufs] ([iduf], [nomeuf], [siglauf], [idregioes], [idpais]) VALUES (2, N'São Paulo', N'SP', NULL, 1);
INSERT [ufs] ([iduf], [nomeuf], [siglauf], [idregioes], [idpais]) VALUES (3, N'Rio de Janeiro', N'RJ', NULL, 1);
INSERT [ufs] ([iduf], [nomeuf], [siglauf], [idregioes], [idpais]) VALUES (4, N'Goiás', N'', NULL, 1);
INSERT [ufs] ([iduf], [nomeuf], [siglauf], [idregioes], [idpais]) VALUES (5, N'Tocantins', N'TO', NULL, 1);
INSERT [ufs] ([iduf], [nomeuf], [siglauf], [idregioes], [idpais]) VALUES (6, N'Minas Gerais', N'MG', NULL, 1);
INSERT [ufs] ([iduf], [nomeuf], [siglauf], [idregioes], [idpais]) VALUES (7, N'Paraná', N'PR', NULL, 1);
INSERT [ufs] ([iduf], [nomeuf], [siglauf], [idregioes], [idpais]) VALUES (8, N'Espirito Santo', N'ES', NULL, 1);
INSERT [ufs] ([iduf], [nomeuf], [siglauf], [idregioes], [idpais]) VALUES (9, N'Acre', N'AC', NULL, 1);
INSERT [ufs] ([iduf], [nomeuf], [siglauf], [idregioes], [idpais]) VALUES (10, N'Alagoas', N'AL', NULL, 1);
INSERT [ufs] ([iduf], [nomeuf], [siglauf], [idregioes], [idpais]) VALUES (11, N'Amapá', N'AP', NULL, 1);
INSERT [ufs] ([iduf], [nomeuf], [siglauf], [idregioes], [idpais]) VALUES (12, N'Amazonas', N'AM', NULL, 1);
INSERT [ufs] ([iduf], [nomeuf], [siglauf], [idregioes], [idpais]) VALUES (13, N'Bahia', N'BA', NULL, 1);
INSERT [ufs] ([iduf], [nomeuf], [siglauf], [idregioes], [idpais]) VALUES (14, N'Ceará', N'CE', NULL, 1);
INSERT [ufs] ([iduf], [nomeuf], [siglauf], [idregioes], [idpais]) VALUES (15, N'Maranhão', N'MA', NULL, 1);
INSERT [ufs] ([iduf], [nomeuf], [siglauf], [idregioes], [idpais]) VALUES (16, N'Mato Grosso', N'MT', NULL, 1);
INSERT [ufs] ([iduf], [nomeuf], [siglauf], [idregioes], [idpais]) VALUES (17, N'Mato Grosso do Sul', N'MS', NULL, 1);
INSERT [ufs] ([iduf], [nomeuf], [siglauf], [idregioes], [idpais]) VALUES (18, N'Paraíba', N'PB', NULL, 1);
INSERT [ufs] ([iduf], [nomeuf], [siglauf], [idregioes], [idpais]) VALUES (19, N'Pará', N'PA', NULL, 1);
INSERT [ufs] ([iduf], [nomeuf], [siglauf], [idregioes], [idpais]) VALUES (20, N'Pernambuco', N'PE', NULL, 1);
INSERT [ufs] ([iduf], [nomeuf], [siglauf], [idregioes], [idpais]) VALUES (21, N'Piauí', N'PI', NULL, 1);
INSERT [ufs] ([iduf], [nomeuf], [siglauf], [idregioes], [idpais]) VALUES (22, N'Rio Grande do Norte', N'RN', NULL, 1);
INSERT [ufs] ([iduf], [nomeuf], [siglauf], [idregioes], [idpais]) VALUES (23, N'Rio Grande do Sul', N'RS', NULL, 1);
INSERT [ufs] ([iduf], [nomeuf], [siglauf], [idregioes], [idpais]) VALUES (24, N'Rondônia', N'RO', NULL, 1);
INSERT [ufs] ([iduf], [nomeuf], [siglauf], [idregioes], [idpais]) VALUES (25, N'Roraima', N'RR', NULL, 1);
INSERT [ufs] ([iduf], [nomeuf], [siglauf], [idregioes], [idpais]) VALUES (26, N'Santa Catarina', N'SC', NULL, 1);
INSERT [ufs] ([iduf], [nomeuf], [siglauf], [idregioes], [idpais]) VALUES (27, N'Sergipe', N'SE', NULL, 1);

CREATE TABLE [tipoproduto](
	[idtipoproduto] [int] NOT NULL,
	[idcategoria] [int] NULL,
	[idunidademedida] [int] NULL,
	[nomeproduto] [varchar](100) NOT NULL,
	[situacao] [char](1) NOT NULL,
	[aceitarequisicao] [char](1) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idtipoproduto] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_658] ON [tipoproduto] 
(
	[idcategoria] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_664] ON [tipoproduto] 
(
	[idunidademedida] ASC
)ON [PRIMARY];

CREATE TABLE [tipomudanca](
	[idtipomudanca] [int] NOT NULL,
	[idtipofluxo] [int] NULL,
	[idmodeloemailcriacao] [int] NULL,
	[idmodeloemailfinalizacao] [int] NULL,
	[idmodeloemailacoes] [int] NULL,
	[idgrupoexecutor] [int] NULL,
	[idcalendario] [int] NULL,
	[nometipomudanca] [varchar](100) NULL,
	[datainicio] [date] NULL,
	[datafim] [date] NULL,
PRIMARY KEY CLUSTERED 
(
	[idtipomudanca] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [idcalendario] ON [tipomudanca] 
(
	[idcalendario] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [idgrupoexecutor] ON [tipomudanca] 
(
	[idgrupoexecutor] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [idtipofluxo] ON [tipomudanca] 
(
	[idtipofluxo] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [tipomudanca_ibfk_2] ON [tipomudanca] 
(
	[idmodeloemailcriacao] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [tipomudanca_ibfk_3] ON [tipomudanca] 
(
	[idmodeloemailfinalizacao] ASC
)ON [PRIMARY];

CREATE TABLE [tipoliberacao](
	[idtipoliberacao] [int] NOT NULL,
	[idtipofluxo] [int] NULL,
	[idmodeloemailcriacao] [int] NULL,
	[idmodeloemailfinalizacao] [int] NULL,
	[idmodeloemailacoes] [int] NULL,
	[idgrupoexecutor] [int] NULL,
	[idcalendario] [int] NULL,
	[nometipoliberacao] [varchar](100) NULL,
	[datainicio] [date] NULL,
	[datafim] [date] NULL,
 CONSTRAINT [tipoliberacao_pkey] PRIMARY KEY CLUSTERED 
(
	[idtipoliberacao] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [tipoliberacao_idcalendario_idx] ON [tipoliberacao] 
(
	[idcalendario] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [tipoliberacao_idgrupoexecutor_idx] ON [tipoliberacao] 
(
	[idgrupoexecutor] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [tipoliberacao_idmodeloemailacoes_idx] ON [tipoliberacao] 
(
	[idmodeloemailacoes] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [tipoliberacao_idmodeloemailcriacao_idx] ON [tipoliberacao] 
(
	[idmodeloemailcriacao] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [tipoliberacao_idmodeloemailfinalizacao_idx] ON [tipoliberacao] 
(
	[idmodeloemailfinalizacao] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [tipoliberacao_idtipofluxo_idx] ON [tipoliberacao] 
(
	[idtipofluxo] ASC
)ON [PRIMARY];

CREATE TRIGGER [timers_setCurrentTime] ON  [timers]
FOR UPDATE
AS
BEGIN
	SET NOCOUNT ON; 
	UPDATE tbl
	SET INITIALDATE = GETDATE()
	FROM timers AS tbl
	INNER JOIN inserted AS i
		ON tbl.TIMERID = i.TIMERID; 
END;

CREATE TRIGGER [tabfederacaodados_setCurrentTime] ON  [tabfederacaodados]
FOR UPDATE
AS
BEGIN
	SET NOCOUNT ON; 
	UPDATE tbl
	SET criacao = GETDATE()
	FROM tabfederacaodados AS tbl
	INNER JOIN inserted AS i
		ON tbl.nometabela = i.nometabela; 
END;

CREATE TRIGGER [cotacao_setCurrentTime] ON  [cotacao]
FOR UPDATE
AS
BEGIN
	SET NOCOUNT ON; 
	UPDATE tbl
	SET datahoracadastro = GETDATE()
	FROM cotacao AS tbl
	INNER JOIN inserted AS i
		ON tbl.idcotacao = i.idcotacao; 
END;

CREATE TRIGGER [contratos_hist_setCurrentTime] ON  [contratos_hist]
FOR UPDATE
AS
BEGIN
	SET NOCOUNT ON; 
	UPDATE tbl
	SET criadoem = GETDATE()
	FROM contratos_hist AS tbl
	INNER JOIN inserted AS i
		ON tbl.idcontrato_hist = i.idcontrato_hist; 
END;

CREATE TABLE [criteriocotacaocategoria](
	[idcategoria] [int] NOT NULL,
	[idcriterio] [int] NOT NULL,
	[pesocotacao] [int] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idcategoria] ASC,
	[idcriterio] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [idcriterio] ON [criteriocotacaocategoria] 
(
	[idcriterio] ASC
)ON [PRIMARY];

CREATE TABLE [criteriocotacao](
	[idcotacao] [int] NOT NULL,
	[idcriterio] [int] NOT NULL,
	[peso] [int] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idcotacao] ASC,
	[idcriterio] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_33] ON [criteriocotacao] 
(
	[idcriterio] ASC
)ON [PRIMARY];

CREATE TRIGGER [controleged_setCurrentTime] ON  [controleged]
FOR UPDATE
AS
BEGIN
	SET NOCOUNT ON; 
	UPDATE tbl
	SET datahora = GETDATE()
	FROM controleged AS tbl
	INNER JOIN inserted AS i
		ON tbl.idcontroleged = i.idcontroleged; 
END;

CREATE TABLE [contadoracesso](
	[idcontadoracesso] [int] NOT NULL,
	[idusuario] [int] NULL,
	[idbaseconhecimento] [int] NULL,
	[datahoraacesso] [datetime] NOT NULL,
	[contadoracesso] [int] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idcontadoracesso] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_608] ON [contadoracesso] 
(
	[idusuario] ASC
)ON [PRIMARY];

CREATE TABLE [categoriaproblema](
	[idcategoriaproblema] [int] NOT NULL,
	[cat_idcategoriaproblema] [int] NULL,
	[idcategoriaproblemapai] [int] NULL,
	[nomecategoria] [int] NULL,
	[idtipofluxo] [int] NULL,
	[idgrupoexecutor] [int] NULL,
	[datainicio] [date] NULL,
	[datafim] [date] NULL,
	[nomecategoriaproblema] [varchar](100) NULL,
	[idtemplate] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[idcategoriaproblema] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_617] ON [categoriaproblema] 
(
	[cat_idcategoriaproblema] ASC
)ON [PRIMARY];

CREATE TRIGGER [bpm_instanciafluxo_setCurrentTime] ON  [bpm_instanciafluxo]
FOR UPDATE
AS
BEGIN
	SET NOCOUNT ON; 
	UPDATE tbl
	SET datahoracriacao = GETDATE()
	FROM bpm_instanciafluxo AS tbl
	INNER JOIN inserted AS i
		ON tbl.idinstancia = i.idinstancia; 
END;

CREATE TABLE [categoriamudanca](
	[idcategoriamudanca] [int] NOT NULL,
	[idtipofluxo] [int] NULL,
	[idmodeloemailcriacao] [int] NULL,
	[idmodeloemailfinalizacao] [int] NULL,
	[idmodeloemailacoes] [int] NULL,
	[idgruponivel1] [int] NULL,
	[idgrupoexecutor] [int] NULL,
	[idcalendario] [int] NULL,
	[idcategoriamudancapai] [int] NULL,
	[nomecategoria] [varchar](100) NULL,
	[datainicio] [date] NULL,
	[datafim] [date] NULL,
PRIMARY KEY CLUSTERED 
(
	[idcategoriamudanca] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_categori_reference_bpm_tipo] ON [categoriamudanca] 
(
	[idtipofluxo] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_categori_reference_calendar] ON [categoriamudanca] 
(
	[idcalendario] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_categori_reference_grupo] ON [categoriamudanca] 
(
	[idgruponivel1] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_categori_reference_grupo_01] ON [categoriamudanca] 
(
	[idgrupoexecutor] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_categori_reference_modelose] ON [categoriamudanca] 
(
	[idmodeloemailcriacao] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_categori_reference_modelose_01] ON [categoriamudanca] 
(
	[idmodeloemailfinalizacao] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_categori_reference_modelose_02] ON [categoriamudanca] 
(
	[idmodeloemailacoes] ASC
)ON [PRIMARY];

CREATE TABLE [catalogoservico](
	[idcatalogoservico] [int] NOT NULL,
	[idcontrato] [int] NULL,
	[datainicio] [date] NULL,
	[datafim] [date] NULL,
	[obs] [text] NULL,
	[nomeservico] [char](150) NULL,
	[titulocatalogoservico] [varchar](256) NULL,
PRIMARY KEY CLUSTERED 
(
	[idcatalogoservico] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE UNIQUE NONCLUSTERED INDEX [ak_key_1_catalago] ON [catalogoservico] 
(
	[idcatalogoservico] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_infocata_reference_contratos] ON [catalogoservico] 
(
	[idcontrato] ASC
)ON [PRIMARY];

CREATE TRIGGER [bpm_itemtrabalhofluxo_setCurrentTime] ON  [bpm_itemtrabalhofluxo]
FOR UPDATE
AS
BEGIN
	SET NOCOUNT ON; 
	UPDATE tbl
	SET datahoracriacao = GETDATE()
	FROM bpm_itemtrabalhofluxo AS tbl
	INNER JOIN inserted AS i
		ON tbl.iditemtrabalho = i.iditemtrabalho; 
END;

CREATE TRIGGER [bpm_historicoitemtrabalho_setCurrentTime] ON  [bpm_historicoitemtrabalho]
FOR UPDATE
AS
BEGIN
	SET NOCOUNT ON; 
	UPDATE tbl
	SET datahora = GETDATE()
	FROM bpm_historicoitemtrabalho AS tbl
	INNER JOIN inserted AS i
		ON tbl.idhistoricoitemtrabalho = i.idhistoricoitemtrabalho; 
END;

CREATE TRIGGER [bpm_atribuicaofluxo_setCurrentTime] ON  [bpm_atribuicaofluxo]
FOR UPDATE
AS
BEGIN
	SET NOCOUNT ON; 
	UPDATE tbl
	SET datahora = GETDATE()
	FROM bpm_atribuicaofluxo AS tbl
	INNER JOIN inserted AS i
		ON tbl.idatribuicao = i.idatribuicao; 
END;

CREATE TABLE [baseconhecimento](
	[idbaseconhecimento] [int] NOT NULL,
	[idpasta] [int] NULL,
	[datainicio] [date] NOT NULL,
	[datafim] [date] NULL,
	[titulo] [varchar](256) NOT NULL,
	[conteudo] [text] NULL,
	[status] [char](1) NOT NULL,
	[idbaseconhecimentopai] [int] NULL,
	[dataexpiracao] [date] NULL,
	[versao] [varchar](45) NULL,
	[idnotificacao] [int] NULL,
	[justificativaobservacao] [varchar](500) NULL,
	[datapublicacao] [date] NULL,
	[fontereferencia] [varchar](255) NULL,
	[faq] [varchar](45) NULL,
	[arquivado] [varchar](45) NULL,
	[idusuarioautor] [int] NULL,
	[idusuarioaprovador] [int] NULL,
	[idhistoricobaseconhecimento] [int] NULL,
	[origem] [char](1) NOT NULL,
	[privacidade] [varchar](45) NULL,
	[situacao] [varchar](45) NULL,
	[gerenciamentoDisponibilidade] [char](1) NULL,
	[direitoAutoral] [char](1) NULL,
	[legislacao] [char](1) NULL,
	[conteudosemformatacao] [text] NULL,
	[erroconhecido] [char](1) NULL,
PRIMARY KEY CLUSTERED 
(
	[idbaseconhecimento] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [idhistoricobaseconhecimento] ON [baseconhecimento] 
(
	[idhistoricobaseconhecimento] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [idnotificacao] ON [baseconhecimento] 
(
	[idnotificacao] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_BASECONHECIMENTOPAI] ON [baseconhecimento] 
(
	[idbaseconhecimentopai] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [INDEX_BASEPASTA] ON [baseconhecimento] 
(
	[idpasta] ASC
)ON [PRIMARY];

INSERT [baseconhecimento] ([idbaseconhecimento], [idpasta], [datainicio], [datafim], [titulo], [conteudo], [status], [idbaseconhecimentopai], [dataexpiracao], [versao], [idnotificacao], [justificativaobservacao], [datapublicacao], [fontereferencia], [faq], [arquivado], [idusuarioautor], [idusuarioaprovador], [idhistoricobaseconhecimento], [origem], [privacidade], [situacao], [gerenciamentoDisponibilidade], [direitoAutoral], [legislacao], [conteudosemformatacao], [erroconhecido]) VALUES (1, 1, CAST(0xF5360B00 AS Date), NULL, N'Conhecimento 1', N'Descri&ccedil;&atilde;o Conhecimento 1<br />', N'S', NULL, CAST(0x6D390B00 AS Date), N'1.0', NULL, N'Justificativa Conhecimento 1', CAST(0xF5360B00 AS Date), N'Conhecimento 1', NULL, N'N', 1, 1, 1, N'1', N'C', N'DS', NULL, NULL, NULL, N'Descrição Conhecimento 1', NULL);
INSERT [baseconhecimento] ([idbaseconhecimento], [idpasta], [datainicio], [datafim], [titulo], [conteudo], [status], [idbaseconhecimentopai], [dataexpiracao], [versao], [idnotificacao], [justificativaobservacao], [datapublicacao], [fontereferencia], [faq], [arquivado], [idusuarioautor], [idusuarioaprovador], [idhistoricobaseconhecimento], [origem], [privacidade], [situacao], [gerenciamentoDisponibilidade], [direitoAutoral], [legislacao], [conteudosemformatacao], [erroconhecido]) VALUES (2, 2, CAST(0xF5360B00 AS Date), NULL, N'Conhecimento 2', N'Descri&ccedil;&atilde;o Conhecimento 2<br />', N'S', NULL, CAST(0x6D390B00 AS Date), N'1.0', NULL, N'Justificativa Conhecimento 2', CAST(0xF5360B00 AS Date), N'', NULL, N'N', 1, 1, 2, N'1', N'C', N'DS', NULL, NULL, NULL, N'Descrição Conhecimento 2', NULL);
INSERT [baseconhecimento] ([idbaseconhecimento], [idpasta], [datainicio], [datafim], [titulo], [conteudo], [status], [idbaseconhecimentopai], [dataexpiracao], [versao], [idnotificacao], [justificativaobservacao], [datapublicacao], [fontereferencia], [faq], [arquivado], [idusuarioautor], [idusuarioaprovador], [idhistoricobaseconhecimento], [origem], [privacidade], [situacao], [gerenciamentoDisponibilidade], [direitoAutoral], [legislacao], [conteudosemformatacao], [erroconhecido]) VALUES (3, 1, CAST(0xF5360B00 AS Date), NULL, N'FAQ 1', N'Resposta FAQ 1<br />', N'S', NULL, CAST(0x6D390B00 AS Date), N'1.0', NULL, N'Justificativa FAQ 1', CAST(0xF5360B00 AS Date), N'FAQ 1', N'S', N'N', 1, 1, 3, N'1', N'C', N'DS', NULL, NULL, NULL, N'Resposta FAQ 1', NULL);
INSERT [baseconhecimento] ([idbaseconhecimento], [idpasta], [datainicio], [datafim], [titulo], [conteudo], [status], [idbaseconhecimentopai], [dataexpiracao], [versao], [idnotificacao], [justificativaobservacao], [datapublicacao], [fontereferencia], [faq], [arquivado], [idusuarioautor], [idusuarioaprovador], [idhistoricobaseconhecimento], [origem], [privacidade], [situacao], [gerenciamentoDisponibilidade], [direitoAutoral], [legislacao], [conteudosemformatacao], [erroconhecido]) VALUES (4, 2, CAST(0xF5360B00 AS Date), NULL, N'FAQ 2', N'Resposta FAQ 2', N'S', NULL, CAST(0x6D390B00 AS Date), N'1.0', NULL, N'Justificativa FAQ 2', CAST(0xF5360B00 AS Date), N'FAQ 2', N'S', N'N', 1, 1, 4, N'1', N'C', N'DS', NULL, NULL, NULL, N'Resposta FAQ 2', NULL);

CREATE TABLE [avaliacaocotacao](
	[idcriterio] [int] NOT NULL,
	[idfornecedor] [int] NOT NULL,
	[iditemcotacao] [int] NOT NULL,
	[avaliacao] [int] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idcriterio] ASC,
	[idfornecedor] ASC,
	[iditemcotacao] ASC
)
) ON [PRIMARY];

CREATE TRIGGER [acordonivelservico_setCurrentTime] ON  [acordonivelservico]
FOR UPDATE
AS
BEGIN
	SET NOCOUNT ON; 
	UPDATE tbl
	SET criadoEm = GETDATE()
	FROM acordonivelservico AS tbl
	INNER JOIN inserted AS i
		ON tbl.idacordonivelservico = i.idacordonivelservico; 
END;

CREATE TABLE [alcadacentroresultado](
	[idalcadacentroresultado] [int] NOT NULL,
	[idcentroresultado] [int] NOT NULL,
	[idempregado] [int] NOT NULL,
	[idalcada] [int] NOT NULL,
	[datainicio] [date] NOT NULL,
	[datafim] [date] NULL,
PRIMARY KEY CLUSTERED 
(
	[idalcadacentroresultado] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_662] ON [alcadacentroresultado] 
(
	[idcentroresultado] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_663] ON [alcadacentroresultado] 
(
	[idempregado] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_673] ON [alcadacentroresultado] 
(
	[idalcada] ASC
)ON [PRIMARY];

CREATE TRIGGER [accountlines_setCurrentTime] ON  [accountLines]
FOR UPDATE
AS
BEGIN
	SET NOCOUNT ON; 
	UPDATE al
	SET ts = GETDATE()
	FROM accountLines AS al
	INNER JOIN inserted AS i
		ON al.id = i.id; 
END;

CREATE TABLE [acordonivelservico_hist](
	[idacordonivelservico_hist] [bigint] NOT NULL,
	[idacordonivelservico] [bigint] NOT NULL,
	[idservicocontrato] [bigint] NULL,
	[idprioridadepadrao] [int] NULL,
	[situacao] [char](1) NOT NULL,
	[titulosla] [varchar](500) NOT NULL,
	[disponibilidade] [decimal](10, 3) NULL,
	[descricaosla] [text] NULL,
	[escoposla] [text] NULL,
	[datainicio] [date] NOT NULL,
	[datafim] [date] NULL,
	[avaliarem] [date] NULL,
	[tipo] [char](1) NULL,
	[valorlimite] [decimal](15, 3) NULL,
	[detalheglosa] [text] NULL,
	[detalhelimiteglosa] [text] NULL,
	[unidadevalorlimite] [varchar](150) NULL,
	[impacto] [char](1) NULL,
	[urgencia] [char](1) NULL,
	[permiteMudarImpUrg] [char](1) NULL,
	[deleted] [char](1) NULL,
	[criadoem] [datetime] NOT NULL,
	[criadopor] [varchar](255) NULL,
	[modificadoem] [datetime] NOT NULL,
	[modificadopor] [varchar](255) NULL,
	[conteudodados] [text] NULL,
	[idformula] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[idacordonivelservico_hist] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_102] ON [acordonivelservico_hist] 
(
	[idprioridadepadrao] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_91] ON [acordonivelservico_hist] 
(
	[idservicocontrato] ASC
)ON [PRIMARY];

INSERT [acordonivelservico_hist] ([idacordonivelservico_hist], [idacordonivelservico], [idservicocontrato], [idprioridadepadrao], [situacao], [titulosla], [disponibilidade], [descricaosla], [escoposla], [datainicio], [datafim], [avaliarem], [tipo], [valorlimite], [detalheglosa], [detalhelimiteglosa], [unidadevalorlimite], [impacto], [urgencia], [permiteMudarImpUrg], [deleted], [criadoem], [criadopor], [modificadoem], [modificadopor], [conteudodados], [idformula]) VALUES (1, 1, NULL, NULL, N'a', N'teste', NULL, NULL, NULL, CAST(0xFF330B00 AS Date), NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, CAST('2013-04-05 13:40:00' AS datetime), NULL, CAST('2013-04-05 13:40:00' AS datetime), NULL, NULL, NULL);
INSERT [acordonivelservico_hist] ([idacordonivelservico_hist], [idacordonivelservico], [idservicocontrato], [idprioridadepadrao], [situacao], [titulosla], [disponibilidade], [descricaosla], [escoposla], [datainicio], [datafim], [avaliarem], [tipo], [valorlimite], [detalheglosa], [detalhelimiteglosa], [unidadevalorlimite], [impacto], [urgencia], [permiteMudarImpUrg], [deleted], [criadoem], [criadopor], [modificadoem], [modificadopor], [conteudodados], [idformula]) VALUES (2, 2, NULL, NULL, N'a', N'teste', NULL, NULL, NULL, CAST(0xFF330B00 AS Date), NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, CAST('2013-04-05 13:40:00' AS datetime), NULL, CAST('2013-04-05 13:40:00' AS datetime), NULL, NULL, NULL);
INSERT [acordonivelservico_hist] ([idacordonivelservico_hist], [idacordonivelservico], [idservicocontrato], [idprioridadepadrao], [situacao], [titulosla], [disponibilidade], [descricaosla], [escoposla], [datainicio], [datafim], [avaliarem], [tipo], [valorlimite], [detalheglosa], [detalhelimiteglosa], [unidadevalorlimite], [impacto], [urgencia], [permiteMudarImpUrg], [deleted], [criadoem], [criadopor], [modificadoem], [modificadopor], [conteudodados], [idformula]) VALUES (3, 3, NULL, NULL, N'a', N'b', NULL, NULL, NULL, CAST(0xFF330B00 AS Date), NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, CAST('2013-04-05 13:40:00' AS datetime), NULL, CAST('2013-04-05 13:40:00' AS datetime), NULL, NULL, NULL);

CREATE TRIGGER [historicoic_setCurrentTime] ON  [historicoic]
FOR UPDATE
AS
BEGIN
	SET NOCOUNT ON; 
	UPDATE tbl
	SET datahoraalteracao = GETDATE()
	FROM historicoic AS tbl
	INNER JOIN inserted AS i
		ON tbl.idhistoricoic = i.idhistoricoic; 
END;

CREATE TABLE [fluxoservico](
	[idservicocontrato] [bigint] NOT NULL,
	[idtipofluxo] [int] NOT NULL,
	[idfase] [bigint] NOT NULL,
	[principal] [char](1) NOT NULL,
	[deleted] [char](1) NULL,
	[idfluxoservico] [bigint] NOT NULL,
 CONSTRAINT [fluxoservico_pkey] PRIMARY KEY CLUSTERED 
(
	[idfluxoservico] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_117] ON [fluxoservico] 
(
	[idfase] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_93] ON [fluxoservico] 
(
	[idtipofluxo] ASC
)ON [PRIMARY];

CREATE TABLE [dicionario](
	[iddicionario] [int] NOT NULL,
	[nome] [varchar](245) NULL,
	[valor] [varchar](500) NULL,
	[idlingua] [int] NULL,
	[personalizado] [char](1) NULL
PRIMARY KEY CLUSTERED 
(
	[iddicionario] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [idlingua] ON [dicionario] 
(
	[idlingua] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [index_dic_lingua] ON [dicionario] 
(
	[idlingua] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [index_dic_nome] ON [dicionario] 
(
	[nome] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [index_dic_valor] ON [dicionario] 
(
	[valor] ASC
)ON [PRIMARY];

CREATE TRIGGER [execucaobatch_setCurrentTime] ON  [execucaobatch]
FOR UPDATE
AS
BEGIN
	SET NOCOUNT ON; 
	UPDATE tbl
	SET datahora = GETDATE()
	FROM execucaobatch AS tbl
	INNER JOIN inserted AS i
		ON tbl.idexecucaobatch = i.idexecucaobatch; 
END;

CREATE TABLE [execucaoliberacao](
	[idexecucao] [int] NOT NULL,
	[idinstanciafluxo] [bigint] NOT NULL,
	[idliberacao] [int] NOT NULL,
	[idfluxo] [bigint] NOT NULL,
	[seqreabertura] [smallint] NULL,
 CONSTRAINT [execucaoliberacao_pkey] PRIMARY KEY CLUSTERED 
(
	[idexecucao] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [execucaoliberacao_idfluxo_idx] ON [execucaoliberacao] 
(
	[idfluxo] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [execucaoliberacao_idinstanciafluxo_idx] ON [execucaoliberacao] 
(
	[idinstanciafluxo] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [execucaoliberacao_idrequisicaoliberacao_idx] ON [execucaoliberacao] 
(
	[idliberacao] ASC
)ON [PRIMARY];

CREATE TABLE [limitealcada](
	[idlimitealcada] [int] NOT NULL,
	[idalcada] [int] NOT NULL,
	[idgrupo] [int] NOT NULL,
	[tipolimite] [char](1) NULL,
	[abrangenciacentrocusto] [varchar](20) NOT NULL,
	[limiteitemusointerno] [decimal](11, 2) NULL,
	[limitevalormensal] [decimal](11, 2) NULL,
	[situacao] [char](1) NOT NULL,
	[limiteitematendcliente] [decimal](11, 2) NULL,
	[limitemensalatendcliente] [decimal](11, 2) NULL,
PRIMARY KEY CLUSTERED 
(
	[idlimitealcada] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_647] ON [limitealcada] 
(
	[idalcada] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_649] ON [limitealcada] 
(
	[idgrupo] ASC
)ON [PRIMARY];

CREATE TABLE [localidadeunidade](
	[idlocalidadeunidade] [int] NOT NULL,
	[idunidade] [int] NOT NULL,
	[idlocalidade] [int] NOT NULL,
	[datainicio] [date] NULL,
	[datafim] [date] NULL,
PRIMARY KEY CLUSTERED 
(
	[idlocalidadeunidade] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_localida_reference_localida] ON [localidadeunidade] 
(
	[idlocalidade] ASC
)ON [PRIMARY];

CREATE TRIGGER [itemcotacao_setCurrentTime] ON  [itemcotacao]
FOR UPDATE
AS
BEGIN
	SET NOCOUNT ON; 
	UPDATE tbl
	SET datahoralimite = GETDATE()
	FROM itemcotacao AS tbl
	INNER JOIN inserted AS i
		ON tbl.iditemcotacao = i.iditemcotacao; 
END;

CREATE TRIGGER [historicovalor_setCurrentTime] ON  [historicovalor]
FOR UPDATE
AS
BEGIN
	SET NOCOUNT ON; 
	UPDATE tbl
	SET datahoraalteracao = GETDATE()
	FROM historicovalor AS tbl
	INNER JOIN inserted AS i
		ON tbl.idhistoricovalor = i.idhistoricovalor; 
END;

CREATE TABLE [importconfig](
	[idimportconfig] [int] NOT NULL,
	[tipo] [char](1) NOT NULL,
	[idexternalconnection] [int] NULL,
	[tabelaorigem] [varchar](255) NULL,
	[tabeladestino] [varchar](255) NULL,
	[filtroorigem] [text] NULL,
	[nome] [varchar](100) NULL,
PRIMARY KEY CLUSTERED 
(
	[idimportconfig] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_ref_impconx] ON [importconfig] 
(
	[idexternalconnection] ASC
)ON [PRIMARY];

CREATE TABLE [historicosituacaocotacao](
	[idhistorico] [int] NOT NULL,
	[idcotacao] [int] NOT NULL,
	[idresponsavel] [int] NOT NULL,
	[datahora] [datetime] NOT NULL,
	[situacao] [varchar](25) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idhistorico] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [idcotacao] ON [historicosituacaocotacao] 
(
	[idcotacao] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [idresponsavel] ON [historicosituacaocotacao] 
(
	[idresponsavel] ASC
)ON [PRIMARY];

CREATE TABLE [importconfigcampos](
	[idimportconfigcampo] [int] NOT NULL,
	[idimportconfig] [int] NOT NULL,
	[origem] [varchar](255) NULL,
	[destino] [varchar](255) NULL,
	[script] [text] NULL,
PRIMARY KEY CLUSTERED 
(
	[idimportconfigcampo] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_ref_impcp_imp] ON [importconfigcampos] 
(
	[idimportconfig] ASC
)ON [PRIMARY];

CREATE TRIGGER [historicosituacaocotacao_setCurrentTime] ON  [historicosituacaocotacao]
FOR UPDATE
AS
BEGIN
	SET NOCOUNT ON; 
	UPDATE tbl
	SET datahora = GETDATE()
	FROM historicosituacaocotacao AS tbl
	INNER JOIN inserted AS i
		ON tbl.idhistorico = i.idhistorico; 
END;

CREATE TABLE [marca](
	[idmarca] [int] NOT NULL,
	[idfabricante] [bigint] NULL,
	[nomemarca] [varchar](100) NOT NULL,
	[situacao] [char](1) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idmarca] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_661] ON [marca] 
(
	[idfabricante] ASC
)ON [PRIMARY];

CREATE TABLE [fornecedorcotacao](
	[idcotacao] [int] NOT NULL,
	[idfornecedor] [bigint] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idcotacao] ASC,
	[idfornecedor] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_685] ON [fornecedorcotacao] 
(
	[idfornecedor] ASC
)ON [PRIMARY];

CREATE TABLE [acordoservicocontrato](
	[idacordoservicocontrato] [bigint] NOT NULL,
	[idacordonivelservico] [bigint] NOT NULL,
	[idservicocontrato] [bigint] NOT NULL,
	[datacriacao] [date] NOT NULL,
	[datainicio] [date] NULL,
	[datafim] [date] NULL,
	[dataultatualiz] [date] NULL,
	[deleted] [char](1) NULL,
	[idrecurso] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[idacordoservicocontrato] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_ref_asc_rec] ON [acordoservicocontrato] 
(
	[idrecurso] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_627] ON [acordoservicocontrato] 
(
	[idacordonivelservico] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_628] ON [acordoservicocontrato] 
(
	[idservicocontrato] ASC
)ON [PRIMARY];

INSERT [acordoservicocontrato] ([idacordoservicocontrato], [idacordonivelservico], [idservicocontrato], [datacriacao], [datainicio], [datafim], [dataultatualiz], [deleted], [idrecurso]) VALUES (1, 1, 1, CAST(0xF2360B00 AS Date), CAST(0xEE360B00 AS Date), NULL, CAST(0xF2360B00 AS Date), NULL, NULL);
INSERT [acordoservicocontrato] ([idacordoservicocontrato], [idacordonivelservico], [idservicocontrato], [datacriacao], [datainicio], [datafim], [dataultatualiz], [deleted], [idrecurso]) VALUES (2, 1, 2, CAST(0xF2360B00 AS Date), CAST(0xEE360B00 AS Date), NULL, CAST(0xF2360B00 AS Date), NULL, NULL);
INSERT [acordoservicocontrato] ([idacordoservicocontrato], [idacordonivelservico], [idservicocontrato], [datacriacao], [datainicio], [datafim], [dataultatualiz], [deleted], [idrecurso]) VALUES (3, 2, 3, CAST(0xF2360B00 AS Date), CAST(0xEE360B00 AS Date), NULL, CAST(0xF2360B00 AS Date), NULL, NULL);
INSERT [acordoservicocontrato] ([idacordoservicocontrato], [idacordonivelservico], [idservicocontrato], [datacriacao], [datainicio], [datafim], [dataultatualiz], [deleted], [idrecurso]) VALUES (4, 2, 4, CAST(0xF2360B00 AS Date), CAST(0xEE360B00 AS Date), NULL, CAST(0xF2360B00 AS Date), NULL, NULL);
INSERT [acordoservicocontrato] ([idacordoservicocontrato], [idacordonivelservico], [idservicocontrato], [datacriacao], [datainicio], [datafim], [dataultatualiz], [deleted], [idrecurso]) VALUES (5, 3, 5, CAST(0xF2360B00 AS Date), CAST(0xEE360B00 AS Date), NULL, CAST(0xF2360B00 AS Date), NULL, NULL);

CREATE TABLE [faixavaloresrecurso](
	[idfaixavaloresrecurso] [int] NOT NULL,
	[idrecurso] [int] NOT NULL,
	[valorinicio] [decimal](15, 3) NULL,
	[valorfim] [decimal](15, 3) NULL,
	[cor] [varchar](20) NULL,
	[descricao] [varchar](80) NULL,
PRIMARY KEY CLUSTERED 
(
	[idfaixavaloresrecurso] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_604] ON [faixavaloresrecurso] 
(
	[idrecurso] ASC
)ON [PRIMARY];

CREATE TABLE [acaoplanomelhoria](
	[idacaoplanomelhoria] [int] NOT NULL,
	[idplanomelhoria] [int] NOT NULL,
	[idobjetivoplanomelhoria] [int] NOT NULL,
	[tituloacao] [varchar](255) NOT NULL,
	[detalhamentoacao] [text] NULL,
	[datainicio] [date] NULL,
	[datafim] [date] NULL,
	[responsavel] [varchar](255) NULL,
	[dataconclusao] [date] NULL,
	[criadopor] [varchar](255) NULL,
	[modificadopor] [varchar](255) NULL,
	[datacriacao] [date] NULL,
	[ultmodificacao] [date] NULL,
PRIMARY KEY CLUSTERED 
(
	[idacaoplanomelhoria] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_ref_plmact] ON [acaoplanomelhoria] 
(
	[idplanomelhoria] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [ix_act_pm_id] ON [acaoplanomelhoria] 
(
	[idobjetivoplanomelhoria] ASC
)ON [PRIMARY];

CREATE TABLE [apuracaovaloresrecurso](
	[idapuracaovaloresrecurso] [int] NOT NULL,
	[idrecurso] [int] NOT NULL,
	[valorinicio] [decimal](15, 3) NOT NULL,
	[deleted] [char](1) NULL,
PRIMARY KEY CLUSTERED 
(
	[idapuracaovaloresrecurso] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_606] ON [apuracaovaloresrecurso] 
(
	[idrecurso] ASC
)ON [PRIMARY];

CREATE TRIGGER [acordonivelservico_hist_setCurrentTime] ON  [acordonivelservico_hist]
FOR UPDATE
AS
BEGIN
	SET NOCOUNT ON; 
	UPDATE tbl
	SET criadoem = GETDATE()
	FROM acordonivelservico_hist AS tbl
	INNER JOIN inserted AS i
		ON tbl.idacordonivelservico_hist = i.idacordonivelservico_hist; 
END;

CREATE TABLE [avaliacaofornecedor](
	[idavaliacaofornecedor] [int] NOT NULL,
	[idfornecedor] [bigint] NULL,
	[idresponsavel] [int] NULL,
	[dataavaliacao] [date] NULL,
	[decisaoqualificacao] [char](1) NULL,
	[observacoes] [text] NULL,
	[contato] [varchar](245) NULL,
PRIMARY KEY CLUSTERED 
(
	[idavaliacaofornecedor] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_678] ON [avaliacaofornecedor] 
(
	[idfornecedor] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_683] ON [avaliacaofornecedor] 
(
	[idresponsavel] ASC
)ON [PRIMARY];

CREATE TABLE [conhecimentoliberacao](
	[idrequisicaoliberacao] [int] NOT NULL,
	[idbaseconhecimento] [int] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idrequisicaoliberacao] ASC,
	[idbaseconhecimento] ASC
)
) ON [PRIMARY];

CREATE TABLE [conhecimentoic](
	[iditemconfiguracao] [int] NOT NULL,
	[idbaseconhecimento] [int] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[iditemconfiguracao] ASC,
	[idbaseconhecimento] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_ref_conhic_bc] ON [conhecimentoic] 
(
	[idbaseconhecimento] ASC
)ON [PRIMARY];

CREATE TABLE [coletapreco](
	[idcoletapreco] [int] NOT NULL,
	[idfornecedor] [bigint] NOT NULL,
	[iditemcotacao] [int] NOT NULL,
	[idresponsavel] [int] NOT NULL,
	[idrespresultado] [int] NULL,
	[idjustifresultado] [int] NULL,
	[datacoleta] [date] NOT NULL,
	[datavalidade] [date] NULL,
	[especificacoes] [text] NULL,
	[preco] [decimal](8, 2) NOT NULL,
	[valoracrescimo] [decimal](8, 2) NOT NULL,
	[valordesconto] [decimal](8, 2) NOT NULL,
	[valorfrete] [decimal](8, 2) NOT NULL,
	[prazoentrega] [int] NOT NULL,
	[prazomediopagto] [decimal](4, 2) NOT NULL,
	[taxajuros] [decimal](4, 2) NOT NULL,
	[prazogarantia] [int] NOT NULL,
	[quantidadecotada] [decimal](8, 2) NOT NULL,
	[pontuacao] [decimal](8, 4) NULL,
	[resultadocalculo] [char](1) NULL,
	[quantidadecalculo] [decimal](8, 2) NULL,
	[resultadofinal] [char](1) NULL,
	[quantidadecompra] [decimal](8, 2) NULL,
	[complemjustifresultado] [text] NULL,
	[quantidadeaprovada] [decimal](8, 2) NULL,
	[quantidadepedido] [decimal](8, 2) NULL,
PRIMARY KEY CLUSTERED 
(
	[idcoletapreco] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_28] ON [coletapreco] 
(
	[iditemcotacao] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_635] ON [coletapreco] 
(
	[idfornecedor] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_636] ON [coletapreco] 
(
	[idfornecedor] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_695] ON [coletapreco] 
(
	[idrespresultado] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_698] ON [coletapreco] 
(
	[idjustifresultado] ASC
)ON [PRIMARY];

CREATE TABLE [conhecimentosolicitacaoservico](
	[idsolicitacaoservico] [bigint] NOT NULL,
	[idbaseconhecimento] [int] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idsolicitacaoservico] ASC,
	[idbaseconhecimento] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_ref_conhss_bc] ON [conhecimentosolicitacaoservico] 
(
	[idbaseconhecimento] ASC
)ON [PRIMARY];

CREATE TABLE [conhecimentoproblema](
	[idproblema] [int] NOT NULL,
	[idbaseconhecimento] [int] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idproblema] ASC,
	[idbaseconhecimento] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_ref_conhpb_bc] ON [conhecimentoproblema] 
(
	[idbaseconhecimento] ASC
)ON [PRIMARY];

CREATE TABLE [slarequisitosla](
       [idrequisitosla] [int] NOT NULL,
       [idacordonivelservico] [bigint] NOT NULL,
       [datavinculacao] [datetime] NOT NULL,
       [dataultmodificacao] [datetime] NOT NULL,
       [deleted] [char](1) NULL,
PRIMARY KEY CLUSTERED 
(
       [idrequisitosla] ASC,
       [idacordonivelservico] ASC
)
) ON [PRIMARY];


CREATE NONCLUSTERED INDEX [fk_reference_554] ON [slarequisitosla] 
(
	[idacordonivelservico] ASC
)ON [PRIMARY];

CREATE TABLE [objetivomonitoramento](
	[idobjetivomonitoramento] [int] NOT NULL,
	[idobjetivoplanomelhoria] [int] NOT NULL,
	[titulomonitoramento] [varchar](255) NOT NULL,
	[fatorcriticosucesso] [varchar](255) NULL,
	[kpi] [varchar](255) NULL,
	[metrica] [text] NULL,
	[medicao] [text] NULL,
	[relatorios] [text] NULL,
	[responsavel] [varchar](255) NULL,
	[criadopor] [varchar](255) NULL,
	[modificadopor] [varchar](255) NULL,
	[datacriacao] [date] NULL,
	[ultmodificacao] [date] NULL,
PRIMARY KEY CLUSTERED 
(
	[idobjetivomonitoramento] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_ref_objmn] ON [objetivomonitoramento] 
(
	[idobjetivoplanomelhoria] ASC
)ON [PRIMARY];

CREATE TABLE [requisicaomudanca](
	[idrequisicaomudanca] [int] NOT NULL,
	[idproprietario] [int] NOT NULL,
	[idsolicitante] [int] NOT NULL,
	[idtipomudanca] [int] NULL,
	[idgruponivel1] [int] NULL,
	[idgrupoatual] [int] NULL,
	[idcalendario] [int] NULL,
	[motivo] [varchar](255) NULL,
	[nivelimportancianegocio] [varchar](255) NULL,
	[classificacao] [varchar](255) NULL,
	[nivelimpacto] [varchar](255) NULL,
	[analiseimpacto] [varchar](3000) NULL,
	[datahoraconclusao] [datetime] NULL,
	[dataaceitacao] [date] NULL,
	[datavotacao] [date] NULL,
	[datahorainicio] [datetime] NULL,
	[datahoratermino] [datetime] NULL,
	[titulo] [varchar](255) NULL,
	[descricao] [varchar](255) NULL,
	[risco] [varchar](255) NULL,
	[estimativacusto] [float] NULL,
	[planoreversao] [varchar](3000) NULL,
	[status] [varchar](45) NULL,
	[prioridade] [int] NULL,
	[enviaemailcriacao] [varchar](1) NULL,
	[enviaemailfinalizacao] [varchar](1) NULL,
	[enviaemailacoes] [varchar](1) NULL,
	[exibirquadromudancas] [varchar](1) NULL,
	[seqreabertura] [smallint] NULL,
	[datahoracaptura] [datetime] NULL,
	[datahorareativacao] [datetime] NULL,
	[datahorasuspensao] [datetime] NULL,
	[tempodecorridohh] [smallint] NULL,
	[tempodecorridomm] [smallint] NULL,
	[prazohh] [smallint] NULL,
	[prazomm] [smallint] NULL,
	[tempoatendimentohh] [smallint] NULL,
	[tempoatendimentomm] [smallint] NULL,
	[tempoatrasohh] [smallint] NULL,
	[tempoatrasomm] [smallint] NULL,
	[tempocapturahh] [smallint] NULL,
	[tempocapturamm] [smallint] NULL,
	[fase] [varchar](20) NULL,
	[nivelurgencia] [varchar](255) NULL,
	[idbaseconhecimento] [int] NULL,
	[nomecategoriamudanca] [varchar](15) NULL,
	[idcontrato] [int] NOT NULL,
	[idunidade] [int] NULL,
	[idcontatorequisicaomudanca] [int] NULL,
	[idgrupocomite] [int] NULL,
	[enviaemailgrupocomite] [varchar](1) NULL,
	[datahorainicioagendada] [datetime] NULL,
	[datahoraterminoagendada] [datetime] NULL,
	[idlocalidade] [int] NULL,
	[fechamento] [text] NULL,
	[tipo] [varchar](255) NULL,
	[razaomudanca] [varchar](200) NULL,
PRIMARY KEY CLUSTERED 
(
	[idrequisicaomudanca] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_idbaseconhecimento] ON [requisicaomudanca] 
(
	[idbaseconhecimento] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_requisic_reference_calendar] ON [requisicaomudanca] 
(
	[idcalendario] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_requisic_reference_cat] ON [requisicaomudanca] 
(
	[idtipomudanca] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_requisic_reference_grupo] ON [requisicaomudanca] 
(
	[idgruponivel1] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_requisic_reference_grupo_01] ON [requisicaomudanca] 
(
	[idtipomudanca] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_requisic_reference_grupo_comite] ON [requisicaomudanca] 
(
	[idgrupocomite] ASC
)ON [PRIMARY];

CREATE TABLE [solicitacaoservicomudanca](
	[idrequisicaomudanca] [int] NULL,
	[idsolicitacaoservico] [bigint] NULL
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_solicita_reference_requisic] ON [solicitacaoservicomudanca] 
(
	[idrequisicaomudanca] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_solicita_reference_solmud] ON [solicitacaoservicomudanca] 
(
	[idsolicitacaoservico] ASC
)ON [PRIMARY];

CREATE TABLE [atividadeperiodica](
	[idatividadeperiodica] [int] NOT NULL,
	[idcontrato] [int] NULL,
	[idprocedimentotecnico] [int] NULL,
	[idgrupoatvperiodica] [int] NULL,
	[tituloatividade] [varchar](256) NULL,
	[descricao] [text] NULL,
	[datainicio] [date] NULL,
	[orientacaotecnica] [text] NULL,
	[datafim] [date] NULL,
	[criadopor] [varchar](30) NULL,
	[datacriacao] [date] NULL,
	[alteradopor] [varchar](30) NULL,
	[dataultalteracao] [date] NULL,
	[idsolicitacaoservico] [int] NULL,
	[idrequisicaomudanca] [int] NULL,
	[blackout] [char](1) NULL,
	[idproblema] [int] NULL,
	[idLiberacao] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[idatividadeperiodica] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_ref_reqmud] ON [atividadeperiodica] 
(
	[idrequisicaomudanca] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_563] ON [atividadeperiodica] 
(
	[idsolicitacaoservico] ASC
)ON [PRIMARY];

CREATE TABLE [relacionamentoproduto](
	[idtipoproduto] [int] NOT NULL,
	[idtipoprodutorelacionado] [int] NOT NULL,
	[tiporelacionamento] [char](1) NULL,
PRIMARY KEY CLUSTERED 
(
	[idtipoproduto] ASC,
	[idtipoprodutorelacionado] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_655] ON [relacionamentoproduto] 
(
	[idtipoprodutorelacionado] ASC
)ON [PRIMARY];

CREATE TRIGGER [parecer_setCurrentTime] ON  [parecer]
FOR UPDATE
AS
BEGIN
	SET NOCOUNT ON; 
	UPDATE tbl
	SET datahoraparecer = GETDATE()
	FROM parecer AS tbl
	INNER JOIN inserted AS i
		ON tbl.idparecer = i.idparecer; 
END;

CREATE TRIGGER [requisitosla_setCurrentTime] ON  [requisitosla]
FOR UPDATE
AS
BEGIN
	SET NOCOUNT ON; 
	UPDATE tbl
	SET criadoem = GETDATE()
	FROM requisitosla AS tbl
	INNER JOIN inserted AS i
		ON tbl.idrequisitosla = i.idrequisitosla; 
END;

CREATE TABLE [sequence_block_controller](
       [id] [bigint] NOT NULL IDENTITY(1,1) ,
       [sequence_name] [varchar](80) NOT NULL,
       [last_id] [bigint] NOT NULL
PRIMARY KEY CLUSTERED 
(
       [id] ASC
)
);

CREATE UNIQUE NONCLUSTERED INDEX [sequence_name_idx] ON [sequence_block_controller] 
(
       [sequence_name] ASC
)ON [PRIMARY];


CREATE TABLE [servcontratocatalogoserv](
	[idservicocontrato] [bigint] NULL,
	[idcatalogoservico] [int] NULL
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_servcontr_reference_catalogoservico] ON [servcontratocatalogoserv] 
(
	[idcatalogoservico] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_servcontr_reference_servico] ON [servcontratocatalogoserv] 
(
	[idservicocontrato] ASC
)ON [PRIMARY];

CREATE TRIGGER [slarequisitosla_setCurrentTime] ON  [slarequisitosla]
FOR UPDATE
AS
BEGIN
	SET NOCOUNT ON; 
	UPDATE tbl
	SET datavinculacao = GETDATE()
	FROM slarequisitosla AS tbl
	INNER JOIN inserted AS i
		ON tbl.idrequisitosla = i.idrequisitosla; 
END;

CREATE TABLE [requisicaomudancaservico](
	[idrequisicaomudancaservico] [int] NOT NULL,
	[idrequisicaomudanca] [int] NOT NULL,
	[idservico] [bigint] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idrequisicaomudancaservico] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_requisic_referenc_req] ON [requisicaomudancaservico] 
(
	[idrequisicaomudanca] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_requisic_reference_servico] ON [requisicaomudancaservico] 
(
	[idservico] ASC
)ON [PRIMARY];

CREATE TABLE [requisicaomudancarisco](
	[idrequisicaomudancarisco] [int] NOT NULL,
	[idrequisicaomudanca] [int] NOT NULL,
	[idrisco] [bigint] NOT NULL,
 CONSTRAINT [requisicaomudancarisco_pkey] PRIMARY KEY CLUSTERED 
(
	[idrequisicaomudancarisco] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [requisicaomudancarisco_idrequisicaomudanca_idx] ON [requisicaomudancarisco] 
(
	[idrequisicaomudanca] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [requisicaomudancarisco_idrisco_idx] ON [requisicaomudancarisco] 
(
	[idrisco] ASC
)ON [PRIMARY];

CREATE TABLE [requisicaomudancaitemconfiguracao](
	[idrequisicaomudancaitemconfiguracao] [int] NOT NULL,
	[idrequisicaomudanca] [int] NULL,
	[iditemconfiguracao] [int] NULL,
	[descricao] [varchar](100) NULL,
PRIMARY KEY CLUSTERED 
(
	[idrequisicaomudancaitemconfiguracao] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_requisic_reference_itemconf] ON [requisicaomudancaitemconfiguracao] 
(
	[iditemconfiguracao] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_requisic_reference_req] ON [requisicaomudancaitemconfiguracao] 
(
	[idrequisicaomudanca] ASC
)ON [PRIMARY];

CREATE TABLE [produto](
	[idproduto] [int] NOT NULL,
	[idtipoproduto] [int] NOT NULL,
	[idmarca] [int] NULL,
	[modelo] [varchar](25) NULL,
	[precomercado] [decimal](8, 2) NULL,
	[detalhes] [text] NULL,
	[codigoproduto] [varchar](25) NULL,
	[situacao] [char](1) NOT NULL,
	[complemento] [varchar](100) NULL,
PRIMARY KEY CLUSTERED 
(
	[idproduto] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_671] ON [produto] 
(
	[idtipoproduto] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_672] ON [produto] 
(
	[idmarca] ASC
)ON [PRIMARY];

CREATE TABLE [ocorrenciamudanca](
	[idocorrencia] [int] NOT NULL,
	[iditemtrabalho] [bigint] NULL,
	[idjustificativa] [int] NULL,
	[idrequisicaomudanca] [int] NULL,
	[dataregistro] [date] NULL,
	[horaregistro] [varchar](5) NULL,
	[registradopor] [varchar](100) NULL,
	[descricao] [varchar](200) NULL,
	[datainicio] [date] NULL,
	[datafim] [date] NULL,
	[complementojustificativa] [nvarchar](max) NULL,
	[dadosmudanca] [nvarchar](max) NULL,
	[informacoescontato] [nvarchar](max) NULL,
	[categoria] [varchar](20) NULL,
	[origem] [char](1) NULL,
	[tempogasto] [smallint] NULL,
	[ocorrencia] [nvarchar](max) NULL,
	[idcategoriaocorrencia] [int] NULL,
	[idorigemocorrencia] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[idocorrencia] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_ocorrenc_reference_bpm_item] ON [ocorrenciamudanca] 
(
	[iditemtrabalho] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_ocorrenc_reference_justific] ON [ocorrenciamudanca] 
(
	[idjustificativa] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_ocorrenc_reference_requisic] ON [ocorrenciamudanca] 
(
	[idrequisicaomudanca] ASC
)ON [PRIMARY];

CREATE TABLE [criterioavaliacaofornecedor](
	[idavaliacaofornecedor] [int] NOT NULL,
	[idcriterio] [int] NOT NULL,
	[valor] [int] NULL,
	[observacoes] [text] NULL,
PRIMARY KEY CLUSTERED 
(
	[idavaliacaofornecedor] ASC,
	[idcriterio] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_680] ON [criterioavaliacaofornecedor] 
(
	[idcriterio] ASC
)ON [PRIMARY];

CREATE TABLE [conhecimentomudanca](
	[idrequisicaomudanca] [int] NOT NULL,
	[idbaseconhecimento] [int] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[idrequisicaomudanca] ASC,
	[idbaseconhecimento] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_ref_conhmud_bc] ON [conhecimentomudanca] 
(
	[idbaseconhecimento] ASC
)ON [PRIMARY];

CREATE TABLE [avaliacaoreferenciafornecedor](
	[idavaliacaofornecedor] [int] NOT NULL,
	[idempregado] [int] NOT NULL,
	[decisao] [char](1) NULL,
	[observacoes] [text] NULL,
PRIMARY KEY CLUSTERED 
(
	[idavaliacaofornecedor] ASC,
	[idempregado] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_6896] ON [avaliacaoreferenciafornecedor] 
(
	[idempregado] ASC
)ON [PRIMARY];

CREATE TABLE [avaliacaopedido](
	[idavaliacao] [int] NOT NULL,
	[idcriterio] [int] NOT NULL,
	[idpedido] [int] NULL,
	[idcoletapreco] [int] NULL,
	[iditemrequisicaoproduto] [int] NULL,
	[tipoavaliacao] [char](1) NOT NULL,
	[avaliacao] [decimal](8, 2) NOT NULL,
	[observacoes] [text] NULL,
PRIMARY KEY CLUSTERED 
(
	[idavaliacao] ASC
)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_49] ON [avaliacaopedido] 
(
	[idcriterio] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_701] ON [avaliacaopedido] 
(
	[idpedido] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_702] ON [avaliacaopedido] 
(
	[idcoletapreco] ASC,
	[iditemrequisicaoproduto] ASC
)ON [PRIMARY];

CREATE TABLE [avaliacaocoletapreco](
	[idcriterio] [int] NOT NULL,
	[idcoletapreco] [int] NOT NULL,
	[avaliacao] [int] NOT NULL
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_36] ON [avaliacaocoletapreco] 
(
	[idcriterio] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_689] ON [avaliacaocoletapreco] 
(
	[idcoletapreco] ASC
)ON [PRIMARY];

CREATE TABLE [aprovacaomudanca](
	[idaprovacaomudanca] [int] NOT NULL,
	[idrequisicaomudanca] [int] NULL,
	[idempregado] [int] NULL,
	[nomeempregado] [varchar](45) NULL,
	[voto] [char](1) NULL,
	[comentario] [varchar](200) NULL,
	[datahorainicio] [datetime] NULL,
	[dataHoraVotacao] [varchar](25) NULL,
PRIMARY KEY CLUSTERED 
(
	[idaprovacaomudanca] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_empregado_idx] ON [aprovacaomudanca] 
(
	[idempregado] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_requisicaomudanca_idx] ON [aprovacaomudanca] 
(
	[idrequisicaomudanca] ASC
)ON [PRIMARY];

CREATE TRIGGER [add_current_date_to_slarequisitosla_update] ON  [slarequisitosla]
FOR INSERT
AS
BEGIN
       SET NOCOUNT ON; 
       UPDATE tbl
       SET dataultmodificacao = GETDATE()
       FROM slarequisitosla AS tbl
       INNER JOIN inserted AS i
             ON tbl.idrequisitosla = i.idrequisitosla; 
END;

CREATE TRIGGER [add_current_date_to_slarequisitosla_insert] ON  [slarequisitosla]
FOR UPDATE
AS
BEGIN
       SET NOCOUNT ON; 
       UPDATE tbl
       SET dataultmodificacao = GETDATE()
       FROM slarequisitosla AS tbl
       INNER JOIN inserted AS i
             ON tbl.idrequisitosla = i.idrequisitosla; 
END;

CREATE TABLE [fornecedorproduto](
	[idfornecedorproduto] [int] NOT NULL,
	[idfornecedor] [bigint] NULL,
	[idtipoproduto] [int] NOT NULL,
	[idmarca] [int] NULL,
	[datainicio] [date] NOT NULL,
	[datafim] [date] NULL,
PRIMARY KEY CLUSTERED 
(
	[idfornecedorproduto] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_660] ON [fornecedorproduto] 
(
	[idfornecedor] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_675] ON [fornecedorproduto] 
(
	[idmarca] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [idtipoproduto] ON [fornecedorproduto] 
(
	[idtipoproduto] ASC
)ON [PRIMARY];

CREATE TABLE [execucaomudanca](
	[idexecucao] [int] NOT NULL,
	[idinstanciafluxo] [bigint] NOT NULL,
	[idrequisicaomudanca] [int] NOT NULL,
	[idfluxo] [bigint] NOT NULL,
	[seqreabertura] [smallint] NULL,
PRIMARY KEY CLUSTERED 
(
	[idexecucao] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_execucao_reference_bpm_flux] ON [execucaomudanca] 
(
	[idfluxo] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_execucao_reference_bpm_inst] ON [execucaomudanca] 
(
	[idinstanciafluxo] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_execucao_reference_requisic] ON [execucaomudanca] 
(
	[idrequisicaomudanca] ASC
)ON [PRIMARY];

CREATE TABLE [inspecaopedidocompra](
	[idpedido] [int] NOT NULL,
	[idcriterio] [int] NOT NULL,
	[idresponsavel] [int] NOT NULL,
	[datahorainspecao] [datetime] NOT NULL,
	[avaliacao] [varchar](25) NULL,
	[observacoes] [nvarchar](1) NULL,
PRIMARY KEY CLUSTERED 
(
	[idpedido] ASC,
	[idcriterio] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_717] ON [inspecaopedidocompra] 
(
	[idcriterio] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_718] ON [inspecaopedidocompra] 
(
	[idresponsavel] ASC
)ON [PRIMARY];

CREATE TRIGGER [inspecaopedidocompra_setCurrentTime] ON  [inspecaopedidocompra]
FOR UPDATE
AS
BEGIN
	SET NOCOUNT ON; 
	UPDATE tbl
	SET datahorainspecao = GETDATE()
	FROM inspecaopedidocompra AS tbl
	INNER JOIN inserted AS i
		ON tbl.idpedido = i.idpedido; 
END;

CREATE TABLE [itempedidocompra](
	[iditempedido] [int] NOT NULL,
	[idpedido] [int] NOT NULL,
	[idproduto] [int] NOT NULL,
	[idcoletapreco] [int] NULL,
	[quantidade] [decimal](8, 2) NOT NULL,
	[valortotal] [decimal](8, 2) NOT NULL,
	[valordesconto] [decimal](8, 2) NULL,
	[valoracrescimo] [decimal](8, 2) NULL,
	[basecalculoicms] [decimal](8, 2) NULL,
	[aliquotaicms] [decimal](8, 2) NULL,
	[aliquotaipi] [decimal](8, 2) NULL,
PRIMARY KEY CLUSTERED 
(
	[iditempedido] ASC
)
) ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_703] ON [itempedidocompra] 
(
	[idcoletapreco] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_704] ON [itempedidocompra] 
(
	[idpedido] ASC
)ON [PRIMARY];

CREATE NONCLUSTERED INDEX [fk_reference_705] ON [itempedidocompra] 
(
	[idproduto] ASC
)ON [PRIMARY];

ALTER TABLE [acaoplanomelhoria] ADD  DEFAULT (NULL) FOR [datainicio];

ALTER TABLE [acaoplanomelhoria] ADD  DEFAULT (NULL) FOR [datafim];

ALTER TABLE [acaoplanomelhoria] ADD  DEFAULT (NULL) FOR [responsavel];

ALTER TABLE [acaoplanomelhoria] ADD  DEFAULT (NULL) FOR [dataconclusao];

ALTER TABLE [acaoplanomelhoria] ADD  DEFAULT (NULL) FOR [criadopor];

ALTER TABLE [acaoplanomelhoria] ADD  DEFAULT (NULL) FOR [modificadopor];

ALTER TABLE [acaoplanomelhoria] ADD  DEFAULT (NULL) FOR [datacriacao];

ALTER TABLE [acaoplanomelhoria] ADD  DEFAULT (NULL) FOR [ultmodificacao];

ALTER TABLE [accountLines] ADD  DEFAULT (getdate()) FOR [ts];

ALTER TABLE [acordonivelservico] ADD  DEFAULT (NULL) FOR [idservicocontrato];

ALTER TABLE [acordonivelservico] ADD  DEFAULT (NULL) FOR [idprioridadepadrao];

ALTER TABLE [acordonivelservico] ADD  DEFAULT (NULL) FOR [disponibilidade];

ALTER TABLE [acordonivelservico] ADD  DEFAULT (NULL) FOR [datafim];

ALTER TABLE [acordonivelservico] ADD  DEFAULT (NULL) FOR [avaliarem]

ALTER TABLE [acordonivelservico] ADD  DEFAULT (NULL) FOR [tipo];

ALTER TABLE [acordonivelservico] ADD  DEFAULT (NULL) FOR [deleted]

ALTER TABLE [acordonivelservico] ADD  DEFAULT (NULL) FOR [valorLimite];

ALTER TABLE [acordonivelservico] ADD  DEFAULT (NULL) FOR [unidadeValorLimite];

ALTER TABLE [acordonivelservico] ADD  DEFAULT (NULL) FOR [impacto];

ALTER TABLE [acordonivelservico] ADD  DEFAULT (NULL) FOR [urgencia];

ALTER TABLE [acordonivelservico] ADD  DEFAULT (NULL) FOR [permiteMudarImpUrg];

ALTER TABLE [acordonivelservico] ADD  DEFAULT (NULL) FOR [idFormula];

ALTER TABLE [acordonivelservico] ADD  DEFAULT (getdate()) FOR [criadoEm];

ALTER TABLE [acordonivelservico] ADD  DEFAULT (NULL) FOR [criadoPor];

ALTER TABLE [acordonivelservico] ADD  DEFAULT (NULL) FOR [modificadoPor];

ALTER TABLE [acordonivelservico] ADD  DEFAULT (NULL) FOR [tempoauto];

ALTER TABLE [acordonivelservico] ADD  DEFAULT (NULL) FOR [idprioridadeauto1];

ALTER TABLE [acordonivelservico] ADD  DEFAULT (NULL) FOR [idprioridadeauto2];

ALTER TABLE [acordonivelservico] ADD  DEFAULT (NULL) FOR [idprioridadeauto3];

ALTER TABLE [acordonivelservico] ADD  DEFAULT (NULL) FOR [idprioridadeauto4];

ALTER TABLE [acordonivelservico] ADD  DEFAULT (NULL) FOR [idprioridadeauto5];

ALTER TABLE [acordonivelservico] ADD  DEFAULT (NULL) FOR [idgrupo1];

ALTER TABLE [acordonivelservico] ADD  DEFAULT (NULL) FOR [idgrupo2];

ALTER TABLE [acordonivelservico] ADD  DEFAULT (NULL) FOR [idgrupo3];

ALTER TABLE [acordonivelservico] ADD  DEFAULT (NULL) FOR [idgrupo4];

ALTER TABLE [acordonivelservico] ADD  DEFAULT (NULL) FOR [idgrupo5];

ALTER TABLE [acordonivelservico_hist] ADD  DEFAULT (NULL) FOR [idservicocontrato];

ALTER TABLE [acordonivelservico_hist] ADD  DEFAULT (NULL) FOR [idprioridadepadrao];

ALTER TABLE [acordonivelservico_hist] ADD  DEFAULT (NULL) FOR [disponibilidade];

ALTER TABLE [acordonivelservico_hist] ADD  DEFAULT (NULL) FOR [datafim];

ALTER TABLE [acordonivelservico_hist] ADD  DEFAULT (NULL) FOR [avaliarem];

ALTER TABLE [acordonivelservico_hist] ADD  DEFAULT (NULL) FOR [tipo];

ALTER TABLE [acordonivelservico_hist] ADD  DEFAULT (NULL) FOR [valorlimite];

ALTER TABLE [acordonivelservico_hist] ADD  DEFAULT (NULL) FOR [unidadevalorlimite];

ALTER TABLE [acordonivelservico_hist] ADD  DEFAULT (NULL) FOR [impacto];

ALTER TABLE [acordonivelservico_hist] ADD  DEFAULT (NULL) FOR [urgencia];

ALTER TABLE [acordonivelservico_hist] ADD  DEFAULT (NULL) FOR [permiteMudarImpUrg];

ALTER TABLE [acordonivelservico_hist] ADD  DEFAULT (NULL) FOR [deleted];

ALTER TABLE [acordonivelservico_hist] ADD  DEFAULT (getdate()) FOR [criadoem];

ALTER TABLE [acordonivelservico_hist] ADD  DEFAULT (NULL) FOR [criadopor];

ALTER TABLE [acordonivelservico_hist] ADD  DEFAULT ('0000-00-00 00:00:00') FOR [modificadoem];

ALTER TABLE [acordonivelservico_hist] ADD  DEFAULT (NULL) FOR [modificadopor];

ALTER TABLE [acordonivelservico_hist] ADD  DEFAULT (NULL) FOR [idformula];

ALTER TABLE [acordonivelservicocontrato] ADD  DEFAULT (NULL) FOR [unidadevalorlimite];

ALTER TABLE [acordonivelservicocontrato] ADD  DEFAULT (NULL) FOR [datafim];

ALTER TABLE [acordonivelservicocontrato] ADD  DEFAULT (NULL) FOR [deleted];

ALTER TABLE [acordonivelservicocontrato] ADD  DEFAULT (NULL) FOR [idFormula];

ALTER TABLE [acordoservicocontrato] ADD  DEFAULT (NULL) FOR [datainicio];

ALTER TABLE [acordoservicocontrato] ADD  DEFAULT (NULL) FOR [datafim];

ALTER TABLE [acordoservicocontrato] ADD  DEFAULT (NULL) FOR [dataultatualiz];

ALTER TABLE [acordoservicocontrato] ADD  DEFAULT (NULL) FOR [deleted];

ALTER TABLE [acordoservicocontrato] ADD  DEFAULT (NULL) FOR [idrecurso];

ALTER TABLE [alcada] ADD  DEFAULT (NULL) FOR [tipoalcada];

ALTER TABLE [alcadacentroresultado] ADD  DEFAULT (NULL) FOR [datafim];

ALTER TABLE [anexo] ADD  DEFAULT (NULL) FOR [idexecucaoatividade];

ALTER TABLE [anexobaseconhecimento] ADD  DEFAULT (NULL) FOR [idbaseconhecimento];

ALTER TABLE [anexobaseconhecimento] ADD  DEFAULT (NULL) FOR [datafim];

ALTER TABLE [anexoincidente] ADD  DEFAULT (NULL) FOR [datafim];

ALTER TABLE [anexoincidente] ADD  DEFAULT (NULL) FOR [extensao];

ALTER TABLE [anexomudanca] ADD  DEFAULT (NULL) FOR [idmudanca];

ALTER TABLE [anexomudanca] ADD  DEFAULT (NULL) FOR [datainicio];

ALTER TABLE [anexomudanca] ADD  DEFAULT (NULL) FOR [datafim];

ALTER TABLE [anexomudanca] ADD  DEFAULT (NULL) FOR [nome];

ALTER TABLE [anexomudanca] ADD  DEFAULT (NULL) FOR [link];

ALTER TABLE [anexomudanca] ADD  DEFAULT (NULL) FOR [extensao];

ALTER TABLE [anexomudanca] ADD  DEFAULT (NULL) FOR [descricao];

ALTER TABLE [aprovacaomudanca] ADD  DEFAULT (NULL) FOR [idrequisicaomudanca];

ALTER TABLE [aprovacaomudanca] ADD  DEFAULT (NULL) FOR [idempregado];

ALTER TABLE [aprovacaomudanca] ADD  DEFAULT (NULL) FOR [nomeempregado];

ALTER TABLE [aprovacaomudanca] ADD  DEFAULT (NULL) FOR [voto];

ALTER TABLE [aprovacaomudanca] ADD  DEFAULT (NULL) FOR [comentario];

ALTER TABLE [aprovacaomudanca] ADD  DEFAULT (NULL) FOR [datahorainicio];

ALTER TABLE [aprovacaosolicitacaoservico] ADD  DEFAULT (NULL) FOR [idtarefa];

ALTER TABLE [aprovacaosolicitacaoservico] ADD  DEFAULT (NULL) FOR [datahora];

ALTER TABLE [aprovacaosolicitacaoservico] ADD  DEFAULT (NULL) FOR [idjustificativa];

ALTER TABLE [apuracaovaloresrecurso] ADD  DEFAULT (NULL) FOR [deleted];

ALTER TABLE [atividadeperiodica] ADD  DEFAULT (NULL) FOR [idcontrato];

ALTER TABLE [atividadeperiodica] ADD  DEFAULT (NULL) FOR [idprocedimentotecnico];

ALTER TABLE [atividadeperiodica] ADD  DEFAULT (NULL) FOR [idgrupoatvperiodica];

ALTER TABLE [atividadeperiodica] ADD  DEFAULT (NULL) FOR [tituloatividade];

ALTER TABLE [atividadeperiodica] ADD  DEFAULT (NULL) FOR [datainicio];

ALTER TABLE [atividadeperiodica] ADD  DEFAULT (NULL) FOR [datafim];

ALTER TABLE [atividadeperiodica] ADD  DEFAULT (NULL) FOR [criadopor];

ALTER TABLE [atividadeperiodica] ADD  DEFAULT (NULL) FOR [datacriacao];

ALTER TABLE [atividadeperiodica] ADD  DEFAULT (NULL) FOR [alteradopor];

ALTER TABLE [atividadeperiodica] ADD  DEFAULT (NULL) FOR [dataultalteracao];

ALTER TABLE [atividadeperiodica] ADD  DEFAULT (NULL) FOR [idsolicitacaoservico];

ALTER TABLE [atividadeperiodica] ADD  DEFAULT (NULL) FOR [idrequisicaomudanca];

ALTER TABLE [atividadeperiodica] ADD  DEFAULT (NULL) FOR [blackout];

ALTER TABLE [atividades] ADD  DEFAULT (NULL) FOR [idatividadeproxima];

ALTER TABLE [atividades] ADD  DEFAULT (NULL) FOR [grupoexecutor];

ALTER TABLE [atividadesos] ADD  DEFAULT (NULL) FOR [sequencia];

ALTER TABLE [atividadesos] ADD  DEFAULT (NULL) FOR [idatividadeservicocontrato];

ALTER TABLE [atividadesos] ADD  DEFAULT (NULL) FOR [custoatividade];

ALTER TABLE [atividadesos] ADD  DEFAULT (NULL) FOR [glosaatividade];

ALTER TABLE [atividadesos] ADD  DEFAULT (NULL) FOR [complexidade];

ALTER TABLE [atividadesos] ADD  DEFAULT (NULL) FOR [deleted];

ALTER TABLE [atividadesos] ADD  DEFAULT (NULL) FOR [qtdeexecutada];

-- Object:  Default [DF__atividade__conta__3B0BC30C]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [atividadesos] ADD  DEFAULT (NULL) FOR [contabilizar];

-- Object:  Default [DF__atividade__idser__3BFFE745]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [atividadesos] ADD  DEFAULT (NULL) FOR [idservicocontratocontabil];

-- Object:  Default [DF__atividade__custo__41B8C09B]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [atividadesservicocontrato] ADD  DEFAULT (NULL) FOR [custoatividade];

-- Object:  Default [DF__atividade__compl__42ACE4D4]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [atividadesservicocontrato] ADD  DEFAULT (NULL) FOR [complexidade];

-- Object:  Default [DF__atividade__delet__43A1090D]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [atividadesservicocontrato] ADD  DEFAULT (NULL) FOR [deleted];

-- Object:  Default [DF__atividades__hora__44952D46]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [atividadesservicocontrato] ADD  DEFAULT (NULL) FOR [hora];

-- Object:  Default [DF__atividade__quant__4589517F]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [atividadesservicocontrato] ADD  DEFAULT (NULL) FOR [quantidade];

-- Object:  Default [DF__atividade__perio__467D75B8]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [atividadesservicocontrato] ADD  DEFAULT (NULL) FOR [periodo];

-- Object:  Default [DF__atividade__tipoc__477199F1]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [atividadesservicocontrato] ADD  DEFAULT (NULL) FOR [tipocusto];

-- Object:  Default [DF__atividade__conta__4865BE2A]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [atividadesservicocontrato] ADD  DEFAULT (NULL) FOR [contabilizar];

-- Object:  Default [DF__atividade__idser__4959E263]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [atividadesservicocontrato] ADD  DEFAULT (NULL) FOR [idservicocontratocontabil];

-- Object:  Default [DF__auditoria__idite__4E1E9780]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [auditoria] ADD  DEFAULT (NULL) FOR [iditemconfiguracao];

-- Object:  Default [DF__auditoria__idusu__4F12BBB9]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [auditoria] ADD  DEFAULT (NULL) FOR [idusuario];

-- Object:  Default [DF__auditoria__hora__5006DFF2]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [auditoria] ADD  DEFAULT (NULL) FOR [hora];

-- Object:  Default [DF__auditoria__idite__54CB950F]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [auditoriaitemconfiguracao] ADD  DEFAULT (NULL) FOR [iditemconfiguracao];

-- Object:  Default [DF__auditoria__idemp__55BFB948]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [auditoriaitemconfiguracao] ADD  DEFAULT (NULL) FOR [idempregado];

-- Object:  Default [DF__auditoriai__hora__56B3DD81]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [auditoriaitemconfiguracao] ADD  DEFAULT (NULL) FOR [hora];

-- Object:  Default [DF__avaliacao__idfor__0D64F3ED]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [avaliacaofornecedor] ADD  DEFAULT (NULL) FOR [idfornecedor];

-- Object:  Default [DF__avaliacao__idres__0E591826]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [avaliacaofornecedor] ADD  DEFAULT (NULL) FOR [idresponsavel];

-- Object:  Default [DF__avaliacao__dataa__0F4D3C5F]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [avaliacaofornecedor] ADD  DEFAULT (NULL) FOR [dataavaliacao];

-- Object:  Default [DF__avaliacao__decis__10416098]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [avaliacaofornecedor] ADD  DEFAULT (NULL) FOR [decisaoqualificacao];

-- Object:  Default [DF__avaliacao__conta__113584D1]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [avaliacaofornecedor] ADD  DEFAULT (NULL) FOR [contato];

-- Object:  Default [DF__avaliacao__idped__271AA44F]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [avaliacaopedido] ADD  DEFAULT (NULL) FOR [idpedido];

-- Object:  Default [DF__avaliacao__idcol__280EC888]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [avaliacaopedido] ADD  DEFAULT (NULL) FOR [idcoletapreco];

-- Object:  Default [DF__avaliacao__idite__2902ECC1]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [avaliacaopedido] ADD  DEFAULT (NULL) FOR [iditemrequisicaoproduto];

-- Object:  Default [DF__avaliacao__idava__226010D3]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [avaliacaoreferenciafornecedor] ADD  DEFAULT ('0') FOR [idavaliacaofornecedor];

-- Object:  Default [DF__avaliacao__idemp__2354350C]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [avaliacaoreferenciafornecedor] ADD  DEFAULT ('0') FOR [idempregado];

-- Object:  Default [DF__avaliacao__decis__24485945]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [avaliacaoreferenciafornecedor] ADD  DEFAULT (NULL) FOR [decisao];

-- Object:  Default [DF__baseconhe__idpas__4850AF91]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [baseconhecimento] ADD  DEFAULT (NULL) FOR [idpasta];

-- Object:  Default [DF__baseconhe__dataf__4944D3CA]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [baseconhecimento] ADD  DEFAULT (NULL) FOR [datafim];

-- Object:  Default [DF__baseconhe__idbas__4A38F803]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [baseconhecimento] ADD  DEFAULT (NULL) FOR [idbaseconhecimentopai];

-- Object:  Default [DF__baseconhe__datae__4B2D1C3C]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [baseconhecimento] ADD  DEFAULT (NULL) FOR [dataexpiracao];

-- Object:  Default [DF__baseconhe__versa__4C214075]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [baseconhecimento] ADD  DEFAULT (NULL) FOR [versao];

-- Object:  Default [DF__baseconhe__idnot__4D1564AE]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [baseconhecimento] ADD  DEFAULT (NULL) FOR [idnotificacao];

-- Object:  Default [DF__baseconhe__justi__4E0988E7]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [baseconhecimento] ADD  DEFAULT (NULL) FOR [justificativaobservacao];

-- Object:  Default [DF__baseconhe__datap__4EFDAD20]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [baseconhecimento] ADD  DEFAULT (NULL) FOR [datapublicacao];

-- Object:  Default [DF__baseconhe__fonte__4FF1D159]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [baseconhecimento] ADD  DEFAULT (NULL) FOR [fontereferencia];

-- Object:  Default [DF__baseconheci__faq__50E5F592]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [baseconhecimento] ADD  DEFAULT (NULL) FOR [faq];

-- Object:  Default [DF__baseconhe__arqui__51DA19CB]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [baseconhecimento] ADD  DEFAULT (NULL) FOR [arquivado];

-- Object:  Default [DF__baseconhe__idusu__52CE3E04]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [baseconhecimento] ADD  DEFAULT (NULL) FOR [idusuarioautor];

-- Object:  Default [DF__baseconhe__idusu__53C2623D]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [baseconhecimento] ADD  DEFAULT (NULL) FOR [idusuarioaprovador];

-- Object:  Default [DF__baseconhe__idhis__54B68676]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [baseconhecimento] ADD  DEFAULT (NULL) FOR [idhistoricobaseconhecimento];

-- Object:  Default [DF__baseconhe__priva__55AAAAAF]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [baseconhecimento] ADD  DEFAULT (NULL) FOR [privacidade];

-- Object:  Default [DF__baseconhe__situa__569ECEE8]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [baseconhecimento] ADD  DEFAULT (NULL) FOR [situacao];

-- Object:  Default [DF__baseconhe__geren__5792F321]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [baseconhecimento] ADD  DEFAULT (NULL) FOR [gerenciamentoDisponibilidade];

-- Object:  Default [DF__baseconhe__direi__5887175A]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [baseconhecimento] ADD  DEFAULT (NULL) FOR [direitoAutoral];

-- Object:  Default [DF__baseconhe__legis__597B3B93]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [baseconhecimento] ADD  DEFAULT (NULL) FOR [legislacao];

-- Object:  Default [DF__baseitemc__idtip__5F492382]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [baseitemconfiguracao] ADD  DEFAULT (NULL) FOR [idtipoitemconfiguracao];

-- Object:  Default [DF__baseitemc__dataf__603D47BB]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [baseitemconfiguracao] ADD  DEFAULT (NULL) FOR [datafim];

-- Object:  Default [DF__baseitemc__tipoe__61316BF4]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [baseitemconfiguracao] ADD  DEFAULT (NULL) FOR [tipoexecucao];

-- Object:  Default [DF__baseitemc__coman__6225902D]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [baseitemconfiguracao] ADD  DEFAULT (NULL) FOR [comando];

-- Object:  Default [DF__botaoacaov__hint__6ABAD62E]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [botaoacaovisao] ADD  DEFAULT (NULL) FOR [hint];

-- Object:  Default [DF__botaoacao__icone__6BAEFA67]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [botaoacaovisao] ADD  DEFAULT (NULL) FOR [icone];

-- Object:  Default [DF__botaoacao__ordem__6CA31EA0]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [botaoacaovisao] ADD  DEFAULT (NULL) FOR [ordem];

-- Object:  Default [DF__bpm_atribu__tipo__7167D3BD]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [bpm_atribuicaofluxo] ADD  DEFAULT (NULL) FOR [tipo];

-- Object:  Default [DF__bpm_atrib__datah__725BF7F6]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [bpm_atribuicaofluxo] ADD  DEFAULT (getdate()) FOR [datahora];

-- Object:  Default [DF__bpm_atrib__idusu__73501C2F]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [bpm_atribuicaofluxo] ADD  DEFAULT (NULL) FOR [idusuario];

-- Object:  Default [DF__bpm_atrib__idgru__74444068]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [bpm_atribuicaofluxo] ADD  DEFAULT (NULL) FOR [idgrupo];

-- Object:  Default [DF__bpm_eleme__subti__79FD19BE]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [bpm_elementofluxo] ADD  DEFAULT (NULL) FOR [subtipo];

-- Object:  Default [DF__bpm_elemen__nome__7AF13DF7]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [bpm_elementofluxo] ADD  DEFAULT (NULL) FOR [nome];

-- Object:  Default [DF__bpm_eleme__tipoi__7BE56230]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [bpm_elementofluxo] ADD  DEFAULT (NULL) FOR [tipointeracao];

-- Object:  Default [DF__bpm_element__url__7CD98669]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [bpm_elementofluxo] ADD  DEFAULT (NULL) FOR [url];

-- Object:  Default [DF__bpm_eleme__visao__7DCDAAA2]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [bpm_elementofluxo] ADD  DEFAULT (NULL) FOR [visao];

-- Object:  Default [DF__bpm_eleme__nomef__7EC1CEDB]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [bpm_elementofluxo] ADD  DEFAULT (NULL) FOR [nomefluxoencadeado];

-- Object:  Default [DF__bpm_elemen__posx__7FB5F314]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [bpm_elementofluxo] ADD  DEFAULT (NULL) FOR [posx];

-- Object:  Default [DF__bpm_elemen__posy__00AA174D]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [bpm_elementofluxo] ADD  DEFAULT (NULL) FOR [posy];

-- Object:  Default [DF__bpm_eleme__altur__019E3B86]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [bpm_elementofluxo] ADD  DEFAULT (NULL) FOR [altura];

-- Object:  Default [DF__bpm_eleme__largu__02925FBF]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [bpm_elementofluxo] ADD  DEFAULT (NULL) FOR [largura];

-- Object:  Default [DF__bpm_eleme__model__038683F8]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [bpm_elementofluxo] ADD  DEFAULT (NULL) FOR [modeloemail];

-- Object:  Default [DF__bpm_eleme__templ__047AA831]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [bpm_elementofluxo] ADD  DEFAULT (NULL) FOR [template];

-- Object:  Default [DF__bpm_eleme__inter__056ECC6A]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [bpm_elementofluxo] ADD  DEFAULT (NULL) FOR [intervalo];

-- Object:  Default [DF__bpm_eleme__multi__0662F0A3]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [bpm_elementofluxo] ADD  DEFAULT (NULL) FOR [multiplasinstancias];

-- Object:  Default [DF__bpm_eleme__conta__075714DC]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [bpm_elementofluxo] ADD  DEFAULT (NULL) FOR [contabilizasla];

-- Object:  Default [DF__bpm_eleme__perce__084B3915]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [bpm_elementofluxo] ADD  DEFAULT (NULL) FOR [percexecucao];

-- Object:  Default [DF__bpm_fluxo__idtip__0D0FEE32]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [bpm_fluxo] ADD  DEFAULT (NULL) FOR [idtipofluxo];

-- Object:  Default [DF__bpm_fluxo__dataf__0E04126B]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [bpm_fluxo] ADD  DEFAULT (NULL) FOR [datafim];

-- Object:  Default [DF__bpm_histo__idres__12C8C788]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [bpm_historicoitemtrabalho] ADD  DEFAULT (NULL) FOR [idresponsavel];

-- Object:  Default [DF__bpm_histo__idusu__13BCEBC1]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [bpm_historicoitemtrabalho] ADD  DEFAULT (NULL) FOR [idusuario];

-- Object:  Default [DF__bpm_histo__idgru__14B10FFA]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [bpm_historicoitemtrabalho] ADD  DEFAULT (NULL) FOR [idgrupo];

-- Object:  Default [DF__bpm_histo__datah__15A53433]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [bpm_historicoitemtrabalho] ADD  DEFAULT (getdate()) FOR [datahora];

-- Object:  Default [DF__bpm_insta__datah__1A69E950]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [bpm_instanciafluxo] ADD  DEFAULT (getdate()) FOR [datahoracriacao];

-- Object:  Default [DF__bpm_insta__situa__1B5E0D89]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [bpm_instanciafluxo] ADD  DEFAULT (NULL) FOR [situacao];

-- Object:  Default [DF__bpm_insta__datah__1C5231C2]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [bpm_instanciafluxo] ADD  DEFAULT (NULL) FOR [datahorafinalizacao];

-- Object:  Default [DF__bpm_itemt__idres__2116E6DF]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [bpm_itemtrabalhofluxo] ADD  DEFAULT (NULL) FOR [idresponsavelatual];

-- Object:  Default [DF__bpm_itemt__datah__220B0B18]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [bpm_itemtrabalhofluxo] ADD  DEFAULT (getdate()) FOR [datahoracriacao];

-- Object:  Default [DF__bpm_itemt__datah__22FF2F51]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [bpm_itemtrabalhofluxo] ADD  DEFAULT (NULL) FOR [datahorainicio];

-- Object:  Default [DF__bpm_itemt__datah__23F3538A]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [bpm_itemtrabalhofluxo] ADD  DEFAULT (NULL) FOR [datahorafinalizacao];

-- Object:  Default [DF__bpm_itemt__datah__24E777C3]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [bpm_itemtrabalhofluxo] ADD  DEFAULT (NULL) FOR [datahoraexecucao];

-- Object:  Default [DF__bpm_objet__idite__29AC2CE0]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [bpm_objetoinstanciafluxo] ADD  DEFAULT (NULL) FOR [iditemtrabalho];

-- Object:  Default [DF__bpm_objet__idobj__2AA05119]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [bpm_objetoinstanciafluxo] ADD  DEFAULT (NULL) FOR [idobjetonegocio];

-- Object:  Default [DF__bpm_objet__nomeo__2B947552]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [bpm_objetoinstanciafluxo] ADD  DEFAULT (NULL) FOR [nomeobjeto];

-- Object:  Default [DF__bpm_objet__nomec__2C88998B]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [bpm_objetoinstanciafluxo] ADD  DEFAULT (NULL) FOR [nomeclasse];

-- Object:  Default [DF__bpm_objet__nomet__2D7CBDC4]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [bpm_objetoinstanciafluxo] ADD  DEFAULT (NULL) FOR [nometabelabd];

-- Object:  Default [DF__bpm_objet__nomec__2E70E1FD]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [bpm_objetoinstanciafluxo] ADD  DEFAULT (NULL) FOR [nomecampobd];

-- Object:  Default [DF__bpm_objet__tipoc__2F650636]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [bpm_objetoinstanciafluxo] ADD  DEFAULT (NULL) FOR [tipocampobd];

-- Object:  Default [DF__bpm_seque__nomec__3429BB53]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [bpm_sequenciafluxo] ADD  DEFAULT (NULL) FOR [nomeclasseorigem];

-- Object:  Default [DF__bpm_seque__nomec__351DDF8C]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [bpm_sequenciafluxo] ADD  DEFAULT (NULL) FOR [nomeclassedestino];

-- Object:  Default [DF__bpm_seque__idcon__361203C5]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [bpm_sequenciafluxo] ADD  DEFAULT (NULL) FOR [idconexaoorigem];

-- Object:  Default [DF__bpm_seque__idcon__370627FE]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [bpm_sequenciafluxo] ADD  DEFAULT (NULL) FOR [idconexaodestino];

-- Object:  Default [DF__bpm_seque__borda__37FA4C37]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [bpm_sequenciafluxo] ADD  DEFAULT (NULL) FOR [bordax];

-- Object:  Default [DF__bpm_seque__borda__38EE7070]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [bpm_sequenciafluxo] ADD  DEFAULT (NULL) FOR [borday];

-- Object:  Default [DF__bpm_seque__posic__39E294A9]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [bpm_sequenciafluxo] ADD  DEFAULT (NULL) FOR [posicaoalterada];

-- Object:  Default [DF__bpm_sequen__nome__3AD6B8E2]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [bpm_sequenciafluxo] ADD  DEFAULT (NULL) FOR [nome];

-- Object:  Default [DF__bpm_tipof__nomec__3F9B6DFF]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [bpm_tipofluxo] ADD  DEFAULT (NULL) FOR [nomeclassefluxo];

-- Object:  Default [DF__calendari__descr__53A266AC]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [calendario] ADD  DEFAULT (NULL) FOR [descricao];

-- Object:  Default [DF__calendari__consi__54968AE5]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [calendario] ADD  DEFAULT (NULL) FOR [consideraferiados];

-- Object:  Default [DF__calendari__idjor__558AAF1E]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [calendario] ADD  DEFAULT (NULL) FOR [idjornadaseg];

-- Object:  Default [DF__calendari__idjor__567ED357]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [calendario] ADD  DEFAULT (NULL) FOR [idjornadater];

-- Object:  Default [DF__calendari__idjor__5772F790]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [calendario] ADD  DEFAULT (NULL) FOR [idjornadaqua];

-- Object:  Default [DF__calendari__idjor__58671BC9]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [calendario] ADD  DEFAULT (NULL) FOR [idjornadaqui];

-- Object:  Default [DF__calendari__idjor__595B4002]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [calendario] ADD  DEFAULT (NULL) FOR [idjornadasex];

-- Object:  Default [DF__calendari__idjor__5A4F643B]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [calendario] ADD  DEFAULT (NULL) FOR [idjornadasab];

-- Object:  Default [DF__calendari__idjor__5B438874]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [calendario] ADD  DEFAULT (NULL) FOR [idjornadadom];

-- Object:  Default [DF__camposobj__preci__03BB8E22]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [camposobjetonegocio] ADD  DEFAULT ('0') FOR [precisiondb];

-- Object:  Default [DF__caracteri__tagca__731B1205]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [caracteristica] ADD  DEFAULT (NULL) FOR [tagcaracteristica];

-- Object:  Default [DF__caracteri__descr__740F363E]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [caracteristica] ADD  DEFAULT (NULL) FOR [descricao];

-- Object:  Default [DF__caracteris__tipo__75035A77]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [caracteristica] ADD  DEFAULT (NULL) FOR [tipo];

-- Object:  Default [DF__caracteri__dataf__75F77EB0]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [caracteristica] ADD  DEFAULT (NULL) FOR [datafim];

-- Object:  Default [DF__caracteri__siste__76EBA2E9]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [caracteristica] ADD  DEFAULT (NULL) FOR [sistema];

-- Object:  Default [DF__cargos__datafim__7BB05806]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [cargos] ADD  DEFAULT (NULL) FOR [datafim];

-- Object:  Default [DF__catalogos__idcat__4890A6B3]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [catalogoservico] ADD  DEFAULT ('0') FOR [idcatalogoservico];

-- Object:  Default [DF__catalogos__idcon__4984CAEC]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [catalogoservico] ADD  DEFAULT (NULL) FOR [idcontrato];

-- Object:  Default [DF__catalogos__datai__4A78EF25]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [catalogoservico] ADD  DEFAULT (NULL) FOR [datainicio];

-- Object:  Default [DF__catalogos__dataf__4B6D135E]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [catalogoservico] ADD  DEFAULT (NULL) FOR [datafim];

-- Object:  Default [DF__catalogos__nomes__4C613797]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [catalogoservico] ADD  DEFAULT (NULL) FOR [nomeservico];

-- Object:  Default [DF__catalogos__titul__4D555BD0]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [catalogoservico] ADD  DEFAULT (NULL) FOR [titulocatalogoservico];

-- Object:  Default [DF__categoria__idtip__30AE302A]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [categoriamudanca] ADD  DEFAULT (NULL) FOR [idtipofluxo];

-- Object:  Default [DF__categoria__idmod__31A25463]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [categoriamudanca] ADD  DEFAULT (NULL) FOR [idmodeloemailcriacao];

-- Object:  Default [DF__categoria__idmod__3296789C]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [categoriamudanca] ADD  DEFAULT (NULL) FOR [idmodeloemailfinalizacao];

-- Object:  Default [DF__categoria__idmod__338A9CD5]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [categoriamudanca] ADD  DEFAULT (NULL) FOR [idmodeloemailacoes];

-- Object:  Default [DF__categoria__idgru__347EC10E]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [categoriamudanca] ADD  DEFAULT (NULL) FOR [idgruponivel1];

-- Object:  Default [DF__categoria__idgru__3572E547]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [categoriamudanca] ADD  DEFAULT (NULL) FOR [idgrupoexecutor];

-- Object:  Default [DF__categoria__idcal__36670980]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [categoriamudanca] ADD  DEFAULT (NULL) FOR [idcalendario];

-- Object:  Default [DF__categoria__idcat__375B2DB9]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [categoriamudanca] ADD  DEFAULT (NULL) FOR [idcategoriamudancapai];

-- Object:  Default [DF__categoria__nomec__384F51F2]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [categoriamudanca] ADD  DEFAULT (NULL) FOR [nomecategoria];

-- Object:  Default [DF__categoria__datai__3943762B]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [categoriamudanca] ADD  DEFAULT (NULL) FOR [datainicio];

-- Object:  Default [DF__categoria__dataf__3A379A64]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [categoriamudanca] ADD  DEFAULT (NULL) FOR [datafim];

-- Object:  Default [DF__categoria__dataF__1387E197]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [categoriaocorrencia] ADD  DEFAULT (NULL) FOR [dataFim];

-- Object:  Default [DF__categoria__idcat__184C96B4]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [categoriapost] ADD  DEFAULT (NULL) FOR [idcategoriapostPai];

-- Object:  Default [DF__categoria__nomec__1940BAED]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [categoriapost] ADD  DEFAULT (NULL) FOR [nomecategoria];

-- Object:  Default [DF__categoria__datai__1A34DF26]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [categoriapost] ADD  DEFAULT (NULL) FOR [datainicio];

-- Object:  Default [DF__categoria__dataf__1B29035F]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [categoriapost] ADD  DEFAULT (NULL) FOR [datafim];

-- Object:  Default [DF__categoria__cat_i__1FEDB87C]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [categoriaproblema] ADD  DEFAULT (NULL) FOR [cat_idcategoriaproblema];

-- Object:  Default [DF__categoria__idcat__3E723F9C]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [categoriaproduto] ADD  DEFAULT (NULL) FOR [idcategoriapai];

-- Object:  Default [DF__categoria__pesoc__3F6663D5]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [categoriaproduto] ADD  DEFAULT (NULL) FOR [pesocotacaopreco];

-- Object:  Default [DF__categoria__pesoc__405A880E]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [categoriaproduto] ADD  DEFAULT (NULL) FOR [pesocotacaoprazoentrega];

-- Object:  Default [DF__categoria__pesoc__414EAC47]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [categoriaproduto] ADD  DEFAULT (NULL) FOR [pesocotacaoprazopagto];

-- Object:  Default [DF__categoria__pesoc__4242D080]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [categoriaproduto] ADD  DEFAULT (NULL) FOR [pesocotacaotaxajuros];

-- Object:  Default [DF__categoria__pesoc__4336F4B9]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [categoriaproduto] ADD  DEFAULT (NULL) FOR [pesocotacaoprazogarantia];

-- Object:  Default [DF__categoria__compa__48EFCE0F]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [categoriaquestionario] ADD  DEFAULT ('N') FOR [compartilhada];

-- Object:  Default [DF__categoria__idcat__4DB4832C]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [categoriaservico] ADD  DEFAULT (NULL) FOR [idcategoriaservicopai];

-- Object:  Default [DF__categoria__datai__4EA8A765]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [categoriaservico] ADD  DEFAULT ('2012-04-02') FOR [datainicio];

-- Object:  Default [DF__categoria__dataf__4F9CCB9E]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [categoriaservico] ADD  DEFAULT (NULL) FOR [datafim];

-- Object:  Default [DF__categoria__nomeC__5090EFD7]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [categoriaservico] ADD  DEFAULT (NULL) FOR [nomeCategoriaServicoConcatenado];

-- Object:  Default [DF__categoria__nomeC__51851410]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [categoriaservico] ADD  DEFAULT (NULL) FOR [nomeCatServicoConcatenado];

-- Object:  Default [DF__categoria__idcat__5EDF0F2E]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [categoriasolucao] ADD  DEFAULT (NULL) FOR [idcategoriasolucaopai];

-- Object:  Default [DF__categoria__dataf__5FD33367]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [categoriasolucao] ADD  DEFAULT (NULL) FOR [datafim];

-- Object:  Default [DF__categoria__delet__60C757A0]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [categoriasolucao] ADD  DEFAULT (NULL) FOR [deleted];

-- Object:  Default [DF__causainci__idcau__190BB0C3]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [causaincidente] ADD  DEFAULT (NULL) FOR [idcausaincidentepai];

-- Object:  Default [DF__causainci__dataf__19FFD4FC]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [causaincidente] ADD  DEFAULT (NULL) FOR [datafim];

-- Object:  Default [DF__causainci__delet__1AF3F935]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [causaincidente] ADD  DEFAULT (NULL) FOR [deleted];

-- Object:  Default [DF__centrores__idcen__1FB8AE52]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [centroresultado] ADD  DEFAULT (NULL) FOR [idcentroresultadopai];

-- Object:  Default [DF__centrores__permi__20ACD28B]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [centroresultado] ADD  DEFAULT (NULL) FOR [permiterequisicaoproduto];

-- Object:  Default [DF__clientes__nomefa__1FCDBCEB]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [clientes] ADD  DEFAULT (NULL) FOR [nomefantasia];

-- Object:  Default [DF__clientes__cpfcnp__20C1E124]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [clientes] ADD  DEFAULT (NULL) FOR [cpfcnpj];

-- Object:  Default [DF__clientes__delete__21B6055D]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [clientes] ADD  DEFAULT (NULL) FOR [deleted];

-- Object:  Default [DF__colecao__nome__18826C35]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [colecao] ADD  DEFAULT (NULL) FOR [nome];

-- Object:  Default [DF__colecao__idteste__1976906E]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [colecao] ADD  DEFAULT (NULL) FOR [idteste];

-- Object:  Default [DF__coletapre__idres__71E7C201]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [coletapreco] ADD  DEFAULT (NULL) FOR [idrespresultado];

-- Object:  Default [DF__coletapre__idjus__72DBE63A]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [coletapreco] ADD  DEFAULT (NULL) FOR [idjustifresultado];

-- Object:  Default [DF__coletapre__datav__73D00A73]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [coletapreco] ADD  DEFAULT (NULL) FOR [datavalidade];

-- Object:  Default [DF__coletapre__pontu__74C42EAC]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [coletapreco] ADD  DEFAULT (NULL) FOR [pontuacao];

-- Object:  Default [DF__coletapre__resul__75B852E5]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [coletapreco] ADD  DEFAULT (NULL) FOR [resultadocalculo];

-- Object:  Default [DF__coletapre__quant__76AC771E]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [coletapreco] ADD  DEFAULT (NULL) FOR [quantidadecalculo];

-- Object:  Default [DF__coletapre__resul__77A09B57]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [coletapreco] ADD  DEFAULT (NULL) FOR [resultadofinal];

-- Object:  Default [DF__coletapre__quant__7894BF90]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [coletapreco] ADD  DEFAULT (NULL) FOR [quantidadecompra];

-- Object:  Default [DF__coletapre__quant__7988E3C9]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [coletapreco] ADD  DEFAULT (NULL) FOR [quantidadeaprovada];

-- Object:  Default [DF__coletapre__quant__7A7D0802]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [coletapreco] ADD  DEFAULT (NULL) FOR [quantidadepedido];

-- Object:  Default [DF__comandosi__siste__4727812E]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [comandosistemaoperacional] ADD  DEFAULT (NULL) FOR [sistemaoperacional];

-- Object:  Default [DF__comandosi__coman__481BA567]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [comandosistemaoperacional] ADD  DEFAULT (NULL) FOR [comandosistemaoperacional];

-- Object:  Default [DF__comentari__dataf__59463169]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [comentarios] ADD  DEFAULT (NULL) FOR [datafim];

-- Object:  Default [DF__complexid__idcon__5E0AE686]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [complexidade] ADD  DEFAULT ('0') FOR [idcontrato];

-- Object:  Default [DF__complexid__valor__5EFF0ABF]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [complexidade] ADD  DEFAULT (NULL) FOR [valorcomplexidade];

-- Object:  Default [DF__complexid__delet__5FF32EF8]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [complexidade] ADD  DEFAULT (NULL) FOR [deleted];

-- Object:  Default [DF__condicaoo__dataf__64B7E415]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [condicaooperacao] ADD  DEFAULT (NULL) FOR [datafim];

-- Object:  Default [DF__contadora__idusu__318D45CA]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [contadoracesso] ADD  DEFAULT (NULL) FOR [idusuario];

-- Object:  Default [DF__contadora__idbas__32816A03]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [contadoracesso] ADD  DEFAULT (NULL) FOR [idbaseconhecimento];

-- Object:  Default [DF__contatocl__telef__392E6792]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [contatocliente] ADD  DEFAULT (NULL) FOR [telefones];

-- Object:  Default [DF__contatocl__email__3A228BCB]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [contatocliente] ADD  DEFAULT (NULL) FOR [email];

-- Object:  Default [DF__contatocl__depar__3B16B004]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [contatocliente] ADD  DEFAULT (NULL) FOR [departamento];

-- Object:  Default [DF__contatocl__datai__3C0AD43D]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [contatocliente] ADD  DEFAULT (NULL) FOR [datainicio];

-- Object:  Default [DF__contatocl__dataf__3CFEF876]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [contatocliente] ADD  DEFAULT (NULL) FOR [datafim];

-- Object:  Default [DF__contatopr__nomec__5B795DF5]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [contatoproblema] ADD  DEFAULT (NULL) FOR [nomecontato];

-- Object:  Default [DF__contatopr__telef__5C6D822E]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [contatoproblema] ADD  DEFAULT (NULL) FOR [telefonecontato];

-- Object:  Default [DF__contatopr__email__5D61A667]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [contatoproblema] ADD  DEFAULT (NULL) FOR [emailcontato];

-- Object:  Default [DF__contatopr__idloc__5E55CAA0]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [contatoproblema] ADD  DEFAULT (NULL) FOR [idlocalidade];

-- Object:  Default [DF__contatopr__ramal__5F49EED9]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [contatoproblema] ADD  DEFAULT (NULL) FOR [ramal];

-- Object:  Default [DF__contatore__nomec__41C3AD93]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [contatorequisicaomudanca] ADD  DEFAULT (NULL) FOR [nomecontato];

-- Object:  Default [DF__contatore__telef__42B7D1CC]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [contatorequisicaomudanca] ADD  DEFAULT (NULL) FOR [telefonecontato];

-- Object:  Default [DF__contatore__email__43ABF605]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [contatorequisicaomudanca] ADD  DEFAULT (NULL) FOR [emailcontato];

-- Object:  Default [DF__contatore__idloc__44A01A3E]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [contatorequisicaomudanca] ADD  DEFAULT (NULL) FOR [idlocalidade];

-- Object:  Default [DF__contatore__ramal__45943E77]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [contatorequisicaomudanca] ADD  DEFAULT (NULL) FOR [ramal];

-- Object:  Default [DF__contatoso__telef__4A58F394]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [contatosolicitacaoservico] ADD  DEFAULT (NULL) FOR [telefonecontato];

-- Object:  Default [DF__contatoso__idloc__4B4D17CD]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [contatosolicitacaoservico] ADD  DEFAULT (NULL) FOR [idlocalidade];

-- Object:  Default [DF__contatoso__ramal__4C413C06]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [contatosolicitacaoservico] ADD  DEFAULT (NULL) FOR [ramal];

-- Object:  Default [DF__contratoq__idpro__5105F123]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [contratoquestionarios] ADD  DEFAULT (NULL) FOR [idprofissional];

-- Object:  Default [DF__contratoq__idemp__51FA155C]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [contratoquestionarios] ADD  DEFAULT (NULL) FOR [idempresa];

-- Object:  Default [DF__contratoque__aba__52EE3995]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [contratoquestionarios] ADD  DEFAULT (NULL) FOR [aba];

-- Object:  Default [DF__contratoq__situa__53E25DCE]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [contratoquestionarios] ADD  DEFAULT (NULL) FOR [situacao];

-- Object:  Default [DF__contratoq__situa__54D68207]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [contratoquestionarios] ADD  DEFAULT (NULL) FOR [situacaocomplemento];

-- Object:  Default [DF__contratoq__datah__55CAA640]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [contratoquestionarios] ADD  DEFAULT (NULL) FOR [datahoragrav];

-- Object:  Default [DF__contratoq__migra__56BECA79]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [contratoquestionarios] ADD  DEFAULT (NULL) FOR [migrado];

-- Object:  Default [DF__contratoq__idmig__57B2EEB2]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [contratoquestionarios] ADD  DEFAULT (NULL) FOR [idmigracao];

-- Object:  Default [DF__contratos__idmoe__492FC531]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [contratos] ADD  DEFAULT (NULL) FOR [idmoeda];

-- Object:  Default [DF__contratos__valor__4A23E96A]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [contratos] ADD  DEFAULT (NULL) FOR [valorestimado];

-- Object:  Default [DF__contratos__tipot__4B180DA3]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [contratos] ADD  DEFAULT (NULL) FOR [tipotempoestimado];

-- Object:  Default [DF__contratos__tempo__4C0C31DC]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [contratos] ADD  DEFAULT (NULL) FOR [tempoestimado];

-- Object:  Default [DF__contratos__cotac__4D005615]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [contratos] ADD  DEFAULT (NULL) FOR [cotacaomoeda];

-- Object:  Default [DF__contratos__cadas__4DF47A4E]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [contratos] ADD  DEFAULT (NULL) FOR [cadastromanualusuario];

-- Object:  Default [DF__contratos__delet__4EE89E87]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [contratos] ADD  DEFAULT (NULL) FOR [deleted];

-- Object:  Default [DF__contratos__idgru__4FDCC2C0]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [contratos] ADD  DEFAULT (NULL) FOR [idgruposolicitante];

-- Object:  Default [DF__contratos__dataf__50D0E6F9]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [contratos] ADD  DEFAULT (NULL) FOR [datafimcontrato];

-- Object:  Default [DF__contratos__idmoe__5689C04F]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [contratos_hist] ADD  DEFAULT (NULL) FOR [idmoeda];

-- Object:  Default [DF__contratos__valor__577DE488]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [contratos_hist] ADD  DEFAULT (NULL) FOR [valorestimado];

-- Object:  Default [DF__contratos__tipot__587208C1]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [contratos_hist] ADD  DEFAULT (NULL) FOR [tipotempoestimado];

-- Object:  Default [DF__contratos__tempo__59662CFA]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [contratos_hist] ADD  DEFAULT (NULL) FOR [tempoestimado];

-- Object:  Default [DF__contratos__cotac__5A5A5133]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [contratos_hist] ADD  DEFAULT (NULL) FOR [cotacaomoeda];

-- Object:  Default [DF__contratos__cadas__5B4E756C]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [contratos_hist] ADD  DEFAULT (NULL) FOR [cadastromanualusuario];

-- Object:  Default [DF__contratos__delet__5C4299A5]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [contratos_hist] ADD  DEFAULT (NULL) FOR [deleted];

-- Object:  Default [DF__contratos__idgru__5D36BDDE]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [contratos_hist] ADD  DEFAULT (NULL) FOR [idgruposolicitante];

-- Object:  Default [DF__contratos__dataf__5E2AE217]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [contratos_hist] ADD  DEFAULT (NULL) FOR [datafimcontrato];

-- Object:  Default [DF__contratos__criad__5F1F0650]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [contratos_hist] ADD  DEFAULT (NULL) FOR [criadopor];

-- Object:  Default [DF__contratos__modif__60132A89]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [contratos_hist] ADD  DEFAULT ('0000-00-00 00:00:00') FOR [modificadoem];

-- Object:  Default [DF__contratos__modif__61074EC2]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [contratos_hist] ADD  DEFAULT (NULL) FOR [modificadopor];

-- Object:  Default [DF__contratos__idcon__39D87308]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [contratosunidades] ADD  DEFAULT ('0') FOR [idcontrato];

-- Object:  Default [DF__contratos__contr__3ACC9741]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [contratosunidades] ADD  DEFAULT (NULL) FOR [contratosunidadescol];

-- Object:  Default [DF__controleg__descr__1E704FB5]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [controleged] ADD  DEFAULT (NULL) FOR [descricaoarquivo];

-- Object:  Default [DF__controleg__exten__1F6473EE]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [controleged] ADD  DEFAULT (NULL) FOR [extensaoarquivo];

-- Object:  Default [DF__controleg__datah__20589827]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [controleged] ADD  DEFAULT (sysdatetime()) FOR [datahora];

-- Object:  Default [DF__controleg__pasta__214CBC60]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [controleged] ADD  DEFAULT (NULL) FOR [pasta];

-- Object:  Default [DF__cotacao__identif__21CBDF4D]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [cotacao] ADD  DEFAULT (NULL) FOR [identificacao];

-- Object:  Default [DF__cotacao__datahor__22C00386]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [cotacao] ADD  DEFAULT (getdate()) FOR [datahoracadastro];

-- Object:  Default [DF__cotacao__datafin__23B427BF]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [cotacao] ADD  DEFAULT (NULL) FOR [datafinalprevista];

-- Object:  Default [DF__cotacaoit__idpar__06E2DEE7]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [cotacaoitemrequisicao] ADD  DEFAULT (NULL) FOR [idparecer];

-- Object:  Default [DF__cotacaoit__idite__07D70320]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [cotacaoitemrequisicao] ADD  DEFAULT (NULL) FOR [iditemtrabalhoaprovacao];

-- Object:  Default [DF__cotacaoit__idsol__08CB2759]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [cotacaoitemrequisicao] ADD  DEFAULT (NULL) FOR [idsolicitacaoservico];

-- Object:  Default [DF__cotacaoit__idite__09BF4B92]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [cotacaoitemrequisicao] ADD  DEFAULT (NULL) FOR [iditemtrabalhoinspecao];

-- Object:  Default [DF__cotacaoit__idcot__0AB36FCB]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [cotacaoitemrequisicao] ADD  DEFAULT (NULL) FOR [idcotacao];

-- Object:  Default [DF__cotacaoit__situa__0BA79404]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [cotacaoitemrequisicao] ADD  DEFAULT (NULL) FOR [situacao];

-- Object:  Default [DF__cotacaoit__quant__0C9BB83D]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [cotacaoitemrequisicao] ADD  DEFAULT (NULL) FOR [quantidadeentregue];

-- Object:  Default [DF__cotacaoit__idite__0D8FDC76]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [cotacaoitemrequisicao] ADD  DEFAULT (NULL) FOR [iditemtrabalho];

-- Object:  Default [DF__criterioa__idava__3B219CFC]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [criterioavaliacaofornecedor] ADD  DEFAULT ('0') FOR [idavaliacaofornecedor];

-- Object:  Default [DF__criterioa__idcri__3C15C135]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [criterioavaliacaofornecedor] ADD  DEFAULT ('0') FOR [idcriterio];

-- Object:  Default [DF__criterioa__valor__3D09E56E]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [criterioavaliacaofornecedor] ADD  DEFAULT (NULL) FOR [valor];

-- Object:  Default [DF__demandas__idcont__56C9B771]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [demandas] ADD  DEFAULT (NULL) FOR [idcontrato];

-- Object:  Default [DF__demandas__idproj__57BDDBAA]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [demandas] ADD  DEFAULT (NULL) FOR [idprojeto];

-- Object:  Default [DF__demandas__iddema__58B1FFE3]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [demandas] ADD  DEFAULT (NULL) FOR [iddemandapai];

-- Object:  Default [DF__demandas__previs__59A6241C]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [demandas] ADD  DEFAULT (NULL) FOR [previsaoinicio];

-- Object:  Default [DF__demandas__datain__5A9A4855]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [demandas] ADD  DEFAULT (NULL) FOR [datainicio];

-- Object:  Default [DF__demandas__previs__5B8E6C8E]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [demandas] ADD  DEFAULT (NULL) FOR [previsaofim];

-- Object:  Default [DF__demandas__datafi__5C8290C7]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [demandas] ADD  DEFAULT (NULL) FOR [datafim];

-- Object:  Default [DF__demandas__expect__5D76B500]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [demandas] ADD  DEFAULT (NULL) FOR [expectativafim];

-- Object:  Default [DF__demandas__dataca__5E6AD939]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [demandas] ADD  DEFAULT (NULL) FOR [datacadastro];

-- Object:  Default [DF__demandas__comple__5F5EFD72]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [demandas] ADD  DEFAULT (NULL) FOR [complexidade];

-- Object:  Default [DF__demandas__custot__605321AB]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [demandas] ADD  DEFAULT (NULL) FOR [custototal];

-- Object:  Default [DF__demandas__idos__614745E4]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [demandas] ADD  DEFAULT (NULL) FOR [idos];

-- Object:  Default [DF__demandas__glosa__623B6A1D]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [demandas] ADD  DEFAULT (NULL) FOR [glosa];

-- Object:  Default [DF__dicionario__nome__67001F3A]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [dicionario] ADD  DEFAULT (NULL) FOR [nome];

-- Object:  Default [DF__dicionari__valor__67F44373]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [dicionario] ADD  DEFAULT (NULL) FOR [valor];

-- Object:  Default [DF__dicionari__idlin__68E867AC]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [dicionario] ADD  DEFAULT (NULL) FOR [idlingua];

ALTER TABLE [dicionario] ADD  DEFAULT ('N') FOR [personalizado];

-- Object:  Default [DF__empregado__idemp__7271D1E6]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [empregadoitemconfiguracao] ADD  DEFAULT (NULL) FOR [idempregado];

-- Object:  Default [DF__empregado__dataf__7365F61F]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [empregadoitemconfiguracao] ADD  DEFAULT (NULL) FOR [datafim];

-- Object:  Default [DF__empregado__nomep__70099B30]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [empregados] ADD  DEFAULT (NULL) FOR [nomeprocura];

-- Object:  Default [DF__empregado__datan__70FDBF69]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [empregados] ADD  DEFAULT (NULL) FOR [datanascimento];

-- Object:  Default [DF__empregados__sexo__71F1E3A2]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [empregados] ADD  DEFAULT (NULL) FOR [sexo];

-- Object:  Default [DF__empregados__cpf__72E607DB]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [empregados] ADD  DEFAULT (NULL) FOR [cpf];

-- Object:  Default [DF__empregados__rg__73DA2C14]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [empregados] ADD  DEFAULT (NULL) FOR [rg];

-- Object:  Default [DF__empregado__datae__74CE504D]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [empregados] ADD  DEFAULT (NULL) FOR [dataemissaorg];

-- Object:  Default [DF__empregado__idtip__75C27486]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [empregados] ADD  DEFAULT ('0') FOR [idtiposangue];

-- Object:  Default [DF__empregado__orgex__76B698BF]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [empregados] ADD  DEFAULT (NULL) FOR [orgexpedidor];

-- Object:  Default [DF__empregado__idufo__77AABCF8]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [empregados] ADD  DEFAULT (NULL) FOR [iduforgexpedidor];

-- Object:  Default [DF__empregados__pai__789EE131]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [empregados] ADD  DEFAULT (NULL) FOR [pai];

-- Object:  Default [DF__empregados__mae__7993056A]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [empregados] ADD  DEFAULT (NULL) FOR [mae];

-- Object:  Default [DF__empregado__conju__7A8729A3]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [empregados] ADD  DEFAULT (NULL) FOR [conjuge];

-- Object:  Default [DF__empregado__estad__7B7B4DDC]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [empregados] ADD  DEFAULT (NULL) FOR [estadocivil];

-- Object:  Default [DF__empregado__email__7C6F7215]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [empregados] ADD  DEFAULT (NULL) FOR [email];

-- Object:  Default [DF__empregado__datac__7D63964E]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [empregados] ADD  DEFAULT (NULL) FOR [datacadastro];

-- Object:  Default [DF__empregado__fuman__7E57BA87]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [empregados] ADD  DEFAULT ('N') FOR [fumante];

-- Object:  Default [DF__empregado__ctpsn__7F4BDEC0]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [empregados] ADD  DEFAULT (NULL) FOR [ctpsnumero];

-- Object:  Default [DF__empregado__ctpss__004002F9]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [empregados] ADD  DEFAULT (NULL) FOR [ctpsserie];

-- Object:  Default [DF__empregado__ctpsi__01342732]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [empregados] ADD  DEFAULT (NULL) FOR [ctpsiduf];

-- Object:  Default [DF__empregado__ctpsd__02284B6B]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [empregados] ADD  DEFAULT (NULL) FOR [ctpsdataemissao];

-- Object:  Default [DF__empregados__nit__031C6FA4]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [empregados] ADD  DEFAULT (NULL) FOR [nit];

-- Object:  Default [DF__empregado__dataa__041093DD]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [empregados] ADD  DEFAULT (NULL) FOR [dataadmissao];

-- Object:  Default [DF__empregado__datad__0504B816]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [empregados] ADD  DEFAULT (NULL) FOR [datademissao];

-- Object:  Default [DF__empregados__tipo__05F8DC4F]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [empregados] ADD  DEFAULT (NULL) FOR [tipo];

-- Object:  Default [DF__empregado__custo__06ED0088]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [empregados] ADD  DEFAULT (NULL) FOR [custoporhora];

-- Object:  Default [DF__empregado__custo__07E124C1]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [empregados] ADD  DEFAULT (NULL) FOR [custototalmes];

-- Object:  Default [DF__empregado__valor__08D548FA]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [empregados] ADD  DEFAULT (NULL) FOR [valorsalario];

-- Object:  Default [DF__empregado__valor__09C96D33]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [empregados] ADD  DEFAULT (NULL) FOR [valorProdutividadeMedia];

-- Object:  Default [DF__empregado__valor__0ABD916C]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [empregados] ADD  DEFAULT (NULL) FOR [valorPlanoSaudeMedia];

-- Object:  Default [DF__empregado__valor__0BB1B5A5]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [empregados] ADD  DEFAULT (NULL) FOR [valorVTraMedia];

-- Object:  Default [DF__empregado__valor__0CA5D9DE]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [empregados] ADD  DEFAULT (NULL) FOR [valorVRefMedia];

-- Object:  Default [DF__empregado__agenc__0D99FE17]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [empregados] ADD  DEFAULT (NULL) FOR [agencia];

-- Object:  Default [DF__empregado__conta__0E8E2250]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [empregados] ADD  DEFAULT (NULL) FOR [contasalario];

-- Object:  Default [DF__empregado__iduni__0F824689]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [empregados] ADD  DEFAULT (NULL) FOR [idunidade];

-- Object:  Default [DF__empregado__dataf__10766AC2]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [empregados] ADD  DEFAULT (NULL) FOR [datafim];

-- Object:  Default [DF__empregado__telef__116A8EFB]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [empregados] ADD  DEFAULT (NULL) FOR [telefone];

-- Object:  Default [DF__empregado__idcar__125EB334]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [empregados] ADD  DEFAULT (NULL) FOR [idcargo];

-- Object:  Default [DF__empregado__vincu__1352D76D]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [empregados] ADD  DEFAULT (NULL) FOR [vinculaAContratos];

-- Object:  Default [DF__empregado__ramal__1446FBA6]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [empregados] ADD  DEFAULT (NULL) FOR [ramal];

-- Object:  Default [DF__empresa__dataini__782AAB3C]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [empresa] ADD  DEFAULT ('2012-04-02') FOR [datainicio];

-- Object:  Default [DF__empresa__datafim__791ECF75]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [empresa] ADD  DEFAULT (NULL) FOR [datafim];

-- Object:  Default [DF__endereco__lograd__28ED12D1]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [endereco] ADD  DEFAULT (NULL) FOR [logradouro];

-- Object:  Default [DF__endereco__numero__29E1370A]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [endereco] ADD  DEFAULT (NULL) FOR [numero];

-- Object:  Default [DF__endereco__comple__2AD55B43]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [endereco] ADD  DEFAULT (NULL) FOR [complemento];

-- Object:  Default [DF__endereco__bairro__2BC97F7C]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [endereco] ADD  DEFAULT (NULL) FOR [bairro];

-- Object:  Default [DF__endereco__idcida__2CBDA3B5]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [endereco] ADD  DEFAULT (NULL) FOR [idcidade];

-- Object:  Default [DF__endereco__idpais__2DB1C7EE]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [endereco] ADD  DEFAULT (NULL) FOR [idpais];

-- Object:  Default [DF__endereco__cep__2EA5EC27]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [endereco] ADD  DEFAULT (NULL) FOR [cep];

-- Object:  Default [DF__endereco__iduf__2F9A1060]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [endereco] ADD  DEFAULT (NULL) FOR [iduf];

-- Object:  Default [DF__entregait__idsol__7ED7A8CB]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [entregaitemrequisicao] ADD  DEFAULT (NULL) FOR [idsolicitacaoservico];

-- Object:  Default [DF__entregait__idite__7FCBCD04]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [entregaitemrequisicao] ADD  DEFAULT (NULL) FOR [iditemtrabalho];

-- Object:  Default [DF__entregait__idpar__00BFF13D]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [entregaitemrequisicao] ADD  DEFAULT (NULL) FOR [idparecer];

-- Object:  Default [DF__etapas__idetapap__15BB0E23]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [etapas] ADD  DEFAULT (NULL) FOR [idetapapai];

-- Object:  Default [DF__evento__datainic__1F44785D]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [evento] ADD  DEFAULT (NULL) FOR [datainicio];

-- Object:  Default [DF__evento__datafim__20389C96]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [evento] ADD  DEFAULT (NULL) FOR [datafim];

-- Object:  Default [DF__evento__usuario__212CC0CF]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [evento] ADD  DEFAULT (NULL) FOR [usuario];

-- Object:  Default [DF__evento__senha__2220E508]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [evento] ADD  DEFAULT (NULL) FOR [senha];

-- Object:  Default [DF__eventoemp__idgru__2E86BBED]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [eventoempregado] ADD  DEFAULT (NULL) FOR [idgrupo];

-- Object:  Default [DF__eventoemp__iduni__2F7AE026]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [eventoempregado] ADD  DEFAULT (NULL) FOR [idunidade];

-- Object:  Default [DF__eventoemp__idite__306F045F]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [eventoempregado] ADD  DEFAULT (NULL) FOR [iditemconfiguracaopai];

-- Object:  Default [DF__eventogru__ideve__3533B97C]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [eventogrupo] ADD  DEFAULT (NULL) FOR [idevento];

-- Object:  Default [DF__eventogru__idgru__3627DDB5]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [eventogrupo] ADD  DEFAULT (NULL) FOR [idgrupo];

-- Object:  Default [DF__eventoite__ideve__3BE0B70B]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [eventoitemconfiguracao] ADD  DEFAULT ('0') FOR [idevento];

-- Object:  Default [DF__eventoite__idite__3CD4DB44]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [eventoitemconfiguracao] ADD  DEFAULT ('0') FOR [iditemconfiguracao];

-- Object:  Default [DF__eventomon__criad__4E3E9311]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [eventomonitoramento] ADD  DEFAULT (NULL) FOR [criadopor];

-- Object:  Default [DF__eventomon__modif__4F32B74A]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [eventomonitoramento] ADD  DEFAULT (NULL) FOR [modificadopor];

-- Object:  Default [DF__eventomon__datac__5026DB83]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [eventomonitoramento] ADD  DEFAULT (NULL) FOR [datacriacao];

-- Object:  Default [DF__eventomon__ultmo__511AFFBC]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [eventomonitoramento] ADD  DEFAULT (NULL) FOR [ultmodificacao];

-- Object:  Default [DF__eventouni__iduni__428DB49A]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [eventounidade] ADD  DEFAULT (NULL) FOR [idunidade];

-- Object:  Default [DF__eventouni__ideve__4381D8D3]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [eventounidade] ADD  DEFAULT (NULL) FOR [idevento];

-- Object:  Default [DF__excecaoca__idjor__48468DF0]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [excecaocalendario] ADD  DEFAULT (NULL) FOR [idjornada];

-- Object:  Default [DF__excecaoem__idgru__0FED2634]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [excecaoempregado] ADD  DEFAULT (NULL) FOR [idgrupo];

-- Object:  Default [DF__excecaoem__iduni__10E14A6D]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [excecaoempregado] ADD  DEFAULT (NULL) FOR [idunidade];

-- Object:  Default [DF__execucaoa__horap__4D0B430D]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [execucaoatividadeperiodica] ADD  DEFAULT (NULL) FOR [horaprogramada];

-- Object:  Default [DF__execucaoa__usuar__4DFF6746]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [execucaoatividadeperiodica] ADD  DEFAULT (NULL) FOR [usuario];

-- Object:  Default [DF__execucaoa__idemp__4EF38B7F]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [execucaoatividadeperiodica] ADD  DEFAULT (NULL) FOR [idempregado];

-- Object:  Default [DF__execucaoa__datae__4FE7AFB8]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [execucaoatividadeperiodica] ADD  DEFAULT (NULL) FOR [dataexecucao];

-- Object:  Default [DF__execucaoa__horae__50DBD3F1]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [execucaoatividadeperiodica] ADD  DEFAULT (NULL) FOR [horaexecucao];

-- Object:  Default [DF__execucaoa__datar__51CFF82A]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [execucaoatividadeperiodica] ADD  DEFAULT (NULL) FOR [dataregistro];

-- Object:  Default [DF__execucaoa__horar__52C41C63]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [execucaoatividadeperiodica] ADD  DEFAULT (NULL) FOR [horaregistro];

-- Object:  Default [DF__execucaoa__idpro__53B8409C]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [execucaoatividadeperiodica] ADD  DEFAULT (NULL) FOR [idprogramacaoatividade];

-- Object:  Default [DF__execucaoa__idmot__54AC64D5]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [execucaoatividadeperiodica] ADD  DEFAULT (NULL) FOR [idmotivosuspensao];

-- Object:  Default [DF__execucaob__datah__597119F2]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [execucaobatch] ADD  DEFAULT (sysdatetime()) FOR [datahora];

-- Object:  Default [DF__execucaod__idemp__5E35CF0F]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [execucaodemanda] ADD  DEFAULT (NULL) FOR [idempregadoexecutor];

-- Object:  Default [DF__execucaod__idemp__5F29F348]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [execucaodemanda] ADD  DEFAULT (NULL) FOR [idempregadoreceptor];

-- Object:  Default [DF__execucaod__qtdeh__601E1781]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [execucaodemanda] ADD  DEFAULT (NULL) FOR [qtdehoras];

-- Object:  Default [DF__execucaod__grupo__61123BBA]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [execucaodemanda] ADD  DEFAULT (NULL) FOR [grupoexecutor];

-- Object:  Default [DF__execucaod__termi__62065FF3]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [execucaodemanda] ADD  DEFAULT (NULL) FOR [terminoprevisto];

-- Object:  Default [DF__execucaod__termi__62FA842C]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [execucaodemanda] ADD  DEFAULT (NULL) FOR [terminoreal];

-- Object:  Default [DF__execucaom__seqre__67BF3949]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [execucaomudanca] ADD  DEFAULT (NULL) FOR [seqreabertura];

-- Object:  Default [DF__execucaop__idpro__65F6EC68]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [execucaoproblema] ADD  DEFAULT (NULL) FOR [idproblema];

-- Object:  Default [DF__execucaop__idfas__66EB10A1]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [execucaoproblema] ADD  DEFAULT (NULL) FOR [idfase];

-- Object:  Default [DF__execucaop__idins__67DF34DA]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [execucaoproblema] ADD  DEFAULT (NULL) FOR [idinstanciafluxo];

-- Object:  Default [DF__execucaop__idflu__68D35913]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [execucaoproblema] ADD  DEFAULT (NULL) FOR [idfluxo];

-- Object:  Default [DF__execucaop__prazo__69C77D4C]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [execucaoproblema] ADD  DEFAULT (NULL) FOR [prazohh];

-- Object:  Default [DF__execucaop__prazo__6ABBA185]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [execucaoproblema] ADD  DEFAULT (NULL) FOR [prazomm];

-- Object:  Default [DF__execucaop__seqre__6BAFC5BE]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [execucaoproblema] ADD  DEFAULT (NULL) FOR [seqreabertura];

-- Object:  Default [DF__execucaos__idsol__6F605B11]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [execucaosolicitacao] ADD  DEFAULT (NULL) FOR [idsolicitacaoservico];

-- Object:  Default [DF__execucaos__idfas__70547F4A]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [execucaosolicitacao] ADD  DEFAULT (NULL) FOR [idfase];

-- Object:  Default [DF__execucaos__idins__7148A383]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [execucaosolicitacao] ADD  DEFAULT (NULL) FOR [idinstanciafluxo];

-- Object:  Default [DF__execucaos__idflu__723CC7BC]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [execucaosolicitacao] ADD  DEFAULT (NULL) FOR [idfluxo];

-- Object:  Default [DF__execucaos__prazo__7330EBF5]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [execucaosolicitacao] ADD  DEFAULT (NULL) FOR [prazohh];

-- Object:  Default [DF__execucaos__prazo__7425102E]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [execucaosolicitacao] ADD  DEFAULT (NULL) FOR [prazomm];

-- Object:  Default [DF__execucaos__seqre__75193467]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [execucaosolicitacao] ADD  DEFAULT (NULL) FOR [seqreabertura];

-- Object:  Default [DF__externalc__urljd__79DDE984]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [externalconnection] ADD  DEFAULT (NULL) FOR [urljdbc];

-- Object:  Default [DF__externalc__jdbcd__7AD20DBD]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [externalconnection] ADD  DEFAULT (NULL) FOR [jdbcdbname];

-- Object:  Default [DF__externalc__jdbcd__7BC631F6]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [externalconnection] ADD  DEFAULT (NULL) FOR [jdbcdriver];

-- Object:  Default [DF__externalc__jdbcu__7CBA562F]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [externalconnection] ADD  DEFAULT (NULL) FOR [jdbcuser];

-- Object:  Default [DF__externalc__jdbcp__7DAE7A68]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [externalconnection] ADD  DEFAULT (NULL) FOR [jdbcpassword];

-- Object:  Default [DF__externalc__filen__7EA29EA1]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [externalconnection] ADD  DEFAULT (NULL) FOR [filename];

-- Object:  Default [DF__externalc__schem__7F96C2DA]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [externalconnection] ADD  DEFAULT (NULL) FOR [schemadb];

-- Object:  Default [DF__externalc__delet__008AE713]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [externalconnection] ADD  DEFAULT (NULL) FOR [deleted];

-- Object:  Default [DF__faixavalo__valor__054F9C30]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [faixavaloresrecurso] ADD  DEFAULT (NULL) FOR [valorinicio];

-- Object:  Default [DF__faixavalo__valor__0643C069]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [faixavaloresrecurso] ADD  DEFAULT (NULL) FOR [valorfim];

-- Object:  Default [DF__faixavalore__cor__0737E4A2]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [faixavaloresrecurso] ADD  DEFAULT (NULL) FOR [cor];

-- Object:  Default [DF__faixavalo__descr__082C08DB]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [faixavaloresrecurso] ADD  DEFAULT (NULL) FOR [descricao];

-- Object:  Default [DF__fatura__descrica__139DBB87]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [fatura] ADD  DEFAULT (NULL) FOR [descricaofatura];

-- Object:  Default [DF__fatura__valorpre__1491DFC0]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [fatura] ADD  DEFAULT (NULL) FOR [valorprevistosomaos];

-- Object:  Default [DF__fatura__valorsom__158603F9]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [fatura] ADD  DEFAULT (NULL) FOR [valorsomaglosasos];

-- Object:  Default [DF__fatura__valorexe__167A2832]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [fatura] ADD  DEFAULT (NULL) FOR [valorexecutadosomaos];

-- Object:  Default [DF__fatura__saldopre__176E4C6B]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [fatura] ADD  DEFAULT (NULL) FOR [saldoprevisto];

-- Object:  Default [DF__faturaapu__valor__1C330188]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [faturaapuracaoans] ADD  DEFAULT (NULL) FOR [valorapurado];

-- Object:  Default [DF__faturaapu__perce__1D2725C1]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [faturaapuracaoans] ADD  DEFAULT (NULL) FOR [percentualglosa];

-- Object:  Default [DF__faturaapu__valor__1E1B49FA]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [faturaapuracaoans] ADD  DEFAULT (NULL) FOR [valorglosa];

-- Object:  Default [DF__faturaapu__dataa__1F0F6E33]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [faturaapuracaoans] ADD  DEFAULT (NULL) FOR [dataapuracao];

-- Object:  Default [DF__feriado__descric__27A4B434]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [feriado] ADD  DEFAULT (NULL) FOR [descricao];

-- Object:  Default [DF__feriado__abrange__2898D86D]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [feriado] ADD  DEFAULT (NULL) FOR [abrangencia];

-- Object:  Default [DF__feriado__iduf__298CFCA6]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [feriado] ADD  DEFAULT (NULL) FOR [iduf];

-- Object:  Default [DF__feriado__idcidad__2A8120DF]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [feriado] ADD  DEFAULT (NULL) FOR [idcidade];

-- Object:  Default [DF__feriado__recorre__2B754518]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [feriado] ADD  DEFAULT (NULL) FOR [recorrente];

-- Object:  Default [DF__fluxoserv__princ__37DB1BFD]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [fluxoservico] ADD  DEFAULT ('N') FOR [principal];

-- Object:  Default [DF__fluxoserv__delet__38CF4036]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [fluxoservico] ADD  DEFAULT (NULL) FOR [deleted];

-- Object:  Default [DF__formula__datacri__2611717D]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [formula] ADD  DEFAULT (NULL) FOR [datacriacao];

-- Object:  Default [DF__fornecedo__nomef__63D8CE75]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [fornecedor] ADD  DEFAULT (NULL) FOR [nomefantasia];

-- Object:  Default [DF__fornecedor__cnpj__64CCF2AE]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [fornecedor] ADD  DEFAULT (NULL) FOR [cnpj];

-- Object:  Default [DF__fornecedo__email__65C116E7]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [fornecedor] ADD  DEFAULT (NULL) FOR [email];

-- Object:  Default [DF__fornecedo__delet__66B53B20]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [fornecedor] ADD  DEFAULT (NULL) FOR [deleted];

-- Object:  Default [DF__fornecedo__telef__67A95F59]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [fornecedor] ADD  DEFAULT (NULL) FOR [telefone];

-- Object:  Default [DF__fornecedor__fax__689D8392]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [fornecedor] ADD  DEFAULT (NULL) FOR [fax];

-- Object:  Default [DF__fornecedo__nomeC__6991A7CB]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [fornecedor] ADD  DEFAULT (NULL) FOR [nomeContato];

-- Object:  Default [DF__fornecedo__inscr__6A85CC04]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [fornecedor] ADD  DEFAULT (NULL) FOR [inscricaoEstadual];

-- Object:  Default [DF__fornecedo__inscr__6B79F03D]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [fornecedor] ADD  DEFAULT (NULL) FOR [inscricaoMunicipal];

-- Object:  Default [DF__fornecedo__idend__6C6E1476]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [fornecedor] ADD  DEFAULT (NULL) FOR [idendereco];

-- Object:  Default [DF__fornecedo__tipop__6D6238AF]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [fornecedor] ADD  DEFAULT (NULL) FOR [tipopessoa];

-- Object:  Default [DF__fornecedo__idfor__3D93F553]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [fornecedorcotacao] ADD  DEFAULT ('0') FOR [idfornecedor];

-- Object:  Default [DF__fornecedo__idfor__49F9CC38]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [fornecedorproduto] ADD  DEFAULT (NULL) FOR [idfornecedor];

-- Object:  Default [DF__fornecedo__idmar__4AEDF071]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [fornecedorproduto] ADD  DEFAULT (NULL) FOR [idmarca];

-- Object:  Default [DF__fornecedo__dataf__4BE214AA]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [fornecedorproduto] ADD  DEFAULT (NULL) FOR [datafim];

-- Object:  Default [DF__galeriaim__descr__528F1239]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [galeriaimagens] ADD  DEFAULT (NULL) FOR [descricaoimagem];

-- Object:  Default [DF__galeriaim__exten__53833672]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [galeriaimagens] ADD  DEFAULT (NULL) FOR [extensao];

-- Object:  Default [DF__glosaos__numeroO__5847EB8F]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [glosaos] ADD  DEFAULT (NULL) FOR [numeroOcorrencias];

-- Object:  Default [DF__glosaos__idacord__593C0FC8]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [glosaos] ADD  DEFAULT (NULL) FOR [idacordonivelservico];

-- Object:  Default [DF__glosaserv__quant__5E00C4E5]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [glosaservicocontrato] ADD  DEFAULT (NULL) FOR [quantidadeglosa];

-- Object:  Default [DF__glosaserv__dataf__5EF4E91E]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [glosaservicocontrato] ADD  DEFAULT (NULL) FOR [datafim];

-- Object:  Default [DF__grupo__datafim__17E28260]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [grupo] ADD  DEFAULT (NULL) FOR [datafim];

-- Object:  Default [DF__grupo__servicede__18D6A699]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [grupo] ADD  DEFAULT (NULL) FOR [servicedesk];

-- Object:  Default [DF__grupo__sigla__19CACAD2]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [grupo] ADD  DEFAULT (NULL) FOR [sigla];

-- Object:  Default [DF__grupo__abertura__1ABEEF0B]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [grupo] ADD  DEFAULT (NULL) FOR [abertura];

-- Object:  Default [DF__grupo__encerrame__1BB31344]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [grupo] ADD  DEFAULT (NULL) FOR [encerramento];

-- Object:  Default [DF__grupo__andamento__1CA7377D]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [grupo] ADD  DEFAULT (NULL) FOR [andamento];

-- Object:  Default [DF__grupo__comitecon__1D9B5BB6]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [grupo] ADD  DEFAULT (NULL) FOR [comiteconsultivomudanca];

-- Object:  Default [DF__grupoatvp__dataf__63B99E3B]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [grupoatvperiodica] ADD  DEFAULT (NULL) FOR [datafim];

-- Object:  Default [DF__grupoatvp__delet__64ADC274]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [grupoatvperiodica] ADD  DEFAULT (NULL) FOR [deleted];

-- Object:  Default [DF__grupoitem__dataf__69727791]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [grupoitemconfiguracao] ADD  DEFAULT (NULL) FOR [datafim];

-- Object:  Default [DF__grupoitem__email__6A669BCA]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [grupoitemconfiguracao] ADD  DEFAULT (NULL) FOR [email];

-- Object:  Default [DF__grupoitem__email__6B5AC003]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [grupoitemconfiguracao] ADD  DEFAULT (NULL) FOR [emailgrupoitemconfiguracao];

-- Object:  Default [DF__grupoitem__idGru__6C4EE43C]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [grupoitemconfiguracao] ADD  DEFAULT (NULL) FOR [idGrupoItemConfiguracaoPai];

-- Object:  Default [DF__grupoques__ordem__71139959]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [grupoquestionario] ADD  DEFAULT (NULL) FOR [ordem];

-- Object:  Default [DF__gruporecu__delet__55DFB4D9]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [gruporecursos] ADD  DEFAULT (NULL) FOR [deleted];

-- Object:  Default [DF__gruposema__idemp__75D84E76]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [gruposemails] ADD  DEFAULT (NULL) FOR [idempregado];

-- Object:  Default [DF__gruposemai__nome__76CC72AF]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [gruposemails] ADD  DEFAULT (NULL) FOR [nome];

-- Object:  Default [DF__gruposemp__envia__0055DCE9]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [gruposempregados] ADD  DEFAULT (NULL) FOR [enviaemail];

-- Object:  Default [DF__grupovisa__tipol__09DF4723]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [grupovisaocamposnegocio] ADD  DEFAULT (NULL) FOR [tipoligacao];

-- Object:  Default [DF__grupovisa__taman__0AD36B5C]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [grupovisaocamposnegocio] ADD  DEFAULT (NULL) FOR [tamanhoparapesq];

-- Object:  Default [DF__grupovisa__descr__0F982079]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [grupovisaocamposnegocioinfosql] ADD  DEFAULT (NULL) FOR [descricao];

-- Object:  Default [DF__grupovisa__idcam__145CD596]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [grupovisaocamposnegocioligacao] ADD  DEFAULT (NULL) FOR [idcamposobjetonegocioligacao];

-- Object:  Default [DF__grupovisa__descr__1550F9CF]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [grupovisaocamposnegocioligacao] ADD  DEFAULT (NULL) FOR [descricao];

-- Object:  Default [DF__historico__idpas__727BF387]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicobaseconhecimento] ADD  DEFAULT (NULL) FOR [idpasta];

-- Object:  Default [DF__historico__datai__737017C0]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicobaseconhecimento] ADD  DEFAULT (NULL) FOR [datainicio];

-- Object:  Default [DF__historico__dataf__74643BF9]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicobaseconhecimento] ADD  DEFAULT (NULL) FOR [datafim];

-- Object:  Default [DF__historico__titul__75586032]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicobaseconhecimento] ADD  DEFAULT (NULL) FOR [titulo];

-- Object:  Default [DF__historico__statu__764C846B]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicobaseconhecimento] ADD  DEFAULT (NULL) FOR [status];

-- Object:  Default [DF__historico__idbas__7740A8A4]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicobaseconhecimento] ADD  DEFAULT (NULL) FOR [idbaseconhecimentopai];

-- Object:  Default [DF__historico__datae__7834CCDD]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicobaseconhecimento] ADD  DEFAULT (NULL) FOR [dataexpiracao];

-- Object:  Default [DF__historico__versa__7928F116]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicobaseconhecimento] ADD  DEFAULT (NULL) FOR [versao];

-- Object:  Default [DF__historico__idusu__7A1D154F]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicobaseconhecimento] ADD  DEFAULT (NULL) FOR [idusuarioautor];

-- Object:  Default [DF__historico__idusu__7B113988]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicobaseconhecimento] ADD  DEFAULT (NULL) FOR [idusuarioaprovador];

-- Object:  Default [DF__historico__fonte__7C055DC1]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicobaseconhecimento] ADD  DEFAULT (NULL) FOR [fontereferencia];

-- Object:  Default [DF__historico__idnot__7CF981FA]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicobaseconhecimento] ADD  DEFAULT (NULL) FOR [idnotificacao];

-- Object:  Default [DF__historico__datap__7DEDA633]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicobaseconhecimento] ADD  DEFAULT (NULL) FOR [datapublicacao];

-- Object:  Default [DF__historico__justi__7EE1CA6C]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicobaseconhecimento] ADD  DEFAULT (NULL) FOR [justificativaobservacao];

-- Object:  Default [DF__historicoba__faq__7FD5EEA5]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicobaseconhecimento] ADD  DEFAULT (NULL) FOR [faq];

-- Object:  Default [DF__historico__orige__00CA12DE]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicobaseconhecimento] ADD  DEFAULT (NULL) FOR [origem];

-- Object:  Default [DF__historico__arqui__01BE3717]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicobaseconhecimento] ADD  DEFAULT (NULL) FOR [arquivado];

-- Object:  Default [DF__historico__idusu__02B25B50]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicobaseconhecimento] ADD  DEFAULT (NULL) FOR [idusuarioalteracao];

-- Object:  Default [DF__historico__datah__03A67F89]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicobaseconhecimento] ADD  DEFAULT (NULL) FOR [datahoraalteracao];

-- Object:  Default [DF__historicoe__hora__1EDA6409]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoexecucao] ADD  DEFAULT (NULL) FOR [hora];

-- Object:  Default [DF__historico__idite__267B85D1]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoic] ADD  DEFAULT (NULL) FOR [iditemconfiguracaopai];

-- Object:  Default [DF__historico__idtip__276FAA0A]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoic] ADD  DEFAULT (NULL) FOR [idtipoitemconfiguracao];

-- Object:  Default [DF__historico__idgru__2863CE43]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoic] ADD  DEFAULT (NULL) FOR [idgrupoitemconfiguracao];

-- Object:  Default [DF__historico__idpro__2957F27C]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoic] ADD  DEFAULT (NULL) FOR [idproprietario];

-- Object:  Default [DF__historico__versa__2A4C16B5]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoic] ADD  DEFAULT (NULL) FOR [versao];

-- Object:  Default [DF__historico__famil__2B403AEE]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoic] ADD  DEFAULT (NULL) FOR [familia];

-- Object:  Default [DF__historico__idfam__2C345F27]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoic] ADD  DEFAULT (NULL) FOR [idfamiliaitemconfiguracao];

-- Object:  Default [DF__historico__class__2D288360]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoic] ADD  DEFAULT (NULL) FOR [classe];

-- Object:  Default [DF__historico__idcla__2E1CA799]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoic] ADD  DEFAULT (NULL) FOR [idclasseitemconfiguracao];

-- Object:  Default [DF__historico__local__2F10CBD2]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoic] ADD  DEFAULT (NULL) FOR [localidade];

-- Object:  Default [DF__historico__statu__3004F00B]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoic] ADD  DEFAULT (NULL) FOR [status];

-- Object:  Default [DF__historico__criti__30F91444]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoic] ADD  DEFAULT (NULL) FOR [criticidade];

-- Object:  Default [DF__historico__numer__31ED387D]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoic] ADD  DEFAULT (NULL) FOR [numeroSerie];

-- Object:  Default [DF__historico__dataE__32E15CB6]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoic] ADD  DEFAULT (NULL) FOR [dataExpiracao];

-- Object:  Default [DF__historico__idMud__33D580EF]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoic] ADD  DEFAULT (NULL) FOR [idMudanca];

-- Object:  Default [DF__historico__idPro__34C9A528]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoic] ADD  DEFAULT (NULL) FOR [idProblema];

-- Object:  Default [DF__historico__IdInc__35BDC961]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoic] ADD  DEFAULT (NULL) FOR [IdIncidente];

-- Object:  Default [DF__historico__datah__36B1ED9A]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoic] ADD  DEFAULT (sysdatetime()) FOR [datahoraalteracao];

-- Object:  Default [DF__historico__basel__37A611D3]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoic] ADD  DEFAULT (NULL) FOR [baseline];

-- Object:  Default [DF__historico__resta__389A360C]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoic] ADD  DEFAULT (NULL) FOR [restauracao];

-- Object:  Default [DF__historico__idMid__398E5A45]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoic] ADD  DEFAULT (NULL) FOR [idMidiaSoftware];

-- Object:  Default [DF__historico__impac__3A827E7E]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoic] ADD  DEFAULT (NULL) FOR [impacto];

-- Object:  Default [DF__historico__urgen__3B76A2B7]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoic] ADD  DEFAULT (NULL) FOR [urgencia];

-- Object:  Default [DF__historico__histo__3C6AC6F0]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoic] ADD  DEFAULT (NULL) FOR [historicoVersao];

-- Object:  Default [DF__historico__datah__2AA11C70]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoliberacao] ADD  DEFAULT (sysdatetime()) FOR [datahoraModificacao];

-- Object:  Default [DF__historico__tipoM__2B9540A9]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoliberacao] ADD  DEFAULT (NULL) FOR [tipoModificacao];

-- Object:  Default [DF__historico__histo__2C8964E2]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoliberacao] ADD  DEFAULT (NULL) FOR [historicoVersao];

-- Object:  Default [DF__historico__idres__2D7D891B]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoliberacao] ADD  DEFAULT (NULL) FOR [idresponsavel];

-- Object:  Default [DF__historico__datal__2E71AD54]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoliberacao] ADD  DEFAULT (NULL) FOR [dataliberacao];

-- Object:  Default [DF__historico__versa__2F65D18D]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoliberacao] ADD  DEFAULT (NULL) FOR [versao];

-- Object:  Default [DF__historico__seqre__3059F5C6]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoliberacao] ADD  DEFAULT (NULL) FOR [seqreabertura];

-- Object:  Default [DF__historico__envia__314E19FF]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoliberacao] ADD  DEFAULT (NULL) FOR [enviaemailcriacao];

-- Object:  Default [DF__historico__envia__32423E38]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoliberacao] ADD  DEFAULT (NULL) FOR [enviaemailacoes];

-- Object:  Default [DF__historico__tempo__33366271]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoliberacao] ADD  DEFAULT (NULL) FOR [tempoatrasohh];

-- Object:  Default [DF__historico__tempo__342A86AA]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoliberacao] ADD  DEFAULT (NULL) FOR [tempoatrasomm];

-- Object:  Default [DF__historico__tempo__351EAAE3]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoliberacao] ADD  DEFAULT (NULL) FOR [tempocapturahh];

-- Object:  Default [DF__historico__tempo__3612CF1C]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoliberacao] ADD  DEFAULT (NULL) FOR [tempocapturamm];

-- Object:  Default [DF__historico__datah__3706F355]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoliberacao] ADD  DEFAULT (sysdatetime()) FOR [datahoratermino];

-- Object:  Default [DF__historico__datah__37FB178E]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoliberacao] ADD  DEFAULT (sysdatetime()) FOR [datahoraconclusao];

-- Object:  Default [DF__historico__statu__38EF3BC7]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoliberacao] ADD  DEFAULT (NULL) FOR [status];

-- Object:  Default [DF__historico__tempo__39E36000]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoliberacao] ADD  DEFAULT (NULL) FOR [tempodecorridohh];

-- Object:  Default [DF__historico__tempo__3AD78439]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoliberacao] ADD  DEFAULT (NULL) FOR [tempodecorridomm];

-- Object:  Default [DF__historico__tempo__3BCBA872]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoliberacao] ADD  DEFAULT (NULL) FOR [tempoatendimentohh];

-- Object:  Default [DF__historico__tempo__3CBFCCAB]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoliberacao] ADD  DEFAULT (NULL) FOR [tempoatendimentomm];

-- Object:  Default [DF__historico__datah__3DB3F0E4]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoliberacao] ADD  DEFAULT (sysdatetime()) FOR [datahoracaptura];

-- Object:  Default [DF__historico__datah__3EA8151D]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoliberacao] ADD  DEFAULT (sysdatetime()) FOR [datahorareativacao];

-- Object:  Default [DF__historico__datah__3F9C3956]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoliberacao] ADD  DEFAULT (sysdatetime()) FOR [datahorainicio];

-- Object:  Default [DF__historico__idcal__40905D8F]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoliberacao] ADD  DEFAULT (NULL) FOR [idcalendario];

-- Object:  Default [DF__historico__datah__418481C8]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoliberacao] ADD  DEFAULT (sysdatetime()) FOR [datahorasuspensao];

-- Object:  Default [DF__historico__envia__4278A601]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoliberacao] ADD  DEFAULT (NULL) FOR [enviaemailfinalizacao];

-- Object:  Default [DF__historico__prazo__436CCA3A]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoliberacao] ADD  DEFAULT (NULL) FOR [prazohh];

-- Object:  Default [DF__historico__prazo__4460EE73]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoliberacao] ADD  DEFAULT (NULL) FOR [prazomm];

-- Object:  Default [DF__historico__datah__455512AC]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoliberacao] ADD  DEFAULT (sysdatetime()) FOR [datahorainicioagendada];

-- Object:  Default [DF__historico__datah__464936E5]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoliberacao] ADD  DEFAULT (sysdatetime()) FOR [datahoraterminoagendada];

-- Object:  Default [DF__historico__idtip__473D5B1E]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoliberacao] ADD  DEFAULT (NULL) FOR [idtipoliberacao];

-- Object:  Default [DF__historico__idGru__48317F57]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicoliberacao] ADD  DEFAULT (NULL) FOR [idGrupoAtual];

-- Object:  Default [DF__historico__datah__4223A046]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicosituacaocotacao] ADD  DEFAULT (sysdatetime()) FOR [datahora];

-- Object:  Default [DF__historico__idite__48D09DD5]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicotentativa] ADD  DEFAULT (NULL) FOR [iditemconfiguracao];

-- Object:  Default [DF__historico__idbas__49C4C20E]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicotentativa] ADD  DEFAULT (NULL) FOR [idbaseitemconfiguracao];

-- Object:  Default [DF__historico__ideve__4AB8E647]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicotentativa] ADD  DEFAULT (NULL) FOR [idevento];

-- Object:  Default [DF__historico__idemp__4BAD0A80]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicotentativa] ADD  DEFAULT (NULL) FOR [idempregado];

-- Object:  Default [DF__historico__descr__4CA12EB9]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicotentativa] ADD  DEFAULT (NULL) FOR [descricao];

-- Object:  Default [DF__historicot__data__4D9552F2]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicotentativa] ADD  DEFAULT (NULL) FOR [data];

-- Object:  Default [DF__historicot__hora__4E89772B]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicotentativa] ADD  DEFAULT (NULL) FOR [hora];

-- Object:  Default [DF__historico__idite__59FB29D7]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicovalor] ADD  DEFAULT (NULL) FOR [iditemconfiguracao];

-- Object:  Default [DF__historico__idcar__5AEF4E10]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicovalor] ADD  DEFAULT (NULL) FOR [idcaracteristica];

-- Object:  Default [DF__historico__valor__5BE37249]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicovalor] ADD  DEFAULT (NULL) FOR [valorstr];

-- Object:  Default [DF__historico__valor__5CD79682]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicovalor] ADD  DEFAULT (NULL) FOR [valordecimal];

-- Object:  Default [DF__historico__valor__5DCBBABB]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicovalor] ADD  DEFAULT (NULL) FOR [valordate];

-- Object:  Default [DF__historico__idbas__5EBFDEF4]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicovalor] ADD  DEFAULT (NULL) FOR [idbaseitemconfiguracao];

-- Object:  Default [DF__historico__datah__5FB4032D]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicovalor] ADD  DEFAULT (sysdatetime()) FOR [datahoraalteracao];

-- Object:  Default [DF__historico__basel__60A82766]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicovalor] ADD  DEFAULT (NULL) FOR [baseline];

-- Object:  Default [DF__historico__idHis__619C4B9F]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [historicovalor] ADD  DEFAULT (NULL) FOR [idHistoricoIC];

-- Object:  Default [DF__imagemhis__idpro__6B25B5D9]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [imagemhistorico] ADD  DEFAULT (NULL) FOR [idprofissional];

-- Object:  Default [DF__imagemhis__idemp__6C19DA12]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [imagemhistorico] ADD  DEFAULT (NULL) FOR [idempresa];

-- Object:  Default [DF__imagemhisto__aba__6D0DFE4B]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [imagemhistorico] ADD  DEFAULT (NULL) FOR [aba];

-- Object:  Default [DF__imagemite__idser__71D2B368]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [imagemitemconfiguracao] ADD  DEFAULT (NULL) FOR [idservico];

-- Object:  Default [DF__imagemite__idite__72C6D7A1]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [imagemitemconfiguracao] ADD  DEFAULT (NULL) FOR [iditemconfiguracao];

-- Object:  Default [DF__imagemitem__posx__73BAFBDA]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [imagemitemconfiguracao] ADD  DEFAULT (NULL) FOR [posx];

-- Object:  Default [DF__imagemitem__posy__74AF2013]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [imagemitemconfiguracao] ADD  DEFAULT (NULL) FOR [posy];

-- Object:  Default [DF__imagemite__descr__75A3444C]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [imagemitemconfiguracao] ADD  DEFAULT (NULL) FOR [descricao];

-- Object:  Default [DF__imagemite__camin__76976885]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [imagemitemconfiguracao] ADD  DEFAULT (NULL) FOR [caminhoimagem];

-- Object:  Default [DF__imagemite__idima__778B8CBE]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [imagemitemconfiguracao] ADD  DEFAULT (NULL) FOR [idimagemitemconfiguracaopai];

-- Object:  Default [DF__imagemser__idser__7C5041DB]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [imagemservicorelacionado] ADD  DEFAULT (NULL) FOR [idservico];

-- Object:  Default [DF__imagemser__idser__7D446614]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [imagemservicorelacionado] ADD  DEFAULT (NULL) FOR [idservicorelacionado];

-- Object:  Default [DF__imagemserv__posx__7E388A4D]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [imagemservicorelacionado] ADD  DEFAULT (NULL) FOR [posx];

-- Object:  Default [DF__imagemserv__posy__7F2CAE86]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [imagemservicorelacionado] ADD  DEFAULT (NULL) FOR [posy];

-- Object:  Default [DF__imagemser__descr__0020D2BF]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [imagemservicorelacionado] ADD  DEFAULT (NULL) FOR [descricao];

-- Object:  Default [DF__imagemser__camin__0114F6F8]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [imagemservicorelacionado] ADD  DEFAULT (NULL) FOR [caminhoimagem];

-- Object:  Default [DF__imagemser__idima__02091B31]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [imagemservicorelacionado] ADD  DEFAULT (NULL) FOR [idimagemservicorelacionadopai];

-- Object:  Default [DF__impacto__siglaIm__06CDD04E]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [impacto] ADD  DEFAULT (NULL) FOR [siglaImpacto];

-- Object:  Default [DF__importcon__idext__17043817]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [importconfig] ADD  DEFAULT (NULL) FOR [idexternalconnection];

-- Object:  Default [DF__importcon__tabel__17F85C50]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [importconfig] ADD  DEFAULT (NULL) FOR [tabelaorigem];

-- Object:  Default [DF__importcon__tabel__18EC8089]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [importconfig] ADD  DEFAULT (NULL) FOR [tabeladestino];

-- Object:  Default [DF__importconf__nome__19E0A4C2]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [importconfig] ADD  DEFAULT (NULL) FOR [nome];

-- Object:  Default [DF__importcon__orige__1F997E18]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [importconfigcampos] ADD  DEFAULT (NULL) FOR [origem];

-- Object:  Default [DF__importcon__desti__208DA251]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [importconfigcampos] ADD  DEFAULT (NULL) FOR [destino];

-- Object:  Default [DF__infocatal__idcat__26467BA7]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [infocatalogoservico] ADD  DEFAULT (NULL) FOR [idcatalogoservico];

-- Object:  Default [DF__infocatal__nomei__273A9FE0]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [infocatalogoservico] ADD  DEFAULT (NULL) FOR [nomeinfocatalogoservico];

-- Object:  Default [DF__informaca__usuar__2BFF54FD]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [informacaoservico] ADD  DEFAULT (NULL) FOR [usuario];

-- Object:  Default [DF__informaca__titul__2CF37936]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [informacaoservico] ADD  DEFAULT (NULL) FOR [titulo];

-- Object:  Default [DF__informaca__texto__2DE79D6F]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [informacaoservico] ADD  DEFAULT (NULL) FOR [texto];

-- Object:  Default [DF__informaca__situa__2EDBC1A8]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [informacaoservico] ADD  DEFAULT (NULL) FOR [situacao];

-- Object:  Default [DF__informaca__delet__2FCFE5E1]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [informacaoservico] ADD  DEFAULT (NULL) FOR [deleted];

-- Object:  Default [DF__informaco__idinf__34949AFE]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [informacoescontratoconfig] ADD  DEFAULT (NULL) FOR [idinformacoescontratoconfigpai];

-- Object:  Default [DF__informaco__funci__3588BF37]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [informacoescontratoconfig] ADD  DEFAULT (NULL) FOR [funcionalidadepath];

-- Object:  Default [DF__informaco__idque__367CE370]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [informacoescontratoconfig] ADD  DEFAULT (NULL) FOR [idquestionario];

-- Object:  Default [DF__informaco__ordem__377107A9]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [informacoescontratoconfig] ADD  DEFAULT (NULL) FOR [ordem];

-- Object:  Default [DF__informaco__funca__38652BE2]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [informacoescontratoconfig] ADD  DEFAULT (NULL) FOR [funcadicionalaposgravacao];

-- Object:  Default [DF__informaco__chama__3959501B]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [informacoescontratoconfig] ADD  DEFAULT (NULL) FOR [chamarfuncaddaposgravar];

-- Object:  Default [DF__informaco__chama__3A4D7454]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [informacoescontratoconfig] ADD  DEFAULT (NULL) FOR [chamarfuncaddhistorico];

-- Object:  Default [DF__informaco__icone__3B41988D]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [informacoescontratoconfig] ADD  DEFAULT (NULL) FOR [iconefunchistorico];

-- Object:  Default [DF__informaco__icone__3C35BCC6]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [informacoescontratoconfig] ADD  DEFAULT (NULL) FOR [iconefunchistoricofinal];

-- Object:  Default [DF__informaco__segur__3D29E0FF]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [informacoescontratoconfig] ADD  DEFAULT (NULL) FOR [segurancaunidade];

-- Object:  Default [DF__informaco__segur__3E1E0538]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [informacoescontratoconfig] ADD  DEFAULT (NULL) FOR [segurancaunidadepcmso];

-- Object:  Default [DF__informaco__segur__3F122971]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [informacoescontratoconfig] ADD  DEFAULT (NULL) FOR [segurancaunidadeenferm];

-- Object:  Default [DF__inspecaoe__idres__498FB7E4]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [inspecaoentregaitem] ADD  DEFAULT (NULL) FOR [idresponsavel];

-- Object:  Default [DF__inspecaoe__datah__4A83DC1D]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [inspecaoentregaitem] ADD  DEFAULT (sysdatetime()) FOR [datahorainspecao];

-- Object:  Default [DF__inspecaoe__avali__4B780056]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [inspecaoentregaitem] ADD  DEFAULT (NULL) FOR [avaliacao];

-- Object:  Default [DF__inspecaop__datah__5319221E]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [inspecaopedidocompra] ADD  DEFAULT (sysdatetime()) FOR [datahorainspecao];

-- Object:  Default [DF__inspecaop__avali__540D4657]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [inspecaopedidocompra] ADD  DEFAULT (NULL) FOR [avaliacao];

-- Object:  Default [DF__inventari__idnet__5BAE681F]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [inventarioxml] ADD  DEFAULT (NULL) FOR [idnetmap];

-- Object:  Default [DF__inventari__datai__5CA28C58]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [inventarioxml] ADD  DEFAULT (NULL) FOR [datainicial];

-- Object:  Default [DF__inventari__dataf__5D96B091]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [inventarioxml] ADD  DEFAULT (NULL) FOR [datafinal];

-- Object:  Default [DF__inventario__nome__5E8AD4CA]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [inventarioxml] ADD  DEFAULT (NULL) FOR [nome];

-- Object:  Default [DF__itemcfgso__idite__60731D3C]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemcfgsolicitacaoserv] ADD  DEFAULT (NULL) FOR [iditemconfiguracao];

-- Object:  Default [DF__itemcfgso__idsol__61674175]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemcfgsolicitacaoserv] ADD  DEFAULT (NULL) FOR [idsolicitacaoservico];

-- Object:  Default [DF__itemcfgso__datai__625B65AE]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemcfgsolicitacaoserv] ADD  DEFAULT (NULL) FOR [datainicio];

-- Object:  Default [DF__itemcfgso__dataf__634F89E7]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemcfgsolicitacaoserv] ADD  DEFAULT (NULL) FOR [datafim];

-- Object:  Default [DF__itemconfi__idite__5AA469F6]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemconfiguracao] ADD  DEFAULT (NULL) FOR [iditemconfiguracaopai];

-- Object:  Default [DF__itemconfi__idtip__5B988E2F]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemconfiguracao] ADD  DEFAULT (NULL) FOR [idtipoitemconfiguracao];

-- Object:  Default [DF__itemconfi__dataf__5C8CB268]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemconfiguracao] ADD  DEFAULT (NULL) FOR [datafim];

-- Object:  Default [DF__itemconfi__idgru__5D80D6A1]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemconfiguracao] ADD  DEFAULT (NULL) FOR [idgrupoitemconfiguracao];

-- Object:  Default [DF__itemconfi__idpro__5E74FADA]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemconfiguracao] ADD  DEFAULT (NULL) FOR [idproprietario];

-- Object:  Default [DF__itemconfi__datae__5F691F13]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemconfiguracao] ADD  DEFAULT (NULL) FOR [dataexpiracao];

-- Object:  Default [DF__itemconfi__versa__605D434C]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemconfiguracao] ADD  DEFAULT (NULL) FOR [versao];

-- Object:  Default [DF__itemconfi__famil__61516785]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemconfiguracao] ADD  DEFAULT (NULL) FOR [familia];

-- Object:  Default [DF__itemconfi__class__62458BBE]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemconfiguracao] ADD  DEFAULT (NULL) FOR [classe];

-- Object:  Default [DF__itemconfi__local__6339AFF7]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemconfiguracao] ADD  DEFAULT (NULL) FOR [localidade];

-- Object:  Default [DF__itemconfi__statu__642DD430]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemconfiguracao] ADD  DEFAULT (NULL) FOR [status];

-- Object:  Default [DF__itemconfi__criti__6521F869]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemconfiguracao] ADD  DEFAULT (NULL) FOR [criticidade];

-- Object:  Default [DF__itemconfi__numer__66161CA2]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemconfiguracao] ADD  DEFAULT (NULL) FOR [numeroSerie];

-- Object:  Default [DF__itemconfi__idMud__670A40DB]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemconfiguracao] ADD  DEFAULT (NULL) FOR [idMudanca];

-- Object:  Default [DF__itemconfi__idPro__67FE6514]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemconfiguracao] ADD  DEFAULT (NULL) FOR [idProblema];

-- Object:  Default [DF__itemconfi__IdInc__68F2894D]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemconfiguracao] ADD  DEFAULT (NULL) FOR [IdIncidente];

-- Object:  Default [DF__itemconfi__idMid__69E6AD86]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemconfiguracao] ADD  DEFAULT (NULL) FOR [idMidiaSoftware];

-- Object:  Default [DF__itemconfi__impac__6ADAD1BF]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemconfiguracao] ADD  DEFAULT (NULL) FOR [impacto];

-- Object:  Default [DF__itemconfi__urgen__6BCEF5F8]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemconfiguracao] ADD  DEFAULT (NULL) FOR [urgencia];

-- Object:  Default [DF__itemconfi__idbas__6CC31A31]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemconfiguracao] ADD  DEFAULT (NULL) FOR [idbaseconhecimento];

-- Object:  Default [DF__itemconfi__idbas__69FC8776]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemconfiguracaoevento] ADD  DEFAULT (NULL) FOR [idbaseitemconfiguracao];

-- Object:  Default [DF__itemconfi__idite__6AF0ABAF]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemconfiguracaoevento] ADD  DEFAULT (NULL) FOR [iditemconfiguracao];

-- Object:  Default [DF__itemconfi__tipoe__6BE4CFE8]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemconfiguracaoevento] ADD  DEFAULT (NULL) FOR [tipoexecucao];

-- Object:  Default [DF__itemconfig__hora__6CD8F421]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemconfiguracaoevento] ADD  DEFAULT (NULL) FOR [hora];

-- Object:  Default [DF__itemconfi__linha__6DCD185A]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemconfiguracaoevento] ADD  DEFAULT (NULL) FOR [linhacomando];

-- Object:  Default [DF__itemconfi__linha__6EC13C93]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemconfiguracaoevento] ADD  DEFAULT (NULL) FOR [linhacomandolinux];

-- Object:  Default [DF__itemcotac__idcot__2E06CDA9]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemcotacao] ADD  DEFAULT (NULL) FOR [idcotacao];

-- Object:  Default [DF__itemcotac__idpro__2EFAF1E2]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemcotacao] ADD  DEFAULT (NULL) FOR [idproduto];

-- Object:  Default [DF__itemcotac__quant__2FEF161B]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemcotacao] ADD  DEFAULT (NULL) FOR [quantidade];

-- Object:  Default [DF__itemcotac__situa__30E33A54]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemcotacao] ADD  DEFAULT (NULL) FOR [situacao];

-- Object:  Default [DF__itemcotac__idcat__31D75E8D]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemcotacao] ADD  DEFAULT (NULL) FOR [idcategoriaproduto];

-- Object:  Default [DF__itemcotac__iduni__32CB82C6]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemcotacao] ADD  DEFAULT (NULL) FOR [idunidademedida];

-- Object:  Default [DF__itemcotac__marca__33BFA6FF]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemcotacao] ADD  DEFAULT (NULL) FOR [marcapreferencial];

-- Object:  Default [DF__itemcotac__preco__34B3CB38]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemcotacao] ADD  DEFAULT (NULL) FOR [precoaproximado];

-- Object:  Default [DF__itemcotac__resul__35A7EF71]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemcotacao] ADD  DEFAULT (NULL) FOR [resultadovalidacao];

-- Object:  Default [DF__itemcotac__pesop__369C13AA]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemcotacao] ADD  DEFAULT (NULL) FOR [pesopreco];

-- Object:  Default [DF__itemcotac__pesop__379037E3]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemcotacao] ADD  DEFAULT (NULL) FOR [pesoprazoentrega];

-- Object:  Default [DF__itemcotac__pesop__38845C1C]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemcotacao] ADD  DEFAULT (NULL) FOR [pesoprazopagto];

-- Object:  Default [DF__itemcotac__pesot__39788055]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemcotacao] ADD  DEFAULT (NULL) FOR [pesotaxajuros];

-- Object:  Default [DF__itemcotac__pesop__3A6CA48E]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemcotacao] ADD  DEFAULT (NULL) FOR [pesoprazogarantia];

-- Object:  Default [DF__itemcotac__exige__3B60C8C7]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemcotacao] ADD  DEFAULT (NULL) FOR [exigefornecedorqualificado];

-- Object:  Default [DF__itempedid__idcol__7385F1B0]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itempedidocompra] ADD  DEFAULT (NULL) FOR [idcoletapreco];

-- Object:  Default [DF__itempedid__valor__747A15E9]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itempedidocompra] ADD  DEFAULT (NULL) FOR [valordesconto];

-- Object:  Default [DF__itempedid__valor__756E3A22]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itempedidocompra] ADD  DEFAULT (NULL) FOR [valoracrescimo];

-- Object:  Default [DF__itempedid__basec__76625E5B]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itempedidocompra] ADD  DEFAULT (NULL) FOR [basecalculoicms];

-- Object:  Default [DF__itempedid__aliqu__77568294]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itempedidocompra] ADD  DEFAULT (NULL) FOR [aliquotaicms];

-- Object:  Default [DF__itempedid__aliqu__784AA6CD]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itempedidocompra] ADD  DEFAULT (NULL) FOR [aliquotaipi];

-- Object:  Default [DF__itemrequi__idpar__7C30464A]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemrequisicaoproduto] ADD  DEFAULT (NULL) FOR [idparecervalidacao];

-- Object:  Default [DF__itemrequi__idpar__7D246A83]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemrequisicaoproduto] ADD  DEFAULT (NULL) FOR [idparecerautorizacao];

-- Object:  Default [DF__itemrequi__idcat__7E188EBC]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemrequisicaoproduto] ADD  DEFAULT (NULL) FOR [idcategoriaproduto];

-- Object:  Default [DF__itemrequi__iduni__7F0CB2F5]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemrequisicaoproduto] ADD  DEFAULT (NULL) FOR [idunidademedida];

-- Object:  Default [DF__itemrequi__idpro__0000D72E]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemrequisicaoproduto] ADD  DEFAULT (NULL) FOR [idproduto];

-- Object:  Default [DF__itemrequi__idite__00F4FB67]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemrequisicaoproduto] ADD  DEFAULT (NULL) FOR [iditemcotacao];

-- Object:  Default [DF__itemrequi__marca__01E91FA0]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemrequisicaoproduto] ADD  DEFAULT (NULL) FOR [marcapreferencial];

-- Object:  Default [DF__itemrequi__preco__02DD43D9]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemrequisicaoproduto] ADD  DEFAULT (NULL) FOR [precoaproximado];

-- Object:  Default [DF__itemrequi__situa__03D16812]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemrequisicaoproduto] ADD  DEFAULT (NULL) FOR [situacao];

-- Object:  Default [DF__itemrequi__percv__04C58C4B]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemrequisicaoproduto] ADD  DEFAULT (NULL) FOR [percvariacaopreco];

-- Object:  Default [DF__itemrequi__qtdea__05B9B084]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemrequisicaoproduto] ADD  DEFAULT (NULL) FOR [qtdeaprovada];

-- Object:  Default [DF__itemrequi__aprov__06ADD4BD]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemrequisicaoproduto] ADD  DEFAULT (NULL) FOR [aprovacotacao];

-- Object:  Default [DF__itemrequi__qtdec__07A1F8F6]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemrequisicaoproduto] ADD  DEFAULT (NULL) FOR [qtdecotada];

-- Object:  Default [DF__itemrequi__valor__08961D2F]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [itemrequisicaoproduto] ADD  DEFAULT (NULL) FOR [valoraprovado];

-- Object:  Default [DF__jornadatr__inici__7FEBC895]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [jornadatrabalho] ADD  DEFAULT (NULL) FOR [inicio1];

-- Object:  Default [DF__jornadatr__termi__00DFECCE]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [jornadatrabalho] ADD  DEFAULT (NULL) FOR [termino1];

-- Object:  Default [DF__jornadatr__inici__01D41107]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [jornadatrabalho] ADD  DEFAULT (NULL) FOR [inicio2];

-- Object:  Default [DF__jornadatr__termi__02C83540]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [jornadatrabalho] ADD  DEFAULT (NULL) FOR [termino2];

-- Object:  Default [DF__jornadatr__inici__03BC5979]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [jornadatrabalho] ADD  DEFAULT (NULL) FOR [inicio3];

-- Object:  Default [DF__jornadatr__termi__04B07DB2]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [jornadatrabalho] ADD  DEFAULT (NULL) FOR [termino3];

-- Object:  Default [DF__jornadatr__inici__05A4A1EB]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [jornadatrabalho] ADD  DEFAULT (NULL) FOR [inicio4];

-- Object:  Default [DF__jornadatr__termi__0698C624]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [jornadatrabalho] ADD  DEFAULT (NULL) FOR [termino4];

-- Object:  Default [DF__jornadatr__inici__078CEA5D]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [jornadatrabalho] ADD  DEFAULT (NULL) FOR [inicio5];

-- Object:  Default [DF__jornadatr__termi__08810E96]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [jornadatrabalho] ADD  DEFAULT (NULL) FOR [termino5];

-- Object:  Default [DF__jornadatr__carga__097532CF]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [jornadatrabalho] ADD  DEFAULT (NULL) FOR [cargahoraria];

-- Object:  Default [DF__jornadatr__datai__0A695708]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [jornadatrabalho] ADD  DEFAULT (NULL) FOR [datainicio];

-- Object:  Default [DF__jornadatr__dataf__0B5D7B41]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [jornadatrabalho] ADD  DEFAULT (NULL) FOR [datafim];

-- Object:  Default [DF__justifica__idite__1022305E]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [justificacaofalha] ADD  DEFAULT (NULL) FOR [iditemconfiguracao];

-- Object:  Default [DF__justifica__idbas__11165497]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [justificacaofalha] ADD  DEFAULT (NULL) FOR [idbaseitemconfiguracao];

-- Object:  Default [DF__justifica__ideve__120A78D0]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [justificacaofalha] ADD  DEFAULT (NULL) FOR [idevento];

-- Object:  Default [DF__justifica__idemp__12FE9D09]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [justificacaofalha] ADD  DEFAULT (NULL) FOR [idempregado];

-- Object:  Default [DF__justifica__idhis__13F2C142]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [justificacaofalha] ADD  DEFAULT (NULL) FOR [idhistoricotentativa];

-- Object:  Default [DF__justificac__data__14E6E57B]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [justificacaofalha] ADD  DEFAULT (NULL) FOR [data];

-- Object:  Default [DF__justificac__hora__15DB09B4]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [justificacaofalha] ADD  DEFAULT (NULL) FOR [hora];

-- Object:  Default [DF__justifica__aprov__025E20EC]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [justificativaliberacao] ADD  DEFAULT (NULL) FOR [aprovacao];

-- Object:  Default [DF__justifica__delet__03524525]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [justificativaliberacao] ADD  DEFAULT (NULL) FOR [deleted];

-- Object:  Default [DF__justifica__aprov__534E2C48]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [justificativamudanca] ADD  DEFAULT (NULL) FOR [aprovacao];

-- Object:  Default [DF__justifica__delet__54425081]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [justificativamudanca] ADD  DEFAULT (NULL) FOR [deleted];

-- Object:  Default [DF__justifica__situa__29820FAE]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [justificativaparecer] ADD  DEFAULT (NULL) FOR [situacao];

-- Object:  Default [DF__justifica__aplic__2A7633E7]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [justificativaparecer] ADD  DEFAULT (NULL) FOR [aplicavelrequisicao];

-- Object:  Default [DF__justifica__aplic__2B6A5820]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [justificativaparecer] ADD  DEFAULT (NULL) FOR [aplicavelcotacao];

-- Object:  Default [DF__justifica__aplic__2C5E7C59]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [justificativaparecer] ADD  DEFAULT (NULL) FOR [aplicavelinspecao];

-- Object:  Default [DF__justifica__aprov__62265B84]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [justificativaproblema] ADD  DEFAULT (NULL) FOR [aprovacao];

-- Object:  Default [DF__justifica__delet__631A7FBD]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [justificativaproblema] ADD  DEFAULT (NULL) FOR [deleted];

-- Object:  Default [DF__justifica__delet__2A563856]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [justificativasolicitacao] ADD  DEFAULT (NULL) FOR [deleted];

-- Object:  Default [DF__justifica__aprov__2B4A5C8F]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [justificativasolicitacao] ADD  DEFAULT (NULL) FOR [aprovacao];

-- Object:  Default [DF__liberacao__idres__7D4E87B5]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [liberacao] ADD  DEFAULT (NULL) FOR [idresponsavel];

-- Object:  Default [DF__liberacao__datal__7E42ABEE]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [liberacao] ADD  DEFAULT (NULL) FOR [dataliberacao];

-- Object:  Default [DF__liberacao__versa__7F36D027]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [liberacao] ADD  DEFAULT (NULL) FOR [versao];

-- Object:  Default [DF__liberacao__envia__0446695E]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [liberacao] ADD  DEFAULT (NULL) FOR [enviaemailcriacao];

-- Object:  Default [DF__liberacao__envia__053A8D97]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [liberacao] ADD  DEFAULT (NULL) FOR [enviaemailacoes];

-- Object:  Default [DF__liberacao__datah__062EB1D0]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [liberacao] ADD  DEFAULT ('1970-01-01 00:00:00') FOR [datahoratermino];

-- Object:  Default [DF__liberacao__datah__0722D609]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [liberacao] ADD  DEFAULT ('1970-01-01 00:00:00') FOR [datahoraconclusao];

-- Object:  Default [DF__liberacao__statu__0816FA42]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [liberacao] ADD  DEFAULT (NULL) FOR [status];

-- Object:  Default [DF__liberacao__datah__090B1E7B]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [liberacao] ADD  DEFAULT ('1970-01-01 00:00:00') FOR [datahoracaptura];

-- Object:  Default [DF__liberacao__datah__09FF42B4]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [liberacao] ADD  DEFAULT ('1970-01-01 00:00:00') FOR [datahorareativacao];

-- Object:  Default [DF__liberacao__datah__0AF366ED]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [liberacao] ADD  DEFAULT ('1970-01-01 00:00:00') FOR [datahorainicio];

-- Object:  Default [DF__liberacao__datah__0BE78B26]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [liberacao] ADD  DEFAULT ('1970-01-01 00:00:00') FOR [datahorasuspensao];

-- Object:  Default [DF__liberacao__envia__0CDBAF5F]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [liberacao] ADD  DEFAULT (NULL) FOR [enviaemailfinalizacao];

-- Object:  Default [DF__liberacao__datah__0DCFD398]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [liberacao] ADD  DEFAULT ('1970-01-01 00:00:00') FOR [datahorainicioagendada];

-- Object:  Default [DF__liberacao__datah__0EC3F7D1]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [liberacao] ADD  DEFAULT ('1970-01-01 00:00:00') FOR [datahoraterminoagendada];

-- Object:  Default [DF__liberacao__prior__0FB81C0A]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [liberacao] ADD  DEFAULT (NULL) FOR [prioridade];

-- Object:  Default [DF__liberacao__nivel__10AC4043]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [liberacao] ADD  DEFAULT (NULL) FOR [nivelurgencia];

-- Object:  Default [DF__liberacao__nivel__11A0647C]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [liberacao] ADD  DEFAULT (NULL) FOR [nivelimpacto];

-- Object:  Default [DF__liberacao__idapr__129488B5]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [liberacao] ADD  DEFAULT (NULL) FOR [idaprovador];

-- Object:  Default [DF__liberacao__datah__1388ACEE]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [liberacao] ADD  DEFAULT ('1970-01-01 00:00:00') FOR [datahoraaprovacao];

-- Object:  Default [DF__liberacao__idhis__1F2F69C4]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [liberacaoproblema] ADD  DEFAULT (NULL) FOR [idhistoricoliberacao];

-- Object:  Default [DF__limitealc__tipol__6C43F744]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [limitealcada] ADD  DEFAULT (NULL) FOR [tipolimite];

-- Object:  Default [DF__limitealc__limit__6D381B7D]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [limitealcada] ADD  DEFAULT (NULL) FOR [limiteitemusointerno];

-- Object:  Default [DF__limitealc__limit__6E2C3FB6]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [limitealcada] ADD  DEFAULT (NULL) FOR [limitevalormensal];

-- Object:  Default [DF__lingua__nome__1A0AC1F4]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [lingua] ADD  DEFAULT (NULL) FOR [nome];

-- Object:  Default [DF__lingua__sigla__1AFEE62D]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [lingua] ADD  DEFAULT (NULL) FOR [sigla];

-- Object:  Default [DF__lingua__datainic__1BF30A66]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [lingua] ADD  DEFAULT (NULL) FOR [datainicio];

-- Object:  Default [DF__lingua__datafim__1CE72E9F]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [lingua] ADD  DEFAULT (NULL) FOR [datafim];

-- Object:  Default [DF__localexec__delet__257C74A0]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [localexecucaoservico] ADD  DEFAULT (NULL) FOR [deleted];

-- Object:  Default [DF__localidad__nomel__5AAF56EE]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [localidade] ADD  DEFAULT (NULL) FOR [nomelocalidade];

-- Object:  Default [DF__localidad__datai__5BA37B27]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [localidade] ADD  DEFAULT (NULL) FOR [datainicio];

-- Object:  Default [DF__localidad__dataf__5C979F60]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [localidade] ADD  DEFAULT (NULL) FOR [datafim];

-- Object:  Default [DF__localidad__datai__615C547D]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [localidadeunidade] ADD  DEFAULT (NULL) FOR [datainicio];

-- Object:  Default [DF__localidad__dataf__625078B6]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [localidadeunidade] ADD  DEFAULT (NULL) FOR [datafim];

-- Object:  Default [DF__logdados__dtatua__37311087]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [logdados] ADD  DEFAULT (NULL) FOR [dtatualizacao];

-- Object:  Default [DF__logdados__operac__382534C0]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [logdados] ADD  DEFAULT (NULL) FOR [operacao];

-- Object:  Default [DF__logdados__idusua__391958F9]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [logdados] ADD  DEFAULT (NULL) FOR [idusuario];

-- Object:  Default [DF__logdados__localo__3A0D7D32]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [logdados] ADD  DEFAULT (NULL) FOR [localorigem];

-- Object:  Default [DF__logdados__nometa__3B01A16B]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [logdados] ADD  DEFAULT (NULL) FOR [nometabela];

-- Object:  Default [DF__logdados__logdad__3BF5C5A4]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [logdados] ADD  DEFAULT (NULL) FOR [logdadoscol];

-- Object:  Default [DF__logdados__datalo__3CE9E9DD]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [logdados] ADD  DEFAULT (getdate()) FOR [datalog];

-- Object:  Default [DF__marca__idfabrica__168F36CB]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [marca] ADD  DEFAULT (NULL) FOR [idfabricante];

-- Object:  Default [DF__matrizpri__idcon__1920BF5C]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [matrizprioridade] ADD  DEFAULT (NULL) FOR [idcontrato];

-- Object:  Default [DF__matrizpri__delet__1A14E395]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [matrizprioridade] ADD  DEFAULT (NULL) FOR [deleted];

-- Object:  Default [DF__matrizvis__idvis__1209AD79]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [matrizvisao] ADD  DEFAULT (NULL) FOR [idvisao];

-- Object:  Default [DF__matrizvis__idobj__12FDD1B2]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [matrizvisao] ADD  DEFAULT (NULL) FOR [idobjetonegocio];

-- Object:  Default [DF__matrizvis__idcam__13F1F5EB]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [matrizvisao] ADD  DEFAULT (NULL) FOR [idcamposobjetonegocio1];

-- Object:  Default [DF__matrizvis__idcam__14E61A24]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [matrizvisao] ADD  DEFAULT (NULL) FOR [idcamposobjetonegocio2];

-- Object:  Default [DF__matrizvis__idcam__15DA3E5D]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [matrizvisao] ADD  DEFAULT (NULL) FOR [idcamposobjetonegocio3];

-- Object:  Default [DF__matrizvis__nomec__16CE6296]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [matrizvisao] ADD  DEFAULT (NULL) FOR [nomecampo1];

-- Object:  Default [DF__matrizvis__nomec__17C286CF]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [matrizvisao] ADD  DEFAULT (NULL) FOR [nomecampo2];

-- Object:  Default [DF__matrizvis__nomec__18B6AB08]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [matrizvisao] ADD  DEFAULT (NULL) FOR [nomecampo3];

-- Object:  Default [DF__matrizvis__descr__19AACF41]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [matrizvisao] ADD  DEFAULT (NULL) FOR [descricaocampo1];

-- Object:  Default [DF__matrizvis__descr__1A9EF37A]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [matrizvisao] ADD  DEFAULT (NULL) FOR [descricaocampo2];

-- Object:  Default [DF__matrizvis__descr__1B9317B3]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [matrizvisao] ADD  DEFAULT (NULL) FOR [descricaocampo3];

-- Object:  Default [DF__menu__idmenupai__00750D23]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [menu] ADD  DEFAULT (NULL) FOR [idmenupai];

-- Object:  Default [DF__menu__datafim__0169315C]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [menu] ADD  DEFAULT (NULL) FOR [datafim];

-- Object:  Default [DF__menu__descricao__025D5595]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [menu] ADD  DEFAULT (NULL) FOR [descricao];

-- Object:  Default [DF__menu__ordem__035179CE]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [menu] ADD  DEFAULT (NULL) FOR [ordem];

-- Object:  Default [DF__menu__link__04459E07]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [menu] ADD  DEFAULT (NULL) FOR [link];

-- Object:  Default [DF__menu__imagem__0539C240]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [menu] ADD  DEFAULT (NULL) FOR [imagem];

-- Object:  Default [DF__menu__horizontal__062DE679]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [menu] ADD  DEFAULT (NULL) FOR [horizontal];

-- Object:  Default [DF__menu__menurapido__07220AB2]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [menu] ADD  DEFAULT (NULL) FOR [menurapido];

-- Object:  Default [DF__midia__nome__24B26D99]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [midia] ADD  DEFAULT (NULL) FOR [nome];

-- Object:  Default [DF__midia__midiacol__25A691D2]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [midia] ADD  DEFAULT (NULL) FOR [midiacol];

-- Object:  Default [DF__midiasoft__endfi__2A6B46EF]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [midiasoftware] ADD  DEFAULT (NULL) FOR [endfisico];

-- Object:  Default [DF__midiasoft__versa__2B5F6B28]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [midiasoftware] ADD  DEFAULT (NULL) FOR [versao];

-- Object:  Default [DF__midiasoft__endlo__2C538F61]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [midiasoftware] ADD  DEFAULT (NULL) FOR [endlogico];

-- Object:  Default [DF__midiasoft__licen__2D47B39A]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [midiasoftware] ADD  DEFAULT (NULL) FOR [licencas];

-- Object:  Default [DF__midiasoft__idmid__2E3BD7D3]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [midiasoftware] ADD  DEFAULT (NULL) FOR [idmidia];

-- Object:  Default [DF__midiasoft__idtip__2F2FFC0C]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [midiasoftware] ADD  DEFAULT (NULL) FOR [idtiposoftware];

-- Object:  Default [DF__midiasoft__datai__30242045]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [midiasoftware] ADD  DEFAULT (NULL) FOR [datainicio];

-- Object:  Default [DF__midiasoft__dataf__3118447E]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [midiasoftware] ADD  DEFAULT (NULL) FOR [datafim];

-- Object:  Default [DF__modelosem__ident__35DCF99B]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [modelosemails] ADD  DEFAULT (NULL) FOR [identificador];

-- Object:  Default [DF__nagioscon__nomej__59E54FE7]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [nagiosconexao] ADD  DEFAULT (NULL) FOR [nomejndi];

-- Object:  Default [DF__nagioscon__criad__5AD97420]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [nagiosconexao] ADD  DEFAULT (NULL) FOR [criadopor];

-- Object:  Default [DF__nagioscon__modif__5BCD9859]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [nagiosconexao] ADD  DEFAULT (NULL) FOR [modificadopor];

-- Object:  Default [DF__nagioscon__datac__5CC1BC92]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [nagiosconexao] ADD  DEFAULT (NULL) FOR [datacriacao];

-- Object:  Default [DF__nagioscon__ultmo__5DB5E0CB]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [nagiosconexao] ADD  DEFAULT (NULL) FOR [ultmodificacao];

-- Object:  Default [DF__nagioscon__delet__5EAA0504]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [nagiosconexao] ADD  DEFAULT (NULL) FOR [deleted];

-- Object:  Default [DF__netmap__ip__636EBA21]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [netmap] ADD  DEFAULT (NULL) FOR [ip];

-- Object:  Default [DF__netmap__mask__6462DE5A]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [netmap] ADD  DEFAULT (NULL) FOR [mask];

-- Object:  Default [DF__netmap__mac__65570293]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [netmap] ADD  DEFAULT (NULL) FOR [mac];

-- Object:  Default [DF__netmap__date__664B26CC]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [netmap] ADD  DEFAULT (NULL) FOR [date_];

-- Object:  Default [DF__netmap__nome__673F4B05]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [netmap] ADD  DEFAULT (NULL) FOR [nome];

-- Object:  Default [DF__notificac__titul__6C040022]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [notificacao] ADD  DEFAULT (NULL) FOR [titulo];

-- Object:  Default [DF__notificac__tipon__6CF8245B]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [notificacao] ADD  DEFAULT (NULL) FOR [tiponotificacao];

-- Object:  Default [DF__notificac__datai__6DEC4894]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [notificacao] ADD  DEFAULT (NULL) FOR [datainicio];

-- Object:  Default [DF__notificac__dataf__6EE06CCD]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [notificacao] ADD  DEFAULT (NULL) FOR [datafim];

-- Object:  Default [DF__notificac__idCon__6FD49106]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [notificacao] ADD  DEFAULT (NULL) FOR [idContrato];

-- Object:  Default [DF__notificac__idnot__42CCE065]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [notificacaogrupo] ADD  DEFAULT (NULL) FOR [idnotificacao];

-- Object:  Default [DF__notificac__idgru__43C1049E]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [notificacaogrupo] ADD  DEFAULT (NULL) FOR [idgrupo];

-- Object:  Default [DF__notificac__idNot__02E7657A]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [notificacaoservico] ADD  DEFAULT (NULL) FOR [idNotificacao];

-- Object:  Default [DF__notificac__idSer__03DB89B3]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [notificacaoservico] ADD  DEFAULT (NULL) FOR [idServico];

-- Object:  Default [DF__notificac__idnot__05C3D225]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [notificacaousuario] ADD  DEFAULT (NULL) FOR [idnotificacao];

-- Object:  Default [DF__notificac__idusu__06B7F65E]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [notificacaousuario] ADD  DEFAULT (NULL) FOR [idusuario];

-- Object:  Default [DF__objetivom__fator__719CDDE7]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [objetivomonitoramento] ADD  DEFAULT (NULL) FOR [fatorcriticosucesso];

-- Object:  Default [DF__objetivomon__kpi__72910220]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [objetivomonitoramento] ADD  DEFAULT (NULL) FOR [kpi];

-- Object:  Default [DF__objetivom__respo__73852659]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [objetivomonitoramento] ADD  DEFAULT (NULL) FOR [responsavel];

-- Object:  Default [DF__objetivom__criad__74794A92]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [objetivomonitoramento] ADD  DEFAULT (NULL) FOR [criadopor];

-- Object:  Default [DF__objetivom__modif__756D6ECB]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [objetivomonitoramento] ADD  DEFAULT (NULL) FOR [modificadopor];

-- Object:  Default [DF__objetivom__datac__76619304]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [objetivomonitoramento] ADD  DEFAULT (NULL) FOR [datacriacao];

-- Object:  Default [DF__objetivom__ultmo__7755B73D]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [objetivomonitoramento] ADD  DEFAULT (NULL) FOR [ultmodificacao];

-- Object:  Default [DF__objetivop__medic__48CFD27E]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [objetivoplanomelhoria] ADD  DEFAULT (NULL) FOR [medicao];

-- Object:  Default [DF__objetivop__respo__49C3F6B7]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [objetivoplanomelhoria] ADD  DEFAULT (NULL) FOR [responsavel];

-- Object:  Default [DF__objetivop__criad__4AB81AF0]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [objetivoplanomelhoria] ADD  DEFAULT (NULL) FOR [criadopor];

-- Object:  Default [DF__objetivop__modif__4BAC3F29]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [objetivoplanomelhoria] ADD  DEFAULT (NULL) FOR [modificadopor];

-- Object:  Default [DF__objetivop__datac__4CA06362]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [objetivoplanomelhoria] ADD  DEFAULT (NULL) FOR [datacriacao];

-- Object:  Default [DF__objetivop__ultmo__4D94879B]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [objetivoplanomelhoria] ADD  DEFAULT (NULL) FOR [ultmodificacao];

-- Object:  Default [DF__ocorrenci__horar__220BD66F]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [ocorrencialiberacao] ADD  DEFAULT (NULL) FOR [horaregistro];

-- Object:  Default [DF__ocorrenci__regis__22FFFAA8]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [ocorrencialiberacao] ADD  DEFAULT (NULL) FOR [registradopor];

-- Object:  Default [DF__ocorrenci__descr__23F41EE1]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [ocorrencialiberacao] ADD  DEFAULT (NULL) FOR [descricao];

-- Object:  Default [DF__ocorrenci__categ__24E8431A]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [ocorrencialiberacao] ADD  DEFAULT (NULL) FOR [categoria];

-- Object:  Default [DF__ocorrenci__orige__25DC6753]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [ocorrencialiberacao] ADD  DEFAULT (NULL) FOR [origem];

-- Object:  Default [DF__ocorrenci__idite__5BED93EA]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [ocorrenciamudanca] ADD  DEFAULT (NULL) FOR [iditemtrabalho];

-- Object:  Default [DF__ocorrenci__idjus__5CE1B823]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [ocorrenciamudanca] ADD  DEFAULT (NULL) FOR [idjustificativa];

-- Object:  Default [DF__ocorrenci__idreq__5DD5DC5C]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [ocorrenciamudanca] ADD  DEFAULT (NULL) FOR [idrequisicaomudanca];

-- Object:  Default [DF__ocorrenci__datar__5ECA0095]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [ocorrenciamudanca] ADD  DEFAULT (NULL) FOR [dataregistro];

-- Object:  Default [DF__ocorrenci__horar__5FBE24CE]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [ocorrenciamudanca] ADD  DEFAULT (NULL) FOR [horaregistro];

-- Object:  Default [DF__ocorrenci__regis__60B24907]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [ocorrenciamudanca] ADD  DEFAULT (NULL) FOR [registradopor];

-- Object:  Default [DF__ocorrenci__descr__61A66D40]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [ocorrenciamudanca] ADD  DEFAULT (NULL) FOR [descricao];

-- Object:  Default [DF__ocorrenci__datai__629A9179]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [ocorrenciamudanca] ADD  DEFAULT (NULL) FOR [datainicio];

-- Object:  Default [DF__ocorrenci__dataf__638EB5B2]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [ocorrenciamudanca] ADD  DEFAULT (NULL) FOR [datafim];

-- Object:  Default [DF__ocorrenci__categ__6482D9EB]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [ocorrenciamudanca] ADD  DEFAULT (NULL) FOR [categoria];

-- Object:  Default [DF__ocorrenci__orige__6576FE24]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [ocorrenciamudanca] ADD  DEFAULT (NULL) FOR [origem];

-- Object:  Default [DF__ocorrenci__tempo__666B225D]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [ocorrenciamudanca] ADD  DEFAULT (NULL) FOR [tempogasto];

-- Object:  Default [DF__ocorrenci__idcat__675F4696]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [ocorrenciamudanca] ADD  DEFAULT (NULL) FOR [idcategoriaocorrencia];

-- Object:  Default [DF__ocorrenci__idori__68536ACF]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [ocorrenciamudanca] ADD  DEFAULT (NULL) FOR [idorigemocorrencia];

-- Object:  Default [DF__ocorrenci__idite__495AADBA]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [ocorrenciaproblema] ADD  DEFAULT (NULL) FOR [iditemtrabalho];

-- Object:  Default [DF__ocorrenci__idjus__4A4ED1F3]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [ocorrenciaproblema] ADD  DEFAULT (NULL) FOR [idjustificativa];

-- Object:  Default [DF__ocorrenci__idpro__4B42F62C]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [ocorrenciaproblema] ADD  DEFAULT (NULL) FOR [idproblema];

-- Object:  Default [DF__ocorrenci__datar__4C371A65]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [ocorrenciaproblema] ADD  DEFAULT (NULL) FOR [dataregistro];

-- Object:  Default [DF__ocorrenci__horar__4D2B3E9E]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [ocorrenciaproblema] ADD  DEFAULT (NULL) FOR [horaregistro];

-- Object:  Default [DF__ocorrenci__regis__4E1F62D7]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [ocorrenciaproblema] ADD  DEFAULT (NULL) FOR [registradopor];

-- Object:  Default [DF__ocorrenci__descr__4F138710]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [ocorrenciaproblema] ADD  DEFAULT (NULL) FOR [descricao];

-- Object:  Default [DF__ocorrenci__datai__5007AB49]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [ocorrenciaproblema] ADD  DEFAULT (NULL) FOR [datainicio];

-- Object:  Default [DF__ocorrenci__dataf__50FBCF82]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [ocorrenciaproblema] ADD  DEFAULT (NULL) FOR [datafim];

-- Object:  Default [DF__ocorrenci__categ__51EFF3BB]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [ocorrenciaproblema] ADD  DEFAULT (NULL) FOR [categoria];

-- Object:  Default [DF__ocorrenci__orige__52E417F4]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [ocorrenciaproblema] ADD  DEFAULT (NULL) FOR [origem];

-- Object:  Default [DF__ocorrenci__tempo__53D83C2D]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [ocorrenciaproblema] ADD  DEFAULT (NULL) FOR [tempogasto];

-- Object:  Default [DF__ocorrenci__idcat__54CC6066]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [ocorrenciaproblema] ADD  DEFAULT (NULL) FOR [idcategoriaocorrencia];

-- Object:  Default [DF__ocorrenci__idori__55C0849F]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [ocorrenciaproblema] ADD  DEFAULT (NULL) FOR [idorigemocorrencia];

-- Object:  Default [DF__ocorrenci__idemp__697C9932]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [ocorrencias] ADD  DEFAULT (NULL) FOR [idempregado];

-- Object:  Default [DF__ocorrenci__idjus__34D3C6C9]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [ocorrenciasolicitacao] ADD  DEFAULT (NULL) FOR [idjustificativa];

-- Object:  Default [DF__ocorrenci__idsol__35C7EB02]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [ocorrenciasolicitacao] ADD  DEFAULT (NULL) FOR [idsolicitacaoservico];

-- Object:  Default [DF__ocorrenci__idite__36BC0F3B]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [ocorrenciasolicitacao] ADD  DEFAULT (NULL) FOR [iditemtrabalho];

-- Object:  Default [DF__ocorrenci__datar__37B03374]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [ocorrenciasolicitacao] ADD  DEFAULT (NULL) FOR [dataregistro];

-- Object:  Default [DF__ocorrenci__horar__38A457AD]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [ocorrenciasolicitacao] ADD  DEFAULT (NULL) FOR [horaregistro];

-- Object:  Default [DF__ocorrenci__regis__39987BE6]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [ocorrenciasolicitacao] ADD  DEFAULT (NULL) FOR [registradopor];

-- Object:  Default [DF__ocorrenci__descr__3A8CA01F]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [ocorrenciasolicitacao] ADD  DEFAULT (NULL) FOR [descricao];

-- Object:  Default [DF__ocorrenci__datai__3B80C458]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [ocorrenciasolicitacao] ADD  DEFAULT (NULL) FOR [datainicio];

-- Object:  Default [DF__ocorrenci__dataf__3C74E891]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [ocorrenciasolicitacao] ADD  DEFAULT (NULL) FOR [datafim];

-- Object:  Default [DF__ocorrenci__categ__3D690CCA]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [ocorrenciasolicitacao] ADD  DEFAULT (NULL) FOR [categoria];

-- Object:  Default [DF__ocorrenci__orige__3E5D3103]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [ocorrenciasolicitacao] ADD  DEFAULT (NULL) FOR [origem];

-- Object:  Default [DF__ocorrenci__tempo__3F51553C]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [ocorrenciasolicitacao] ADD  DEFAULT (NULL) FOR [tempogasto];

-- Object:  Default [DF__ocorrenci__idcat__40457975]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [ocorrenciasolicitacao] ADD  DEFAULT (NULL) FOR [idcategoriaocorrencia];

-- Object:  Default [DF__ocorrenci__idori__41399DAE]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [ocorrenciasolicitacao] ADD  DEFAULT (NULL) FOR [idorigemocorrencia];

-- Object:  Default [DF__opiniao__idusuar__1EAF7B80]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [opiniao] ADD  DEFAULT (NULL) FOR [idusuario];

-- Object:  Default [DF__opiniao__idsolic__1FA39FB9]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [opiniao] ADD  DEFAULT (NULL) FOR [idsolicitacao];

-- Object:  Default [DF__opiniao__tipo__2097C3F2];    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [opiniao] ADD  DEFAULT (NULL) FOR [tipo];

-- Object:  Default [DF__opiniao__observa__218BE82B]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [opiniao] ADD  DEFAULT (NULL) FOR [observacoes];

-- Object:  Default [DF__opiniao__data__22800C64]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [opiniao] ADD  DEFAULT (NULL) FOR [data];

-- Object:  Default [DF__origemoco__dataF__300F11AC]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [origemocorrencia] ADD  DEFAULT (NULL) FOR [dataFim];

-- Object:  Default [DF__os__idclassifica__102C51FF]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [os] ADD  DEFAULT (NULL) FOR [idclassificacaoos];

-- Object:  Default [DF__os__idservicocon__11207638]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [os] ADD  DEFAULT (NULL) FOR [idservicocontrato];

-- Object:  Default [DF__os__numero__12149A71]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [os] ADD  DEFAULT (NULL) FOR [numero];

-- Object:  Default [DF__os__ano__1308BEAA]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [os] ADD  DEFAULT (NULL) FOR [ano];

-- Object:  Default [DF__os__situacaoos__13FCE2E3]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [os] ADD  DEFAULT (NULL) FOR [situacaoos];

-- Object:  Default [DF__os__nomearearequ__14F1071C]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [os] ADD  DEFAULT (NULL) FOR [nomearearequisitante];

-- Object:  Default [DF__os__quantidadegl__15E52B55]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [os] ADD  DEFAULT (NULL) FOR [quantidadeglosasanterior];

-- Object:  Default [DF__os__quantidade__16D94F8E]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [os] ADD  DEFAULT (NULL) FOR [quantidade];

-- Object:  Default [DF__os__idospai__17CD73C7]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [os] ADD  DEFAULT (NULL) FOR [idospai];

-- Object:  Default [DF__osativida__idati__19B5BC39]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [osatividadeperiodica] ADD  DEFAULT (NULL) FOR [idatividadeperiodica];

-- Object:  Default [DF__osatividad__idos__1AA9E072]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [osatividadeperiodica] ADD  DEFAULT (NULL) FOR [idos];

-- Object:  Default [DF__parametro__dataf__270FB757]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [parametrocorpore] ADD  DEFAULT (NULL) FOR [datafim];

-- Object:  Default [DF__parametro__dataf__270FB757]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [parametrocorpore] ADD  DEFAULT (NULL) FOR [tipodado];

-- Object:  Default [DF__parametro__modul__7D6E8346]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [parametros] ADD  DEFAULT (NULL) FOR [modulo];

-- Object:  Default [DF__parametro__valor__7E62A77F]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [parametros] ADD  DEFAULT (NULL) FOR [valor];

-- Object:  Default [DF__parametro__detal__7F56CBB8]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [parametros] ADD  DEFAULT (NULL) FOR [detalhamento];

-- Object:  Default [DF__parecer__idjusti__07EC11B9]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [parecer] ADD  DEFAULT (NULL) FOR [idjustificativa];

-- Object:  Default [DF__parecer__idalcad__08E035F2]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [parecer] ADD  DEFAULT (NULL) FOR [idalcada];

-- Object:  Default [DF__parecer__datahor__09D45A2B]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [parecer] ADD  DEFAULT (getdate()) FOR [datahoraparecer];

-- Object:  Default [DF__pasta__nome__108157BA]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [pasta] ADD  DEFAULT (NULL) FOR [nome];

-- Object:  Default [DF__pasta__datainici__11757BF3]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [pasta] ADD  DEFAULT (NULL) FOR [datainicio];

-- Object:  Default [DF__pasta__datafim__1269A02C]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [pasta] ADD  DEFAULT (NULL) FOR [datafim];

-- Object:  Default [DF__pasta__idpastapa__135DC465]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [pasta] ADD  DEFAULT (NULL) FOR [idpastapai];

-- Object:  Default [DF__pasta__idnotific__1451E89E]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [pasta] ADD  DEFAULT (NULL) FOR [idnotificacao];

-- Object:  Default [DF__pasta__herdaperm__15460CD7]    Script Date: 05/29/2013 13:26:37 --
ALTER TABLE [pasta] ADD  DEFAULT (NULL) FOR [herdapermissoes];

-- Object:  Default [DF__pedidocom__datap__0E4EF685]    Script Date: 05/29/2013 13:26:38 --
ALTER TABLE [pedidocompra] ADD  DEFAULT (NULL) FOR [dataprevistaentrega];

-- Object:  Default [DF__pedidocom__ident__0F431ABE]    Script Date: 05/29/2013 13:26:38 --
ALTER TABLE [pedidocompra] ADD  DEFAULT (NULL) FOR [identificacaoentrega];

-- Object:  Default [DF__pedidocom__valor__10373EF7]    Script Date: 05/29/2013 13:26:38 --
ALTER TABLE [pedidocompra] ADD  DEFAULT (NULL) FOR [valorfrete];

-- Object:  Default [DF__pedidocom__valor__112B6330]    Script Date: 05/29/2013 13:26:38 --
ALTER TABLE [pedidocompra] ADD  DEFAULT (NULL) FOR [valorseguro];

-- Object:  Default [DF__pedidocom__numer__121F8769]    Script Date: 05/29/2013 13:26:38 --
ALTER TABLE [pedidocompra] ADD  DEFAULT (NULL) FOR [numeronf];

-- Object:  Default [DF__pedidocom__outra__1313ABA2]    Script Date: 05/29/2013 13:26:38 --
ALTER TABLE [pedidocompra] ADD  DEFAULT (NULL) FOR [outrasdespesas];

-- Object:  Default [DF__pedidocom__idcot__1407CFDB]    Script Date: 05/29/2013 13:26:38 --
ALTER TABLE [pedidocompra] ADD  DEFAULT (NULL) FOR [idcotacao];

-- Object:  Default [DF__pedidocom__idend__14FBF414]    Script Date: 05/29/2013 13:26:38 --
ALTER TABLE [pedidocompra] ADD  DEFAULT (NULL) FOR [idenderecoentrega];

-- Object:  Default [DF__pedidocom__datae__15F0184D]    Script Date: 05/29/2013 13:26:38 --
ALTER TABLE [pedidocompra] ADD  DEFAULT (NULL) FOR [dataentrega];

-- Object:  Default [DF__perfilace__dataf__33EA8F88]    Script Date: 05/29/2013 13:26:38 --
ALTER TABLE [perfilacesso] ADD  DEFAULT (NULL) FOR [datafim];

-- Object:  Default [DF__perfilace__dataf__2B554987]    Script Date: 05/29/2013 13:26:38 --
ALTER TABLE [perfilacessogrupo] ADD  DEFAULT (NULL) FOR [datafim];

-- Object:  Default [DF__perfilace__idper__2D3D91F9]    Script Date: 05/29/2013 13:26:38 --
ALTER TABLE [perfilacessomenu] ADD  DEFAULT (NULL) FOR [idperfilacesso];

-- Object:  Default [DF__perfilace__idmen__2E31B632]    Script Date: 05/29/2013 13:26:38 --
ALTER TABLE [perfilacessomenu] ADD  DEFAULT (NULL) FOR [idmenu];

-- Object:  Default [DF__perfilace__dataf__2F25DA6B]    Script Date: 05/29/2013 13:26:38 --
ALTER TABLE [perfilacessomenu] ADD  DEFAULT (NULL) FOR [datafim];

-- Object:  Default [DF__perfilace__dataf__3A978D17]    Script Date: 05/29/2013 13:26:38 --
ALTER TABLE [perfilacessopasta] ADD  DEFAULT (NULL) FOR [datafim];

-- Object:  Default [DF__perfilace__aprov__3B8BB150]    Script Date: 05/29/2013 13:26:38 --
ALTER TABLE [perfilacessopasta] ADD  DEFAULT (NULL) FOR [aprovabaseconhecimento];

-- Object:  Default [DF__perfilace__permi__3C7FD589]    Script Date: 05/29/2013 13:26:38 --
ALTER TABLE [perfilacessopasta] ADD  DEFAULT (NULL) FOR [permiteleitura];

-- Object:  Default [DF__perfilace__permi__3D73F9C2]    Script Date: 05/29/2013 13:26:38 --
ALTER TABLE [perfilacessopasta] ADD  DEFAULT (NULL) FOR [permiteleituragravacao];

-- Object:  Default [DF__perfilace__dataf__4238AEDF]    Script Date: 05/29/2013 13:26:38 --
ALTER TABLE [perfilacessosituacaofatura] ADD  DEFAULT (NULL) FOR [datafim];

-- Object:  Default [DF__perfilace__dataf__46FD63FC]    Script Date: 05/29/2013 13:26:38 --
ALTER TABLE [perfilacessosituacaoos] ADD  DEFAULT (NULL) FOR [datafim];

-- Object:  Default [DF__perfilace__dataf__4BC21919]    Script Date: 05/29/2013 13:26:38 --
ALTER TABLE [perfilacessousuario] ADD  DEFAULT (NULL) FOR [datafim];

-- Object:  Default [DF__perfilseg__descp__5086CE36]    Script Date: 05/29/2013 13:26:38 --
ALTER TABLE [perfilseguranca] ADD  DEFAULT (NULL) FOR [descperfilseguranca];

-- Object:  Default [DF__permissoe__reati__554B8353]    Script Date: 05/29/2013 13:26:38 --
ALTER TABLE [permissoesfluxo] ADD  DEFAULT (NULL) FOR [reativar];

-- Object:  Default [DF__permissoe__alter__563FA78C]    Script Date: 05/29/2013 13:26:38 --
ALTER TABLE [permissoesfluxo] ADD  DEFAULT (NULL) FOR [alterarsla];

-- Object:  Default [DF__permissoe__reabr__5733CBC5]    Script Date: 05/29/2013 13:26:38 --
ALTER TABLE [permissoesfluxo] ADD  DEFAULT (NULL) FOR [reabrir];

-- Object:  Default [DF__pessoa__nome__5FC911C6]    Script Date: 05/29/2013 13:26:38 --
ALTER TABLE [pessoa] ADD  DEFAULT (NULL) FOR [nome];

-- Object:  Default [DF__pessoa__cpf__60BD35FF]    Script Date: 05/29/2013 13:26:38 --
ALTER TABLE [pessoa] ADD  DEFAULT (NULL) FOR [cpf];

-- Object:  Default [DF__planomelh__idfor__3D5E1FD2]    Script Date: 05/29/2013 13:26:38 --
ALTER TABLE [planomelhoria] ADD  DEFAULT (NULL) FOR [idfornecedor];

-- Object:  Default [DF__planomelh__idcon__3E52440B]    Script Date: 05/29/2013 13:26:38 --
ALTER TABLE [planomelhoria] ADD  DEFAULT (NULL) FOR [idcontrato];

-- Object:  Default [DF__planomelh__dataf__3F466844]    Script Date: 05/29/2013 13:26:38 --
ALTER TABLE [planomelhoria] ADD  DEFAULT (NULL) FOR [datafim];

-- Object:  Default [DF__planomelh__datac__403A8C7D]    Script Date: 05/29/2013 13:26:38 --
ALTER TABLE [planomelhoria] ADD  DEFAULT (NULL) FOR [datacriacao];

-- Object:  Default [DF__planomelh__criad__412EB0B6]    Script Date: 05/29/2013 13:26:38 --
ALTER TABLE [planomelhoria] ADD  DEFAULT (NULL) FOR [criadopor];

-- Object:  Default [DF__planomelh__modif__4222D4EF]    Script Date: 05/29/2013 13:26:38 --
ALTER TABLE [planomelhoria] ADD  DEFAULT (NULL) FOR [modificadopor];

-- Object:  Default [DF__planomelh__ultmo__4316F928]    Script Date: 05/29/2013 13:26:38 --
ALTER TABLE [planomelhoria] ADD  DEFAULT (NULL) FOR [ultmodificacao];

-- Object:  Default [DF__planomelh__situa__440B1D61]    Script Date: 05/29/2013 13:26:38 --
ALTER TABLE [planomelhoria] ADD  DEFAULT (NULL) FOR [situacao];

-- Object:  Default [DF__portal__iditem__6581EB1C]    Script Date: 05/29/2013 13:26:38 --
ALTER TABLE [portal] ADD  DEFAULT (NULL) FOR [iditem];

-- Object:  Default [DF__portal__posicaox__66760F55]    Script Date: 05/29/2013 13:26:38 --
ALTER TABLE [portal] ADD  DEFAULT (NULL) FOR [posicaox];

-- Object:  Default [DF__portal__posicaoy__676A338E]    Script Date: 05/29/2013 13:26:38 --
ALTER TABLE [portal] ADD  DEFAULT (NULL) FOR [posicaoy];

-- Object:  Default [DF__portal__largura__685E57C7]    Script Date: 05/29/2013 13:26:38 --
ALTER TABLE [portal] AD