--------------------------------------------------------
--  Alter session to fix the decimal and thousand markers
--------------------------------------------------------

	ALTER session SET NLS_NUMERIC_CHARACTERS = ',.';

--------------------------------------------------------
--  Arquivo criado - Terça-feira-Abril-09-2013   
--------------------------------------------------------
--------------------------------------------------------
--  DDL for Sequence INFORMACAOSERVICO_IDINFORMACAO
--------------------------------------------------------

   CREATE SEQUENCE  "INFORMACAOSERVICO_IDINFORMACAO"  MINVALUE 1 MAXVALUE 999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence LOGDADOS_IDLOG_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "LOGDADOS_IDLOG_SEQ"  MINVALUE 1 MAXVALUE 999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence OPINIAO_IDOPINIAO_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "OPINIAO_IDOPINIAO_SEQ"  MINVALUE 1 MAXVALUE 999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence SERVICOS_IDSERVICO_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "SERVICOS_IDSERVICO_SEQ"  MINVALUE 1 MAXVALUE 999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
   --------------------------------------------------------
--  DDL for Sequence SEQUENCE_BLOCK_ID_SEQ
--------------------------------------------------------

	CREATE SEQUENCE  "SEQUENCE_BLOCK_ID_SEQ"  MINVALUE 1 MAXVALUE 999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Table ACAOPLANOMELHORIA
--------------------------------------------------------

  CREATE TABLE "ACAOPLANOMELHORIA" 
   (	"IDACAOPLANOMELHORIA" NUMBER(10,0), 
	"IDPLANOMELHORIA" NUMBER(10,0), 
	"IDOBJETIVOPLANOMELHORIA" NUMBER(10,0), 
	"TITULOACAO" VARCHAR2(255 CHAR), 
	"DETALHAMENTOACAO" CLOB, 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE, 
	"RESPONSAVEL" VARCHAR2(255 CHAR), 
	"DATACONCLUSAO" DATE, 
	"CRIADOPOR" VARCHAR2(255 CHAR), 
	"MODIFICADOPOR" VARCHAR2(255 CHAR), 
	"DATACRIACAO" DATE, 
	"ULTMODIFICACAO" DATE
   );
--------------------------------------------------------
--  DDL for Table ACORDONIVELSERVICO
--------------------------------------------------------

  CREATE TABLE "ACORDONIVELSERVICO" 
   (	"IDACORDONIVELSERVICO" NUMBER(24,0), 
	"IDSERVICOCONTRATO" NUMBER(24,0), 
	"IDPRIORIDADEPADRAO" NUMBER(24,0), 
	"SITUACAO" CHAR(1 CHAR), 
	"TITULOSLA" VARCHAR2(500 CHAR), 
	"DISPONIBILIDADE" FLOAT(126), 
	"DESCRICAOSLA" CLOB, 
	"ESCOPOSLA" CLOB, 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE, 
	"AVALIAREM" DATE, 
	"TIPO" CHAR(1 CHAR), 
	"DELETED" CHAR(1 CHAR), 
	"VALORLIMITE" FLOAT(126), 
	"DETALHEGLOSA" CLOB, 
	"DETALHELIMITEGLOSA" CLOB, 
	"UNIDADEVALORLIMITE" VARCHAR2(150 CHAR), 
	"IMPACTO" CHAR(1 CHAR), 
	"URGENCIA" CHAR(1 CHAR), 
	"PERMITEMUDARIMPURG" CHAR(1 CHAR), 
	"IDFORMULA" NUMBER(10,0), 
	"CONTATOS" CLOB, 
	"CRIADOEM" DATE DEFAULT SYSDATE, 
	"CRIADOPOR" VARCHAR2(30 CHAR), 
	"MODIFICADOEM" DATE DEFAULT to_date('01-JAN-70 00:00:00', 'dd-MON-yy hh24:mi:ss'), 
	"MODIFICADOPOR" VARCHAR2(30 CHAR), 
	"TEMPOAUTO" FLOAT(126), 
	"IDPRIORIDADEAUTO1" NUMBER(10,0), 
	"IDPRIORIDADEAUTO2" NUMBER(10,0), 
	"IDPRIORIDADEAUTO3" NUMBER(10,0), 
	"IDPRIORIDADEAUTO4" NUMBER(10,0), 
	"IDPRIORIDADEAUTO5" NUMBER(10,0), 
	"IDGRUPO1" NUMBER(10,0), 
	"IDGRUPO2" NUMBER(10,0), 
	"IDGRUPO3" NUMBER(10,0), 
	"IDGRUPO4" NUMBER(10,0), 
	"IDGRUPO5" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table ACORDONIVELSERVICOCONTRATO
--------------------------------------------------------

  CREATE TABLE "ACORDONIVELSERVICOCONTRATO" 
   (	"IDACORDONIVELSERVICOCONTRATO" NUMBER(10,0), 
	"IDCONTRATO" NUMBER(10,0), 
	"DESCRICAOACORDO" VARCHAR2(200 CHAR), 
	"DETALHAMENTOACORDO" CLOB, 
	"VALORLIMITE" FLOAT(126), 
	"UNIDADEVALORLIMITE" VARCHAR2(200 CHAR), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE, 
	"DESCRICAOGLOSA" CLOB, 
	"DELETED" CHAR(1 CHAR), 
	"IDFORMULA" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table ACORDONIVELSERVICO_HIST
--------------------------------------------------------

  CREATE TABLE "ACORDONIVELSERVICO_HIST" 
   (	"IDACORDONIVELSERVICO_HIST" NUMBER(24,0), 
	"IDACORDONIVELSERVICO" NUMBER(24,0), 
	"IDSERVICOCONTRATO" NUMBER(24,0), 
	"IDPRIORIDADEPADRAO" NUMBER(10,0), 
	"SITUACAO" CHAR(1 CHAR), 
	"TITULOSLA" VARCHAR2(500 CHAR), 
	"DISPONIBILIDADE" FLOAT(126), 
	"DESCRICAOSLA" CLOB, 
	"ESCOPOSLA" CLOB, 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE, 
	"AVALIAREM" DATE, 
	"TIPO" CHAR(1 CHAR), 
	"VALORLIMITE" FLOAT(126), 
	"DETALHEGLOSA" CLOB, 
	"DETALHELIMITEGLOSA" CLOB, 
	"UNIDADEVALORLIMITE" VARCHAR2(150 CHAR), 
	"IMPACTO" CHAR(1 CHAR), 
	"URGENCIA" CHAR(1 CHAR), 
	"PERMITEMUDARIMPURG" CHAR(1 CHAR), 
	"DELETED" CHAR(1 CHAR), 
	"CRIADOEM" DATE DEFAULT SYSDATE, 
	"CRIADOPOR" VARCHAR2(255 CHAR), 
	"MODIFICADOEM" DATE DEFAULT to_date('01-JAN-70 00:00:00', 'dd-MON-yy hh24:mi:ss'), 
	"MODIFICADOPOR" VARCHAR2(255 CHAR), 
	"CONTEUDODADOS" CLOB, 
	"IDFORMULA" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table ACORDOSERVICOCONTRATO
--------------------------------------------------------

  CREATE TABLE "ACORDOSERVICOCONTRATO" 
   (	"IDACORDOSERVICOCONTRATO" NUMBER(24,0), 
	"IDACORDONIVELSERVICO" NUMBER(24,0), 
	"IDSERVICOCONTRATO" NUMBER(24,0), 
	"DATACRIACAO" DATE, 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE, 
	"DATAULTATUALIZ" DATE, 
	"DELETED" CHAR(1 CHAR), 
	"IDRECURSO" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table ALCADA
--------------------------------------------------------

  CREATE TABLE "ALCADA" 
   (	"IDALCADA" NUMBER(10,0), 
	"NOMEALCADA" VARCHAR2(70 CHAR), 
	"SITUACAO" CHAR(1 CHAR), 
	"TIPOALCADA" VARCHAR2(40 CHAR)
   );

   COMMENT ON COLUMN "ALCADA"."TIPOALCADA" IS 'C - Autorização de compras';
--------------------------------------------------------
--  DDL for Table ALCADACENTRORESULTADO
--------------------------------------------------------

  CREATE TABLE "ALCADACENTRORESULTADO" 
   (	"IDALCADACENTRORESULTADO" NUMBER(10,0), 
	"IDCENTRORESULTADO" NUMBER(10,0), 
	"IDEMPREGADO" NUMBER(10,0), 
	"IDALCADA" NUMBER(10,0), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE
   );
--------------------------------------------------------
--  DDL for Table ANEXO
--------------------------------------------------------

  CREATE TABLE "ANEXO" 
   (	"IDANEXO" NUMBER(10,0), 
	"IDEXECUCAOATIVIDADE" NUMBER(10,0), 
	"NOME" VARCHAR2(256 CHAR), 
	"DESCRICAO" CLOB, 
	"EXTENSAO" VARCHAR2(256 CHAR), 
	"LINK" VARCHAR2(256 CHAR), 
	"PATH" VARCHAR2(256 CHAR)
   );
--------------------------------------------------------
--  DDL for Table ANEXOBASECONHECIMENTO
--------------------------------------------------------

  CREATE TABLE "ANEXOBASECONHECIMENTO" 
   (	"IDANEXOBASECONHECIMENTO" NUMBER(10,0), 
	"IDBASECONHECIMENTO" NUMBER(10,0), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE, 
	"NOME" VARCHAR2(256 CHAR), 
	"LINK" VARCHAR2(256 CHAR), 
	"EXTENSAO" VARCHAR2(10 CHAR), 
	"DESCRICAO" VARCHAR2(256 CHAR)
   );
--------------------------------------------------------
--  DDL for Table ANEXOINCIDENTE
--------------------------------------------------------

  CREATE TABLE "ANEXOINCIDENTE" 
   (	"IDANEXOINCIDENTE" NUMBER(10,0), 
	"IDINCIDENTE" NUMBER(10,0), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE, 
	"NOME" VARCHAR2(256 CHAR), 
	"LINK" VARCHAR2(256 CHAR), 
	"EXTENSAO" VARCHAR2(10 CHAR), 
	"DESCRICAO" VARCHAR2(256 CHAR)
   );
--------------------------------------------------------
--  DDL for Table ANEXOMUDANCA
--------------------------------------------------------

  CREATE TABLE "ANEXOMUDANCA" 
   (	"IDANEXOMUDANCA" NUMBER(10,0), 
	"IDMUDANCA" NUMBER(10,0), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE, 
	"NOME" VARCHAR2(256 CHAR), 
	"LINK" VARCHAR2(256 CHAR), 
	"EXTENSAO" VARCHAR2(10 CHAR), 
	"DESCRICAO" VARCHAR2(256 CHAR)
   );
--------------------------------------------------------
--  DDL for Table APROVACAOMUDANCA
--------------------------------------------------------

  CREATE TABLE "APROVACAOMUDANCA" 
   (	"IDAPROVACAOMUDANCA" NUMBER(10,0), 
	"IDREQUISICAOMUDANCA" NUMBER(10,0), 
	"IDEMPREGADO" NUMBER(10,0), 
	"NOMEEMPREGADO" VARCHAR2(45 CHAR), 
	"VOTO" CHAR(1 CHAR), 
	"COMENTARIO" VARCHAR2(200 CHAR), 
	"DATAHORAINICIO" DATE
   );
--------------------------------------------------------
--  DDL for Table APROVACAOSOLICITACAOSERVICO
--------------------------------------------------------

  CREATE TABLE "APROVACAOSOLICITACAOSERVICO" 
   (	"IDAPROVACAOSOLICITACAOSERVICO" NUMBER(10,0), 
	"IDSOLICITACAOSERVICO" NUMBER(24,0), 
	"IDTAREFA" NUMBER(24,0), 
	"IDRESPONSAVEL" NUMBER(10,0), 
	"DATAHORA" DATE, 
	"IDJUSTIFICATIVA" NUMBER(10,0), 
	"COMPLEMENTOJUSTIFICATIVA" CLOB, 
	"OBSERVACOES" CLOB, 
	"APROVACAO" CHAR(1 CHAR)
   );
--------------------------------------------------------
--  DDL for Table APURACAOVALORESRECURSO
--------------------------------------------------------

  CREATE TABLE "APURACAOVALORESRECURSO" 
   (	"IDAPURACAOVALORESRECURSO" NUMBER(10,0), 
	"IDRECURSO" NUMBER(10,0), 
	"VALORINICIO" FLOAT(126), 
	"DELETED" CHAR(1 CHAR)
   );
--------------------------------------------------------
--  DDL for Table ATIVIDADEPERIODICA
--------------------------------------------------------

  CREATE TABLE "ATIVIDADEPERIODICA" 
   (	"IDATIVIDADEPERIODICA" NUMBER(10,0), 
	"IDCONTRATO" NUMBER(10,0), 
	"IDPROCEDIMENTOTECNICO" NUMBER(10,0), 
	"IDGRUPOATVPERIODICA" NUMBER(10,0), 
	"TITULOATIVIDADE" VARCHAR2(256 CHAR), 
	"DESCRICAO" CLOB, 
	"DATAINICIO" DATE, 
	"ORIENTACAOTECNICA" CLOB, 
	"DATAFIM" DATE, 
	"CRIADOPOR" VARCHAR2(30 CHAR), 
	"DATACRIACAO" DATE, 
	"ALTERADOPOR" VARCHAR2(30 CHAR), 
	"DATAULTALTERACAO" DATE, 
	"IDSOLICITACAOSERVICO" NUMBER(10,0), 
	"IDREQUISICAOMUDANCA" NUMBER(10,0), 
	"BLACKOUT" CHAR(1 CHAR)
   );
--------------------------------------------------------
--  DDL for Table ATIVIDADES
--------------------------------------------------------

  CREATE TABLE "ATIVIDADES" 
   (	"IDATIVIDADE" NUMBER(10,0), 
	"IDETAPA" NUMBER(10,0), 
	"IDTIPOATIVIDADE" NUMBER(10,0), 
	"IDATIVIDADEPROXIMA" NUMBER(10,0), 
	"NOMEATIVIDADE" VARCHAR2(100 CHAR), 
	"ORDEM" NUMBER(5,0), 
	"GRUPOEXECUTOR" VARCHAR2(20 CHAR)
   );
--------------------------------------------------------
--  DDL for Table ATIVIDADESFLUXOS
--------------------------------------------------------

  CREATE TABLE "ATIVIDADESFLUXOS" 
   (	"IDATIVIDADE" NUMBER(10,0), 
	"IDFLUXO" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table ATIVIDADESOS
--------------------------------------------------------

  CREATE TABLE "ATIVIDADESOS" 
   (	"IDATIVIDADESOS" NUMBER(24,0), 
	"IDOS" NUMBER(10,0), 
	"SEQUENCIA" NUMBER(5,0), 
	"IDATIVIDADESERVICOCONTRATO" NUMBER(24,0), 
	"DESCRICAOATIVIDADE" CLOB, 
	"OBSATIVIDADE" CLOB, 
	"CUSTOATIVIDADE" FLOAT(126), 
	"GLOSAATIVIDADE" FLOAT(126), 
	"COMPLEXIDADE" CHAR(5 CHAR), 
	"DELETED" CHAR(1 CHAR), 
	"QTDEEXECUTADA" FLOAT(126), 
	"FORMULA" CLOB, 
	"CONTABILIZAR" CHAR(1 CHAR), 
	"IDSERVICOCONTRATOCONTABIL" NUMBER(24,0)
   );
--------------------------------------------------------
--  DDL for Table ATIVIDADESSERVICOCONTRATO
--------------------------------------------------------

  CREATE TABLE "ATIVIDADESSERVICOCONTRATO" 
   (	"IDATIVIDADESERVICOCONTRATO" NUMBER(24,0), 
	"IDSERVICOCONTRATO" NUMBER(24,0), 
	"DESCRICAOATIVIDADE" CLOB, 
	"OBSATIVIDADE" CLOB, 
	"CUSTOATIVIDADE" FLOAT(126), 
	"COMPLEXIDADE" CHAR(5 CHAR), 
	"DELETED" CHAR(1 CHAR), 
	"HORA" FLOAT(126), 
	"QUANTIDADE" NUMBER(10,0), 
	"PERIODO" CHAR(5 CHAR), 
	"TIPOCUSTO" CHAR(1 CHAR), 
	"FORMULA" CLOB, 
	"CONTABILIZAR" CHAR(1 CHAR), 
	"IDSERVICOCONTRATOCONTABIL" NUMBER(24,0)
   );
--------------------------------------------------------
--  DDL for Table AUDITORIA
--------------------------------------------------------

  CREATE TABLE "AUDITORIA" 
   (	"IDAUDITORIA" NUMBER(10,0), 
	"IDITEMCONFIGURACAO" NUMBER(10,0), 
	"IDUSUARIO" NUMBER(10,0), 
	"DATA" DATE, 
	"HORA" CHAR(4 CHAR), 
	"OCORR" CLOB
   );
--------------------------------------------------------
--  DDL for Table AUDITORIAITEMCONFIGURACAO
--------------------------------------------------------

  CREATE TABLE "AUDITORIAITEMCONFIGURACAO" 
   (	"IDAUDITORIA" NUMBER(10,0), 
	"IDITEMCONFIGURACAO" NUMBER(10,0), 
	"IDEMPREGADO" NUMBER(10,0), 
	"DATA" DATE, 
	"HORA" CHAR(4 CHAR), 
	"OCORR" CLOB
   );
--------------------------------------------------------
--  DDL for Table AVALIACAOCOLETAPRECO
--------------------------------------------------------

  CREATE TABLE "AVALIACAOCOLETAPRECO" 
   (	"IDCRITERIO" NUMBER(10,0), 
	"IDCOLETAPRECO" NUMBER(10,0), 
	"AVALIACAO" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table AVALIACAOCOTACAO
--------------------------------------------------------

  CREATE TABLE "AVALIACAOCOTACAO" 
   (	"IDCRITERIO" NUMBER(10,0), 
	"IDFORNECEDOR" NUMBER(10,0), 
	"IDITEMCOTACAO" NUMBER(10,0), 
	"AVALIACAO" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table AVALIACAOFORNECEDOR
--------------------------------------------------------

  CREATE TABLE "AVALIACAOFORNECEDOR" 
   (	"IDAVALIACAOFORNECEDOR" NUMBER(10,0), 
	"IDFORNECEDOR" NUMBER(24,0), 
	"IDRESPONSAVEL" NUMBER(10,0), 
	"DATAAVALIACAO" DATE, 
	"DECISAOQUALIFICACAO" CHAR(1 CHAR), 
	"OBSERVACOES" CLOB, 
	"CONTATO" VARCHAR2(245 CHAR)
   );
--------------------------------------------------------
--  DDL for Table AVALIACAOPEDIDO
--------------------------------------------------------

  CREATE TABLE "AVALIACAOPEDIDO" 
   (	"IDAVALIACAO" NUMBER(10,0), 
	"IDCRITERIO" NUMBER(10,0), 
	"IDPEDIDO" NUMBER(10,0), 
	"IDCOLETAPRECO" NUMBER(10,0), 
	"IDITEMREQUISICAOPRODUTO" NUMBER(10,0), 
	"TIPOAVALIACAO" CHAR(1 CHAR), 
	"AVALIACAO" FLOAT(126), 
	"OBSERVACOES" CLOB
   );

   COMMENT ON COLUMN "AVALIACAOPEDIDO"."TIPOAVALIACAO" IS 'P - Produto
            C - Compra';
--------------------------------------------------------
--  DDL for Table AVALIACAOREFERENCIAFORNECEDOR
--------------------------------------------------------

  CREATE TABLE "AVALIACAOREFERENCIAFORNECEDOR" 
   (	"IDAVALIACAOFORNECEDOR" NUMBER(10,0) DEFAULT '0', 
	"IDEMPREGADO" NUMBER(10,0) DEFAULT '0', 
	"DECISAO" CHAR(1 CHAR), 
	"OBSERVACOES" CLOB
   );
--------------------------------------------------------
--  DDL for Table BASECONHECIMENTO
--------------------------------------------------------

  CREATE TABLE "BASECONHECIMENTO" 
   (	"IDBASECONHECIMENTO" NUMBER(10,0), 
	"IDPASTA" NUMBER(10,0), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE, 
	"TITULO" VARCHAR2(256 CHAR), 
	"CONTEUDO" CLOB, 
	"STATUS" CHAR(1 CHAR), 
	"IDBASECONHECIMENTOPAI" NUMBER(10,0), 
	"DATAEXPIRACAO" DATE, 
	"VERSAO" VARCHAR2(45 CHAR), 
	"IDNOTIFICACAO" NUMBER(10,0), 
	"JUSTIFICATIVAOBSERVACAO" VARCHAR2(500 CHAR), 
	"DATAPUBLICACAO" DATE, 
	"FONTEREFERENCIA" VARCHAR2(255 CHAR), 
	"FAQ" VARCHAR2(45 CHAR), 
	"ARQUIVADO" VARCHAR2(45 CHAR), 
	"IDUSUARIOAUTOR" NUMBER(10,0), 
	"IDUSUARIOAPROVADOR" NUMBER(10,0), 
	"IDHISTORICOBASECONHECIMENTO" NUMBER(10,0), 
	"ORIGEM" CHAR(1 CHAR), 
	"PRIVACIDADE" VARCHAR2(45 CHAR), 
	"SITUACAO" VARCHAR2(45 CHAR), 
	"GERENCIAMENTODISPONIBILIDADE" CHAR(1 CHAR), 
	"DIREITOAUTORAL" CHAR(1 CHAR), 
	"LEGISLACAO" CHAR(1 CHAR), 
	"CONTEUDOSEMFORMATACAO" CLOB
   );
--------------------------------------------------------
--  DDL for Table BASECONHECIMENTORELACIONADO
--------------------------------------------------------

  CREATE TABLE "BASECONHECIMENTORELACIONADO" 
   (	"IDBASECONHECIMENTO" NUMBER(10,0), 
	"IDBASECONHECIMENTORELACIONADO" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table BASEITEMCONFIGURACAO
--------------------------------------------------------

  CREATE TABLE "BASEITEMCONFIGURACAO" 
   (	"IDBASEITEMCONFIGURACAO" NUMBER(10,0), 
	"IDTIPOITEMCONFIGURACAO" NUMBER(10,0), 
	"NOMEBASEITEMCONFIGURACAO" VARCHAR2(256 CHAR), 
	"EXECUTAVEL" VARCHAR2(256 CHAR), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE, 
	"TIPOEXECUCAO" CHAR(1 CHAR), 
	"COMANDO" VARCHAR2(256 CHAR)
   );

   COMMENT ON COLUMN "BASEITEMCONFIGURACAO"."COMANDO" IS 'Comando de instalacao selenciosa.';
--------------------------------------------------------
--  DDL for Table BIBLIOTECASEXTERNAS
--------------------------------------------------------

  CREATE TABLE "BIBLIOTECASEXTERNAS" 
   (	"IDBIBLIOTECASEXTERNA" NUMBER(24,0), 
	"NOME" VARCHAR2(500 CHAR), 
	"CAMINHO" VARCHAR2(500 CHAR)
   );
--------------------------------------------------------
--  DDL for Table BOTAOACAOVISAO
--------------------------------------------------------

  CREATE TABLE "BOTAOACAOVISAO" 
   (	"IDBOTAOACAOVISAO" NUMBER(24,0), 
	"IDVISAO" NUMBER(24,0), 
	"TEXTO" VARCHAR2(120 CHAR), 
	"ACAO" CHAR(1 CHAR), 
	"SCRIPT" CLOB, 
	"HINT" VARCHAR2(120 CHAR), 
	"ICONE" VARCHAR2(120 CHAR), 
	"ORDEM" NUMBER(5,0)
   );
--------------------------------------------------------
--  DDL for Table BPM_ATRIBUICAOFLUXO
--------------------------------------------------------

  CREATE TABLE "BPM_ATRIBUICAOFLUXO" 
   (	"IDATRIBUICAO" NUMBER(24,0), 
	"IDITEMTRABALHO" NUMBER(24,0), 
	"TIPO" VARCHAR2(20 CHAR), 
	"DATAHORA" DATE DEFAULT SYSDATE, 
	"IDUSUARIO" NUMBER(10,0), 
	"IDGRUPO" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table BPM_ELEMENTOFLUXO
--------------------------------------------------------

  CREATE TABLE "BPM_ELEMENTOFLUXO" 
   (	"IDELEMENTO" NUMBER(24,0), 
	"IDFLUXO" NUMBER(24,0), 
	"TIPOELEMENTO" VARCHAR2(20 CHAR), 
	"SUBTIPO" VARCHAR2(20 CHAR), 
	"NOME" VARCHAR2(50 CHAR), 
	"DOCUMENTACAO" CLOB, 
	"TIPOINTERACAO" CHAR(1 CHAR), 
	"URL" VARCHAR2(150 CHAR), 
	"VISAO" VARCHAR2(150 CHAR), 
	"GRUPOS" CLOB, 
	"USUARIOS" CLOB, 
	"ACAOENTRADA" CLOB, 
	"ACAOSAIDA" CLOB, 
	"SCRIPT" CLOB, 
	"TEXTOEMAIL" CLOB, 
	"NOMEFLUXOENCADEADO" VARCHAR2(100 CHAR), 
	"POSX" FLOAT(126), 
	"POSY" FLOAT(126), 
	"ALTURA" FLOAT(126), 
	"LARGURA" FLOAT(126), 
	"MODELOEMAIL" VARCHAR2(20 CHAR), 
	"TEMPLATE" VARCHAR2(40 CHAR), 
	"INTERVALO" NUMBER(10,0), 
	"CONDICAODISPARO" CLOB, 
	"MULTIPLASINSTANCIAS" CHAR(1 CHAR), 
	"DESTINATARIOSEMAIL" CLOB, 
	"CONTABILIZASLA" CHAR(1 CHAR), 
	"PERCEXECUCAO" FLOAT(126)
   );
--------------------------------------------------------
--  DDL for Table BPM_FLUXO
--------------------------------------------------------

  CREATE TABLE "BPM_FLUXO" 
   (	"IDFLUXO" NUMBER(24,0), 
	"VERSAO" VARCHAR2(10 CHAR), 
	"IDTIPOFLUXO" NUMBER(10,0), 
	"VARIAVEIS" CLOB, 
	"CONTEUDOXML" CLOB, 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE
   );
--------------------------------------------------------
--  DDL for Table BPM_HISTORICOITEMTRABALHO
--------------------------------------------------------

  CREATE TABLE "BPM_HISTORICOITEMTRABALHO" 
   (	"IDHISTORICOITEMTRABALHO" NUMBER(24,0), 
	"IDITEMTRABALHO" NUMBER(24,0), 
	"IDRESPONSAVEL" NUMBER(10,0), 
	"IDUSUARIO" NUMBER(10,0), 
	"IDGRUPO" NUMBER(10,0), 
	"DATAHORA" DATE DEFAULT SYSDATE, 
	"ACAO" VARCHAR2(10 CHAR)
   );
--------------------------------------------------------
--  DDL for Table BPM_INSTANCIAFLUXO
--------------------------------------------------------

  CREATE TABLE "BPM_INSTANCIAFLUXO" 
   (	"IDINSTANCIA" NUMBER(24,0), 
	"IDFLUXO" NUMBER(24,0), 
	"DATAHORACRIACAO" DATE DEFAULT SYSDATE, 
	"SITUACAO" VARCHAR2(20 CHAR), 
	"DATAHORAFINALIZACAO" DATE
   );
--------------------------------------------------------
--  DDL for Table BPM_ITEMTRABALHOFLUXO
--------------------------------------------------------

  CREATE TABLE "BPM_ITEMTRABALHOFLUXO" 
   (	"IDITEMTRABALHO" NUMBER(24,0), 
	"IDINSTANCIA" NUMBER(24,0), 
	"IDELEMENTO" NUMBER(24,0), 
	"IDRESPONSAVELATUAL" NUMBER(10,0), 
	"DATAHORACRIACAO" DATE DEFAULT SYSDATE, 
	"DATAHORAINICIO" DATE, 
	"SITUACAO" CHAR(20 CHAR), 
	"DATAHORAFINALIZACAO" DATE, 
	"DATAHORAEXECUCAO" DATE
   );
--------------------------------------------------------
--  DDL for Table BPM_OBJETOINSTANCIAFLUXO
--------------------------------------------------------

  CREATE TABLE "BPM_OBJETOINSTANCIAFLUXO" 
   (	"IDOBJETOINSTANCIA" NUMBER(24,0), 
	"IDITEMTRABALHO" NUMBER(24,0), 
	"IDINSTANCIA" NUMBER(24,0), 
	"IDOBJETONEGOCIO" NUMBER(24,0), 
	"NOMEOBJETO" VARCHAR2(100 CHAR), 
	"NOMECLASSE" VARCHAR2(100 CHAR), 
	"TIPOASSOCIACAO" CHAR(1 CHAR), 
	"CAMPOCHAVE" CHAR(1 CHAR), 
	"OBJETOPRINCIPAL" CHAR(1 CHAR), 
	"NOMETABELABD" VARCHAR2(120 CHAR), 
	"NOMECAMPOBD" VARCHAR2(100 CHAR), 
	"TIPOCAMPOBD" VARCHAR2(20 CHAR), 
	"VALOR" CLOB
   );

   COMMENT ON COLUMN "BPM_OBJETOINSTANCIAFLUXO"."CAMPOCHAVE" IS 'S - Sim
            N - Não';
--------------------------------------------------------
--  DDL for Table BPM_SEQUENCIAFLUXO
--------------------------------------------------------

  CREATE TABLE "BPM_SEQUENCIAFLUXO" 
   (	"IDELEMENTOORIGEM" NUMBER(24,0), 
	"IDELEMENTODESTINO" NUMBER(24,0), 
	"IDFLUXO" NUMBER(24,0), 
	"NOMECLASSEORIGEM" VARCHAR2(100 CHAR), 
	"NOMECLASSEDESTINO" VARCHAR2(100 CHAR), 
	"CONDICAO" CLOB, 
	"IDCONEXAOORIGEM" NUMBER(5,0), 
	"IDCONEXAODESTINO" NUMBER(5,0), 
	"BORDAX" FLOAT(126), 
	"BORDAY" FLOAT(126), 
	"POSICAOALTERADA" CHAR(1 CHAR), 
	"NOME" VARCHAR2(100 CHAR)
   );
--------------------------------------------------------
--  DDL for Table BPM_TIPOFLUXO
--------------------------------------------------------

  CREATE TABLE "BPM_TIPOFLUXO" 
   (	"IDTIPOFLUXO" NUMBER(10,0), 
	"NOMEFLUXO" VARCHAR2(70 CHAR), 
	"DESCRICAO" CLOB, 
	"NOMECLASSEFLUXO" VARCHAR2(255 CHAR)
   );
--------------------------------------------------------
--  DDL for Table CALENDARIO
--------------------------------------------------------

  CREATE TABLE "CALENDARIO" 
   (	"IDCALENDARIO" NUMBER(10,0), 
	"DESCRICAO" VARCHAR2(70 CHAR), 
	"CONSIDERAFERIADOS" CHAR(1 CHAR), 
	"IDJORNADASEG" NUMBER(10,0), 
	"IDJORNADATER" NUMBER(10,0), 
	"IDJORNADAQUA" NUMBER(10,0), 
	"IDJORNADAQUI" NUMBER(10,0), 
	"IDJORNADASEX" NUMBER(10,0), 
	"IDJORNADASAB" NUMBER(10,0), 
	"IDJORNADADOM" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table CAMPOOBJRELACIONADO
--------------------------------------------------------

  CREATE TABLE "CAMPOOBJRELACIONADO" 
   (	"IDCAMPOOBJRELACIONADO" NUMBER(24,0), 
	"IDRELACOBJETONEGOCIO" NUMBER(24,0), 
	"IDCAMPOSOBJETONEGOCIOPAI" NUMBER(24,0), 
	"IDCAMPOSOBJETONEGOCIOFILHO" NUMBER(24,0), 
	"SITUACAO" CHAR(1 CHAR)
   );
--------------------------------------------------------
--  DDL for Table CAMPOSOBJETONEGOCIO
--------------------------------------------------------

  CREATE TABLE "CAMPOSOBJETONEGOCIO" 
   (	"IDCAMPOSOBJETONEGOCIO" NUMBER(24,0), 
	"IDOBJETONEGOCIO" NUMBER(24,0), 
	"NOME" VARCHAR2(100 CHAR), 
	"NOMEDB" VARCHAR2(100 CHAR), 
	"PK" CHAR(1 CHAR), 
	"SEQUENCE" CHAR(1 CHAR), 
	"UNICO" CHAR(1 CHAR), 
	"TIPODB" CHAR(20 CHAR), 
	"OBRIGATORIO" CHAR(1 CHAR), 
	"SITUACAO" CHAR(1 CHAR), 
	"PRECISIONDB" NUMBER(24,0) DEFAULT '0'
   );
--------------------------------------------------------
--  DDL for Table CARACTERISTICA
--------------------------------------------------------

  CREATE TABLE "CARACTERISTICA" 
   (	"IDCARACTERISTICA" NUMBER(10,0), 
	"IDEMPRESA" NUMBER(10,0), 
	"NOMECARACTERISTICA" VARCHAR2(255 CHAR), 
	"TAGCARACTERISTICA" VARCHAR2(255 CHAR), 
	"DESCRICAO" VARCHAR2(4000 CHAR), 
	"TIPO" CHAR(2 CHAR), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE, 
	"SISTEMA" CHAR(1 CHAR)
   );
--------------------------------------------------------
--  DDL for Table CARGOS
--------------------------------------------------------

  CREATE TABLE "CARGOS" 
   (	"IDCARGO" NUMBER(10,0), 
	"NOMECARGO" VARCHAR2(256 CHAR), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE
   );
--------------------------------------------------------
--  DDL for Table CATALOGOSERVICO
--------------------------------------------------------

  CREATE TABLE "CATALOGOSERVICO" 
   (	"IDCATALOGOSERVICO" NUMBER(10,0) DEFAULT '0', 
	"IDCONTRATO" NUMBER(10,0), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE, 
	"OBS" CLOB, 
	"NOMESERVICO" CHAR(150 CHAR), 
	"TITULOCATALOGOSERVICO" VARCHAR2(256 CHAR)
   );
--------------------------------------------------------
--  DDL for Table CATEGORIAGALERIAIMAGEM
--------------------------------------------------------

  CREATE TABLE "CATEGORIAGALERIAIMAGEM" 
   (	"IDCATEGORIAGALERIAIMAGEM" NUMBER(10,0), 
	"NOMECATEGORIA" VARCHAR2(70 CHAR)
   );
--------------------------------------------------------
--  DDL for Table CATEGORIAMUDANCA
--------------------------------------------------------

  CREATE TABLE "CATEGORIAMUDANCA" 
   (	"IDCATEGORIAMUDANCA" NUMBER(10,0), 
	"IDTIPOFLUXO" NUMBER(10,0), 
	"IDMODELOEMAILCRIACAO" NUMBER(10,0), 
	"IDMODELOEMAILFINALIZACAO" NUMBER(10,0), 
	"IDMODELOEMAILACOES" NUMBER(10,0), 
	"IDGRUPONIVEL1" NUMBER(10,0), 
	"IDGRUPOEXECUTOR" NUMBER(10,0), 
	"IDCALENDARIO" NUMBER(10,0), 
	"IDCATEGORIAMUDANCAPAI" NUMBER(10,0), 
	"NOMECATEGORIA" VARCHAR2(100 CHAR), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE
   );
--------------------------------------------------------
--  DDL for Table CATEGORIAOCORRENCIA
--------------------------------------------------------

  CREATE TABLE "CATEGORIAOCORRENCIA" 
   (	"IDCATEGORIAOCORRENCIA" NUMBER(10,0), 
	"NOME" VARCHAR2(20 CHAR), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE
   );
--------------------------------------------------------
--  DDL for Table CATEGORIAPOST
--------------------------------------------------------

  CREATE TABLE "CATEGORIAPOST" 
   (	"IDCATEGORIAPOST" NUMBER(10,0), 
	"IDCATEGORIAPOSTPAI" NUMBER(10,0), 
	"NOMECATEGORIA" VARCHAR2(255 CHAR), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE
   );
--------------------------------------------------------
--  DDL for Table CATEGORIAPROBLEMA
--------------------------------------------------------

  CREATE TABLE "CATEGORIAPROBLEMA" 
   (	"IDCATEGORIAPROBLEMA" NUMBER(10,0), 
	"CAT_IDCATEGORIAPROBLEMA" NUMBER(10,0), 
	"IDCATEGORIAPROBLEMAPAI" NUMBER(10,0), 
	"NOMECATEGORIA" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table CATEGORIAPRODUTO
--------------------------------------------------------

  CREATE TABLE "CATEGORIAPRODUTO" 
   (	"IDCATEGORIA" NUMBER(10,0), 
	"IDCATEGORIAPAI" NUMBER(10,0), 
	"NOMECATEGORIA" VARCHAR2(100 CHAR), 
	"SITUACAO" CHAR(1 CHAR), 
	"PESOCOTACAOPRECO" NUMBER(10,0), 
	"PESOCOTACAOPRAZOENTREGA" NUMBER(10,0), 
	"PESOCOTACAOPRAZOPAGTO" NUMBER(10,0), 
	"PESOCOTACAOTAXAJUROS" NUMBER(10,0), 
	"PESOCOTACAOPRAZOGARANTIA" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table CATEGORIAQUESTIONARIO
--------------------------------------------------------

  CREATE TABLE "CATEGORIAQUESTIONARIO" 
   (	"IDCATEGORIAQUESTIONARIO" NUMBER(10,0), 
	"NOMECATEGORIAQUESTIONARIO" VARCHAR2(50 CHAR), 
	"IDEMPRESA" NUMBER(10,0), 
	"COMPARTILHADA" CHAR(1 CHAR) DEFAULT 'N'
   );
--------------------------------------------------------
--  DDL for Table CATEGORIASERVICO
--------------------------------------------------------

  CREATE TABLE "CATEGORIASERVICO" 
   (	"IDCATEGORIASERVICO" NUMBER(10,0), 
	"IDCATEGORIASERVICOPAI" NUMBER(10,0), 
	"IDEMPRESA" NUMBER(10,0), 
	"NOMECATEGORIASERVICO" VARCHAR2(100 CHAR), 
	"DATAINICIO" DATE DEFAULT to_date('2012-04-02', 'yyyy-mm-dd'), 
	"DATAFIM" DATE, 
	"NOMECATEGORIASERVICOCONCATENAD" VARCHAR2(1024 CHAR), 
	"NOMECATSERVICOCONCATENADO" VARCHAR2(520 CHAR)
   );
--------------------------------------------------------
--  DDL for Table CATEGORIASOLUCAO
--------------------------------------------------------

  CREATE TABLE "CATEGORIASOLUCAO" 
   (	"IDCATEGORIASOLUCAO" NUMBER(10,0), 
	"IDCATEGORIASOLUCAOPAI" NUMBER(10,0), 
	"DESCRICAOCATEGORIASOLUCAO" VARCHAR2(100 CHAR), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE, 
	"DELETED" CHAR(1 CHAR)
   );
--------------------------------------------------------
--  DDL for Table CAUSAINCIDENTE
--------------------------------------------------------

  CREATE TABLE "CAUSAINCIDENTE" 
   (	"IDCAUSAINCIDENTE" NUMBER(10,0), 
	"IDCAUSAINCIDENTEPAI" NUMBER(10,0), 
	"DESCRICAOCAUSA" VARCHAR2(100 CHAR), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE, 
	"DELETED" CHAR(1 CHAR)
   );
--------------------------------------------------------
--  DDL for Table CENTRORESULTADO
--------------------------------------------------------

  CREATE TABLE "CENTRORESULTADO" 
   (	"IDCENTRORESULTADO" NUMBER(10,0), 
	"CODIGOCENTRORESULTADO" VARCHAR2(25 CHAR), 
	"NOMECENTRORESULTADO" VARCHAR2(200 CHAR), 
	"IDCENTRORESULTADOPAI" NUMBER(10,0), 
	"PERMITEREQUISICAOPRODUTO" CHAR(1 CHAR), 
	"SITUACAO" CHAR(1 CHAR)
   );
--------------------------------------------------------
--  DDL for Table CIDADES
--------------------------------------------------------

  CREATE TABLE "CIDADES" 
   (	"IDCIDADE" NUMBER(10,0), 
	"NOMECIDADE" VARCHAR2(45 CHAR), 
	"IDUF" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table CLIENTES
--------------------------------------------------------

  CREATE TABLE "CLIENTES" 
   (	"IDCLIENTE" NUMBER(10,0), 
	"NOMERAZAOSOCIAL" VARCHAR2(70 CHAR), 
	"NOMEFANTASIA" VARCHAR2(70 CHAR), 
	"CPFCNPJ" VARCHAR2(14 CHAR), 
	"OBSERVACOES" CLOB, 
	"SITUACAO" CHAR(1 CHAR), 
	"DELETED" CHAR(1 CHAR)
   );
--------------------------------------------------------
--  DDL for Table COLECAO
--------------------------------------------------------

  CREATE TABLE "COLECAO" 
   (	"IDCOLECAO" NUMBER(10,0), 
	"NOME" VARCHAR2(256 CHAR), 
	"IDTESTE" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table COLETAPRECO
--------------------------------------------------------

  CREATE TABLE "COLETAPRECO" 
   (	"IDCOLETAPRECO" NUMBER(10,0), 
	"IDFORNECEDOR" NUMBER(24,0), 
	"IDITEMCOTACAO" NUMBER(10,0), 
	"IDRESPONSAVEL" NUMBER(10,0), 
	"IDRESPRESULTADO" NUMBER(10,0), 
	"IDJUSTIFRESULTADO" NUMBER(10,0), 
	"DATACOLETA" DATE, 
	"DATAVALIDADE" DATE, 
	"ESPECIFICACOES" CLOB, 
	"PRECO" FLOAT(126), 
	"VALORACRESCIMO" FLOAT(126), 
	"VALORDESCONTO" FLOAT(126), 
	"VALORFRETE" FLOAT(126), 
	"PRAZOENTREGA" NUMBER(10,0), 
	"PRAZOMEDIOPAGTO" FLOAT(126), 
	"TAXAJUROS" FLOAT(126), 
	"PRAZOGARANTIA" NUMBER(10,0), 
	"QUANTIDADECOTADA" FLOAT(126), 
	"PONTUACAO" FLOAT(126), 
	"RESULTADOCALCULO" CHAR(1 CHAR), 
	"QUANTIDADECALCULO" FLOAT(126), 
	"RESULTADOFINAL" CHAR(1 CHAR), 
	"QUANTIDADECOMPRA" FLOAT(126), 
	"COMPLEMJUSTIFRESULTADO" CLOB, 
	"QUANTIDADEAPROVADA" FLOAT(126), 
	"QUANTIDADEPEDIDO" FLOAT(126)
   );

   COMMENT ON COLUMN "COLETAPRECO"."RESULTADOCALCULO" IS 'M - Melhor cotação
            E - Empate
            N - Não vencedora';
   COMMENT ON COLUMN "COLETAPRECO"."RESULTADOFINAL" IS 'M - Melhor cotação
            N - Não vencedora';
--------------------------------------------------------
--  DDL for Table COMANDO
--------------------------------------------------------

  CREATE TABLE "COMANDO" 
   (	"ID" NUMBER(10,0), 
	"DESCRICAO" VARCHAR2(400 CHAR)
   );
--------------------------------------------------------
--  DDL for Table COMANDOSISTEMAOPERACIONAL
--------------------------------------------------------

  CREATE TABLE "COMANDOSISTEMAOPERACIONAL" 
   (	"ID" NUMBER(10,0), 
	"IDCOMANDO" NUMBER(10,0), 
	"IDSISTEMAOPERACIONAL" NUMBER(10,0), 
	"COMANDO" VARCHAR2(255 CHAR), 
	"SISTEMAOPERACIONAL" VARCHAR2(255 CHAR), 
	"COMANDOSISTEMAOPERACIONAL" VARCHAR2(255 CHAR)
   );
--------------------------------------------------------
--  DDL for Table COMENTARIOS
--------------------------------------------------------

  CREATE TABLE "COMENTARIOS" 
   (	"IDCOMENTARIO" NUMBER(10,0), 
	"IDBASECONHECIMENTO" NUMBER(10,0), 
	"COMENTARIO" CLOB, 
	"NOME" VARCHAR2(255 CHAR), 
	"NOTA" VARCHAR2(45 CHAR), 
	"EMAIL" VARCHAR2(70 CHAR), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE
   );
--------------------------------------------------------
--  DDL for Table COMPLEXIDADE
--------------------------------------------------------

  CREATE TABLE "COMPLEXIDADE" 
   (	"IDCONTRATO" NUMBER(10,0) DEFAULT '0', 
	"COMPLEXIDADE" CHAR(1 CHAR), 
	"VALORCOMPLEXIDADE" FLOAT(126), 
	"DELETED" CHAR(1 CHAR)
   );
--------------------------------------------------------
--  DDL for Table CONDICAOOPERACAO
--------------------------------------------------------

  CREATE TABLE "CONDICAOOPERACAO" 
   (	"IDCONDICAOOPERACAO" NUMBER(10,0), 
	"IDEMPRESA" NUMBER(10,0), 
	"NOMECONDICAOOPERACAO" VARCHAR2(150 CHAR), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE
   );
--------------------------------------------------------
--  DDL for Table CONHECIMENTOIC
--------------------------------------------------------

  CREATE TABLE "CONHECIMENTOIC" 
   (	"IDITEMCONFIGURACAO" NUMBER(10,0), 
	"IDBASECONHECIMENTO" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table CONHECIMENTOMUDANCA
--------------------------------------------------------

  CREATE TABLE "CONHECIMENTOMUDANCA" 
   (	"IDREQUISICAOMUDANCA" NUMBER(10,0), 
	"IDBASECONHECIMENTO" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table CONHECIMENTOPROBLEMA
--------------------------------------------------------

  CREATE TABLE "CONHECIMENTOPROBLEMA" 
   (	"IDPROBLEMA" NUMBER(10,0), 
	"IDBASECONHECIMENTO" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table CONHECIMENTOSOLICITACAOSERVICO
--------------------------------------------------------

  CREATE TABLE "CONHECIMENTOSOLICITACAOSERVICO" 
   (	"IDSOLICITACAOSERVICO" NUMBER(24,0), 
	"IDBASECONHECIMENTO" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table CONTADORACESSO
--------------------------------------------------------

  CREATE TABLE "CONTADORACESSO" 
   (	"IDCONTADORACESSO" NUMBER(10,0), 
	"IDUSUARIO" NUMBER(10,0), 
	"IDBASECONHECIMENTO" NUMBER(10,0), 
	"DATAHORAACESSO" DATE DEFAULT SYSDATE, 
	"CONTADORACESSO" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table CONTATOCLIENTE
--------------------------------------------------------

  CREATE TABLE "CONTATOCLIENTE" 
   (	"IDCONTATOCLIENTE" NUMBER(10,0), 
	"IDCLIENTE" NUMBER(10,0), 
	"NOME" VARCHAR2(80 CHAR), 
	"TELEFONES" VARCHAR2(100 CHAR), 
	"EMAIL" VARCHAR2(255 CHAR), 
	"DEPARTAMENTO" VARCHAR2(100 CHAR), 
	"OBSERVACOES" CLOB, 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE
   );
--------------------------------------------------------
--  DDL for Table CONTATOREQUISICAOMUDANCA
--------------------------------------------------------

  CREATE TABLE "CONTATOREQUISICAOMUDANCA" 
   (	"IDCONTATOREQUISICAOMUDANCA" NUMBER(10,0), 
	"NOMECONTATO" VARCHAR2(100 CHAR), 
	"TELEFONECONTATO" VARCHAR2(100 CHAR), 
	"EMAILCONTATO" VARCHAR2(200 CHAR), 
	"OBSERVACAO" CLOB, 
	"IDLOCALIDADE" NUMBER(10,0), 
	"RAMAL" VARCHAR2(5 CHAR)
   );
--------------------------------------------------------
--  DDL for Table CONTATOSOLICITACAOSERVICO
--------------------------------------------------------

  CREATE TABLE "CONTATOSOLICITACAOSERVICO" 
   (	"IDCONTATOSOLICITACAOSERVICO" NUMBER(10,0), 
	"NOMECONTATO" VARCHAR2(70 CHAR), 
	"TELEFONECONTATO" VARCHAR2(70 CHAR), 
	"EMAILCONTATO" VARCHAR2(120 CHAR), 
	"LOCALIZACAOFISICA" CLOB, 
	"IDLOCALIDADE" NUMBER(10,0), 
	"RAMAL" VARCHAR2(5 CHAR)
   );
--------------------------------------------------------
--  DDL for Table CONTRATOQUESTIONARIOS
--------------------------------------------------------

  CREATE TABLE "CONTRATOQUESTIONARIOS" 
   (	"IDCONTRATOQUESTIONARIO" NUMBER(10,0), 
	"IDQUESTIONARIO" NUMBER(10,0), 
	"IDCONTRATO" NUMBER(10,0), 
	"DATAQUESTIONARIO" DATE, 
	"IDPROFISSIONAL" NUMBER(10,0), 
	"IDEMPRESA" NUMBER(10,0), 
	"ABA" VARCHAR2(30 CHAR), 
	"SITUACAO" CHAR(1 CHAR), 
	"SITUACAOCOMPLEMENTO" CHAR(1 CHAR), 
	"DATAHORAGRAV" DATE, 
	"MIGRADO" CHAR(1 CHAR), 
	"CONTEUDOIMPRESSO" CLOB, 
	"IDMIGRACAO" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table CONTRATOS
--------------------------------------------------------

  CREATE TABLE "CONTRATOS" 
   (	"IDCONTRATO" NUMBER(10,0), 
	"IDCLIENTE" NUMBER(10,0), 
	"IDMOEDA" NUMBER(10,0), 
	"IDFORNECEDOR" NUMBER(24,0), 
	"NUMERO" VARCHAR2(30 CHAR), 
	"OBJETO" CLOB, 
	"DATACONTRATO" DATE, 
	"VALORESTIMADO" FLOAT(126), 
	"TIPOTEMPOESTIMADO" CHAR(1 CHAR), 
	"TEMPOESTIMADO" NUMBER(10,0), 
	"TIPO" CHAR(1 CHAR), 
	"SITUACAO" CHAR(1 CHAR), 
	"COTACAOMOEDA" FLOAT(126), 
	"CADASTROMANUALUSUARIO" CHAR(1 CHAR), 
	"DELETED" CHAR(1 CHAR), 
	"IDGRUPOSOLICITANTE" NUMBER(10,0), 
	"DATAFIMCONTRATO" DATE
   );
--------------------------------------------------------
--  DDL for Table CONTRATOSCOLABORADORES
--------------------------------------------------------

  CREATE TABLE "CONTRATOSCOLABORADORES" 
   (	"IDEMPREGADO" NUMBER(10,0), 
	"IDCONTRATO" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table CONTRATOSGRUPOS
--------------------------------------------------------

  CREATE TABLE "CONTRATOSGRUPOS" 
   (	"IDGRUPO" NUMBER(10,0), 
	"IDCONTRATO" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table CONTRATOS_HIST
--------------------------------------------------------

  CREATE TABLE "CONTRATOS_HIST" 
   (	"IDCONTRATO_HIST" NUMBER(10,0), 
	"IDCONTRATO" NUMBER(10,0), 
	"IDCLIENTE" NUMBER(10,0), 
	"IDMOEDA" NUMBER(10,0), 
	"IDFORNECEDOR" NUMBER(24,0), 
	"NUMERO" VARCHAR2(30 CHAR), 
	"OBJETO" CLOB, 
	"DATACONTRATO" DATE, 
	"VALORESTIMADO" FLOAT(126), 
	"TIPOTEMPOESTIMADO" CHAR(1 CHAR), 
	"TEMPOESTIMADO" NUMBER(10,0), 
	"TIPO" CHAR(1 CHAR), 
	"SITUACAO" CHAR(1 CHAR), 
	"COTACAOMOEDA" FLOAT(126), 
	"CADASTROMANUALUSUARIO" CHAR(1 CHAR), 
	"DELETED" CHAR(1 CHAR), 
	"IDGRUPOSOLICITANTE" NUMBER(10,0), 
	"DATAFIMCONTRATO" DATE, 
	"CRIADOEM" DATE DEFAULT SYSDATE, 
	"CRIADOPOR" VARCHAR2(256 CHAR), 
	"MODIFICADOEM" DATE DEFAULT to_date('01-JAN-70 00:00:00', 'dd-MON-yy hh24:mi:ss'), 
	"MODIFICADOPOR" VARCHAR2(256 CHAR), 
	"CONTEUDODADOS" CLOB
   );
--------------------------------------------------------
--  DDL for Table CONTRATOSUNIDADES
--------------------------------------------------------

  CREATE TABLE "CONTRATOSUNIDADES" 
   (	"IDUNIDADE" NUMBER(10,0), 
	"IDCONTRATO" NUMBER(10,0) DEFAULT '0', 
	"CONTRATOSUNIDADESCOL" VARCHAR2(45 CHAR)
   );
--------------------------------------------------------
--  DDL for Table CONTROLEGED
--------------------------------------------------------

  CREATE TABLE "CONTROLEGED" 
   (	"IDCONTROLEGED" NUMBER(10,0), 
	"IDTABELA" NUMBER(5,0), 
	"ID" NUMBER(10,0), 
	"NOMEARQUIVO" VARCHAR2(255 CHAR), 
	"DESCRICAOARQUIVO" VARCHAR2(255 CHAR), 
	"EXTENSAOARQUIVO" VARCHAR2(5 CHAR), 
	"DATAHORA" DATE DEFAULT SYSDATE, 
	"PASTA" VARCHAR2(255 CHAR), 
	"CONTEUDOARQUIVO" BLOB
   );
--------------------------------------------------------
--  DDL for Table CONTROLEQUESTIONARIOS
--------------------------------------------------------

  CREATE TABLE "CONTROLEQUESTIONARIOS" 
   (	"IDCONTROLEQUESTIONARIO" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table COTACAO
--------------------------------------------------------

  CREATE TABLE "COTACAO" 
   (	"IDCOTACAO" NUMBER(10,0), 
	"IDENTIFICACAO" VARCHAR2(100 CHAR), 
	"IDEMPRESA" NUMBER(10,0), 
	"IDRESPONSAVEL" NUMBER(10,0), 
	"SITUACAO" VARCHAR2(25 CHAR), 
	"DATAHORACADASTRO" DATE DEFAULT SYSDATE, 
	"OBSERVACOES" CLOB, 
	"DATAFINALPREVISTA" DATE
   );
--------------------------------------------------------
--  DDL for Table COTACAOITEMREQUISICAO
--------------------------------------------------------

  CREATE TABLE "COTACAOITEMREQUISICAO" 
   (	"IDCOLETAPRECO" NUMBER(10,0), 
	"IDITEMREQUISICAOPRODUTO" NUMBER(10,0), 
	"IDPARECER" NUMBER(10,0), 
	"IDITEMTRABALHOAPROVACAO" NUMBER(24,0), 
	"IDSOLICITACAOSERVICO" NUMBER(24,0), 
	"IDITEMTRABALHOINSPECAO" NUMBER(24,0), 
	"IDCOTACAO" NUMBER(10,0), 
	"QUANTIDADE" FLOAT(126), 
	"SITUACAO" CHAR(25 CHAR), 
	"QUANTIDADEENTREGUE" FLOAT(126), 
	"IDITEMTRABALHO" NUMBER(10,0)
   );

   COMMENT ON COLUMN "COTACAOITEMREQUISICAO"."SITUACAO" IS 'Aguardando - Aguardando aprovação
            PreAprovado - Pré aprovado
            Aprovado - Aprovado
            NaoAprovado - Não aprovado';
--------------------------------------------------------
--  DDL for Table CRITERIOAVALIACAO
--------------------------------------------------------

  CREATE TABLE "CRITERIOAVALIACAO" 
   (	"IDCRITERIO" NUMBER(10,0), 
	"DESCRICAO" VARCHAR2(100 CHAR), 
	"APLICAVELCOTACAO" CHAR(1 CHAR), 
	"APLICAVELAVALIACAOSOLICITANTE" CHAR(1 CHAR), 
	"APLICAVELAVALIACAOCOMPRADOR" CHAR(1 CHAR), 
	"APLICAVELQUALIFICACAOFORNECEDO" CHAR(1 CHAR), 
	"TIPOAVALIACAO" CHAR(1 CHAR)
   );

   COMMENT ON COLUMN "CRITERIOAVALIACAO"."TIPOAVALIACAO" IS 'S - Sim/N?o
            A - Aceito/Nao Aceito
            C - Conforme/Nao Conforme
            N - Numero - 0 a 10';
--------------------------------------------------------
--  DDL for Table CRITERIOAVALIACAOFORNECEDOR
--------------------------------------------------------

  CREATE TABLE "CRITERIOAVALIACAOFORNECEDOR" 
   (	"IDAVALIACAOFORNECEDOR" NUMBER(10,0) DEFAULT '0', 
	"IDCRITERIO" NUMBER(10,0) DEFAULT '0', 
	"VALOR" NUMBER(10,0), 
	"OBSERVACOES" CLOB
   );
--------------------------------------------------------
--  DDL for Table CRITERIOCOTACAO
--------------------------------------------------------

  CREATE TABLE "CRITERIOCOTACAO" 
   (	"IDCOTACAO" NUMBER(10,0), 
	"IDCRITERIO" NUMBER(10,0), 
	"PESO" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table CRITERIOCOTACAOCATEGORIA
--------------------------------------------------------

  CREATE TABLE "CRITERIOCOTACAOCATEGORIA" 
   (	"IDCATEGORIA" NUMBER(10,0), 
	"IDCRITERIO" NUMBER(10,0), 
	"PESOCOTACAO" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table CRITERIOITEMCOTACAO
--------------------------------------------------------

  CREATE TABLE "CRITERIOITEMCOTACAO" 
   (	"IDITEMCOTACAO" NUMBER(10,0), 
	"IDCRITERIO" NUMBER(10,0), 
	"PESO" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table DEMANDAS
--------------------------------------------------------

  CREATE TABLE "DEMANDAS" 
   (	"IDDEMANDA" NUMBER(10,0), 
	"IDCONTRATO" NUMBER(10,0), 
	"IDSITUACAODEMANDA" NUMBER(10,0), 
	"IDTIPODEMANDA" NUMBER(10,0), 
	"IDPROJETO" NUMBER(10,0), 
	"IDDEMANDAPAI" NUMBER(10,0), 
	"IDFLUXO" NUMBER(10,0), 
	"PREVISAOINICIO" DATE, 
	"DATAINICIO" DATE, 
	"PREVISAOFIM" DATE, 
	"DATAFIM" DATE, 
	"DETALHAMENTO" CLOB, 
	"PRIORIDADE" CHAR(1 CHAR), 
	"EXPECTATIVAFIM" DATE, 
	"DATACADASTRO" DATE, 
	"COMPLEXIDADE" NUMBER(10,0), 
	"CUSTOTOTAL" FLOAT(126), 
	"OBSERVACAO" CLOB, 
	"IDOS" NUMBER(10,0), 
	"GLOSA" FLOAT(126)
   );
--------------------------------------------------------
--  DDL for Table DICIONARIO
--------------------------------------------------------

  CREATE TABLE "DICIONARIO" 
   (	
    "IDDICIONARIO" NUMBER(10,0), 
	"NOME" VARCHAR2(245 CHAR), 
	"VALOR" VARCHAR2(500 CHAR), 
	"IDLINGUA" NUMBER(10,0),
	"PERSONALIZADO" CHAR(1 CHAR) DEFAULT 'N'
   );
--------------------------------------------------------
--  DDL for Table EMAILSOLICITACAOSERVICO
--------------------------------------------------------

  CREATE TABLE "EMAILSOLICITACAOSERVICO" 
   (	"MESSAGEID" VARCHAR2(500 CHAR), 
	"SITUACAO" VARCHAR2(25 CHAR), 
	"IDEMAILSOLICITACAOSERVICO" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table EMPREGADOITEMCONFIGURACAO
--------------------------------------------------------

  CREATE TABLE "EMPREGADOITEMCONFIGURACAO" 
   (	"IDUSUARIO" NUMBER(10,0), 
	"IDITEMCONFIGURACAO" NUMBER(10,0), 
	"IDEMPREGADO" NUMBER(10,0), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE
   );
--------------------------------------------------------
--  DDL for Table EMPREGADOS
--------------------------------------------------------

  CREATE TABLE "EMPREGADOS" 
   (	"IDEMPREGADO" NUMBER(10,0), 
	"NOME" VARCHAR2(80 CHAR), 
	"NOMEPROCURA" VARCHAR2(80 CHAR), 
	"DATANASCIMENTO" DATE, 
	"SEXO" CHAR(1 CHAR), 
	"CPF" VARCHAR2(14 CHAR), 
	"RG" VARCHAR2(15 CHAR), 
	"DATAEMISSAORG" DATE, 
	"IDTIPOSANGUE" NUMBER(10,0) DEFAULT '0', 
	"ORGEXPEDIDOR" VARCHAR2(15 CHAR), 
	"IDUFORGEXPEDIDOR" NUMBER(10,0), 
	"PAI" VARCHAR2(50 CHAR), 
	"MAE" VARCHAR2(50 CHAR), 
	"CONJUGE" VARCHAR2(50 CHAR), 
	"OBSERVACOES" CLOB, 
	"ESTADOCIVIL" NUMBER(5,0), 
	"EMAIL" VARCHAR2(200 CHAR), 
	"DATACADASTRO" DATE, 
	"FUMANTE" CHAR(1 CHAR) DEFAULT 'N', 
	"CTPSNUMERO" VARCHAR2(15 CHAR), 
	"CTPSSERIE" VARCHAR2(10 CHAR), 
	"CTPSIDUF" NUMBER(10,0), 
	"CTPSDATAEMISSAO" DATE, 
	"NIT" VARCHAR2(20 CHAR), 
	"DATAADMISSAO" DATE, 
	"DATADEMISSAO" DATE, 
	"TIPO" CHAR(1 CHAR), 
	"IDSITUACAOFUNCIONAL" NUMBER(10,0), 
	"CUSTOPORHORA" FLOAT(126), 
	"CUSTOTOTALMES" FLOAT(126), 
	"VALORSALARIO" FLOAT(126), 
	"VALORPRODUTIVIDADEMEDIA" FLOAT(126), 
	"VALORPLANOSAUDEMEDIA" FLOAT(126), 
	"VALORVTRAMEDIA" FLOAT(126), 
	"VALORVREFMEDIA" FLOAT(126), 
	"AGENCIA" VARCHAR2(10 CHAR), 
	"CONTASALARIO" VARCHAR2(20 CHAR), 
	"IDUNIDADE" NUMBER(10,0), 
	"DATAFIM" DATE, 
	"TELEFONE" VARCHAR2(45 CHAR), 
	"IDCARGO" NUMBER(10,0), 
	"VINCULAACONTRATOS" CHAR(1 CHAR), 
	"RAMAL" VARCHAR2(5 CHAR)
   );
--------------------------------------------------------
--  DDL for Table EMPRESA
--------------------------------------------------------

  CREATE TABLE "EMPRESA" 
   (	"IDEMPRESA" NUMBER(10,0), 
	"NOMEEMPRESA" VARCHAR2(150 CHAR), 
	"DETALHAMENTO" CLOB, 
	"DATAINICIO" DATE DEFAULT to_date('2012-04-02', 'yyyy-mm-dd'), 
	"DATAFIM" DATE
   );
--------------------------------------------------------
--  DDL for Table ENDERECO
--------------------------------------------------------

  CREATE TABLE "ENDERECO" 
   (	"IDENDERECO" NUMBER(10,0), 
	"LOGRADOURO" VARCHAR2(200 CHAR), 
	"NUMERO" VARCHAR2(20 CHAR), 
	"COMPLEMENTO" VARCHAR2(200 CHAR), 
	"BAIRRO" VARCHAR2(200 CHAR), 
	"IDCIDADE" NUMBER(10,0), 
	"IDPAIS" NUMBER(10,0), 
	"CEP" VARCHAR2(8 CHAR), 
	"IDUF" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table ENTREGAITEMREQUISICAO
--------------------------------------------------------

  CREATE TABLE "ENTREGAITEMREQUISICAO" 
   (	"IDENTREGA" NUMBER(10,0), 
	"IDPEDIDO" NUMBER(10,0), 
	"IDCOLETAPRECO" NUMBER(10,0), 
	"IDITEMREQUISICAOPRODUTO" NUMBER(10,0), 
	"IDSOLICITACAOSERVICO" NUMBER(24,0), 
	"QUANTIDADEENTREGUE" FLOAT(126), 
	"IDITEMTRABALHO" NUMBER(24,0), 
	"IDPARECER" NUMBER(10,0), 
	"SITUACAO" VARCHAR2(25 CHAR), 
	"OBSERVACOES" CLOB
   );
--------------------------------------------------------
--  DDL for Table ETAPAS
--------------------------------------------------------

  CREATE TABLE "ETAPAS" 
   (	"IDETAPA" NUMBER(10,0), 
	"IDFLUXO" NUMBER(10,0), 
	"IDETAPAPAI" NUMBER(10,0), 
	"NOMEETAPA" VARCHAR2(70 CHAR), 
	"ORDEM" NUMBER(5,0)
   );
--------------------------------------------------------
--  DDL for Table EVENTO
--------------------------------------------------------

  CREATE TABLE "EVENTO" 
   (	"IDEVENTO" NUMBER(10,0), 
	"IDEMPRESA" NUMBER(10,0), 
	"DESCRICAO" VARCHAR2(255 CHAR), 
	"LIGARCASODESL" CHAR(1 CHAR), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE, 
	"USUARIO" VARCHAR2(256 CHAR), 
	"SENHA" VARCHAR2(256 CHAR)
   );
--------------------------------------------------------
--  DDL for Table EVENTOEMPREGADO
--------------------------------------------------------

  CREATE TABLE "EVENTOEMPREGADO" 
   (	"IDEVENTO" NUMBER(10,0), 
	"IDEMPREGADO" NUMBER(10,0), 
	"IDGRUPO" NUMBER(10,0), 
	"IDUNIDADE" NUMBER(10,0), 
	"IDITEMCONFIGURACAOPAI" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table EVENTOGRUPO
--------------------------------------------------------

  CREATE TABLE "EVENTOGRUPO" 
   (	"IDEVENTO" NUMBER(10,0), 
	"IDGRUPO" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table EVENTOITEMCONFIGURACAO
--------------------------------------------------------

  CREATE TABLE "EVENTOITEMCONFIGURACAO" 
   (	"IDEVENTO" NUMBER(10,0) DEFAULT '0', 
	"IDITEMCONFIGURACAO" NUMBER(10,0) DEFAULT '0'
   );
--------------------------------------------------------
--  DDL for Table EVENTOMONITCONHECIMENTO
--------------------------------------------------------

  CREATE TABLE "EVENTOMONITCONHECIMENTO" 
   (	"IDEVENTOMONITORAMENTO" NUMBER(10,0), 
	"IDBASECONHECIMENTO" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table EVENTOMONITORAMENTO
--------------------------------------------------------

  CREATE TABLE "EVENTOMONITORAMENTO" 
   (	"IDEVENTOMONITORAMENTO" NUMBER(10,0), 
	"NOMEEVENTO" VARCHAR2(255 CHAR), 
	"DETALHAMENTO" CLOB, 
	"CRIADOPOR" VARCHAR2(255 CHAR), 
	"MODIFICADOPOR" VARCHAR2(255 CHAR), 
	"DATACRIACAO" DATE, 
	"ULTMODIFICACAO" DATE
   );
--------------------------------------------------------
--  DDL for Table EVENTOUNIDADE
--------------------------------------------------------

  CREATE TABLE "EVENTOUNIDADE" 
   (	"IDUNIDADE" NUMBER(10,0), 
	"IDEVENTO" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table EXCECAOCALENDARIO
--------------------------------------------------------

  CREATE TABLE "EXCECAOCALENDARIO" 
   (	"IDEXCECAOCALENDARIO" NUMBER(10,0), 
	"IDCALENDARIO" NUMBER(10,0), 
	"IDJORNADA" NUMBER(10,0), 
	"TIPO" CHAR(1 CHAR), 
	"DATAINICIO" DATE, 
	"DATATERMINO" DATE
   );

   COMMENT ON COLUMN "EXCECAOCALENDARIO"."TIPO" IS 'F=Folga             T=Trabalho';
--------------------------------------------------------
--  DDL for Table EXCECAOEMPREGADO
--------------------------------------------------------

  CREATE TABLE "EXCECAOEMPREGADO" 
   (	"IDEVENTO" NUMBER(10,0), 
	"IDEMPREGADO" NUMBER(10,0), 
	"IDGRUPO" NUMBER(10,0), 
	"IDUNIDADE" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table EXECUCAOATIVIDADEPERIODICA
--------------------------------------------------------

  CREATE TABLE "EXECUCAOATIVIDADEPERIODICA" 
   (	"IDEXECUCAOATIVIDADEPERIODICA" NUMBER(10,0), 
	"IDATIVIDADEPERIODICA" NUMBER(10,0), 
	"DATAPROGRAMADA" DATE, 
	"HORAPROGRAMADA" CHAR(5 CHAR), 
	"SITUACAO" CHAR(1 CHAR), 
	"DETALHAMENTO" CLOB, 
	"USUARIO" CHAR(1 CHAR), 
	"IDEMPREGADO" NUMBER(10,0), 
	"DATAEXECUCAO" DATE, 
	"HORAEXECUCAO" CHAR(5 CHAR), 
	"DATAREGISTRO" DATE, 
	"HORAREGISTRO" CHAR(5 CHAR), 
	"IDPROGRAMACAOATIVIDADE" NUMBER(10,0), 
	"IDMOTIVOSUSPENSAO" NUMBER(10,0), 
	"COMPLEMENTOMOTIVOSUSPENSAO" CLOB
   );
--------------------------------------------------------
--  DDL for Table EXECUCAOBATCH
--------------------------------------------------------

  CREATE TABLE "EXECUCAOBATCH" 
   (	"IDEXECUCAOBATCH" NUMBER(10,0), 
	"IDPROCESSAMENTOBATCH" NUMBER(10,0), 
	"CONTEUDO" CLOB, 
	"DATAHORA" DATE DEFAULT SYSDATE
   );
--------------------------------------------------------
--  DDL for Table EXECUCAODEMANDA
--------------------------------------------------------

  CREATE TABLE "EXECUCAODEMANDA" 
   (	"IDEXECUCAO" NUMBER(10,0), 
	"IDDEMANDA" NUMBER(10,0), 
	"IDATIVIDADE" NUMBER(10,0), 
	"IDEMPREGADOEXECUTOR" NUMBER(10,0), 
	"IDEMPREGADORECEPTOR" NUMBER(10,0), 
	"RELATO" CLOB, 
	"QTDEHORAS" FLOAT(126), 
	"SITUACAO" CHAR(1 CHAR), 
	"GRUPOEXECUTOR" VARCHAR2(20 CHAR), 
	"TERMINOPREVISTO" DATE, 
	"TERMINOREAL" DATE
   );
--------------------------------------------------------
--  DDL for Table EXECUCAOMUDANCA
--------------------------------------------------------

  CREATE TABLE "EXECUCAOMUDANCA" 
   (	"IDEXECUCAO" NUMBER(10,0), 
	"IDINSTANCIAFLUXO" NUMBER(24,0), 
	"IDREQUISICAOMUDANCA" NUMBER(10,0), 
	"IDFLUXO" NUMBER(24,0), 
	"SEQREABERTURA" NUMBER(5,0)
   );
--------------------------------------------------------
--  DDL for Table EXECUCAOSOLICITACAO
--------------------------------------------------------

  CREATE TABLE "EXECUCAOSOLICITACAO" 
   (	"IDEXECUCAO" NUMBER(24,0), 
	"IDSOLICITACAOSERVICO" NUMBER(24,0), 
	"IDFASE" NUMBER(24,0), 
	"IDINSTANCIAFLUXO" NUMBER(24,0), 
	"IDFLUXO" NUMBER(24,0), 
	"PRAZOHH" NUMBER(5,0), 
	"PRAZOMM" NUMBER(5,0), 
	"SEQREABERTURA" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table EXTERNALCONNECTION
--------------------------------------------------------

  CREATE TABLE "EXTERNALCONNECTION" 
   (	"IDEXTERNALCONNECTION" NUMBER(10,0), 
	"NOME" VARCHAR2(80 CHAR), 
	"TIPO" CHAR(1 CHAR), 
	"URLJDBC" VARCHAR2(255 CHAR), 
	"JDBCDBNAME" VARCHAR2(255 CHAR), 
	"JDBCDRIVER" VARCHAR2(255 CHAR), 
	"JDBCUSER" VARCHAR2(255 CHAR), 
	"JDBCPASSWORD" VARCHAR2(255 CHAR), 
	"FILENAME" VARCHAR2(500 CHAR), 
	"SCHEMADB" VARCHAR2(255 CHAR), 
	"DELETED" CHAR(1 CHAR)
   );
--------------------------------------------------------
--  DDL for Table FAIXAVALORESRECURSO
--------------------------------------------------------

  CREATE TABLE "FAIXAVALORESRECURSO" 
   (	"IDFAIXAVALORESRECURSO" NUMBER(10,0), 
	"IDRECURSO" NUMBER(10,0), 
	"VALORINICIO" FLOAT(126), 
	"VALORFIM" FLOAT(126), 
	"COR" VARCHAR2(20 CHAR), 
	"DESCRICAO" VARCHAR2(80 CHAR)
   );
--------------------------------------------------------
--  DDL for Table FASESERVICO
--------------------------------------------------------

  CREATE TABLE "FASESERVICO" 
   (	"IDFASE" NUMBER(24,0), 
	"NOMEFASE" VARCHAR2(70 CHAR), 
	"FASECAPTURA" CHAR(1 CHAR)
   );
--------------------------------------------------------
--  DDL for Table FATURA
--------------------------------------------------------

  CREATE TABLE "FATURA" 
   (	"IDFATURA" NUMBER(10,0), 
	"IDCONTRATO" NUMBER(10,0), 
	"DATAINICIAL" DATE, 
	"DATAFINAL" DATE, 
	"DESCRICAOFATURA" VARCHAR2(150 CHAR), 
	"VALORCOTACAOMOEDA" FLOAT(126), 
	"DATACRIACAO" DATE, 
	"DATAULTMODIFICACAO" DATE, 
	"VALORPREVISTOSOMAOS" FLOAT(126), 
	"VALORSOMAGLOSASOS" FLOAT(126), 
	"VALOREXECUTADOSOMAOS" FLOAT(126), 
	"OBSERVACAO" CLOB, 
	"APROVACAOGESTOR" CLOB, 
	"APROVACAOFISCAL" CLOB, 
	"SALDOPREVISTO" FLOAT(126), 
	"SITUACAOFATURA" CHAR(1 CHAR)
   );
--------------------------------------------------------
--  DDL for Table FATURAAPURACAOANS
--------------------------------------------------------

  CREATE TABLE "FATURAAPURACAOANS" 
   (	"IDFATURAAPURACAOANS" NUMBER(10,0), 
	"IDFATURA" NUMBER(10,0), 
	"IDACORDONIVELSERVICOCONTRATO" NUMBER(10,0), 
	"VALORAPURADO" FLOAT(126), 
	"DETALHAMENTO" CLOB, 
	"PERCENTUALGLOSA" FLOAT(126), 
	"VALORGLOSA" FLOAT(126), 
	"DATAAPURACAO" DATE
   );
--------------------------------------------------------
--  DDL for Table FATURAOS
--------------------------------------------------------

  CREATE TABLE "FATURAOS" 
   (	"IDFATURA" NUMBER(10,0), 
	"IDOS" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table FERIADO
--------------------------------------------------------

  CREATE TABLE "FERIADO" 
   (	"IDFERIADO" NUMBER(10,0), 
	"DATA" DATE, 
	"DESCRICAO" VARCHAR2(100 CHAR), 
	"ABRANGENCIA" CHAR(1 CHAR), 
	"IDUF" NUMBER(10,0), 
	"IDCIDADE" NUMBER(10,0), 
	"RECORRENTE" CHAR(1 CHAR)
   );
--------------------------------------------------------
--  DDL for Table FLUXO
--------------------------------------------------------

  CREATE TABLE "FLUXO" 
   (	"IDFLUXO" NUMBER(10,0), 
	"NOMEFLUXO" VARCHAR2(70 CHAR), 
	"DESCRICAO" CLOB
   );
--------------------------------------------------------
--  DDL for Table FLUXOS
--------------------------------------------------------

  CREATE TABLE "FLUXOS" 
   (	"IDFLUXO" NUMBER(10,0), 
	"NOMEFLUXO" VARCHAR2(70 CHAR)
   );
--------------------------------------------------------
--  DDL for Table FLUXOSERVICO
--------------------------------------------------------

  CREATE TABLE "FLUXOSERVICO" 
   (	"IDSERVICOCONTRATO" NUMBER(24,0), 
	"IDTIPOFLUXO" NUMBER(10,0), 
	"IDFASE" NUMBER(24,0), 
	"PRINCIPAL" CHAR(1 CHAR) DEFAULT 'N', 
	"DELETED" CHAR(1 CHAR)
   );
--------------------------------------------------------
--  DDL for Table FORMULA
--------------------------------------------------------

  CREATE TABLE "FORMULA" 
   (	"IDFORMULA" NUMBER(10,0), 
	"IDENTIFICADOR" VARCHAR2(120 CHAR), 
	"NOME" VARCHAR2(120 CHAR), 
	"CONTEUDO" CLOB, 
	"DATACRIACAO" DATE
   );
--------------------------------------------------------
--  DDL for Table FORNECEDOR
--------------------------------------------------------

  CREATE TABLE "FORNECEDOR" 
   (	"IDFORNECEDOR" NUMBER(24,0), 
	"RAZAOSOCIAL" VARCHAR2(100 CHAR), 
	"NOMEFANTASIA" VARCHAR2(70 CHAR), 
	"CNPJ" VARCHAR2(14 CHAR), 
	"EMAIL" VARCHAR2(255 CHAR), 
	"OBSERVACAO" CLOB, 
	"DELETED" CHAR(1 CHAR), 
	"TELEFONE" VARCHAR2(20 CHAR), 
	"FAX" VARCHAR2(20 CHAR), 
	"NOMECONTATO" VARCHAR2(100 CHAR), 
	"INSCRICAOESTADUAL" VARCHAR2(25 CHAR), 
	"INSCRICAOMUNICIPAL" VARCHAR2(25 CHAR), 
	"IDENDERECO" NUMBER(10,0), 
	"TIPOPESSOA" CHAR(1 CHAR)
   );
--------------------------------------------------------
--  DDL for Table FORNECEDORCOTACAO
--------------------------------------------------------

  CREATE TABLE "FORNECEDORCOTACAO" 
   (	"IDCOTACAO" NUMBER(10,0), 
	"IDFORNECEDOR" NUMBER(24,0) DEFAULT '0'
   );
--------------------------------------------------------
--  DDL for Table FORNECEDORPRODUTO
--------------------------------------------------------

  CREATE TABLE "FORNECEDORPRODUTO" 
   (	"IDFORNECEDORPRODUTO" NUMBER(10,0), 
	"IDFORNECEDOR" NUMBER(24,0), 
	"IDTIPOPRODUTO" NUMBER(10,0), 
	"IDMARCA" NUMBER(10,0), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE
   );
--------------------------------------------------------
--  DDL for Table GALERIAIMAGENS
--------------------------------------------------------

  CREATE TABLE "GALERIAIMAGENS" 
   (	"IDIMAGEM" NUMBER(10,0), 
	"IDCATEGORIAGALERIAIMAGEM" NUMBER(10,0), 
	"NOMEIMAGEM" VARCHAR2(255 CHAR), 
	"DESCRICAOIMAGEM" VARCHAR2(70 CHAR), 
	"DETALHAMENTO" CLOB, 
	"EXTENSAO" VARCHAR2(15 CHAR)
   );
--------------------------------------------------------
--  DDL for Table GLOSAOS
--------------------------------------------------------

  CREATE TABLE "GLOSAOS" 
   (	"IDGLOSAOS" NUMBER(10,0), 
	"IDOS" NUMBER(10,0), 
	"DATACRIACAO" DATE, 
	"DATAULTMODIFICACAO" DATE, 
	"DESCRICAOGLOSA" CLOB, 
	"OCORRENCIAS" CLOB, 
	"PERCAPLICADO" FLOAT(126), 
	"CUSTOGLOSA" FLOAT(126), 
	"NUMEROOCORRENCIAS" FLOAT(126), 
	"IDACORDONIVELSERVICO" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table GLOSASERVICOCONTRATO
--------------------------------------------------------

  CREATE TABLE "GLOSASERVICOCONTRATO" 
   (	"IDGLOSASERVICOCONTRATO" NUMBER(24,0), 
	"IDSERVICOCONTRATO" NUMBER(24,0), 
	"QUANTIDADEGLOSA" NUMBER(10,0), 
	"DATAFIM" DATE
   );
--------------------------------------------------------
--  DDL for Table GRUPO
--------------------------------------------------------

  CREATE TABLE "GRUPO" 
   (	"IDGRUPO" NUMBER(10,0), 
	"IDEMPRESA" NUMBER(10,0), 
	"NOME" VARCHAR2(255 CHAR), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE, 
	"DESCRICAO" CLOB, 
	"SERVICEDESK" CHAR(1 CHAR), 
	"SIGLA" VARCHAR2(20 CHAR), 
	"ABERTURA" VARCHAR2(45 CHAR), 
	"ENCERRAMENTO" VARCHAR2(45 CHAR), 
	"ANDAMENTO" VARCHAR2(45 CHAR), 
	"COMITECONSULTIVOMUDANCA" VARCHAR2(1 CHAR)
   );
--------------------------------------------------------
--  DDL for Table GRUPOATVPERIODICA
--------------------------------------------------------

  CREATE TABLE "GRUPOATVPERIODICA" 
   (	"IDGRUPOATVPERIODICA" NUMBER(10,0), 
	"NOMEGRUPOATVPERIODICA" VARCHAR2(256 CHAR), 
	"DESCGRUPOATVPERIODICA" CLOB, 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE, 
	"DELETED" CHAR(1 CHAR)
   );
--------------------------------------------------------
--  DDL for Table GRUPOITEMCONFIGURACAO
--------------------------------------------------------

  CREATE TABLE "GRUPOITEMCONFIGURACAO" 
   (	"IDGRUPOITEMCONFIGURACAO" NUMBER(10,0), 
	"NOMEGRUPOITEMCONFIGURACAO" VARCHAR2(100 CHAR), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE, 
	"EMAIL" VARCHAR2(50 CHAR), 
	"EMAILGRUPOITEMCONFIGURACAO" VARCHAR2(256 CHAR), 
	"IDGRUPOITEMCONFIGURACAOPAI" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table GRUPOQUESTIONARIO
--------------------------------------------------------

  CREATE TABLE "GRUPOQUESTIONARIO" 
   (	"IDGRUPOQUESTIONARIO" NUMBER(10,0), 
	"IDQUESTIONARIO" NUMBER(10,0), 
	"NOMEGRUPOQUESTIONARIO" VARCHAR2(80 CHAR), 
	"ORDEM" NUMBER(5,0)
   );
--------------------------------------------------------
--  DDL for Table GRUPORECURSOS
--------------------------------------------------------

  CREATE TABLE "GRUPORECURSOS" 
   (	"IDGRUPORECURSO" NUMBER(10,0), 
	"NOMEGRUPORECURSO" VARCHAR2(70 CHAR), 
	"SITUACAO" CHAR(1 CHAR), 
	"DELETED" CHAR(1 CHAR)
   );
--------------------------------------------------------
--  DDL for Table GRUPOSEMAILS
--------------------------------------------------------

  CREATE TABLE "GRUPOSEMAILS" 
   (	"IDGRUPO" NUMBER(10,0), 
	"IDEMPREGADO" NUMBER(10,0), 
	"NOME" VARCHAR2(80 CHAR), 
	"EMAIL" VARCHAR2(200 CHAR)
   );
--------------------------------------------------------
--  DDL for Table GRUPOSEMPREGADOS
--------------------------------------------------------

  CREATE TABLE "GRUPOSEMPREGADOS" 
   (	"IDGRUPO" NUMBER(10,0), 
	"IDEMPREGADO" NUMBER(10,0), 
	"ENVIAEMAIL" CHAR(1 CHAR)
   );
--------------------------------------------------------
--  DDL for Table GRUPOVISAO
--------------------------------------------------------

  CREATE TABLE "GRUPOVISAO" 
   (	"IDGRUPOVISAO" NUMBER(24,0), 
	"IDVISAO" NUMBER(24,0), 
	"DESCRICAOGRUPOVISAO" VARCHAR2(500 CHAR), 
	"FORMA" CHAR(1 CHAR), 
	"ORDEM" NUMBER(10,0), 
	"SITUACAO" CHAR(1 CHAR)
   );
--------------------------------------------------------
--  DDL for Table GRUPOVISAOCAMPOSNEGOCIO
--------------------------------------------------------

  CREATE TABLE "GRUPOVISAOCAMPOSNEGOCIO" 
   (	"IDGRUPOVISAO" NUMBER(24,0), 
	"IDCAMPOSOBJETONEGOCIO" NUMBER(24,0), 
	"DESCRICAONEGOCIO" VARCHAR2(500 CHAR), 
	"TIPONEGOCIO" VARCHAR2(20 CHAR), 
	"ORDEM" NUMBER(10,0), 
	"SITUACAO" CHAR(1 CHAR), 
	"OBRIGATORIO" CHAR(1 CHAR), 
	"TAMANHO" NUMBER(5,0), 
	"DECIMAIS" NUMBER(5,0), 
	"TIPOLIGACAO" CHAR(1 CHAR), 
	"TEXTOSQL" CLOB, 
	"TAMANHOPARAPESQ" NUMBER(5,0), 
	"FORMULA" CLOB, 
	"VISIVEL" CHAR(1 CHAR), 
	"HTMLCODE" CLOB
   );
--------------------------------------------------------
--  DDL for Table GRUPOVISAOCAMPOSNEGOCIOINFOSQL
--------------------------------------------------------

  CREATE TABLE "GRUPOVISAOCAMPOSNEGOCIOINFOSQL" 
   (	"IDGRUPOVISAOCAMPOSNEGOCIOINFOS" NUMBER(24,0), 
	"IDGRUPOVISAO" NUMBER(24,0), 
	"IDCAMPOSOBJETONEGOCIO" NUMBER(24,0), 
	"CAMPO" VARCHAR2(150 CHAR), 
	"TIPOLIGACAO" CHAR(1 CHAR), 
	"FILTRO" CLOB, 
	"DESCRICAO" VARCHAR2(400 CHAR)
   );
--------------------------------------------------------
--  DDL for Table GRUPOVISAOCAMPOSNEGOCIOLIGACAO
--------------------------------------------------------

  CREATE TABLE "GRUPOVISAOCAMPOSNEGOCIOLIGACAO" 
   (	"IDGRPVISCAMPOSNEGLIGACA" NUMBER(24,0), 
	"IDGRUPOVISAO" NUMBER(24,0), 
	"IDCAMPOSOBJETONEGOCIO" NUMBER(24,0), 
	"IDCAMPOSOBJETONEGOCIOLIGACAO" NUMBER(24,0), 
	"TIPOLIGACAO" CHAR(1 CHAR), 
	"FILTRO" CLOB, 
	"DESCRICAO" VARCHAR2(400 CHAR)
   );
--------------------------------------------------------
--  DDL for Table HILOSEQUENCES
--------------------------------------------------------

  CREATE TABLE "HILOSEQUENCES" 
   (	"SEQUENCENAME" VARCHAR2(50 CHAR), 
	"HIGHVALUES" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table HISTORICOBASECONHECIMENTO
--------------------------------------------------------

  CREATE TABLE "HISTORICOBASECONHECIMENTO" 
   (	"IDHISTORICOBASECONHECIMENTO" NUMBER(10,0), 
	"IDBASECONHECIMENTO" NUMBER(10,0), 
	"IDPASTA" NUMBER(10,0), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE, 
	"TITULO" VARCHAR2(256 CHAR), 
	"CONTEUDO" CLOB, 
	"STATUS" CHAR(1 CHAR), 
	"IDBASECONHECIMENTOPAI" NUMBER(10,0), 
	"DATAEXPIRACAO" DATE, 
	"VERSAO" VARCHAR2(45 CHAR), 
	"IDUSUARIOAUTOR" NUMBER(10,0), 
	"IDUSUARIOAPROVADOR" NUMBER(10,0), 
	"FONTEREFERENCIA" VARCHAR2(255 CHAR), 
	"IDNOTIFICACAO" NUMBER(10,0), 
	"DATAPUBLICACAO" DATE, 
	"JUSTIFICATIVAOBSERVACAO" VARCHAR2(500 CHAR), 
	"FAQ" VARCHAR2(45 CHAR), 
	"ORIGEM" CHAR(1 CHAR), 
	"ARQUIVADO" VARCHAR2(45 CHAR), 
	"IDUSUARIOALTERACAO" NUMBER(10,0), 
	"DATAHORAALTERACAO" DATE, 
	"CONTEUDOSEMFORMATACAO" CLOB
   );
--------------------------------------------------------
--  DDL for Table HISTORICOEXECUCAO
--------------------------------------------------------

  CREATE TABLE "HISTORICOEXECUCAO" 
   (	"IDHISTORICO" NUMBER(10,0), 
	"IDEXECUCAO" NUMBER(10,0), 
	"DATA" DATE, 
	"SITUACAO" CHAR(1 CHAR), 
	"IDEMPREGADOEXECUTOR" NUMBER(10,0), 
	"DETALHAMENTO" CLOB, 
	"HORA" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table HISTORICOIC
--------------------------------------------------------

  CREATE TABLE "HISTORICOIC" 
   (	"IDHISTORICOIC" NUMBER(10,0), 
	"IDITEMCONFIGURACAO" NUMBER(10,0), 
	"IDENTIFICACAO" VARCHAR2(400 CHAR), 
	"IDITEMCONFIGURACAOPAI" NUMBER(10,0), 
	"IDTIPOITEMCONFIGURACAO" NUMBER(10,0), 
	"IDGRUPOITEMCONFIGURACAO" NUMBER(10,0), 
	"IDPROPRIETARIO" NUMBER(10,0), 
	"VERSAO" VARCHAR2(250 CHAR), 
	"FAMILIA" VARCHAR2(250 CHAR), 
	"IDFAMILIAITEMCONFIGURACAO" NUMBER(10,0), 
	"CLASSE" VARCHAR2(250 CHAR), 
	"IDCLASSEITEMCONFIGURACAO" NUMBER(10,0), 
	"LOCALIDADE" VARCHAR2(250 CHAR), 
	"STATUS" NUMBER(10,0), 
	"CRITICIDADE" NUMBER(10,0), 
	"NUMEROSERIE" VARCHAR2(45 CHAR), 
	"DATAEXPIRACAO" DATE, 
	"IDMUDANCA" NUMBER(10,0), 
	"IDPROBLEMA" NUMBER(10,0), 
	"IDINCIDENTE" NUMBER(10,0), 
	"IDAUTORALTERACAO" NUMBER(10,0), 
	"DATAHORAALTERACAO" DATE DEFAULT SYSDATE, 
	"BASELINE" VARCHAR2(30 CHAR), 
	"RESTAURACAO" NUMBER(10,0), 
	"IDMIDIASOFTWARE" NUMBER(10,0), 
	"IMPACTO" VARCHAR2(255 CHAR), 
	"URGENCIA" VARCHAR2(255 CHAR), 
	"HISTORICOVERSAO" DECIMAL(5, 2)
   );
--------------------------------------------------------
--  DDL for Table HISTORICOSITUACAOCOTACAO
--------------------------------------------------------

  CREATE TABLE "HISTORICOSITUACAOCOTACAO" 
   (	"IDHISTORICO" NUMBER(10,0), 
	"IDCOTACAO" NUMBER(10,0), 
	"IDRESPONSAVEL" NUMBER(10,0), 
	"DATAHORA" DATE DEFAULT SYSDATE, 
	"SITUACAO" VARCHAR2(25 CHAR)
   );
--------------------------------------------------------
--  DDL for Table HISTORICOTENTATIVA
--------------------------------------------------------

  CREATE TABLE "HISTORICOTENTATIVA" 
   (	"IDHISTORICOTENTATIVA" NUMBER(10,0), 
	"IDITEMCONFIGURACAO" NUMBER(10,0), 
	"IDBASEITEMCONFIGURACAO" NUMBER(10,0), 
	"IDEVENTO" NUMBER(10,0), 
	"IDEMPREGADO" NUMBER(10,0), 
	"DESCRICAO" VARCHAR2(255 CHAR), 
	"DATA" DATE, 
	"HORA" CHAR(4 CHAR)
   );
--------------------------------------------------------
--  DDL for Table HISTORICOVALOR
--------------------------------------------------------

  CREATE TABLE "HISTORICOVALOR" 
   (	"IDHISTORICOVALOR" NUMBER(10,0), 
	"IDVALOR" NUMBER(10,0), 
	"IDITEMCONFIGURACAO" NUMBER(10,0), 
	"IDCARACTERISTICA" NUMBER(10,0), 
	"VALORSTR" VARCHAR2(4000 CHAR), 
	"VALORLONGO" CLOB, 
	"VALORDECIMAL" FLOAT(126), 
	"VALORDATE" DATE, 
	"IDBASEITEMCONFIGURACAO" NUMBER(10,0), 
	"DATAHORAALTERACAO" DATE DEFAULT SYSDATE, 
	"IDAUTORALTERACAO" NUMBER(10,0), 
	"BASELINE" VARCHAR2(30 CHAR), 
	"IDHISTORICOIC" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table HTMLCODEVISAO
--------------------------------------------------------

  CREATE TABLE "HTMLCODEVISAO" 
   (	"IDHTMLCODEVISAO" NUMBER(24,0), 
	"IDVISAO" NUMBER(24,0), 
	"HTMLCODETYPE" CHAR(30 CHAR), 
	"HTMLCODE" CLOB
   );
--------------------------------------------------------
--  DDL for Table IMAGEMHISTORICO
--------------------------------------------------------

  CREATE TABLE "IMAGEMHISTORICO" 
   (	"IDIMAGEM" NUMBER(10,0), 
	"DATA" DATE, 
	"NOMEARQUIVO" VARCHAR2(255 CHAR), 
	"OBSERVACAO" CLOB, 
	"IDCONTRATO" NUMBER(10,0), 
	"IDPROFISSIONAL" NUMBER(10,0), 
	"IDEMPRESA" NUMBER(10,0), 
	"ABA" VARCHAR2(30 CHAR)
   );
--------------------------------------------------------
--  DDL for Table IMAGEMITEMCONFIGURACAO
--------------------------------------------------------

  CREATE TABLE "IMAGEMITEMCONFIGURACAO" 
   (	"IDIMAGEMITEMCONFIGURACAO" NUMBER(10,0), 
	"IDSERVICO" NUMBER(10,0), 
	"IDITEMCONFIGURACAO" NUMBER(10,0), 
	"POSX" NUMBER(10,0), 
	"POSY" NUMBER(10,0), 
	"DESCRICAO" VARCHAR2(256 CHAR), 
	"CAMINHOIMAGEM" VARCHAR2(256 CHAR), 
	"IDIMAGEMITEMCONFIGURACAOPAI" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table IMAGEMSERVICORELACIONADO
--------------------------------------------------------

  CREATE TABLE "IMAGEMSERVICORELACIONADO" 
   (	"IDIMAGEMSERVICORELACIONADO" NUMBER(10,0), 
	"IDSERVICO" NUMBER(10,0), 
	"IDSERVICORELACIONADO" NUMBER(10,0), 
	"POSX" NUMBER(10,0), 
	"POSY" NUMBER(10,0), 
	"DESCRICAO" VARCHAR2(256 CHAR), 
	"CAMINHOIMAGEM" VARCHAR2(256 CHAR), 
	"IDIMAGEMSERVICORELACIONADOPAI" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table IMPACTO
--------------------------------------------------------

  CREATE TABLE "IMPACTO" 
   (	"IDIMPACTO" NUMBER(10,0), 
	"NIVELIMPACTO" VARCHAR2(100 CHAR), 
	"SIGLAIMPACTO" CHAR(2 CHAR)
   );
--------------------------------------------------------
--  DDL for Table IMPORTANCIACONHECIMENTOGRUPO
--------------------------------------------------------

  CREATE TABLE "IMPORTANCIACONHECIMENTOGRUPO" 
   (	"IDBASECONHECIMENTO" NUMBER(10,0), 
	"IDGRUPO" NUMBER(10,0), 
	"GRAUIMPORTANCIAGRUPO" VARCHAR2(45 CHAR)
   );
--------------------------------------------------------
--  DDL for Table IMPORTANCIACONHECIMENTOUSUARIO
--------------------------------------------------------

  CREATE TABLE "IMPORTANCIACONHECIMENTOUSUARIO" 
   (	"IDBASECONHECIMENTO" NUMBER(10,0), 
	"IDUSUARIO" NUMBER(10,0), 
	"GRAUIMPORTANCIAUSUARIO" VARCHAR2(45 CHAR)
   );
--------------------------------------------------------
--  DDL for Table IMPORTANCIANEGOCIO
--------------------------------------------------------

  CREATE TABLE "IMPORTANCIANEGOCIO" 
   (	"IDIMPORTANCIANEGOCIO" NUMBER(10,0), 
	"IDEMPRESA" NUMBER(10,0), 
	"NOMEIMPORTANCIANEGOCIO" VARCHAR2(100 CHAR), 
	"SITUACAO" CHAR(1 CHAR)
   );
--------------------------------------------------------
--  DDL for Table IMPORTCONFIG
--------------------------------------------------------

  CREATE TABLE "IMPORTCONFIG" 
   (	"IDIMPORTCONFIG" NUMBER(10,0), 
	"TIPO" CHAR(1 CHAR), 
	"IDEXTERNALCONNECTION" NUMBER(10,0), 
	"TABELAORIGEM" VARCHAR2(255 CHAR), 
	"TABELADESTINO" VARCHAR2(255 CHAR), 
	"FILTROORIGEM" CLOB, 
	"NOME" VARCHAR2(100 CHAR)
   );
--------------------------------------------------------
--  DDL for Table IMPORTCONFIGCAMPOS
--------------------------------------------------------

  CREATE TABLE "IMPORTCONFIGCAMPOS" 
   (	"IDIMPORTCONFIGCAMPO" NUMBER(10,0), 
	"IDIMPORTCONFIG" NUMBER(10,0), 
	"ORIGEM" VARCHAR2(255 CHAR), 
	"DESTINO" VARCHAR2(255 CHAR), 
	"SCRIPT" CLOB
   );
--------------------------------------------------------
--  DDL for Table INFOCATALOGOSERVICO
--------------------------------------------------------

  CREATE TABLE "INFOCATALOGOSERVICO" 
   (	"IDINFOCATALOGOSERVICO" NUMBER(10,0), 
	"IDCATALOGOSERVICO" NUMBER(10,0), 
	"DESCINFOCATALOGOSERVICO" CLOB, 
	"NOMEINFOCATALOGOSERVICO" VARCHAR2(200 CHAR)
   );
--------------------------------------------------------
--  DDL for Table INFORMACAOSERVICO
--------------------------------------------------------

  CREATE TABLE "INFORMACAOSERVICO" 
   (	"IDINFORMACAOSERVICO" NUMBER(24,0), 
	"IDSERVICO" NUMBER(24,0), 
	"USUARIO" VARCHAR2(255 CHAR), 
	"TITULO" VARCHAR2(255 CHAR), 
	"TEXTO" VARCHAR2(255 CHAR), 
	"SITUACAO" VARCHAR2(255 CHAR), 
	"DELETED" VARCHAR2(255 CHAR)
   );
--------------------------------------------------------
--  DDL for Table INFORMACOESCONTRATOCONFIG
--------------------------------------------------------

  CREATE TABLE "INFORMACOESCONTRATOCONFIG" 
   (	"IDINFORMACOESCONTRATOCONFIG" NUMBER(10,0), 
	"IDINFORMACOESCONTRATOCONFIGPAI" NUMBER(10,0), 
	"NOME" VARCHAR2(50 CHAR), 
	"DESCRICAO" VARCHAR2(70 CHAR), 
	"FUNCIONALIDADEPATH" VARCHAR2(255 CHAR), 
	"FUNCITEM" CHAR(1 CHAR), 
	"IDQUESTIONARIO" NUMBER(10,0), 
	"IDEMPRESA" NUMBER(10,0), 
	"SITUACAO" CHAR(1 CHAR), 
	"ORDEM" NUMBER(5,0), 
	"INFOADICIONAL" CLOB, 
	"FUNCADICIONALAPOSGRAVACAO" VARCHAR2(255 CHAR), 
	"CHAMARFUNCADDAPOSGRAVAR" CHAR(1 CHAR), 
	"CHAMARFUNCADDHISTORICO" CHAR(1 CHAR), 
	"ICONEFUNCHISTORICO" VARCHAR2(255 CHAR), 
	"ICONEFUNCHISTORICOFINAL" VARCHAR2(255 CHAR), 
	"VALIDACOES" CLOB, 
	"SEGURANCAUNIDADE" CHAR(1 CHAR), 
	"SEGURANCAUNIDADEPCMSO" CHAR(1 CHAR), 
	"SEGURANCAUNIDADEENFERM" CHAR(1 CHAR)
   );
--------------------------------------------------------
--  DDL for Table INFORMACOESCONTRATOPERFSEG
--------------------------------------------------------

  CREATE TABLE "INFORMACOESCONTRATOPERFSEG" 
   (	"IDINFORMACOESCONTRATOCONFIG" NUMBER(10,0), 
	"IDPERFILSEGURANCA" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table INSPECAOENTREGAITEM
--------------------------------------------------------

  CREATE TABLE "INSPECAOENTREGAITEM" 
   (	"IDENTREGA" NUMBER(10,0), 
	"IDCRITERIO" NUMBER(10,0), 
	"IDRESPONSAVEL" NUMBER(10,0), 
	"DATAHORAINSPECAO" DATE DEFAULT SYSDATE, 
	"AVALIACAO" VARCHAR2(25 CHAR), 
	"OBSERVACOES" CLOB
   );
--------------------------------------------------------
--  DDL for Table INSPECAOPEDIDOCOMPRA
--------------------------------------------------------

  CREATE TABLE "INSPECAOPEDIDOCOMPRA" 
   (	"IDPEDIDO" NUMBER(10,0), 
	"IDCRITERIO" NUMBER(10,0), 
	"IDRESPONSAVEL" NUMBER(10,0), 
	"DATAHORAINSPECAO" DATE DEFAULT SYSDATE, 
	"AVALIACAO" VARCHAR2(25 CHAR), 
	"OBSERVACOES" CLOB
   );
--------------------------------------------------------
--  DDL for Table INSTALACAO
--------------------------------------------------------

  CREATE TABLE "INSTALACAO"
   (    "IDINSTALACAO" NUMBER(10,0),
    "SUCESSO" CHAR(1 CHAR),
    "PASSO" VARCHAR2(256 CHAR)
   );
--------------------------------------------------------
--  DDL for Table INVENTARIOXML
--------------------------------------------------------

  CREATE TABLE "INVENTARIOXML" 
   (	"IDINVENTARIOXML" NUMBER(10,0), 
	"CONTEUDO" CLOB, 
	"IDNETMAP" NUMBER(10,0), 
	"DATAINICIAL" DATE, 
	"DATAFINAL" DATE, 
	"NOME" VARCHAR2(256 CHAR)
   );
--------------------------------------------------------
--  DDL for Table ITEMCFGSOLICITACAOSERV
--------------------------------------------------------

  CREATE TABLE "ITEMCFGSOLICITACAOSERV" 
   (	"IDITEMCONFIGURACAO" NUMBER(10,0), 
	"IDSOLICITACAOSERVICO" NUMBER(24,0), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE
   );
--------------------------------------------------------
--  DDL for Table ITEMCONFIGURACAO
--------------------------------------------------------

  CREATE TABLE "ITEMCONFIGURACAO" 
   (	"IDITEMCONFIGURACAO" NUMBER(10,0), 
	"IDENTIFICACAO" VARCHAR2(400 CHAR), 
	"IDITEMCONFIGURACAOPAI" NUMBER(10,0), 
	"IDTIPOITEMCONFIGURACAO" NUMBER(10,0), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE, 
	"IDGRUPOITEMCONFIGURACAO" NUMBER(10,0), 
	"IDPROPRIETARIO" NUMBER(10,0), 
	"DATAEXPIRACAO" DATE, 
	"VERSAO" VARCHAR2(50 CHAR), 
	"FAMILIA" VARCHAR2(250 CHAR), 
	"CLASSE" VARCHAR2(250 CHAR), 
	"LOCALIDADE" VARCHAR2(250 CHAR), 
	"STATUS" NUMBER(10,0), 
	"CRITICIDADE" NUMBER(10,0), 
	"NUMEROSERIE" VARCHAR2(45 CHAR), 
	"IDMUDANCA" NUMBER(10,0), 
	"IDPROBLEMA" NUMBER(10,0), 
	"IDINCIDENTE" NUMBER(10,0), 
	"IDMIDIASOFTWARE" NUMBER(10,0), 
	"IMPACTO" VARCHAR2(255 CHAR), 
	"URGENCIA" VARCHAR2(255 CHAR), 
	"IDBASECONHECIMENTO" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table ITEMCONFIGURACAOEVENTO
--------------------------------------------------------

  CREATE TABLE "ITEMCONFIGURACAOEVENTO" 
   (	"IDITEMCONFIGURACAOEVENTO" NUMBER(10,0), 
	"IDBASEITEMCONFIGURACAO" NUMBER(10,0), 
	"IDITEMCONFIGURACAO" NUMBER(10,0), 
	"IDEVENTO" NUMBER(10,0), 
	"TIPOEXECUCAO" CHAR(1 CHAR), 
	"GERARQUANDO" CHAR(1 CHAR), 
	"DATA" DATE, 
	"HORA" CHAR(4 CHAR), 
	"LINHACOMANDO" VARCHAR2(255 CHAR), 
	"LINHACOMANDOLINUX" VARCHAR2(255 CHAR)
   );
--------------------------------------------------------
--  DDL for Table ITEMCOTACAO
--------------------------------------------------------

  CREATE TABLE "ITEMCOTACAO" 
   (	"IDITEMCOTACAO" NUMBER(10,0), 
	"IDCOTACAO" NUMBER(10,0), 
	"IDPRODUTO" NUMBER(10,0), 
	"TIPOIDENTIFICACAO" CHAR(1 CHAR), 
	"QUANTIDADE" FLOAT(126), 
	"SITUACAO" VARCHAR2(20 CHAR), 
	"DATAHORALIMITE" DATE DEFAULT SYSDATE, 
	"IDCATEGORIAPRODUTO" NUMBER(10,0), 
	"IDUNIDADEMEDIDA" NUMBER(10,0), 
	"DESCRICAOITEM" VARCHAR2(200 CHAR), 
	"ESPECIFICACOES" CLOB, 
	"MARCAPREFERENCIAL" VARCHAR2(100 CHAR), 
	"PRECOAPROXIMADO" FLOAT(126), 
	"SOLICITACOESATENDIDAS" CLOB, 
	"RESULTADOVALIDACAO" CHAR(1 CHAR), 
	"MENSAGENSVALIDACAO" CLOB, 
	"PESOPRECO" NUMBER(10,0), 
	"PESOPRAZOENTREGA" NUMBER(10,0), 
	"PESOPRAZOPAGTO" NUMBER(10,0), 
	"PESOTAXAJUROS" NUMBER(10,0), 
	"PESOPRAZOGARANTIA" NUMBER(10,0), 
	"EXIGEFORNECEDORQUALIFICADO" CHAR(1 CHAR)
   );
--------------------------------------------------------
--  DDL for Table ITEMPEDIDOCOMPRA
--------------------------------------------------------

  CREATE TABLE "ITEMPEDIDOCOMPRA" 
   (	"IDITEMPEDIDO" NUMBER(10,0), 
	"IDPEDIDO" NUMBER(10,0), 
	"IDPRODUTO" NUMBER(10,0), 
	"IDCOLETAPRECO" NUMBER(10,0), 
	"QUANTIDADE" FLOAT(126), 
	"VALORTOTAL" FLOAT(126), 
	"VALORDESCONTO" FLOAT(126), 
	"VALORACRESCIMO" FLOAT(126), 
	"BASECALCULOICMS" FLOAT(126), 
	"ALIQUOTAICMS" FLOAT(126), 
	"ALIQUOTAIPI" FLOAT(126)
   );
--------------------------------------------------------
--  DDL for Table ITEMREQUISICAOPRODUTO
--------------------------------------------------------

  CREATE TABLE "ITEMREQUISICAOPRODUTO" 
   (	"IDITEMREQUISICAOPRODUTO" NUMBER(10,0), 
	"IDSOLICITACAOSERVICO" NUMBER(10,0), 
	"IDPARECERVALIDACAO" NUMBER(10,0), 
	"IDPARECERAUTORIZACAO" NUMBER(10,0), 
	"IDCATEGORIAPRODUTO" NUMBER(10,0), 
	"IDUNIDADEMEDIDA" NUMBER(10,0), 
	"IDPRODUTO" NUMBER(10,0), 
	"IDITEMCOTACAO" NUMBER(10,0), 
	"DESCRICAOITEM" VARCHAR2(200 CHAR), 
	"ESPECIFICACOES" CLOB, 
	"QUANTIDADE" FLOAT(126), 
	"MARCAPREFERENCIAL" VARCHAR2(100 CHAR), 
	"PRECOAPROXIMADO" FLOAT(126), 
	"SITUACAO" VARCHAR2(20 CHAR), 
	"PERCVARIACAOPRECO" FLOAT(126), 
	"QTDEAPROVADA" FLOAT(126), 
	"TIPOATENDIMENTO" CHAR(1 CHAR), 
	"TIPOIDENTIFICACAO" CHAR(1 CHAR), 
	"APROVACOTACAO" CHAR(1 CHAR), 
	"QTDECOTADA" FLOAT(126), 
	"VALORAPROVADO" FLOAT(126)
   );

   COMMENT ON COLUMN "ITEMREQUISICAOPRODUTO"."TIPOATENDIMENTO" IS 'C - Cotação
            E - Estoque';
--------------------------------------------------------
--  DDL for Table JORNADATRABALHO
--------------------------------------------------------

  CREATE TABLE "JORNADATRABALHO" 
   (	"IDJORNADA" NUMBER(10,0), 
	"DESCRICAO" VARCHAR2(70 CHAR), 
	"INICIO1" CHAR(5 CHAR), 
	"TERMINO1" CHAR(5 CHAR), 
	"INICIO2" CHAR(5 CHAR), 
	"TERMINO2" CHAR(5 CHAR), 
	"INICIO3" CHAR(5 CHAR), 
	"TERMINO3" CHAR(5 CHAR), 
	"INICIO4" CHAR(5 CHAR), 
	"TERMINO4" CHAR(5 CHAR), 
	"INICIO5" CHAR(5 CHAR), 
	"TERMINO5" CHAR(5 CHAR), 
	"CARGAHORARIA" CHAR(5 CHAR), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE
   );
--------------------------------------------------------
--  DDL for Table JUSTIFICACAOFALHA
--------------------------------------------------------

  CREATE TABLE "JUSTIFICACAOFALHA" 
   (	"IDJUSTIFICACAOFALHA" NUMBER(10,0), 
	"IDITEMCONFIGURACAO" NUMBER(10,0), 
	"IDBASEITEMCONFIGURACAO" NUMBER(10,0), 
	"IDEVENTO" NUMBER(10,0), 
	"IDEMPREGADO" NUMBER(10,0), 
	"IDHISTORICOTENTATIVA" NUMBER(10,0), 
	"DESCRICAO" CLOB, 
	"DATA" DATE, 
	"HORA" CHAR(4 CHAR)
   );
--------------------------------------------------------
--  DDL for Table JUSTIFICATIVAMUDANCA
--------------------------------------------------------

  CREATE TABLE "JUSTIFICATIVAMUDANCA" 
   (	"IDJUSTIFICATIVAMUDANCA" NUMBER(10,0), 
	"DESCRICAOJUSTIFICATIVA" VARCHAR2(100 CHAR), 
	"SUSPENSAO" CHAR(1 CHAR), 
	"SITUACAO" CHAR(1 CHAR), 
	"APROVACAO" CHAR(1 CHAR), 
	"DELETED" CHAR(1 CHAR)
   );
--------------------------------------------------------
--  DDL for Table JUSTIFICATIVAPARECER
--------------------------------------------------------

  CREATE TABLE "JUSTIFICATIVAPARECER" 
   (	"IDJUSTIFICATIVA" NUMBER(10,0), 
	"DESCRICAOJUSTIFICATIVA" VARCHAR2(100 CHAR), 
	"SITUACAO" CHAR(1 CHAR), 
	"APLICAVELREQUISICAO" CHAR(1 CHAR), 
	"APLICAVELCOTACAO" CHAR(1 CHAR), 
	"APLICAVELINSPECAO" CHAR(1 CHAR)
   );
--------------------------------------------------------
--  DDL for Table JUSTIFICATIVASOLICITACAO
--------------------------------------------------------

  CREATE TABLE "JUSTIFICATIVASOLICITACAO" 
   (	"IDJUSTIFICATIVA" NUMBER(10,0), 
	"DESCRICAOJUSTIFICATIVA" VARCHAR2(100 CHAR), 
	"SUSPENSAO" CHAR(1 CHAR), 
	"SITUACAO" CHAR(1 CHAR), 
	"DELETED" CHAR(1 CHAR), 
	"APROVACAO" CHAR(1 CHAR)
   );
--------------------------------------------------------
--  DDL for Table LIBERACAO
--------------------------------------------------------

  CREATE TABLE "LIBERACAO" 
   (	"IDLIBERACAO" NUMBER(10,0), 
	"IDSOLICITANTE" NUMBER(10,0), 
	"IDRESPONSAVEL" NUMBER(10,0), 
	"TITULO" VARCHAR2(100 CHAR), 
	"DESCRICAO" CLOB, 
	"DATAINICIAL" DATE, 
	"DATAFINAL" DATE, 
	"DATALIBERACAO" DATE, 
	"SITUACAO" CHAR(1 CHAR), 
	"RISCO" CHAR(1 CHAR), 
	"VERSAO" VARCHAR2(25 CHAR)
   );

   COMMENT ON COLUMN "LIBERACAO"."SITUACAO" IS 'A - Aceita
            E - Em execução
            F - Finalizada
            X - Cancelada';
   COMMENT ON COLUMN "LIBERACAO"."RISCO" IS 'B - Baixo
            M - Médio
            A - Alto';
--------------------------------------------------------
--  DDL for Table LIBERACAOMUDANCA
--------------------------------------------------------

  CREATE TABLE "LIBERACAOMUDANCA" 
   (	"IDLIBERACAO" NUMBER(10,0), 
	"IDREQUISICAOMUDANCA" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table LIMITEALCADA
--------------------------------------------------------

  CREATE TABLE "LIMITEALCADA" 
   (	"IDLIMITEALCADA" NUMBER(10,0), 
	"IDALCADA" NUMBER(10,0), 
	"IDGRUPO" NUMBER(10,0), 
	"TIPOLIMITE" CHAR(1 CHAR), 
	"ABRANGENCIACENTROCUSTO" VARCHAR2(20 CHAR), 
	"LIMITEVALORITEM" FLOAT(126), 
	"LIMITEVALORMENSAL" FLOAT(126), 
	"SITUACAO" CHAR(1 CHAR)
   );

   COMMENT ON COLUMN "LIMITEALCADA"."TIPOLIMITE" IS 'F - Por faixa de valores
            Q - Qualquer valor
            ';
   COMMENT ON COLUMN "LIMITEALCADA"."ABRANGENCIACENTROCUSTO" IS 'T - Todos
            R - Somente o responsável';
--------------------------------------------------------
--  DDL for Table LINGUA
--------------------------------------------------------

  CREATE TABLE "LINGUA" 
   (	"IDLINGUA" NUMBER(10,0), 
	"NOME" VARCHAR2(245 CHAR), 
	"SIGLA" VARCHAR2(245 CHAR), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE
   );
--------------------------------------------------------
--  DDL for Table LOCALEXECUCAOSERVICO
--------------------------------------------------------

  CREATE TABLE "LOCALEXECUCAOSERVICO" 
   (	"IDLOCALEXECUCAOSERVICO" NUMBER(10,0), 
	"NOMELOCALEXECUCAOSERVICO" VARCHAR2(70 CHAR), 
	"DELETED" CHAR(1 CHAR)
   );
--------------------------------------------------------
--  DDL for Table LOCALIDADE
--------------------------------------------------------

  CREATE TABLE "LOCALIDADE" 
   (	"IDLOCALIDADE" NUMBER(10,0), 
	"NOMELOCALIDADE" VARCHAR2(255 CHAR), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE
   );
--------------------------------------------------------
--  DDL for Table LOCALIDADEUNIDADE
--------------------------------------------------------

  CREATE TABLE "LOCALIDADEUNIDADE" 
   (	"IDLOCALIDADEUNIDADE" NUMBER(10,0), 
	"IDUNIDADE" NUMBER(10,0), 
	"IDLOCALIDADE" NUMBER(10,0), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE
   );
--------------------------------------------------------
--  DDL for Table LOGDADOS
--------------------------------------------------------

  CREATE TABLE "LOGDADOS" 
   (	"IDLOG" NUMBER(10,0), 
	"DTATUALIZACAO" DATE, 
	"OPERACAO" VARCHAR2(100 CHAR), 
	"DADOS" CLOB, 
	"IDUSUARIO" NUMBER(10,0), 
	"LOCALORIGEM" VARCHAR2(255 CHAR), 
	"NOMETABELA" VARCHAR2(255 CHAR), 
	"LOGDADOSCOL" VARCHAR2(45 CHAR), 
	"DATALOG" DATE DEFAULT SYSDATE
   );
--------------------------------------------------------
--  DDL for Table MARCA
--------------------------------------------------------

  CREATE TABLE "MARCA" 
   (	"IDMARCA" NUMBER(10,0), 
	"IDFABRICANTE" NUMBER(24,0), 
	"NOMEMARCA" VARCHAR2(100 CHAR), 
	"SITUACAO" CHAR(1 CHAR)
   );
--------------------------------------------------------
--  DDL for Table MATRIZPRIORIDADE
--------------------------------------------------------

  CREATE TABLE "MATRIZPRIORIDADE" 
   (	"IDMATRIZPRIORIDADE" NUMBER(10,0), 
	"SIGLAIMPACTO" CHAR(2 CHAR), 
	"SIGLAURGENCIA" CHAR(2 CHAR), 
	"VALORPRIORIDADE" NUMBER(10,0), 
	"IDCONTRATO" NUMBER(10,0), 
	"DELETED" CHAR(1 CHAR)
   );
--------------------------------------------------------
--  DDL for Table MATRIZVISAO
--------------------------------------------------------

  CREATE TABLE "MATRIZVISAO" 
   (	"IDMATRIZ" NUMBER(24,0), 
	"IDVISAO" NUMBER(24,0), 
	"IDOBJETONEGOCIO" NUMBER(24,0), 
	"IDCAMPOSOBJETONEGOCIO1" NUMBER(24,0), 
	"IDCAMPOSOBJETONEGOCIO2" NUMBER(24,0), 
	"IDCAMPOSOBJETONEGOCIO3" NUMBER(24,0), 
	"STRINFO" CLOB, 
	"NOMECAMPO1" VARCHAR2(255 CHAR), 
	"NOMECAMPO2" VARCHAR2(255 CHAR), 
	"NOMECAMPO3" VARCHAR2(255 CHAR), 
	"DESCRICAOCAMPO1" VARCHAR2(255 CHAR), 
	"DESCRICAOCAMPO2" VARCHAR2(255 CHAR), 
	"DESCRICAOCAMPO3" VARCHAR2(255 CHAR)
   );
--------------------------------------------------------
--  DDL for Table MENU
--------------------------------------------------------

  CREATE TABLE "MENU" 
   (	"IDMENU" NUMBER(10,0), 
	"IDMENUPAI" NUMBER(10,0), 
	"NOME" VARCHAR2(256 CHAR), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE, 
	"DESCRICAO" VARCHAR2(256 CHAR), 
	"ORDEM" NUMBER(10,0), 
	"LINK" VARCHAR2(256 CHAR), 
	"IMAGEM" VARCHAR2(256 CHAR), 
	"HORIZONTAL" VARCHAR2(10 CHAR), 
	"MENURAPIDO" VARCHAR2(45 CHAR)
   );
--------------------------------------------------------
--  DDL for Table MEUCATALOGO
--------------------------------------------------------

  CREATE TABLE "MEUCATALOGO" 
   (	"IDUSUARIO" NUMBER(10,0), 
	"IDSERVICO" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table MIDIA
--------------------------------------------------------

  CREATE TABLE "MIDIA" 
   (	"IDMIDIA" NUMBER(10,0), 
	"NOME" VARCHAR2(200 CHAR), 
	"MIDIACOL" VARCHAR2(45 CHAR)
   );
--------------------------------------------------------
--  DDL for Table MIDIASOFTWARE
--------------------------------------------------------

  CREATE TABLE "MIDIASOFTWARE" 
   (	"IDMIDIASOFTWARE" NUMBER(10,0), 
	"NOME" VARCHAR2(200 CHAR), 
	"ENDFISICO" VARCHAR2(500 CHAR), 
	"VERSAO" VARCHAR2(20 CHAR), 
	"ENDLOGICO" VARCHAR2(200 CHAR), 
	"LICENCAS" NUMBER(10,0), 
	"IDMIDIA" NUMBER(10,0), 
	"IDTIPOSOFTWARE" NUMBER(10,0), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE
   );
--------------------------------------------------------
--  DDL for Table MODELOSEMAILS
--------------------------------------------------------

  CREATE TABLE "MODELOSEMAILS" 
   (	"IDMODELOEMAIL" NUMBER(10,0), 
	"TITULO" VARCHAR2(100 CHAR), 
	"TEXTO" CLOB, 
	"SITUACAO" CHAR(1 CHAR), 
	"IDENTIFICADOR" VARCHAR2(20 CHAR)
   );
--------------------------------------------------------
--  DDL for Table MOEDAS
--------------------------------------------------------

  CREATE TABLE "MOEDAS" 
   (	"IDMOEDA" NUMBER(10,0), 
	"NOMEMOEDA" VARCHAR2(50 CHAR)
   );
--------------------------------------------------------
--  DDL for Table MOTIVOSUSPENSAOATIVID
--------------------------------------------------------

  CREATE TABLE "MOTIVOSUSPENSAOATIVID" 
   (	"IDMOTIVO" NUMBER(10,0), 
	"DESCRICAO" VARCHAR2(100 CHAR)
   );
--------------------------------------------------------
--  DDL for Table NAGIOSCONEXAO
--------------------------------------------------------

  CREATE TABLE "NAGIOSCONEXAO" 
   (	"IDNAGIOSCONEXAO" NUMBER(10,0), 
	"NOME" VARCHAR2(255 CHAR), 
	"NOMEJNDI" VARCHAR2(255 CHAR), 
	"CRIADOPOR" VARCHAR2(255 CHAR), 
	"MODIFICADOPOR" VARCHAR2(255 CHAR), 
	"DATACRIACAO" DATE, 
	"ULTMODIFICACAO" DATE, 
	"DELETED" CHAR(1 CHAR)
   );
--------------------------------------------------------
--  DDL for Table NETMAP
--------------------------------------------------------

  CREATE TABLE "NETMAP" 
   (	"IDNETMAP" NUMBER(10,0), 
	"IP" VARCHAR2(50 CHAR), 
	"MASK" VARCHAR2(50 CHAR), 
	"MAC" VARCHAR2(50 CHAR), 
	"DATE_" DATE, 
	"NOME" VARCHAR2(150 CHAR)
   );
--------------------------------------------------------
--  DDL for Table NOTIFICACAO
--------------------------------------------------------

  CREATE TABLE "NOTIFICACAO" 
   (	"IDNOTIFICACAO" NUMBER(10,0), 
	"TITULO" VARCHAR2(255 CHAR), 
	"TIPONOTIFICACAO" CHAR(1 CHAR), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE, 
	"ORIGEMNOTIFICACAO" CHAR(1 CHAR), 
	"IDCONTRATO" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table NOTIFICACAOGRUPO
--------------------------------------------------------

  CREATE TABLE "NOTIFICACAOGRUPO" 
   (	"IDNOTIFICACAO" NUMBER(10,0), 
	"IDGRUPO" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table NOTIFICACAOSERVICO
--------------------------------------------------------

  CREATE TABLE "NOTIFICACAOSERVICO" 
   (	"IDNOTIFICACAO" NUMBER(10,0), 
	"IDSERVICO" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table NOTIFICACAOUSUARIO
--------------------------------------------------------

  CREATE TABLE "NOTIFICACAOUSUARIO" 
   (	"IDNOTIFICACAO" NUMBER(10,0), 
	"IDUSUARIO" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table OBJETIVOMONITORAMENTO
--------------------------------------------------------

  CREATE TABLE "OBJETIVOMONITORAMENTO" 
   (	"IDOBJETIVOMONITORAMENTO" NUMBER(10,0), 
	"IDOBJETIVOPLANOMELHORIA" NUMBER(10,0), 
	"TITULOMONITORAMENTO" VARCHAR2(255 CHAR), 
	"FATORCRITICOSUCESSO" VARCHAR2(255 CHAR), 
	"KPI" VARCHAR2(255 CHAR), 
	"METRICA" CLOB, 
	"MEDICAO" CLOB, 
	"RELATORIOS" CLOB, 
	"RESPONSAVEL" VARCHAR2(255 CHAR), 
	"CRIADOPOR" VARCHAR2(255 CHAR), 
	"MODIFICADOPOR" VARCHAR2(255 CHAR), 
	"DATACRIACAO" DATE, 
	"ULTMODIFICACAO" DATE
   );
--------------------------------------------------------
--  DDL for Table OBJETIVOPLANOMELHORIA
--------------------------------------------------------

  CREATE TABLE "OBJETIVOPLANOMELHORIA" 
   (	"IDOBJETIVOPLANOMELHORIA" NUMBER(10,0), 
	"IDPLANOMELHORIA" NUMBER(10,0), 
	"TITULOOBJETIVO" VARCHAR2(255 CHAR), 
	"DETALHAMENTO" CLOB, 
	"RESULTADOESPERADO" CLOB, 
	"MEDICAO" VARCHAR2(255 CHAR), 
	"RESPONSAVEL" VARCHAR2(255 CHAR), 
	"CRIADOPOR" VARCHAR2(255 CHAR), 
	"MODIFICADOPOR" VARCHAR2(255 CHAR), 
	"DATACRIACAO" DATE, 
	"ULTMODIFICACAO" DATE
   );
--------------------------------------------------------
--  DDL for Table OBJETONEGOCIO
--------------------------------------------------------

  CREATE TABLE "OBJETONEGOCIO" 
   (	"IDOBJETONEGOCIO" NUMBER(24,0), 
	"NOMEOBJETONEGOCIO" VARCHAR2(500 CHAR), 
	"NOMETABELADB" VARCHAR2(120 CHAR), 
	"SITUACAO" CHAR(1 CHAR)
   );
--------------------------------------------------------
--  DDL for Table OCORRENCIAMUDANCA
--------------------------------------------------------

  CREATE TABLE "OCORRENCIAMUDANCA" 
   (	"IDOCORRENCIA" NUMBER(10,0), 
	"IDITEMTRABALHO" NUMBER(24,0), 
	"IDJUSTIFICATIVA" NUMBER(10,0), 
	"IDREQUISICAOMUDANCA" NUMBER(10,0), 
	"DATAREGISTRO" DATE, 
	"HORAREGISTRO" VARCHAR2(5 CHAR), 
	"REGISTRADOPOR" VARCHAR2(100 CHAR), 
	"DESCRICAO" VARCHAR2(200 CHAR), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE, 
	"COMPLEMENTOJUSTIFICATIVA" CLOB, 
	"DADOSMUDANCA" CLOB, 
	"INFORMACOESCONTATO" CLOB, 
	"CATEGORIA" VARCHAR2(20 CHAR), 
	"ORIGEM" CHAR(1 CHAR), 
	"TEMPOGASTO" NUMBER(5,0), 
	"OCORRENCIA" CLOB, 
	"IDCATEGORIAOCORRENCIA" NUMBER(10,0), 
	"IDORIGEMOCORRENCIA" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table OCORRENCIAS
--------------------------------------------------------

  CREATE TABLE "OCORRENCIAS" 
   (	"IDOCORRENCIA" NUMBER(10,0), 
	"IDDEMANDA" NUMBER(10,0), 
	"OCORRENCIA" CLOB, 
	"TIPOOCORRENCIA" CHAR(1 CHAR), 
	"RESPOSTAOCORRENCIA" CLOB, 
	"DATA" DATE, 
	"IDEMPREGADO" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table OCORRENCIASOLICITACAO
--------------------------------------------------------

  CREATE TABLE "OCORRENCIASOLICITACAO" 
   (	"IDOCORRENCIA" NUMBER(10,0), 
	"IDJUSTIFICATIVA" NUMBER(10,0), 
	"IDSOLICITACAOSERVICO" NUMBER(24,0), 
	"IDITEMTRABALHO" NUMBER(24,0), 
	"DATAREGISTRO" DATE, 
	"HORAREGISTRO" VARCHAR2(5 CHAR), 
	"REGISTRADOPOR" VARCHAR2(100 CHAR), 
	"DESCRICAO" VARCHAR2(500 CHAR), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE, 
	"COMPLEMENTOJUSTIFICATIVA" CLOB, 
	"DADOSSOLICITACAO" CLOB, 
	"INFORMACOESCONTATO" CLOB, 
	"CATEGORIA" VARCHAR2(20 CHAR), 
	"ORIGEM" CHAR(1 CHAR), 
	"TEMPOGASTO" NUMBER(5,0), 
	"OCORRENCIA" CLOB, 
	"IDCATEGORIAOCORRENCIA" NUMBER(10,0), 
	"IDORIGEMOCORRENCIA" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table OPCAORESPOSTAQUESTIONARIO
--------------------------------------------------------

  CREATE TABLE "OPCAORESPOSTAQUESTIONARIO" 
   (	"IDOPCAORESPOSTAQUESTIONARIO" NUMBER(10,0), 
	"IDQUESTAOQUESTIONARIO" NUMBER(10,0), 
	"TITULO" VARCHAR2(255 CHAR), 
	"PESO" NUMBER(10,0), 
	"VALOR" VARCHAR2(50 CHAR), 
	"GERAALERTA" CHAR(1 CHAR), 
	"EXIBECOMPLEMENTO" CHAR(1 CHAR), 
	"IDQUESTAOCOMPLEMENTO" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table OPINIAO
--------------------------------------------------------

  CREATE TABLE "OPINIAO" 
   (	"IDOPINIAO" NUMBER(10,0), 
	"IDUSUARIO" NUMBER(10,0), 
	"IDSOLICITACAO" NUMBER(10,0), 
	"TIPO" VARCHAR2(50 CHAR), 
	"OBSERVACOES" VARCHAR2(250 CHAR), 
	"DATA" DATE, 
	"HORA" DATE DEFAULT SYSDATE
   );
--------------------------------------------------------
--  DDL for Table ORIGEMATENDIMENTO
--------------------------------------------------------

  CREATE TABLE "ORIGEMATENDIMENTO" 
   (	"IDORIGEM" NUMBER(24,0), 
	"DESCRICAO" VARCHAR2(100 CHAR)
   );
--------------------------------------------------------
--  DDL for Table ORIGEMOCORRENCIA
--------------------------------------------------------

  CREATE TABLE "ORIGEMOCORRENCIA" 
   (	"IDORIGEMOCORRENCIA" NUMBER(10,0), 
	"NOME" VARCHAR2(256 CHAR), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE
   );
--------------------------------------------------------
--  DDL for Table OS
--------------------------------------------------------

  CREATE TABLE "OS" 
   (	"IDOS" NUMBER(10,0), 
	"IDCONTRATO" NUMBER(10,0), 
	"IDCLASSIFICACAOOS" NUMBER(10,0), 
	"IDSERVICOCONTRATO" NUMBER(24,0), 
	"NUMERO" VARCHAR2(20 CHAR), 
	"ANO" NUMBER(10,0), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE, 
	"DEMANDA" CLOB, 
	"OBJETIVO" CLOB, 
	"SITUACAOOS" NUMBER(10,0), 
	"NOMEAREAREQUISITANTE" VARCHAR2(150 CHAR), 
	"OBSFINALIZACAO" CLOB, 
	"QUANTIDADEGLOSASANTERIOR" NUMBER(10,0), 
	"QUANTIDADE" NUMBER(10,0), 
	"IDOSPAI" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table OSATIVIDADEPERIODICA
--------------------------------------------------------

  CREATE TABLE "OSATIVIDADEPERIODICA" 
   (	"IDATIVIDADEPERIODICA" NUMBER(10,0), 
	"IDOS" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table PAIS
--------------------------------------------------------

  CREATE TABLE "PAIS" 
   (	"IDPAIS" NUMBER(10,0), 
	"NOMEPAIS" VARCHAR2(200 CHAR)
   );
--------------------------------------------------------
--  DDL for Table PALAVRAGEMEA
--------------------------------------------------------

  CREATE TABLE "PALAVRAGEMEA" 
   (	"IDPALAVRAGEMEA" NUMBER(10,0), 
	"PALAVRA" VARCHAR2(256 CHAR), 
	"PALAVRACORRESPONDENTE" VARCHAR2(256 CHAR)
   );
--------------------------------------------------------
--  DDL for Table PARAMETROCORPORE
--------------------------------------------------------

  CREATE TABLE "PARAMETROCORPORE" 
   (	"IDPARAMETROCORPORE" NUMBER(10,0), 
	"NOMEPARAMETROCORPORE" VARCHAR2(200 CHAR), 
	"VALOR" VARCHAR2(200 CHAR), 
	"IDEMPRESA" NUMBER(10,0), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE,
	"TIPODADO" VARCHAR2(50 CHAR)
   );
--------------------------------------------------------
--  DDL for Table PARAMETROS
--------------------------------------------------------

  CREATE TABLE "PARAMETROS" 
   (	"NOMEPARAMETRO" VARCHAR2(70 CHAR), 
	"IDEMPRESA" NUMBER(10,0), 
	"MODULO" VARCHAR2(200 CHAR), 
	"VALOR" VARCHAR2(200 CHAR), 
	"DETALHAMENTO" VARCHAR2(200 CHAR)
   );
--------------------------------------------------------
--  DDL for Table PARAMETROSCONTRATO
--------------------------------------------------------

  CREATE TABLE "PARAMETROSCONTRATO" 
   (	"IDCONTRATO" NUMBER(10,0), 
	"NOMEPARAMETRO" VARCHAR2(100 CHAR), 
	"VALORPARAMETRO" CLOB
   );
--------------------------------------------------------
--  DDL for Table PARECER
--------------------------------------------------------

  CREATE TABLE "PARECER" 
   (	"IDPARECER" NUMBER(10,0), 
	"IDJUSTIFICATIVA" NUMBER(10,0), 
	"IDALCADA" NUMBER(10,0), 
	"IDRESPONSAVEL" NUMBER(10,0), 
	"DATAHORAPARECER" DATE DEFAULT SYSDATE, 
	"COMPLEMENTOJUSTIFICATIVA" CLOB, 
	"APROVADO" CHAR(1 CHAR), 
	"OBSERVACOES" CLOB
   );
--------------------------------------------------------
--  DDL for Table PASTA
--------------------------------------------------------

  CREATE TABLE "PASTA" 
   (	"IDPASTA" NUMBER(10,0), 
	"NOME" VARCHAR2(256 CHAR), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE, 
	"IDPASTAPAI" NUMBER(10,0), 
	"IDNOTIFICACAO" NUMBER(10,0), 
	"HERDAPERMISSOES" CHAR(1 CHAR)
   );
--------------------------------------------------------
--  DDL for Table PEDIDOCOMPRA
--------------------------------------------------------

  CREATE TABLE "PEDIDOCOMPRA" 
   (	"IDPEDIDO" NUMBER(10,0), 
	"IDEMPRESA" NUMBER(10,0), 
	"IDFORNECEDOR" NUMBER(24,0), 
	"DATAPEDIDO" DATE, 
	"DATAPREVISTAENTREGA" DATE, 
	"NUMEROPEDIDO" VARCHAR2(25 CHAR), 
	"IDENTIFICACAOENTREGA" VARCHAR2(25 CHAR), 
	"VALORFRETE" FLOAT(126), 
	"VALORSEGURO" FLOAT(126), 
	"NUMERONF" VARCHAR2(25 CHAR), 
	"OUTRASDESPESAS" FLOAT(126), 
	"SITUACAO" VARCHAR2(20 CHAR), 
	"IDCOTACAO" NUMBER(10,0), 
	"IDENDERECOENTREGA" NUMBER(10,0), 
	"DATAENTREGA" DATE, 
	"OBSERVACOES" CLOB
   );
--------------------------------------------------------
--  DDL for Table PERFILACESSO
--------------------------------------------------------

  CREATE TABLE "PERFILACESSO" 
   (	"IDPERFIL" NUMBER(10,0), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE, 
	"NOME" VARCHAR2(256 CHAR),
	"ACESSOSISTEMACITSMART" CHAR(1 char)  DEFAULT 'S'
   );
--------------------------------------------------------
--  DDL for Table PERFILACESSOGRUPO
--------------------------------------------------------

  CREATE TABLE "PERFILACESSOGRUPO" 
   (	"IDPERFIL" NUMBER(10,0), 
	"IDGRUPO" NUMBER(10,0), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE
   );
--------------------------------------------------------
--  DDL for Table PERFILACESSOMENU
--------------------------------------------------------

  CREATE TABLE "PERFILACESSOMENU" 
   (	"IDPERFILACESSO" NUMBER(10,0), 
	"IDMENU" NUMBER(10,0), 
	"PESQUISA" CHAR(1 CHAR), 
	"GRAVA" CHAR(1 CHAR), 
	"DELETA" CHAR(1 CHAR), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE
   );
--------------------------------------------------------
--  DDL for Table PERFILACESSOPASTA
--------------------------------------------------------

  CREATE TABLE "PERFILACESSOPASTA" 
   (	"IDPERFIL" NUMBER(10,0), 
	"IDPASTA" NUMBER(10,0), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE, 
	"APROVABASECONHECIMENTO" CHAR(1 CHAR), 
	"PERMITELEITURA" CHAR(1 CHAR), 
	"PERMITELEITURAGRAVACAO" CHAR(1 CHAR)
   );
--------------------------------------------------------
--  DDL for Table PERFILACESSOSITUACAOFATURA
--------------------------------------------------------

  CREATE TABLE "PERFILACESSOSITUACAOFATURA" 
   (	"IDPERFIL" NUMBER(10,0), 
	"SITUACAOFATURA" CHAR(1 CHAR), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE
   );
--------------------------------------------------------
--  DDL for Table PERFILACESSOSITUACAOOS
--------------------------------------------------------

  CREATE TABLE "PERFILACESSOSITUACAOOS" 
   (	"IDPERFIL" NUMBER(10,0), 
	"SITUACAOOS" NUMBER(10,0), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE
   );
--------------------------------------------------------
--  DDL for Table PERFILACESSOUSUARIO
--------------------------------------------------------

  CREATE TABLE "PERFILACESSOUSUARIO" 
   (	"DATAINICIO" DATE, 
	"IDUSUARIO" NUMBER(10,0), 
	"IDPERFIL" NUMBER(10,0), 
	"DATAFIM" DATE
   );
--------------------------------------------------------
--  DDL for Table PERFILSEGURANCA
--------------------------------------------------------

  CREATE TABLE "PERFILSEGURANCA" 
   (	"IDPERFILSEGURANCA" NUMBER(10,0), 
	"NOMEPERFILSEGURANCA" VARCHAR2(15 CHAR), 
	"DESCPERFILSEGURANCA" VARCHAR2(70 CHAR)
   );
--------------------------------------------------------
--  DDL for Table PERMISSOESFLUXO
--------------------------------------------------------

  CREATE TABLE "PERMISSOESFLUXO" 
   (	"IDGRUPO" NUMBER(10,0), 
	"IDTIPOFLUXO" NUMBER(10,0), 
	"CRIAR" CHAR(1 CHAR), 
	"EXECUTAR" CHAR(1 CHAR), 
	"DELEGAR" CHAR(1 CHAR), 
	"SUSPENDER" CHAR(1 CHAR), 
	"REATIVAR" CHAR(1 CHAR), 
	"ALTERARSLA" CHAR(1 CHAR), 
	"REABRIR" CHAR(1 CHAR)
   );
--------------------------------------------------------
--  DDL for Table PESQUISASATISFACAO
--------------------------------------------------------

  CREATE TABLE "PESQUISASATISFACAO" 
   (	"IDPESQUISASATISFACAO" NUMBER(10,0), 
	"IDSOLICITACAOSERVICO" NUMBER(24,0), 
	"NOTA" NUMBER(10,0), 
	"COMENTARIO" CLOB
   );
--------------------------------------------------------
--  DDL for Table PESSOA
--------------------------------------------------------

  CREATE TABLE "PESSOA" 
   (	"TOKENIDENTIFICACAO" VARCHAR2(20 CHAR), 
	"NOME" VARCHAR2(200 CHAR), 
	"CPF" VARCHAR2(20 CHAR)
   );
--------------------------------------------------------
--  DDL for Table PLANOMELHORIA
--------------------------------------------------------

  CREATE TABLE "PLANOMELHORIA" 
   (	"IDPLANOMELHORIA" NUMBER(10,0), 
	"IDFORNECEDOR" NUMBER(10,0), 
	"IDCONTRATO" NUMBER(10,0), 
	"TITULO" VARCHAR2(100 CHAR), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE, 
	"OBJETIVO" CLOB, 
	"VISAOGERAL" CLOB, 
	"ESCOPO" CLOB, 
	"VISAO" CLOB, 
	"MISSAO" CLOB, 
	"DATACRIACAO" DATE, 
	"NOTAS" CLOB, 
	"CRIADOPOR" VARCHAR2(40 CHAR), 
	"MODIFICADOPOR" VARCHAR2(40 CHAR), 
	"ULTMODIFICACAO" DATE, 
	"SITUACAO" CHAR(1 CHAR)
   );
--------------------------------------------------------
--  DDL for Table PORTAL
--------------------------------------------------------

  CREATE TABLE "PORTAL" 
   (	"IDPORTAL" NUMBER(10,0), 
	"IDITEM" NUMBER(10,0), 
	"POSICAOX" FLOAT(126), 
	"POSICAOY" FLOAT(126), 
	"IDUSUARIO" NUMBER(10,0), 
	"LARGURA" FLOAT(126), 
	"ALTURA" FLOAT(126), 
	"DATA" DATE, 
	"HORA" DATE DEFAULT SYSDATE, 
	"COLUNA" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table POST
--------------------------------------------------------

  CREATE TABLE "POST" 
   (	"IDPOST" NUMBER(10,0), 
	"TITULO" VARCHAR2(255 CHAR), 
	"DESCRICAO" CLOB, 
	"CONTEUDO" CLOB, 
	"IMAGEM" VARCHAR2(255 CHAR), 
	"IDCATEGORIAPOST" NUMBER(10,0), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE
   );
--------------------------------------------------------
--  DDL for Table PRIORIDADE
--------------------------------------------------------

  CREATE TABLE "PRIORIDADE" 
   (	"IDPRIORIDADE" NUMBER(10,0), 
	"IDEMPRESA" NUMBER(10,0), 
	"NOMEPRIORIDADE" VARCHAR2(100 CHAR), 
	"SITUACAO" CHAR(1 CHAR), 
	"GRUPOPRIORIDADE" CHAR(3 CHAR)
   );
--------------------------------------------------------
--  DDL for Table PRIORIDADEACORDONIVELSERVICO
--------------------------------------------------------

  CREATE TABLE "PRIORIDADEACORDONIVELSERVICO" 
   (	"IDUNIDADE" NUMBER(10,0), 
	"IDACORDONIVELSERVICO" NUMBER(24,0), 
	"IDPRIORIDADE" NUMBER(24,0), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE
   );
--------------------------------------------------------
--  DDL for Table PRIORIDADESERVICOUNIDADE
--------------------------------------------------------

  CREATE TABLE "PRIORIDADESERVICOUNIDADE" 
   (	"IDUNIDADE" NUMBER(10,0), 
	"IDSERVICOCONTRATO" NUMBER(24,0), 
	"IDPRIORIDADE" NUMBER(24,0), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE
   );
--------------------------------------------------------
--  DDL for Table PROBLEMA
--------------------------------------------------------

  CREATE TABLE "PROBLEMA" 
   (	"IDPROBLEMA" NUMBER(10,0), 
	"STATUS" VARCHAR2(40 CHAR), 
	"PRIORIDADE" NUMBER(10,0), 
	"IDCRIADOR" NUMBER(10,0), 
	"IDPROPRIETARIO" NUMBER(10,0), 
	"TITULO" VARCHAR2(255 CHAR), 
	"DESCRICAO" VARCHAR2(1000 CHAR), 
	"IDCATEGORIAPROBLEMA" NUMBER(10,0), 
	"IMPACTO" VARCHAR2(10 CHAR), 
	"URGENCIA" VARCHAR2(10 CHAR), 
	"PROATIVOREATIVO" VARCHAR2(15 CHAR), 
	"DATAHORALIMITESOLUCIONAR" DATE, 
	"MSGERROASSOCIADA" VARCHAR2(1000 CHAR), 
	"IDPROBLEMAITEMCONFIGURACAO" NUMBER(10,0), 
	"IDPROBLEMAMUDANCA" NUMBER(10,0), 
	"IDPROBLEMAINCIDENTE" NUMBER(10,0), 
	"DATAHORAINICIO" DATE, 
	"DATAHORAFIM" DATE, 
	"SOLUCAODEFINITIVA" VARCHAR2(4000 CHAR), 
	"ADICIONARBDCE" VARCHAR2(1 CHAR), 
	"STATUSBASECONHECIMENTO" VARCHAR2(1 CHAR), 
	"IDPASTABASECONHECIMENTO" NUMBER(10,0), 
	"CAUSARAIZ" VARCHAR2(4000 CHAR), 
	"SOLUCAOCONTORNO" VARCHAR2(4000 CHAR), 
	"IDBASECONHECIMENTO" NUMBER(10,0), 
	"SEVERIDADE" VARCHAR2(15 CHAR), 
	"IDGRUPO" NUMBER(10,0), 
	"IDSERVICO" NUMBER(10,0), 
	"IDCONTRATO" NUMBER(10,0), 
	"IDSERVICOCONTRATO" NUMBER(10,0), 
	"IDPRIORIDADE" NUMBER(10,0), 
	"DATAHORALIMITE" DATE DEFAULT SYSDATE, 
	"DATAHORASOLICITACAO" DATE DEFAULT to_date('01-JAN-70 00:00:00', 'dd-MON-yy hh24:mi:ss'), 
	"PRAZOHH" NUMBER(10,0), 
	"PRAZOMM" NUMBER(10,0), 
	"SLAACOMBINAR" CHAR(1 CHAR)
   );
--------------------------------------------------------
--  DDL for Table PROBLEMAITEMCONFIGURACAO
--------------------------------------------------------

  CREATE TABLE "PROBLEMAITEMCONFIGURACAO" 
   (	"IDPROBLEMAITEMCONFIGURACAO" NUMBER(10,0), 
	"IDPROBLEMA" NUMBER(10,0), 
	"IDITEMCONFIGURACAO" NUMBER(10,0), 
	"DESCRICAOPROBLEMA" VARCHAR2(255 CHAR)
   );
--------------------------------------------------------
--  DDL for Table PROBLEMAMUDANCA
--------------------------------------------------------

  CREATE TABLE "PROBLEMAMUDANCA" 
   (	"IDPROBLEMAMUDANCA" NUMBER(10,0), 
	"IDPROBLEMA" NUMBER(10,0), 
	"IDREQUISICAOMUDANCA" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table PROCEDIMENTOTECNICO
--------------------------------------------------------

  CREATE TABLE "PROCEDIMENTOTECNICO" 
   (	"IDPROCEDIMENTOTECNICO" NUMBER(10,0), 
	"NOMEPROCEDIMENTOTECNICO" VARCHAR2(255 CHAR), 
	"TEXTOPROCEDIMENTOTECNICO" CLOB, 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE
   );
--------------------------------------------------------
--  DDL for Table PROCESSAMENTOBATCH
--------------------------------------------------------

  CREATE TABLE "PROCESSAMENTOBATCH" 
   (	"IDPROCESSAMENTOBATCH" NUMBER(10,0), 
	"DESCRICAO" VARCHAR2(256 CHAR), 
	"EXPRESSAOCRON" VARCHAR2(40 CHAR), 
	"CONTEUDO" CLOB, 
	"TIPO" CHAR(1 CHAR), 
	"SITUACAO" CHAR(1 CHAR)
   );
--------------------------------------------------------
--  DDL for Table PRODUTO
--------------------------------------------------------

  CREATE TABLE "PRODUTO" 
   (	"IDPRODUTO" NUMBER(10,0), 
	"IDTIPOPRODUTO" NUMBER(10,0), 
	"IDMARCA" NUMBER(10,0), 
	"MODELO" VARCHAR2(25 CHAR), 
	"PRECOMERCADO" FLOAT(126), 
	"DETALHES" CLOB, 
	"CODIGOPRODUTO" VARCHAR2(25 CHAR), 
	"SITUACAO" CHAR(1 CHAR), 
	"COMPLEMENTO" VARCHAR2(100 CHAR)
   );
--------------------------------------------------------
--  DDL for Table PROGRAMACAOATIVIDADE
--------------------------------------------------------

  CREATE TABLE "PROGRAMACAOATIVIDADE" 
   (	"IDPROGRAMACAOATIVIDADE" NUMBER(10,0), 
	"IDATIVIDADEPERIODICA" NUMBER(10,0), 
	"TIPOAGENDAMENTO" CHAR(1 CHAR), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE, 
	"DURACAOESTIMADA" NUMBER(10,0), 
	"PERIODICIDADEDIARIA" NUMBER(10,0), 
	"PERIODICIDADESEMANAL" NUMBER(10,0), 
	"PERIODICIDADEMENSAL" NUMBER(10,0), 
	"DIA" NUMBER(10,0), 
	"DIAUTIL" NUMBER(10,0), 
	"DIASEMANA" NUMBER(10,0), 
	"SEQDIASEMANA" NUMBER(10,0), 
	"SEG" CHAR(1 CHAR), 
	"TER" CHAR(1 CHAR), 
	"QUA" CHAR(1 CHAR), 
	"QUI" CHAR(1 CHAR), 
	"SEX" CHAR(1 CHAR), 
	"SAB" CHAR(1 CHAR), 
	"DOM" CHAR(1 CHAR), 
	"JAN" CHAR(1 CHAR), 
	"FEV" CHAR(1 CHAR), 
	"MAR" CHAR(1 CHAR), 
	"ABR" CHAR(1 CHAR), 
	"MAI" CHAR(1 CHAR), 
	"JUN" CHAR(1 CHAR), 
	"JUL" CHAR(1 CHAR), 
	"AGO" CHAR(1 CHAR), 
	"SETEM" CHAR(1 CHAR), 
	"OUTUB" CHAR(1 CHAR), 
	"NOV" CHAR(1 CHAR), 
	"DEZ" CHAR(1 CHAR), 
	"REPETICAO" CHAR(1 CHAR), 
	"REPETICAOINTERVALO" NUMBER(10,0), 
	"REPETICAOTIPOINTERVALO" CHAR(1 CHAR), 
	"HORAINICIO" CHAR(4 CHAR), 
	"HORAFIM" CHAR(4 CHAR), 
	"IDATIVIDADESOS" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table PROJETOS
--------------------------------------------------------

  CREATE TABLE "PROJETOS" 
   (	"IDPROJETO" NUMBER(10,0), 
	"IDCLIENTE" NUMBER(10,0), 
	"IDCONTRATO" NUMBER(10,0), 
	"NOMEPROJETO" VARCHAR2(70 CHAR), 
	"DETALHAMENTO" CLOB, 
	"SITUACAO" CHAR(1 CHAR), 
	"VALORESTIMADO" FLOAT(126)
   );
--------------------------------------------------------
--  DDL for Table QUESTAOQUESTIONARIO
--------------------------------------------------------

  CREATE TABLE "QUESTAOQUESTIONARIO" 
   (	"IDQUESTAOQUESTIONARIO" NUMBER(10,0), 
	"IDGRUPOQUESTIONARIO" NUMBER(10,0), 
	"IDQUESTAOAGRUPADORA" NUMBER(10,0), 
	"IDQUESTAOCOMPARTILHADA" NUMBER(10,0), 
	"IDQUESTAOORIGEM" NUMBER(10,0), 
	"TIPO" CHAR(1 CHAR), 
	"TITULOQUESTAOQUESTIONARIO" CLOB, 
	"TIPOQUESTAO" CHAR(1 CHAR), 
	"SEXOQUESTAO" CHAR(1 CHAR), 
	"SEQUENCIAQUESTAO" NUMBER(10,0), 
	"VALORDEFAULT" CLOB, 
	"TEXTOINICIAL" CLOB, 
	"TAMANHO" NUMBER(10,0), 
	"DECIMAIS" NUMBER(10,0), 
	"INFORESPOSTA" CHAR(1 CHAR), 
	"VALORESREFERENCIA" CLOB, 
	"UNIDADE" CLOB, 
	"OBRIGATORIA" CHAR(1 CHAR), 
	"PONDERADA" CHAR(1 CHAR), 
	"QTDELINHAS" NUMBER(10,0), 
	"QTDECOLUNAS" NUMBER(10,0), 
	"CABECALHOLINHAS" CHAR(1 CHAR), 
	"CABECALHOCOLUNAS" CHAR(1 CHAR), 
	"NOMELISTAGEM" VARCHAR2(30 CHAR), 
	"ULTIMOVALOR" CHAR(1 CHAR), 
	"IDSUBQUESTIONARIO" NUMBER(10,0), 
	"ABARESULTSUBFORM" VARCHAR2(200 CHAR), 
	"SIGLA" VARCHAR2(100 CHAR), 
	"IMPRIME" CHAR(1 CHAR), 
	"CALCULADA" CHAR(1 CHAR), 
	"EDITAVEL" CHAR(1 CHAR), 
	"VALORPERMITIDO1" FLOAT(126), 
	"VALORPERMITIDO2" FLOAT(126), 
	"APLICAVELCRIANCA" CHAR(1 CHAR), 
	"APLICAVELIDOSO" CHAR(1 CHAR), 
	"APLICAVELADULTO" CHAR(1 CHAR), 
	"APLICAVELADOLESCENTE" CHAR(1 CHAR), 
	"IDIMAGEM" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table QUESTIONARIO
--------------------------------------------------------

  CREATE TABLE "QUESTIONARIO" 
   (	"IDQUESTIONARIO" NUMBER(10,0), 
	"IDQUESTIONARIOORIGEM" NUMBER(10,0), 
	"IDCATEGORIAQUESTIONARIO" NUMBER(10,0), 
	"NOMEQUESTIONARIO" VARCHAR2(50 CHAR), 
	"IDEMPRESA" NUMBER(10,0), 
	"ATIVO" CHAR(1 CHAR) DEFAULT 'S'
   );
--------------------------------------------------------
--  DDL for Table REABERTURASOLICITACAO
--------------------------------------------------------

  CREATE TABLE "REABERTURASOLICITACAO" 
   (	"IDSOLICITACAOSERVICO" NUMBER(24,0), 
	"SEQREABERTURA" NUMBER(10,0), 
	"IDRESPONSAVEL" NUMBER(10,0), 
	"DATAHORA" DATE DEFAULT SYSDATE, 
	"OBSERVACOES" CLOB
   );
--------------------------------------------------------
--  DDL for Table RECURSO
--------------------------------------------------------

  CREATE TABLE "RECURSO" 
   (	"IDRECURSO" NUMBER(10,0), 
	"IDGRUPORECURSO" NUMBER(10,0), 
	"IDRECURSOPAI" NUMBER(10,0), 
	"NOMERECURSO" VARCHAR2(150 CHAR), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE, 
	"TIPOATUALIZACAO" CHAR(1 CHAR), 
	"DELETED" CHAR(1 CHAR), 
	"IDNAGIOSCONEXAO" NUMBER(10,0), 
	"HOSTNAME" VARCHAR2(255 CHAR), 
	"SERVICENAME" VARCHAR2(255 CHAR), 
	"HORAINICIOFUNC" VARCHAR2(5 CHAR), 
	"HORAFIMFUNC" VARCHAR2(5 CHAR), 
	"IDCALENDARIO" NUMBER(10,0), 
	"STATUSABERTURAINC" VARCHAR2(255 CHAR), 
	"IDSOLICITANTE" NUMBER(10,0), 
	"EMAILABERTURAINC" VARCHAR2(255 CHAR), 
	"DESCRICAOABERTINC" CLOB, 
	"IMPACTO" CHAR(1 CHAR), 
	"URGENCIA" CHAR(1 CHAR), 
	"IDGRUPO" NUMBER(10,0), 
	"IDORIGEM" NUMBER(24,0), 
	"IDSERVICOCONTRATO" NUMBER(24,0), 
	"IDEVENTOMONITORAMENTO" NUMBER(10,0), 
	"IDITEMCONFIGURACAO" NUMBER(10,0), 
	"STATUSALERTA" VARCHAR2(255 CHAR), 
	"EMAILSALERTA" CLOB, 
	"DESCRICAOALERTA" CLOB
   );
--------------------------------------------------------
--  DDL for Table REGIOES
--------------------------------------------------------

  CREATE TABLE "REGIOES" 
   (	"IDREGIOES" NUMBER(10,0), 
	"NOME" VARCHAR2(45 CHAR)
   );
--------------------------------------------------------
--  DDL for Table REGISTRO
--------------------------------------------------------

  CREATE TABLE "REGISTRO" 
   (	"IDREGISTRO" NUMBER(10,0), 
	"TOKENIDENTIFICACAO" VARCHAR2(20 CHAR), 
	"DATAHORA" DATE DEFAULT SYSDATE
   );
--------------------------------------------------------
--  DDL for Table RELACIONAMENTOPRODUTO
--------------------------------------------------------

  CREATE TABLE "RELACIONAMENTOPRODUTO" 
   (	"IDTIPOPRODUTO" NUMBER(10,0), 
	"IDTIPOPRODUTORELACIONADO" NUMBER(10,0), 
	"TIPORELACIONAMENTO" CHAR(1 CHAR)
   );

   COMMENT ON COLUMN "RELACIONAMENTOPRODUTO"."TIPORELACIONAMENTO" IS 'A - Acessório
            S - Produto semelhante';
--------------------------------------------------------
--  DDL for Table RELACOBJETONEGOCIO
--------------------------------------------------------

  CREATE TABLE "RELACOBJETONEGOCIO" 
   (	"IDRELACOBJETONEGOCIO" NUMBER(24,0), 
	"IDOBJETONEGOCIOPAI" NUMBER(24,0), 
	"IDOBJETONEGOCIOFILHO" NUMBER(24,0), 
	"SITUACAO" CHAR(1 CHAR)
   );
--------------------------------------------------------
--  DDL for Table REQUISICAOMUDANCA
--------------------------------------------------------

  CREATE TABLE "REQUISICAOMUDANCA" 
   (	"IDREQUISICAOMUDANCA" NUMBER(10,0), 
	"IDPROPRIETARIO" NUMBER(10,0), 
	"IDSOLICITANTE" NUMBER(10,0), 
	"IDTIPOMUDANCA" NUMBER(10,0), 
	"IDGRUPONIVEL1" NUMBER(10,0), 
	"IDGRUPOATUAL" NUMBER(10,0), 
	"IDCALENDARIO" NUMBER(10,0), 
	"MOTIVO" VARCHAR2(255 CHAR), 
	"NIVELIMPORTANCIANEGOCIO" VARCHAR2(255 CHAR), 
	"CLASSIFICACAO" VARCHAR2(255 CHAR), 
	"NIVELIMPACTO" VARCHAR2(255 CHAR), 
	"ANALISEIMPACTO" VARCHAR2(3000 CHAR), 
	"DATAHORACONCLUSAO" DATE, 
	"DATAACEITACAO" DATE, 
	"DATAVOTACAO" DATE, 
	"DATAHORAINICIO" DATE, 
	"DATAHORATERMINO" DATE, 
	"TITULO" VARCHAR2(255 CHAR), 
	"DESCRICAO" VARCHAR2(255 CHAR), 
	"RISCO" VARCHAR2(255 CHAR), 
	"ESTIMATIVACUSTO" FLOAT(126), 
	"PLANOREVERSAO" VARCHAR2(3000 CHAR), 
	"STATUS" VARCHAR2(45 CHAR), 
	"PRIORIDADE" NUMBER(10,0), 
	"ENVIAEMAILCRIACAO" VARCHAR2(1 CHAR), 
	"ENVIAEMAILFINALIZACAO" VARCHAR2(1 CHAR), 
	"ENVIAEMAILACOES" VARCHAR2(1 CHAR), 
	"EXIBIRQUADROMUDANCAS" VARCHAR2(1 CHAR), 
	"SEQREABERTURA" NUMBER(5,0), 
	"DATAHORACAPTURA" DATE, 
	"DATAHORAREATIVACAO" DATE, 
	"DATAHORASUSPENSAO" DATE, 
	"TEMPODECORRIDOHH" NUMBER(5,0), 
	"TEMPODECORRIDOMM" NUMBER(5,0), 
	"PRAZOHH" NUMBER(5,0), 
	"PRAZOMM" NUMBER(5,0), 
	"TEMPOATENDIMENTOHH" NUMBER(5,0), 
	"TEMPOATENDIMENTOMM" NUMBER(5,0), 
	"TEMPOATRASOHH" NUMBER(5,0), 
	"TEMPOATRASOMM" NUMBER(5,0), 
	"TEMPOCAPTURAHH" NUMBER(5,0), 
	"TEMPOCAPTURAMM" NUMBER(5,0), 
	"FASE" VARCHAR2(20 CHAR), 
	"NIVELURGENCIA" VARCHAR2(255 CHAR), 
	"IDBASECONHECIMENTO" NUMBER(10,0), 
	"NOMECATEGORIAMUDANCA" VARCHAR2(15 CHAR), 
	"IDCONTRATO" NUMBER(10,0), 
	"IDUNIDADE" NUMBER(10,0), 
	"IDCONTATOREQUISICAOMUDANCA" NUMBER(10,0), 
	"IDGRUPOCOMITE" NUMBER(10,0), 
	"ENVIAEMAILGRUPOCOMITE" VARCHAR2(1 CHAR), 
	"DATAHORAINICIOAGENDADA" DATE, 
	"DATAHORATERMINOAGENDADA" DATE, 
	"IDLOCALIDADE" NUMBER(10,0), 
	"FECHAMENTO" CLOB,
	"TIPO" VARCHAR2(255 CHAR)
   );
--------------------------------------------------------
--  DDL for Table REQUISICAOMUDANCAITEMCONFIGURA
--------------------------------------------------------

  CREATE TABLE "REQUISICAOMUDANCAITEMCONFIGURA" 
   (	"IDREQUISICAOMUDANCAITEMCONFIGU" NUMBER(10,0), 
	"IDREQUISICAOMUDANCA" NUMBER(10,0), 
	"IDITEMCONFIGURACAO" NUMBER(10,0), 
	"DESCRICAO" VARCHAR2(100 CHAR)
   );
--------------------------------------------------------
--  DDL for Table REQUISICAOMUDANCASERVICO
--------------------------------------------------------

  CREATE TABLE "REQUISICAOMUDANCASERVICO" 
   (	"IDREQUISICAOMUDANCASERVICO" NUMBER(10,0), 
	"IDREQUISICAOMUDANCA" NUMBER(10,0), 
	"IDSERVICO" NUMBER(24,0)
   );
--------------------------------------------------------
--  DDL for Table REQUISICAOPRODUTO
--------------------------------------------------------

  CREATE TABLE "REQUISICAOPRODUTO" 
   (	"IDSOLICITACAOSERVICO" NUMBER(10,0), 
	"IDPROJETO" NUMBER(10,0), 
	"IDCENTROCUSTO" NUMBER(10,0), 
	"IDENDERECOENTREGA" NUMBER(10,0), 
	"FINALIDADE" CHAR(1 CHAR), 
	"REJEITADA" CHAR(1 CHAR)
   );

 -- COMMENT ON COLUMN "REQUISICAOPRODUTO"."FINALIDADE" IS 'C - Atendimento ao cliente I - Uso interno';
--------------------------------------------------------
--  DDL for Table REQUISITOSLA
--------------------------------------------------------

  CREATE TABLE "REQUISITOSLA" 
   (	"IDREQUISITOSLA" NUMBER(10,0), 
	"IDEMPREGADO" NUMBER(10,0), 
	"REQUISITADOEM" DATE, 
	"ASSUNTO" VARCHAR2(200 CHAR), 
	"DETALHAMENTO" CLOB, 
	"SITUACAO" CHAR(1 CHAR), 
	"CRIADOPOR" VARCHAR2(255 CHAR), 
	"CRIADOEM" DATE DEFAULT SYSDATE, 
	"MODIFICADOPOR" VARCHAR2(255 CHAR), 
	"MODIFICADOEM" DATE DEFAULT to_date('01-JAN-70 00:00:00', 'dd-MON-yy hh24:mi:ss'), 
	"DELETED" CHAR(1 CHAR)
   );
   
   CREATE TABLE "REQUISICAOLIBERACAORESPONSAVEL"(
	"IDREQUISICAOLIBERACAORESP" NUMBER(10,0),
	"IDRESPONSAVEL" NUMBER(10,0),
	"IDREQUISICAOLIBERACAO" NUMBER(10,0),
	"PAPELRESPONSAVEL" VARCHAR2(200 CHAR)
);
--------------------------------------------------------
--  DDL for Table RESPONSABILIDADE
--------------------------------------------------------

  CREATE TABLE "RESPONSABILIDADE" 
   (	"IDRESPONSABILIDADE" NUMBER(10,0), 
	"IDEMPREGADO" NUMBER(10,0), 
	"IDCONTRATO" NUMBER(10,0), 
	"IDCONTATOCLIENTE" NUMBER(10,0), 
	"IDSERVICOCONTRATO" NUMBER(10,0), 
	"PRODUTOATV" VARCHAR2(400 CHAR), 
	"DETALHAMENTO" CLOB, 
	"PARTICIPACAO" VARCHAR2(400 CHAR)
   );
--------------------------------------------------------
--  DDL for Table RESPOSTAITEMQUESTIONARIO
--------------------------------------------------------

  CREATE TABLE "RESPOSTAITEMQUESTIONARIO" 
   (	"IDRESPOSTAITEMQUESTIONARIO" NUMBER(10,0), 
	"IDIDENTIFICADORRESPOSTA" NUMBER(10,0), 
	"IDQUESTAOQUESTIONARIO" NUMBER(10,0), 
	"SEQUENCIALRESPOSTA" NUMBER(10,0), 
	"RESPOSTATEXTUAL" CLOB, 
	"RESPOSTAPERCENTUAL" FLOAT(126), 
	"RESPOSTAVALOR" FLOAT(126), 
	"RESPOSTAVALOR2" FLOAT(126), 
	"RESPOSTANUMERO" FLOAT(126), 
	"RESPOSTANUMERO2" FLOAT(126), 
	"RESPOSTADATA" DATE, 
	"RESPOSTAHORA" VARCHAR2(4 CHAR), 
	"RESPOSTAPRESSAOSISTOLICA" NUMBER(5,0), 
	"RESPOSTAPRESSAODIASTOLICA" NUMBER(5,0), 
	"RESPOSTAMES" NUMBER(5,0), 
	"RESPOSTAANO" NUMBER(5,0), 
	"RESPOSTAPESO" FLOAT(126), 
	"RESPOSTAALTURA" FLOAT(126), 
	"RESPOSTAIMC" FLOAT(126), 
	"RESPOSTADUM" DATE, 
	"RESPOSTACICLOMENSTRUAL" NUMBER(5,0), 
	"RESPOSTAMEDIAFASELUTEA" NUMBER(5,0), 
	"RESPOSTADPP" DATE, 
	"RESPOSTAIDLISTAGEM" VARCHAR2(10 CHAR), 
	"IDATESTADO" NUMBER(10,0), 
	"RESPOSTADPPPELADUM" DATE, 
	"RESPOSTADIA" NUMBER(5,0)
   );
--------------------------------------------------------
--  DDL for Table RESPOSTAITEMQUESTIONARIOANEXOS
--------------------------------------------------------

  CREATE TABLE "RESPOSTAITEMQUESTIONARIOANEXOS" 
   (	"IDRESPOSTAITMQUESTIONARIOANEXO" NUMBER(10,0), 
	"IDRESPOSTAITEMQUESTIONARIO" NUMBER(10,0), 
	"CAMINHOANEXO" VARCHAR2(255 CHAR), 
	"OBSERVACAO" CLOB
   );
--------------------------------------------------------
--  DDL for Table RESPOSTAITEMQUESTIONARIOCIDS
--------------------------------------------------------

  CREATE TABLE "RESPOSTAITEMQUESTIONARIOCIDS" 
   (	"IDRESPOSTAITEMQUESTIONARIOCID" NUMBER(10,0), 
	"IDRESPOSTAITEMQUESTIONARIO" NUMBER(10,0), 
	"IDCID" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table RESPOSTAITEMQUESTIONARIOOPCOES
--------------------------------------------------------

  CREATE TABLE "RESPOSTAITEMQUESTIONARIOOPCOES" 
   (	"IDRESPOSTAITEMQUESTIONARIO" NUMBER(10,0), 
	"IDOPCAORESPOSTAQUESTIONARIO" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table RESULTADOSESPERADOS
--------------------------------------------------------

  CREATE TABLE "RESULTADOSESPERADOS" 
   (	"IDSERVICOCONTRATO" NUMBER(24,0), 
	"IDACORDONIVELSERVICO" NUMBER(24,0), 
	"DESCRICAORESULTADOS" VARCHAR2(1000 CHAR), 
	"LIMITES" VARCHAR2(200 CHAR), 
	"GLOSA" VARCHAR2(200 CHAR), 
	"LIMITEGLOSA" VARCHAR2(200 CHAR), 
	"DELETED" CHAR(1 CHAR)
   );
--------------------------------------------------------
--  DDL for Table REVISARSLA
--------------------------------------------------------

  CREATE TABLE "REVISARSLA" 
   (	"IDREVISARSLA" NUMBER(24,0), 
	"IDACORDONIVELSERVICO" NUMBER(24,0), 
	"DATAREVISAO" DATE, 
	"DETALHEREVISAO" CLOB, 
	"OBSERVACAO" VARCHAR2(200 CHAR), 
	"DELETED" CHAR(1 CHAR)
   );
--------------------------------------------------------
--  DDL for Table SCRIPTS
--------------------------------------------------------

  CREATE TABLE "SCRIPTS" 
   (	"DESCRICAO" CLOB, 
	"DATAFIM" DATE, 
	"DATAINICIO" DATE, 
	"HISTORICO" CLOB, 
	"IDSCRIPT" NUMBER(10,0), 
	"NOME" VARCHAR2(255 CHAR), 
	"SQLQUERY" CLOB, 
	"TIPO" CHAR(10 CHAR), 
	"IDVERSAO" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table SCRIPTSVISAO
--------------------------------------------------------

  CREATE TABLE "SCRIPTSVISAO" 
   (	"IDSCRIPTSVISAO" NUMBER(24,0), 
	"IDVISAO" NUMBER(24,0), 
	"TYPEEXECUTE" CHAR(1 CHAR), 
	"SCRYPTTYPE" CHAR(30 CHAR), 
	"SCRIPT" CLOB, 
	"SCRIPTLANGUAGE" VARCHAR2(30 CHAR)
   );
   
CREATE TABLE SEQUENCE_BLOCK_CONTROLLER 
	(
	  ID NUMBER NOT NULL 
	, SEQUENCE_NAME VARCHAR2(80) NOT NULL 
	, LAST_ID NUMBER NOT NULL 
	);

CREATE INDEX SEQUENCE_BLOCK_INDEX1 ON SEQUENCE_BLOCK_CONTROLLER (SEQUENCE_NAME ASC);


--------------------------------------------------------
--  DDL for Table SERVCONTRATOCATALOGOSERV
--------------------------------------------------------

  CREATE TABLE "SERVCONTRATOCATALOGOSERV" 
   (	"IDSERVICOCONTRATO" NUMBER(24,0), 
	"IDCATALOGOSERVICO" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table SERVICO
--------------------------------------------------------

  CREATE TABLE "SERVICO" 
   (	"IDSERVICO" NUMBER(24,0), 
	"IDCATEGORIASERVICO" NUMBER(10,0), 
	"IDSITUACAOSERVICO" NUMBER(10,0), 
	"IDTIPOSERVICO" NUMBER(10,0), 
	"IDIMPORTANCIANEGOCIO" NUMBER(10,0), 
	"IDEMPRESA" NUMBER(24,0), 
	"IDTIPOEVENTOSERVICO" NUMBER(10,0), 
	"IDTIPODEMANDASERVICO" NUMBER(10,0), 
	"IDLOCALEXECUCAOSERVICO" NUMBER(10,0), 
	"NOMESERVICO" VARCHAR2(500 CHAR), 
	"DETALHESERVICO" CLOB, 
	"OBJETIVO" CLOB, 
	"PASSOSSERVICO" CLOB, 
	"DATAINICIO" DATE, 
	"LINKPROCESSO" VARCHAR2(500 CHAR), 
	"DESCRICAOPROCESSO" CLOB, 
	"TIPODESCPROCESS" CHAR(1 CHAR), 
	"DISPPORTAL" CHAR(1 CHAR), 
	"QUADROORIENTPORTAL" CLOB, 
	"DELETED" CHAR(1 CHAR), 
	"DETALHESSERVICO" VARCHAR2(255 CHAR), 
	"SIGLAABREV" VARCHAR2(150 CHAR), 
	"IDBASECONHECIMENTO" NUMBER(10,0), 
	"IDTEMPLATESOLICITACAO" NUMBER(10,0), 
	"IDTEMPLATEACOMPANHAMENTO" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table SERVICOCONTRATO
--------------------------------------------------------

  CREATE TABLE "SERVICOCONTRATO" 
   (	"IDSERVICOCONTRATO" NUMBER(24,0), 
	"IDSERVICO" NUMBER(24,0), 
	"IDCONTRATO" NUMBER(10,0), 
	"IDCONDICAOOPERACAO" NUMBER(10,0), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE, 
	"OBSERVACAO" CLOB, 
	"CUSTO" FLOAT(126), 
	"RESTRICOESPRESSUP" CLOB, 
	"OBJETIVO" CLOB, 
	"PERMITESLANOCADINC" CHAR(1 CHAR), 
	"LINKPROCESSO" VARCHAR2(500 CHAR), 
	"DESCRICAOPROCESSO" CLOB, 
	"TIPODESCPROCESS" CHAR(1 CHAR), 
	"DELETED" CHAR(1 CHAR), 
	"AREAREQUISITANTE" VARCHAR2(150 CHAR), 
	"IDGRUPONIVEL1" NUMBER(10,0), 
	"IDMODELOEMAILCRIACAO" NUMBER(10,0), 
	"IDMODELOEMAILFINALIZACAO" NUMBER(10,0), 
	"IDMODELOEMAILACOES" NUMBER(10,0), 
	"IDGRUPOEXECUTOR" NUMBER(10,0), 
	"IDCALENDARIO" NUMBER(10,0), 
	"PERMSLATEMPOACOMBINAR" CHAR(1 CHAR), 
	"PERMMUDANCASLA" CHAR(1 CHAR), 
	"PERMMUDANCACALENDARIO" CHAR(1 CHAR), 
	"IDGRUPOAPROVADOR" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table SERVICO_HIST
--------------------------------------------------------

  CREATE TABLE "SERVICO_HIST" 
   (	"IDHISTORICOSERVICO" NUMBER(24,0), 
	"IDSERVICO" NUMBER(24,0), 
	"IDCATEGORIASERVICO" NUMBER(10,0), 
	"IDSITUACAOSERVICO" NUMBER(10,0), 
	"IDTIPOSERVICO" NUMBER(10,0), 
	"IDIMPORTANCIANEGOCIO" NUMBER(10,0), 
	"IDEMPRESA" NUMBER(24,0), 
	"IDTIPOEVENTOSERVICO" NUMBER(10,0), 
	"IDTIPODEMANDASERVICO" NUMBER(10,0), 
	"IDLOCALEXECUCAOSERVICO" NUMBER(10,0), 
	"NOMESERVICO" VARCHAR2(500 CHAR), 
	"DETALHESERVICO" CLOB, 
	"OBJETIVO" CLOB, 
	"PASSOSSERVICO" CLOB, 
	"DATAINICIO" DATE, 
	"LINKPROCESSO" VARCHAR2(500 CHAR), 
	"DESCRICAOPROCESSO" CLOB, 
	"TIPODESCPROCESS" CHAR(1 CHAR), 
	"DISPPORTAL" CHAR(1 CHAR), 
	"QUADROORIENTPORTAL" CLOB, 
	"DELETED" CHAR(1 CHAR), 
	"DETALHESSERVICO" VARCHAR2(255 CHAR), 
	"SIGLAABREV" VARCHAR2(150 CHAR), 
	"IDBASECONHECIMENTO" NUMBER(10,0), 
	"IDTEMPLATESOLICITACAO" NUMBER(10,0), 
	"IDTEMPLATEACOMPANHAMENTO" NUMBER(10,0), 
	"CRIADOEM" DATE DEFAULT SYSDATE, 
	"CRIADOPOR" VARCHAR2(255 CHAR), 
	"MODIFICADOEM" DATE DEFAULT to_date('01-JAN-70 00:00:00', 'dd-MON-yy hh24:mi:ss'), 
	"MODIFICADOPOR" VARCHAR2(255 CHAR), 
	"CONTEUDODADOS" CLOB
   );
--------------------------------------------------------
--  DDL for Table SERVICOS
--------------------------------------------------------

  CREATE TABLE "SERVICOS" 
   (	"IDSERVICO" NUMBER(24,0), 
	"NOMESERVICO" VARCHAR2(255 CHAR), 
	"DETALHESSERVICO" VARCHAR2(255 CHAR), 
	"OBJETIVO" VARCHAR2(255 CHAR), 
	"PASSOSSERVICO" VARCHAR2(255 CHAR), 
	"DATAINICIO" VARCHAR2(255 CHAR), 
	"LINKPROCESSO" VARCHAR2(255 CHAR), 
	"DESCRICAOPROCESSO" VARCHAR2(255 CHAR), 
	"TIPODESCPROCESS" VARCHAR2(255 CHAR), 
	"DISPPORTAL" VARCHAR2(255 CHAR), 
	"QUADROORIENTPORTAL" VARCHAR2(255 CHAR), 
	"DELETED" VARCHAR2(255 CHAR)
   );
--------------------------------------------------------
--  DDL for Table SISTEMAOPERACIONAL
--------------------------------------------------------

  CREATE TABLE "SISTEMAOPERACIONAL" 
   (	"ID" NUMBER(10,0), 
	"NOME" VARCHAR2(255 CHAR)
   );
--------------------------------------------------------
--  DDL for Table SITUACAODEMANDA
--------------------------------------------------------

  CREATE TABLE "SITUACAODEMANDA" 
   (	"IDSITUACAODEMANDA" NUMBER(10,0), 
	"NOMESITUACAO" VARCHAR2(40 CHAR)
   );
--------------------------------------------------------
--  DDL for Table SITUACAOSERVICO
--------------------------------------------------------

  CREATE TABLE "SITUACAOSERVICO" 
   (	"IDSITUACAOSERVICO" NUMBER(10,0), 
	"IDEMPRESA" NUMBER(10,0), 
	"NOMESITUACAOSERVICO" VARCHAR2(100 CHAR), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE
   );
--------------------------------------------------------
--  DDL for Table SLAREQUISITOSLA
--------------------------------------------------------

  CREATE TABLE "SLAREQUISITOSLA" 
   (	"IDREQUISITOSLA" NUMBER(10,0), 
	"IDACORDONIVELSERVICO" NUMBER(24,0), 
	"DATAVINCULACAO" DATE DEFAULT SYSDATE, 
	"DATAULTMODIFICACAO" DATE DEFAULT SYSDATE, 
	"DELETED" CHAR(1 CHAR)
   );
--------------------------------------------------------
--  DDL for Table SOLICITACAOSERVICO
--------------------------------------------------------

  CREATE TABLE "SOLICITACAOSERVICO" 
   (	"IDSOLICITACAOSERVICO" NUMBER(24,0), 
	"IDFASEATUAL" NUMBER(24,0), 
	"IDTIPOPROBLEMA" NUMBER(24,0), 
	"IDGRUPOATUAL" NUMBER(10,0), 
	"IDPRIORIDADE" NUMBER(24,0), 
	"IDORIGEM" NUMBER(24,0), 
	"IDRESPONSAVEL" NUMBER(10,0), 
	"IDSOLICITANTE" NUMBER(10,0), 
	"ATENDIMENTOPRESENCIAL" CHAR(1 CHAR), 
	"DATAHORASOLICITACAO" DATE DEFAULT SYSDATE, 
	"DATAHORALIMITE" DATE, 
	"PRAZOHH" NUMBER(5,0), 
	"PRAZOMM" NUMBER(5,0), 
	"DESCRICAO" CLOB, 
	"RESPOSTA" CLOB, 
	"DATAHORAINICIO" DATE, 
	"DATAHORAFIM" DATE, 
	"SITUACAO" VARCHAR2(20 CHAR), 
	"DELETED" CHAR(1 CHAR), 
	"IDCONTATOSOLICITACAOSERVICO" NUMBER(10,0), 
	"IDSERVICOCONTRATO" NUMBER(24,0), 
	"IDUNIDADE" NUMBER(10,0), 
	"IDCAUSAINCIDENTE" NUMBER(10,0), 
	"IDCATEGORIASOLUCAO" NUMBER(10,0), 
	"IDTIPODEMANDASERVICO" NUMBER(10,0), 
	"IDITEMCONFIGURACAO" NUMBER(10,0), 
	"IDITEMCONFIGURACAOFILHO" NUMBER(10,0), 
	"IDSOLICITACAOPAI" NUMBER(10,0), 
	"DETALHAMENTOCAUSA____" CLOB, 
	"SEQREABERTURA" NUMBER(10,0), 
	"DETALHAMENTOCAUSA" CLOB, 
	"ENVIAEMAILCRIACAO" CHAR(1 CHAR), 
	"ENVIAEMAILFINALIZACAO" CHAR(1 CHAR), 
	"ENVIAEMAILACOES" CHAR(1 CHAR), 
	"IDGRUPONIVEL1" NUMBER(10,0), 
	"SOLUCAOTEMPORARIA" CHAR(1 CHAR), 
	"IDSOLICITACAOSERVICOORIGEM" NUMBER(24,0), 
	"IDCALENDARIO" NUMBER(10,0), 
	"HOUVEMUDANCA" CHAR(1 CHAR), 
	"SLAACOMBINAR" CHAR(1 CHAR), 
	"PRAZOHHANTERIOR" NUMBER(5,0), 
	"PRAZOMMANTERIOR" NUMBER(5,0), 
	"TEMPODECORRIDOHH" NUMBER(5,0), 
	"TEMPODECORRIDOMM" NUMBER(5,0), 
	"DATAHORASUSPENSAO" DATE, 
	"DATAHORAREATIVACAO" DATE, 
	"IMPACTO" CHAR(1 CHAR), 
	"URGENCIA" CHAR(1 CHAR), 
	"TEMPOCAPTURAHH" NUMBER(5,0), 
	"TEMPOCAPTURAMM" NUMBER(5,0), 
	"TEMPOATRASOHH" NUMBER(5,0), 
	"TEMPOATRASOMM" NUMBER(5,0), 
	"TEMPOATENDIMENTOHH" NUMBER(5,0), 
	"TEMPOATENDIMENTOMM" NUMBER(5,0), 
	"DATAHORACAPTURA" DATE, 
	"IDBASECONHECIMENTO" NUMBER(10,0), 
	"IDACORDONIVELSERVICO" NUMBER(10,0), 
	"IDSOLICITACAORELACIONADA" NUMBER(10,0), 
	"DESCRICAOSEMFORMATACAO" CLOB, 
	"DATAHORAINICIOSLA" DATE, 
	"IDULTIMAAPROVACAO" NUMBER(10,0), 
	"SITUACAOSLA" CHAR(1 CHAR), 
	"DATAHORASUSPENSAOSLA" DATE, 
	"DATAHORAREATIVACAOSLA" DATE, 
	"PRAZOCAPTURAHH" NUMBER(10,0), 
	"PRAZOCAPTURAMM" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table SOLICITACAOSERVICOEVTMON
--------------------------------------------------------

  CREATE TABLE "SOLICITACAOSERVICOEVTMON" 
   (	"IDSOLICITACAOSERVICO" NUMBER(24,0), 
	"IDEVENTOMONITORAMENTO" NUMBER(10,0), 
	"IDRECURSO" NUMBER(10,0), 
	"NOMEHOST" VARCHAR2(255 CHAR), 
	"NOMESERVICE" VARCHAR2(255 CHAR), 
	"INFOADD" CLOB
   );
--------------------------------------------------------
--  DDL for Table SOLICITACAOSERVICOMUDANCA
--------------------------------------------------------

  CREATE TABLE "SOLICITACAOSERVICOMUDANCA" 
   (	"IDREQUISICAOMUDANCA" NUMBER(10,0), 
	"IDSOLICITACAOSERVICO" NUMBER(24,0)
   );
--------------------------------------------------------
--  DDL for Table SOLICITACAOSERVICOPROBLEMA
--------------------------------------------------------

  CREATE TABLE "SOLICITACAOSERVICOPROBLEMA" 
   (	"IDPROBLEMA" NUMBER(10,0), 
	"IDSOLICITACAOSERVICO" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table TABFEDERACAODADOS
--------------------------------------------------------

  CREATE TABLE "TABFEDERACAODADOS" 
   (	"NOMETABELA" VARCHAR2(255 CHAR), 
	"CHAVEFINAL" VARCHAR2(255 CHAR), 
	"CHAVEORIGINAL" VARCHAR2(255 CHAR), 
	"ORIGEM" VARCHAR2(255 CHAR), 
	"CRIACAO" DATE DEFAULT SYSDATE, 
	"ULTATUALIZ" DATE DEFAULT to_date('01-JAN-70 00:00:00', 'dd-MON-yy hh24:mi:ss')
   );
--------------------------------------------------------
--  DDL for Table TEMPLATESOLICITACAOSERVICO
--------------------------------------------------------

  CREATE TABLE "TEMPLATESOLICITACAOSERVICO" 
   (	"IDTEMPLATE" NUMBER(10,0), 
	"IDENTIFICACAO" VARCHAR2(40 CHAR), 
	"NOMETEMPLATE" VARCHAR2(200 CHAR), 
	"NOMECLASSEDTO" VARCHAR2(255 CHAR), 
	"NOMECLASSEACTION" VARCHAR2(255 CHAR), 
	"NOMECLASSESERVICO" VARCHAR2(255 CHAR), 
	"URLRECUPERACAO" VARCHAR2(255 CHAR), 
	"SCRIPTAPOSRECUPERACAO" CLOB, 
	"HABILITADIRECIONAMENTO" CHAR(1 CHAR), 
	"HABILITASITUACAO" CHAR(1 CHAR), 
	"HABILITASOLUCAO" CHAR(1 CHAR), 
	"ALTURADIV" NUMBER(10,0), 
	"HABILITAURGENCIAIMPACTO" CHAR(1 CHAR), 
	"HABILITANOTIFICACAOEMAIL" CHAR(1 CHAR), 
	"HABILITAPROBLEMA" CHAR(1 CHAR), 
	"HABILITAMUDANCA" CHAR(1 CHAR), 
	"HABILITAITEMCONFIGURACAO" CHAR(1 CHAR), 
	"HABILITASOLICITACAORELACIONADA" CHAR(1 CHAR), 
	"HABILITAGRAVARECONTINUAR" CHAR(1 CHAR)
   );
--------------------------------------------------------
--  DDL for Table TEMPOACORDONIVELSERVICO
--------------------------------------------------------

  CREATE TABLE "TEMPOACORDONIVELSERVICO" 
   (	"IDACORDONIVELSERVICO" NUMBER(24,0), 
	"IDPRIORIDADE" NUMBER(24,0), 
	"IDFASE" NUMBER(24,0), 
	"TEMPOHH" NUMBER(10,0), 
	"TEMPOMM" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table TIMERS
--------------------------------------------------------

  CREATE TABLE "TIMERS" 
   (	"TIMERID" VARCHAR2(80 CHAR), 
	"TARGETID" VARCHAR2(250 CHAR), 
	"INITIALDATE" DATE DEFAULT SYSDATE, 
	"TIMERINTERVAL" NUMBER(24,0), 
	"INSTANCEPK" BLOB, 
	"INFO" BLOB
   );
--------------------------------------------------------
--  DDL for Table TIMESHEET
--------------------------------------------------------

  CREATE TABLE "TIMESHEET" 
   (	"IDTIMESHEET" NUMBER(10,0), 
	"IDDEMANDA" NUMBER(10,0), 
	"IDEMPREGADO" NUMBER(10,0), 
	"IDPROJETO" NUMBER(10,0), 
	"QTDEHORAS" FLOAT(126), 
	"DATA" DATE, 
	"CUSTOPORHORA" FLOAT(126), 
	"DETALHAMENTO" CLOB
   );
--------------------------------------------------------
--  DDL for Table TIPOCOMPLEXIDADE
--------------------------------------------------------

  CREATE TABLE "TIPOCOMPLEXIDADE" 
   (	"COMPLEXIDADE" CHAR(1 CHAR), 
	"DESCTIPOCOMPLEXIDADE" VARCHAR2(50 CHAR)
   );
--------------------------------------------------------
--  DDL for Table TIPODEMANDA
--------------------------------------------------------

  CREATE TABLE "TIPODEMANDA" 
   (	"IDTIPODEMANDA" NUMBER(10,0), 
	"NOMETIPODEMANDA" VARCHAR2(40 CHAR)
   );
--------------------------------------------------------
--  DDL for Table TIPODEMANDASERVICO
--------------------------------------------------------

  CREATE TABLE "TIPODEMANDASERVICO" 
   (	"IDTIPODEMANDASERVICO" NUMBER(10,0), 
	"NOMETIPODEMANDASERVICO" VARCHAR2(70 CHAR), 
	"CLASSIFICACAO" CHAR(1 CHAR), 
	"DELETED" CHAR(1 CHAR)
   );
--------------------------------------------------------
--  DDL for Table TIPOEVENTOSERVICO
--------------------------------------------------------

  CREATE TABLE "TIPOEVENTOSERVICO" 
   (	"IDTIPOEVENTOSERVICO" NUMBER(10,0), 
	"NOMETIPOEVENTOSERVICO" VARCHAR2(70 CHAR), 
	"DELETED" CHAR(1 CHAR)
   );
--------------------------------------------------------
--  DDL for Table TIPOITEMCFGCARACTERISTICA
--------------------------------------------------------

  CREATE TABLE "TIPOITEMCFGCARACTERISTICA" 
   (	"ID" NUMBER(10,0), 
	"IDTIPOITEMCONFIGURACAO" NUMBER(10,0), 
	"IDCARACTERISTICA" NUMBER(10,0), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE, 
	"NAMEINFOAGENTE" VARCHAR2(255 CHAR)
   );
--------------------------------------------------------
--  DDL for Table TIPOITEMCONFIGURACAO
--------------------------------------------------------

  CREATE TABLE "TIPOITEMCONFIGURACAO" 
   (	"IDTIPOITEMCONFIGURACAO" NUMBER(10,0), 
	"IDEMPRESA" NUMBER(10,0), 
	"NOMETIPOITEMCONFIGURACAO" VARCHAR2(255 CHAR), 
	"TAGTIPOITEMCONFIGURACAO" VARCHAR2(50 CHAR), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE, 
	"SISTEMA" CHAR(1 CHAR), 
	"CATEGORIA" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table TIPOMUDANCA
--------------------------------------------------------

  CREATE TABLE "TIPOMUDANCA" 
   (	"IDTIPOMUDANCA" NUMBER(10,0), 
	"IDTIPOFLUXO" NUMBER(10,0), 
	"IDMODELOEMAILCRIACAO" NUMBER(10,0), 
	"IDMODELOEMAILFINALIZACAO" NUMBER(10,0), 
	"IDMODELOEMAILACOES" NUMBER(10,0), 
	"IDGRUPOEXECUTOR" NUMBER(10,0), 
	"IDCALENDARIO" NUMBER(10,0), 
	"NOMETIPOMUDANCA" VARCHAR2(100 CHAR), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE
   );
--------------------------------------------------------
--  DDL for Table TIPOOS
--------------------------------------------------------

  CREATE TABLE "TIPOOS" 
   (	"IDCLASSIFICACAOOS" NUMBER(10,0), 
	"IDCONTRATO" NUMBER(10,0), 
	"DESCRICAO" VARCHAR2(150 CHAR), 
	"DETALHAMENTO" CLOB
   );
--------------------------------------------------------
--  DDL for Table TIPOPROBLEMAATENDIMENTO
--------------------------------------------------------

  CREATE TABLE "TIPOPROBLEMAATENDIMENTO" 
   (	"IDTIPOPROBLEMA" NUMBER(24,0), 
	"IDTIPOPROBLEMAPAI" NUMBER(24,0), 
	"DESCRICAOPROBLEMA" CLOB, 
	"SITUACAO" CHAR(1 CHAR)
   );
--------------------------------------------------------
--  DDL for Table TIPOPRODUTO
--------------------------------------------------------

  CREATE TABLE "TIPOPRODUTO" 
   (	"IDTIPOPRODUTO" NUMBER(10,0), 
	"IDCATEGORIA" NUMBER(10,0), 
	"IDUNIDADEMEDIDA" NUMBER(10,0), 
	"NOMEPRODUTO" VARCHAR2(100 CHAR), 
	"SITUACAO" CHAR(1 CHAR), 
	"ACEITAREQUISICAO" CHAR(1 CHAR)
   );
--------------------------------------------------------
--  DDL for Table TIPOSATIVIDADES
--------------------------------------------------------

  CREATE TABLE "TIPOSATIVIDADES" 
   (	"IDTIPOATIVIDADE" NUMBER(10,0), 
	"DESCRICAOTIPOATIVIDADE" VARCHAR2(50 CHAR)
   );
--------------------------------------------------------
--  DDL for Table TIPOSERVICO
--------------------------------------------------------

  CREATE TABLE "TIPOSERVICO" 
   (	"IDTIPOSERVICO" NUMBER(10,0), 
	"IDEMPRESA" NUMBER(10,0), 
	"NOMETIPOSERVICO" VARCHAR2(300 CHAR), 
	"SITUACAO" CHAR(1 CHAR)
   );
--------------------------------------------------------
--  DDL for Table TIPOSOFTWARE
--------------------------------------------------------

  CREATE TABLE "TIPOSOFTWARE" 
   (	"IDTIPOSOFTWARE" NUMBER(10,0), 
	"NOME" VARCHAR2(200 CHAR)
   );
--------------------------------------------------------
--  DDL for Table TIPOUNIDADE
--------------------------------------------------------

  CREATE TABLE "TIPOUNIDADE" 
   (	"IDTIPOUNIDADE" NUMBER(10,0), 
	"IDEMPRESA" NUMBER(10,0), 
	"NOMETIPOUNIDADE" VARCHAR2(80 CHAR), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE
   );
--------------------------------------------------------
--  DDL for Table UFS
--------------------------------------------------------

  CREATE TABLE "UFS" 
   (	"IDUF" NUMBER(10,0), 
	"NOMEUF" VARCHAR2(50 CHAR), 
	"SIGLAUF" VARCHAR2(2 CHAR), 
	"IDREGIOES" VARCHAR2(45 CHAR), 
	"IDPAIS" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table UNIDADE
--------------------------------------------------------

  CREATE TABLE "UNIDADE" 
   (	"IDUNIDADE" NUMBER(10,0), 
	"IDUNIDADEPAI" NUMBER(10,0), 
	"IDTIPOUNIDADE" NUMBER(10,0), 
	"IDEMPRESA" NUMBER(10,0), 
	"NOME" VARCHAR2(255 CHAR), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE, 
	"DESCRICAO" CLOB, 
	"EMAIL" VARCHAR2(40 CHAR), 
	"IDENDERECO" NUMBER(10,0), 
	"ACEITAENTREGAPRODUTO" CHAR(1 CHAR)
   );
--------------------------------------------------------
--  DDL for Table UNIDADEBASEITEMCONFIGURACAO
--------------------------------------------------------

  CREATE TABLE "UNIDADEBASEITEMCONFIGURACAO" 
   (	"IDBASEITEMCONFIGURACAO" NUMBER(10,0), 
	"IDUNIDADE" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table UNIDADEMEDIDA
--------------------------------------------------------

  CREATE TABLE "UNIDADEMEDIDA" 
   (	"IDUNIDADEMEDIDA" NUMBER(10,0), 
	"NOMEUNIDADEMEDIDA" VARCHAR2(100 CHAR), 
	"SIGLAUNIDADEMEDIDA" VARCHAR2(10 CHAR), 
	"SITUACAO" CHAR(1 CHAR)
   );
--------------------------------------------------------
--  DDL for Table UNIDADESACCSERVICOS
--------------------------------------------------------

  CREATE TABLE "UNIDADESACCSERVICOS" 
   (	"IDUNIDADE" NUMBER(10,0), 
	"IDSERVICO" NUMBER(24,0)
   );
--------------------------------------------------------
--  DDL for Table URGENCIA
--------------------------------------------------------

  CREATE TABLE "URGENCIA" 
   (	"IDURGENCIA" NUMBER(10,0), 
	"NIVELURGENCIA" VARCHAR2(100 CHAR), 
	"SIGLAURGENCIA" CHAR(2 CHAR)
   );
--------------------------------------------------------
--  DDL for Table USUARIO
--------------------------------------------------------

  CREATE TABLE "USUARIO" 
   (	"IDUSUARIO" NUMBER(10,0), 
	"IDUNIDADE" NUMBER(10,0), 
	"IDEMPREGADO" NUMBER(10,0), 
	"IDEMPRESA" NUMBER(10,0), 
	"LOGIN" VARCHAR2(256 CHAR), 
	"NOME" VARCHAR2(256 CHAR), 
	"SENHA" VARCHAR2(300 CHAR), 
	"STATUS" CHAR(1 CHAR), 
	"LDAP" CHAR(1 CHAR), 
	"ULTIMOACESSOPORTAL" DATE
   );
--------------------------------------------------------
--  DDL for Table USUARIOITEMCONFIGURACAO
--------------------------------------------------------

  CREATE TABLE "USUARIOITEMCONFIGURACAO" 
   (	"IDUSUARIO" NUMBER(10,0), 
	"IDITEMCONFIGURACAO" NUMBER(10,0), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE
   );
--------------------------------------------------------
--  DDL for Table VALOR
--------------------------------------------------------

  CREATE TABLE "VALOR" 
   (	"IDVALOR" NUMBER(10,0), 
	"IDITEMCONFIGURACAO" NUMBER(10,0), 
	"IDCARACTERISTICA" NUMBER(10,0), 
	"VALORSTR" VARCHAR2(4000 CHAR), 
	"VALORLONGO" CLOB, 
	"VALORDECIMAL" FLOAT(126), 
	"VALORDATE" DATE, 
	"IDBASEITEMCONFIGURACAO" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table VALORAJUSTEGLOSA
--------------------------------------------------------

  CREATE TABLE "VALORAJUSTEGLOSA" 
   (	"IDSERVICOCONTRATO" NUMBER(24,0), 
	"IDACORDONIVELSERVICO" NUMBER(24,0), 
	"QUANTIDADEFALHAS" NUMBER(10,0), 
	"VALORAJUSTE" FLOAT(126), 
	"DELETED" CHAR(1 CHAR)
   );
--------------------------------------------------------
--  DDL for Table VALORSERVICOCONTRATO
--------------------------------------------------------

  CREATE TABLE "VALORSERVICOCONTRATO" 
   (	"IDSERVICOCONTRATO" NUMBER(24,0), 
	"IDSERVICO" NUMBER(10,0), 
	"VALORSERVICO" FLOAT(126), 
	"DATAINICIO" DATE, 
	"DATAFIM" DATE, 
	"IDVALORSERVICOCONTRATO" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table VALORVISAOCAMPOSNEGOCIO
--------------------------------------------------------

  CREATE TABLE "VALORVISAOCAMPOSNEGOCIO" 
   (	"IDVALORVISAOCAMPOSNEGOCIO" NUMBER(24,0), 
	"IDGRUPOVISAO" NUMBER(24,0), 
	"IDCAMPOSOBJETONEGOCIO" NUMBER(24,0), 
	"VALOR" VARCHAR2(500 CHAR), 
	"SITUACAO" CHAR(1 CHAR), 
	"DESCRICAO" VARCHAR2(500 CHAR)
   );
--------------------------------------------------------
--  DDL for Table VERSAO
--------------------------------------------------------

  CREATE TABLE "VERSAO" 
   (	"IDVERSAO" NUMBER(10,0), 
	"NOMEVERSAO" VARCHAR2(100 CHAR),
	"IDUSUARIO" NUMBER(10,0)
   );
--------------------------------------------------------
--  DDL for Table VINCULAOSINCIDENTE
--------------------------------------------------------

  CREATE TABLE "VINCULAOSINCIDENTE" 
   (	"IDOS" NUMBER(10,0), 
	"IDSOLICITACAOSERVICO" NUMBER(24,0), 
	"IDATIVIDADESOS" NUMBER(24,0)
   );
--------------------------------------------------------
--  DDL for Table VINCULOVISAO
--------------------------------------------------------

  CREATE TABLE "VINCULOVISAO" 
   (	"IDVISAORELACIONADA" NUMBER(24,0), 
	"SEQ" NUMBER(10,0), 
	"TIPOVINCULO" CHAR(1 CHAR), 
	"IDGRUPOVISAOPAI" NUMBER(24,0), 
	"IDCAMPOSOBJETONEGOCIOPAI" NUMBER(24,0), 
	"IDGRUPOVISAOFILHO" NUMBER(24,0), 
	"IDCAMPOSOBJETONEGOCIOFILHO" NUMBER(24,0), 
	"IDCAMPOSOBJETONEGOCIOPAINN" NUMBER(24,0), 
	"IDCAMPOSOBJETONEGOCIOFILHONN" NUMBER(24,0)
   );
--------------------------------------------------------
--  DDL for Table VISAO
--------------------------------------------------------

  CREATE TABLE "VISAO" 
   (	"IDVISAO" NUMBER(24,0), 
	"DESCRICAO" VARCHAR2(120 CHAR), 
	"TIPOVISAO" CHAR(2 CHAR), 
	"SITUACAO" CHAR(1 CHAR), 
	"CLASSENAME" VARCHAR2(500 CHAR), 
	"IDENTIFICADOR" VARCHAR2(100 CHAR)
   );
--------------------------------------------------------
--  DDL for Table VISAORELACIONADA
--------------------------------------------------------

  CREATE TABLE "VISAORELACIONADA" 
   (	"IDVISAORELACIONADA" NUMBER(24,0), 
	"IDVISAOPAI" NUMBER(24,0), 
	"IDVISAOFILHA" NUMBER(24,0), 
	"IDOBJETONEGOCIONN" NUMBER(24,0), 
	"ORDEM" NUMBER(10,0), 
	"TITULO" VARCHAR2(500 CHAR), 
	"SITUACAO" CHAR(1 CHAR), 
	"TIPOVINCULACAO" CHAR(1 CHAR), 
	"ACAOEMSELECAOPESQUISA" CHAR(2 CHAR)
   );
REM INSERTING into ACAOPLANOMELHORIA
SET DEFINE OFF;
REM INSERTING into ACORDONIVELSERVICO
SET DEFINE OFF;
Insert into ACORDONIVELSERVICO (IDACORDONIVELSERVICO,IDSERVICOCONTRATO,IDPRIORIDADEPADRAO,SITUACAO,TITULOSLA,DISPONIBILIDADE,DATAINICIO,DATAFIM,AVALIAREM,TIPO,DELETED,VALORLIMITE,UNIDADEVALORLIMITE,IMPACTO,URGENCIA,PERMITEMUDARIMPURG,IDFORMULA,CRIADOEM,CRIADOPOR,MODIFICADOEM,MODIFICADOPOR,TEMPOAUTO,IDPRIORIDADEAUTO1,IDPRIORIDADEAUTO2,IDPRIORIDADEAUTO3,IDPRIORIDADEAUTO4,IDPRIORIDADEAUTO5,IDGRUPO1,IDGRUPO2,IDGRUPO3,IDGRUPO4,IDGRUPO5) values ('1',null,null,'A','SLA 1',null,to_date('01/04/13','DD/MM/RR'),null,to_date('31/12/14','DD/MM/RR'),'T','N',null,' ','B','B','S',null,to_date('08/04/13','DD/MM/RR'),null,to_date('31/12/69','DD/MM/RR'),null,null,null,null,null,null,null,null,null,null,null,null);
Insert into ACORDONIVELSERVICO (IDACORDONIVELSERVICO,IDSERVICOCONTRATO,IDPRIORIDADEPADRAO,SITUACAO,TITULOSLA,DISPONIBILIDADE,DATAINICIO,DATAFIM,AVALIAREM,TIPO,DELETED,VALORLIMITE,UNIDADEVALORLIMITE,IMPACTO,URGENCIA,PERMITEMUDARIMPURG,IDFORMULA,CRIADOEM,CRIADOPOR,MODIFICADOEM,MODIFICADOPOR,TEMPOAUTO,IDPRIORIDADEAUTO1,IDPRIORIDADEAUTO2,IDPRIORIDADEAUTO3,IDPRIORIDADEAUTO4,IDPRIORIDADEAUTO5,IDGRUPO1,IDGRUPO2,IDGRUPO3,IDGRUPO4,IDGRUPO5) values ('2',null,null,'A','SLA 2',null,to_date('01/04/13','DD/MM/RR'),null,to_date('31/12/14','DD/MM/RR'),'T','N',null,' ','B','B','S',null,to_date('08/04/13','DD/MM/RR'),null,to_date('31/12/69','DD/MM/RR'),null,null,null,null,null,null,null,null,null,null,null,null);
Insert into ACORDONIVELSERVICO (IDACORDONIVELSERVICO,IDSERVICOCONTRATO,IDPRIORIDADEPADRAO,SITUACAO,TITULOSLA,DISPONIBILIDADE,DATAINICIO,DATAFIM,AVALIAREM,TIPO,DELETED,VALORLIMITE,UNIDADEVALORLIMITE,IMPACTO,URGENCIA,PERMITEMUDARIMPURG,IDFORMULA,CRIADOEM,CRIADOPOR,MODIFICADOEM,MODIFICADOPOR,TEMPOAUTO,IDPRIORIDADEAUTO1,IDPRIORIDADEAUTO2,IDPRIORIDADEAUTO3,IDPRIORIDADEAUTO4,IDPRIORIDADEAUTO5,IDGRUPO1,IDGRUPO2,IDGRUPO3,IDGRUPO4,IDGRUPO5) values ('3',null,null,'A','SLA 3',null,to_date('01/04/13','DD/MM/RR'),null,to_date('31/12/14','DD/MM/RR'),'T','N',null,' ','B','B','S',null,to_date('08/04/13','DD/MM/RR'),null,to_date('31/12/69','DD/MM/RR'),null,null,null,null,null,null,null,null,null,null,null,null);
REM INSERTING into ACORDONIVELSERVICOCONTRATO
SET DEFINE OFF;
REM INSERTING into ACORDONIVELSERVICO_HIST
SET DEFINE OFF;
Insert into ACORDONIVELSERVICO_HIST (IDACORDONIVELSERVICO_HIST,IDACORDONIVELSERVICO,IDSERVICOCONTRATO,IDPRIORIDADEPADRAO,SITUACAO,TITULOSLA,DISPONIBILIDADE,DATAINICIO,DATAFIM,AVALIAREM,TIPO,VALORLIMITE,UNIDADEVALORLIMITE,IMPACTO,URGENCIA,PERMITEMUDARIMPURG,DELETED,CRIADOEM,CRIADOPOR,MODIFICADOEM,MODIFICADOPOR,IDFORMULA) values ('1','1',null,null,'A','Acordo de Nível de Servico 1',null,to_date('01/04/13','DD/MM/RR'),null,to_date('31/12/14','DD/MM/RR'),'T',null,' ','B','B','S','N',to_date('05/04/13','DD/MM/RR'),'Administrador',to_date('05/04/13','DD/MM/RR'),'Administrador',null);
Insert into ACORDONIVELSERVICO_HIST (IDACORDONIVELSERVICO_HIST,IDACORDONIVELSERVICO,IDSERVICOCONTRATO,IDPRIORIDADEPADRAO,SITUACAO,TITULOSLA,DISPONIBILIDADE,DATAINICIO,DATAFIM,AVALIAREM,TIPO,VALORLIMITE,UNIDADEVALORLIMITE,IMPACTO,URGENCIA,PERMITEMUDARIMPURG,DELETED,CRIADOEM,CRIADOPOR,MODIFICADOEM,MODIFICADOPOR,IDFORMULA) values ('2','2',null,null,'A','Acordo de Nível de Servico 2',null,to_date('01/04/13','DD/MM/RR'),null,to_date('31/12/14','DD/MM/RR'),'T',null,' ','B','B','S','N',to_date('05/04/13','DD/MM/RR'),'Administrador',to_date('05/04/13','DD/MM/RR'),'Administrador',null);
Insert into ACORDONIVELSERVICO_HIST (IDACORDONIVELSERVICO_HIST,IDACORDONIVELSERVICO,IDSERVICOCONTRATO,IDPRIORIDADEPADRAO,SITUACAO,TITULOSLA,DISPONIBILIDADE,DATAINICIO,DATAFIM,AVALIAREM,TIPO,VALORLIMITE,UNIDADEVALORLIMITE,IMPACTO,URGENCIA,PERMITEMUDARIMPURG,DELETED,CRIADOEM,CRIADOPOR,MODIFICADOEM,MODIFICADOPOR,IDFORMULA) values ('3','3',null,null,'A','Acordo de Nível de Servico 3',null,to_date('01/04/13','DD/MM/RR'),null,to_date('31/12/14','DD/MM/RR'),'T',null,' ','B','B','S','N',to_date('05/04/13','DD/MM/RR'),'Administrador',to_date('05/04/13','DD/MM/RR'),'Administrador',null);
Insert into ACORDONIVELSERVICO_HIST (IDACORDONIVELSERVICO_HIST,IDACORDONIVELSERVICO,IDSERVICOCONTRATO,IDPRIORIDADEPADRAO,SITUACAO,TITULOSLA,DISPONIBILIDADE,DATAINICIO,DATAFIM,AVALIAREM,TIPO,VALORLIMITE,UNIDADEVALORLIMITE,IMPACTO,URGENCIA,PERMITEMUDARIMPURG,DELETED,CRIADOEM,CRIADOPOR,MODIFICADOEM,MODIFICADOPOR,IDFORMULA) values ('4','1',null,null,'A','SLA 1',null,to_date('01/04/13','DD/MM/RR'),null,to_date('31/12/14','DD/MM/RR'),'T',null,' ','B','B','S','N',to_date('08/04/13','DD/MM/RR'),'Administrador',to_date('08/04/13','DD/MM/RR'),'Administrador',null);
Insert into ACORDONIVELSERVICO_HIST (IDACORDONIVELSERVICO_HIST,IDACORDONIVELSERVICO,IDSERVICOCONTRATO,IDPRIORIDADEPADRAO,SITUACAO,TITULOSLA,DISPONIBILIDADE,DATAINICIO,DATAFIM,AVALIAREM,TIPO,VALORLIMITE,UNIDADEVALORLIMITE,IMPACTO,URGENCIA,PERMITEMUDARIMPURG,DELETED,CRIADOEM,CRIADOPOR,MODIFICADOEM,MODIFICADOPOR,IDFORMULA) values ('5','2',null,null,'A','SLA 2',null,to_date('01/04/13','DD/MM/RR'),null,to_date('31/12/14','DD/MM/RR'),'T',null,' ','B','B','S','N',to_date('08/04/13','DD/MM/RR'),'Administrador',to_date('08/04/13','DD/MM/RR'),'Administrador',null);
Insert into ACORDONIVELSERVICO_HIST (IDACORDONIVELSERVICO_HIST,IDACORDONIVELSERVICO,IDSERVICOCONTRATO,IDPRIORIDADEPADRAO,SITUACAO,TITULOSLA,DISPONIBILIDADE,DATAINICIO,DATAFIM,AVALIAREM,TIPO,VALORLIMITE,UNIDADEVALORLIMITE,IMPACTO,URGENCIA,PERMITEMUDARIMPURG,DELETED,CRIADOEM,CRIADOPOR,MODIFICADOEM,MODIFICADOPOR,IDFORMULA) values ('6','3',null,null,'A','SLA 3',null,to_date('01/04/13','DD/MM/RR'),null,to_date('31/12/14','DD/MM/RR'),'T',null,' ','B','B','S','N',to_date('08/04/13','DD/MM/RR'),'Administrador',to_date('08/04/13','DD/MM/RR'),'Administrador',null);
REM INSERTING into ACORDOSERVICOCONTRATO
SET DEFINE OFF;
Insert into ACORDOSERVICOCONTRATO (IDACORDOSERVICOCONTRATO,IDACORDONIVELSERVICO,IDSERVICOCONTRATO,DATACRIACAO,DATAINICIO,DATAFIM,DATAULTATUALIZ,DELETED,IDRECURSO) values ('1','1','1',to_date('05/04/13','DD/MM/RR'),to_date('01/04/13','DD/MM/RR'),null,to_date('05/04/13','DD/MM/RR'),null,null);
Insert into ACORDOSERVICOCONTRATO (IDACORDOSERVICOCONTRATO,IDACORDONIVELSERVICO,IDSERVICOCONTRATO,DATACRIACAO,DATAINICIO,DATAFIM,DATAULTATUALIZ,DELETED,IDRECURSO) values ('2','1','2',to_date('05/04/13','DD/MM/RR'),to_date('01/04/13','DD/MM/RR'),null,to_date('05/04/13','DD/MM/RR'),null,null);
Insert into ACORDOSERVICOCONTRATO (IDACORDOSERVICOCONTRATO,IDACORDONIVELSERVICO,IDSERVICOCONTRATO,DATACRIACAO,DATAINICIO,DATAFIM,DATAULTATUALIZ,DELETED,IDRECURSO) values ('3','2','3',to_date('05/04/13','DD/MM/RR'),to_date('01/04/13','DD/MM/RR'),null,to_date('05/04/13','DD/MM/RR'),null,null);
Insert into ACORDOSERVICOCONTRATO (IDACORDOSERVICOCONTRATO,IDACORDONIVELSERVICO,IDSERVICOCONTRATO,DATACRIACAO,DATAINICIO,DATAFIM,DATAULTATUALIZ,DELETED,IDRECURSO) values ('4','2','4',to_date('05/04/13','DD/MM/RR'),to_date('01/04/13','DD/MM/RR'),null,to_date('05/04/13','DD/MM/RR'),null,null);
Insert into ACORDOSERVICOCONTRATO (IDACORDOSERVICOCONTRATO,IDACORDONIVELSERVICO,IDSERVICOCONTRATO,DATACRIACAO,DATAINICIO,DATAFIM,DATAULTATUALIZ,DELETED,IDRECURSO) values ('5','3','5',to_date('05/04/13','DD/MM/RR'),to_date('01/04/13','DD/MM/RR'),null,to_date('05/04/13','DD/MM/RR'),null,null);
REM INSERTING into ALCADA
SET DEFINE OFF;
REM INSERTING into ALCADACENTRORESULTADO
SET DEFINE OFF;
REM INSERTING into ANEXO
SET DEFINE OFF;
REM INSERTING into ANEXOBASECONHECIMENTO
SET DEFINE OFF;
REM INSERTING into ANEXOINCIDENTE
SET DEFINE OFF;
REM INSERTING into ANEXOMUDANCA
SET DEFINE OFF;
REM INSERTING into APROVACAOMUDANCA
SET DEFINE OFF;
REM INSERTING into APROVACAOSOLICITACAOSERVICO
SET DEFINE OFF;
REM INSERTING into APURACAOVALORESRECURSO
SET DEFINE OFF;
REM INSERTING into ATIVIDADEPERIODICA
SET DEFINE OFF;
REM INSERTING into ATIVIDADES
SET DEFINE OFF;
REM INSERTING into ATIVIDADESFLUXOS
SET DEFINE OFF;
REM INSERTING into ATIVIDADESOS
SET DEFINE OFF;
REM INSERTING into ATIVIDADESSERVICOCONTRATO
SET DEFINE OFF;
REM INSERTING into AUDITORIA
SET DEFINE OFF;
REM INSERTING into AUDITORIAITEMCONFIGURACAO
SET DEFINE OFF;
REM INSERTING into AVALIACAOCOLETAPRECO
SET DEFINE OFF;
REM INSERTING into AVALIACAOCOTACAO
SET DEFINE OFF;
REM INSERTING into AVALIACAOFORNECEDOR
SET DEFINE OFF;
REM INSERTING into AVALIACAOPEDIDO
SET DEFINE OFF;
REM INSERTING into AVALIACAOREFERENCIAFORNECEDOR
SET DEFINE OFF;
REM INSERTING into BASECONHECIMENTO
SET DEFINE OFF;
Insert into BASECONHECIMENTO (IDBASECONHECIMENTO,IDPASTA,DATAINICIO,DATAFIM,TITULO,STATUS,IDBASECONHECIMENTOPAI,DATAEXPIRACAO,VERSAO,IDNOTIFICACAO,JUSTIFICATIVAOBSERVACAO,DATAPUBLICACAO,FONTEREFERENCIA,FAQ,ARQUIVADO,IDUSUARIOAUTOR,IDUSUARIOAPROVADOR,IDHISTORICOBASECONHECIMENTO,ORIGEM,PRIVACIDADE,SITUACAO,GERENCIAMENTODISPONIBILIDADE,DIREITOAUTORAL,LEGISLACAO) values ('1','1',to_date('08/04/13','DD/MM/RR'),null,'Conhecimento 1','S',null,to_date('31/12/14','DD/MM/RR'),'1.0',null,'Justificativa Conhecimento 1',to_date('08/04/13','DD/MM/RR'),'Conhecimento 1',null,'N','1','1','1','1','C','DS',null,null,null);
Insert into BASECONHECIMENTO (IDBASECONHECIMENTO,IDPASTA,DATAINICIO,DATAFIM,TITULO,STATUS,IDBASECONHECIMENTOPAI,DATAEXPIRACAO,VERSAO,IDNOTIFICACAO,JUSTIFICATIVAOBSERVACAO,DATAPUBLICACAO,FONTEREFERENCIA,FAQ,ARQUIVADO,IDUSUARIOAUTOR,IDUSUARIOAPROVADOR,IDHISTORICOBASECONHECIMENTO,ORIGEM,PRIVACIDADE,SITUACAO,GERENCIAMENTODISPONIBILIDADE,DIREITOAUTORAL,LEGISLACAO) values ('2','2',to_date('08/04/13','DD/MM/RR'),null,'Conhecimento 2','S',null,to_date('31/12/14','DD/MM/RR'),'1.0',null,'Justificativa Conhecimento 2',to_date('08/04/13','DD/MM/RR'),' ',null,'N','1','1','2','1','C','DS',null,null,null);
Insert into BASECONHECIMENTO (IDBASECONHECIMENTO,IDPASTA,DATAINICIO,DATAFIM,TITULO,STATUS,IDBASECONHECIMENTOPAI,DATAEXPIRACAO,VERSAO,IDNOTIFICACAO,JUSTIFICATIVAOBSERVACAO,DATAPUBLICACAO,FONTEREFERENCIA,FAQ,ARQUIVADO,IDUSUARIOAUTOR,IDUSUARIOAPROVADOR,IDHISTORICOBASECONHECIMENTO,ORIGEM,PRIVACIDADE,SITUACAO,GERENCIAMENTODISPONIBILIDADE,DIREITOAUTORAL,LEGISLACAO) values ('3','1',to_date('08/04/13','DD/MM/RR'),null,'FAQ 1','S',null,to_date('31/12/14','DD/MM/RR'),'1.0',null,'Justificativa FAQ 1',to_date('08/04/13','DD/MM/RR'),'FAQ 1','S','N','1','1','3','1','C','DS',null,null,null);
Insert into BASECONHECIMENTO (IDBASECONHECIMENTO,IDPASTA,DATAINICIO,DATAFIM,TITULO,STATUS,IDBASECONHECIMENTOPAI,DATAEXPIRACAO,VERSAO,IDNOTIFICACAO,JUSTIFICATIVAOBSERVACAO,DATAPUBLICACAO,FONTEREFERENCIA,FAQ,ARQUIVADO,IDUSUARIOAUTOR,IDUSUARIOAPROVADOR,IDHISTORICOBASECONHECIMENTO,ORIGEM,PRIVACIDADE,SITUACAO,GERENCIAMENTODISPONIBILIDADE,DIREITOAUTORAL,LEGISLACAO) values ('4','2',to_date('08/04/13','DD/MM/RR'),null,'FAQ 2','S',null,to_date('31/12/14','DD/MM/RR'),'1.0',null,'Justificativa FAQ 2',to_date('08/04/13','DD/MM/RR'),'FAQ 2','S','N','1','1','4','1','C','DS',null,null,null);
REM INSERTING into BASECONHECIMENTORELACIONADO
SET DEFINE OFF;
REM INSERTING into BASEITEMCONFIGURACAO
SET DEFINE OFF;
REM INSERTING into BIBLIOTECASEXTERNAS
SET DEFINE OFF;
REM INSERTING into BOTAOACAOVISAO
SET DEFINE OFF;
REM INSERTING into CALENDARIO
SET DEFINE OFF;
Insert into CALENDARIO (IDCALENDARIO,DESCRICAO,CONSIDERAFERIADOS,IDJORNADASEG,IDJORNADATER,IDJORNADAQUA,IDJORNADAQUI,IDJORNADASEX,IDJORNADASAB,IDJORNADADOM) values ('1','Padrão','S','1','1','1','1','1',null,null);
REM INSERTING into CAMPOOBJRELACIONADO
SET DEFINE OFF;
REM INSERTING into CAMPOSOBJETONEGOCIO
SET DEFINE OFF;
REM INSERTING into CARACTERISTICA
SET DEFINE OFF;
REM INSERTING into CARGOS
SET DEFINE OFF;
Insert into CARGOS (IDCARGO,NOMECARGO,DATAINICIO,DATAFIM) values ('1','Administrador do Sistema',to_date('01/01/12','DD/MM/RR'),null);
Insert into CARGOS (IDCARGO,NOMECARGO,DATAINICIO,DATAFIM) values ('2','Default',to_date('01/01/12','DD/MM/RR'),null);
Insert into CARGOS (IDCARGO,NOMECARGO,DATAINICIO,DATAFIM) values ('3','Coordenador HelpDesk',to_date('13/07/12','DD/MM/RR'),null);
REM INSERTING into CATALOGOSERVICO
SET DEFINE OFF;
REM INSERTING into CATEGORIAGALERIAIMAGEM
SET DEFINE OFF;
REM INSERTING into CATEGORIAMUDANCA
SET DEFINE OFF;
REM INSERTING into CATEGORIAOCORRENCIA
SET DEFINE OFF;
REM INSERTING into CATEGORIAPOST
SET DEFINE OFF;
REM INSERTING into CATEGORIAPROBLEMA
SET DEFINE OFF;
REM INSERTING into CATEGORIAPRODUTO
SET DEFINE OFF;
REM INSERTING into CATEGORIAQUESTIONARIO
SET DEFINE OFF;
Insert into CATEGORIAQUESTIONARIO (IDCATEGORIAQUESTIONARIO,NOMECATEGORIAQUESTIONARIO,IDEMPRESA,COMPARTILHADA) values ('1','CONTRATOS','1','N');
REM INSERTING into CATEGORIASERVICO
SET DEFINE OFF;
Insert into CATEGORIASERVICO (IDCATEGORIASERVICO,IDCATEGORIASERVICOPAI,IDEMPRESA,NOMECATEGORIASERVICO,DATAINICIO,DATAFIM,NOMECATEGORIASERVICOCONCATENAD,NOMECATSERVICOCONCATENADO) values ('1',null,'1','Categoria de Serviço 1',to_date('02/04/13','DD/MM/RR'),null,'Categoria de Serviço 1',null);
REM INSERTING into CATEGORIASOLUCAO
SET DEFINE OFF;
Insert into CATEGORIASOLUCAO (IDCATEGORIASOLUCAO,IDCATEGORIASOLUCAOPAI,DESCRICAOCATEGORIASOLUCAO,DATAINICIO,DATAFIM,DELETED) values ('1',null,'Software',to_date('01/01/12','DD/MM/RR'),null,'n');
Insert into CATEGORIASOLUCAO (IDCATEGORIASOLUCAO,IDCATEGORIASOLUCAOPAI,DESCRICAOCATEGORIASOLUCAO,DATAINICIO,DATAFIM,DELETED) values ('2','1','Ajuste de configuração de software',to_date('01/01/12','DD/MM/RR'),null,'n');
Insert into CATEGORIASOLUCAO (IDCATEGORIASOLUCAO,IDCATEGORIASOLUCAOPAI,DESCRICAOCATEGORIASOLUCAO,DATAINICIO,DATAFIM,DELETED) values ('3','1','Nova Instalação',to_date('01/01/12','DD/MM/RR'),null,null);
Insert into CATEGORIASOLUCAO (IDCATEGORIASOLUCAO,IDCATEGORIASOLUCAOPAI,DESCRICAOCATEGORIASOLUCAO,DATAINICIO,DATAFIM,DELETED) values ('4','1','Remoção de arquivos temporários',to_date('01/01/12','DD/MM/RR'),null,'n');
Insert into CATEGORIASOLUCAO (IDCATEGORIASOLUCAO,IDCATEGORIASOLUCAOPAI,DESCRICAOCATEGORIASOLUCAO,DATAINICIO,DATAFIM,DELETED) values ('5','1','Ajuste no sistema operacional',to_date('01/01/12','DD/MM/RR'),null,'n');
Insert into CATEGORIASOLUCAO (IDCATEGORIASOLUCAO,IDCATEGORIASOLUCAOPAI,DESCRICAOCATEGORIASOLUCAO,DATAINICIO,DATAFIM,DELETED) values ('6',null,'Hardware',to_date('01/01/12','DD/MM/RR'),null,'y');
Insert into CATEGORIASOLUCAO (IDCATEGORIASOLUCAO,IDCATEGORIASOLUCAOPAI,DESCRICAOCATEGORIASOLUCAO,DATAINICIO,DATAFIM,DELETED) values ('7','6','Reparo no hardware',to_date('01/01/12','DD/MM/RR'),null,'n');
Insert into CATEGORIASOLUCAO (IDCATEGORIASOLUCAO,IDCATEGORIASOLUCAOPAI,DESCRICAOCATEGORIASOLUCAO,DATAINICIO,DATAFIM,DELETED) values ('8','6','Substituição de hardware',to_date('01/01/12','DD/MM/RR'),null,'n');
Insert into CATEGORIASOLUCAO (IDCATEGORIASOLUCAO,IDCATEGORIASOLUCAOPAI,DESCRICAOCATEGORIASOLUCAO,DATAINICIO,DATAFIM,DELETED) values ('9','6','Manutenção preventiva',to_date('01/01/12','DD/MM/RR'),null,'n');
Insert into CATEGORIASOLUCAO (IDCATEGORIASOLUCAO,IDCATEGORIASOLUCAOPAI,DESCRICAOCATEGORIASOLUCAO,DATAINICIO,DATAFIM,DELETED) values ('10',null,'Ajuste na configuração do aplicativo',to_date('01/01/12','DD/MM/RR'),null,null);
Insert into CATEGORIASOLUCAO (IDCATEGORIASOLUCAO,IDCATEGORIASOLUCAOPAI,DESCRICAOCATEGORIASOLUCAO,DATAINICIO,DATAFIM,DELETED) values ('11',null,'Ajustes nas configurações do sistema',to_date('01/01/12','DD/MM/RR'),null,null);
Insert into CATEGORIASOLUCAO (IDCATEGORIASOLUCAO,IDCATEGORIASOLUCAOPAI,DESCRICAOCATEGORIASOLUCAO,DATAINICIO,DATAFIM,DELETED) values ('12',null,'Atualização no sistema operacional',to_date('01/01/12','DD/MM/RR'),null,null);
Insert into CATEGORIASOLUCAO (IDCATEGORIASOLUCAO,IDCATEGORIASOLUCAOPAI,DESCRICAOCATEGORIASOLUCAO,DATAINICIO,DATAFIM,DELETED) values ('13',null,'Aplicação de service pack',to_date('01/01/12','DD/MM/RR'),null,null);
Insert into CATEGORIASOLUCAO (IDCATEGORIASOLUCAO,IDCATEGORIASOLUCAOPAI,DESCRICAOCATEGORIASOLUCAO,DATAINICIO,DATAFIM,DELETED) values ('14',null,'Ajuste na configuração do browser',to_date('01/01/12','DD/MM/RR'),null,null);
Insert into CATEGORIASOLUCAO (IDCATEGORIASOLUCAO,IDCATEGORIASOLUCAOPAI,DESCRICAOCATEGORIASOLUCAO,DATAINICIO,DATAFIM,DELETED) values ('15',null,'Novas parametrizações',to_date('01/01/12','DD/MM/RR'),null,null);
Insert into CATEGORIASOLUCAO (IDCATEGORIASOLUCAO,IDCATEGORIASOLUCAOPAI,DESCRICAOCATEGORIASOLUCAO,DATAINICIO,DATAFIM,DELETED) values ('16',null,'Reconfiguração de parâmetros de rede',to_date('01/01/12','DD/MM/RR'),null,null);
Insert into CATEGORIASOLUCAO (IDCATEGORIASOLUCAO,IDCATEGORIASOLUCAOPAI,DESCRICAOCATEGORIASOLUCAO,DATAINICIO,DATAFIM,DELETED) values ('17',null,'Liberação de regras no firewall',to_date('01/01/12','DD/MM/RR'),null,null);
Insert into CATEGORIASOLUCAO (IDCATEGORIASOLUCAO,IDCATEGORIASOLUCAOPAI,DESCRICAOCATEGORIASOLUCAO,DATAINICIO,DATAFIM,DELETED) values ('18',null,'Alteração de regras no firewall',to_date('01/01/12','DD/MM/RR'),null,null);
Insert into CATEGORIASOLUCAO (IDCATEGORIASOLUCAO,IDCATEGORIASOLUCAOPAI,DESCRICAOCATEGORIASOLUCAO,DATAINICIO,DATAFIM,DELETED) values ('19',null,'Exclusão de regras no firewall',to_date('01/01/12','DD/MM/RR'),null,null);
Insert into CATEGORIASOLUCAO (IDCATEGORIASOLUCAO,IDCATEGORIASOLUCAOPAI,DESCRICAOCATEGORIASOLUCAO,DATAINICIO,DATAFIM,DELETED) values ('20',null,'Liberação de página no proxy',to_date('01/01/12','DD/MM/RR'),null,null);
Insert into CATEGORIASOLUCAO (IDCATEGORIASOLUCAO,IDCATEGORIASOLUCAOPAI,DESCRICAOCATEGORIASOLUCAO,DATAINICIO,DATAFIM,DELETED) values ('21',null,'Criação de usuários',to_date('01/01/12','DD/MM/RR'),null,null);
Insert into CATEGORIASOLUCAO (IDCATEGORIASOLUCAO,IDCATEGORIASOLUCAOPAI,DESCRICAOCATEGORIASOLUCAO,DATAINICIO,DATAFIM,DELETED) values ('22',null,'Mudança de perfil',to_date('01/01/12','DD/MM/RR'),null,null);
Insert into CATEGORIASOLUCAO (IDCATEGORIASOLUCAO,IDCATEGORIASOLUCAOPAI,DESCRICAOCATEGORIASOLUCAO,DATAINICIO,DATAFIM,DELETED) values ('23',null,'Backup e Restore',to_date('01/01/12','DD/MM/RR'),null,null);
Insert into CATEGORIASOLUCAO (IDCATEGORIASOLUCAO,IDCATEGORIASOLUCAOPAI,DESCRICAOCATEGORIASOLUCAO,DATAINICIO,DATAFIM,DELETED) values ('24',null,'Software',to_date('01/01/12','DD/MM/RR'),null,'y');
REM INSERTING into CAUSAINCIDENTE
SET DEFINE OFF;
Insert into CAUSAINCIDENTE (IDCAUSAINCIDENTE,IDCAUSAINCIDENTEPAI,DESCRICAOCAUSA,DATAINICIO,DATAFIM,DELETED) values ('1',null,'Software',to_date('01/01/12','DD/MM/RR'),null,null);
Insert into CAUSAINCIDENTE (IDCAUSAINCIDENTE,IDCAUSAINCIDENTEPAI,DESCRICAOCAUSA,DATAINICIO,DATAFIM,DELETED) values ('2','1','Instalação ineficaz',to_date('01/01/12','DD/MM/RR'),null,null);
Insert into CAUSAINCIDENTE (IDCAUSAINCIDENTE,IDCAUSAINCIDENTEPAI,DESCRICAOCAUSA,DATAINICIO,DATAFIM,DELETED) values ('3','1','Configuração',to_date('01/01/12','DD/MM/RR'),null,null);
Insert into CAUSAINCIDENTE (IDCAUSAINCIDENTE,IDCAUSAINCIDENTEPAI,DESCRICAOCAUSA,DATAINICIO,DATAFIM,DELETED) values ('4','1','Falta de Treinamento',to_date('01/01/12','DD/MM/RR'),null,null);
Insert into CAUSAINCIDENTE (IDCAUSAINCIDENTE,IDCAUSAINCIDENTEPAI,DESCRICAOCAUSA,DATAINICIO,DATAFIM,DELETED) values ('5',null,'Hardware',to_date('01/01/12','DD/MM/RR'),null,null);
Insert into CAUSAINCIDENTE (IDCAUSAINCIDENTE,IDCAUSAINCIDENTEPAI,DESCRICAOCAUSA,DATAINICIO,DATAFIM,DELETED) values ('6','5','Defeito',to_date('01/01/12','DD/MM/RR'),null,null);
Insert into CAUSAINCIDENTE (IDCAUSAINCIDENTE,IDCAUSAINCIDENTEPAI,DESCRICAOCAUSA,DATAINICIO,DATAFIM,DELETED) values ('7','5','Configuração',to_date('01/01/12','DD/MM/RR'),null,null);
Insert into CAUSAINCIDENTE (IDCAUSAINCIDENTE,IDCAUSAINCIDENTEPAI,DESCRICAOCAUSA,DATAINICIO,DATAFIM,DELETED) values ('8','5','Uso Indevido',to_date('01/01/12','DD/MM/RR'),null,null);
Insert into CAUSAINCIDENTE (IDCAUSAINCIDENTE,IDCAUSAINCIDENTEPAI,DESCRICAOCAUSA,DATAINICIO,DATAFIM,DELETED) values ('9','5','Outros',to_date('01/01/12','DD/MM/RR'),null,'n');
Insert into CAUSAINCIDENTE (IDCAUSAINCIDENTE,IDCAUSAINCIDENTEPAI,DESCRICAOCAUSA,DATAINICIO,DATAFIM,DELETED) values ('10','1','Erro no aplicativo',to_date('01/01/12','DD/MM/RR'),null,null);
Insert into CAUSAINCIDENTE (IDCAUSAINCIDENTE,IDCAUSAINCIDENTEPAI,DESCRICAOCAUSA,DATAINICIO,DATAFIM,DELETED) values ('11','1','Lentidão',to_date('01/01/12','DD/MM/RR'),null,null);
Insert into CAUSAINCIDENTE (IDCAUSAINCIDENTE,IDCAUSAINCIDENTEPAI,DESCRICAOCAUSA,DATAINICIO,DATAFIM,DELETED) values ('12','1','Erro na configuração',to_date('01/01/12','DD/MM/RR'),null,null);
Insert into CAUSAINCIDENTE (IDCAUSAINCIDENTE,IDCAUSAINCIDENTEPAI,DESCRICAOCAUSA,DATAINICIO,DATAFIM,DELETED) values ('13','5','Erro na configuração',to_date('01/01/12','DD/MM/RR'),null,'y');
Insert into CAUSAINCIDENTE (IDCAUSAINCIDENTE,IDCAUSAINCIDENTEPAI,DESCRICAOCAUSA,DATAINICIO,DATAFIM,DELETED) values ('14','9','Mudança não planejada',to_date('01/01/12','DD/MM/RR'),null,null);
REM INSERTING into CENTRORESULTADO
SET DEFINE OFF;
REM INSERTING into CIDADES
SET DEFINE OFF;
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0001','Acrelândia', '09');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0002','Assis Brasil', '09');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0003','Brasiléia' , '09');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0004','Bujari', '09 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0005','Capixaba', '09 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0006','Cruzeiro do Sul', '09 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0007','Epitaciolândia' , '09');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0008','Feijó', '09');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0009','Jordão', '09 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0010','Mâncio Lima' , '09 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0011','Manoel Urbano', '09 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0012','Marechal Thaumaturgo' , '09');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0013','Plácido de Castro', '09');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0014','Porto Acre', '09');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0015','Porto Walter', '09');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0016','Rio Branco', '09');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0017','Rodrigues Alves', '09 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0018','Santa Rosa do Purus', '09 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0019','Sena Madureira' , '09');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0020','Senador Guiomard' , '09');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0021','Tarauacá', '09 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0022','Xapuri', '09 ');

Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0023','Água Branca' , '10 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0024','Anadia', '10 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0025','Arapiraca' , '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0026','Atalaia' , '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0027','Barra de Santo Antônio' , '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0028','Barra de São Miguel', '10 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0029','Batalha' , '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0030','Belém', '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0031','Belo Monte', '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0032','Boca da Mata', '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0033','Branquinha', '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0034','Cacimbinhas' , '10 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0035','Cajueiro', '10 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0036','Campestre' , '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0037','Campo Alegre', '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0038','Campo Grande', '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0039','Canapi', '10 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0040','Capela', '10 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0041','Carneiros' , '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0042','Chã Preta' , '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0043','Coité do Nóia', '10 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0044','Colônia Leopoldina', '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0045','Coqueiro Seco', '10 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0046','Coruripe', '10 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0047','Craíbas' , '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0048','Delmiro Gouveia', '10 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0049','Dois Riachos', '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0050','Estrela de Alagoas', '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0051','Feira Grande', '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0052','Feliz Deserto', '10 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0053','Flexeiras' , '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0054','Girau do Ponciano', '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0055','Ibateguara', '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0056','Igaci', '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0057','Igreja Nova' , '10 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0058','Inhapi', '10 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0059','Jacaré dos Homens', '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0060','Jacuípe' , '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0061','Japaratinga' , '10 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0062','Jaramataia', '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0063','Joaquim Gomes', '10 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0064','Jundiá', '10 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0065','Junqueiro' , '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0066','Lagoa da Canoa' , '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0067','Limoeiro de Anadia', '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0068','Maceió', '10 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0069','Major Isidoro', '10 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0070','Mar Vermelho', '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0071','Maragogi', '10 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0072','Maravilha' , '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0073','Marechal Deodoro' , '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0074','Maribondo' , '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0075','Mata Grande' , '10 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0076','Matriz de Camaragibe' , '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0077','Messias' , '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0078','Minador do Negrão', '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0079','Monteirópolis', '10 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0080','Murici', '10 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0081','Novo Lino' , '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0082','Olho d`Água das Flores' , '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0083','Olho d`Água do Casado', '10 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0084','Olho d`Água Grande', '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0085','Olivença', '10 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0086','Ouro Branco' , '10 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0087','Palestina' , '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0088','Palmeira dos Índios', '10 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0089','Pão de Açúcar', '10 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0090','Pariconha' , '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0091','Paripueira', '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0092','Passo de Camaragibe', '10 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0093','Paulo Jacinto', '10 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0094','Penedo', '10 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0095','Piaçabuçu' , '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0096','Pilar', '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0097','Pindoba' , '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0098','Piranhas', '10 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0099','Poço das Trincheiras' , '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0100','Porto Calvo' , '10 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0101','Porto de Pedras', '10 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0102','Porto Real do Colégio', '10 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0103','Quebrangulo' , '10 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0104','Rio Largo' , '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0105','Roteiro' , '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0106','Santa Luzia do Norte' , '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0107','Santana do Ipanema', '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0108','Santana do Mundaú', '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0109','São Brás', '10 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0110','São José da Laje' , '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0111','São José da Tapera', '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0112','São Luís do Quitunde' , '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0113','São Miguel dos Campos', '10 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0114','São Miguel dos Milagres', '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0115','São Sebastião', '10 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0116','Satuba', '10 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0117','Senador Rui Palmeira' , '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0118','Tanque d`Arca', '10 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0119','Taquarana' , '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0120','Teotônio Vilela', '10 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0121','Traipu', '10 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0122','União dos Palmares', '10');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0123','Viçosa', '10 ');

Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0124','Amapá', '11');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0125','Calçoene', '11 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0126','Cutias', '11 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0127','Ferreira Gomes' , '11');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0128','Itaubal' , '11');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0129','Laranjal do Jari' , '11');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0130','Macapá', '11 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0131','Mazagão' , '11');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0132','Oiapoque', '11 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0133','Pedra Branca do Amaparí', '11');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0134','Porto Grande', '11');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0135','Pracuúba', '11 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0136','Santana' , '11');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0137','Serra do Navio' , '11');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0138','Tartarugalzinho', '11 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0139','Vitória do Jari', '11 ');

Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0140','Alvarães', '12 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0141','Amaturá' , '12');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0142','Anamã' , '12');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0143','Anori', '12');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0144','Apuí' , '12');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0145','Atalaia do Norte' , '12');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0146','Autazes' , '12');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0147','Barcelos', '12 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0148','Barreirinha' , '12 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0149','Benjamin Constant', '12');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0150','Beruri', '12 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0151','Boa Vista do Ramos', '12');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0152','Boca do Acre', '12');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0153','Borba', '12');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0154','Caapiranga', '12');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0155','Canutama', '12 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0156','Carauari', '12 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0157','Careiro' , '12');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0158','Careiro da Várzea', '12');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0159','Coari', '12');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0160','Codajás' , '12');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0161','Eirunepé', '12 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0162','Envira', '12 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0163','Fonte Boa' , '12');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0164','Guajará' , '12');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0165','Humaitá' , '12');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0166','Ipixuna' , '12');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0167','Iranduba', '12 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0168','Itacoatiara' , '12 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0169','Itamarati' , '12');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0170','Itapiranga', '12');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0171','Japurá', '12 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0172','Juruá', '12');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0173','Jutaí', '12');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0174','Lábrea', '12 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0175','Manacapuru', '12');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0176','Manaquiri' , '12');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0177','Manaus', '12 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0178','Manicoré', '12 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0179','Maraã', '12');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0180','Maués', '12');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0181','Nhamundá', '12 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0182','Nova Olinda do Norte' , '12');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0183','Novo Airão', '12');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0184','Novo Aripuanã', '12 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0185','Parintins' , '12');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0186','Pauini', '12 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0187','Presidente Figueiredo', '12 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0188','Rio Preto da Eva' , '12');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0189','Santa Isabel do Rio Negro', '12');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0190','Santo Antônio do Içá' , '12');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0191','São Gabriel da Cachoeira' , '12 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0192','São Paulo de Olivença', '12 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0193','São Sebastião do Uatumã', '12');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0194','Silves', '12 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0195','Tabatinga' , '12');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0196','Tapauá', '12 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0197','Tefé' , '12');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0198','Tonantins' , '12');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0199','Uarini', '12 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0200','Urucará' , '12');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0201','Urucurituba' , '12 ');

Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0202','Abaíra', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0203','Abaré', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0204','Acajutiba' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0205','Adustina', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0206','Água Fria' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0207','Aiquara' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0208','Alagoinhas', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0209','Alcobaça', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0210','Almadina', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0211','Amargosa', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0212','Amélia Rodrigues' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0213','América Dourada', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0214','Anagé', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0215','Andaraí' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0216','Andorinha' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0217','Angical' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0218','Anguera' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0219','Antas', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0220','Antônio Cardoso', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0221','Antônio Gonçalves', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0222','Aporá', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0223','Apuarema', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0224','Araças', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0225','Aracatu' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0226','Araci', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0227','Aramari' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0228','Arataca' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0229','Aratuípe', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0230','Aurelino Leal', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0231','Baianópolis' , '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0232','Baixa Grande', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0233','Banzaê', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0234','Barra', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0235','Barra da Estiva', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0236','Barra do Choça' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0237','Barra do Mendes', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0238','Barra do Rocha' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0239','Barreiras' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0240','Barro Alto', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0241','Belmonte', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0242','Belo Campo', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0243','Biritinga' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0244','Boa Nova', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0245','Boa Vista do Tupim', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0246','Bom Jesus da Lapa', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0247','Bom Jesus da Serra', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0248','Boninal' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0249','Bonito', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0250','Boquira' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0251','Botuporã', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0252','Brejões' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0253','Brejolândia' , '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0254','Brotas de Macaúbas', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0255','Brumado' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0256','Buerarema' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0257','Buritirama', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0258','Caatiba' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0259','Cabaceiras do Paraguaçu', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0260','Cachoeira' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0261','Caculé', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0262','Caém' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0263','Caetanos', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0264','Caetité' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0265','Cafarnaum' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0266','Cairu', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0267','Caldeirão Grande' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0268','Camacan' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0269','Camaçari', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0270','Camamu', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0271','Campo Alegre de Lourdes', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0272','Campo Formoso', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0273','Canápolis' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0274','Canarana', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0275','Canavieiras' , '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0276','Candeal' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0277','Candeias', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0278','Candiba' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0279','Cândido Sales', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0280','Cansanção' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0281','Canudos' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0282','Capela do Alto Alegre', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0283','Capim Grosso', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0284','Caraíbas', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0285','Caravelas' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0286','Cardeal da Silva' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0287','Carinhanha', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0288','Casa Nova' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0289','Castro Alves', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0290','Catolândia', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0291','Catu' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0292','Caturama', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0293','Central' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0294','Chorrochó' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0295','Cícero Dantas', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0296','Cipó' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0297','Coaraci' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0298','Cocos', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0299','Conceição da Feira', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0300','Conceição do Almeida' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0301','Conceição do Coité', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0302','Conceição do Jacuípe' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0303','Conde', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0304','Condeúba', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0305','Contendas do Sincorá' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0306','Coração de Maria' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0307','Cordeiros' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0308','Coribe', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0309','Coronel João Sá', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0310','Correntina', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0311','Cotegipe', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0312','Cravolândia' , '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0313','Crisópolis', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0314','Cristópolis' , '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0315','Cruz das Almas' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0316','Curaçá', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0317','Dário Meira' , '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0318','Dias d`Ávila', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0319','Dom Basílio' , '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0320','Dom Macedo Costa' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0321','Elísio Medrado' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0322','Encruzilhada', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0323','Entre Rios', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0324','Érico Cardoso', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0325','Esplanada' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0326','Euclides da Cunha', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0327','Eunápolis' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0328','Fátima', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0329','Feira da Mata', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0330','Feira de Santana' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0331','Filadélfia', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0332','Firmino Alves', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0333','Floresta Azul', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0334','Formosa do Rio Preto' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0335','Gandu', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0336','Gavião', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0337','Gentio do Ouro' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0338','Glória', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0339','Gongogi' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0340','Governador Lomanto Júnior', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0341','Governador Mangabeira', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0342','Guajeru' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0343','Guanambi', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0344','Guaratinga', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0345','Heliópolis', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0346','Iaçu' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0347','Ibiassucê' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0348','Ibicaraí', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0349','Ibicoara', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0350','Ibicuí', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0351','Ibipeba' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0352','Ibipitanga', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0353','Ibiquera', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0354','Ibirapitanga', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0355','Ibirapuã', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0356','Ibirataia' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0357','Ibitiara', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0358','Ibititá' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0359','Ibotirama' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0360','Ichu' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0361','Igaporã' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0362','Igrapiúna' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0363','Iguaí', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0364','Ilhéus', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0365','Inhambupe' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0366','Ipecaetá', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0367','Ipiaú', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0368','Ipirá', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0369','Ipupiara', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0370','Irajuba' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0371','Iramaia' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0372','Iraquara', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0373','Irará', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0374','Irecê', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0375','Itabela' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0376','Itaberaba' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0377','Itabuna' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0378','Itacaré' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0379','Itaeté', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0380','Itagi', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0381','Itagibá' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0382','Itagimirim', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0383','Itaguaçu da Bahia', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0384','Itaju do Colônia' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0385','Itajuípe', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0386','Itamaraju' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0387','Itamari' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0388','Itambé', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0389','Itanagra', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0390','Itanhém' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0391','Itaparica' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0392','Itapé', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0393','Itapebi' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0394','Itapetinga', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0395','Itapicuru' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0396','Itapitanga', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0397','Itaquara', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0398','Itarantim' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0399','Itatim', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0400','Itiruçu' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0401','Itiúba', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0402','Itororó' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0403','Ituaçu', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0404','Ituberá' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0405','Iuiú' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0406','Jaborandi' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0407','Jacaraci', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0408','Jacobina', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0409','Jaguaquara', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0410','Jaguarari' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0411','Jaguaripe' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0412','Jandaíra', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0413','Jequié', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0414','Jeremoabo' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0415','Jiquiriçá' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0416','Jitaúna' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0417','João Dourado', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0418','Juazeiro', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0419','Jucuruçu', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0420','Jussara' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0421','Jussari' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0422','Jussiape', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0423','Lafaiete Coutinho', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0424','Lagoa Real', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0425','Laje' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0426','Lajedão' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0427','Lajedinho' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0428','Lajedo do Tabocal', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0429','Lamarão' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0430','Lapão', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0431','Lauro de Freitas' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0432','Lençóis' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0433','Licínio de Almeida', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0434','Livramento de Nossa Senhora' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0435','Macajuba', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0436','Macarani', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0437','Macaúbas', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0438','Macururé', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0439','Madre de Deus', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0440','Maetinga', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0441','Maiquinique' , '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0442','Mairi', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0443','Malhada' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0444','Malhada de Pedras', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0445','Manoel Vitorino', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0446','Mansidão', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0447','Maracás' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0448','Maragogipe', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0449','Maraú', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0450','Marcionílio Souza', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0451','Mascote' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0452','Mata de São João' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0453','Matina', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0454','Medeiros Neto', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0455','Miguel Calmon', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0456','Milagres', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0457','Mirangaba' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0458','Mirante' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0459','Monte Santo' , '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0460','Morpará' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0461','Morro do Chapéu', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0462','Mortugaba' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0463','Mucugê', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0464','Mucuri', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0465','Mulungu do Morro' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0466','Mundo Novo', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0467','Muniz Ferreira' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0468','Muquém de São Francisco', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0469','Muritiba', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0470','Mutuípe' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0471','Nazaré', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0472','Nilo Peçanha', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0473','Nordestina', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0474','Nova Canaã', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0475','Nova Fátima' , '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0476','Nova Ibiá' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0477','Nova Itarana', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0478','Nova Redenção', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0479','Nova Soure', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0480','Nova Viçosa' , '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0481','Novo Horizonte' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0482','Novo Triunfo', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0483','Olindina', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0484','Oliveira dos Brejinhos' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0485','Ouriçangas', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0486','Ourolândia', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0487','Palmas de Monte Alto' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0488','Palmeiras' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0489','Paramirim' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0490','Paratinga' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0491','Paripiranga' , '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0492','Pau Brasil', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0493','Paulo Afonso', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0494','Pé de Serra' , '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0495','Pedrão', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0496','Pedro Alexandre', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0497','Piatã', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0498','Pilão Arcado', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0499','Pindaí', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0500','Pindobaçu' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0501','Pintadas', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0502','Piraí do Norte' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0503','Piripá', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0504','Piritiba', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0505','Planaltino', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0506','Planalto', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0507','Poções', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0508','Pojuca', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0509','Ponto Novo', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0510','Porto Seguro', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0511','Potiraguá' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0512','Prado', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0513','Presidente Dutra' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0514','Presidente Jânio Quadros' , '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0515','Presidente Tancredo Neves', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0516','Queimadas' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0517','Quijingue' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0518','Quixabeira', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0519','Rafael Jambeiro', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0520','Remanso' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0521','Retirolândia', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0522','Riachão das Neves', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0523','Riachão do Jacuípe', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0524','Riacho de Santana', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0525','Ribeira do Amparo', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0526','Ribeira do Pombal', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0527','Ribeirão do Largo', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0528','Rio de Contas', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0529','Rio do Antônio' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0530','Rio do Pires', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0531','Rio Real', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0532','Rodelas' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0533','Ruy Barbosa' , '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0534','Salinas da Margarida' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0535','Salvador', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0536','Santa Bárbara', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0537','Santa Brígida', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0538','Santa Cruz Cabrália', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0539','Santa Cruz da Vitória', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0540','Santa Inês', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0541','Santa Luzia' , '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0542','Santa Maria da Vitória' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0543','Santa Rita de Cássia' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0544','Santa Teresinha', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0545','Santaluz', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0546','Santana' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0547','Santanópolis', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0548','Santo Amaro' , '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0549','Santo Antônio de Jesus' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0550','Santo Estêvão', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0551','São Desidério', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0552','São Domingos', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0553','São Felipe', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0554','São Félix' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0555','São Félix do Coribe', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0556','São Francisco do Conde' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0557','São Gabriel' , '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0558','São Gonçalo dos Campos' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0559','São José da Vitória', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0560','São José do Jacuípe', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0561','São Miguel das Matas' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0562','São Sebastião do Passé' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0563','Sapeaçu' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0564','Sátiro Dias' , '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0565','Saubara' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0566','Saúde', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0567','Seabra', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0568','Sebastião Laranjeiras', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0569','Senhor do Bonfim' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0570','Sento Sé', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0571','Serra do Ramalho' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0572','Serra Dourada', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0573','Serra Preta' , '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0574','Serrinha', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0575','Serrolândia' , '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0576','Simões Filho', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0577','Sítio do Mato', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0578','Sítio do Quinto', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0579','Sobradinho', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0580','Souto Soares', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0581','Tabocas do Brejo Velho' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0582','Tanhaçu' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0583','Tanque Novo' , '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0584','Tanquinho' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0585','Taperoá' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0586','Tapiramutá', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0587','Teixeira de Freitas', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0588','Teodoro Sampaio', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0589','Teofilândia' , '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0590','Teolândia' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0591','Terra Nova', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0592','Tremedal', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0593','Tucano', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0594','Uauá' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0595','Ubaíra', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0596','Ubaitaba', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0597','Ubatã', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0598','Uibaí', '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0599','Umburanas' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0600','Una', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0601','Urandi', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0602','Uruçuca' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0603','Utinga', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0604','Valença' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0605','Valente' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0606','Várzea da Roça' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0607','Várzea do Poço' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0608','Várzea Nova' , '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0609','Varzedo' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0610','Vera Cruz' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0611','Vereda', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0612','Vitória da Conquista' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0613','Wagner', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0614','Wanderley' , '13');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0615','Wenceslau Guimarães', '13 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0616','Xique-Xique' , '13 ');

Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0617','Abaiara' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0618','Acarapé' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0619','Acaraú', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0620','Acopiara', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0621','Aiuaba', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0622','Alcântaras', '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0623','Altaneira' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0624','Alto Santo', '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0625','Amontada', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0626','Antonina do Norte', '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0627','Apuiarés', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0628','Aquiraz' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0629','Aracati' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0630','Aracoiaba' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0631','Ararendá', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0632','Araripe' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0633','Aratuba' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0634','Arneiroz', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0635','Assaré', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0636','Aurora', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0637','Baixio', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0638','Banabuiú', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0639','Barbalha', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0640','Barreira', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0641','Barro', '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0642','Barroquinha' , '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0643','Baturité', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0644','Beberibe', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0645','Bela Cruz' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0646','Boa Viagem', '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0647','Brejo Santo' , '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0648','Camocim' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0649','Campos Sales', '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0650','Canindé' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0651','Capistrano', '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0652','Caridade', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0653','Cariré', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0654','Caririaçu' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0655','Cariús', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0656','Carnaubal' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0657','Cascavel', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0658','Catarina', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0659','Catunda' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0660','Caucaia' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0661','Cedro', '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0662','Chaval', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0663','Choró', '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0664','Chorozinho', '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0665','Coreaú', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0666','Crateús' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0667','Crato', '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0668','Croatá', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0669','Cruz' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0670','Deputado Irapuan Pinheiro', '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0671','Ererê', '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0672','Eusébio' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0673','Farias Brito', '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0674','Forquilha' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0675','Fortaleza' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0676','Fortim', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0677','Frecheirinha', '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0678','General Sampaio', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0679','Graça', '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0680','Granja', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0681','Granjeiro' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0682','Groaíras', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0683','Guaiúba' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0684','Guaraciaba do Norte', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0685','Guaramiranga', '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0686','Hidrolândia' , '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0687','Horizonte' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0688','Ibaretama' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0689','Ibiapina', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0690','Ibicuitinga' , '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0691','Icapuí', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0692','Icó', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0693','Iguatu', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0694','Independência', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0695','Ipaporanga', '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0696','Ipaumirim' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0697','Ipu', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0698','Ipueiras', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0699','Iracema' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0700','Irauçuba', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0701','Itaiçaba', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0702','Itaitinga' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0703','Itapagé' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0704','Itapipoca' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0705','Itapiúna', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0706','Itarema' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0707','Itatira' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0708','Jaguaretama' , '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0709','Jaguaribara' , '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0710','Jaguaribe' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0711','Jaguaruana', '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0712','Jardim', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0713','Jati' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0714','Jijoca de Jericoacoara' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0715','Juazeiro do Norte', '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0716','Jucás', '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0717','Lavras da Mangabeira' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0718','Limoeiro do Norte', '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0719','Madalena', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0720','Maracanaú' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0721','Maranguape', '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0722','Marco', '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0723','Martinópole' , '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0724','Massapê' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0725','Mauriti' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0726','Meruoca' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0727','Milagres', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0728','Milhã', '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0729','Miraíma' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0730','Missão Velha', '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0731','Mombaça' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0732','Monsenhor Tabosa' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0733','Morada Nova' , '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0734','Moraújo' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0735','Morrinhos' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0736','Mucambo' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0737','Mulungu' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0738','Nova Olinda' , '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0739','Nova Russas' , '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0740','Novo Oriente', '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0741','Ocara', '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0742','Orós' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0743','Pacajus' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0744','Pacatuba', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0745','Pacoti', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0746','Pacujá', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0747','Palhano' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0748','Palmácia', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0749','Paracuru', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0750','Paraipaba' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0751','Parambu' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0752','Paramoti', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0753','Pedra Branca', '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0754','Penaforte' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0755','Pentecoste', '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0756','Pereiro' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0757','Pindoretama' , '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0758','Piquet Carneiro', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0759','Pires Ferreira' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0760','Poranga' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0761','Porteiras' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0762','Potengi' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0763','Potiretama', '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0764','Quiterianópolis', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0765','Quixadá' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0766','Quixelô' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0767','Quixeramobim', '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0768','Quixeré' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0769','Redenção', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0770','Reriutaba' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0771','Russas', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0772','Saboeiro', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0773','Salitre' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0774','Santa Quitéria' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0775','Santana do Acaraú', '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0776','Santana do Cariri', '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0777','São Benedito', '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0778','São Gonçalo do Amarante', '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0779','São João do Jaguaribe', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0780','São Luís do Curu' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0781','Senador Pompeu' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0782','Senador Sá', '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0783','Sobral', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0784','Solonópole', '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0785','Tabuleiro do Norte', '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0786','Tamboril', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0787','Tarrafas', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0788','Tauá' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0789','Tejuçuoca' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0790','Tianguá' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0791','Trairi', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0792','Tururu', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0793','Ubajara' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0794','Umari', '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0795','Umirim', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0796','Uruburetama' , '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0797','Uruoca', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0798','Varjota' , '14');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0799','Várzea Alegre', '14 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0800','Viçosa do Ceará', '14 ');

Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0801','Brasília', '01 ');

Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0802','Afonso Cláudio' , '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0803','Água Doce do Norte', '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0804','Águia Branca', '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0805','Alegre', '08 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0806','Alfredo Chaves' , '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0807','Alto Rio Novo', '08 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0808','Anchieta', '08 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0809','Apiacá', '08 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0810','Aracruz' , '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0811','Atilio Vivacqua', '08 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0812','Baixo Guandu', '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0813','Barra de São Francisco' , '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0814','Boa Esperança', '08 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0815','Bom Jesus do Norte', '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0816','Brejetuba' , '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0817','Cachoeiro de Itapemirim', '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0818','Cariacica' , '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0819','Castelo' , '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0820','Colatina', '08 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0821','Conceição da Barra', '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0822','Conceição do Castelo' , '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0823','Divino de São Lourenço' , '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0824','Domingos Martins' , '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0825','Dores do Rio Preto', '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0826','Ecoporanga', '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0827','Fundão', '08 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0828','Guaçuí', '08 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0829','Guarapari' , '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0830','Ibatiba' , '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0831','Ibiraçu' , '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0832','Ibitirama' , '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0833','Iconha', '08 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0834','Irupi', '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0835','Itaguaçu', '08 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0836','Itapemirim', '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0837','Itarana' , '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0838','Iúna' , '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0839','Jaguaré' , '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0840','Jerônimo Monteiro', '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0841','João Neiva', '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0842','Laranja da Terra' , '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0843','Linhares', '08 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0844','Mantenópolis', '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0845','Marataízes', '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0846','Marechal Floriano', '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0847','Marilândia', '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0848','Mimoso do Sul', '08 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0849','Montanha', '08 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0850','Mucurici', '08 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0851','Muniz Freire', '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0852','Muqui', '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0853','Nova Venécia', '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0854','Pancas', '08 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0855','Pedro Canário', '08 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0856','Pinheiros' , '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0857','Piúma', '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0858','Ponto Belo', '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0859','Presidente Kennedy', '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0860','Rio Bananal' , '08 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0861','Rio Novo do Sul', '08 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0862','Santa Leopoldina' , '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0863','Santa Maria de Jetibá', '08 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0864','Santa Teresa', '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0865','São Domingos do Norte', '08 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0866','São Gabriel da Palha' , '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0867','São José do Calçado', '08 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0868','São Mateus', '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0869','São Roque do Canaã', '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0870','Serra', '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0871','Sooretama' , '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0872','Vargem Alta' , '08 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0873','Venda Nova do Imigrante', '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0874','Viana', '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0875','Vila Pavão', '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0876','Vila Valério', '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0877','Vila Velha', '08');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0878','Vitória' , '08');

Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0879','Abadia de Goiás', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0880','Abadiânia' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0881','Acreúna' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0882','Adelândia' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0883','Água Fria de Goiás', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0884','Água Limpa', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0885','Águas Lindas de Goiás', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0886','Alexânia', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0887','Aloândia', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0888','Alto Horizonte' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0889','Alto Paraíso de Goiás', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0890','Alvorada do Norte', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0891','Amaralina' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0892','Americano do Brasil', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0893','Amorinópolis', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0894','Anápolis', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0895','Anhanguera', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0896','Anicuns' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0897','Aparecida de Goiânia' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0898','Aparecida do Rio Doce', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0899','Aporé', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0900','Araçu', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0901','Aragarças' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0902','Aragoiânia', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0903','Araguapaz' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0904','Arenópolis', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0905','Aruanã', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0906','Aurilândia', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0907','Avelinópolis', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0908','Baliza', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0909','Barro Alto', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0910','Bela Vista de Goiás', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0911','Bom Jardim de Goiás', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0912','Bom Jesus de Goiás', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0913','Bonfinópolis', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0914','Bonópolis' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0915','Brazabrantes', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0916','Britânia', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0917','Buriti Alegre', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0918','Buriti de Goiás', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0919','Buritinópolis', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0920','Cabeceiras', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0921','Cachoeira Alta' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0922','Cachoeira de Goiás', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0923','Cachoeira Dourada', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0924','Caçu' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0925','Caiapônia' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0926','Caldas Novas', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0927','Caldazinha', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0928','Campestre de Goiás', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0929','Campinaçu' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0930','Campinorte', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0931','Campo Alegre de Goiás', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0932','Campos Belos', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0933','Campos Verdes', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0934','Carmo do Rio Verde', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0935','Castelândia' , '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0936','Catalão' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0937','Caturaí' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0938','Cavalcante', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0939','Ceres', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0940','Cezarina', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0941','Chapadão do Céu', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0942','CIDADES Ocidental', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0943','Cocalzinho de Goiás', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0944','Colinas do Sul' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0945','Córrego do Ouro', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0946','Corumbá de Goiás' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0947','Corumbaíba', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0948','Cristalina', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0949','Cristianópolis' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0950','Crixás', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0951','Cromínia', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0952','Cumari', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0953','Damianópolis', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0954','Damolândia', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0955','Davinópolis' , '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0956','Diorama' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0957','Divinópolis de Goiás' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0958','Doverlândia' , '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0959','Edealina', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0960','Edéia', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0961','Estrela do Norte' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0962','Faina', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0963','Fazenda Nova', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0964','Firminópolis', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0965','Flores de Goiás', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0966','Formosa' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0967','Formoso' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0968','Goianápolis' , '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0969','Goiandira' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0970','Goianésia' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0971','Goiânia' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0972','Goianira', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0973','Goiás', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0974','Goiatuba', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0975','Gouvelândia' , '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0976','Guapó', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0977','Guaraíta', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0978','Guarani de Goiás' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0979','Guarinos', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0980','Heitoraí', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0981','Hidrolândia' , '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0982','Hidrolina' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0983','Iaciara' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0984','Inaciolândia', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0985','Indiara' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0986','Inhumas' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0987','Ipameri' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0988','Iporá', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0989','Israelândia' , '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0990','Itaberaí', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0991','Itaguari', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0992','Itaguaru', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0993','Itajá', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0994','Itapaci' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0995','Itapirapuã', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0996','Itapuranga', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0997','Itarumã' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0998','Itauçu', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('0999','Itumbiara' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1000','Ivolândia' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1001','Jandaia' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1002','Jaraguá' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1003','Jataí', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1004','Jaupaci' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1005','Jesúpolis' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1006','Joviânia', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1007','Jussara' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1008','Leopoldo de Bulhões', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1009','Luziânia', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1010','Mairipotaba' , '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1011','Mambaí', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1012','Mara Rosa' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1013','Marzagão', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1014','Matrinchã' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1015','Maurilândia' , '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1016','Mimoso de Goiás', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1017','Minaçu', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1018','Mineiros', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1019','Moiporá' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1020','Monte Alegre de Goiás', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1021','Montes Claros de Goiás' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1022','Montividiu', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1023','Montividiu do Norte', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1024','Morrinhos' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1025','Morro Agudo de Goiás' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1026','Mossâmedes', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1027','Mozarlândia' , '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1028','Mundo Novo', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1029','Mutunópolis' , '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1030','Nazário' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1031','Nerópolis' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1032','Niquelândia' , '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1033','Nova América', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1034','Nova Aurora' , '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1035','Nova Crixás' , '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1036','Nova Glória' , '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1037','Nova Iguaçu de Goiás' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1038','Nova Roma' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1039','Nova Veneza' , '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1040','Novo Brasil' , '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1041','Novo Gama' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1042','Novo Planalto', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1043','Orizona' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1044','Ouro Verde de Goiás', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1045','Ouvidor' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1046','Padre Bernardo' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1047','Palestina de Goiás', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1048','Palmeiras de Goiás', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1049','Palmelo' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1050','Palminópolis', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1051','Panamá', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1052','Paranaiguara', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1053','Paraúna' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1054','Perolândia', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1055','Petrolina de Goiás', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1056','Pilar de Goiás' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1057','Piracanjuba' , '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1058','Piranhas', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1059','Pirenópolis' , '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1060','Pires do Rio', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1061','Planaltina', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1062','Pontalina' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1063','Porangatu' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1064','Porteirão' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1065','Portelândia' , '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1066','Posse', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1067','Professor Jamil', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1068','Quirinópolis', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1069','Rialma', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1070','Rianápolis', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1071','Rio Quente', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1072','Rio Verde' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1073','Rubiataba' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1074','Sanclerlândia', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1075','Santa Bárbara de Goiás' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1076','Santa Cruz de Goiás', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1077','Santa Fé de Goiás', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1078','Santa Helena de Goiás', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1079','Santa Isabel', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1080','Santa Rita do Araguaia' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1081','Santa Rita do Novo Destino', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1082','Santa Rosa de Goiás', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1083','Santa Tereza de Goiás', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1084','Santa Terezinha de Goiás' , '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1085','Santo Antônio da Barra' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1086','Santo Antônio de Goiás' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1087','Santo Antônio do Descoberto' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1088','São Domingos', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1089','São Francisco de Goiás' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1090','São João d`Aliança', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1091','São João da Paraúna', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1092','São Luís de Montes Belos' , '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1093','São Luíz do Norte', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1094','São Miguel do Araguaia' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1095','São Miguel do Passa Quatro', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1096','São Patrício', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1097','São Simão' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1098','Senador Canedo' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1099','Serranópolis', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1100','Silvânia', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1101','Simolândia', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1102','Sítio d`Abadia' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1103','Taquaral de Goiás', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1104','Teresina de Goiás', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1105','Terezópolis de Goiás' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1106','Três Ranchos', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1107','Trindade', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1108','Trombas' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1109','Turvânia', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1110','Turvelândia' , '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1111','Uirapuru', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1112','Uruaçu', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1113','Uruana', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1114','Urutaí', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1115','Valparaíso de Goiás', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1116','Varjão', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1117','Vianópolis', '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1118','Vicentinópolis' , '04');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1119','Vila Boa', '04 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1120','Vila Propício', '04 ');

Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1121','Açailândia', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1122','Afonso Cunha', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1123','Água Doce do Maranhão', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1124','Alcântara' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1125','Aldeias Altas', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1126','Altamira do Maranhão' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1127','Alto Alegre do Maranhão', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1128','Alto Alegre do Pindaré' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1129','Alto Parnaíba', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1130','Amapá do Maranhão', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1131','Amarante do Maranhão' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1132','Anajatuba' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1133','Anapurus', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1134','Apicum-Açu', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1135','Araguanã', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1136','Araioses', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1137','Arame', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1138','Arari', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1139','Axixá', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1140','Bacabal' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1141','Bacabeira' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1142','Bacuri', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1143','Bacurituba', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1144','Balsas', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1145','Barão de Grajaú', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1146','Barra do Corda' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1147','Barreirinhas', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1148','Bela Vista do Maranhão' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1149','Belágua' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1150','Benedito Leite' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1151','Bequimão', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1152','Bernardo do Mearim', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1153','Boa Vista do Gurupi', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1154','Bom Jardim', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1155','Bom Jesus das Selvas' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1156','Bom Lugar' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1157','Brejo', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1158','Brejo de Areia' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1159','Buriti', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1160','Buriti Bravo', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1161','Buriticupu', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1162','Buritirana', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1163','Cachoeira Grande' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1164','Cajapió' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1165','Cajari', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1166','Campestre do Maranhão', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1167','Cândido Mendes' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1168','Cantanhede', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1169','Capinzal do Norte', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1170','Carolina', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1171','Carutapera', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1172','Caxias', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1173','Cedral', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1174','Central do Maranhão', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1175','Centro do Guilherme', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1176','Centro Novo do Maranhão', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1177','Chapadinha', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1178','Cidelândia', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1179','Codó' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1180','Coelho Neto' , '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1181','Colinas' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1182','Conceição do Lago-Açu', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1183','Coroatá' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1184','Cururupu', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1185','Davinópolis' , '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1186','Dom Pedro' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1187','Duque Bacelar', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1188','Esperantinópolis' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1189','Estreito', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1190','Feira Nova do Maranhão' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1191','Fernando Falcão', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1192','Formosa da Serra Negra' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1193','Fortaleza dos Nogueiras', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1194','Fortuna' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1195','Godofredo Viana', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1196','Gonçalves Dias' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1197','Governador Archer', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1198','Governador Edison Lobão', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1199','Governador Eugênio Barros', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1200','Governador Luiz Rocha', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1201','Governador Newton Bello', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1202','Governador Nunes Freire', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1203','Graça Aranha', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1204','Grajaú', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1205','Guimarães' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1206','Humberto de Campos', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1207','Icatu', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1208','Igarapé do Meio', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1209','Igarapé Grande' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1210','Imperatriz', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1211','Itaipava do Grajaú', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1212','Itapecuru Mirim', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1213','Itinga do Maranhão', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1214','Jatobá', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1215','Jenipapo dos Vieiras' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1216','João Lisboa' , '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1217','Joselândia', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1218','Junco do Maranhão', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1219','Lago da Pedra', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1220','Lago do Junco', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1221','Lago dos Rodrigues', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1222','Lago Verde', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1223','Lagoa do Mato', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1224','Lagoa Grande do Maranhão' , '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1225','Lajeado Novo', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1226','Lima Campos' , '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1227','Loreto', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1228','Luís Domingues' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1229','Magalhães de Almeida' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1230','Maracaçumé', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1231','Marajá do Sena' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1232','Maranhãozinho', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1233','Mata Roma' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1234','Matinha' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1235','Matões', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1236','Matões do Norte', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1237','Milagres do Maranhão' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1238','Mirador' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1239','Miranda do Norte' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1240','Mirinzal', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1241','Monção', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1242','Montes Altos', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1243','Morros', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1244','Nina Rodrigues' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1245','Nova Colinas', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1246','Nova Iorque' , '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1247','Nova Olinda do Maranhão', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1248','Olho d`Água das Cunhãs' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1249','Olinda Nova do Maranhão', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1250','Paço do Lumiar' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1251','Palmeirândia', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1252','Paraibano' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1253','Parnarama' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1254','Passagem Franca', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1255','Pastos Bons' , '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1256','Paulino Neves', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1257','Paulo Ramos' , '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1258','Pedreiras' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1259','Pedro do Rosário' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1260','Penalva' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1261','Peri Mirim', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1262','Peritoró', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1263','Pindaré-Mirim', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1264','Pinheiro', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1265','Pio XII' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1266','Pirapemas' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1267','Poção de Pedras', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1268','Porto Franco', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1269','Porto Rico do Maranhão' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1270','Presidente Dutra' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1271','Presidente Juscelino' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1272','Presidente Médici', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1273','Presidente Sarney', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1274','Presidente Vargas', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1275','Primeira Cruz', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1276','Raposa', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1277','Riachão' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1278','Ribamar Fiquene', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1279','Rosário' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1280','Sambaíba', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1281','Santa Filomena do Maranhão', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1282','Santa Helena', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1283','Santa Inês', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1284','Santa Luzia' , '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1285','Santa Luzia do Paruá' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1286','Santa Quitéria do Maranhão', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1287','Santa Rita', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1288','Santana do Maranhão', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1289','Santo Amaro do Maranhão', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1290','Santo Antônio dos Lopes', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1291','São Benedito do Rio Preto', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1292','São Bento' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1293','São Bernardo', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1294','São Domingos do Azeitão', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1295','São Domingos do Maranhão' , '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1296','São Félix de Balsas', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1297','São Francisco do Brejão', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1298','São Francisco do Maranhão', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1299','São João Batista' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1300','São João do Carú' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1301','São João do Paraíso', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1302','São João do Soter', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1303','São João dos Patos', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1304','São José de Ribamar', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1305','São José dos Basílios', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1306','São Luís', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1307','São Luís Gonzaga do Maranhão', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1308','São Mateus do Maranhão' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1309','São Pedro da Água Branca' , '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1310','São Pedro dos Crentes', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1311','São Raimundo das Mangabeiras', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1312','São Raimundo do Doca Bezerra', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1313','São Roberto' , '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1314','São Vicente Ferrer', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1315','Satubinha' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1316','Senador Alexandre Costa', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1317','Senador La Rocque', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1318','Serrano do Maranhão', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1319','Sítio Novo', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1320','Sucupira do Norte', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1321','Sucupira do Riachão', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1322','Tasso Fragoso', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1323','Timbiras', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1324','Timon', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1325','Trizidela do Vale', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1326','Tufilândia', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1327','Tuntum', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1328','Turiaçu' , '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1329','Turilândia', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1330','Tutóia', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1331','Urbano Santos', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1332','Vargem Grande', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1333','Viana', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1334','Vila Nova dos Martírios', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1335','Vitória do Mearim', '15');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1336','Vitorino Freire', '15 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1337','Zé Doca' , '15');

Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1338','Acorizal', '16 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1339','Água Boa', '16 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1340','Alta Floresta', '16 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1341','Alto Araguaia', '16 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1342','Alto Boa Vista' , '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1343','Alto Garças' , '16 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1344','Alto Paraguai', '16 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1345','Alto Taquari', '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1346','Apiacás' , '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1347','Araguaiana', '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1348','Araguainha', '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1349','Araputanga', '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1350','Arenápolis', '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1351','Aripuanã', '16 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1352','Barão de Melgaço' , '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1353','Barra do Bugres', '16 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1354','Barra do Garças', '16 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1355','Brasnorte' , '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1356','Cáceres' , '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1357','Campinápolis', '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1358','Campo Novo do Parecis', '16 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1359','Campo Verde' , '16 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1360','Campos de Júlio', '16 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1361','Canabrava do Norte', '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1362','Canarana', '16 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1363','Carlinda', '16 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1364','Castanheira' , '16 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1365','Chapada dos Guimarães', '16 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1366','Cláudia' , '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1367','Cocalinho' , '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1368','Colíder' , '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1369','Comodoro', '16 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1370','Confresa', '16 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1371','Cotriguaçu', '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1372','Cuiabá', '16 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1373','Denise', '16 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1374','Diamantino', '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1375','Dom Aquino', '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1376','Feliz Natal' , '16 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1377','Figueirópolis d`Oeste', '16 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1378','Gaúcha do Norte', '16 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1379','General Carneiro' , '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1380','Glória d`Oeste' , '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1381','Guarantã do Norte', '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1382','Guiratinga', '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1383','Indiavaí', '16 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1384','Itaúba', '16 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1385','Itiquira', '16 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1386','Jaciara' , '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1387','Jangada' , '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1388','Jauru', '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1389','Juara', '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1390','Juína', '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1391','Juruena' , '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1392','Juscimeira', '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1393','Lambari d`Oeste', '16 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1394','Lucas do Rio Verde', '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1395','Luciára' , '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1396','Marcelândia' , '16 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1397','Matupá', '16 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1398','Mirassol d`Oeste' , '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1399','Nobres', '16 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1400','Nortelândia' , '16 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1401','Nossa Senhora do Livramento' , '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1402','Nova Bandeirantes', '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1403','Nova Brasilândia' , '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1404','Nova Canaã do Norte', '16 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1405','Nova Guarita', '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1406','Nova Lacerda', '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1407','Nova Marilândia', '16 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1408','Nova Maringá', '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1409','Nova Monte Verde' , '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1410','Nova Mutum', '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1411','Nova Olímpia', '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1412','Nova Ubiratã', '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1413','Nova Xavantina' , '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1414','Novo Horizonte do Norte', '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1415','Novo Mundo', '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1416','Novo São Joaquim' , '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1417','Paranaíta' , '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1418','Paranatinga' , '16 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1419','Pedra Preta' , '16 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1420','Peixoto de Azevedo', '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1421','Planalto da Serra', '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1422','Poconé', '16 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1423','Pontal do Araguaia', '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1424','Ponte Branca', '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1425','Pontes e Lacerda' , '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1426','Porto Alegre do Norte', '16 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1427','Porto dos Gaúchos', '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1428','Porto Esperidião' , '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1429','Porto Estrela', '16 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1430','Poxoréo' , '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1431','Primavera do Leste', '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1432','Querência' , '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1433','Reserva do Cabaçal', '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1434','Ribeirão Cascalheira' , '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1435','Ribeirãozinho', '16 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1436','Rio Branco', '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1437','Rondonópolis', '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1438','Rosário Oeste', '16 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1439','Salto do Céu', '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1440','Santa Carmem', '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1441','Santa Terezinha', '16 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1442','Santo Afonso', '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1443','Santo Antônio do Leverger', '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1444','São Félix do Araguaia', '16 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1445','São José do Povo' , '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1446','São José do Rio Claro', '16 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1447','São José do Xingu', '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1448','São José dos Quatro Marcos', '16 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1449','São Pedro da Cipa', '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1450','Sapezal' , '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1451','Sinop', '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1452','Sorriso' , '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1453','Tabaporã', '16 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1454','Tangará da Serra' , '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1455','Tapurah' , '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1456','Terra Nova do Norte', '16 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1457','Tesouro' , '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1458','Torixoréu' , '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1459','União do Sul', '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1460','Várzea Grande', '16 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1461','Vera' , '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1462','Vila Bela da Santíssima Trindade' , '16');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1463','Vila Rica' , '16');

Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1464','Água Clara', '17');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1465','Alcinópolis' , '17 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1466','Amambaí' , '17');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1467','Anastácio' , '17');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1468','Anaurilândia', '17');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1469','Angélica', '17 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1470','Antônio João', '17');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1471','Aparecida do Taboado' , '17');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1472','Aquidauana', '17');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1473','Aral Moreira', '17');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1474','Bandeirantes', '17');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1475','Bataguassu', '17');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1476','Bataiporã' , '17');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1477','Bela Vista', '17');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1478','Bodoquena' , '17');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1479','Bonito', '17 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1480','Brasilândia' , '17 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1481','Caarapó' , '17');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1482','Camapuã' , '17');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1483','Campo Grande', '17');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1484','Caracol' , '17');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1485','Cassilândia' , '17 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1486','Chapadão do Sul', '17 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1487','Corguinho' , '17');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1488','Coronel Sapucaia' , '17');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1489','Corumbá' , '17');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1490','Costa Rica', '17');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1491','Coxim', '17');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1492','Deodápolis', '17');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1493','Dois Irmãos do Buriti', '17 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1494','Douradina' , '17');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1495','Dourados', '17 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1496','Eldorado', '17 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1497','Fátima do Sul', '17 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1498','Glória de Dourados', '17');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1499','Guia Lopes da Laguna' , '17');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1500','Iguatemi', '17 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1501','Inocência' , '17');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1502','Itaporã' , '17');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1503','Itaquiraí' , '17');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1504','Ivinhema', '17 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1505','Japorã', '17 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1506','Jaraguari' , '17');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1507','Jardim', '17 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1508','Jateí', '17');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1509','Juti' , '17');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1510','Ladário' , '17');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1511','Laguna Carapã', '17 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1512','Maracaju', '17 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1513','Miranda' , '17');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1514','Mundo Novo', '17');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1515','Naviraí' , '17');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1516','Nioaque' , '17');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1517','Nova Alvorada do Sul' , '17');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1518','Nova Andradina' , '17');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1519','Novo Horizonte do Sul', '17 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1520','Paranaíba' , '17');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1521','Paranhos', '17 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1522','Pedro Gomes' , '17 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1523','Ponta Porã', '17');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1524','Porto Murtinho' , '17');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1525','Ribas do Rio Pardo', '17');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1526','Rio Brilhante', '17 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1527','Rio Negro' , '17');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1528','Rio Verde de Mato Grosso' , '17 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1529','Rochedo' , '17');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1530','Santa Rita do Pardo', '17 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1531','São Gabriel do Oeste' , '17');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1532','Selvíria', '17 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1533','Sete Quedas' , '17 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1534','Sidrolândia' , '17 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1535','Sonora', '17 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1536','Tacuru', '17 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1537','Taquarussu', '17');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1538','Terenos' , '17');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1539','Três Lagoas' , '17 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1540','Vicentina' , '17');

Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1541','Abadia dos Dourados', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1542','Abaeté', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1543','Abre Campo', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1544','Acaiaca' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1545','Açucena' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1546','Água Boa', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1547','Água Comprida', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1548','Aguanil' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1549','Águas Formosas' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1550','Águas Vermelhas', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1551','Aimorés' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1552','Aiuruoca', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1553','Alagoa', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1554','Albertina' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1555','Além Paraíba', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1556','Alfenas' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1557','Alfredo Vasconcelos', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1558','Almenara', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1559','Alpercata' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1560','Alpinópolis' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1561','Alterosa', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1562','Alto Caparaó', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1563','Alto Jequitibá' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1564','Alto Rio Doce', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1565','Alvarenga' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1566','Alvinópolis' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1567','Alvorada de Minas', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1568','Amparo do Serra', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1569','Andradas', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1570','Andrelândia' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1571','Angelândia', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1572','Antônio Carlos' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1573','Antônio Dias', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1574','Antônio Prado de Minas' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1575','Araçaí', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1576','Aracitaba' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1577','Araçuaí' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1578','Araguari', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1579','Arantina', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1580','Araponga', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1581','Araporã' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1582','Arapuá', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1583','Araújos' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1584','Araxá', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1585','Arceburgo' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1586','Arcos', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1587','Areado', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1588','Argirita', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1589','Aricanduva', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1590','Arinos', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1591','Astolfo Dutra', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1592','Ataléia' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1593','Augusto de Lima', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1594','Baependi', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1595','Baldim', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1596','Bambuí', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1597','Bandeira', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1598','Bandeira do Sul', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1599','Barão de Cocais', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1600','Barão de Monte Alto', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1601','Barbacena' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1602','Barra Longa' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1603','Barroso' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1604','Bela Vista de Minas', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1605','Belmiro Braga', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1606','Belo Horizonte' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1607','Belo Oriente', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1608','Belo Vale' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1609','Berilo', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1610','Berizal' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1611','Bertópolis', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1612','Betim', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1613','Bias Fortes' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1614','Bicas', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1615','Biquinhas' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1616','Boa Esperança', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1617','Bocaina de Minas' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1618','Bocaiúva', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1619','Bom Despacho', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1620','Bom Jardim de Minas', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1621','Bom Jesus da Penha', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1622','Bom Jesus do Amparo', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1623','Bom Jesus do Galho', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1624','Bom Repouso' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1625','Bom Sucesso' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1626','Bonfim', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1627','Bonfinópolis de Minas', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1628','Bonito de Minas', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1629','Borda da Mata', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1630','Botelhos', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1631','Botumirim' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1632','Brás Pires', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1633','Brasilândia de Minas' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1634','Brasília de Minas', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1635','Brasópolis', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1636','Braúnas' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1637','Brumadinho', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1638','Bueno Brandão', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1639','Buenópolis', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1640','Bugre', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1641','Buritis' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1642','Buritizeiro' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1643','Cabeceira Grande' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1644','Cabo Verde', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1645','Cachoeira da Prata', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1646','Cachoeira de Minas', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1647','Cachoeira de Pajeú', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1648','Cachoeira Dourada', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1649','Caetanópolis', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1650','Caeté', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1651','Caiana', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1652','Cajuri', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1653','Caldas', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1654','Camacho' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1655','Camanducaia' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1656','Cambuí', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1657','Cambuquira', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1658','Campanário', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1659','Campanha', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1660','Campestre' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1661','Campina Verde', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1662','Campo Azul', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1663','Campo Belo', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1664','Campo do Meio', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1665','Campo Florido', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1666','Campos Altos', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1667','Campos Gerais', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1668','Cana Verde', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1669','Canaã', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1670','Canápolis' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1671','Candeias', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1672','Cantagalo' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1673','Caparaó' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1674','Capela Nova' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1675','Capelinha' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1676','Capetinga' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1677','Capim Branco', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1678','Capinópolis' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1679','Capitão Andrade', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1680','Capitão Enéas', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1681','Capitólio' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1682','Caputira', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1683','Caraí', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1684','Caranaíba' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1685','Carandaí', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1686','Carangola' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1687','Caratinga' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1688','Carbonita' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1689','Careaçu' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1690','Carlos Chagas', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1691','Carmésia', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1692','Carmo da Cachoeira', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1693','Carmo da Mata', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1694','Carmo de Minas' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1695','Carmo do Cajuru', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1696','Carmo do Paranaíba', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1697','Carmo do Rio Claro', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1698','Carmópolis de Minas', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1699','Carneirinho' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1700','Carrancas' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1701','Carvalhópolis', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1702','Carvalhos' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1703','Casa Grande' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1704','Cascalho Rico', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1705','Cássia', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1706','Cataguases', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1707','Catas Altas' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1708','Catas Altas da Noruega' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1709','Catuji', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1710','Catuti', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1711','Caxambu' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1712','Cedro do Abaeté', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1713','Central de Minas' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1714','Centralina', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1715','Chácara' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1716','Chalé', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1717','Chapada do Norte' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1718','Chapada Gaúcha' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1719','Chiador' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1720','Cipotânea' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1721','Claraval', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1722','Claro dos Poções' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1723','Cláudio' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1724','Coimbra' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1725','Coluna', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1726','Comendador Gomes' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1727','Comercinho', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1728','Conceição da Aparecida' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1729','Conceição da Barra de Minas' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1730','Conceição das Alagoas', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1731','Conceição das Pedras' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1732','Conceição de Ipanema' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1733','Conceição do Mato Dentro' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1734','Conceição do Pará', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1735','Conceição do Rio Verde' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1736','Conceição dos Ouros', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1737','Cônego Marinho' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1738','Confins' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1739','Congonhal' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1740','Congonhas' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1741','Congonhas do Norte', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1742','Conquista' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1743','Conselheiro Lafaiete' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1744','Conselheiro Pena' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1745','Consolação', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1746','Contagem', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1747','Coqueiral' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1748','Coração de Jesus' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1749','Cordisburgo' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1750','Cordislândia', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1751','Corinto' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1752','Coroaci' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1753','Coromandel', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1754','Coronel Fabriciano', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1755','Coronel Murta', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1756','Coronel Pacheco', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1757','Coronel Xavier Chaves', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1758','Córrego Danta', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1759','Córrego do Bom Jesus' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1760','Córrego Fundo', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1761','Córrego Novo', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1762','Couto de Magalhães de Minas' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1763','Crisólita' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1764','Cristais', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1765','Cristália' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1766','Cristiano Otoni', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1767','Cristina', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1768','Crucilândia' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1769','Cruzeiro da Fortaleza', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1770','Cruzília', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1771','Cuparaque' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1772','Curral de Dentro' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1773','Curvelo' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1774','Datas', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1775','Delfim Moreira' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1776','Delfinópolis', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1777','Delta', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1778','Descoberto', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1779','Desterro de Entre Rios' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1780','Desterro do Melo' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1781','Diamantina', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1782','Diogo de Vasconcelos' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1783','Dionísio', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1784','Divinésia' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1785','Divino', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1786','Divino das Laranjeiras' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1787','Divinolândia de Minas', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1788','Divinópolis' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1789','Divisa Alegre', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1790','Divisa Nova' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1791','Divisópolis' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1792','Dom Bosco' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1793','Dom Cavati', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1794','Dom Joaquim' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1795','Dom Silvério', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1796','Dom Viçoso', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1797','Dona Eusébia', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1798','Dores de Campos', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1799','Dores de Guanhães', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1800','Dores do Indaiá', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1801','Dores do Turvo' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1802','Doresópolis' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1803','Douradoquara', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1804','Durandé' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1805','Elói Mendes' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1806','Engenheiro Caldas', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1807','Engenheiro Navarro', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1808','Entre Folhas', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1809','Entre Rios de Minas', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1810','Ervália' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1811','Esmeraldas', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1812','Espera Feliz', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1813','Espinosa', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1814','Espírito Santo do Dourado', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1815','Estiva', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1816','Estrela Dalva', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1817','Estrela do Indaiá', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1818','Estrela do Sul' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1819','Eugenópolis' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1820','Ewbank da Câmara' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1821','Extrema' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1822','Fama' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1823','Faria Lemos' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1824','Felício dos Santos', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1825','Felisburgo', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1826','Felixlândia' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1827','Fernandes Tourinho', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1828','Ferros', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1829','Fervedouro', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1830','Florestal' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1831','Formiga' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1832','Formoso' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1833','Fortaleza de Minas', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1834','Fortuna de Minas' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1835','Francisco Badaró' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1836','Francisco Dumont' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1837','Francisco Sá', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1838','Franciscópolis' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1839','Frei Gaspar' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1840','Frei Inocêncio' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1841','Frei Lagonegro' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1842','Fronteira' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1843','Fronteira dos Vales', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1844','Fruta de Leite' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1845','Frutal', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1846','Funilândia', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1847','Galiléia', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1848','Gameleiras', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1849','Glaucilândia', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1850','Goiabeira' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1851','Goianá', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1852','Gonçalves' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1853','Gonzaga' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1854','Gouveia' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1855','Governador Valadares' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1856','Grão Mogol', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1857','Grupiara', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1858','Guanhães', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1859','Guapé', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1860','Guaraciaba', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1861','Guaraciama', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1862','Guaranésia', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1863','Guarani' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1864','Guarará' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1865','Guarda-Mor', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1866','Guaxupé' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1867','Guidoval', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1868','Guimarânia', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1869','Guiricema' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1870','Gurinhatã' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1871','Heliodora' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1872','Iapu' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1873','Ibertioga' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1874','Ibiá' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1875','Ibiaí', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1876','Ibiracatu' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1877','Ibiraci' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1878','Ibirité' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1879','Ibitiúra de Minas', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1880','Ibituruna' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1881','Icaraí de Minas', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1882','Igarapé' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1883','Igaratinga', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1884','Iguatama', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1885','Ijaci', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1886','Ilicínea', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1887','Imbé de Minas', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1888','Inconfidentes', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1889','Indaiabira', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1890','Indianópolis', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1891','Ingaí', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1892','Inhapim' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1893','Inhaúma' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1894','Inimutaba' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1895','Ipaba', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1896','Ipanema' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1897','Ipatinga', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1898','Ipiaçu', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1899','Ipuiúna' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1900','Iraí de Minas', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1901','Itabira' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1902','Itabirinha de Mantena', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1903','Itabirito' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1904','Itacambira', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1905','Itacarambi', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1906','Itaguara', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1907','Itaipé', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1908','Itajubá' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1909','Itamarandiba', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1910','Itamarati de Minas', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1911','Itambacuri', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1912','Itambé do Mato Dentro', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1913','Itamogi' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1914','Itamonte', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1915','Itanhandu' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1916','Itanhomi', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1917','Itaobim' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1918','Itapagipe' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1919','Itapecerica' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1920','Itapeva' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1921','Itatiaiuçu', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1922','Itaú de Minas', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1923','Itaúna', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1924','Itaverava' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1925','Itinga', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1926','Itueta', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1927','Ituiutaba' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1928','Itumirim', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1929','Iturama' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1930','Itutinga', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1931','Jaboticatubas', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1932','Jacinto' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1933','Jacuí', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1934','Jacutinga' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1935','Jaguaraçu' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1936','Jaíba', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1937','Jampruca', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1938','Janaúba' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1939','Januária', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1940','Japaraíba' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1941','Japonvar', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1942','Jeceaba' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1943','Jenipapo de Minas', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1944','Jequeri' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1945','Jequitaí', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1946','Jequitibá' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1947','Jequitinhonha', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1948','Jesuânia', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1949','Joaíma', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1950','Joanésia', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1951','João Monlevade' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1952','João Pinheiro', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1953','Joaquim Felício', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1954','Jordânia', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1955','José Gonçalves de Minas', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1956','José Raydan' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1957','Josenópolis' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1958','Juatuba' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1959','Juiz de Fora', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1960','Juramento' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1961','Juruaia' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1962','Juvenília' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1963','Ladainha', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1964','Lagamar' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1965','Lagoa da Prata' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1966','Lagoa dos Patos', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1967','Lagoa Dourada', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1968','Lagoa Formosa', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1969','Lagoa Grande', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1970','Lagoa Santa' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1971','Lajinha' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1972','Lambari' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1973','Lamim', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1974','Laranjal', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1975','Lassance', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1976','Lavras', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1977','Leandro Ferreira' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1978','Leme do Prado', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1979','Leopoldina', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1980','Liberdade' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1981','Lima Duarte' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1982','Limeira do Oeste' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1983','Lontra', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1984','Luisburgo' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1985','Luislândia', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1986','Luminárias', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1987','Luz', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1988','Machacalis', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1989','Machado' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1990','Madre de Deus de Minas' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1991','Malacacheta' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1992','Mamonas' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1993','Manga', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1994','Manhuaçu', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1995','Manhumirim', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1996','Mantena' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1997','Mar de Espanha' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1998','Maravilhas', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('1999','Maria da Fé' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2000','Mariana' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2001','Marilac' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2002','Mário Campos', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2003','Maripá de Minas', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2004','Marliéria' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2005','Marmelópolis', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2006','Martinho Campos', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2007','Martins Soares' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2008','Mata Verde', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2009','Materlândia' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2010','Mateus Leme' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2011','Mathias Lobato' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2012','Matias Barbosa' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2013','Matias Cardoso' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2014','Matipó', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2015','Mato Verde', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2016','Matozinhos', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2017','Matutina', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2018','Medeiros', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2019','Medina', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2020','Mendes Pimentel', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2021','Mercês', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2022','Mesquita', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2023','Minas Novas' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2024','Minduri' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2025','Mirabela', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2026','Miradouro' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2027','Miraí', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2028','Miravânia' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2029','Moeda', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2030','Moema', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2031','Monjolos', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2032','Monsenhor Paulo', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2033','Montalvânia' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2034','Monte Alegre de Minas', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2035','Monte Azul', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2036','Monte Belo', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2037','Monte Carmelo', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2038','Monte Formoso', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2039','Monte Santo de Minas' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2040','Monte Sião', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2041','Montes Claros', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2042','Montezuma' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2043','Morada Nova de Minas' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2044','Morro da Garça' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2045','Morro do Pilar' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2046','Munhoz', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2047','Muriaé', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2048','Mutum', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2049','Muzambinho', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2050','Nacip Raydan', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2051','Nanuque' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2052','Naque', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2053','Natalândia', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2054','Natércia', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2055','Nazareno', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2056','Nepomuceno', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2057','Ninheira', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2058','Nova Belém', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2059','Nova Era', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2060','Nova Lima' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2061','Nova Módica' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2062','Nova Ponte', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2063','Nova Porteirinha' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2064','Nova Resende', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2065','Nova Serrana', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2066','Nova União', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2067','Novo Cruzeiro', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2068','Novo Oriente de Minas', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2069','Novorizonte' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2070','Olaria', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2071','Olhos-d`Água', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2072','Olímpio Noronha', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2073','Oliveira', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2074','Oliveira Fortes', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2075','Onça de Pitangui' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2076','Oratórios' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2077','Orizânia', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2078','Ouro Branco' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2079','Ouro Fino' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2080','Ouro Preto', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2081','Ouro Verde de Minas', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2082','Padre Carvalho' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2083','Padre Paraíso', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2084','Pai Pedro' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2085','Paineiras' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2086','Pains', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2087','Paiva', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2088','Palma', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2089','Palmópolis', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2090','Papagaios' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2091','Pará de Minas', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2092','Paracatu', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2093','Paraguaçu' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2094','Paraisópolis', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2095','Paraopeba' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2096','Passa Quatro', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2097','Passa Tempo' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2098','Passa-Vinte' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2099','Passabém', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2100','Passos', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2101','Patis', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2102','Patos de Minas' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2103','Patrocínio', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2104','Patrocínio do Muriaé' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2105','Paula Cândido', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2106','Paulistas' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2107','Pavão', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2108','Peçanha' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2109','Pedra Azul', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2110','Pedra Bonita', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2111','Pedra do Anta', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2112','Pedra do Indaiá', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2113','Pedra Dourada', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2114','Pedralva', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2115','Pedras de Maria da Cruz', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2116','Pedrinópolis', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2117','Pedro Leopoldo' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2118','Pedro Teixeira' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2119','Pequeri' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2120','Pequi', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2121','Perdigão', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2122','Perdizes', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2123','Perdões' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2124','Periquito' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2125','Pescador', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2126','Piau' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2127','Piedade de Caratinga' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2128','Piedade de Ponte Nova', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2129','Piedade do Rio Grande', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2130','Piedade dos Gerais', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2131','Pimenta' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2132','Pingo-d`Água', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2133','Pintópolis', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2134','Piracema', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2135','Pirajuba', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2136','Piranga' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2137','Piranguçu' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2138','Piranguinho' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2139','Pirapetinga' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2140','Pirapora', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2141','Piraúba' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2142','Pitangui', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2143','Piumhi', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2144','Planura' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2145','Poço Fundo', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2146','Poços de Caldas', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2147','Pocrane' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2148','Pompéu', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2149','Ponte Nova', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2150','Ponto Chique', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2151','Ponto dos Volantes', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2152','Porteirinha' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2153','Porto Firme' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2154','Poté' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2155','Pouso Alegre', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2156','Pouso Alto', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2157','Prados', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2158','Prata', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2159','Pratápolis', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2160','Pratinha', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2161','Presidente Bernardes' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2162','Presidente Juscelino' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2163','Presidente Kubitschek', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2164','Presidente Olegário', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2165','Prudente de Morais', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2166','Quartel Geral', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2167','Queluzito' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2168','Raposos' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2169','Raul Soares' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2170','Recreio' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2171','Reduto', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2172','Resende Costa', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2173','Resplendor', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2174','Ressaquinha' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2175','Riachinho' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2176','Riacho dos Machados', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2177','Ribeirão das Neves', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2178','Ribeirão Vermelho', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2179','Rio Acima' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2180','Rio Casca' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2181','Rio do Prado', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2182','Rio Doce', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2183','Rio Espera', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2184','Rio Manso' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2185','Rio Novo', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2186','Rio Paranaíba', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2187','Rio Pardo de Minas', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2188','Rio Piracicaba' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2189','Rio Pomba' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2190','Rio Preto' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2191','Rio Vermelho', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2192','Ritápolis' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2193','Rochedo de Minas' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2194','Rodeiro' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2195','Romaria' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2196','Rosário da Limeira', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2197','Rubelita', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2198','Rubim', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2199','Sabará', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2200','Sabinópolis' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2201','Sacramento', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2202','Salinas' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2203','Salto da Divisa', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2204','Santa Bárbara', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2205','Santa Bárbara do Leste' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2206','Santa Bárbara do Monte Verde', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2207','Santa Bárbara do Tugúrio' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2208','Santa Cruz de Minas', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2209','Santa Cruz de Salinas', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2210','Santa Cruz do Escalvado', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2211','Santa Efigênia de Minas', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2212','Santa Fé de Minas', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2213','Santa Helena de Minas', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2214','Santa Juliana', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2215','Santa Luzia' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2216','Santa Margarida', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2217','Santa Maria de Itabira' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2218','Santa Maria do Salto' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2219','Santa Maria do Suaçuí', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2220','Santa Rita de Caldas' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2221','Santa Rita de Ibitipoca', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2222','Santa Rita de Jacutinga', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2223','Santa Rita de Minas', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2224','Santa Rita do Itueto' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2225','Santa Rita do Sapucaí', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2226','Santa Rosa da Serra', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2227','Santa Vitória', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2228','Santana da Vargem', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2229','Santana de Cataguases', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2230','Santana de Pirapama', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2231','Santana do Deserto', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2232','Santana do Garambéu', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2233','Santana do Jacaré', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2234','Santana do Manhuaçu', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2235','Santana do Paraíso', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2236','Santana do Riacho', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2237','Santana dos Montes', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2238','Santo Antônio do Amparo', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2239','Santo Antônio do Aventureiro', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2240','Santo Antônio do Grama' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2241','Santo Antônio do Itambé', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2242','Santo Antônio do Jacinto' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2243','Santo Antônio do Monte' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2244','Santo Antônio do Retiro', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2245','Santo Antônio do Rio Abaixo' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2246','Santo Hipólito' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2247','Santos Dumont', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2248','São Bento Abade', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2249','São Brás do Suaçuí', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2250','São Domingos das Dores' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2251','São Domingos do Prata', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2252','São Félix de Minas', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2253','São Francisco', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2254','São Francisco de Paula' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2255','São Francisco de Sales' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2256','São Francisco do Glória', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2257','São Geraldo' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2258','São Geraldo da Piedade' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2259','São Geraldo do Baixio', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2260','São Gonçalo do Abaeté', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2261','São Gonçalo do Pará', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2262','São Gonçalo do Rio Abaixo', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2263','São Gonçalo do Rio Preto' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2264','São Gonçalo do Sapucaí' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2265','São Gotardo' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2266','São João Batista do Glória', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2267','São João da Lagoa', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2268','São João da Mata' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2269','São João da Ponte', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2270','São João das Missões' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2271','São João del Rei' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2272','São João do Manhuaçu' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2273','São João do Manteninha' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2274','São João do Oriente', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2275','São João do Pacuí', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2276','São João do Paraíso', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2277','São João Evangelista' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2278','São João Nepomuceno', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2279','São Joaquim de Bicas' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2280','São José da Barra', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2281','São José da Lapa' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2282','São José da Safira', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2283','São José da Varginha' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2284','São José do Alegre', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2285','São José do Divino', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2286','São José do Goiabal', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2287','São José do Jacuri', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2288','São José do Mantimento' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2289','São Lourenço', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2290','São Miguel do Anta', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2291','São Pedro da União', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2292','São Pedro do Suaçuí', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2293','São Pedro dos Ferros' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2294','São Romão' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2295','São Roque de Minas', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2296','São Sebastião da Bela Vista' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2297','São Sebastião da Vargem Alegre', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2298','São Sebastião do Anta', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2299','São Sebastião do Maranhão', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2300','São Sebastião do Oeste' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2301','São Sebastião do Paraíso' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2302','São Sebastião do Rio Preto', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2303','São Sebastião do Rio Verde', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2304','São Thomé das Letras' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2305','São Tiago' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2306','São Tomás de Aquino', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2307','São Vicente de Minas' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2308','Sapucaí-Mirim', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2309','Sardoá', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2310','Sarzedo' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2311','Sem-Peixe' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2312','Senador Amaral' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2313','Senador Cortes' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2314','Senador Firmino', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2315','Senador José Bento', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2316','Senador Modestino Gonçalves' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2317','Senhora de Oliveira', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2318','Senhora do Porto' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2319','Senhora dos Remédios' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2320','Sericita', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2321','Seritinga' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2322','Serra Azul de Minas', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2323','Serra da Saudade' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2324','Serra do Salitre' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2325','Serra dos Aimorés', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2326','Serrania', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2327','Serranópolis de Minas', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2328','Serranos', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2329','Serro', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2330','Sete Lagoas' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2331','Setubinha' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2332','Silveirânia' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2333','Silvianópolis', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2334','Simão Pereira', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2335','Simonésia' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2336','Sobrália', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2337','Soledade de Minas', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2338','Tabuleiro' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2339','Taiobeiras', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2340','Taparuba', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2341','Tapira', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2342','Tapiraí' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2343','Taquaraçu de Minas', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2344','Tarumirim' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2345','Teixeiras' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2346','Teófilo Otoni', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2347','Timóteo' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2348','Tiradentes', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2349','Tiros', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2350','Tocantins' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2351','Tocos do Moji', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2352','Toledo', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2353','Tombos', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2354','Três Corações', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2355','Três Marias' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2356','Três Pontas' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2357','Tumiritinga' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2358','Tupaciguara' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2359','Turmalina' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2360','Turvolândia' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2361','Ubá', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2362','Ubaí' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2363','Ubaporanga', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2364','Uberaba' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2365','Uberlândia', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2366','Umburatiba', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2367','Unaí' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2368','União de Minas' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2369','Uruana de Minas', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2370','Urucânia', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2371','Urucuia' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2372','Vargem Alegre', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2373','Vargem Bonita', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2374','Vargem Grande do Rio Pardo', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2375','Varginha', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2376','Varjão de Minas', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2377','Várzea da Palma', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2378','Varzelândia' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2379','Vazante' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2380','Verdelândia' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2381','Veredinha' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2382','Veríssimo' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2383','Vermelho Novo', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2384','Vespasiano', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2385','Viçosa', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2386','Vieiras' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2387','Virgem da Lapa' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2388','Virgínia', '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2389','Virginópolis', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2390','Virgolândia' , '06 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2391','Visconde do Rio Branco' , '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2392','Volta Grande', '06');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2393','Wenceslau Braz' , '06');

Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2394','Abaetetuba', '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2395','Abel Figueiredo', '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2396','Acará', '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2397','Afuá' , '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2398','Água Azul do Norte', '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2399','Alenquer', '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2400','Almeirim', '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2401','Altamira', '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2402','Anajás', '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2403','Ananindeua', '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2404','Anapu', '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2405','Augusto Corrêa' , '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2406','Aurora do Pará' , '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2407','Aveiro', '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2408','Bagre', '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2409','Baião', '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2410','Bannach' , '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2411','Barcarena' , '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2412','Belém', '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2413','Belterra', '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2414','Benevides' , '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2415','Bom Jesus do Tocantins' , '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2416','Bonito', '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2417','Bragança', '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2418','Brasil Novo' , '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2419','Brejo Grande do Araguaia' , '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2420','Breu Branco' , '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2421','Breves', '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2422','Bujaru', '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2423','Cachoeira do Arari', '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2424','Cachoeira do Piriá', '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2425','Cametá', '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2426','Canaã dos Carajás', '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2427','Capanema', '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2428','Capitão Poço', '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2429','Castanhal' , '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2430','Chaves', '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2431','Colares' , '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2432','Conceição do Araguaia', '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2433','Concórdia do Pará', '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2434','Cumaru do Norte', '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2435','Curionópolis', '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2436','Curralinho', '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2437','Curuá', '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2438','Curuçá', '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2439','Dom Eliseu', '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2440','Eldorado dos Carajás' , '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2441','Faro' , '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2442','Floresta do Araguaia' , '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2443','Garrafão do Norte', '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2444','Goianésia do Pará', '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2445','Gurupá', '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2446','Igarapé-Açu' , '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2447','Igarapé-Miri', '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2448','Inhangapi' , '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2449','Ipixuna do Pará', '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2450','Irituia' , '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2451','Itaituba', '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2452','Itupiranga', '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2453','Jacareacanga', '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2454','Jacundá' , '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2455','Juruti', '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2456','Limoeiro do Ajuru', '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2457','Mãe do Rio', '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2458','Magalhães Barata' , '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2459','Marabá', '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2460','Maracanã', '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2461','Marapanim' , '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2462','Marituba', '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2463','Medicilândia', '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2464','Melgaço' , '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2465','Mocajuba', '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2466','Moju' , '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2467','Monte Alegre', '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2468','Muaná', '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2469','Nova Esperança do Piriá', '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2470','Nova Ipixuna', '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2471','Nova Timboteua' , '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2472','Novo Progresso' , '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2473','Novo Repartimento', '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2474','Óbidos', '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2475','Oeiras do Pará' , '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2476','Oriximiná' , '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2477','Ourém', '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2478','Ourilândia do Norte', '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2479','Pacajá', '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2480','Palestina do Pará', '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2481','Paragominas' , '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2482','Parauapebas' , '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2483','Pau d`Arco', '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2484','Peixe-Boi' , '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2485','Piçarra' , '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2486','Placas', '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2487','Ponta de Pedras', '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2488','Portel', '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2489','Porto de Moz', '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2490','Prainha' , '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2491','Primavera' , '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2492','Quatipuru' , '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2493','Redenção', '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2494','Rio Maria' , '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2495','Rondon do Pará' , '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2496','Rurópolis' , '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2497','Salinópolis' , '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2498','Salvaterra', '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2499','Santa Bárbara do Pará', '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2500','Santa Cruz do Arari', '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2501','Santa Isabel do Pará' , '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2502','Santa Luzia do Pará', '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2503','Santa Maria das Barreiras', '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2504','Santa Maria do Pará', '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2505','Santana do Araguaia', '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2506','Santarém', '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2507','Santarém Novo', '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2508','Santo Antônio do Tauá', '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2509','São Caetano de Odivelas', '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2510','São Domingos do Araguaia' , '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2511','São Domingos do Capim', '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2512','São Félix do Xingu', '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2513','São Francisco do Pará', '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2514','São Geraldo do Araguaia', '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2515','São João da Ponta', '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2516','São João de Pirabas', '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2517','São João do Araguaia' , '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2518','São Miguel do Guamá', '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2519','São Sebastião da Boa Vista', '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2520','Sapucaia', '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2521','Senador José Porfírio', '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2522','Soure', '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2523','Tailândia' , '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2524','Terra Alta', '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2525','Terra Santa' , '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2526','Tomé-Açu', '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2527','Tracuateua', '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2528','Trairão' , '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2529','Tucumã', '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2530','Tucuruí' , '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2531','Ulianópolis' , '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2532','Uruará', '19 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2533','Vigia', '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2534','Viseu', '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2535','Vitória do Xingu' , '19');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2536','Xinguara', '19 ');

Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2537','Água Branca' , '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2538','Aguiar', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2539','Alagoa Grande', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2540','Alagoa Nova' , '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2541','Alagoinha' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2542','Alcantil', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2543','Algodão de Jandaíra', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2544','Alhandra', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2545','Amparo', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2546','Aparecida' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2547','Araçagi' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2548','Arara', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2549','Araruna' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2550','Areia', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2551','Areia de Baraúnas', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2552','Areial', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2553','Aroeiras', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2554','Assunção', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2555','Baía da Traição', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2556','Bananeiras', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2557','Baraúna' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2558','Barra de Santa Rosa', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2559','Barra de Santana' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2560','Barra de São Miguel', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2561','Bayeux', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2562','Belém', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2563','Belém do Brejo do Cruz' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2564','Bernardino Batista', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2565','Boa Ventura' , '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2566','Boa Vista' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2567','Bom Jesus' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2568','Bom Sucesso' , '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2569','Bonito de Santa Fé', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2570','Boqueirão' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2571','Borborema' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2572','Brejo do Cruz', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2573','Brejo dos Santos' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2574','Caaporã' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2575','Cabaceiras', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2576','Cabedelo', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2577','Cachoeira dos Índios' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2578','Cacimba de Areia' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2579','Cacimba de Dentro', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2580','Cacimbas', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2581','Caiçara' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2582','Cajazeiras', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2583','Cajazeirinhas', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2584','Caldas Brandão' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2585','Camalaú' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2586','Campina Grande' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2587','Campo de Santana' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2588','Capim', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2589','Caraúbas', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2590','Carrapateira', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2591','Casserengue' , '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2592','Catingueira' , '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2593','Catolé do Rocha', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2594','Caturité', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2595','Conceição' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2596','Condado' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2597','Conde', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2598','Congo', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2599','Coremas' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2600','Coxixola', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2601','Cruz do Espírito Santo' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2602','Cubati', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2603','Cuité', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2604','Cuité de Mamanguape', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2605','Cuitegi' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2606','Curral de Cima' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2607','Curral Velho', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2608','Damião', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2609','Desterro', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2610','Diamante', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2611','Dona Inês' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2612','Duas Estradas', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2613','Emas' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2614','Esperança' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2615','Fagundes', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2616','Frei Martinho', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2617','Gado Bravo', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2618','Guarabira' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2619','Gurinhém', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2620','Gurjão', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2621','Ibiara', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2622','Igaracy' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2623','Imaculada' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2624','Ingá' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2625','Itabaiana' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2626','Itaporanga', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2627','Itapororoca' , '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2628','Itatuba' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2629','Jacaraú' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2630','Jericó', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2631','João Pessoa' , '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2632','Juarez Távora', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2633','Juazeirinho' , '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2634','Junco do Seridó', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2635','Juripiranga' , '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2636','Juru' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2637','Lagoa', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2638','Lagoa de Dentro', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2639','Lagoa Seca', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2640','Lastro', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2641','Livramento', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2642','Logradouro', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2643','Lucena', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2644','Mãe d`Água', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2645','Malta', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2646','Mamanguape', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2647','Manaíra' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2648','Marcação', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2649','Mari' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2650','Marizópolis' , '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2651','Massaranduba', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2652','Mataraca', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2653','Matinhas', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2654','Mato Grosso' , '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2655','Maturéia', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2656','Mogeiro' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2657','Montadas', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2658','Monte Horebe', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2659','Monteiro', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2660','Mulungu' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2661','Natuba', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2662','Nazarezinho' , '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2663','Nova Floresta', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2664','Nova Olinda' , '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2665','Nova Palmeira', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2666','Olho d`Água' , '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2667','Olivedos', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2668','Ouro Velho', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2669','Parari', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2670','Passagem', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2671','Patos', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2672','Paulista', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2673','Pedra Branca', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2674','Pedra Lavrada', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2675','Pedras de Fogo' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2676','Pedro Régis' , '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2677','Piancó', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2678','Picuí', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2679','Pilar', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2680','Pilões', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2681','Pilõezinhos' , '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2682','Pirpirituba' , '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2683','Pitimbu' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2684','Pocinhos', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2685','Poço Dantas' , '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2686','Poço de José de Moura', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2687','Pombal', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2688','Prata', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2689','Princesa Isabel', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2690','Puxinanã', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2691','Queimadas' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2692','Quixabá' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2693','Remígio' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2694','Riachão' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2695','Riachão do Bacamarte' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2696','Riachão do Poço', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2697','Riacho de Santo Antônio', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2698','Riacho dos Cavalos', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2699','Rio Tinto' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2700','Salgadinho', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2701','Salgado de São Félix' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2702','Santa Cecília', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2703','Santa Cruz', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2704','Santa Helena', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2705','Santa Inês', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2706','Santa Luzia' , '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2707','Santa Rita', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2708','Santa Teresinha', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2709','Santana de Mangueira' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2710','Santana dos Garrotes' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2711','Santarém', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2712','Santo André' , '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2713','São Bentinho', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2714','São Bento' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2715','São Domingos de Pombal' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2716','São Domingos do Cariri' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2717','São Francisco', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2718','São João do Cariri', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2719','São João do Rio do Peixe' , '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2720','São João do Tigre', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2721','São José da Lagoa Tapada' , '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2722','São José de Caiana', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2723','São José de Espinharas' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2724','São José de Piranhas' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2725','São José de Princesa' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2726','São José do Bonfim', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2727','São José do Brejo do Cruz', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2728','São José do Sabugi', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2729','São José dos Cordeiros' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2730','São José dos Ramos', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2731','São Mamede', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2732','São Miguel de Taipu', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2733','São Sebastião de Lagoa de Roça', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2734','São Sebastião do Umbuzeiro', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2735','Sapé' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2736','Seridó', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2737','Serra Branca', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2738','Serra da Raiz', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2739','Serra Grande', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2740','Serra Redonda', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2741','Serraria', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2742','Sertãozinho' , '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2743','Sobrado' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2744','Solânea' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2745','Soledade', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2746','Sossêgo' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2747','Sousa', '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2748','Sumé' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2749','Taperoá' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2750','Tavares' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2751','Teixeira', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2752','Tenório' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2753','Triunfo' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2754','Uiraúna' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2755','Umbuzeiro' , '18');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2756','Várzea', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2757','Vieirópolis' , '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2758','Vista Serrana', '18 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2759','Zabelê', '18 ');

Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2760','Abatiá', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2761','Adrianópolis', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2762','Agudos do Sul', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2763','Almirante Tamandaré', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2764','Altamira do Paraná', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2765','Alto Paraná' , '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2766','Alto Piquiri', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2767','Altônia' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2768','Alvorada do Sul', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2769','Amaporã' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2770','Ampére', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2771','Anahy', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2772','Andirá', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2773','Ângulo', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2774','Antonina', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2775','Antônio Olinto' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2776','Apucarana' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2777','Arapongas' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2778','Arapoti' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2779','Arapuã', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2780','Araruna' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2781','Araucária' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2782','Ariranha do Ivaí' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2783','Assaí', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2784','Assis Chateaubriand', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2785','Astorga' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2786','Atalaia' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2787','Balsa Nova', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2788','Bandeirantes', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2789','Barbosa Ferraz' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2790','Barra do Jacaré', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2791','Barracão', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2792','Bela Vista da Caroba' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2793','Bela Vista do Paraíso', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2794','Bituruna', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2795','Boa Esperança', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2796','Boa Esperança do Iguaçu', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2797','Boa Ventura de São Roque' , '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2798','Boa Vista da Aparecida' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2799','Bocaiúva do Sul', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2800','Bom Jesus do Sul' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2801','Bom Sucesso' , '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2802','Bom Sucesso do Sul', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2803','Borrazópolis', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2804','Braganey', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2805','Brasilândia do Sul', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2806','Cafeara' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2807','Cafelândia', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2808','Cafezal do Sul' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2809','Califórnia', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2810','Cambará' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2811','Cambé', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2812','Cambira' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2813','Campina da Lagoa' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2814','Campina do Simão' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2815','Campina Grande do Sul', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2816','Campo Bonito', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2817','Campo do Tenente' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2818','Campo Largo' , '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2819','Campo Magro' , '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2820','Campo Mourão', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2821','Cândido de Abreu' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2822','Candói', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2823','Cantagalo' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2824','Capanema', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2825','Capitão Leônidas Marques' , '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2826','Carambeí', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2827','Carlópolis', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2828','Cascavel', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2829','Castro', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2830','Catanduvas', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2831','Centenário do Sul', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2832','Cerro Azul', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2833','Céu Azul', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2834','Chopinzinho' , '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2835','Cianorte', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2836','CIDADES Gaúcha' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2837','Clevelândia' , '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2838','Colombo' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2839','Colorado', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2840','Congonhinhas', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2841','Conselheiro Mairinck' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2842','Contenda', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2843','Corbélia', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2844','Cornélio Procópio', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2845','Coronel Domingos Soares', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2846','Coronel Vivida' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2847','Corumbataí do Sul', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2848','Cruz Machado', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2849','Cruzeiro do Iguaçu', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2850','Cruzeiro do Oeste', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2851','Cruzeiro do Sul', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2852','Cruzmaltina' , '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2853','Curitiba', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2854','Curiúva' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2855','Diamante d`Oeste' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2856','Diamante do Norte', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2857','Diamante do Sul', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2858','Dois Vizinhos', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2859','Douradina' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2860','Doutor Camargo' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2861','Doutor Ulysses' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2862','Enéas Marques', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2863','Engenheiro Beltrão', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2864','Entre Rios do Oeste', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2865','Esperança Nova' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2866','Espigão Alto do Iguaçu' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2867','Farol', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2868','Faxinal' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2869','Fazenda Rio Grande', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2870','Fênix', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2871','Fernandes Pinheiro', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2872','Figueira', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2873','Flor da Serra do Sul' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2874','Floraí', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2875','Floresta', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2876','Florestópolis', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2877','Flórida' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2878','Formosa do Oeste' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2879','Foz do Iguaçu', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2880','Foz do Jordão', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2881','Francisco Alves', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2882','Francisco Beltrão', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2883','General Carneiro' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2884','Godoy Moreira', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2885','Goioerê' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2886','Goioxim' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2887','Grandes Rios', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2888','Guaíra', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2889','Guairaçá', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2890','Guamiranga', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2891','Guapirama' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2892','Guaporema' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2893','Guaraci' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2894','Guaraniaçu', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2895','Guarapuava', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2896','Guaraqueçaba', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2897','Guaratuba' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2898','Honório Serpa', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2899','Ibaiti', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2900','Ibema', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2901','Ibiporã' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2902','Icaraíma', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2903','Iguaraçu', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2904','Iguatu', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2905','Imbaú', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2906','Imbituva', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2907','Inácio Martins' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2908','Inajá', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2909','Indianópolis', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2910','Ipiranga', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2911','Iporã', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2912','Iracema do Oeste' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2913','Irati', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2914','Iretama' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2915','Itaguajé', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2916','Itaipulândia', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2917','Itambaracá', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2918','Itambé', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2919','Itapejara d`Oeste', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2920','Itaperuçu' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2921','Itaúna do Sul', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2922','Ivaí' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2923','Ivaiporã', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2924','Ivaté', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2925','Ivatuba' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2926','Jaboti', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2927','Jacarezinho' , '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2928','Jaguapitã' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2929','Jaguariaíva' , '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2930','Jandaia do Sul' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2931','Janiópolis', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2932','Japira', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2933','Japurá', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2934','Jardim Alegre', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2935','Jardim Olinda', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2936','Jataizinho', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2937','Jesuítas', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2938','Joaquim Távora' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2939','Jundiaí do Sul' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2940','Juranda' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2941','Jussara' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2942','Kaloré', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2943','Lapa' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2944','Laranjal', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2945','Laranjeiras do Sul', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2946','Leópolis', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2947','Lidianópolis', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2948','Lindoeste' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2949','Loanda', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2950','Lobato', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2951','Londrina', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2952','Luiziana', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2953','Lunardelli', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2954','Lupionópolis', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2955','Mallet', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2956','Mamborê' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2957','Mandaguaçu', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2958','Mandaguari', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2959','Mandirituba' , '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2960','Manfrinópolis', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2961','Mangueirinha', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2962','Manoel Ribas', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2963','Marechal Cândido Rondon', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2964','Maria Helena', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2965','Marialva', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2966','Marilândia do Sul', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2967','Marilena', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2968','Mariluz' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2969','Maringá' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2970','Mariópolis', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2971','Maripá', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2972','Marmeleiro', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2973','Marquinho' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2974','Marumbi' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2975','Matelândia', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2976','Matinhos', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2977','Mato Rico' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2978','Mauá da Serra', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2979','Medianeira', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2980','Mercedes', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2981','Mirador' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2982','Miraselva' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2983','Missal', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2984','Moreira Sales', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2985','Morretes', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2986','Munhoz de Melo' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2987','Nossa Senhora das Graças' , '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2988','Nova Aliança do Ivaí' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2989','Nova América da Colina' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2990','Nova Aurora' , '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2991','Nova Cantu', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2992','Nova Esperança' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2993','Nova Esperança do Sudoeste', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2994','Nova Fátima' , '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2995','Nova Laranjeiras' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2996','Nova Londrina', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2997','Nova Olímpia', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2998','Nova Prata do Iguaçu' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('2999','Nova Santa Bárbara', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3000','Nova Santa Rosa', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3001','Nova Tebas', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3002','Novo Itacolomi' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3003','Ortigueira', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3004','Ourizona', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3005','Ouro Verde do Oeste', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3006','Paiçandu', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3007','Palmas', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3008','Palmeira', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3009','Palmital', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3010','Palotina', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3011','Paraíso do Norte' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3012','Paranacity', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3013','Paranaguá' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3014','Paranapoema' , '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3015','Paranavaí' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3016','Pato Bragado', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3017','Pato Branco' , '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3018','Paula Freitas', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3019','Paulo Frontin', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3020','Peabiru' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3021','Perobal' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3022','Pérola', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3023','Pérola d`Oeste' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3024','Piên' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3025','Pinhais' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3026','Pinhal de São Bento', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3027','Pinhalão', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3028','Pinhão', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3029','Piraí do Sul', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3030','Piraquara' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3031','Pitanga' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3032','Pitangueiras', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3033','Planaltina do Paraná' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3034','Planalto', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3035','Ponta Grossa', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3036','Pontal do Paraná' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3037','Porecatu', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3038','Porto Amazonas' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3039','Porto Barreiro' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3040','Porto Rico', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3041','Porto Vitória', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3042','Prado Ferreira' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3043','Pranchita' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3044','Presidente Castelo Branco', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3045','Primeiro de Maio' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3046','Prudentópolis', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3047','Quarto Centenário', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3048','Quatiguá', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3049','Quatro Barras', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3050','Quatro Pontes', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3051','Quedas do Iguaçu' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3052','Querência do Norte', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3053','Quinta do Sol', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3054','Quitandinha' , '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3055','Ramilândia', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3056','Rancho Alegre', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3057','Rancho Alegre d`Oeste', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3058','Realeza' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3059','Rebouças', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3060','Renascença', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3061','Reserva' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3062','Reserva do Iguaçu', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3063','Ribeirão Claro' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3064','Ribeirão do Pinhal', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3065','Rio Azul', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3066','Rio Bom' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3067','Rio Bonito do Iguaçu' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3068','Rio Branco do Ivaí', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3069','Rio Branco do Sul', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3070','Rio Negro' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3071','Rolândia', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3072','Roncador', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3073','Rondon', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3074','Rosário do Ivaí', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3075','Sabáudia', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3076','Salgado Filho', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3077','Salto do Itararé' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3078','Salto do Lontra', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3079','Santa Amélia', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3080','Santa Cecília do Pavão' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3081','Santa Cruz de Monte Castelo' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3082','Santa Fé', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3083','Santa Helena', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3084','Santa Inês', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3085','Santa Isabel do Ivaí' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3086','Santa Izabel do Oeste', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3087','Santa Lúcia' , '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3088','Santa Maria do Oeste' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3089','Santa Mariana', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3090','Santa Mônica', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3091','Santa Tereza do Oeste', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3092','Santa Terezinha de Itaipu', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3093','Santana do Itararé', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3094','Santo Antônio da Platina' , '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3095','Santo Antônio do Caiuá' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3096','Santo Antônio do Paraíso' , '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3097','Santo Antônio do Sudoeste', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3098','Santo Inácio', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3099','São Carlos do Ivaí', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3100','São Jerônimo da Serra', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3101','São João', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3102','São João do Caiuá', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3103','São João do Ivaí' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3104','São João do Triunfo', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3105','São Jorge d`Oeste', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3106','São Jorge do Ivaí', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3107','São Jorge do Patrocínio', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3108','São José da Boa Vista', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3109','São José das Palmeiras' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3110','São José dos Pinhais' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3111','São Manoel do Paraná' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3112','São Mateus do Sul', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3113','São Miguel do Iguaçu' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3114','São Pedro do Iguaçu', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3115','São Pedro do Ivaí', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3116','São Pedro do Paraná', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3117','São Sebastião da Amoreira', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3118','São Tomé', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3119','Sapopema', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3120','Sarandi' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3121','Saudade do Iguaçu', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3122','Sengés', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3123','Serranópolis do Iguaçu' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3124','Sertaneja' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3125','Sertanópolis', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3126','Siqueira Campos', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3127','Sulina', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3128','Tamarana', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3129','Tamboara', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3130','Tapejara', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3131','Tapira', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3132','Teixeira Soares', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3133','Telêmaco Borba' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3134','Terra Boa' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3135','Terra Rica', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3136','Terra Roxa', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3137','Tibagi', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3138','Tijucas do Sul' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3139','Toledo', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3140','Tomazina', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3141','Três Barras do Paraná', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3142','Tunas do Paraná', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3143','Tuneiras do Oeste', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3144','Tupãssi' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3145','Turvo', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3146','Ubiratã' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3147','Umuarama', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3148','União da Vitória' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3149','Uniflor' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3150','Uraí' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3151','Ventania', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3152','Vera Cruz do Oeste', '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3153','Verê' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3154','Vila Alta' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3155','Virmond' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3156','Vitorino', '07 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3157','Wenceslau Braz' , '07');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3158','Xambrê', '07 ');

Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3159','Abreu e Lima', '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3160','Afogados da Ingazeira', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3161','Afrânio' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3162','Agrestina' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3163','Água Preta', '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3164','Águas Belas' , '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3165','Alagoinha' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3166','Aliança' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3167','Altinho' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3168','Amaraji' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3169','Angelim' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3170','Araçoiaba' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3171','Araripina' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3172','Arcoverde' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3173','Barra de Guabiraba', '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3174','Barreiros' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3175','Belém de Maria' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3176','Belém de São Francisco' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3177','Belo Jardim' , '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3178','Betânia' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3179','Bezerros', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3180','Bodocó', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3181','Bom Conselho', '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3182','Bom Jardim', '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3183','Bonito', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3184','Brejão', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3185','Brejinho', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3186','Brejo da Madre de Deus' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3187','Buenos Aires', '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3188','Buíque', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3189','Cabo de Santo Agostinho', '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3190','Cabrobó' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3191','Cachoeirinha', '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3192','Caetés', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3193','Calçado' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3194','Calumbi' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3195','Camaragibe', '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3196','Camocim de São Félix' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3197','Camutanga' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3198','Canhotinho', '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3199','Capoeiras' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3200','Carnaíba', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3201','Carnaubeira da Penha' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3202','Carpina' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3203','Caruaru' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3204','Casinhas', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3205','Catende' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3206','Cedro', '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3207','Chã de Alegria' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3208','Chã Grande', '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3209','Condado' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3210','Correntes' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3211','Cortês', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3212','Cumaru', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3213','Cupira', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3214','Custódia', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3215','Dormentes' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3216','Escada', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3217','Exu', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3218','Feira Nova', '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3219','Fernando de Noronha', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3220','Ferreiros' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3221','Flores', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3222','Floresta', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3223','Frei Miguelinho', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3224','Gameleira' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3225','Garanhuns' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3226','Glória do Goitá', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3227','Goiana', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3228','Granito' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3229','Gravatá' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3230','Iati' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3231','Ibimirim', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3232','Ibirajuba' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3233','Igarassu', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3234','Iguaraci', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3235','Inajá', '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3236','Ingazeira' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3237','Ipojuca' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3238','Ipubi', '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3239','Itacuruba' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3240','Itaíba', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3241','Itamaracá' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3242','Itambé', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3243','Itapetim', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3244','Itapissuma', '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3245','Itaquitinga' , '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3246','Jaboatão dos Guararapes', '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3247','Jaqueira', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3248','Jataúba' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3249','Jatobá', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3250','João Alfredo', '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3251','Joaquim Nabuco' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3252','Jucati', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3253','Jupi' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3254','Jurema', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3255','Lagoa do Carro' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3256','Lagoa do Itaenga' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3257','Lagoa do Ouro', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3258','Lagoa dos Gatos', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3259','Lagoa Grande', '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3260','Lajedo', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3261','Limoeiro', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3262','Macaparana', '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3263','Machados', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3264','Manari', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3265','Maraial' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3266','Mirandiba' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3267','Moreilândia' , '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3268','Moreno', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3269','Nazaré da Mata' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3270','Olinda', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3271','Orobó', '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3272','Orocó', '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3273','Ouricuri', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3274','Palmares', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3275','Palmeirina', '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3276','Panelas' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3277','Paranatama', '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3278','Parnamirim', '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3279','Passira' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3280','Paudalho', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3281','Paulista', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3282','Pedra', '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3283','Pesqueira' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3284','Petrolândia' , '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3285','Petrolina' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3286','Poção', '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3287','Pombos', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3288','Primavera' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3289','Quipapá' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3290','Quixaba' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3291','Recife', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3292','Riacho das Almas' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3293','Ribeirão', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3294','Rio Formoso' , '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3295','Sairé', '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3296','Salgadinho', '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3297','Salgueiro' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3298','Saloá', '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3299','Sanharó' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3300','Santa Cruz', '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3301','Santa Cruz da Baixa Verde', '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3302','Santa Cruz do Capibaribe' , '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3303','Santa Filomena' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3304','Santa Maria da Boa Vista' , '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3305','Santa Maria do Cambucá' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3306','Santa Terezinha', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3307','São Benedito do Sul', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3308','São Bento do Una' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3309','São Caitano' , '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3310','São João', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3311','São Joaquim do Monte' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3312','São José da Coroa Grande' , '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3313','São José do Belmonte' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3314','São José do Egito', '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3315','São Lourenço da Mata' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3316','São Vicente Ferrer', '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3317','Serra Talhada', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3318','Serrita' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3319','Sertânia', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3320','Sirinhaém' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3321','Solidão' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3322','Surubim' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3323','Tabira', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3324','Tacaimbó', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3325','Tacaratu', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3326','Tamandaré' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3327','Taquaritinga do Norte', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3328','Terezinha' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3329','Terra Nova', '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3330','Timbaúba', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3331','Toritama', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3332','Tracunhaém', '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3333','Trindade', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3334','Triunfo' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3335','Tupanatinga' , '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3336','Tuparetama', '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3337','Venturosa' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3338','Verdejante', '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3339','Vertente do Lério', '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3340','Vertentes' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3341','Vicência', '20 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3342','Vitória de Santo Antão' , '20');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3343','Xexéu', '20');

Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3344','Acauã', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3345','Agricolândia', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3346','Água Branca' , '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3347','Alagoinha do Piauí', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3348','Alegrete do Piauí', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3349','Alto Longá', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3350','Altos', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3351','Alvorada do Gurguéia' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3352','Amarante', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3353','Angical do Piauí' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3354','Anísio de Abreu', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3355','Antônio Almeida', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3356','Aroazes' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3357','Arraial' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3358','Assunção do Piauí', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3359','Avelino Lopes', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3360','Baixa Grande do Ribeiro', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3361','Barra d`Alcântara', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3362','Barras', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3363','Barreiras do Piauí', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3364','Barro Duro', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3365','Batalha' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3366','Bela Vista do Piauí', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3367','Belém do Piauí' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3368','Beneditinos' , '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3369','Bertolínia', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3370','Betânia do Piauí' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3371','Boa Hora', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3372','Bocaina' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3373','Bom Jesus' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3374','Bom Princípio do Piauí' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3375','Bonfim do Piauí', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3376','Boqueirão do Piauí', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3377','Brasileira', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3378','Brejo do Piauí' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3379','Buriti dos Lopes' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3380','Buriti dos Montes', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3381','Cabeceiras do Piauí', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3382','Cajazeiras do Piauí', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3383','Cajueiro da Praia', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3384','Caldeirão Grande do Piauí', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3385','Campinas do Piauí', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3386','Campo Alegre do Fidalgo', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3387','Campo Grande do Piauí', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3388','Campo Largo do Piauí' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3389','Campo Maior' , '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3390','Canavieira', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3391','Canto do Buriti', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3392','Capitão de Campos', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3393','Capitão Gervásio Oliveira', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3394','Caracol' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3395','Caraúbas do Piauí', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3396','Caridade do Piauí', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3397','Castelo do Piauí' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3398','Caxingó' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3399','Cocal', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3400','Cocal de Telha' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3401','Cocal dos Alves', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3402','Coivaras', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3403','Colônia do Gurguéia', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3404','Colônia do Piauí' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3405','Conceição do Canindé' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3406','Coronel José Dias', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3407','Corrente', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3408','Cristalândia do Piauí', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3409','Cristino Castro', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3410','Curimatá', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3411','Currais' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3412','Curral Novo do Piauí' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3413','Curralinhos' , '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3414','Demerval Lobão' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3415','Dirceu Arcoverde' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3416','Dom Expedito Lopes', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3417','Dom Inocêncio', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3418','Domingos Mourão', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3419','Elesbão Veloso' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3420','Eliseu Martins' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3421','Esperantina' , '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3422','Fartura do Piauí' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3423','Flores do Piauí', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3424','Floresta do Piauí', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3425','Floriano', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3426','Francinópolis', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3427','Francisco Ayres', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3428','Francisco Macedo' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3429','Francisco Santos' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3430','Fronteiras', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3431','Geminiano' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3432','Gilbués' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3433','Guadalupe' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3434','Guaribas', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3435','Hugo Napoleão', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3436','Ilha Grande' , '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3437','Inhuma', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3438','Ipiranga do Piauí', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3439','Isaías Coelho', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3440','Itainópolis' , '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3441','Itaueira', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3442','Jacobina do Piauí', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3443','Jaicós', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3444','Jardim do Mulato' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3445','Jatobá do Piauí', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3446','Jerumenha' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3447','João Costa', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3448','Joaquim Pires', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3449','Joca Marques', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3450','José de Freitas', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3451','Juazeiro do Piauí', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3452','Júlio Borges', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3453','Jurema', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3454','Lagoa Alegre', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3455','Lagoa de São Francisco' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3456','Lagoa do Barro do Piauí', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3457','Lagoa do Piauí' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3458','Lagoa do Sítio' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3459','Lagoinha do Piauí', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3460','Landri Sales', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3461','Luís Correia', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3462','Luzilândia', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3463','Madeiro' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3464','Manoel Emídio', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3465','Marcolândia' , '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3466','Marcos Parente' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3467','Massapê do Piauí' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3468','Matias Olímpio' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3469','Miguel Alves', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3470','Miguel Leão' , '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3471','Milton Brandão' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3472','Monsenhor Gil', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3473','Monsenhor Hipólito', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3474','Monte Alegre do Piauí', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3475','Morro Cabeça no Tempo', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3476','Morro do Chapéu do Piauí' , '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3477','Murici dos Portelas', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3478','Nazaré do Piauí', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3479','Nossa Senhora de Nazaré', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3480','Nossa Senhora dos Remédios', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3481','Nova Santa Rita', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3482','Novo Oriente do Piauí', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3483','Novo Santo Antônio', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3484','Oeiras', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3485','Olho d`Água do Piauí' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3486','Padre Marcos', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3487','Paes Landim' , '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3488','Pajeú do Piauí' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3489','Palmeira do Piauí', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3490','Palmeirais', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3491','Paquetá' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3492','Parnaguá', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3493','Parnaíba', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3494','Passagem Franca do Piauí' , '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3495','Patos do Piauí' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3496','Paulistana', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3497','Pavussu' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3498','Pedro II', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3499','Pedro Laurentino' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3500','Picos', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3501','Pimenteiras' , '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3502','Pio IX', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3503','Piracuruca', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3504','Piripiri', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3505','Porto', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3506','Porto Alegre do Piauí', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3507','Prata do Piauí' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3508','Queimada Nova', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3509','Redenção do Gurguéia' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3510','Regeneração' , '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3511','Riacho Frio' , '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3512','Ribeira do Piauí' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3513','Ribeiro Gonçalves', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3514','Rio Grande do Piauí', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3515','Santa Cruz do Piauí', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3516','Santa Cruz dos Milagres', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3517','Santa Filomena' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3518','Santa Luz' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3519','Santa Rosa do Piauí', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3520','Santana do Piauí' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3521','Santo Antônio de Lisboa', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3522','Santo Antônio dos Milagres', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3523','Santo Inácio do Piauí', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3524','São Braz do Piauí', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3525','São Félix do Piauí', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3526','São Francisco de Assis do Piauí', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3527','São Francisco do Piauí' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3528','São Gonçalo do Gurguéia', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3529','São Gonçalo do Piauí' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3530','São João da Canabrava', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3531','São João da Fronteira', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3532','São João da Serra', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3533','São João da Varjota', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3534','São João do Arraial', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3535','São João do Piauí', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3536','São José do Divino', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3537','São José do Peixe', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3538','São José do Piauí', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3539','São Julião', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3540','São Lourenço do Piauí', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3541','São Luis do Piauí', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3542','São Miguel da Baixa Grande', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3543','São Miguel do Fidalgo', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3544','São Miguel do Tapuio' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3545','São Pedro do Piauí', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3546','São Raimundo Nonato', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3547','Sebastião Barros' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3548','Sebastião Leal' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3549','Sigefredo Pacheco', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3550','Simões', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3551','Simplício Mendes' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3552','Socorro do Piauí' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3553','Sussuapara', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3554','Tamboril do Piauí', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3555','Tanque do Piauí', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3556','Teresina', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3557','União', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3558','Uruçuí', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3559','Valença do Piauí' , '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3560','Várzea Branca', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3561','Várzea Grande', '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3562','Vera Mendes' , '21 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3563','Vila Nova do Piauí', '21');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3564','Wall Ferraz' , '21 ');

Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3565','Angra dos Reis' , '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3566','Aperibé' , '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3567','Araruama', '03 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3568','Areal', '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3569','Armação dos Búzios', '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3570','Arraial do Cabo', '03 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3571','Barra do Piraí' , '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3572','Barra Mansa' , '03 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3573','Belford Roxo', '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3574','Bom Jardim', '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3575','Bom Jesus do Itabapoana', '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3576','Cabo Frio' , '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3577','Cachoeiras de Macacu' , '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3578','Cambuci' , '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3579','Campos dos Goytacazes', '03 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3580','Cantagalo' , '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3581','Carapebus' , '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3582','Cardoso Moreira', '03 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3583','Carmo', '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3584','Casimiro de Abreu', '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3585','Comendador Levy Gasparian', '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3586','Conceição de Macabu', '03 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3587','Cordeiro', '03 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3588','Duas Barras' , '03 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3589','Duque de Caxias', '03 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3590','Engenheiro Paulo de Frontin' , '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3591','Guapimirim', '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3592','Iguaba Grande', '03 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3593','Itaboraí', '03 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3594','Itaguaí' , '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3595','Italva', '03 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3596','Itaocara', '03 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3597','Itaperuna' , '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3598','Itatiaia', '03 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3599','Japeri', '03 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3600','Laje do Muriaé' , '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3601','Macaé', '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3602','Macuco', '03 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3603','Magé' , '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3604','Mangaratiba' , '03 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3605','Maricá', '03 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3606','Mendes', '03 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3607','Miguel Pereira' , '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3608','Miracema', '03 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3609','Natividade', '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3610','Nilópolis' , '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3611','Niterói' , '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3612','Nova Friburgo', '03 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3613','Nova Iguaçu' , '03 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3614','Paracambi' , '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3615','Paraíba do Sul' , '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3616','Parati', '03 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3617','Paty do Alferes', '03 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3618','Petrópolis', '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3619','Pinheiral' , '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3620','Piraí', '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3621','Porciúncula' , '03 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3622','Porto Real', '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3623','Quatis', '03 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3624','Queimados' , '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3625','Quissamã', '03 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3626','Resende' , '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3627','Rio Bonito', '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3628','Rio Claro' , '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3629','Rio das Flores' , '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3630','Rio das Ostras' , '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3631','Rio de Janeiro' , '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3632','Santa Maria Madalena' , '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3633','Santo Antônio de Pádua' , '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3634','São Fidélis' , '03 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3635','São Francisco de Itabapoana' , '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3636','São Gonçalo' , '03 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3637','São João da Barra', '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3638','São João de Meriti', '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3639','São José de Ubá', '03 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3640','São José do Vale do Rio Preto' , '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3641','São Pedro da Aldeia', '03 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3642','São Sebastião do Alto', '03 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3643','Sapucaia', '03 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3644','Saquarema' , '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3645','Seropédica', '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3646','Silva Jardim', '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3647','Sumidouro' , '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3648','Tanguá', '03 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3649','Teresópolis' , '03 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3650','Trajano de Morais', '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3651','Três Rios' , '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3652','Valença' , '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3653','Varre-Sai' , '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3654','Vassouras' , '03');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3655','Volta Redonda', '03 ');

Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3656','Acari', '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3657','Açu', '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3658','Afonso Bezerra' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3659','Água Nova' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3660','Alexandria', '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3661','Almino Afonso', '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3662','Alto do Rodrigues', '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3663','Angicos' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3664','Antônio Martins', '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3665','Apodi', '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3666','Areia Branca', '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3667','Arês' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3668','Augusto Severo' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3669','Baía Formosa', '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3670','Baraúna' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3671','Barcelona' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3672','Bento Fernandes', '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3673','Bodó' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3674','Bom Jesus' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3675','Brejinho', '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3676','Caiçara do Norte' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3677','Caiçara do Rio do Vento', '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3678','Caicó', '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3679','Campo Redondo', '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3680','Canguaretama', '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3681','Caraúbas', '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3682','Carnaúba dos Dantas', '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3683','Carnaubais', '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3684','Ceará-Mirim' , '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3685','Cerro Corá', '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3686','Coronel Ezequiel' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3687','Coronel João Pessoa', '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3688','Cruzeta' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3689','Currais Novos', '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3690','Doutor Severiano' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3691','Encanto' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3692','Equador' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3693','Espírito Santo' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3694','Extremoz', '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3695','Felipe Guerra', '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3696','Fernando Pedroza' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3697','Florânia', '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3698','Francisco Dantas' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3699','Frutuoso Gomes' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3700','Galinhos', '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3701','Goianinha' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3702','Governador Dix-Sept Rosado', '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3703','Grossos' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3704','Guamaré' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3705','Ielmo Marinho', '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3706','Ipanguaçu' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3707','Ipueira' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3708','Itajá', '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3709','Itaú' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3710','Jaçanã', '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3711','Jandaíra', '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3712','Janduís' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3713','Januário Cicco' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3714','Japi' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3715','Jardim de Angicos', '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3716','Jardim de Piranhas', '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3717','Jardim do Seridó' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3718','João Câmara' , '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3719','João Dias' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3720','José da Penha', '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3721','Jucurutu', '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3722','Lagoa d`Anta', '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3723','Lagoa de Pedras', '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3724','Lagoa de Velhos', '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3725','Lagoa Nova', '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3726','Lagoa Salgada', '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3727','Lajes', '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3728','Lajes Pintadas' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3729','Lucrécia', '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3730','Luís Gomes', '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3731','Macaíba' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3732','Macau', '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3733','Major Sales' , '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3734','Marcelino Vieira' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3735','Martins' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3736','Maxaranguape', '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3737','Messias Targino', '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3738','Montanhas' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3739','Monte Alegre', '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3740','Monte das Gameleiras' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3741','Mossoró' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3742','Natal', '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3743','Nísia Floresta' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3744','Nova Cruz' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3745','Olho-d`Água do Borges', '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3746','Ouro Branco' , '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3747','Paraná', '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3748','Paraú', '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3749','Parazinho' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3750','Parelhas', '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3751','Parnamirim', '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3752','Passa e Fica', '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3753','Passagem', '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3754','Patu' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3755','Pau dos Ferros' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3756','Pedra Grande', '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3757','Pedra Preta' , '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3758','Pedro Avelino', '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3759','Pedro Velho' , '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3760','Pendências', '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3761','Pilões', '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3762','Poço Branco' , '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3763','Portalegre', '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3764','Porto do Mangue', '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3765','Presidente Juscelino' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3766','Pureza', '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3767','Rafael Fernandes' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3768','Rafael Godeiro' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3769','Riacho da Cruz' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3770','Riacho de Santana', '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3771','Riachuelo' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3772','Rio do Fogo' , '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3773','Rodolfo Fernandes', '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3774','Ruy Barbosa' , '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3775','Santa Cruz', '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3776','Santa Maria' , '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3777','Santana do Matos' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3778','Santana do Seridó', '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3779','Santo Antônio', '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3780','São Bento do Norte', '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3781','São Bento do Trairí', '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3782','São Fernando', '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3783','São Francisco do Oeste' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3784','São Gonçalo do Amarante', '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3785','São João do Sabugi', '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3786','São José de Mipibu', '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3787','São José do Campestre', '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3788','São José do Seridó', '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3789','São Miguel', '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3790','São Miguel de Touros' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3791','São Paulo do Potengi' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3792','São Pedro' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3793','São Rafael', '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3794','São Tomé', '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3795','São Vicente' , '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3796','Senador Elói de Souza', '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3797','Senador Georgino Avelino' , '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3798','Serra de São Bento', '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3799','Serra do Mel', '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3800','Serra Negra do Norte' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3801','Serrinha', '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3802','Serrinha dos Pintos', '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3803','Severiano Melo' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3804','Sítio Novo', '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3805','Taboleiro Grande' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3806','Taipu', '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3807','Tangará' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3808','Tenente Ananias', '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3809','Tenente Laurentino Cruz', '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3810','Tibau', '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3811','Tibau do Sul', '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3812','Timbaúba dos Batistas', '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3813','Touros', '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3814','Triunfo Potiguar' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3815','Umarizal', '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3816','Upanema' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3817','Várzea', '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3818','Venha-Ver' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3819','Vera Cruz' , '22');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3820','Viçosa', '22 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3821','Vila Flor' , '22');

Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3822','Água Santa', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3823','Agudo', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3824','Ajuricaba' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3825','Alecrim' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3826','Alegrete', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3827','Alegria' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3828','Alpestre', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3829','Alto Alegre' , '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3830','Alto Feliz', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3831','Alvorada', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3832','Amaral Ferrador', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3833','Ametista do Sul', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3834','André da Rocha' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3835','Anta Gorda', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3836','Antônio Prado', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3837','Arambaré', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3838','Araricá' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3839','Aratiba' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3840','Arroio do Meio' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3841','Arroio do Sal', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3842','Arroio do Tigre', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3843','Arroio dos Ratos' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3844','Arroio Grande', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3845','Arvorezinha' , '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3846','Augusto Pestana', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3847','Áurea', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3848','Bagé' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3849','Balneário Pinhal' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3850','Barão', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3851','Barão de Cotegipe', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3852','Barão do Triunfo' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3853','Barra do Guarita' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3854','Barra do Quaraí', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3855','Barra do Ribeiro' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3856','Barra do Rio Azul', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3857','Barra Funda' , '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3858','Barracão', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3859','Barros Cassal', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3860','Benjamin Constant do Sul' , '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3861','Bento Gonçalves', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3862','Boa Vista das Missões', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3863','Boa Vista do Buricá', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3864','Boa Vista do Sul' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3865','Bom Jesus' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3866','Bom Princípio', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3867','Bom Progresso', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3868','Bom Retiro do Sul', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3869','Boqueirão do Leão', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3870','Bossoroca' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3871','Braga', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3872','Brochier', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3873','Butiá', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3874','Caçapava do Sul', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3875','Cacequi' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3876','Cachoeira do Sul' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3877','Cachoeirinha', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3878','Cacique Doble', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3879','Caibaté' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3880','Caiçara' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3881','Camaquã' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3882','Camargo' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3883','Cambará do Sul' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3884','Campestre da Serra', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3885','Campina das Missões', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3886','Campinas do Sul', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3887','Campo Bom' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3888','Campo Novo', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3889','Campos Borges', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3890','Candelária', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3891','Cândido Godói', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3892','Candiota', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3893','Canela', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3894','Canguçu' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3895','Canoas', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3896','Capão da Canoa' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3897','Capão do Leão', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3898','Capela de Santana', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3899','Capitão' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3900','Capivari do Sul', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3901','Caraá', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3902','Carazinho' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3903','Carlos Barbosa' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3904','Carlos Gomes', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3905','Casca', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3906','Caseiros', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3907','Catuípe' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3908','Caxias do Sul', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3909','Centenário', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3910','Cerrito' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3911','Cerro Branco', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3912','Cerro Grande', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3913','Cerro Grande do Sul', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3914','Cerro Largo' , '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3915','Chapada' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3916','Charqueadas' , '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3917','Charrua' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3918','Chiapeta', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3919','Chuí' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3920','Chuvisca', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3921','Cidreira', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3922','Ciríaco' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3923','Colinas' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3924','Colorado', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3925','Condor', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3926','Constantina' , '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3927','Coqueiros do Sul' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3928','Coronel Barros' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3929','Coronel Bicaco' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3930','Cotiporã', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3931','Coxilha' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3932','Crissiumal', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3933','Cristal' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3934','Cristal do Sul' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3935','Cruz Alta' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3936','Cruzeiro do Sul', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3937','David Canabarro', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3938','Derrubadas', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3939','Dezesseis de Novembro', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3940','Dilermando de Aguiar' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3941','Dois Irmãos' , '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3942','Dois Irmãos das Missões', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3943','Dois Lajeados', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3944','Dom Feliciano', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3945','Dom Pedrito' , '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3946','Dom Pedro de Alcântara' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3947','Dona Francisca' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3948','Doutor Maurício Cardoso', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3949','Doutor Ricardo' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3950','Eldorado do Sul', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3951','Encantado' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3952','Encruzilhada do Sul', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3953','Engenho Velho', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3954','Entre Rios do Sul', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3955','Entre-Ijuís' , '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3956','Erebango', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3957','Erechim' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3958','Ernestina' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3959','Erval Grande', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3960','Erval Seco', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3961','Esmeralda' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3962','Esperança do Sul' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3963','Espumoso', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3964','Estação' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3965','Estância Velha' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3966','Esteio', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3967','Estrela' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3968','Estrela Velha', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3969','Eugênio de Castro', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3970','Fagundes Varela', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3971','Farroupilha' , '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3972','Faxinal do Soturno', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3973','Faxinalzinho', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3974','Fazenda Vilanova' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3975','Feliz', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3976','Flores da Cunha', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3977','Floriano Peixoto' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3978','Fontoura Xavier', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3979','Formigueiro' , '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3980','Fortaleza dos Valos', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3981','Frederico Westphalen' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3982','Garibaldi' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3983','Garruchos' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3984','Gaurama' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3985','General Câmara' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3986','Gentil', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3987','Getúlio Vargas' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3988','Giruá', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3989','Glorinha', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3990','Gramado' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3991','Gramado dos Loureiros', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3992','Gramado Xavier' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3993','Gravataí', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3994','Guabiju' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3995','Guaíba', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3996','Guaporé' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3997','Guarani das Missões', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3998','Harmonia', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('3999','Herval', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4000','Herveiras' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4001','Horizontina' , '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4002','Hulha Negra' , '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4003','Humaitá' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4004','Ibarama' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4005','Ibiaçá', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4006','Ibiraiaras', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4007','Ibirapuitã', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4008','Ibirubá' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4009','Igrejinha' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4010','Ijuí' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4011','Ilópolis', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4012','Imbé' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4013','Imigrante' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4014','Independência', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4015','Inhacorá', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4016','Ipê', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4017','Ipiranga do Sul', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4018','Iraí' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4019','Itaara', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4020','Itacurubi' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4021','Itapuca' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4022','Itaqui', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4023','Itatiba do Sul' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4024','Ivorá', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4025','Ivoti', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4026','Jaboticaba', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4027','Jacutinga' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4028','Jaguarão', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4029','Jaguari' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4030','Jaquirana' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4031','Jari' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4032','Jóia' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4033','Júlio de Castilhos', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4034','Lagoa dos Três Cantos', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4035','Lagoa Vermelha' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4036','Lagoão', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4037','Lajeado' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4038','Lajeado do Bugre' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4039','Lavras do Sul', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4040','Liberato Salzano' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4041','Lindolfo Collor', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4042','Linha Nova', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4043','Maçambara' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4044','Machadinho', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4045','Mampituba' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4046','Manoel Viana', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4047','Maquiné' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4048','Maratá', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4049','Marau', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4050','Marcelino Ramos', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4051','Mariana Pimentel' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4052','Mariano Moro', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4053','Marques de Souza' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4054','Mata' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4055','Mato Castelhano', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4056','Mato Leitão' , '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4057','Maximiliano de Almeida' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4058','Minas do Leão', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4059','Miraguaí', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4060','Montauri', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4061','Monte Alegre dos Campos', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4062','Monte Belo do Sul', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4063','Montenegro', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4064','Mormaço' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4065','Morrinhos do Sul' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4066','Morro Redondo', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4067','Morro Reuter', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4068','Mostardas' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4069','Muçum', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4070','Muitos Capões', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4071','Muliterno' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4072','Não-Me-Toque', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4073','Nicolau Vergueiro', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4074','Nonoai', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4075','Nova Alvorada', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4076','Nova Araçá', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4077','Nova Bassano', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4078','Nova Boa Vista' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4079','Nova Bréscia', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4080','Nova Candelária', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4081','Nova Esperança do Sul', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4082','Nova Hartz', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4083','Nova Pádua', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4084','Nova Palma', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4085','Nova Petrópolis', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4086','Nova Prata', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4087','Nova Ramada' , '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4088','Nova Roma do Sul' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4089','Nova Santa Rita', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4090','Novo Barreiro', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4091','Novo Cabrais', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4092','Novo Hamburgo', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4093','Novo Machado', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4094','Novo Tiradentes', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4095','Osório', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4096','Paim Filho', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4097','Palmares do Sul', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4098','Palmeira das Missões' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4099','Palmitinho', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4100','Panambi' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4101','Pantano Grande' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4102','Paraí', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4103','Paraíso do Sul' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4104','Pareci Novo' , '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4105','Parobé', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4106','Passa Sete', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4107','Passo do Sobrado' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4108','Passo Fundo' , '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4109','Paverama', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4110','Pedro Osório', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4111','Pejuçara', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4112','Pelotas' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4113','Picada Café' , '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4114','Pinhal', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4115','Pinhal Grande', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4116','Pinheirinho do Vale', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4117','Pinheiro Machado' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4118','Pirapó', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4119','Piratini', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4120','Planalto', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4121','Poço das Antas' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4122','Pontão', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4123','Ponte Preta' , '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4124','Portão', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4125','Porto Alegre', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4126','Porto Lucena', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4127','Porto Mauá', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4128','Porto Vera Cruz', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4129','Porto Xavier', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4130','Pouso Novo', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4131','Presidente Lucena', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4132','Progresso' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4133','Protásio Alves' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4134','Putinga' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4135','Quaraí', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4136','Quevedos', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4137','Quinze de Novembro', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4138','Redentora' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4139','Relvado' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4140','Restinga Seca', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4141','Rio dos Índios' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4142','Rio Grande', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4143','Rio Pardo' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4144','Riozinho', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4145','Roca Sales', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4146','Rodeio Bonito', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4147','Rolante' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4148','Ronda Alta', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4149','Rondinha', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4150','Roque Gonzales' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4151','Rosário do Sul' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4152','Sagrada Família', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4153','Saldanha Marinho' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4154','Salto do Jacuí' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4155','Salvador das Missões' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4156','Salvador do Sul', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4157','Sananduva' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4158','Santa Bárbara do Sul' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4159','Santa Clara do Sul', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4160','Santa Cruz do Sul', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4161','Santa Maria' , '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4162','Santa Maria do Herval', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4163','Santa Rosa', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4164','Santa Tereza', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4165','Santa Vitória do Palmar', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4166','Santana da Boa Vista' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4167','Santana do Livramento', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4168','Santiago', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4169','Santo Ângelo', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4170','Santo Antônio da Patrulha', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4171','Santo Antônio das Missões', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4172','Santo Antônio do Palma' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4173','Santo Antônio do Planalto', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4174','Santo Augusto', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4175','Santo Cristo', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4176','Santo Expedito do Sul', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4177','São Borja' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4178','São Domingos do Sul', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4179','São Francisco de Assis' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4180','São Francisco de Paula' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4181','São Gabriel' , '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4182','São Jerônimo', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4183','São João da Urtiga', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4184','São João do Polêsine' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4185','São Jorge' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4186','São José das Missões' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4187','São José do Herval', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4188','São José do Hortêncio', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4189','São José do Inhacorá' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4190','São José do Norte', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4191','São José do Ouro' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4192','São José dos Ausentes', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4193','São Leopoldo', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4194','São Lourenço do Sul', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4195','São Luiz Gonzaga' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4196','São Marcos', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4197','São Martinho', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4198','São Martinho da Serra', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4199','São Miguel das Missões' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4200','São Nicolau' , '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4201','São Paulo das Missões', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4202','São Pedro da Serra', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4203','São Pedro do Butiá', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4204','São Pedro do Sul' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4205','São Sebastião do Caí' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4206','São Sepé', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4207','São Valentim', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4208','São Valentim do Sul', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4209','São Valério do Sul', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4210','São Vendelino', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4211','São Vicente do Sul', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4212','Sapiranga' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4213','Sapucaia do Sul', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4214','Sarandi' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4215','Seberi', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4216','Sede Nova' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4217','Segredo' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4218','Selbach' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4219','Senador Salgado Filho', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4220','Sentinela do Sul' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4221','Serafina Corrêa', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4222','Sério', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4223','Sertão', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4224','Sertão Santana' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4225','Sete de Setembro' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4226','Severiano de Almeida' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4227','Silveira Martins' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4228','Sinimbu' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4229','Sobradinho', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4230','Soledade', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4231','Tabaí', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4232','Tapejara', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4233','Tapera', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4234','Tapes', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4235','Taquara' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4236','Taquari' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4237','Taquaruçu do Sul' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4238','Tavares' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4239','Tenente Portela', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4240','Terra de Areia' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4241','Teutônia', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4242','Tiradentes do Sul', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4243','Toropi', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4244','Torres', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4245','Tramandaí' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4246','Travesseiro' , '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4247','Três Arroios', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4248','Três Cachoeiras', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4249','Três Coroas' , '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4250','Três de Maio', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4251','Três Forquilhas', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4252','Três Palmeiras' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4253','Três Passos' , '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4254','Trindade do Sul', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4255','Triunfo' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4256','Tucunduva' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4257','Tunas', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4258','Tupanci do Sul' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4259','Tupanciretã' , '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4260','Tupandi' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4261','Tuparendi' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4262','Turuçu', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4263','Ubiretama' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4264','União da Serra' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4265','Unistalda' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4266','Uruguaiana', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4267','Vacaria' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4268','Vale do Sol' , '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4269','Vale Real' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4270','Vale Verde', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4271','Vanini', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4272','Venâncio Aires' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4273','Vera Cruz' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4274','Veranópolis' , '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4275','Vespasiano Correa', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4276','Viadutos', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4277','Viamão', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4278','Vicente Dutra', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4279','Victor Graeff', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4280','Vila Flores' , '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4281','Vila Lângaro', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4282','Vila Maria', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4283','Vila Nova do Sul' , '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4284','Vista Alegre', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4285','Vista Alegre do Prata', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4286','Vista Gaúcha', '23');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4287','Vitória das Missões', '23 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4288','Xangri-lá' , '23');
									
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4289','Alta Floresta d`Oeste', '24 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4290','Alto Alegre dos Parecis', '24');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4291','Alto Paraíso', '24');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4292','Alvorada d`Oeste' , '24');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4293','Ariquemes' , '24');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4294','Buritis' , '24');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4295','Cabixi', '24 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4296','Cacaulândia' , '24 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4297','Cacoal', '24 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4298','Campo Novo de Rondônia' , '24');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4299','Candeias do Jamari', '24');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4300','Castanheiras', '24');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4301','Cerejeiras', '24');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4302','Chupinguaia' , '24 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4303','Colorado do Oeste', '24');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4304','Corumbiara', '24');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4305','Costa Marques', '24 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4306','Cujubim' , '24');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4307','Espigão d`Oeste', '24 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4308','Governador Jorge Teixeira', '24');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4309','Guajará-Mirim', '24 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4310','Itapuã do Oeste', '24 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4311','Jaru' , '24');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4312','Ji-Paraná' , '24');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4313','Machadinho d`Oeste', '24');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4314','Ministro Andreazza', '24');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4315','Mirante da Serra' , '24');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4316','Monte Negro' , '24 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4317','Nova Brasilândia d`Oeste' , '24 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4318','Nova Mamoré' , '24 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4319','Nova União', '24');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4320','Novo Horizonte do Oeste', '24');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4321','Ouro Preto do Oeste', '24 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4322','Parecis' , '24');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4323','Pimenta Bueno', '24 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4324','Pimenteiras do Oeste' , '24');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4325','Porto Velho' , '24 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4326','Presidente Médici', '24');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4327','Primavera de Rondônia', '24 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4328','Rio Crespo', '24');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4329','Rolim de Moura' , '24');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4330','Santa Luzia d`Oeste', '24 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4331','São Felipe d`Oeste', '24');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4332','São Francisco do Guaporé' , '24 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4333','São Miguel do Guaporé', '24 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4334','Seringueiras', '24');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4335','Teixeirópolis', '24 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4336','Theobroma' , '24');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4337','Urupá', '24');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4338','Vale do Anari', '24 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4339','Vale do Paraíso', '24 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4340','Vilhena' , '24');

Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4341','Alto Alegre' , '25 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4342','Amajari' , '25');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4343','Boa Vista' , '25');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4344','Bonfim', '25 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4345','Cantá', '25');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4346','Caracaraí' , '25');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4347','Caroebe' , '25');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4348','Iracema' , '25');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4349','Mucajaí' , '25');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4350','Normandia' , '25');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4351','Pacaraima' , '25');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4352','Rorainópolis', '25');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4353','São João da Baliza', '25');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4354','São Luiz', '25 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4355','Uiramutã', '25 ');

Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4356','Abdon Batista', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4357','Abelardo Luz', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4358','Agrolândia', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4359','Agronômica', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4360','Água Doce' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4361','Águas de Chapecó' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4362','Águas Frias' , '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4363','Águas Mornas', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4364','Alfredo Wagner' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4365','Alto Bela Vista', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4366','Anchieta', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4367','Angelina', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4368','Anita Garibaldi', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4369','Anitápolis', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4370','Antônio Carlos' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4371','Apiúna', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4372','Arabutã' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4373','Araquari', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4374','Araranguá' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4375','Armazém' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4376','Arroio Trinta', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4377','Arvoredo', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4378','Ascurra' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4379','Atalanta', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4380','Aurora', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4381','Balneário Arroio do Silva', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4382','Balneário Barra do Sul' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4383','Balneário Camboriú', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4384','Balneário Gaivota', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4385','Bandeirante' , '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4386','Barra Bonita', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4387','Barra Velha' , '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4388','Bela Vista do Toldo', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4389','Belmonte', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4390','Benedito Novo', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4391','Biguaçu' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4392','Blumenau', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4393','Bocaina do Sul' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4394','Bom Jardim da Serra', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4395','Bom Jesus' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4396','Bom Jesus do Oeste', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4397','Bom Retiro', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4398','Bombinhas' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4399','Botuverá', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4400','Braço do Norte' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4401','Braço do Trombudo', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4402','Brunópolis', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4403','Brusque' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4404','Caçador' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4405','Caibi', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4406','Calmon', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4407','Camboriú', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4408','Campo Alegre', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4409','Campo Belo do Sul', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4410','Campo Erê' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4411','Campos Novos', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4412','Canelinha' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4413','Canoinhas' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4414','Capão Alto', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4415','Capinzal', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4416','Capivari de Baixo', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4417','Catanduvas', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4418','Caxambu do Sul' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4419','Celso Ramos' , '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4420','Cerro Negro' , '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4421','Chapadão do Lageado', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4422','Chapecó' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4423','Cocal do Sul', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4424','Concórdia' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4425','Cordilheira Alta' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4426','Coronel Freitas', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4427','Coronel Martins', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4428','Correia Pinto', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4429','Corupá', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4430','Criciúma', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4431','Cunha Porã', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4432','Cunhataí', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4433','Curitibanos' , '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4434','Descanso', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4435','Dionísio Cerqueira', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4436','Dona Emma' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4437','Doutor Pedrinho', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4438','Entre Rios', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4439','Ermo' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4440','Erval Velho' , '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4441','Faxinal dos Guedes', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4442','Flor do Sertão' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4443','Florianópolis', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4444','Formosa do Sul' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4445','Forquilhinha', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4446','Fraiburgo' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4447','Frei Rogério', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4448','Galvão', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4449','Garopaba', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4450','Garuva', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4451','Gaspar', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4452','Governador Celso Ramos' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4453','Grão Pará' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4454','Gravatal', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4455','Guabiruba' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4456','Guaraciaba', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4457','Guaramirim', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4458','Guarujá do Sul' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4459','Guatambú', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4460','Herval d`Oeste' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4461','Ibiam', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4462','Ibicaré' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4463','Ibirama' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4464','Içara', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4465','Ilhota', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4466','Imaruí', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4467','Imbituba', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4468','Imbuia', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4469','Indaial' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4470','Iomerê', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4471','Ipira', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4472','Iporã do Oeste' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4473','Ipuaçu', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4474','Ipumirim', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4475','Iraceminha', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4476','Irani', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4477','Irati', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4478','Irineópolis' , '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4479','Itá', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4480','Itaiópolis', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4481','Itajaí', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4482','Itapema' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4483','Itapiranga', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4484','Itapoá', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4485','Ituporanga', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4486','Jaborá', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4487','Jacinto Machado', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4488','Jaguaruna' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4489','Jaraguá do Sul' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4490','Jardinópolis', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4491','Joaçaba' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4492','Joinville' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4493','José Boiteux', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4494','Jupiá', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4495','Lacerdópolis', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4496','Lages', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4497','Laguna', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4498','Lajeado Grande' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4499','Laurentino', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4500','Lauro Muller', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4501','Lebon Régis' , '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4502','Leoberto Leal', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4503','Lindóia do Sul' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4504','Lontras' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4505','Luiz Alves', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4506','Luzerna' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4507','Macieira', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4508','Mafra', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4509','Major Gercino', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4510','Major Vieira', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4511','Maracajá', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4512','Maravilha' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4513','Marema', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4514','Massaranduba', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4515','Matos Costa' , '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4516','Meleiro' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4517','Mirim Doce', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4518','Modelo', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4519','Mondaí', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4520','Monte Carlo' , '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4521','Monte Castelo', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4522','Morro da Fumaça', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4523','Morro Grande', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4524','Navegantes', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4525','Nova Erechim', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4526','Nova Itaberaba' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4527','Nova Trento' , '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4528','Nova Veneza' , '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4529','Novo Horizonte' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4530','Orleans' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4531','Otacílio Costa' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4532','Ouro' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4533','Ouro Verde', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4534','Paial', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4535','Painel', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4536','Palhoça' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4537','Palma Sola', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4538','Palmeira', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4539','Palmitos', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4540','Papanduva' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4541','Paraíso' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4542','Passo de Torres', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4543','Passos Maia' , '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4544','Paulo Lopes' , '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4545','Pedras Grandes' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4546','Penha', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4547','Peritiba', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4548','Petrolândia' , '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4549','Piçarras', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4550','Pinhalzinho' , '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4551','Pinheiro Preto' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4552','Piratuba', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4553','Planalto Alegre', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4554','Pomerode', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4555','Ponte Alta', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4556','Ponte Alta do Norte', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4557','Ponte Serrada', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4558','Porto Belo', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4559','Porto União' , '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4560','Pouso Redondo', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4561','Praia Grande', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4562','Presidente Castelo Branco', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4563','Presidente Getúlio', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4564','Presidente Nereu' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4565','Princesa', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4566','Quilombo', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4567','Rancho Queimado', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4568','Rio das Antas', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4569','Rio do Campo', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4570','Rio do Oeste', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4571','Rio do Sul', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4572','Rio dos Cedros' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4573','Rio Fortuna' , '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4574','Rio Negrinho', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4575','Rio Rufino', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4576','Riqueza' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4577','Rodeio', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4578','Romelândia', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4579','Salete', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4580','Saltinho', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4581','Salto Veloso', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4582','Sangão', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4583','Santa Cecília', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4584','Santa Helena', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4585','Santa Rosa de Lima', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4586','Santa Rosa do Sul', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4587','Santa Terezinha', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4588','Santa Terezinha do Progresso', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4589','Santiago do Sul', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4590','Santo Amaro da Imperatriz', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4591','São Bento do Sul' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4592','São Bernardino' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4593','São Bonifácio', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4594','São Carlos', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4595','São Cristovão do Sul' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4596','São Domingos', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4597','São Francisco do Sul' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4598','São João Batista' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4599','São João do Itaperiú' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4600','São João do Oeste', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4601','São João do Sul', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4602','São Joaquim' , '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4603','São José', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4604','São José do Cedro', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4605','São José do Cerrito', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4606','São Lourenço do Oeste', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4607','São Ludgero' , '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4608','São Martinho', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4609','São Miguel da Boa Vista', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4610','São Miguel do Oeste', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4611','São Pedro de Alcântara' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4612','Saudades', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4613','Schroeder' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4614','Seara', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4615','Serra Alta', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4616','Siderópolis' , '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4617','Sombrio' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4618','Sul Brasil', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4619','Taió' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4620','Tangará' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4621','Tigrinhos' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4622','Tijucas' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4623','Timbé do Sul', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4624','Timbó', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4625','Timbó Grande', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4626','Três Barras' , '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4627','Treviso' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4628','Treze de Maio', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4629','Treze Tílias', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4630','Trombudo Central' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4631','Tubarão' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4632','Tunápolis' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4633','Turvo', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4634','União do Oeste' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4635','Urubici' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4636','Urupema' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4637','Urussanga' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4638','Vargeão' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4639','Vargem', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4640','Vargem Bonita', '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4641','Vidal Ramos' , '26 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4642','Videira' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4643','Vitor Meireles' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4644','Witmarsum' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4645','Xanxerê' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4646','Xavantina' , '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4647','Xaxim', '26');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4648','Zortéa', '26 ');

Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4649','Adamantina', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4650','Adolfo', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4651','Aguaí', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4652','Águas da Prata' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4653','Águas de Lindóia' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4654','Águas de Santa Bárbara' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4655','Águas de São Pedro', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4656','Agudos', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4657','Alambari', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4658','Alfredo Marcondes', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4659','Altair', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4660','Altinópolis' , '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4661','Alto Alegre' , '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4662','Alumínio', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4663','Álvares Florence' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4664','Álvares Machado', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4665','Álvaro de Carvalho', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4666','Alvinlândia' , '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4667','Americana' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4668','Américo Brasiliense', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4669','Américo de Campos', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4670','Amparo', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4671','Analândia' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4672','Andradina' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4673','Angatuba', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4674','Anhembi' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4675','Anhumas' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4676','Aparecida' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4677','Aparecida d`Oeste', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4678','Apiaí', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4679','Araçariguama', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4680','Araçatuba' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4681','Araçoiaba da Serra', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4682','Aramina' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4683','Arandu', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4684','Arapeí', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4685','Araraquara', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4686','Araras', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4687','Arco-Íris' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4688','Arealva' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4689','Areias', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4690','Areiópolis', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4691','Ariranha', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4692','Artur Nogueira' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4693','Arujá', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4694','Aspásia' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4695','Assis', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4696','Atibaia' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4697','Auriflama' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4698','Avaí' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4699','Avanhandava' , '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4700','Avaré', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4701','Bady Bassitt', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4702','Balbinos', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4703','Bálsamo' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4704','Bananal' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4705','Barão de Antonina', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4706','Barbosa' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4707','Bariri', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4708','Barra Bonita', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4709','Barra do Chapéu', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4710','Barra do Turvo' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4711','Barretos', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4712','Barrinha', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4713','Barueri' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4714','Bastos', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4715','Batatais', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4716','Bauru', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4717','Bebedouro' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4718','Bento de Abreu' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4719','Bernardino de Campos' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4720','Bertioga', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4721','Bilac', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4722','Birigui' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4723','Biritiba-Mirim' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4724','Boa Esperança do Sul' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4725','Bocaina' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4726','Bofete', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4727','Boituva' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4728','Bom Jesus dos Perdões', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4729','Bom Sucesso de Itararé' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4730','Borá' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4731','Boracéia', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4732','Borborema' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4733','Borebi', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4734','Botucatu', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4735','Bragança Paulista', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4736','Braúna', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4737','Brejo Alegre', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4738','Brodowski' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4739','Brotas', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4740','Buri' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4741','Buritama', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4742','Buritizal' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4743','Cabrália Paulista', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4744','Cabreúva', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4745','Caçapava', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4746','Cachoeira Paulista', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4747','Caconde' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4748','Cafelândia', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4749','Caiabu', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4750','Caieiras', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4751','Caiuá', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4752','Cajamar' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4753','Cajati', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4754','Cajobi', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4755','Cajuru', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4756','Campina do Monte Alegre', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4757','Campinas', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4758','Campo Limpo Paulista' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4759','Campos do Jordão' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4760','Campos Novos Paulista', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4761','Cananéia', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4762','Canas', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4763','Cândido Mota', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4764','Cândido Rodrigues', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4765','Canitar' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4766','Capão Bonito', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4767','Capela do Alto' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4768','Capivari', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4769','Caraguatatuba', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4770','Carapicuíba' , '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4771','Cardoso' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4772','Casa Branca' , '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4773','Cássia dos Coqueiros' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4774','Castilho', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4775','Catanduva' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4776','Catiguá' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4777','Cedral', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4778','Cerqueira César', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4779','Cerquilho' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4780','Cesário Lange', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4781','Charqueada', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4782','Chavantes' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4783','Clementina', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4784','Colina', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4785','Colômbia', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4786','Conchal' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4787','Conchas' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4788','Cordeirópolis', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4789','Coroados', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4790','Coronel Macedo' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4791','Corumbataí', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4792','Cosmópolis', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4793','Cosmorama' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4794','Cotia', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4795','Cravinhos' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4796','Cristais Paulista', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4797','Cruzália', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4798','Cruzeiro', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4799','Cubatão' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4800','Cunha', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4801','Descalvado', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4802','Diadema' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4803','Dirce Reis', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4804','Divinolândia', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4805','Dobrada' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4806','Dois Córregos', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4807','Dolcinópolis', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4808','Dourado' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4809','Dracena' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4810','Duartina', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4811','Dumont', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4812','Echaporã', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4813','Eldorado', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4814','Elias Fausto', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4815','Elisiário' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4816','Embaúba' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4817','Embu' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4818','Embu-Guaçu', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4819','Emilianópolis', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4820','Engenheiro Coelho', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4821','Espírito Santo do Pinhal' , '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4822','Espírito Santo do Turvo', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4823','Estiva Gerbi', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4824','Estrela d`Oeste', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4825','Estrela do Norte' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4826','Euclides da Cunha Paulista', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4827','Fartura' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4828','Fernando Prestes' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4829','Fernandópolis', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4830','Fernão', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4831','Ferraz de Vasconcelos', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4832','Flora Rica', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4833','Floreal' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4834','Florínia', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4835','Flórida Paulista' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4836','Franca', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4837','Francisco Morato' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4838','Franco da Rocha', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4839','Gabriel Monteiro' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4840','Gália', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4841','Garça', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4842','Gastão Vidigal' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4843','Gavião Peixoto' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4844','General Salgado', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4845','Getulina', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4846','Glicério', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4847','Guaiçara', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4848','Guaimbê' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4849','Guaíra', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4850','Guapiaçu', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4851','Guapiara', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4852','Guará', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4853','Guaraçaí', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4854','Guaraci' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4855','Guarani d`Oeste', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4856','Guarantã', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4857','Guararapes', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4858','Guararema' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4859','Guaratinguetá', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4860','Guareí', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4861','Guariba' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4862','Guarujá' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4863','Guarulhos' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4864','Guatapará' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4865','Guzolândia', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4866','Herculândia' , '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4867','Holambra', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4868','Hortolândia' , '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4869','Iacanga' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4870','Iacri', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4871','Iaras', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4872','Ibaté', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4873','Ibirá', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4874','Ibirarema' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4875','Ibitinga', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4876','Ibiúna', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4877','Icém' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4878','Iepê' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4879','Igaraçu do Tietê' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4880','Igarapava' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4881','Igaratá' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4882','Iguape', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4883','Ilha Comprida', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4884','Ilha Solteira', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4885','Ilhabela', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4886','Indaiatuba', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4887','Indiana' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4888','Indiaporã' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4889','Inúbia Paulista', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4890','Ipauçu', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4891','Iperó', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4892','Ipeúna', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4893','Ipiguá', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4894','Iporanga', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4895','Ipuã' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4896','Iracemápolis', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4897','Irapuã', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4898','Irapuru' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4899','Itaberá' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4900','Itaí' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4901','Itajobi' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4902','Itaju', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4903','Itanhaém', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4904','Itaóca', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4905','Itapecerica da Serra' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4906','Itapetininga', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4907','Itapeva' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4908','Itapevi' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4909','Itapira' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4910','Itapirapuã Paulista', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4911','Itápolis', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4912','Itaporanga', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4913','Itapuí', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4914','Itapura' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4915','Itaquaquecetuba', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4916','Itararé' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4917','Itariri' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4918','Itatiba' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4919','Itatinga', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4920','Itirapina' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4921','Itirapuã', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4922','Itobi', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4923','Itu', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4924','Itupeva' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4925','Ituverava' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4926','Jaborandi' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4927','Jaboticabal' , '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4928','Jacareí' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4929','Jaci' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4930','Jacupiranga' , '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4931','Jaguariúna', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4932','Jales', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4933','Jambeiro', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4934','Jandira' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4935','Jardinópolis', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4936','Jarinu', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4937','Jaú', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4938','Jeriquara' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4939','Joanópolis', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4940','João Ramalho', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4941','José Bonifácio' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4942','Júlio Mesquita' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4943','Jumirim' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4944','Jundiaí' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4945','Junqueirópolis' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4946','Juquiá', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4947','Juquitiba' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4948','Lagoinha', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4949','Laranjal Paulista', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4950','Lavínia' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4951','Lavrinhas' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4952','Leme' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4953','Lençóis Paulista' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4954','Limeira' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4955','Lindóia' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4956','Lins' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4957','Lorena', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4958','Lourdes' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4959','Louveira', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4960','Lucélia' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4961','Lucianópolis', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4962','Luís Antônio', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4963','Luiziânia' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4964','Lupércio', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4965','Lutécia' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4966','Macatuba', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4967','Macaubal', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4968','Macedônia' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4969','Magda', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4970','Mairinque' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4971','Mairiporã' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4972','Manduri' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4973','Marabá Paulista', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4974','Maracaí' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4975','Marapoama' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4976','Mariápolis', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4977','Marília' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4978','Marinópolis' , '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4979','Martinópolis', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4980','Matão', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4981','Mauá' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4982','Mendonça', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4983','Meridiano' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4984','Mesópolis' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4985','Miguelópolis', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4986','Mineiros do Tietê', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4987','Mira Estrela', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4988','Miracatu', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4989','Mirandópolis', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4990','Mirante do Paranapanema', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4991','Mirassol', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4992','Mirassolândia', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4993','Mococa', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4994','Mogi das Cruzes', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4995','Mogi Guaçu', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4996','Mogi-Mirim', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4997','Mombuca' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4998','Monções' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('4999','Mongaguá', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5000','Monte Alegre do Sul', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5001','Monte Alto', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5002','Monte Aprazível', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5003','Monte Azul Paulista', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5004','Monte Castelo', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5005','Monte Mor' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5006','Monteiro Lobato', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5007','Morro Agudo' , '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5008','Morungaba' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5009','Motuca', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5010','Murutinga do Sul' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5011','Nantes', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5012','Narandiba' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5013','Natividade da Serra', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5014','Nazaré Paulista', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5015','Neves Paulista' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5016','Nhandeara' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5017','Nipoã', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5018','Nova Aliança', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5019','Nova Campina', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5020','Nova Canaã Paulista', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5021','Nova Castilho', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5022','Nova Europa' , '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5023','Nova Granada', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5024','Nova Guataporanga', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5025','Nova Independência', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5026','Nova Luzitânia' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5027','Nova Odessa' , '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5028','Novais', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5029','Novo Horizonte' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5030','Nuporanga' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5031','Ocauçu', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5032','Óleo' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5033','Olímpia' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5034','Onda Verde', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5035','Oriente' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5036','Orindiúva' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5037','Orlândia', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5038','Osasco', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5039','Oscar Bressane' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5040','Osvaldo Cruz', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5041','Ourinhos', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5042','Ouro Verde', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5043','Ouroeste', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5044','Pacaembu', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5045','Palestina' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5046','Palmares Paulista', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5047','Palmeira d`Oeste' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5048','Palmital', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5049','Panorama', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5050','Paraguaçu Paulista', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5051','Paraibuna' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5052','Paraíso' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5053','Paranapanema', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5054','Paranapuã' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5055','Parapuã' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5056','Pardinho', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5057','Pariquera-Açu', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5058','Parisi', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5059','Patrocínio Paulista', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5060','Paulicéia' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5061','Paulínia', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5062','Paulistânia' , '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5063','Paulo de Faria' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5064','Pederneiras' , '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5065','Pedra Bela', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5066','Pedranópolis', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5067','Pedregulho', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5068','Pedreira', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5069','Pedrinhas Paulista', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5070','Pedro de Toledo', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5071','Penápolis' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5072','Pereira Barreto', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5073','Pereiras', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5074','Peruíbe' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5075','Piacatu' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5076','Piedade' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5077','Pilar do Sul', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5078','Pindamonhangaba', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5079','Pindorama' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5080','Pinhalzinho' , '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5081','Piquerobi' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5082','Piquete' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5083','Piracaia', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5084','Piracicaba', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5085','Piraju', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5086','Pirajuí' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5087','Pirangi' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5088','Pirapora do Bom Jesus', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5089','Pirapozinho' , '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5090','Pirassununga', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5091','Piratininga' , '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5092','Pitangueiras', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5093','Planalto', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5094','Platina' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5095','Poá', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5096','Poloni', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5097','Pompéia' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5098','Pongaí', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5099','Pontal', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5100','Pontalinda', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5101','Pontes Gestal', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5102','Populina', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5103','Porangaba' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5104','Porto Feliz' , '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5105','Porto Ferreira' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5106','Potim', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5107','Potirendaba' , '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5108','Pracinha', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5109','Pradópolis', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5110','Praia Grande', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5111','Pratânia', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5112','Presidente Alves' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5113','Presidente Bernardes' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5114','Presidente Epitácio', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5115','Presidente Prudente', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5116','Presidente Venceslau' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5117','Promissão' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5118','Quadra', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5119','Quatá', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5120','Queiroz' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5121','Queluz', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5122','Quintana', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5123','Rafard', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5124','Rancharia' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5125','Redenção da Serra', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5126','Regente Feijó', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5127','Reginópolis' , '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5128','Registro', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5129','Restinga', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5130','Ribeira' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5131','Ribeirão Bonito', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5132','Ribeirão Branco', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5133','Ribeirão Corrente', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5134','Ribeirão do Sul', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5135','Ribeirão dos Índios', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5136','Ribeirão Grande', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5137','Ribeirão Pires' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5138','Ribeirão Preto' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5139','Rifaina' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5140','Rincão', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5141','Rinópolis' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5142','Rio Claro' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5143','Rio das Pedras' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5144','Rio Grande da Serra', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5145','Riolândia' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5146','Riversul', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5147','Rosana', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5148','Roseira' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5149','Rubiácea', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5150','Rubinéia', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5151','Sabino', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5152','Sagres', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5153','Sales', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5154','Sales Oliveira' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5155','Salesópolis' , '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5156','Salmourão' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5157','Saltinho', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5158','Salto', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5159','Salto de Pirapora', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5160','Salto Grande', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5161','Sandovalina' , '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5162','Santa Adélia', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5163','Santa Albertina', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5164','Santa Bárbara d`Oeste', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5165','Santa Branca', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5166','Santa Clara d`Oeste', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5167','Santa Cruz da Conceição', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5168','Santa Cruz da Esperança', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5169','Santa Cruz das Palmeiras' , '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5170','Santa Cruz do Rio Pardo', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5171','Santa Ernestina', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5172','Santa Fé do Sul', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5173','Santa Gertrudes', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5174','Santa Isabel', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5175','Santa Lúcia' , '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5176','Santa Maria da Serra' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5177','Santa Mercedes' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5178','Santa Rita d`Oeste', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5179','Santa Rita do Passa Quatro', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5180','Santa Rosa de Viterbo', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5181','Santa Salete', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5182','Santana da Ponte Pensa' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5183','Santana de Parnaíba', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5184','Santo Anastácio', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5185','Santo André' , '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5186','Santo Antônio da Alegria' , '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5187','Santo Antônio de Posse' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5188','Santo Antônio do Aracanguá', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5189','Santo Antônio do Jardim', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5190','Santo Antônio do Pinhal', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5191','Santo Expedito' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5192','Santópolis do Aguapeí', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5193','Santos', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5194','São Bento do Sapucaí' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5195','São Bernardo do Campo', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5196','São Caetano do Sul', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5197','São Carlos', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5198','São Francisco', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5199','São João da Boa Vista', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5200','São João das Duas Pontes' , '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5201','São João de Iracema', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5202','São João do Pau d`Alho' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5203','São Joaquim da Barra' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5204','São José da Bela Vista' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5205','São José do Barreiro' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5206','São José do Rio Pardo', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5207','São José do Rio Preto', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5208','São José dos Campos', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5209','São Lourenço da Serra', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5210','São Luís do Paraitinga' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5211','São Manuel', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5212','São Miguel Arcanjo', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5213','São Paulo' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5214','São Pedro' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5215','São Pedro do Turvo', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5216','São Roque' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5217','São Sebastião', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5218','São Sebastião da Grama' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5219','São Simão' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5220','São Vicente' , '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5221','Sarapuí' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5222','Sarutaiá', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5223','Sebastianópolis do Sul' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5224','Serra Azul', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5225','Serra Negra' , '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5226','Serrana' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5227','Sertãozinho' , '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5228','Sete Barras' , '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5229','Severínia' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5230','Silveiras' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5231','Socorro' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5232','Sorocaba', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5233','Sud Mennucci', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5234','Sumaré', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5235','Suzanápolis' , '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5236','Suzano', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5237','Tabapuã' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5238','Tabatinga' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5239','Taboão da Serra', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5240','Taciba', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5241','Taguaí', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5242','Taiaçu', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5243','Taiúva', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5244','Tambaú', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5245','Tanabi', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5246','Tapiraí' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5247','Tapiratiba', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5248','Taquaral', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5249','Taquaritinga', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5250','Taquarituba' , '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5251','Taquarivaí', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5252','Tarabai' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5253','Tarumã', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5254','Tatuí', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5255','Taubaté' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5256','Tejupá', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5257','Teodoro Sampaio', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5258','Terra Roxa', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5259','Tietê', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5260','Timburi' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5261','Torre de Pedra' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5262','Torrinha', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5263','Trabiju' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5264','Tremembé', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5265','Três Fronteiras', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5266','Tuiuti', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5267','Tupã' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5268','Tupi Paulista', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5269','Turiúba' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5270','Turmalina' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5271','Ubarana' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5272','Ubatuba' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5273','Ubirajara' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5274','Uchoa', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5275','União Paulista' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5276','Urânia', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5277','Uru', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5278','Urupês', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5279','Valentim Gentil', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5280','Valinhos', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5281','Valparaíso', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5282','Vargem', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5283','Vargem Grande do Sul' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5284','Vargem Grande Paulista' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5285','Várzea Paulista', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5286','Vera Cruz' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5287','Vinhedo' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5288','Viradouro' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5289','Vista Alegre do Alto' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5290','Vitória Brasil' , '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5291','Votorantim', '02');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5292','Votuporanga' , '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5293','Zacarias', '02 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5294','Amparo de São Francisco', '27');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5295','Aquidabã', '27 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5296','Aracaju' , '27');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5297','Arauá', '27');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5298','Areia Branca', '27');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5299','Barra dos Coqueiros', '27 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5300','Boquim', '27 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5301','Brejo Grande', '27');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5302','Campo do Brito' , '27');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5303','Canhoba' , '27');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5304','Canindé de São Francisco' , '27 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5305','Capela', '27 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5306','Carira', '27 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5307','Carmópolis', '27');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5308','Cedro de São João', '27');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5309','Cristinápolis', '27 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5310','Cumbe', '27');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5311','Divina Pastora' , '27');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5312','Estância', '27 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5313','Feira Nova', '27');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5314','Frei Paulo', '27');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5315','Gararu', '27 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5316','General Maynard', '27 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5317','Gracho Cardoso' , '27');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5318','Ilha das Flores', '27 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5319','Indiaroba' , '27');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5320','Itabaiana' , '27');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5321','Itabaianinha', '27');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5322','Itabi', '27');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5323','Itaporanga d`Ajuda', '27');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5324','Japaratuba', '27');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5325','Japoatã' , '27');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5326','Lagarto' , '27');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5327','Laranjeiras' , '27 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5328','Macambira' , '27');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5329','Malhada dos Bois' , '27');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5330','Malhador', '27 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5331','Maruim', '27 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5332','Moita Bonita', '27');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5333','Monte Alegre de Sergipe', '27');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5334','Muribeca', '27 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5335','Neópolis', '27 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5336','Nossa Senhora Aparecida', '27');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5337','Nossa Senhora da Glória', '27');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5338','Nossa Senhora das Dores', '27');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5339','Nossa Senhora de Lourdes' , '27 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5340','Nossa Senhora do Socorro' , '27 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5341','Pacatuba', '27 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5342','Pedra Mole', '27');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5343','Pedrinhas' , '27');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5344','Pinhão', '27 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5345','Pirambu' , '27');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5346','Poço Redondo', '27');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5347','Poço Verde', '27');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5348','Porto da Folha' , '27');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5349','Propriá' , '27');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5350','Riachão do Dantas', '27');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5351','Riachuelo' , '27');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5352','Ribeirópolis', '27');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5353','Rosário do Catete', '27');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5354','Salgado' , '27');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5355','Santa Luzia do Itanhy', '27 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5356','Santa Rosa de Lima', '27');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5357','Santana do São Francisco' , '27 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5358','Santo Amaro das Brotas' , '27');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5359','São Cristóvão', '27 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5360','São Domingos', '27');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5361','São Francisco', '27 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5362','São Miguel do Aleixo' , '27');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5363','Simão Dias', '27');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5364','Siriri', '27 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5365','Telha', '27');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5366','Tobias Barreto' , '27');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5367','Tomar do Geru', '27 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5368','Umbaúba' , '27');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5369','Abreulândia' , '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5370','Aguiarnópolis', '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5371','Aliança do Tocantins' , '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5372','Almas', '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5373','Alvorada', '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5374','Ananás', '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5375','Angico', '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5376','Aparecida do Rio Negro' , '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5377','Aragominas', '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5378','Araguacema', '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5379','Araguaçu', '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5380','Araguaína' , '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5381','Araguanã', '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5382','Araguatins', '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5383','Arapoema', '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5384','Arraias' , '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5385','Augustinópolis' , '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5386','Aurora do Tocantins', '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5387','Axixá do Tocantins', '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5388','Babaçulândia', '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5389','Bandeirantes do Tocantins', '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5390','Barra do Ouro', '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5391','Barrolândia' , '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5392','Bernardo Sayão' , '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5393','Bom Jesus do Tocantins' , '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5394','Brasilândia do Tocantins' , '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5395','Brejinho de Nazaré', '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5396','Buriti do Tocantins', '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5397','Cachoeirinha', '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5398','Campos Lindos', '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5399','Cariri do Tocantins', '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5400','Carmolândia' , '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5401','Carrasco Bonito', '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5402','Caseara' , '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5403','Centenário', '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5404','Chapada da Natividade', '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5405','Chapada de Areia' , '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5406','Colinas do Tocantins' , '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5407','Colméia' , '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5408','Combinado' , '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5409','Conceição do Tocantins' , '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5410','Couto de Magalhães', '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5411','Cristalândia', '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5412','Crixás do Tocantins', '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5413','Darcinópolis', '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5414','Dianópolis', '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5415','Divinópolis do Tocantins' , '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5416','Dois Irmãos do Tocantins' , '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5417','Dueré', '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5418','Esperantina' , '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5419','Fátima', '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5420','Figueirópolis', '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5421','Filadélfia', '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5422','Formoso do Araguaia', '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5423','Fortaleza do Tabocão' , '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5424','Goianorte' , '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5425','Goiatins', '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5426','Guaraí', '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5427','Gurupi', '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5428','Ipueiras', '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5429','Itacajá' , '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5430','Itaguatins', '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5431','Itapiratins' , '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5432','Itaporã do Tocantins' , '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5433','Jaú do Tocantins' , '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5434','Juarina' , '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5435','Lagoa da Confusão', '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5436','Lagoa do Tocantins', '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5437','Lajeado' , '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5438','Lavandeira', '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5439','Lizarda' , '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5440','Luzinópolis' , '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5441','Marianópolis do Tocantins', '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5442','Mateiros', '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5443','Maurilândia do Tocantins' , '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5444','Miracema do Tocantins', '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5445','Miranorte' , '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5446','Monte do Carmo' , '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5447','Monte Santo do Tocantins' , '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5448','Muricilândia', '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5449','Natividade', '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5450','Nazaré', '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5451','Nova Olinda' , '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5452','Nova Rosalândia', '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5453','Novo Acordo' , '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5454','Novo Alegre' , '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5455','Novo Jardim' , '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5456','Oliveira de Fátima', '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5457','Palmas', '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5458','Palmeirante' , '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5459','Palmeiras do Tocantins' , '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5460','Palmeirópolis', '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5461','Paraíso do Tocantins' , '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5462','Paranã', '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5463','Pau d`Arco', '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5464','Pedro Afonso', '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5465','Peixe', '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5466','Pequizeiro', '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5467','Pindorama do Tocantins' , '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5468','Piraquê' , '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5469','Pium' , '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5470','Ponte Alta do Bom Jesus', '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5471','Ponte Alta do Tocantins', '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5472','Porto Alegre do Tocantins', '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5473','Porto Nacional' , '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5474','Praia Norte' , '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5475','Presidente Kennedy', '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5476','Pugmil', '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5477','Recursolândia', '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5478','Riachinho' , '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5479','Rio da Conceição' , '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5480','Rio dos Bois', '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5481','Rio Sono', '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5482','Sampaio' , '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5483','Sandolândia' , '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5484','Santa Fé do Araguaia' , '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5485','Santa Maria do Tocantins' , '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5486','Santa Rita do Tocantins', '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5487','Santa Rosa do Tocantins', '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5488','Santa Tereza do Tocantins', '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5489','Santa Terezinha do Tocantins', '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5490','São Bento do Tocantins' , '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5491','São Félix do Tocantins' , '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5492','São Miguel do Tocantins', '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5493','São Salvador do Tocantins', '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5494','São Sebastião do Tocantins', '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5495','São Valério da Natividade', '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5496','Silvanópolis', '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5497','Sítio Novo do Tocantins', '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5498','Sucupira', '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5499','Taguatinga', '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5500','Taipas do Tocantins', '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5501','Talismã' , '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5502','Tocantínia', '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5503','Tocantinópolis' , '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5504','Tupirama', '05 ');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5505','Tupiratins', '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5506','Wanderlândia', '05');
Insert into CIDADES (IDCIDADE, NOMECIDADE, IDUF) values ('5507','Xambioá' , '05');
Insert into CIDADES (IDCIDADE,NOMECIDADE,IDUF) values ('5508','Brazlandia','1');
Insert into CIDADES (IDCIDADE,NOMECIDADE,IDUF) values ('5509','Candangolandia','1');
Insert into CIDADES (IDCIDADE,NOMECIDADE,IDUF) values ('5510','Ceilandia','1');
Insert into CIDADES (IDCIDADE,NOMECIDADE,IDUF) values ('5511','Cruzeiro','1');
Insert into CIDADES (IDCIDADE,NOMECIDADE,IDUF) values ('5512','Gama','1');
Insert into CIDADES (IDCIDADE,NOMECIDADE,IDUF) values ('5513','Guara','1');
Insert into CIDADES (IDCIDADE,NOMECIDADE,IDUF) values ('5514','Lago Norte','1');
Insert into CIDADES (IDCIDADE,NOMECIDADE,IDUF) values ('5515','Lago Sul','1');
Insert into CIDADES (IDCIDADE,NOMECIDADE,IDUF) values ('5516','Nucleo Bandeirante','1');
Insert into CIDADES (IDCIDADE,NOMECIDADE,IDUF) values ('5517','Paranoa','1');
Insert into CIDADES (IDCIDADE,NOMECIDADE,IDUF) values ('5518','Planaltina','1');
Insert into CIDADES (IDCIDADE,NOMECIDADE,IDUF) values ('5519','Recanto das Emas','1');
Insert into CIDADES (IDCIDADE,NOMECIDADE,IDUF) values ('5520','Riacho Fundo','1');
Insert into CIDADES (IDCIDADE,NOMECIDADE,IDUF) values ('5521','Samambaia','1');
Insert into CIDADES (IDCIDADE,NOMECIDADE,IDUF) values ('5522','Santa Maria','1');
Insert into CIDADES (IDCIDADE,NOMECIDADE,IDUF) values ('5523','Sao Sebastiao','1');
Insert into CIDADES (IDCIDADE,NOMECIDADE,IDUF) values ('5524','Sobradinho','1');
Insert into CIDADES (IDCIDADE,NOMECIDADE,IDUF) values ('5525','Taguatinga','1');
Insert into CIDADES (IDCIDADE,NOMECIDADE,IDUF) values ('5526','Abadia de Goiás','4');
REM INSERTING into CLIENTES
SET DEFINE OFF;
Insert into CLIENTES (IDCLIENTE,NOMERAZAOSOCIAL,NOMEFANTASIA,CPFCNPJ,SITUACAO,DELETED) values ('1','Cliente 1','Cliente 1',' ','A',null);
REM INSERTING into COLECAO
SET DEFINE OFF;
REM INSERTING into COLETAPRECO
SET DEFINE OFF;
REM INSERTING into COMANDO
SET DEFINE OFF;
REM INSERTING into COMANDOSISTEMAOPERACIONAL
SET DEFINE OFF;
REM INSERTING into COMENTARIOS
SET DEFINE OFF;
REM INSERTING into COMPLEXIDADE
SET DEFINE OFF;
REM INSERTING into CONDICAOOPERACAO
SET DEFINE OFF;
Insert into CONDICAOOPERACAO (IDCONDICAOOPERACAO,IDEMPRESA,NOMECONDICAOOPERACAO,DATAINICIO,DATAFIM) values ('1','1','24 X 7',to_date('01/01/12','DD/MM/RR'),null);
Insert into CONDICAOOPERACAO (IDCONDICAOOPERACAO,IDEMPRESA,NOMECONDICAOOPERACAO,DATAINICIO,DATAFIM) values ('2','1','Horário Comercial',to_date('01/01/12','DD/MM/RR'),null);
REM INSERTING into CONHECIMENTOIC
SET DEFINE OFF;
REM INSERTING into CONHECIMENTOMUDANCA
SET DEFINE OFF;
REM INSERTING into CONHECIMENTOPROBLEMA
SET DEFINE OFF;
REM INSERTING into CONHECIMENTOSOLICITACAOSERVICO
SET DEFINE OFF;
REM INSERTING into CONTADORACESSO
SET DEFINE OFF;
REM INSERTING into CONTATOCLIENTE
SET DEFINE OFF;
REM INSERTING into CONTATOREQUISICAOMUDANCA
SET DEFINE OFF;
REM INSERTING into CONTATOSOLICITACAOSERVICO
SET DEFINE OFF;
Insert into CONTATOSOLICITACAOSERVICO (IDCONTATOSOLICITACAOSERVICO,NOMECONTATO,TELEFONECONTATO,EMAILCONTATO,IDLOCALIDADE,RAMAL) values ('1','Default','3242-4433','citsmart_instalador_mysql@centralit.com.br',null,null);
Insert into CONTATOSOLICITACAOSERVICO (IDCONTATOSOLICITACAOSERVICO,NOMECONTATO,TELEFONECONTATO,EMAILCONTATO,IDLOCALIDADE,RAMAL) values ('2','Default','3242-4433','citsmart_instalador_mysql@centralit.com.br',null,null);
Insert into CONTATOSOLICITACAOSERVICO (IDCONTATOSOLICITACAOSERVICO,NOMECONTATO,TELEFONECONTATO,EMAILCONTATO,IDLOCALIDADE,RAMAL) values ('3','Consultor','3242-4433','citsmart_instalador_mysql@centralit.com.br',null,null);
Insert into CONTATOSOLICITACAOSERVICO (IDCONTATOSOLICITACAOSERVICO,NOMECONTATO,TELEFONECONTATO,EMAILCONTATO,IDLOCALIDADE,RAMAL) values ('4','Consultor','3242-4433','citsmart_instalador_mysql@centralit.com.br',null,null);
REM INSERTING into CONTRATOQUESTIONARIOS
SET DEFINE OFF;
REM INSERTING into CONTRATOS
SET DEFINE OFF;
Insert into CONTRATOS (IDCONTRATO,IDCLIENTE,IDMOEDA,IDFORNECEDOR,NUMERO,DATACONTRATO,VALORESTIMADO,TIPOTEMPOESTIMADO,TEMPOESTIMADO,TIPO,SITUACAO,COTACAOMOEDA,CADASTROMANUALUSUARIO,DELETED,IDGRUPOSOLICITANTE,DATAFIMCONTRATO) values ('1','1','1','1','1',to_date('01/04/13','DD/MM/RR'),'1000000',null,null,'C','A','1','N',null,'2',to_date('31/12/14','DD/MM/RR'));
REM INSERTING into CONTRATOSCOLABORADORES
SET DEFINE OFF;
REM INSERTING into CONTRATOSGRUPOS
SET DEFINE OFF;
Insert into CONTRATOSGRUPOS (IDGRUPO,IDCONTRATO) values ('2','1');
Insert into CONTRATOSGRUPOS (IDGRUPO,IDCONTRATO) values ('3','1');
Insert into CONTRATOSGRUPOS (IDGRUPO,IDCONTRATO) values ('4','1');
Insert into CONTRATOSGRUPOS (IDGRUPO,IDCONTRATO) values ('16','1');
Insert into CONTRATOSGRUPOS (IDGRUPO,IDCONTRATO) values ('17','1');
Insert into CONTRATOSGRUPOS (IDGRUPO,IDCONTRATO) values ('19','1');
REM INSERTING into CONTRATOS_HIST
SET DEFINE OFF;
Insert into CONTRATOS_HIST (IDCONTRATO_HIST,IDCONTRATO,IDCLIENTE,IDMOEDA,IDFORNECEDOR,NUMERO,DATACONTRATO,VALORESTIMADO,TIPOTEMPOESTIMADO,TEMPOESTIMADO,TIPO,SITUACAO,COTACAOMOEDA,CADASTROMANUALUSUARIO,DELETED,IDGRUPOSOLICITANTE,DATAFIMCONTRATO,CRIADOEM,CRIADOPOR,MODIFICADOEM,MODIFICADOPOR) values ('1','1','1','1','1','1',to_date('01/04/13','DD/MM/RR'),'1000000',null,null,'C','A','1',null,null,'2',to_date('31/12/14','DD/MM/RR'),to_date('02/04/13','DD/MM/RR'),'Administrador',to_date('02/04/13','DD/MM/RR'),'Administrador');
REM INSERTING into CONTRATOSUNIDADES
SET DEFINE OFF;
REM INSERTING into CONTROLEGED
SET DEFINE OFF;
REM INSERTING into CONTROLEQUESTIONARIOS
SET DEFINE OFF;
REM INSERTING into COTACAO
SET DEFINE OFF;
REM INSERTING into COTACAOITEMREQUISICAO
SET DEFINE OFF;
REM INSERTING into CRITERIOAVALIACAO
SET DEFINE OFF;
REM INSERTING into CRITERIOAVALIACAOFORNECEDOR
SET DEFINE OFF;
REM INSERTING into CRITERIOCOTACAO
SET DEFINE OFF;
REM INSERTING into CRITERIOCOTACAOCATEGORIA
SET DEFINE OFF;
REM INSERTING into CRITERIOITEMCOTACAO
SET DEFINE OFF;
REM INSERTING into DEMANDAS
SET DEFINE OFF;
REM INSERTING into DICIONARIO
SET DEFINE OFF;
REM INSERTING into EMAILSOLICITACAOSERVICO
SET DEFINE OFF;
REM INSERTING into EMPREGADOITEMCONFIGURACAO
SET DEFINE OFF;
REM INSERTING into EMPREGADOS
SET DEFINE OFF;
Insert into EMPREGADOS (IDEMPREGADO,NOME,NOMEPROCURA,DATANASCIMENTO,SEXO,CPF,RG,DATAEMISSAORG,IDTIPOSANGUE,ORGEXPEDIDOR,IDUFORGEXPEDIDOR,PAI,MAE,CONJUGE,ESTADOCIVIL,EMAIL,DATACADASTRO,FUMANTE,CTPSNUMERO,CTPSSERIE,CTPSIDUF,CTPSDATAEMISSAO,NIT,DATAADMISSAO,DATADEMISSAO,TIPO,IDSITUACAOFUNCIONAL,CUSTOPORHORA,CUSTOTOTALMES,VALORSALARIO,VALORPRODUTIVIDADEMEDIA,VALORPLANOSAUDEMEDIA,VALORVTRAMEDIA,VALORVREFMEDIA,AGENCIA,CONTASALARIO,IDUNIDADE,DATAFIM,TELEFONE,IDCARGO,VINCULAACONTRATOS,RAMAL) values ('1','Administrador','Administrador',to_date('01/01/12','DD/MM/RR'),'M',' ',' ',null,'0',' ',null,' ',' ',' ',null,'citsmart_instalador_mysql@centralit.com.br',null,null,' ',' ',null,null,' ',to_date('01/01/12','DD/MM/RR'),null,'E','1',null,null,null,null,null,null,null,' ',' ','1',null,'3242-4433','1',null,null);
Insert into EMPREGADOS (IDEMPREGADO,NOME,NOMEPROCURA,DATANASCIMENTO,SEXO,CPF,RG,DATAEMISSAORG,IDTIPOSANGUE,ORGEXPEDIDOR,IDUFORGEXPEDIDOR,PAI,MAE,CONJUGE,ESTADOCIVIL,EMAIL,DATACADASTRO,FUMANTE,CTPSNUMERO,CTPSSERIE,CTPSIDUF,CTPSDATAEMISSAO,NIT,DATAADMISSAO,DATADEMISSAO,TIPO,IDSITUACAOFUNCIONAL,CUSTOPORHORA,CUSTOTOTALMES,VALORSALARIO,VALORPRODUTIVIDADEMEDIA,VALORPLANOSAUDEMEDIA,VALORVTRAMEDIA,VALORVREFMEDIA,AGENCIA,CONTASALARIO,IDUNIDADE,DATAFIM,TELEFONE,IDCARGO,VINCULAACONTRATOS,RAMAL) values ('2','Default','Default',to_date('01/01/12','DD/MM/RR'),'M',' ',' ',null,'0',' ',null,' ',' ',' ',null,'citsmart_instalador_mysql@centralit.com.br',null,null,' ',' ',null,null,' ',to_date('01/01/12','DD/MM/RR'),null,'E','1',null,null,null,null,null,null,null,' ',' ','1',null,'3242-4433','2',null,null);
Insert into EMPREGADOS (IDEMPREGADO,NOME,NOMEPROCURA,DATANASCIMENTO,SEXO,CPF,RG,DATAEMISSAORG,IDTIPOSANGUE,ORGEXPEDIDOR,IDUFORGEXPEDIDOR,PAI,MAE,CONJUGE,ESTADOCIVIL,EMAIL,DATACADASTRO,FUMANTE,CTPSNUMERO,CTPSSERIE,CTPSIDUF,CTPSDATAEMISSAO,NIT,DATAADMISSAO,DATADEMISSAO,TIPO,IDSITUACAOFUNCIONAL,CUSTOPORHORA,CUSTOTOTALMES,VALORSALARIO,VALORPRODUTIVIDADEMEDIA,VALORPLANOSAUDEMEDIA,VALORVTRAMEDIA,VALORVREFMEDIA,AGENCIA,CONTASALARIO,IDUNIDADE,DATAFIM,TELEFONE,IDCARGO,VINCULAACONTRATOS,RAMAL) values ('3','Consultor','Consultor',to_date('01/01/12','DD/MM/RR'),'M',' ',' ',null,'0',' ',null,' ',' ',' ',null,'contact@citsmart.com',null,null,' ',' ',null,null,' ',to_date('01/01/12','DD/MM/RR'),null,'E','1',null,null,null,null,null,null,null,' ',' ','1',null,'3242-4433','1',null,null);
REM INSERTING into EMPRESA
SET DEFINE OFF;
Insert into EMPRESA (IDEMPRESA,NOMEEMPRESA,DATAINICIO,DATAFIM) values ('1','Default',to_date('18/03/13','DD/MM/RR'),null);
REM INSERTING into ENDERECO
SET DEFINE OFF;
Insert into ENDERECO (IDENDERECO,LOGRADOURO,NUMERO,COMPLEMENTO,BAIRRO,IDCIDADE,IDPAIS,CEP,IDUF) values ('1',null,null,null,null,'971','1',null,'4');
REM INSERTING into ENTREGAITEMREQUISICAO
SET DEFINE OFF;
REM INSERTING into ETAPAS
SET DEFINE OFF;
REM INSERTING into EVENTO
SET DEFINE OFF;
REM INSERTING into EVENTOEMPREGADO
SET DEFINE OFF;
REM INSERTING into EVENTOGRUPO
SET DEFINE OFF;
REM INSERTING into EVENTOITEMCONFIGURACAO
SET DEFINE OFF;
REM INSERTING into EVENTOMONITCONHECIMENTO
SET DEFINE OFF;
REM INSERTING into EVENTOMONITORAMENTO
SET DEFINE OFF;
REM INSERTING into EVENTOUNIDADE
SET DEFINE OFF;
REM INSERTING into EXCECAOCALENDARIO
SET DEFINE OFF;
REM INSERTING into EXCECAOEMPREGADO
SET DEFINE OFF;
REM INSERTING into EXECUCAOATIVIDADEPERIODICA
SET DEFINE OFF;
REM INSERTING into EXECUCAOBATCH
SET DEFINE OFF;
REM INSERTING into EXECUCAODEMANDA
SET DEFINE OFF;
REM INSERTING into EXECUCAOMUDANCA
SET DEFINE OFF;
REM INSERTING into EXTERNALCONNECTION
SET DEFINE OFF;
REM INSERTING into FAIXAVALORESRECURSO
SET DEFINE OFF;
REM INSERTING into FASESERVICO
SET DEFINE OFF;
Insert into FASESERVICO (IDFASE,NOMEFASE,FASECAPTURA) values ('1','Captura','S');
Insert into FASESERVICO (IDFASE,NOMEFASE,FASECAPTURA) values ('2','Execução','N');
REM INSERTING into FATURA
SET DEFINE OFF;
REM INSERTING into FATURAAPURACAOANS
SET DEFINE OFF;
REM INSERTING into FATURAOS
SET DEFINE OFF;
REM INSERTING into FERIADO
SET DEFINE OFF;
REM INSERTING into FLUXO
SET DEFINE OFF;
REM INSERTING into FLUXOS
SET DEFINE OFF;
REM INSERTING into FLUXOSERVICO
SET DEFINE OFF;
REM INSERTING into FORMULA
SET DEFINE OFF;
Insert into FORMULA (IDFORMULA,IDENTIFICADOR,NOME,DATACRIACAO) values ('1','Calculo de ANS Padrão','Calculo de ANS Padrão',null);
Insert into FORMULA (IDFORMULA,IDENTIFICADOR,NOME,DATACRIACAO) values ('2','CalculoGLOSAOS','Calculo Glosa OS',null);
REM INSERTING into FORNECEDOR
SET DEFINE OFF;
Insert into FORNECEDOR (IDFORNECEDOR,RAZAOSOCIAL,NOMEFANTASIA,CNPJ,EMAIL,DELETED,TELEFONE,FAX,NOMECONTATO,INSCRICAOESTADUAL,INSCRICAOMUNICIPAL,IDENDERECO,TIPOPESSOA) values ('1','Fornecedor 1','Seu Fornecedor',null,' ',null,null,null,' ',' ',' ','1',' ');
REM INSERTING into FORNECEDORCOTACAO
SET DEFINE OFF;
REM INSERTING into FORNECEDORPRODUTO
SET DEFINE OFF;
REM INSERTING into GALERIAIMAGENS
SET DEFINE OFF;
REM INSERTING into GLOSAOS
SET DEFINE OFF;
REM INSERTING into GLOSASERVICOCONTRATO
SET DEFINE OFF;
REM INSERTING into GRUPO
SET DEFINE OFF;
Insert into GRUPO (IDGRUPO,IDEMPRESA,NOME,DATAINICIO,DATAFIM,SERVICEDESK,SIGLA,ABERTURA,ENCERRAMENTO,ANDAMENTO,COMITECONSULTIVOMUDANCA) values ('1','1','Desenvolvimento',to_date('01/01/12','DD/MM/RR'),null,'N','DES',null,null,null,' ');
Insert into GRUPO (IDGRUPO,IDEMPRESA,NOME,DATAINICIO,DATAFIM,SERVICEDESK,SIGLA,ABERTURA,ENCERRAMENTO,ANDAMENTO,COMITECONSULTIVOMUDANCA) values ('2','1','1º NÍVEL',to_date('01/01/12','DD/MM/RR'),null,'S','SDNIVEL1',null,null,null,' ');
Insert into GRUPO (IDGRUPO,IDEMPRESA,NOME,DATAINICIO,DATAFIM,SERVICEDESK,SIGLA,ABERTURA,ENCERRAMENTO,ANDAMENTO,COMITECONSULTIVOMUDANCA) values ('3','1','2º NÍVEL',to_date('01/01/12','DD/MM/RR'),null,'S','SDNIVEL2',null,null,null,' ');
Insert into GRUPO (IDGRUPO,IDEMPRESA,NOME,DATAINICIO,DATAFIM,SERVICEDESK,SIGLA,ABERTURA,ENCERRAMENTO,ANDAMENTO,COMITECONSULTIVOMUDANCA) values ('4','1','3º NÍVEL - Infraestrutura',to_date('01/01/12','DD/MM/RR'),null,'S','SDNIVEL3Infra',null,null,null,' ');
Insert into GRUPO (IDGRUPO,IDEMPRESA,NOME,DATAINICIO,DATAFIM,SERVICEDESK,SIGLA,ABERTURA,ENCERRAMENTO,ANDAMENTO,COMITECONSULTIVOMUDANCA) values ('5','1','Qualidade',to_date('01/01/12','DD/MM/RR'),null,'S','QUALIDADE',null,null,null,' ');
Insert into GRUPO (IDGRUPO,IDEMPRESA,NOME,DATAINICIO,DATAFIM,SERVICEDESK,SIGLA,ABERTURA,ENCERRAMENTO,ANDAMENTO,COMITECONSULTIVOMUDANCA) values ('6','1','Gestores Internos',to_date('01/01/12','DD/MM/RR'),null,'S','GESTORES',null,null,null,' ');
Insert into GRUPO (IDGRUPO,IDEMPRESA,NOME,DATAINICIO,DATAFIM,SERVICEDESK,SIGLA,ABERTURA,ENCERRAMENTO,ANDAMENTO,COMITECONSULTIVOMUDANCA) values ('7','1','Coordenadores Externos',to_date('01/01/12','DD/MM/RR'),null,'N','COORD_EXT',null,null,null,' ');
Insert into GRUPO (IDGRUPO,IDEMPRESA,NOME,DATAINICIO,DATAFIM,SERVICEDESK,SIGLA,ABERTURA,ENCERRAMENTO,ANDAMENTO,COMITECONSULTIVOMUDANCA) values ('16','1','3º NÍVEL - Aplicação',to_date('01/01/12','DD/MM/RR'),null,'S','SDNIVEL3Apli',null,null,null,' ');
Insert into GRUPO (IDGRUPO,IDEMPRESA,NOME,DATAINICIO,DATAFIM,SERVICEDESK,SIGLA,ABERTURA,ENCERRAMENTO,ANDAMENTO,COMITECONSULTIVOMUDANCA) values ('17','1','3º NÍVEL - Sistemas',to_date('01/01/12','DD/MM/RR'),null,'S','SDNIVEL3Sist',null,null,null,' ');
Insert into GRUPO (IDGRUPO,IDEMPRESA,NOME,DATAINICIO,DATAFIM,SERVICEDESK,SIGLA,ABERTURA,ENCERRAMENTO,ANDAMENTO,COMITECONSULTIVOMUDANCA) values ('18','1','Coordenador',to_date('01/01/12','DD/MM/RR'),null,'S','COORDENAÇÃO',null,null,null,' ');
Insert into GRUPO (IDGRUPO,IDEMPRESA,NOME,DATAINICIO,DATAFIM,SERVICEDESK,SIGLA,ABERTURA,ENCERRAMENTO,ANDAMENTO,COMITECONSULTIVOMUDANCA) values ('19','1','3º NÍVEL - Telefonia',to_date('01/01/12','DD/MM/RR'),null,'N','SDNIVEL3Telefonia',null,null,null,' ');
Insert into GRUPO (IDGRUPO,IDEMPRESA,NOME,DATAINICIO,DATAFIM,SERVICEDESK,SIGLA,ABERTURA,ENCERRAMENTO,ANDAMENTO,COMITECONSULTIVOMUDANCA) values ('20','1','Gerentes',to_date('01/01/12','DD/MM/RR'),null,'S','GER',null,null,null,' ');
REM INSERTING into GRUPOATVPERIODICA
SET DEFINE OFF;
REM INSERTING into GRUPOITEMCONFIGURACAO
SET DEFINE OFF;
REM INSERTING into GRUPOQUESTIONARIO
SET DEFINE OFF;
REM INSERTING into GRUPORECURSOS
SET DEFINE OFF;
REM INSERTING into GRUPOSEMAILS
SET DEFINE OFF;
REM INSERTING into GRUPOSEMPREGADOS
SET DEFINE OFF;
Insert into GRUPOSEMPREGADOS (IDGRUPO,IDEMPREGADO,ENVIAEMAIL) values ('2','1','N');
Insert into GRUPOSEMPREGADOS (IDGRUPO,IDEMPREGADO,ENVIAEMAIL) values ('2','2','N');
Insert into GRUPOSEMPREGADOS (IDGRUPO,IDEMPREGADO,ENVIAEMAIL) values ('2','3','N');
Insert into GRUPOSEMPREGADOS (IDGRUPO,IDEMPREGADO,ENVIAEMAIL) values ('3','1','N');
Insert into GRUPOSEMPREGADOS (IDGRUPO,IDEMPREGADO,ENVIAEMAIL) values ('3','3','N');
Insert into GRUPOSEMPREGADOS (IDGRUPO,IDEMPREGADO,ENVIAEMAIL) values ('4','1','N');
Insert into GRUPOSEMPREGADOS (IDGRUPO,IDEMPREGADO,ENVIAEMAIL) values ('4','3','N');
Insert into GRUPOSEMPREGADOS (IDGRUPO,IDEMPREGADO,ENVIAEMAIL) values ('16','3','N');
Insert into GRUPOSEMPREGADOS (IDGRUPO,IDEMPREGADO,ENVIAEMAIL) values ('17','1','N');
Insert into GRUPOSEMPREGADOS (IDGRUPO,IDEMPREGADO,ENVIAEMAIL) values ('17','3','N');
Insert into GRUPOSEMPREGADOS (IDGRUPO,IDEMPREGADO,ENVIAEMAIL) values ('18','1','N');
Insert into GRUPOSEMPREGADOS (IDGRUPO,IDEMPREGADO,ENVIAEMAIL) values ('19','1','N');
Insert into GRUPOSEMPREGADOS (IDGRUPO,IDEMPREGADO,ENVIAEMAIL) values ('19','3','N');
REM INSERTING into GRUPOVISAO
SET DEFINE OFF;
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('3','7','Visão de Empresa','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('7','8','Listagem de Empregados','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('8','9','Endereços','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('12','10','Grupos de Segurança do Empregado','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('15','5','Visão Empregados','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('19','13','Listagem de Fluxos','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('114','39','Pesquisa Causa de Incidentes','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('120','45','$grupo.recursos.lista','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('121','46','$nagios.conexao.listagem','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('122','47','$requisitosla.pesquisasla','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('123','48','$visao.listagemAcordoNivelServico','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('124','22','$visao.listagemClientes','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('125','49','$visao.listagemConexoesExternas','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('126','25','$visao.listagemContratos','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('127','50','$visao.listagemEmpregados','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('128','51','$visao.listagemFluxos','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('129','52','$visao.listagemFluxoTrabalho','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('130','24','$visao.listagemFornecedores','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('131','35','$visao.listagemLocalExecucaoServico','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('132','18','$visao.listagemServicosCriacao','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('133','31','$visao.listagemTipoEventoServico','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('134','53','$visao.pesquisaCategoriaSolucao','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('135','41','$visao.pesquisaCausaIncidentes','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('136','43','$visao.pesquisaGrupoAtividadePeriodica','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('137','37','$visao.pesquisaJustificativaSolicitacao','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('138','33','$visao.pesquisaTipoSolicitacaoServico','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('139','54','$contrato.historicoauditoria','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('140','55','$grupo.recursos','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('141','32','$menu.nome.tipoSolicitacaoServico','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('142','56','$nagios.conexao.titulo','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('143','57','$requisitosla.sla','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('144','58','$sla.historicoauditoria','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('145','59','$sla.listacontratosvinculadosano','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('146','60','$sla.listacontratosvinculadoscliente','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('147','61','$sla.listacontratosvinculadosterceiro','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('148','62','$slarequisitosla.titulo','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('149','63','$sla.revisar.revisar','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('150','28','$visao.acordoNivelServicoContrato','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('151','14','$visao.cadastroFluxos','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('152','64','$visao.complexidades','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('153','29','$visao.fluxoServico','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('154','65','$visao.historicoAuditoriaServico','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('155','66','$visao.vincularSlaServico','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('156','67','$visao.acordoGeral','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('157','26','$visao.acordoNivelServico','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('158','15','$visao.analiseIncidente','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('159','16','$visao.atendimento','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('160','27','$visao.atividadesServico','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('161','30','$visao.CadastroTipoEventoServico','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('162','40','$visao.categoriaSolucao','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('163','38','$visao.causaIncidentes','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('164','21','$visao.clientes','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('165','68','$visao.conexoesExternas','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('166','20','$visao.contratos','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('167','17','$visao.criacaoServicos','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('168','69','$visao.enderecos','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('169','23','$visao.fornecedores','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('170','42','$visao.grupoAtividadePeriodica','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('171','70','$visao.gruposSegurancaEmpregados','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('172','12','$visao.incidente','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('173','36','$visao.justificativaSolicitacao','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('174','34','$visao.localExecucaoServico','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('175','19','$visao.servicoContrato','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('176','44','$visao.servicoContratoMulti','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('177','71','$visao.visaoEmpregados','1','0','A');
Insert into GRUPOVISAO (IDGRUPOVISAO,IDVISAO,DESCRICAOGRUPOVISAO,FORMA,ORDEM,SITUACAO) values ('178','72','$visao.visaoEmpresa','1','0','A');
REM INSERTING into GRUPOVISAOCAMPOSNEGOCIO
SET DEFINE OFF;
REM INSERTING into GRUPOVISAOCAMPOSNEGOCIOINFOSQL
SET DEFINE OFF;
REM INSERTING into GRUPOVISAOCAMPOSNEGOCIOLIGACAO
SET DEFINE OFF;
REM INSERTING into HILOSEQUENCES
SET DEFINE OFF;
REM INSERTING into HISTORICOBASECONHECIMENTO
SET DEFINE OFF;
Insert into HISTORICOBASECONHECIMENTO (IDHISTORICOBASECONHECIMENTO,IDBASECONHECIMENTO,IDPASTA,DATAINICIO,DATAFIM,TITULO,STATUS,IDBASECONHECIMENTOPAI,DATAEXPIRACAO,VERSAO,IDUSUARIOAUTOR,IDUSUARIOAPROVADOR,FONTEREFERENCIA,IDNOTIFICACAO,DATAPUBLICACAO,JUSTIFICATIVAOBSERVACAO,FAQ,ORIGEM,ARQUIVADO,IDUSUARIOALTERACAO,DATAHORAALTERACAO) values ('1','1','1',to_date('08/04/13','DD/MM/RR'),null,'Conhecimento 1','S',null,to_date('31/12/14','DD/MM/RR'),'1.0','1','1','Conhecimento 1',null,to_date('08/04/13','DD/MM/RR'),'Justificativa Conhecimento 1',null,'1','N','1',to_date('08/04/13','DD/MM/RR'));
Insert into HISTORICOBASECONHECIMENTO (IDHISTORICOBASECONHECIMENTO,IDBASECONHECIMENTO,IDPASTA,DATAINICIO,DATAFIM,TITULO,STATUS,IDBASECONHECIMENTOPAI,DATAEXPIRACAO,VERSAO,IDUSUARIOAUTOR,IDUSUARIOAPROVADOR,FONTEREFERENCIA,IDNOTIFICACAO,DATAPUBLICACAO,JUSTIFICATIVAOBSERVACAO,FAQ,ORIGEM,ARQUIVADO,IDUSUARIOALTERACAO,DATAHORAALTERACAO) values ('2','2','2',to_date('08/04/13','DD/MM/RR'),null,'Conhecimento 2','S',null,to_date('31/12/14','DD/MM/RR'),'1.0','1','1',' ',null,to_date('08/04/13','DD/MM/RR'),'Justificativa Conhecimento 2',null,'1','N','1',to_date('08/04/13','DD/MM/RR'));
Insert into HISTORICOBASECONHECIMENTO (IDHISTORICOBASECONHECIMENTO,IDBASECONHECIMENTO,IDPASTA,DATAINICIO,DATAFIM,TITULO,STATUS,IDBASECONHECIMENTOPAI,DATAEXPIRACAO,VERSAO,IDUSUARIOAUTOR,IDUSUARIOAPROVADOR,FONTEREFERENCIA,IDNOTIFICACAO,DATAPUBLICACAO,JUSTIFICATIVAOBSERVACAO,FAQ,ORIGEM,ARQUIVADO,IDUSUARIOALTERACAO,DATAHORAALTERACAO) values ('3','3','1',to_date('08/04/13','DD/MM/RR'),null,'FAQ 1','S',null,to_date('31/12/14','DD/MM/RR'),'1.0','1','1','FAQ 1',null,to_date('08/04/13','DD/MM/RR'),'Justificativa FAQ 1','S','1','N','1',to_date('08/04/13','DD/MM/RR'));
Insert into HISTORICOBASECONHECIMENTO (IDHISTORICOBASECONHECIMENTO,IDBASECONHECIMENTO,IDPASTA,DATAINICIO,DATAFIM,TITULO,STATUS,IDBASECONHECIMENTOPAI,DATAEXPIRACAO,VERSAO,IDUSUARIOAUTOR,IDUSUARIOAPROVADOR,FONTEREFERENCIA,IDNOTIFICACAO,DATAPUBLICACAO,JUSTIFICATIVAOBSERVACAO,FAQ,ORIGEM,ARQUIVADO,IDUSUARIOALTERACAO,DATAHORAALTERACAO) values ('4','4','2',to_date('08/04/13','DD/MM/RR'),null,'FAQ 2','S',null,to_date('31/12/14','DD/MM/RR'),'1.0','1','1','FAQ 2',null,to_date('08/04/13','DD/MM/RR'),'Justificativa FAQ 2','S','1','N','1',to_date('08/04/13','DD/MM/RR'));
REM INSERTING into HISTORICOEXECUCAO
SET DEFINE OFF;
REM INSERTING into HISTORICOIC
SET DEFINE OFF;
REM INSERTING into HISTORICOSITUACAOCOTACAO
SET DEFINE OFF;
REM INSERTING into HISTORICOTENTATIVA
SET DEFINE OFF;
REM INSERTING into HISTORICOVALOR
SET DEFINE OFF;
REM INSERTING into HTMLCODEVISAO
SET DEFINE OFF;
REM INSERTING into IMAGEMHISTORICO
SET DEFINE OFF;
REM INSERTING into IMAGEMITEMCONFIGURACAO
SET DEFINE OFF;
REM INSERTING into IMAGEMSERVICORELACIONADO
SET DEFINE OFF;
REM INSERTING into IMPACTO
SET DEFINE OFF;
Insert into IMPACTO (IDIMPACTO,NIVELIMPACTO,SIGLAIMPACTO) values ('1','Altíssimo','AL');
Insert into IMPACTO (IDIMPACTO,NIVELIMPACTO,SIGLAIMPACTO) values ('2','Alto','A ');
Insert into IMPACTO (IDIMPACTO,NIVELIMPACTO,SIGLAIMPACTO) values ('3','Elevado','E ');
Insert into IMPACTO (IDIMPACTO,NIVELIMPACTO,SIGLAIMPACTO) values ('4','Médio','M ');
Insert into IMPACTO (IDIMPACTO,NIVELIMPACTO,SIGLAIMPACTO) values ('5','Baixo','B ');
REM INSERTING into IMPORTANCIACONHECIMENTOGRUPO
SET DEFINE OFF;
REM INSERTING into IMPORTANCIACONHECIMENTOUSUARIO
SET DEFINE OFF;
REM INSERTING into IMPORTANCIANEGOCIO
SET DEFINE OFF;
Insert into IMPORTANCIANEGOCIO (IDIMPORTANCIANEGOCIO,IDEMPRESA,NOMEIMPORTANCIANEGOCIO,SITUACAO) values ('1','1','Baixa','A');
Insert into IMPORTANCIANEGOCIO (IDIMPORTANCIANEGOCIO,IDEMPRESA,NOMEIMPORTANCIANEGOCIO,SITUACAO) values ('3','1','Média','A');
Insert into IMPORTANCIANEGOCIO (IDIMPORTANCIANEGOCIO,IDEMPRESA,NOMEIMPORTANCIANEGOCIO,SITUACAO) values ('4','1','Alta','A');
Insert into IMPORTANCIANEGOCIO (IDIMPORTANCIANEGOCIO,IDEMPRESA,NOMEIMPORTANCIANEGOCIO,SITUACAO) values ('10','1','A combinar','A');
Insert into IMPORTANCIANEGOCIO (IDIMPORTANCIANEGOCIO,IDEMPRESA,NOMEIMPORTANCIANEGOCIO,SITUACAO) values ('11','1','Normal','A');
REM INSERTING into IMPORTCONFIG
SET DEFINE OFF;
REM INSERTING into IMPORTCONFIGCAMPOS
SET DEFINE OFF;
REM INSERTING into INFOCATALOGOSERVICO
SET DEFINE OFF;
REM INSERTING into INFORMACAOSERVICO
SET DEFINE OFF;
REM INSERTING into INFORMACOESCONTRATOCONFIG
SET DEFINE OFF;
REM INSERTING into INFORMACOESCONTRATOPERFSEG
SET DEFINE OFF;
REM INSERTING into INSPECAOENTREGAITEM
SET DEFINE OFF;
REM INSERTING into INSPECAOPEDIDOCOMPRA
SET DEFINE OFF;
REM INSERTING into INVENTARIOXML
SET DEFINE OFF;
REM INSERTING into ITEMCFGSOLICITACAOSERV
SET DEFINE OFF;
REM INSERTING into ITEMCONFIGURACAO
SET DEFINE OFF;
REM INSERTING into ITEMCONFIGURACAOEVENTO
SET DEFINE OFF;
REM INSERTING into ITEMCOTACAO
SET DEFINE OFF;
REM INSERTING into ITEMPEDIDOCOMPRA
SET DEFINE OFF;
REM INSERTING into ITEMREQUISICAOPRODUTO
SET DEFINE OFF;
REM INSERTING into JORNADATRABALHO
SET DEFINE OFF;
Insert into JORNADATRABALHO (IDJORNADA,DESCRICAO,INICIO1,TERMINO1,INICIO2,TERMINO2,INICIO3,TERMINO3,INICIO4,TERMINO4,INICIO5,TERMINO5,CARGAHORARIA,DATAINICIO,DATAFIM) values ('1','Service Desk (Semana)','08:00','20:00','     ','     ','     ','     ','     ','     ','     ','     ','12:00',null,null);
Insert into JORNADATRABALHO (IDJORNADA,DESCRICAO,INICIO1,TERMINO1,INICIO2,TERMINO2,INICIO3,TERMINO3,INICIO4,TERMINO4,INICIO5,TERMINO5,CARGAHORARIA,DATAINICIO,DATAFIM) values ('2','Service Desk (Fim de semana)','08:00','15:00','     ','     ','     ','     ','     ','     ','     ','     ','07:00',null,null);
REM INSERTING into JUSTIFICACAOFALHA
SET DEFINE OFF;
REM INSERTING into JUSTIFICATIVAMUDANCA
SET DEFINE OFF;
REM INSERTING into JUSTIFICATIVAPARECER
SET DEFINE OFF;
REM INSERTING into JUSTIFICATIVASOLICITACAO
SET DEFINE OFF;
REM INSERTING into LIBERACAO
SET DEFINE OFF;
REM INSERTING into LIBERACAOMUDANCA
SET DEFINE OFF;
REM INSERTING into LIMITEALCADA
SET DEFINE OFF;
REM INSERTING into LINGUA
SET DEFINE OFF;
Insert into LINGUA (IDLINGUA,NOME,SIGLA,DATAINICIO,DATAFIM) values ('1','Português','PT',to_date('30/01/13','DD/MM/RR'),null);
Insert into LINGUA (IDLINGUA,NOME,SIGLA,DATAINICIO,DATAFIM) values ('2','Inglês','EN',to_date('30/01/13','DD/MM/RR'),null);
Insert into LINGUA (IDLINGUA,NOME,SIGLA,DATAINICIO,DATAFIM) values ('3','Espanol','ES',to_date('30/01/13','DD/MM/RR'),null);
REM INSERTING into LOCALEXECUCAOSERVICO
SET DEFINE OFF;
Insert into LOCALEXECUCAOSERVICO (IDLOCALEXECUCAOSERVICO,NOMELOCALEXECUCAOSERVICO,DELETED) values ('1','Interno','N');
Insert into LOCALEXECUCAOSERVICO (IDLOCALEXECUCAOSERVICO,NOMELOCALEXECUCAOSERVICO,DELETED) values ('2','Externo','N');
Insert into LOCALEXECUCAOSERVICO (IDLOCALEXECUCAOSERVICO,NOMELOCALEXECUCAOSERVICO,DELETED) values ('4','Interno/Externo',null);
REM INSERTING into LOCALIDADE
SET DEFINE OFF;
REM INSERTING into LOCALIDADEUNIDADE
SET DEFINE OFF;
REM INSERTING into LOGDADOS
SET DEFINE OFF;
REM INSERTING into MARCA
SET DEFINE OFF;
REM INSERTING into MATRIZPRIORIDADE
SET DEFINE OFF;
Insert into MATRIZPRIORIDADE (IDMATRIZPRIORIDADE,SIGLAIMPACTO,SIGLAURGENCIA,VALORPRIORIDADE,IDCONTRATO,DELETED) values ('1','AL','B ','2',null,' ');
Insert into MATRIZPRIORIDADE (IDMATRIZPRIORIDADE,SIGLAIMPACTO,SIGLAURGENCIA,VALORPRIORIDADE,IDCONTRATO,DELETED) values ('2','AL','M ','2',null,' ');
Insert into MATRIZPRIORIDADE (IDMATRIZPRIORIDADE,SIGLAIMPACTO,SIGLAURGENCIA,VALORPRIORIDADE,IDCONTRATO,DELETED) values ('3','AL','A ','1',null,' ');
Insert into MATRIZPRIORIDADE (IDMATRIZPRIORIDADE,SIGLAIMPACTO,SIGLAURGENCIA,VALORPRIORIDADE,IDCONTRATO,DELETED) values ('4','AL','C ','1',null,' ');
Insert into MATRIZPRIORIDADE (IDMATRIZPRIORIDADE,SIGLAIMPACTO,SIGLAURGENCIA,VALORPRIORIDADE,IDCONTRATO,DELETED) values ('5','A ','B ','3',null,' ');
Insert into MATRIZPRIORIDADE (IDMATRIZPRIORIDADE,SIGLAIMPACTO,SIGLAURGENCIA,VALORPRIORIDADE,IDCONTRATO,DELETED) values ('6','A ','M ','2',null,' ');
Insert into MATRIZPRIORIDADE (IDMATRIZPRIORIDADE,SIGLAIMPACTO,SIGLAURGENCIA,VALORPRIORIDADE,IDCONTRATO,DELETED) values ('7','A ','A ','2',null,' ');
Insert into MATRIZPRIORIDADE (IDMATRIZPRIORIDADE,SIGLAIMPACTO,SIGLAURGENCIA,VALORPRIORIDADE,IDCONTRATO,DELETED) values ('8','A ','C ','1',null,' ');
Insert into MATRIZPRIORIDADE (IDMATRIZPRIORIDADE,SIGLAIMPACTO,SIGLAURGENCIA,VALORPRIORIDADE,IDCONTRATO,DELETED) values ('9','E ','B ','3',null,' ');
Insert into MATRIZPRIORIDADE (IDMATRIZPRIORIDADE,SIGLAIMPACTO,SIGLAURGENCIA,VALORPRIORIDADE,IDCONTRATO,DELETED) values ('10','E ','M ','3',null,' ');
Insert into MATRIZPRIORIDADE (IDMATRIZPRIORIDADE,SIGLAIMPACTO,SIGLAURGENCIA,VALORPRIORIDADE,IDCONTRATO,DELETED) values ('11','E ','A ','2',null,' ');
Insert into MATRIZPRIORIDADE (IDMATRIZPRIORIDADE,SIGLAIMPACTO,SIGLAURGENCIA,VALORPRIORIDADE,IDCONTRATO,DELETED) values ('12','E ','C ','2',null,' ');
Insert into MATRIZPRIORIDADE (IDMATRIZPRIORIDADE,SIGLAIMPACTO,SIGLAURGENCIA,VALORPRIORIDADE,IDCONTRATO,DELETED) values ('13','M ','B ','4',null,' ');
Insert into MATRIZPRIORIDADE (IDMATRIZPRIORIDADE,SIGLAIMPACTO,SIGLAURGENCIA,VALORPRIORIDADE,IDCONTRATO,DELETED) values ('14','M ','M ','3',null,' ');
Insert into MATRIZPRIORIDADE (IDMATRIZPRIORIDADE,SIGLAIMPACTO,SIGLAURGENCIA,VALORPRIORIDADE,IDCONTRATO,DELETED) values ('15','M ','A ','3',null,' ');
Insert into MATRIZPRIORIDADE (IDMATRIZPRIORIDADE,SIGLAIMPACTO,SIGLAURGENCIA,VALORPRIORIDADE,IDCONTRATO,DELETED) values ('16','M ','C ','2',null,' ');
Insert into MATRIZPRIORIDADE (IDMATRIZPRIORIDADE,SIGLAIMPACTO,SIGLAURGENCIA,VALORPRIORIDADE,IDCONTRATO,DELETED) values ('17','B ','B ','5',null,' ');
Insert into MATRIZPRIORIDADE (IDMATRIZPRIORIDADE,SIGLAIMPACTO,SIGLAURGENCIA,VALORPRIORIDADE,IDCONTRATO,DELETED) values ('18','B ','M ','4',null,' ');
Insert into MATRIZPRIORIDADE (IDMATRIZPRIORIDADE,SIGLAIMPACTO,SIGLAURGENCIA,VALORPRIORIDADE,IDCONTRATO,DELETED) values ('19','B ','A ','3',null,' ');
Insert into MATRIZPRIORIDADE (IDMATRIZPRIORIDADE,SIGLAIMPACTO,SIGLAURGENCIA,VALORPRIORIDADE,IDCONTRATO,DELETED) values ('20','B ','C ','3',null,' ');
REM INSERTING into MATRIZVISAO
SET DEFINE OFF;
REM INSERTING into MENU
SET DEFINE OFF;
REM INSERTING into MEUCATALOGO
SET DEFINE OFF;
REM INSERTING into MIDIA
SET DEFINE OFF;
Insert into MIDIA (IDMIDIA, NOME) values ('1', 'Blu-ray');
Insert into MIDIA (IDMIDIA, NOME) values ('2', 'Cartão de Memória');
Insert into MIDIA (IDMIDIA, NOME) values ('3', 'CD');
Insert into MIDIA (IDMIDIA, NOME) values ('4', 'Disquete');
Insert into MIDIA (IDMIDIA, NOME) values ('5', 'DVD');
Insert into MIDIA (IDMIDIA, NOME) values ('6', 'Fita Magnética');
Insert into MIDIA (IDMIDIA, NOME) values ('7', 'HD');
Insert into MIDIA (IDMIDIA, NOME) values ('8', 'Pen drive');
Insert into MIDIA (IDMIDIA, NOME) values ('9', 'Outros');
REM INSERTING into MIDIASOFTWARE
SET DEFINE OFF;
REM INSERTING into MODELOSEMAILS
SET DEFINE OFF;
Insert into MODELOSEMAILS (IDMODELOEMAIL,TITULO,SITUACAO,IDENTIFICADOR) values ('1','Solicitação registrada -  ${IDSOLICITACAOSERVICO}','A',null);
Insert into MODELOSEMAILS (IDMODELOEMAIL,TITULO,SITUACAO,IDENTIFICADOR) values ('2','Solicitação atendida - ${IDSOLICITACAOSERVICO}','A',null);
Insert into MODELOSEMAILS (IDMODELOEMAIL,TITULO,SITUACAO,IDENTIFICADOR) values ('3','Solicitação em atendimento - ${IDSOLICITACAOSERVICO}','A',null);
Insert into MODELOSEMAILS (IDMODELOEMAIL,TITULO,SITUACAO,IDENTIFICADOR) values ('6','Validade do Item configuração - ${IDENTIFICACAO}','A',' ');
Insert into MODELOSEMAILS (IDMODELOEMAIL,TITULO,SITUACAO,IDENTIFICADOR) values ('7','Validade do documento - ${TITULO}','A','bc');
Insert into MODELOSEMAILS (IDMODELOEMAIL,TITULO,SITUACAO,IDENTIFICADOR) values ('8','Criação da Pasta - ${NOME}','A','cp');
Insert into MODELOSEMAILS (IDMODELOEMAIL,TITULO,SITUACAO,IDENTIFICADOR) values ('9','Alteração da Pasta - ${NOME}','A','ap');
Insert into MODELOSEMAILS (IDMODELOEMAIL,TITULO,SITUACAO,IDENTIFICADOR) values ('10','Exclusão da pasta - ${NOME}','A','ep');
Insert into MODELOSEMAILS (IDMODELOEMAIL,TITULO,SITUACAO,IDENTIFICADOR) values ('11','Criação do documento - ${TITULO}','A','cc');
Insert into MODELOSEMAILS (IDMODELOEMAIL,TITULO,SITUACAO,IDENTIFICADOR) values ('12','Alteração do documento - ${TITULO}','A','ac');
Insert into MODELOSEMAILS (IDMODELOEMAIL,TITULO,SITUACAO,IDENTIFICADOR) values ('13','Exclusão do documento - ${TITULO}','A','ec');
Insert into MODELOSEMAILS (IDMODELOEMAIL,TITULO,SITUACAO,IDENTIFICADOR) values ('14','Alteração do Item configuração - ${IDENTIFICACAO}','A','alteracaoIC');
Insert into MODELOSEMAILS (IDMODELOEMAIL,TITULO,SITUACAO,IDENTIFICADOR) values ('15','Alteração do Item configuração para Grupo- ${IDENTIFICACAO}','A','alteracaoICGrupo');
Insert into MODELOSEMAILS (IDMODELOEMAIL,TITULO,SITUACAO,IDENTIFICADOR) values ('16','Criação do Item configuração - ${IDENTIFICACAO}','A','CriacaoIC');
Insert into MODELOSEMAILS (IDMODELOEMAIL,TITULO,SITUACAO,IDENTIFICADOR) values ('17','Alteração Serviço - ${NOMESERVICO}','A','alteracaoServico');
REM INSERTING into MOEDAS
SET DEFINE OFF;
Insert into MOEDAS (IDMOEDA,NOMEMOEDA) values ('1','Real');
Insert into MOEDAS (IDMOEDA,NOMEMOEDA) values ('2','UST');
REM INSERTING into MOTIVOSUSPENSAOATIVID
SET DEFINE OFF;
REM INSERTING into NAGIOSCONEXAO
SET DEFINE OFF;
REM INSERTING into NETMAP
SET DEFINE OFF;
REM INSERTING into NOTIFICACAO
SET DEFINE OFF;
REM INSERTING into NOTIFICACAOGRUPO
SET DEFINE OFF;
REM INSERTING into NOTIFICACAOSERVICO
SET DEFINE OFF;
REM INSERTING into NOTIFICACAOUSUARIO
SET DEFINE OFF;
REM INSERTING into OBJETIVOMONITORAMENTO
SET DEFINE OFF;
REM INSERTING into OBJETIVOPLANOMELHORIA
SET DEFINE OFF;
REM INSERTING into OBJETONEGOCIO
SET DEFINE OFF;
REM INSERTING into OCORRENCIAMUDANCA
SET DEFINE OFF;
REM INSERTING into OCORRENCIAS
SET DEFINE OFF;
REM INSERTING into OCORRENCIASOLICITACAO
SET DEFINE OFF;
Insert into OCORRENCIASOLICITACAO (IDOCORRENCIA,IDJUSTIFICATIVA,IDSOLICITACAOSERVICO,IDITEMTRABALHO,DATAREGISTRO,HORAREGISTRO,REGISTRADOPOR,DESCRICAO,DATAINICIO,DATAFIM,CATEGORIA,ORIGEM,TEMPOGASTO,IDCATEGORIAOCORRENCIA,IDORIGEMOCORRENCIA) values ('1',null,'1',null,to_date('05/04/13','DD/MM/RR'),'09:40','Consultor','Registro da Solicitação',to_date('05/04/13','DD/MM/RR'),to_date('05/04/13','DD/MM/RR'),'Criacao','O','0',null,null);
Insert into OCORRENCIASOLICITACAO (IDOCORRENCIA,IDJUSTIFICATIVA,IDSOLICITACAOSERVICO,IDITEMTRABALHO,DATAREGISTRO,HORAREGISTRO,REGISTRADOPOR,DESCRICAO,DATAINICIO,DATAFIM,CATEGORIA,ORIGEM,TEMPOGASTO,IDCATEGORIAOCORRENCIA,IDORIGEMOCORRENCIA) values ('2',null,'1',null,to_date('05/04/13','DD/MM/RR'),'09:40','Automático','Inicio do SLA',to_date('05/04/13','DD/MM/RR'),to_date('05/04/13','DD/MM/RR'),'InicioSLA','O','0',null,null);
Insert into OCORRENCIASOLICITACAO (IDOCORRENCIA,IDJUSTIFICATIVA,IDSOLICITACAOSERVICO,IDITEMTRABALHO,DATAREGISTRO,HORAREGISTRO,REGISTRADOPOR,DESCRICAO,DATAINICIO,DATAFIM,CATEGORIA,ORIGEM,TEMPOGASTO,IDCATEGORIAOCORRENCIA,IDORIGEMOCORRENCIA) values ('3',null,'2',null,to_date('05/04/13','DD/MM/RR'),'09:43','Consultor','Registro da Solicitação',to_date('05/04/13','DD/MM/RR'),to_date('05/04/13','DD/MM/RR'),'Criacao','O','0',null,null);
Insert into OCORRENCIASOLICITACAO (IDOCORRENCIA,IDJUSTIFICATIVA,IDSOLICITACAOSERVICO,IDITEMTRABALHO,DATAREGISTRO,HORAREGISTRO,REGISTRADOPOR,DESCRICAO,DATAINICIO,DATAFIM,CATEGORIA,ORIGEM,TEMPOGASTO,IDCATEGORIAOCORRENCIA,IDORIGEMOCORRENCIA) values ('4',null,'2',null,to_date('05/04/13','DD/MM/RR'),'09:43','Automático','Inicio do SLA',to_date('05/04/13','DD/MM/RR'),to_date('05/04/13','DD/MM/RR'),'InicioSLA','O','0',null,null);
Insert into OCORRENCIASOLICITACAO (IDOCORRENCIA,IDJUSTIFICATIVA,IDSOLICITACAOSERVICO,IDITEMTRABALHO,DATAREGISTRO,HORAREGISTRO,REGISTRADOPOR,DESCRICAO,DATAINICIO,DATAFIM,CATEGORIA,ORIGEM,TEMPOGASTO,IDCATEGORIAOCORRENCIA,IDORIGEMOCORRENCIA) values ('5',null,'3',null,to_date('05/04/13','DD/MM/RR'),'09:46','Default','Registro da Solicitação',to_date('05/04/13','DD/MM/RR'),to_date('05/04/13','DD/MM/RR'),'Criacao','O','0',null,null);
Insert into OCORRENCIASOLICITACAO (IDOCORRENCIA,IDJUSTIFICATIVA,IDSOLICITACAOSERVICO,IDITEMTRABALHO,DATAREGISTRO,HORAREGISTRO,REGISTRADOPOR,DESCRICAO,DATAINICIO,DATAFIM,CATEGORIA,ORIGEM,TEMPOGASTO,IDCATEGORIAOCORRENCIA,IDORIGEMOCORRENCIA) values ('6',null,'3',null,to_date('05/04/13','DD/MM/RR'),'09:46','Automático','Encerramento da Solicitação',to_date('05/04/13','DD/MM/RR'),to_date('05/04/13','DD/MM/RR'),'Encerramento','O','0',null,null);
Insert into OCORRENCIASOLICITACAO (IDOCORRENCIA,IDJUSTIFICATIVA,IDSOLICITACAOSERVICO,IDITEMTRABALHO,DATAREGISTRO,HORAREGISTRO,REGISTRADOPOR,DESCRICAO,DATAINICIO,DATAFIM,CATEGORIA,ORIGEM,TEMPOGASTO,IDCATEGORIAOCORRENCIA,IDORIGEMOCORRENCIA) values ('7',null,'3',null,to_date('05/04/13','DD/MM/RR'),'09:46','Automático','Inicio do SLA',to_date('05/04/13','DD/MM/RR'),to_date('05/04/13','DD/MM/RR'),'InicioSLA','O','0',null,null);
Insert into OCORRENCIASOLICITACAO (IDOCORRENCIA,IDJUSTIFICATIVA,IDSOLICITACAOSERVICO,IDITEMTRABALHO,DATAREGISTRO,HORAREGISTRO,REGISTRADOPOR,DESCRICAO,DATAINICIO,DATAFIM,CATEGORIA,ORIGEM,TEMPOGASTO,IDCATEGORIAOCORRENCIA,IDORIGEMOCORRENCIA) values ('8',null,'3',null,to_date('05/04/13','DD/MM/RR'),'09:46','Automático','Encerramento da Solicitação',to_date('05/04/13','DD/MM/RR'),to_date('05/04/13','DD/MM/RR'),'Encerramento','O','0',null,null);
Insert into OCORRENCIASOLICITACAO (IDOCORRENCIA,IDJUSTIFICATIVA,IDSOLICITACAOSERVICO,IDITEMTRABALHO,DATAREGISTRO,HORAREGISTRO,REGISTRADOPOR,DESCRICAO,DATAINICIO,DATAFIM,CATEGORIA,ORIGEM,TEMPOGASTO,IDCATEGORIAOCORRENCIA,IDORIGEMOCORRENCIA) values ('9',null,'4',null,to_date('05/04/13','DD/MM/RR'),'10:13','Default','Registro da Solicitação',to_date('05/04/13','DD/MM/RR'),to_date('05/04/13','DD/MM/RR'),'Criacao','O','0',null,null);
Insert into OCORRENCIASOLICITACAO (IDOCORRENCIA,IDJUSTIFICATIVA,IDSOLICITACAOSERVICO,IDITEMTRABALHO,DATAREGISTRO,HORAREGISTRO,REGISTRADOPOR,DESCRICAO,DATAINICIO,DATAFIM,CATEGORIA,ORIGEM,TEMPOGASTO,IDCATEGORIAOCORRENCIA,IDORIGEMOCORRENCIA) values ('10',null,'4',null,to_date('05/04/13','DD/MM/RR'),'10:13','Automático','Inicio do SLA',to_date('05/04/13','DD/MM/RR'),to_date('05/04/13','DD/MM/RR'),'InicioSLA','O','0',null,null);
REM INSERTING into OPCAORESPOSTAQUESTIONARIO
SET DEFINE OFF;
REM INSERTING into OPINIAO
SET DEFINE OFF;
REM INSERTING into ORIGEMATENDIMENTO
SET DEFINE OFF;
Insert into ORIGEMATENDIMENTO (IDORIGEM,DESCRICAO) values ('1','Service Desk');
Insert into ORIGEMATENDIMENTO (IDORIGEM,DESCRICAO) values ('2','Internet');
Insert into ORIGEMATENDIMENTO (IDORIGEM,DESCRICAO) values ('3','E-mail');
Insert into ORIGEMATENDIMENTO (IDORIGEM,DESCRICAO) values ('4','Operador');
Insert into ORIGEMATENDIMENTO (IDORIGEM,DESCRICAO) values ('5','3º Nivel');
REM INSERTING into ORIGEMOCORRENCIA
SET DEFINE OFF;
REM INSERTING into OS
SET DEFINE OFF;
REM INSERTING into OSATIVIDADEPERIODICA
SET DEFINE OFF;
REM INSERTING into PAIS
SET DEFINE OFF;
Insert into PAIS (IDPAIS,NOMEPAIS) values ('1','Brasil');
REM INSERTING into PALAVRAGEMEA
SET DEFINE OFF;
REM INSERTING into PARAMETROCORPORE
SET DEFINE OFF;
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('0','ORIGEM - Configuração de Origem de Informações (para federação de dados)',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('1','Diretorio Arquivo NetMap',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('2','Faixa de Ip',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('3','No Pesquisa',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('4','Atributo Pesquisa',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('5','CAMINHO_INSTALADORES',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('6','Diretorio XML Agente',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('7','Periodo para fazer inventario dias',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('8','Caminho Nmap',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('9','ID Grupo Nível 1',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('10','Email origem das notificações de solicitações de serviço',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('11','Exige autenticação para envio de email',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('12','Usuário para autenticação de email',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('13','Senha para autenticação de email',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('14','SMTP para envio de email',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('15','GED Interno (S/N)',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('16','GED Interno em Banco de Dados (S/N)',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('17','GED Externo - Classe de tratamento',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('18','GED Diretorio',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('19','Nome da Empresa',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('20','BASE CONHECIMENTO - Pasta de armazenamento',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('21','BASECONHECIMENTO - Pasta de armazenamento arquivos LUCENE',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('22','MÉTODO DE AUTENTICAÇÃO (1 - Próprio, 2 - LDAP)',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('23','SMTP LEITURA - Servidor de entrada de emails do Service Desk',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('24','SMTP LEITURA - Caixa de entrada de emails do Service Desk',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('25','SMTP LEITURA - Senha da Caixa de entrada de emails do Service Desk',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('26','SMTP LEITURA - Provider do servidor de emails do Service Desk (imaps, pops, imap, pop, etc)',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('27','SMTP LEITURA - Porta do servidor de emails do Service Desk',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('28','SMTP LEITURA - Pasta da caixa de entrada de emails do Service Desk',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('29','Nome do fluxo padrão para serviços',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('30','ID da fase padrão para execução de serviços',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('31','Envia email na execução dos fluxos de solicitações/incidentes',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('32','DB - nome do SCHEMA do Banco de dados',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('33','URL de acesso ao sistema',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('34','LDAP - URL de acesso ao ActiveDirectory. Exemplo: ldap://10.2.1.2:389',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('35','LDAP - String com dominio do AD. Exemplo: dc=empresa,dc=com,dc=br',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('36','Domínio de e-mail. (@empresa.com.br)',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('37','LDAP - Login para consultar informações de usuários do LDAP(deve-se cadastrar também a senha).',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('38','LDAP - Senha para consultar informações de usuários do LDAP(deve-se cadastrar também o login).',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('39','LDAP - Id do perfil de acesso que será setado automaticamente caso o usuário não possua nenhum.',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('40','Faz o controle de acessos do catalogo de serviço por unidade (S/N) ?',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('41','Faz o controle de vinculo de colaboradores aos contratos (S/N) ?',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('42','Pagina para cadastro de solicitações de serviço (será usado o padrão caso não seja informado)',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('43','LDAP - Sufixo dominio',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('44','Diretório Upload repositório path',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('45','LDAP - ID Grupo Padrão.',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('46','Página de Login usando o Portal',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('47','Nome do fluxo padrão para mudanças',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('48','Validar permissões de botões (gravar, excluir e pesquisar) (S/N).',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('49','Gravar nome Usuário e Nome Empregado a partir do Last Name? (S/N).',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('50','Aceitar Valor 0 (Zero) para quantidade e custo da atividade?',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('51','FORMULA GLOSA OS - Código Padrão',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('52','Ativar log no sistema (''true'' ou ''false'')',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('53','Tipos: ''CIT_LOG'' (arquivo de log), ''DB_LOG'' (grava no banco)',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('54','Caminho da pasta que ficará o arquivo de LOG',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('55','Nome do arquivo de log',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('56','Extensão do arquivo de log',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('57','ID do modelo de e-mail que será enviado para o grupo de destino ao escalar uma solicitação.',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('58','Notificar o grupo ao receber uma escalação de solicitação de serviço (S e N).',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('59','PATRIMÔNIOP - ID Tipo Item Configuração.',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('60','Grupo de novos itens de configuração.',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('61','Vincula contratos a unidade',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('62','Identifica o id do serviço para solicitações de serviços e incidentes (Ex: A Ser Classificado )',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('63','[Parametro Depreciado] Pagina para cadastro de solicitações de serviço pelo Portal (Default: ''/pages/solicitacaoServicoPortal/solicitacaoServicoPortal.load'')',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('64','LDAP - Atributo LDAP para obter NOME DO COLABORADOR? (DisplayName, CN, SN ...).',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('65','Identifica o id de origem do chamado padrão da solicitação de serviço ',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('66','Idioma padrão do sistema(Ex: EN=Inglês)?',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('67','LDAP - Filtro LDAP na busca? (Default: (&(objectCategory=person)(objectClass=user))).',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('68','LDAP - Mostrar botão de buscar no AD na tela de incidentes.(Default: ''N'')',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('69','Validar campos Causa e Categoria da Solução da página solicitação serviço obrigatorios(Default: N)',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('70','Mostrar botões de importação e exportação do xml no cadastro de menus. (Default: S)',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('71','Parâmetro para ler o arquivo XML padrão de menus. (Default: N)',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('72','SMTP LEITURA - Limite de emails carregados em Solicitação Serviço',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('73','Avisar, com antecedência, a quantidade de dias que restam para a expiração da licença. (Default: 90 dias)',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('74','Enviar e-mail para grupo ou proprietário do item configuração. (1: Grupo 2: proprietário).',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('75','ID do modelo de e-mail para envio de notificação de licença próximo da expiração',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('76','Nome do Domínio da Rede (exemplo: EMPRESA, CORPORACAO)',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('78','Avisar, com antecedência, a quantidade de dias que restam para a expiração do conhecimento.  (Default: 90 dias)',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('79','ID do modelo de e-mail para envio de notificação de criação de pasta',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('80','ID do modelo de e-mail para envio de notificação de atualização de pasta',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('81','ID do modelo de e-mail para envio de notificação de exclusão de pasta',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('82','ID do modelo de e-mail para envio de notificação de criação de conhecimento',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('83','ID do modelo de e-mail para envio de notificação de atualização de conhecimento',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('84','ID do modelo de e-mail para envio de notificação de exclusão de conhecimento',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('85','Verificação de vinculo de mudança relacionada ao Item de configuração (Default: S)',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('86','Mostrar Categoria de serviço em Incidente default(S)',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('87','Modelo de criação de IC',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('88','Modelo de alteração de IC)',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('89','Modelo de alteração de IC de grupo',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('90','Envio de e-mails de Notificação de ICs (1-Grupo, 2-Proprietario, 3-Todos) (Default: 1)',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('91','SMTP GMAIL - Envio e recebimento de e-mails utilizando GMAIL? (S e N)',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('92','Nome fase ciclo de vida desenvolvimento Item Configuração (Default: ICs em Desenvolvimento)',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('93','Nome fase ciclo de vida produção Item Configuração (Default: ICs em Produção',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('94','Nome fase ciclo de vida homologação Item Configuração (Default: ICs em Homologação)',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('95','Nome Inventário (Default: Inventário)',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('96','ID do grupo de desenvolvimento Item Configuração (Ex: 1)',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('97','ID do grupo de produção Item Configuração (Ex: 2)',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('98','ID do grupo de homologação Item Configuração (Ex: 3)',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('99','ID do grupo de inventario Item Configuração (Ex: 4)',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('100','ID do grupo padrão para atendimento de requisições de produtos',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('101','Percentual máximo de variação de preço para cotação',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('102','LDAP - Número máximo de colaboradores retornados na rotina de sincronização com AD? ',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('103','ID do modelo de e-mail para envio de notificação de alteracao de serviço',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('104','Calcular a prioridade da solicitação dinamicamente usando a fórmula cadastrada. (Default: ''N'')',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('105','ID da origem que será setado como padrão ao criar um novo incidente',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('106','Determina automaticamente a urgência e impacto das requisições de produto',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('107','Peso padrão para critério PREÇO na cotação',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('108','Peso padrão para critério PRAZO DE ENTREGA na cotação',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('109','Peso padrão para critério PRAZO DE PAGAMENTO na cotação',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('110','Peso padrão para critério PRAZO DE GARANTIA na cotação',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('111','Peso padrão para critério TAXA DE JUROS na cotação',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('112','Path do Arquivo de Status do Nagios',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('113','ID do modelo de e-mail para escalação automática',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('114','Permite que um empregado da área de compras faça requisição de produto',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('115','Tirar vinculo de localidade física com unidade ?(S/N)(Default: N)',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('116','ID do modelo de e-mail para alteração da senha de acesso ao CITSmart',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('117','Informar o caminho para salvar a tabela LOGDADOS',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('118','[Portal] ID do Contrato padrão para abertura de chamados.',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('119','Tipo de captura de solicitações/Incidentes (1-Na execução, 2-No direcionamento) (Default: 1)',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('120','ID do modelo de e-mail para envio de notificação para o comitê de consultivo de mudanças',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('121','Faz o controle de Configuração para o openLDAP (S/N)(Default: N)',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
Insert into PARAMETROCORPORE (IDPARAMETROCORPORE,NOMEPARAMETROCORPORE,VALOR,IDEMPRESA,DATAINICIO,DATAFIM,TIPODADO) values ('122','ID do modelo de e-mail que será enviado para o grupo de destino ao escalar uma requisição mudança',' ','1',to_date('08/04/13','DD/MM/RR'),null,null);
REM INSERTING into PARAMETROS
SET DEFINE OFF;
REM INSERTING into PARAMETROSCONTRATO
SET DEFINE OFF;
REM INSERTING into PARECER
SET DEFINE OFF;
REM INSERTING into PASTA
SET DEFINE OFF;
Insert into PASTA (IDPASTA,NOME,DATAINICIO,DATAFIM,IDPASTAPAI,IDNOTIFICACAO,HERDAPERMISSOES) values ('1','Pasta 1',null,null,null,null,null);
Insert into PASTA (IDPASTA,NOME,DATAINICIO,DATAFIM,IDPASTAPAI,IDNOTIFICACAO,HERDAPERMISSOES) values ('2','Pasta 2',null,null,null,null,null);
REM INSERTING into PEDIDOCOMPRA
SET DEFINE OFF;
REM INSERTING into PERFILACESSO
SET DEFINE OFF;
Insert into PERFILACESSO (IDPERFIL,DATAINICIO,DATAFIM,NOME) values ('1',to_date('01/01/12','DD/MM/RR'),null,'Administrador');
Insert into PERFILACESSO (IDPERFIL,DATAINICIO,DATAFIM,NOME) values ('2',to_date('18/03/13','DD/MM/RR'),null,'Atendimento 1º NÍVEL');
Insert into PERFILACESSO (IDPERFIL,DATAINICIO,DATAFIM,NOME) values ('3',to_date('01/01/12','DD/MM/RR'),null,'Supervisão');
Insert into PERFILACESSO (IDPERFIL,DATAINICIO,DATAFIM,NOME) values ('4',to_date('01/01/12','DD/MM/RR'),null,'Qualidade');
Insert into PERFILACESSO (IDPERFIL,DATAINICIO,DATAFIM,NOME) values ('5',to_date('01/01/12','DD/MM/RR'),null,'Coordenação');
Insert into PERFILACESSO (IDPERFIL,DATAINICIO,DATAFIM,NOME) values ('6',to_date('01/01/12','DD/MM/RR'),null,'Usuário');
Insert into PERFILACESSO (IDPERFIL,DATAINICIO,DATAFIM,NOME) values ('7',to_date('01/01/12','DD/MM/RR'),null,'Desenvolvimento');
Insert into PERFILACESSO (IDPERFIL,DATAINICIO,DATAFIM,NOME) values ('15',to_date('01/01/12','DD/MM/RR'),null,'Atendimento 3º NÍVEL');
Insert into PERFILACESSO (IDPERFIL,DATAINICIO,DATAFIM,NOME) values ('18',to_date('01/01/12','DD/MM/RR'),null,'Atendimento 2º NÍVEL');
REM INSERTING into PERFILACESSOGRUPO
SET DEFINE OFF;
Insert into PERFILACESSOGRUPO (IDPERFIL,IDGRUPO,DATAINICIO,DATAFIM) values ('1','2',to_date('01/01/12','DD/MM/RR'),null);
Insert into PERFILACESSOGRUPO (IDPERFIL,IDGRUPO,DATAINICIO,DATAFIM) values ('4','5',to_date('01/01/12','DD/MM/RR'),null);
Insert into PERFILACESSOGRUPO (IDPERFIL,IDGRUPO,DATAINICIO,DATAFIM) values ('5','6',to_date('01/01/12','DD/MM/RR'),null);
Insert into PERFILACESSOGRUPO (IDPERFIL,IDGRUPO,DATAINICIO,DATAFIM) values ('5','7',to_date('01/01/12','DD/MM/RR'),null);
Insert into PERFILACESSOGRUPO (IDPERFIL,IDGRUPO,DATAINICIO,DATAFIM) values ('5','18',to_date('01/01/12','DD/MM/RR'),null);
Insert into PERFILACESSOGRUPO (IDPERFIL,IDGRUPO,DATAINICIO,DATAFIM) values ('5','20',to_date('01/01/12','DD/MM/RR'),null);
Insert into PERFILACESSOGRUPO (IDPERFIL,IDGRUPO,DATAINICIO,DATAFIM) values ('7','1',to_date('01/01/12','DD/MM/RR'),null);
Insert into PERFILACESSOGRUPO (IDPERFIL,IDGRUPO,DATAINICIO,DATAFIM) values ('15','4',to_date('01/01/12','DD/MM/RR'),null);
Insert into PERFILACESSOGRUPO (IDPERFIL,IDGRUPO,DATAINICIO,DATAFIM) values ('15','16',to_date('01/01/12','DD/MM/RR'),null);
Insert into PERFILACESSOGRUPO (IDPERFIL,IDGRUPO,DATAINICIO,DATAFIM) values ('15','17',to_date('01/01/12','DD/MM/RR'),null);
Insert into PERFILACESSOGRUPO (IDPERFIL,IDGRUPO,DATAINICIO,DATAFIM) values ('15','19',to_date('01/01/12','DD/MM/RR'),null);
Insert into PERFILACESSOGRUPO (IDPERFIL,IDGRUPO,DATAINICIO,DATAFIM) values ('18','3',to_date('01/01/12','DD/MM/RR'),null);
REM INSERTING into PERFILACESSOMENU
SET DEFINE OFF;
REM INSERTING into PERFILACESSOPASTA
SET DEFINE OFF;
Insert into PERFILACESSOPASTA (IDPERFIL,IDPASTA,DATAINICIO,DATAFIM,APROVABASECONHECIMENTO,PERMITELEITURA,PERMITELEITURAGRAVACAO) values ('1','1',to_date('05/04/13','DD/MM/RR'),null,'S','N','S');
Insert into PERFILACESSOPASTA (IDPERFIL,IDPASTA,DATAINICIO,DATAFIM,APROVABASECONHECIMENTO,PERMITELEITURA,PERMITELEITURAGRAVACAO) values ('1','2',to_date('05/04/13','DD/MM/RR'),null,'S','N','S');
Insert into PERFILACESSOPASTA (IDPERFIL,IDPASTA,DATAINICIO,DATAFIM,APROVABASECONHECIMENTO,PERMITELEITURA,PERMITELEITURAGRAVACAO) values ('1','3',to_date('05/04/13','DD/MM/RR'),null,'S','N','S');
Insert into PERFILACESSOPASTA (IDPERFIL,IDPASTA,DATAINICIO,DATAFIM,APROVABASECONHECIMENTO,PERMITELEITURA,PERMITELEITURAGRAVACAO) values ('1','4',to_date('05/04/13','DD/MM/RR'),null,'S','N','S');
Insert into PERFILACESSOPASTA (IDPERFIL,IDPASTA,DATAINICIO,DATAFIM,APROVABASECONHECIMENTO,PERMITELEITURA,PERMITELEITURAGRAVACAO) values ('2','1',to_date('05/04/13','DD/MM/RR'),null,'N','S','N');
Insert into PERFILACESSOPASTA (IDPERFIL,IDPASTA,DATAINICIO,DATAFIM,APROVABASECONHECIMENTO,PERMITELEITURA,PERMITELEITURAGRAVACAO) values ('2','2',to_date('05/04/13','DD/MM/RR'),null,'N','S','N');
Insert into PERFILACESSOPASTA (IDPERFIL,IDPASTA,DATAINICIO,DATAFIM,APROVABASECONHECIMENTO,PERMITELEITURA,PERMITELEITURAGRAVACAO) values ('2','3',to_date('05/04/13','DD/MM/RR'),null,'N','S','N');
Insert into PERFILACESSOPASTA (IDPERFIL,IDPASTA,DATAINICIO,DATAFIM,APROVABASECONHECIMENTO,PERMITELEITURA,PERMITELEITURAGRAVACAO) values ('2','4',to_date('05/04/13','DD/MM/RR'),null,'N','S','N');
Insert into PERFILACESSOPASTA (IDPERFIL,IDPASTA,DATAINICIO,DATAFIM,APROVABASECONHECIMENTO,PERMITELEITURA,PERMITELEITURAGRAVACAO) values ('3','1',to_date('05/04/13','DD/MM/RR'),null,'S','N','S');
Insert into PERFILACESSOPASTA (IDPERFIL,IDPASTA,DATAINICIO,DATAFIM,APROVABASECONHECIMENTO,PERMITELEITURA,PERMITELEITURAGRAVACAO) values ('3','2',to_date('05/04/13','DD/MM/RR'),null,'S','N','S');
Insert into PERFILACESSOPASTA (IDPERFIL,IDPASTA,DATAINICIO,DATAFIM,APROVABASECONHECIMENTO,PERMITELEITURA,PERMITELEITURAGRAVACAO) values ('3','3',to_date('05/04/13','DD/MM/RR'),null,'S','N','S');
Insert into PERFILACESSOPASTA (IDPERFIL,IDPASTA,DATAINICIO,DATAFIM,APROVABASECONHECIMENTO,PERMITELEITURA,PERMITELEITURAGRAVACAO) values ('3','4',to_date('05/04/13','DD/MM/RR'),null,'S','N','S');
Insert into PERFILACESSOPASTA (IDPERFIL,IDPASTA,DATAINICIO,DATAFIM,APROVABASECONHECIMENTO,PERMITELEITURA,PERMITELEITURAGRAVACAO) values ('4','1',to_date('05/04/13','DD/MM/RR'),null,'N','S','N');
Insert into PERFILACESSOPASTA (IDPERFIL,IDPASTA,DATAINICIO,DATAFIM,APROVABASECONHECIMENTO,PERMITELEITURA,PERMITELEITURAGRAVACAO) values ('4','2',to_date('05/04/13','DD/MM/RR'),null,'N','S','N');
Insert into PERFILACESSOPASTA (IDPERFIL,IDPASTA,DATAINICIO,DATAFIM,APROVABASECONHECIMENTO,PERMITELEITURA,PERMITELEITURAGRAVACAO) values ('4','3',to_date('05/04/13','DD/MM/RR'),null,'N','S','N');
Insert into PERFILACESSOPASTA (IDPERFIL,IDPASTA,DATAINICIO,DATAFIM,APROVABASECONHECIMENTO,PERMITELEITURA,PERMITELEITURAGRAVACAO) values ('4','4',to_date('05/04/13','DD/MM/RR'),null,'N','S','N');
Insert into PERFILACESSOPASTA (IDPERFIL,IDPASTA,DATAINICIO,DATAFIM,APROVABASECONHECIMENTO,PERMITELEITURA,PERMITELEITURAGRAVACAO) values ('5','1',to_date('05/04/13','DD/MM/RR'),null,'S','N','S');
Insert into PERFILACESSOPASTA (IDPERFIL,IDPASTA,DATAINICIO,DATAFIM,APROVABASECONHECIMENTO,PERMITELEITURA,PERMITELEITURAGRAVACAO) values ('5','2',to_date('05/04/13','DD/MM/RR'),null,'S','N','S');
Insert into PERFILACESSOPASTA (IDPERFIL,IDPASTA,DATAINICIO,DATAFIM,APROVABASECONHECIMENTO,PERMITELEITURA,PERMITELEITURAGRAVACAO) values ('5','3',to_date('05/04/13','DD/MM/RR'),null,'S','N','S');
Insert into PERFILACESSOPASTA (IDPERFIL,IDPASTA,DATAINICIO,DATAFIM,APROVABASECONHECIMENTO,PERMITELEITURA,PERMITELEITURAGRAVACAO) values ('5','4',to_date('05/04/13','DD/MM/RR'),null,'S','N','S');
Insert into PERFILACESSOPASTA (IDPERFIL,IDPASTA,DATAINICIO,DATAFIM,APROVABASECONHECIMENTO,PERMITELEITURA,PERMITELEITURAGRAVACAO) values ('6','1',to_date('05/04/13','DD/MM/RR'),null,'N','S','N');
Insert into PERFILACESSOPASTA (IDPERFIL,IDPASTA,DATAINICIO,DATAFIM,APROVABASECONHECIMENTO,PERMITELEITURA,PERMITELEITURAGRAVACAO) values ('6','2',to_date('05/04/13','DD/MM/RR'),null,'N','S','N');
Insert into PERFILACESSOPASTA (IDPERFIL,IDPASTA,DATAINICIO,DATAFIM,APROVABASECONHECIMENTO,PERMITELEITURA,PERMITELEITURAGRAVACAO) values ('6','3',to_date('05/04/13','DD/MM/RR'),null,'N','S','N');
Insert into PERFILACESSOPASTA (IDPERFIL,IDPASTA,DATAINICIO,DATAFIM,APROVABASECONHECIMENTO,PERMITELEITURA,PERMITELEITURAGRAVACAO) values ('6','4',to_date('05/04/13','DD/MM/RR'),null,'N','S','N');
Insert into PERFILACESSOPASTA (IDPERFIL,IDPASTA,DATAINICIO,DATAFIM,APROVABASECONHECIMENTO,PERMITELEITURA,PERMITELEITURAGRAVACAO) values ('7','1',to_date('05/04/13','DD/MM/RR'),null,'N','S','N');
Insert into PERFILACESSOPASTA (IDPERFIL,IDPASTA,DATAINICIO,DATAFIM,APROVABASECONHECIMENTO,PERMITELEITURA,PERMITELEITURAGRAVACAO) values ('7','2',to_date('05/04/13','DD/MM/RR'),null,'N','S','N');
Insert into PERFILACESSOPASTA (IDPERFIL,IDPASTA,DATAINICIO,DATAFIM,APROVABASECONHECIMENTO,PERMITELEITURA,PERMITELEITURAGRAVACAO) values ('7','3',to_date('05/04/13','DD/MM/RR'),null,'N','S','N');
Insert into PERFILACESSOPASTA (IDPERFIL,IDPASTA,DATAINICIO,DATAFIM,APROVABASECONHECIMENTO,PERMITELEITURA,PERMITELEITURAGRAVACAO) values ('7','4',to_date('05/04/13','DD/MM/RR'),null,'N','S','N');
Insert into PERFILACESSOPASTA (IDPERFIL,IDPASTA,DATAINICIO,DATAFIM,APROVABASECONHECIMENTO,PERMITELEITURA,PERMITELEITURAGRAVACAO) values ('15','1',to_date('05/04/13','DD/MM/RR'),null,'N','S','N');
Insert into PERFILACESSOPASTA (IDPERFIL,IDPASTA,DATAINICIO,DATAFIM,APROVABASECONHECIMENTO,PERMITELEITURA,PERMITELEITURAGRAVACAO) values ('15','2',to_date('05/04/13','DD/MM/RR'),null,'N','S','N');
Insert into PERFILACESSOPASTA (IDPERFIL,IDPASTA,DATAINICIO,DATAFIM,APROVABASECONHECIMENTO,PERMITELEITURA,PERMITELEITURAGRAVACAO) values ('15','3',to_date('05/04/13','DD/MM/RR'),null,'N','S','N');
Insert into PERFILACESSOPASTA (IDPERFIL,IDPASTA,DATAINICIO,DATAFIM,APROVABASECONHECIMENTO,PERMITELEITURA,PERMITELEITURAGRAVACAO) values ('15','4',to_date('05/04/13','DD/MM/RR'),null,'N','S','N');
Insert into PERFILACESSOPASTA (IDPERFIL,IDPASTA,DATAINICIO,DATAFIM,APROVABASECONHECIMENTO,PERMITELEITURA,PERMITELEITURAGRAVACAO) values ('18','1',to_date('05/04/13','DD/MM/RR'),null,'N','S','N');
Insert into PERFILACESSOPASTA (IDPERFIL,IDPASTA,DATAINICIO,DATAFIM,APROVABASECONHECIMENTO,PERMITELEITURA,PERMITELEITURAGRAVACAO) values ('18','2',to_date('05/04/13','DD/MM/RR'),null,'N','S','N');
Insert into PERFILACESSOPASTA (IDPERFIL,IDPASTA,DATAINICIO,DATAFIM,APROVABASECONHECIMENTO,PERMITELEITURA,PERMITELEITURAGRAVACAO) values ('18','3',to_date('05/04/13','DD/MM/RR'),null,'N','S','N');
Insert into PERFILACESSOPASTA (IDPERFIL,IDPASTA,DATAINICIO,DATAFIM,APROVABASECONHECIMENTO,PERMITELEITURA,PERMITELEITURAGRAVACAO) values ('18','4',to_date('05/04/13','DD/MM/RR'),null,'N','S','N');
REM INSERTING into PERFILACESSOSITUACAOFATURA
SET DEFINE OFF;
Insert INTO PERFILACESSOSITUACAOFATURA (IDPERFIL,SITUACAOFATURA,DATAINICIO,DATAFIM) VALUES (1,'1',to_date('04/09/12','DD/MM/RR'),NULL);
Insert INTO PERFILACESSOSITUACAOFATURA (IDPERFIL,SITUACAOFATURA,DATAINICIO,DATAFIM) VALUES (1,'2',to_date('04/09/12','DD/MM/RR'),NULL);
Insert INTO PERFILACESSOSITUACAOFATURA (IDPERFIL,SITUACAOFATURA,DATAINICIO,DATAFIM) VALUES (1,'3',to_date('04/09/12','DD/MM/RR'),NULL);
Insert INTO PERFILACESSOSITUACAOFATURA (IDPERFIL,SITUACAOFATURA,DATAINICIO,DATAFIM) VALUES (1,'4',to_date('04/09/12','DD/MM/RR'),NULL);
Insert INTO PERFILACESSOSITUACAOFATURA (IDPERFIL,SITUACAOFATURA,DATAINICIO,DATAFIM) VALUES (1,'5',to_date('04/09/12','DD/MM/RR'),NULL);
Insert INTO PERFILACESSOSITUACAOFATURA (IDPERFIL,SITUACAOFATURA,DATAINICIO,DATAFIM) VALUES (1,'6',to_date('04/09/12','DD/MM/RR'),NULL);
Insert INTO PERFILACESSOSITUACAOFATURA (IDPERFIL,SITUACAOFATURA,DATAINICIO,DATAFIM) VALUES (1,'7',to_date('04/09/12','DD/MM/RR'),NULL);
REM INSERTING into PERFILACESSOSITUACAOOS
SET DEFINE OFF;
Insert INTO PERFILACESSOSITUACAOOS (IDPERFIL,SITUACAOOS,DATAINICIO,DATAFIM) VALUES (1,'1',to_date('04/09/12','DD/MM/RR'),NULL);
Insert INTO PERFILACESSOSITUACAOOS (IDPERFIL,SITUACAOOS,DATAINICIO,DATAFIM) VALUES (1,'2',to_date('04/09/12','DD/MM/RR'),NULL);
Insert INTO PERFILACESSOSITUACAOOS (IDPERFIL,SITUACAOOS,DATAINICIO,DATAFIM) VALUES (1,'3',to_date('04/09/12','DD/MM/RR'),NULL);
Insert INTO PERFILACESSOSITUACAOOS (IDPERFIL,SITUACAOOS,DATAINICIO,DATAFIM) VALUES (1,'4',to_date('04/09/12','DD/MM/RR'),NULL);
Insert INTO PERFILACESSOSITUACAOOS (IDPERFIL,SITUACAOOS,DATAINICIO,DATAFIM) VALUES (1,'5',to_date('04/09/12','DD/MM/RR'),NULL);
Insert INTO PERFILACESSOSITUACAOOS (IDPERFIL,SITUACAOOS,DATAINICIO,DATAFIM) VALUES (1,'6',to_date('04/09/12','DD/MM/RR'),NULL);
Insert INTO PERFILACESSOSITUACAOOS (IDPERFIL,SITUACAOOS,DATAINICIO,DATAFIM) VALUES (1,'7',to_date('04/09/12','DD/MM/RR'),NULL);
REM INSERTING into PERFILACESSOUSUARIO
SET DEFINE OFF;
Insert into PERFILACESSOUSUARIO (DATAINICIO,IDUSUARIO,IDPERFIL,DATAFIM) values (to_date('01/01/12','DD/MM/RR'),'1','1',null);
Insert into PERFILACESSOUSUARIO (DATAINICIO,IDUSUARIO,IDPERFIL,DATAFIM) values (to_date('01/01/12','DD/MM/RR'),'2','2',null);
Insert into PERFILACESSOUSUARIO (DATAINICIO,IDUSUARIO,IDPERFIL,DATAFIM) values (to_date('01/01/12','DD/MM/RR'),'3','1',null);
REM INSERTING into PERFILSEGURANCA
SET DEFINE OFF;
REM INSERTING into PESQUISASATISFACAO
SET DEFINE OFF;
REM INSERTING into PESSOA
SET DEFINE OFF;
REM INSERTING into PLANOMELHORIA
SET DEFINE OFF;
REM INSERTING into PORTAL
SET DEFINE OFF;
REM INSERTING into POST
SET DEFINE OFF;
REM INSERTING into PRIORIDADE
SET DEFINE OFF;
Insert into PRIORIDADE (IDPRIORIDADE,IDEMPRESA,NOMEPRIORIDADE,SITUACAO,GRUPOPRIORIDADE) values ('1','1','1','A','   ');
Insert into PRIORIDADE (IDPRIORIDADE,IDEMPRESA,NOMEPRIORIDADE,SITUACAO,GRUPOPRIORIDADE) values ('2','1','2','A','   ');
Insert into PRIORIDADE (IDPRIORIDADE,IDEMPRESA,NOMEPRIORIDADE,SITUACAO,GRUPOPRIORIDADE) values ('3','1','3','A','   ');
Insert into PRIORIDADE (IDPRIORIDADE,IDEMPRESA,NOMEPRIORIDADE,SITUACAO,GRUPOPRIORIDADE) values ('4','1','4','A','   ');
Insert into PRIORIDADE (IDPRIORIDADE,IDEMPRESA,NOMEPRIORIDADE,SITUACAO,GRUPOPRIORIDADE) values ('5','1','5','A','   ');
REM INSERTING into PRIORIDADEACORDONIVELSERVICO
SET DEFINE OFF;
REM INSERTING into PRIORIDADESERVICOUNIDADE
SET DEFINE OFF;
REM INSERTING into PROBLEMA
SET DEFINE OFF;
REM INSERTING into PROBLEMAITEMCONFIGURACAO
SET DEFINE OFF;
REM INSERTING into PROBLEMAMUDANCA
SET DEFINE OFF;
REM INSERTING into PROCEDIMENTOTECNICO
SET DEFINE OFF;
REM INSERTING into PROCESSAMENTOBATCH
SET DEFINE OFF;
Insert into PROCESSAMENTOBATCH (IDPROCESSAMENTOBATCH,DESCRICAO,EXPRESSAOCRON,TIPO,SITUACAO) values ('1','Execução da Rotina de Inventario',' ','C','A');
Insert into PROCESSAMENTOBATCH (IDPROCESSAMENTOBATCH,DESCRICAO,EXPRESSAOCRON,TIPO,SITUACAO) values ('2','Verifica e avisa a data de expiração de um item de configuração',' ','C','A');
Insert into PROCESSAMENTOBATCH (IDPROCESSAMENTOBATCH,DESCRICAO,EXPRESSAOCRON,TIPO,SITUACAO) values ('3','Backup LogDados',' ','C','A');
Insert into PROCESSAMENTOBATCH (IDPROCESSAMENTOBATCH,DESCRICAO,EXPRESSAOCRON,TIPO,SITUACAO) values ('4','Replicar o conteúdo do campo descricao da tabela solicitacaoservico para o campo descricaosemformatacao',' ','C','A');
Insert into PROCESSAMENTOBATCH (IDPROCESSAMENTOBATCH,DESCRICAO,EXPRESSAOCRON,TIPO,SITUACAO) values ('5','Replicar o conteudo do campo conteudo da  tabela base conhecimento para o campo conteudosemformatcao',' ','C','A');
REM INSERTING into PRODUTO
SET DEFINE OFF;
REM INSERTING into PROGRAMACAOATIVIDADE
SET DEFINE OFF;
REM INSERTING into PROJETOS
SET DEFINE OFF;
REM INSERTING into QUESTAOQUESTIONARIO
SET DEFINE OFF;
REM INSERTING into QUESTIONARIO
SET DEFINE OFF;
REM INSERTING into REABERTURASOLICITACAO
SET DEFINE OFF;
REM INSERTING into RECURSO
SET DEFINE OFF;
REM INSERTING into REGIOES
SET DEFINE OFF;
REM INSERTING into REGISTRO
SET DEFINE OFF;
REM INSERTING into RELACIONAMENTOPRODUTO
SET DEFINE OFF;
REM INSERTING into RELACOBJETONEGOCIO
SET DEFINE OFF;
REM INSERTING into REQUISICAOMUDANCA
SET DEFINE OFF;
REM INSERTING into REQUISICAOMUDANCAITEMCONFIGURA
SET DEFINE OFF;
REM INSERTING into REQUISICAOMUDANCASERVICO
SET DEFINE OFF;
REM INSERTING into REQUISICAOPRODUTO
SET DEFINE OFF;
REM INSERTING into REQUISITOSLA
SET DEFINE OFF;
REM INSERTING into RESPONSABILIDADE
SET DEFINE OFF;
REM INSERTING into RESPOSTAITEMQUESTIONARIO
SET DEFINE OFF;
REM INSERTING into RESPOSTAITEMQUESTIONARIOANEXOS
SET DEFINE OFF;
REM INSERTING into RESPOSTAITEMQUESTIONARIOCIDS
SET DEFINE OFF;
REM INSERTING into RESPOSTAITEMQUESTIONARIOOPCOES
SET DEFINE OFF;
REM INSERTING into RESULTADOSESPERADOS
SET DEFINE OFF;
REM INSERTING into REVISARSLA
SET DEFINE OFF;
REM INSERTING into SCRIPTS
SET DEFINE OFF;
REM INSERTING into SCRIPTSVISAO
SET DEFINE OFF;
REM INSERTING into SERVCONTRATOCATALOGOSERV
SET DEFINE OFF;
REM INSERTING into SERVICO
SET DEFINE OFF;
Insert into SERVICO (IDSERVICO,IDCATEGORIASERVICO,IDSITUACAOSERVICO,IDTIPOSERVICO,IDIMPORTANCIANEGOCIO,IDEMPRESA,IDTIPOEVENTOSERVICO,IDTIPODEMANDASERVICO,IDLOCALEXECUCAOSERVICO,NOMESERVICO,DATAINICIO,LINKPROCESSO,TIPODESCPROCESS,DISPPORTAL,DELETED,DETALHESSERVICO,SIGLAABREV,IDBASECONHECIMENTO,IDTEMPLATESOLICITACAO,IDTEMPLATEACOMPANHAMENTO) values ('1','1','1','1','10','1','33','3','4','Serviço 1',to_date('01/04/13','DD/MM/RR'),' ',null,'S',null,null,' ',null,null,null);
Insert into SERVICO (IDSERVICO,IDCATEGORIASERVICO,IDSITUACAOSERVICO,IDTIPOSERVICO,IDIMPORTANCIANEGOCIO,IDEMPRESA,IDTIPOEVENTOSERVICO,IDTIPODEMANDASERVICO,IDLOCALEXECUCAOSERVICO,NOMESERVICO,DATAINICIO,LINKPROCESSO,TIPODESCPROCESS,DISPPORTAL,DELETED,DETALHESSERVICO,SIGLAABREV,IDBASECONHECIMENTO,IDTEMPLATESOLICITACAO,IDTEMPLATEACOMPANHAMENTO) values ('2','1','1','1','10','1','33','3','4','Serviço 2',to_date('01/04/13','DD/MM/RR'),' ',null,'S',null,null,' ',null,null,null);
Insert into SERVICO (IDSERVICO,IDCATEGORIASERVICO,IDSITUACAOSERVICO,IDTIPOSERVICO,IDIMPORTANCIANEGOCIO,IDEMPRESA,IDTIPOEVENTOSERVICO,IDTIPODEMANDASERVICO,IDLOCALEXECUCAOSERVICO,NOMESERVICO,DATAINICIO,LINKPROCESSO,TIPODESCPROCESS,DISPPORTAL,DELETED,DETALHESSERVICO,SIGLAABREV,IDBASECONHECIMENTO,IDTEMPLATESOLICITACAO,IDTEMPLATEACOMPANHAMENTO) values ('3','1','1','1','10','1','33','3','4','Serviço 3',to_date('01/04/13','DD/MM/RR'),' ',null,'S',null,null,' ',null,null,null);
Insert into SERVICO (IDSERVICO,IDCATEGORIASERVICO,IDSITUACAOSERVICO,IDTIPOSERVICO,IDIMPORTANCIANEGOCIO,IDEMPRESA,IDTIPOEVENTOSERVICO,IDTIPODEMANDASERVICO,IDLOCALEXECUCAOSERVICO,NOMESERVICO,DATAINICIO,LINKPROCESSO,TIPODESCPROCESS,DISPPORTAL,DELETED,DETALHESSERVICO,SIGLAABREV,IDBASECONHECIMENTO,IDTEMPLATESOLICITACAO,IDTEMPLATEACOMPANHAMENTO) values ('4','1','1','1','10','1','33','1','4','Serviço 4',to_date('01/04/13','DD/MM/RR'),' ',null,'S',null,null,' ',null,null,null);
Insert into SERVICO (IDSERVICO,IDCATEGORIASERVICO,IDSITUACAOSERVICO,IDTIPOSERVICO,IDIMPORTANCIANEGOCIO,IDEMPRESA,IDTIPOEVENTOSERVICO,IDTIPODEMANDASERVICO,IDLOCALEXECUCAOSERVICO,NOMESERVICO,DATAINICIO,LINKPROCESSO,TIPODESCPROCESS,DISPPORTAL,DELETED,DETALHESSERVICO,SIGLAABREV,IDBASECONHECIMENTO,IDTEMPLATESOLICITACAO,IDTEMPLATEACOMPANHAMENTO) values ('5','1','1','1','10','1','33','1','4','Serviço 5',to_date('01/04/13','DD/MM/RR'),' ',null,'S',null,null,' ',null,null,null);
REM INSERTING into SERVICOCONTRATO
SET DEFINE OFF;
Insert into SERVICOCONTRATO (IDSERVICOCONTRATO,IDSERVICO,IDCONTRATO,IDCONDICAOOPERACAO,DATAINICIO,DATAFIM,CUSTO,PERMITESLANOCADINC,LINKPROCESSO,TIPODESCPROCESS,DELETED,AREAREQUISITANTE,IDGRUPONIVEL1,IDMODELOEMAILCRIACAO,IDMODELOEMAILFINALIZACAO,IDMODELOEMAILACOES,IDGRUPOEXECUTOR,IDCALENDARIO,PERMSLATEMPOACOMBINAR,PERMMUDANCASLA,PERMMUDANCACALENDARIO,IDGRUPOAPROVADOR) values ('1','1','1','2',to_date('01/04/13','DD/MM/RR'),null,null,null,' ',null,null,' ',null,'17',null,null,null,'1',null,null,null,null);
Insert into SERVICOCONTRATO (IDSERVICOCONTRATO,IDSERVICO,IDCONTRATO,IDCONDICAOOPERACAO,DATAINICIO,DATAFIM,CUSTO,PERMITESLANOCADINC,LINKPROCESSO,TIPODESCPROCESS,DELETED,AREAREQUISITANTE,IDGRUPONIVEL1,IDMODELOEMAILCRIACAO,IDMODELOEMAILFINALIZACAO,IDMODELOEMAILACOES,IDGRUPOEXECUTOR,IDCALENDARIO,PERMSLATEMPOACOMBINAR,PERMMUDANCASLA,PERMMUDANCACALENDARIO,IDGRUPOAPROVADOR) values ('2','2','1','2',to_date('01/04/13','DD/MM/RR'),null,null,null,' ',null,null,' ','2','17',null,null,null,'1',null,null,null,null);
Insert into SERVICOCONTRATO (IDSERVICOCONTRATO,IDSERVICO,IDCONTRATO,IDCONDICAOOPERACAO,DATAINICIO,DATAFIM,CUSTO,PERMITESLANOCADINC,LINKPROCESSO,TIPODESCPROCESS,DELETED,AREAREQUISITANTE,IDGRUPONIVEL1,IDMODELOEMAILCRIACAO,IDMODELOEMAILFINALIZACAO,IDMODELOEMAILACOES,IDGRUPOEXECUTOR,IDCALENDARIO,PERMSLATEMPOACOMBINAR,PERMMUDANCASLA,PERMMUDANCACALENDARIO,IDGRUPOAPROVADOR) values ('3','3','1','2',to_date('01/04/13','DD/MM/RR'),null,null,null,' ',null,null,' ','2','17',null,null,null,'1',null,null,null,null);
Insert into SERVICOCONTRATO (IDSERVICOCONTRATO,IDSERVICO,IDCONTRATO,IDCONDICAOOPERACAO,DATAINICIO,DATAFIM,CUSTO,PERMITESLANOCADINC,LINKPROCESSO,TIPODESCPROCESS,DELETED,AREAREQUISITANTE,IDGRUPONIVEL1,IDMODELOEMAILCRIACAO,IDMODELOEMAILFINALIZACAO,IDMODELOEMAILACOES,IDGRUPOEXECUTOR,IDCALENDARIO,PERMSLATEMPOACOMBINAR,PERMMUDANCASLA,PERMMUDANCACALENDARIO,IDGRUPOAPROVADOR) values ('4','4','1','2',to_date('01/04/13','DD/MM/RR'),null,null,null,' ',null,null,' ','2','17',null,null,null,'1',null,null,null,null);
Insert into SERVICOCONTRATO (IDSERVICOCONTRATO,IDSERVICO,IDCONTRATO,IDCONDICAOOPERACAO,DATAINICIO,DATAFIM,CUSTO,PERMITESLANOCADINC,LINKPROCESSO,TIPODESCPROCESS,DELETED,AREAREQUISITANTE,IDGRUPONIVEL1,IDMODELOEMAILCRIACAO,IDMODELOEMAILFINALIZACAO,IDMODELOEMAILACOES,IDGRUPOEXECUTOR,IDCALENDARIO,PERMSLATEMPOACOMBINAR,PERMMUDANCASLA,PERMMUDANCACALENDARIO,IDGRUPOAPROVADOR) values ('5','5','1','2',to_date('01/04/13','DD/MM/RR'),null,null,null,' ',null,null,' ','2','17',null,null,null,'1',null,null,null,null);
REM INSERTING into SERVICO_HIST
SET DEFINE OFF;
Insert into SERVICO_HIST (IDHISTORICOSERVICO,IDSERVICO,IDCATEGORIASERVICO,IDSITUACAOSERVICO,IDTIPOSERVICO,IDIMPORTANCIANEGOCIO,IDEMPRESA,IDTIPOEVENTOSERVICO,IDTIPODEMANDASERVICO,IDLOCALEXECUCAOSERVICO,NOMESERVICO,DATAINICIO,LINKPROCESSO,TIPODESCPROCESS,DISPPORTAL,DELETED,DETALHESSERVICO,SIGLAABREV,IDBASECONHECIMENTO,IDTEMPLATESOLICITACAO,IDTEMPLATEACOMPANHAMENTO,CRIADOEM,CRIADOPOR,MODIFICADOEM,MODIFICADOPOR) values ('1','1','1','1','1','10','1','19','3','4','Seu Serviço',to_date('01/04/13','DD/MM/RR'),' ',null,'S',null,null,' ',null,null,null,to_date('02/04/13','DD/MM/RR'),'Administrador',to_date('02/04/13','DD/MM/RR'),'Administrador');
Insert into SERVICO_HIST (IDHISTORICOSERVICO,IDSERVICO,IDCATEGORIASERVICO,IDSITUACAOSERVICO,IDTIPOSERVICO,IDIMPORTANCIANEGOCIO,IDEMPRESA,IDTIPOEVENTOSERVICO,IDTIPODEMANDASERVICO,IDLOCALEXECUCAOSERVICO,NOMESERVICO,DATAINICIO,LINKPROCESSO,TIPODESCPROCESS,DISPPORTAL,DELETED,DETALHESSERVICO,SIGLAABREV,IDBASECONHECIMENTO,IDTEMPLATESOLICITACAO,IDTEMPLATEACOMPANHAMENTO,CRIADOEM,CRIADOPOR,MODIFICADOEM,MODIFICADOPOR) values ('2','1','1','1','1','10','1','19','3','4','Serviço 1',to_date('01/04/13','DD/MM/RR'),' ',null,'S',null,null,' ',null,null,null,to_date('03/04/13','DD/MM/RR'),'Administrador',to_date('03/04/13','DD/MM/RR'),'Administrador');
Insert into SERVICO_HIST (IDHISTORICOSERVICO,IDSERVICO,IDCATEGORIASERVICO,IDSITUACAOSERVICO,IDTIPOSERVICO,IDIMPORTANCIANEGOCIO,IDEMPRESA,IDTIPOEVENTOSERVICO,IDTIPODEMANDASERVICO,IDLOCALEXECUCAOSERVICO,NOMESERVICO,DATAINICIO,LINKPROCESSO,TIPODESCPROCESS,DISPPORTAL,DELETED,DETALHESSERVICO,SIGLAABREV,IDBASECONHECIMENTO,IDTEMPLATESOLICITACAO,IDTEMPLATEACOMPANHAMENTO,CRIADOEM,CRIADOPOR,MODIFICADOEM,MODIFICADOPOR) values ('3','2','1','1','1','10','1','33','3','4','Serviço 2',to_date('01/04/13','DD/MM/RR'),' ',null,'S',null,null,' ',null,null,null,to_date('03/04/13','DD/MM/RR'),'Administrador',to_date('03/04/13','DD/MM/RR'),'Administrador');
Insert into SERVICO_HIST (IDHISTORICOSERVICO,IDSERVICO,IDCATEGORIASERVICO,IDSITUACAOSERVICO,IDTIPOSERVICO,IDIMPORTANCIANEGOCIO,IDEMPRESA,IDTIPOEVENTOSERVICO,IDTIPODEMANDASERVICO,IDLOCALEXECUCAOSERVICO,NOMESERVICO,DATAINICIO,LINKPROCESSO,TIPODESCPROCESS,DISPPORTAL,DELETED,DETALHESSERVICO,SIGLAABREV,IDBASECONHECIMENTO,IDTEMPLATESOLICITACAO,IDTEMPLATEACOMPANHAMENTO,CRIADOEM,CRIADOPOR,MODIFICADOEM,MODIFICADOPOR) values ('4','1','1','1','1','10','1','33','3','4','Serviço 1',to_date('01/04/13','DD/MM/RR'),' ',null,'S',null,null,' ',null,null,null,to_date('03/04/13','DD/MM/RR'),'Administrador',to_date('03/04/13','DD/MM/RR'),'Administrador');
Insert into SERVICO_HIST (IDHISTORICOSERVICO,IDSERVICO,IDCATEGORIASERVICO,IDSITUACAOSERVICO,IDTIPOSERVICO,IDIMPORTANCIANEGOCIO,IDEMPRESA,IDTIPOEVENTOSERVICO,IDTIPODEMANDASERVICO,IDLOCALEXECUCAOSERVICO,NOMESERVICO,DATAINICIO,LINKPROCESSO,TIPODESCPROCESS,DISPPORTAL,DELETED,DETALHESSERVICO,SIGLAABREV,IDBASECONHECIMENTO,IDTEMPLATESOLICITACAO,IDTEMPLATEACOMPANHAMENTO,CRIADOEM,CRIADOPOR,MODIFICADOEM,MODIFICADOPOR) values ('5','3','1','1','1','10','1','33','3','4','Serviço 3',to_date('01/04/13','DD/MM/RR'),' ',null,'S',null,null,' ',null,null,null,to_date('03/04/13','DD/MM/RR'),'Administrador',to_date('03/04/13','DD/MM/RR'),'Administrador');
Insert into SERVICO_HIST (IDHISTORICOSERVICO,IDSERVICO,IDCATEGORIASERVICO,IDSITUACAOSERVICO,IDTIPOSERVICO,IDIMPORTANCIANEGOCIO,IDEMPRESA,IDTIPOEVENTOSERVICO,IDTIPODEMANDASERVICO,IDLOCALEXECUCAOSERVICO,NOMESERVICO,DATAINICIO,LINKPROCESSO,TIPODESCPROCESS,DISPPORTAL,DELETED,DETALHESSERVICO,SIGLAABREV,IDBASECONHECIMENTO,IDTEMPLATESOLICITACAO,IDTEMPLATEACOMPANHAMENTO,CRIADOEM,CRIADOPOR,MODIFICADOEM,MODIFICADOPOR) values ('6','4','1','1','1','10','1','33','1','4','Serviço 4',to_date('01/04/13','DD/MM/RR'),' ',null,'S',null,null,' ',null,null,null,to_date('03/04/13','DD/MM/RR'),'Administrador',to_date('03/04/13','DD/MM/RR'),'Administrador');
Insert into SERVICO_HIST (IDHISTORICOSERVICO,IDSERVICO,IDCATEGORIASERVICO,IDSITUACAOSERVICO,IDTIPOSERVICO,IDIMPORTANCIANEGOCIO,IDEMPRESA,IDTIPOEVENTOSERVICO,IDTIPODEMANDASERVICO,IDLOCALEXECUCAOSERVICO,NOMESERVICO,DATAINICIO,LINKPROCESSO,TIPODESCPROCESS,DISPPORTAL,DELETED,DETALHESSERVICO,SIGLAABREV,IDBASECONHECIMENTO,IDTEMPLATESOLICITACAO,IDTEMPLATEACOMPANHAMENTO,CRIADOEM,CRIADOPOR,MODIFICADOEM,MODIFICADOPOR) values ('7','5','1','1','1','10','1','33','1','4','Serviço 5',to_date('01/04/13','DD/MM/RR'),' ',null,'S',null,null,' ',null,null,null,to_date('03/04/13','DD/MM/RR'),'Administrador',to_date('03/04/13','DD/MM/RR'),'Administrador');
REM INSERTING into SERVICOS
SET DEFINE OFF;
REM INSERTING into SISTEMAOPERACIONAL
SET DEFINE OFF;
REM INSERTING into SITUACAODEMANDA
SET DEFINE OFF;
Insert into SITUACAODEMANDA (IDSITUACAODEMANDA,NOMESITUACAO) values ('1','Ativo');
REM INSERTING into SITUACAOSERVICO
SET DEFINE OFF;
Insert into SITUACAOSERVICO (IDSITUACAOSERVICO,IDEMPRESA,NOMESITUACAOSERVICO,DATAINICIO,DATAFIM) values ('-999','1','Em Análise',null,null);
Insert into SITUACAOSERVICO (IDSITUACAOSERVICO,IDEMPRESA,NOMESITUACAOSERVICO,DATAINICIO,DATAFIM) values ('1','1','Ativo',null,null);
Insert into SITUACAOSERVICO (IDSITUACAOSERVICO,IDEMPRESA,NOMESITUACAOSERVICO,DATAINICIO,DATAFIM) values ('2','1','Inativo',null,null);
Insert into SITUACAOSERVICO (IDSITUACAOSERVICO,IDEMPRESA,NOMESITUACAOSERVICO,DATAINICIO,DATAFIM) values ('3','1','Em criação',null,null);
Insert into SITUACAOSERVICO (IDSITUACAOSERVICO,IDEMPRESA,NOMESITUACAOSERVICO,DATAINICIO,DATAFIM) values ('4','1','Em desenho',null,null);
REM INSERTING into SLAREQUISITOSLA
SET DEFINE OFF;
REM INSERTING into SOLICITACAOSERVICOEVTMON
SET DEFINE OFF;
REM INSERTING into SOLICITACAOSERVICOMUDANCA
SET DEFINE OFF;
REM INSERTING into SOLICITACAOSERVICOPROBLEMA
SET DEFINE OFF;
REM INSERTING into TABFEDERACAODADOS
SET DEFINE OFF;
REM INSERTING into TEMPLATESOLICITACAOSERVICO
SET DEFINE OFF;
Insert into TEMPLATESOLICITACAOSERVICO (IDTEMPLATE,IDENTIFICACAO,NOMETEMPLATE,NOMECLASSEDTO,NOMECLASSEACTION,NOMECLASSESERVICO,URLRECUPERACAO,HABILITADIRECIONAMENTO,HABILITASITUACAO,HABILITASOLUCAO,ALTURADIV,HABILITAURGENCIAIMPACTO,HABILITANOTIFICACAOEMAIL,HABILITAPROBLEMA,HABILITAMUDANCA,HABILITAITEMCONFIGURACAO,HABILITASOLICITACAORELACIONADA,HABILITAGRAVARECONTINUAR) values ('10','AprovacaoSolicitacaoServico','Aprovaçãoo da Solicitaçãoo de Serviço','br.com.centralit.citcorpore.bean.AprovacaoSolicitacaoServicoDTO','br.com.centralit.citcorpore.ajaxForms.AprovacaoSolicitacaoServico','br.com.centralit.citcorpore.negocio.AprovacaoSolicitacaoServicoServiceEjb','/pages/aprovacaoSolicitacaoServico/aprovacaoSolicitacaoServico.load','N','N','N','250','N','N','N','N','N','N','S');
REM INSERTING into TEMPOACORDONIVELSERVICO
SET DEFINE OFF;
Insert into TEMPOACORDONIVELSERVICO (IDACORDONIVELSERVICO,IDPRIORIDADE,IDFASE,TEMPOHH,TEMPOMM) values ('1','1','1','0','0');
Insert into TEMPOACORDONIVELSERVICO (IDACORDONIVELSERVICO,IDPRIORIDADE,IDFASE,TEMPOHH,TEMPOMM) values ('1','1','2','0','0');
Insert into TEMPOACORDONIVELSERVICO (IDACORDONIVELSERVICO,IDPRIORIDADE,IDFASE,TEMPOHH,TEMPOMM) values ('1','2','1','0','0');
Insert into TEMPOACORDONIVELSERVICO (IDACORDONIVELSERVICO,IDPRIORIDADE,IDFASE,TEMPOHH,TEMPOMM) values ('1','2','2','0','0');
Insert into TEMPOACORDONIVELSERVICO (IDACORDONIVELSERVICO,IDPRIORIDADE,IDFASE,TEMPOHH,TEMPOMM) values ('1','3','1','0','0');
Insert into TEMPOACORDONIVELSERVICO (IDACORDONIVELSERVICO,IDPRIORIDADE,IDFASE,TEMPOHH,TEMPOMM) values ('1','3','2','0','0');
Insert into TEMPOACORDONIVELSERVICO (IDACORDONIVELSERVICO,IDPRIORIDADE,IDFASE,TEMPOHH,TEMPOMM) values ('1','4','1','0','0');
Insert into TEMPOACORDONIVELSERVICO (IDACORDONIVELSERVICO,IDPRIORIDADE,IDFASE,TEMPOHH,TEMPOMM) values ('1','4','2','0','0');
Insert into TEMPOACORDONIVELSERVICO (IDACORDONIVELSERVICO,IDPRIORIDADE,IDFASE,TEMPOHH,TEMPOMM) values ('1','5','1','0','0');
Insert into TEMPOACORDONIVELSERVICO (IDACORDONIVELSERVICO,IDPRIORIDADE,IDFASE,TEMPOHH,TEMPOMM) values ('1','5','2','0','0');
Insert into TEMPOACORDONIVELSERVICO (IDACORDONIVELSERVICO,IDPRIORIDADE,IDFASE,TEMPOHH,TEMPOMM) values ('2','1','1','0','0');
Insert into TEMPOACORDONIVELSERVICO (IDACORDONIVELSERVICO,IDPRIORIDADE,IDFASE,TEMPOHH,TEMPOMM) values ('2','1','2','0','0');
Insert into TEMPOACORDONIVELSERVICO (IDACORDONIVELSERVICO,IDPRIORIDADE,IDFASE,TEMPOHH,TEMPOMM) values ('2','2','1','0','0');
Insert into TEMPOACORDONIVELSERVICO (IDACORDONIVELSERVICO,IDPRIORIDADE,IDFASE,TEMPOHH,TEMPOMM) values ('2','2','2','0','0');
Insert into TEMPOACORDONIVELSERVICO (IDACORDONIVELSERVICO,IDPRIORIDADE,IDFASE,TEMPOHH,TEMPOMM) values ('2','3','1','0','0');
Insert into TEMPOACORDONIVELSERVICO (IDACORDONIVELSERVICO,IDPRIORIDADE,IDFASE,TEMPOHH,TEMPOMM) values ('2','3','2','0','0');
Insert into TEMPOACORDONIVELSERVICO (IDACORDONIVELSERVICO,IDPRIORIDADE,IDFASE,TEMPOHH,TEMPOMM) values ('2','4','1','0','0');
Insert into TEMPOACORDONIVELSERVICO (IDACORDONIVELSERVICO,IDPRIORIDADE,IDFASE,TEMPOHH,TEMPOMM) values ('2','4','2','0','0');
Insert into TEMPOACORDONIVELSERVICO (IDACORDONIVELSERVICO,IDPRIORIDADE,IDFASE,TEMPOHH,TEMPOMM) values ('2','5','1','0','0');
Insert into TEMPOACORDONIVELSERVICO (IDACORDONIVELSERVICO,IDPRIORIDADE,IDFASE,TEMPOHH,TEMPOMM) values ('2','5','2','0','0');
Insert into TEMPOACORDONIVELSERVICO (IDACORDONIVELSERVICO,IDPRIORIDADE,IDFASE,TEMPOHH,TEMPOMM) values ('3','1','1','0','0');
Insert into TEMPOACORDONIVELSERVICO (IDACORDONIVELSERVICO,IDPRIORIDADE,IDFASE,TEMPOHH,TEMPOMM) values ('3','1','2','0','0');
Insert into TEMPOACORDONIVELSERVICO (IDACORDONIVELSERVICO,IDPRIORIDADE,IDFASE,TEMPOHH,TEMPOMM) values ('3','2','1','0','0');
Insert into TEMPOACORDONIVELSERVICO (IDACORDONIVELSERVICO,IDPRIORIDADE,IDFASE,TEMPOHH,TEMPOMM) values ('3','2','2','0','0');
Insert into TEMPOACORDONIVELSERVICO (IDACORDONIVELSERVICO,IDPRIORIDADE,IDFASE,TEMPOHH,TEMPOMM) values ('3','3','1','0','0');
Insert into TEMPOACORDONIVELSERVICO (IDACORDONIVELSERVICO,IDPRIORIDADE,IDFASE,TEMPOHH,TEMPOMM) values ('3','3','2','0','0');
Insert into TEMPOACORDONIVELSERVICO (IDACORDONIVELSERVICO,IDPRIORIDADE,IDFASE,TEMPOHH,TEMPOMM) values ('3','4','1','0','0');
Insert into TEMPOACORDONIVELSERVICO (IDACORDONIVELSERVICO,IDPRIORIDADE,IDFASE,TEMPOHH,TEMPOMM) values ('3','4','2','0','0');
Insert into TEMPOACORDONIVELSERVICO (IDACORDONIVELSERVICO,IDPRIORIDADE,IDFASE,TEMPOHH,TEMPOMM) values ('3','5','1','0','0');
Insert into TEMPOACORDONIVELSERVICO (IDACORDONIVELSERVICO,IDPRIORIDADE,IDFASE,TEMPOHH,TEMPOMM) values ('3','5','2','0','0');
REM INSERTING into TIMERS
SET DEFINE OFF;
REM INSERTING into TIMESHEET
SET DEFINE OFF;
REM INSERTING into TIPOCOMPLEXIDADE
SET DEFINE OFF;
REM INSERTING into TIPODEMANDA
SET DEFINE OFF;
REM INSERTING into TIPODEMANDASERVICO
SET DEFINE OFF;
Insert into TIPODEMANDASERVICO (IDTIPODEMANDASERVICO,NOMETIPODEMANDASERVICO,CLASSIFICACAO,DELETED) values ('1','Requisição','R',null);
Insert into TIPODEMANDASERVICO (IDTIPODEMANDASERVICO,NOMETIPODEMANDASERVICO,CLASSIFICACAO,DELETED) values ('2','O.S. (Ordem de Serviço)','O',null);
Insert into TIPODEMANDASERVICO (IDTIPODEMANDASERVICO,NOMETIPODEMANDASERVICO,CLASSIFICACAO,DELETED) values ('3','Incidente','I',null);
REM INSERTING into TIPOEVENTOSERVICO
SET DEFINE OFF;
Insert into TIPOEVENTOSERVICO (IDTIPOEVENTOSERVICO,NOMETIPOEVENTOSERVICO,DELETED) values ('1','EVENTUAL',null);
Insert into TIPOEVENTOSERVICO (IDTIPOEVENTOSERVICO,NOMETIPOEVENTOSERVICO,DELETED) values ('19','DIÁRIO',null);
Insert into TIPOEVENTOSERVICO (IDTIPOEVENTOSERVICO,NOMETIPOEVENTOSERVICO,DELETED) values ('30','SEMANAL',null);
Insert into TIPOEVENTOSERVICO (IDTIPOEVENTOSERVICO,NOMETIPOEVENTOSERVICO,DELETED) values ('31','MENSAL',null);
Insert into TIPOEVENTOSERVICO (IDTIPOEVENTOSERVICO,NOMETIPOEVENTOSERVICO,DELETED) values ('32','SEMESTRAL',null);
Insert into TIPOEVENTOSERVICO (IDTIPOEVENTOSERVICO,NOMETIPOEVENTOSERVICO,DELETED) values ('33','ANUAL',null);
REM INSERTING into TIPOITEMCFGCARACTERISTICA
SET DEFINE OFF;
REM INSERTING into TIPOITEMCONFIGURACAO
SET DEFINE OFF;
REM INSERTING into TIPOOS
SET DEFINE OFF;
REM INSERTING into TIPOPROBLEMAATENDIMENTO
SET DEFINE OFF;
REM INSERTING into TIPOPRODUTO
SET DEFINE OFF;
REM INSERTING into TIPOSATIVIDADES
SET DEFINE OFF;
REM INSERTING into TIPOSERVICO
SET DEFINE OFF;
Insert into TIPOSERVICO (IDTIPOSERVICO,IDEMPRESA,NOMETIPOSERVICO,SITUACAO) values ('1','1','A DEFINIR','A');
REM INSERTING into TIPOSOFTWARE
SET DEFINE OFF;
Insert into TIPOSOFTWARE (IDTIPOSOFTWARE, NOME) values ('1', 'Anti-virus');
Insert into TIPOSOFTWARE (IDTIPOSOFTWARE, NOME) values ('2', 'Auxiliar de escritório');
Insert into TIPOSOFTWARE (IDTIPOSOFTWARE, NOME) values ('3', 'Comunicador Instantâneo');
Insert into TIPOSOFTWARE (IDTIPOSOFTWARE, NOME) values ('4', 'Editor de Imagem');
Insert into TIPOSOFTWARE (IDTIPOSOFTWARE, NOME) values ('5', 'Editor de Texto');
Insert into TIPOSOFTWARE (IDTIPOSOFTWARE, NOME) values ('6', 'Navegador');
Insert into TIPOSOFTWARE (IDTIPOSOFTWARE, NOME) values ('7', 'Sistema Operacional');
Insert into TIPOSOFTWARE (IDTIPOSOFTWARE, NOME) values ('8', 'Outros');
REM INSERTING into TIPOUNIDADE
SET DEFINE OFF;
REM INSERTING into UFS
SET DEFINE OFF;
Insert into UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) values ('0',' -- Indefinida -- ','--',null,'1');
Insert into UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) values ('1','Distrito Federal','DF',null,'1');
Insert into UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) values ('2','São Paulo','SP',null,'1');
Insert into UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) values ('3','Rio de Janeiro','RJ',null,'1');
Insert into UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) values ('4','Goiás','GO',null,'1');
Insert into UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) values ('5','Tocantins','TO',null,'1');
Insert into UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) values ('6','Minas Gerais','MG',null,'1');
Insert into UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) values ('7','Paraná','PR',null,'1');
Insert into UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) values ('8','Espirito Santo','ES',null,'1');
Insert into UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) values ('9','Acre','AC',null,'1');
Insert into UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) values ('10','Alagoas','AL',null,'1');
Insert into UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) values ('11','Amapá','AP',null,'1');
Insert into UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) values ('12','Amazonas','AM',null,'1');
Insert into UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) values ('13','Bahia','BA',null,'1');
Insert into UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) values ('14','Ceará','CE',null,'1');
Insert into UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) values ('15','Maranhão','MA',null,'1');
Insert into UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) values ('16','Mato Grosso','MT',null,'1');
Insert into UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) values ('17','Mato Grosso do Sul','MS',null,'1');
Insert into UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) values ('18','Paraíba','PB',null,'1');
Insert into UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) values ('19','Pará','PA',null,'1');
Insert into UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) values ('20','Pernambuco','PE',null,'1');
Insert into UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) values ('21','Piauí','PI',null,'1');
Insert into UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) values ('22','Rio Grande do Norte','RN',null,'1');
Insert into UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) values ('23','Rio Grande do Sul','RS',null,'1');
Insert into UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) values ('24','Rondônia','RO',null,'1');
Insert into UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) values ('25','Roraima','RR',null,'1');
Insert into UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) values ('26','Santa Catarina','SC',null,'1');
Insert into UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) values ('27','Sergipe','SE',null,'1');
REM INSERTING into UNIDADE
SET DEFINE OFF;
Insert into UNIDADE (IDUNIDADE,IDUNIDADEPAI,IDTIPOUNIDADE,IDEMPRESA,NOME,DATAINICIO,DATAFIM,EMAIL,IDENDERECO,ACEITAENTREGAPRODUTO) values ('1',null,null,'1','Default',to_date('01/01/12','DD/MM/RR'),null,' ',null,null);
REM INSERTING into UNIDADEBASEITEMCONFIGURACAO
SET DEFINE OFF;
REM INSERTING into UNIDADEMEDIDA
SET DEFINE OFF;
REM INSERTING into UNIDADESACCSERVICOS
SET DEFINE OFF;
REM INSERTING into URGENCIA
SET DEFINE OFF;
Insert into URGENCIA (IDURGENCIA,NIVELURGENCIA,SIGLAURGENCIA) values ('1','Crítica','C ');
Insert into URGENCIA (IDURGENCIA,NIVELURGENCIA,SIGLAURGENCIA) values ('2','Alta','A ');
Insert into URGENCIA (IDURGENCIA,NIVELURGENCIA,SIGLAURGENCIA) values ('3','Média','M ');
Insert into URGENCIA (IDURGENCIA,NIVELURGENCIA,SIGLAURGENCIA) values ('4','Baixa','B ');
REM INSERTING into USUARIO
SET DEFINE OFF;
Insert into USUARIO (IDUSUARIO,IDUNIDADE,IDEMPREGADO,IDEMPRESA,LOGIN,NOME,SENHA,STATUS,LDAP,ULTIMOACESSOPORTAL) values ('1',null,'1','1','admin','Administrador','511574e821fa42fb7d31796ab74c1c721098a0df','A',null,null);
Insert into USUARIO (IDUSUARIO,IDUNIDADE,IDEMPREGADO,IDEMPRESA,LOGIN,NOME,SENHA,STATUS,LDAP,ULTIMOACESSOPORTAL) values ('2',null,'2','1','default','Default','40bd001563085fc35165329ea1ff5c5ecbdbbeef','A',null,null);
Insert into USUARIO (IDUSUARIO,IDUNIDADE,IDEMPREGADO,IDEMPRESA,LOGIN,NOME,SENHA,STATUS,LDAP,ULTIMOACESSOPORTAL) values ('3',null,'3','1','consultor','Consultor','04a991894ac6cdd7ef06d049feb9f0b9cc6c9004','A',null,null);
REM INSERTING into USUARIOITEMCONFIGURACAO
SET DEFINE OFF;
REM INSERTING into VALOR
SET DEFINE OFF;
REM INSERTING into VALORAJUSTEGLOSA
SET DEFINE OFF;
REM INSERTING into VALORSERVICOCONTRATO
SET DEFINE OFF;
REM INSERTING into VALORVISAOCAMPOSNEGOCIO
SET DEFINE OFF;
REM INSERTING into VERSAO
SET DEFINE OFF;
Insert into VERSAO (IDVERSAO,NOMEVERSAO) values ('1','2.0.5');
REM INSERTING into VINCULAOSINCIDENTE
SET DEFINE OFF;
REM INSERTING into VINCULOVISAO
SET DEFINE OFF;
REM INSERTING into VISAO
SET DEFINE OFF;
REM INSERTING into VISAORELACIONADA
SET DEFINE OFF;
--------------------------------------------------------
--  DDL for Index AK_KEY_1_CATALAGO
--------------------------------------------------------

  CREATE UNIQUE INDEX "AK_KEY_1_CATALAGO" ON "CATALOGOSERVICO" ("IDCATALOGOSERVICO");
--------------------------------------------------------
--  DDL for Index BASEITEMCONFIGURACAO
--------------------------------------------------------

  CREATE INDEX "BASEITEMCONFIGURACAO" ON "HISTORICOTENTATIVA" ("IDHISTORICOTENTATIVA", "IDBASEITEMCONFIGURACAO");
--------------------------------------------------------
--  DDL for Index EMPREGADO
--------------------------------------------------------

  CREATE INDEX "EMPREGADO" ON "HISTORICOTENTATIVA" ("IDHISTORICOTENTATIVA", "IDEMPREGADO");
--------------------------------------------------------
--  DDL for Index EVENTO
--------------------------------------------------------

  CREATE INDEX "EVENTO" ON "HISTORICOTENTATIVA" ("IDHISTORICOTENTATIVA", "IDEVENTO");
--------------------------------------------------------
--  DDL for Index FK_ALERTAGR_REFERENCE_ALERTA
--------------------------------------------------------

  CREATE INDEX "FK_ALERTAGR_REFERENCE_ALERTA" ON "NOTIFICACAOGRUPO" ("IDNOTIFICACAO");
--------------------------------------------------------
--  DDL for Index FK_ALERTAGR_REFERENCE_GRUPO
--------------------------------------------------------

  CREATE INDEX "FK_ALERTAGR_REFERENCE_GRUPO" ON "NOTIFICACAOGRUPO" ("IDGRUPO");
--------------------------------------------------------
--  DDL for Index FK_ALERTAUS_REFERENCE_ALERTA
--------------------------------------------------------

  CREATE INDEX "FK_ALERTAUS_REFERENCE_ALERTA" ON "NOTIFICACAOUSUARIO" ("IDNOTIFICACAO");
--------------------------------------------------------
--  DDL for Index FK_ALERTAUS_REFERENCE_USUARIO
--------------------------------------------------------

  CREATE INDEX "FK_ALERTAUS_REFERENCE_USUARIO" ON "NOTIFICACAOUSUARIO" ("IDUSUARIO");
--------------------------------------------------------
--  DDL for Index FK_APROVACAO_JUSTIFICATIVA_IDX
--------------------------------------------------------

  CREATE INDEX "FK_APROVACAO_JUSTIFICATIVA_IDX" ON "APROVACAOSOLICITACAOSERVICO" ("IDJUSTIFICATIVA");
--------------------------------------------------------
--  DDL for Index FK_APROVACAO_RESPONSAVEL_IDX
--------------------------------------------------------

  CREATE INDEX "FK_APROVACAO_RESPONSAVEL_IDX" ON "APROVACAOSOLICITACAOSERVICO" ("IDRESPONSAVEL");
--------------------------------------------------------
--  DDL for Index FK_APROVACAO_SOLICITACAO_IDX
--------------------------------------------------------

  CREATE INDEX "FK_APROVACAO_SOLICITACAO_IDX" ON "APROVACAOSOLICITACAOSERVICO" ("IDSOLICITACAOSERVICO");
--------------------------------------------------------
--  DDL for Index FK_APROVACAO_TAREFA_IDX
--------------------------------------------------------

  CREATE INDEX "FK_APROVACAO_TAREFA_IDX" ON "APROVACAOSOLICITACAOSERVICO" ("IDTAREFA");
--------------------------------------------------------
--  DDL for Index FK_AUTORALTERACAO
--------------------------------------------------------

  CREATE INDEX "FK_AUTORALTERACAO" ON "HISTORICOIC" ("IDAUTORALTERACAO");
--------------------------------------------------------
--  DDL for Index FK_CARGO_FUNCIONARIO
--------------------------------------------------------

  CREATE INDEX "FK_CARGO_FUNCIONARIO" ON "EMPREGADOS" ("IDCARGO");
--------------------------------------------------------
--  DDL for Index FK_CATEGORI_REFERENCE_BPM_TIPO
--------------------------------------------------------

  CREATE INDEX "FK_CATEGORI_REFERENCE_BPM_TIPO" ON "CATEGORIAMUDANCA" ("IDTIPOFLUXO");
--------------------------------------------------------
--  DDL for Index FK_CATEGORI_REFERENCE_CALENDAR
--------------------------------------------------------

  CREATE INDEX "FK_CATEGORI_REFERENCE_CALENDAR" ON "CATEGORIAMUDANCA" ("IDCALENDARIO");
--------------------------------------------------------
--  DDL for Index FK_CATEGORI_REFERENCE_GRUPO
--------------------------------------------------------

  CREATE INDEX "FK_CATEGORI_REFERENCE_GRUPO" ON "CATEGORIAMUDANCA" ("IDGRUPONIVEL1");
--------------------------------------------------------
--  DDL for Index FK_CATEGORI_REFERENCE_GRUPO_01
--------------------------------------------------------

  CREATE INDEX "FK_CATEGORI_REFERENCE_GRUPO_01" ON "CATEGORIAMUDANCA" ("IDGRUPOEXECUTOR");
--------------------------------------------------------
--  DDL for Index FK_CATEGORI_REFERENCE_MODELOSE
--------------------------------------------------------

  CREATE INDEX "FK_CATEGORI_REFERENCE_MODELOSE" ON "CATEGORIAMUDANCA" ("IDMODELOEMAILFINALIZACAO");
--------------------------------------------------------
--  DDL for Index FK_CATEGORI_REFERENCE_MODELO_1
--------------------------------------------------------

  CREATE INDEX "FK_CATEGORI_REFERENCE_MODELO_1" ON "CATEGORIAMUDANCA" ("IDMODELOEMAILCRIACAO");
--------------------------------------------------------
--  DDL for Index FK_CATEGORI_REFERENCE_MODELO_2
--------------------------------------------------------

  CREATE INDEX "FK_CATEGORI_REFERENCE_MODELO_2" ON "CATEGORIAMUDANCA" ("IDMODELOEMAILACOES");
--------------------------------------------------------
--  DDL for Index FK_CIDADES_1
--------------------------------------------------------

  CREATE INDEX "FK_CIDADES_1" ON "CIDADES" ("IDUF");
--------------------------------------------------------
--  DDL for Index FK_CLASSEITEMCONFIGURACAO
--------------------------------------------------------

  CREATE INDEX "FK_CLASSEITEMCONFIGURACAO" ON "HISTORICOIC" ("IDCLASSEITEMCONFIGURACAO");
--------------------------------------------------------
--  DDL for Index FK_COMANDO
--------------------------------------------------------

  CREATE INDEX "FK_COMANDO" ON "COMANDOSISTEMAOPERACIONAL" ("IDCOMANDO");
--------------------------------------------------------
--  DDL for Index FK_COMENTARIO_BASECONHECIMENTO
--------------------------------------------------------

  CREATE INDEX "FK_COMENTARIO_BASECONHECIMENTO" ON "COMENTARIOS" ("IDBASECONHECIMENTO");
--------------------------------------------------------
--  DDL for Index FK_EMPREGADO_IDX
--------------------------------------------------------

  CREATE INDEX "FK_EMPREGADO_IDX" ON "APROVACAOMUDANCA" ("IDEMPREGADO");
--------------------------------------------------------
--  DDL for Index FK_EXECUCAO_REFERENCE_BPM_FLUX
--------------------------------------------------------

  CREATE INDEX "FK_EXECUCAO_REFERENCE_BPM_FLUX" ON "EXECUCAOMUDANCA" ("IDFLUXO");
--------------------------------------------------------
--  DDL for Index FK_EXECUCAO_REFERENCE_BPM_INST
--------------------------------------------------------

  CREATE INDEX "FK_EXECUCAO_REFERENCE_BPM_INST" ON "EXECUCAOMUDANCA" ("IDINSTANCIAFLUXO");
--------------------------------------------------------
--  DDL for Index FK_EXECUCAO_REFERENCE_REQUISIC
--------------------------------------------------------

  CREATE INDEX "FK_EXECUCAO_REFERENCE_REQUISIC" ON "EXECUCAOMUDANCA" ("IDREQUISICAOMUDANCA");
--------------------------------------------------------
--  DDL for Index FK_FAMILIAITEMCONFIGURACAO
--------------------------------------------------------

  CREATE INDEX "FK_FAMILIAITEMCONFIGURACAO" ON "HISTORICOIC" ("IDFAMILIAITEMCONFIGURACAO");
--------------------------------------------------------
--  DDL for Index FK_FORN_END
--------------------------------------------------------

  CREATE INDEX "FK_FORN_END" ON "FORNECEDOR" ("IDENDERECO");
--------------------------------------------------------
--  DDL for Index FK_HISTORIC_REFERENCE_EXECUCAO
--------------------------------------------------------

  CREATE INDEX "FK_HISTORIC_REFERENCE_EXECUCAO" ON "HISTORICOEXECUCAO" ("IDEXECUCAO");
--------------------------------------------------------
--  DDL for Index FK_IDBASECONHECIMENTO
--------------------------------------------------------

  CREATE INDEX "FK_IDBASECONHECIMENTO" ON "REQUISICAOMUDANCA" ("IDBASECONHECIMENTO");
--------------------------------------------------------
--  DDL for Index FK_IDBASECONHECIMENTO_ITEMCONF
--------------------------------------------------------

  CREATE INDEX "FK_IDBASECONHECIMENTO_ITEMCONF" ON "ITEMCONFIGURACAO" ("IDBASECONHECIMENTO");
--------------------------------------------------------
--  DDL for Index FK_IDPROPRIETARIO
--------------------------------------------------------

  CREATE INDEX "FK_IDPROPRIETARIO" ON "ITEMCONFIGURACAO" ("IDPROPRIETARIO");
--------------------------------------------------------
--  DDL for Index FK_IDTESTE
--------------------------------------------------------

  CREATE INDEX "FK_IDTESTE" ON "COLECAO" ("IDTESTE");
--------------------------------------------------------
--  DDL for Index FK_INFOCATA_REFERENCE_CATALAGO
--------------------------------------------------------

  CREATE INDEX "FK_INFOCATA_REFERENCE_CATALAGO" ON "INFOCATALOGOSERVICO" ("IDCATALOGOSERVICO");
--------------------------------------------------------
--  DDL for Index FK_INFOCATA_REFERENCE_CONTRATO
--------------------------------------------------------

  CREATE INDEX "FK_INFOCATA_REFERENCE_CONTRATO" ON "CATALOGOSERVICO" ("IDCONTRATO");
--------------------------------------------------------
--  DDL for Index FK_ITEMCFGS_REFERENCE_ITEMCONF
--------------------------------------------------------

  CREATE INDEX "FK_ITEMCFGS_REFERENCE_ITEMCONF" ON "ITEMCFGSOLICITACAOSERV" ("IDITEMCONFIGURACAO");
--------------------------------------------------------
--  DDL for Index FK_ITEMCFGS_REFERENCE_SOLICITA
--------------------------------------------------------

  CREATE INDEX "FK_ITEMCFGS_REFERENCE_SOLICITA" ON "ITEMCFGSOLICITACAOSERV" ("IDSOLICITACAOSERVICO");
--------------------------------------------------------
--  DDL for Index FK_ITEMCONF_ASSOCIATI_ITEMCONF
--------------------------------------------------------

  CREATE INDEX "FK_ITEMCONF_ASSOCIATI_ITEMCONF" ON "ITEMCONFIGURACAO" ("IDITEMCONFIGURACAOPAI");
--------------------------------------------------------
--  DDL for Index FK_ITEMCONFIGURACAO
--------------------------------------------------------

  CREATE INDEX "FK_ITEMCONFIGURACAO" ON "HISTORICOIC" ("IDITEMCONFIGURACAO");
--------------------------------------------------------
--  DDL for Index FK_ITEMCONF_REFERENCE_TIPOITEM
--------------------------------------------------------

  CREATE INDEX "FK_ITEMCONF_REFERENCE_TIPOITEM" ON "ITEMCONFIGURACAO" ("IDTIPOITEMCONFIGURACAO");
--------------------------------------------------------
--  DDL for Index FK_LOCALIDA_REFERENCE_LOCALIDA
--------------------------------------------------------

  CREATE INDEX "FK_LOCALIDA_REFERENCE_LOCALIDA" ON "LOCALIDADEUNIDADE" ("IDLOCALIDADE");
--------------------------------------------------------
--  DDL for Index FK_MIDIA
--------------------------------------------------------

  CREATE INDEX "FK_MIDIA" ON "MIDIASOFTWARE" ("IDMIDIA");
--------------------------------------------------------
--  DDL for Index FK_OCORRENC_REFERENCE_BPM_ITEM
--------------------------------------------------------

  CREATE INDEX "FK_OCORRENC_REFERENCE_BPM_ITEM" ON "OCORRENCIAMUDANCA" ("IDITEMTRABALHO");
--------------------------------------------------------
--  DDL for Index FK_OCORRENC_REFERENCE_JUSTIFIC
--------------------------------------------------------

  CREATE INDEX "FK_OCORRENC_REFERENCE_JUSTIFIC" ON "OCORRENCIAMUDANCA" ("IDJUSTIFICATIVA");
--------------------------------------------------------
--  DDL for Index FK_OCORRENC_REFERENCE_REQUISIC
--------------------------------------------------------

  CREATE INDEX "FK_OCORRENC_REFERENCE_REQUISIC" ON "OCORRENCIAMUDANCA" ("IDREQUISICAOMUDANCA");
--------------------------------------------------------
--  DDL for Index FK_POST_1_IDX
--------------------------------------------------------

  CREATE INDEX "FK_POST_1_IDX" ON "POST" ("IDCATEGORIAPOST");
--------------------------------------------------------
--  DDL for Index FK_REF_ASC_REC
--------------------------------------------------------

  CREATE INDEX "FK_REF_ASC_REC" ON "ACORDOSERVICOCONTRATO" ("IDRECURSO");
--------------------------------------------------------
--  DDL for Index FK_REF_CONHIC_BC
--------------------------------------------------------

  CREATE INDEX "FK_REF_CONHIC_BC" ON "CONHECIMENTOIC" ("IDBASECONHECIMENTO");
--------------------------------------------------------
--  DDL for Index FK_REF_CONHMUD_BC
--------------------------------------------------------

  CREATE INDEX "FK_REF_CONHMUD_BC" ON "CONHECIMENTOMUDANCA" ("IDBASECONHECIMENTO");
--------------------------------------------------------
--  DDL for Index FK_REF_CONHPB_BC
--------------------------------------------------------

  CREATE INDEX "FK_REF_CONHPB_BC" ON "CONHECIMENTOPROBLEMA" ("IDBASECONHECIMENTO");
--------------------------------------------------------
--  DDL for Index FK_REF_CONHSS_BC
--------------------------------------------------------

  CREATE INDEX "FK_REF_CONHSS_BC" ON "CONHECIMENTOSOLICITACAOSERVICO" ("IDBASECONHECIMENTO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_100
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_100" ON "SOLICITACAOSERVICO" ("IDTIPOPROBLEMA");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_101
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_101" ON "PRIORIDADESERVICOUNIDADE" ("IDSERVICOCONTRATO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_102
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_102" ON "ACORDONIVELSERVICO_HIST" ("IDPRIORIDADEPADRAO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_102_1
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_102_1" ON "ACORDONIVELSERVICO" ("IDPRIORIDADEPADRAO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_103
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_103" ON "SOLICITACAOSERVICO" ("IDSERVICOCONTRATO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_104
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_104" ON "SOLICITACAOSERVICO" ("IDORIGEM");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_105
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_105" ON "SOLICITACAOSERVICO" ("IDRESPONSAVEL");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_106
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_106" ON "BPM_OBJETOINSTANCIAFLUXO" ("IDOBJETONEGOCIO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_107
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_107" ON "BPM_ITEMTRABALHOFLUXO" ("IDINSTANCIA");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_108
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_108" ON "PERMISSOESFLUXO" ("IDTIPOFLUXO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_109
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_109" ON "BPM_OBJETOINSTANCIAFLUXO" ("IDITEMTRABALHO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_110
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_110" ON "BPM_ITEMTRABALHOFLUXO" ("IDRESPONSAVELATUAL");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_111
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_111" ON "SOLICITACAOSERVICO" ("IDSOLICITANTE");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_112
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_112" ON "BPM_ITEMTRABALHOFLUXO" ("IDELEMENTO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_115
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_115" ON "BPM_FLUXO" ("IDTIPOFLUXO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_116
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_116" ON "EXECUCAOSOLICITACAO" ("IDSOLICITACAOSERVICO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_117
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_117" ON "FLUXOSERVICO" ("IDFASE");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_118
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_118" ON "EXECUCAOSOLICITACAO" ("IDFASE");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_119
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_119" ON "BPM_ATRIBUICAOFLUXO" ("IDITEMTRABALHO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_120
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_120" ON "SOLICITACAOSERVICO" ("IDFASEATUAL");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_121
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_121" ON "HTMLCODEVISAO" ("IDVISAO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_122
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_122" ON "BPM_INSTANCIAFLUXO" ("IDFLUXO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_123
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_123" ON "SOLICITACAOSERVICO" ("IDUNIDADE");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_124
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_124" ON "SERVICO" ("IDTIPOEVENTOSERVICO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_125
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_125" ON "SERVICO" ("IDTIPODEMANDASERVICO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_126
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_126" ON "BPM_ELEMENTOFLUXO" ("IDFLUXO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_126_1
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_126_1" ON "SERVICO" ("IDLOCALEXECUCAOSERVICO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_127
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_127" ON "ATIVIDADESSERVICOCONTRATO" ("IDSERVICOCONTRATO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_127_1
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_127_1" ON "BPM_OBJETOINSTANCIAFLUXO" ("IDINSTANCIA");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_128
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_128" ON "ATIVIDADESOS" ("IDOS");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_128_1
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_128_1" ON "EXECUCAOSOLICITACAO" ("IDFLUXO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_129
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_129" ON "ATIVIDADESOS" ("IDATIVIDADESERVICOCONTRATO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_130
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_130" ON "EXECUCAOSOLICITACAO" ("IDINSTANCIAFLUXO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_130_2
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_130_2" ON "HISTORICOTENTATIVA" ("IDITEMCONFIGURACAO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_131
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_131" ON "HISTORICOTENTATIVA" ("IDBASEITEMCONFIGURACAO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_133
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_133" ON "BPM_SEQUENCIAFLUXO" ("IDELEMENTODESTINO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_133_2
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_133_2" ON "HISTORICOTENTATIVA" ("IDEVENTO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_134
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_134" ON "BPM_SEQUENCIAFLUXO" ("IDFLUXO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_135
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_135" ON "BPM_ATRIBUICAOFLUXO" ("IDUSUARIO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_136
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_136" ON "HISTORICOTENTATIVA" ("IDEMPREGADO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_137
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_137" ON "JUSTIFICACAOFALHA" ("IDHISTORICOTENTATIVA");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_137_2
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_137_2" ON "BPM_ATRIBUICAOFLUXO" ("IDGRUPO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_138
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_138" ON "PERFILACESSOMENU" ("IDPERFILACESSO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_138_2
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_138_2" ON "SOLICITACAOSERVICO" ("IDGRUPOATUAL");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_139
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_139" ON "PERFILACESSOMENU" ("IDMENU");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_22
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_22" ON "OS" ("IDCONTRATO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_24
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_24" ON "OS" ("IDCLASSIFICACAOOS");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_25
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_25" ON "ITEMCOTACAO" ("IDCOTACAO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_26
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_26" ON "CONTRATOS" ("IDMOEDA");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_26_2
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_26_2" ON "CONTRATOS_HIST" ("IDMOEDA");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_27
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_27" ON "OS" ("IDSERVICOCONTRATO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_28
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_28" ON "COLETAPRECO" ("IDITEMCOTACAO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_3
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_3" ON "CONTRATOS" ("IDCLIENTE");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_3_2
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_3_2" ON "CONTRATOS_HIST" ("IDCLIENTE");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_33
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_33" ON "CRITERIOCOTACAO" ("IDCRITERIO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_35
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_35" ON "PARECER" ("IDJUSTIFICATIVA");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_36
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_36" ON "AVALIACAOCOLETAPRECO" ("IDCRITERIO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_37
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_37" ON "SERVICO" ("IDIMPORTANCIANEGOCIO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_38
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_38" ON "SERVICOCONTRATO" ("IDCONDICAOOPERACAO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_39
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_39" ON "ACORDONIVELSERVICO" ("IDSERVICOCONTRATO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_40
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_40" ON "SERVICOCONTRATO" ("IDSERVICO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_41
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_41" ON "SERVICOCONTRATO" ("IDCONTRATO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_42
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_42" ON "SERVICO" ("IDEMPRESA");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_49
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_49" ON "AVALIACAOPEDIDO" ("IDCRITERIO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_50
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_50" ON "TEMPOACORDONIVELSERVICO" ("IDPRIORIDADE");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_504
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_504" ON "GLOSAOS" ("IDOS");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_505
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_505" ON "FATURA" ("IDCONTRATO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_508
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_508" ON "FATURAOS" ("IDOS");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_509
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_509" ON "ACORDONIVELSERVICOCONTRATO" ("IDCONTRATO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_510
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_510" ON "FATURAAPURACAOANS" ("IDFATURA");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_511
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_511" ON "FATURAAPURACAOANS" ("IDACORDONIVELSERVICOCONTRATO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_52
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_52" ON "BPM_HISTORICOITEMTRABALHO" ("IDITEMTRABALHO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_53
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_53" ON "BPM_HISTORICOITEMTRABALHO" ("IDRESPONSAVEL");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_531
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_531" ON "SOLICITACAOSERVICO" ("IDCAUSAINCIDENTE");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_532
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_532" ON "SOLICITACAOSERVICO" ("IDCATEGORIASOLUCAO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_54
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_54" ON "BPM_HISTORICOITEMTRABALHO" ("IDUSUARIO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_540
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_540" ON "EXCECAOCALENDARIO" ("IDCALENDARIO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_541
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_541" ON "EXCECAOCALENDARIO" ("IDJORNADA");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_542
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_542" ON "PESQUISASATISFACAO" ("IDSOLICITACAOSERVICO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_542_1
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_542_1" ON "REABERTURASOLICITACAO" ("IDRESPONSAVEL");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_546
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_546" ON "SERVICOCONTRATO" ("IDGRUPONIVEL1");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_547
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_547" ON "SERVICOCONTRATO" ("IDMODELOEMAILCRIACAO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_548
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_548" ON "SERVICOCONTRATO" ("IDMODELOEMAILFINALIZACAO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_549
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_549" ON "SERVICOCONTRATO" ("IDMODELOEMAILACOES");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_55
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_55" ON "BPM_HISTORICOITEMTRABALHO" ("IDGRUPO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_550
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_550" ON "SOLICITACAOSERVICO" ("IDGRUPONIVEL1");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_552
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_552" ON "REQUISITOSLA" ("IDEMPREGADO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_554
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_554" ON "SLAREQUISITOSLA" ("IDACORDONIVELSERVICO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_559
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_559" ON "SERVICOCONTRATO" ("IDGRUPOEXECUTOR");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_56
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_56" ON "CAUSAINCIDENTE" ("IDCAUSAINCIDENTEPAI");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_560
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_560" ON "SERVICOCONTRATO" ("IDCALENDARIO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_561
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_561" ON "SOLICITACAOSERVICO" ("IDCALENDARIO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_562
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_562" ON "OCORRENCIASOLICITACAO" ("IDJUSTIFICATIVA");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_563
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_563" ON "ATIVIDADEPERIODICA" ("IDSOLICITACAOSERVICO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_564
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_564" ON "OCORRENCIASOLICITACAO" ("IDSOLICITACAOSERVICO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_565
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_565" ON "OCORRENCIASOLICITACAO" ("IDITEMTRABALHO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_567
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_567" ON "SERVICO" ("IDBASECONHECIMENTO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_569
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_569" ON "CONTRATOSCOLABORADORES" ("IDCONTRATO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_57
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_57" ON "CATEGORIASOLUCAO" ("IDCATEGORIASOLUCAOPAI");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_571
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_571" ON "UNIDADESACCSERVICOS" ("IDSERVICO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_572
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_572" ON "ACORDONIVELSERVICO" ("IDFORMULA");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_573
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_573" ON "ACORDONIVELSERVICOCONTRATO" ("IDFORMULA");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_579
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_579" ON "OSATIVIDADEPERIODICA" ("IDATIVIDADEPERIODICA");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_580
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_580" ON "OSATIVIDADEPERIODICA" ("IDOS");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_60
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_60" ON "CONTRATOS" ("IDFORNECEDOR");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_60_2
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_60_2" ON "CONTRATOS_HIST" ("IDFORNECEDOR");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_604
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_604" ON "FAIXAVALORESRECURSO" ("IDRECURSO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_605
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_605" ON "RECURSO" ("IDRECURSOPAI");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_606
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_606" ON "APURACAOVALORESRECURSO" ("IDRECURSO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_608
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_608" ON "CONTADORACESSO" ("IDUSUARIO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_610
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_610" ON "PROBLEMAITEMCONFIGURACAO" ("IDITEMCONFIGURACAO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_611
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_611" ON "PROBLEMAMUDANCA" ("IDREQUISICAOMUDANCA");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_612
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_612" ON "PROBLEMA" ("IDPROBLEMAITEMCONFIGURACAO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_613
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_613" ON "PROBLEMAITEMCONFIGURACAO" ("IDPROBLEMA");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_614
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_614" ON "PROBLEMA" ("IDPROBLEMAMUDANCA");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_615
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_615" ON "PROBLEMAMUDANCA" ("IDPROBLEMA");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_616
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_616" ON "PROBLEMA" ("IDCATEGORIAPROBLEMA");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_617
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_617" ON "CATEGORIAPROBLEMA" ("CAT_IDCATEGORIAPROBLEMA");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_618
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_618" ON "GLOSAOS" ("IDACORDONIVELSERVICO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_619
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_619" ON "OS" ("IDOSPAI");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_620
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_620" ON "MATRIZVISAO" ("IDVISAO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_621
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_621" ON "MATRIZVISAO" ("IDOBJETONEGOCIO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_622
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_622" ON "CONTATOSOLICITACAOSERVICO" ("IDLOCALIDADE");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_622_1
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_622_1" ON "MATRIZVISAO" ("IDCAMPOSOBJETONEGOCIO1");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_623
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_623" ON "MATRIZVISAO" ("IDCAMPOSOBJETONEGOCIO2");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_624
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_624" ON "MATRIZVISAO" ("IDCAMPOSOBJETONEGOCIO3");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_625
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_625" ON "ITEMREQUISICAOPRODUTO" ("IDSOLICITACAOSERVICO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_626
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_626" ON "REQUISICAOPRODUTO" ("IDPROJETO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_627
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_627" ON "ACORDOSERVICOCONTRATO" ("IDACORDONIVELSERVICO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_628
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_628" ON "ACORDOSERVICOCONTRATO" ("IDSERVICOCONTRATO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_633
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_633" ON "COTACAO" ("IDEMPRESA");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_635
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_635" ON "COLETAPRECO" ("IDRESPONSAVEL");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_636
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_636" ON "COLETAPRECO" ("IDFORNECEDOR");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_638
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_638" ON "PEDIDOCOMPRA" ("IDFORNECEDOR");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_642
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_642" ON "SERVICO" ("IDTEMPLATEACOMPANHAMENTO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_643
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_643" ON "ITEMREQUISICAOPRODUTO" ("IDPARECERVALIDACAO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_644
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_644" ON "ITEMREQUISICAOPRODUTO" ("IDPARECERAUTORIZACAO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_646
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_646" ON "REQUISICAOPRODUTO" ("IDCENTROCUSTO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_647
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_647" ON "LIMITEALCADA" ("IDALCADA");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_649
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_649" ON "LIMITEALCADA" ("IDGRUPO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_650
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_650" ON "PARECER" ("IDALCADA");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_655
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_655" ON "RELACIONAMENTOPRODUTO" ("IDTIPOPRODUTORELACIONADO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_658
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_658" ON "TIPOPRODUTO" ("IDCATEGORIA");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_660
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_660" ON "FORNECEDORPRODUTO" ("IDFORNECEDOR");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_661
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_661" ON "MARCA" ("IDFABRICANTE");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_662
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_662" ON "ALCADACENTRORESULTADO" ("IDCENTRORESULTADO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_663
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_663" ON "ALCADACENTRORESULTADO" ("IDEMPREGADO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_664
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_664" ON "TIPOPRODUTO" ("IDUNIDADEMEDIDA");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_665
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_665" ON "VALORSERVICOCONTRATO" ("IDSERVICOCONTRATO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_668
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_668" ON "REQUISICAOPRODUTO" ("IDENDERECOENTREGA");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_669
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_669" ON "ITEMREQUISICAOPRODUTO" ("IDPRODUTO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_670
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_670" ON "CATEGORIAPRODUTO" ("IDCATEGORIAPAI");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_671
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_671" ON "PRODUTO" ("IDTIPOPRODUTO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_672
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_672" ON "PRODUTO" ("IDMARCA");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_673
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_673" ON "ALCADACENTRORESULTADO" ("IDALCADA");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_674
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_674" ON "ITEMCOTACAO" ("IDPRODUTO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_675
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_675" ON "FORNECEDORPRODUTO" ("IDMARCA");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_676
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_676" ON "ITEMREQUISICAOPRODUTO" ("IDUNIDADEMEDIDA");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_677
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_677" ON "ITEMREQUISICAOPRODUTO" ("IDCATEGORIAPRODUTO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_678
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_678" ON "AVALIACAOFORNECEDOR" ("IDFORNECEDOR");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_680
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_680" ON "CRITERIOAVALIACAOFORNECEDOR" ("IDCRITERIO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_683
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_683" ON "AVALIACAOFORNECEDOR" ("IDRESPONSAVEL");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_685
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_685" ON "FORNECEDORCOTACAO" ("IDFORNECEDOR");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_688
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_688" ON "COTACAOITEMREQUISICAO" ("IDCOTACAO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_689
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_689" ON "AVALIACAOCOLETAPRECO" ("IDCOLETAPRECO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_6896
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_6896" ON "AVALIACAOREFERENCIAFORNECEDOR" ("IDEMPREGADO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_690
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_690" ON "ITEMCOTACAO" ("IDUNIDADEMEDIDA");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_691
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_691" ON "ITEMCOTACAO" ("IDCATEGORIAPRODUTO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_692
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_692" ON "ITEMREQUISICAOPRODUTO" ("IDITEMCOTACAO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_694
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_694" ON "COTACAOITEMREQUISICAO" ("IDPARECER");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_695
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_695" ON "COLETAPRECO" ("IDRESPRESULTADO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_698
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_698" ON "COLETAPRECO" ("IDJUSTIFRESULTADO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_699
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_699" ON "COTACAOITEMREQUISICAO" ("IDITEMTRABALHOAPROVACAO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_701
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_701" ON "ENTREGAITEMREQUISICAO" ("IDPEDIDO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_701_1
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_701_1" ON "AVALIACAOPEDIDO" ("IDPEDIDO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_702
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_702" ON "AVALIACAOPEDIDO" ("IDCOLETAPRECO", "IDITEMREQUISICAOPRODUTO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_702_1
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_702_1" ON "ENTREGAITEMREQUISICAO" ("IDCOLETAPRECO", "IDITEMREQUISICAOPRODUTO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_703
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_703" ON "ITEMPEDIDOCOMPRA" ("IDCOLETAPRECO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_704
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_704" ON "ITEMPEDIDOCOMPRA" ("IDPEDIDO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_705
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_705" ON "ITEMPEDIDOCOMPRA" ("IDPRODUTO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_706
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_706" ON "PEDIDOCOMPRA" ("IDCOTACAO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_707
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_707" ON "PEDIDOCOMPRA" ("IDENDERECOENTREGA");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_710
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_710" ON "LIBERACAOMUDANCA" ("IDREQUISICAOMUDANCA");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_711
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_711" ON "ENTREGAITEMREQUISICAO" ("IDSOLICITACAOSERVICO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_712
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_712" ON "ENTREGAITEMREQUISICAO" ("IDITEMTRABALHO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_713
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_713" ON "INSPECAOENTREGAITEM" ("IDRESPONSAVEL");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_714
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_714" ON "INSPECAOENTREGAITEM" ("IDCRITERIO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_717
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_717" ON "INSPECAOPEDIDOCOMPRA" ("IDCRITERIO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_718
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_718" ON "INSPECAOPEDIDOCOMPRA" ("IDRESPONSAVEL");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_719
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_719" ON "ENTREGAITEMREQUISICAO" ("IDPARECER");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_72
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_72" ON "CAMPOSOBJETONEGOCIO" ("IDOBJETONEGOCIO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_720
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_720" ON "LIBERACAO" ("IDSOLICITANTE");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_721
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_721" ON "LIBERACAO" ("IDRESPONSAVEL");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_724
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_724" ON "CRITERIOITEMCOTACAO" ("IDITEMCOTACAO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_73
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_73" ON "RELACOBJETONEGOCIO" ("IDOBJETONEGOCIOPAI");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_74
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_74" ON "RELACOBJETONEGOCIO" ("IDOBJETONEGOCIOFILHO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_75
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_75" ON "GRUPOVISAO" ("IDVISAO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_77
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_77" ON "GRUPOVISAOCAMPOSNEGOCIO" ("IDCAMPOSOBJETONEGOCIO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_78
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_78" ON "VISAORELACIONADA" ("IDVISAOPAI");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_80
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_80" ON "CAMPOOBJRELACIONADO" ("IDRELACOBJETONEGOCIO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_81
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_81" ON "CAMPOOBJRELACIONADO" ("IDCAMPOSOBJETONEGOCIOPAI");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_82
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_82" ON "CAMPOOBJRELACIONADO" ("IDCAMPOSOBJETONEGOCIOFILHO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_83
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_83" ON "VALORVISAOCAMPOSNEGOCIO" ("IDGRUPOVISAO", "IDCAMPOSOBJETONEGOCIO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_84
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_84" ON "GRUPOVISAOCAMPOSNEGOCIOLIGACAO" ("IDGRUPOVISAO", "IDCAMPOSOBJETONEGOCIO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_85
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_85" ON "GRUPOVISAOCAMPOSNEGOCIOLIGACAO" ("IDCAMPOSOBJETONEGOCIOLIGACAO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_86
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_86" ON "GRUPOVISAOCAMPOSNEGOCIOINFOSQL" ("IDGRUPOVISAO", "IDCAMPOSOBJETONEGOCIO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_90
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_90" ON "VISAORELACIONADA" ("IDOBJETONEGOCIONN");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_91
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_91" ON "ACORDONIVELSERVICO_HIST" ("IDSERVICOCONTRATO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_93
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_93" ON "FLUXOSERVICO" ("IDTIPOFLUXO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_95
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_95" ON "SOLICITACAOSERVICO" ("IDPRIORIDADE");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_96
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_96" ON "SCRIPTSVISAO" ("IDVISAO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_97
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_97" ON "BOTAOACAOVISAO" ("IDVISAO");
--------------------------------------------------------
--  DDL for Index FK_REFERENCE_99
--------------------------------------------------------

  CREATE INDEX "FK_REFERENCE_99" ON "PRIORIDADESERVICOUNIDADE" ("IDPRIORIDADE");
--------------------------------------------------------
--  DDL for Index FK_REF_EVTMON
--------------------------------------------------------

  CREATE INDEX "FK_REF_EVTMON" ON "SOLICITACAOSERVICOEVTMON" ("IDEVENTOMONITORAMENTO");
--------------------------------------------------------
--  DDL for Index FK_REF_EVT_REC
--------------------------------------------------------

  CREATE INDEX "FK_REF_EVT_REC" ON "RECURSO" ("IDEVENTOMONITORAMENTO");
--------------------------------------------------------
--  DDL for Index FK_REF_GRP_REC
--------------------------------------------------------

  CREATE INDEX "FK_REF_GRP_REC" ON "RECURSO" ("IDGRUPO");
--------------------------------------------------------
--  DDL for Index FK_REF_GRPREC
--------------------------------------------------------

  CREATE INDEX "FK_REF_GRPREC" ON "RECURSO" ("IDGRUPORECURSO");
--------------------------------------------------------
--  DDL for Index FK_REF_IC_REC
--------------------------------------------------------

  CREATE INDEX "FK_REF_IC_REC" ON "RECURSO" ("IDITEMCONFIGURACAO");
--------------------------------------------------------
--  DDL for Index FK_REF_IMPCONX
--------------------------------------------------------

  CREATE INDEX "FK_REF_IMPCONX" ON "IMPORTCONFIG" ("IDEXTERNALCONNECTION");
--------------------------------------------------------
--  DDL for Index FK_REF_IMPCP_IMP
--------------------------------------------------------

  CREATE INDEX "FK_REF_IMPCP_IMP" ON "IMPORTCONFIGCAMPOS" ("IDIMPORTCONFIG");
--------------------------------------------------------
--  DDL for Index FK_REF_OBJMN
--------------------------------------------------------

  CREATE INDEX "FK_REF_OBJMN" ON "OBJETIVOMONITORAMENTO" ("IDOBJETIVOPLANOMELHORIA");
--------------------------------------------------------
--  DDL for Index FK_REF_ORIG_REC
--------------------------------------------------------

  CREATE INDEX "FK_REF_ORIG_REC" ON "RECURSO" ("IDORIGEM");
--------------------------------------------------------
--  DDL for Index FK_REF_PLMACT
--------------------------------------------------------

  CREATE INDEX "FK_REF_PLMACT" ON "ACAOPLANOMELHORIA" ("IDPLANOMELHORIA");
--------------------------------------------------------
--  DDL for Index FK_REF_REC_CALEND
--------------------------------------------------------

  CREATE INDEX "FK_REF_REC_CALEND" ON "RECURSO" ("IDCALENDARIO");
--------------------------------------------------------
--  DDL for Index FK_REF_RECEVTMON
--------------------------------------------------------

  CREATE INDEX "FK_REF_RECEVTMON" ON "SOLICITACAOSERVICOEVTMON" ("IDRECURSO");
--------------------------------------------------------
--  DDL for Index FK_REF_REC_NAGIOS
--------------------------------------------------------

  CREATE INDEX "FK_REF_REC_NAGIOS" ON "RECURSO" ("IDNAGIOSCONEXAO");
--------------------------------------------------------
--  DDL for Index FK_REF_REQMUD
--------------------------------------------------------

  CREATE INDEX "FK_REF_REQMUD" ON "ATIVIDADEPERIODICA" ("IDREQUISICAOMUDANCA");
--------------------------------------------------------
--  DDL for Index FK_REF_SC_REC
--------------------------------------------------------

  CREATE INDEX "FK_REF_SC_REC" ON "RECURSO" ("IDSERVICOCONTRATO");
--------------------------------------------------------
--  DDL for Index FK_REF_SOLIC_REC
--------------------------------------------------------

  CREATE INDEX "FK_REF_SOLIC_REC" ON "RECURSO" ("IDSOLICITANTE");
--------------------------------------------------------
--  DDL for Index FK_REF_SOL_SERVCTRDATA
--------------------------------------------------------

  CREATE INDEX "FK_REF_SOL_SERVCTRDATA" ON "SOLICITACAOSERVICO" ("DATAHORASOLICITACAO", "IDSERVICOCONTRATO");
--------------------------------------------------------
--  DDL for Index FK_REF_SOL_SERVDATA
--------------------------------------------------------

  CREATE INDEX "FK_REF_SOL_SERVDATA" ON "SOLICITACAOSERVICO" ("DATAHORASOLICITACAO", "IDSOLICITANTE");
--------------------------------------------------------
--  DDL for Index FK_REQUISICAOMUDANCA_IDX
--------------------------------------------------------

  CREATE INDEX "FK_REQUISICAOMUDANCA_IDX" ON "APROVACAOMUDANCA" ("IDREQUISICAOMUDANCA");
--------------------------------------------------------
--  DDL for Index FK_REQUISIC_REFERENCE_CALENDAR
--------------------------------------------------------

  CREATE INDEX "FK_REQUISIC_REFERENCE_CALENDAR" ON "REQUISICAOMUDANCA" ("IDCALENDARIO");
--------------------------------------------------------
--  DDL for Index FK_REQUISIC_REFERENCE_CAT
--------------------------------------------------------

  CREATE INDEX "FK_REQUISIC_REFERENCE_CAT" ON "REQUISICAOMUDANCA" ("IDTIPOMUDANCA");
--------------------------------------------------------
--  DDL for Index FK_REQUISIC_REFERENCE_GRUPO
--------------------------------------------------------

  CREATE INDEX "FK_REQUISIC_REFERENCE_GRUPO" ON "REQUISICAOMUDANCA" ("IDGRUPONIVEL1");
--------------------------------------------------------
--  DDL for Index FK_REQUISIC_REFERENCE_GRUPO_CO
--------------------------------------------------------

  CREATE INDEX "FK_REQUISIC_REFERENCE_GRUPO_CO" ON "REQUISICAOMUDANCA" ("IDGRUPOCOMITE");
--------------------------------------------------------
--  DDL for Index FK_REQUISIC_REFERENCE_GRUPO_01
--------------------------------------------------------

  CREATE INDEX "FK_REQUISIC_REFERENCE_GRUPO_01" ON "REQUISICAOMUDANCA" ("IDGRUPOATUAL");
--------------------------------------------------------
--  DDL for Index FK_REQUISIC_REFERENCE_ITEMCONF
--------------------------------------------------------

  CREATE INDEX "FK_REQUISIC_REFERENCE_ITEMCONF" ON "REQUISICAOMUDANCAITEMCONFIGURA" ("IDITEMCONFIGURACAO");
--------------------------------------------------------
--  DDL for Index FK_REQUISIC_REFERENCE_REQ
--------------------------------------------------------

  CREATE INDEX "FK_REQUISIC_REFERENCE_REQ" ON "REQUISICAOMUDANCAITEMCONFIGURA" ("IDREQUISICAOMUDANCA");
--------------------------------------------------------
--  DDL for Index FK_REQUISIC_REFERENCE_SERVICO
--------------------------------------------------------

  CREATE INDEX "FK_REQUISIC_REFERENCE_SERVICO" ON "REQUISICAOMUDANCASERVICO" ("IDSERVICO");
--------------------------------------------------------
--  DDL for Index FK_REQUISIC_REFERENC_REQ
--------------------------------------------------------

  CREATE INDEX "FK_REQUISIC_REFERENC_REQ" ON "REQUISICAOMUDANCASERVICO" ("IDREQUISICAOMUDANCA");
--------------------------------------------------------
--  DDL for Index FK_SERVCONTR_REFERENCE_CATALOG
--------------------------------------------------------

  CREATE INDEX "FK_SERVCONTR_REFERENCE_CATALOG" ON "SERVCONTRATOCATALOGOSERV" ("IDCATALOGOSERVICO");
--------------------------------------------------------
--  DDL for Index FK_SERVCONTR_REFERENCE_SERVICO
--------------------------------------------------------

  CREATE INDEX "FK_SERVCONTR_REFERENCE_SERVICO" ON "SERVCONTRATOCATALOGOSERV" ("IDSERVICOCONTRATO");
--------------------------------------------------------
--  DDL for Index FK_SOLICITACAO_APROVACAO_IDX
--------------------------------------------------------

  CREATE INDEX "FK_SOLICITACAO_APROVACAO_IDX" ON "SOLICITACAOSERVICO" ("IDULTIMAAPROVACAO");
--------------------------------------------------------
--  DDL for Index FK_SOLICITACAOSERV_CONTATO
--------------------------------------------------------

  CREATE INDEX "FK_SOLICITACAOSERV_CONTATO" ON "SOLICITACAOSERVICO" ("IDCONTATOSOLICITACAOSERVICO");
--------------------------------------------------------
--  DDL for Index FK_SOLICITA_REFERENCE_REQUISIC
--------------------------------------------------------

  CREATE INDEX "FK_SOLICITA_REFERENCE_REQUISIC" ON "SOLICITACAOSERVICOMUDANCA" ("IDREQUISICAOMUDANCA");
--------------------------------------------------------
--  DDL for Index FK_SOLICITA_REFERENCE_SOLICITA
--------------------------------------------------------

  CREATE INDEX "FK_SOLICITA_REFERENCE_SOLICITA" ON "SOLICITACAOSERVICOPROBLEMA" ("IDSOLICITACAOSERVICO");
--------------------------------------------------------
--  DDL for Index FK_SOLICITA_REFERENCE_SOLMUD
--------------------------------------------------------

  CREATE INDEX "FK_SOLICITA_REFERENCE_SOLMUD" ON "SOLICITACAOSERVICOMUDANCA" ("IDSOLICITACAOSERVICO");
--------------------------------------------------------
--  DDL for Index FK_TIPOSOFTWARE
--------------------------------------------------------

  CREATE INDEX "FK_TIPOSOFTWARE" ON "MIDIASOFTWARE" ("IDTIPOSOFTWARE");
--------------------------------------------------------
--  DDL for Index FK_UF_PAIS
--------------------------------------------------------

  CREATE INDEX "FK_UF_PAIS" ON "UFS" ("IDPAIS");
--------------------------------------------------------
--  DDL for Index FK_UFS
--------------------------------------------------------

  CREATE INDEX "FK_UFS" ON "UFS" ("IDREGIOES");
--------------------------------------------------------
--  DDL for Index FK_UNID_END
--------------------------------------------------------

  CREATE INDEX "FK_UNID_END" ON "UNIDADE" ("IDENDERECO");
--------------------------------------------------------
--  DDL for Index FK_VALOR
--------------------------------------------------------

  CREATE INDEX "FK_VALOR" ON "HISTORICOVALOR" ("IDVALOR");
--------------------------------------------------------
--  DDL for Index FK_VINCULOV_REF1_CAMPOSOB
--------------------------------------------------------

  CREATE INDEX "FK_VINCULOV_REF1_CAMPOSOB" ON "VINCULOVISAO" ("IDCAMPOSOBJETONEGOCIOPAINN");
--------------------------------------------------------
--  DDL for Index FK_VINCULOV_REF1_GRUPOVIS
--------------------------------------------------------

  CREATE INDEX "FK_VINCULOV_REF1_GRUPOVIS" ON "VINCULOVISAO" ("IDGRUPOVISAOFILHO", "IDCAMPOSOBJETONEGOCIOFILHO");
--------------------------------------------------------
--  DDL for Index FK_VINCULOV_REF2_CAMPOSOB
--------------------------------------------------------

  CREATE INDEX "FK_VINCULOV_REF2_CAMPOSOB" ON "VINCULOVISAO" ("IDCAMPOSOBJETONEGOCIOFILHONN");
--------------------------------------------------------
--  DDL for Index FK_VINCULOV_REF2_GRUPOVIS
--------------------------------------------------------

  CREATE INDEX "FK_VINCULOV_REF2_GRUPOVIS" ON "VINCULOVISAO" ("IDGRUPOVISAOPAI", "IDCAMPOSOBJETONEGOCIOPAI");
--------------------------------------------------------
--  DDL for Index FK_VISAOREL_REF2_VISAO
--------------------------------------------------------

  CREATE INDEX "FK_VISAOREL_REF2_VISAO" ON "VISAORELACIONADA" ("IDVISAOFILHA");
--------------------------------------------------------
--  DDL for Index FK3107D1C6B3CD587F
--------------------------------------------------------

  CREATE INDEX "FK3107D1C6B3CD587F" ON "INFORMACAOSERVICO" ("IDSERVICO");
--------------------------------------------------------
--  DDL for Index IDBASECONHECIMENTO
--------------------------------------------------------

  CREATE INDEX "IDBASECONHECIMENTO" ON "SOLICITACAOSERVICO" ("IDBASECONHECIMENTO");
--------------------------------------------------------
--  DDL for Index IDCALENDARIO
--------------------------------------------------------

  CREATE INDEX "IDCALENDARIO" ON "TIPOMUDANCA" ("IDCALENDARIO");
--------------------------------------------------------
--  DDL for Index IDCATEGORIAOCORRENCIA
--------------------------------------------------------

  CREATE INDEX "IDCATEGORIAOCORRENCIA" ON "OCORRENCIASOLICITACAO" ("IDCATEGORIAOCORRENCIA");
--------------------------------------------------------
--  DDL for Index IDCOTACAO
--------------------------------------------------------

  CREATE INDEX "IDCOTACAO" ON "HISTORICOSITUACAOCOTACAO" ("IDCOTACAO");
--------------------------------------------------------
--  DDL for Index IDCRITERIO
--------------------------------------------------------

  CREATE INDEX "IDCRITERIO" ON "CRITERIOCOTACAOCATEGORIA" ("IDCRITERIO");
--------------------------------------------------------
--  DDL for Index IDGRUPOEXECUTOR
--------------------------------------------------------

  CREATE INDEX "IDGRUPOEXECUTOR" ON "TIPOMUDANCA" ("IDGRUPOEXECUTOR");
--------------------------------------------------------
--  DDL for Index IDGRUPOITEMCONFIGURACAO
--------------------------------------------------------

  CREATE INDEX "IDGRUPOITEMCONFIGURACAO" ON "ITEMCONFIGURACAO" ("IDGRUPOITEMCONFIGURACAO");
--------------------------------------------------------
--  DDL for Index IDHISTORICOBASECONHECIMENTO
--------------------------------------------------------

  CREATE INDEX "IDHISTORICOBASECONHECIMENTO" ON "BASECONHECIMENTO" ("IDHISTORICOBASECONHECIMENTO");
--------------------------------------------------------
--  DDL for Index IDITEMCONFIGURACAO
--------------------------------------------------------

  CREATE INDEX "IDITEMCONFIGURACAO" ON "EVENTOITEMCONFIGURACAO" ("IDITEMCONFIGURACAO");
--------------------------------------------------------
--  DDL for Index IDITEMREQUISICAOPRODUTO
--------------------------------------------------------

  CREATE INDEX "IDITEMREQUISICAOPRODUTO" ON "COTACAOITEMREQUISICAO" ("IDITEMREQUISICAOPRODUTO");
--------------------------------------------------------
--  DDL for Index IDITEMTRABALHOINSPECAO
--------------------------------------------------------

  CREATE INDEX "IDITEMTRABALHOINSPECAO" ON "COTACAOITEMREQUISICAO" ("IDITEMTRABALHOINSPECAO");
--------------------------------------------------------
--  DDL for Index IDNOTIFICACAO
--------------------------------------------------------

  CREATE INDEX "IDNOTIFICACAO" ON "BASECONHECIMENTO" ("IDNOTIFICACAO");
--------------------------------------------------------
--  DDL for Index IDORIGEMOCORRENCIA
--------------------------------------------------------

  CREATE INDEX "IDORIGEMOCORRENCIA" ON "OCORRENCIASOLICITACAO" ("IDORIGEMOCORRENCIA");
--------------------------------------------------------
--  DDL for Index IDRESPONSAVEL
--------------------------------------------------------

  CREATE INDEX "IDRESPONSAVEL" ON "HISTORICOSITUACAOCOTACAO" ("IDRESPONSAVEL");
--------------------------------------------------------
--  DDL for Index IDSOLICITACAOSERVICO
--------------------------------------------------------

  CREATE INDEX "IDSOLICITACAOSERVICO" ON "COTACAOITEMREQUISICAO" ("IDSOLICITACAOSERVICO");
--------------------------------------------------------
--  DDL for Index IDTEMPLATESOLICITACAO
--------------------------------------------------------

  CREATE INDEX "IDTEMPLATESOLICITACAO" ON "SERVICO" ("IDTEMPLATESOLICITACAO");
--------------------------------------------------------
--  DDL for Index IDTIPOFLUXO
--------------------------------------------------------

  CREATE INDEX "IDTIPOFLUXO" ON "TIPOMUDANCA" ("IDTIPOFLUXO");
--------------------------------------------------------
--  DDL for Index IDTIPOPRODUTO
--------------------------------------------------------

  CREATE INDEX "IDTIPOPRODUTO" ON "FORNECEDORPRODUTO" ("IDTIPOPRODUTO");
--------------------------------------------------------
--  DDL for Index IDVERSAO
--------------------------------------------------------

  CREATE UNIQUE INDEX "IDVERSAO" ON "VERSAO" ("IDVERSAO");
--------------------------------------------------------
--  DDL for Index IDX_IDACORDONIVELSERVICO
--------------------------------------------------------

  CREATE INDEX "IDX_IDACORDONIVELSERVICO" ON "SOLICITACAOSERVICO" ("IDACORDONIVELSERVICO");
--------------------------------------------------------
--  DDL for Index IDX_IDITEMCONFIGURACAO
--------------------------------------------------------

  CREATE INDEX "IDX_IDITEMCONFIGURACAO" ON "SOLICITACAOSERVICO" ("IDITEMCONFIGURACAO");
--------------------------------------------------------
--  DDL for Index IDX_IDITEMCONFIGURACAOFILHO
--------------------------------------------------------

  CREATE INDEX "IDX_IDITEMCONFIGURACAOFILHO" ON "SOLICITACAOSERVICO" ("IDITEMCONFIGURACAOFILHO");
--------------------------------------------------------
--  DDL for Index IDX_IDSOLICITACAOPAI
--------------------------------------------------------

  CREATE INDEX "IDX_IDSOLICITACAOPAI" ON "SOLICITACAOSERVICO" ("IDSOLICITACAOPAI");
--------------------------------------------------------
--  DDL for Index IDX_IDSOLICITACAORELACIONADA
--------------------------------------------------------

  CREATE INDEX "IDX_IDSOLICITACAORELACIONADA" ON "SOLICITACAOSERVICO" ("IDSOLICITACAORELACIONADA");
--------------------------------------------------------
--  DDL for Index IDX_IDSOLICITACAOSERVICOORIGEM
--------------------------------------------------------

  CREATE INDEX "IDX_IDSOLICITACAOSERVICOORIGEM" ON "SOLICITACAOSERVICO" ("IDSOLICITACAOSERVICOORIGEM");
--------------------------------------------------------
--  DDL for Index IDX_IDTIPODEMANDASERVICO
--------------------------------------------------------

  CREATE INDEX "IDX_IDTIPODEMANDASERVICO" ON "SOLICITACAOSERVICO" ("IDTIPODEMANDASERVICO");
--------------------------------------------------------
--  DDL for Index INDEX_ACESSOMENU2
--------------------------------------------------------

  CREATE INDEX "INDEX_ACESSOMENU2" ON "PERFILACESSOMENU" ("DATAFIM");
--------------------------------------------------------
--  DDL for Index INDEX_ANEXOBASECONHECIMENTO
--------------------------------------------------------

  CREATE INDEX "INDEX_ANEXOBASECONHECIMENTO" ON "ANEXOBASECONHECIMENTO" ("IDBASECONHECIMENTO");
--------------------------------------------------------
--  DDL for Index INDEX_ANEXOEXECUCAOATIVIDADE
--------------------------------------------------------

  CREATE INDEX "INDEX_ANEXOEXECUCAOATIVIDADE" ON "ANEXO" ("IDEXECUCAOATIVIDADE");
--------------------------------------------------------
--  DDL for Index INDEX_ATIVIDADEPROXIMA
--------------------------------------------------------

  CREATE INDEX "INDEX_ATIVIDADEPROXIMA" ON "ATIVIDADES" ("IDATIVIDADEPROXIMA");
--------------------------------------------------------
--  DDL for Index INDEX_ATIVIDADESETAPA
--------------------------------------------------------

  CREATE INDEX "INDEX_ATIVIDADESETAPA" ON "ATIVIDADES" ("IDETAPA");
--------------------------------------------------------
--  DDL for Index INDEX_ATIVIDADESFLUXO
--------------------------------------------------------

  CREATE INDEX "INDEX_ATIVIDADESFLUXO" ON "ATIVIDADESFLUXOS" ("IDFLUXO");
--------------------------------------------------------
--  DDL for Index INDEX_ATIVIDADESTIPOATIVIDADE
--------------------------------------------------------

  CREATE INDEX "INDEX_ATIVIDADESTIPOATIVIDADE" ON "ATIVIDADES" ("IDTIPOATIVIDADE");
--------------------------------------------------------
--  DDL for Index INDEX_AUDITEMPREGADO
--------------------------------------------------------

  CREATE INDEX "INDEX_AUDITEMPREGADO" ON "AUDITORIAITEMCONFIGURACAO" ("IDEMPREGADO");
--------------------------------------------------------
--  DDL for Index INDEX_AUDITORIAITEMCONFIGURACA
--------------------------------------------------------

  CREATE INDEX "INDEX_AUDITORIAITEMCONFIGURACA" ON "AUDITORIA" ("IDITEMCONFIGURACAO");
--------------------------------------------------------
--  DDL for Index INDEX_AUDITORIAUSUARIO
--------------------------------------------------------

  CREATE INDEX "INDEX_AUDITORIAUSUARIO" ON "AUDITORIA" ("IDUSUARIO");
--------------------------------------------------------
--  DDL for Index INDEX_AUDTITEMCONFIGURACAO
--------------------------------------------------------

  CREATE INDEX "INDEX_AUDTITEMCONFIGURACAO" ON "AUDITORIAITEMCONFIGURACAO" ("IDITEMCONFIGURACAO");
--------------------------------------------------------
--  DDL for Index INDEX_BASECONHECIMENTOPAI
--------------------------------------------------------

  CREATE INDEX "INDEX_BASECONHECIMENTOPAI" ON "BASECONHECIMENTO" ("IDBASECONHECIMENTOPAI");
--------------------------------------------------------
--  DDL for Index INDEX_BASEPASTA
--------------------------------------------------------

  CREATE INDEX "INDEX_BASEPASTA" ON "BASECONHECIMENTO" ("IDPASTA");
--------------------------------------------------------
--  DDL for Index INDEX_BASETIPOITEMCONFIGURACAO
--------------------------------------------------------

  CREATE INDEX "INDEX_BASETIPOITEMCONFIGURACAO" ON "BASEITEMCONFIGURACAO" ("IDTIPOITEMCONFIGURACAO");
--------------------------------------------------------
--  DDL for Index INDEX_CATEGORIASERVICOPAI
--------------------------------------------------------

  CREATE INDEX "INDEX_CATEGORIASERVICOPAI" ON "CATEGORIASERVICO" ("IDCATEGORIASERVICOPAI");
--------------------------------------------------------
--  DDL for Index INDEX_CATEMPRESA
--------------------------------------------------------

  CREATE INDEX "INDEX_CATEMPRESA" ON "CATEGORIASERVICO" ("IDEMPRESA");
--------------------------------------------------------
--  DDL for Index INDEX_CEMPRESA
--------------------------------------------------------

  CREATE INDEX "INDEX_CEMPRESA" ON "CARACTERISTICA" ("IDEMPRESA");
--------------------------------------------------------
--  DDL for Index INDEX_CNOMECARACTERISTICA
--------------------------------------------------------

  CREATE INDEX "INDEX_CNOMECARACTERISTICA" ON "CARACTERISTICA" ("NOMECARACTERISTICA");
--------------------------------------------------------
--  DDL for Index INDEX_COMANDOSISTEMAOPERACIONA
--------------------------------------------------------

  CREATE INDEX "INDEX_COMANDOSISTEMAOPERACIONA" ON "COMANDOSISTEMAOPERACIONAL" ("IDSISTEMAOPERACIONAL");
--------------------------------------------------------
--  DDL for Index INDEX_CONDEMPRESA
--------------------------------------------------------

  CREATE INDEX "INDEX_CONDEMPRESA" ON "CONDICAOOPERACAO" ("IDEMPRESA");
--------------------------------------------------------
--  DDL for Index INDEX_CONTATOCLIENTE
--------------------------------------------------------

  CREATE INDEX "INDEX_CONTATOCLIENTE" ON "CONTATOCLIENTE" ("IDCLIENTE");
--------------------------------------------------------
--  DDL for Index INDEX_CONTRATOCONTRATO
--------------------------------------------------------

  CREATE INDEX "INDEX_CONTRATOCONTRATO" ON "CONTRATOQUESTIONARIOS" ("IDCONTRATO");
--------------------------------------------------------
--  DDL for Index INDEX_CONTRATOEMPRESA
--------------------------------------------------------

  CREATE INDEX "INDEX_CONTRATOEMPRESA" ON "CONTRATOQUESTIONARIOS" ("IDEMPRESA");
--------------------------------------------------------
--  DDL for Index INDEX_CONTRATOMIGRACAO
--------------------------------------------------------

  CREATE INDEX "INDEX_CONTRATOMIGRACAO" ON "CONTRATOQUESTIONARIOS" ("IDMIGRACAO");
--------------------------------------------------------
--  DDL for Index INDEX_CONTRATOPROFISSIONAL
--------------------------------------------------------

  CREATE INDEX "INDEX_CONTRATOPROFISSIONAL" ON "CONTRATOQUESTIONARIOS" ("IDPROFISSIONAL");
--------------------------------------------------------
--  DDL for Index INDEX_CONTRATOQUESTIONARIO
--------------------------------------------------------

  CREATE INDEX "INDEX_CONTRATOQUESTIONARIO" ON "CONTRATOQUESTIONARIOS" ("IDQUESTIONARIO");
--------------------------------------------------------
--  DDL for Index INDEX_DEMANDACONTRATO
--------------------------------------------------------

  CREATE INDEX "INDEX_DEMANDACONTRATO" ON "DEMANDAS" ("IDCONTRATO");
--------------------------------------------------------
--  DDL for Index INDEX_DEMANDADEMANDAPAI
--------------------------------------------------------

  CREATE INDEX "INDEX_DEMANDADEMANDAPAI" ON "DEMANDAS" ("IDDEMANDAPAI");
--------------------------------------------------------
--  DDL for Index INDEX_DEMANDAFLUXO
--------------------------------------------------------

  CREATE INDEX "INDEX_DEMANDAFLUXO" ON "DEMANDAS" ("IDFLUXO");
--------------------------------------------------------
--  DDL for Index INDEX_DEMANDAPROJETO
--------------------------------------------------------

  CREATE INDEX "INDEX_DEMANDAPROJETO" ON "DEMANDAS" ("IDPROJETO");
--------------------------------------------------------
--  DDL for Index INDEX_DEMANDASITUACAODEMANDA
--------------------------------------------------------

  CREATE INDEX "INDEX_DEMANDASITUACAODEMANDA" ON "DEMANDAS" ("IDSITUACAODEMANDA");
--------------------------------------------------------
--  DDL for Index INDEX_DEMANDATIPODEMANDA
--------------------------------------------------------

  CREATE INDEX "INDEX_DEMANDATIPODEMANDA" ON "DEMANDAS" ("IDTIPODEMANDA");
--------------------------------------------------------
--  DDL for Index INDEX_DIC_LINGUA_2
--------------------------------------------------------

  CREATE INDEX "INDEX_DIC_LINGUA_2" ON "DICIONARIO" ("IDLINGUA");
--------------------------------------------------------
--  DDL for Index INDEX_DIC_NOME
--------------------------------------------------------

  CREATE INDEX "INDEX_DIC_NOME" ON "DICIONARIO" ("NOME");
--------------------------------------------------------
--  DDL for Index INDEX_DIC_VALOR
--------------------------------------------------------

  CREATE INDEX "INDEX_DIC_VALOR" ON "DICIONARIO" ("VALOR");
--------------------------------------------------------
--  DDL for Index INDEX_EMPREGADO
--------------------------------------------------------

  CREATE INDEX "INDEX_EMPREGADO" ON "EMPREGADOITEMCONFIGURACAO" ("IDEMPREGADO");
--------------------------------------------------------
--  DDL for Index INDEX_EMPREGADOITEMCONFIGURACA
--------------------------------------------------------

  CREATE INDEX "INDEX_EMPREGADOITEMCONFIGURACA" ON "EMPREGADOITEMCONFIGURACAO" ("IDITEMCONFIGURACAO");
--------------------------------------------------------
--  DDL for Index INDEX_EMPUNIDADE
--------------------------------------------------------

  CREATE INDEX "INDEX_EMPUNIDADE" ON "EMPREGADOS" ("IDUNIDADE");
--------------------------------------------------------
--  DDL for Index INDEX_ETAPAFLUXO
--------------------------------------------------------

  CREATE INDEX "INDEX_ETAPAFLUXO" ON "ETAPAS" ("IDFLUXO");
--------------------------------------------------------
--  DDL for Index INDEX_ETAPASETAPAPAI
--------------------------------------------------------

  CREATE INDEX "INDEX_ETAPASETAPAPAI" ON "ETAPAS" ("IDETAPAPAI");
--------------------------------------------------------
--  DDL for Index INDEX_EVENTOEMPREGADO
--------------------------------------------------------

  CREATE INDEX "INDEX_EVENTOEMPREGADO" ON "EVENTOEMPREGADO" ("IDEMPREGADO");
--------------------------------------------------------
--  DDL for Index INDEX_EVENTOEMPRESA
--------------------------------------------------------

  CREATE INDEX "INDEX_EVENTOEMPRESA" ON "EVENTO" ("IDEMPRESA");
--------------------------------------------------------
--  DDL for Index INDEX_EVENTOGRUPO
--------------------------------------------------------

  CREATE INDEX "INDEX_EVENTOGRUPO" ON "EVENTOEMPREGADO" ("IDGRUPO");
--------------------------------------------------------
--  DDL for Index INDEX_EVENTOUNIDADE
--------------------------------------------------------

  CREATE INDEX "INDEX_EVENTOUNIDADE" ON "EVENTOEMPREGADO" ("IDUNIDADE");
--------------------------------------------------------
--  DDL for Index INDEX_EXCECAOEMPREGADO
--------------------------------------------------------

  CREATE INDEX "INDEX_EXCECAOEMPREGADO" ON "EXCECAOEMPREGADO" ("IDEMPREGADO");
--------------------------------------------------------
--  DDL for Index INDEX_EXCECAOGRUPO
--------------------------------------------------------

  CREATE INDEX "INDEX_EXCECAOGRUPO" ON "EXCECAOEMPREGADO" ("IDGRUPO");
--------------------------------------------------------
--  DDL for Index INDEX_EXCECAOUNIDADE
--------------------------------------------------------

  CREATE INDEX "INDEX_EXCECAOUNIDADE" ON "EXCECAOEMPREGADO" ("IDUNIDADE");
--------------------------------------------------------
--  DDL for Index INDEX_EXECUCAOATIVIDADE
--------------------------------------------------------

  CREATE INDEX "INDEX_EXECUCAOATIVIDADE" ON "EXECUCAODEMANDA" ("IDATIVIDADE");
--------------------------------------------------------
--  DDL for Index INDEX_GALERIACATEGORIAGALERIAI
--------------------------------------------------------

  CREATE INDEX "INDEX_GALERIACATEGORIAGALERIAI" ON "GALERIAIMAGENS" ("IDCATEGORIAGALERIAIMAGEM");
--------------------------------------------------------
--  DDL for Index INDEX_GRUPOEMPRESA
--------------------------------------------------------

  CREATE INDEX "INDEX_GRUPOEMPRESA" ON "GRUPO" ("IDEMPRESA");
--------------------------------------------------------
--  DDL for Index INDEX_GRUPOQUESTQUESTIONARIO
--------------------------------------------------------

  CREATE INDEX "INDEX_GRUPOQUESTQUESTIONARIO" ON "GRUPOQUESTIONARIO" ("IDQUESTIONARIO");
--------------------------------------------------------
--  DDL for Index INDEX_GRUPOSEMPREGADO
--------------------------------------------------------

  CREATE INDEX "INDEX_GRUPOSEMPREGADO" ON "GRUPOSEMPREGADOS" ("IDEMPREGADO");
--------------------------------------------------------
--  DDL for Index INDEX_ICPAI
--------------------------------------------------------

  CREATE INDEX "INDEX_ICPAI" ON "ITEMCONFIGURACAO" ("IDENTIFICACAO", "IDITEMCONFIGURACAOPAI");
--------------------------------------------------------
--  DDL for Index INDEX_IDENTIFICADORRESPOSTA
--------------------------------------------------------

  CREATE INDEX "INDEX_IDENTIFICADORRESPOSTA" ON "RESPOSTAITEMQUESTIONARIO" ("IDIDENTIFICADORRESPOSTA");
--------------------------------------------------------
--  DDL for Index INDEX_IMAGEMITEMCONFIGURACAO
--------------------------------------------------------

  CREATE INDEX "INDEX_IMAGEMITEMCONFIGURACAO" ON "IMAGEMITEMCONFIGURACAO" ("IDITEMCONFIGURACAO");
--------------------------------------------------------
--  DDL for Index INDEX_IMAGEMITEMCONFIGURACAOPA
--------------------------------------------------------

  CREATE INDEX "INDEX_IMAGEMITEMCONFIGURACAOPA" ON "IMAGEMITEMCONFIGURACAO" ("IDIMAGEMITEMCONFIGURACAOPAI");
--------------------------------------------------------
--  DDL for Index INDEX_IMAGEMITEMSERVICO
--------------------------------------------------------

  CREATE INDEX "INDEX_IMAGEMITEMSERVICO" ON "IMAGEMSERVICORELACIONADO" ("IDSERVICO");
--------------------------------------------------------
--  DDL for Index INDEX_IMAGEMITEMSERVICO_1
--------------------------------------------------------

  CREATE INDEX "INDEX_IMAGEMITEMSERVICO_1" ON "IMAGEMITEMCONFIGURACAO" ("IDSERVICO");
--------------------------------------------------------
--  DDL for Index INDEX_IMAGEMSERVICORELACIONADO
--------------------------------------------------------

  CREATE INDEX "INDEX_IMAGEMSERVICORELACIONADO" ON "IMAGEMSERVICORELACIONADO" ("IDSERVICORELACIONADO");
--------------------------------------------------------
--  DDL for Index INDEX_IMAGEMSERVICORELACIONA_1
--------------------------------------------------------

  CREATE INDEX "INDEX_IMAGEMSERVICORELACIONA_1" ON "IMAGEMSERVICORELACIONADO" ("IDIMAGEMSERVICORELACIONADOPAI");
--------------------------------------------------------
--  DDL for Index INDEX_IMPORTANCIAEMPRESA
--------------------------------------------------------

  CREATE INDEX "INDEX_IMPORTANCIAEMPRESA" ON "IMPORTANCIANEGOCIO" ("IDEMPRESA");
--------------------------------------------------------
--  DDL for Index INDEX_INFORMACOESCONTRATOCONFI
--------------------------------------------------------

  CREATE INDEX "INDEX_INFORMACOESCONTRATOCONFI" ON "INFORMACOESCONTRATOCONFIG" ("IDINFORMACOESCONTRATOCONFIGPAI");
--------------------------------------------------------
--  DDL for Index INDEX_INFORMACOESEMPRESA
--------------------------------------------------------

  CREATE INDEX "INDEX_INFORMACOESEMPRESA" ON "INFORMACOESCONTRATOCONFIG" ("IDEMPRESA");
--------------------------------------------------------
--  DDL for Index INDEX_INFORMACOESPERFILSEGURAN
--------------------------------------------------------

  CREATE INDEX "INDEX_INFORMACOESPERFILSEGURAN" ON "INFORMACOESCONTRATOPERFSEG" ("IDPERFILSEGURANCA");
--------------------------------------------------------
--  DDL for Index INDEX_INFORMACOESQUESTIONARIO
--------------------------------------------------------

  CREATE INDEX "INDEX_INFORMACOESQUESTIONARIO" ON "INFORMACOESCONTRATOCONFIG" ("IDQUESTIONARIO");
--------------------------------------------------------
--  DDL for Index INDEX_INVENTARIONETMAP
--------------------------------------------------------

  CREATE INDEX "INDEX_INVENTARIONETMAP" ON "INVENTARIOXML" ("IDNETMAP");
--------------------------------------------------------
--  DDL for Index INDEX_ITEMBASEITEMCONFIGURACAO
--------------------------------------------------------

  CREATE INDEX "INDEX_ITEMBASEITEMCONFIGURACAO" ON "ITEMCONFIGURACAOEVENTO" ("IDBASEITEMCONFIGURACAO");
--------------------------------------------------------
--  DDL for Index INDEX_ITEMCONF
--------------------------------------------------------

  CREATE INDEX "INDEX_ITEMCONF" ON "ITEMCONFIGURACAO" ("IDITEMCONFIGURACAO", "IDITEMCONFIGURACAOPAI", "IDTIPOITEMCONFIGURACAO", "DATAFIM");
--------------------------------------------------------
--  DDL for Index INDEX_ITEMCONFIGURACAO
--------------------------------------------------------

  CREATE INDEX "INDEX_ITEMCONFIGURACAO" ON "ITEMCONFIGURACAOEVENTO" ("IDITEMCONFIGURACAO");
--------------------------------------------------------
--  DDL for Index INDEX_ITEMEVENTO
--------------------------------------------------------

  CREATE INDEX "INDEX_ITEMEVENTO" ON "ITEMCONFIGURACAOEVENTO" ("IDEVENTO");
--------------------------------------------------------
--  DDL for Index INDEX_JUSTIFICACAOBASEITEMCONF
--------------------------------------------------------

  CREATE INDEX "INDEX_JUSTIFICACAOBASEITEMCONF" ON "JUSTIFICACAOFALHA" ("IDBASEITEMCONFIGURACAO");
--------------------------------------------------------
--  DDL for Index INDEX_JUSTIFICACAOEMPREGADO
--------------------------------------------------------

  CREATE INDEX "INDEX_JUSTIFICACAOEMPREGADO" ON "JUSTIFICACAOFALHA" ("IDEMPREGADO");
--------------------------------------------------------
--  DDL for Index INDEX_JUSTIFICACAOEVENTO
--------------------------------------------------------

  CREATE INDEX "INDEX_JUSTIFICACAOEVENTO" ON "JUSTIFICACAOFALHA" ("IDEVENTO");
--------------------------------------------------------
--  DDL for Index INDEX_JUSTIFICACAOITEMCONFIGUR
--------------------------------------------------------

  CREATE INDEX "INDEX_JUSTIFICACAOITEMCONFIGUR" ON "JUSTIFICACAOFALHA" ("IDITEMCONFIGURACAO");
--------------------------------------------------------
--  DDL for Index INDEX_MENU_LINK_2
--------------------------------------------------------

  CREATE INDEX "INDEX_MENU_LINK_2" ON "MENU" ("LINK");
--------------------------------------------------------
--  DDL for Index INDEX_MENU_NOME_2
--------------------------------------------------------

  CREATE INDEX "INDEX_MENU_NOME_2" ON "MENU" ("NOME", "ORDEM");
--------------------------------------------------------
--  DDL for Index INDEX_MENUPAI
--------------------------------------------------------

  CREATE INDEX "INDEX_MENUPAI" ON "MENU" ("IDMENUPAI");
--------------------------------------------------------
--  DDL for Index INDEX_MENU_RAPIDO_2
--------------------------------------------------------

  CREATE INDEX "INDEX_MENU_RAPIDO_2" ON "MENU" ("MENURAPIDO");
--------------------------------------------------------
--  DDL for Index INDEX_NETMAPIP
--------------------------------------------------------

  CREATE INDEX "INDEX_NETMAPIP" ON "NETMAP" ("IP");
--------------------------------------------------------
--  DDL for Index INDEX_NOMECATEG
--------------------------------------------------------

  CREATE INDEX "INDEX_NOMECATEG" ON "CATEGORIASERVICO" ("NOMECATEGORIASERVICOCONCATENAD");
--------------------------------------------------------
--  DDL for Index INDEX_OCORRENCIASDEMANDA
--------------------------------------------------------

  CREATE INDEX "INDEX_OCORRENCIASDEMANDA" ON "OCORRENCIAS" ("IDDEMANDA");
--------------------------------------------------------
--  DDL for Index INDEX_OCORRENCIASEMPREGADO
--------------------------------------------------------

  CREATE INDEX "INDEX_OCORRENCIASEMPREGADO" ON "OCORRENCIAS" ("IDEMPREGADO");
--------------------------------------------------------
--  DDL for Index INDEX_OPCAOQUESTAOQUESTIONARIO
--------------------------------------------------------

  CREATE INDEX "INDEX_OPCAOQUESTAOQUESTIONARIO" ON "OPCAORESPOSTAQUESTIONARIO" ("IDQUESTAOQUESTIONARIO");
--------------------------------------------------------
--  DDL for Index INDEX_OPCOESQUESTAOCOMPLEMENTO
--------------------------------------------------------

  CREATE INDEX "INDEX_OPCOESQUESTAOCOMPLEMENTO" ON "OPCAORESPOSTAQUESTIONARIO" ("IDQUESTAOCOMPLEMENTO");
--------------------------------------------------------
--  DDL for Index INDEX_PARAMETROSEMPRESA
--------------------------------------------------------

  CREATE INDEX "INDEX_PARAMETROSEMPRESA" ON "PARAMETROS" ("IDEMPRESA");
--------------------------------------------------------
--  DDL for Index INDEX_PASTAPAI
--------------------------------------------------------

  CREATE INDEX "INDEX_PASTAPAI" ON "PASTA" ("IDPASTAPAI");
--------------------------------------------------------
--  DDL for Index INDEX_PERFIL
--------------------------------------------------------

  CREATE INDEX "INDEX_PERFIL" ON "PERFILACESSOUSUARIO" ("IDPERFIL");
--------------------------------------------------------
--  DDL for Index INDEX_PERFILGRUPO
--------------------------------------------------------

  CREATE INDEX "INDEX_PERFILGRUPO" ON "PERFILACESSOGRUPO" ("IDGRUPO");
--------------------------------------------------------
--  DDL for Index INDEX_PERFILPASTA
--------------------------------------------------------

  CREATE INDEX "INDEX_PERFILPASTA" ON "PERFILACESSOPASTA" ("IDPASTA");
--------------------------------------------------------
--  DDL for Index INDEX_PERFILUSUARIO
--------------------------------------------------------

  CREATE INDEX "INDEX_PERFILUSUARIO" ON "PERFILACESSOUSUARIO" ("IDUSUARIO");
--------------------------------------------------------
--  DDL for Index INDEX_PRIORIDADEEMPRESA
--------------------------------------------------------

  CREATE INDEX "INDEX_PRIORIDADEEMPRESA" ON "PRIORIDADE" ("IDEMPRESA");
--------------------------------------------------------
--  DDL for Index INDEX_PROJETOCONTRATO
--------------------------------------------------------

  CREATE INDEX "INDEX_PROJETOCONTRATO" ON "PROJETOS" ("IDCONTRATO");
--------------------------------------------------------
--  DDL for Index INDEX_PROJETOSCLIENTE
--------------------------------------------------------

  CREATE INDEX "INDEX_PROJETOSCLIENTE" ON "PROJETOS" ("IDCLIENTE");
--------------------------------------------------------
--  DDL for Index INDEX_QUESTAOAGRUPADORA
--------------------------------------------------------

  CREATE INDEX "INDEX_QUESTAOAGRUPADORA" ON "QUESTAOQUESTIONARIO" ("IDQUESTAOAGRUPADORA");
--------------------------------------------------------
--  DDL for Index INDEX_QUESTAOCOMPARTILHADA
--------------------------------------------------------

  CREATE INDEX "INDEX_QUESTAOCOMPARTILHADA" ON "QUESTAOQUESTIONARIO" ("IDQUESTAOCOMPARTILHADA");
--------------------------------------------------------
--  DDL for Index INDEX_QUESTAOGRUPOQUESTIONARIO
--------------------------------------------------------

  CREATE INDEX "INDEX_QUESTAOGRUPOQUESTIONARIO" ON "QUESTAOQUESTIONARIO" ("IDGRUPOQUESTIONARIO");
--------------------------------------------------------
--  DDL for Index INDEX_QUESTAOIMAGEM
--------------------------------------------------------

  CREATE INDEX "INDEX_QUESTAOIMAGEM" ON "QUESTAOQUESTIONARIO" ("IDIMAGEM");
--------------------------------------------------------
--  DDL for Index INDEX_QUESTAOORIGEM
--------------------------------------------------------

  CREATE INDEX "INDEX_QUESTAOORIGEM" ON "QUESTAOQUESTIONARIO" ("IDQUESTAOORIGEM");
--------------------------------------------------------
--  DDL for Index INDEX_QUESTIONARIOCATEGORIAQUE
--------------------------------------------------------

  CREATE INDEX "INDEX_QUESTIONARIOCATEGORIAQUE" ON "QUESTIONARIO" ("IDCATEGORIAQUESTIONARIO");
--------------------------------------------------------
--  DDL for Index INDEX_QUESTIONARIOORIGEM
--------------------------------------------------------

  CREATE INDEX "INDEX_QUESTIONARIOORIGEM" ON "QUESTIONARIO" ("IDQUESTIONARIOORIGEM");
--------------------------------------------------------
--  DDL for Index INDEX_REPOSTAATESTADO
--------------------------------------------------------

  CREATE INDEX "INDEX_REPOSTAATESTADO" ON "RESPOSTAITEMQUESTIONARIO" ("IDATESTADO");
--------------------------------------------------------
--  DDL for Index INDEX_REPOSTACID
--------------------------------------------------------

  CREATE INDEX "INDEX_REPOSTACID" ON "RESPOSTAITEMQUESTIONARIOCIDS" ("IDCID");
--------------------------------------------------------
--  DDL for Index INDEX_REPOSTAOPCAORESPOSTAQUES
--------------------------------------------------------

  CREATE INDEX "INDEX_REPOSTAOPCAORESPOSTAQUES" ON "RESPOSTAITEMQUESTIONARIOOPCOES" ("IDOPCAORESPOSTAQUESTIONARIO");
--------------------------------------------------------
--  DDL for Index INDEX_RESPONSABILIDADECONTATOC
--------------------------------------------------------

  CREATE INDEX "INDEX_RESPONSABILIDADECONTATOC" ON "RESPONSABILIDADE" ("IDCONTATOCLIENTE");
--------------------------------------------------------
--  DDL for Index INDEX_RESPONSABILIDADECONTRATO
--------------------------------------------------------

  CREATE INDEX "INDEX_RESPONSABILIDADECONTRATO" ON "RESPONSABILIDADE" ("IDCONTRATO");
--------------------------------------------------------
--  DDL for Index INDEX_RESPONSABILIDADEEMPREGAD
--------------------------------------------------------

  CREATE INDEX "INDEX_RESPONSABILIDADEEMPREGAD" ON "RESPONSABILIDADE" ("IDEMPREGADO");
--------------------------------------------------------
--  DDL for Index INDEX_RESPONSABILIDADESERVICOC
--------------------------------------------------------

  CREATE INDEX "INDEX_RESPONSABILIDADESERVICOC" ON "RESPONSABILIDADE" ("IDSERVICOCONTRATO");
--------------------------------------------------------
--  DDL for Index INDEX_RESPOSTAITEMQUESTIONARIO
--------------------------------------------------------

  CREATE INDEX "INDEX_RESPOSTAITEMQUESTIONARIO" ON "RESPOSTAITEMQUESTIONARIOCIDS" ("IDRESPOSTAITEMQUESTIONARIO");
--------------------------------------------------------
--  DDL for Index INDEX_RESPOSTAITEMQUESTIONAR_1
--------------------------------------------------------

  CREATE INDEX "INDEX_RESPOSTAITEMQUESTIONAR_1" ON "RESPOSTAITEMQUESTIONARIOANEXOS" ("IDRESPOSTAITEMQUESTIONARIO");
--------------------------------------------------------
--  DDL for Index INDEX_RESPOSTAQUESTAOQUESTIONA
--------------------------------------------------------

  CREATE INDEX "INDEX_RESPOSTAQUESTAOQUESTIONA" ON "RESPOSTAITEMQUESTIONARIO" ("IDQUESTAOQUESTIONARIO");
--------------------------------------------------------
--  DDL for Index INDEX_SERVICO_IDCATSERVICO_4
--------------------------------------------------------

  CREATE INDEX "INDEX_SERVICO_IDCATSERVICO_4" ON "SERVICO" ("IDCATEGORIASERVICO");
--------------------------------------------------------
--  DDL for Index INDEX_SERVICO_IDSITSERVICO_4
--------------------------------------------------------

  CREATE INDEX "INDEX_SERVICO_IDSITSERVICO_4" ON "SERVICO" ("IDSITUACAOSERVICO");
--------------------------------------------------------
--  DDL for Index INDEX_SERVICO_IDTIPOSERVICO_4
--------------------------------------------------------

  CREATE INDEX "INDEX_SERVICO_IDTIPOSERVICO_4" ON "SERVICO" ("IDTIPOSERVICO");
--------------------------------------------------------
--  DDL for Index INDEX_SERVICO_NOMESERVICO_4
--------------------------------------------------------

  CREATE INDEX "INDEX_SERVICO_NOMESERVICO_4" ON "SERVICO" ("NOMESERVICO");
--------------------------------------------------------
--  DDL for Index INDEX_SITUACAOEMPRESA
--------------------------------------------------------

  CREATE INDEX "INDEX_SITUACAOEMPRESA" ON "SITUACAOSERVICO" ("IDEMPRESA");
--------------------------------------------------------
--  DDL for Index INDEX_SUBQUESTIONARIO
--------------------------------------------------------

  CREATE INDEX "INDEX_SUBQUESTIONARIO" ON "QUESTAOQUESTIONARIO" ("IDSUBQUESTIONARIO");
--------------------------------------------------------
--  DDL for Index INDEX_TIMESHEETDEMANDA
--------------------------------------------------------

  CREATE INDEX "INDEX_TIMESHEETDEMANDA" ON "TIMESHEET" ("IDDEMANDA");
--------------------------------------------------------
--  DDL for Index INDEX_TIMESHEETEMPREGADO
--------------------------------------------------------

  CREATE INDEX "INDEX_TIMESHEETEMPREGADO" ON "TIMESHEET" ("IDEMPREGADO");
--------------------------------------------------------
--  DDL for Index INDEX_TIMESHEETPROJETO
--------------------------------------------------------

  CREATE INDEX "INDEX_TIMESHEETPROJETO" ON "TIMESHEET" ("IDPROJETO");
--------------------------------------------------------
--  DDL for Index INDEX_TIPOCARACTERISTICA
--------------------------------------------------------

  CREATE INDEX "INDEX_TIPOCARACTERISTICA" ON "TIPOITEMCFGCARACTERISTICA" ("IDCARACTERISTICA");
--------------------------------------------------------
--  DDL for Index INDEX_TIPOCARC
--------------------------------------------------------

  CREATE INDEX "INDEX_TIPOCARC" ON "TIPOITEMCFGCARACTERISTICA" ("IDTIPOITEMCONFIGURACAO", "IDCARACTERISTICA", "NAMEINFOAGENTE");
--------------------------------------------------------
--  DDL for Index INDEX_TIPOEMPRESA
--------------------------------------------------------

  CREATE INDEX "INDEX_TIPOEMPRESA" ON "TIPOITEMCONFIGURACAO" ("IDEMPRESA");
--------------------------------------------------------
--  DDL for Index INDEX_TIPOITEMCONFIGURACAO
--------------------------------------------------------

  CREATE INDEX "INDEX_TIPOITEMCONFIGURACAO" ON "TIPOITEMCFGCARACTERISTICA" ("IDTIPOITEMCONFIGURACAO");
--------------------------------------------------------
--  DDL for Index INDEX_TIPOOSCONTRATO
--------------------------------------------------------

  CREATE INDEX "INDEX_TIPOOSCONTRATO" ON "TIPOOS" ("IDCONTRATO");
--------------------------------------------------------
--  DDL for Index INDEX_TIPOSERVICOEMPRESA
--------------------------------------------------------

  CREATE INDEX "INDEX_TIPOSERVICOEMPRESA" ON "TIPOSERVICO" ("IDEMPRESA");
--------------------------------------------------------
--  DDL for Index INDEX_TIPOUNIDADEEMPRESA
--------------------------------------------------------

  CREATE INDEX "INDEX_TIPOUNIDADEEMPRESA" ON "TIPOUNIDADE" ("IDEMPRESA");
--------------------------------------------------------
--  DDL for Index INDEX_UNEMPRESA
--------------------------------------------------------

  CREATE INDEX "INDEX_UNEMPRESA" ON "UNIDADE" ("IDEMPRESA");
--------------------------------------------------------
--  DDL for Index INDEX_UNIDADE
--------------------------------------------------------

  CREATE INDEX "INDEX_UNIDADE" ON "UNIDADEBASEITEMCONFIGURACAO" ("IDUNIDADE");
--------------------------------------------------------
--  DDL for Index INDEX_UNTIPOUNIDADE
--------------------------------------------------------

  CREATE INDEX "INDEX_UNTIPOUNIDADE" ON "UNIDADE" ("IDTIPOUNIDADE");
--------------------------------------------------------
--  DDL for Index INDEX_UNUNIDADEPAI
--------------------------------------------------------

  CREATE INDEX "INDEX_UNUNIDADEPAI" ON "UNIDADE" ("IDUNIDADEPAI");
--------------------------------------------------------
--  DDL for Index INDEX_USEMPREGADO
--------------------------------------------------------

  CREATE INDEX "INDEX_USEMPREGADO" ON "USUARIO" ("IDEMPREGADO");
--------------------------------------------------------
--  DDL for Index INDEX_USEMPRESA
--------------------------------------------------------

  CREATE INDEX "INDEX_USEMPRESA" ON "USUARIO" ("IDEMPRESA");
--------------------------------------------------------
--  DDL for Index INDEX_USUARIOITEMCONFIGURACAO
--------------------------------------------------------

  CREATE INDEX "INDEX_USUARIOITEMCONFIGURACAO" ON "USUARIOITEMCONFIGURACAO" ("IDITEMCONFIGURACAO");
--------------------------------------------------------
--  DDL for Index INDEX_USUNIDADE
--------------------------------------------------------

  CREATE INDEX "INDEX_USUNIDADE" ON "USUARIO" ("IDUNIDADE");
--------------------------------------------------------
--  DDL for Index INDEX_VBASEITEMCONFIG
--------------------------------------------------------

  CREATE INDEX "INDEX_VBASEITEMCONFIG" ON "VALOR" ("IDBASEITEMCONFIGURACAO");
--------------------------------------------------------
--  DDL for Index INDEX_VCARACTERISTICA
--------------------------------------------------------

  CREATE INDEX "INDEX_VCARACTERISTICA" ON "VALOR" ("IDCARACTERISTICA");
--------------------------------------------------------
--  DDL for Index INDEX_VCONSULTA3
--------------------------------------------------------

  CREATE INDEX "INDEX_VCONSULTA3" ON "VALOR" ("IDITEMCONFIGURACAO", "IDCARACTERISTICA", "IDBASEITEMCONFIGURACAO");
--------------------------------------------------------
--  DDL for Index INDEX_VITEMCONFIGURACAO
--------------------------------------------------------

  CREATE INDEX "INDEX_VITEMCONFIGURACAO" ON "VALOR" ("IDITEMCONFIGURACAO");
--------------------------------------------------------
--  DDL for Index ITEMCONFIGURACAO
--------------------------------------------------------

  CREATE INDEX "ITEMCONFIGURACAO" ON "HISTORICOTENTATIVA" ("IDHISTORICOTENTATIVA", "IDITEMCONFIGURACAO");
--------------------------------------------------------
--  DDL for Index IX_ACT_PM_ID
--------------------------------------------------------

  CREATE INDEX "IX_ACT_PM_ID" ON "ACAOPLANOMELHORIA" ("IDOBJETIVOPLANOMELHORIA");
--------------------------------------------------------
--  DDL for Index IX_IDENTIFICADOR
--------------------------------------------------------

  CREATE UNIQUE INDEX "IX_IDENTIFICADOR" ON "FORMULA" ("IDENTIFICADOR");
--------------------------------------------------------
--  DDL for Index IX_IMAGEMHIISTORICO_DATA
--------------------------------------------------------

  CREATE INDEX "IX_IMAGEMHIISTORICO_DATA" ON "IMAGEMHISTORICO" ("DATA", "IDCONTRATO", "IDPROFISSIONAL");
--------------------------------------------------------
--  DDL for Index IX_IMAGEMHISTORICO
--------------------------------------------------------

  CREATE INDEX "IX_IMAGEMHISTORICO" ON "IMAGEMHISTORICO" ("IDCONTRATO", "DATA");
--------------------------------------------------------
--  DDL for Index IX_OBJ_PM_ID
--------------------------------------------------------

  CREATE INDEX "IX_OBJ_PM_ID" ON "OBJETIVOPLANOMELHORIA" ("IDPLANOMELHORIA");
--------------------------------------------------------
--  DDL for Index IX_PM_CONTRATO
--------------------------------------------------------

  CREATE INDEX "IX_PM_CONTRATO" ON "PLANOMELHORIA" ("IDCONTRATO", "IDFORNECEDOR");
--------------------------------------------------------
--  DDL for Index IX_PM_FORN
--------------------------------------------------------

  CREATE INDEX "IX_PM_FORN" ON "PLANOMELHORIA" ("IDFORNECEDOR");
--------------------------------------------------------
--  DDL for Index IX_TAB_ORIG_CHVORIG
--------------------------------------------------------

  CREATE INDEX "IX_TAB_ORIG_CHVORIG" ON "TABFEDERACAODADOS" ("ORIGEM", "NOMETABELA", "CHAVEORIGINAL");
--------------------------------------------------------
--  DDL for Index NOME_UNIQUE
--------------------------------------------------------

  CREATE UNIQUE INDEX "NOME_UNIQUE" ON "REGIOES" ("NOME");
--------------------------------------------------------
--  DDL for Index NOMEVERSAO
--------------------------------------------------------

  CREATE UNIQUE INDEX "NOMEVERSAO" ON "VERSAO" ("NOMEVERSAO");
--------------------------------------------------------
--  DDL for Index PRIMARY
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY" ON "ACORDONIVELSERVICOCONTRATO" ("IDACORDONIVELSERVICOCONTRATO");
--------------------------------------------------------
--  DDL for Index PRIMARY_10
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_10" ON "PESSOA" ("TOKENIDENTIFICACAO");
--------------------------------------------------------
--  DDL for Index PRIMARY_100
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_100" ON "ACORDONIVELSERVICO" ("IDACORDONIVELSERVICO");
--------------------------------------------------------
--  DDL for Index PRIMARY_101
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_101" ON "ACORDONIVELSERVICO_HIST" ("IDACORDONIVELSERVICO_HIST");
--------------------------------------------------------
--  DDL for Index PRIMARY_102
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_102" ON "AUDITORIA" ("IDAUDITORIA");
--------------------------------------------------------
--  DDL for Index PRIMARY_103
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_103" ON "AVALIACAOFORNECEDOR" ("IDAVALIACAOFORNECEDOR");
--------------------------------------------------------
--  DDL for Index PRIMARY_104
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_104" ON "BPM_HISTORICOITEMTRABALHO" ("IDHISTORICOITEMTRABALHO");
--------------------------------------------------------
--  DDL for Index PRIMARY_105
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_105" ON "BPM_ITEMTRABALHOFLUXO" ("IDITEMTRABALHO");
--------------------------------------------------------
--  DDL for Index PRIMARY_106
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_106" ON "BPM_OBJETOINSTANCIAFLUXO" ("IDOBJETOINSTANCIA");
--------------------------------------------------------
--  DDL for Index PRIMARY_107
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_107" ON "CARACTERISTICA" ("IDCARACTERISTICA");
--------------------------------------------------------
--  DDL for Index PRIMARY_108
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_108" ON "CONTRATOS" ("IDCONTRATO");
--------------------------------------------------------
--  DDL for Index PRIMARY_109
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_109" ON "CRITERIOCOTACAO" ("IDCOTACAO", "IDCRITERIO");
--------------------------------------------------------
--  DDL for Index PRIMARY_11
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_11" ON "PORTAL" ("IDPORTAL");
--------------------------------------------------------
--  DDL for Index PRIMARY_110
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_110" ON "EMPRESA" ("IDEMPRESA");
--------------------------------------------------------
--  DDL for Index PRIMARY_111
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_111" ON "ENDERECO" ("IDENDERECO");
--------------------------------------------------------
--  DDL for Index PRIMARY_112
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_112" ON "EVENTOMONITCONHECIMENTO" ("IDEVENTOMONITORAMENTO", "IDBASECONHECIMENTO");
--------------------------------------------------------
--  DDL for Index PRIMARY_113
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_113" ON "FASESERVICO" ("IDFASE");
--------------------------------------------------------
--  DDL for Index PRIMARY_114
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_114" ON "IMAGEMSERVICORELACIONADO" ("IDIMAGEMSERVICORELACIONADO");
--------------------------------------------------------
--  DDL for Index PRIMARY_115
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_115" ON "JORNADATRABALHO" ("IDJORNADA");
--------------------------------------------------------
--  DDL for Index PRIMARY_116
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_116" ON "LIBERACAO" ("IDLIBERACAO");
--------------------------------------------------------
--  DDL for Index PRIMARY_117
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_117" ON "MARCA" ("IDMARCA");
--------------------------------------------------------
--  DDL for Index PRIMARY_118
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_118" ON "MENU" ("IDMENU");
--------------------------------------------------------
--  DDL for Index PRIMARY_119
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_119" ON "OBJETIVOMONITORAMENTO" ("IDOBJETIVOMONITORAMENTO");
--------------------------------------------------------
--  DDL for Index PRIMARY_12
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_12" ON "VINCULAOSINCIDENTE" ("IDOS", "IDSOLICITACAOSERVICO");
--------------------------------------------------------
--  DDL for Index PRIMARY_120
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_120" ON "OPCAORESPOSTAQUESTIONARIO" ("IDOPCAORESPOSTAQUESTIONARIO");
--------------------------------------------------------
--  DDL for Index PRIMARY_121
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_121" ON "PARECER" ("IDPARECER");
--------------------------------------------------------
--  DDL for Index PRIMARY_122
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_122" ON "PERFILSEGURANCA" ("IDPERFILSEGURANCA");
--------------------------------------------------------
--  DDL for Index PRIMARY_123
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_123" ON "PROBLEMA" ("IDPROBLEMA");
--------------------------------------------------------
--  DDL for Index PRIMARY_124
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_124" ON "REGISTRO" ("IDREGISTRO");
--------------------------------------------------------
--  DDL for Index PRIMARY_125
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_125" ON "RELACOBJETONEGOCIO" ("IDRELACOBJETONEGOCIO");
--------------------------------------------------------
--  DDL for Index PRIMARY_126
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_126" ON "SERVICO_HIST" ("IDHISTORICOSERVICO");
--------------------------------------------------------
--  DDL for Index PRIMARY_127
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_127" ON "TABFEDERACAODADOS" ("NOMETABELA", "CHAVEFINAL");
--------------------------------------------------------
--  DDL for Index PRIMARY_128
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_128" ON "TEMPLATESOLICITACAOSERVICO" ("IDTEMPLATE");
--------------------------------------------------------
--  DDL for Index PRIMARY_129
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_129" ON "TIMERS" ("TIMERID", "TARGETID");
--------------------------------------------------------
--  DDL for Index PRIMARY_13
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_13" ON "RELACIONAMENTOPRODUTO" ("IDTIPOPRODUTO", "IDTIPOPRODUTORELACIONADO");
--------------------------------------------------------
--  DDL for Index PRIMARY_130
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_130" ON "TIPOCOMPLEXIDADE" ("COMPLEXIDADE");
--------------------------------------------------------
--  DDL for Index PRIMARY_131
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_131" ON "TIPOSATIVIDADES" ("IDTIPOATIVIDADE");
--------------------------------------------------------
--  DDL for Index PRIMARY_132
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_132" ON "TIPOSOFTWARE" ("IDTIPOSOFTWARE");
--------------------------------------------------------
--  DDL for Index PRIMARY_133
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_133" ON "TIPOUNIDADE" ("IDTIPOUNIDADE");
--------------------------------------------------------
--  DDL for Index PRIMARY_134
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_134" ON "ACORDOSERVICOCONTRATO" ("IDACORDOSERVICOCONTRATO");
--------------------------------------------------------
--  DDL for Index PRIMARY_135
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_135" ON "APURACAOVALORESRECURSO" ("IDAPURACAOVALORESRECURSO");
--------------------------------------------------------
--  DDL for Index PRIMARY_136
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_136" ON "AUDITORIAITEMCONFIGURACAO" ("IDAUDITORIA");
--------------------------------------------------------
--  DDL for Index PRIMARY_137
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_137" ON "BASECONHECIMENTORELACIONADO" ("IDBASECONHECIMENTO", "IDBASECONHECIMENTORELACIONADO");
--------------------------------------------------------
--  DDL for Index PRIMARY_138
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_138" ON "BPM_FLUXO" ("IDFLUXO");
--------------------------------------------------------
--  DDL for Index PRIMARY_139
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_139" ON "CATEGORIAOCORRENCIA" ("IDCATEGORIAOCORRENCIA");
--------------------------------------------------------
--  DDL for Index PRIMARY_14
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_14" ON "REQUISICAOMUDANCAITEMCONFIGURA" ("IDREQUISICAOMUDANCAITEMCONFIGU");
--------------------------------------------------------
--  DDL for Index PRIMARY_140
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_140" ON "CATEGORIAQUESTIONARIO" ("IDCATEGORIAQUESTIONARIO");
--------------------------------------------------------
--  DDL for Index PRIMARY_141
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_141" ON "COMPLEXIDADE" ("IDCONTRATO", "COMPLEXIDADE");
--------------------------------------------------------
--  DDL for Index PRIMARY_142
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_142" ON "CONTATOSOLICITACAOSERVICO" ("IDCONTATOSOLICITACAOSERVICO");
--------------------------------------------------------
--  DDL for Index PRIMARY_143
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_143" ON "COTACAO" ("IDCOTACAO");
--------------------------------------------------------
--  DDL for Index PRIMARY_144
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_144" ON "EXCECAOCALENDARIO" ("IDEXCECAOCALENDARIO");
--------------------------------------------------------
--  DDL for Index PRIMARY_145
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_145" ON "EXECUCAOATIVIDADEPERIODICA" ("IDEXECUCAOATIVIDADEPERIODICA");
--------------------------------------------------------
--  DDL for Index PRIMARY_146
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_146" ON "EXECUCAOBATCH" ("IDEXECUCAOBATCH");
--------------------------------------------------------
--  DDL for Index PRIMARY_147
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_147" ON "EXECUCAODEMANDA" ("IDEXECUCAO");
--------------------------------------------------------
--  DDL for Index PRIMARY_148
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_148" ON "FAIXAVALORESRECURSO" ("IDFAIXAVALORESRECURSO");
--------------------------------------------------------
--  DDL for Index PRIMARY_149
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_149" ON "FATURA" ("IDFATURA");
--------------------------------------------------------
--  DDL for Index PRIMARY_15
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_15" ON "SERVICOS" ("IDSERVICO");
--------------------------------------------------------
--  DDL for Index PRIMARY_150
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_150" ON "FERIADO" ("IDFERIADO");
--------------------------------------------------------
--  DDL for Index PRIMARY_151
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_151" ON "FLUXO" ("IDFLUXO");
--------------------------------------------------------
--  DDL for Index PRIMARY_152
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_152" ON "FLUXOSERVICO" ("IDSERVICOCONTRATO", "IDTIPOFLUXO", "IDFASE");
--------------------------------------------------------
--  DDL for Index PRIMARY_153
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_153" ON "FORNECEDORPRODUTO" ("IDFORNECEDORPRODUTO");
--------------------------------------------------------
--  DDL for Index PRIMARY_154
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_154" ON "GRUPOVISAOCAMPOSNEGOCIO" ("IDGRUPOVISAO", "IDCAMPOSOBJETONEGOCIO");
--------------------------------------------------------
--  DDL for Index PRIMARY_155
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_155" ON "GRUPOVISAOCAMPOSNEGOCIOINFOSQL" ("IDGRUPOVISAOCAMPOSNEGOCIOINFOS");
--------------------------------------------------------
--  DDL for Index PRIMARY_156
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_156" ON "HISTORICOIC" ("IDHISTORICOIC");
--------------------------------------------------------
--  DDL for Index PRIMARY_157
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_157" ON "IMPACTO" ("IDIMPACTO");
--------------------------------------------------------
--  DDL for Index PRIMARY_158
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_158" ON "IMPORTANCIANEGOCIO" ("IDIMPORTANCIANEGOCIO");
--------------------------------------------------------
--  DDL for Index PRIMARY_159
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_159" ON "ITEMCOTACAO" ("IDITEMCOTACAO");
--------------------------------------------------------
--  DDL for Index PRIMARY_16
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_16" ON "SLAREQUISITOSLA" ("IDREQUISITOSLA", "IDACORDONIVELSERVICO");
--------------------------------------------------------
--  DDL for Index PRIMARY_160
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_160" ON "JUSTIFICACAOFALHA" ("IDJUSTIFICACAOFALHA");
--------------------------------------------------------
--  DDL for Index PRIMARY_161
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_161" ON "LIBERACAOMUDANCA" ("IDLIBERACAO", "IDREQUISICAOMUDANCA");
--------------------------------------------------------
--  DDL for Index PRIMARY_162
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_162" ON "LINGUA" ("IDLINGUA");
--------------------------------------------------------
--  DDL for Index PRIMARY_163
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_163" ON "MATRIZVISAO" ("IDMATRIZ");
--------------------------------------------------------
--  DDL for Index PRIMARY_164
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_164" ON "MIDIASOFTWARE" ("IDMIDIASOFTWARE");
--------------------------------------------------------
--  DDL for Index PRIMARY_165
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_165" ON "PALAVRAGEMEA" ("IDPALAVRAGEMEA");
--------------------------------------------------------
--  DDL for Index PRIMARY_166
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_166" ON "PERFILACESSO" ("IDPERFIL");
--------------------------------------------------------
--  DDL for Index PRIMARY_167
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_167" ON "PERFILACESSOSITUACAOFATURA" ("IDPERFIL", "SITUACAOFATURA");
--------------------------------------------------------
--  DDL for Index PRIMARY_168
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_168" ON "PLANOMELHORIA" ("IDPLANOMELHORIA");
--------------------------------------------------------
--  DDL for Index PRIMARY_169
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_169" ON "POST" ("IDPOST");
--------------------------------------------------------
--  DDL for Index PRIMARY_17
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_17" ON "TIPODEMANDA" ("IDTIPODEMANDA");
--------------------------------------------------------
--  DDL for Index PRIMARY_170
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_170" ON "PROCEDIMENTOTECNICO" ("IDPROCEDIMENTOTECNICO");
--------------------------------------------------------
--  DDL for Index PRIMARY_171
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_171" ON "RECURSO" ("IDRECURSO");
--------------------------------------------------------
--  DDL for Index PRIMARY_172
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_172" ON "REQUISICAOPRODUTO" ("IDSOLICITACAOSERVICO");
--------------------------------------------------------
--  DDL for Index PRIMARY_173
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_173" ON "SERVICO" ("IDSERVICO");
--------------------------------------------------------
--  DDL for Index PRIMARY_174
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_174" ON "SITUACAODEMANDA" ("IDSITUACAODEMANDA");
--------------------------------------------------------
--  DDL for Index PRIMARY_175
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_175" ON "SOLICITACAOSERVICOEVTMON" ("IDSOLICITACAOSERVICO", "IDEVENTOMONITORAMENTO");
--------------------------------------------------------
--  DDL for Index PRIMARY_176
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_176" ON "TIMESHEET" ("IDTIMESHEET");
--------------------------------------------------------
--  DDL for Index PRIMARY_177
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_177" ON "TIPOEVENTOSERVICO" ("IDTIPOEVENTOSERVICO");
--------------------------------------------------------
--  DDL for Index PRIMARY_178
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_178" ON "APROVACAOMUDANCA" ("IDAPROVACAOMUDANCA");
--------------------------------------------------------
--  DDL for Index PRIMARY_179
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_179" ON "BOTAOACAOVISAO" ("IDBOTAOACAOVISAO");
--------------------------------------------------------
--  DDL for Index PRIMARY_18
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_18" ON "UFS" ("IDUF");
--------------------------------------------------------
--  DDL for Index PRIMARY_180
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_180" ON "BPM_ATRIBUICAOFLUXO" ("IDATRIBUICAO");
--------------------------------------------------------
--  DDL for Index PRIMARY_181
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_181" ON "BPM_ELEMENTOFLUXO" ("IDELEMENTO");
--------------------------------------------------------
--  DDL for Index PRIMARY_182
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_182" ON "BPM_TIPOFLUXO" ("IDTIPOFLUXO");
--------------------------------------------------------
--  DDL for Index PRIMARY_183
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_183" ON "CALENDARIO" ("IDCALENDARIO");
--------------------------------------------------------
--  DDL for Index PRIMARY_184
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_184" ON "CATEGORIAMUDANCA" ("IDCATEGORIAMUDANCA");
--------------------------------------------------------
--  DDL for Index PRIMARY_185
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_185" ON "CONHECIMENTOSOLICITACAOSERVICO" ("IDSOLICITACAOSERVICO", "IDBASECONHECIMENTO");
--------------------------------------------------------
--  DDL for Index PRIMARY_186
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_186" ON "CONTADORACESSO" ("IDCONTADORACESSO");
--------------------------------------------------------
--  DDL for Index PRIMARY_187
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_187" ON "CONTRATOSCOLABORADORES" ("IDEMPREGADO", "IDCONTRATO");
--------------------------------------------------------
--  DDL for Index PRIMARY_188
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_188" ON "CONTRATOSGRUPOS" ("IDGRUPO", "IDCONTRATO");
--------------------------------------------------------
--  DDL for Index PRIMARY_189
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_189" ON "EXCECAOEMPREGADO" ("IDEVENTO", "IDEMPREGADO");
--------------------------------------------------------
--  DDL for Index PRIMARY_19
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_19" ON "USUARIO" ("IDUSUARIO");
--------------------------------------------------------
--  DDL for Index PRIMARY_190
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_190" ON "EXECUCAOMUDANCA" ("IDEXECUCAO");
--------------------------------------------------------
--  DDL for Index PRIMARY_191
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_191" ON "EXECUCAOSOLICITACAO" ("IDEXECUCAO");
--------------------------------------------------------
--  DDL for Index PRIMARY_192
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_192" ON "FLUXOS" ("IDFLUXO");
--------------------------------------------------------
--  DDL for Index PRIMARY_193
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_193" ON "FORNECEDOR" ("IDFORNECEDOR");
--------------------------------------------------------
--  DDL for Index PRIMARY_194
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_194" ON "GLOSASERVICOCONTRATO" ("IDGLOSASERVICOCONTRATO");
--------------------------------------------------------
--  DDL for Index PRIMARY_195
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_195" ON "GRUPOATVPERIODICA" ("IDGRUPOATVPERIODICA");
--------------------------------------------------------
--  DDL for Index PRIMARY_196
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_196" ON "HISTORICOVALOR" ("IDHISTORICOVALOR");
--------------------------------------------------------
--  DDL for Index PRIMARY_197
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_197" ON "HTMLCODEVISAO" ("IDHTMLCODEVISAO");
--------------------------------------------------------
--  DDL for Index PRIMARY_198
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_198" ON "LOCALIDADEUNIDADE" ("IDLOCALIDADEUNIDADE");
--------------------------------------------------------
--  DDL for Index PRIMARY_199
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_199" ON "NAGIOSCONEXAO" ("IDNAGIOSCONEXAO");
--------------------------------------------------------
--  DDL for Index PRIMARY_20
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_20" ON "ALCADACENTRORESULTADO" ("IDALCADACENTRORESULTADO");
--------------------------------------------------------
--  DDL for Index PRIMARY_200
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_200" ON "OBJETIVOPLANOMELHORIA" ("IDOBJETIVOPLANOMELHORIA");
--------------------------------------------------------
--  DDL for Index PRIMARY_201
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_201" ON "PERFILACESSOSITUACAOOS" ("IDPERFIL", "SITUACAOOS");
--------------------------------------------------------
--  DDL for Index PRIMARY_202
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_202" ON "PERMISSOESFLUXO" ("IDGRUPO", "IDTIPOFLUXO");
--------------------------------------------------------
--  DDL for Index PRIMARY_203
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_203" ON "REQUISICAOMUDANCA" ("IDREQUISICAOMUDANCA");
--------------------------------------------------------
--  DDL for Index PRIMARY_204
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_204" ON "REQUISITOSLA" ("IDREQUISITOSLA");
--------------------------------------------------------
--  DDL for Index PRIMARY_205
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_205" ON "RESPOSTAITEMQUESTIONARIO" ("IDRESPOSTAITEMQUESTIONARIO");
--------------------------------------------------------
--  DDL for Index PRIMARY_206
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_206" ON "SCRIPTS" ("IDSCRIPT");
--------------------------------------------------------
--  DDL for Index PRIMARY_207
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_207" ON "SCRIPTSVISAO" ("IDSCRIPTSVISAO");
--------------------------------------------------------
--  DDL for Index PRIMARY_208
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_208" ON "SISTEMAOPERACIONAL" ("ID");
--------------------------------------------------------
--  DDL for Index PRIMARY_209
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_209" ON "SITUACAOSERVICO" ("IDSITUACAOSERVICO");
--------------------------------------------------------
--  DDL for Index PRIMARY_21
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_21" ON "ANEXOINCIDENTE" ("IDANEXOINCIDENTE");
--------------------------------------------------------
--  DDL for Index PRIMARY_210
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_210" ON "TIPOMUDANCA" ("IDTIPOMUDANCA");
--------------------------------------------------------
--  DDL for Index PRIMARY_211
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_211" ON "TIPOSERVICO" ("IDTIPOSERVICO");
--------------------------------------------------------
--  DDL for Index PRIMARY_212
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_212" ON "UNIDADEBASEITEMCONFIGURACAO" ("IDBASEITEMCONFIGURACAO");
--------------------------------------------------------
--  DDL for Index PRIMARY_213
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_213" ON "UNIDADEMEDIDA" ("IDUNIDADEMEDIDA");
--------------------------------------------------------
--  DDL for Index PRIMARY_214
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_214" ON "BASECONHECIMENTO" ("IDBASECONHECIMENTO");
--------------------------------------------------------
--  DDL for Index PRIMARY_215
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_215" ON "BASEITEMCONFIGURACAO" ("IDBASEITEMCONFIGURACAO");
--------------------------------------------------------
--  DDL for Index PRIMARY_216
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_216" ON "CATEGORIAPROBLEMA" ("IDCATEGORIAPROBLEMA");
--------------------------------------------------------
--  DDL for Index PRIMARY_217
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_217" ON "CAUSAINCIDENTE" ("IDCAUSAINCIDENTE");
--------------------------------------------------------
--  DDL for Index PRIMARY_218
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_218" ON "CENTRORESULTADO" ("IDCENTRORESULTADO");
--------------------------------------------------------
--  DDL for Index PRIMARY_219
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_219" ON "CONHECIMENTOMUDANCA" ("IDREQUISICAOMUDANCA", "IDBASECONHECIMENTO");
--------------------------------------------------------
--  DDL for Index PRIMARY_22
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_22" ON "ANEXOMUDANCA" ("IDANEXOMUDANCA");
--------------------------------------------------------
--  DDL for Index PRIMARY_220
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_220" ON "CONTRATOQUESTIONARIOS" ("IDCONTRATOQUESTIONARIO");
--------------------------------------------------------
--  DDL for Index PRIMARY_221
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_221" ON "CONTROLEQUESTIONARIOS" ("IDCONTROLEQUESTIONARIO");
--------------------------------------------------------
--  DDL for Index PRIMARY_222
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_222" ON "DEMANDAS" ("IDDEMANDA");
--------------------------------------------------------
--  DDL for Index PRIMARY_223
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_223" ON "EMAILSOLICITACAOSERVICO" ("IDEMAILSOLICITACAOSERVICO");
--------------------------------------------------------
--  DDL for Index PRIMARY_224
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_224" ON "EMPREGADOS" ("IDEMPREGADO");
--------------------------------------------------------
--  DDL for Index PRIMARY_225
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_225" ON "EXTERNALCONNECTION" ("IDEXTERNALCONNECTION");
--------------------------------------------------------
--  DDL for Index PRIMARY_226
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_226" ON "FORMULA" ("IDFORMULA");
--------------------------------------------------------
--  DDL for Index PRIMARY_227
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_227" ON "GRUPOSEMPREGADOS" ("IDGRUPO", "IDEMPREGADO");
--------------------------------------------------------
--  DDL for Index PRIMARY_228
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_228" ON "INVENTARIOXML" ("IDINVENTARIOXML");
--------------------------------------------------------
--  DDL for Index PRIMARY_229
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_229" ON "JUSTIFICATIVAPARECER" ("IDJUSTIFICATIVA");
--------------------------------------------------------
--  DDL for Index PRIMARY_23
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_23" ON "ATIVIDADEPERIODICA" ("IDATIVIDADEPERIODICA");
--------------------------------------------------------
--  DDL for Index PRIMARY_230
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_230" ON "MIDIA" ("IDMIDIA");
--------------------------------------------------------
--  DDL for Index PRIMARY_231
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_231" ON "MODELOSEMAILS" ("IDMODELOEMAIL");
--------------------------------------------------------
--  DDL for Index PRIMARY_232
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_232" ON "NETMAP" ("IDNETMAP");
--------------------------------------------------------
--  DDL for Index PRIMARY_233
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_233" ON "OCORRENCIASOLICITACAO" ("IDOCORRENCIA");
--------------------------------------------------------
--  DDL for Index PRIMARY_234
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_234" ON "PARAMETROCORPORE" ("IDPARAMETROCORPORE");
--------------------------------------------------------
--  DDL for Index PRIMARY_235
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_235" ON "VINCULOVISAO" ("IDVISAORELACIONADA", "SEQ");
--------------------------------------------------------
--  DDL for Index PRIMARY_236
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_236" ON "PROGRAMACAOATIVIDADE" ("IDPROGRAMACAOATIVIDADE");
--------------------------------------------------------
--  DDL for Index PRIMARY_237
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_237" ON "RESPONSABILIDADE" ("IDRESPONSABILIDADE");
--------------------------------------------------------
--  DDL for Index PRIMARY_238
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_238" ON "REVISARSLA" ("IDREVISARSLA");
--------------------------------------------------------
--  DDL for Index PRIMARY_239
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_239" ON "SERVICOCONTRATO" ("IDSERVICOCONTRATO");
--------------------------------------------------------
--  DDL for Index PRIMARY_24
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_24" ON "BPM_INSTANCIAFLUXO" ("IDINSTANCIA");
--------------------------------------------------------
--  DDL for Index PRIMARY_240
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_240" ON "SOLICITACAOSERVICO" ("IDSOLICITACAOSERVICO");
--------------------------------------------------------
--  DDL for Index PRIMARY_241
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_241" ON "TIPOPROBLEMAATENDIMENTO" ("IDTIPOPROBLEMA");
--------------------------------------------------------
--  DDL for Index PRIMARY_242
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_242" ON "UNIDADESACCSERVICOS" ("IDUNIDADE", "IDSERVICO");
--------------------------------------------------------
--  DDL for Index PRIMARY_243
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_243" ON "ATIVIDADES" ("IDATIVIDADE");
--------------------------------------------------------
--  DDL for Index PRIMARY_244
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_244" ON "ATIVIDADESSERVICOCONTRATO" ("IDATIVIDADESERVICOCONTRATO");
--------------------------------------------------------
--  DDL for Index PRIMARY_245
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_245" ON "AVALIACAOCOTACAO" ("IDCRITERIO", "IDFORNECEDOR", "IDITEMCOTACAO");
--------------------------------------------------------
--  DDL for Index PRIMARY_246
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_246" ON "CARGOS" ("IDCARGO");
--------------------------------------------------------
--  DDL for Index PRIMARY_247
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_247" ON "CATEGORIASERVICO" ("IDCATEGORIASERVICO");
--------------------------------------------------------
--  DDL for Index PRIMARY_248
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_248" ON "COLECAO" ("IDCOLECAO");
--------------------------------------------------------
--  DDL for Index PRIMARY_249
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_249" ON "COMANDO" ("ID");
--------------------------------------------------------
--  DDL for Index PRIMARY_250
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_250" ON "CONDICAOOPERACAO" ("IDCONDICAOOPERACAO");
--------------------------------------------------------
--  DDL for Index PRIMARY_251
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_251" ON "CONTATOREQUISICAOMUDANCA" ("IDCONTATOREQUISICAOMUDANCA");
--------------------------------------------------------
--  DDL for Index PRIMARY_252
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_252" ON "CONTRATOSUNIDADES" ("IDUNIDADE", "IDCONTRATO");
--------------------------------------------------------
--  DDL for Index PRIMARY_253
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_253" ON "CRITERIOAVALIACAOFORNECEDOR" ("IDAVALIACAOFORNECEDOR", "IDCRITERIO");
--------------------------------------------------------
--  DDL for Index PRIMARY_254
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_254" ON "CRITERIOITEMCOTACAO" ("IDCRITERIO", "IDITEMCOTACAO");
--------------------------------------------------------
--  DDL for Index PRIMARY_255
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_255" ON "DICIONARIO" ("IDDICIONARIO");
--------------------------------------------------------
--  DDL for Index PRIMARY_256
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_256" ON "EVENTO" ("IDEVENTO");
--------------------------------------------------------
--  DDL for Index PRIMARY_257
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_257" ON "FATURAAPURACAOANS" ("IDFATURAAPURACAOANS");
--------------------------------------------------------
--  DDL for Index PRIMARY_258
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_258" ON "FATURAOS" ("IDFATURA", "IDOS");
--------------------------------------------------------
--  DDL for Index PRIMARY_259
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_259" ON "FORNECEDORCOTACAO" ("IDCOTACAO", "IDFORNECEDOR");
--------------------------------------------------------
--  DDL for Index PRIMARY_26
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_26" ON "COMENTARIOS" ("IDCOMENTARIO");
--------------------------------------------------------
--  DDL for Index PRIMARY_260
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_260" ON "GRUPOVISAO" ("IDGRUPOVISAO");
--------------------------------------------------------
--  DDL for Index PRIMARY_261
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_261" ON "HISTORICOEXECUCAO" ("IDHISTORICO");
--------------------------------------------------------
--  DDL for Index PRIMARY_262
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_262" ON "IMAGEMITEMCONFIGURACAO" ("IDIMAGEMITEMCONFIGURACAO");
--------------------------------------------------------
--  DDL for Index PRIMARY_263
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_263" ON "INFORMACOESCONTRATOPERFSEG" ("IDINFORMACOESCONTRATOCONFIG", "IDPERFILSEGURANCA");
--------------------------------------------------------
--  DDL for Index PRIMARY_264
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_264" ON "INSPECAOENTREGAITEM" ("IDENTREGA", "IDCRITERIO");
--------------------------------------------------------
--  DDL for Index PRIMARY_265
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_265" ON "ITEMREQUISICAOPRODUTO" ("IDITEMREQUISICAOPRODUTO");
--------------------------------------------------------
--  DDL for Index PRIMARY_266
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_266" ON "JUSTIFICATIVASOLICITACAO" ("IDJUSTIFICATIVA");
--------------------------------------------------------
--  DDL for Index PRIMARY_267
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_267" ON "LIMITEALCADA" ("IDLIMITEALCADA");
--------------------------------------------------------
--  DDL for Index PRIMARY_268
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_268" ON "LOCALEXECUCAOSERVICO" ("IDLOCALEXECUCAOSERVICO");
--------------------------------------------------------
--  DDL for Index PRIMARY_269
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_269" ON "LOGDADOS" ("IDLOG");
--------------------------------------------------------
--  DDL for Index PRIMARY_27
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_27" ON "CONHECIMENTOPROBLEMA" ("IDPROBLEMA", "IDBASECONHECIMENTO");
--------------------------------------------------------
--  DDL for Index PRIMARY_270
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_270" ON "NOTIFICACAO" ("IDNOTIFICACAO");
--------------------------------------------------------
--  DDL for Index PRIMARY_271
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_271" ON "ORIGEMATENDIMENTO" ("IDORIGEM");
--------------------------------------------------------
--  DDL for Index PRIMARY_273
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_273" ON "VISAO" ("IDVISAO");
--------------------------------------------------------
--  DDL for Index PRIMARY_274
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_274" ON "PRIORIDADEACORDONIVELSERVICO" ("IDUNIDADE", "IDACORDONIVELSERVICO");
--------------------------------------------------------
--  DDL for Index PRIMARY_275
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_275" ON "PRIORIDADESERVICOUNIDADE" ("IDUNIDADE", "IDSERVICOCONTRATO");
--------------------------------------------------------
--  DDL for Index PRIMARY_276
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_276" ON "PRODUTO" ("IDPRODUTO");
--------------------------------------------------------
--  DDL for Index PRIMARY_277
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_277" ON "VALORSERVICOCONTRATO" ("IDVALORSERVICOCONTRATO");
--------------------------------------------------------
--  DDL for Index PRIMARY_278
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_278" ON "ANEXOBASECONHECIMENTO" ("IDANEXOBASECONHECIMENTO");
--------------------------------------------------------
--  DDL for Index PRIMARY_279
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_279" ON "APROVACAOSOLICITACAOSERVICO" ("IDAPROVACAOSOLICITACAOSERVICO");
--------------------------------------------------------
--  DDL for Index PRIMARY_28
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_28" ON "CONTROLEGED" ("IDCONTROLEGED");
--------------------------------------------------------
--  DDL for Index PRIMARY_280
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_280" ON "ATIVIDADESFLUXOS" ("IDATIVIDADE", "IDFLUXO");
--------------------------------------------------------
--  DDL for Index PRIMARY_281
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_281" ON "AVALIACAOPEDIDO" ("IDAVALIACAO");
--------------------------------------------------------
--  DDL for Index PRIMARY_282
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_282" ON "AVALIACAOREFERENCIAFORNECEDOR" ("IDAVALIACAOFORNECEDOR", "IDEMPREGADO");
--------------------------------------------------------
--  DDL for Index PRIMARY_283
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_283" ON "BPM_SEQUENCIAFLUXO" ("IDELEMENTOORIGEM", "IDELEMENTODESTINO");
--------------------------------------------------------
--  DDL for Index PRIMARY_284
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_284" ON "CAMPOSOBJETONEGOCIO" ("IDCAMPOSOBJETONEGOCIO");
--------------------------------------------------------
--  DDL for Index PRIMARY_285
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_285" ON "CATEGORIAGALERIAIMAGEM" ("IDCATEGORIAGALERIAIMAGEM");
--------------------------------------------------------
--  DDL for Index PRIMARY_286
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_286" ON "CATEGORIAPRODUTO" ("IDCATEGORIA");
--------------------------------------------------------
--  DDL for Index PRIMARY_287
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_287" ON "CIDADES" ("IDCIDADE");
--------------------------------------------------------
--  DDL for Index PRIMARY_288
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_288" ON "CLIENTES" ("IDCLIENTE");
--------------------------------------------------------
--  DDL for Index PRIMARY_289
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_289" ON "COLETAPRECO" ("IDCOLETAPRECO");
--------------------------------------------------------
--  DDL for Index PRIMARY_29
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_29" ON "ENTREGAITEMREQUISICAO" ("IDENTREGA");
--------------------------------------------------------
--  DDL for Index PRIMARY_290
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_290" ON "COMANDOSISTEMAOPERACIONAL" ("ID");
--------------------------------------------------------
--  DDL for Index PRIMARY_291
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_291" ON "CONTATOCLIENTE" ("IDCONTATOCLIENTE");
--------------------------------------------------------
--  DDL for Index PRIMARY_292
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_292" ON "COTACAOITEMREQUISICAO" ("IDCOLETAPRECO", "IDITEMREQUISICAOPRODUTO");
--------------------------------------------------------
--  DDL for Index PRIMARY_293
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_293" ON "EMPREGADOITEMCONFIGURACAO" ("IDUSUARIO", "IDITEMCONFIGURACAO");
--------------------------------------------------------
--  DDL for Index PRIMARY_294
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_294" ON "ETAPAS" ("IDETAPA");
--------------------------------------------------------
--  DDL for Index PRIMARY_295
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_295" ON "EVENTOEMPREGADO" ("IDEVENTO", "IDEMPREGADO");
--------------------------------------------------------
--  DDL for Index PRIMARY_296
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_296" ON "EVENTOMONITORAMENTO" ("IDEVENTOMONITORAMENTO");
--------------------------------------------------------
--  DDL for Index PRIMARY_297
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_297" ON "GRUPOITEMCONFIGURACAO" ("IDGRUPOITEMCONFIGURACAO");
--------------------------------------------------------
--  DDL for Index PRIMARY_298
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_298" ON "GRUPORECURSOS" ("IDGRUPORECURSO");
--------------------------------------------------------
--  DDL for Index PRIMARY_299
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_299" ON "GRUPOVISAOCAMPOSNEGOCIOLIGACAO" ("IDGRPVISCAMPOSNEGLIGACA");
--------------------------------------------------------
--  DDL for Index PRIMARY_30
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_30" ON "GLOSAOS" ("IDGLOSAOS");
--------------------------------------------------------
--  DDL for Index PRIMARY_300
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_300" ON "HILOSEQUENCES" ("SEQUENCENAME");
--------------------------------------------------------
--  DDL for Index PRIMARY_31
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_31" ON "GRUPOQUESTIONARIO" ("IDGRUPOQUESTIONARIO");
--------------------------------------------------------
--  DDL for Index PRIMARY_33
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_33" ON "IMPORTANCIACONHECIMENTOGRUPO" ("IDBASECONHECIMENTO", "IDGRUPO");
--------------------------------------------------------
--  DDL for Index PRIMARY_34
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_34" ON "IMPORTANCIACONHECIMENTOUSUARIO" ("IDBASECONHECIMENTO", "IDUSUARIO");
--------------------------------------------------------
--  DDL for Index PRIMARY_35
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_35" ON "INFOCATALOGOSERVICO" ("IDINFOCATALOGOSERVICO");
--------------------------------------------------------
--  DDL for Index PRIMARY_36
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_36" ON "INFORMACOESCONTRATOCONFIG" ("IDINFORMACOESCONTRATOCONFIG");
--------------------------------------------------------
--  DDL for Index PRIMARY_37
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_37" ON "ITEMPEDIDOCOMPRA" ("IDITEMPEDIDO");
--------------------------------------------------------
--  DDL for Index PRIMARY_38
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_38" ON "MOEDAS" ("IDMOEDA");
--------------------------------------------------------
--  DDL for Index PRIMARY_39
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_39" ON "OCORRENCIAMUDANCA" ("IDOCORRENCIA");
--------------------------------------------------------
--  DDL for Index PRIMARY_4
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_4" ON "IMPORTCONFIGCAMPOS" ("IDIMPORTCONFIGCAMPO");
--------------------------------------------------------
--  DDL for Index PRIMARY_40
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_40" ON "OCORRENCIAS" ("IDOCORRENCIA");
--------------------------------------------------------
--  DDL for Index PRIMARY_41
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_41" ON "PAIS" ("IDPAIS");
--------------------------------------------------------
--  DDL for Index PRIMARY_42
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_42" ON "PERFILACESSOGRUPO" ("IDPERFIL", "IDGRUPO", "DATAINICIO");
--------------------------------------------------------
--  DDL for Index PRIMARY_43
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_43" ON "PRIORIDADE" ("IDPRIORIDADE");
--------------------------------------------------------
--  DDL for Index PRIMARY_44
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_44" ON "VISAORELACIONADA" ("IDVISAORELACIONADA");
--------------------------------------------------------
--  DDL for Index PRIMARY_45
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_45" ON "PROBLEMAITEMCONFIGURACAO" ("IDPROBLEMAITEMCONFIGURACAO");
--------------------------------------------------------
--  DDL for Index PRIMARY_46
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_46" ON "PROBLEMAMUDANCA" ("IDPROBLEMAMUDANCA");
--------------------------------------------------------
--  DDL for Index PRIMARY_47
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_47" ON "PROCESSAMENTOBATCH" ("IDPROCESSAMENTOBATCH");
--------------------------------------------------------
--  DDL for Index PRIMARY_48
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_48" ON "QUESTIONARIO" ("IDQUESTIONARIO");
--------------------------------------------------------
--  DDL for Index PRIMARY_49
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_49" ON "REABERTURASOLICITACAO" ("IDSOLICITACAOSERVICO", "SEQREABERTURA");
--------------------------------------------------------
--  DDL for Index PRIMARY_5
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_5" ON "INSPECAOPEDIDOCOMPRA" ("IDPEDIDO", "IDCRITERIO");
--------------------------------------------------------
--  DDL for Index PRIMARY_50
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_50" ON "REGIOES" ("IDREGIOES");
--------------------------------------------------------
--  DDL for Index PRIMARY_51
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_51" ON "RESPOSTAITEMQUESTIONARIOANEXOS" ("IDRESPOSTAITMQUESTIONARIOANEXO");
--------------------------------------------------------
--  DDL for Index PRIMARY_52
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_52" ON "RESPOSTAITEMQUESTIONARIOOPCOES" ("IDRESPOSTAITEMQUESTIONARIO", "IDOPCAORESPOSTAQUESTIONARIO");
--------------------------------------------------------
--  DDL for Index PRIMARY_53
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_53" ON "TIPODEMANDASERVICO" ("IDTIPODEMANDASERVICO");
--------------------------------------------------------
--  DDL for Index PRIMARY_54
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_54" ON "TIPOITEMCFGCARACTERISTICA" ("ID");
--------------------------------------------------------
--  DDL for Index PRIMARY_55
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_55" ON "TIPOITEMCONFIGURACAO" ("IDTIPOITEMCONFIGURACAO");
--------------------------------------------------------
--  DDL for Index PRIMARY_56
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_56" ON "TIPOOS" ("IDCLASSIFICACAOOS");
--------------------------------------------------------
--  DDL for Index PRIMARY_57
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_57" ON "UNIDADE" ("IDUNIDADE");
--------------------------------------------------------
--  DDL for Index PRIMARY_58
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_58" ON "VALOR" ("IDVALOR");
--------------------------------------------------------
--  DDL for Index PRIMARY_59
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_59" ON "ACAOPLANOMELHORIA" ("IDACAOPLANOMELHORIA");
--------------------------------------------------------
--  DDL for Index PRIMARY_60
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_60" ON "ALCADA" ("IDALCADA");
--------------------------------------------------------
--  DDL for Index PRIMARY_61
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_61" ON "ANEXO" ("IDANEXO");
--------------------------------------------------------
--  DDL for Index PRIMARY_62
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_62" ON "ATIVIDADESOS" ("IDATIVIDADESOS");
--------------------------------------------------------
--  DDL for Index PRIMARY_63
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_63" ON "BIBLIOTECASEXTERNAS" ("IDBIBLIOTECASEXTERNA");
--------------------------------------------------------
--  DDL for Index PRIMARY_64
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_64" ON "CAMPOOBJRELACIONADO" ("IDCAMPOOBJRELACIONADO");
--------------------------------------------------------
--  DDL for Index PRIMARY_65
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_65" ON "CATEGORIAPOST" ("IDCATEGORIAPOST");
--------------------------------------------------------
--  DDL for Index PRIMARY_66
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_66" ON "CATEGORIASOLUCAO" ("IDCATEGORIASOLUCAO");
--------------------------------------------------------
--  DDL for Index PRIMARY_67
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_67" ON "CONHECIMENTOIC" ("IDITEMCONFIGURACAO", "IDBASECONHECIMENTO");
--------------------------------------------------------
--  DDL for Index PRIMARY_68
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_68" ON "CONTRATOS_HIST" ("IDCONTRATO_HIST");
--------------------------------------------------------
--  DDL for Index PRIMARY_69
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_69" ON "CRITERIOAVALIACAO" ("IDCRITERIO");
--------------------------------------------------------
--  DDL for Index PRIMARY_7
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_7" ON "MATRIZPRIORIDADE" ("IDMATRIZPRIORIDADE");
--------------------------------------------------------
--  DDL for Index PRIMARY_70
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_70" ON "CRITERIOCOTACAOCATEGORIA" ("IDCATEGORIA", "IDCRITERIO");
--------------------------------------------------------
--  DDL for Index PRIMARY_71
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_71" ON "EVENTOITEMCONFIGURACAO" ("IDEVENTO", "IDITEMCONFIGURACAO");
--------------------------------------------------------
--  DDL for Index PRIMARY_72
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_72" ON "GALERIAIMAGENS" ("IDIMAGEM");
--------------------------------------------------------
--  DDL for Index PRIMARY_73
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_73" ON "GRUPO" ("IDGRUPO");
--------------------------------------------------------
--  DDL for Index PRIMARY_74
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_74" ON "GRUPOSEMAILS" ("IDGRUPO", "EMAIL");
--------------------------------------------------------
--  DDL for Index PRIMARY_75
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_75" ON "HISTORICOBASECONHECIMENTO" ("IDHISTORICOBASECONHECIMENTO", "IDBASECONHECIMENTO");
--------------------------------------------------------
--  DDL for Index PRIMARY_76
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_76" ON "HISTORICOSITUACAOCOTACAO" ("IDHISTORICO");
--------------------------------------------------------
--  DDL for Index PRIMARY_77
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_77" ON "IMAGEMHISTORICO" ("IDIMAGEM");
--------------------------------------------------------
--  DDL for Index PRIMARY_78
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_78" ON "IMPORTCONFIG" ("IDIMPORTCONFIG");
--------------------------------------------------------
--  DDL for Index PRIMARY_79
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_79" ON "INFORMACAOSERVICO" ("IDINFORMACAOSERVICO");
--------------------------------------------------------
--  DDL for Index PRIMARY_8
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_8" ON "MEUCATALOGO" ("IDUSUARIO", "IDSERVICO");
--------------------------------------------------------
--  DDL for Index PRIMARY_80
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_80" ON "JUSTIFICATIVAMUDANCA" ("IDJUSTIFICATIVAMUDANCA");
--------------------------------------------------------
--  DDL for Index PRIMARY_81
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_81" ON "LOCALIDADE" ("IDLOCALIDADE");
--------------------------------------------------------
--  DDL for Index PRIMARY_82
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_82" ON "MOTIVOSUSPENSAOATIVID" ("IDMOTIVO");
--------------------------------------------------------
--  DDL for Index PRIMARY_83
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_83" ON "OBJETONEGOCIO" ("IDOBJETONEGOCIO");
--------------------------------------------------------
--  DDL for Index PRIMARY_84
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_84" ON "OPINIAO" ("IDOPINIAO");
--------------------------------------------------------
--  DDL for Index PRIMARY_85
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_85" ON "ORIGEMOCORRENCIA" ("IDORIGEMOCORRENCIA");
--------------------------------------------------------
--  DDL for Index PRIMARY_86
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_86" ON "PARAMETROSCONTRATO" ("IDCONTRATO", "NOMEPARAMETRO");
--------------------------------------------------------
--  DDL for Index PRIMARY_87
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_87" ON "PASTA" ("IDPASTA");
--------------------------------------------------------
--  DDL for Index PRIMARY_88
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_88" ON "PEDIDOCOMPRA" ("IDPEDIDO");
--------------------------------------------------------
--  DDL for Index PRIMARY_89
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_89" ON "PERFILACESSOUSUARIO" ("IDUSUARIO", "IDPERFIL");
--------------------------------------------------------
--  DDL for Index PRIMARY_9
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_9" ON "PERFILACESSOPASTA" ("IDPERFIL", "IDPASTA");
--------------------------------------------------------
--  DDL for Index PRIMARY_90
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_90" ON "PESQUISASATISFACAO" ("IDPESQUISASATISFACAO");
--------------------------------------------------------
--  DDL for Index PRIMARY_91
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_91" ON "PROJETOS" ("IDPROJETO");
--------------------------------------------------------
--  DDL for Index PRIMARY_92
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_92" ON "QUESTAOQUESTIONARIO" ("IDQUESTAOQUESTIONARIO");
--------------------------------------------------------
--  DDL for Index PRIMARY_93
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_93" ON "REQUISICAOMUDANCASERVICO" ("IDREQUISICAOMUDANCASERVICO");
--------------------------------------------------------
--  DDL for Index PRIMARY_94
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_94" ON "RESPOSTAITEMQUESTIONARIOCIDS" ("IDRESPOSTAITEMQUESTIONARIOCID");
--------------------------------------------------------
--  DDL for Index PRIMARY_95
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_95" ON "TEMPOACORDONIVELSERVICO" ("IDACORDONIVELSERVICO", "IDPRIORIDADE", "IDFASE");
--------------------------------------------------------
--  DDL for Index PRIMARY_96
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_96" ON "TIPOPRODUTO" ("IDTIPOPRODUTO");
--------------------------------------------------------
--  DDL for Index PRIMARY_97
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_97" ON "URGENCIA" ("IDURGENCIA");
--------------------------------------------------------
--  DDL for Index PRIMARY_98
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_98" ON "USUARIOITEMCONFIGURACAO" ("IDUSUARIO", "IDITEMCONFIGURACAO");
--------------------------------------------------------
--  DDL for Index PRIMARY_99
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRIMARY_99" ON "VALORVISAOCAMPOSNEGOCIO" ("IDVALORVISAOCAMPOSNEGOCIO");
--------------------------------------------------------
--  DDL for Index TIPOMUDANCA_IBFK_2
--------------------------------------------------------

  CREATE INDEX "TIPOMUDANCA_IBFK_2" ON "TIPOMUDANCA" ("IDMODELOEMAILCRIACAO");
--------------------------------------------------------
--  DDL for Index TIPOMUDANCA_IBFK_3
--------------------------------------------------------

  CREATE INDEX "TIPOMUDANCA_IBFK_3" ON "TIPOMUDANCA" ("IDMODELOEMAILFINALIZACAO");
--------------------------------------------------------
--  DDL for Index TIPOMUDANCA_IBFK_4
--------------------------------------------------------

  CREATE INDEX "TIPOMUDANCA_IBFK_4" ON "TIPOMUDANCA" ("IDMODELOEMAILACOES");
--------------------------------------------------------
--  Constraints for Table ACAOPLANOMELHORIA
--------------------------------------------------------

ALTER TABLE "ACAOPLANOMELHORIA" MODIFY ("IDACAOPLANOMELHORIA" NOT NULL ENABLE);
ALTER TABLE "ACAOPLANOMELHORIA" MODIFY ("IDPLANOMELHORIA" NOT NULL ENABLE);
ALTER TABLE "ACAOPLANOMELHORIA" MODIFY ("IDOBJETIVOPLANOMELHORIA" NOT NULL ENABLE);
ALTER TABLE "ACAOPLANOMELHORIA" MODIFY ("TITULOACAO" NOT NULL ENABLE);
ALTER TABLE "ACAOPLANOMELHORIA" ADD CONSTRAINT "PRIMARY_59" PRIMARY KEY ("IDACAOPLANOMELHORIA");
--------------------------------------------------------
--  Constraints for Table ACORDONIVELSERVICO
--------------------------------------------------------

ALTER TABLE "ACORDONIVELSERVICO" MODIFY ("IDACORDONIVELSERVICO" NOT NULL ENABLE);
ALTER TABLE "ACORDONIVELSERVICO" MODIFY ("SITUACAO" NOT NULL ENABLE);
ALTER TABLE "ACORDONIVELSERVICO" MODIFY ("TITULOSLA" NOT NULL ENABLE);
ALTER TABLE "ACORDONIVELSERVICO" MODIFY ("DATAINICIO" NOT NULL ENABLE);
ALTER TABLE "ACORDONIVELSERVICO" MODIFY ("CRIADOEM" NOT NULL ENABLE);
ALTER TABLE "ACORDONIVELSERVICO" MODIFY ("MODIFICADOEM" NOT NULL ENABLE);
ALTER TABLE "ACORDONIVELSERVICO" ADD CONSTRAINT "PRIMARY_100" PRIMARY KEY ("IDACORDONIVELSERVICO");
--------------------------------------------------------
--  Constraints for Table ACORDONIVELSERVICOCONTRATO
--------------------------------------------------------

ALTER TABLE "ACORDONIVELSERVICOCONTRATO" MODIFY ("IDACORDONIVELSERVICOCONTRATO" NOT NULL ENABLE);
ALTER TABLE "ACORDONIVELSERVICOCONTRATO" MODIFY ("IDCONTRATO" NOT NULL ENABLE);
ALTER TABLE "ACORDONIVELSERVICOCONTRATO" MODIFY ("DESCRICAOACORDO" NOT NULL ENABLE);
ALTER TABLE "ACORDONIVELSERVICOCONTRATO" MODIFY ("VALORLIMITE" NOT NULL ENABLE);
ALTER TABLE "ACORDONIVELSERVICOCONTRATO" MODIFY ("DATAINICIO" NOT NULL ENABLE);
ALTER TABLE "ACORDONIVELSERVICOCONTRATO" ADD CONSTRAINT "PRIMARY" PRIMARY KEY ("IDACORDONIVELSERVICOCONTRATO");
--------------------------------------------------------
--  Constraints for Table ACORDONIVELSERVICO_HIST
--------------------------------------------------------

ALTER TABLE "ACORDONIVELSERVICO_HIST" MODIFY ("IDACORDONIVELSERVICO_HIST" NOT NULL ENABLE);
ALTER TABLE "ACORDONIVELSERVICO_HIST" MODIFY ("IDACORDONIVELSERVICO" NOT NULL ENABLE);
ALTER TABLE "ACORDONIVELSERVICO_HIST" MODIFY ("SITUACAO" NOT NULL ENABLE);
ALTER TABLE "ACORDONIVELSERVICO_HIST" MODIFY ("TITULOSLA" NOT NULL ENABLE);
ALTER TABLE "ACORDONIVELSERVICO_HIST" MODIFY ("DATAINICIO" NOT NULL ENABLE);
ALTER TABLE "ACORDONIVELSERVICO_HIST" MODIFY ("CRIADOEM" NOT NULL ENABLE);
ALTER TABLE "ACORDONIVELSERVICO_HIST" MODIFY ("MODIFICADOEM" NOT NULL ENABLE);
ALTER TABLE "ACORDONIVELSERVICO_HIST" ADD CONSTRAINT "PRIMARY_101" PRIMARY KEY ("IDACORDONIVELSERVICO_HIST");
--------------------------------------------------------
--  Constraints for Table ACORDOSERVICOCONTRATO
--------------------------------------------------------

ALTER TABLE "ACORDOSERVICOCONTRATO" MODIFY ("IDACORDOSERVICOCONTRATO" NOT NULL ENABLE);
ALTER TABLE "ACORDOSERVICOCONTRATO" MODIFY ("IDACORDONIVELSERVICO" NOT NULL ENABLE);
ALTER TABLE "ACORDOSERVICOCONTRATO" MODIFY ("IDSERVICOCONTRATO" NOT NULL ENABLE);
ALTER TABLE "ACORDOSERVICOCONTRATO" MODIFY ("DATACRIACAO" NOT NULL ENABLE);
ALTER TABLE "ACORDOSERVICOCONTRATO" ADD CONSTRAINT "PRIMARY_134" PRIMARY KEY ("IDACORDOSERVICOCONTRATO");
--------------------------------------------------------
--  Constraints for Table ALCADA
--------------------------------------------------------

ALTER TABLE "ALCADA" MODIFY ("IDALCADA" NOT NULL ENABLE);
ALTER TABLE "ALCADA" MODIFY ("NOMEALCADA" NOT NULL ENABLE);
ALTER TABLE "ALCADA" MODIFY ("SITUACAO" NOT NULL ENABLE);
ALTER TABLE "ALCADA" ADD CONSTRAINT "PRIMARY_60" PRIMARY KEY ("IDALCADA");
--------------------------------------------------------
--  Constraints for Table ALCADACENTRORESULTADO
--------------------------------------------------------

ALTER TABLE "ALCADACENTRORESULTADO" MODIFY ("IDALCADACENTRORESULTADO" NOT NULL ENABLE);
ALTER TABLE "ALCADACENTRORESULTADO" MODIFY ("IDCENTRORESULTADO" NOT NULL ENABLE);
ALTER TABLE "ALCADACENTRORESULTADO" MODIFY ("IDEMPREGADO" NOT NULL ENABLE);
ALTER TABLE "ALCADACENTRORESULTADO" MODIFY ("IDALCADA" NOT NULL ENABLE);
ALTER TABLE "ALCADACENTRORESULTADO" MODIFY ("DATAINICIO" NOT NULL ENABLE);
ALTER TABLE "ALCADACENTRORESULTADO" ADD CONSTRAINT "PRIMARY_20" PRIMARY KEY ("IDALCADACENTRORESULTADO");
--------------------------------------------------------
--  Constraints for Table ANEXO
--------------------------------------------------------

ALTER TABLE "ANEXO" MODIFY ("IDANEXO" NOT NULL ENABLE);
ALTER TABLE "ANEXO" MODIFY ("NOME" NOT NULL ENABLE);
ALTER TABLE "ANEXO" MODIFY ("EXTENSAO" NOT NULL ENABLE);
ALTER TABLE "ANEXO" MODIFY ("LINK" NOT NULL ENABLE);
ALTER TABLE "ANEXO" MODIFY ("PATH" NOT NULL ENABLE);
ALTER TABLE "ANEXO" ADD CONSTRAINT "PRIMARY_61" PRIMARY KEY ("IDANEXO");
--------------------------------------------------------
--  Constraints for Table ANEXOBASECONHECIMENTO
--------------------------------------------------------

ALTER TABLE "ANEXOBASECONHECIMENTO" ADD CONSTRAINT "PRIMARY_278" PRIMARY KEY ("IDANEXOBASECONHECIMENTO");
--------------------------------------------------------
--  Constraints for Table ANEXOINCIDENTE
--------------------------------------------------------

ALTER TABLE "ANEXOINCIDENTE" MODIFY ("IDANEXOINCIDENTE" NOT NULL ENABLE);
ALTER TABLE "ANEXOINCIDENTE" MODIFY ("IDINCIDENTE" NOT NULL ENABLE);
ALTER TABLE "ANEXOINCIDENTE" MODIFY ("DATAINICIO" NOT NULL ENABLE);
ALTER TABLE "ANEXOINCIDENTE" MODIFY ("NOME" NOT NULL ENABLE);
ALTER TABLE "ANEXOINCIDENTE" MODIFY ("LINK" NOT NULL ENABLE);
ALTER TABLE "ANEXOINCIDENTE" MODIFY ("DESCRICAO" NOT NULL ENABLE);
ALTER TABLE "ANEXOINCIDENTE" ADD CONSTRAINT "PRIMARY_21" PRIMARY KEY ("IDANEXOINCIDENTE");
--------------------------------------------------------
--  Constraints for Table ANEXOMUDANCA
--------------------------------------------------------
  
ALTER TABLE "ANEXOMUDANCA" MODIFY ("IDANEXOMUDANCA" NOT NULL ENABLE);
ALTER TABLE "ANEXOMUDANCA" ADD CONSTRAINT "PRIMARY_22" PRIMARY KEY ("IDANEXOMUDANCA");
--------------------------------------------------------
--  Constraints for Table APROVACAOMUDANCA
--------------------------------------------------------
  
ALTER TABLE "APROVACAOMUDANCA" MODIFY ("IDAPROVACAOMUDANCA" NOT NULL ENABLE);
ALTER TABLE "APROVACAOMUDANCA" ADD CONSTRAINT "PRIMARY_178" PRIMARY KEY ("IDAPROVACAOMUDANCA");
--------------------------------------------------------
--  Constraints for Table APROVACAOSOLICITACAOSERVICO
--------------------------------------------------------

ALTER TABLE "APROVACAOSOLICITACAOSERVICO" MODIFY ("APROVACAO" NOT NULL ENABLE);
ALTER TABLE "APROVACAOSOLICITACAOSERVICO" MODIFY ("IDRESPONSAVEL" NOT NULL ENABLE);
ALTER TABLE "APROVACAOSOLICITACAOSERVICO" MODIFY ("IDSOLICITACAOSERVICO" NOT NULL ENABLE);
ALTER TABLE "APROVACAOSOLICITACAOSERVICO" MODIFY ("IDAPROVACAOSOLICITACAOSERVICO" NOT NULL ENABLE);
ALTER TABLE "APROVACAOSOLICITACAOSERVICO" ADD CONSTRAINT "PRIMARY_279" PRIMARY KEY ("IDAPROVACAOSOLICITACAOSERVICO");
--------------------------------------------------------
--  Constraints for Table APURACAOVALORESRECURSO
--------------------------------------------------------

ALTER TABLE "APURACAOVALORESRECURSO" MODIFY ("VALORINICIO" NOT NULL ENABLE);
ALTER TABLE "APURACAOVALORESRECURSO" MODIFY ("IDRECURSO" NOT NULL ENABLE);
ALTER TABLE "APURACAOVALORESRECURSO" MODIFY ("IDAPURACAOVALORESRECURSO" NOT NULL ENABLE);
ALTER TABLE "APURACAOVALORESRECURSO" ADD CONSTRAINT "PRIMARY_135" PRIMARY KEY ("IDAPURACAOVALORESRECURSO");
--------------------------------------------------------
--  Constraints for Table ATIVIDADEPERIODICA
--------------------------------------------------------

ALTER TABLE "ATIVIDADEPERIODICA" MODIFY ("IDATIVIDADEPERIODICA" NOT NULL ENABLE);
ALTER TABLE "ATIVIDADEPERIODICA" ADD CONSTRAINT "PRIMARY_23" PRIMARY KEY ("IDATIVIDADEPERIODICA");
--------------------------------------------------------
--  Constraints for Table ATIVIDADES
--------------------------------------------------------

ALTER TABLE "ATIVIDADES" MODIFY ("ORDEM" NOT NULL ENABLE);
ALTER TABLE "ATIVIDADES" MODIFY ("NOMEATIVIDADE" NOT NULL ENABLE);
ALTER TABLE "ATIVIDADES" MODIFY ("IDTIPOATIVIDADE" NOT NULL ENABLE);
ALTER TABLE "ATIVIDADES" MODIFY ("IDETAPA" NOT NULL ENABLE);
ALTER TABLE "ATIVIDADES" MODIFY ("IDATIVIDADE" NOT NULL ENABLE);
ALTER TABLE "ATIVIDADES" ADD CONSTRAINT "PRIMARY_243" PRIMARY KEY ("IDATIVIDADE");
--------------------------------------------------------
--  Constraints for Table ATIVIDADESFLUXOS
--------------------------------------------------------

ALTER TABLE "ATIVIDADESFLUXOS" MODIFY ("IDFLUXO" NOT NULL ENABLE);
ALTER TABLE "ATIVIDADESFLUXOS" MODIFY ("IDATIVIDADE" NOT NULL ENABLE);
ALTER TABLE "ATIVIDADESFLUXOS" ADD CONSTRAINT "PRIMARY_280" PRIMARY KEY ("IDATIVIDADE", "IDFLUXO");
--------------------------------------------------------
--  Constraints for Table ATIVIDADESOS
--------------------------------------------------------

ALTER TABLE "ATIVIDADESOS" MODIFY ("DESCRICAOATIVIDADE" NOT NULL ENABLE);
ALTER TABLE "ATIVIDADESOS" MODIFY ("IDOS" NOT NULL ENABLE);
ALTER TABLE "ATIVIDADESOS" MODIFY ("IDATIVIDADESOS" NOT NULL ENABLE);
ALTER TABLE "ATIVIDADESOS" ADD CONSTRAINT "PRIMARY_62" PRIMARY KEY ("IDATIVIDADESOS");
--------------------------------------------------------
--  Constraints for Table ATIVIDADESSERVICOCONTRATO
--------------------------------------------------------

ALTER TABLE "ATIVIDADESSERVICOCONTRATO" MODIFY ("DESCRICAOATIVIDADE" NOT NULL ENABLE);
ALTER TABLE "ATIVIDADESSERVICOCONTRATO" MODIFY ("IDSERVICOCONTRATO" NOT NULL ENABLE);
ALTER TABLE "ATIVIDADESSERVICOCONTRATO" MODIFY ("IDATIVIDADESERVICOCONTRATO" NOT NULL ENABLE);
ALTER TABLE "ATIVIDADESSERVICOCONTRATO" ADD CONSTRAINT "PRIMARY_244" PRIMARY KEY ("IDATIVIDADESERVICOCONTRATO");
--------------------------------------------------------
--  Constraints for Table AUDITORIA
--------------------------------------------------------

ALTER TABLE "AUDITORIA" MODIFY ("DATA" NOT NULL ENABLE);
ALTER TABLE "AUDITORIA" MODIFY ("IDAUDITORIA" NOT NULL ENABLE);
ALTER TABLE "AUDITORIA" ADD CONSTRAINT "PRIMARY_102" PRIMARY KEY ("IDAUDITORIA");
--------------------------------------------------------
--  Constraints for Table AUDITORIAITEMCONFIGURACAO
--------------------------------------------------------

ALTER TABLE "AUDITORIAITEMCONFIGURACAO" MODIFY ("DATA" NOT NULL ENABLE);
ALTER TABLE "AUDITORIAITEMCONFIGURACAO" MODIFY ("IDAUDITORIA" NOT NULL ENABLE);
ALTER TABLE "AUDITORIAITEMCONFIGURACAO" ADD CONSTRAINT "PRIMARY_136" PRIMARY KEY ("IDAUDITORIA");
--------------------------------------------------------
--  Constraints for Table AVALIACAOCOLETAPRECO
--------------------------------------------------------

ALTER TABLE "AVALIACAOCOLETAPRECO" MODIFY ("AVALIACAO" NOT NULL ENABLE);
ALTER TABLE "AVALIACAOCOLETAPRECO" MODIFY ("IDCOLETAPRECO" NOT NULL ENABLE);
ALTER TABLE "AVALIACAOCOLETAPRECO" MODIFY ("IDCRITERIO" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table AVALIACAOCOTACAO
--------------------------------------------------------

ALTER TABLE "AVALIACAOCOTACAO" MODIFY ("AVALIACAO" NOT NULL ENABLE);
ALTER TABLE "AVALIACAOCOTACAO" MODIFY ("IDITEMCOTACAO" NOT NULL ENABLE);
ALTER TABLE "AVALIACAOCOTACAO" MODIFY ("IDFORNECEDOR" NOT NULL ENABLE);
ALTER TABLE "AVALIACAOCOTACAO" MODIFY ("IDCRITERIO" NOT NULL ENABLE);
ALTER TABLE "AVALIACAOCOTACAO" ADD CONSTRAINT "PRIMARY_245" PRIMARY KEY ("IDCRITERIO", "IDFORNECEDOR", "IDITEMCOTACAO");
--------------------------------------------------------
--  Constraints for Table AVALIACAOFORNECEDOR
--------------------------------------------------------

ALTER TABLE "AVALIACAOFORNECEDOR" MODIFY ("IDAVALIACAOFORNECEDOR" NOT NULL ENABLE);
ALTER TABLE "AVALIACAOFORNECEDOR" ADD CONSTRAINT "PRIMARY_103" PRIMARY KEY ("IDAVALIACAOFORNECEDOR");
--------------------------------------------------------
--  Constraints for Table AVALIACAOPEDIDO
--------------------------------------------------------

ALTER TABLE "AVALIACAOPEDIDO" MODIFY ("AVALIACAO" NOT NULL ENABLE);
ALTER TABLE "AVALIACAOPEDIDO" MODIFY ("TIPOAVALIACAO" NOT NULL ENABLE);
ALTER TABLE "AVALIACAOPEDIDO" MODIFY ("IDCRITERIO" NOT NULL ENABLE);
ALTER TABLE "AVALIACAOPEDIDO" MODIFY ("IDAVALIACAO" NOT NULL ENABLE);
ALTER TABLE "AVALIACAOPEDIDO" ADD CONSTRAINT "PRIMARY_281" PRIMARY KEY ("IDAVALIACAO");
--------------------------------------------------------
--  Constraints for Table AVALIACAOREFERENCIAFORNECEDOR
--------------------------------------------------------

ALTER TABLE "AVALIACAOREFERENCIAFORNECEDOR" MODIFY ("IDEMPREGADO" NOT NULL ENABLE);
ALTER TABLE "AVALIACAOREFERENCIAFORNECEDOR" MODIFY ("IDAVALIACAOFORNECEDOR" NOT NULL ENABLE);
ALTER TABLE "AVALIACAOREFERENCIAFORNECEDOR" ADD CONSTRAINT "PRIMARY_282" PRIMARY KEY ("IDAVALIACAOFORNECEDOR", "IDEMPREGADO");
--------------------------------------------------------
--  Constraints for Table BASECONHECIMENTO
--------------------------------------------------------

ALTER TABLE "BASECONHECIMENTO" MODIFY ("ORIGEM" NOT NULL ENABLE);
ALTER TABLE "BASECONHECIMENTO" MODIFY ("STATUS" NOT NULL ENABLE);
ALTER TABLE "BASECONHECIMENTO" MODIFY ("TITULO" NOT NULL ENABLE);
ALTER TABLE "BASECONHECIMENTO" MODIFY ("DATAINICIO" NOT NULL ENABLE);
ALTER TABLE "BASECONHECIMENTO" MODIFY ("IDBASECONHECIMENTO" NOT NULL ENABLE);
ALTER TABLE "BASECONHECIMENTO" ADD CONSTRAINT "PRIMARY_214" PRIMARY KEY ("IDBASECONHECIMENTO");
--------------------------------------------------------
--  Constraints for Table BASECONHECIMENTORELACIONADO
--------------------------------------------------------

ALTER TABLE "BASECONHECIMENTORELACIONADO" MODIFY ("IDBASECONHECIMENTORELACIONADO" NOT NULL ENABLE);
ALTER TABLE "BASECONHECIMENTORELACIONADO" MODIFY ("IDBASECONHECIMENTO" NOT NULL ENABLE);
ALTER TABLE "BASECONHECIMENTORELACIONADO" ADD CONSTRAINT "PRIMARY_137" PRIMARY KEY ("IDBASECONHECIMENTO", "IDBASECONHECIMENTORELACIONADO");
--------------------------------------------------------
--  Constraints for Table BASEITEMCONFIGURACAO
--------------------------------------------------------

ALTER TABLE "BASEITEMCONFIGURACAO" MODIFY ("DATAINICIO" NOT NULL ENABLE);
ALTER TABLE "BASEITEMCONFIGURACAO" MODIFY ("EXECUTAVEL" NOT NULL ENABLE);
ALTER TABLE "BASEITEMCONFIGURACAO" MODIFY ("NOMEBASEITEMCONFIGURACAO" NOT NULL ENABLE);
ALTER TABLE "BASEITEMCONFIGURACAO" MODIFY ("IDBASEITEMCONFIGURACAO" NOT NULL ENABLE);
ALTER TABLE "BASEITEMCONFIGURACAO" ADD CONSTRAINT "PRIMARY_215" PRIMARY KEY ("IDBASEITEMCONFIGURACAO");
--------------------------------------------------------
--  Constraints for Table BIBLIOTECASEXTERNAS
--------------------------------------------------------

ALTER TABLE "BIBLIOTECASEXTERNAS" MODIFY ("CAMINHO" NOT NULL ENABLE);
ALTER TABLE "BIBLIOTECASEXTERNAS" MODIFY ("NOME" NOT NULL ENABLE);
ALTER TABLE "BIBLIOTECASEXTERNAS" MODIFY ("IDBIBLIOTECASEXTERNA" NOT NULL ENABLE);
ALTER TABLE "BIBLIOTECASEXTERNAS" ADD CONSTRAINT "PRIMARY_63" PRIMARY KEY ("IDBIBLIOTECASEXTERNA");
--------------------------------------------------------
--  Constraints for Table BOTAOACAOVISAO
--------------------------------------------------------

ALTER TABLE "BOTAOACAOVISAO" MODIFY ("ACAO" NOT NULL ENABLE);
ALTER TABLE "BOTAOACAOVISAO" MODIFY ("TEXTO" NOT NULL ENABLE);
ALTER TABLE "BOTAOACAOVISAO" MODIFY ("IDVISAO" NOT NULL ENABLE);
ALTER TABLE "BOTAOACAOVISAO" MODIFY ("IDBOTAOACAOVISAO" NOT NULL ENABLE);
ALTER TABLE "BOTAOACAOVISAO" ADD CONSTRAINT "PRIMARY_179" PRIMARY KEY ("IDBOTAOACAOVISAO");
--------------------------------------------------------
--  Constraints for Table BPM_ATRIBUICAOFLUXO
--------------------------------------------------------

ALTER TABLE "BPM_ATRIBUICAOFLUXO" MODIFY ("DATAHORA" NOT NULL ENABLE);
ALTER TABLE "BPM_ATRIBUICAOFLUXO" MODIFY ("IDITEMTRABALHO" NOT NULL ENABLE);
ALTER TABLE "BPM_ATRIBUICAOFLUXO" MODIFY ("IDATRIBUICAO" NOT NULL ENABLE);
ALTER TABLE "BPM_ATRIBUICAOFLUXO" ADD CONSTRAINT "PRIMARY_180" PRIMARY KEY ("IDATRIBUICAO");
--------------------------------------------------------
--  Constraints for Table BPM_ELEMENTOFLUXO
--------------------------------------------------------

ALTER TABLE "BPM_ELEMENTOFLUXO" MODIFY ("TIPOELEMENTO" NOT NULL ENABLE);
ALTER TABLE "BPM_ELEMENTOFLUXO" MODIFY ("IDFLUXO" NOT NULL ENABLE);
ALTER TABLE "BPM_ELEMENTOFLUXO" MODIFY ("IDELEMENTO" NOT NULL ENABLE);
ALTER TABLE "BPM_ELEMENTOFLUXO" ADD CONSTRAINT "PRIMARY_181" PRIMARY KEY ("IDELEMENTO");
--------------------------------------------------------
--  Constraints for Table BPM_FLUXO
--------------------------------------------------------

ALTER TABLE "BPM_FLUXO" MODIFY ("DATAINICIO" NOT NULL ENABLE);
ALTER TABLE "BPM_FLUXO" MODIFY ("VERSAO" NOT NULL ENABLE);
ALTER TABLE "BPM_FLUXO" MODIFY ("IDFLUXO" NOT NULL ENABLE);
ALTER TABLE "BPM_FLUXO" ADD CONSTRAINT "PRIMARY_138" PRIMARY KEY ("IDFLUXO");
--------------------------------------------------------
--  Constraints for Table BPM_HISTORICOITEMTRABALHO
--------------------------------------------------------

ALTER TABLE "BPM_HISTORICOITEMTRABALHO" MODIFY ("ACAO" NOT NULL ENABLE);
ALTER TABLE "BPM_HISTORICOITEMTRABALHO" MODIFY ("DATAHORA" NOT NULL ENABLE);
ALTER TABLE "BPM_HISTORICOITEMTRABALHO" MODIFY ("IDITEMTRABALHO" NOT NULL ENABLE);
ALTER TABLE "BPM_HISTORICOITEMTRABALHO" MODIFY ("IDHISTORICOITEMTRABALHO" NOT NULL ENABLE);
ALTER TABLE "BPM_HISTORICOITEMTRABALHO" ADD CONSTRAINT "PRIMARY_104" PRIMARY KEY ("IDHISTORICOITEMTRABALHO");
--------------------------------------------------------
--  Constraints for Table BPM_INSTANCIAFLUXO
--------------------------------------------------------

ALTER TABLE "BPM_INSTANCIAFLUXO" MODIFY ("DATAHORACRIACAO" NOT NULL ENABLE);
ALTER TABLE "BPM_INSTANCIAFLUXO" MODIFY ("IDFLUXO" NOT NULL ENABLE);
ALTER TABLE "BPM_INSTANCIAFLUXO" MODIFY ("IDINSTANCIA" NOT NULL ENABLE);
ALTER TABLE "BPM_INSTANCIAFLUXO" ADD CONSTRAINT "PRIMARY_24" PRIMARY KEY ("IDINSTANCIA");
--------------------------------------------------------
--  Constraints for Table BPM_ITEMTRABALHOFLUXO
--------------------------------------------------------

ALTER TABLE "BPM_ITEMTRABALHOFLUXO" MODIFY ("SITUACAO" NOT NULL ENABLE);
ALTER TABLE "BPM_ITEMTRABALHOFLUXO" MODIFY ("DATAHORACRIACAO" NOT NULL ENABLE);
ALTER TABLE "BPM_ITEMTRABALHOFLUXO" MODIFY ("IDELEMENTO" NOT NULL ENABLE);
ALTER TABLE "BPM_ITEMTRABALHOFLUXO" MODIFY ("IDINSTANCIA" NOT NULL ENABLE);
ALTER TABLE "BPM_ITEMTRABALHOFLUXO" MODIFY ("IDITEMTRABALHO" NOT NULL ENABLE);
ALTER TABLE "BPM_ITEMTRABALHOFLUXO" ADD CONSTRAINT "PRIMARY_105" PRIMARY KEY ("IDITEMTRABALHO");
--------------------------------------------------------
--  Constraints for Table BPM_OBJETOINSTANCIAFLUXO
--------------------------------------------------------

ALTER TABLE "BPM_OBJETOINSTANCIAFLUXO" MODIFY ("OBJETOPRINCIPAL" NOT NULL ENABLE);
ALTER TABLE "BPM_OBJETOINSTANCIAFLUXO" MODIFY ("CAMPOCHAVE" NOT NULL ENABLE);
ALTER TABLE "BPM_OBJETOINSTANCIAFLUXO" MODIFY ("TIPOASSOCIACAO" NOT NULL ENABLE);
ALTER TABLE "BPM_OBJETOINSTANCIAFLUXO" MODIFY ("IDINSTANCIA" NOT NULL ENABLE);
ALTER TABLE "BPM_OBJETOINSTANCIAFLUXO" MODIFY ("IDOBJETOINSTANCIA" NOT NULL ENABLE);
ALTER TABLE "BPM_OBJETOINSTANCIAFLUXO" ADD CONSTRAINT "PRIMARY_106" PRIMARY KEY ("IDOBJETOINSTANCIA");
--------------------------------------------------------
--  Constraints for Table BPM_SEQUENCIAFLUXO
--------------------------------------------------------

ALTER TABLE "BPM_SEQUENCIAFLUXO" MODIFY ("IDFLUXO" NOT NULL ENABLE);
ALTER TABLE "BPM_SEQUENCIAFLUXO" MODIFY ("IDELEMENTODESTINO" NOT NULL ENABLE);
ALTER TABLE "BPM_SEQUENCIAFLUXO" MODIFY ("IDELEMENTOORIGEM" NOT NULL ENABLE);
ALTER TABLE "BPM_SEQUENCIAFLUXO" ADD CONSTRAINT "PRIMARY_283" PRIMARY KEY ("IDELEMENTOORIGEM", "IDELEMENTODESTINO");
--------------------------------------------------------
--  Constraints for Table BPM_TIPOFLUXO
--------------------------------------------------------

ALTER TABLE "BPM_TIPOFLUXO" MODIFY ("NOMEFLUXO" NOT NULL ENABLE);
ALTER TABLE "BPM_TIPOFLUXO" MODIFY ("IDTIPOFLUXO" NOT NULL ENABLE);
ALTER TABLE "BPM_TIPOFLUXO" ADD CONSTRAINT "PRIMARY_182" PRIMARY KEY ("IDTIPOFLUXO");
--------------------------------------------------------
--  Constraints for Table CALENDARIO
--------------------------------------------------------

ALTER TABLE "CALENDARIO" MODIFY ("IDCALENDARIO" NOT NULL ENABLE);
ALTER TABLE "CALENDARIO" ADD CONSTRAINT "PRIMARY_183" PRIMARY KEY ("IDCALENDARIO");
--------------------------------------------------------
--  Constraints for Table CAMPOOBJRELACIONADO
--------------------------------------------------------

ALTER TABLE "CAMPOOBJRELACIONADO" MODIFY ("SITUACAO" NOT NULL ENABLE);
ALTER TABLE "CAMPOOBJRELACIONADO" MODIFY ("IDCAMPOSOBJETONEGOCIOFILHO" NOT NULL ENABLE);
ALTER TABLE "CAMPOOBJRELACIONADO" MODIFY ("IDCAMPOSOBJETONEGOCIOPAI" NOT NULL ENABLE);
ALTER TABLE "CAMPOOBJRELACIONADO" MODIFY ("IDRELACOBJETONEGOCIO" NOT NULL ENABLE);
ALTER TABLE "CAMPOOBJRELACIONADO" MODIFY ("IDCAMPOOBJRELACIONADO" NOT NULL ENABLE);
ALTER TABLE "CAMPOOBJRELACIONADO" ADD CONSTRAINT "PRIMARY_64" PRIMARY KEY ("IDCAMPOOBJRELACIONADO");
--------------------------------------------------------
--  Constraints for Table CAMPOSOBJETONEGOCIO
--------------------------------------------------------

ALTER TABLE "CAMPOSOBJETONEGOCIO" MODIFY ("PRECISIONDB" NOT NULL ENABLE);
ALTER TABLE "CAMPOSOBJETONEGOCIO" MODIFY ("SITUACAO" NOT NULL ENABLE);
ALTER TABLE "CAMPOSOBJETONEGOCIO" MODIFY ("OBRIGATORIO" NOT NULL ENABLE);
ALTER TABLE "CAMPOSOBJETONEGOCIO" MODIFY ("TIPODB" NOT NULL ENABLE);
ALTER TABLE "CAMPOSOBJETONEGOCIO" MODIFY ("UNICO" NOT NULL ENABLE);
ALTER TABLE "CAMPOSOBJETONEGOCIO" MODIFY ("SEQUENCE" NOT NULL ENABLE);
ALTER TABLE "CAMPOSOBJETONEGOCIO" MODIFY ("PK" NOT NULL ENABLE);
ALTER TABLE "CAMPOSOBJETONEGOCIO" MODIFY ("NOMEDB" NOT NULL ENABLE);
ALTER TABLE "CAMPOSOBJETONEGOCIO" MODIFY ("NOME" NOT NULL ENABLE);
ALTER TABLE "CAMPOSOBJETONEGOCIO" MODIFY ("IDOBJETONEGOCIO" NOT NULL ENABLE);
ALTER TABLE "CAMPOSOBJETONEGOCIO" MODIFY ("IDCAMPOSOBJETONEGOCIO" NOT NULL ENABLE);
ALTER TABLE "CAMPOSOBJETONEGOCIO" ADD CONSTRAINT "PRIMARY_284" PRIMARY KEY ("IDCAMPOSOBJETONEGOCIO");
--------------------------------------------------------
--  Constraints for Table CARACTERISTICA
--------------------------------------------------------

ALTER TABLE "CARACTERISTICA" MODIFY ("DATAINICIO" NOT NULL ENABLE);
ALTER TABLE "CARACTERISTICA" MODIFY ("NOMECARACTERISTICA" NOT NULL ENABLE);
ALTER TABLE "CARACTERISTICA" MODIFY ("IDEMPRESA" NOT NULL ENABLE);
ALTER TABLE "CARACTERISTICA" MODIFY ("IDCARACTERISTICA" NOT NULL ENABLE);
ALTER TABLE "CARACTERISTICA" ADD CONSTRAINT "PRIMARY_107" PRIMARY KEY ("IDCARACTERISTICA");
--------------------------------------------------------
--  Constraints for Table CARGOS
--------------------------------------------------------

ALTER TABLE "CARGOS" MODIFY ("DATAINICIO" NOT NULL ENABLE);
ALTER TABLE "CARGOS" MODIFY ("NOMECARGO" NOT NULL ENABLE);
ALTER TABLE "CARGOS" MODIFY ("IDCARGO" NOT NULL ENABLE);
ALTER TABLE "CARGOS" ADD CONSTRAINT "PRIMARY_246" PRIMARY KEY ("IDCARGO");
--------------------------------------------------------
--  Constraints for Table CATALOGOSERVICO
--------------------------------------------------------

ALTER TABLE "CATALOGOSERVICO" MODIFY ("IDCATALOGOSERVICO" NOT NULL ENABLE);
ALTER TABLE "CATALOGOSERVICO" ADD CONSTRAINT "AK_KEY_1_CATALAGO" UNIQUE ("IDCATALOGOSERVICO");
--------------------------------------------------------
--  Constraints for Table CATEGORIAGALERIAIMAGEM
--------------------------------------------------------

ALTER TABLE "CATEGORIAGALERIAIMAGEM" MODIFY ("NOMECATEGORIA" NOT NULL ENABLE);
ALTER TABLE "CATEGORIAGALERIAIMAGEM" MODIFY ("IDCATEGORIAGALERIAIMAGEM" NOT NULL ENABLE);
ALTER TABLE "CATEGORIAGALERIAIMAGEM" ADD CONSTRAINT "PRIMARY_285" PRIMARY KEY ("IDCATEGORIAGALERIAIMAGEM");
--------------------------------------------------------
--  Constraints for Table CATEGORIAMUDANCA
--------------------------------------------------------

ALTER TABLE "CATEGORIAMUDANCA" MODIFY ("IDCATEGORIAMUDANCA" NOT NULL ENABLE);
ALTER TABLE "CATEGORIAMUDANCA" ADD CONSTRAINT "PRIMARY_184" PRIMARY KEY ("IDCATEGORIAMUDANCA");
--------------------------------------------------------
--  Constraints for Table CATEGORIAOCORRENCIA
--------------------------------------------------------

ALTER TABLE "CATEGORIAOCORRENCIA" MODIFY ("DATAINICIO" NOT NULL ENABLE);
ALTER TABLE "CATEGORIAOCORRENCIA" MODIFY ("NOME" NOT NULL ENABLE);
ALTER TABLE "CATEGORIAOCORRENCIA" MODIFY ("IDCATEGORIAOCORRENCIA" NOT NULL ENABLE);
ALTER TABLE "CATEGORIAOCORRENCIA" ADD CONSTRAINT "PRIMARY_139" PRIMARY KEY ("IDCATEGORIAOCORRENCIA");
--------------------------------------------------------
--  Constraints for Table CATEGORIAPOST
--------------------------------------------------------

ALTER TABLE "CATEGORIAPOST" MODIFY ("IDCATEGORIAPOST" NOT NULL ENABLE);
ALTER TABLE "CATEGORIAPOST" ADD CONSTRAINT "PRIMARY_65" PRIMARY KEY ("IDCATEGORIAPOST");
--------------------------------------------------------
--  Constraints for Table CATEGORIAPROBLEMA
--------------------------------------------------------

ALTER TABLE "CATEGORIAPROBLEMA" MODIFY ("NOMECATEGORIA" NOT NULL ENABLE);
ALTER TABLE "CATEGORIAPROBLEMA" MODIFY ("IDCATEGORIAPROBLEMAPAI" NOT NULL ENABLE);
ALTER TABLE "CATEGORIAPROBLEMA" MODIFY ("IDCATEGORIAPROBLEMA" NOT NULL ENABLE);
ALTER TABLE "CATEGORIAPROBLEMA" ADD CONSTRAINT "PRIMARY_216" PRIMARY KEY ("IDCATEGORIAPROBLEMA");
--------------------------------------------------------
--  Constraints for Table CATEGORIAPRODUTO
--------------------------------------------------------

ALTER TABLE "CATEGORIAPRODUTO" MODIFY ("SITUACAO" NOT NULL ENABLE);
ALTER TABLE "CATEGORIAPRODUTO" MODIFY ("NOMECATEGORIA" NOT NULL ENABLE);
ALTER TABLE "CATEGORIAPRODUTO" MODIFY ("IDCATEGORIA" NOT NULL ENABLE);
ALTER TABLE "CATEGORIAPRODUTO" ADD CONSTRAINT "PRIMARY_286" PRIMARY KEY ("IDCATEGORIA");
--------------------------------------------------------
--  Constraints for Table CATEGORIAQUESTIONARIO
--------------------------------------------------------

ALTER TABLE "CATEGORIAQUESTIONARIO" MODIFY ("IDEMPRESA" NOT NULL ENABLE);
ALTER TABLE "CATEGORIAQUESTIONARIO" MODIFY ("NOMECATEGORIAQUESTIONARIO" NOT NULL ENABLE);
ALTER TABLE "CATEGORIAQUESTIONARIO" MODIFY ("IDCATEGORIAQUESTIONARIO" NOT NULL ENABLE);
ALTER TABLE "CATEGORIAQUESTIONARIO" ADD CONSTRAINT "PRIMARY_140" PRIMARY KEY ("IDCATEGORIAQUESTIONARIO");
--------------------------------------------------------
--  Constraints for Table CATEGORIASERVICO
--------------------------------------------------------

ALTER TABLE "CATEGORIASERVICO" MODIFY ("NOMECATEGORIASERVICO" NOT NULL ENABLE);
ALTER TABLE "CATEGORIASERVICO" MODIFY ("IDEMPRESA" NOT NULL ENABLE);
ALTER TABLE "CATEGORIASERVICO" MODIFY ("IDCATEGORIASERVICO" NOT NULL ENABLE);
ALTER TABLE "CATEGORIASERVICO" ADD CONSTRAINT "PRIMARY_247" PRIMARY KEY ("IDCATEGORIASERVICO");
--------------------------------------------------------
--  Constraints for Table CATEGORIASOLUCAO
--------------------------------------------------------

ALTER TABLE "CATEGORIASOLUCAO" MODIFY ("DATAINICIO" NOT NULL ENABLE);
ALTER TABLE "CATEGORIASOLUCAO" MODIFY ("DESCRICAOCATEGORIASOLUCAO" NOT NULL ENABLE);
ALTER TABLE "CATEGORIASOLUCAO" MODIFY ("IDCATEGORIASOLUCAO" NOT NULL ENABLE);
ALTER TABLE "CATEGORIASOLUCAO" ADD CONSTRAINT "PRIMARY_66" PRIMARY KEY ("IDCATEGORIASOLUCAO");
--------------------------------------------------------
--  Constraints for Table CAUSAINCIDENTE
--------------------------------------------------------

ALTER TABLE "CAUSAINCIDENTE" MODIFY ("DATAINICIO" NOT NULL ENABLE);
ALTER TABLE "CAUSAINCIDENTE" MODIFY ("DESCRICAOCAUSA" NOT NULL ENABLE);
ALTER TABLE "CAUSAINCIDENTE" MODIFY ("IDCAUSAINCIDENTE" NOT NULL ENABLE);
ALTER TABLE "CAUSAINCIDENTE" ADD CONSTRAINT "PRIMARY_217" PRIMARY KEY ("IDCAUSAINCIDENTE");
--------------------------------------------------------
--  Constraints for Table CENTRORESULTADO
--------------------------------------------------------

ALTER TABLE "CENTRORESULTADO" MODIFY ("SITUACAO" NOT NULL ENABLE);
ALTER TABLE "CENTRORESULTADO" MODIFY ("NOMECENTRORESULTADO" NOT NULL ENABLE);
ALTER TABLE "CENTRORESULTADO" MODIFY ("CODIGOCENTRORESULTADO" NOT NULL ENABLE);
ALTER TABLE "CENTRORESULTADO" MODIFY ("IDCENTRORESULTADO" NOT NULL ENABLE);
ALTER TABLE "CENTRORESULTADO" ADD CONSTRAINT "PRIMARY_218" PRIMARY KEY ("IDCENTRORESULTADO");
--------------------------------------------------------
--  Constraints for Table CIDADES
--------------------------------------------------------

ALTER TABLE "CIDADES" ADD CONSTRAINT "PRIMARY_287" PRIMARY KEY ("IDCIDADE");
ALTER TABLE "CIDADES" MODIFY ("IDUF" NOT NULL ENABLE);
ALTER TABLE "CIDADES" MODIFY ("NOMECIDADE" NOT NULL ENABLE);
ALTER TABLE "CIDADES" MODIFY ("IDCIDADE" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table CLIENTES
--------------------------------------------------------

ALTER TABLE "CLIENTES" MODIFY ("SITUACAO" NOT NULL ENABLE);
ALTER TABLE "CLIENTES" MODIFY ("NOMERAZAOSOCIAL" NOT NULL ENABLE);
ALTER TABLE "CLIENTES" MODIFY ("IDCLIENTE" NOT NULL ENABLE);
ALTER TABLE "CLIENTES" ADD CONSTRAINT "PRIMARY_288" PRIMARY KEY ("IDCLIENTE");
--------------------------------------------------------
--  Constraints for Table COLECAO
--------------------------------------------------------

ALTER TABLE "COLECAO" MODIFY ("IDCOLECAO" NOT NULL ENABLE);
ALTER TABLE "COLECAO" ADD CONSTRAINT "PRIMARY_248" PRIMARY KEY ("IDCOLECAO");
--------------------------------------------------------
--  Constraints for Table COLETAPRECO
--------------------------------------------------------

ALTER TABLE "COLETAPRECO" MODIFY ("QUANTIDADECOTADA" NOT NULL ENABLE);
ALTER TABLE "COLETAPRECO" MODIFY ("PRAZOGARANTIA" NOT NULL ENABLE);
ALTER TABLE "COLETAPRECO" MODIFY ("TAXAJUROS" NOT NULL ENABLE);
ALTER TABLE "COLETAPRECO" MODIFY ("PRAZOMEDIOPAGTO" NOT NULL ENABLE);
ALTER TABLE "COLETAPRECO" MODIFY ("PRAZOENTREGA" NOT NULL ENABLE);
ALTER TABLE "COLETAPRECO" MODIFY ("VALORFRETE" NOT NULL ENABLE);
ALTER TABLE "COLETAPRECO" MODIFY ("VALORDESCONTO" NOT NULL ENABLE);
ALTER TABLE "COLETAPRECO" MODIFY ("VALORACRESCIMO" NOT NULL ENABLE);
ALTER TABLE "COLETAPRECO" MODIFY ("PRECO" NOT NULL ENABLE);
ALTER TABLE "COLETAPRECO" MODIFY ("DATACOLETA" NOT NULL ENABLE);
ALTER TABLE "COLETAPRECO" MODIFY ("IDRESPONSAVEL" NOT NULL ENABLE);
ALTER TABLE "COLETAPRECO" MODIFY ("IDITEMCOTACAO" NOT NULL ENABLE);
ALTER TABLE "COLETAPRECO" MODIFY ("IDFORNECEDOR" NOT NULL ENABLE);
ALTER TABLE "COLETAPRECO" MODIFY ("IDCOLETAPRECO" NOT NULL ENABLE);
ALTER TABLE "COLETAPRECO" ADD CONSTRAINT "PRIMARY_289" PRIMARY KEY ("IDCOLETAPRECO");

--------------------------------------------------------
--  Constraints for Table COMANDO
--------------------------------------------------------

ALTER TABLE "COMANDO" MODIFY ("DESCRICAO" NOT NULL ENABLE);
ALTER TABLE "COMANDO" MODIFY ("ID" NOT NULL ENABLE);
ALTER TABLE "COMANDO" ADD CONSTRAINT "PRIMARY_249" PRIMARY KEY ("ID");
--------------------------------------------------------
--  Constraints for Table COMANDOSISTEMAOPERACIONAL
--------------------------------------------------------

ALTER TABLE "COMANDOSISTEMAOPERACIONAL" MODIFY ("COMANDO" NOT NULL ENABLE);
ALTER TABLE "COMANDOSISTEMAOPERACIONAL" MODIFY ("IDSISTEMAOPERACIONAL" NOT NULL ENABLE);
ALTER TABLE "COMANDOSISTEMAOPERACIONAL" MODIFY ("IDCOMANDO" NOT NULL ENABLE);
ALTER TABLE "COMANDOSISTEMAOPERACIONAL" MODIFY ("ID" NOT NULL ENABLE);
ALTER TABLE "COMANDOSISTEMAOPERACIONAL" ADD CONSTRAINT "PRIMARY_290" PRIMARY KEY ("ID");
--------------------------------------------------------
--  Constraints for Table COMENTARIOS
--------------------------------------------------------

ALTER TABLE "COMENTARIOS" MODIFY ("DATAINICIO" NOT NULL ENABLE);
ALTER TABLE "COMENTARIOS" MODIFY ("EMAIL" NOT NULL ENABLE);
ALTER TABLE "COMENTARIOS" MODIFY ("NOTA" NOT NULL ENABLE);
ALTER TABLE "COMENTARIOS" MODIFY ("NOME" NOT NULL ENABLE);
ALTER TABLE "COMENTARIOS" MODIFY ("COMENTARIO" NOT NULL ENABLE);
ALTER TABLE "COMENTARIOS" MODIFY ("IDBASECONHECIMENTO" NOT NULL ENABLE);
ALTER TABLE "COMENTARIOS" MODIFY ("IDCOMENTARIO" NOT NULL ENABLE);
ALTER TABLE "COMENTARIOS" ADD CONSTRAINT "PRIMARY_26" PRIMARY KEY ("IDCOMENTARIO");
--------------------------------------------------------
--  Constraints for Table COMPLEXIDADE
--------------------------------------------------------

ALTER TABLE "COMPLEXIDADE" MODIFY ("COMPLEXIDADE" NOT NULL ENABLE);
ALTER TABLE "COMPLEXIDADE" MODIFY ("IDCONTRATO" NOT NULL ENABLE);
ALTER TABLE "COMPLEXIDADE" ADD CONSTRAINT "PRIMARY_141" PRIMARY KEY ("IDCONTRATO", "COMPLEXIDADE");
--------------------------------------------------------
--  Constraints for Table CONDICAOOPERACAO
--------------------------------------------------------

ALTER TABLE "CONDICAOOPERACAO" MODIFY ("DATAINICIO" NOT NULL ENABLE);
ALTER TABLE "CONDICAOOPERACAO" MODIFY ("NOMECONDICAOOPERACAO" NOT NULL ENABLE);
ALTER TABLE "CONDICAOOPERACAO" MODIFY ("IDEMPRESA" NOT NULL ENABLE);
ALTER TABLE "CONDICAOOPERACAO" MODIFY ("IDCONDICAOOPERACAO" NOT NULL ENABLE);
ALTER TABLE "CONDICAOOPERACAO" ADD CONSTRAINT "PRIMARY_250" PRIMARY KEY ("IDCONDICAOOPERACAO");
--------------------------------------------------------
--  Constraints for Table CONHECIMENTOIC
--------------------------------------------------------

ALTER TABLE "CONHECIMENTOIC" MODIFY ("IDBASECONHECIMENTO" NOT NULL ENABLE);
ALTER TABLE "CONHECIMENTOIC" MODIFY ("IDITEMCONFIGURACAO" NOT NULL ENABLE);
ALTER TABLE "CONHECIMENTOIC" ADD CONSTRAINT "PRIMARY_67" PRIMARY KEY ("IDITEMCONFIGURACAO", "IDBASECONHECIMENTO");
--------------------------------------------------------
--  Constraints for Table CONHECIMENTOMUDANCA
--------------------------------------------------------

ALTER TABLE "CONHECIMENTOMUDANCA" MODIFY ("IDBASECONHECIMENTO" NOT NULL ENABLE);
ALTER TABLE "CONHECIMENTOMUDANCA" MODIFY ("IDREQUISICAOMUDANCA" NOT NULL ENABLE);
ALTER TABLE "CONHECIMENTOMUDANCA" ADD CONSTRAINT "PRIMARY_219" PRIMARY KEY ("IDREQUISICAOMUDANCA", "IDBASECONHECIMENTO");
--------------------------------------------------------
--  Constraints for Table CONHECIMENTOPROBLEMA
--------------------------------------------------------

ALTER TABLE "CONHECIMENTOPROBLEMA" MODIFY ("IDBASECONHECIMENTO" NOT NULL ENABLE);
ALTER TABLE "CONHECIMENTOPROBLEMA" MODIFY ("IDPROBLEMA" NOT NULL ENABLE);
ALTER TABLE "CONHECIMENTOPROBLEMA" ADD CONSTRAINT "PRIMARY_27" PRIMARY KEY ("IDPROBLEMA", "IDBASECONHECIMENTO");
--------------------------------------------------------
--  Constraints for Table CONHECIMENTOSOLICITACAOSERVICO
--------------------------------------------------------

ALTER TABLE "CONHECIMENTOSOLICITACAOSERVICO" MODIFY ("IDBASECONHECIMENTO" NOT NULL ENABLE);
ALTER TABLE "CONHECIMENTOSOLICITACAOSERVICO" MODIFY ("IDSOLICITACAOSERVICO" NOT NULL ENABLE);
ALTER TABLE "CONHECIMENTOSOLICITACAOSERVICO" ADD CONSTRAINT "PRIMARY_185" PRIMARY KEY ("IDSOLICITACAOSERVICO", "IDBASECONHECIMENTO");
--------------------------------------------------------
--  Constraints for Table CONTADORACESSO
--------------------------------------------------------

ALTER TABLE "CONTADORACESSO" MODIFY ("CONTADORACESSO" NOT NULL ENABLE);
ALTER TABLE "CONTADORACESSO" MODIFY ("DATAHORAACESSO" NOT NULL ENABLE);
ALTER TABLE "CONTADORACESSO" MODIFY ("IDCONTADORACESSO" NOT NULL ENABLE);
ALTER TABLE "CONTADORACESSO" ADD CONSTRAINT "PRIMARY_186" PRIMARY KEY ("IDCONTADORACESSO");
--------------------------------------------------------
--  Constraints for Table CONTATOCLIENTE
--------------------------------------------------------

ALTER TABLE "CONTATOCLIENTE" MODIFY ("NOME" NOT NULL ENABLE);
ALTER TABLE "CONTATOCLIENTE" MODIFY ("IDCLIENTE" NOT NULL ENABLE);
ALTER TABLE "CONTATOCLIENTE" MODIFY ("IDCONTATOCLIENTE" NOT NULL ENABLE);
ALTER TABLE "CONTATOCLIENTE" ADD CONSTRAINT "PRIMARY_291" PRIMARY KEY ("IDCONTATOCLIENTE");
--------------------------------------------------------
--  Constraints for Table CONTATOREQUISICAOMUDANCA
--------------------------------------------------------

ALTER TABLE "CONTATOREQUISICAOMUDANCA" MODIFY ("IDCONTATOREQUISICAOMUDANCA" NOT NULL ENABLE);
ALTER TABLE "CONTATOREQUISICAOMUDANCA" ADD CONSTRAINT "PRIMARY_251" PRIMARY KEY ("IDCONTATOREQUISICAOMUDANCA");
--------------------------------------------------------
--  Constraints for Table CONTATOSOLICITACAOSERVICO
--------------------------------------------------------

ALTER TABLE "CONTATOSOLICITACAOSERVICO" MODIFY ("EMAILCONTATO" NOT NULL ENABLE);
ALTER TABLE "CONTATOSOLICITACAOSERVICO" MODIFY ("NOMECONTATO" NOT NULL ENABLE);
ALTER TABLE "CONTATOSOLICITACAOSERVICO" MODIFY ("IDCONTATOSOLICITACAOSERVICO" NOT NULL ENABLE);
ALTER TABLE "CONTATOSOLICITACAOSERVICO" ADD CONSTRAINT "PRIMARY_142" PRIMARY KEY ("IDCONTATOSOLICITACAOSERVICO");
--------------------------------------------------------
--  Constraints for Table CONTRATOQUESTIONARIOS
--------------------------------------------------------

ALTER TABLE "CONTRATOQUESTIONARIOS" MODIFY ("DATAQUESTIONARIO" NOT NULL ENABLE);
ALTER TABLE "CONTRATOQUESTIONARIOS" MODIFY ("IDCONTRATO" NOT NULL ENABLE);
ALTER TABLE "CONTRATOQUESTIONARIOS" MODIFY ("IDQUESTIONARIO" NOT NULL ENABLE);
ALTER TABLE "CONTRATOQUESTIONARIOS" MODIFY ("IDCONTRATOQUESTIONARIO" NOT NULL ENABLE);
ALTER TABLE "CONTRATOQUESTIONARIOS" ADD CONSTRAINT "PRIMARY_220" PRIMARY KEY ("IDCONTRATOQUESTIONARIO");
--------------------------------------------------------
--  Constraints for Table CONTRATOS
--------------------------------------------------------

ALTER TABLE "CONTRATOS" MODIFY ("SITUACAO" NOT NULL ENABLE);
ALTER TABLE "CONTRATOS" MODIFY ("TIPO" NOT NULL ENABLE);
ALTER TABLE "CONTRATOS" MODIFY ("DATACONTRATO" NOT NULL ENABLE);
ALTER TABLE "CONTRATOS" MODIFY ("NUMERO" NOT NULL ENABLE);
ALTER TABLE "CONTRATOS" MODIFY ("IDFORNECEDOR" NOT NULL ENABLE);
ALTER TABLE "CONTRATOS" MODIFY ("IDCLIENTE" NOT NULL ENABLE);
ALTER TABLE "CONTRATOS" MODIFY ("IDCONTRATO" NOT NULL ENABLE);
ALTER TABLE "CONTRATOS" ADD CONSTRAINT "PRIMARY_108" PRIMARY KEY ("IDCONTRATO");
--------------------------------------------------------
--  Constraints for Table CONTRATOSCOLABORADORES
--------------------------------------------------------

ALTER TABLE "CONTRATOSCOLABORADORES" MODIFY ("IDCONTRATO" NOT NULL ENABLE);
ALTER TABLE "CONTRATOSCOLABORADORES" MODIFY ("IDEMPREGADO" NOT NULL ENABLE);
ALTER TABLE "CONTRATOSCOLABORADORES" ADD CONSTRAINT "PRIMARY_187" PRIMARY KEY ("IDEMPREGADO", "IDCONTRATO");
--------------------------------------------------------
--  Constraints for Table CONTRATOSGRUPOS
--------------------------------------------------------

ALTER TABLE "CONTRATOSGRUPOS" MODIFY ("IDCONTRATO" NOT NULL ENABLE);
ALTER TABLE "CONTRATOSGRUPOS" MODIFY ("IDGRUPO" NOT NULL ENABLE);
ALTER TABLE "CONTRATOSGRUPOS" ADD CONSTRAINT "PRIMARY_188" PRIMARY KEY ("IDGRUPO", "IDCONTRATO");
--------------------------------------------------------
--  Constraints for Table CONTRATOS_HIST
--------------------------------------------------------

ALTER TABLE "CONTRATOS_HIST" MODIFY ("DATACONTRATO" NOT NULL ENABLE);
ALTER TABLE "CONTRATOS_HIST" MODIFY ("NUMERO" NOT NULL ENABLE);
ALTER TABLE "CONTRATOS_HIST" MODIFY ("IDFORNECEDOR" NOT NULL ENABLE);
ALTER TABLE "CONTRATOS_HIST" MODIFY ("IDCLIENTE" NOT NULL ENABLE);
ALTER TABLE "CONTRATOS_HIST" MODIFY ("IDCONTRATO" NOT NULL ENABLE);
ALTER TABLE "CONTRATOS_HIST" MODIFY ("IDCONTRATO_HIST" NOT NULL ENABLE);
ALTER TABLE "CONTRATOS_HIST" MODIFY ("MODIFICADOEM" NOT NULL ENABLE);
ALTER TABLE "CONTRATOS_HIST" MODIFY ("CRIADOEM" NOT NULL ENABLE);
ALTER TABLE "CONTRATOS_HIST" MODIFY ("SITUACAO" NOT NULL ENABLE);
ALTER TABLE "CONTRATOS_HIST" MODIFY ("TIPO" NOT NULL ENABLE);
ALTER TABLE "CONTRATOS_HIST" ADD CONSTRAINT "PRIMARY_68" PRIMARY KEY ("IDCONTRATO_HIST");
--------------------------------------------------------
--  Constraints for Table CONTRATOSUNIDADES
--------------------------------------------------------

ALTER TABLE "CONTRATOSUNIDADES" MODIFY ("IDCONTRATO" NOT NULL ENABLE);
ALTER TABLE "CONTRATOSUNIDADES" MODIFY ("IDUNIDADE" NOT NULL ENABLE);
ALTER TABLE "CONTRATOSUNIDADES" ADD CONSTRAINT "PRIMARY_252" PRIMARY KEY ("IDUNIDADE", "IDCONTRATO");
--------------------------------------------------------
--  Constraints for Table CONTROLEGED
--------------------------------------------------------

ALTER TABLE "CONTROLEGED" MODIFY ("DATAHORA" NOT NULL ENABLE);
ALTER TABLE "CONTROLEGED" MODIFY ("NOMEARQUIVO" NOT NULL ENABLE);
ALTER TABLE "CONTROLEGED" MODIFY ("ID" NOT NULL ENABLE);
ALTER TABLE "CONTROLEGED" MODIFY ("IDTABELA" NOT NULL ENABLE);
ALTER TABLE "CONTROLEGED" MODIFY ("IDCONTROLEGED" NOT NULL ENABLE);
ALTER TABLE "CONTROLEGED" ADD CONSTRAINT "PRIMARY_28" PRIMARY KEY ("IDCONTROLEGED");
--------------------------------------------------------
--  Constraints for Table CONTROLEQUESTIONARIOS
--------------------------------------------------------

ALTER TABLE "CONTROLEQUESTIONARIOS" MODIFY ("IDCONTROLEQUESTIONARIO" NOT NULL ENABLE);
ALTER TABLE "CONTROLEQUESTIONARIOS" ADD CONSTRAINT "PRIMARY_221" PRIMARY KEY ("IDCONTROLEQUESTIONARIO");
--------------------------------------------------------
--  Constraints for Table COTACAO
--------------------------------------------------------

ALTER TABLE "COTACAO" MODIFY ("DATAHORACADASTRO" NOT NULL ENABLE);
ALTER TABLE "COTACAO" MODIFY ("SITUACAO" NOT NULL ENABLE);
ALTER TABLE "COTACAO" MODIFY ("IDRESPONSAVEL" NOT NULL ENABLE);
ALTER TABLE "COTACAO" MODIFY ("IDEMPRESA" NOT NULL ENABLE);
ALTER TABLE "COTACAO" MODIFY ("IDCOTACAO" NOT NULL ENABLE);
ALTER TABLE "COTACAO" ADD CONSTRAINT "PRIMARY_143" PRIMARY KEY ("IDCOTACAO");
--------------------------------------------------------
--  Constraints for Table COTACAOITEMREQUISICAO
--------------------------------------------------------

ALTER TABLE "COTACAOITEMREQUISICAO" MODIFY ("QUANTIDADE" NOT NULL ENABLE);
ALTER TABLE "COTACAOITEMREQUISICAO" MODIFY ("IDITEMREQUISICAOPRODUTO" NOT NULL ENABLE);
ALTER TABLE "COTACAOITEMREQUISICAO" MODIFY ("IDCOLETAPRECO" NOT NULL ENABLE);
ALTER TABLE "COTACAOITEMREQUISICAO" ADD CONSTRAINT "PRIMARY_292" PRIMARY KEY ("IDCOLETAPRECO", "IDITEMREQUISICAOPRODUTO");
--------------------------------------------------------
--  Constraints for Table CRITERIOAVALIACAO
--------------------------------------------------------

ALTER TABLE "CRITERIOAVALIACAO" MODIFY ("TIPOAVALIACAO" NOT NULL ENABLE);
ALTER TABLE "CRITERIOAVALIACAO" MODIFY ("APLICAVELQUALIFICACAOFORNECEDO" NOT NULL ENABLE);
ALTER TABLE "CRITERIOAVALIACAO" MODIFY ("APLICAVELAVALIACAOCOMPRADOR" NOT NULL ENABLE);
ALTER TABLE "CRITERIOAVALIACAO" MODIFY ("APLICAVELAVALIACAOSOLICITANTE" NOT NULL ENABLE);
ALTER TABLE "CRITERIOAVALIACAO" MODIFY ("APLICAVELCOTACAO" NOT NULL ENABLE);
ALTER TABLE "CRITERIOAVALIACAO" MODIFY ("DESCRICAO" NOT NULL ENABLE);
ALTER TABLE "CRITERIOAVALIACAO" MODIFY ("IDCRITERIO" NOT NULL ENABLE);
ALTER TABLE "CRITERIOAVALIACAO" ADD CONSTRAINT "PRIMARY_69" PRIMARY KEY ("IDCRITERIO");
--------------------------------------------------------
--  Constraints for Table CRITERIOAVALIACAOFORNECEDOR
--------------------------------------------------------

ALTER TABLE "CRITERIOAVALIACAOFORNECEDOR" MODIFY ("IDCRITERIO" NOT NULL ENABLE);
ALTER TABLE "CRITERIOAVALIACAOFORNECEDOR" MODIFY ("IDAVALIACAOFORNECEDOR" NOT NULL ENABLE);
ALTER TABLE "CRITERIOAVALIACAOFORNECEDOR" ADD CONSTRAINT "PRIMARY_253" PRIMARY KEY ("IDAVALIACAOFORNECEDOR", "IDCRITERIO");
--------------------------------------------------------
--  Constraints for Table CRITERIOCOTACAO
--------------------------------------------------------

ALTER TABLE "CRITERIOCOTACAO" MODIFY ("PESO" NOT NULL ENABLE);
ALTER TABLE "CRITERIOCOTACAO" MODIFY ("IDCRITERIO" NOT NULL ENABLE);
ALTER TABLE "CRITERIOCOTACAO" MODIFY ("IDCOTACAO" NOT NULL ENABLE);
ALTER TABLE "CRITERIOCOTACAO" ADD CONSTRAINT "PRIMARY_109" PRIMARY KEY ("IDCOTACAO", "IDCRITERIO");
--------------------------------------------------------
--  Constraints for Table CRITERIOCOTACAOCATEGORIA
--------------------------------------------------------

ALTER TABLE "CRITERIOCOTACAOCATEGORIA" MODIFY ("PESOCOTACAO" NOT NULL ENABLE);
ALTER TABLE "CRITERIOCOTACAOCATEGORIA" MODIFY ("IDCRITERIO" NOT NULL ENABLE);
ALTER TABLE "CRITERIOCOTACAOCATEGORIA" MODIFY ("IDCATEGORIA" NOT NULL ENABLE);
ALTER TABLE "CRITERIOCOTACAOCATEGORIA" ADD CONSTRAINT "PRIMARY_70" PRIMARY KEY ("IDCATEGORIA", "IDCRITERIO");
--------------------------------------------------------
--  Constraints for Table CRITERIOITEMCOTACAO
--------------------------------------------------------

ALTER TABLE "CRITERIOITEMCOTACAO" MODIFY ("PESO" NOT NULL ENABLE);
ALTER TABLE "CRITERIOITEMCOTACAO" MODIFY ("IDCRITERIO" NOT NULL ENABLE);
ALTER TABLE "CRITERIOITEMCOTACAO" MODIFY ("IDITEMCOTACAO" NOT NULL ENABLE);
ALTER TABLE "CRITERIOITEMCOTACAO" ADD CONSTRAINT "PRIMARY_254" PRIMARY KEY ("IDCRITERIO", "IDITEMCOTACAO");
--------------------------------------------------------
--  Constraints for Table DEMANDAS
--------------------------------------------------------

ALTER TABLE "DEMANDAS" MODIFY ("PRIORIDADE" NOT NULL ENABLE);
ALTER TABLE "DEMANDAS" MODIFY ("IDFLUXO" NOT NULL ENABLE);
ALTER TABLE "DEMANDAS" MODIFY ("IDTIPODEMANDA" NOT NULL ENABLE);
ALTER TABLE "DEMANDAS" MODIFY ("IDSITUACAODEMANDA" NOT NULL ENABLE);
ALTER TABLE "DEMANDAS" MODIFY ("IDDEMANDA" NOT NULL ENABLE);
ALTER TABLE "DEMANDAS" ADD CONSTRAINT "PRIMARY_222" PRIMARY KEY ("IDDEMANDA");
--------------------------------------------------------
--  Constraints for Table DICIONARIO
--------------------------------------------------------

ALTER TABLE "DICIONARIO" MODIFY ("IDDICIONARIO" NOT NULL ENABLE);
ALTER TABLE "DICIONARIO" ADD CONSTRAINT "PRIMARY_255" PRIMARY KEY ("IDDICIONARIO");
--------------------------------------------------------
--  Constraints for Table EMAILSOLICITACAOSERVICO
--------------------------------------------------------

ALTER TABLE "EMAILSOLICITACAOSERVICO" MODIFY ("IDEMAILSOLICITACAOSERVICO" NOT NULL ENABLE);
ALTER TABLE "EMAILSOLICITACAOSERVICO" MODIFY ("SITUACAO" NOT NULL ENABLE);
ALTER TABLE "EMAILSOLICITACAOSERVICO" MODIFY ("MESSAGEID" NOT NULL ENABLE);
ALTER TABLE "EMAILSOLICITACAOSERVICO" ADD CONSTRAINT "PRIMARY_223" PRIMARY KEY ("IDEMAILSOLICITACAOSERVICO");
--------------------------------------------------------
--  Constraints for Table EMPREGADOITEMCONFIGURACAO
--------------------------------------------------------

ALTER TABLE "EMPREGADOITEMCONFIGURACAO" MODIFY ("DATAINICIO" NOT NULL ENABLE);
ALTER TABLE "EMPREGADOITEMCONFIGURACAO" MODIFY ("IDITEMCONFIGURACAO" NOT NULL ENABLE);
ALTER TABLE "EMPREGADOITEMCONFIGURACAO" MODIFY ("IDUSUARIO" NOT NULL ENABLE);
ALTER TABLE "EMPREGADOITEMCONFIGURACAO" ADD CONSTRAINT "PRIMARY_293" PRIMARY KEY ("IDUSUARIO", "IDITEMCONFIGURACAO");
--------------------------------------------------------
--  Constraints for Table EMPREGADOS
--------------------------------------------------------

ALTER TABLE "EMPREGADOS" MODIFY ("IDSITUACAOFUNCIONAL" NOT NULL ENABLE);
ALTER TABLE "EMPREGADOS" MODIFY ("NOME" NOT NULL ENABLE);
ALTER TABLE "EMPREGADOS" MODIFY ("IDEMPREGADO" NOT NULL ENABLE);
ALTER TABLE "EMPREGADOS" ADD CONSTRAINT "PRIMARY_224" PRIMARY KEY ("IDEMPREGADO");
--------------------------------------------------------
--  Constraints for Table EMPRESA
--------------------------------------------------------

ALTER TABLE "EMPRESA" MODIFY ("NOMEEMPRESA" NOT NULL ENABLE);
ALTER TABLE "EMPRESA" MODIFY ("IDEMPRESA" NOT NULL ENABLE);
ALTER TABLE "EMPRESA" ADD CONSTRAINT "PRIMARY_110" PRIMARY KEY ("IDEMPRESA");
--------------------------------------------------------
--  Constraints for Table ENDERECO
--------------------------------------------------------

ALTER TABLE "ENDERECO" MODIFY ("IDENDERECO" NOT NULL ENABLE);
ALTER TABLE "ENDERECO" ADD CONSTRAINT "PRIMARY_111" PRIMARY KEY ("IDENDERECO");
--------------------------------------------------------
--  Constraints for Table ENTREGAITEMREQUISICAO
--------------------------------------------------------

ALTER TABLE "ENTREGAITEMREQUISICAO" MODIFY ("SITUACAO" NOT NULL ENABLE);
ALTER TABLE "ENTREGAITEMREQUISICAO" MODIFY ("QUANTIDADEENTREGUE" NOT NULL ENABLE);
ALTER TABLE "ENTREGAITEMREQUISICAO" MODIFY ("IDITEMREQUISICAOPRODUTO" NOT NULL ENABLE);
ALTER TABLE "ENTREGAITEMREQUISICAO" MODIFY ("IDCOLETAPRECO" NOT NULL ENABLE);
ALTER TABLE "ENTREGAITEMREQUISICAO" MODIFY ("IDPEDIDO" NOT NULL ENABLE);
ALTER TABLE "ENTREGAITEMREQUISICAO" MODIFY ("IDENTREGA" NOT NULL ENABLE);
ALTER TABLE "ENTREGAITEMREQUISICAO" ADD CONSTRAINT "PRIMARY_29" PRIMARY KEY ("IDENTREGA");
--------------------------------------------------------
--  Constraints for Table ETAPAS
--------------------------------------------------------

ALTER TABLE "ETAPAS" MODIFY ("ORDEM" NOT NULL ENABLE);
ALTER TABLE "ETAPAS" MODIFY ("NOMEETAPA" NOT NULL ENABLE);
ALTER TABLE "ETAPAS" MODIFY ("IDFLUXO" NOT NULL ENABLE);
ALTER TABLE "ETAPAS" MODIFY ("IDETAPA" NOT NULL ENABLE);
ALTER TABLE "ETAPAS" ADD CONSTRAINT "PRIMARY_294" PRIMARY KEY ("IDETAPA");
--------------------------------------------------------
--  Constraints for Table EVENTO
--------------------------------------------------------

ALTER TABLE "EVENTO" ADD CONSTRAINT "PRIMARY_256" PRIMARY KEY ("IDEVENTO");
ALTER TABLE "EVENTO" MODIFY ("LIGARCASODESL" NOT NULL ENABLE);
ALTER TABLE "EVENTO" MODIFY ("DESCRICAO" NOT NULL ENABLE);
ALTER TABLE "EVENTO" MODIFY ("IDEMPRESA" NOT NULL ENABLE);
ALTER TABLE "EVENTO" MODIFY ("IDEVENTO" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table EVENTOEMPREGADO
--------------------------------------------------------

ALTER TABLE "EVENTOEMPREGADO" MODIFY ("IDEMPREGADO" NOT NULL ENABLE);
ALTER TABLE "EVENTOEMPREGADO" MODIFY ("IDEVENTO" NOT NULL ENABLE);
ALTER TABLE "EVENTOEMPREGADO" ADD CONSTRAINT "PRIMARY_295" PRIMARY KEY ("IDEVENTO", "IDEMPREGADO");
--------------------------------------------------------
--  Constraints for Table EVENTOITEMCONFIGURACAO
--------------------------------------------------------

ALTER TABLE "EVENTOITEMCONFIGURACAO" MODIFY ("IDITEMCONFIGURACAO" NOT NULL ENABLE);
ALTER TABLE "EVENTOITEMCONFIGURACAO" MODIFY ("IDEVENTO" NOT NULL ENABLE);
ALTER TABLE "EVENTOITEMCONFIGURACAO" ADD CONSTRAINT "PRIMARY_71" PRIMARY KEY ("IDEVENTO", "IDITEMCONFIGURACAO");
--------------------------------------------------------
--  Constraints for Table EVENTOMONITCONHECIMENTO
--------------------------------------------------------

ALTER TABLE "EVENTOMONITCONHECIMENTO" MODIFY ("IDBASECONHECIMENTO" NOT NULL ENABLE);
ALTER TABLE "EVENTOMONITCONHECIMENTO" MODIFY ("IDEVENTOMONITORAMENTO" NOT NULL ENABLE);
ALTER TABLE "EVENTOMONITCONHECIMENTO" ADD CONSTRAINT "PRIMARY_112" PRIMARY KEY ("IDEVENTOMONITORAMENTO", "IDBASECONHECIMENTO");
--------------------------------------------------------
--  Constraints for Table EVENTOMONITORAMENTO
--------------------------------------------------------

ALTER TABLE "EVENTOMONITORAMENTO" MODIFY ("NOMEEVENTO" NOT NULL ENABLE);
ALTER TABLE "EVENTOMONITORAMENTO" MODIFY ("IDEVENTOMONITORAMENTO" NOT NULL ENABLE);
ALTER TABLE "EVENTOMONITORAMENTO" ADD CONSTRAINT "PRIMARY_296" PRIMARY KEY ("IDEVENTOMONITORAMENTO");
--------------------------------------------------------
--  Constraints for Table EXCECAOCALENDARIO
--------------------------------------------------------

ALTER TABLE "EXCECAOCALENDARIO" MODIFY ("DATATERMINO" NOT NULL ENABLE);
ALTER TABLE "EXCECAOCALENDARIO" MODIFY ("DATAINICIO" NOT NULL ENABLE);
ALTER TABLE "EXCECAOCALENDARIO" MODIFY ("TIPO" NOT NULL ENABLE);
ALTER TABLE "EXCECAOCALENDARIO" MODIFY ("IDCALENDARIO" NOT NULL ENABLE);
ALTER TABLE "EXCECAOCALENDARIO" MODIFY ("IDEXCECAOCALENDARIO" NOT NULL ENABLE);
ALTER TABLE "EXCECAOCALENDARIO" ADD CONSTRAINT "PRIMARY_144" PRIMARY KEY ("IDEXCECAOCALENDARIO");
--------------------------------------------------------
--  Constraints for Table EXCECAOEMPREGADO
--------------------------------------------------------

ALTER TABLE "EXCECAOEMPREGADO" MODIFY ("IDEMPREGADO" NOT NULL ENABLE);
ALTER TABLE "EXCECAOEMPREGADO" MODIFY ("IDEVENTO" NOT NULL ENABLE);
ALTER TABLE "EXCECAOEMPREGADO" ADD CONSTRAINT "PRIMARY_189" PRIMARY KEY ("IDEVENTO", "IDEMPREGADO");
--------------------------------------------------------
--  Constraints for Table EXECUCAOATIVIDADEPERIODICA
--------------------------------------------------------

ALTER TABLE "EXECUCAOATIVIDADEPERIODICA" MODIFY ("SITUACAO" NOT NULL ENABLE);
ALTER TABLE "EXECUCAOATIVIDADEPERIODICA" MODIFY ("DATAPROGRAMADA" NOT NULL ENABLE);
ALTER TABLE "EXECUCAOATIVIDADEPERIODICA" MODIFY ("IDATIVIDADEPERIODICA" NOT NULL ENABLE);
ALTER TABLE "EXECUCAOATIVIDADEPERIODICA" MODIFY ("IDEXECUCAOATIVIDADEPERIODICA" NOT NULL ENABLE);
ALTER TABLE "EXECUCAOATIVIDADEPERIODICA" ADD CONSTRAINT "PRIMARY_145" PRIMARY KEY ("IDEXECUCAOATIVIDADEPERIODICA");
--------------------------------------------------------
--  Constraints for Table EXECUCAOBATCH
--------------------------------------------------------

ALTER TABLE "EXECUCAOBATCH" MODIFY ("DATAHORA" NOT NULL ENABLE);
ALTER TABLE "EXECUCAOBATCH" MODIFY ("CONTEUDO" NOT NULL ENABLE);
ALTER TABLE "EXECUCAOBATCH" MODIFY ("IDPROCESSAMENTOBATCH" NOT NULL ENABLE);
ALTER TABLE "EXECUCAOBATCH" MODIFY ("IDEXECUCAOBATCH" NOT NULL ENABLE);
ALTER TABLE "EXECUCAOBATCH" ADD CONSTRAINT "PRIMARY_146" PRIMARY KEY ("IDEXECUCAOBATCH");
--------------------------------------------------------
--  Constraints for Table EXECUCAODEMANDA
--------------------------------------------------------

ALTER TABLE "EXECUCAODEMANDA" MODIFY ("SITUACAO" NOT NULL ENABLE);
ALTER TABLE "EXECUCAODEMANDA" MODIFY ("IDATIVIDADE" NOT NULL ENABLE);
ALTER TABLE "EXECUCAODEMANDA" MODIFY ("IDDEMANDA" NOT NULL ENABLE);
ALTER TABLE "EXECUCAODEMANDA" MODIFY ("IDEXECUCAO" NOT NULL ENABLE);
ALTER TABLE "EXECUCAODEMANDA" ADD CONSTRAINT "PRIMARY_147" PRIMARY KEY ("IDEXECUCAO");
--------------------------------------------------------
--  Constraints for Table EXECUCAOMUDANCA
--------------------------------------------------------

ALTER TABLE "EXECUCAOMUDANCA" MODIFY ("IDFLUXO" NOT NULL ENABLE);
ALTER TABLE "EXECUCAOMUDANCA" MODIFY ("IDREQUISICAOMUDANCA" NOT NULL ENABLE);
ALTER TABLE "EXECUCAOMUDANCA" MODIFY ("IDINSTANCIAFLUXO" NOT NULL ENABLE);
ALTER TABLE "EXECUCAOMUDANCA" MODIFY ("IDEXECUCAO" NOT NULL ENABLE);
ALTER TABLE "EXECUCAOMUDANCA" ADD CONSTRAINT "PRIMARY_190" PRIMARY KEY ("IDEXECUCAO");
--------------------------------------------------------
--  Constraints for Table EXECUCAOSOLICITACAO
--------------------------------------------------------

ALTER TABLE "EXECUCAOSOLICITACAO" MODIFY ("IDEXECUCAO" NOT NULL ENABLE);
ALTER TABLE "EXECUCAOSOLICITACAO" ADD CONSTRAINT "PRIMARY_191" PRIMARY KEY ("IDEXECUCAO");
--------------------------------------------------------
--  Constraints for Table EXTERNALCONNECTION
--------------------------------------------------------

ALTER TABLE "EXTERNALCONNECTION" MODIFY ("TIPO" NOT NULL ENABLE);
ALTER TABLE "EXTERNALCONNECTION" MODIFY ("NOME" NOT NULL ENABLE);
ALTER TABLE "EXTERNALCONNECTION" MODIFY ("IDEXTERNALCONNECTION" NOT NULL ENABLE);
ALTER TABLE "EXTERNALCONNECTION" ADD CONSTRAINT "PRIMARY_225" PRIMARY KEY ("IDEXTERNALCONNECTION");
--------------------------------------------------------
--  Constraints for Table FAIXAVALORESRECURSO
--------------------------------------------------------

ALTER TABLE "FAIXAVALORESRECURSO" MODIFY ("IDRECURSO" NOT NULL ENABLE);
ALTER TABLE "FAIXAVALORESRECURSO" MODIFY ("IDFAIXAVALORESRECURSO" NOT NULL ENABLE);
ALTER TABLE "FAIXAVALORESRECURSO" ADD CONSTRAINT "PRIMARY_148" PRIMARY KEY ("IDFAIXAVALORESRECURSO");
--------------------------------------------------------
--  Constraints for Table FASESERVICO
--------------------------------------------------------

ALTER TABLE "FASESERVICO" MODIFY ("FASECAPTURA" NOT NULL ENABLE);
ALTER TABLE "FASESERVICO" MODIFY ("NOMEFASE" NOT NULL ENABLE);
ALTER TABLE "FASESERVICO" MODIFY ("IDFASE" NOT NULL ENABLE);
ALTER TABLE "FASESERVICO" ADD CONSTRAINT "PRIMARY_113" PRIMARY KEY ("IDFASE");
--------------------------------------------------------
--  Constraints for Table FATURA
--------------------------------------------------------

ALTER TABLE "FATURA" MODIFY ("IDFATURA" NOT NULL ENABLE);
ALTER TABLE "FATURA" MODIFY ("IDCONTRATO" NOT NULL ENABLE);
ALTER TABLE "FATURA" MODIFY ("SITUACAOFATURA" NOT NULL ENABLE);
ALTER TABLE "FATURA" MODIFY ("DATAULTMODIFICACAO" NOT NULL ENABLE);
ALTER TABLE "FATURA" MODIFY ("DATACRIACAO" NOT NULL ENABLE);
ALTER TABLE "FATURA" MODIFY ("VALORCOTACAOMOEDA" NOT NULL ENABLE);
ALTER TABLE "FATURA" MODIFY ("DATAFINAL" NOT NULL ENABLE);
ALTER TABLE "FATURA" MODIFY ("DATAINICIAL" NOT NULL ENABLE);
ALTER TABLE "FATURA" ADD CONSTRAINT "PRIMARY_149" PRIMARY KEY ("IDFATURA");
--------------------------------------------------------
--  Constraints for Table FATURAAPURACAOANS
--------------------------------------------------------

ALTER TABLE "FATURAAPURACAOANS" MODIFY ("IDFATURAAPURACAOANS" NOT NULL ENABLE);
ALTER TABLE "FATURAAPURACAOANS" MODIFY ("IDFATURA" NOT NULL ENABLE);
ALTER TABLE "FATURAAPURACAOANS" MODIFY ("IDACORDONIVELSERVICOCONTRATO" NOT NULL ENABLE);
ALTER TABLE "FATURAAPURACAOANS" ADD CONSTRAINT "PRIMARY_257" PRIMARY KEY ("IDFATURAAPURACAOANS");
--------------------------------------------------------
--  Constraints for Table FATURAOS
--------------------------------------------------------

ALTER TABLE "FATURAOS" MODIFY ("IDOS" NOT NULL ENABLE);
ALTER TABLE "FATURAOS" MODIFY ("IDFATURA" NOT NULL ENABLE);
ALTER TABLE "FATURAOS" ADD CONSTRAINT "PRIMARY_258" PRIMARY KEY ("IDFATURA", "IDOS");
--------------------------------------------------------
--  Constraints for Table FERIADO
--------------------------------------------------------

ALTER TABLE "FERIADO" MODIFY ("DATA" NOT NULL ENABLE);
ALTER TABLE "FERIADO" MODIFY ("IDFERIADO" NOT NULL ENABLE);
ALTER TABLE "FERIADO" ADD CONSTRAINT "PRIMARY_150" PRIMARY KEY ("IDFERIADO");
--------------------------------------------------------
--  Constraints for Table FLUXO
--------------------------------------------------------

ALTER TABLE "FLUXO" MODIFY ("NOMEFLUXO" NOT NULL ENABLE);
ALTER TABLE "FLUXO" MODIFY ("IDFLUXO" NOT NULL ENABLE);
ALTER TABLE "FLUXO" ADD CONSTRAINT "PRIMARY_151" PRIMARY KEY ("IDFLUXO");
--------------------------------------------------------
--  Constraints for Table FLUXOS
--------------------------------------------------------

ALTER TABLE "FLUXOS" MODIFY ("NOMEFLUXO" NOT NULL ENABLE);
ALTER TABLE "FLUXOS" MODIFY ("IDFLUXO" NOT NULL ENABLE);
ALTER TABLE "FLUXOS" ADD CONSTRAINT "PRIMARY_192" PRIMARY KEY ("IDFLUXO");
--------------------------------------------------------
--  Constraints for Table FLUXOSERVICO
--------------------------------------------------------

ALTER TABLE "FLUXOSERVICO" MODIFY ("PRINCIPAL" NOT NULL ENABLE);
ALTER TABLE "FLUXOSERVICO" MODIFY ("IDFASE" NOT NULL ENABLE);
ALTER TABLE "FLUXOSERVICO" MODIFY ("IDTIPOFLUXO" NOT NULL ENABLE);
ALTER TABLE "FLUXOSERVICO" MODIFY ("IDSERVICOCONTRATO" NOT NULL ENABLE);
ALTER TABLE "FLUXOSERVICO" ADD CONSTRAINT "PRIMARY_152" PRIMARY KEY ("IDSERVICOCONTRATO", "IDTIPOFLUXO", "IDFASE");
-----------------------------------------------------