--
-- PostgreSQL database dump
--

-- Dumped from database version 9.1.4
-- Dumped by pg_dump version 9.1.8
-- Started on 2013-04-08 17:36:59 BRT

SET statement_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- TOC entry 480 (class 3079 OID 12506)
-- Name: plpgsql; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS plpgsql WITH SCHEMA pg_catalog;


--
-- TOC entry 6395 (class 0 OID 0)
-- Dependencies: 480
-- Name: EXTENSION plpgsql; Type: COMMENT; Schema: -; Owner: -
--



SET search_path = public, pg_catalog;

--
-- TOC entry 492 (class 1255 OID 2246017)
-- Dependencies: 5 1923
-- Name: update_acordonivelservico(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION update_acordonivelservico() RETURNS trigger
    LANGUAGE plpgsql
    AS '
BEGIN
    NEW.criadoEm := CURRENT_TIMESTAMP; 
    RETURN NEW;
END;
';


--
-- TOC entry 493 (class 1255 OID 2246042)
-- Dependencies: 1923 5
-- Name: update_acordonivelservico_hist(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION update_acordonivelservico_hist() RETURNS trigger
    LANGUAGE plpgsql
    AS '
BEGIN
    NEW.criadoem := CURRENT_TIMESTAMP; 
    RETURN NEW;
END;
';


--
-- TOC entry 494 (class 1255 OID 2246345)
-- Dependencies: 1923 5
-- Name: update_bpm_atribuicaofluxo(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION update_bpm_atribuicaofluxo() RETURNS trigger
    LANGUAGE plpgsql
    AS '
BEGIN
    NEW.datahora := CURRENT_TIMESTAMP; 
    RETURN NEW;
END;
';


--
-- TOC entry 495 (class 1255 OID 2246387)
-- Dependencies: 5 1923
-- Name: update_bpm_historicoitemtrabalho(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION update_bpm_historicoitemtrabalho() RETURNS trigger
    LANGUAGE plpgsql
    AS '
BEGIN
    NEW.datahora := CURRENT_TIMESTAMP; 
    RETURN NEW;
END;
';


--
-- TOC entry 496 (class 1255 OID 2246400)
-- Dependencies: 1923 5
-- Name: update_bpm_instanciafluxo(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION update_bpm_instanciafluxo() RETURNS trigger
    LANGUAGE plpgsql
    AS '
BEGIN
    NEW.datahoracriacao := CURRENT_TIMESTAMP; 
    RETURN NEW;
END;
';


--
-- TOC entry 497 (class 1255 OID 2246409)
-- Dependencies: 1923 5
-- Name: update_bpm_itemtrabalhofluxo(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION update_bpm_itemtrabalhofluxo() RETURNS trigger
    LANGUAGE plpgsql
    AS '
BEGIN
    NEW.datahoracriacao := CURRENT_TIMESTAMP; 
    RETURN NEW;
END;
';


--
-- TOC entry 498 (class 1255 OID 2246822)
-- Dependencies: 1923 5
-- Name: update_contratos_hist(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION update_contratos_hist() RETURNS trigger
    LANGUAGE plpgsql
    AS '
BEGIN
    NEW.criadoem := CURRENT_TIMESTAMP; 
    RETURN NEW;
END;
';


--
-- TOC entry 499 (class 1255 OID 2246859)
-- Dependencies: 1923 5
-- Name: update_controleged(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION update_controleged() RETURNS trigger
    LANGUAGE plpgsql
    AS '
BEGIN
    NEW.datahora := CURRENT_TIMESTAMP; 
    RETURN NEW;
END;
';


--
-- TOC entry 500 (class 1255 OID 2246876)
-- Dependencies: 5 1923
-- Name: update_cotacao(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION update_cotacao() RETURNS trigger
    LANGUAGE plpgsql
    AS '
BEGIN
    NEW.datahoracadastro := CURRENT_TIMESTAMP; 
    RETURN NEW;
END;
';


--
-- TOC entry 501 (class 1255 OID 2247170)
-- Dependencies: 1923 5
-- Name: update_execucaobatch(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION update_execucaobatch() RETURNS trigger
    LANGUAGE plpgsql
    AS '
BEGIN
    NEW.datahora := CURRENT_TIMESTAMP; 
    RETURN NEW;
END;
';


--
-- TOC entry 502 (class 1255 OID 2247538)
-- Dependencies: 5 1923
-- Name: update_historicoic(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION update_historicoic() RETURNS trigger
    LANGUAGE plpgsql
    AS '
BEGIN
    NEW.datahoraalteracao := CURRENT_TIMESTAMP; 
    RETURN NEW;
END;
';


--
-- TOC entry 503 (class 1255 OID 2247550)
-- Dependencies: 1923 5
-- Name: update_historicosituacaocotacao(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION update_historicosituacaocotacao() RETURNS trigger
    LANGUAGE plpgsql
    AS '
BEGIN
    NEW.datahora := CURRENT_TIMESTAMP; 
    RETURN NEW;
END;
';


--
-- TOC entry 504 (class 1255 OID 2247588)
-- Dependencies: 5 1923
-- Name: update_historicovalor(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION update_historicovalor() RETURNS trigger
    LANGUAGE plpgsql
    AS '
BEGIN
    NEW.datahoraalteracao := CURRENT_TIMESTAMP; 
    RETURN NEW;
END;
';


--
-- TOC entry 505 (class 1255 OID 2247754)
-- Dependencies: 1923 5
-- Name: update_inspecaoentregaitem(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION update_inspecaoentregaitem() RETURNS trigger
    LANGUAGE plpgsql
    AS '
BEGIN
    NEW.datahorainspecao := CURRENT_TIMESTAMP; 
    RETURN NEW;
END;
';


--
-- TOC entry 506 (class 1255 OID 2247778)
-- Dependencies: 1923 5
-- Name: update_inspecaopedidocompra(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION update_inspecaopedidocompra() RETURNS trigger
    LANGUAGE plpgsql
    AS '
BEGIN
    NEW.datahorainspecao := CURRENT_TIMESTAMP; 
    RETURN NEW;
END;
';


--
-- TOC entry 507 (class 1255 OID 2247871)
-- Dependencies: 5 1923
-- Name: update_itemcotacao(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION update_itemcotacao() RETURNS trigger
    LANGUAGE plpgsql
    AS '
BEGIN
    NEW.datahoralimite := CURRENT_TIMESTAMP; 
    RETURN NEW;
END;
';


--
-- TOC entry 508 (class 1255 OID 2248074)
-- Dependencies: 5 1923
-- Name: update_logdados(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION update_logdados() RETURNS trigger
    LANGUAGE plpgsql
    AS '
BEGIN
    NEW.datalog := CURRENT_TIMESTAMP; 
    RETURN NEW;
END;
';


--
-- TOC entry 509 (class 1255 OID 2248370)
-- Dependencies: 5 1923
-- Name: update_opiniao(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION update_opiniao() RETURNS trigger
    LANGUAGE plpgsql
    AS '
BEGIN
    NEW.hora := CURRENT_TIMESTAMP; 
    RETURN NEW;
END;
';


--
-- TOC entry 510 (class 1255 OID 2248444)
-- Dependencies: 5 1923
-- Name: update_parecer(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION update_parecer() RETURNS trigger
    LANGUAGE plpgsql
    AS '
BEGIN
    NEW.datahoraparecer := CURRENT_TIMESTAMP; 
    RETURN NEW;
END;
';


--
-- TOC entry 511 (class 1255 OID 2248590)
-- Dependencies: 1923 5
-- Name: update_portal(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION update_portal() RETURNS trigger
    LANGUAGE plpgsql
    AS '
BEGIN
    NEW.hora := CURRENT_TIMESTAMP; 
    RETURN NEW;
END;
';


--
-- TOC entry 512 (class 1255 OID 2248650)
-- Dependencies: 1923 5
-- Name: update_problema(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION update_problema() RETURNS trigger
    LANGUAGE plpgsql
    AS '
BEGIN
    NEW.datahoralimite := CURRENT_TIMESTAMP; 
    RETURN NEW;
END;
';


--
-- TOC entry 513 (class 1255 OID 2248792)
-- Dependencies: 1923 5
-- Name: update_reaberturasolicitacao(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION update_reaberturasolicitacao() RETURNS trigger
    LANGUAGE plpgsql
    AS '
BEGIN
    NEW.datahora := CURRENT_TIMESTAMP; 
    RETURN NEW;
END;
';


--
-- TOC entry 514 (class 1255 OID 2248881)
-- Dependencies: 1923 5
-- Name: update_registro(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION update_registro() RETURNS trigger
    LANGUAGE plpgsql
    AS '
BEGIN
    NEW.datahora := CURRENT_TIMESTAMP; 
    RETURN NEW;
END;
';


--
-- TOC entry 515 (class 1255 OID 2249020)
-- Dependencies: 1923 5
-- Name: update_requisitosla(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION update_requisitosla() RETURNS trigger
    LANGUAGE plpgsql
    AS '
BEGIN
    NEW.criadoem := CURRENT_TIMESTAMP; 
    RETURN NEW;
END;
';


--
-- TOC entry 516 (class 1255 OID 2249179)
-- Dependencies: 5 1923
-- Name: update_servico_hist(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION update_servico_hist() RETURNS trigger
    LANGUAGE plpgsql
    AS '
BEGIN
    NEW.criadoEm := CURRENT_TIMESTAMP; 
    RETURN NEW;
END;
';


--
-- TOC entry 517 (class 1255 OID 2249254)
-- Dependencies: 5 1923
-- Name: update_slarequisitosla(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION update_slarequisitosla() RETURNS trigger
    LANGUAGE plpgsql
    AS '
BEGIN
    NEW.dataultmodificacao := CURRENT_TIMESTAMP; 
    RETURN NEW;
END;
';


--
-- TOC entry 518 (class 1255 OID 2249372)
-- Dependencies: 1923 5
-- Name: update_tabfederacaodados(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION update_tabfederacaodados() RETURNS trigger
    LANGUAGE plpgsql
    AS '
BEGIN
    NEW.criacao := CURRENT_TIMESTAMP; 
    RETURN NEW;
END;
';


--
-- TOC entry 519 (class 1255 OID 2249408)
-- Dependencies: 5 1923
-- Name: update_timers(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION update_timers() RETURNS trigger
    LANGUAGE plpgsql
    AS '
BEGIN
    NEW.INITIALDATE := CURRENT_TIMESTAMP; 
    RETURN NEW;
END;
';


SET default_tablespace = '';

SET default_with_oids = false;

--
-- TOC entry 161 (class 1259 OID 2245983)
-- Dependencies: 4149 4150 4151 5
-- Name: acaoplanomelhoria; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE acaoplanomelhoria (
    idacaoplanomelhoria integer NOT NULL,
    idplanomelhoria integer NOT NULL,
    idobjetivoplanomelhoria integer NOT NULL,
    tituloacao character varying(255) NOT NULL,
    detalhamentoacao text,
    datainicio date,
    datafim date,
    responsavel character varying(255) DEFAULT NULL::character varying,
    dataconclusao date,
    criadopor character varying(255) DEFAULT NULL::character varying,
    modificadopor character varying(255) DEFAULT NULL::character varying,
    datacriacao date,
    ultmodificacao date
);


--
-- TOC entry 162 (class 1259 OID 2245996)
-- Dependencies: 4152 4153 4154 4155 4156 4157 4158 4159 4160 4161 4162 4163 4164 5
-- Name: acordonivelservico; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE acordonivelservico (
    idacordonivelservico bigint NOT NULL,
    idservicocontrato bigint,
    idprioridadepadrao bigint,
    situacao character(1) NOT NULL,
    titulosla character varying(500) NOT NULL,
    disponibilidade numeric(15,3) DEFAULT NULL::numeric,
    descricaosla text,
    escoposla text,
    datainicio date NOT NULL,
    datafim date,
    avaliarem date,
    tipo character(1) DEFAULT NULL::bpchar,
    deleted character(1) DEFAULT NULL::bpchar,
    valorlimite numeric(15,3) DEFAULT NULL::numeric,
    detalheglosa text,
    detalhelimiteglosa text,
    unidadevalorlimite character varying(150) DEFAULT NULL::character varying,
    impacto character(1) DEFAULT NULL::bpchar,
    urgencia character(1) DEFAULT NULL::bpchar,
    permitemudarimpurg character(1) DEFAULT NULL::bpchar,
    idformula integer,
    contatos text,
    criadoem timestamp without time zone DEFAULT now() NOT NULL,
    criadopor character varying(30) DEFAULT NULL::character varying,
    modificadoem timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    modificadopor character varying(30) DEFAULT NULL::character varying,
    tempoauto numeric(15,3) DEFAULT NULL::numeric,
    idprioridadeauto1 integer,
    idprioridadeauto2 integer,
    idprioridadeauto3 integer,
    idprioridadeauto4 integer,
    idprioridadeauto5 integer,
    idgrupo1 integer,
    idgrupo2 integer,
    idgrupo3 integer,
    idgrupo4 integer,
    idgrupo5 integer
);


--
-- TOC entry 163 (class 1259 OID 2246022)
-- Dependencies: 4165 4166 4167 4168 4169 4170 4171 4172 4173 4174 4175 4176 5
-- Name: acordonivelservico_hist; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE acordonivelservico_hist (
    idacordonivelservico_hist bigint NOT NULL,
    idacordonivelservico bigint NOT NULL,
    idservicocontrato bigint,
    idprioridadepadrao integer,
    situacao character(1) NOT NULL,
    titulosla character varying(500) NOT NULL,
    disponibilidade numeric(10,3) DEFAULT NULL::numeric,
    descricaosla text,
    escoposla text,
    datainicio date NOT NULL,
    datafim date,
    avaliarem date,
    tipo character(1) DEFAULT NULL::bpchar,
    valorlimite numeric(15,3) DEFAULT NULL::numeric,
    detalheglosa text,
    detalhelimiteglosa text,
    unidadevalorlimite character varying(150) DEFAULT NULL::character varying,
    impacto character(1) DEFAULT NULL::bpchar,
    urgencia character(1) DEFAULT NULL::bpchar,
    permitemudarimpurg character(1) DEFAULT NULL::bpchar,
    deleted character(1) DEFAULT NULL::bpchar,
    criadoem timestamp without time zone DEFAULT now() NOT NULL,
    criadopor character varying(255) DEFAULT NULL::character varying,
    modificadoem timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    modificadopor character varying(255) DEFAULT NULL::character varying,
    conteudodados text,
    idformula integer
);


--
-- TOC entry 164 (class 1259 OID 2246046)
-- Dependencies: 4177 4178 5
-- Name: acordonivelservicocontrato; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE acordonivelservicocontrato (
    idacordonivelservicocontrato integer NOT NULL,
    idcontrato integer NOT NULL,
    descricaoacordo character varying(200) NOT NULL,
    detalhamentoacordo text,
    valorlimite numeric(15,3) NOT NULL,
    unidadevalorlimite character varying(200) DEFAULT NULL::character varying,
    datainicio date NOT NULL,
    datafim date,
    descricaoglosa text,
    deleted character(1) DEFAULT NULL::bpchar,
    idformula integer
);


--
-- TOC entry 165 (class 1259 OID 2246058)
-- Dependencies: 4179 5
-- Name: acordoservicocontrato; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE acordoservicocontrato (
    idacordoservicocontrato bigint NOT NULL,
    idacordonivelservico bigint NOT NULL,
    idservicocontrato bigint NOT NULL,
    datacriacao date NOT NULL,
    datainicio date,
    datafim date,
    dataultatualiz date,
    deleted character(1) DEFAULT NULL::bpchar,
    idrecurso integer
);


--
-- TOC entry 166 (class 1259 OID 2246072)
-- Dependencies: 4180 5
-- Name: alcada; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE alcada (
    idalcada integer NOT NULL,
    nomealcada character varying(70) NOT NULL,
    situacao character(1) NOT NULL,
    tipoalcada character varying(40) DEFAULT NULL::character varying
);


--
-- TOC entry 6396 (class 0 OID 0)
-- Dependencies: 166
-- Name: COLUMN alcada.tipoalcada; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN alcada.tipoalcada IS 'C - Autorização de compras';


--
-- TOC entry 167 (class 1259 OID 2246078)
-- Dependencies: 5
-- Name: alcadacentroresultado; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE alcadacentroresultado (
    idalcadacentroresultado integer NOT NULL,
    idcentroresultado integer NOT NULL,
    idempregado integer NOT NULL,
    idalcada integer NOT NULL,
    datainicio date NOT NULL,
    datafim date
);


--
-- TOC entry 168 (class 1259 OID 2246091)
-- Dependencies: 5
-- Name: anexo; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE anexo (
    idanexo integer NOT NULL,
    idexecucaoatividade integer,
    nome character varying(256) NOT NULL,
    descricao text,
    extensao character varying(256) NOT NULL,
    link character varying(256) NOT NULL,
    path character varying(256) NOT NULL
);


--
-- TOC entry 6397 (class 0 OID 0)
-- Dependencies: 168
-- Name: TABLE anexo; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE anexo IS 'anexo';


--
-- TOC entry 169 (class 1259 OID 2246100)
-- Dependencies: 5
-- Name: anexobaseconhecimento; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE anexobaseconhecimento (
    idanexobaseconhecimento integer NOT NULL,
    idbaseconhecimento integer,
    datainicio date NOT NULL,
    datafim date,
    nome character varying(256) NOT NULL,
    link character varying(256) NOT NULL,
    extensao character varying(10) NOT NULL,
    descricao character varying(256) NOT NULL
);


--
-- TOC entry 6398 (class 0 OID 0)
-- Dependencies: 169
-- Name: TABLE anexobaseconhecimento; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE anexobaseconhecimento IS 'anexobaseconhecimento';


--
-- TOC entry 170 (class 1259 OID 2246109)
-- Dependencies: 4181 5
-- Name: anexoincidente; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE anexoincidente (
    idanexoincidente integer NOT NULL,
    idincidente integer NOT NULL,
    datainicio date NOT NULL,
    datafim date,
    nome character varying(256) NOT NULL,
    link character varying(256) NOT NULL,
    extensao character varying(10) DEFAULT NULL::character varying,
    descricao character varying(256) NOT NULL
);


--
-- TOC entry 6399 (class 0 OID 0)
-- Dependencies: 170
-- Name: TABLE anexoincidente; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE anexoincidente IS 'Armazena as referências para arquivos anexados a incidentes.';


--
-- TOC entry 171 (class 1259 OID 2246118)
-- Dependencies: 4182 4183 4184 4185 5
-- Name: anexomudanca; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE anexomudanca (
    idanexomudanca integer NOT NULL,
    idmudanca integer,
    datainicio date,
    datafim date,
    nome character varying(256) DEFAULT NULL::character varying,
    link character varying(256) DEFAULT NULL::character varying,
    extensao character varying(10) DEFAULT NULL::character varying,
    descricao character varying(256) DEFAULT NULL::character varying
);


--
-- TOC entry 172 (class 1259 OID 2246130)
-- Dependencies: 4186 4187 4188 5
-- Name: aprovacaomudanca; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE aprovacaomudanca (
    idaprovacaomudanca integer NOT NULL,
    idrequisicaomudanca integer,
    idempregado integer,
    nomeempregado character varying(45) DEFAULT NULL::character varying,
    voto character(1) DEFAULT NULL::bpchar,
    comentario character varying(200) DEFAULT NULL::character varying,
    datahorainicio timestamp without time zone
);


--
-- TOC entry 173 (class 1259 OID 2246140)
-- Dependencies: 5
-- Name: aprovacaosolicitacaoservico; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE aprovacaosolicitacaoservico (
    idaprovacaosolicitacaoservico integer NOT NULL,
    idsolicitacaoservico bigint NOT NULL,
    idtarefa bigint,
    idresponsavel integer NOT NULL,
    datahora timestamp without time zone,
    idjustificativa integer,
    complementojustificativa text,
    observacoes text,
    aprovacao character(1) NOT NULL
);


--
-- TOC entry 174 (class 1259 OID 2246152)
-- Dependencies: 4189 5
-- Name: apuracaovaloresrecurso; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE apuracaovaloresrecurso (
    idapuracaovaloresrecurso integer NOT NULL,
    idrecurso integer NOT NULL,
    valorinicio numeric(15,3) NOT NULL,
    deleted character(1) DEFAULT NULL::bpchar
);


--
-- TOC entry 175 (class 1259 OID 2246159)
-- Dependencies: 4190 4191 4192 4193 5
-- Name: atividadeperiodica; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE atividadeperiodica (
    idatividadeperiodica integer NOT NULL,
    idcontrato integer,
    idprocedimentotecnico integer,
    idgrupoatvperiodica integer,
    tituloatividade character varying(256) DEFAULT NULL::character varying,
    descricao text,
    datainicio date,
    orientacaotecnica text,
    datafim date,
    criadopor character varying(30) DEFAULT NULL::character varying,
    datacriacao date,
    alteradopor character varying(30) DEFAULT NULL::character varying,
    dataultalteracao date,
    idsolicitacaoservico integer,
    idrequisicaomudanca integer,
    blackout character(1) DEFAULT NULL::bpchar
);


--
-- TOC entry 176 (class 1259 OID 2246173)
-- Dependencies: 4194 5
-- Name: atividades; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE atividades (
    idatividade integer NOT NULL,
    idetapa integer NOT NULL,
    idtipoatividade integer NOT NULL,
    idatividadeproxima integer,
    nomeatividade character varying(100) NOT NULL,
    ordem smallint NOT NULL,
    grupoexecutor character varying(20) DEFAULT NULL::character varying
);


--
-- TOC entry 6400 (class 0 OID 0)
-- Dependencies: 176
-- Name: TABLE atividades; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE atividades IS 'atividades';


--
-- TOC entry 177 (class 1259 OID 2246182)
-- Dependencies: 5
-- Name: atividadesfluxos; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE atividadesfluxos (
    idatividade integer NOT NULL,
    idfluxo integer NOT NULL
);


--
-- TOC entry 6401 (class 0 OID 0)
-- Dependencies: 177
-- Name: TABLE atividadesfluxos; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE atividadesfluxos IS 'atividadesfluxos';


--
-- TOC entry 178 (class 1259 OID 2246188)
-- Dependencies: 4195 4196 4197 4198 4199 4200 5
-- Name: atividadesos; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE atividadesos (
    idatividadesos bigint NOT NULL,
    idos integer NOT NULL,
    sequencia smallint,
    idatividadeservicocontrato bigint,
    descricaoatividade text NOT NULL,
    obsatividade text,
    custoatividade numeric(18,3) DEFAULT NULL::numeric,
    glosaatividade numeric(18,3) DEFAULT NULL::numeric,
    complexidade character(5) DEFAULT NULL::bpchar,
    deleted character(1) DEFAULT NULL::bpchar,
    qtdeexecutada numeric(15,3) DEFAULT NULL::numeric,
    formula text,
    contabilizar character(1) DEFAULT NULL::bpchar,
    idservicocontratocontabil bigint
);


--
-- TOC entry 179 (class 1259 OID 2246204)
-- Dependencies: 4201 4202 4203 4204 4205 4206 4207 5
-- Name: atividadesservicocontrato; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE atividadesservicocontrato (
    idatividadeservicocontrato bigint NOT NULL,
    idservicocontrato bigint NOT NULL,
    descricaoatividade text NOT NULL,
    obsatividade text,
    custoatividade numeric(18,3) DEFAULT NULL::numeric,
    complexidade character(5) DEFAULT NULL::bpchar,
    deleted character(1) DEFAULT NULL::bpchar,
    hora numeric(10,2) DEFAULT NULL::numeric,
    quantidade integer,
    periodo character(5) DEFAULT NULL::bpchar,
    tipocusto character(1) DEFAULT NULL::bpchar,
    formula text,
    contabilizar character(1) DEFAULT NULL::bpchar,
    idservicocontratocontabil bigint
);


--
-- TOC entry 180 (class 1259 OID 2246220)
-- Dependencies: 4208 5
-- Name: auditoria; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE auditoria (
    idauditoria integer NOT NULL,
    iditemconfiguracao integer,
    idusuario integer,
    data date NOT NULL,
    hora character(4) DEFAULT NULL::bpchar,
    ocorr text
);


--
-- TOC entry 6402 (class 0 OID 0)
-- Dependencies: 180
-- Name: TABLE auditoria; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE auditoria IS 'auditoria';


--
-- TOC entry 181 (class 1259 OID 2246231)
-- Dependencies: 4209 5
-- Name: auditoriaitemconfiguracao; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE auditoriaitemconfiguracao (
    idauditoria integer NOT NULL,
    iditemconfiguracao integer,
    idempregado integer,
    data date NOT NULL,
    hora character(4) DEFAULT NULL::bpchar,
    ocorr text
);


--
-- TOC entry 6403 (class 0 OID 0)
-- Dependencies: 181
-- Name: TABLE auditoriaitemconfiguracao; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE auditoriaitemconfiguracao IS 'auditoriaitemconfiguracao';


--
-- TOC entry 182 (class 1259 OID 2246242)
-- Dependencies: 5
-- Name: avaliacaocoletapreco; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE avaliacaocoletapreco (
    idcriterio integer NOT NULL,
    idcoletapreco integer NOT NULL,
    avaliacao integer NOT NULL
);


--
-- TOC entry 183 (class 1259 OID 2246247)
-- Dependencies: 5
-- Name: avaliacaocotacao; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE avaliacaocotacao (
    idcriterio integer NOT NULL,
    idfornecedor integer NOT NULL,
    iditemcotacao integer NOT NULL,
    avaliacao integer NOT NULL
);


--
-- TOC entry 184 (class 1259 OID 2246252)
-- Dependencies: 4210 4211 5
-- Name: avaliacaofornecedor; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE avaliacaofornecedor (
    idavaliacaofornecedor integer NOT NULL,
    idfornecedor bigint,
    idresponsavel integer,
    dataavaliacao date,
    decisaoqualificacao character(1) DEFAULT NULL::bpchar,
    observacoes text,
    contato character varying(245) DEFAULT NULL::character varying
);


--
-- TOC entry 478 (class 1259 OID 2249717)
-- Dependencies: 5
-- Name: avaliacaopedido; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE avaliacaopedido (
    idavaliacao integer NOT NULL,
    idcriterio integer NOT NULL,
    idpedido integer,
    idcoletapreco integer,
    iditemrequisicaoproduto integer,
    tipoavaliacao character(1) NOT NULL,
    avaliacao numeric(8,2) NOT NULL,
    observacoes text
);


--
-- TOC entry 6404 (class 0 OID 0)
-- Dependencies: 478
-- Name: COLUMN avaliacaopedido.tipoavaliacao; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN avaliacaopedido.tipoavaliacao IS 'P - Produto\n            C - Compra';


--
-- TOC entry 185 (class 1259 OID 2246264)
-- Dependencies: 4212 4213 4214 5
-- Name: avaliacaoreferenciafornecedor; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE avaliacaoreferenciafornecedor (
    idavaliacaofornecedor integer DEFAULT 0 NOT NULL,
    idempregado integer DEFAULT 0 NOT NULL,
    decisao character(1) DEFAULT NULL::bpchar,
    observacoes text
);


--
-- TOC entry 186 (class 1259 OID 2246281)
-- Dependencies: 4215 4216 4217 4218 4219 4220 4221 4222 4223 4224 5
-- Name: baseconhecimento; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE baseconhecimento (
    idbaseconhecimento integer NOT NULL,
    idpasta integer,
    datainicio date NOT NULL,
    datafim date,
    titulo character varying(256) NOT NULL,
    conteudo text,
    status character(1) NOT NULL,
    idbaseconhecimentopai integer,
    dataexpiracao date,
    versao character varying(45) DEFAULT NULL::character varying,
    idnotificacao integer,
    justificativaobservacao character varying(500) DEFAULT NULL::character varying,
    datapublicacao date,
    fontereferencia character varying(255) DEFAULT NULL::character varying,
    faq character varying(45) DEFAULT NULL::character varying,
    arquivado character varying(45) DEFAULT NULL::character varying,
    idusuarioautor integer,
    idusuarioaprovador integer,
    idhistoricobaseconhecimento integer,
    origem character(1) NOT NULL,
    privacidade character varying(45) DEFAULT NULL::character varying,
    situacao character varying(45) DEFAULT NULL::character varying,
    gerenciamentodisponibilidade character(1) DEFAULT NULL::bpchar,
    direitoautoral character(1) DEFAULT NULL::bpchar,
    legislacao character(1) DEFAULT NULL::bpchar,
    conteudosemformatacao text
);


--
-- TOC entry 6405 (class 0 OID 0)
-- Dependencies: 186
-- Name: TABLE baseconhecimento; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE baseconhecimento IS 'baseconhecimento';


--
-- TOC entry 187 (class 1259 OID 2246303)
-- Dependencies: 5
-- Name: baseconhecimentorelacionado; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE baseconhecimentorelacionado (
    idbaseconhecimento integer NOT NULL,
    idbaseconhecimentorelacionado integer NOT NULL
);


--
-- TOC entry 188 (class 1259 OID 2246308)
-- Dependencies: 4225 4226 5
-- Name: baseitemconfiguracao; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE baseitemconfiguracao (
    idbaseitemconfiguracao integer NOT NULL,
    idtipoitemconfiguracao integer,
    nomebaseitemconfiguracao character varying(256) NOT NULL,
    executavel character varying(256) NOT NULL,
    datainicio date NOT NULL,
    datafim date,
    tipoexecucao character(1) DEFAULT NULL::bpchar,
    comando character varying(256) DEFAULT NULL::character varying
);


--
-- TOC entry 6406 (class 0 OID 0)
-- Dependencies: 188
-- Name: TABLE baseitemconfiguracao; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE baseitemconfiguracao IS 'baseitemconfiguracao';


--
-- TOC entry 6407 (class 0 OID 0)
-- Dependencies: 188
-- Name: COLUMN baseitemconfiguracao.comando; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN baseitemconfiguracao.comando IS 'Comando de instalacao selenciosa.';


--
-- TOC entry 189 (class 1259 OID 2246319)
-- Dependencies: 5
-- Name: bibliotecasexternas; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE bibliotecasexternas (
    idbibliotecasexterna bigint NOT NULL,
    nome character varying(500) NOT NULL,
    caminho character varying(500) NOT NULL
);


--
-- TOC entry 190 (class 1259 OID 2246327)
-- Dependencies: 4227 4228 5
-- Name: botaoacaovisao; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE botaoacaovisao (
    idbotaoacaovisao bigint NOT NULL,
    idvisao bigint NOT NULL,
    texto character varying(120) NOT NULL,
    acao character(1) NOT NULL,
    script text,
    hint character varying(120) DEFAULT NULL::character varying,
    icone character varying(120) DEFAULT NULL::character varying,
    ordem smallint
);


--
-- TOC entry 191 (class 1259 OID 2246338)
-- Dependencies: 4229 4230 5
-- Name: bpm_atribuicaofluxo; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE bpm_atribuicaofluxo (
    idatribuicao bigint NOT NULL,
    iditemtrabalho bigint NOT NULL,
    tipo character varying(20) DEFAULT NULL::character varying,
    datahora timestamp without time zone DEFAULT now() NOT NULL,
    idusuario integer,
    idgrupo integer
);


--
-- TOC entry 192 (class 1259 OID 2246350)
-- Dependencies: 4231 4232 4233 4234 4235 4236 4237 4238 4239 4240 5
-- Name: bpm_elementofluxo; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE bpm_elementofluxo (
    idelemento bigint NOT NULL,
    idfluxo bigint NOT NULL,
    tipoelemento character varying(20) NOT NULL,
    subtipo character varying(20) DEFAULT NULL::character varying,
    nome character varying(50) DEFAULT NULL::character varying,
    documentacao text,
    tipointeracao character(1) DEFAULT NULL::bpchar,
    url character varying(150) DEFAULT NULL::character varying,
    visao character varying(150) DEFAULT NULL::character varying,
    grupos text,
    usuarios text,
    acaoentrada text,
    acaosaida text,
    script text,
    textoemail text,
    nomefluxoencadeado character varying(100) DEFAULT NULL::character varying,
    posx double precision,
    posy double precision,
    altura double precision,
    largura double precision,
    modeloemail character varying(20) DEFAULT NULL::character varying,
    template character varying(40) DEFAULT NULL::character varying,
    intervalo integer,
    condicaodisparo text,
    multiplasinstancias character(1) DEFAULT NULL::bpchar,
    destinatariosemail text,
    contabilizasla character(1) DEFAULT NULL::bpchar,
    percexecucao double precision
);


--
-- TOC entry 193 (class 1259 OID 2246369)
-- Dependencies: 5
-- Name: bpm_fluxo; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE bpm_fluxo (
    idfluxo bigint NOT NULL,
    versao character varying(10) NOT NULL,
    idtipofluxo integer,
    variaveis text,
    conteudoxml text,
    datainicio date NOT NULL,
    datafim date
);


--
-- TOC entry 194 (class 1259 OID 2246381)
-- Dependencies: 4241 5
-- Name: bpm_historicoitemtrabalho; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE bpm_historicoitemtrabalho (
    idhistoricoitemtrabalho bigint NOT NULL,
    iditemtrabalho bigint NOT NULL,
    idresponsavel integer,
    idusuario integer,
    idgrupo integer,
    datahora timestamp without time zone DEFAULT now() NOT NULL,
    acao character varying(10) NOT NULL
);


--
-- TOC entry 195 (class 1259 OID 2246393)
-- Dependencies: 4242 4243 5
-- Name: bpm_instanciafluxo; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE bpm_instanciafluxo (
    idinstancia bigint NOT NULL,
    idfluxo bigint NOT NULL,
    datahoracriacao timestamp without time zone DEFAULT now() NOT NULL,
    situacao character varying(20) DEFAULT NULL::character varying,
    datahorafinalizacao timestamp without time zone
);


--
-- TOC entry 196 (class 1259 OID 2246403)
-- Dependencies: 4244 5
-- Name: bpm_itemtrabalhofluxo; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE bpm_itemtrabalhofluxo (
    iditemtrabalho bigint NOT NULL,
    idinstancia bigint NOT NULL,
    idelemento bigint NOT NULL,
    idresponsavelatual integer,
    datahoracriacao timestamp without time zone DEFAULT now() NOT NULL,
    datahorainicio timestamp without time zone,
    situacao character(20) NOT NULL,
    datahorafinalizacao timestamp without time zone,
    datahoraexecucao timestamp without time zone
);


--
-- TOC entry 197 (class 1259 OID 2246414)
-- Dependencies: 4245 4246 4247 4248 4249 5
-- Name: bpm_objetoinstanciafluxo; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE bpm_objetoinstanciafluxo (
    idobjetoinstancia bigint NOT NULL,
    iditemtrabalho bigint,
    idinstancia bigint NOT NULL,
    idobjetonegocio bigint,
    nomeobjeto character varying(100) DEFAULT NULL::character varying,
    nomeclasse character varying(100) DEFAULT NULL::character varying,
    tipoassociacao character(1) NOT NULL,
    campochave character(1) NOT NULL,
    objetoprincipal character(1) NOT NULL,
    nometabelabd character varying(120) DEFAULT NULL::character varying,
    nomecampobd character varying(100) DEFAULT NULL::character varying,
    tipocampobd character varying(20) DEFAULT NULL::character varying,
    valor text
);


--
-- TOC entry 6408 (class 0 OID 0)
-- Dependencies: 197
-- Name: COLUMN bpm_objetoinstanciafluxo.campochave; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN bpm_objetoinstanciafluxo.campochave IS 'S - Sim\n            N - Não';


--
-- TOC entry 198 (class 1259 OID 2246430)
-- Dependencies: 4250 4251 4252 4253 5
-- Name: bpm_sequenciafluxo; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE bpm_sequenciafluxo (
    idelementoorigem bigint NOT NULL,
    idelementodestino bigint NOT NULL,
    idfluxo bigint NOT NULL,
    nomeclasseorigem character varying(100) DEFAULT NULL::character varying,
    nomeclassedestino character varying(100) DEFAULT NULL::character varying,
    condicao text,
    idconexaoorigem smallint,
    idconexaodestino smallint,
    bordax double precision,
    borday double precision,
    posicaoalterada character(1) DEFAULT NULL::bpchar,
    nome character varying(100) DEFAULT NULL::character varying
);


--
-- TOC entry 199 (class 1259 OID 2246444)
-- Dependencies: 4254 5
-- Name: bpm_tipofluxo; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE bpm_tipofluxo (
    idtipofluxo integer NOT NULL,
    nomefluxo character varying(70) NOT NULL,
    descricao text,
    nomeclassefluxo character varying(255) DEFAULT NULL::character varying
);


--
-- TOC entry 200 (class 1259 OID 2246453)
-- Dependencies: 4255 4256 5
-- Name: calendario; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE calendario (
    idcalendario integer NOT NULL,
    descricao character varying(70) DEFAULT NULL::character varying,
    consideraferiados character(1) DEFAULT NULL::bpchar,
    idjornadaseg integer,
    idjornadater integer,
    idjornadaqua integer,
    idjornadaqui integer,
    idjornadasex integer,
    idjornadasab integer,
    idjornadadom integer
);


--
-- TOC entry 201 (class 1259 OID 2246460)
-- Dependencies: 5
-- Name: campoobjrelacionado; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE campoobjrelacionado (
    idcampoobjrelacionado bigint NOT NULL,
    idrelacobjetonegocio bigint NOT NULL,
    idcamposobjetonegociopai bigint NOT NULL,
    idcamposobjetonegociofilho bigint NOT NULL,
    situacao character(1) NOT NULL
);


--
-- TOC entry 202 (class 1259 OID 2246468)
-- Dependencies: 4257 5
-- Name: camposobjetonegocio; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE camposobjetonegocio (
    idcamposobjetonegocio bigint NOT NULL,
    idobjetonegocio bigint NOT NULL,
    nome character varying(100) NOT NULL,
    nomedb character varying(100) NOT NULL,
    pk character(1) NOT NULL,
    sequence character(1) NOT NULL,
    unico character(1) NOT NULL,
    tipodb character(20) NOT NULL,
    obrigatorio character(1) NOT NULL,
    situacao character(1) NOT NULL,
    precisiondb bigint DEFAULT 0::bigint NOT NULL
);


--
-- TOC entry 203 (class 1259 OID 2246475)
-- Dependencies: 4258 4259 4260 4261 5
-- Name: caracteristica; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE caracteristica (
    idcaracteristica integer NOT NULL,
    idempresa integer NOT NULL,
    nomecaracteristica character varying(255) NOT NULL,
    tagcaracteristica character varying(255) DEFAULT NULL::character varying,
    descricao character varying(4000) DEFAULT NULL::character varying,
    tipo character(2) DEFAULT NULL::bpchar,
    datainicio date NOT NULL,
    datafim date,
    sistema character(1) DEFAULT NULL::bpchar
);


--
-- TOC entry 6409 (class 0 OID 0)
-- Dependencies: 203
-- Name: TABLE caracteristica; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE caracteristica IS 'caracteristica';


--
-- TOC entry 204 (class 1259 OID 2246489)
-- Dependencies: 5
-- Name: cargos; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE cargos (
    idcargo integer NOT NULL,
    nomecargo character varying(256) NOT NULL,
    datainicio date NOT NULL,
    datafim date
);


--
-- TOC entry 6410 (class 0 OID 0)
-- Dependencies: 204
-- Name: TABLE cargos; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE cargos IS '{\rtf1ansiansicpg1252uc1deff0deflang1046deflangfe1046{';


--
-- TOC entry 205 (class 1259 OID 2246494)
-- Dependencies: 4262 4263 4264 5
-- Name: catalogoservico; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE catalogoservico (
    idcatalogoservico integer DEFAULT 0 NOT NULL,
    idcontrato integer,
    datainicio date,
    datafim date,
    obs text,
    nomeservico character(150) DEFAULT NULL::bpchar,
    titulocatalogoservico character varying(256) DEFAULT NULL::character varying
);


--
-- TOC entry 206 (class 1259 OID 2246506)
-- Dependencies: 5
-- Name: categoriagaleriaimagem; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE categoriagaleriaimagem (
    idcategoriagaleriaimagem integer NOT NULL,
    nomecategoria character varying(70) NOT NULL
);


--
-- TOC entry 6411 (class 0 OID 0)
-- Dependencies: 206
-- Name: TABLE categoriagaleriaimagem; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE categoriagaleriaimagem IS 'categoriagaleriaimagem';


--
-- TOC entry 207 (class 1259 OID 2246511)
-- Dependencies: 4265 5
-- Name: categoriamudanca; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE categoriamudanca (
    idcategoriamudanca integer NOT NULL,
    idtipofluxo integer,
    idmodeloemailcriacao integer,
    idmodeloemailfinalizacao integer,
    idmodeloemailacoes integer,
    idgruponivel1 integer,
    idgrupoexecutor integer,
    idcalendario integer,
    idcategoriamudancapai integer,
    nomecategoria character varying(100) DEFAULT NULL::character varying,
    datainicio date,
    datafim date
);


--
-- TOC entry 208 (class 1259 OID 2246534)
-- Dependencies: 5
-- Name: categoriaocorrencia; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE categoriaocorrencia (
    idcategoriaocorrencia integer NOT NULL,
    nome character varying(20) NOT NULL,
    datainicio date NOT NULL,
    datafim date
);


--
-- TOC entry 209 (class 1259 OID 2246539)
-- Dependencies: 4266 5
-- Name: categoriapost; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE categoriapost (
    idcategoriapost integer NOT NULL,
    idcategoriapostpai integer,
    nomecategoria character varying(255) DEFAULT NULL::character varying,
    datainicio date,
    datafim date
);


--
-- TOC entry 210 (class 1259 OID 2246545)
-- Dependencies: 5
-- Name: categoriaproblema; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE categoriaproblema (
    idcategoriaproblema integer NOT NULL,
    cat_idcategoriaproblema integer,
    idcategoriaproblemapai integer NOT NULL,
    nomecategoria integer NOT NULL
);


--
-- TOC entry 211 (class 1259 OID 2246551)
-- Dependencies: 5
-- Name: categoriaproduto; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE categoriaproduto (
    idcategoria integer NOT NULL,
    idcategoriapai integer,
    nomecategoria character varying(100) NOT NULL,
    situacao character(1) NOT NULL,
    pesocotacaopreco integer,
    pesocotacaoprazoentrega integer,
    pesocotacaoprazopagto integer,
    pesocotacaotaxajuros integer,
    pesocotacaoprazogarantia integer
);


--
-- TOC entry 212 (class 1259 OID 2246562)
-- Dependencies: 4267 5
-- Name: categoriaquestionario; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE categoriaquestionario (
    idcategoriaquestionario integer NOT NULL,
    nomecategoriaquestionario character varying(50) NOT NULL,
    idempresa integer NOT NULL,
    compartilhada character(1) DEFAULT 'N'::bpchar
);


--
-- TOC entry 6412 (class 0 OID 0)
-- Dependencies: 212
-- Name: TABLE categoriaquestionario; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE categoriaquestionario IS 'categoriaquestionario';


--
-- TOC entry 213 (class 1259 OID 2246568)
-- Dependencies: 4268 4269 4270 5
-- Name: categoriaservico; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE categoriaservico (
    idcategoriaservico integer NOT NULL,
    idcategoriaservicopai integer,
    idempresa integer NOT NULL,
    nomecategoriaservico character varying(100) NOT NULL,
    datainicio date DEFAULT '2012-04-02'::date,
    datafim date,
    nomecategoriaservicoconcatenado character varying(1024) DEFAULT NULL::character varying,
    nomecatservicoconcatenado character varying(520) DEFAULT NULL::character varying
);


--
-- TOC entry 6413 (class 0 OID 0)
-- Dependencies: 213
-- Name: TABLE categoriaservico; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE categoriaservico IS 'categoriaservico';


--
-- TOC entry 214 (class 1259 OID 2246582)
-- Dependencies: 4271 5
-- Name: categoriasolucao; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE categoriasolucao (
    idcategoriasolucao integer NOT NULL,
    idcategoriasolucaopai integer,
    descricaocategoriasolucao character varying(100) NOT NULL,
    datainicio date NOT NULL,
    datafim date,
    deleted character(1) DEFAULT NULL::bpchar
);


--
-- TOC entry 215 (class 1259 OID 2246589)
-- Dependencies: 4272 5
-- Name: causaincidente; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE causaincidente (
    idcausaincidente integer NOT NULL,
    idcausaincidentepai integer,
    descricaocausa character varying(100) NOT NULL,
    datainicio date NOT NULL,
    datafim date,
    deleted character(1) DEFAULT NULL::bpchar
);


--
-- TOC entry 216 (class 1259 OID 2246596)
-- Dependencies: 4273 5
-- Name: centroresultado; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE centroresultado (
    idcentroresultado integer NOT NULL,
    codigocentroresultado character varying(25) NOT NULL,
    nomecentroresultado character varying(200) NOT NULL,
    idcentroresultadopai integer,
    permiterequisicaoproduto character(1) DEFAULT NULL::bpchar,
    situacao character(1) NOT NULL
);


--
-- TOC entry 217 (class 1259 OID 2246602)
-- Dependencies: 5
-- Name: cidades; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE cidades (
    idcidade integer NOT NULL,
    nomecidade character varying(45) NOT NULL,
    iduf integer NOT NULL
);


--
-- TOC entry 218 (class 1259 OID 2246608)
-- Dependencies: 4274 4275 4276 5
-- Name: clientes; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE clientes (
    idcliente integer NOT NULL,
    nomerazaosocial character varying(70) NOT NULL,
    nomefantasia character varying(70) DEFAULT NULL::character varying,
    cpfcnpj character varying(14) DEFAULT NULL::character varying,
    observacoes text,
    situacao character(1) NOT NULL,
    deleted character(1) DEFAULT NULL::bpchar
);


--
-- TOC entry 6414 (class 0 OID 0)
-- Dependencies: 218
-- Name: TABLE clientes; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE clientes IS 'clientes';


--
-- TOC entry 219 (class 1259 OID 2246619)
-- Dependencies: 4277 5
-- Name: colecao; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE colecao (
    idcolecao integer NOT NULL,
    nome character varying(256) DEFAULT NULL::character varying,
    idteste integer
);


--
-- TOC entry 6415 (class 0 OID 0)
-- Dependencies: 219
-- Name: TABLE colecao; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE colecao IS 'colecao';


--
-- TOC entry 220 (class 1259 OID 2246626)
-- Dependencies: 4278 4279 4280 4281 4282 4283 4284 5
-- Name: coletapreco; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE coletapreco (
    idcoletapreco integer NOT NULL,
    idfornecedor bigint NOT NULL,
    iditemcotacao integer NOT NULL,
    idresponsavel integer NOT NULL,
    idrespresultado integer,
    idjustifresultado integer,
    datacoleta date NOT NULL,
    datavalidade date,
    especificacoes text,
    preco numeric(8,2) NOT NULL,
    valoracrescimo numeric(8,2) NOT NULL,
    valordesconto numeric(8,2) NOT NULL,
    valorfrete numeric(8,2) NOT NULL,
    prazoentrega integer NOT NULL,
    prazomediopagto numeric(4,2) NOT NULL,
    taxajuros numeric(4,2) NOT NULL,
    prazogarantia integer NOT NULL,
    quantidadecotada numeric(8,2) NOT NULL,
    pontuacao numeric(8,4) DEFAULT NULL::numeric,
    resultadocalculo character(1) DEFAULT NULL::bpchar,
    quantidadecalculo numeric(8,2) DEFAULT NULL::numeric,
    resultadofinal character(1) DEFAULT NULL::bpchar,
    quantidadecompra numeric(8,2) DEFAULT NULL::numeric,
    complemjustifresultado text,
    quantidadeaprovada numeric(8,2) DEFAULT NULL::numeric,
    quantidadepedido numeric(8,2) DEFAULT NULL::numeric
);


--
-- TOC entry 6416 (class 0 OID 0)
-- Dependencies: 220
-- Name: COLUMN coletapreco.resultadocalculo; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN coletapreco.resultadocalculo IS 'M - Melhor cotação\n            E - Empate\n            N - Não vencedora';


--
-- TOC entry 6417 (class 0 OID 0)
-- Dependencies: 220
-- Name: COLUMN coletapreco.resultadofinal; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN coletapreco.resultadofinal IS 'M - Melhor cotação\n            N - Não vencedora';


--
-- TOC entry 221 (class 1259 OID 2246646)
-- Dependencies: 5
-- Name: comando; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE comando (
    id integer NOT NULL,
    descricao character varying(400) NOT NULL
);


--
-- TOC entry 6418 (class 0 OID 0)
-- Dependencies: 221
-- Name: TABLE comando; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE comando IS 'comando';


--
-- TOC entry 222 (class 1259 OID 2246651)
-- Dependencies: 4285 4286 5
-- Name: comandosistemaoperacional; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE comandosistemaoperacional (
    id integer NOT NULL,
    idcomando integer NOT NULL,
    idsistemaoperacional integer NOT NULL,
    comando character varying(255) NOT NULL,
    sistemaoperacional character varying(255) DEFAULT NULL::character varying,
    comandosistemaoperacional character varying(255) DEFAULT NULL::character varying
);


--
-- TOC entry 6419 (class 0 OID 0)
-- Dependencies: 222
-- Name: TABLE comandosistemaoperacional; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE comandosistemaoperacional IS 'comandosistemaoperacional';


--
-- TOC entry 223 (class 1259 OID 2246663)
-- Dependencies: 5
-- Name: comentarios; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE comentarios (
    idcomentario integer NOT NULL,
    idbaseconhecimento integer NOT NULL,
    comentario text NOT NULL,
    nome character varying(255) NOT NULL,
    nota character varying(45) NOT NULL,
    email character varying(70) NOT NULL,
    datainicio date NOT NULL,
    datafim date
);


--
-- TOC entry 224 (class 1259 OID 2246672)
-- Dependencies: 4287 4288 4289 5
-- Name: complexidade; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE complexidade (
    idcontrato integer DEFAULT 0 NOT NULL,
    complexidade character(1) NOT NULL,
    valorcomplexidade numeric(10,2) DEFAULT NULL::numeric,
    deleted character(1) DEFAULT NULL::bpchar
);


--
-- TOC entry 225 (class 1259 OID 2246680)
-- Dependencies: 5
-- Name: condicaooperacao; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE condicaooperacao (
    idcondicaooperacao integer NOT NULL,
    idempresa integer NOT NULL,
    nomecondicaooperacao character varying(150) NOT NULL,
    datainicio date NOT NULL,
    datafim date
);


--
-- TOC entry 6420 (class 0 OID 0)
-- Dependencies: 225
-- Name: TABLE condicaooperacao; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE condicaooperacao IS 'condicaooperacao';


--
-- TOC entry 226 (class 1259 OID 2246686)
-- Dependencies: 5
-- Name: conhecimentoic; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE conhecimentoic (
    iditemconfiguracao integer NOT NULL,
    idbaseconhecimento integer NOT NULL
);


--
-- TOC entry 227 (class 1259 OID 2246697)
-- Dependencies: 5
-- Name: conhecimentomudanca; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE conhecimentomudanca (
    idrequisicaomudanca integer NOT NULL,
    idbaseconhecimento integer NOT NULL
);


--
-- TOC entry 228 (class 1259 OID 2246708)
-- Dependencies: 5
-- Name: conhecimentoproblema; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE conhecimentoproblema (
    idproblema integer NOT NULL,
    idbaseconhecimento integer NOT NULL
);


--
-- TOC entry 229 (class 1259 OID 2246719)
-- Dependencies: 5
-- Name: conhecimentosolicitacaoservico; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE conhecimentosolicitacaoservico (
    idsolicitacaoservico bigint NOT NULL,
    idbaseconhecimento integer NOT NULL
);


--
-- TOC entry 230 (class 1259 OID 2246730)
-- Dependencies: 4290 5
-- Name: contadoracesso; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE contadoracesso (
    idcontadoracesso integer NOT NULL,
    idusuario integer,
    idbaseconhecimento integer,
    datahoraacesso timestamp without time zone DEFAULT now() NOT NULL,
    contadoracesso integer NOT NULL
);


--
-- TOC entry 231 (class 1259 OID 2246737)
-- Dependencies: 4291 4292 4293 5
-- Name: contatocliente; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE contatocliente (
    idcontatocliente integer NOT NULL,
    idcliente integer NOT NULL,
    nome character varying(80) NOT NULL,
    telefones character varying(100) DEFAULT NULL::character varying,
    email character varying(255) DEFAULT NULL::character varying,
    departamento character varying(100) DEFAULT NULL::character varying,
    observacoes text,
    datainicio date,
    datafim date
);


--
-- TOC entry 6421 (class 0 OID 0)
-- Dependencies: 231
-- Name: TABLE contatocliente; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE contatocliente IS 'contatocliente';


--
-- TOC entry 232 (class 1259 OID 2246749)
-- Dependencies: 4294 4295 4296 4297 5
-- Name: contatorequisicaomudanca; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE contatorequisicaomudanca (
    idcontatorequisicaomudanca integer NOT NULL,
    nomecontato character varying(100) DEFAULT NULL::character varying,
    telefonecontato character varying(100) DEFAULT NULL::character varying,
    emailcontato character varying(200) DEFAULT NULL::character varying,
    observacao text,
    idlocalidade integer,
    ramal character varying(5) DEFAULT NULL::character varying
);


--
-- TOC entry 233 (class 1259 OID 2246761)
-- Dependencies: 4298 4299 5
-- Name: contatosolicitacaoservico; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE contatosolicitacaoservico (
    idcontatosolicitacaoservico integer NOT NULL,
    nomecontato character varying(70) NOT NULL,
    telefonecontato character varying(70) DEFAULT NULL::character varying,
    emailcontato character varying(120) NOT NULL,
    localizacaofisica text,
    idlocalidade integer,
    ramal character varying(5) DEFAULT NULL::character varying
);


--
-- TOC entry 234 (class 1259 OID 2246772)
-- Dependencies: 4300 4301 4302 4303 5
-- Name: contratoquestionarios; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE contratoquestionarios (
    idcontratoquestionario integer NOT NULL,
    idquestionario integer NOT NULL,
    idcontrato integer NOT NULL,
    dataquestionario date NOT NULL,
    idprofissional integer,
    idempresa integer,
    aba character varying(30) DEFAULT NULL::character varying,
    situacao character(1) DEFAULT NULL::bpchar,
    situacaocomplemento character(1) DEFAULT NULL::bpchar,
    datahoragrav date,
    migrado character(1) DEFAULT NULL::bpchar,
    conteudoimpresso text,
    idmigracao integer
);


--
-- TOC entry 6422 (class 0 OID 0)
-- Dependencies: 234
-- Name: TABLE contratoquestionarios; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE contratoquestionarios IS 'contratoquestionarios';


--
-- TOC entry 235 (class 1259 OID 2246789)
-- Dependencies: 4304 4305 4306 4307 4308 5
-- Name: contratos; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE contratos (
    idcontrato integer NOT NULL,
    idcliente integer NOT NULL,
    idmoeda integer,
    idfornecedor bigint NOT NULL,
    numero character varying(30) NOT NULL,
    objeto text NOT NULL,
    datacontrato date NOT NULL,
    valorestimado numeric(18,3) DEFAULT NULL::numeric,
    tipotempoestimado character(1) DEFAULT NULL::bpchar,
    tempoestimado integer,
    tipo character(1) NOT NULL,
    situacao character(1) NOT NULL,
    cotacaomoeda numeric(18,3) DEFAULT NULL::numeric,
    cadastromanualusuario character(1) DEFAULT NULL::bpchar,
    deleted character(1) DEFAULT NULL::bpchar,
    idgruposolicitante integer,
    datafimcontrato date
);


--
-- TOC entry 236 (class 1259 OID 2246805)
-- Dependencies: 4309 4310 4311 4312 4313 4314 4315 4316 4317 5
-- Name: contratos_hist; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE contratos_hist (
    idcontrato_hist integer NOT NULL,
    idcontrato integer NOT NULL,
    idcliente integer NOT NULL,
    idmoeda integer,
    idfornecedor bigint NOT NULL,
    numero character varying(30) NOT NULL,
    objeto text NOT NULL,
    datacontrato date NOT NULL,
    valorestimado numeric(18,3) DEFAULT NULL::numeric,
    tipotempoestimado character(1) DEFAULT NULL::bpchar,
    tempoestimado integer,
    tipo character(1) NOT NULL,
    situacao character(1) NOT NULL,
    cotacaomoeda numeric(18,3) DEFAULT NULL::numeric,
    cadastromanualusuario character(1) DEFAULT NULL::bpchar,
    deleted character(1) DEFAULT NULL::bpchar,
    idgruposolicitante integer,
    datafimcontrato date,
    criadoem timestamp without time zone DEFAULT now() NOT NULL,
    criadopor character varying(256) DEFAULT NULL::character varying,
    modificadoem timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    modificadopor character varying(256) DEFAULT NULL::character varying,
    conteudodados text
);


--
-- TOC entry 237 (class 1259 OID 2246827)
-- Dependencies: 5
-- Name: contratoscolaboradores; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE contratoscolaboradores (
    idempregado integer NOT NULL,
    idcontrato integer NOT NULL
);


--
-- TOC entry 238 (class 1259 OID 2246833)
-- Dependencies: 4318 4319 5
-- Name: contratosgrupos; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE contratosgrupos (
    idgrupo integer NOT NULL,
    idcontrato integer NOT NULL,
    CONSTRAINT contratosgrupos_idcontrato_check CHECK ((idcontrato >= 0)),
    CONSTRAINT contratosgrupos_idgrupo_check CHECK ((idgrupo >= 0))
);


--
-- TOC entry 239 (class 1259 OID 2246840)
-- Dependencies: 4320 4321 5
-- Name: contratosunidades; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE contratosunidades (
    idunidade integer NOT NULL,
    idcontrato integer DEFAULT 0 NOT NULL,
    contratosunidadescol character varying(45) DEFAULT NULL::character varying
);


--
-- TOC entry 240 (class 1259 OID 2246847)
-- Dependencies: 4322 4323 4324 4325 5
-- Name: controleged; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE controleged (
    idcontroleged integer NOT NULL,
    idtabela smallint NOT NULL,
    id integer NOT NULL,
    nomearquivo character varying(255) NOT NULL,
    descricaoarquivo character varying(255) DEFAULT NULL::character varying,
    extensaoarquivo character varying(5) DEFAULT NULL::character varying,
    datahora timestamp without time zone DEFAULT now() NOT NULL,
    pasta character varying(255) DEFAULT NULL::character varying,
    conteudoarquivo text
);


--
-- TOC entry 241 (class 1259 OID 2246861)
-- Dependencies: 5
-- Name: controlequestionarios; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE controlequestionarios (
    idcontrolequestionario integer NOT NULL
);


--
-- TOC entry 6423 (class 0 OID 0)
-- Dependencies: 241
-- Name: TABLE controlequestionarios; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE controlequestionarios IS 'controlequestionarios';


--
-- TOC entry 242 (class 1259 OID 2246866)
-- Dependencies: 4326 4327 5
-- Name: cotacao; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE cotacao (
    idcotacao integer NOT NULL,
    identificacao character varying(100) DEFAULT NULL::character varying,
    idempresa integer NOT NULL,
    idresponsavel integer NOT NULL,
    situacao character varying(25) NOT NULL,
    datahoracadastro timestamp without time zone DEFAULT now() NOT NULL,
    observacoes text,
    datafinalprevista date
);


--
-- TOC entry 243 (class 1259 OID 2246879)
-- Dependencies: 4328 4329 5
-- Name: cotacaoitemrequisicao; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE cotacaoitemrequisicao (
    idcoletapreco integer NOT NULL,
    iditemrequisicaoproduto integer NOT NULL,
    idparecer integer,
    iditemtrabalhoaprovacao bigint,
    idsolicitacaoservico bigint,
    iditemtrabalhoinspecao bigint,
    idcotacao integer,
    quantidade numeric(8,2) NOT NULL,
    situacao character(25) DEFAULT NULL::bpchar,
    quantidadeentregue numeric(8,2) DEFAULT NULL::numeric,
    iditemtrabalho integer
);


--
-- TOC entry 6424 (class 0 OID 0)
-- Dependencies: 243
-- Name: COLUMN cotacaoitemrequisicao.situacao; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cotacaoitemrequisicao.situacao IS 'Aguardando - Aguardando aprovação\n            PreAprovado - Pré aprovado\n            Aprovado - Aprovado\n            NaoAprovado - Não aprovado';


--
-- TOC entry 244 (class 1259 OID 2246922)
-- Dependencies: 5
-- Name: criterioavaliacao; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE criterioavaliacao (
    idcriterio integer NOT NULL,
    descricao character varying(100) NOT NULL,
    aplicavelcotacao character(1) NOT NULL,
    aplicavelavaliacaosolicitante character(1) NOT NULL,
    aplicavelavaliacaocomprador character(1) NOT NULL,
    aplicavelqualificacaofornecedor character(1) NOT NULL,
    tipoavaliacao character(1) NOT NULL
);


--
-- TOC entry 6425 (class 0 OID 0)
-- Dependencies: 244
-- Name: COLUMN criterioavaliacao.tipoavaliacao; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN criterioavaliacao.tipoavaliacao IS 'S - Sim/No\n            A - Aceito/Nao Aceito\n            C - Conforme/Nao Conforme\n            N - Numero - 0 a 10';


--
-- TOC entry 245 (class 1259 OID 2246927)
-- Dependencies: 4330 4331 5
-- Name: criterioavaliacaofornecedor; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE criterioavaliacaofornecedor (
    idavaliacaofornecedor integer DEFAULT 0 NOT NULL,
    idcriterio integer DEFAULT 0 NOT NULL,
    valor integer,
    observacoes text
);


--
-- TOC entry 246 (class 1259 OID 2246948)
-- Dependencies: 5
-- Name: criteriocotacao; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE criteriocotacao (
    idcotacao integer NOT NULL,
    idcriterio integer NOT NULL,
    peso integer NOT NULL
);


--
-- TOC entry 247 (class 1259 OID 2246964)
-- Dependencies: 5
-- Name: criteriocotacaocategoria; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE criteriocotacaocategoria (
    idcategoria integer NOT NULL,
    idcriterio integer NOT NULL,
    pesocotacao integer NOT NULL
);


--
-- TOC entry 248 (class 1259 OID 2246980)
-- Dependencies: 5
-- Name: criterioitemcotacao; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE criterioitemcotacao (
    iditemcotacao integer NOT NULL,
    idcriterio integer NOT NULL,
    peso integer NOT NULL
);


--
-- TOC entry 249 (class 1259 OID 2246986)
-- Dependencies: 4332 4333 5
-- Name: demandas; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE demandas (
    iddemanda integer NOT NULL,
    idcontrato integer,
    idsituacaodemanda integer NOT NULL,
    idtipodemanda integer NOT NULL,
    idprojeto integer,
    iddemandapai integer,
    idfluxo integer NOT NULL,
    previsaoinicio date,
    datainicio date,
    previsaofim date,
    datafim date,
    detalhamento text,
    prioridade character(1) NOT NULL,
    expectativafim date,
    datacadastro date,
    complexidade integer,
    custototal numeric(18,3) DEFAULT NULL::numeric,
    observacao text,
    idos integer,
    glosa numeric(15,3) DEFAULT NULL::numeric
);


--
-- TOC entry 6426 (class 0 OID 0)
-- Dependencies: 249
-- Name: TABLE demandas; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE demandas IS 'demandas';


--
-- TOC entry 250 (class 1259 OID 2247002)
-- Dependencies: 4334 4335 5
-- Name: dicionario; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE dicionario (
    iddicionario integer NOT NULL,
    nome character varying(245) DEFAULT NULL::character varying,
    valor character varying(500) DEFAULT NULL::character varying,
    idlingua integer,
    personalizado character(1) DEFAULT 'N'::bpchar
);


--
-- TOC entry 251 (class 1259 OID 2247012)
-- Dependencies: 5
-- Name: emailsolicitacaoservico; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE emailsolicitacaoservico (
    messageid character varying(500) NOT NULL,
    situacao character varying(25) NOT NULL,
    idemailsolicitacaoservico integer NOT NULL
);


--
-- TOC entry 252 (class 1259 OID 2247020)
-- Dependencies: 5
-- Name: empregadoitemconfiguracao; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE empregadoitemconfiguracao (
    idusuario integer NOT NULL,
    iditemconfiguracao integer NOT NULL,
    idempregado integer,
    datainicio date NOT NULL,
    datafim date
);


--
-- TOC entry 6427 (class 0 OID 0)
-- Dependencies: 252
-- Name: TABLE empregadoitemconfiguracao; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE empregadoitemconfiguracao IS 'empregadoitemconfiguracao';


--
-- TOC entry 253 (class 1259 OID 2247027)
-- Dependencies: 4336 4337 4338 4339 4340 4341 4342 4343 4344 4345 4346 4347 4348 4349 4350 4351 4352 4353 4354 4355 5
-- Name: empregados; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE empregados (
    idempregado integer NOT NULL,
    nome character varying(80) NOT NULL,
    nomeprocura character varying(80) DEFAULT NULL::character varying,
    datanascimento date,
    sexo character(1) DEFAULT NULL::bpchar,
    cpf character varying(14) DEFAULT NULL::character varying,
    rg character varying(15) DEFAULT NULL::character varying,
    dataemissaorg date,
    idtiposangue integer DEFAULT 0,
    orgexpedidor character varying(15) DEFAULT NULL::character varying,
    iduforgexpedidor integer,
    pai character varying(50) DEFAULT NULL::character varying,
    mae character varying(50) DEFAULT NULL::character varying,
    conjuge character varying(50) DEFAULT NULL::character varying,
    observacoes text,
    estadocivil smallint,
    email character varying(200) DEFAULT NULL::character varying,
    datacadastro date,
    fumante character(1) DEFAULT 'N'::bpchar,
    ctpsnumero character varying(15) DEFAULT NULL::character varying,
    ctpsserie character varying(10) DEFAULT NULL::character varying,
    ctpsiduf integer,
    ctpsdataemissao date,
    nit character varying(20) DEFAULT NULL::character varying,
    dataadmissao date,
    datademissao date,
    tipo character(1) DEFAULT NULL::bpchar,
    idsituacaofuncional integer NOT NULL,
    custoporhora double precision,
    custototalmes double precision,
    valorsalario double precision,
    valorprodutividademedia double precision,
    valorplanosaudemedia double precision,
    valorvtramedia double precision,
    valorvrefmedia double precision,
    agencia character varying(10) DEFAULT NULL::character varying,
    contasalario character varying(20) DEFAULT NULL::character varying,
    idunidade integer,
    datafim date,
    telefone character varying(45) DEFAULT NULL::character varying,
    idcargo integer,
    vinculaacontratos character(1) DEFAULT NULL::bpchar,
    ramal character varying(5) DEFAULT NULL::character varying
);


--
-- TOC entry 6428 (class 0 OID 0)
-- Dependencies: 253
-- Name: TABLE empregados; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE empregados IS 'empregados';


--
-- TOC entry 254 (class 1259 OID 2247057)
-- Dependencies: 4356 5
-- Name: empresa; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE empresa (
    idempresa integer NOT NULL,
    nomeempresa character varying(150) NOT NULL,
    detalhamento text,
    datainicio date DEFAULT '2012-04-02'::date,
    datafim date
);


--
-- TOC entry 6429 (class 0 OID 0)
-- Dependencies: 254
-- Name: TABLE empresa; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE empresa IS 'empresa';


--
-- TOC entry 255 (class 1259 OID 2247066)
-- Dependencies: 4357 4358 4359 4360 4361 5
-- Name: endereco; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE endereco (
    idendereco integer NOT NULL,
    logradouro character varying(200) DEFAULT NULL::character varying,
    numero character varying(20) DEFAULT NULL::character varying,
    complemento character varying(200) DEFAULT NULL::character varying,
    bairro character varying(200) DEFAULT NULL::character varying,
    idcidade integer,
    idpais integer,
    cep character varying(8) DEFAULT NULL::character varying,
    iduf integer
);


--
-- TOC entry 479 (class 1259 OID 2249751)
-- Dependencies: 5
-- Name: entregaitemrequisicao; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE entregaitemrequisicao (
    identrega integer NOT NULL,
    idpedido integer NOT NULL,
    idcoletapreco integer NOT NULL,
    iditemrequisicaoproduto integer NOT NULL,
    idsolicitacaoservico bigint,
    quantidadeentregue numeric(8,2) NOT NULL,
    iditemtrabalho bigint,
    idparecer integer,
    situacao character varying(25) NOT NULL,
    observacoes text
);


--
-- TOC entry 256 (class 1259 OID 2247079)
-- Dependencies: 5
-- Name: etapas; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE etapas (
    idetapa integer NOT NULL,
    idfluxo integer NOT NULL,
    idetapapai integer,
    nomeetapa character varying(70) NOT NULL,
    ordem smallint NOT NULL
);


--
-- TOC entry 6430 (class 0 OID 0)
-- Dependencies: 256
-- Name: TABLE etapas; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE etapas IS 'etapas';


--
-- TOC entry 257 (class 1259 OID 2247086)
-- Dependencies: 4362 4363 5
-- Name: evento; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE evento (
    idevento integer NOT NULL,
    idempresa integer NOT NULL,
    descricao character varying(255) NOT NULL,
    ligarcasodesl character(1) NOT NULL,
    datainicio date,
    datafim date,
    usuario character varying(256) DEFAULT NULL::character varying,
    senha character varying(256) DEFAULT NULL::character varying
);


--
-- TOC entry 6431 (class 0 OID 0)
-- Dependencies: 257
-- Name: TABLE evento; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE evento IS 'evento';


--
-- TOC entry 258 (class 1259 OID 2247097)
-- Dependencies: 5
-- Name: eventoempregado; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE eventoempregado (
    idevento integer NOT NULL,
    idempregado integer NOT NULL,
    idgrupo integer,
    idunidade integer,
    iditemconfiguracaopai integer
);


--
-- TOC entry 6432 (class 0 OID 0)
-- Dependencies: 258
-- Name: TABLE eventoempregado; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE eventoempregado IS 'eventoempregado';


--
-- TOC entry 259 (class 1259 OID 2247105)
-- Dependencies: 5
-- Name: eventogrupo; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE eventogrupo (
    idevento integer,
    idgrupo integer
);


--
-- TOC entry 6433 (class 0 OID 0)
-- Dependencies: 259
-- Name: TABLE eventogrupo; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE eventogrupo IS 'eventogrupo';


--
-- TOC entry 260 (class 1259 OID 2247108)
-- Dependencies: 4364 4365 5
-- Name: eventoitemconfiguracao; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE eventoitemconfiguracao (
    idevento integer DEFAULT 0 NOT NULL,
    iditemconfiguracao integer DEFAULT 0 NOT NULL
);


--
-- TOC entry 261 (class 1259 OID 2247116)
-- Dependencies: 5
-- Name: eventomonitconhecimento; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE eventomonitconhecimento (
    ideventomonitoramento integer NOT NULL,
    idbaseconhecimento integer NOT NULL
);


--
-- TOC entry 262 (class 1259 OID 2247121)
-- Dependencies: 4366 4367 5
-- Name: eventomonitoramento; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE eventomonitoramento (
    ideventomonitoramento integer NOT NULL,
    nomeevento character varying(255) NOT NULL,
    detalhamento text,
    criadopor character varying(255) DEFAULT NULL::character varying,
    modificadopor character varying(255) DEFAULT NULL::character varying,
    datacriacao date,
    ultmodificacao date
);


--
-- TOC entry 263 (class 1259 OID 2247131)
-- Dependencies: 5
-- Name: eventounidade; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE eventounidade (
    idunidade integer,
    idevento integer
);


--
-- TOC entry 6434 (class 0 OID 0)
-- Dependencies: 263
-- Name: TABLE eventounidade; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE eventounidade IS 'eventounidade';


--
-- TOC entry 264 (class 1259 OID 2247134)
-- Dependencies: 5
-- Name: excecaocalendario; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE excecaocalendario (
    idexcecaocalendario integer NOT NULL,
    idcalendario integer NOT NULL,
    idjornada integer,
    tipo character(1) NOT NULL,
    datainicio date NOT NULL,
    datatermino date NOT NULL
);


--
-- TOC entry 6435 (class 0 OID 0)
-- Dependencies: 264
-- Name: COLUMN excecaocalendario.tipo; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN excecaocalendario.tipo IS 'F=Folga             T=Trabalho';


--
-- TOC entry 265 (class 1259 OID 2247141)
-- Dependencies: 5
-- Name: excecaoempregado; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE excecaoempregado (
    idevento integer NOT NULL,
    idempregado integer NOT NULL,
    idgrupo integer,
    idunidade integer
);


--
-- TOC entry 6436 (class 0 OID 0)
-- Dependencies: 265
-- Name: TABLE excecaoempregado; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE excecaoempregado IS 'excecaoempregado';


--
-- TOC entry 266 (class 1259 OID 2247149)
-- Dependencies: 4368 4369 4370 4371 5
-- Name: execucaoatividadeperiodica; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE execucaoatividadeperiodica (
    idexecucaoatividadeperiodica integer NOT NULL,
    idatividadeperiodica integer NOT NULL,
    dataprogramada date NOT NULL,
    horaprogramada character(5) DEFAULT NULL::bpchar,
    situacao character(1) NOT NULL,
    detalhamento text,
    usuario character(1) DEFAULT NULL::bpchar,
    idempregado integer,
    dataexecucao date,
    horaexecucao character(5) DEFAULT NULL::bpchar,
    dataregistro date,
    horaregistro character(5) DEFAULT NULL::bpchar,
    idprogramacaoatividade integer,
    idmotivosuspensao integer,
    complementomotivosuspensao text
);


--
-- TOC entry 267 (class 1259 OID 2247161)
-- Dependencies: 4372 5
-- Name: execucaobatch; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE execucaobatch (
    idexecucaobatch integer NOT NULL,
    idprocessamentobatch integer NOT NULL,
    conteudo text NOT NULL,
    datahora timestamp without time zone DEFAULT now() NOT NULL
);


--
-- TOC entry 268 (class 1259 OID 2247172)
-- Dependencies: 4373 4374 5
-- Name: execucaodemanda; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE execucaodemanda (
    idexecucao integer NOT NULL,
    iddemanda integer NOT NULL,
    idatividade integer NOT NULL,
    idempregadoexecutor integer,
    idempregadoreceptor integer,
    relato text,
    qtdehoras numeric(18,3) DEFAULT NULL::numeric,
    situacao character(1) NOT NULL,
    grupoexecutor character varying(20) DEFAULT NULL::character varying,
    terminoprevisto date,
    terminoreal date
);


--
-- TOC entry 6437 (class 0 OID 0)
-- Dependencies: 268
-- Name: TABLE execucaodemanda; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE execucaodemanda IS 'execucaodemanda';


--
-- TOC entry 269 (class 1259 OID 2247183)
-- Dependencies: 5
-- Name: execucaomudanca; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE execucaomudanca (
    idexecucao integer NOT NULL,
    idinstanciafluxo bigint NOT NULL,
    idrequisicaomudanca integer NOT NULL,
    idfluxo bigint NOT NULL,
    seqreabertura smallint
);


--
-- TOC entry 270 (class 1259 OID 2247201)
-- Dependencies: 5
-- Name: execucaosolicitacao; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE execucaosolicitacao (
    idexecucao bigint NOT NULL,
    idsolicitacaoservico bigint,
    idfase bigint,
    idinstanciafluxo bigint,
    idfluxo bigint,
    prazohh smallint,
    prazomm smallint,
    seqreabertura integer
);


--
-- TOC entry 271 (class 1259 OID 2247210)
-- Dependencies: 4375 4376 4377 4378 4379 4380 4381 4382 5
-- Name: externalconnection; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE externalconnection (
    idexternalconnection integer NOT NULL,
    nome character varying(80) NOT NULL,
    tipo character(1) NOT NULL,
    urljdbc character varying(255) DEFAULT NULL::character varying,
    jdbcdbname character varying(255) DEFAULT NULL::character varying,
    jdbcdriver character varying(255) DEFAULT NULL::character varying,
    jdbcuser character varying(255) DEFAULT NULL::character varying,
    jdbcpassword character varying(255) DEFAULT NULL::character varying,
    filename character varying(500) DEFAULT NULL::character varying,
    schemadb character varying(255) DEFAULT NULL::character varying,
    deleted character(1) DEFAULT NULL::bpchar
);


--
-- TOC entry 272 (class 1259 OID 2247226)
-- Dependencies: 4383 4384 4385 4386 5
-- Name: faixavaloresrecurso; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE faixavaloresrecurso (
    idfaixavaloresrecurso integer NOT NULL,
    idrecurso integer NOT NULL,
    valorinicio numeric(15,3) DEFAULT NULL::numeric,
    valorfim numeric(15,3) DEFAULT NULL::numeric,
    cor character varying(20) DEFAULT NULL::character varying,
    descricao character varying(80) DEFAULT NULL::character varying
);


--
-- TOC entry 273 (class 1259 OID 2247236)
-- Dependencies: 5
-- Name: faseservico; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE faseservico (
    idfase bigint NOT NULL,
    nomefase character varying(70) NOT NULL,
    fasecaptura character(1) NOT NULL
);


--
-- TOC entry 274 (class 1259 OID 2247241)
-- Dependencies: 4387 4388 4389 4390 4391 5
-- Name: fatura; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE fatura (
    idfatura integer NOT NULL,
    idcontrato integer NOT NULL,
    datainicial date NOT NULL,
    datafinal date NOT NULL,
    descricaofatura character varying(150) DEFAULT NULL::character varying,
    valorcotacaomoeda numeric(15,3) NOT NULL,
    datacriacao date NOT NULL,
    dataultmodificacao date NOT NULL,
    valorprevistosomaos numeric(15,3) DEFAULT NULL::numeric,
    valorsomaglosasos numeric(15,3) DEFAULT NULL::numeric,
    valorexecutadosomaos numeric(15,3) DEFAULT NULL::numeric,
    observacao text,
    aprovacaogestor text,
    aprovacaofiscal text,
    saldoprevisto numeric(15,3) DEFAULT NULL::numeric,
    situacaofatura character(1) NOT NULL
);


--
-- TOC entry 275 (class 1259 OID 2247255)
-- Dependencies: 4392 4393 4394 5
-- Name: faturaapuracaoans; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE faturaapuracaoans (
    idfaturaapuracaoans integer NOT NULL,
    idfatura integer NOT NULL,
    idacordonivelservicocontrato integer NOT NULL,
    valorapurado numeric(15,3) DEFAULT NULL::numeric,
    detalhamento text,
    percentualglosa numeric(15,3) DEFAULT NULL::numeric,
    valorglosa numeric(15,3) DEFAULT NULL::numeric,
    dataapuracao date
);


--
-- TOC entry 276 (class 1259 OID 2247268)
-- Dependencies: 5
-- Name: faturaos; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE faturaos (
    idfatura integer NOT NULL,
    idos integer NOT NULL
);


--
-- TOC entry 277 (class 1259 OID 2247274)
-- Dependencies: 4395 4396 4397 5
-- Name: feriado; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE feriado (
    idferiado integer NOT NULL,
    data date NOT NULL,
    descricao character varying(100) DEFAULT NULL::character varying,
    abrangencia character(1) DEFAULT NULL::bpchar,
    iduf integer,
    idcidade integer,
    recorrente character(1) DEFAULT NULL::bpchar
);


--
-- TOC entry 6438 (class 0 OID 0)
-- Dependencies: 277
-- Name: TABLE feriado; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE feriado IS 'feriado';


--
-- TOC entry 278 (class 1259 OID 2247282)
-- Dependencies: 5
-- Name: fluxo; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE fluxo (
    idfluxo integer NOT NULL,
    nomefluxo character varying(70) NOT NULL,
    descricao text
);


--
-- TOC entry 279 (class 1259 OID 2247290)
-- Dependencies: 5
-- Name: fluxos; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE fluxos (
    idfluxo integer NOT NULL,
    nomefluxo character varying(70) NOT NULL
);


--
-- TOC entry 6439 (class 0 OID 0)
-- Dependencies: 279
-- Name: TABLE fluxos; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE fluxos IS 'fluxos';


--
-- TOC entry 280 (class 1259 OID 2247295)
-- Dependencies: 4398 4399 5
-- Name: fluxoservico; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE fluxoservico (
    idservicocontrato bigint NOT NULL,
    idtipofluxo integer NOT NULL,
    idfase bigint NOT NULL,
    principal character(1) DEFAULT 'N'::bpchar NOT NULL,
    deleted character(1) DEFAULT NULL::bpchar
);


--
-- TOC entry 281 (class 1259 OID 2247304)
-- Dependencies: 5
-- Name: formula; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE formula (
    idformula integer NOT NULL,
    identificador character varying(120) NOT NULL,
    nome character varying(120) NOT NULL,
    conteudo text,
    datacriacao date
);


--
-- TOC entry 282 (class 1259 OID 2247314)
-- Dependencies: 4400 4401 4402 4403 4404 4405 4406 4407 4408 4409 5
-- Name: fornecedor; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE fornecedor (
    idfornecedor bigint NOT NULL,
    razaosocial character varying(100) NOT NULL,
    nomefantasia character varying(70) DEFAULT NULL::character varying,
    cnpj character varying(14) DEFAULT NULL::character varying,
    email character varying(255) DEFAULT NULL::character varying,
    observacao text,
    deleted character(1) DEFAULT NULL::bpchar,
    telefone character varying(20) DEFAULT NULL::character varying,
    fax character varying(20) DEFAULT NULL::character varying,
    nomecontato character varying(100) DEFAULT NULL::character varying,
    inscricaoestadual character varying(25) DEFAULT NULL::character varying,
    inscricaomunicipal character varying(25) DEFAULT NULL::character varying,
    idendereco integer,
    tipopessoa character(1) DEFAULT NULL::bpchar
);


--
-- TOC entry 283 (class 1259 OID 2247338)
-- Dependencies: 4410 5
-- Name: fornecedorcotacao; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE fornecedorcotacao (
    idcotacao integer NOT NULL,
    idfornecedor bigint DEFAULT 0::bigint NOT NULL
);


--
-- TOC entry 284 (class 1259 OID 2247355)
-- Dependencies: 5
-- Name: fornecedorproduto; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE fornecedorproduto (
    idfornecedorproduto integer NOT NULL,
    idfornecedor bigint,
    idtipoproduto integer NOT NULL,
    idmarca integer,
    datainicio date NOT NULL,
    datafim date
);


--
-- TOC entry 285 (class 1259 OID 2247368)
-- Dependencies: 4411 4412 5
-- Name: galeriaimagens; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE galeriaimagens (
    idimagem integer NOT NULL,
    idcategoriagaleriaimagem integer NOT NULL,
    nomeimagem character varying(255) NOT NULL,
    descricaoimagem character varying(70) DEFAULT NULL::character varying,
    detalhamento text,
    extensao character varying(15) DEFAULT NULL::character varying
);


--
-- TOC entry 6440 (class 0 OID 0)
-- Dependencies: 285
-- Name: TABLE galeriaimagens; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE galeriaimagens IS 'galeriaimagens';


--
-- TOC entry 286 (class 1259 OID 2247379)
-- Dependencies: 4413 5
-- Name: glosaos; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE glosaos (
    idglosaos integer NOT NULL,
    idos integer NOT NULL,
    datacriacao date NOT NULL,
    dataultmodificacao date NOT NULL,
    descricaoglosa text NOT NULL,
    ocorrencias text,
    percaplicado numeric(15,3) NOT NULL,
    custoglosa numeric(15,3) NOT NULL,
    numeroocorrencias numeric(15,3) DEFAULT NULL::numeric,
    idacordonivelservico integer
);


--
-- TOC entry 287 (class 1259 OID 2247390)
-- Dependencies: 5
-- Name: glosaservicocontrato; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE glosaservicocontrato (
    idglosaservicocontrato bigint NOT NULL,
    idservicocontrato bigint NOT NULL,
    quantidadeglosa integer,
    datafim date
);


--
-- TOC entry 288 (class 1259 OID 2247395)
-- Dependencies: 4414 4415 4416 4417 4418 4419 5
-- Name: grupo; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE grupo (
    idgrupo integer NOT NULL,
    idempresa integer NOT NULL,
    nome character varying(255) NOT NULL,
    datainicio date NOT NULL,
    datafim date,
    descricao text,
    servicedesk character(1) DEFAULT NULL::bpchar,
    sigla character varying(20) DEFAULT NULL::character varying,
    abertura character varying(45) DEFAULT NULL::character varying,
    encerramento character varying(45) DEFAULT NULL::character varying,
    andamento character varying(45) DEFAULT NULL::character varying,
    comiteconsultivomudanca character varying(1) DEFAULT NULL::character varying
);


--
-- TOC entry 6441 (class 0 OID 0)
-- Dependencies: 288
-- Name: TABLE grupo; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE grupo IS 'grupo';


--
-- TOC entry 289 (class 1259 OID 2247410)
-- Dependencies: 4420 5
-- Name: grupoatvperiodica; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE grupoatvperiodica (
    idgrupoatvperiodica integer NOT NULL,
    nomegrupoatvperiodica character varying(256) NOT NULL,
    descgrupoatvperiodica text,
    datainicio date NOT NULL,
    datafim date,
    deleted character(1) DEFAULT NULL::bpchar
);


--
-- TOC entry 6442 (class 0 OID 0)
-- Dependencies: 289
-- Name: TABLE grupoatvperiodica; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE grupoatvperiodica IS 'grupoatvperiodica';


--
-- TOC entry 290 (class 1259 OID 2247419)
-- Dependencies: 4421 4422 5
-- Name: grupoitemconfiguracao; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE grupoitemconfiguracao (
    idgrupoitemconfiguracao integer NOT NULL,
    nomegrupoitemconfiguracao character varying(100) NOT NULL,
    datainicio date NOT NULL,
    datafim date,
    email character varying(50) DEFAULT NULL::character varying,
    emailgrupoitemconfiguracao character varying(256) DEFAULT NULL::character varying,
    idgrupoitemconfiguracaopai integer
);


--
-- TOC entry 291 (class 1259 OID 2247426)
-- Dependencies: 5
-- Name: grupoquestionario; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE grupoquestionario (
    idgrupoquestionario integer NOT NULL,
    idquestionario integer NOT NULL,
    nomegrupoquestionario character varying(80) NOT NULL,
    ordem smallint
);


--
-- TOC entry 6443 (class 0 OID 0)
-- Dependencies: 291
-- Name: TABLE grupoquestionario; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE grupoquestionario IS 'grupoquestionario';


--
-- TOC entry 292 (class 1259 OID 2247432)
-- Dependencies: 4423 5
-- Name: gruporecursos; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE gruporecursos (
    idgruporecurso integer NOT NULL,
    nomegruporecurso character varying(70) NOT NULL,
    situacao character(1) NOT NULL,
    deleted character(1) DEFAULT NULL::bpchar
);


--
-- TOC entry 293 (class 1259 OID 2247438)
-- Dependencies: 4424 5
-- Name: gruposemails; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE gruposemails (
    idgrupo integer NOT NULL,
    idempregado integer,
    nome character varying(80) DEFAULT NULL::character varying,
    email character varying(200) NOT NULL
);


--
-- TOC entry 294 (class 1259 OID 2247444)
-- Dependencies: 4425 5
-- Name: gruposempregados; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE gruposempregados (
    idgrupo integer NOT NULL,
    idempregado integer NOT NULL,
    enviaemail character(1) DEFAULT NULL::bpchar
);


--
-- TOC entry 6444 (class 0 OID 0)
-- Dependencies: 294
-- Name: TABLE gruposempregados; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE gruposempregados IS 'gruposempregados';


--
-- TOC entry 295 (class 1259 OID 2247451)
-- Dependencies: 5
-- Name: grupovisao; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE grupovisao (
    idgrupovisao bigint NOT NULL,
    idvisao bigint NOT NULL,
    descricaogrupovisao character varying(500) NOT NULL,
    forma character(1) NOT NULL,
    ordem integer NOT NULL,
    situacao character(1) NOT NULL
);


--
-- TOC entry 296 (class 1259 OID 2247460)
-- Dependencies: 4426 5
-- Name: grupovisaocamposnegocio; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE grupovisaocamposnegocio (
    idgrupovisao bigint NOT NULL,
    idcamposobjetonegocio bigint NOT NULL,
    descricaonegocio character varying(500) NOT NULL,
    tiponegocio character varying(20) NOT NULL,
    ordem integer NOT NULL,
    situacao character(1) NOT NULL,
    obrigatorio character(1) NOT NULL,
    tamanho smallint NOT NULL,
    decimais smallint NOT NULL,
    tipoligacao character(1) DEFAULT NULL::bpchar,
    textosql text,
    tamanhoparapesq smallint,
    formula text,
    visivel character(1) NOT NULL,
    htmlcode text
);


--
-- TOC entry 297 (class 1259 OID 2247470)
-- Dependencies: 4427 5
-- Name: grupovisaocamposnegocioinfosql; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE grupovisaocamposnegocioinfosql (
    idgrupovisaocamposnegocioinfosql bigint NOT NULL,
    idgrupovisao bigint NOT NULL,
    idcamposobjetonegocio bigint NOT NULL,
    campo character varying(150) NOT NULL,
    tipoligacao character(1) NOT NULL,
    filtro text,
    descricao character varying(400) DEFAULT NULL::character varying
);


--
-- TOC entry 298 (class 1259 OID 2247480)
-- Dependencies: 4428 5
-- Name: grupovisaocamposnegocioligacao; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE grupovisaocamposnegocioligacao (
    idgrupovisaocamposnegocioligaca bigint NOT NULL,
    idgrupovisao bigint NOT NULL,
    idcamposobjetonegocio bigint NOT NULL,
    idcamposobjetonegocioligacao bigint,
    tipoligacao character(1) NOT NULL,
    filtro text,
    descricao character varying(400) DEFAULT NULL::character varying
);


--
-- TOC entry 299 (class 1259 OID 2247491)
-- Dependencies: 5
-- Name: hilosequences; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE hilosequences (
    sequencename character varying(50) NOT NULL,
    highvalues integer NOT NULL
);


--
-- TOC entry 300 (class 1259 OID 2247496)
-- Dependencies: 4429 4430 4431 4432 4433 4434 4435 4436 5
-- Name: historicobaseconhecimento; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE historicobaseconhecimento (
    idhistoricobaseconhecimento integer NOT NULL,
    idbaseconhecimento integer NOT NULL,
    idpasta integer,
    datainicio date,
    datafim date,
    titulo character varying(256) DEFAULT NULL::character varying,
    conteudo text,
    status character(1) DEFAULT NULL::bpchar,
    idbaseconhecimentopai integer,
    dataexpiracao date,
    versao character varying(45) DEFAULT NULL::character varying,
    idusuarioautor integer,
    idusuarioaprovador integer,
    fontereferencia character varying(255) DEFAULT NULL::character varying,
    idnotificacao integer,
    datapublicacao date,
    justificativaobservacao character varying(500) DEFAULT NULL::character varying,
    faq character varying(45) DEFAULT NULL::character varying,
    origem character(1) DEFAULT NULL::bpchar,
    arquivado character varying(45) DEFAULT NULL::character varying,
    idusuarioalteracao integer,
    datahoraalteracao timestamp without time zone,
    conteudosemformatacao text
);


--
-- TOC entry 301 (class 1259 OID 2247512)
-- Dependencies: 5
-- Name: historicoexecucao; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE historicoexecucao (
    idhistorico integer NOT NULL,
    idexecucao integer NOT NULL,
    data date NOT NULL,
    situacao character(1) NOT NULL,
    idempregadoexecutor integer NOT NULL,
    detalhamento text,
    hora integer
);


--
-- TOC entry 6445 (class 0 OID 0)
-- Dependencies: 301
-- Name: TABLE historicoexecucao; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE historicoexecucao IS 'historicoexecucao';


--
-- TOC entry 302 (class 1259 OID 2247521)
-- Dependencies: 4437 4438 4439 4440 4441 4442 4443 4444 4445 5
-- Name: historicoic; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE historicoic (
    idhistoricoic integer NOT NULL,
    iditemconfiguracao integer NOT NULL,
    identificacao character varying(400) NOT NULL,
    iditemconfiguracaopai integer,
    idtipoitemconfiguracao integer,
    idgrupoitemconfiguracao integer,
    idproprietario integer,
    versao character varying(250) DEFAULT NULL::character varying,
    familia character varying(250) DEFAULT NULL::character varying,
    idfamiliaitemconfiguracao integer,
    classe character varying(250) DEFAULT NULL::character varying,
    idclasseitemconfiguracao integer,
    localidade character varying(250) DEFAULT NULL::character varying,
    status integer,
    criticidade integer,
    numeroserie character varying(45) DEFAULT NULL::character varying,
    dataexpiracao date,
    idmudanca integer,
    idproblema integer,
    idincidente integer,
    idautoralteracao integer NOT NULL,
    datahoraalteracao timestamp without time zone DEFAULT now() NOT NULL,
    baseline character varying(30) DEFAULT NULL::character varying,
    restauracao integer,
    idmidiasoftware integer,
    impacto character varying(255) DEFAULT NULL::character varying,
    urgencia character varying(255) DEFAULT NULL::character varying,
    historicoversao decimal(5, 2)
);


--
-- TOC entry 303 (class 1259 OID 2247544)
-- Dependencies: 4446 5
-- Name: historicosituacaocotacao; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE historicosituacaocotacao (
    idhistorico integer NOT NULL,
    idcotacao integer NOT NULL,
    idresponsavel integer NOT NULL,
    datahora timestamp without time zone DEFAULT now() NOT NULL,
    situacao character varying(25) NOT NULL
);


--
-- TOC entry 304 (class 1259 OID 2247564)
-- Dependencies: 4447 4448 5
-- Name: historicotentativa; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE historicotentativa (
    idhistoricotentativa integer NOT NULL,
    iditemconfiguracao integer,
    idbaseitemconfiguracao integer,
    idevento integer,
    idempregado integer,
    descricao character varying(255) DEFAULT NULL::character varying,
    data date,
    hora character(4) DEFAULT NULL::bpchar
);


--
-- TOC entry 6446 (class 0 OID 0)
-- Dependencies: 304
-- Name: TABLE historicotentativa; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE historicotentativa IS 'historicotentativa';


--
-- TOC entry 305 (class 1259 OID 2247576)
-- Dependencies: 4449 4450 4451 4452 5
-- Name: historicovalor; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE historicovalor (
    idhistoricovalor integer NOT NULL,
    idvalor integer NOT NULL,
    iditemconfiguracao integer,
    idcaracteristica integer,
    valorstr character varying(4000) DEFAULT NULL::character varying,
    valorlongo text,
    valordecimal numeric(18,4) DEFAULT NULL::numeric,
    valordate date,
    idbaseitemconfiguracao integer,
    datahoraalteracao timestamp without time zone DEFAULT now() NOT NULL,
    idautoralteracao integer NOT NULL,
    baseline character varying(30) DEFAULT NULL::character varying,
    idhistoricoic integer
);


--
-- TOC entry 306 (class 1259 OID 2247591)
-- Dependencies: 5
-- Name: htmlcodevisao; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE htmlcodevisao (
    idhtmlcodevisao bigint NOT NULL,
    idvisao bigint NOT NULL,
    htmlcodetype character(30) NOT NULL,
    htmlcode text NOT NULL
);

CREATE TABLE instalacao
(
	idinstalacao integer NOT NULL,
   	sucesso character(1), 
   	passo character varying
);

--
-- TOC entry 307 (class 1259 OID 2247600)
-- Dependencies: 4453 5
-- Name: imagemhistorico; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE imagemhistorico (
    idimagem integer NOT NULL,
    data date NOT NULL,
    nomearquivo character varying(255) NOT NULL,
    observacao text,
    idcontrato integer NOT NULL,
    idprofissional integer,
    idempresa integer,
    aba character varying(30) DEFAULT NULL::character varying
);


--
-- TOC entry 308 (class 1259 OID 2247610)
-- Dependencies: 4454 4455 5
-- Name: imagemitemconfiguracao; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE imagemitemconfiguracao (
    idimagemitemconfiguracao integer NOT NULL,
    idservico integer,
    iditemconfiguracao integer,
    posx integer,
    posy integer,
    descricao character varying(256) DEFAULT NULL::character varying,
    caminhoimagem character varying(256) DEFAULT NULL::character varying,
    idimagemitemconfiguracaopai integer
);


--
-- TOC entry 6447 (class 0 OID 0)
-- Dependencies: 308
-- Name: TABLE imagemitemconfiguracao; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE imagemitemconfiguracao IS 'imagemitemconfiguracao';


--
-- TOC entry 309 (class 1259 OID 2247623)
-- Dependencies: 4456 4457 5
-- Name: imagemservicorelacionado; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE imagemservicorelacionado (
    idimagemservicorelacionado integer NOT NULL,
    idservico integer,
    idservicorelacionado integer,
    posx integer,
    posy integer,
    descricao character varying(256) DEFAULT NULL::character varying,
    caminhoimagem character varying(256) DEFAULT NULL::character varying,
    idimagemservicorelacionadopai integer
);


--
-- TOC entry 310 (class 1259 OID 2247636)
-- Dependencies: 4458 5
-- Name: impacto; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE impacto (
    idimpacto integer NOT NULL,
    nivelimpacto character varying(100) NOT NULL,
    siglaimpacto character(2) DEFAULT NULL::bpchar
);


--
-- TOC entry 311 (class 1259 OID 2247642)
-- Dependencies: 5
-- Name: importanciaconhecimentogrupo; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE importanciaconhecimentogrupo (
    idbaseconhecimento integer NOT NULL,
    idgrupo integer NOT NULL,
    grauimportanciagrupo character varying(45) NOT NULL
);


--
-- TOC entry 312 (class 1259 OID 2247647)
-- Dependencies: 5
-- Name: importanciaconhecimentousuario; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE importanciaconhecimentousuario (
    idbaseconhecimento integer NOT NULL,
    idusuario integer NOT NULL,
    grauimportanciausuario character varying(45) NOT NULL
);


--
-- TOC entry 313 (class 1259 OID 2247652)
-- Dependencies: 5
-- Name: importancianegocio; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE importancianegocio (
    idimportancianegocio integer NOT NULL,
    idempresa integer NOT NULL,
    nomeimportancianegocio character varying(100) NOT NULL,
    situacao character(1) NOT NULL
);


--
-- TOC entry 6448 (class 0 OID 0)
-- Dependencies: 313
-- Name: TABLE importancianegocio; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE importancianegocio IS 'importancianegocio';


--
-- TOC entry 314 (class 1259 OID 2247658)
-- Dependencies: 4459 4460 4461 5
-- Name: importconfig; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE importconfig (
    idimportconfig integer NOT NULL,
    tipo character(1) NOT NULL,
    idexternalconnection integer,
    tabelaorigem character varying(255) DEFAULT NULL::character varying,
    tabeladestino character varying(255) DEFAULT NULL::character varying,
    filtroorigem text,
    nome character varying(100) DEFAULT NULL::character varying
);


--
-- TOC entry 315 (class 1259 OID 2247675)
-- Dependencies: 4462 4463 5
-- Name: importconfigcampos; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE importconfigcampos (
    idimportconfigcampo integer NOT NULL,
    idimportconfig integer NOT NULL,
    origem character varying(255) DEFAULT NULL::character varying,
    destino character varying(255) DEFAULT NULL::character varying,
    script text
);


--
-- TOC entry 316 (class 1259 OID 2247691)
-- Dependencies: 4464 5
-- Name: infocatalogoservico; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE infocatalogoservico (
    idinfocatalogoservico integer NOT NULL,
    idcatalogoservico integer,
    descinfocatalogoservico text,
    nomeinfocatalogoservico character varying(200) DEFAULT NULL::character varying
);


--
-- TOC entry 317 (class 1259 OID 2247701)
-- Dependencies: 5
-- Name: informacaoservico_idinformacaoservico_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE informacaoservico_idinformacaoservico_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 318 (class 1259 OID 2247703)
-- Dependencies: 4465 4466 4467 4468 4469 4470 5
-- Name: informacaoservico; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE informacaoservico (
    idinformacaoservico integer DEFAULT nextval('informacaoservico_idinformacaoservico_seq'::regclass) NOT NULL,
    idservico bigint NOT NULL,
    usuario character varying(255) DEFAULT NULL::character varying,
    titulo character varying(255) DEFAULT NULL::character varying,
    texto character varying(255) DEFAULT NULL::character varying,
    situacao character varying(255) DEFAULT NULL::character varying,
    deleted character varying(255) DEFAULT NULL::character varying
);


--
-- TOC entry 319 (class 1259 OID 2247718)
-- Dependencies: 4471 4472 4473 4474 4475 4476 4477 4478 4479 5
-- Name: informacoescontratoconfig; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE informacoescontratoconfig (
    idinformacoescontratoconfig integer NOT NULL,
    idinformacoescontratoconfigpai integer,
    nome character varying(50) NOT NULL,
    descricao character varying(70) NOT NULL,
    funcionalidadepath character varying(255) DEFAULT NULL::character varying,
    funcitem character(1) NOT NULL,
    idquestionario integer,
    idempresa integer NOT NULL,
    situacao character(1) NOT NULL,
    ordem smallint,
    infoadicional text,
    funcadicionalaposgravacao character varying(255) DEFAULT NULL::character varying,
    chamarfuncaddaposgravar character(1) DEFAULT NULL::bpchar,
    chamarfuncaddhistorico character(1) DEFAULT NULL::bpchar,
    iconefunchistorico character varying(255) DEFAULT NULL::character varying,
    iconefunchistoricofinal character varying(255) DEFAULT NULL::character varying,
    validacoes text,
    segurancaunidade character(1) DEFAULT NULL::bpchar,
    segurancaunidadepcmso character(1) DEFAULT NULL::bpchar,
    segurancaunidadeenferm character(1) DEFAULT NULL::bpchar
);


--
-- TOC entry 6449 (class 0 OID 0)
-- Dependencies: 319
-- Name: TABLE informacoescontratoconfig; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE informacoescontratoconfig IS 'informacoescontratoconfig';


--
-- TOC entry 320 (class 1259 OID 2247738)
-- Dependencies: 5
-- Name: informacoescontratoperfseg; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE informacoescontratoperfseg (
    idinformacoescontratoconfig integer NOT NULL,
    idperfilseguranca integer NOT NULL
);


--
-- TOC entry 6450 (class 0 OID 0)
-- Dependencies: 320
-- Name: TABLE informacoescontratoperfseg; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE informacoescontratoperfseg IS 'informacoescontratoperfseg';


--
-- TOC entry 321 (class 1259 OID 2247744)
-- Dependencies: 4480 4481 5
-- Name: inspecaoentregaitem; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE inspecaoentregaitem (
    identrega integer NOT NULL,
    idcriterio integer NOT NULL,
    idresponsavel integer,
    datahorainspecao timestamp without time zone DEFAULT now() NOT NULL,
    avaliacao character varying(25) DEFAULT NULL::character varying,
    observacoes text
);


--
-- TOC entry 322 (class 1259 OID 2247768)
-- Dependencies: 4482 4483 5
-- Name: inspecaopedidocompra; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE inspecaopedidocompra (
    idpedido integer NOT NULL,
    idcriterio integer NOT NULL,
    idresponsavel integer NOT NULL,
    datahorainspecao timestamp without time zone DEFAULT now() NOT NULL,
    avaliacao character varying(25) DEFAULT NULL::character varying,
    observacoes text
);


--
-- TOC entry 323 (class 1259 OID 2247792)
-- Dependencies: 4484 5
-- Name: inventarioxml; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE inventarioxml (
    idinventarioxml integer NOT NULL,
    conteudo text,
    idnetmap integer,
    datainicial date,
    datafinal date,
    nome character varying(256) DEFAULT NULL::character varying
);


--
-- TOC entry 6451 (class 0 OID 0)
-- Dependencies: 323
-- Name: TABLE inventarioxml; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE inventarioxml IS 'inventarioxml';


--
-- TOC entry 324 (class 1259 OID 2247802)
-- Dependencies: 5
-- Name: itemcfgsolicitacaoserv; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE itemcfgsolicitacaoserv (
    iditemconfiguracao integer,
    idsolicitacaoservico bigint,
    datainicio date,
    datafim date
);


--
-- TOC entry 325 (class 1259 OID 2247807)
-- Dependencies: 4485 4486 4487 4488 4489 4490 4491 5
-- Name: itemconfiguracao; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE itemconfiguracao (
    iditemconfiguracao integer NOT NULL,
    identificacao character varying(400) NOT NULL,
    iditemconfiguracaopai integer,
    idtipoitemconfiguracao integer,
    datainicio date NOT NULL,
    datafim date,
    idgrupoitemconfiguracao integer,
    idproprietario integer,
    dataexpiracao date,
    versao character varying(50) DEFAULT NULL::character varying,
    familia character varying(250) DEFAULT NULL::character varying,
    classe character varying(250) DEFAULT NULL::character varying,
    localidade character varying(250) DEFAULT NULL::character varying,
    status integer,
    criticidade integer,
    numeroserie character varying(45) DEFAULT NULL::character varying,
    idmudanca integer,
    idproblema integer,
    idincidente integer,
    idmidiasoftware integer,
    impacto character varying(255) DEFAULT NULL::character varying,
    urgencia character varying(255) DEFAULT NULL::character varying,
    idbaseconhecimento integer
);


--
-- TOC entry 6452 (class 0 OID 0)
-- Dependencies: 325
-- Name: TABLE itemconfiguracao; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE itemconfiguracao IS 'itemconfiguracao';


--
-- TOC entry 326 (class 1259 OID 2247843)
-- Dependencies: 4492 4493 4494 4495 5
-- Name: itemconfiguracaoevento; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE itemconfiguracaoevento (
    iditemconfiguracaoevento integer NOT NULL,
    idbaseitemconfiguracao integer,
    iditemconfiguracao integer,
    idevento integer NOT NULL,
    tipoexecucao character(1) DEFAULT NULL::bpchar,
    gerarquando character(1) NOT NULL,
    data date NOT NULL,
    hora character(4) DEFAULT NULL::bpchar,
    linhacomando character varying(255) DEFAULT NULL::character varying,
    linhacomandolinux character varying(255) DEFAULT NULL::character varying
);


--
-- TOC entry 6453 (class 0 OID 0)
-- Dependencies: 326
-- Name: TABLE itemconfiguracaoevento; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE itemconfiguracaoevento IS 'itemconfiguracaoevento';


--
-- TOC entry 327 (class 1259 OID 2247856)
-- Dependencies: 4496 4497 4498 4499 4500 4501 4502 5
-- Name: itemcotacao; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE itemcotacao (
    iditemcotacao integer NOT NULL,
    idcotacao integer,
    idproduto integer,
    tipoidentificacao character(1) NOT NULL,
    quantidade numeric(8,2) DEFAULT NULL::numeric,
    situacao character varying(20) DEFAULT NULL::character varying,
    datahoralimite timestamp without time zone DEFAULT now() NOT NULL,
    idcategoriaproduto integer,
    idunidademedida integer,
    descricaoitem character varying(200) NOT NULL,
    especificacoes text,
    marcapreferencial character varying(100) DEFAULT NULL::character varying,
    precoaproximado numeric(8,2) DEFAULT NULL::numeric,
    solicitacoesatendidas text,
    resultadovalidacao character(1) DEFAULT NULL::bpchar,
    mensagensvalidacao text,
    pesopreco integer,
    pesoprazoentrega integer,
    pesoprazopagto integer,
    pesotaxajuros integer,
    pesoprazogarantia integer,
    exigefornecedorqualificado character(1) DEFAULT NULL::bpchar
);


--
-- TOC entry 328 (class 1259 OID 2247887)
-- Dependencies: 4503 4504 4505 4506 4507 5
-- Name: itempedidocompra; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE itempedidocompra (
    iditempedido integer NOT NULL,
    idpedido integer NOT NULL,
    idproduto integer NOT NULL,
    idcoletapreco integer,
    quantidade numeric(8,2) NOT NULL,
    valortotal numeric(8,2) NOT NULL,
    valordesconto numeric(8,2) DEFAULT NULL::numeric,
    valoracrescimo numeric(8,2) DEFAULT NULL::numeric,
    basecalculoicms numeric(8,2) DEFAULT NULL::numeric,
    aliquotaicms numeric(8,2) DEFAULT NULL::numeric,
    aliquotaipi numeric(8,2) DEFAULT NULL::numeric
);


--
-- TOC entry 329 (class 1259 OID 2247905)
-- Dependencies: 4508 4509 4510 4511 4512 4513 4514 4515 5
-- Name: itemrequisicaoproduto; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE itemrequisicaoproduto (
    iditemrequisicaoproduto integer NOT NULL,
    idsolicitacaoservico integer NOT NULL,
    idparecervalidacao integer,
    idparecerautorizacao integer,
    idcategoriaproduto integer,
    idunidademedida integer,
    idproduto integer,
    iditemcotacao integer,
    descricaoitem character varying(200) NOT NULL,
    especificacoes text,
    quantidade numeric(8,2) NOT NULL,
    marcapreferencial character varying(100) DEFAULT NULL::character varying,
    precoaproximado numeric(8,2) DEFAULT NULL::numeric,
    situacao character varying(20) DEFAULT NULL::character varying,
    percvariacaopreco numeric(8,2) DEFAULT NULL::numeric,
    qtdeaprovada numeric(8,2) DEFAULT NULL::numeric,
    tipoatendimento character(1) NOT NULL,
    tipoidentificacao character(1) NOT NULL,
    aprovacotacao character(1) DEFAULT NULL::bpchar,
    qtdecotada numeric(8,2) DEFAULT NULL::numeric,
    valoraprovado numeric(8,2) DEFAULT NULL::numeric
);


--
-- TOC entry 6454 (class 0 OID 0)
-- Dependencies: 329
-- Name: COLUMN itemrequisicaoproduto.tipoatendimento; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN itemrequisicaoproduto.tipoatendimento IS 'C - Cotação\n            E - Estoque';


--
-- TOC entry 330 (class 1259 OID 2247938)
-- Dependencies: 4516 4517 4518 4519 4520 4521 4522 4523 4524 4525 4526 5
-- Name: jornadatrabalho; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE jornadatrabalho (
    idjornada integer NOT NULL,
    descricao character varying(70) NOT NULL,
    inicio1 character(5) DEFAULT NULL::bpchar,
    termino1 character(5) DEFAULT NULL::bpchar,
    inicio2 character(5) DEFAULT NULL::bpchar,
    termino2 character(5) DEFAULT NULL::bpchar,
    inicio3 character(5) DEFAULT NULL::bpchar,
    termino3 character(5) DEFAULT NULL::bpchar,
    inicio4 character(5) DEFAULT NULL::bpchar,
    termino4 character(5) DEFAULT NULL::bpchar,
    inicio5 character(5) DEFAULT NULL::bpchar,
    termino5 character(5) DEFAULT NULL::bpchar,
    cargahoraria character(5) DEFAULT NULL::bpchar,
    datainicio date,
    datafim date
);


--
-- TOC entry 331 (class 1259 OID 2247954)
-- Dependencies: 4527 5
-- Name: justificacaofalha; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE justificacaofalha (
    idjustificacaofalha integer NOT NULL,
    iditemconfiguracao integer,
    idbaseitemconfiguracao integer,
    idevento integer,
    idempregado integer,
    idhistoricotentativa integer,
    descricao text,
    data date,
    hora character(4) DEFAULT NULL::bpchar
);


--
-- TOC entry 6455 (class 0 OID 0)
-- Dependencies: 331
-- Name: TABLE justificacaofalha; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE justificacaofalha IS 'justificacaofalha';


--
-- TOC entry 332 (class 1259 OID 2247968)
-- Dependencies: 4528 4529 5
-- Name: justificativamudanca; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE justificativamudanca (
    idjustificativamudanca integer NOT NULL,
    descricaojustificativa character varying(100) NOT NULL,
    suspensao character(1) NOT NULL,
    situacao character(1) NOT NULL,
    aprovacao character(1) DEFAULT NULL::bpchar,
    deleted character(1) DEFAULT NULL::bpchar
);


--
-- TOC entry 333 (class 1259 OID 2247975)
-- Dependencies: 4530 4531 4532 4533 5
-- Name: justificativaparecer; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE justificativaparecer (
    idjustificativa integer NOT NULL,
    descricaojustificativa character varying(100) NOT NULL,
    situacao character(1) DEFAULT NULL::bpchar,
    aplicavelrequisicao character(1) DEFAULT NULL::bpchar,
    aplicavelcotacao character(1) DEFAULT NULL::bpchar,
    aplicavelinspecao character(1) DEFAULT NULL::bpchar
);


--
-- TOC entry 334 (class 1259 OID 2247984)
-- Dependencies: 4534 4535 5
-- Name: justificativasolicitacao; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE justificativasolicitacao (
    idjustificativa integer NOT NULL,
    descricaojustificativa character varying(100) NOT NULL,
    suspensao character(1) NOT NULL,
    situacao character(1) NOT NULL,
    deleted character(1) DEFAULT NULL::bpchar,
    aprovacao character(1) DEFAULT NULL::bpchar
);


--
-- TOC entry 335 (class 1259 OID 2247991)
-- Dependencies: 4536 5
-- Name: liberacao; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE liberacao (
    idliberacao integer NOT NULL,
    idsolicitante integer NOT NULL,
    idresponsavel integer,
    titulo character varying(100) NOT NULL,
    descricao text NOT NULL,
    datainicial date NOT NULL,
    datafinal date NOT NULL,
    dataliberacao date,
    situacao character(1) NOT NULL,
    risco character(1) NOT NULL,
    versao character varying(25) DEFAULT NULL::character varying
);


--
-- TOC entry 6456 (class 0 OID 0)
-- Dependencies: 335
-- Name: COLUMN liberacao.situacao; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN liberacao.situacao IS 'A - Aceita\n            E - Em execução\n            F - Finalizada\n            X - Cancelada';


--
-- TOC entry 6457 (class 0 OID 0)
-- Dependencies: 335
-- Name: COLUMN liberacao.risco; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN liberacao.risco IS 'B - Baixo\n            M - Médio\n            A - Alto';


--
-- TOC entry 336 (class 1259 OID 2248002)
-- Dependencies: 5
-- Name: liberacaomudanca; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE liberacaomudanca (
    idliberacao integer,
    idrequisicaomudanca integer
);


--
-- TOC entry 337 (class 1259 OID 2248008)
-- Dependencies: 4537 4538 4539 5
-- Name: limitealcada; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE limitealcada (
    idlimitealcada integer NOT NULL,
    idalcada integer NOT NULL,
    idgrupo integer NOT NULL,
    tipolimite character(1) DEFAULT NULL::bpchar,
    abrangenciacentrocusto character varying(20) NOT NULL,
    limitevaloritem numeric(8,2) DEFAULT NULL::numeric,
    limitevalormensal numeric(8,2) DEFAULT NULL::numeric,
    situacao character(1) NOT NULL
);


--
-- TOC entry 6458 (class 0 OID 0)
-- Dependencies: 337
-- Name: COLUMN limitealcada.tipolimite; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN limitealcada.tipolimite IS 'F - Por faixa de valores\n            Q - Qualquer valor\n            ';


--
-- TOC entry 6459 (class 0 OID 0)
-- Dependencies: 337
-- Name: COLUMN limitealcada.abrangenciacentrocusto; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN limitealcada.abrangenciacentrocusto IS 'T - Todos\n            R - Somente o responsável';


--
-- TOC entry 338 (class 1259 OID 2248028)
-- Dependencies: 4540 4541 5
-- Name: lingua; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE lingua (
    idlingua integer NOT NULL,
    nome character varying(245) DEFAULT NULL::character varying,
    sigla character varying(245) DEFAULT NULL::character varying,
    datainicio date,
    datafim date
);


--
-- TOC entry 339 (class 1259 OID 2248035)
-- Dependencies: 4542 5
-- Name: localexecucaoservico; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE localexecucaoservico (
    idlocalexecucaoservico integer NOT NULL,
    nomelocalexecucaoservico character varying(70) NOT NULL,
    deleted character(1) DEFAULT NULL::bpchar
);


--
-- TOC entry 340 (class 1259 OID 2248041)
-- Dependencies: 4543 5
-- Name: localidade; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE localidade (
    idlocalidade integer NOT NULL,
    nomelocalidade character varying(255) DEFAULT NULL::character varying,
    datainicio date,
    datafim date
);


--
-- TOC entry 341 (class 1259 OID 2248047)
-- Dependencies: 5
-- Name: localidadeunidade; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE localidadeunidade (
    idlocalidadeunidade integer NOT NULL,
    idunidade integer NOT NULL,
    idlocalidade integer NOT NULL,
    datainicio date,
    datafim date
);


--
-- TOC entry 342 (class 1259 OID 2248058)
-- Dependencies: 5
-- Name: logdados_idlog_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE logdados_idlog_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 343 (class 1259 OID 2248060)
-- Dependencies: 4544 4545 4546 4547 4548 4549 5
-- Name: logdados; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE logdados (
    idlog integer DEFAULT nextval('logdados_idlog_seq'::regclass) NOT NULL,
    dtatualizacao date,
    operacao character varying(100) DEFAULT NULL::character varying,
    dados text,
    idusuario integer,
    localorigem character varying(255) DEFAULT NULL::character varying,
    nometabela character varying(255) DEFAULT NULL::character varying,
    logdadoscol character varying(45) DEFAULT NULL::character varying,
    datalog timestamp without time zone DEFAULT now() NOT NULL
);


--
-- TOC entry 344 (class 1259 OID 2248076)
-- Dependencies: 5
-- Name: marca; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE marca (
    idmarca integer NOT NULL,
    idfabricante bigint,
    nomemarca character varying(100) NOT NULL,
    situacao character(1) NOT NULL
);


--
-- TOC entry 345 (class 1259 OID 2248087)
-- Dependencies: 4550 5
-- Name: matrizprioridade; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE matrizprioridade (
    idmatrizprioridade integer NOT NULL,
    siglaimpacto character(2) NOT NULL,
    siglaurgencia character(2) NOT NULL,
    valorprioridade integer NOT NULL,
    idcontrato integer,
    deleted character(1) DEFAULT NULL::bpchar
);


--
-- TOC entry 346 (class 1259 OID 2248093)
-- Dependencies: 4551 4552 4553 4554 4555 4556 5
-- Name: matrizvisao; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE matrizvisao (
    idmatriz bigint NOT NULL,
    idvisao bigint,
    idobjetonegocio bigint,
    idcamposobjetonegocio1 bigint,
    idcamposobjetonegocio2 bigint,
    idcamposobjetonegocio3 bigint,
    strinfo text,
    nomecampo1 character varying(255) DEFAULT NULL::character varying,
    nomecampo2 character varying(255) DEFAULT NULL::character varying,
    nomecampo3 character varying(255) DEFAULT NULL::character varying,
    descricaocampo1 character varying(255) DEFAULT NULL::character varying,
    descricaocampo2 character varying(255) DEFAULT NULL::character varying,
    descricaocampo3 character varying(255) DEFAULT NULL::character varying
);


--
-- TOC entry 347 (class 1259 OID 2248127)
-- Dependencies: 4557 4558 4559 4560 4561 5
-- Name: menu; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE menu (
    idmenu integer NOT NULL,
    idmenupai integer,
    nome character varying(256) NOT NULL,
    datainicio date NOT NULL,
    datafim date,
    descricao character varying(256) DEFAULT NULL::character varying,
    ordem integer,
    link character varying(256) DEFAULT NULL::character varying,
    imagem character varying(256) DEFAULT NULL::character varying,
    horizontal character varying(10) DEFAULT NULL::character varying,
    menurapido character varying(45) DEFAULT NULL::character varying
);


--
-- TOC entry 6460 (class 0 OID 0)
-- Dependencies: 347
-- Name: TABLE menu; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE menu IS 'menu';


--
-- TOC entry 348 (class 1259 OID 2248144)
-- Dependencies: 5
-- Name: meucatalogo; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE meucatalogo (
    idusuario integer NOT NULL,
    idservico integer NOT NULL
);


--
-- TOC entry 349 (class 1259 OID 2248149)
-- Dependencies: 4562 4563 5
-- Name: midia; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE midia (
    idmidia integer NOT NULL,
    nome character varying(200) DEFAULT NULL::character varying,
    midiacol character varying(45) DEFAULT NULL::character varying
);


--
-- TOC entry 350 (class 1259 OID 2248156)
-- Dependencies: 4564 4565 4566 5
-- Name: midiasoftware; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE midiasoftware (
    idmidiasoftware integer NOT NULL,
    nome character varying(200) NOT NULL,
    endfisico character varying(500) DEFAULT NULL::character varying,
    versao character varying(20) DEFAULT NULL::character varying,
    endlogico character varying(200) DEFAULT NULL::character varying,
    licencas integer,
    idmidia integer,
    idtiposoftware integer,
    datainicio date,
    datafim date
);


--
-- TOC entry 351 (class 1259 OID 2248169)
-- Dependencies: 4567 5
-- Name: modelosemails; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE modelosemails (
    idmodeloemail integer NOT NULL,
    titulo character varying(100) NOT NULL,
    texto text NOT NULL,
    situacao character(1) NOT NULL,
    identificador character varying(20) DEFAULT NULL::character varying
);


--
-- TOC entry 352 (class 1259 OID 2248178)
-- Dependencies: 5
-- Name: moedas; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE moedas (
    idmoeda integer NOT NULL,
    nomemoeda character varying(50) NOT NULL
);


--
-- TOC entry 6461 (class 0 OID 0)
-- Dependencies: 352
-- Name: TABLE moedas; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE moedas IS 'moedas';


--
-- TOC entry 353 (class 1259 OID 2248183)
-- Dependencies: 5
-- Name: motivosuspensaoativid; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE motivosuspensaoativid (
    idmotivo integer NOT NULL,
    descricao character varying(100) NOT NULL
);


--
-- TOC entry 6462 (class 0 OID 0)
-- Dependencies: 353
-- Name: TABLE motivosuspensaoativid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE motivosuspensaoativid IS 'motivosuspensaoativid';


--
-- TOC entry 354 (class 1259 OID 2248188)
-- Dependencies: 4568 4569 4570 4571 5
-- Name: nagiosconexao; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE nagiosconexao (
    idnagiosconexao integer NOT NULL,
    nome character varying(255) NOT NULL,
    nomejndi character varying(255) DEFAULT NULL::character varying,
    criadopor character varying(255) DEFAULT NULL::character varying,
    modificadopor character varying(255) DEFAULT NULL::character varying,
    datacriacao date,
    ultmodificacao date,
    deleted character(1) DEFAULT NULL::bpchar
);


--
-- TOC entry 355 (class 1259 OID 2248200)
-- Dependencies: 4572 4573 4574 4575 5
-- Name: netmap; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE netmap (
    idnetmap integer NOT NULL,
    ip character varying(50) DEFAULT NULL::character varying,
    mask character varying(50) DEFAULT NULL::character varying,
    mac character varying(50) DEFAULT NULL::character varying,
    date date,
    nome character varying(150) DEFAULT NULL::character varying
);


--
-- TOC entry 6463 (class 0 OID 0)
-- Dependencies: 355
-- Name: TABLE netmap; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE netmap IS 'netmap';


--
-- TOC entry 356 (class 1259 OID 2248210)
-- Dependencies: 4576 4577 5
-- Name: notificacao; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE notificacao (
    idnotificacao integer NOT NULL,
    titulo character varying(255) DEFAULT NULL::character varying,
    tiponotificacao character(1) DEFAULT NULL::bpchar,
    datainicio date,
    datafim date,
    origemnotificacao character(1) NOT NULL,
    idcontrato integer
);


--
-- TOC entry 357 (class 1259 OID 2248217)
-- Dependencies: 5
-- Name: notificacaogrupo; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE notificacaogrupo (
    idnotificacao integer,
    idgrupo integer
);


--
-- TOC entry 358 (class 1259 OID 2248232)
-- Dependencies: 5
-- Name: notificacaoservico; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE notificacaoservico (
    idnotificacao integer,
    idservico integer
);


--
-- TOC entry 359 (class 1259 OID 2248235)
-- Dependencies: 5
-- Name: notificacaousuario; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE notificacaousuario (
    idnotificacao integer,
    idusuario integer
);


--
-- TOC entry 360 (class 1259 OID 2248245)
-- Dependencies: 4578 4579 4580 4581 4582 5
-- Name: objetivomonitoramento; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE objetivomonitoramento (
    idobjetivomonitoramento integer NOT NULL,
    idobjetivoplanomelhoria integer NOT NULL,
    titulomonitoramento character varying(255) NOT NULL,
    fatorcriticosucesso character varying(255) DEFAULT NULL::character varying,
    kpi character varying(255) DEFAULT NULL::character varying,
    metrica text,
    medicao text,
    relatorios text,
    responsavel character varying(255) DEFAULT NULL::character varying,
    criadopor character varying(255) DEFAULT NULL::character varying,
    modificadopor character varying(255) DEFAULT NULL::character varying,
    datacriacao date,
    ultmodificacao date
);


--
-- TOC entry 361 (class 1259 OID 2248259)
-- Dependencies: 4583 4584 4585 4586 5
-- Name: objetivoplanomelhoria; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE objetivoplanomelhoria (
    idobjetivoplanomelhoria integer NOT NULL,
    idplanomelhoria integer NOT NULL,
    tituloobjetivo character varying(255) NOT NULL,
    detalhamento text,
    resultadoesperado text,
    medicao character varying(255) DEFAULT NULL::character varying,
    responsavel character varying(255) DEFAULT NULL::character varying,
    criadopor character varying(255) DEFAULT NULL::character varying,
    modificadopor character varying(255) DEFAULT NULL::character varying,
    datacriacao date,
    ultmodificacao date
);


--
-- TOC entry 362 (class 1259 OID 2248272)
-- Dependencies: 5
-- Name: objetonegocio; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE objetonegocio (
    idobjetonegocio bigint NOT NULL,
    nomeobjetonegocio character varying(500) NOT NULL,
    nometabeladb character varying(120) NOT NULL,
    situacao character(1) NOT NULL
);


--
-- TOC entry 363 (class 1259 OID 2248280)
-- Dependencies: 4587 4588 4589 4590 4591 5
-- Name: ocorrenciamudanca; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE ocorrenciamudanca (
    idocorrencia integer NOT NULL,
    iditemtrabalho bigint,
    idjustificativa integer,
    idrequisicaomudanca integer,
    dataregistro date,
    horaregistro character varying(5) DEFAULT NULL::character varying,
    registradopor character varying(100) DEFAULT NULL::character varying,
    descricao character varying(200) DEFAULT NULL::character varying,
    datainicio date,
    datafim date,
    complementojustificativa text,
    dadosmudanca text,
    informacoescontato text,
    categoria character varying(20) DEFAULT NULL::character varying,
    origem character(1) DEFAULT NULL::bpchar,
    tempogasto smallint,
    ocorrencia text,
    idcategoriaocorrencia integer,
    idorigemocorrencia integer
);


--
-- TOC entry 364 (class 1259 OID 2248306)
-- Dependencies: 5
-- Name: ocorrencias; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE ocorrencias (
    idocorrencia integer NOT NULL,
    iddemanda integer NOT NULL,
    ocorrencia text,
    tipoocorrencia character(1) NOT NULL,
    respostaocorrencia text,
    data date NOT NULL,
    idempregado integer
);


--
-- TOC entry 6464 (class 0 OID 0)
-- Dependencies: 364
-- Name: TABLE ocorrencias; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE ocorrencias IS 'ocorrencias';


--
-- TOC entry 365 (class 1259 OID 2248316)
-- Dependencies: 4592 4593 4594 4595 4596 5
-- Name: ocorrenciasolicitacao; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE ocorrenciasolicitacao (
    idocorrencia integer NOT NULL,
    idjustificativa integer,
    idsolicitacaoservico bigint,
    iditemtrabalho bigint,
    dataregistro date,
    horaregistro character varying(5) DEFAULT NULL::character varying,
    registradopor character varying(100) DEFAULT NULL::character varying,
    descricao character varying(500) DEFAULT NULL::character varying,
    datainicio date,
    datafim date,
    complementojustificativa text,
    dadossolicitacao text,
    informacoescontato text,
    categoria character varying(20) DEFAULT NULL::character varying,
    origem character(1) DEFAULT NULL::bpchar,
    tempogasto smallint,
    ocorrencia text,
    idcategoriaocorrencia integer,
    idorigemocorrencia integer
);


--
-- TOC entry 366 (class 1259 OID 2248349)
-- Dependencies: 4597 4598 4599 5
-- Name: opcaorespostaquestionario; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE opcaorespostaquestionario (
    idopcaorespostaquestionario integer NOT NULL,
    idquestaoquestionario integer NOT NULL,
    titulo character varying(255) NOT NULL,
    peso integer,
    valor character varying(50) DEFAULT NULL::character varying,
    geraalerta character(1) DEFAULT NULL::bpchar,
    exibecomplemento character(1) DEFAULT NULL::bpchar,
    idquestaocomplemento integer
);


--
-- TOC entry 6465 (class 0 OID 0)
-- Dependencies: 366
-- Name: TABLE opcaorespostaquestionario; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE opcaorespostaquestionario IS 'opcaorespostaquestionario';


--
-- TOC entry 367 (class 1259 OID 2248359)
-- Dependencies: 5
-- Name: opiniao_idopiniao_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE opiniao_idopiniao_seq
    START WITH 3
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 368 (class 1259 OID 2248361)
-- Dependencies: 4600 4601 4602 4603 5
-- Name: opiniao; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE opiniao (
    idopiniao integer DEFAULT nextval('opiniao_idopiniao_seq'::regclass) NOT NULL,
    idusuario integer,
    idsolicitacao integer,
    tipo character varying(50) DEFAULT NULL::character varying,
    observacoes character varying(250) DEFAULT NULL::character varying,
    data date,
    hora timestamp without time zone DEFAULT now() NOT NULL
);


--
-- TOC entry 369 (class 1259 OID 2248372)
-- Dependencies: 5
-- Name: origematendimento; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE origematendimento (
    idorigem bigint NOT NULL,
    descricao character varying(100) NOT NULL
);


--
-- TOC entry 370 (class 1259 OID 2248377)
-- Dependencies: 5
-- Name: origemocorrencia; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE origemocorrencia (
    idorigemocorrencia integer NOT NULL,
    nome character varying(256) NOT NULL,
    datainicio date NOT NULL,
    datafim date
);


--
-- TOC entry 371 (class 1259 OID 2248382)
-- Dependencies: 4604 4605 5
-- Name: os; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE os (
    idos integer NOT NULL,
    idcontrato integer NOT NULL,
    idclassificacaoos integer,
    idservicocontrato bigint,
    numero character varying(20) DEFAULT NULL::character varying,
    ano integer,
    datainicio date NOT NULL,
    datafim date NOT NULL,
    demanda text NOT NULL,
    objetivo text,
    situacaoos integer,
    nomearearequisitante character varying(150) DEFAULT NULL::character varying,
    obsfinalizacao text,
    quantidadeglosasanterior integer,
    quantidade integer,
    idospai integer
);


--
-- TOC entry 372 (class 1259 OID 2248394)
-- Dependencies: 5
-- Name: osatividadeperiodica; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE osatividadeperiodica (
    idatividadeperiodica integer,
    idos integer
);


--
-- TOC entry 373 (class 1259 OID 2248399)
-- Dependencies: 5
-- Name: pais; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE pais (
    idpais integer NOT NULL,
    nomepais character varying(200) NOT NULL
);


--
-- TOC entry 374 (class 1259 OID 2248404)
-- Dependencies: 5
-- Name: palavragemea; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE palavragemea (
    idpalavragemea integer NOT NULL,
    palavra character varying(256) NOT NULL,
    palavracorrespondente character varying(256) NOT NULL
);


--
-- TOC entry 375 (class 1259 OID 2248412)
-- Dependencies: 5
-- Name: parametrocorpore; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE parametrocorpore (
    idparametrocorpore integer NOT NULL,
    nomeparametrocorpore character varying(200) NOT NULL,
    valor character varying(200) NOT NULL,
    idempresa integer NOT NULL,
    datainicio date NOT NULL,
    datafim date,
    tipodado character varying(50)
);


--
-- TOC entry 6466 (class 0 OID 0)
-- Dependencies: 375
-- Name: TABLE parametrocorpore; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE parametrocorpore IS 'parametrocorpore';


--
-- TOC entry 376 (class 1259 OID 2248417)
-- Dependencies: 4606 4607 4608 5
-- Name: parametros; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE parametros (
    nomeparametro character varying(70) NOT NULL,
    idempresa integer NOT NULL,
    modulo character varying(200) DEFAULT NULL::character varying,
    valor character varying(200) DEFAULT NULL::character varying,
    detalhamento character varying(200) DEFAULT NULL::character varying
);


--
-- TOC entry 6467 (class 0 OID 0)
-- Dependencies: 376
-- Name: TABLE parametros; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE parametros IS 'parametros';


--
-- TOC entry 377 (class 1259 OID 2248427)
-- Dependencies: 5
-- Name: parametroscontrato; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE parametroscontrato (
    idcontrato integer NOT NULL,
    nomeparametro character varying(100) NOT NULL,
    valorparametro text
);


--
-- TOC entry 378 (class 1259 OID 2248435)
-- Dependencies: 4609 5
-- Name: parecer; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE parecer (
    idparecer integer NOT NULL,
    idjustificativa integer,
    idalcada integer,
    idresponsavel integer NOT NULL,
    datahoraparecer timestamp without time zone DEFAULT now() NOT NULL,
    complementojustificativa text,
    aprovado character(1) NOT NULL,
    observacoes text
);


--
-- TOC entry 379 (class 1259 OID 2248458)
-- Dependencies: 4610 4611 5
-- Name: pasta; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE pasta (
    idpasta integer NOT NULL,
    nome character varying(256) DEFAULT NULL::character varying,
    datainicio date,
    datafim date,
    idpastapai integer,
    idnotificacao integer,
    herdapermissoes character(1) DEFAULT NULL::bpchar
);


--
-- TOC entry 6468 (class 0 OID 0)
-- Dependencies: 379
-- Name: TABLE pasta; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE pasta IS 'pasta';


--
-- TOC entry 380 (class 1259 OID 2248466)
-- Dependencies: 4612 4613 4614 4615 4616 5
-- Name: pedidocompra; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE pedidocompra (
    idpedido integer NOT NULL,
    idempresa integer NOT NULL,
    idfornecedor bigint NOT NULL,
    datapedido date NOT NULL,
    dataprevistaentrega date,
    numeropedido character varying(25) NOT NULL,
    identificacaoentrega character varying(25) DEFAULT NULL::character varying,
    valorfrete numeric(8,2) DEFAULT NULL::numeric,
    valorseguro numeric(8,2) DEFAULT NULL::numeric,
    numeronf character varying(25) DEFAULT NULL::character varying,
    outrasdespesas numeric(8,2) DEFAULT NULL::numeric,
    situacao character varying(20) NOT NULL,
    idcotacao integer,
    idenderecoentrega integer,
    dataentrega date,
    observacoes text
);


--
-- TOC entry 381 (class 1259 OID 2248497)
-- Dependencies: 5
-- Name: perfilacesso; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE perfilacesso (
    idperfil integer NOT NULL,
    datainicio date NOT NULL,
    datafim date,
    nome character varying(256) NOT NULL,
    acessosistemacitsmart character(1)  DEFAULT 'S'::bpchar
);


--
-- TOC entry 6469 (class 0 OID 0)
-- Dependencies: 381
-- Name: TABLE perfilacesso; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE perfilacesso IS 'perfilacesso';


--
-- TOC entry 382 (class 1259 OID 2248502)
-- Dependencies: 5
-- Name: perfilacessogrupo; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE perfilacessogrupo (
    idperfil integer NOT NULL,
    idgrupo integer NOT NULL,
    datainicio date NOT NULL,
    datafim date
);


--
-- TOC entry 6470 (class 0 OID 0)
-- Dependencies: 382
-- Name: TABLE perfilacessogrupo; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE perfilacessogrupo IS 'perfilacessogrupo';


--
-- TOC entry 383 (class 1259 OID 2248508)
-- Dependencies: 5
-- Name: perfilacessomenu; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE perfilacessomenu (
    idperfilacesso integer,
    idmenu integer,
    pesquisa character(1) NOT NULL,
    grava character(1) NOT NULL,
    deleta character(1) NOT NULL,
    datainicio date NOT NULL,
    datafim date
);


--
-- TOC entry 6471 (class 0 OID 0)
-- Dependencies: 383
-- Name: TABLE perfilacessomenu; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE perfilacessomenu IS 'perfilacessomenu';


--
-- TOC entry 384 (class 1259 OID 2248514)
-- Dependencies: 4617 4618 4619 5
-- Name: perfilacessopasta; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE perfilacessopasta (
    idperfil integer NOT NULL,
    idpasta integer NOT NULL,
    datainicio date NOT NULL,
    datafim date,
    aprovabaseconhecimento character(1) DEFAULT NULL::bpchar,
    permiteleitura character(1) DEFAULT NULL::bpchar,
    permiteleituragravacao character(1) DEFAULT NULL::bpchar
);


--
-- TOC entry 6472 (class 0 OID 0)
-- Dependencies: 384
-- Name: TABLE perfilacessopasta; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE perfilacessopasta IS 'perfilacessopasta';


--
-- TOC entry 385 (class 1259 OID 2248523)
-- Dependencies: 5
-- Name: perfilacessosituacaofatura; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE perfilacessosituacaofatura (
    idperfil integer NOT NULL,
    situacaofatura character(1) NOT NULL,
    datainicio date NOT NULL,
    datafim date
);


--
-- TOC entry 386 (class 1259 OID 2248528)
-- Dependencies: 5
-- Name: perfilacessosituacaoos; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE perfilacessosituacaoos (
    idperfil integer NOT NULL,
    situacaoos integer NOT NULL,
    datainicio date NOT NULL,
    datafim date
);


--
-- TOC entry 387 (class 1259 OID 2248533)
-- Dependencies: 5
-- Name: perfilacessousuario; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE perfilacessousuario (
    datainicio date NOT NULL,
    idusuario integer NOT NULL,
    idperfil integer NOT NULL,
    datafim date
);


--
-- TOC entry 6473 (class 0 OID 0)
-- Dependencies: 387
-- Name: TABLE perfilacessousuario; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE perfilacessousuario IS 'perfilacessousuario';


--
-- TOC entry 388 (class 1259 OID 2248540)
-- Dependencies: 4620 5
-- Name: perfilseguranca; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE perfilseguranca (
    idperfilseguranca integer NOT NULL,
    nomeperfilseguranca character varying(15) NOT NULL,
    descperfilseguranca character varying(70) DEFAULT NULL::character varying
);


--
-- TOC entry 6474 (class 0 OID 0)
-- Dependencies: 388
-- Name: TABLE perfilseguranca; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE perfilseguranca IS 'perfilseguranca';


--
-- TOC entry 389 (class 1259 OID 2248546)
-- Dependencies: 4621 4622 4623 5
-- Name: permissoesfluxo; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE permissoesfluxo (
    idgrupo integer NOT NULL,
    idtipofluxo integer NOT NULL,
    criar character(1) NOT NULL,
    executar character(1) NOT NULL,
    delegar character(1) NOT NULL,
    suspender character(1) NOT NULL,
    reativar character(1) DEFAULT NULL::bpchar,
    alterarsla character(1) DEFAULT NULL::bpchar,
    reabrir character(1) DEFAULT NULL::bpchar
);


--
-- TOC entry 390 (class 1259 OID 2248555)
-- Dependencies: 5
-- Name: pesquisasatisfacao; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE pesquisasatisfacao (
    idpesquisasatisfacao integer NOT NULL,
    idsolicitacaoservico bigint NOT NULL,
    nota integer NOT NULL,
    comentario text
);


--
-- TOC entry 6475 (class 0 OID 0)
-- Dependencies: 390
-- Name: TABLE pesquisasatisfacao; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE pesquisasatisfacao IS 'latin1_swedish_ci';


--
-- TOC entry 391 (class 1259 OID 2248564)
-- Dependencies: 4624 4625 5
-- Name: pessoa; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE pessoa (
    tokenidentificacao character varying(20) NOT NULL,
    nome character varying(200) DEFAULT NULL::character varying,
    cpf character varying(20) DEFAULT NULL::character varying
);


--
-- TOC entry 392 (class 1259 OID 2248571)
-- Dependencies: 4626 4627 4628 5
-- Name: planomelhoria; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE planomelhoria (
    idplanomelhoria integer NOT NULL,
    idfornecedor integer,
    idcontrato integer,
    titulo character varying(100) NOT NULL,
    datainicio date NOT NULL,
    datafim date,
    objetivo text,
    visaogeral text,
    escopo text,
    visao text,
    missao text,
    datacriacao date,
    notas text,
    criadopor character varying(40) DEFAULT NULL::character varying,
    modificadopor character varying(40) DEFAULT NULL::character varying,
    ultmodificacao date,
    situacao character(1) DEFAULT NULL::bpchar
);


--
-- TOC entry 393 (class 1259 OID 2248584)
-- Dependencies: 4629 5
-- Name: portal; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE portal (
    idportal integer NOT NULL,
    iditem integer,
    posicaox double precision,
    posicaoy double precision,
    idusuario integer NOT NULL,
    largura double precision,
    altura double precision,
    data date,
    hora timestamp without time zone DEFAULT now() NOT NULL,
    coluna integer
);


--
-- TOC entry 394 (class 1259 OID 2248592)
-- Dependencies: 4630 4631 5
-- Name: post; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE post (
    idpost integer NOT NULL,
    titulo character varying(255) DEFAULT NULL::character varying,
    descricao text,
    conteudo text,
    imagem character varying(255) DEFAULT NULL::character varying,
    idcategoriapost integer,
    datainicio date,
    datafim date
);


--
-- TOC entry 395 (class 1259 OID 2248608)
-- Dependencies: 5
-- Name: prioridade; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE prioridade (
    idprioridade integer NOT NULL,
    idempresa integer,
    nomeprioridade character varying(100) NOT NULL,
    situacao character(1) NOT NULL,
    grupoprioridade character(3) NOT NULL
);


--
-- TOC entry 6476 (class 0 OID 0)
-- Dependencies: 395
-- Name: TABLE prioridade; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE prioridade IS 'prioridade';


--
-- TOC entry 396 (class 1259 OID 2248614)
-- Dependencies: 5
-- Name: prioridadeacordonivelservico; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE prioridadeacordonivelservico (
    idunidade integer NOT NULL,
    idacordonivelservico bigint NOT NULL,
    idprioridade bigint,
    datainicio date NOT NULL,
    datafim date
);


--
-- TOC entry 397 (class 1259 OID 2248619)
-- Dependencies: 5
-- Name: prioridadeservicounidade; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE prioridadeservicounidade (
    idunidade integer NOT NULL,
    idservicocontrato bigint NOT NULL,
    idprioridade bigint,
    datainicio date NOT NULL,
    datafim date
);


--
-- TOC entry 398 (class 1259 OID 2248626)
-- Dependencies: 4632 4633 4634 4635 4636 4637 4638 4639 4640 4641 4642 4643 4644 4645 4646 4647 5
-- Name: problema; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE problema (
    idproblema integer NOT NULL,
    status character varying(40) DEFAULT NULL::character varying,
    prioridade integer,
    idcriador integer,
    idproprietario integer,
    titulo character varying(255) DEFAULT NULL::character varying,
    descricao character varying(1000) DEFAULT NULL::character varying,
    idcategoriaproblema integer,
    impacto character varying(10) DEFAULT NULL::character varying,
    urgencia character varying(10) DEFAULT NULL::character varying,
    proativoreativo character varying(15) DEFAULT NULL::character varying,
    datahoralimitesolucionar date,
    msgerroassociada character varying(1000) DEFAULT NULL::character varying,
    idproblemaitemconfiguracao integer,
    idproblemamudanca integer,
    idproblemaincidente integer,
    datahorainicio date,
    datahorafim date,
    solucaodefinitiva character varying(4000) DEFAULT NULL::character varying,
    adicionarbdce character varying(1) DEFAULT NULL::character varying,
    statusbaseconhecimento character varying(1) DEFAULT NULL::character varying,
    idpastabaseconhecimento integer,
    causaraiz character varying(4000) DEFAULT NULL::character varying,
    solucaocontorno character varying(4000) DEFAULT NULL::character varying,
    idbaseconhecimento integer,
    severidade character varying(15) DEFAULT NULL::character varying,
    idgrupo integer,
    idservico integer,
    idcontrato integer,
    idservicocontrato integer,
    idprioridade integer,
    datahoralimite timestamp without time zone DEFAULT now(),
    datahorasolicitacao timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone,
    prazohh integer,
    prazomm integer,
    slaacombinar character(1) DEFAULT NULL::bpchar
);


--
-- TOC entry 399 (class 1259 OID 2248655)
-- Dependencies: 4648 5
-- Name: problemaitemconfiguracao; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE problemaitemconfiguracao (
    idproblemaitemconfiguracao integer NOT NULL,
    idproblema integer NOT NULL,
    iditemconfiguracao integer NOT NULL,
    descricaoproblema character varying(255) DEFAULT NULL::character varying
);


--
-- TOC entry 400 (class 1259 OID 2248663)
-- Dependencies: 5
-- Name: problemamudanca; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE problemamudanca (
    idproblemamudanca integer NOT NULL,
    idproblema integer NOT NULL,
    idrequisicaomudanca integer NOT NULL
);


--
-- TOC entry 401 (class 1259 OID 2248670)
-- Dependencies: 5
-- Name: procedimentotecnico; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE procedimentotecnico (
    idprocedimentotecnico integer NOT NULL,
    nomeprocedimentotecnico character varying(255) NOT NULL,
    textoprocedimentotecnico text,
    datainicio date NOT NULL,
    datafim date
);


--
-- TOC entry 6477 (class 0 OID 0)
-- Dependencies: 401
-- Name: TABLE procedimentotecnico; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE procedimentotecnico IS 'procedimentotecnico';


--
-- TOC entry 402 (class 1259 OID 2248678)
-- Dependencies: 4649 5
-- Name: processamentobatch; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE processamentobatch (
    idprocessamentobatch integer NOT NULL,
    descricao character varying(256) DEFAULT NULL::character varying,
    expressaocron character varying(40) NOT NULL,
    conteudo text,
    tipo character(1) NOT NULL,
    situacao character(1) NOT NULL
);


--
-- TOC entry 403 (class 1259 OID 2248687)
-- Dependencies: 4650 4651 4652 4653 5
-- Name: produto; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE produto (
    idproduto integer NOT NULL,
    idtipoproduto integer NOT NULL,
    idmarca integer,
    modelo character varying(25) DEFAULT NULL::character varying,
    precomercado numeric(8,2) DEFAULT NULL::numeric,
    detalhes text,
    codigoproduto character varying(25) DEFAULT NULL::character varying,
    situacao character(1) NOT NULL,
    complemento character varying(100) DEFAULT NULL::character varying
);


--
-- TOC entry 404 (class 1259 OID 2248706)
-- Dependencies: 4654 4655 4656 4657 4658 4659 4660 4661 4662 4663 4664 4665 4666 4667 4668 4669 4670 4671 4672 4673 4674 4675 4676 5
-- Name: programacaoatividade; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE programacaoatividade (
    idprogramacaoatividade integer NOT NULL,
    idatividadeperiodica integer NOT NULL,
    tipoagendamento character(1) NOT NULL,
    datainicio date NOT NULL,
    datafim date,
    duracaoestimada integer,
    periodicidadediaria integer,
    periodicidadesemanal integer,
    periodicidademensal integer,
    dia integer,
    diautil integer,
    diasemana integer,
    seqdiasemana integer,
    seg character(1) DEFAULT NULL::bpchar,
    ter character(1) DEFAULT NULL::bpchar,
    qua character(1) DEFAULT NULL::bpchar,
    qui character(1) DEFAULT NULL::bpchar,
    sex character(1) DEFAULT NULL::bpchar,
    sab character(1) DEFAULT NULL::bpchar,
    dom character(1) DEFAULT NULL::bpchar,
    jan character(1) DEFAULT NULL::bpchar,
    fev character(1) DEFAULT NULL::bpchar,
    mar character(1) DEFAULT NULL::bpchar,
    abr character(1) DEFAULT NULL::bpchar,
    mai character(1) DEFAULT NULL::bpchar,
    jun character(1) DEFAULT NULL::bpchar,
    jul character(1) DEFAULT NULL::bpchar,
    ago character(1) DEFAULT NULL::bpchar,
    setem character(1) DEFAULT NULL::bpchar,
    outub character(1) DEFAULT NULL::bpchar,
    nov character(1) DEFAULT NULL::bpchar,
    dez character(1) DEFAULT NULL::bpchar,
    repeticao character(1) DEFAULT NULL::bpchar,
    repeticaointervalo integer,
    repeticaotipointervalo character(1) DEFAULT NULL::bpchar,
    horainicio character(4) DEFAULT NULL::bpchar,
    horafim character(4) DEFAULT NULL::bpchar,
    idatividadesos integer
);


--
-- TOC entry 405 (class 1259 OID 2248734)
-- Dependencies: 5
-- Name: projetos; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE projetos (
    idprojeto integer NOT NULL,
    idcliente integer NOT NULL,
    idcontrato integer,
    nomeprojeto character varying(70) NOT NULL,
    detalhamento text,
    situacao character(1) NOT NULL,
    valorestimado numeric(18,3) NOT NULL
);


--
-- TOC entry 6478 (class 0 OID 0)
-- Dependencies: 405
-- Name: TABLE projetos; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE projetos IS 'projetos';


--
-- TOC entry 406 (class 1259 OID 2248744)
-- Dependencies: 4677 4678 4679 4680 4681 4682 4683 4684 4685 4686 4687 4688 4689 4690 4691 4692 4693 5
-- Name: questaoquestionario; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE questaoquestionario (
    idquestaoquestionario integer NOT NULL,
    idgrupoquestionario integer,
    idquestaoagrupadora integer,
    idquestaocompartilhada integer,
    idquestaoorigem integer,
    tipo character(1) NOT NULL,
    tituloquestaoquestionario text,
    tipoquestao character(1) NOT NULL,
    sexoquestao character(1) NOT NULL,
    sequenciaquestao integer NOT NULL,
    valordefault text,
    textoinicial text,
    tamanho integer,
    decimais integer,
    inforesposta character(1) DEFAULT NULL::bpchar,
    valoresreferencia text,
    unidade text,
    obrigatoria character(1) NOT NULL,
    ponderada character(1) DEFAULT NULL::bpchar,
    qtdelinhas integer,
    qtdecolunas integer,
    cabecalholinhas character(1) DEFAULT NULL::bpchar,
    cabecalhocolunas character(1) DEFAULT NULL::bpchar,
    nomelistagem character varying(30) DEFAULT NULL::character varying,
    ultimovalor character(1) DEFAULT NULL::bpchar,
    idsubquestionario integer,
    abaresultsubform character varying(200) DEFAULT NULL::character varying,
    sigla character varying(100) DEFAULT NULL::character varying,
    imprime character(1) DEFAULT NULL::bpchar,
    calculada character(1) DEFAULT NULL::bpchar,
    editavel character(1) DEFAULT NULL::bpchar,
    valorpermitido1 numeric(15,5) DEFAULT NULL::numeric,
    valorpermitido2 numeric(15,5) DEFAULT NULL::numeric,
    aplicavelcrianca character(1) DEFAULT NULL::bpchar,
    aplicavelidoso character(1) DEFAULT NULL::bpchar,
    aplicaveladulto character(1) DEFAULT NULL::bpchar,
    aplicaveladolescente character(1) DEFAULT NULL::bpchar,
    idimagem integer
);


--
-- TOC entry 6479 (class 0 OID 0)
-- Dependencies: 406
-- Name: TABLE questaoquestionario; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE questaoquestionario IS 'questaoquestionario';


--
-- TOC entry 407 (class 1259 OID 2248775)
-- Dependencies: 4694 5
-- Name: questionario; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE questionario (
    idquestionario integer NOT NULL,
    idquestionarioorigem integer,
    idcategoriaquestionario integer NOT NULL,
    nomequestionario character varying(50) NOT NULL,
    idempresa integer NOT NULL,
    ativo character(1) DEFAULT 'S'::bpchar
);


--
-- TOC entry 6480 (class 0 OID 0)
-- Dependencies: 407
-- Name: TABLE questionario; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE questionario IS 'questionario';


--
-- TOC entry 408 (class 1259 OID 2248783)
-- Dependencies: 4695 5
-- Name: reaberturasolicitacao; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE reaberturasolicitacao (
    idsolicitacaoservico bigint NOT NULL,
    seqreabertura integer NOT NULL,
    idresponsavel integer,
    datahora timestamp without time zone DEFAULT now() NOT NULL,
    observacoes text
);


--
-- TOC entry 409 (class 1259 OID 2248795)
-- Dependencies: 4696 4697 4698 4699 4700 4701 4702 4703 4704 4705 5
-- Name: recurso; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE recurso (
    idrecurso integer NOT NULL,
    idgruporecurso integer NOT NULL,
    idrecursopai integer,
    nomerecurso character varying(150) NOT NULL,
    datainicio date NOT NULL,
    datafim date,
    tipoatualizacao character(1) NOT NULL,
    deleted character(1) DEFAULT NULL::bpchar,
    idnagiosconexao integer,
    hostname character varying(255) DEFAULT NULL::character varying,
    servicename character varying(255) DEFAULT NULL::character varying,
    horainiciofunc character varying(5) DEFAULT NULL::character varying,
    horafimfunc character varying(5) DEFAULT NULL::character varying,
    idcalendario integer,
    statusaberturainc character varying(255) DEFAULT NULL::character varying,
    idsolicitante integer,
    emailaberturainc character varying(255) DEFAULT NULL::character varying,
    descricaoabertinc text,
    impacto character(1) DEFAULT NULL::bpchar,
    urgencia character(1) DEFAULT NULL::bpchar,
    idgrupo integer,
    idorigem bigint,
    idservicocontrato bigint,
    ideventomonitoramento integer,
    iditemconfiguracao integer,
    statusalerta character varying(255) DEFAULT NULL::character varying,
    emailsalerta text,
    descricaoalerta text
);


--
-- TOC entry 410 (class 1259 OID 2248868)
-- Dependencies: 5
-- Name: regioes; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE regioes (
    idregioes integer NOT NULL,
    nome character varying(45) NOT NULL
);


--
-- TOC entry 411 (class 1259 OID 2248875)
-- Dependencies: 4706 5
-- Name: registro; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE registro (
    idregistro integer NOT NULL,
    tokenidentificacao character varying(20) NOT NULL,
    datahora timestamp without time zone DEFAULT now() NOT NULL
);


--
-- TOC entry 412 (class 1259 OID 2248883)
-- Dependencies: 4707 5
-- Name: relacionamentoproduto; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE relacionamentoproduto (
    idtipoproduto integer NOT NULL,
    idtipoprodutorelacionado integer NOT NULL,
    tiporelacionamento character(1) DEFAULT NULL::bpchar
);


--
-- TOC entry 6481 (class 0 OID 0)
-- Dependencies: 412
-- Name: COLUMN relacionamentoproduto.tiporelacionamento; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN relacionamentoproduto.tiporelacionamento IS 'A - Acessório\n            S - Produto semelhante';


--
-- TOC entry 413 (class 1259 OID 2248890)
-- Dependencies: 5
-- Name: relacobjetonegocio; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE relacobjetonegocio (
    idrelacobjetonegocio bigint NOT NULL,
    idobjetonegociopai bigint NOT NULL,
    idobjetonegociofilho bigint NOT NULL,
    situacao character(1) NOT NULL
);


--
-- TOC entry 414 (class 1259 OID 2248897)
-- Dependencies: 4708 4709 4710 4711 4712 4713 4714 4715 4716 4717 4718 4719 4720 4721 4722 4723 4724 4725 5
-- Name: requisicaomudanca; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE requisicaomudanca (
    idrequisicaomudanca integer NOT NULL,
    idproprietario integer NOT NULL,
    idsolicitante integer NOT NULL,
    idtipomudanca integer,
    idgruponivel1 integer,
    idgrupoatual integer,
    idcalendario integer,
    motivo character varying(255) DEFAULT NULL::character varying,
    nivelimportancianegocio character varying(255) DEFAULT NULL::character varying,
    classificacao character varying(255) DEFAULT NULL::character varying,
    nivelimpacto character varying(255) DEFAULT NULL::character varying,
    analiseimpacto character varying(3000) DEFAULT NULL::character varying,
    datahoraconclusao timestamp without time zone,
    dataaceitacao date,
    datavotacao date,
    datahorainicio timestamp without time zone,
    datahoratermino timestamp without time zone,
    titulo character varying(255) DEFAULT NULL::character varying,
    descricao character varying(255) DEFAULT NULL::character varying,
    risco character varying(255) DEFAULT NULL::character varying,
    estimativacusto double precision,
    planoreversao character varying(3000) DEFAULT NULL::character varying,
    status character varying(45) DEFAULT NULL::character varying,
    prioridade integer,
    enviaemailcriacao character varying(1) DEFAULT NULL::character varying,
    enviaemailfinalizacao character varying(1) DEFAULT NULL::character varying,
    enviaemailacoes character varying(1) DEFAULT NULL::character varying,
    exibirquadromudancas character varying(1) DEFAULT NULL::character varying,
    seqreabertura smallint,
    datahoracaptura timestamp without time zone,
    datahorareativacao timestamp without time zone,
    datahorasuspensao timestamp without time zone,
    tempodecorridohh smallint,
    tempodecorridomm smallint,
    prazohh smallint,
    prazomm smallint,
    tempoatendimentohh smallint,
    tempoatendimentomm smallint,
    tempoatrasohh smallint,
    tempoatrasomm smallint,
    tempocapturahh smallint,
    tempocapturamm smallint,
    fase character varying(20) DEFAULT NULL::character varying,
    nivelurgencia character varying(255) DEFAULT NULL::character varying,
    idbaseconhecimento integer,
    nomecategoriamudanca character varying(15) DEFAULT NULL::character varying,
    idcontrato integer NOT NULL,
    idunidade integer,
    idcontatorequisicaomudanca integer,
    idgrupocomite integer,
    enviaemailgrupocomite character varying(1) DEFAULT NULL::character varying,
    datahorainicioagendada timestamp without time zone,
    datahoraterminoagendada timestamp without time zone,
    idlocalidade integer,
    fechamento text,
	tipo character varying(255) DEFAULT NULL::character varying
);


--
-- TOC entry 415 (class 1259 OID 2248954)
-- Dependencies: 4726 5
-- Name: requisicaomudancaitemconfiguracao; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE requisicaomudancaitemconfiguracao (
    idrequisicaomudancaitemconfiguracao integer NOT NULL,
    idrequisicaomudanca integer,
    iditemconfiguracao integer,
    descricao character varying(100) DEFAULT NULL::character varying
);


--
-- TOC entry 416 (class 1259 OID 2248972)
-- Dependencies: 5
-- Name: requisicaomudancaservico; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE requisicaomudancaservico (
    idrequisicaomudancaservico integer NOT NULL,
    idrequisicaomudanca integer NOT NULL,
    idservico bigint NOT NULL
);


--
-- TOC entry 417 (class 1259 OID 2248984)
-- Dependencies: 5
-- Name: requisicaoproduto; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE requisicaoproduto (
    idsolicitacaoservico integer NOT NULL,
    idprojeto integer,
    idcentrocusto integer,
    idenderecoentrega integer,
    finalidade character(1) NOT NULL,
    rejeitada character(1) NOT NULL
);


--
-- TOC entry 6482 (class 0 OID 0)
-- Dependencies: 417
-- Name: COLUMN requisicaoproduto.finalidade; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN requisicaoproduto.finalidade IS 'C - Atendimento ao cliente\n            I - Uso interno';


--
-- TOC entry 418 (class 1259 OID 2249007)
-- Dependencies: 4727 4728 4729 4730 4731 5
-- Name: requisitosla; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE requisitosla (
    idrequisitosla integer NOT NULL,
    idempregado integer,
    requisitadoem date,
    assunto character varying(200) NOT NULL,
    detalhamento text,
    situacao character(1) NOT NULL,
    criadopor character varying(255) DEFAULT NULL::character varying,
    criadoem timestamp without time zone DEFAULT now() NOT NULL,
    modificadopor character varying(255) DEFAULT NULL::character varying,
    modificadoem timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    deleted character(1) DEFAULT NULL::bpchar
);


--
-- TOC entry 419 (class 1259 OID 2249028)
-- Dependencies: 4732 5
-- Name: responsabilidade; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE responsabilidade (
    idresponsabilidade integer NOT NULL,
    idempregado integer,
    idcontrato integer NOT NULL,
    idcontatocliente integer,
    idservicocontrato integer,
    produtoatv character varying(400) NOT NULL,
    detalhamento text,
    participacao character varying(400) DEFAULT NULL::character varying
);


--
-- TOC entry 6483 (class 0 OID 0)
-- Dependencies: 419
-- Name: TABLE responsabilidade; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE responsabilidade IS 'responsabilidade';


--
-- TOC entry 420 (class 1259 OID 2249041)
-- Dependencies: 4733 4734 4735 4736 4737 4738 4739 4740 4741 4742 5
-- Name: respostaitemquestionario; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE respostaitemquestionario (
    idrespostaitemquestionario integer NOT NULL,
    ididentificadorresposta integer NOT NULL,
    idquestaoquestionario integer NOT NULL,
    sequencialresposta integer,
    respostatextual text,
    respostapercentual numeric(15,5) DEFAULT NULL::numeric,
    respostavalor numeric(15,5) DEFAULT NULL::numeric,
    respostavalor2 numeric(15,5) DEFAULT NULL::numeric,
    respostanumero numeric(13,0) DEFAULT NULL::numeric,
    respostanumero2 numeric(13,0) DEFAULT NULL::numeric,
    respostadata date,
    respostahora character varying(4) DEFAULT NULL::character varying,
    respostapressaosistolica smallint,
    respostapressaodiastolica smallint,
    respostames smallint,
    respostaano smallint,
    respostapeso numeric(15,5) DEFAULT NULL::numeric,
    respostaaltura numeric(15,5) DEFAULT NULL::numeric,
    respostaimc numeric(15,5) DEFAULT NULL::numeric,
    respostadum date,
    respostaciclomenstrual smallint,
    respostamediafaselutea smallint,
    respostadpp date,
    respostaidlistagem character varying(10) DEFAULT NULL::character varying,
    idatestado integer,
    respostadpppeladum date,
    respostadia smallint
);


--
-- TOC entry 6484 (class 0 OID 0)
-- Dependencies: 420
-- Name: TABLE respostaitemquestionario; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE respostaitemquestionario IS 'respostaitemquestionario';


--
-- TOC entry 421 (class 1259 OID 2249062)
-- Dependencies: 5
-- Name: respostaitemquestionarioanexos; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE respostaitemquestionarioanexos (
    idrespostaitmquestionarioanexo integer NOT NULL,
    idrespostaitemquestionario integer NOT NULL,
    caminhoanexo character varying(255) NOT NULL,
    observacao text
);


--
-- TOC entry 6485 (class 0 OID 0)
-- Dependencies: 421
-- Name: TABLE respostaitemquestionarioanexos; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE respostaitemquestionarioanexos IS 'respostaitemquestionarioanexos';


--
-- TOC entry 422 (class 1259 OID 2249071)
-- Dependencies: 5
-- Name: respostaitemquestionariocids; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE respostaitemquestionariocids (
    idrespostaitemquestionariocid integer NOT NULL,
    idrespostaitemquestionario integer NOT NULL,
    idcid integer NOT NULL
);


--
-- TOC entry 6486 (class 0 OID 0)
-- Dependencies: 422
-- Name: TABLE respostaitemquestionariocids; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE respostaitemquestionariocids IS 'respostaitemquestionariocids';


--
-- TOC entry 423 (class 1259 OID 2249078)
-- Dependencies: 5
-- Name: respostaitemquestionarioopcoes; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE respostaitemquestionarioopcoes (
    idrespostaitemquestionario integer NOT NULL,
    idopcaorespostaquestionario integer NOT NULL
);


--
-- TOC entry 6487 (class 0 OID 0)
-- Dependencies: 423
-- Name: TABLE respostaitemquestionarioopcoes; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE respostaitemquestionarioopcoes IS 'respostaitemquestionarioopcoes';


--
-- TOC entry 424 (class 1259 OID 2249084)
-- Dependencies: 4743 4744 4745 4746 4747 5
-- Name: resultadosesperados; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE resultadosesperados (
    idservicocontrato bigint NOT NULL,
    idacordonivelservico bigint NOT NULL,
    descricaoresultados character varying(1000) DEFAULT NULL::character varying,
    limites character varying(200) DEFAULT NULL::character varying,
    glosa character varying(200) DEFAULT NULL::character varying,
    limiteglosa character varying(200) DEFAULT NULL::character varying,
    deleted character(1) DEFAULT NULL::bpchar
);


--
-- TOC entry 425 (class 1259 OID 2249095)
-- Dependencies: 4748 4749 5
-- Name: revisarsla; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE revisarsla (
    idrevisarsla bigint NOT NULL,
    idacordonivelservico bigint NOT NULL,
    datarevisao date NOT NULL,
    detalherevisao text,
    observacao character varying(200) DEFAULT NULL::character varying,
    deleted character(1) DEFAULT NULL::bpchar
);

--
-- TOC entry 426 (class 1259 OID 2249105)
-- Dependencies: 4750 4751 5
-- Name: scripts; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE scripts (
    descricao text,
    datafim date,
    datainicio date NOT NULL,
    historico text,
    idscript integer NOT NULL,
    nome character varying(255) DEFAULT NULL::character varying,
    sqlquery text,
    tipo character(10) DEFAULT NULL::bpchar,
    idversao integer
);


--
-- TOC entry 427 (class 1259 OID 2249115)
-- Dependencies: 4752 5
-- Name: scriptsvisao; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE scriptsvisao (
    idscriptsvisao bigint NOT NULL,
    idvisao bigint NOT NULL,
    typeexecute character(1) NOT NULL,
    scrypttype character(30) NOT NULL,
    script text,
    scriptlanguage character varying(30) DEFAULT NULL::character varying
);


--
-- TOC entry 428 (class 1259 OID 2249125)
-- Dependencies: 5
-- Name: servcontratocatalogoserv; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE SEQUENCE sequence_block_controller_seq
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
  
  
CREATE TABLE sequence_block_controller (
  id bigint NOT NULL DEFAULT nextval('sequence_block_controller_seq'::regclass),
  sequence_name character varying(80) NOT NULL,
  last_id bigint NOT NULL,
  CONSTRAINT sequence_block_controller_pkey PRIMARY KEY (id),
  CONSTRAINT sequence_block_controller_key UNIQUE (sequence_name)
);


CREATE INDEX sequence_block_controller_idx ON sequence_block_controller USING btree (sequence_name);


CREATE TABLE servcontratocatalogoserv (
    idservicocontrato bigint,
    idcatalogoservico integer
);


--
-- TOC entry 429 (class 1259 OID 2249135)
-- Dependencies: 4753 4754 4755 4756 4757 4758 5
-- Name: servico; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE servico (
    idservico bigint NOT NULL,
    idcategoriaservico integer NOT NULL,
    idsituacaoservico integer NOT NULL,
    idtiposervico integer,
    idimportancianegocio integer,
    idempresa bigint NOT NULL,
    idtipoeventoservico integer,
    idtipodemandaservico integer,
    idlocalexecucaoservico integer,
    nomeservico character varying(500) NOT NULL,
    detalheservico text,
    objetivo text,
    passosservico text,
    datainicio date,
    linkprocesso character varying(500) DEFAULT NULL::character varying,
    descricaoprocesso text,
    tipodescprocess character(1) DEFAULT NULL::bpchar,
    dispportal character(1) DEFAULT NULL::bpchar,
    quadroorientportal text,
    deleted character(1) DEFAULT NULL::bpchar,
    detalhesservico character varying(255) DEFAULT NULL::character varying,
    siglaabrev character varying(150) DEFAULT NULL::character varying,
    idbaseconhecimento integer,
    idtemplatesolicitacao integer,
    idtemplateacompanhamento integer
);


--
-- TOC entry 430 (class 1259 OID 2249161)
-- Dependencies: 4759 4760 4761 4762 4763 4764 4765 4766 4767 4768 5
-- Name: servico_hist; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE servico_hist (
    idhistoricoservico bigint NOT NULL,
    idservico bigint NOT NULL,
    idcategoriaservico integer NOT NULL,
    idsituacaoservico integer NOT NULL,
    idtiposervico integer,
    idimportancianegocio integer,
    idempresa bigint NOT NULL,
    idtipoeventoservico integer,
    idtipodemandaservico integer,
    idlocalexecucaoservico integer,
    nomeservico character varying(500) NOT NULL,
    detalheservico text,
    objetivo text,
    passosservico text,
    datainicio date,
    linkprocesso character varying(500) DEFAULT NULL::character varying,
    descricaoprocesso text,
    tipodescprocess character(1) DEFAULT NULL::bpchar,
    dispportal character(1) DEFAULT NULL::bpchar,
    quadroorientportal text,
    deleted character(1) DEFAULT NULL::bpchar,
    detalhesservico character varying(255) DEFAULT NULL::character varying,
    siglaabrev character varying(150) DEFAULT NULL::character varying,
    idbaseconhecimento integer,
    idtemplatesolicitacao integer,
    idtemplateacompanhamento integer,
    criadoem timestamp without time zone DEFAULT now() NOT NULL,
    criadopor character varying(255) DEFAULT NULL::character varying,
    modificadoem timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    modificadopor character varying(255) DEFAULT NULL::character varying,
    conteudodados text
);


--
-- TOC entry 431 (class 1259 OID 2249181)
-- Dependencies: 4769 4770 4771 4772 4773 4774 4775 4776 4777 5
-- Name: servicocontrato; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE servicocontrato (
    idservicocontrato bigint NOT NULL,
    idservico bigint NOT NULL,
    idcontrato integer NOT NULL,
    idcondicaooperacao integer,
    datainicio date NOT NULL,
    datafim date,
    observacao text,
    custo numeric(18,3) DEFAULT NULL::numeric,
    restricoespressup text,
    objetivo text,
    permiteslanocadinc character(1) DEFAULT NULL::bpchar,
    linkprocesso character varying(500) DEFAULT NULL::character varying,
    descricaoprocesso text,
    tipodescprocess character(1) DEFAULT NULL::bpchar,
    deleted character(1) DEFAULT NULL::bpchar,
    arearequisitante character varying(150) DEFAULT NULL::character varying,
    idgruponivel1 integer,
    idmodeloemailcriacao integer,
    idmodeloemailfinalizacao integer,
    idmodeloemailacoes integer,
    idgrupoexecutor integer,
    idcalendario integer,
    permslatempoacombinar character(1) DEFAULT NULL::bpchar,
    permmudancasla character(1) DEFAULT NULL::bpchar,
    permmudancacalendario character(1) DEFAULT NULL::bpchar,
    idgrupoaprovador integer
);


--
-- TOC entry 432 (class 1259 OID 2249207)
-- Dependencies: 5
-- Name: servicos_idservico_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE servicos_idservico_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 433 (class 1259 OID 2249209)
-- Dependencies: 4778 4779 4780 4781 4782 4783 4784 4785 4786 4787 4788 4789 5
-- Name: servicos; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE servicos (
    idservico integer DEFAULT nextval('servicos_idservico_seq'::regclass) NOT NULL,
    nomeservico character varying(255) DEFAULT NULL::character varying,
    detalhesservico character varying(255) DEFAULT NULL::character varying,
    objetivo character varying(255) DEFAULT NULL::character varying,
    passosservico character varying(255) DEFAULT NULL::character varying,
    datainicio character varying(255) DEFAULT NULL::character varying,
    linkprocesso character varying(255) DEFAULT NULL::character varying,
    descricaoprocesso character varying(255) DEFAULT NULL::character varying,
    tipodescprocess character varying(255) DEFAULT NULL::character varying,
    dispportal character varying(255) DEFAULT NULL::character varying,
    quadroorientportal character varying(255) DEFAULT NULL::character varying,
    deleted character varying(255) DEFAULT NULL::character varying
);


--
-- TOC entry 434 (class 1259 OID 2249229)
-- Dependencies: 4790 5
-- Name: sistemaoperacional; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE sistemaoperacional (
    id integer NOT NULL,
    nome character varying(255) DEFAULT NULL::character varying
);


--
-- TOC entry 6488 (class 0 OID 0)
-- Dependencies: 434
-- Name: TABLE sistemaoperacional; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE sistemaoperacional IS 'sistemaoperacional';


--
-- TOC entry 435 (class 1259 OID 2249235)
-- Dependencies: 5
-- Name: situacaodemanda; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE situacaodemanda (
    idsituacaodemanda integer NOT NULL,
    nomesituacao character varying(40) NOT NULL
);


--
-- TOC entry 6489 (class 0 OID 0)
-- Dependencies: 435
-- Name: TABLE situacaodemanda; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE situacaodemanda IS 'situacaodemanda';


--
-- TOC entry 436 (class 1259 OID 2249240)
-- Dependencies: 5
-- Name: situacaoservico; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE situacaoservico (
    idsituacaoservico integer NOT NULL,
    idempresa integer NOT NULL,
    nomesituacaoservico character varying(100) NOT NULL,
    datainicio date,
    datafim date
);


--
-- TOC entry 6490 (class 0 OID 0)
-- Dependencies: 436
-- Name: TABLE situacaoservico; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE situacaoservico IS 'situacaoservico';


--
-- TOC entry 437 (class 1259 OID 2249246)
-- Dependencies: 4791 4792 4793 5
-- Name: slarequisitosla; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE slarequisitosla (
    idrequisitosla integer NOT NULL,
    idacordonivelservico bigint NOT NULL,
    datavinculacao timestamp without time zone DEFAULT now() NOT NULL,
    dataultmodificacao timestamp without time zone DEFAULT  now() NOT NULL,
    deleted character(1) DEFAULT NULL::bpchar
);


--
-- TOC entry 438 (class 1259 OID 2249267)
-- Dependencies: 4794 4795 4796 4797 4798 4799 4800 4801 4802 4803 4804 4805 5
-- Name: solicitacaoservico; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE solicitacaoservico (
    idsolicitacaoservico bigint NOT NULL,
    idfaseatual bigint,
    idtipoproblema bigint,
    idgrupoatual integer,
    idprioridade bigint,
    idorigem bigint,
    idresponsavel integer,
    idsolicitante integer,
    atendimentopresencial character(1) DEFAULT NULL::bpchar,
    datahorasolicitacao timestamp without time zone DEFAULT now() NOT NULL,
    datahoralimite timestamp without time zone,
    prazohh smallint,
    prazomm smallint,
    descricao text NOT NULL,
    resposta text,
    datahorainicio timestamp without time zone,
    datahorafim timestamp without time zone,
    situacao character varying(20) NOT NULL,
    deleted character(1) DEFAULT NULL::bpchar,
    idcontatosolicitacaoservico integer,
    idservicocontrato bigint,
    idunidade integer,
    idcausaincidente integer,
    idcategoriasolucao integer,
    idtipodemandaservico integer,
    iditemconfiguracao integer,
    iditemconfiguracaofilho integer,
    idsolicitacaopai integer,
    detalhamentocausa____ text,
    seqreabertura integer,
    detalhamentocausa text,
    enviaemailcriacao character(1) DEFAULT NULL::bpchar,
    enviaemailfinalizacao character(1) DEFAULT NULL::bpchar,
    enviaemailacoes character(1) DEFAULT NULL::bpchar,
    idgruponivel1 integer,
    solucaotemporaria character(1) DEFAULT NULL::bpchar,
    idsolicitacaoservicoorigem bigint,
    idcalendario integer,
    houvemudanca character(1) DEFAULT NULL::bpchar,
    slaacombinar character(1) DEFAULT NULL::bpchar,
    prazohhanterior smallint,
    prazommanterior smallint,
    tempodecorridohh smallint,
    tempodecorridomm smallint,
    datahorasuspensao timestamp without time zone,
    datahorareativacao timestamp without time zone,
    impacto character(1) DEFAULT NULL::bpchar,
    urgencia character(1) DEFAULT NULL::bpchar,
    tempocapturahh smallint,
    tempocapturamm smallint,
    tempoatrasohh smallint,
    tempoatrasomm smallint,
    tempoatendimentohh smallint,
    tempoatendimentomm smallint,
    datahoracaptura timestamp without time zone,
    idbaseconhecimento integer,
    idacordonivelservico integer,
    idsolicitacaorelacionada integer,
    descricaosemformatacao text,
    datahorainiciosla timestamp without time zone,
    idultimaaprovacao integer,
    situacaosla character(1) DEFAULT NULL::bpchar,
    datahorasuspensaosla timestamp without time zone,
    datahorareativacaosla timestamp without time zone,
    prazocapturahh integer,
    prazocapturamm integer
);


--
-- TOC entry 439 (class 1259 OID 2249316)
-- Dependencies: 4806 4807 5
-- Name: solicitacaoservicoevtmon; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE solicitacaoservicoevtmon (
    idsolicitacaoservico bigint NOT NULL,
    ideventomonitoramento integer NOT NULL,
    idrecurso integer,
    nomehost character varying(255) DEFAULT NULL::character varying,
    nomeservice character varying(255) DEFAULT NULL::character varying,
    infoadd text
);


--
-- TOC entry 440 (class 1259 OID 2249343)
-- Dependencies: 5
-- Name: solicitacaoservicomudanca; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE solicitacaoservicomudanca (
    idrequisicaomudanca integer,
    idsolicitacaoservico bigint
);


--
-- TOC entry 441 (class 1259 OID 2249358)
-- Dependencies: 5
-- Name: solicitacaoservicoproblema; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE solicitacaoservicoproblema (
    idproblema integer,
    idsolicitacaoservico integer
);


--
-- TOC entry 442 (class 1259 OID 2249362)
-- Dependencies: 4808 4809 5
-- Name: tabfederacaodados; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE tabfederacaodados (
    nometabela character varying(255) NOT NULL,
    chavefinal character varying(255) NOT NULL,
    chaveoriginal character varying(255) NOT NULL,
    origem character varying(255) NOT NULL,
    criacao timestamp without time zone DEFAULT now() NOT NULL,
    ultatualiz timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL
);


--
-- TOC entry 443 (class 1259 OID 2249375)
-- Dependencies: 4810 4811 4812 4813 4814 4815 4816 4817 4818 4819 5
-- Name: templatesolicitacaoservico; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE templatesolicitacaoservico (
    idtemplate integer NOT NULL,
    identificacao character varying(40) NOT NULL,
    nometemplate character varying(200) NOT NULL,
    nomeclassedto character varying(255) NOT NULL,
    nomeclasseaction character varying(255) NOT NULL,
    nomeclasseservico character varying(255) NOT NULL,
    urlrecuperacao character varying(255) NOT NULL,
    scriptaposrecuperacao text,
    habilitadirecionamento character(1) DEFAULT NULL::bpchar,
    habilitasituacao character(1) DEFAULT NULL::bpchar,
    habilitasolucao character(1) DEFAULT NULL::bpchar,
    alturadiv integer,
    habilitaurgenciaimpacto character(1) DEFAULT NULL::bpchar,
    habilitanotificacaoemail character(1) DEFAULT NULL::bpchar,
    habilitaproblema character(1) DEFAULT NULL::bpchar,
    habilitamudanca character(1) DEFAULT NULL::bpchar,
    habilitaitemconfiguracao character(1) DEFAULT NULL::bpchar,
    habilitasolicitacaorelacionada character(1) DEFAULT NULL::bpchar,
    habilitagravarecontinuar character(1) DEFAULT NULL::bpchar
);


--
-- TOC entry 444 (class 1259 OID 2249393)
-- Dependencies: 5
-- Name: tempoacordonivelservico; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE tempoacordonivelservico (
    idacordonivelservico bigint NOT NULL,
    idprioridade bigint NOT NULL,
    idfase bigint NOT NULL,
    tempohh integer NOT NULL,
    tempomm integer NOT NULL
);


--
-- TOC entry 445 (class 1259 OID 2249399)
-- Dependencies: 4820 5
-- Name: timers; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE timers (
    timerid character varying(80) NOT NULL,
    targetid character varying(250) NOT NULL,
    initialdate timestamp without time zone DEFAULT now() NOT NULL,
    timerinterval bigint,
    instancepk text,
    info text
);


--
-- TOC entry 446 (class 1259 OID 2249410)
-- Dependencies: 5
-- Name: timesheet; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE timesheet (
    idtimesheet integer NOT NULL,
    iddemanda integer,
    idempregado integer NOT NULL,
    idprojeto integer,
    qtdehoras numeric(18,3) NOT NULL,
    data date NOT NULL,
    custoporhora numeric(18,3) NOT NULL,
    detalhamento text
);


--
-- TOC entry 6491 (class 0 OID 0)
-- Dependencies: 446
-- Name: TABLE timesheet; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE timesheet IS 'timesheet';


--
-- TOC entry 447 (class 1259 OID 2249421)
-- Dependencies: 5
-- Name: tipocomplexidade; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE tipocomplexidade (
    complexidade character(1) NOT NULL,
    desctipocomplexidade character varying(50) NOT NULL
);


--
-- TOC entry 448 (class 1259 OID 2249426)
-- Dependencies: 5
-- Name: tipodemanda; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE tipodemanda (
    idtipodemanda integer NOT NULL,
    nometipodemanda character varying(40) NOT NULL
);


--
-- TOC entry 6492 (class 0 OID 0)
-- Dependencies: 448
-- Name: TABLE tipodemanda; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tipodemanda IS 'tipodemanda';


--
-- TOC entry 449 (class 1259 OID 2249431)
-- Dependencies: 4821 4822 5
-- Name: tipodemandaservico; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE tipodemandaservico (
    idtipodemandaservico integer NOT NULL,
    nometipodemandaservico character varying(70) NOT NULL,
    classificacao character(1) DEFAULT NULL::bpchar,
    deleted character(1) DEFAULT NULL::bpchar
);


--
-- TOC entry 450 (class 1259 OID 2249438)
-- Dependencies: 4823 5
-- Name: tipoeventoservico; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE tipoeventoservico (
    idtipoeventoservico integer NOT NULL,
    nometipoeventoservico character varying(70) NOT NULL,
    deleted character(1) DEFAULT NULL::bpchar
);


--
-- TOC entry 451 (class 1259 OID 2249444)
-- Dependencies: 4824 5
-- Name: tipoitemcfgcaracteristica; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE tipoitemcfgcaracteristica (
    id integer NOT NULL,
    idtipoitemconfiguracao integer NOT NULL,
    idcaracteristica integer NOT NULL,
    datainicio date,
    datafim date,
    nameinfoagente character varying(255) DEFAULT NULL::character varying
);


--
-- TOC entry 6493 (class 0 OID 0)
-- Dependencies: 451
-- Name: TABLE tipoitemcfgcaracteristica; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tipoitemcfgcaracteristica IS 'tipoitemcfgcaracteristica';


--
-- TOC entry 452 (class 1259 OID 2249453)
-- Dependencies: 4825 4826 5
-- Name: tipoitemconfiguracao; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE tipoitemconfiguracao (
    idtipoitemconfiguracao integer NOT NULL,
    idempresa integer NOT NULL,
    nometipoitemconfiguracao character varying(255) NOT NULL,
    tagtipoitemconfiguracao character varying(50) DEFAULT NULL::character varying,
    datainicio date NOT NULL,
    datafim date,
    sistema character(1) DEFAULT NULL::bpchar,
    categoria integer
);


--
-- TOC entry 6494 (class 0 OID 0)
-- Dependencies: 452
-- Name: TABLE tipoitemconfiguracao; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tipoitemconfiguracao IS 'tipoitemconfiguracao';


--
-- TOC entry 453 (class 1259 OID 2249461)
-- Dependencies: 4827 5
-- Name: tipomudanca; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE tipomudanca (
    idtipomudanca integer NOT NULL,
    idtipofluxo integer,
    idmodeloemailcriacao integer,
    idmodeloemailfinalizacao integer,
    idmodeloemailacoes integer,
    idgrupoexecutor integer,
    idcalendario integer,
    nometipomudanca character varying(100) DEFAULT NULL::character varying,
    datainicio date,
    datafim date
);


--
-- TOC entry 454 (class 1259 OID 2249503)
-- Dependencies: 5
-- Name: tipoos; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE tipoos (
    idclassificacaoos integer NOT NULL,
    idcontrato integer,
    descricao character varying(150) NOT NULL,
    detalhamento text
);


--
-- TOC entry 6495 (class 0 OID 0)
-- Dependencies: 454
-- Name: TABLE tipoos; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tipoos IS 'tipoos';


--
-- TOC entry 455 (class 1259 OID 2249512)
-- Dependencies: 5
-- Name: tipoproblemaatendimento; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE tipoproblemaatendimento (
    idtipoproblema bigint NOT NULL,
    idtipoproblemapai bigint,
    descricaoproblema text NOT NULL,
    situacao character(1) NOT NULL
);


--
-- TOC entry 456 (class 1259 OID 2249520)
-- Dependencies: 5
-- Name: tipoproduto; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE tipoproduto (
    idtipoproduto integer NOT NULL,
    idcategoria integer,
    idunidademedida integer,
    nomeproduto character varying(100) NOT NULL,
    situacao character(1) NOT NULL,
    aceitarequisicao character(1) NOT NULL
);


--
-- TOC entry 457 (class 1259 OID 2249532)
-- Dependencies: 5
-- Name: tiposatividades; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE tiposatividades (
    idtipoatividade integer NOT NULL,
    descricaotipoatividade character varying(50) NOT NULL
);


--
-- TOC entry 6496 (class 0 OID 0)
-- Dependencies: 457
-- Name: TABLE tiposatividades; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tiposatividades IS 'tiposatividades';


--
-- TOC entry 458 (class 1259 OID 2249537)
-- Dependencies: 5
-- Name: tiposervico; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE tiposervico (
    idtiposervico integer NOT NULL,
    idempresa integer NOT NULL,
    nometiposervico character varying(300) NOT NULL,
    situacao character(1) NOT NULL
);


--
-- TOC entry 6497 (class 0 OID 0)
-- Dependencies: 458
-- Name: TABLE tiposervico; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tiposervico IS 'tiposervico';


--
-- TOC entry 459 (class 1259 OID 2249543)
-- Dependencies: 4828 5
-- Name: tiposoftware; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE tiposoftware (
    idtiposoftware integer NOT NULL,
    nome character varying(200) DEFAULT NULL::character varying
);


--
-- TOC entry 460 (class 1259 OID 2249549)
-- Dependencies: 5
-- Name: tipounidade; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE tipounidade (
    idtipounidade integer NOT NULL,
    idempresa integer NOT NULL,
    nometipounidade character varying(80) NOT NULL,
    datainicio date,
    datafim date
);


--
-- TOC entry 6498 (class 0 OID 0)
-- Dependencies: 460
-- Name: TABLE tipounidade; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tipounidade IS 'tipounidade';


--
-- TOC entry 461 (class 1259 OID 2249555)
-- Dependencies: 4829 5
-- Name: ufs; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE ufs (
    iduf integer NOT NULL,
    nomeuf character varying(50) NOT NULL,
    siglauf character varying(2) NOT NULL,
    idregioes character varying(45) DEFAULT NULL::character varying,
    idpais integer
);


--
-- TOC entry 6499 (class 0 OID 0)
-- Dependencies: 461
-- Name: TABLE ufs; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE ufs IS 'ufs';


--
-- TOC entry 462 (class 1259 OID 2249568)
-- Dependencies: 4830 4831 5
-- Name: unidade; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE unidade (
    idunidade integer NOT NULL,
    idunidadepai integer,
    idtipounidade integer,
    idempresa integer NOT NULL,
    nome character varying(255) NOT NULL,
    datainicio date NOT NULL,
    datafim date,
    descricao text,
    email character varying(40) DEFAULT NULL::character varying,
    idendereco integer,
    aceitaentregaproduto character(1) DEFAULT NULL::bpchar
);


--
-- TOC entry 6500 (class 0 OID 0)
-- Dependencies: 462
-- Name: TABLE unidade; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE unidade IS 'unidade';


--
-- TOC entry 463 (class 1259 OID 2249587)
-- Dependencies: 5
-- Name: unidadebaseitemconfiguracao; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE unidadebaseitemconfiguracao (
    idbaseitemconfiguracao integer NOT NULL,
    idunidade integer
);


--
-- TOC entry 6501 (class 0 OID 0)
-- Dependencies: 463
-- Name: TABLE unidadebaseitemconfiguracao; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE unidadebaseitemconfiguracao IS 'unidadebaseitemconfiguracao';


--
-- TOC entry 464 (class 1259 OID 2249593)
-- Dependencies: 5
-- Name: unidademedida; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE unidademedida (
    idunidademedida integer NOT NULL,
    nomeunidademedida character varying(100) NOT NULL,
    siglaunidademedida character varying(10) NOT NULL,
    situacao character(1) NOT NULL
);


--
-- TOC entry 465 (class 1259 OID 2249598)
-- Dependencies: 5
-- Name: unidadesaccservicos; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE unidadesaccservicos (
    idunidade integer NOT NULL,
    idservico bigint NOT NULL
);


--
-- TOC entry 466 (class 1259 OID 2249604)
-- Dependencies: 4832 5
-- Name: urgencia; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE urgencia (
    idurgencia integer NOT NULL,
    nivelurgencia character varying(100) NOT NULL,
    siglaurgencia character(2) DEFAULT NULL::bpchar
);


--
-- TOC entry 467 (class 1259 OID 2249610)
-- Dependencies: 4833 4834 4835 4836 4837 5
-- Name: usuario; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE usuario (
    idusuario integer NOT NULL,
    idunidade integer,
    idempregado integer NOT NULL,
    idempresa integer NOT NULL,
    login character varying(256) DEFAULT NULL::character varying,
    nome character varying(256) DEFAULT NULL::character varying,
    senha character varying(300) DEFAULT NULL::character varying,
    status character(1) DEFAULT NULL::bpchar,
    ldap character(1) DEFAULT NULL::bpchar,
    ultimoacessoportal date
);


--
-- TOC entry 6502 (class 0 OID 0)
-- Dependencies: 467
-- Name: TABLE usuario; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE usuario IS 'usuario';


--
-- TOC entry 468 (class 1259 OID 2249626)
-- Dependencies: 5
-- Name: usuarioitemconfiguracao; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE usuarioitemconfiguracao (
    idusuario integer NOT NULL,
    iditemconfiguracao integer NOT NULL,
    datainicio date NOT NULL,
    datafim date
);


--
-- TOC entry 6503 (class 0 OID 0)
-- Dependencies: 468
-- Name: TABLE usuarioitemconfiguracao; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE usuarioitemconfiguracao IS 'usuarioitemconfiguracao';


--
-- TOC entry 469 (class 1259 OID 2249632)
-- Dependencies: 4838 4839 5
-- Name: valor; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE valor (
    idvalor integer NOT NULL,
    iditemconfiguracao integer,
    idcaracteristica integer,
    valorstr character varying(4000) DEFAULT NULL::character varying,
    valorlongo text,
    valordecimal numeric(18,4) DEFAULT NULL::numeric,
    valordate date,
    idbaseitemconfiguracao integer
);


--
-- TOC entry 6504 (class 0 OID 0)
-- Dependencies: 469
-- Name: TABLE valor; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE valor IS 'valor';


--
-- TOC entry 470 (class 1259 OID 2249646)
-- Dependencies: 4840 4841 5
-- Name: valorajusteglosa; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE valorajusteglosa (
    idservicocontrato bigint NOT NULL,
    idacordonivelservico bigint NOT NULL,
    quantidadefalhas integer,
    valorajuste numeric(10,2) DEFAULT NULL::numeric,
    deleted character(1) DEFAULT NULL::bpchar
);


--
-- TOC entry 471 (class 1259 OID 2249651)
-- Dependencies: 4842 5
-- Name: valorservicocontrato; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE valorservicocontrato (
    idservicocontrato bigint,
    idservico integer,
    valorservico numeric(10,2) DEFAULT NULL::numeric,
    datainicio date,
    datafim date,
    idvalorservicocontrato integer NOT NULL
);


--
-- TOC entry 472 (class 1259 OID 2249663)
-- Dependencies: 5
-- Name: valorvisaocamposnegocio; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE valorvisaocamposnegocio (
    idvalorvisaocamposnegocio bigint NOT NULL,
    idgrupovisao bigint NOT NULL,
    idcamposobjetonegocio bigint NOT NULL,
    valor character varying(500) NOT NULL,
    situacao character(1) NOT NULL,
    descricao character varying(500) NOT NULL
);


--
-- TOC entry 473 (class 1259 OID 2249672)
-- Dependencies: 5
-- Name: versao; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE versao (
    idversao integer NOT NULL,
    nomeversao character varying(100) NOT NULL,
    idusuario integer
);


--
-- TOC entry 474 (class 1259 OID 2249679)
-- Dependencies: 5
-- Name: vinculaosincidente; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE vinculaosincidente (
    idos integer NOT NULL,
    idsolicitacaoservico bigint NOT NULL,
    idatividadesos bigint NOT NULL
);


--
-- TOC entry 475 (class 1259 OID 2249684)
-- Dependencies: 5
-- Name: vinculovisao; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE vinculovisao (
    idvisaorelacionada bigint NOT NULL,
    seq integer NOT NULL,
    tipovinculo character(1) NOT NULL,
    idgrupovisaopai bigint,
    idcamposobjetonegociopai bigint,
    idgrupovisaofilho bigint,
    idcamposobjetonegociofilho bigint,
    idcamposobjetonegociopainn bigint,
    idcamposobjetonegociofilhonn bigint
);


--
-- TOC entry 476 (class 1259 OID 2249692)
-- Dependencies: 4843 4844 5
-- Name: visao; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE visao (
    idvisao bigint NOT NULL,
    descricao character varying(120) NOT NULL,
    tipovisao character(2) NOT NULL,
    situacao character(1) NOT NULL,
    classename character varying(500) DEFAULT NULL::character varying,
    identificador character varying(100) DEFAULT NULL::character varying
);


--
-- TOC entry 477 (class 1259 OID 2249702)
-- Dependencies: 4845 5
-- Name: visaorelacionada; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE visaorelacionada (
    idvisaorelacionada bigint NOT NULL,
    idvisaopai bigint NOT NULL,
    idvisaofilha bigint NOT NULL,
    idobjetonegocionn bigint,
    ordem integer NOT NULL,
    titulo character varying(500) NOT NULL,
    situacao character(1) NOT NULL,
    tipovinculacao character(1) NOT NULL,
    acaoemselecaopesquisa character(2) DEFAULT NULL::bpchar
);


--
-- TOC entry 6069 (class 0 OID 2245983)
-- Dependencies: 161 6388
-- Data for Name: acaoplanomelhoria; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6070 (class 0 OID 2245996)
-- Dependencies: 162 6388
-- Data for Name: acordonivelservico; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO acordonivelservico VALUES (1, NULL, NULL, 'A', 'SLA 1', NULL, 'Descrição do Acordo de Nível de Servico 1', '', '2013-04-01', NULL, '2014-12-31', 'T', 'N', NULL, '', '', '', 'B', 'B', 'S', NULL, '', '2013-04-08 11:56:35', NULL, '1970-01-01 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO acordonivelservico VALUES (2, NULL, NULL, 'A', 'SLA 2', NULL, 'Descrição do Acordo de Nível de Servico 1', '', '2013-04-01', NULL, '2014-12-31', 'T', 'N', NULL, '', '', '', 'B', 'B', 'S', NULL, '', '2013-04-08 11:56:45', NULL, '1970-01-01 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO acordonivelservico VALUES (3, NULL, NULL, 'A', 'SLA 3', NULL, 'Descrição do Acordo de Nível de Servico 3', '', '2013-04-01', NULL, '2014-12-31', 'T', 'N', NULL, '', '', '', 'B', 'B', 'S', NULL, '', '2013-04-08 11:56:57', NULL, '1970-01-01 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);


--
-- TOC entry 6071 (class 0 OID 2246022)
-- Dependencies: 163 6388
-- Data for Name: acordonivelservico_hist; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO acordonivelservico_hist VALUES (1, 1, NULL, NULL, 'A', 'Acordo de Nível de Servico 1', NULL, 'Descrição do Acordo de Nível de Servico 1', '', '2013-04-01', NULL, '2014-12-31', 'T', NULL, '', '', '', 'B', 'B', 'S', 'N', '2013-04-05 04:00:00', 'Administrador', '2013-04-05 04:00:00', 'Administrador', 'JSONDATA: TRUE
DETALHEGLOSA: 
URGENCIA: B
DESCRICAORESULTADOS: 
HH-2-5: 
HH-2-4: 
HH-2-3: 
HH-2-2: 
HH-2-1: 
AVALIAREM: 31/12/2014
HH-1-4: 
HH-1-3: 
ACAOFLUXO: 
HH-1-2: 
HH-1-1: 
ESCOPOSLA: 
HH-1-5: 
DINAMICVIEWSJSON_DATA: 
IDFLUXO: 
JSONMATRIZ: 
IMPACTO: B
DINAMICVIEWSIDVISAO: 67
IDGRUPO1: 
IDUNIDADE_1: 
TITULOSLA: Acordo de Nível de Servico 1
DISPONIBILIDADE: 
LIMITEGLOSA: 
TEMPOAUTO: 
TIPO: T
DETALHELIMITEGLOSA: 
NOCACHE: Fri Apr 05 2013 09:28:14 GMT-0300 (Hora oficial do Brasil)
DINAMICVIEWSJSON_TEMPDATA: 
KEYCONTROL: 
MM-2-4: 
MM-2-5: 
MM-2-2: 
MM-2-3: 
MM-2-1: 
MM-1-3: 
MM-1-4: 
PERMITEMUDARIMPURG: S
MM-1-1: 
MM-1-2: 
DINAMICVIEWSTABLESVINC: "TABLE_SEARCH_62","TABLE_SEARCH_63"
MM-1-5: 
CONTATOS: 
VALORAJUSTESERIALIZADO: idServicoContratoidAcordoNivelServicoserialversionuiddeletedquantidadeFalhasvalorAjusteidControleCITFrameworknull
DINAMICVIEWSACAOPESQUISASELECIONADA: 
VALORAJUSTE: 
QUANTIDADEFALHAS: 
DATAFIM: 
MODOEXIBICAO: N
VALORLIMITE: 
SESSION.NUMERO_CONTRATO_EDICAO: 1
UNIDADEVALORLIMITE: 
GLOSA: 
DINAMICVIEWSIDVISAOPESQUISASELECIONADA: 
IDACORDONIVELSERVICO: 1
DATAINICIO: 01/04/2013
DESCRICAOSLA: Descrição do Acordo de Nível de Servico 1
SESSION.DINAMICVIEWS_SAVEINFO: null
IDPRIORIDADEAUTO1: 
IDTAREFA: 
SITUACAO: A
RESULTADOSESPERADOSSERIALIZADO: idServicoContratoidAcordoNivelServicodeletedlimiteslimiteGlosaglosadescricaoResultadosidControleCITFrameworknull
LIMITES: 
DINAMICVIEWSDADOSADICIONAIS: {}
', NULL);
INSERT INTO acordonivelservico_hist VALUES (2, 2, NULL, NULL, 'A', 'Acordo de Nível de Servico 2', NULL, 'Descrição do Acordo de Nível de Servico 1', '', '2013-04-01', NULL, '2014-12-31', 'T', NULL, '', '', '', 'B', 'B', 'S', 'N', '2013-04-05 04:00:00', 'Administrador', '2013-04-05 04:00:00', 'Administrador', 'JSONDATA: 
DETALHEGLOSA: 
URGENCIA: B
DESCRICAORESULTADOS: 
HH-2-5: 
HH-2-4: 
HH-2-3: 
HH-2-2: 
HH-2-1: 
AVALIAREM: 31/12/2014
HH-1-4: 
HH-1-3: 
ACAOFLUXO: 
HH-1-2: 
HH-1-1: 
ESCOPOSLA: 
HH-1-5: 
DINAMICVIEWSJSON_DATA: 
IDFLUXO: 
JSONMATRIZ: 
IMPACTO: B
DINAMICVIEWSIDVISAO: 67
IDGRUPO1: 
IDUNIDADE_1: 
TITULOSLA: Acordo de Nível de Servico 2
DISPONIBILIDADE: 
LIMITEGLOSA: 
TEMPOAUTO: 
TIPO: T
DETALHELIMITEGLOSA: 
NOCACHE: Fri Apr 05 2013 09:29:03 GMT-0300 (Hora oficial do Brasil)
DINAMICVIEWSJSON_TEMPDATA: 
KEYCONTROL: 
MM-2-4: 
MM-2-5: 
MM-2-2: 
MM-2-3: 
MM-2-1: 
MM-1-3: 
MM-1-4: 
PERMITEMUDARIMPURG: S
MM-1-1: 
MM-1-2: 
DINAMICVIEWSTABLESVINC: 
MM-1-5: 
CONTATOS: 
VALORAJUSTESERIALIZADO: idServicoContratoidAcordoNivelServicoserialversionuiddeletedquantidadeFalhasvalorAjusteidControleCITFrameworknull
DINAMICVIEWSACAOPESQUISASELECIONADA: 
VALORAJUSTE: 
QUANTIDADEFALHAS: 
DATAFIM: 
MODOEXIBICAO: N
VALORLIMITE: 
SESSION.NUMERO_CONTRATO_EDICAO: 1
UNIDADEVALORLIMITE: 
GLOSA: 
DINAMICVIEWSIDVISAOPESQUISASELECIONADA: 
IDACORDONIVELSERVICO: 2
DATAINICIO: 01/04/2013
DESCRICAOSLA: Descrição do Acordo de Nível de Servico 1
SESSION.DINAMICVIEWS_SAVEINFO: null
IDPRIORIDADEAUTO1: 
IDTAREFA: 
SITUACAO: A
RESULTADOSESPERADOSSERIALIZADO: idServicoContratoidAcordoNivelServicodeletedlimiteslimiteGlosaglosadescricaoResultadosidControleCITFrameworknull
LIMITES: 
DINAMICVIEWSDADOSADICIONAIS: {}
', NULL);
INSERT INTO acordonivelservico_hist VALUES (3, 3, NULL, NULL, 'A', 'Acordo de Nível de Servico 3', NULL, 'Descrição do Acordo de Nível de Servico 3', '', '2013-04-01', NULL, '2014-12-31', 'T', NULL, '', '', '', 'B', 'B', 'S', 'N', '2013-04-05 04:00:00', 'Administrador', '2013-04-05 04:00:00', 'Administrador', 'JSONDATA: 
DETALHEGLOSA: 
URGENCIA: B
DESCRICAORESULTADOS: 
HH-2-5: 
HH-2-4: 
HH-2-3: 
HH-2-2: 
HH-2-1: 
AVALIAREM: 31/12/2014
HH-1-4: 
HH-1-3: 
ACAOFLUXO: 
HH-1-2: 
HH-1-1: 
ESCOPOSLA: 
HH-1-5: 
DINAMICVIEWSJSON_DATA: 
IDFLUXO: 
JSONMATRIZ: 
IMPACTO: B
DINAMICVIEWSIDVISAO: 67
IDGRUPO1: 
IDUNIDADE_1: 
TITULOSLA: Acordo de Nível de Servico 3
DISPONIBILIDADE: 
LIMITEGLOSA: 
TEMPOAUTO: 
TIPO: T
DETALHELIMITEGLOSA: 
NOCACHE: Fri Apr 05 2013 09:30:09 GMT-0300 (Hora oficial do Brasil)
DINAMICVIEWSJSON_TEMPDATA: 
KEYCONTROL: 
MM-2-4: 
MM-2-5: 
MM-2-2: 
MM-2-3: 
MM-2-1: 
MM-1-3: 
MM-1-4: 
PERMITEMUDARIMPURG: S
MM-1-1: 
MM-1-2: 
DINAMICVIEWSTABLESVINC: 
MM-1-5: 
CONTATOS: 
VALORAJUSTESERIALIZADO: idServicoContratoidAcordoNivelServicoserialversionuiddeletedquantidadeFalhasvalorAjusteidControleCITFrameworknull
DINAMICVIEWSACAOPESQUISASELECIONADA: 
VALORAJUSTE: 
QUANTIDADEFALHAS: 
DATAFIM: 
MODOEXIBICAO: N
VALORLIMITE: 
SESSION.NUMERO_CONTRATO_EDICAO: 1
UNIDADEVALORLIMITE: 
GLOSA: 
DINAMICVIEWSIDVISAOPESQUISASELECIONADA: 
IDACORDONIVELSERVICO: 3
DATAINICIO: 01/04/2013
DESCRICAOSLA: Descrição do Acordo de Nível de Servico 3
SESSION.DINAMICVIEWS_SAVEINFO: null
IDPRIORIDADEAUTO1: 
IDTAREFA: 
SITUACAO: A
RESULTADOSESPERADOSSERIALIZADO: idServicoContratoidAcordoNivelServicodeletedlimiteslimiteGlosaglosadescricaoResultadosidControleCITFrameworknull
LIMITES: 
DINAMICVIEWSDADOSADICIONAIS: {}
', NULL);
INSERT INTO acordonivelservico_hist VALUES (4, 1, NULL, NULL, 'A', 'SLA 1', NULL, 'Descrição do Acordo de Nível de Servico 1', '', '2013-04-01', NULL, '2014-12-31', 'T', NULL, '', '', '', 'B', 'B', 'S', 'N', '2013-04-08 04:00:00', 'Administrador', '2013-04-08 04:00:00', 'Administrador', 'JSONDATA: TRUE
DETALHEGLOSA: 
URGENCIA: B
DESCRICAORESULTADOS: 
HH-2-5: 0
HH-2-4: 0
HH-2-3: 0
HH-2-2: 0
HH-2-1: 0
AVALIAREM: 31/12/2014
HH-1-4: 0
HH-1-3: 0
ACAOFLUXO: 
HH-1-2: 0
HH-1-1: 0
ESCOPOSLA: 
HH-1-5: 0
DINAMICVIEWSJSON_DATA: 
IDFLUXO: 
JSONMATRIZ: 
IMPACTO: B
DINAMICVIEWSIDVISAO: 67
IDGRUPO1: 
IDUNIDADE_1: 
TITULOSLA: SLA 1
DISPONIBILIDADE: 
LIMITEGLOSA: 
TEMPOAUTO: 
TIPO: T
DETALHELIMITEGLOSA: 
REMOVED: false
NOCACHE: Mon Apr 08 2013 09:02:27 GMT-0300 (Hora oficial do Brasil)
DINAMICVIEWSJSON_TEMPDATA: 
KEYCONTROL: 
MM-2-4: 0
MM-2-5: 0
MM-2-2: 0
MM-2-3: 0
MM-2-1: 0
MM-1-3: 0
MM-1-4: 0
PERMITEMUDARIMPURG: S
MM-1-1: 0
MM-1-2: 0
DINAMICVIEWSTABLESVINC: "TABLE_SEARCH_62","TABLE_SEARCH_63"
MM-1-5: 0
CONTATOS: 
VALORAJUSTESERIALIZADO: idServicoContratoidAcordoNivelServicoserialversionuiddeletedquantidadeFalhasvalorAjusteidControleCITFrameworknull
DINAMICVIEWSACAOPESQUISASELECIONADA: 
VALORAJUSTE: 
QUANTIDADEFALHAS: 
DATAFIM: 
MODOEXIBICAO: N
VALORLIMITE: 
SESSION.NUMERO_CONTRATO_EDICAO: null
UNIDADEVALORLIMITE: 
GLOSA: 
DINAMICVIEWSIDVISAOPESQUISASELECIONADA: 
IDACORDONIVELSERVICO: 1
DATAINICIO: 01/04/2013
IDSERVICOCONTRATO: null
DESCRICAOSLA: Descrição do Acordo de Nível de Servico 1
SESSION.DINAMICVIEWS_SAVEINFO: null
IDPRIORIDADEAUTO1: 
IDTAREFA: 
SITUACAO: A
RESULTADOSESPERADOSSERIALIZADO: idServicoContratoidAcordoNivelServicodeletedlimiteslimiteGlosaglosadescricaoResultadosidControleCITFrameworknull
LIMITES: 
DINAMICVIEWSDADOSADICIONAIS: {}
', NULL);
INSERT INTO acordonivelservico_hist VALUES (5, 2, NULL, NULL, 'A', 'SLA 2', NULL, 'Descrição do Acordo de Nível de Servico 1', '', '2013-04-01', NULL, '2014-12-31', 'T', NULL, '', '', '', 'B', 'B', 'S', 'N', '2013-04-08 04:00:00', 'Administrador', '2013-04-08 04:00:00', 'Administrador', 'JSONDATA: TRUE
DETALHEGLOSA: 
URGENCIA: B
DESCRICAORESULTADOS: 
HH-2-5: 0
HH-2-4: 0
HH-2-3: 0
HH-2-2: 0
HH-2-1: 0
AVALIAREM: 31/12/2014
HH-1-4: 0
HH-1-3: 0
ACAOFLUXO: 
HH-1-2: 0
HH-1-1: 0
ESCOPOSLA: 
HH-1-5: 0
DINAMICVIEWSJSON_DATA: 
IDFLUXO: 
JSONMATRIZ: 
IMPACTO: B
DINAMICVIEWSIDVISAO: 67
IDGRUPO1: 
IDUNIDADE_1: 
TITULOSLA: SLA 2
DISPONIBILIDADE: 
LIMITEGLOSA: 
TEMPOAUTO: 
TIPO: T
DETALHELIMITEGLOSA: 
REMOVED: false
NOCACHE: Mon Apr 08 2013 09:02:37 GMT-0300 (Hora oficial do Brasil)
DINAMICVIEWSJSON_TEMPDATA: 
KEYCONTROL: 
MM-2-4: 0
MM-2-5: 0
MM-2-2: 0
MM-2-3: 0
MM-2-1: 0
MM-1-3: 0
MM-1-4: 0
PERMITEMUDARIMPURG: S
MM-1-1: 0
MM-1-2: 0
DINAMICVIEWSTABLESVINC: "TABLE_SEARCH_62","TABLE_SEARCH_63"
MM-1-5: 0
CONTATOS: 
VALORAJUSTESERIALIZADO: idServicoContratoidAcordoNivelServicoserialversionuiddeletedquantidadeFalhasvalorAjusteidControleCITFrameworknull
DINAMICVIEWSACAOPESQUISASELECIONADA: 
VALORAJUSTE: 
QUANTIDADEFALHAS: 
DATAFIM: 
MODOEXIBICAO: N
VALORLIMITE: 
SESSION.NUMERO_CONTRATO_EDICAO: null
UNIDADEVALORLIMITE: 
GLOSA: 
DINAMICVIEWSIDVISAOPESQUISASELECIONADA: 
IDACORDONIVELSERVICO: 2
DATAINICIO: 01/04/2013
IDSERVICOCONTRATO: null
DESCRICAOSLA: Descrição do Acordo de Nível de Servico 1
SESSION.DINAMICVIEWS_SAVEINFO: null
IDPRIORIDADEAUTO1: 
IDTAREFA: 
SITUACAO: A
RESULTADOSESPERADOSSERIALIZADO: idServicoContratoidAcordoNivelServicodeletedlimiteslimiteGlosaglosadescricaoResultadosidControleCITFrameworknull
LIMITES: 
DINAMICVIEWSDADOSADICIONAIS: {}
', NULL);
INSERT INTO acordonivelservico_hist VALUES (6, 3, NULL, NULL, 'A', 'SLA 3', NULL, 'Descrição do Acordo de Nível de Servico 3', '', '2013-04-01', NULL, '2014-12-31', 'T', NULL, '', '', '', 'B', 'B', 'S', 'N', '2013-04-08 04:00:00', 'Administrador', '2013-04-08 04:00:00', 'Administrador', 'JSONDATA: TRUE
DETALHEGLOSA: 
URGENCIA: B
DESCRICAORESULTADOS: 
HH-2-5: 0
HH-2-4: 0
HH-2-3: 0
HH-2-2: 0
HH-2-1: 0
AVALIAREM: 31/12/2014
HH-1-4: 0
HH-1-3: 0
ACAOFLUXO: 
HH-1-2: 0
HH-1-1: 0
ESCOPOSLA: 
HH-1-5: 0
DINAMICVIEWSJSON_DATA: 
IDFLUXO: 
JSONMATRIZ: 
IMPACTO: B
DINAMICVIEWSIDVISAO: 67
IDGRUPO1: 
IDUNIDADE_1: 
TITULOSLA: SLA 3
DISPONIBILIDADE: 
LIMITEGLOSA: 
TEMPOAUTO: 
TIPO: T
DETALHELIMITEGLOSA: 
REMOVED: false
NOCACHE: Mon Apr 08 2013 09:02:48 GMT-0300 (Hora oficial do Brasil)
DINAMICVIEWSJSON_TEMPDATA: 
KEYCONTROL: 
MM-2-4: 0
MM-2-5: 0
MM-2-2: 0
MM-2-3: 0
MM-2-1: 0
MM-1-3: 0
MM-1-4: 0
PERMITEMUDARIMPURG: S
MM-1-1: 0
MM-1-2: 0
DINAMICVIEWSTABLESVINC: "TABLE_SEARCH_62","TABLE_SEARCH_63"
MM-1-5: 0
CONTATOS: 
VALORAJUSTESERIALIZADO: idServicoContratoidAcordoNivelServicoserialversionuiddeletedquantidadeFalhasvalorAjusteidControleCITFrameworknull
DINAMICVIEWSACAOPESQUISASELECIONADA: 
VALORAJUSTE: 
QUANTIDADEFALHAS: 
DATAFIM: 
MODOEXIBICAO: N
VALORLIMITE: 
SESSION.NUMERO_CONTRATO_EDICAO: null
UNIDADEVALORLIMITE: 
GLOSA: 
DINAMICVIEWSIDVISAOPESQUISASELECIONADA: 
IDACORDONIVELSERVICO: 3
DATAINICIO: 01/04/2013
IDSERVICOCONTRATO: null
DESCRICAOSLA: Descrição do Acordo de Nível de Servico 3
SESSION.DINAMICVIEWS_SAVEINFO: null
IDPRIORIDADEAUTO1: 
IDTAREFA: 
SITUACAO: A
RESULTADOSESPERADOSSERIALIZADO: idServicoContratoidAcordoNivelServicodeletedlimiteslimiteGlosaglosadescricaoResultadosidControleCITFrameworknull
LIMITES: 
DINAMICVIEWSDADOSADICIONAIS: {}
', NULL);


--
-- TOC entry 6072 (class 0 OID 2246046)
-- Dependencies: 164 6388
-- Data for Name: acordonivelservicocontrato; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6073 (class 0 OID 2246058)
-- Dependencies: 165 6388
-- Data for Name: acordoservicocontrato; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO acordoservicocontrato VALUES (1, 1, 1, '2013-04-05', '2013-04-01', NULL, '2013-04-05', NULL, NULL);
INSERT INTO acordoservicocontrato VALUES (2, 1, 2, '2013-04-05', '2013-04-01', NULL, '2013-04-05', NULL, NULL);
INSERT INTO acordoservicocontrato VALUES (3, 2, 3, '2013-04-05', '2013-04-01', NULL, '2013-04-05', NULL, NULL);
INSERT INTO acordoservicocontrato VALUES (4, 2, 4, '2013-04-05', '2013-04-01', NULL, '2013-04-05', NULL, NULL);
INSERT INTO acordoservicocontrato VALUES (5, 3, 5, '2013-04-05', '2013-04-01', NULL, '2013-04-05', NULL, NULL);


--
-- TOC entry 6074 (class 0 OID 2246072)
-- Dependencies: 166 6388
-- Data for Name: alcada; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6075 (class 0 OID 2246078)
-- Dependencies: 167 6388
-- Data for Name: alcadacentroresultado; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6076 (class 0 OID 2246091)
-- Dependencies: 168 6388
-- Data for Name: anexo; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6077 (class 0 OID 2246100)
-- Dependencies: 169 6388
-- Data for Name: anexobaseconhecimento; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6078 (class 0 OID 2246109)
-- Dependencies: 170 6388
-- Data for Name: anexoincidente; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6079 (class 0 OID 2246118)
-- Dependencies: 171 6388
-- Data for Name: anexomudanca; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6080 (class 0 OID 2246130)
-- Dependencies: 172 6388
-- Data for Name: aprovacaomudanca; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6081 (class 0 OID 2246140)
-- Dependencies: 173 6388
-- Data for Name: aprovacaosolicitacaoservico; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6082 (class 0 OID 2246152)
-- Dependencies: 174 6388
-- Data for Name: apuracaovaloresrecurso; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6083 (class 0 OID 2246159)
-- Dependencies: 175 6388
-- Data for Name: atividadeperiodica; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6084 (class 0 OID 2246173)
-- Dependencies: 176 6388
-- Data for Name: atividades; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6085 (class 0 OID 2246182)
-- Dependencies: 177 6388
-- Data for Name: atividadesfluxos; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6086 (class 0 OID 2246188)
-- Dependencies: 178 6388
-- Data for Name: atividadesos; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6087 (class 0 OID 2246204)
-- Dependencies: 179 6388
-- Data for Name: atividadesservicocontrato; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6088 (class 0 OID 2246220)
-- Dependencies: 180 6388
-- Data for Name: auditoria; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6089 (class 0 OID 2246231)
-- Dependencies: 181 6388
-- Data for Name: auditoriaitemconfiguracao; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6090 (class 0 OID 2246242)
-- Dependencies: 182 6388
-- Data for Name: avaliacaocoletapreco; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6091 (class 0 OID 2246247)
-- Dependencies: 183 6388
-- Data for Name: avaliacaocotacao; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6092 (class 0 OID 2246252)
-- Dependencies: 184 6388
-- Data for Name: avaliacaofornecedor; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6386 (class 0 OID 2249717)
-- Dependencies: 478 6388
-- Data for Name: avaliacaopedido; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6093 (class 0 OID 2246264)
-- Dependencies: 185 6388
-- Data for Name: avaliacaoreferenciafornecedor; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6094 (class 0 OID 2246281)
-- Dependencies: 186 6388
-- Data for Name: baseconhecimento; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO baseconhecimento VALUES (1, 1, '2013-04-08', NULL, 'Conhecimento 1', 'Descri&ccedil;&atilde;o Conhecimento 1<br />', 'S', NULL, '2014-12-31', '1.0', NULL, 'Justificativa Conhecimento 1', '2013-04-08', 'Conhecimento 1', NULL, 'N', 1, 1, 1, '1', 'C', 'DS', NULL, NULL, NULL, 'Descrição Conhecimento 1');
INSERT INTO baseconhecimento VALUES (2, 2, '2013-04-08', NULL, 'Conhecimento 2', 'Descri&ccedil;&atilde;o Conhecimento 2<br />', 'S', NULL, '2014-12-31', '1.0', NULL, 'Justificativa Conhecimento 2', '2013-04-08', '', NULL, 'N', 1, 1, 2, '1', 'C', 'DS', NULL, NULL, NULL, 'Descrição Conhecimento 2');
INSERT INTO baseconhecimento VALUES (3, 1, '2013-04-08', NULL, 'FAQ 1', 'Resposta FAQ 1<br />', 'S', NULL, '2014-12-31', '1.0', NULL, 'Justificativa FAQ 1', '2013-04-08', 'FAQ 1', 'S', 'N', 1, 1, 3, '1', 'C', 'DS', NULL, NULL, NULL, 'Resposta FAQ 1');
INSERT INTO baseconhecimento VALUES (4, 2, '2013-04-08', NULL, 'FAQ 2', 'Resposta FAQ 2', 'S', NULL, '2014-12-31', '1.0', NULL, 'Justificativa FAQ 2', '2013-04-08', 'FAQ 2', 'S', 'N', 1, 1, 4, '1', 'C', 'DS', NULL, NULL, NULL, 'Resposta FAQ 2');


--
-- TOC entry 6095 (class 0 OID 2246303)
-- Dependencies: 187 6388
-- Data for Name: baseconhecimentorelacionado; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6096 (class 0 OID 2246308)
-- Dependencies: 188 6388
-- Data for Name: baseitemconfiguracao; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6097 (class 0 OID 2246319)
-- Dependencies: 189 6388
-- Data for Name: bibliotecasexternas; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6098 (class 0 OID 2246327)
-- Dependencies: 190 6388
-- Data for Name: botaoacaovisao; Type: TABLE DATA; Schema: public; Owner: -
--


--
-- TOC entry 6108 (class 0 OID 2246453)
-- Dependencies: 200 6388
-- Data for Name: calendario; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO calendario VALUES (1, 'Padrão', 'S', 1, 1, 1, 1, 1, NULL, NULL);


--
-- TOC entry 6109 (class 0 OID 2246460)
-- Dependencies: 201 6388
-- Data for Name: campoobjrelacionado; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6110 (class 0 OID 2246468)
-- Dependencies: 202 6388
-- Data for Name: camposobjetonegocio; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6111 (class 0 OID 2246475)
-- Dependencies: 203 6388
-- Data for Name: caracteristica; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6112 (class 0 OID 2246489)
-- Dependencies: 204 6388
-- Data for Name: cargos; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO cargos VALUES (1, 'Administrador do Sistema', '2012-01-01', NULL);
INSERT INTO cargos VALUES (2, 'Default', '2012-01-01', NULL);
INSERT INTO cargos VALUES (3, 'Coordenador HelpDesk', '2012-07-13', NULL);


--
-- TOC entry 6113 (class 0 OID 2246494)
-- Dependencies: 205 6388
-- Data for Name: catalogoservico; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6114 (class 0 OID 2246506)
-- Dependencies: 206 6388
-- Data for Name: categoriagaleriaimagem; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6115 (class 0 OID 2246511)
-- Dependencies: 207 6388
-- Data for Name: categoriamudanca; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6116 (class 0 OID 2246534)
-- Dependencies: 208 6388
-- Data for Name: categoriaocorrencia; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6117 (class 0 OID 2246539)
-- Dependencies: 209 6388
-- Data for Name: categoriapost; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6118 (class 0 OID 2246545)
-- Dependencies: 210 6388
-- Data for Name: categoriaproblema; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6119 (class 0 OID 2246551)
-- Dependencies: 211 6388
-- Data for Name: categoriaproduto; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6120 (class 0 OID 2246562)
-- Dependencies: 212 6388
-- Data for Name: categoriaquestionario; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO categoriaquestionario VALUES (1, 'CONTRATOS', 1, 'N');


--
-- TOC entry 6121 (class 0 OID 2246568)
-- Dependencies: 213 6388
-- Data for Name: categoriaservico; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO categoriaservico VALUES (1, NULL, 1, 'Categoria de Serviço 1', '2013-04-02', NULL, 'Categoria de Serviço 1', NULL);


--
-- TOC entry 6122 (class 0 OID 2246582)
-- Dependencies: 214 6388
-- Data for Name: categoriasolucao; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO categoriasolucao VALUES (1, NULL, 'Software', '2012-01-01', NULL, 'n');
INSERT INTO categoriasolucao VALUES (2, 1, 'Ajuste de configuração de software', '2012-01-01', NULL, 'n');
INSERT INTO categoriasolucao VALUES (3, 1, 'Nova Instalação', '2012-01-01', NULL, NULL);
INSERT INTO categoriasolucao VALUES (4, 1, 'Remoção de arquivos temporários', '2012-01-01', NULL, 'n');
INSERT INTO categoriasolucao VALUES (5, 1, 'Ajuste no sistema operacional', '2012-01-01', NULL, 'n');
INSERT INTO categoriasolucao VALUES (6, NULL, 'Hardware', '2012-01-01', NULL, 'y');
INSERT INTO categoriasolucao VALUES (7, 6, 'Reparo no hardware', '2012-01-01', NULL, 'n');
INSERT INTO categoriasolucao VALUES (8, 6, 'Substituição de hardware', '2012-01-01', NULL, 'n');
INSERT INTO categoriasolucao VALUES (9, 6, 'Manutenção preventiva', '2012-01-01', NULL, 'n');
INSERT INTO categoriasolucao VALUES (10, NULL, 'Ajuste na configuração do aplicativo', '2012-01-01', NULL, NULL);
INSERT INTO categoriasolucao VALUES (11, NULL, 'Ajustes nas configurações do sistema', '2012-01-01', NULL, NULL);
INSERT INTO categoriasolucao VALUES (12, NULL, 'Atualização no sistema operacional', '2012-01-01', NULL, NULL);
INSERT INTO categoriasolucao VALUES (13, NULL, 'Aplicação de service pack', '2012-01-01', NULL, NULL);
INSERT INTO categoriasolucao VALUES (14, NULL, 'Ajuste na configuração do browser', '2012-01-01', NULL, NULL);
INSERT INTO categoriasolucao VALUES (15, NULL, 'Novas parametrizações', '2012-01-01', NULL, NULL);
INSERT INTO categoriasolucao VALUES (16, NULL, 'Reconfiguração de parâmetros de rede', '2012-01-01', NULL, NULL);
INSERT INTO categoriasolucao VALUES (17, NULL, 'Liberação de regras no firewall', '2012-01-01', NULL, NULL);
INSERT INTO categoriasolucao VALUES (18, NULL, 'Alteração de regras no firewall', '2012-01-01', NULL, NULL);
INSERT INTO categoriasolucao VALUES (19, NULL, 'Exclusão de regras no firewall', '2012-01-01', NULL, NULL);
INSERT INTO categoriasolucao VALUES (20, NULL, 'Liberação de página no proxy', '2012-01-01', NULL, NULL);
INSERT INTO categoriasolucao VALUES (21, NULL, 'Criação de usuários', '2012-01-01', NULL, NULL);
INSERT INTO categoriasolucao VALUES (22, NULL, 'Mudança de perfil', '2012-01-01', NULL, NULL);
INSERT INTO categoriasolucao VALUES (23, NULL, 'Backup e Restore', '2012-01-01', NULL, NULL);
INSERT INTO categoriasolucao VALUES (24, NULL, 'Software', '2012-01-01', NULL, 'y');


--
-- TOC entry 6123 (class 0 OID 2246589)
-- Dependencies: 215 6388
-- Data for Name: causaincidente; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO causaincidente VALUES (1, NULL, 'Software', '2012-01-01', NULL, NULL);
INSERT INTO causaincidente VALUES (2, 1, 'Instalação ineficaz', '2012-01-01', NULL, NULL);
INSERT INTO causaincidente VALUES (3, 1, 'Configuração', '2012-01-01', NULL, NULL);
INSERT INTO causaincidente VALUES (4, 1, 'Falta de Treinamento', '2012-01-01', NULL, NULL);
INSERT INTO causaincidente VALUES (5, NULL, 'Hardware', '2012-01-01', NULL, NULL);
INSERT INTO causaincidente VALUES (6, 5, 'Defeito', '2012-01-01', NULL, NULL);
INSERT INTO causaincidente VALUES (7, 5, 'Configuração', '2012-01-01', NULL, NULL);
INSERT INTO causaincidente VALUES (8, 5, 'Uso Indevido', '2012-01-01', NULL, NULL);
INSERT INTO causaincidente VALUES (9, 5, 'Outros', '2012-01-01', NULL, 'n');
INSERT INTO causaincidente VALUES (10, 1, 'Erro no aplicativo', '2012-01-01', NULL, NULL);
INSERT INTO causaincidente VALUES (11, 1, 'Lentidão', '2012-01-01', NULL, NULL);
INSERT INTO causaincidente VALUES (12, 1, 'Erro na configuração', '2012-01-01', NULL, NULL);
INSERT INTO causaincidente VALUES (13, 5, 'Erro na configuração', '2012-01-01', NULL, 'y');
INSERT INTO causaincidente VALUES (14, 9, 'Mudança não planejada', '2012-01-01', NULL, NULL);


--
-- TOC entry 6124 (class 0 OID 2246596)
-- Dependencies: 216 6388
-- Data for Name: centroresultado; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6125 (class 0 OID 2246602)
-- Dependencies: 217 6388
-- Data for Name: cidades; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0001, 'Acrelândia', 09);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0002, 'Assis Brasil', 09);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0003, 'Brasiléia' , 09);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0004, 'Bujari', 09 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0005, 'Capixaba', 09 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0006, 'Cruzeiro do Sul', 09 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0007, 'Epitaciolândia' , 09);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0008, 'Feijó', 09);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0009, 'Jordão', 09 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0010, 'Mâncio Lima' , 09 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0011, 'Manoel Urbano', 09 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0012, 'Marechal Thaumaturgo' , 09);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0013, 'Plácido de Castro', 09);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0014, 'Porto Acre', 09);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0015, 'Porto Walter', 09);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0016, 'Rio Branco', 09);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0017, 'Rodrigues Alves', 09 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0018, 'Santa Rosa do Purus', 09 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0019, 'Sena Madureira' , 09);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0020, 'Senador Guiomard' , 09);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0021, 'Tarauacá', 09 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0022, 'Xapuri', 09 );

INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0023, 'Água Branca' , 10 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0024, 'Anadia', 10 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0025, 'Arapiraca' , 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0026, 'Atalaia' , 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0027, 'Barra de Santo Antônio' , 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0028, 'Barra de São Miguel', 10 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0029, 'Batalha' , 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0030, 'Belém', 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0031, 'Belo Monte', 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0032, 'Boca da Mata', 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0033, 'Branquinha', 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0034, 'Cacimbinhas' , 10 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0035, 'Cajueiro', 10 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0036, 'Campestre' , 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0037, 'Campo Alegre', 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0038, 'Campo Grande', 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0039, 'Canapi', 10 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0040, 'Capela', 10 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0041, 'Carneiros' , 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0042, 'Chã Preta' , 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0043, 'Coité do Nóia', 10 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0044, 'Colônia Leopoldina', 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0045, 'Coqueiro Seco', 10 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0046, 'Coruripe', 10 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0047, 'Craíbas' , 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0048, 'Delmiro Gouveia', 10 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0049, 'Dois Riachos', 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0050, 'Estrela de Alagoas', 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0051, 'Feira Grande', 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0052, 'Feliz Deserto', 10 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0053, 'Flexeiras' , 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0054, 'Girau do Ponciano', 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0055, 'Ibateguara', 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0056, 'Igaci', 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0057, 'Igreja Nova' , 10 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0058, 'Inhapi', 10 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0059, 'Jacaré dos Homens', 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0060, 'Jacuípe' , 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0061, 'Japaratinga' , 10 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0062, 'Jaramataia', 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0063, 'Joaquim Gomes', 10 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0064, 'Jundiá', 10 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0065, 'Junqueiro' , 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0066, 'Lagoa da Canoa' , 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0067, 'Limoeiro de Anadia', 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0068, 'Maceió', 10 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0069, 'Major Isidoro', 10 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0070, 'Mar Vermelho', 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0071, 'Maragogi', 10 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0072, 'Maravilha' , 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0073, 'Marechal Deodoro' , 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0074, 'Maribondo' , 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0075, 'Mata Grande' , 10 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0076, 'Matriz de Camaragibe' , 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0077, 'Messias' , 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0078, 'Minador do Negrão', 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0079, 'Monteirópolis', 10 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0080, 'Murici', 10 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0081, 'Novo Lino' , 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0082, 'Olho d`Água das Flores' , 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0083, 'Olho d`Água do Casado', 10 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0084, 'Olho d`Água Grande', 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0085, 'Olivença', 10 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0086, 'Ouro Branco' , 10 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0087, 'Palestina' , 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0088, 'Palmeira dos Índios', 10 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0089, 'Pão de Açúcar', 10 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0090, 'Pariconha' , 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0091, 'Paripueira', 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0092, 'Passo de Camaragibe', 10 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0093, 'Paulo Jacinto', 10 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0094, 'Penedo', 10 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0095, 'Piaçabuçu' , 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0096, 'Pilar', 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0097, 'Pindoba' , 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0098, 'Piranhas', 10 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0099, 'Poço das Trincheiras' , 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0100, 'Porto Calvo' , 10 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0101, 'Porto de Pedras', 10 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0102, 'Porto Real do Colégio', 10 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0103, 'Quebrangulo' , 10 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0104, 'Rio Largo' , 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0105, 'Roteiro' , 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0106, 'Santa Luzia do Norte' , 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0107, 'Santana do Ipanema', 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0108, 'Santana do Mundaú', 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0109, 'São Brás', 10 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0110, 'São José da Laje' , 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0111, 'São José da Tapera', 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0112, 'São Luís do Quitunde' , 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0113, 'São Miguel dos Campos', 10 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0114, 'São Miguel dos Milagres', 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0115, 'São Sebastião', 10 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0116, 'Satuba', 10 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0117, 'Senador Rui Palmeira' , 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0118, 'Tanque d`Arca', 10 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0119, 'Taquarana' , 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0120, 'Teotônio Vilela', 10 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0121, 'Traipu', 10 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0122, 'União dos Palmares', 10);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0123, 'Viçosa', 10 );

INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0124, 'Amapá', 11);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0125, 'Calçoene', 11 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0126, 'Cutias', 11 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0127, 'Ferreira Gomes' , 11);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0128, 'Itaubal' , 11);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0129, 'Laranjal do Jari' , 11);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0130, 'Macapá', 11 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0131, 'Mazagão' , 11);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0132, 'Oiapoque', 11 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0133, 'Pedra Branca do Amaparí', 11);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0134, 'Porto Grande', 11);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0135, 'Pracuúba', 11 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0136, 'Santana' , 11);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0137, 'Serra do Navio' , 11);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0138, 'Tartarugalzinho', 11 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0139, 'Vitória do Jari', 11 );

INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0140, 'Alvarães', 12 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0141, 'Amaturá' , 12);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0142, 'Anamã' , 12);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0143, 'Anori', 12);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0144, 'Apuí' , 12);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0145, 'Atalaia do Norte' , 12);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0146, 'Autazes' , 12);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0147, 'Barcelos', 12 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0148, 'Barreirinha' , 12 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0149, 'Benjamin Constant', 12);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0150, 'Beruri', 12 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0151, 'Boa Vista do Ramos', 12);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0152, 'Boca do Acre', 12);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0153, 'Borba', 12);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0154, 'Caapiranga', 12);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0155, 'Canutama', 12 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0156, 'Carauari', 12 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0157, 'Careiro' , 12);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0158, 'Careiro da Várzea', 12);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0159, 'Coari', 12);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0160, 'Codajás' , 12);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0161, 'Eirunepé', 12 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0162, 'Envira', 12 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0163, 'Fonte Boa' , 12);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0164, 'Guajará' , 12);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0165, 'Humaitá' , 12);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0166, 'Ipixuna' , 12);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0167, 'Iranduba', 12 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0168, 'Itacoatiara' , 12 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0169, 'Itamarati' , 12);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0170, 'Itapiranga', 12);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0171, 'Japurá', 12 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0172, 'Juruá', 12);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0173, 'Jutaí', 12);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0174, 'Lábrea', 12 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0175, 'Manacapuru', 12);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0176, 'Manaquiri' , 12);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0177, 'Manaus', 12 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0178, 'Manicoré', 12 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0179, 'Maraã', 12);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0180, 'Maués', 12);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0181, 'Nhamundá', 12 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0182, 'Nova Olinda do Norte' , 12);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0183, 'Novo Airão', 12);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0184, 'Novo Aripuanã', 12 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0185, 'Parintins' , 12);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0186, 'Pauini', 12 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0187, 'Presidente Figueiredo', 12 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0188, 'Rio Preto da Eva' , 12);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0189, 'Santa Isabel do Rio Negro', 12);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0190, 'Santo Antônio do Içá' , 12);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0191, 'São Gabriel da Cachoeira' , 12 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0192, 'São Paulo de Olivença', 12 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0193, 'São Sebastião do Uatumã', 12);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0194, 'Silves', 12 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0195, 'Tabatinga' , 12);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0196, 'Tapauá', 12 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0197, 'Tefé' , 12);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0198, 'Tonantins' , 12);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0199, 'Uarini', 12 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0200, 'Urucará' , 12);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0201, 'Urucurituba' , 12 );

INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0202, 'Abaíra', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0203, 'Abaré', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0204, 'Acajutiba' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0205, 'Adustina', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0206, 'Água Fria' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0207, 'Aiquara' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0208, 'Alagoinhas', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0209, 'Alcobaça', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0210, 'Almadina', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0211, 'Amargosa', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0212, 'Amélia Rodrigues' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0213, 'América Dourada', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0214, 'Anagé', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0215, 'Andaraí' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0216, 'Andorinha' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0217, 'Angical' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0218, 'Anguera' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0219, 'Antas', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0220, 'Antônio Cardoso', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0221, 'Antônio Gonçalves', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0222, 'Aporá', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0223, 'Apuarema', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0224, 'Araças', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0225, 'Aracatu' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0226, 'Araci', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0227, 'Aramari' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0228, 'Arataca' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0229, 'Aratuípe', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0230, 'Aurelino Leal', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0231, 'Baianópolis' , 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0232, 'Baixa Grande', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0233, 'Banzaê', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0234, 'Barra', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0235, 'Barra da Estiva', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0236, 'Barra do Choça' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0237, 'Barra do Mendes', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0238, 'Barra do Rocha' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0239, 'Barreiras' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0240, 'Barro Alto', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0241, 'Belmonte', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0242, 'Belo Campo', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0243, 'Biritinga' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0244, 'Boa Nova', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0245, 'Boa Vista do Tupim', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0246, 'Bom Jesus da Lapa', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0247, 'Bom Jesus da Serra', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0248, 'Boninal' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0249, 'Bonito', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0250, 'Boquira' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0251, 'Botuporã', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0252, 'Brejões' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0253, 'Brejolândia' , 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0254, 'Brotas de Macaúbas', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0255, 'Brumado' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0256, 'Buerarema' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0257, 'Buritirama', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0258, 'Caatiba' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0259, 'Cabaceiras do Paraguaçu', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0260, 'Cachoeira' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0261, 'Caculé', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0262, 'Caém' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0263, 'Caetanos', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0264, 'Caetité' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0265, 'Cafarnaum' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0266, 'Cairu', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0267, 'Caldeirão Grande' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0268, 'Camacan' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0269, 'Camaçari', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0270, 'Camamu', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0271, 'Campo Alegre de Lourdes', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0272, 'Campo Formoso', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0273, 'Canápolis' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0274, 'Canarana', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0275, 'Canavieiras' , 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0276, 'Candeal' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0277, 'Candeias', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0278, 'Candiba' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0279, 'Cândido Sales', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0280, 'Cansanção' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0281, 'Canudos' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0282, 'Capela do Alto Alegre', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0283, 'Capim Grosso', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0284, 'Caraíbas', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0285, 'Caravelas' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0286, 'Cardeal da Silva' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0287, 'Carinhanha', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0288, 'Casa Nova' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0289, 'Castro Alves', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0290, 'Catolândia', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0291, 'Catu' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0292, 'Caturama', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0293, 'Central' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0294, 'Chorrochó' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0295, 'Cícero Dantas', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0296, 'Cipó' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0297, 'Coaraci' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0298, 'Cocos', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0299, 'Conceição da Feira', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0300, 'Conceição do Almeida' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0301, 'Conceição do Coité', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0302, 'Conceição do Jacuípe' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0303, 'Conde', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0304, 'Condeúba', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0305, 'Contendas do Sincorá' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0306, 'Coração de Maria' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0307, 'Cordeiros' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0308, 'Coribe', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0309, 'Coronel João Sá', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0310, 'Correntina', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0311, 'Cotegipe', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0312, 'Cravolândia' , 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0313, 'Crisópolis', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0314, 'Cristópolis' , 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0315, 'Cruz das Almas' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0316, 'Curaçá', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0317, 'Dário Meira' , 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0318, 'Dias d`Ávila', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0319, 'Dom Basílio' , 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0320, 'Dom Macedo Costa' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0321, 'Elísio Medrado' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0322, 'Encruzilhada', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0323, 'Entre Rios', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0324, 'Érico Cardoso', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0325, 'Esplanada' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0326, 'Euclides da Cunha', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0327, 'Eunápolis' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0328, 'Fátima', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0329, 'Feira da Mata', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0330, 'Feira de Santana' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0331, 'Filadélfia', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0332, 'Firmino Alves', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0333, 'Floresta Azul', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0334, 'Formosa do Rio Preto' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0335, 'Gandu', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0336, 'Gavião', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0337, 'Gentio do Ouro' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0338, 'Glória', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0339, 'Gongogi' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0340, 'Governador Lomanto Júnior', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0341, 'Governador Mangabeira', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0342, 'Guajeru' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0343, 'Guanambi', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0344, 'Guaratinga', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0345, 'Heliópolis', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0346, 'Iaçu' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0347, 'Ibiassucê' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0348, 'Ibicaraí', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0349, 'Ibicoara', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0350, 'Ibicuí', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0351, 'Ibipeba' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0352, 'Ibipitanga', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0353, 'Ibiquera', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0354, 'Ibirapitanga', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0355, 'Ibirapuã', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0356, 'Ibirataia' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0357, 'Ibitiara', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0358, 'Ibititá' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0359, 'Ibotirama' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0360, 'Ichu' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0361, 'Igaporã' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0362, 'Igrapiúna' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0363, 'Iguaí', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0364, 'Ilhéus', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0365, 'Inhambupe' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0366, 'Ipecaetá', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0367, 'Ipiaú', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0368, 'Ipirá', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0369, 'Ipupiara', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0370, 'Irajuba' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0371, 'Iramaia' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0372, 'Iraquara', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0373, 'Irará', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0374, 'Irecê', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0375, 'Itabela' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0376, 'Itaberaba' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0377, 'Itabuna' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0378, 'Itacaré' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0379, 'Itaeté', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0380, 'Itagi', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0381, 'Itagibá' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0382, 'Itagimirim', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0383, 'Itaguaçu da Bahia', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0384, 'Itaju do Colônia' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0385, 'Itajuípe', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0386, 'Itamaraju' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0387, 'Itamari' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0388, 'Itambé', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0389, 'Itanagra', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0390, 'Itanhém' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0391, 'Itaparica' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0392, 'Itapé', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0393, 'Itapebi' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0394, 'Itapetinga', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0395, 'Itapicuru' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0396, 'Itapitanga', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0397, 'Itaquara', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0398, 'Itarantim' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0399, 'Itatim', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0400, 'Itiruçu' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0401, 'Itiúba', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0402, 'Itororó' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0403, 'Ituaçu', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0404, 'Ituberá' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0405, 'Iuiú' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0406, 'Jaborandi' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0407, 'Jacaraci', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0408, 'Jacobina', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0409, 'Jaguaquara', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0410, 'Jaguarari' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0411, 'Jaguaripe' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0412, 'Jandaíra', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0413, 'Jequié', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0414, 'Jeremoabo' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0415, 'Jiquiriçá' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0416, 'Jitaúna' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0417, 'João Dourado', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0418, 'Juazeiro', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0419, 'Jucuruçu', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0420, 'Jussara' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0421, 'Jussari' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0422, 'Jussiape', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0423, 'Lafaiete Coutinho', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0424, 'Lagoa Real', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0425, 'Laje' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0426, 'Lajedão' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0427, 'Lajedinho' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0428, 'Lajedo do Tabocal', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0429, 'Lamarão' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0430, 'Lapão', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0431, 'Lauro de Freitas' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0432, 'Lençóis' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0433, 'Licínio de Almeida', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0434, 'Livramento de Nossa Senhora' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0435, 'Macajuba', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0436, 'Macarani', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0437, 'Macaúbas', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0438, 'Macururé', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0439, 'Madre de Deus', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0440, 'Maetinga', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0441, 'Maiquinique' , 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0442, 'Mairi', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0443, 'Malhada' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0444, 'Malhada de Pedras', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0445, 'Manoel Vitorino', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0446, 'Mansidão', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0447, 'Maracás' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0448, 'Maragogipe', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0449, 'Maraú', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0450, 'Marcionílio Souza', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0451, 'Mascote' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0452, 'Mata de São João' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0453, 'Matina', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0454, 'Medeiros Neto', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0455, 'Miguel Calmon', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0456, 'Milagres', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0457, 'Mirangaba' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0458, 'Mirante' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0459, 'Monte Santo' , 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0460, 'Morpará' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0461, 'Morro do Chapéu', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0462, 'Mortugaba' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0463, 'Mucugê', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0464, 'Mucuri', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0465, 'Mulungu do Morro' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0466, 'Mundo Novo', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0467, 'Muniz Ferreira' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0468, 'Muquém de São Francisco', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0469, 'Muritiba', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0470, 'Mutuípe' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0471, 'Nazaré', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0472, 'Nilo Peçanha', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0473, 'Nordestina', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0474, 'Nova Canaã', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0475, 'Nova Fátima' , 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0476, 'Nova Ibiá' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0477, 'Nova Itarana', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0478, 'Nova Redenção', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0479, 'Nova Soure', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0480, 'Nova Viçosa' , 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0481, 'Novo Horizonte' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0482, 'Novo Triunfo', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0483, 'Olindina', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0484, 'Oliveira dos Brejinhos' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0485, 'Ouriçangas', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0486, 'Ourolândia', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0487, 'Palmas de Monte Alto' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0488, 'Palmeiras' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0489, 'Paramirim' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0490, 'Paratinga' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0491, 'Paripiranga' , 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0492, 'Pau Brasil', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0493, 'Paulo Afonso', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0494, 'Pé de Serra' , 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0495, 'Pedrão', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0496, 'Pedro Alexandre', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0497, 'Piatã', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0498, 'Pilão Arcado', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0499, 'Pindaí', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0500, 'Pindobaçu' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0501, 'Pintadas', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0502, 'Piraí do Norte' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0503, 'Piripá', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0504, 'Piritiba', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0505, 'Planaltino', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0506, 'Planalto', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0507, 'Poções', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0508, 'Pojuca', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0509, 'Ponto Novo', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0510, 'Porto Seguro', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0511, 'Potiraguá' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0512, 'Prado', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0513, 'Presidente Dutra' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0514, 'Presidente Jânio Quadros' , 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0515, 'Presidente Tancredo Neves', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0516, 'Queimadas' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0517, 'Quijingue' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0518, 'Quixabeira', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0519, 'Rafael Jambeiro', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0520, 'Remanso' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0521, 'Retirolândia', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0522, 'Riachão das Neves', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0523, 'Riachão do Jacuípe', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0524, 'Riacho de Santana', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0525, 'Ribeira do Amparo', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0526, 'Ribeira do Pombal', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0527, 'Ribeirão do Largo', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0528, 'Rio de Contas', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0529, 'Rio do Antônio' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0530, 'Rio do Pires', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0531, 'Rio Real', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0532, 'Rodelas' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0533, 'Ruy Barbosa' , 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0534, 'Salinas da Margarida' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0535, 'Salvador', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0536, 'Santa Bárbara', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0537, 'Santa Brígida', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0538, 'Santa Cruz Cabrália', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0539, 'Santa Cruz da Vitória', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0540, 'Santa Inês', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0541, 'Santa Luzia' , 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0542, 'Santa Maria da Vitória' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0543, 'Santa Rita de Cássia' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0544, 'Santa Teresinha', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0545, 'Santaluz', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0546, 'Santana' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0547, 'Santanópolis', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0548, 'Santo Amaro' , 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0549, 'Santo Antônio de Jesus' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0550, 'Santo Estêvão', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0551, 'São Desidério', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0552, 'São Domingos', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0553, 'São Felipe', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0554, 'São Félix' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0555, 'São Félix do Coribe', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0556, 'São Francisco do Conde' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0557, 'São Gabriel' , 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0558, 'São Gonçalo dos Campos' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0559, 'São José da Vitória', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0560, 'São José do Jacuípe', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0561, 'São Miguel das Matas' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0562, 'São Sebastião do Passé' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0563, 'Sapeaçu' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0564, 'Sátiro Dias' , 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0565, 'Saubara' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0566, 'Saúde', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0567, 'Seabra', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0568, 'Sebastião Laranjeiras', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0569, 'Senhor do Bonfim' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0570, 'Sento Sé', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0571, 'Serra do Ramalho' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0572, 'Serra Dourada', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0573, 'Serra Preta' , 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0574, 'Serrinha', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0575, 'Serrolândia' , 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0576, 'Simões Filho', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0577, 'Sítio do Mato', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0578, 'Sítio do Quinto', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0579, 'Sobradinho', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0580, 'Souto Soares', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0581, 'Tabocas do Brejo Velho' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0582, 'Tanhaçu' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0583, 'Tanque Novo' , 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0584, 'Tanquinho' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0585, 'Taperoá' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0586, 'Tapiramutá', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0587, 'Teixeira de Freitas', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0588, 'Teodoro Sampaio', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0589, 'Teofilândia' , 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0590, 'Teolândia' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0591, 'Terra Nova', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0592, 'Tremedal', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0593, 'Tucano', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0594, 'Uauá' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0595, 'Ubaíra', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0596, 'Ubaitaba', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0597, 'Ubatã', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0598, 'Uibaí', 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0599, 'Umburanas' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0600, 'Una', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0601, 'Urandi', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0602, 'Uruçuca' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0603, 'Utinga', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0604, 'Valença' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0605, 'Valente' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0606, 'Várzea da Roça' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0607, 'Várzea do Poço' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0608, 'Várzea Nova' , 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0609, 'Varzedo' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0610, 'Vera Cruz' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0611, 'Vereda', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0612, 'Vitória da Conquista' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0613, 'Wagner', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0614, 'Wanderley' , 13);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0615, 'Wenceslau Guimarães', 13 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0616, 'Xique-Xique' , 13 );

INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0617, 'Abaiara' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0618, 'Acarapé' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0619, 'Acaraú', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0620, 'Acopiara', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0621, 'Aiuaba', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0622, 'Alcântaras', 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0623, 'Altaneira' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0624, 'Alto Santo', 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0625, 'Amontada', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0626, 'Antonina do Norte', 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0627, 'Apuiarés', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0628, 'Aquiraz' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0629, 'Aracati' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0630, 'Aracoiaba' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0631, 'Ararendá', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0632, 'Araripe' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0633, 'Aratuba' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0634, 'Arneiroz', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0635, 'Assaré', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0636, 'Aurora', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0637, 'Baixio', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0638, 'Banabuiú', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0639, 'Barbalha', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0640, 'Barreira', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0641, 'Barro', 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0642, 'Barroquinha' , 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0643, 'Baturité', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0644, 'Beberibe', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0645, 'Bela Cruz' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0646, 'Boa Viagem', 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0647, 'Brejo Santo' , 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0648, 'Camocim' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0649, 'Campos Sales', 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0650, 'Canindé' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0651, 'Capistrano', 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0652, 'Caridade', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0653, 'Cariré', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0654, 'Caririaçu' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0655, 'Cariús', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0656, 'Carnaubal' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0657, 'Cascavel', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0658, 'Catarina', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0659, 'Catunda' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0660, 'Caucaia' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0661, 'Cedro', 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0662, 'Chaval', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0663, 'Choró', 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0664, 'Chorozinho', 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0665, 'Coreaú', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0666, 'Crateús' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0667, 'Crato', 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0668, 'Croatá', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0669, 'Cruz' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0670, 'Deputado Irapuan Pinheiro', 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0671, 'Ererê', 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0672, 'Eusébio' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0673, 'Farias Brito', 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0674, 'Forquilha' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0675, 'Fortaleza' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0676, 'Fortim', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0677, 'Frecheirinha', 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0678, 'General Sampaio', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0679, 'Graça', 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0680, 'Granja', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0681, 'Granjeiro' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0682, 'Groaíras', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0683, 'Guaiúba' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0684, 'Guaraciaba do Norte', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0685, 'Guaramiranga', 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0686, 'Hidrolândia' , 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0687, 'Horizonte' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0688, 'Ibaretama' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0689, 'Ibiapina', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0690, 'Ibicuitinga' , 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0691, 'Icapuí', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0692, 'Icó', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0693, 'Iguatu', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0694, 'Independência', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0695, 'Ipaporanga', 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0696, 'Ipaumirim' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0697, 'Ipu', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0698, 'Ipueiras', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0699, 'Iracema' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0700, 'Irauçuba', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0701, 'Itaiçaba', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0702, 'Itaitinga' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0703, 'Itapagé' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0704, 'Itapipoca' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0705, 'Itapiúna', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0706, 'Itarema' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0707, 'Itatira' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0708, 'Jaguaretama' , 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0709, 'Jaguaribara' , 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0710, 'Jaguaribe' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0711, 'Jaguaruana', 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0712, 'Jardim', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0713, 'Jati' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0714, 'Jijoca de Jericoacoara' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0715, 'Juazeiro do Norte', 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0716, 'Jucás', 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0717, 'Lavras da Mangabeira' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0718, 'Limoeiro do Norte', 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0719, 'Madalena', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0720, 'Maracanaú' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0721, 'Maranguape', 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0722, 'Marco', 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0723, 'Martinópole' , 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0724, 'Massapê' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0725, 'Mauriti' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0726, 'Meruoca' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0727, 'Milagres', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0728, 'Milhã', 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0729, 'Miraíma' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0730, 'Missão Velha', 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0731, 'Mombaça' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0732, 'Monsenhor Tabosa' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0733, 'Morada Nova' , 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0734, 'Moraújo' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0735, 'Morrinhos' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0736, 'Mucambo' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0737, 'Mulungu' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0738, 'Nova Olinda' , 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0739, 'Nova Russas' , 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0740, 'Novo Oriente', 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0741, 'Ocara', 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0742, 'Orós' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0743, 'Pacajus' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0744, 'Pacatuba', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0745, 'Pacoti', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0746, 'Pacujá', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0747, 'Palhano' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0748, 'Palmácia', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0749, 'Paracuru', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0750, 'Paraipaba' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0751, 'Parambu' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0752, 'Paramoti', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0753, 'Pedra Branca', 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0754, 'Penaforte' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0755, 'Pentecoste', 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0756, 'Pereiro' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0757, 'Pindoretama' , 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0758, 'Piquet Carneiro', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0759, 'Pires Ferreira' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0760, 'Poranga' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0761, 'Porteiras' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0762, 'Potengi' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0763, 'Potiretama', 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0764, 'Quiterianópolis', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0765, 'Quixadá' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0766, 'Quixelô' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0767, 'Quixeramobim', 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0768, 'Quixeré' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0769, 'Redenção', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0770, 'Reriutaba' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0771, 'Russas', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0772, 'Saboeiro', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0773, 'Salitre' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0774, 'Santa Quitéria' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0775, 'Santana do Acaraú', 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0776, 'Santana do Cariri', 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0777, 'São Benedito', 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0778, 'São Gonçalo do Amarante', 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0779, 'São João do Jaguaribe', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0780, 'São Luís do Curu' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0781, 'Senador Pompeu' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0782, 'Senador Sá', 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0783, 'Sobral', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0784, 'Solonópole', 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0785, 'Tabuleiro do Norte', 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0786, 'Tamboril', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0787, 'Tarrafas', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0788, 'Tauá' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0789, 'Tejuçuoca' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0790, 'Tianguá' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0791, 'Trairi', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0792, 'Tururu', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0793, 'Ubajara' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0794, 'Umari', 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0795, 'Umirim', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0796, 'Uruburetama' , 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0797, 'Uruoca', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0798, 'Varjota' , 14);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0799, 'Várzea Alegre', 14 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0800, 'Viçosa do Ceará', 14 );

INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0801, 'Brasília', 01 );

INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0802, 'Afonso Cláudio' , 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0803, 'Água Doce do Norte', 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0804, 'Águia Branca', 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0805, 'Alegre', 08 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0806, 'Alfredo Chaves' , 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0807, 'Alto Rio Novo', 08 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0808, 'Anchieta', 08 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0809, 'Apiacá', 08 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0810, 'Aracruz' , 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0811, 'Atilio Vivacqua', 08 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0812, 'Baixo Guandu', 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0813, 'Barra de São Francisco' , 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0814, 'Boa Esperança', 08 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0815, 'Bom Jesus do Norte', 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0816, 'Brejetuba' , 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0817, 'Cachoeiro de Itapemirim', 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0818, 'Cariacica' , 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0819, 'Castelo' , 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0820, 'Colatina', 08 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0821, 'Conceição da Barra', 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0822, 'Conceição do Castelo' , 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0823, 'Divino de São Lourenço' , 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0824, 'Domingos Martins' , 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0825, 'Dores do Rio Preto', 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0826, 'Ecoporanga', 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0827, 'Fundão', 08 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0828, 'Guaçuí', 08 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0829, 'Guarapari' , 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0830, 'Ibatiba' , 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0831, 'Ibiraçu' , 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0832, 'Ibitirama' , 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0833, 'Iconha', 08 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0834, 'Irupi', 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0835, 'Itaguaçu', 08 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0836, 'Itapemirim', 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0837, 'Itarana' , 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0838, 'Iúna' , 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0839, 'Jaguaré' , 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0840, 'Jerônimo Monteiro', 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0841, 'João Neiva', 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0842, 'Laranja da Terra' , 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0843, 'Linhares', 08 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0844, 'Mantenópolis', 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0845, 'Marataízes', 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0846, 'Marechal Floriano', 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0847, 'Marilândia', 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0848, 'Mimoso do Sul', 08 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0849, 'Montanha', 08 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0850, 'Mucurici', 08 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0851, 'Muniz Freire', 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0852, 'Muqui', 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0853, 'Nova Venécia', 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0854, 'Pancas', 08 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0855, 'Pedro Canário', 08 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0856, 'Pinheiros' , 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0857, 'Piúma', 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0858, 'Ponto Belo', 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0859, 'Presidente Kennedy', 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0860, 'Rio Bananal' , 08 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0861, 'Rio Novo do Sul', 08 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0862, 'Santa Leopoldina' , 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0863, 'Santa Maria de Jetibá', 08 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0864, 'Santa Teresa', 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0865, 'São Domingos do Norte', 08 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0866, 'São Gabriel da Palha' , 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0867, 'São José do Calçado', 08 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0868, 'São Mateus', 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0869, 'São Roque do Canaã', 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0870, 'Serra', 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0871, 'Sooretama' , 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0872, 'Vargem Alta' , 08 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0873, 'Venda Nova do Imigrante', 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0874, 'Viana', 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0875, 'Vila Pavão', 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0876, 'Vila Valério', 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0877, 'Vila Velha', 08);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0878, 'Vitória' , 08);

INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0879, 'Abadia de Goiás', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0880, 'Abadiânia' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0881, 'Acreúna' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0882, 'Adelândia' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0883, 'Água Fria de Goiás', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0884, 'Água Limpa', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0885, 'Águas Lindas de Goiás', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0886, 'Alexânia', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0887, 'Aloândia', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0888, 'Alto Horizonte' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0889, 'Alto Paraíso de Goiás', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0890, 'Alvorada do Norte', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0891, 'Amaralina' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0892, 'Americano do Brasil', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0893, 'Amorinópolis', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0894, 'Anápolis', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0895, 'Anhanguera', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0896, 'Anicuns' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0897, 'Aparecida de Goiânia' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0898, 'Aparecida do Rio Doce', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0899, 'Aporé', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0900, 'Araçu', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0901, 'Aragarças' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0902, 'Aragoiânia', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0903, 'Araguapaz' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0904, 'Arenópolis', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0905, 'Aruanã', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0906, 'Aurilândia', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0907, 'Avelinópolis', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0908, 'Baliza', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0909, 'Barro Alto', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0910, 'Bela Vista de Goiás', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0911, 'Bom Jardim de Goiás', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0912, 'Bom Jesus de Goiás', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0913, 'Bonfinópolis', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0914, 'Bonópolis' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0915, 'Brazabrantes', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0916, 'Britânia', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0917, 'Buriti Alegre', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0918, 'Buriti de Goiás', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0919, 'Buritinópolis', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0920, 'Cabeceiras', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0921, 'Cachoeira Alta' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0922, 'Cachoeira de Goiás', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0923, 'Cachoeira Dourada', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0924, 'Caçu' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0925, 'Caiapônia' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0926, 'Caldas Novas', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0927, 'Caldazinha', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0928, 'Campestre de Goiás', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0929, 'Campinaçu' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0930, 'Campinorte', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0931, 'Campo Alegre de Goiás', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0932, 'Campos Belos', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0933, 'Campos Verdes', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0934, 'Carmo do Rio Verde', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0935, 'Castelândia' , 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0936, 'Catalão' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0937, 'Caturaí' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0938, 'Cavalcante', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0939, 'Ceres', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0940, 'Cezarina', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0941, 'Chapadão do Céu', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0942, 'cidades Ocidental', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0943, 'Cocalzinho de Goiás', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0944, 'Colinas do Sul' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0945, 'Córrego do Ouro', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0946, 'Corumbá de Goiás' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0947, 'Corumbaíba', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0948, 'Cristalina', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0949, 'Cristianópolis' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0950, 'Crixás', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0951, 'Cromínia', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0952, 'Cumari', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0953, 'Damianópolis', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0954, 'Damolândia', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0955, 'Davinópolis' , 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0956, 'Diorama' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0957, 'Divinópolis de Goiás' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0958, 'Doverlândia' , 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0959, 'Edealina', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0960, 'Edéia', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0961, 'Estrela do Norte' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0962, 'Faina', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0963, 'Fazenda Nova', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0964, 'Firminópolis', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0965, 'Flores de Goiás', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0966, 'Formosa' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0967, 'Formoso' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0968, 'Goianápolis' , 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0969, 'Goiandira' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0970, 'Goianésia' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0971, 'Goiânia' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0972, 'Goianira', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0973, 'Goiás', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0974, 'Goiatuba', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0975, 'Gouvelândia' , 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0976, 'Guapó', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0977, 'Guaraíta', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0978, 'Guarani de Goiás' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0979, 'Guarinos', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0980, 'Heitoraí', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0981, 'Hidrolândia' , 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0982, 'Hidrolina' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0983, 'Iaciara' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0984, 'Inaciolândia', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0985, 'Indiara' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0986, 'Inhumas' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0987, 'Ipameri' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0988, 'Iporá', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0989, 'Israelândia' , 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0990, 'Itaberaí', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0991, 'Itaguari', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0992, 'Itaguaru', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0993, 'Itajá', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0994, 'Itapaci' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0995, 'Itapirapuã', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0996, 'Itapuranga', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0997, 'Itarumã' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0998, 'Itauçu', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (0999, 'Itumbiara' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1000, 'Ivolândia' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1001, 'Jandaia' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1002, 'Jaraguá' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1003, 'Jataí', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1004, 'Jaupaci' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1005, 'Jesúpolis' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1006, 'Joviânia', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1007, 'Jussara' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1008, 'Leopoldo de Bulhões', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1009, 'Luziânia', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1010, 'Mairipotaba' , 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1011, 'Mambaí', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1012, 'Mara Rosa' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1013, 'Marzagão', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1014, 'Matrinchã' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1015, 'Maurilândia' , 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1016, 'Mimoso de Goiás', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1017, 'Minaçu', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1018, 'Mineiros', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1019, 'Moiporá' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1020, 'Monte Alegre de Goiás', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1021, 'Montes Claros de Goiás' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1022, 'Montividiu', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1023, 'Montividiu do Norte', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1024, 'Morrinhos' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1025, 'Morro Agudo de Goiás' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1026, 'Mossâmedes', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1027, 'Mozarlândia' , 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1028, 'Mundo Novo', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1029, 'Mutunópolis' , 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1030, 'Nazário' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1031, 'Nerópolis' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1032, 'Niquelândia' , 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1033, 'Nova América', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1034, 'Nova Aurora' , 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1035, 'Nova Crixás' , 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1036, 'Nova Glória' , 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1037, 'Nova Iguaçu de Goiás' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1038, 'Nova Roma' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1039, 'Nova Veneza' , 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1040, 'Novo Brasil' , 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1041, 'Novo Gama' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1042, 'Novo Planalto', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1043, 'Orizona' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1044, 'Ouro Verde de Goiás', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1045, 'Ouvidor' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1046, 'Padre Bernardo' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1047, 'Palestina de Goiás', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1048, 'Palmeiras de Goiás', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1049, 'Palmelo' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1050, 'Palminópolis', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1051, 'Panamá', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1052, 'Paranaiguara', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1053, 'Paraúna' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1054, 'Perolândia', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1055, 'Petrolina de Goiás', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1056, 'Pilar de Goiás' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1057, 'Piracanjuba' , 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1058, 'Piranhas', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1059, 'Pirenópolis' , 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1060, 'Pires do Rio', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1061, 'Planaltina', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1062, 'Pontalina' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1063, 'Porangatu' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1064, 'Porteirão' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1065, 'Portelândia' , 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1066, 'Posse', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1067, 'Professor Jamil', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1068, 'Quirinópolis', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1069, 'Rialma', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1070, 'Rianápolis', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1071, 'Rio Quente', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1072, 'Rio Verde' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1073, 'Rubiataba' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1074, 'Sanclerlândia', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1075, 'Santa Bárbara de Goiás' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1076, 'Santa Cruz de Goiás', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1077, 'Santa Fé de Goiás', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1078, 'Santa Helena de Goiás', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1079, 'Santa Isabel', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1080, 'Santa Rita do Araguaia' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1081, 'Santa Rita do Novo Destino', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1082, 'Santa Rosa de Goiás', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1083, 'Santa Tereza de Goiás', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1084, 'Santa Terezinha de Goiás' , 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1085, 'Santo Antônio da Barra' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1086, 'Santo Antônio de Goiás' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1087, 'Santo Antônio do Descoberto' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1088, 'São Domingos', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1089, 'São Francisco de Goiás' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1090, 'São João d`Aliança', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1091, 'São João da Paraúna', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1092, 'São Luís de Montes Belos' , 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1093, 'São Luíz do Norte', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1094, 'São Miguel do Araguaia' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1095, 'São Miguel do Passa Quatro', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1096, 'São Patrício', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1097, 'São Simão' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1098, 'Senador Canedo' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1099, 'Serranópolis', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1100, 'Silvânia', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1101, 'Simolândia', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1102, 'Sítio d`Abadia' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1103, 'Taquaral de Goiás', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1104, 'Teresina de Goiás', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1105, 'Terezópolis de Goiás' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1106, 'Três Ranchos', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1107, 'Trindade', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1108, 'Trombas' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1109, 'Turvânia', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1110, 'Turvelândia' , 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1111, 'Uirapuru', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1112, 'Uruaçu', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1113, 'Uruana', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1114, 'Urutaí', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1115, 'Valparaíso de Goiás', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1116, 'Varjão', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1117, 'Vianópolis', 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1118, 'Vicentinópolis' , 04);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1119, 'Vila Boa', 04 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1120, 'Vila Propício', 04 );

INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1121, 'Açailândia', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1122, 'Afonso Cunha', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1123, 'Água Doce do Maranhão', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1124, 'Alcântara' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1125, 'Aldeias Altas', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1126, 'Altamira do Maranhão' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1127, 'Alto Alegre do Maranhão', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1128, 'Alto Alegre do Pindaré' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1129, 'Alto Parnaíba', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1130, 'Amapá do Maranhão', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1131, 'Amarante do Maranhão' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1132, 'Anajatuba' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1133, 'Anapurus', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1134, 'Apicum-Açu', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1135, 'Araguanã', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1136, 'Araioses', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1137, 'Arame', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1138, 'Arari', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1139, 'Axixá', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1140, 'Bacabal' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1141, 'Bacabeira' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1142, 'Bacuri', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1143, 'Bacurituba', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1144, 'Balsas', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1145, 'Barão de Grajaú', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1146, 'Barra do Corda' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1147, 'Barreirinhas', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1148, 'Bela Vista do Maranhão' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1149, 'Belágua' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1150, 'Benedito Leite' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1151, 'Bequimão', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1152, 'Bernardo do Mearim', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1153, 'Boa Vista do Gurupi', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1154, 'Bom Jardim', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1155, 'Bom Jesus das Selvas' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1156, 'Bom Lugar' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1157, 'Brejo', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1158, 'Brejo de Areia' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1159, 'Buriti', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1160, 'Buriti Bravo', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1161, 'Buriticupu', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1162, 'Buritirana', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1163, 'Cachoeira Grande' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1164, 'Cajapió' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1165, 'Cajari', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1166, 'Campestre do Maranhão', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1167, 'Cândido Mendes' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1168, 'Cantanhede', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1169, 'Capinzal do Norte', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1170, 'Carolina', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1171, 'Carutapera', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1172, 'Caxias', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1173, 'Cedral', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1174, 'Central do Maranhão', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1175, 'Centro do Guilherme', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1176, 'Centro Novo do Maranhão', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1177, 'Chapadinha', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1178, 'Cidelândia', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1179, 'Codó' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1180, 'Coelho Neto' , 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1181, 'Colinas' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1182, 'Conceição do Lago-Açu', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1183, 'Coroatá' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1184, 'Cururupu', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1185, 'Davinópolis' , 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1186, 'Dom Pedro' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1187, 'Duque Bacelar', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1188, 'Esperantinópolis' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1189, 'Estreito', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1190, 'Feira Nova do Maranhão' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1191, 'Fernando Falcão', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1192, 'Formosa da Serra Negra' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1193, 'Fortaleza dos Nogueiras', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1194, 'Fortuna' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1195, 'Godofredo Viana', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1196, 'Gonçalves Dias' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1197, 'Governador Archer', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1198, 'Governador Edison Lobão', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1199, 'Governador Eugênio Barros', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1200, 'Governador Luiz Rocha', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1201, 'Governador Newton Bello', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1202, 'Governador Nunes Freire', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1203, 'Graça Aranha', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1204, 'Grajaú', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1205, 'Guimarães' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1206, 'Humberto de Campos', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1207, 'Icatu', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1208, 'Igarapé do Meio', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1209, 'Igarapé Grande' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1210, 'Imperatriz', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1211, 'Itaipava do Grajaú', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1212, 'Itapecuru Mirim', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1213, 'Itinga do Maranhão', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1214, 'Jatobá', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1215, 'Jenipapo dos Vieiras' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1216, 'João Lisboa' , 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1217, 'Joselândia', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1218, 'Junco do Maranhão', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1219, 'Lago da Pedra', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1220, 'Lago do Junco', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1221, 'Lago dos Rodrigues', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1222, 'Lago Verde', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1223, 'Lagoa do Mato', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1224, 'Lagoa Grande do Maranhão' , 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1225, 'Lajeado Novo', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1226, 'Lima Campos' , 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1227, 'Loreto', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1228, 'Luís Domingues' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1229, 'Magalhães de Almeida' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1230, 'Maracaçumé', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1231, 'Marajá do Sena' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1232, 'Maranhãozinho', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1233, 'Mata Roma' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1234, 'Matinha' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1235, 'Matões', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1236, 'Matões do Norte', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1237, 'Milagres do Maranhão' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1238, 'Mirador' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1239, 'Miranda do Norte' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1240, 'Mirinzal', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1241, 'Monção', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1242, 'Montes Altos', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1243, 'Morros', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1244, 'Nina Rodrigues' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1245, 'Nova Colinas', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1246, 'Nova Iorque' , 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1247, 'Nova Olinda do Maranhão', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1248, 'Olho d`Água das Cunhãs' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1249, 'Olinda Nova do Maranhão', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1250, 'Paço do Lumiar' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1251, 'Palmeirândia', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1252, 'Paraibano' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1253, 'Parnarama' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1254, 'Passagem Franca', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1255, 'Pastos Bons' , 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1256, 'Paulino Neves', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1257, 'Paulo Ramos' , 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1258, 'Pedreiras' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1259, 'Pedro do Rosário' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1260, 'Penalva' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1261, 'Peri Mirim', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1262, 'Peritoró', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1263, 'Pindaré-Mirim', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1264, 'Pinheiro', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1265, 'Pio XII' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1266, 'Pirapemas' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1267, 'Poção de Pedras', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1268, 'Porto Franco', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1269, 'Porto Rico do Maranhão' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1270, 'Presidente Dutra' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1271, 'Presidente Juscelino' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1272, 'Presidente Médici', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1273, 'Presidente Sarney', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1274, 'Presidente Vargas', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1275, 'Primeira Cruz', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1276, 'Raposa', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1277, 'Riachão' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1278, 'Ribamar Fiquene', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1279, 'Rosário' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1280, 'Sambaíba', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1281, 'Santa Filomena do Maranhão', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1282, 'Santa Helena', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1283, 'Santa Inês', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1284, 'Santa Luzia' , 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1285, 'Santa Luzia do Paruá' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1286, 'Santa Quitéria do Maranhão', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1287, 'Santa Rita', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1288, 'Santana do Maranhão', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1289, 'Santo Amaro do Maranhão', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1290, 'Santo Antônio dos Lopes', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1291, 'São Benedito do Rio Preto', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1292, 'São Bento' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1293, 'São Bernardo', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1294, 'São Domingos do Azeitão', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1295, 'São Domingos do Maranhão' , 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1296, 'São Félix de Balsas', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1297, 'São Francisco do Brejão', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1298, 'São Francisco do Maranhão', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1299, 'São João Batista' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1300, 'São João do Carú' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1301, 'São João do Paraíso', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1302, 'São João do Soter', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1303, 'São João dos Patos', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1304, 'São José de Ribamar', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1305, 'São José dos Basílios', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1306, 'São Luís', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1307, 'São Luís Gonzaga do Maranhão', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1308, 'São Mateus do Maranhão' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1309, 'São Pedro da Água Branca' , 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1310, 'São Pedro dos Crentes', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1311, 'São Raimundo das Mangabeiras', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1312, 'São Raimundo do Doca Bezerra', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1313, 'São Roberto' , 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1314, 'São Vicente Ferrer', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1315, 'Satubinha' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1316, 'Senador Alexandre Costa', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1317, 'Senador La Rocque', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1318, 'Serrano do Maranhão', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1319, 'Sítio Novo', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1320, 'Sucupira do Norte', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1321, 'Sucupira do Riachão', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1322, 'Tasso Fragoso', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1323, 'Timbiras', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1324, 'Timon', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1325, 'Trizidela do Vale', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1326, 'Tufilândia', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1327, 'Tuntum', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1328, 'Turiaçu' , 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1329, 'Turilândia', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1330, 'Tutóia', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1331, 'Urbano Santos', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1332, 'Vargem Grande', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1333, 'Viana', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1334, 'Vila Nova dos Martírios', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1335, 'Vitória do Mearim', 15);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1336, 'Vitorino Freire', 15 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1337, 'Zé Doca' , 15);

INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1338, 'Acorizal', 16 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1339, 'Água Boa', 16 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1340, 'Alta Floresta', 16 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1341, 'Alto Araguaia', 16 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1342, 'Alto Boa Vista' , 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1343, 'Alto Garças' , 16 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1344, 'Alto Paraguai', 16 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1345, 'Alto Taquari', 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1346, 'Apiacás' , 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1347, 'Araguaiana', 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1348, 'Araguainha', 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1349, 'Araputanga', 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1350, 'Arenápolis', 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1351, 'Aripuanã', 16 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1352, 'Barão de Melgaço' , 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1353, 'Barra do Bugres', 16 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1354, 'Barra do Garças', 16 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1355, 'Brasnorte' , 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1356, 'Cáceres' , 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1357, 'Campinápolis', 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1358, 'Campo Novo do Parecis', 16 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1359, 'Campo Verde' , 16 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1360, 'Campos de Júlio', 16 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1361, 'Canabrava do Norte', 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1362, 'Canarana', 16 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1363, 'Carlinda', 16 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1364, 'Castanheira' , 16 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1365, 'Chapada dos Guimarães', 16 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1366, 'Cláudia' , 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1367, 'Cocalinho' , 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1368, 'Colíder' , 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1369, 'Comodoro', 16 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1370, 'Confresa', 16 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1371, 'Cotriguaçu', 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1372, 'Cuiabá', 16 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1373, 'Denise', 16 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1374, 'Diamantino', 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1375, 'Dom Aquino', 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1376, 'Feliz Natal' , 16 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1377, 'Figueirópolis d`Oeste', 16 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1378, 'Gaúcha do Norte', 16 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1379, 'General Carneiro' , 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1380, 'Glória d`Oeste' , 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1381, 'Guarantã do Norte', 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1382, 'Guiratinga', 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1383, 'Indiavaí', 16 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1384, 'Itaúba', 16 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1385, 'Itiquira', 16 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1386, 'Jaciara' , 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1387, 'Jangada' , 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1388, 'Jauru', 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1389, 'Juara', 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1390, 'Juína', 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1391, 'Juruena' , 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1392, 'Juscimeira', 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1393, 'Lambari d`Oeste', 16 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1394, 'Lucas do Rio Verde', 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1395, 'Luciára' , 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1396, 'Marcelândia' , 16 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1397, 'Matupá', 16 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1398, 'Mirassol d`Oeste' , 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1399, 'Nobres', 16 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1400, 'Nortelândia' , 16 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1401, 'Nossa Senhora do Livramento' , 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1402, 'Nova Bandeirantes', 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1403, 'Nova Brasilândia' , 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1404, 'Nova Canaã do Norte', 16 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1405, 'Nova Guarita', 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1406, 'Nova Lacerda', 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1407, 'Nova Marilândia', 16 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1408, 'Nova Maringá', 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1409, 'Nova Monte Verde' , 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1410, 'Nova Mutum', 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1411, 'Nova Olímpia', 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1412, 'Nova Ubiratã', 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1413, 'Nova Xavantina' , 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1414, 'Novo Horizonte do Norte', 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1415, 'Novo Mundo', 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1416, 'Novo São Joaquim' , 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1417, 'Paranaíta' , 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1418, 'Paranatinga' , 16 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1419, 'Pedra Preta' , 16 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1420, 'Peixoto de Azevedo', 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1421, 'Planalto da Serra', 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1422, 'Poconé', 16 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1423, 'Pontal do Araguaia', 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1424, 'Ponte Branca', 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1425, 'Pontes e Lacerda' , 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1426, 'Porto Alegre do Norte', 16 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1427, 'Porto dos Gaúchos', 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1428, 'Porto Esperidião' , 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1429, 'Porto Estrela', 16 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1430, 'Poxoréo' , 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1431, 'Primavera do Leste', 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1432, 'Querência' , 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1433, 'Reserva do Cabaçal', 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1434, 'Ribeirão Cascalheira' , 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1435, 'Ribeirãozinho', 16 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1436, 'Rio Branco', 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1437, 'Rondonópolis', 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1438, 'Rosário Oeste', 16 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1439, 'Salto do Céu', 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1440, 'Santa Carmem', 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1441, 'Santa Terezinha', 16 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1442, 'Santo Afonso', 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1443, 'Santo Antônio do Leverger', 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1444, 'São Félix do Araguaia', 16 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1445, 'São José do Povo' , 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1446, 'São José do Rio Claro', 16 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1447, 'São José do Xingu', 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1448, 'São José dos Quatro Marcos', 16 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1449, 'São Pedro da Cipa', 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1450, 'Sapezal' , 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1451, 'Sinop', 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1452, 'Sorriso' , 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1453, 'Tabaporã', 16 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1454, 'Tangará da Serra' , 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1455, 'Tapurah' , 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1456, 'Terra Nova do Norte', 16 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1457, 'Tesouro' , 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1458, 'Torixoréu' , 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1459, 'União do Sul', 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1460, 'Várzea Grande', 16 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1461, 'Vera' , 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1462, 'Vila Bela da Santíssima Trindade' , 16);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1463, 'Vila Rica' , 16);

INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1464, 'Água Clara', 17);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1465, 'Alcinópolis' , 17 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1466, 'Amambaí' , 17);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1467, 'Anastácio' , 17);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1468, 'Anaurilândia', 17);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1469, 'Angélica', 17 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1470, 'Antônio João', 17);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1471, 'Aparecida do Taboado' , 17);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1472, 'Aquidauana', 17);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1473, 'Aral Moreira', 17);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1474, 'Bandeirantes', 17);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1475, 'Bataguassu', 17);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1476, 'Bataiporã' , 17);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1477, 'Bela Vista', 17);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1478, 'Bodoquena' , 17);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1479, 'Bonito', 17 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1480, 'Brasilândia' , 17 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1481, 'Caarapó' , 17);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1482, 'Camapuã' , 17);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1483, 'Campo Grande', 17);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1484, 'Caracol' , 17);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1485, 'Cassilândia' , 17 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1486, 'Chapadão do Sul', 17 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1487, 'Corguinho' , 17);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1488, 'Coronel Sapucaia' , 17);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1489, 'Corumbá' , 17);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1490, 'Costa Rica', 17);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1491, 'Coxim', 17);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1492, 'Deodápolis', 17);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1493, 'Dois Irmãos do Buriti', 17 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1494, 'Douradina' , 17);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1495, 'Dourados', 17 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1496, 'Eldorado', 17 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1497, 'Fátima do Sul', 17 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1498, 'Glória de Dourados', 17);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1499, 'Guia Lopes da Laguna' , 17);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1500, 'Iguatemi', 17 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1501, 'Inocência' , 17);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1502, 'Itaporã' , 17);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1503, 'Itaquiraí' , 17);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1504, 'Ivinhema', 17 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1505, 'Japorã', 17 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1506, 'Jaraguari' , 17);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1507, 'Jardim', 17 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1508, 'Jateí', 17);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1509, 'Juti' , 17);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1510, 'Ladário' , 17);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1511, 'Laguna Carapã', 17 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1512, 'Maracaju', 17 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1513, 'Miranda' , 17);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1514, 'Mundo Novo', 17);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1515, 'Naviraí' , 17);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1516, 'Nioaque' , 17);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1517, 'Nova Alvorada do Sul' , 17);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1518, 'Nova Andradina' , 17);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1519, 'Novo Horizonte do Sul', 17 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1520, 'Paranaíba' , 17);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1521, 'Paranhos', 17 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1522, 'Pedro Gomes' , 17 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1523, 'Ponta Porã', 17);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1524, 'Porto Murtinho' , 17);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1525, 'Ribas do Rio Pardo', 17);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1526, 'Rio Brilhante', 17 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1527, 'Rio Negro' , 17);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1528, 'Rio Verde de Mato Grosso' , 17 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1529, 'Rochedo' , 17);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1530, 'Santa Rita do Pardo', 17 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1531, 'São Gabriel do Oeste' , 17);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1532, 'Selvíria', 17 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1533, 'Sete Quedas' , 17 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1534, 'Sidrolândia' , 17 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1535, 'Sonora', 17 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1536, 'Tacuru', 17 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1537, 'Taquarussu', 17);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1538, 'Terenos' , 17);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1539, 'Três Lagoas' , 17 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1540, 'Vicentina' , 17);

INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1541, 'Abadia dos Dourados', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1542, 'Abaeté', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1543, 'Abre Campo', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1544, 'Acaiaca' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1545, 'Açucena' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1546, 'Água Boa', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1547, 'Água Comprida', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1548, 'Aguanil' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1549, 'Águas Formosas' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1550, 'Águas Vermelhas', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1551, 'Aimorés' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1552, 'Aiuruoca', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1553, 'Alagoa', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1554, 'Albertina' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1555, 'Além Paraíba', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1556, 'Alfenas' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1557, 'Alfredo Vasconcelos', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1558, 'Almenara', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1559, 'Alpercata' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1560, 'Alpinópolis' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1561, 'Alterosa', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1562, 'Alto Caparaó', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1563, 'Alto Jequitibá' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1564, 'Alto Rio Doce', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1565, 'Alvarenga' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1566, 'Alvinópolis' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1567, 'Alvorada de Minas', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1568, 'Amparo do Serra', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1569, 'Andradas', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1570, 'Andrelândia' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1571, 'Angelândia', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1572, 'Antônio Carlos' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1573, 'Antônio Dias', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1574, 'Antônio Prado de Minas' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1575, 'Araçaí', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1576, 'Aracitaba' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1577, 'Araçuaí' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1578, 'Araguari', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1579, 'Arantina', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1580, 'Araponga', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1581, 'Araporã' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1582, 'Arapuá', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1583, 'Araújos' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1584, 'Araxá', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1585, 'Arceburgo' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1586, 'Arcos', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1587, 'Areado', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1588, 'Argirita', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1589, 'Aricanduva', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1590, 'Arinos', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1591, 'Astolfo Dutra', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1592, 'Ataléia' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1593, 'Augusto de Lima', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1594, 'Baependi', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1595, 'Baldim', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1596, 'Bambuí', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1597, 'Bandeira', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1598, 'Bandeira do Sul', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1599, 'Barão de Cocais', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1600, 'Barão de Monte Alto', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1601, 'Barbacena' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1602, 'Barra Longa' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1603, 'Barroso' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1604, 'Bela Vista de Minas', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1605, 'Belmiro Braga', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1606, 'Belo Horizonte' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1607, 'Belo Oriente', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1608, 'Belo Vale' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1609, 'Berilo', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1610, 'Berizal' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1611, 'Bertópolis', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1612, 'Betim', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1613, 'Bias Fortes' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1614, 'Bicas', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1615, 'Biquinhas' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1616, 'Boa Esperança', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1617, 'Bocaina de Minas' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1618, 'Bocaiúva', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1619, 'Bom Despacho', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1620, 'Bom Jardim de Minas', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1621, 'Bom Jesus da Penha', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1622, 'Bom Jesus do Amparo', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1623, 'Bom Jesus do Galho', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1624, 'Bom Repouso' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1625, 'Bom Sucesso' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1626, 'Bonfim', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1627, 'Bonfinópolis de Minas', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1628, 'Bonito de Minas', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1629, 'Borda da Mata', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1630, 'Botelhos', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1631, 'Botumirim' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1632, 'Brás Pires', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1633, 'Brasilândia de Minas' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1634, 'Brasília de Minas', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1635, 'Brasópolis', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1636, 'Braúnas' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1637, 'Brumadinho', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1638, 'Bueno Brandão', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1639, 'Buenópolis', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1640, 'Bugre', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1641, 'Buritis' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1642, 'Buritizeiro' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1643, 'Cabeceira Grande' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1644, 'Cabo Verde', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1645, 'Cachoeira da Prata', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1646, 'Cachoeira de Minas', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1647, 'Cachoeira de Pajeú', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1648, 'Cachoeira Dourada', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1649, 'Caetanópolis', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1650, 'Caeté', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1651, 'Caiana', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1652, 'Cajuri', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1653, 'Caldas', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1654, 'Camacho' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1655, 'Camanducaia' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1656, 'Cambuí', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1657, 'Cambuquira', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1658, 'Campanário', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1659, 'Campanha', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1660, 'Campestre' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1661, 'Campina Verde', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1662, 'Campo Azul', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1663, 'Campo Belo', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1664, 'Campo do Meio', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1665, 'Campo Florido', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1666, 'Campos Altos', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1667, 'Campos Gerais', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1668, 'Cana Verde', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1669, 'Canaã', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1670, 'Canápolis' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1671, 'Candeias', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1672, 'Cantagalo' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1673, 'Caparaó' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1674, 'Capela Nova' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1675, 'Capelinha' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1676, 'Capetinga' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1677, 'Capim Branco', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1678, 'Capinópolis' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1679, 'Capitão Andrade', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1680, 'Capitão Enéas', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1681, 'Capitólio' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1682, 'Caputira', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1683, 'Caraí', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1684, 'Caranaíba' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1685, 'Carandaí', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1686, 'Carangola' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1687, 'Caratinga' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1688, 'Carbonita' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1689, 'Careaçu' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1690, 'Carlos Chagas', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1691, 'Carmésia', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1692, 'Carmo da Cachoeira', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1693, 'Carmo da Mata', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1694, 'Carmo de Minas' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1695, 'Carmo do Cajuru', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1696, 'Carmo do Paranaíba', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1697, 'Carmo do Rio Claro', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1698, 'Carmópolis de Minas', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1699, 'Carneirinho' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1700, 'Carrancas' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1701, 'Carvalhópolis', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1702, 'Carvalhos' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1703, 'Casa Grande' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1704, 'Cascalho Rico', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1705, 'Cássia', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1706, 'Cataguases', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1707, 'Catas Altas' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1708, 'Catas Altas da Noruega' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1709, 'Catuji', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1710, 'Catuti', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1711, 'Caxambu' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1712, 'Cedro do Abaeté', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1713, 'Central de Minas' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1714, 'Centralina', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1715, 'Chácara' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1716, 'Chalé', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1717, 'Chapada do Norte' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1718, 'Chapada Gaúcha' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1719, 'Chiador' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1720, 'Cipotânea' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1721, 'Claraval', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1722, 'Claro dos Poções' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1723, 'Cláudio' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1724, 'Coimbra' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1725, 'Coluna', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1726, 'Comendador Gomes' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1727, 'Comercinho', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1728, 'Conceição da Aparecida' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1729, 'Conceição da Barra de Minas' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1730, 'Conceição das Alagoas', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1731, 'Conceição das Pedras' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1732, 'Conceição de Ipanema' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1733, 'Conceição do Mato Dentro' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1734, 'Conceição do Pará', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1735, 'Conceição do Rio Verde' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1736, 'Conceição dos Ouros', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1737, 'Cônego Marinho' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1738, 'Confins' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1739, 'Congonhal' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1740, 'Congonhas' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1741, 'Congonhas do Norte', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1742, 'Conquista' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1743, 'Conselheiro Lafaiete' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1744, 'Conselheiro Pena' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1745, 'Consolação', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1746, 'Contagem', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1747, 'Coqueiral' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1748, 'Coração de Jesus' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1749, 'Cordisburgo' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1750, 'Cordislândia', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1751, 'Corinto' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1752, 'Coroaci' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1753, 'Coromandel', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1754, 'Coronel Fabriciano', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1755, 'Coronel Murta', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1756, 'Coronel Pacheco', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1757, 'Coronel Xavier Chaves', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1758, 'Córrego Danta', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1759, 'Córrego do Bom Jesus' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1760, 'Córrego Fundo', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1761, 'Córrego Novo', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1762, 'Couto de Magalhães de Minas' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1763, 'Crisólita' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1764, 'Cristais', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1765, 'Cristália' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1766, 'Cristiano Otoni', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1767, 'Cristina', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1768, 'Crucilândia' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1769, 'Cruzeiro da Fortaleza', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1770, 'Cruzília', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1771, 'Cuparaque' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1772, 'Curral de Dentro' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1773, 'Curvelo' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1774, 'Datas', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1775, 'Delfim Moreira' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1776, 'Delfinópolis', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1777, 'Delta', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1778, 'Descoberto', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1779, 'Desterro de Entre Rios' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1780, 'Desterro do Melo' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1781, 'Diamantina', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1782, 'Diogo de Vasconcelos' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1783, 'Dionísio', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1784, 'Divinésia' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1785, 'Divino', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1786, 'Divino das Laranjeiras' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1787, 'Divinolândia de Minas', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1788, 'Divinópolis' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1789, 'Divisa Alegre', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1790, 'Divisa Nova' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1791, 'Divisópolis' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1792, 'Dom Bosco' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1793, 'Dom Cavati', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1794, 'Dom Joaquim' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1795, 'Dom Silvério', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1796, 'Dom Viçoso', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1797, 'Dona Eusébia', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1798, 'Dores de Campos', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1799, 'Dores de Guanhães', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1800, 'Dores do Indaiá', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1801, 'Dores do Turvo' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1802, 'Doresópolis' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1803, 'Douradoquara', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1804, 'Durandé' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1805, 'Elói Mendes' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1806, 'Engenheiro Caldas', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1807, 'Engenheiro Navarro', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1808, 'Entre Folhas', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1809, 'Entre Rios de Minas', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1810, 'Ervália' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1811, 'Esmeraldas', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1812, 'Espera Feliz', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1813, 'Espinosa', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1814, 'Espírito Santo do Dourado', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1815, 'Estiva', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1816, 'Estrela Dalva', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1817, 'Estrela do Indaiá', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1818, 'Estrela do Sul' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1819, 'Eugenópolis' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1820, 'Ewbank da Câmara' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1821, 'Extrema' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1822, 'Fama' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1823, 'Faria Lemos' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1824, 'Felício dos Santos', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1825, 'Felisburgo', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1826, 'Felixlândia' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1827, 'Fernandes Tourinho', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1828, 'Ferros', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1829, 'Fervedouro', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1830, 'Florestal' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1831, 'Formiga' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1832, 'Formoso' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1833, 'Fortaleza de Minas', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1834, 'Fortuna de Minas' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1835, 'Francisco Badaró' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1836, 'Francisco Dumont' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1837, 'Francisco Sá', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1838, 'Franciscópolis' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1839, 'Frei Gaspar' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1840, 'Frei Inocêncio' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1841, 'Frei Lagonegro' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1842, 'Fronteira' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1843, 'Fronteira dos Vales', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1844, 'Fruta de Leite' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1845, 'Frutal', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1846, 'Funilândia', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1847, 'Galiléia', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1848, 'Gameleiras', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1849, 'Glaucilândia', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1850, 'Goiabeira' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1851, 'Goianá', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1852, 'Gonçalves' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1853, 'Gonzaga' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1854, 'Gouveia' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1855, 'Governador Valadares' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1856, 'Grão Mogol', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1857, 'Grupiara', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1858, 'Guanhães', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1859, 'Guapé', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1860, 'Guaraciaba', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1861, 'Guaraciama', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1862, 'Guaranésia', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1863, 'Guarani' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1864, 'Guarará' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1865, 'Guarda-Mor', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1866, 'Guaxupé' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1867, 'Guidoval', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1868, 'Guimarânia', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1869, 'Guiricema' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1870, 'Gurinhatã' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1871, 'Heliodora' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1872, 'Iapu' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1873, 'Ibertioga' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1874, 'Ibiá' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1875, 'Ibiaí', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1876, 'Ibiracatu' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1877, 'Ibiraci' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1878, 'Ibirité' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1879, 'Ibitiúra de Minas', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1880, 'Ibituruna' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1881, 'Icaraí de Minas', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1882, 'Igarapé' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1883, 'Igaratinga', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1884, 'Iguatama', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1885, 'Ijaci', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1886, 'Ilicínea', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1887, 'Imbé de Minas', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1888, 'Inconfidentes', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1889, 'Indaiabira', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1890, 'Indianópolis', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1891, 'Ingaí', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1892, 'Inhapim' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1893, 'Inhaúma' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1894, 'Inimutaba' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1895, 'Ipaba', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1896, 'Ipanema' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1897, 'Ipatinga', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1898, 'Ipiaçu', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1899, 'Ipuiúna' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1900, 'Iraí de Minas', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1901, 'Itabira' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1902, 'Itabirinha de Mantena', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1903, 'Itabirito' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1904, 'Itacambira', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1905, 'Itacarambi', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1906, 'Itaguara', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1907, 'Itaipé', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1908, 'Itajubá' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1909, 'Itamarandiba', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1910, 'Itamarati de Minas', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1911, 'Itambacuri', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1912, 'Itambé do Mato Dentro', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1913, 'Itamogi' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1914, 'Itamonte', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1915, 'Itanhandu' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1916, 'Itanhomi', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1917, 'Itaobim' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1918, 'Itapagipe' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1919, 'Itapecerica' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1920, 'Itapeva' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1921, 'Itatiaiuçu', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1922, 'Itaú de Minas', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1923, 'Itaúna', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1924, 'Itaverava' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1925, 'Itinga', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1926, 'Itueta', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1927, 'Ituiutaba' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1928, 'Itumirim', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1929, 'Iturama' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1930, 'Itutinga', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1931, 'Jaboticatubas', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1932, 'Jacinto' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1933, 'Jacuí', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1934, 'Jacutinga' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1935, 'Jaguaraçu' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1936, 'Jaíba', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1937, 'Jampruca', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1938, 'Janaúba' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1939, 'Januária', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1940, 'Japaraíba' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1941, 'Japonvar', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1942, 'Jeceaba' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1943, 'Jenipapo de Minas', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1944, 'Jequeri' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1945, 'Jequitaí', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1946, 'Jequitibá' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1947, 'Jequitinhonha', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1948, 'Jesuânia', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1949, 'Joaíma', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1950, 'Joanésia', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1951, 'João Monlevade' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1952, 'João Pinheiro', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1953, 'Joaquim Felício', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1954, 'Jordânia', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1955, 'José Gonçalves de Minas', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1956, 'José Raydan' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1957, 'Josenópolis' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1958, 'Juatuba' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1959, 'Juiz de Fora', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1960, 'Juramento' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1961, 'Juruaia' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1962, 'Juvenília' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1963, 'Ladainha', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1964, 'Lagamar' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1965, 'Lagoa da Prata' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1966, 'Lagoa dos Patos', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1967, 'Lagoa Dourada', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1968, 'Lagoa Formosa', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1969, 'Lagoa Grande', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1970, 'Lagoa Santa' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1971, 'Lajinha' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1972, 'Lambari' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1973, 'Lamim', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1974, 'Laranjal', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1975, 'Lassance', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1976, 'Lavras', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1977, 'Leandro Ferreira' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1978, 'Leme do Prado', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1979, 'Leopoldina', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1980, 'Liberdade' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1981, 'Lima Duarte' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1982, 'Limeira do Oeste' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1983, 'Lontra', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1984, 'Luisburgo' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1985, 'Luislândia', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1986, 'Luminárias', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1987, 'Luz', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1988, 'Machacalis', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1989, 'Machado' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1990, 'Madre de Deus de Minas' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1991, 'Malacacheta' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1992, 'Mamonas' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1993, 'Manga', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1994, 'Manhuaçu', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1995, 'Manhumirim', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1996, 'Mantena' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1997, 'Mar de Espanha' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1998, 'Maravilhas', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (1999, 'Maria da Fé' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2000, 'Mariana' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2001, 'Marilac' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2002, 'Mário Campos', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2003, 'Maripá de Minas', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2004, 'Marliéria' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2005, 'Marmelópolis', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2006, 'Martinho Campos', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2007, 'Martins Soares' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2008, 'Mata Verde', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2009, 'Materlândia' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2010, 'Mateus Leme' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2011, 'Mathias Lobato' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2012, 'Matias Barbosa' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2013, 'Matias Cardoso' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2014, 'Matipó', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2015, 'Mato Verde', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2016, 'Matozinhos', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2017, 'Matutina', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2018, 'Medeiros', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2019, 'Medina', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2020, 'Mendes Pimentel', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2021, 'Mercês', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2022, 'Mesquita', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2023, 'Minas Novas' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2024, 'Minduri' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2025, 'Mirabela', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2026, 'Miradouro' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2027, 'Miraí', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2028, 'Miravânia' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2029, 'Moeda', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2030, 'Moema', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2031, 'Monjolos', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2032, 'Monsenhor Paulo', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2033, 'Montalvânia' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2034, 'Monte Alegre de Minas', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2035, 'Monte Azul', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2036, 'Monte Belo', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2037, 'Monte Carmelo', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2038, 'Monte Formoso', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2039, 'Monte Santo de Minas' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2040, 'Monte Sião', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2041, 'Montes Claros', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2042, 'Montezuma' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2043, 'Morada Nova de Minas' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2044, 'Morro da Garça' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2045, 'Morro do Pilar' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2046, 'Munhoz', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2047, 'Muriaé', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2048, 'Mutum', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2049, 'Muzambinho', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2050, 'Nacip Raydan', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2051, 'Nanuque' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2052, 'Naque', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2053, 'Natalândia', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2054, 'Natércia', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2055, 'Nazareno', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2056, 'Nepomuceno', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2057, 'Ninheira', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2058, 'Nova Belém', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2059, 'Nova Era', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2060, 'Nova Lima' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2061, 'Nova Módica' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2062, 'Nova Ponte', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2063, 'Nova Porteirinha' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2064, 'Nova Resende', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2065, 'Nova Serrana', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2066, 'Nova União', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2067, 'Novo Cruzeiro', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2068, 'Novo Oriente de Minas', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2069, 'Novorizonte' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2070, 'Olaria', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2071, 'Olhos-d`Água', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2072, 'Olímpio Noronha', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2073, 'Oliveira', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2074, 'Oliveira Fortes', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2075, 'Onça de Pitangui' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2076, 'Oratórios' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2077, 'Orizânia', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2078, 'Ouro Branco' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2079, 'Ouro Fino' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2080, 'Ouro Preto', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2081, 'Ouro Verde de Minas', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2082, 'Padre Carvalho' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2083, 'Padre Paraíso', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2084, 'Pai Pedro' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2085, 'Paineiras' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2086, 'Pains', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2087, 'Paiva', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2088, 'Palma', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2089, 'Palmópolis', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2090, 'Papagaios' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2091, 'Pará de Minas', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2092, 'Paracatu', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2093, 'Paraguaçu' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2094, 'Paraisópolis', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2095, 'Paraopeba' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2096, 'Passa Quatro', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2097, 'Passa Tempo' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2098, 'Passa-Vinte' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2099, 'Passabém', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2100, 'Passos', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2101, 'Patis', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2102, 'Patos de Minas' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2103, 'Patrocínio', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2104, 'Patrocínio do Muriaé' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2105, 'Paula Cândido', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2106, 'Paulistas' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2107, 'Pavão', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2108, 'Peçanha' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2109, 'Pedra Azul', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2110, 'Pedra Bonita', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2111, 'Pedra do Anta', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2112, 'Pedra do Indaiá', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2113, 'Pedra Dourada', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2114, 'Pedralva', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2115, 'Pedras de Maria da Cruz', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2116, 'Pedrinópolis', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2117, 'Pedro Leopoldo' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2118, 'Pedro Teixeira' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2119, 'Pequeri' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2120, 'Pequi', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2121, 'Perdigão', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2122, 'Perdizes', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2123, 'Perdões' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2124, 'Periquito' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2125, 'Pescador', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2126, 'Piau' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2127, 'Piedade de Caratinga' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2128, 'Piedade de Ponte Nova', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2129, 'Piedade do Rio Grande', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2130, 'Piedade dos Gerais', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2131, 'Pimenta' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2132, 'Pingo-d`Água', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2133, 'Pintópolis', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2134, 'Piracema', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2135, 'Pirajuba', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2136, 'Piranga' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2137, 'Piranguçu' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2138, 'Piranguinho' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2139, 'Pirapetinga' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2140, 'Pirapora', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2141, 'Piraúba' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2142, 'Pitangui', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2143, 'Piumhi', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2144, 'Planura' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2145, 'Poço Fundo', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2146, 'Poços de Caldas', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2147, 'Pocrane' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2148, 'Pompéu', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2149, 'Ponte Nova', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2150, 'Ponto Chique', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2151, 'Ponto dos Volantes', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2152, 'Porteirinha' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2153, 'Porto Firme' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2154, 'Poté' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2155, 'Pouso Alegre', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2156, 'Pouso Alto', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2157, 'Prados', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2158, 'Prata', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2159, 'Pratápolis', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2160, 'Pratinha', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2161, 'Presidente Bernardes' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2162, 'Presidente Juscelino' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2163, 'Presidente Kubitschek', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2164, 'Presidente Olegário', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2165, 'Prudente de Morais', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2166, 'Quartel Geral', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2167, 'Queluzito' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2168, 'Raposos' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2169, 'Raul Soares' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2170, 'Recreio' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2171, 'Reduto', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2172, 'Resende Costa', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2173, 'Resplendor', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2174, 'Ressaquinha' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2175, 'Riachinho' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2176, 'Riacho dos Machados', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2177, 'Ribeirão das Neves', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2178, 'Ribeirão Vermelho', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2179, 'Rio Acima' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2180, 'Rio Casca' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2181, 'Rio do Prado', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2182, 'Rio Doce', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2183, 'Rio Espera', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2184, 'Rio Manso' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2185, 'Rio Novo', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2186, 'Rio Paranaíba', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2187, 'Rio Pardo de Minas', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2188, 'Rio Piracicaba' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2189, 'Rio Pomba' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2190, 'Rio Preto' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2191, 'Rio Vermelho', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2192, 'Ritápolis' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2193, 'Rochedo de Minas' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2194, 'Rodeiro' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2195, 'Romaria' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2196, 'Rosário da Limeira', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2197, 'Rubelita', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2198, 'Rubim', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2199, 'Sabará', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2200, 'Sabinópolis' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2201, 'Sacramento', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2202, 'Salinas' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2203, 'Salto da Divisa', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2204, 'Santa Bárbara', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2205, 'Santa Bárbara do Leste' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2206, 'Santa Bárbara do Monte Verde', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2207, 'Santa Bárbara do Tugúrio' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2208, 'Santa Cruz de Minas', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2209, 'Santa Cruz de Salinas', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2210, 'Santa Cruz do Escalvado', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2211, 'Santa Efigênia de Minas', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2212, 'Santa Fé de Minas', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2213, 'Santa Helena de Minas', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2214, 'Santa Juliana', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2215, 'Santa Luzia' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2216, 'Santa Margarida', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2217, 'Santa Maria de Itabira' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2218, 'Santa Maria do Salto' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2219, 'Santa Maria do Suaçuí', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2220, 'Santa Rita de Caldas' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2221, 'Santa Rita de Ibitipoca', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2222, 'Santa Rita de Jacutinga', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2223, 'Santa Rita de Minas', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2224, 'Santa Rita do Itueto' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2225, 'Santa Rita do Sapucaí', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2226, 'Santa Rosa da Serra', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2227, 'Santa Vitória', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2228, 'Santana da Vargem', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2229, 'Santana de Cataguases', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2230, 'Santana de Pirapama', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2231, 'Santana do Deserto', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2232, 'Santana do Garambéu', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2233, 'Santana do Jacaré', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2234, 'Santana do Manhuaçu', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2235, 'Santana do Paraíso', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2236, 'Santana do Riacho', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2237, 'Santana dos Montes', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2238, 'Santo Antônio do Amparo', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2239, 'Santo Antônio do Aventureiro', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2240, 'Santo Antônio do Grama' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2241, 'Santo Antônio do Itambé', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2242, 'Santo Antônio do Jacinto' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2243, 'Santo Antônio do Monte' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2244, 'Santo Antônio do Retiro', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2245, 'Santo Antônio do Rio Abaixo' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2246, 'Santo Hipólito' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2247, 'Santos Dumont', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2248, 'São Bento Abade', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2249, 'São Brás do Suaçuí', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2250, 'São Domingos das Dores' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2251, 'São Domingos do Prata', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2252, 'São Félix de Minas', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2253, 'São Francisco', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2254, 'São Francisco de Paula' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2255, 'São Francisco de Sales' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2256, 'São Francisco do Glória', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2257, 'São Geraldo' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2258, 'São Geraldo da Piedade' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2259, 'São Geraldo do Baixio', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2260, 'São Gonçalo do Abaeté', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2261, 'São Gonçalo do Pará', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2262, 'São Gonçalo do Rio Abaixo', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2263, 'São Gonçalo do Rio Preto' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2264, 'São Gonçalo do Sapucaí' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2265, 'São Gotardo' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2266, 'São João Batista do Glória', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2267, 'São João da Lagoa', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2268, 'São João da Mata' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2269, 'São João da Ponte', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2270, 'São João das Missões' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2271, 'São João del Rei' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2272, 'São João do Manhuaçu' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2273, 'São João do Manteninha' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2274, 'São João do Oriente', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2275, 'São João do Pacuí', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2276, 'São João do Paraíso', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2277, 'São João Evangelista' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2278, 'São João Nepomuceno', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2279, 'São Joaquim de Bicas' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2280, 'São José da Barra', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2281, 'São José da Lapa' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2282, 'São José da Safira', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2283, 'São José da Varginha' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2284, 'São José do Alegre', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2285, 'São José do Divino', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2286, 'São José do Goiabal', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2287, 'São José do Jacuri', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2288, 'São José do Mantimento' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2289, 'São Lourenço', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2290, 'São Miguel do Anta', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2291, 'São Pedro da União', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2292, 'São Pedro do Suaçuí', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2293, 'São Pedro dos Ferros' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2294, 'São Romão' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2295, 'São Roque de Minas', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2296, 'São Sebastião da Bela Vista' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2297, 'São Sebastião da Vargem Alegre', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2298, 'São Sebastião do Anta', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2299, 'São Sebastião do Maranhão', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2300, 'São Sebastião do Oeste' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2301, 'São Sebastião do Paraíso' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2302, 'São Sebastião do Rio Preto', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2303, 'São Sebastião do Rio Verde', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2304, 'São Thomé das Letras' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2305, 'São Tiago' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2306, 'São Tomás de Aquino', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2307, 'São Vicente de Minas' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2308, 'Sapucaí-Mirim', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2309, 'Sardoá', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2310, 'Sarzedo' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2311, 'Sem-Peixe' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2312, 'Senador Amaral' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2313, 'Senador Cortes' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2314, 'Senador Firmino', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2315, 'Senador José Bento', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2316, 'Senador Modestino Gonçalves' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2317, 'Senhora de Oliveira', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2318, 'Senhora do Porto' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2319, 'Senhora dos Remédios' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2320, 'Sericita', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2321, 'Seritinga' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2322, 'Serra Azul de Minas', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2323, 'Serra da Saudade' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2324, 'Serra do Salitre' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2325, 'Serra dos Aimorés', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2326, 'Serrania', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2327, 'Serranópolis de Minas', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2328, 'Serranos', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2329, 'Serro', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2330, 'Sete Lagoas' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2331, 'Setubinha' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2332, 'Silveirânia' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2333, 'Silvianópolis', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2334, 'Simão Pereira', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2335, 'Simonésia' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2336, 'Sobrália', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2337, 'Soledade de Minas', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2338, 'Tabuleiro' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2339, 'Taiobeiras', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2340, 'Taparuba', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2341, 'Tapira', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2342, 'Tapiraí' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2343, 'Taquaraçu de Minas', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2344, 'Tarumirim' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2345, 'Teixeiras' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2346, 'Teófilo Otoni', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2347, 'Timóteo' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2348, 'Tiradentes', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2349, 'Tiros', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2350, 'Tocantins' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2351, 'Tocos do Moji', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2352, 'Toledo', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2353, 'Tombos', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2354, 'Três Corações', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2355, 'Três Marias' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2356, 'Três Pontas' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2357, 'Tumiritinga' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2358, 'Tupaciguara' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2359, 'Turmalina' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2360, 'Turvolândia' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2361, 'Ubá', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2362, 'Ubaí' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2363, 'Ubaporanga', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2364, 'Uberaba' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2365, 'Uberlândia', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2366, 'Umburatiba', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2367, 'Unaí' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2368, 'União de Minas' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2369, 'Uruana de Minas', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2370, 'Urucânia', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2371, 'Urucuia' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2372, 'Vargem Alegre', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2373, 'Vargem Bonita', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2374, 'Vargem Grande do Rio Pardo', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2375, 'Varginha', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2376, 'Varjão de Minas', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2377, 'Várzea da Palma', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2378, 'Varzelândia' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2379, 'Vazante' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2380, 'Verdelândia' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2381, 'Veredinha' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2382, 'Veríssimo' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2383, 'Vermelho Novo', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2384, 'Vespasiano', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2385, 'Viçosa', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2386, 'Vieiras' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2387, 'Virgem da Lapa' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2388, 'Virgínia', 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2389, 'Virginópolis', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2390, 'Virgolândia' , 06 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2391, 'Visconde do Rio Branco' , 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2392, 'Volta Grande', 06);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2393, 'Wenceslau Braz' , 06);

INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2394, 'Abaetetuba', 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2395, 'Abel Figueiredo', 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2396, 'Acará', 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2397, 'Afuá' , 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2398, 'Água Azul do Norte', 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2399, 'Alenquer', 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2400, 'Almeirim', 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2401, 'Altamira', 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2402, 'Anajás', 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2403, 'Ananindeua', 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2404, 'Anapu', 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2405, 'Augusto Corrêa' , 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2406, 'Aurora do Pará' , 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2407, 'Aveiro', 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2408, 'Bagre', 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2409, 'Baião', 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2410, 'Bannach' , 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2411, 'Barcarena' , 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2412, 'Belém', 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2413, 'Belterra', 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2414, 'Benevides' , 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2415, 'Bom Jesus do Tocantins' , 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2416, 'Bonito', 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2417, 'Bragança', 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2418, 'Brasil Novo' , 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2419, 'Brejo Grande do Araguaia' , 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2420, 'Breu Branco' , 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2421, 'Breves', 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2422, 'Bujaru', 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2423, 'Cachoeira do Arari', 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2424, 'Cachoeira do Piriá', 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2425, 'Cametá', 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2426, 'Canaã dos Carajás', 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2427, 'Capanema', 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2428, 'Capitão Poço', 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2429, 'Castanhal' , 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2430, 'Chaves', 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2431, 'Colares' , 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2432, 'Conceição do Araguaia', 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2433, 'Concórdia do Pará', 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2434, 'Cumaru do Norte', 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2435, 'Curionópolis', 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2436, 'Curralinho', 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2437, 'Curuá', 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2438, 'Curuçá', 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2439, 'Dom Eliseu', 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2440, 'Eldorado dos Carajás' , 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2441, 'Faro' , 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2442, 'Floresta do Araguaia' , 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2443, 'Garrafão do Norte', 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2444, 'Goianésia do Pará', 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2445, 'Gurupá', 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2446, 'Igarapé-Açu' , 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2447, 'Igarapé-Miri', 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2448, 'Inhangapi' , 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2449, 'Ipixuna do Pará', 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2450, 'Irituia' , 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2451, 'Itaituba', 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2452, 'Itupiranga', 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2453, 'Jacareacanga', 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2454, 'Jacundá' , 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2455, 'Juruti', 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2456, 'Limoeiro do Ajuru', 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2457, 'Mãe do Rio', 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2458, 'Magalhães Barata' , 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2459, 'Marabá', 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2460, 'Maracanã', 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2461, 'Marapanim' , 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2462, 'Marituba', 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2463, 'Medicilândia', 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2464, 'Melgaço' , 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2465, 'Mocajuba', 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2466, 'Moju' , 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2467, 'Monte Alegre', 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2468, 'Muaná', 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2469, 'Nova Esperança do Piriá', 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2470, 'Nova Ipixuna', 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2471, 'Nova Timboteua' , 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2472, 'Novo Progresso' , 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2473, 'Novo Repartimento', 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2474, 'Óbidos', 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2475, 'Oeiras do Pará' , 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2476, 'Oriximiná' , 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2477, 'Ourém', 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2478, 'Ourilândia do Norte', 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2479, 'Pacajá', 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2480, 'Palestina do Pará', 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2481, 'Paragominas' , 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2482, 'Parauapebas' , 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2483, 'Pau d`Arco', 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2484, 'Peixe-Boi' , 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2485, 'Piçarra' , 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2486, 'Placas', 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2487, 'Ponta de Pedras', 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2488, 'Portel', 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2489, 'Porto de Moz', 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2490, 'Prainha' , 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2491, 'Primavera' , 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2492, 'Quatipuru' , 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2493, 'Redenção', 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2494, 'Rio Maria' , 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2495, 'Rondon do Pará' , 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2496, 'Rurópolis' , 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2497, 'Salinópolis' , 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2498, 'Salvaterra', 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2499, 'Santa Bárbara do Pará', 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2500, 'Santa Cruz do Arari', 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2501, 'Santa Isabel do Pará' , 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2502, 'Santa Luzia do Pará', 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2503, 'Santa Maria das Barreiras', 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2504, 'Santa Maria do Pará', 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2505, 'Santana do Araguaia', 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2506, 'Santarém', 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2507, 'Santarém Novo', 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2508, 'Santo Antônio do Tauá', 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2509, 'São Caetano de Odivelas', 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2510, 'São Domingos do Araguaia' , 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2511, 'São Domingos do Capim', 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2512, 'São Félix do Xingu', 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2513, 'São Francisco do Pará', 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2514, 'São Geraldo do Araguaia', 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2515, 'São João da Ponta', 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2516, 'São João de Pirabas', 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2517, 'São João do Araguaia' , 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2518, 'São Miguel do Guamá', 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2519, 'São Sebastião da Boa Vista', 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2520, 'Sapucaia', 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2521, 'Senador José Porfírio', 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2522, 'Soure', 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2523, 'Tailândia' , 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2524, 'Terra Alta', 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2525, 'Terra Santa' , 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2526, 'Tomé-Açu', 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2527, 'Tracuateua', 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2528, 'Trairão' , 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2529, 'Tucumã', 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2530, 'Tucuruí' , 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2531, 'Ulianópolis' , 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2532, 'Uruará', 19 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2533, 'Vigia', 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2534, 'Viseu', 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2535, 'Vitória do Xingu' , 19);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2536, 'Xinguara', 19 );

INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2537, 'Água Branca' , 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2538, 'Aguiar', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2539, 'Alagoa Grande', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2540, 'Alagoa Nova' , 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2541, 'Alagoinha' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2542, 'Alcantil', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2543, 'Algodão de Jandaíra', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2544, 'Alhandra', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2545, 'Amparo', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2546, 'Aparecida' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2547, 'Araçagi' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2548, 'Arara', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2549, 'Araruna' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2550, 'Areia', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2551, 'Areia de Baraúnas', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2552, 'Areial', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2553, 'Aroeiras', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2554, 'Assunção', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2555, 'Baía da Traição', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2556, 'Bananeiras', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2557, 'Baraúna' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2558, 'Barra de Santa Rosa', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2559, 'Barra de Santana' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2560, 'Barra de São Miguel', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2561, 'Bayeux', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2562, 'Belém', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2563, 'Belém do Brejo do Cruz' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2564, 'Bernardino Batista', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2565, 'Boa Ventura' , 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2566, 'Boa Vista' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2567, 'Bom Jesus' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2568, 'Bom Sucesso' , 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2569, 'Bonito de Santa Fé', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2570, 'Boqueirão' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2571, 'Borborema' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2572, 'Brejo do Cruz', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2573, 'Brejo dos Santos' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2574, 'Caaporã' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2575, 'Cabaceiras', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2576, 'Cabedelo', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2577, 'Cachoeira dos Índios' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2578, 'Cacimba de Areia' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2579, 'Cacimba de Dentro', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2580, 'Cacimbas', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2581, 'Caiçara' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2582, 'Cajazeiras', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2583, 'Cajazeirinhas', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2584, 'Caldas Brandão' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2585, 'Camalaú' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2586, 'Campina Grande' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2587, 'Campo de Santana' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2588, 'Capim', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2589, 'Caraúbas', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2590, 'Carrapateira', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2591, 'Casserengue' , 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2592, 'Catingueira' , 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2593, 'Catolé do Rocha', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2594, 'Caturité', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2595, 'Conceição' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2596, 'Condado' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2597, 'Conde', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2598, 'Congo', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2599, 'Coremas' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2600, 'Coxixola', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2601, 'Cruz do Espírito Santo' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2602, 'Cubati', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2603, 'Cuité', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2604, 'Cuité de Mamanguape', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2605, 'Cuitegi' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2606, 'Curral de Cima' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2607, 'Curral Velho', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2608, 'Damião', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2609, 'Desterro', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2610, 'Diamante', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2611, 'Dona Inês' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2612, 'Duas Estradas', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2613, 'Emas' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2614, 'Esperança' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2615, 'Fagundes', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2616, 'Frei Martinho', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2617, 'Gado Bravo', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2618, 'Guarabira' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2619, 'Gurinhém', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2620, 'Gurjão', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2621, 'Ibiara', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2622, 'Igaracy' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2623, 'Imaculada' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2624, 'Ingá' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2625, 'Itabaiana' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2626, 'Itaporanga', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2627, 'Itapororoca' , 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2628, 'Itatuba' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2629, 'Jacaraú' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2630, 'Jericó', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2631, 'João Pessoa' , 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2632, 'Juarez Távora', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2633, 'Juazeirinho' , 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2634, 'Junco do Seridó', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2635, 'Juripiranga' , 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2636, 'Juru' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2637, 'Lagoa', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2638, 'Lagoa de Dentro', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2639, 'Lagoa Seca', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2640, 'Lastro', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2641, 'Livramento', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2642, 'Logradouro', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2643, 'Lucena', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2644, 'Mãe d`Água', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2645, 'Malta', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2646, 'Mamanguape', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2647, 'Manaíra' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2648, 'Marcação', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2649, 'Mari' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2650, 'Marizópolis' , 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2651, 'Massaranduba', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2652, 'Mataraca', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2653, 'Matinhas', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2654, 'Mato Grosso' , 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2655, 'Maturéia', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2656, 'Mogeiro' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2657, 'Montadas', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2658, 'Monte Horebe', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2659, 'Monteiro', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2660, 'Mulungu' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2661, 'Natuba', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2662, 'Nazarezinho' , 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2663, 'Nova Floresta', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2664, 'Nova Olinda' , 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2665, 'Nova Palmeira', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2666, 'Olho d`Água' , 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2667, 'Olivedos', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2668, 'Ouro Velho', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2669, 'Parari', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2670, 'Passagem', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2671, 'Patos', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2672, 'Paulista', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2673, 'Pedra Branca', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2674, 'Pedra Lavrada', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2675, 'Pedras de Fogo' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2676, 'Pedro Régis' , 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2677, 'Piancó', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2678, 'Picuí', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2679, 'Pilar', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2680, 'Pilões', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2681, 'Pilõezinhos' , 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2682, 'Pirpirituba' , 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2683, 'Pitimbu' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2684, 'Pocinhos', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2685, 'Poço Dantas' , 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2686, 'Poço de José de Moura', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2687, 'Pombal', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2688, 'Prata', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2689, 'Princesa Isabel', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2690, 'Puxinanã', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2691, 'Queimadas' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2692, 'Quixabá' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2693, 'Remígio' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2694, 'Riachão' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2695, 'Riachão do Bacamarte' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2696, 'Riachão do Poço', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2697, 'Riacho de Santo Antônio', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2698, 'Riacho dos Cavalos', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2699, 'Rio Tinto' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2700, 'Salgadinho', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2701, 'Salgado de São Félix' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2702, 'Santa Cecília', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2703, 'Santa Cruz', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2704, 'Santa Helena', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2705, 'Santa Inês', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2706, 'Santa Luzia' , 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2707, 'Santa Rita', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2708, 'Santa Teresinha', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2709, 'Santana de Mangueira' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2710, 'Santana dos Garrotes' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2711, 'Santarém', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2712, 'Santo André' , 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2713, 'São Bentinho', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2714, 'São Bento' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2715, 'São Domingos de Pombal' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2716, 'São Domingos do Cariri' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2717, 'São Francisco', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2718, 'São João do Cariri', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2719, 'São João do Rio do Peixe' , 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2720, 'São João do Tigre', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2721, 'São José da Lagoa Tapada' , 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2722, 'São José de Caiana', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2723, 'São José de Espinharas' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2724, 'São José de Piranhas' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2725, 'São José de Princesa' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2726, 'São José do Bonfim', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2727, 'São José do Brejo do Cruz', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2728, 'São José do Sabugi', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2729, 'São José dos Cordeiros' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2730, 'São José dos Ramos', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2731, 'São Mamede', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2732, 'São Miguel de Taipu', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2733, 'São Sebastião de Lagoa de Roça', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2734, 'São Sebastião do Umbuzeiro', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2735, 'Sapé' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2736, 'Seridó', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2737, 'Serra Branca', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2738, 'Serra da Raiz', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2739, 'Serra Grande', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2740, 'Serra Redonda', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2741, 'Serraria', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2742, 'Sertãozinho' , 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2743, 'Sobrado' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2744, 'Solânea' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2745, 'Soledade', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2746, 'Sossêgo' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2747, 'Sousa', 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2748, 'Sumé' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2749, 'Taperoá' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2750, 'Tavares' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2751, 'Teixeira', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2752, 'Tenório' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2753, 'Triunfo' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2754, 'Uiraúna' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2755, 'Umbuzeiro' , 18);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2756, 'Várzea', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2757, 'Vieirópolis' , 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2758, 'Vista Serrana', 18 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2759, 'Zabelê', 18 );

INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2760, 'Abatiá', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2761, 'Adrianópolis', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2762, 'Agudos do Sul', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2763, 'Almirante Tamandaré', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2764, 'Altamira do Paraná', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2765, 'Alto Paraná' , 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2766, 'Alto Piquiri', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2767, 'Altônia' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2768, 'Alvorada do Sul', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2769, 'Amaporã' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2770, 'Ampére', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2771, 'Anahy', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2772, 'Andirá', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2773, 'Ângulo', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2774, 'Antonina', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2775, 'Antônio Olinto' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2776, 'Apucarana' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2777, 'Arapongas' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2778, 'Arapoti' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2779, 'Arapuã', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2780, 'Araruna' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2781, 'Araucária' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2782, 'Ariranha do Ivaí' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2783, 'Assaí', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2784, 'Assis Chateaubriand', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2785, 'Astorga' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2786, 'Atalaia' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2787, 'Balsa Nova', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2788, 'Bandeirantes', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2789, 'Barbosa Ferraz' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2790, 'Barra do Jacaré', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2791, 'Barracão', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2792, 'Bela Vista da Caroba' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2793, 'Bela Vista do Paraíso', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2794, 'Bituruna', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2795, 'Boa Esperança', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2796, 'Boa Esperança do Iguaçu', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2797, 'Boa Ventura de São Roque' , 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2798, 'Boa Vista da Aparecida' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2799, 'Bocaiúva do Sul', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2800, 'Bom Jesus do Sul' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2801, 'Bom Sucesso' , 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2802, 'Bom Sucesso do Sul', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2803, 'Borrazópolis', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2804, 'Braganey', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2805, 'Brasilândia do Sul', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2806, 'Cafeara' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2807, 'Cafelândia', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2808, 'Cafezal do Sul' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2809, 'Califórnia', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2810, 'Cambará' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2811, 'Cambé', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2812, 'Cambira' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2813, 'Campina da Lagoa' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2814, 'Campina do Simão' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2815, 'Campina Grande do Sul', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2816, 'Campo Bonito', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2817, 'Campo do Tenente' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2818, 'Campo Largo' , 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2819, 'Campo Magro' , 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2820, 'Campo Mourão', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2821, 'Cândido de Abreu' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2822, 'Candói', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2823, 'Cantagalo' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2824, 'Capanema', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2825, 'Capitão Leônidas Marques' , 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2826, 'Carambeí', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2827, 'Carlópolis', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2828, 'Cascavel', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2829, 'Castro', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2830, 'Catanduvas', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2831, 'Centenário do Sul', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2832, 'Cerro Azul', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2833, 'Céu Azul', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2834, 'Chopinzinho' , 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2835, 'Cianorte', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2836, 'cidades Gaúcha' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2837, 'Clevelândia' , 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2838, 'Colombo' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2839, 'Colorado', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2840, 'Congonhinhas', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2841, 'Conselheiro Mairinck' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2842, 'Contenda', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2843, 'Corbélia', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2844, 'Cornélio Procópio', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2845, 'Coronel Domingos Soares', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2846, 'Coronel Vivida' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2847, 'Corumbataí do Sul', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2848, 'Cruz Machado', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2849, 'Cruzeiro do Iguaçu', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2850, 'Cruzeiro do Oeste', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2851, 'Cruzeiro do Sul', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2852, 'Cruzmaltina' , 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2853, 'Curitiba', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2854, 'Curiúva' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2855, 'Diamante d`Oeste' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2856, 'Diamante do Norte', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2857, 'Diamante do Sul', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2858, 'Dois Vizinhos', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2859, 'Douradina' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2860, 'Doutor Camargo' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2861, 'Doutor Ulysses' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2862, 'Enéas Marques', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2863, 'Engenheiro Beltrão', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2864, 'Entre Rios do Oeste', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2865, 'Esperança Nova' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2866, 'Espigão Alto do Iguaçu' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2867, 'Farol', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2868, 'Faxinal' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2869, 'Fazenda Rio Grande', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2870, 'Fênix', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2871, 'Fernandes Pinheiro', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2872, 'Figueira', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2873, 'Flor da Serra do Sul' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2874, 'Floraí', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2875, 'Floresta', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2876, 'Florestópolis', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2877, 'Flórida' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2878, 'Formosa do Oeste' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2879, 'Foz do Iguaçu', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2880, 'Foz do Jordão', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2881, 'Francisco Alves', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2882, 'Francisco Beltrão', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2883, 'General Carneiro' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2884, 'Godoy Moreira', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2885, 'Goioerê' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2886, 'Goioxim' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2887, 'Grandes Rios', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2888, 'Guaíra', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2889, 'Guairaçá', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2890, 'Guamiranga', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2891, 'Guapirama' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2892, 'Guaporema' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2893, 'Guaraci' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2894, 'Guaraniaçu', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2895, 'Guarapuava', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2896, 'Guaraqueçaba', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2897, 'Guaratuba' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2898, 'Honório Serpa', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2899, 'Ibaiti', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2900, 'Ibema', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2901, 'Ibiporã' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2902, 'Icaraíma', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2903, 'Iguaraçu', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2904, 'Iguatu', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2905, 'Imbaú', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2906, 'Imbituva', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2907, 'Inácio Martins' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2908, 'Inajá', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2909, 'Indianópolis', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2910, 'Ipiranga', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2911, 'Iporã', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2912, 'Iracema do Oeste' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2913, 'Irati', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2914, 'Iretama' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2915, 'Itaguajé', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2916, 'Itaipulândia', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2917, 'Itambaracá', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2918, 'Itambé', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2919, 'Itapejara d`Oeste', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2920, 'Itaperuçu' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2921, 'Itaúna do Sul', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2922, 'Ivaí' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2923, 'Ivaiporã', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2924, 'Ivaté', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2925, 'Ivatuba' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2926, 'Jaboti', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2927, 'Jacarezinho' , 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2928, 'Jaguapitã' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2929, 'Jaguariaíva' , 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2930, 'Jandaia do Sul' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2931, 'Janiópolis', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2932, 'Japira', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2933, 'Japurá', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2934, 'Jardim Alegre', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2935, 'Jardim Olinda', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2936, 'Jataizinho', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2937, 'Jesuítas', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2938, 'Joaquim Távora' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2939, 'Jundiaí do Sul' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2940, 'Juranda' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2941, 'Jussara' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2942, 'Kaloré', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2943, 'Lapa' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2944, 'Laranjal', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2945, 'Laranjeiras do Sul', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2946, 'Leópolis', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2947, 'Lidianópolis', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2948, 'Lindoeste' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2949, 'Loanda', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2950, 'Lobato', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2951, 'Londrina', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2952, 'Luiziana', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2953, 'Lunardelli', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2954, 'Lupionópolis', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2955, 'Mallet', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2956, 'Mamborê' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2957, 'Mandaguaçu', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2958, 'Mandaguari', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2959, 'Mandirituba' , 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2960, 'Manfrinópolis', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2961, 'Mangueirinha', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2962, 'Manoel Ribas', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2963, 'Marechal Cândido Rondon', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2964, 'Maria Helena', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2965, 'Marialva', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2966, 'Marilândia do Sul', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2967, 'Marilena', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2968, 'Mariluz' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2969, 'Maringá' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2970, 'Mariópolis', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2971, 'Maripá', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2972, 'Marmeleiro', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2973, 'Marquinho' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2974, 'Marumbi' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2975, 'Matelândia', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2976, 'Matinhos', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2977, 'Mato Rico' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2978, 'Mauá da Serra', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2979, 'Medianeira', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2980, 'Mercedes', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2981, 'Mirador' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2982, 'Miraselva' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2983, 'Missal', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2984, 'Moreira Sales', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2985, 'Morretes', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2986, 'Munhoz de Melo' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2987, 'Nossa Senhora das Graças' , 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2988, 'Nova Aliança do Ivaí' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2989, 'Nova América da Colina' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2990, 'Nova Aurora' , 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2991, 'Nova Cantu', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2992, 'Nova Esperança' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2993, 'Nova Esperança do Sudoeste', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2994, 'Nova Fátima' , 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2995, 'Nova Laranjeiras' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2996, 'Nova Londrina', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2997, 'Nova Olímpia', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2998, 'Nova Prata do Iguaçu' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (2999, 'Nova Santa Bárbara', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3000, 'Nova Santa Rosa', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3001, 'Nova Tebas', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3002, 'Novo Itacolomi' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3003, 'Ortigueira', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3004, 'Ourizona', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3005, 'Ouro Verde do Oeste', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3006, 'Paiçandu', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3007, 'Palmas', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3008, 'Palmeira', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3009, 'Palmital', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3010, 'Palotina', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3011, 'Paraíso do Norte' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3012, 'Paranacity', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3013, 'Paranaguá' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3014, 'Paranapoema' , 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3015, 'Paranavaí' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3016, 'Pato Bragado', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3017, 'Pato Branco' , 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3018, 'Paula Freitas', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3019, 'Paulo Frontin', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3020, 'Peabiru' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3021, 'Perobal' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3022, 'Pérola', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3023, 'Pérola d`Oeste' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3024, 'Piên' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3025, 'Pinhais' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3026, 'Pinhal de São Bento', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3027, 'Pinhalão', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3028, 'Pinhão', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3029, 'Piraí do Sul', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3030, 'Piraquara' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3031, 'Pitanga' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3032, 'Pitangueiras', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3033, 'Planaltina do Paraná' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3034, 'Planalto', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3035, 'Ponta Grossa', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3036, 'Pontal do Paraná' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3037, 'Porecatu', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3038, 'Porto Amazonas' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3039, 'Porto Barreiro' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3040, 'Porto Rico', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3041, 'Porto Vitória', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3042, 'Prado Ferreira' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3043, 'Pranchita' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3044, 'Presidente Castelo Branco', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3045, 'Primeiro de Maio' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3046, 'Prudentópolis', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3047, 'Quarto Centenário', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3048, 'Quatiguá', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3049, 'Quatro Barras', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3050, 'Quatro Pontes', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3051, 'Quedas do Iguaçu' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3052, 'Querência do Norte', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3053, 'Quinta do Sol', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3054, 'Quitandinha' , 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3055, 'Ramilândia', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3056, 'Rancho Alegre', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3057, 'Rancho Alegre d`Oeste', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3058, 'Realeza' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3059, 'Rebouças', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3060, 'Renascença', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3061, 'Reserva' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3062, 'Reserva do Iguaçu', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3063, 'Ribeirão Claro' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3064, 'Ribeirão do Pinhal', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3065, 'Rio Azul', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3066, 'Rio Bom' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3067, 'Rio Bonito do Iguaçu' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3068, 'Rio Branco do Ivaí', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3069, 'Rio Branco do Sul', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3070, 'Rio Negro' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3071, 'Rolândia', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3072, 'Roncador', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3073, 'Rondon', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3074, 'Rosário do Ivaí', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3075, 'Sabáudia', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3076, 'Salgado Filho', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3077, 'Salto do Itararé' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3078, 'Salto do Lontra', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3079, 'Santa Amélia', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3080, 'Santa Cecília do Pavão' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3081, 'Santa Cruz de Monte Castelo' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3082, 'Santa Fé', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3083, 'Santa Helena', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3084, 'Santa Inês', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3085, 'Santa Isabel do Ivaí' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3086, 'Santa Izabel do Oeste', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3087, 'Santa Lúcia' , 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3088, 'Santa Maria do Oeste' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3089, 'Santa Mariana', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3090, 'Santa Mônica', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3091, 'Santa Tereza do Oeste', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3092, 'Santa Terezinha de Itaipu', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3093, 'Santana do Itararé', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3094, 'Santo Antônio da Platina' , 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3095, 'Santo Antônio do Caiuá' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3096, 'Santo Antônio do Paraíso' , 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3097, 'Santo Antônio do Sudoeste', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3098, 'Santo Inácio', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3099, 'São Carlos do Ivaí', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3100, 'São Jerônimo da Serra', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3101, 'São João', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3102, 'São João do Caiuá', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3103, 'São João do Ivaí' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3104, 'São João do Triunfo', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3105, 'São Jorge d`Oeste', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3106, 'São Jorge do Ivaí', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3107, 'São Jorge do Patrocínio', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3108, 'São José da Boa Vista', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3109, 'São José das Palmeiras' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3110, 'São José dos Pinhais' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3111, 'São Manoel do Paraná' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3112, 'São Mateus do Sul', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3113, 'São Miguel do Iguaçu' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3114, 'São Pedro do Iguaçu', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3115, 'São Pedro do Ivaí', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3116, 'São Pedro do Paraná', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3117, 'São Sebastião da Amoreira', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3118, 'São Tomé', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3119, 'Sapopema', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3120, 'Sarandi' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3121, 'Saudade do Iguaçu', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3122, 'Sengés', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3123, 'Serranópolis do Iguaçu' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3124, 'Sertaneja' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3125, 'Sertanópolis', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3126, 'Siqueira Campos', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3127, 'Sulina', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3128, 'Tamarana', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3129, 'Tamboara', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3130, 'Tapejara', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3131, 'Tapira', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3132, 'Teixeira Soares', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3133, 'Telêmaco Borba' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3134, 'Terra Boa' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3135, 'Terra Rica', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3136, 'Terra Roxa', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3137, 'Tibagi', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3138, 'Tijucas do Sul' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3139, 'Toledo', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3140, 'Tomazina', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3141, 'Três Barras do Paraná', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3142, 'Tunas do Paraná', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3143, 'Tuneiras do Oeste', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3144, 'Tupãssi' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3145, 'Turvo', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3146, 'Ubiratã' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3147, 'Umuarama', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3148, 'União da Vitória' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3149, 'Uniflor' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3150, 'Uraí' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3151, 'Ventania', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3152, 'Vera Cruz do Oeste', 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3153, 'Verê' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3154, 'Vila Alta' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3155, 'Virmond' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3156, 'Vitorino', 07 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3157, 'Wenceslau Braz' , 07);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3158, 'Xambrê', 07 );

INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3159, 'Abreu e Lima', 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3160, 'Afogados da Ingazeira', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3161, 'Afrânio' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3162, 'Agrestina' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3163, 'Água Preta', 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3164, 'Águas Belas' , 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3165, 'Alagoinha' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3166, 'Aliança' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3167, 'Altinho' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3168, 'Amaraji' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3169, 'Angelim' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3170, 'Araçoiaba' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3171, 'Araripina' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3172, 'Arcoverde' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3173, 'Barra de Guabiraba', 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3174, 'Barreiros' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3175, 'Belém de Maria' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3176, 'Belém de São Francisco' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3177, 'Belo Jardim' , 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3178, 'Betânia' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3179, 'Bezerros', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3180, 'Bodocó', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3181, 'Bom Conselho', 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3182, 'Bom Jardim', 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3183, 'Bonito', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3184, 'Brejão', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3185, 'Brejinho', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3186, 'Brejo da Madre de Deus' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3187, 'Buenos Aires', 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3188, 'Buíque', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3189, 'Cabo de Santo Agostinho', 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3190, 'Cabrobó' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3191, 'Cachoeirinha', 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3192, 'Caetés', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3193, 'Calçado' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3194, 'Calumbi' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3195, 'Camaragibe', 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3196, 'Camocim de São Félix' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3197, 'Camutanga' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3198, 'Canhotinho', 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3199, 'Capoeiras' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3200, 'Carnaíba', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3201, 'Carnaubeira da Penha' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3202, 'Carpina' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3203, 'Caruaru' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3204, 'Casinhas', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3205, 'Catende' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3206, 'Cedro', 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3207, 'Chã de Alegria' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3208, 'Chã Grande', 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3209, 'Condado' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3210, 'Correntes' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3211, 'Cortês', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3212, 'Cumaru', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3213, 'Cupira', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3214, 'Custódia', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3215, 'Dormentes' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3216, 'Escada', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3217, 'Exu', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3218, 'Feira Nova', 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3219, 'Fernando de Noronha', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3220, 'Ferreiros' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3221, 'Flores', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3222, 'Floresta', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3223, 'Frei Miguelinho', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3224, 'Gameleira' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3225, 'Garanhuns' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3226, 'Glória do Goitá', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3227, 'Goiana', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3228, 'Granito' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3229, 'Gravatá' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3230, 'Iati' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3231, 'Ibimirim', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3232, 'Ibirajuba' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3233, 'Igarassu', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3234, 'Iguaraci', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3235, 'Inajá', 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3236, 'Ingazeira' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3237, 'Ipojuca' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3238, 'Ipubi', 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3239, 'Itacuruba' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3240, 'Itaíba', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3241, 'Itamaracá' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3242, 'Itambé', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3243, 'Itapetim', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3244, 'Itapissuma', 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3245, 'Itaquitinga' , 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3246, 'Jaboatão dos Guararapes', 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3247, 'Jaqueira', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3248, 'Jataúba' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3249, 'Jatobá', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3250, 'João Alfredo', 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3251, 'Joaquim Nabuco' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3252, 'Jucati', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3253, 'Jupi' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3254, 'Jurema', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3255, 'Lagoa do Carro' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3256, 'Lagoa do Itaenga' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3257, 'Lagoa do Ouro', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3258, 'Lagoa dos Gatos', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3259, 'Lagoa Grande', 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3260, 'Lajedo', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3261, 'Limoeiro', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3262, 'Macaparana', 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3263, 'Machados', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3264, 'Manari', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3265, 'Maraial' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3266, 'Mirandiba' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3267, 'Moreilândia' , 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3268, 'Moreno', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3269, 'Nazaré da Mata' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3270, 'Olinda', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3271, 'Orobó', 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3272, 'Orocó', 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3273, 'Ouricuri', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3274, 'Palmares', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3275, 'Palmeirina', 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3276, 'Panelas' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3277, 'Paranatama', 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3278, 'Parnamirim', 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3279, 'Passira' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3280, 'Paudalho', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3281, 'Paulista', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3282, 'Pedra', 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3283, 'Pesqueira' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3284, 'Petrolândia' , 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3285, 'Petrolina' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3286, 'Poção', 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3287, 'Pombos', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3288, 'Primavera' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3289, 'Quipapá' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3290, 'Quixaba' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3291, 'Recife', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3292, 'Riacho das Almas' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3293, 'Ribeirão', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3294, 'Rio Formoso' , 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3295, 'Sairé', 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3296, 'Salgadinho', 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3297, 'Salgueiro' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3298, 'Saloá', 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3299, 'Sanharó' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3300, 'Santa Cruz', 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3301, 'Santa Cruz da Baixa Verde', 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3302, 'Santa Cruz do Capibaribe' , 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3303, 'Santa Filomena' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3304, 'Santa Maria da Boa Vista' , 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3305, 'Santa Maria do Cambucá' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3306, 'Santa Terezinha', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3307, 'São Benedito do Sul', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3308, 'São Bento do Una' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3309, 'São Caitano' , 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3310, 'São João', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3311, 'São Joaquim do Monte' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3312, 'São José da Coroa Grande' , 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3313, 'São José do Belmonte' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3314, 'São José do Egito', 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3315, 'São Lourenço da Mata' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3316, 'São Vicente Ferrer', 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3317, 'Serra Talhada', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3318, 'Serrita' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3319, 'Sertânia', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3320, 'Sirinhaém' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3321, 'Solidão' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3322, 'Surubim' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3323, 'Tabira', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3324, 'Tacaimbó', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3325, 'Tacaratu', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3326, 'Tamandaré' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3327, 'Taquaritinga do Norte', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3328, 'Terezinha' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3329, 'Terra Nova', 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3330, 'Timbaúba', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3331, 'Toritama', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3332, 'Tracunhaém', 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3333, 'Trindade', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3334, 'Triunfo' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3335, 'Tupanatinga' , 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3336, 'Tuparetama', 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3337, 'Venturosa' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3338, 'Verdejante', 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3339, 'Vertente do Lério', 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3340, 'Vertentes' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3341, 'Vicência', 20 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3342, 'Vitória de Santo Antão' , 20);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3343, 'Xexéu', 20);

INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3344, 'Acauã', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3345, 'Agricolândia', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3346, 'Água Branca' , 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3347, 'Alagoinha do Piauí', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3348, 'Alegrete do Piauí', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3349, 'Alto Longá', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3350, 'Altos', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3351, 'Alvorada do Gurguéia' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3352, 'Amarante', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3353, 'Angical do Piauí' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3354, 'Anísio de Abreu', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3355, 'Antônio Almeida', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3356, 'Aroazes' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3357, 'Arraial' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3358, 'Assunção do Piauí', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3359, 'Avelino Lopes', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3360, 'Baixa Grande do Ribeiro', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3361, 'Barra d`Alcântara', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3362, 'Barras', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3363, 'Barreiras do Piauí', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3364, 'Barro Duro', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3365, 'Batalha' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3366, 'Bela Vista do Piauí', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3367, 'Belém do Piauí' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3368, 'Beneditinos' , 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3369, 'Bertolínia', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3370, 'Betânia do Piauí' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3371, 'Boa Hora', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3372, 'Bocaina' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3373, 'Bom Jesus' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3374, 'Bom Princípio do Piauí' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3375, 'Bonfim do Piauí', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3376, 'Boqueirão do Piauí', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3377, 'Brasileira', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3378, 'Brejo do Piauí' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3379, 'Buriti dos Lopes' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3380, 'Buriti dos Montes', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3381, 'Cabeceiras do Piauí', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3382, 'Cajazeiras do Piauí', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3383, 'Cajueiro da Praia', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3384, 'Caldeirão Grande do Piauí', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3385, 'Campinas do Piauí', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3386, 'Campo Alegre do Fidalgo', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3387, 'Campo Grande do Piauí', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3388, 'Campo Largo do Piauí' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3389, 'Campo Maior' , 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3390, 'Canavieira', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3391, 'Canto do Buriti', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3392, 'Capitão de Campos', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3393, 'Capitão Gervásio Oliveira', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3394, 'Caracol' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3395, 'Caraúbas do Piauí', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3396, 'Caridade do Piauí', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3397, 'Castelo do Piauí' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3398, 'Caxingó' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3399, 'Cocal', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3400, 'Cocal de Telha' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3401, 'Cocal dos Alves', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3402, 'Coivaras', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3403, 'Colônia do Gurguéia', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3404, 'Colônia do Piauí' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3405, 'Conceição do Canindé' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3406, 'Coronel José Dias', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3407, 'Corrente', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3408, 'Cristalândia do Piauí', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3409, 'Cristino Castro', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3410, 'Curimatá', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3411, 'Currais' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3412, 'Curral Novo do Piauí' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3413, 'Curralinhos' , 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3414, 'Demerval Lobão' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3415, 'Dirceu Arcoverde' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3416, 'Dom Expedito Lopes', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3417, 'Dom Inocêncio', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3418, 'Domingos Mourão', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3419, 'Elesbão Veloso' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3420, 'Eliseu Martins' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3421, 'Esperantina' , 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3422, 'Fartura do Piauí' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3423, 'Flores do Piauí', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3424, 'Floresta do Piauí', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3425, 'Floriano', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3426, 'Francinópolis', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3427, 'Francisco Ayres', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3428, 'Francisco Macedo' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3429, 'Francisco Santos' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3430, 'Fronteiras', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3431, 'Geminiano' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3432, 'Gilbués' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3433, 'Guadalupe' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3434, 'Guaribas', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3435, 'Hugo Napoleão', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3436, 'Ilha Grande' , 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3437, 'Inhuma', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3438, 'Ipiranga do Piauí', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3439, 'Isaías Coelho', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3440, 'Itainópolis' , 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3441, 'Itaueira', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3442, 'Jacobina do Piauí', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3443, 'Jaicós', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3444, 'Jardim do Mulato' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3445, 'Jatobá do Piauí', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3446, 'Jerumenha' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3447, 'João Costa', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3448, 'Joaquim Pires', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3449, 'Joca Marques', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3450, 'José de Freitas', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3451, 'Juazeiro do Piauí', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3452, 'Júlio Borges', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3453, 'Jurema', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3454, 'Lagoa Alegre', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3455, 'Lagoa de São Francisco' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3456, 'Lagoa do Barro do Piauí', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3457, 'Lagoa do Piauí' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3458, 'Lagoa do Sítio' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3459, 'Lagoinha do Piauí', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3460, 'Landri Sales', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3461, 'Luís Correia', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3462, 'Luzilândia', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3463, 'Madeiro' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3464, 'Manoel Emídio', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3465, 'Marcolândia' , 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3466, 'Marcos Parente' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3467, 'Massapê do Piauí' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3468, 'Matias Olímpio' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3469, 'Miguel Alves', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3470, 'Miguel Leão' , 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3471, 'Milton Brandão' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3472, 'Monsenhor Gil', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3473, 'Monsenhor Hipólito', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3474, 'Monte Alegre do Piauí', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3475, 'Morro Cabeça no Tempo', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3476, 'Morro do Chapéu do Piauí' , 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3477, 'Murici dos Portelas', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3478, 'Nazaré do Piauí', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3479, 'Nossa Senhora de Nazaré', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3480, 'Nossa Senhora dos Remédios', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3481, 'Nova Santa Rita', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3482, 'Novo Oriente do Piauí', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3483, 'Novo Santo Antônio', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3484, 'Oeiras', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3485, 'Olho d`Água do Piauí' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3486, 'Padre Marcos', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3487, 'Paes Landim' , 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3488, 'Pajeú do Piauí' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3489, 'Palmeira do Piauí', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3490, 'Palmeirais', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3491, 'Paquetá' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3492, 'Parnaguá', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3493, 'Parnaíba', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3494, 'Passagem Franca do Piauí' , 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3495, 'Patos do Piauí' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3496, 'Paulistana', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3497, 'Pavussu' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3498, 'Pedro II', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3499, 'Pedro Laurentino' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3500, 'Picos', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3501, 'Pimenteiras' , 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3502, 'Pio IX', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3503, 'Piracuruca', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3504, 'Piripiri', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3505, 'Porto', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3506, 'Porto Alegre do Piauí', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3507, 'Prata do Piauí' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3508, 'Queimada Nova', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3509, 'Redenção do Gurguéia' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3510, 'Regeneração' , 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3511, 'Riacho Frio' , 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3512, 'Ribeira do Piauí' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3513, 'Ribeiro Gonçalves', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3514, 'Rio Grande do Piauí', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3515, 'Santa Cruz do Piauí', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3516, 'Santa Cruz dos Milagres', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3517, 'Santa Filomena' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3518, 'Santa Luz' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3519, 'Santa Rosa do Piauí', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3520, 'Santana do Piauí' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3521, 'Santo Antônio de Lisboa', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3522, 'Santo Antônio dos Milagres', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3523, 'Santo Inácio do Piauí', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3524, 'São Braz do Piauí', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3525, 'São Félix do Piauí', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3526, 'São Francisco de Assis do Piauí', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3527, 'São Francisco do Piauí' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3528, 'São Gonçalo do Gurguéia', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3529, 'São Gonçalo do Piauí' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3530, 'São João da Canabrava', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3531, 'São João da Fronteira', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3532, 'São João da Serra', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3533, 'São João da Varjota', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3534, 'São João do Arraial', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3535, 'São João do Piauí', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3536, 'São José do Divino', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3537, 'São José do Peixe', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3538, 'São José do Piauí', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3539, 'São Julião', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3540, 'São Lourenço do Piauí', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3541, 'São Luis do Piauí', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3542, 'São Miguel da Baixa Grande', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3543, 'São Miguel do Fidalgo', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3544, 'São Miguel do Tapuio' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3545, 'São Pedro do Piauí', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3546, 'São Raimundo Nonato', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3547, 'Sebastião Barros' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3548, 'Sebastião Leal' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3549, 'Sigefredo Pacheco', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3550, 'Simões', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3551, 'Simplício Mendes' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3552, 'Socorro do Piauí' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3553, 'Sussuapara', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3554, 'Tamboril do Piauí', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3555, 'Tanque do Piauí', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3556, 'Teresina', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3557, 'União', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3558, 'Uruçuí', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3559, 'Valença do Piauí' , 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3560, 'Várzea Branca', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3561, 'Várzea Grande', 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3562, 'Vera Mendes' , 21 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3563, 'Vila Nova do Piauí', 21);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3564, 'Wall Ferraz' , 21 );

INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3565, 'Angra dos Reis' , 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3566, 'Aperibé' , 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3567, 'Araruama', 03 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3568, 'Areal', 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3569, 'Armação dos Búzios', 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3570, 'Arraial do Cabo', 03 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3571, 'Barra do Piraí' , 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3572, 'Barra Mansa' , 03 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3573, 'Belford Roxo', 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3574, 'Bom Jardim', 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3575, 'Bom Jesus do Itabapoana', 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3576, 'Cabo Frio' , 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3577, 'Cachoeiras de Macacu' , 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3578, 'Cambuci' , 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3579, 'Campos dos Goytacazes', 03 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3580, 'Cantagalo' , 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3581, 'Carapebus' , 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3582, 'Cardoso Moreira', 03 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3583, 'Carmo', 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3584, 'Casimiro de Abreu', 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3585, 'Comendador Levy Gasparian', 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3586, 'Conceição de Macabu', 03 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3587, 'Cordeiro', 03 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3588, 'Duas Barras' , 03 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3589, 'Duque de Caxias', 03 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3590, 'Engenheiro Paulo de Frontin' , 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3591, 'Guapimirim', 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3592, 'Iguaba Grande', 03 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3593, 'Itaboraí', 03 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3594, 'Itaguaí' , 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3595, 'Italva', 03 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3596, 'Itaocara', 03 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3597, 'Itaperuna' , 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3598, 'Itatiaia', 03 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3599, 'Japeri', 03 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3600, 'Laje do Muriaé' , 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3601, 'Macaé', 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3602, 'Macuco', 03 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3603, 'Magé' , 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3604, 'Mangaratiba' , 03 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3605, 'Maricá', 03 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3606, 'Mendes', 03 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3607, 'Miguel Pereira' , 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3608, 'Miracema', 03 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3609, 'Natividade', 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3610, 'Nilópolis' , 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3611, 'Niterói' , 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3612, 'Nova Friburgo', 03 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3613, 'Nova Iguaçu' , 03 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3614, 'Paracambi' , 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3615, 'Paraíba do Sul' , 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3616, 'Parati', 03 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3617, 'Paty do Alferes', 03 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3618, 'Petrópolis', 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3619, 'Pinheiral' , 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3620, 'Piraí', 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3621, 'Porciúncula' , 03 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3622, 'Porto Real', 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3623, 'Quatis', 03 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3624, 'Queimados' , 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3625, 'Quissamã', 03 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3626, 'Resende' , 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3627, 'Rio Bonito', 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3628, 'Rio Claro' , 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3629, 'Rio das Flores' , 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3630, 'Rio das Ostras' , 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3631, 'Rio de Janeiro' , 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3632, 'Santa Maria Madalena' , 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3633, 'Santo Antônio de Pádua' , 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3634, 'São Fidélis' , 03 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3635, 'São Francisco de Itabapoana' , 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3636, 'São Gonçalo' , 03 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3637, 'São João da Barra', 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3638, 'São João de Meriti', 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3639, 'São José de Ubá', 03 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3640, 'São José do Vale do Rio Preto' , 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3641, 'São Pedro da Aldeia', 03 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3642, 'São Sebastião do Alto', 03 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3643, 'Sapucaia', 03 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3644, 'Saquarema' , 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3645, 'Seropédica', 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3646, 'Silva Jardim', 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3647, 'Sumidouro' , 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3648, 'Tanguá', 03 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3649, 'Teresópolis' , 03 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3650, 'Trajano de Morais', 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3651, 'Três Rios' , 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3652, 'Valença' , 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3653, 'Varre-Sai' , 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3654, 'Vassouras' , 03);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3655, 'Volta Redonda', 03 );

INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3656, 'Acari', 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3657, 'Açu', 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3658, 'Afonso Bezerra' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3659, 'Água Nova' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3660, 'Alexandria', 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3661, 'Almino Afonso', 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3662, 'Alto do Rodrigues', 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3663, 'Angicos' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3664, 'Antônio Martins', 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3665, 'Apodi', 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3666, 'Areia Branca', 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3667, 'Arês' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3668, 'Augusto Severo' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3669, 'Baía Formosa', 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3670, 'Baraúna' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3671, 'Barcelona' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3672, 'Bento Fernandes', 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3673, 'Bodó' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3674, 'Bom Jesus' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3675, 'Brejinho', 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3676, 'Caiçara do Norte' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3677, 'Caiçara do Rio do Vento', 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3678, 'Caicó', 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3679, 'Campo Redondo', 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3680, 'Canguaretama', 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3681, 'Caraúbas', 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3682, 'Carnaúba dos Dantas', 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3683, 'Carnaubais', 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3684, 'Ceará-Mirim' , 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3685, 'Cerro Corá', 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3686, 'Coronel Ezequiel' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3687, 'Coronel João Pessoa', 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3688, 'Cruzeta' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3689, 'Currais Novos', 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3690, 'Doutor Severiano' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3691, 'Encanto' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3692, 'Equador' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3693, 'Espírito Santo' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3694, 'Extremoz', 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3695, 'Felipe Guerra', 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3696, 'Fernando Pedroza' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3697, 'Florânia', 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3698, 'Francisco Dantas' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3699, 'Frutuoso Gomes' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3700, 'Galinhos', 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3701, 'Goianinha' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3702, 'Governador Dix-Sept Rosado', 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3703, 'Grossos' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3704, 'Guamaré' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3705, 'Ielmo Marinho', 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3706, 'Ipanguaçu' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3707, 'Ipueira' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3708, 'Itajá', 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3709, 'Itaú' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3710, 'Jaçanã', 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3711, 'Jandaíra', 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3712, 'Janduís' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3713, 'Januário Cicco' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3714, 'Japi' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3715, 'Jardim de Angicos', 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3716, 'Jardim de Piranhas', 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3717, 'Jardim do Seridó' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3718, 'João Câmara' , 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3719, 'João Dias' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3720, 'José da Penha', 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3721, 'Jucurutu', 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3722, 'Lagoa d`Anta', 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3723, 'Lagoa de Pedras', 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3724, 'Lagoa de Velhos', 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3725, 'Lagoa Nova', 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3726, 'Lagoa Salgada', 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3727, 'Lajes', 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3728, 'Lajes Pintadas' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3729, 'Lucrécia', 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3730, 'Luís Gomes', 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3731, 'Macaíba' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3732, 'Macau', 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3733, 'Major Sales' , 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3734, 'Marcelino Vieira' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3735, 'Martins' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3736, 'Maxaranguape', 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3737, 'Messias Targino', 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3738, 'Montanhas' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3739, 'Monte Alegre', 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3740, 'Monte das Gameleiras' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3741, 'Mossoró' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3742, 'Natal', 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3743, 'Nísia Floresta' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3744, 'Nova Cruz' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3745, 'Olho-d`Água do Borges', 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3746, 'Ouro Branco' , 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3747, 'Paraná', 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3748, 'Paraú', 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3749, 'Parazinho' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3750, 'Parelhas', 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3751, 'Parnamirim', 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3752, 'Passa e Fica', 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3753, 'Passagem', 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3754, 'Patu' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3755, 'Pau dos Ferros' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3756, 'Pedra Grande', 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3757, 'Pedra Preta' , 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3758, 'Pedro Avelino', 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3759, 'Pedro Velho' , 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3760, 'Pendências', 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3761, 'Pilões', 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3762, 'Poço Branco' , 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3763, 'Portalegre', 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3764, 'Porto do Mangue', 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3765, 'Presidente Juscelino' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3766, 'Pureza', 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3767, 'Rafael Fernandes' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3768, 'Rafael Godeiro' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3769, 'Riacho da Cruz' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3770, 'Riacho de Santana', 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3771, 'Riachuelo' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3772, 'Rio do Fogo' , 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3773, 'Rodolfo Fernandes', 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3774, 'Ruy Barbosa' , 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3775, 'Santa Cruz', 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3776, 'Santa Maria' , 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3777, 'Santana do Matos' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3778, 'Santana do Seridó', 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3779, 'Santo Antônio', 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3780, 'São Bento do Norte', 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3781, 'São Bento do Trairí', 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3782, 'São Fernando', 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3783, 'São Francisco do Oeste' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3784, 'São Gonçalo do Amarante', 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3785, 'São João do Sabugi', 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3786, 'São José de Mipibu', 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3787, 'São José do Campestre', 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3788, 'São José do Seridó', 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3789, 'São Miguel', 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3790, 'São Miguel de Touros' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3791, 'São Paulo do Potengi' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3792, 'São Pedro' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3793, 'São Rafael', 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3794, 'São Tomé', 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3795, 'São Vicente' , 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3796, 'Senador Elói de Souza', 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3797, 'Senador Georgino Avelino' , 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3798, 'Serra de São Bento', 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3799, 'Serra do Mel', 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3800, 'Serra Negra do Norte' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3801, 'Serrinha', 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3802, 'Serrinha dos Pintos', 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3803, 'Severiano Melo' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3804, 'Sítio Novo', 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3805, 'Taboleiro Grande' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3806, 'Taipu', 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3807, 'Tangará' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3808, 'Tenente Ananias', 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3809, 'Tenente Laurentino Cruz', 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3810, 'Tibau', 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3811, 'Tibau do Sul', 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3812, 'Timbaúba dos Batistas', 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3813, 'Touros', 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3814, 'Triunfo Potiguar' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3815, 'Umarizal', 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3816, 'Upanema' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3817, 'Várzea', 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3818, 'Venha-Ver' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3819, 'Vera Cruz' , 22);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3820, 'Viçosa', 22 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3821, 'Vila Flor' , 22);

INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3822, 'Água Santa', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3823, 'Agudo', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3824, 'Ajuricaba' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3825, 'Alecrim' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3826, 'Alegrete', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3827, 'Alegria' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3828, 'Alpestre', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3829, 'Alto Alegre' , 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3830, 'Alto Feliz', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3831, 'Alvorada', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3832, 'Amaral Ferrador', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3833, 'Ametista do Sul', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3834, 'André da Rocha' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3835, 'Anta Gorda', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3836, 'Antônio Prado', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3837, 'Arambaré', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3838, 'Araricá' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3839, 'Aratiba' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3840, 'Arroio do Meio' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3841, 'Arroio do Sal', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3842, 'Arroio do Tigre', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3843, 'Arroio dos Ratos' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3844, 'Arroio Grande', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3845, 'Arvorezinha' , 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3846, 'Augusto Pestana', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3847, 'Áurea', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3848, 'Bagé' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3849, 'Balneário Pinhal' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3850, 'Barão', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3851, 'Barão de Cotegipe', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3852, 'Barão do Triunfo' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3853, 'Barra do Guarita' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3854, 'Barra do Quaraí', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3855, 'Barra do Ribeiro' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3856, 'Barra do Rio Azul', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3857, 'Barra Funda' , 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3858, 'Barracão', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3859, 'Barros Cassal', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3860, 'Benjamin Constant do Sul' , 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3861, 'Bento Gonçalves', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3862, 'Boa Vista das Missões', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3863, 'Boa Vista do Buricá', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3864, 'Boa Vista do Sul' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3865, 'Bom Jesus' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3866, 'Bom Princípio', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3867, 'Bom Progresso', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3868, 'Bom Retiro do Sul', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3869, 'Boqueirão do Leão', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3870, 'Bossoroca' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3871, 'Braga', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3872, 'Brochier', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3873, 'Butiá', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3874, 'Caçapava do Sul', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3875, 'Cacequi' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3876, 'Cachoeira do Sul' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3877, 'Cachoeirinha', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3878, 'Cacique Doble', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3879, 'Caibaté' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3880, 'Caiçara' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3881, 'Camaquã' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3882, 'Camargo' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3883, 'Cambará do Sul' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3884, 'Campestre da Serra', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3885, 'Campina das Missões', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3886, 'Campinas do Sul', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3887, 'Campo Bom' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3888, 'Campo Novo', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3889, 'Campos Borges', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3890, 'Candelária', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3891, 'Cândido Godói', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3892, 'Candiota', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3893, 'Canela', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3894, 'Canguçu' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3895, 'Canoas', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3896, 'Capão da Canoa' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3897, 'Capão do Leão', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3898, 'Capela de Santana', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3899, 'Capitão' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3900, 'Capivari do Sul', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3901, 'Caraá', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3902, 'Carazinho' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3903, 'Carlos Barbosa' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3904, 'Carlos Gomes', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3905, 'Casca', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3906, 'Caseiros', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3907, 'Catuípe' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3908, 'Caxias do Sul', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3909, 'Centenário', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3910, 'Cerrito' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3911, 'Cerro Branco', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3912, 'Cerro Grande', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3913, 'Cerro Grande do Sul', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3914, 'Cerro Largo' , 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3915, 'Chapada' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3916, 'Charqueadas' , 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3917, 'Charrua' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3918, 'Chiapeta', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3919, 'Chuí' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3920, 'Chuvisca', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3921, 'Cidreira', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3922, 'Ciríaco' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3923, 'Colinas' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3924, 'Colorado', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3925, 'Condor', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3926, 'Constantina' , 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3927, 'Coqueiros do Sul' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3928, 'Coronel Barros' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3929, 'Coronel Bicaco' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3930, 'Cotiporã', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3931, 'Coxilha' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3932, 'Crissiumal', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3933, 'Cristal' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3934, 'Cristal do Sul' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3935, 'Cruz Alta' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3936, 'Cruzeiro do Sul', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3937, 'David Canabarro', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3938, 'Derrubadas', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3939, 'Dezesseis de Novembro', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3940, 'Dilermando de Aguiar' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3941, 'Dois Irmãos' , 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3942, 'Dois Irmãos das Missões', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3943, 'Dois Lajeados', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3944, 'Dom Feliciano', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3945, 'Dom Pedrito' , 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3946, 'Dom Pedro de Alcântara' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3947, 'Dona Francisca' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3948, 'Doutor Maurício Cardoso', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3949, 'Doutor Ricardo' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3950, 'Eldorado do Sul', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3951, 'Encantado' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3952, 'Encruzilhada do Sul', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3953, 'Engenho Velho', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3954, 'Entre Rios do Sul', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3955, 'Entre-Ijuís' , 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3956, 'Erebango', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3957, 'Erechim' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3958, 'Ernestina' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3959, 'Erval Grande', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3960, 'Erval Seco', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3961, 'Esmeralda' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3962, 'Esperança do Sul' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3963, 'Espumoso', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3964, 'Estação' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3965, 'Estância Velha' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3966, 'Esteio', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3967, 'Estrela' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3968, 'Estrela Velha', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3969, 'Eugênio de Castro', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3970, 'Fagundes Varela', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3971, 'Farroupilha' , 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3972, 'Faxinal do Soturno', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3973, 'Faxinalzinho', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3974, 'Fazenda Vilanova' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3975, 'Feliz', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3976, 'Flores da Cunha', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3977, 'Floriano Peixoto' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3978, 'Fontoura Xavier', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3979, 'Formigueiro' , 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3980, 'Fortaleza dos Valos', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3981, 'Frederico Westphalen' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3982, 'Garibaldi' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3983, 'Garruchos' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3984, 'Gaurama' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3985, 'General Câmara' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3986, 'Gentil', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3987, 'Getúlio Vargas' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3988, 'Giruá', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3989, 'Glorinha', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3990, 'Gramado' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3991, 'Gramado dos Loureiros', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3992, 'Gramado Xavier' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3993, 'Gravataí', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3994, 'Guabiju' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3995, 'Guaíba', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3996, 'Guaporé' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3997, 'Guarani das Missões', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3998, 'Harmonia', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (3999, 'Herval', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4000, 'Herveiras' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4001, 'Horizontina' , 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4002, 'Hulha Negra' , 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4003, 'Humaitá' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4004, 'Ibarama' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4005, 'Ibiaçá', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4006, 'Ibiraiaras', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4007, 'Ibirapuitã', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4008, 'Ibirubá' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4009, 'Igrejinha' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4010, 'Ijuí' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4011, 'Ilópolis', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4012, 'Imbé' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4013, 'Imigrante' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4014, 'Independência', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4015, 'Inhacorá', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4016, 'Ipê', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4017, 'Ipiranga do Sul', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4018, 'Iraí' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4019, 'Itaara', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4020, 'Itacurubi' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4021, 'Itapuca' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4022, 'Itaqui', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4023, 'Itatiba do Sul' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4024, 'Ivorá', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4025, 'Ivoti', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4026, 'Jaboticaba', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4027, 'Jacutinga' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4028, 'Jaguarão', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4029, 'Jaguari' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4030, 'Jaquirana' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4031, 'Jari' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4032, 'Jóia' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4033, 'Júlio de Castilhos', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4034, 'Lagoa dos Três Cantos', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4035, 'Lagoa Vermelha' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4036, 'Lagoão', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4037, 'Lajeado' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4038, 'Lajeado do Bugre' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4039, 'Lavras do Sul', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4040, 'Liberato Salzano' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4041, 'Lindolfo Collor', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4042, 'Linha Nova', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4043, 'Maçambara' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4044, 'Machadinho', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4045, 'Mampituba' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4046, 'Manoel Viana', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4047, 'Maquiné' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4048, 'Maratá', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4049, 'Marau', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4050, 'Marcelino Ramos', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4051, 'Mariana Pimentel' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4052, 'Mariano Moro', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4053, 'Marques de Souza' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4054, 'Mata' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4055, 'Mato Castelhano', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4056, 'Mato Leitão' , 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4057, 'Maximiliano de Almeida' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4058, 'Minas do Leão', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4059, 'Miraguaí', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4060, 'Montauri', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4061, 'Monte Alegre dos Campos', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4062, 'Monte Belo do Sul', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4063, 'Montenegro', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4064, 'Mormaço' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4065, 'Morrinhos do Sul' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4066, 'Morro Redondo', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4067, 'Morro Reuter', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4068, 'Mostardas' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4069, 'Muçum', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4070, 'Muitos Capões', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4071, 'Muliterno' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4072, 'Não-Me-Toque', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4073, 'Nicolau Vergueiro', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4074, 'Nonoai', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4075, 'Nova Alvorada', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4076, 'Nova Araçá', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4077, 'Nova Bassano', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4078, 'Nova Boa Vista' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4079, 'Nova Bréscia', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4080, 'Nova Candelária', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4081, 'Nova Esperança do Sul', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4082, 'Nova Hartz', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4083, 'Nova Pádua', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4084, 'Nova Palma', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4085, 'Nova Petrópolis', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4086, 'Nova Prata', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4087, 'Nova Ramada' , 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4088, 'Nova Roma do Sul' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4089, 'Nova Santa Rita', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4090, 'Novo Barreiro', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4091, 'Novo Cabrais', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4092, 'Novo Hamburgo', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4093, 'Novo Machado', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4094, 'Novo Tiradentes', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4095, 'Osório', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4096, 'Paim Filho', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4097, 'Palmares do Sul', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4098, 'Palmeira das Missões' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4099, 'Palmitinho', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4100, 'Panambi' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4101, 'Pantano Grande' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4102, 'Paraí', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4103, 'Paraíso do Sul' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4104, 'Pareci Novo' , 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4105, 'Parobé', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4106, 'Passa Sete', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4107, 'Passo do Sobrado' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4108, 'Passo Fundo' , 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4109, 'Paverama', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4110, 'Pedro Osório', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4111, 'Pejuçara', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4112, 'Pelotas' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4113, 'Picada Café' , 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4114, 'Pinhal', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4115, 'Pinhal Grande', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4116, 'Pinheirinho do Vale', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4117, 'Pinheiro Machado' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4118, 'Pirapó', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4119, 'Piratini', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4120, 'Planalto', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4121, 'Poço das Antas' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4122, 'Pontão', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4123, 'Ponte Preta' , 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4124, 'Portão', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4125, 'Porto Alegre', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4126, 'Porto Lucena', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4127, 'Porto Mauá', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4128, 'Porto Vera Cruz', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4129, 'Porto Xavier', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4130, 'Pouso Novo', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4131, 'Presidente Lucena', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4132, 'Progresso' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4133, 'Protásio Alves' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4134, 'Putinga' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4135, 'Quaraí', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4136, 'Quevedos', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4137, 'Quinze de Novembro', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4138, 'Redentora' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4139, 'Relvado' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4140, 'Restinga Seca', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4141, 'Rio dos Índios' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4142, 'Rio Grande', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4143, 'Rio Pardo' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4144, 'Riozinho', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4145, 'Roca Sales', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4146, 'Rodeio Bonito', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4147, 'Rolante' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4148, 'Ronda Alta', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4149, 'Rondinha', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4150, 'Roque Gonzales' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4151, 'Rosário do Sul' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4152, 'Sagrada Família', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4153, 'Saldanha Marinho' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4154, 'Salto do Jacuí' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4155, 'Salvador das Missões' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4156, 'Salvador do Sul', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4157, 'Sananduva' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4158, 'Santa Bárbara do Sul' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4159, 'Santa Clara do Sul', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4160, 'Santa Cruz do Sul', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4161, 'Santa Maria' , 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4162, 'Santa Maria do Herval', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4163, 'Santa Rosa', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4164, 'Santa Tereza', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4165, 'Santa Vitória do Palmar', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4166, 'Santana da Boa Vista' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4167, 'Santana do Livramento', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4168, 'Santiago', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4169, 'Santo Ângelo', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4170, 'Santo Antônio da Patrulha', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4171, 'Santo Antônio das Missões', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4172, 'Santo Antônio do Palma' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4173, 'Santo Antônio do Planalto', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4174, 'Santo Augusto', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4175, 'Santo Cristo', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4176, 'Santo Expedito do Sul', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4177, 'São Borja' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4178, 'São Domingos do Sul', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4179, 'São Francisco de Assis' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4180, 'São Francisco de Paula' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4181, 'São Gabriel' , 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4182, 'São Jerônimo', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4183, 'São João da Urtiga', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4184, 'São João do Polêsine' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4185, 'São Jorge' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4186, 'São José das Missões' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4187, 'São José do Herval', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4188, 'São José do Hortêncio', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4189, 'São José do Inhacorá' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4190, 'São José do Norte', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4191, 'São José do Ouro' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4192, 'São José dos Ausentes', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4193, 'São Leopoldo', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4194, 'São Lourenço do Sul', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4195, 'São Luiz Gonzaga' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4196, 'São Marcos', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4197, 'São Martinho', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4198, 'São Martinho da Serra', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4199, 'São Miguel das Missões' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4200, 'São Nicolau' , 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4201, 'São Paulo das Missões', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4202, 'São Pedro da Serra', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4203, 'São Pedro do Butiá', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4204, 'São Pedro do Sul' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4205, 'São Sebastião do Caí' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4206, 'São Sepé', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4207, 'São Valentim', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4208, 'São Valentim do Sul', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4209, 'São Valério do Sul', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4210, 'São Vendelino', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4211, 'São Vicente do Sul', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4212, 'Sapiranga' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4213, 'Sapucaia do Sul', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4214, 'Sarandi' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4215, 'Seberi', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4216, 'Sede Nova' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4217, 'Segredo' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4218, 'Selbach' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4219, 'Senador Salgado Filho', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4220, 'Sentinela do Sul' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4221, 'Serafina Corrêa', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4222, 'Sério', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4223, 'Sertão', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4224, 'Sertão Santana' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4225, 'Sete de Setembro' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4226, 'Severiano de Almeida' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4227, 'Silveira Martins' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4228, 'Sinimbu' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4229, 'Sobradinho', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4230, 'Soledade', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4231, 'Tabaí', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4232, 'Tapejara', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4233, 'Tapera', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4234, 'Tapes', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4235, 'Taquara' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4236, 'Taquari' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4237, 'Taquaruçu do Sul' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4238, 'Tavares' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4239, 'Tenente Portela', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4240, 'Terra de Areia' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4241, 'Teutônia', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4242, 'Tiradentes do Sul', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4243, 'Toropi', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4244, 'Torres', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4245, 'Tramandaí' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4246, 'Travesseiro' , 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4247, 'Três Arroios', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4248, 'Três Cachoeiras', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4249, 'Três Coroas' , 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4250, 'Três de Maio', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4251, 'Três Forquilhas', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4252, 'Três Palmeiras' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4253, 'Três Passos' , 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4254, 'Trindade do Sul', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4255, 'Triunfo' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4256, 'Tucunduva' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4257, 'Tunas', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4258, 'Tupanci do Sul' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4259, 'Tupanciretã' , 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4260, 'Tupandi' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4261, 'Tuparendi' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4262, 'Turuçu', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4263, 'Ubiretama' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4264, 'União da Serra' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4265, 'Unistalda' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4266, 'Uruguaiana', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4267, 'Vacaria' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4268, 'Vale do Sol' , 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4269, 'Vale Real' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4270, 'Vale Verde', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4271, 'Vanini', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4272, 'Venâncio Aires' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4273, 'Vera Cruz' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4274, 'Veranópolis' , 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4275, 'Vespasiano Correa', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4276, 'Viadutos', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4277, 'Viamão', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4278, 'Vicente Dutra', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4279, 'Victor Graeff', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4280, 'Vila Flores' , 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4281, 'Vila Lângaro', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4282, 'Vila Maria', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4283, 'Vila Nova do Sul' , 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4284, 'Vista Alegre', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4285, 'Vista Alegre do Prata', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4286, 'Vista Gaúcha', 23);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4287, 'Vitória das Missões', 23 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4288, 'Xangri-lá' , 23);
									
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4289, 'Alta Floresta d`Oeste', 24 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4290, 'Alto Alegre dos Parecis', 24);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4291, 'Alto Paraíso', 24);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4292, 'Alvorada d`Oeste' , 24);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4293, 'Ariquemes' , 24);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4294, 'Buritis' , 24);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4295, 'Cabixi', 24 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4296, 'Cacaulândia' , 24 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4297, 'Cacoal', 24 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4298, 'Campo Novo de Rondônia' , 24);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4299, 'Candeias do Jamari', 24);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4300, 'Castanheiras', 24);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4301, 'Cerejeiras', 24);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4302, 'Chupinguaia' , 24 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4303, 'Colorado do Oeste', 24);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4304, 'Corumbiara', 24);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4305, 'Costa Marques', 24 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4306, 'Cujubim' , 24);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4307, 'Espigão d`Oeste', 24 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4308, 'Governador Jorge Teixeira', 24);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4309, 'Guajará-Mirim', 24 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4310, 'Itapuã do Oeste', 24 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4311, 'Jaru' , 24);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4312, 'Ji-Paraná' , 24);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4313, 'Machadinho d`Oeste', 24);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4314, 'Ministro Andreazza', 24);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4315, 'Mirante da Serra' , 24);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4316, 'Monte Negro' , 24 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4317, 'Nova Brasilândia d`Oeste' , 24 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4318, 'Nova Mamoré' , 24 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4319, 'Nova União', 24);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4320, 'Novo Horizonte do Oeste', 24);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4321, 'Ouro Preto do Oeste', 24 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4322, 'Parecis' , 24);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4323, 'Pimenta Bueno', 24 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4324, 'Pimenteiras do Oeste' , 24);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4325, 'Porto Velho' , 24 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4326, 'Presidente Médici', 24);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4327, 'Primavera de Rondônia', 24 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4328, 'Rio Crespo', 24);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4329, 'Rolim de Moura' , 24);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4330, 'Santa Luzia d`Oeste', 24 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4331, 'São Felipe d`Oeste', 24);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4332, 'São Francisco do Guaporé' , 24 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4333, 'São Miguel do Guaporé', 24 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4334, 'Seringueiras', 24);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4335, 'Teixeirópolis', 24 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4336, 'Theobroma' , 24);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4337, 'Urupá', 24);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4338, 'Vale do Anari', 24 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4339, 'Vale do Paraíso', 24 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4340, 'Vilhena' , 24);

INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4341, 'Alto Alegre' , 25 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4342, 'Amajari' , 25);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4343, 'Boa Vista' , 25);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4344, 'Bonfim', 25 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4345, 'Cantá', 25);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4346, 'Caracaraí' , 25);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4347, 'Caroebe' , 25);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4348, 'Iracema' , 25);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4349, 'Mucajaí' , 25);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4350, 'Normandia' , 25);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4351, 'Pacaraima' , 25);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4352, 'Rorainópolis', 25);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4353, 'São João da Baliza', 25);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4354, 'São Luiz', 25 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4355, 'Uiramutã', 25 );

INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4356, 'Abdon Batista', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4357, 'Abelardo Luz', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4358, 'Agrolândia', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4359, 'Agronômica', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4360, 'Água Doce' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4361, 'Águas de Chapecó' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4362, 'Águas Frias' , 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4363, 'Águas Mornas', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4364, 'Alfredo Wagner' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4365, 'Alto Bela Vista', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4366, 'Anchieta', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4367, 'Angelina', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4368, 'Anita Garibaldi', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4369, 'Anitápolis', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4370, 'Antônio Carlos' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4371, 'Apiúna', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4372, 'Arabutã' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4373, 'Araquari', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4374, 'Araranguá' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4375, 'Armazém' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4376, 'Arroio Trinta', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4377, 'Arvoredo', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4378, 'Ascurra' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4379, 'Atalanta', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4380, 'Aurora', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4381, 'Balneário Arroio do Silva', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4382, 'Balneário Barra do Sul' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4383, 'Balneário Camboriú', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4384, 'Balneário Gaivota', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4385, 'Bandeirante' , 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4386, 'Barra Bonita', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4387, 'Barra Velha' , 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4388, 'Bela Vista do Toldo', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4389, 'Belmonte', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4390, 'Benedito Novo', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4391, 'Biguaçu' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4392, 'Blumenau', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4393, 'Bocaina do Sul' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4394, 'Bom Jardim da Serra', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4395, 'Bom Jesus' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4396, 'Bom Jesus do Oeste', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4397, 'Bom Retiro', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4398, 'Bombinhas' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4399, 'Botuverá', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4400, 'Braço do Norte' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4401, 'Braço do Trombudo', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4402, 'Brunópolis', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4403, 'Brusque' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4404, 'Caçador' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4405, 'Caibi', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4406, 'Calmon', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4407, 'Camboriú', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4408, 'Campo Alegre', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4409, 'Campo Belo do Sul', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4410, 'Campo Erê' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4411, 'Campos Novos', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4412, 'Canelinha' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4413, 'Canoinhas' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4414, 'Capão Alto', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4415, 'Capinzal', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4416, 'Capivari de Baixo', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4417, 'Catanduvas', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4418, 'Caxambu do Sul' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4419, 'Celso Ramos' , 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4420, 'Cerro Negro' , 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4421, 'Chapadão do Lageado', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4422, 'Chapecó' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4423, 'Cocal do Sul', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4424, 'Concórdia' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4425, 'Cordilheira Alta' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4426, 'Coronel Freitas', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4427, 'Coronel Martins', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4428, 'Correia Pinto', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4429, 'Corupá', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4430, 'Criciúma', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4431, 'Cunha Porã', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4432, 'Cunhataí', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4433, 'Curitibanos' , 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4434, 'Descanso', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4435, 'Dionísio Cerqueira', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4436, 'Dona Emma' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4437, 'Doutor Pedrinho', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4438, 'Entre Rios', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4439, 'Ermo' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4440, 'Erval Velho' , 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4441, 'Faxinal dos Guedes', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4442, 'Flor do Sertão' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4443, 'Florianópolis', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4444, 'Formosa do Sul' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4445, 'Forquilhinha', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4446, 'Fraiburgo' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4447, 'Frei Rogério', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4448, 'Galvão', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4449, 'Garopaba', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4450, 'Garuva', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4451, 'Gaspar', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4452, 'Governador Celso Ramos' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4453, 'Grão Pará' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4454, 'Gravatal', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4455, 'Guabiruba' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4456, 'Guaraciaba', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4457, 'Guaramirim', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4458, 'Guarujá do Sul' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4459, 'Guatambú', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4460, 'Herval d`Oeste' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4461, 'Ibiam', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4462, 'Ibicaré' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4463, 'Ibirama' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4464, 'Içara', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4465, 'Ilhota', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4466, 'Imaruí', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4467, 'Imbituba', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4468, 'Imbuia', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4469, 'Indaial' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4470, 'Iomerê', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4471, 'Ipira', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4472, 'Iporã do Oeste' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4473, 'Ipuaçu', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4474, 'Ipumirim', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4475, 'Iraceminha', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4476, 'Irani', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4477, 'Irati', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4478, 'Irineópolis' , 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4479, 'Itá', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4480, 'Itaiópolis', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4481, 'Itajaí', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4482, 'Itapema' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4483, 'Itapiranga', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4484, 'Itapoá', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4485, 'Ituporanga', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4486, 'Jaborá', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4487, 'Jacinto Machado', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4488, 'Jaguaruna' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4489, 'Jaraguá do Sul' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4490, 'Jardinópolis', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4491, 'Joaçaba' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4492, 'Joinville' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4493, 'José Boiteux', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4494, 'Jupiá', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4495, 'Lacerdópolis', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4496, 'Lages', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4497, 'Laguna', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4498, 'Lajeado Grande' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4499, 'Laurentino', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4500, 'Lauro Muller', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4501, 'Lebon Régis' , 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4502, 'Leoberto Leal', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4503, 'Lindóia do Sul' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4504, 'Lontras' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4505, 'Luiz Alves', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4506, 'Luzerna' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4507, 'Macieira', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4508, 'Mafra', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4509, 'Major Gercino', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4510, 'Major Vieira', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4511, 'Maracajá', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4512, 'Maravilha' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4513, 'Marema', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4514, 'Massaranduba', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4515, 'Matos Costa' , 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4516, 'Meleiro' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4517, 'Mirim Doce', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4518, 'Modelo', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4519, 'Mondaí', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4520, 'Monte Carlo' , 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4521, 'Monte Castelo', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4522, 'Morro da Fumaça', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4523, 'Morro Grande', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4524, 'Navegantes', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4525, 'Nova Erechim', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4526, 'Nova Itaberaba' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4527, 'Nova Trento' , 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4528, 'Nova Veneza' , 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4529, 'Novo Horizonte' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4530, 'Orleans' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4531, 'Otacílio Costa' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4532, 'Ouro' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4533, 'Ouro Verde', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4534, 'Paial', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4535, 'Painel', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4536, 'Palhoça' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4537, 'Palma Sola', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4538, 'Palmeira', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4539, 'Palmitos', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4540, 'Papanduva' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4541, 'Paraíso' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4542, 'Passo de Torres', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4543, 'Passos Maia' , 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4544, 'Paulo Lopes' , 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4545, 'Pedras Grandes' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4546, 'Penha', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4547, 'Peritiba', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4548, 'Petrolândia' , 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4549, 'Piçarras', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4550, 'Pinhalzinho' , 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4551, 'Pinheiro Preto' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4552, 'Piratuba', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4553, 'Planalto Alegre', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4554, 'Pomerode', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4555, 'Ponte Alta', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4556, 'Ponte Alta do Norte', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4557, 'Ponte Serrada', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4558, 'Porto Belo', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4559, 'Porto União' , 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4560, 'Pouso Redondo', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4561, 'Praia Grande', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4562, 'Presidente Castelo Branco', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4563, 'Presidente Getúlio', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4564, 'Presidente Nereu' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4565, 'Princesa', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4566, 'Quilombo', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4567, 'Rancho Queimado', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4568, 'Rio das Antas', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4569, 'Rio do Campo', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4570, 'Rio do Oeste', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4571, 'Rio do Sul', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4572, 'Rio dos Cedros' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4573, 'Rio Fortuna' , 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4574, 'Rio Negrinho', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4575, 'Rio Rufino', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4576, 'Riqueza' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4577, 'Rodeio', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4578, 'Romelândia', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4579, 'Salete', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4580, 'Saltinho', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4581, 'Salto Veloso', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4582, 'Sangão', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4583, 'Santa Cecília', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4584, 'Santa Helena', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4585, 'Santa Rosa de Lima', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4586, 'Santa Rosa do Sul', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4587, 'Santa Terezinha', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4588, 'Santa Terezinha do Progresso', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4589, 'Santiago do Sul', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4590, 'Santo Amaro da Imperatriz', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4591, 'São Bento do Sul' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4592, 'São Bernardino' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4593, 'São Bonifácio', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4594, 'São Carlos', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4595, 'São Cristovão do Sul' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4596, 'São Domingos', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4597, 'São Francisco do Sul' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4598, 'São João Batista' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4599, 'São João do Itaperiú' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4600, 'São João do Oeste', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4601, 'São João do Sul', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4602, 'São Joaquim' , 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4603, 'São José', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4604, 'São José do Cedro', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4605, 'São José do Cerrito', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4606, 'São Lourenço do Oeste', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4607, 'São Ludgero' , 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4608, 'São Martinho', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4609, 'São Miguel da Boa Vista', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4610, 'São Miguel do Oeste', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4611, 'São Pedro de Alcântara' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4612, 'Saudades', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4613, 'Schroeder' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4614, 'Seara', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4615, 'Serra Alta', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4616, 'Siderópolis' , 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4617, 'Sombrio' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4618, 'Sul Brasil', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4619, 'Taió' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4620, 'Tangará' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4621, 'Tigrinhos' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4622, 'Tijucas' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4623, 'Timbé do Sul', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4624, 'Timbó', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4625, 'Timbó Grande', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4626, 'Três Barras' , 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4627, 'Treviso' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4628, 'Treze de Maio', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4629, 'Treze Tílias', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4630, 'Trombudo Central' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4631, 'Tubarão' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4632, 'Tunápolis' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4633, 'Turvo', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4634, 'União do Oeste' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4635, 'Urubici' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4636, 'Urupema' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4637, 'Urussanga' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4638, 'Vargeão' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4639, 'Vargem', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4640, 'Vargem Bonita', 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4641, 'Vidal Ramos' , 26 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4642, 'Videira' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4643, 'Vitor Meireles' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4644, 'Witmarsum' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4645, 'Xanxerê' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4646, 'Xavantina' , 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4647, 'Xaxim', 26);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4648, 'Zortéa', 26 );

INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4649, 'Adamantina', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4650, 'Adolfo', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4651, 'Aguaí', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4652, 'Águas da Prata' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4653, 'Águas de Lindóia' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4654, 'Águas de Santa Bárbara' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4655, 'Águas de São Pedro', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4656, 'Agudos', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4657, 'Alambari', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4658, 'Alfredo Marcondes', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4659, 'Altair', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4660, 'Altinópolis' , 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4661, 'Alto Alegre' , 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4662, 'Alumínio', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4663, 'Álvares Florence' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4664, 'Álvares Machado', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4665, 'Álvaro de Carvalho', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4666, 'Alvinlândia' , 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4667, 'Americana' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4668, 'Américo Brasiliense', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4669, 'Américo de Campos', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4670, 'Amparo', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4671, 'Analândia' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4672, 'Andradina' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4673, 'Angatuba', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4674, 'Anhembi' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4675, 'Anhumas' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4676, 'Aparecida' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4677, 'Aparecida d`Oeste', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4678, 'Apiaí', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4679, 'Araçariguama', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4680, 'Araçatuba' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4681, 'Araçoiaba da Serra', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4682, 'Aramina' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4683, 'Arandu', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4684, 'Arapeí', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4685, 'Araraquara', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4686, 'Araras', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4687, 'Arco-Íris' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4688, 'Arealva' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4689, 'Areias', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4690, 'Areiópolis', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4691, 'Ariranha', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4692, 'Artur Nogueira' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4693, 'Arujá', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4694, 'Aspásia' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4695, 'Assis', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4696, 'Atibaia' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4697, 'Auriflama' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4698, 'Avaí' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4699, 'Avanhandava' , 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4700, 'Avaré', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4701, 'Bady Bassitt', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4702, 'Balbinos', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4703, 'Bálsamo' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4704, 'Bananal' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4705, 'Barão de Antonina', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4706, 'Barbosa' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4707, 'Bariri', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4708, 'Barra Bonita', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4709, 'Barra do Chapéu', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4710, 'Barra do Turvo' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4711, 'Barretos', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4712, 'Barrinha', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4713, 'Barueri' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4714, 'Bastos', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4715, 'Batatais', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4716, 'Bauru', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4717, 'Bebedouro' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4718, 'Bento de Abreu' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4719, 'Bernardino de Campos' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4720, 'Bertioga', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4721, 'Bilac', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4722, 'Birigui' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4723, 'Biritiba-Mirim' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4724, 'Boa Esperança do Sul' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4725, 'Bocaina' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4726, 'Bofete', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4727, 'Boituva' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4728, 'Bom Jesus dos Perdões', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4729, 'Bom Sucesso de Itararé' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4730, 'Borá' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4731, 'Boracéia', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4732, 'Borborema' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4733, 'Borebi', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4734, 'Botucatu', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4735, 'Bragança Paulista', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4736, 'Braúna', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4737, 'Brejo Alegre', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4738, 'Brodowski' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4739, 'Brotas', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4740, 'Buri' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4741, 'Buritama', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4742, 'Buritizal' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4743, 'Cabrália Paulista', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4744, 'Cabreúva', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4745, 'Caçapava', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4746, 'Cachoeira Paulista', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4747, 'Caconde' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4748, 'Cafelândia', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4749, 'Caiabu', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4750, 'Caieiras', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4751, 'Caiuá', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4752, 'Cajamar' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4753, 'Cajati', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4754, 'Cajobi', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4755, 'Cajuru', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4756, 'Campina do Monte Alegre', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4757, 'Campinas', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4758, 'Campo Limpo Paulista' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4759, 'Campos do Jordão' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4760, 'Campos Novos Paulista', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4761, 'Cananéia', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4762, 'Canas', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4763, 'Cândido Mota', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4764, 'Cândido Rodrigues', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4765, 'Canitar' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4766, 'Capão Bonito', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4767, 'Capela do Alto' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4768, 'Capivari', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4769, 'Caraguatatuba', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4770, 'Carapicuíba' , 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4771, 'Cardoso' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4772, 'Casa Branca' , 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4773, 'Cássia dos Coqueiros' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4774, 'Castilho', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4775, 'Catanduva' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4776, 'Catiguá' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4777, 'Cedral', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4778, 'Cerqueira César', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4779, 'Cerquilho' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4780, 'Cesário Lange', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4781, 'Charqueada', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4782, 'Chavantes' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4783, 'Clementina', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4784, 'Colina', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4785, 'Colômbia', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4786, 'Conchal' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4787, 'Conchas' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4788, 'Cordeirópolis', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4789, 'Coroados', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4790, 'Coronel Macedo' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4791, 'Corumbataí', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4792, 'Cosmópolis', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4793, 'Cosmorama' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4794, 'Cotia', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4795, 'Cravinhos' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4796, 'Cristais Paulista', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4797, 'Cruzália', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4798, 'Cruzeiro', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4799, 'Cubatão' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4800, 'Cunha', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4801, 'Descalvado', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4802, 'Diadema' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4803, 'Dirce Reis', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4804, 'Divinolândia', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4805, 'Dobrada' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4806, 'Dois Córregos', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4807, 'Dolcinópolis', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4808, 'Dourado' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4809, 'Dracena' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4810, 'Duartina', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4811, 'Dumont', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4812, 'Echaporã', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4813, 'Eldorado', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4814, 'Elias Fausto', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4815, 'Elisiário' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4816, 'Embaúba' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4817, 'Embu' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4818, 'Embu-Guaçu', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4819, 'Emilianópolis', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4820, 'Engenheiro Coelho', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4821, 'Espírito Santo do Pinhal' , 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4822, 'Espírito Santo do Turvo', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4823, 'Estiva Gerbi', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4824, 'Estrela d`Oeste', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4825, 'Estrela do Norte' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4826, 'Euclides da Cunha Paulista', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4827, 'Fartura' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4828, 'Fernando Prestes' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4829, 'Fernandópolis', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4830, 'Fernão', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4831, 'Ferraz de Vasconcelos', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4832, 'Flora Rica', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4833, 'Floreal' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4834, 'Florínia', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4835, 'Flórida Paulista' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4836, 'Franca', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4837, 'Francisco Morato' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4838, 'Franco da Rocha', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4839, 'Gabriel Monteiro' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4840, 'Gália', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4841, 'Garça', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4842, 'Gastão Vidigal' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4843, 'Gavião Peixoto' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4844, 'General Salgado', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4845, 'Getulina', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4846, 'Glicério', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4847, 'Guaiçara', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4848, 'Guaimbê' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4849, 'Guaíra', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4850, 'Guapiaçu', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4851, 'Guapiara', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4852, 'Guará', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4853, 'Guaraçaí', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4854, 'Guaraci' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4855, 'Guarani d`Oeste', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4856, 'Guarantã', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4857, 'Guararapes', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4858, 'Guararema' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4859, 'Guaratinguetá', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4860, 'Guareí', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4861, 'Guariba' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4862, 'Guarujá' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4863, 'Guarulhos' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4864, 'Guatapará' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4865, 'Guzolândia', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4866, 'Herculândia' , 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4867, 'Holambra', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4868, 'Hortolândia' , 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4869, 'Iacanga' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4870, 'Iacri', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4871, 'Iaras', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4872, 'Ibaté', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4873, 'Ibirá', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4874, 'Ibirarema' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4875, 'Ibitinga', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4876, 'Ibiúna', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4877, 'Icém' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4878, 'Iepê' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4879, 'Igaraçu do Tietê' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4880, 'Igarapava' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4881, 'Igaratá' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4882, 'Iguape', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4883, 'Ilha Comprida', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4884, 'Ilha Solteira', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4885, 'Ilhabela', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4886, 'Indaiatuba', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4887, 'Indiana' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4888, 'Indiaporã' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4889, 'Inúbia Paulista', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4890, 'Ipauçu', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4891, 'Iperó', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4892, 'Ipeúna', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4893, 'Ipiguá', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4894, 'Iporanga', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4895, 'Ipuã' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4896, 'Iracemápolis', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4897, 'Irapuã', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4898, 'Irapuru' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4899, 'Itaberá' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4900, 'Itaí' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4901, 'Itajobi' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4902, 'Itaju', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4903, 'Itanhaém', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4904, 'Itaóca', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4905, 'Itapecerica da Serra' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4906, 'Itapetininga', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4907, 'Itapeva' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4908, 'Itapevi' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4909, 'Itapira' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4910, 'Itapirapuã Paulista', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4911, 'Itápolis', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4912, 'Itaporanga', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4913, 'Itapuí', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4914, 'Itapura' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4915, 'Itaquaquecetuba', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4916, 'Itararé' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4917, 'Itariri' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4918, 'Itatiba' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4919, 'Itatinga', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4920, 'Itirapina' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4921, 'Itirapuã', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4922, 'Itobi', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4923, 'Itu', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4924, 'Itupeva' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4925, 'Ituverava' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4926, 'Jaborandi' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4927, 'Jaboticabal' , 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4928, 'Jacareí' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4929, 'Jaci' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4930, 'Jacupiranga' , 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4931, 'Jaguariúna', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4932, 'Jales', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4933, 'Jambeiro', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4934, 'Jandira' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4935, 'Jardinópolis', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4936, 'Jarinu', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4937, 'Jaú', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4938, 'Jeriquara' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4939, 'Joanópolis', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4940, 'João Ramalho', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4941, 'José Bonifácio' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4942, 'Júlio Mesquita' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4943, 'Jumirim' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4944, 'Jundiaí' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4945, 'Junqueirópolis' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4946, 'Juquiá', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4947, 'Juquitiba' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4948, 'Lagoinha', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4949, 'Laranjal Paulista', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4950, 'Lavínia' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4951, 'Lavrinhas' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4952, 'Leme' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4953, 'Lençóis Paulista' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4954, 'Limeira' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4955, 'Lindóia' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4956, 'Lins' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4957, 'Lorena', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4958, 'Lourdes' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4959, 'Louveira', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4960, 'Lucélia' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4961, 'Lucianópolis', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4962, 'Luís Antônio', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4963, 'Luiziânia' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4964, 'Lupércio', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4965, 'Lutécia' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4966, 'Macatuba', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4967, 'Macaubal', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4968, 'Macedônia' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4969, 'Magda', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4970, 'Mairinque' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4971, 'Mairiporã' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4972, 'Manduri' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4973, 'Marabá Paulista', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4974, 'Maracaí' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4975, 'Marapoama' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4976, 'Mariápolis', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4977, 'Marília' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4978, 'Marinópolis' , 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4979, 'Martinópolis', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4980, 'Matão', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4981, 'Mauá' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4982, 'Mendonça', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4983, 'Meridiano' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4984, 'Mesópolis' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4985, 'Miguelópolis', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4986, 'Mineiros do Tietê', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4987, 'Mira Estrela', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4988, 'Miracatu', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4989, 'Mirandópolis', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4990, 'Mirante do Paranapanema', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4991, 'Mirassol', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4992, 'Mirassolândia', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4993, 'Mococa', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4994, 'Mogi das Cruzes', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4995, 'Mogi Guaçu', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4996, 'Mogi-Mirim', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4997, 'Mombuca' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4998, 'Monções' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (4999, 'Mongaguá', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5000, 'Monte Alegre do Sul', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5001, 'Monte Alto', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5002, 'Monte Aprazível', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5003, 'Monte Azul Paulista', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5004, 'Monte Castelo', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5005, 'Monte Mor' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5006, 'Monteiro Lobato', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5007, 'Morro Agudo' , 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5008, 'Morungaba' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5009, 'Motuca', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5010, 'Murutinga do Sul' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5011, 'Nantes', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5012, 'Narandiba' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5013, 'Natividade da Serra', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5014, 'Nazaré Paulista', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5015, 'Neves Paulista' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5016, 'Nhandeara' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5017, 'Nipoã', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5018, 'Nova Aliança', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5019, 'Nova Campina', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5020, 'Nova Canaã Paulista', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5021, 'Nova Castilho', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5022, 'Nova Europa' , 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5023, 'Nova Granada', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5024, 'Nova Guataporanga', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5025, 'Nova Independência', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5026, 'Nova Luzitânia' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5027, 'Nova Odessa' , 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5028, 'Novais', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5029, 'Novo Horizonte' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5030, 'Nuporanga' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5031, 'Ocauçu', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5032, 'Óleo' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5033, 'Olímpia' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5034, 'Onda Verde', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5035, 'Oriente' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5036, 'Orindiúva' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5037, 'Orlândia', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5038, 'Osasco', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5039, 'Oscar Bressane' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5040, 'Osvaldo Cruz', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5041, 'Ourinhos', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5042, 'Ouro Verde', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5043, 'Ouroeste', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5044, 'Pacaembu', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5045, 'Palestina' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5046, 'Palmares Paulista', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5047, 'Palmeira d`Oeste' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5048, 'Palmital', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5049, 'Panorama', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5050, 'Paraguaçu Paulista', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5051, 'Paraibuna' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5052, 'Paraíso' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5053, 'Paranapanema', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5054, 'Paranapuã' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5055, 'Parapuã' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5056, 'Pardinho', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5057, 'Pariquera-Açu', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5058, 'Parisi', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5059, 'Patrocínio Paulista', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5060, 'Paulicéia' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5061, 'Paulínia', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5062, 'Paulistânia' , 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5063, 'Paulo de Faria' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5064, 'Pederneiras' , 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5065, 'Pedra Bela', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5066, 'Pedranópolis', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5067, 'Pedregulho', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5068, 'Pedreira', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5069, 'Pedrinhas Paulista', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5070, 'Pedro de Toledo', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5071, 'Penápolis' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5072, 'Pereira Barreto', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5073, 'Pereiras', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5074, 'Peruíbe' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5075, 'Piacatu' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5076, 'Piedade' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5077, 'Pilar do Sul', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5078, 'Pindamonhangaba', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5079, 'Pindorama' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5080, 'Pinhalzinho' , 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5081, 'Piquerobi' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5082, 'Piquete' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5083, 'Piracaia', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5084, 'Piracicaba', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5085, 'Piraju', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5086, 'Pirajuí' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5087, 'Pirangi' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5088, 'Pirapora do Bom Jesus', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5089, 'Pirapozinho' , 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5090, 'Pirassununga', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5091, 'Piratininga' , 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5092, 'Pitangueiras', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5093, 'Planalto', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5094, 'Platina' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5095, 'Poá', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5096, 'Poloni', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5097, 'Pompéia' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5098, 'Pongaí', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5099, 'Pontal', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5100, 'Pontalinda', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5101, 'Pontes Gestal', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5102, 'Populina', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5103, 'Porangaba' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5104, 'Porto Feliz' , 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5105, 'Porto Ferreira' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5106, 'Potim', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5107, 'Potirendaba' , 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5108, 'Pracinha', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5109, 'Pradópolis', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5110, 'Praia Grande', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5111, 'Pratânia', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5112, 'Presidente Alves' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5113, 'Presidente Bernardes' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5114, 'Presidente Epitácio', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5115, 'Presidente Prudente', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5116, 'Presidente Venceslau' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5117, 'Promissão' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5118, 'Quadra', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5119, 'Quatá', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5120, 'Queiroz' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5121, 'Queluz', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5122, 'Quintana', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5123, 'Rafard', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5124, 'Rancharia' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5125, 'Redenção da Serra', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5126, 'Regente Feijó', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5127, 'Reginópolis' , 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5128, 'Registro', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5129, 'Restinga', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5130, 'Ribeira' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5131, 'Ribeirão Bonito', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5132, 'Ribeirão Branco', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5133, 'Ribeirão Corrente', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5134, 'Ribeirão do Sul', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5135, 'Ribeirão dos Índios', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5136, 'Ribeirão Grande', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5137, 'Ribeirão Pires' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5138, 'Ribeirão Preto' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5139, 'Rifaina' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5140, 'Rincão', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5141, 'Rinópolis' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5142, 'Rio Claro' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5143, 'Rio das Pedras' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5144, 'Rio Grande da Serra', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5145, 'Riolândia' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5146, 'Riversul', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5147, 'Rosana', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5148, 'Roseira' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5149, 'Rubiácea', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5150, 'Rubinéia', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5151, 'Sabino', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5152, 'Sagres', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5153, 'Sales', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5154, 'Sales Oliveira' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5155, 'Salesópolis' , 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5156, 'Salmourão' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5157, 'Saltinho', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5158, 'Salto', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5159, 'Salto de Pirapora', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5160, 'Salto Grande', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5161, 'Sandovalina' , 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5162, 'Santa Adélia', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5163, 'Santa Albertina', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5164, 'Santa Bárbara d`Oeste', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5165, 'Santa Branca', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5166, 'Santa Clara d`Oeste', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5167, 'Santa Cruz da Conceição', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5168, 'Santa Cruz da Esperança', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5169, 'Santa Cruz das Palmeiras' , 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5170, 'Santa Cruz do Rio Pardo', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5171, 'Santa Ernestina', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5172, 'Santa Fé do Sul', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5173, 'Santa Gertrudes', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5174, 'Santa Isabel', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5175, 'Santa Lúcia' , 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5176, 'Santa Maria da Serra' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5177, 'Santa Mercedes' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5178, 'Santa Rita d`Oeste', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5179, 'Santa Rita do Passa Quatro', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5180, 'Santa Rosa de Viterbo', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5181, 'Santa Salete', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5182, 'Santana da Ponte Pensa' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5183, 'Santana de Parnaíba', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5184, 'Santo Anastácio', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5185, 'Santo André' , 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5186, 'Santo Antônio da Alegria' , 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5187, 'Santo Antônio de Posse' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5188, 'Santo Antônio do Aracanguá', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5189, 'Santo Antônio do Jardim', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5190, 'Santo Antônio do Pinhal', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5191, 'Santo Expedito' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5192, 'Santópolis do Aguapeí', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5193, 'Santos', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5194, 'São Bento do Sapucaí' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5195, 'São Bernardo do Campo', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5196, 'São Caetano do Sul', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5197, 'São Carlos', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5198, 'São Francisco', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5199, 'São João da Boa Vista', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5200, 'São João das Duas Pontes' , 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5201, 'São João de Iracema', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5202, 'São João do Pau d`Alho' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5203, 'São Joaquim da Barra' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5204, 'São José da Bela Vista' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5205, 'São José do Barreiro' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5206, 'São José do Rio Pardo', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5207, 'São José do Rio Preto', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5208, 'São José dos Campos', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5209, 'São Lourenço da Serra', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5210, 'São Luís do Paraitinga' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5211, 'São Manuel', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5212, 'São Miguel Arcanjo', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5213, 'São Paulo' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5214, 'São Pedro' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5215, 'São Pedro do Turvo', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5216, 'São Roque' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5217, 'São Sebastião', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5218, 'São Sebastião da Grama' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5219, 'São Simão' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5220, 'São Vicente' , 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5221, 'Sarapuí' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5222, 'Sarutaiá', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5223, 'Sebastianópolis do Sul' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5224, 'Serra Azul', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5225, 'Serra Negra' , 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5226, 'Serrana' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5227, 'Sertãozinho' , 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5228, 'Sete Barras' , 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5229, 'Severínia' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5230, 'Silveiras' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5231, 'Socorro' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5232, 'Sorocaba', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5233, 'Sud Mennucci', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5234, 'Sumaré', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5235, 'Suzanápolis' , 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5236, 'Suzano', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5237, 'Tabapuã' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5238, 'Tabatinga' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5239, 'Taboão da Serra', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5240, 'Taciba', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5241, 'Taguaí', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5242, 'Taiaçu', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5243, 'Taiúva', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5244, 'Tambaú', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5245, 'Tanabi', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5246, 'Tapiraí' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5247, 'Tapiratiba', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5248, 'Taquaral', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5249, 'Taquaritinga', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5250, 'Taquarituba' , 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5251, 'Taquarivaí', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5252, 'Tarabai' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5253, 'Tarumã', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5254, 'Tatuí', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5255, 'Taubaté' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5256, 'Tejupá', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5257, 'Teodoro Sampaio', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5258, 'Terra Roxa', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5259, 'Tietê', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5260, 'Timburi' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5261, 'Torre de Pedra' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5262, 'Torrinha', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5263, 'Trabiju' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5264, 'Tremembé', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5265, 'Três Fronteiras', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5266, 'Tuiuti', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5267, 'Tupã' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5268, 'Tupi Paulista', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5269, 'Turiúba' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5270, 'Turmalina' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5271, 'Ubarana' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5272, 'Ubatuba' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5273, 'Ubirajara' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5274, 'Uchoa', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5275, 'União Paulista' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5276, 'Urânia', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5277, 'Uru', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5278, 'Urupês', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5279, 'Valentim Gentil', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5280, 'Valinhos', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5281, 'Valparaíso', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5282, 'Vargem', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5283, 'Vargem Grande do Sul' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5284, 'Vargem Grande Paulista' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5285, 'Várzea Paulista', 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5286, 'Vera Cruz' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5287, 'Vinhedo' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5288, 'Viradouro' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5289, 'Vista Alegre do Alto' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5290, 'Vitória Brasil' , 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5291, 'Votorantim', 02);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5292, 'Votuporanga' , 02 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5293, 'Zacarias', 02 );

INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5294, 'Amparo de São Francisco', 27);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5295, 'Aquidabã', 27 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5296, 'Aracaju' , 27);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5297, 'Arauá', 27);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5298, 'Areia Branca', 27);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5299, 'Barra dos Coqueiros', 27 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5300, 'Boquim', 27 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5301, 'Brejo Grande', 27);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5302, 'Campo do Brito' , 27);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5303, 'Canhoba' , 27);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5304, 'Canindé de São Francisco' , 27 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5305, 'Capela', 27 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5306, 'Carira', 27 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5307, 'Carmópolis', 27);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5308, 'Cedro de São João', 27);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5309, 'Cristinápolis', 27 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5310, 'Cumbe', 27);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5311, 'Divina Pastora' , 27);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5312, 'Estância', 27 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5313, 'Feira Nova', 27);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5314, 'Frei Paulo', 27);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5315, 'Gararu', 27 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5316, 'General Maynard', 27 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5317, 'Gracho Cardoso' , 27);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5318, 'Ilha das Flores', 27 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5319, 'Indiaroba' , 27);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5320, 'Itabaiana' , 27);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5321, 'Itabaianinha', 27);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5322, 'Itabi', 27);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5323, 'Itaporanga d`Ajuda', 27);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5324, 'Japaratuba', 27);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5325, 'Japoatã' , 27);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5326, 'Lagarto' , 27);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5327, 'Laranjeiras' , 27 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5328, 'Macambira' , 27);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5329, 'Malhada dos Bois' , 27);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5330, 'Malhador', 27 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5331, 'Maruim', 27 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5332, 'Moita Bonita', 27);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5333, 'Monte Alegre de Sergipe', 27);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5334, 'Muribeca', 27 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5335, 'Neópolis', 27 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5336, 'Nossa Senhora Aparecida', 27);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5337, 'Nossa Senhora da Glória', 27);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5338, 'Nossa Senhora das Dores', 27);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5339, 'Nossa Senhora de Lourdes' , 27 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5340, 'Nossa Senhora do Socorro' , 27 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5341, 'Pacatuba', 27 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5342, 'Pedra Mole', 27);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5343, 'Pedrinhas' , 27);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5344, 'Pinhão', 27 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5345, 'Pirambu' , 27);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5346, 'Poço Redondo', 27);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5347, 'Poço Verde', 27);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5348, 'Porto da Folha' , 27);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5349, 'Propriá' , 27);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5350, 'Riachão do Dantas', 27);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5351, 'Riachuelo' , 27);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5352, 'Ribeirópolis', 27);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5353, 'Rosário do Catete', 27);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5354, 'Salgado' , 27);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5355, 'Santa Luzia do Itanhy', 27 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5356, 'Santa Rosa de Lima', 27);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5357, 'Santana do São Francisco' , 27 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5358, 'Santo Amaro das Brotas' , 27);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5359, 'São Cristóvão', 27 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5360, 'São Domingos', 27);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5361, 'São Francisco', 27 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5362, 'São Miguel do Aleixo' , 27);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5363, 'Simão Dias', 27);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5364, 'Siriri', 27 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5365, 'Telha', 27);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5366, 'Tobias Barreto' , 27);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5367, 'Tomar do Geru', 27 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5368, 'Umbaúba' , 27);

INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5369, 'Abreulândia' , 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5370, 'Aguiarnópolis', 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5371, 'Aliança do Tocantins' , 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5372, 'Almas', 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5373, 'Alvorada', 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5374, 'Ananás', 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5375, 'Angico', 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5376, 'Aparecida do Rio Negro' , 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5377, 'Aragominas', 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5378, 'Araguacema', 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5379, 'Araguaçu', 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5380, 'Araguaína' , 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5381, 'Araguanã', 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5382, 'Araguatins', 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5383, 'Arapoema', 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5384, 'Arraias' , 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5385, 'Augustinópolis' , 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5386, 'Aurora do Tocantins', 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5387, 'Axixá do Tocantins', 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5388, 'Babaçulândia', 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5389, 'Bandeirantes do Tocantins', 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5390, 'Barra do Ouro', 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5391, 'Barrolândia' , 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5392, 'Bernardo Sayão' , 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5393, 'Bom Jesus do Tocantins' , 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5394, 'Brasilândia do Tocantins' , 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5395, 'Brejinho de Nazaré', 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5396, 'Buriti do Tocantins', 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5397, 'Cachoeirinha', 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5398, 'Campos Lindos', 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5399, 'Cariri do Tocantins', 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5400, 'Carmolândia' , 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5401, 'Carrasco Bonito', 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5402, 'Caseara' , 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5403, 'Centenário', 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5404, 'Chapada da Natividade', 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5405, 'Chapada de Areia' , 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5406, 'Colinas do Tocantins' , 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5407, 'Colméia' , 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5408, 'Combinado' , 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5409, 'Conceição do Tocantins' , 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5410, 'Couto de Magalhães', 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5411, 'Cristalândia', 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5412, 'Crixás do Tocantins', 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5413, 'Darcinópolis', 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5414, 'Dianópolis', 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5415, 'Divinópolis do Tocantins' , 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5416, 'Dois Irmãos do Tocantins' , 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5417, 'Dueré', 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5418, 'Esperantina' , 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5419, 'Fátima', 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5420, 'Figueirópolis', 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5421, 'Filadélfia', 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5422, 'Formoso do Araguaia', 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5423, 'Fortaleza do Tabocão' , 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5424, 'Goianorte' , 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5425, 'Goiatins', 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5426, 'Guaraí', 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5427, 'Gurupi', 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5428, 'Ipueiras', 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5429, 'Itacajá' , 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5430, 'Itaguatins', 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5431, 'Itapiratins' , 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5432, 'Itaporã do Tocantins' , 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5433, 'Jaú do Tocantins' , 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5434, 'Juarina' , 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5435, 'Lagoa da Confusão', 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5436, 'Lagoa do Tocantins', 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5437, 'Lajeado' , 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5438, 'Lavandeira', 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5439, 'Lizarda' , 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5440, 'Luzinópolis' , 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5441, 'Marianópolis do Tocantins', 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5442, 'Mateiros', 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5443, 'Maurilândia do Tocantins' , 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5444, 'Miracema do Tocantins', 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5445, 'Miranorte' , 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5446, 'Monte do Carmo' , 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5447, 'Monte Santo do Tocantins' , 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5448, 'Muricilândia', 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5449, 'Natividade', 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5450, 'Nazaré', 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5451, 'Nova Olinda' , 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5452, 'Nova Rosalândia', 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5453, 'Novo Acordo' , 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5454, 'Novo Alegre' , 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5455, 'Novo Jardim' , 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5456, 'Oliveira de Fátima', 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5457, 'Palmas', 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5458, 'Palmeirante' , 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5459, 'Palmeiras do Tocantins' , 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5460, 'Palmeirópolis', 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5461, 'Paraíso do Tocantins' , 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5462, 'Paranã', 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5463, 'Pau d`Arco', 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5464, 'Pedro Afonso', 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5465, 'Peixe', 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5466, 'Pequizeiro', 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5467, 'Pindorama do Tocantins' , 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5468, 'Piraquê' , 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5469, 'Pium' , 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5470, 'Ponte Alta do Bom Jesus', 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5471, 'Ponte Alta do Tocantins', 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5472, 'Porto Alegre do Tocantins', 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5473, 'Porto Nacional' , 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5474, 'Praia Norte' , 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5475, 'Presidente Kennedy', 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5476, 'Pugmil', 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5477, 'Recursolândia', 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5478, 'Riachinho' , 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5479, 'Rio da Conceição' , 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5480, 'Rio dos Bois', 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5481, 'Rio Sono', 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5482, 'Sampaio' , 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5483, 'Sandolândia' , 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5484, 'Santa Fé do Araguaia' , 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5485, 'Santa Maria do Tocantins' , 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5486, 'Santa Rita do Tocantins', 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5487, 'Santa Rosa do Tocantins', 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5488, 'Santa Tereza do Tocantins', 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5489, 'Santa Terezinha do Tocantins', 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5490, 'São Bento do Tocantins' , 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5491, 'São Félix do Tocantins' , 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5492, 'São Miguel do Tocantins', 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5493, 'São Salvador do Tocantins', 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5494, 'São Sebastião do Tocantins', 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5495, 'São Valério da Natividade', 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5496, 'Silvanópolis', 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5497, 'Sítio Novo do Tocantins', 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5498, 'Sucupira', 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5499, 'Taguatinga', 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5500, 'Taipas do Tocantins', 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5501, 'Talismã' , 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5502, 'Tocantínia', 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5503, 'Tocantinópolis' , 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5504, 'Tupirama', 05 );
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5505, 'Tupiratins', 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5506, 'Wanderlândia', 05);
INSERT INTO cidades (idcidade, nomecidade, iduf) VALUES (5507, 'Xambioá' , 05);
INSERT INTO cidades (idcidade,nomecidade,iduf) VALUES (5508,'Brazlandia',1);
INSERT INTO cidades (idcidade,nomecidade,iduf) VALUES (5509,'Candangolandia',1);
INSERT INTO cidades (idcidade,nomecidade,iduf) VALUES (5510,'Ceilandia',1);
INSERT INTO cidades (idcidade,nomecidade,iduf) VALUES (5511,'Cruzeiro',1);
INSERT INTO cidades (idcidade,nomecidade,iduf) VALUES (5512,'Gama',1);
INSERT INTO cidades (idcidade,nomecidade,iduf) VALUES (5513,'Guara',1);
INSERT INTO cidades (idcidade,nomecidade,iduf) VALUES (5514,'Lago Norte',1);
INSERT INTO cidades (idcidade,nomecidade,iduf) VALUES (5515,'Lago Sul',1);
INSERT INTO cidades (idcidade,nomecidade,iduf) VALUES (5516,'Nucleo Bandeirante',1);
INSERT INTO cidades (idcidade,nomecidade,iduf) VALUES (5517,'Paranoa',1);
INSERT INTO cidades (idcidade,nomecidade,iduf) VALUES (5518,'Planaltina',1);
INSERT INTO cidades (idcidade,nomecidade,iduf) VALUES (5519,'Recanto das Emas',1);
INSERT INTO cidades (idcidade,nomecidade,iduf) VALUES (5520,'Riacho Fundo',1);
INSERT INTO cidades (idcidade,nomecidade,iduf) VALUES (5521,'Samambaia',1);
INSERT INTO cidades (idcidade,nomecidade,iduf) VALUES (5522,'Santa Maria',1);
INSERT INTO cidades (idcidade,nomecidade,iduf) VALUES (5523,'Sao Sebastiao',1);
INSERT INTO cidades (idcidade,nomecidade,iduf) VALUES (5524,'Sobradinho',1);
INSERT INTO cidades (idcidade,nomecidade,iduf) VALUES (5525,'Taguatinga',1);
INSERT INTO cidades (idcidade,nomecidade,iduf) VALUES (5526,'Abadia de Goiás',4);


--
-- TOC entry 6126 (class 0 OID 2246608)
-- Dependencies: 218 6388
-- Data for Name: clientes; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO clientes VALUES (1, 'Cliente 1', 'Cliente 1', '', '', 'A', NULL);


--
-- TOC entry 6127 (class 0 OID 2246619)
-- Dependencies: 219 6388
-- Data for Name: colecao; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6128 (class 0 OID 2246626)
-- Dependencies: 220 6388
-- Data for Name: coletapreco; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6129 (class 0 OID 2246646)
-- Dependencies: 221 6388
-- Data for Name: comando; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6130 (class 0 OID 2246651)
-- Dependencies: 222 6388
-- Data for Name: comandosistemaoperacional; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6131 (class 0 OID 2246663)
-- Dependencies: 223 6388
-- Data for Name: comentarios; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6132 (class 0 OID 2246672)
-- Dependencies: 224 6388
-- Data for Name: complexidade; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6133 (class 0 OID 2246680)
-- Dependencies: 225 6388
-- Data for Name: condicaooperacao; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO condicaooperacao VALUES (1, 1, '24 X 7', '2012-01-01', NULL);
INSERT INTO condicaooperacao VALUES (2, 1, 'Horário Comercial', '2012-01-01', NULL);


--
-- TOC entry 6134 (class 0 OID 2246686)
-- Dependencies: 226 6388
-- Data for Name: conhecimentoic; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6135 (class 0 OID 2246697)
-- Dependencies: 227 6388
-- Data for Name: conhecimentomudanca; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6136 (class 0 OID 2246708)
-- Dependencies: 228 6388
-- Data for Name: conhecimentoproblema; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6137 (class 0 OID 2246719)
-- Dependencies: 229 6388
-- Data for Name: conhecimentosolicitacaoservico; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6138 (class 0 OID 2246730)
-- Dependencies: 230 6388
-- Data for Name: contadoracesso; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6139 (class 0 OID 2246737)
-- Dependencies: 231 6388
-- Data for Name: contatocliente; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6140 (class 0 OID 2246749)
-- Dependencies: 232 6388
-- Data for Name: contatorequisicaomudanca; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6141 (class 0 OID 2246761)
-- Dependencies: 233 6388
-- Data for Name: contatosolicitacaoservico; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO contatosolicitacaoservico VALUES (1, 'Default', '3242-4433', 'citsmart_instalador_mysql@centralit.com.br', '', NULL, NULL);
INSERT INTO contatosolicitacaoservico VALUES (2, 'Default', '3242-4433', 'citsmart_instalador_mysql@centralit.com.br', '', NULL, NULL);
INSERT INTO contatosolicitacaoservico VALUES (3, 'Consultor', '3242-4433', 'citsmart_instalador_mysql@centralit.com.br', '', NULL, NULL);
INSERT INTO contatosolicitacaoservico VALUES (4, 'Consultor', '3242-4433', 'citsmart_instalador_mysql@centralit.com.br', '', NULL, NULL);


--
-- TOC entry 6142 (class 0 OID 2246772)
-- Dependencies: 234 6388
-- Data for Name: contratoquestionarios; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6143 (class 0 OID 2246789)
-- Dependencies: 235 6388
-- Data for Name: contratos; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO contratos VALUES (1, 1, 1, 1, '1', 'Descrição do Contrato', '2013-04-01', 1000000.000, NULL, NULL, 'C', 'A', 1.000, 'N', NULL, 2, '2014-12-31');


--
-- TOC entry 6144 (class 0 OID 2246805)
-- Dependencies: 236 6388
-- Data for Name: contratos_hist; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO contratos_hist VALUES (1, 1, 1, 1, 1, '1', 'Descrição do Contrato', '2013-04-01', 1000000.000, NULL, NULL, 'C', 'A', 1.000, NULL, NULL, 2, '2014-12-31', '2013-04-02 04:00:00', 'Administrador', '2013-04-02 04:00:00', 'Administrador', 'JSONDATA: TRUE
TIPO: C
NUMERO: 1
NOCACHE: Tue Apr 02 2013 13:26:45 GMT-0300 (Hora oficial do Brasil)
IDFORNECEDOR: 1
KEYCONTROL: 
DINAMICVIEWSJSON_TEMPDATA: 
VALORESTIMADO: 1.000.000,00
IDCLIENTE: 1
CADASTROMANUALUSUARIO: N
COTACAOMOEDA: 1,00
IDCONTRATO: 1
DINAMICVIEWSTABLESVINC: "TABLE_SEARCH_28","TABLE_SEARCH_64"
DINAMICVIEWSACAOPESQUISASELECIONADA: 
DATAFIMCONTRATO: 31/12/2014
OBJETO: Descrição do Contrato
IDMOEDA: 1
DATACONTRATO: 01/04/2013
ACAOFLUXO: 
MODOEXIBICAO: N
IDGRUPOSOLICITANTE: 2
SESSION.NUMERO_CONTRATO_EDICAO: null
DINAMICVIEWSIDVISAOPESQUISASELECIONADA: 
DINAMICVIEWSJSON_DATA: 
IDFLUXO: 
JSONMATRIZ: 
DINAMICVIEWSIDVISAO: 20
SESSION.DINAMICVIEWS_SAVEINFO: null
IDTAREFA: 
SITUACAO: A
DINAMICVIEWSDADOSADICIONAIS: {}
');


--
-- TOC entry 6145 (class 0 OID 2246827)
-- Dependencies: 237 6388
-- Data for Name: contratoscolaboradores; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6146 (class 0 OID 2246833)
-- Dependencies: 238 6388
-- Data for Name: contratosgrupos; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO contratosgrupos VALUES (2, 1);
INSERT INTO contratosgrupos VALUES (3, 1);
INSERT INTO contratosgrupos VALUES (4, 1);
INSERT INTO contratosgrupos VALUES (16, 1);
INSERT INTO contratosgrupos VALUES (17, 1);
INSERT INTO contratosgrupos VALUES (19, 1);


--
-- TOC entry 6147 (class 0 OID 2246840)
-- Dependencies: 239 6388
-- Data for Name: contratosunidades; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6148 (class 0 OID 2246847)
-- Dependencies: 240 6388
-- Data for Name: controleged; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6149 (class 0 OID 2246861)
-- Dependencies: 241 6388
-- Data for Name: controlequestionarios; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6150 (class 0 OID 2246866)
-- Dependencies: 242 6388
-- Data for Name: cotacao; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6151 (class 0 OID 2246879)
-- Dependencies: 243 6388
-- Data for Name: cotacaoitemrequisicao; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6152 (class 0 OID 2246922)
-- Dependencies: 244 6388
-- Data for Name: criterioavaliacao; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6153 (class 0 OID 2246927)
-- Dependencies: 245 6388
-- Data for Name: criterioavaliacaofornecedor; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6154 (class 0 OID 2246948)
-- Dependencies: 246 6388
-- Data for Name: criteriocotacao; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6155 (class 0 OID 2246964)
-- Dependencies: 247 6388
-- Data for Name: criteriocotacaocategoria; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6156 (class 0 OID 2246980)
-- Dependencies: 248 6388
-- Data for Name: criterioitemcotacao; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6157 (class 0 OID 2246986)
-- Dependencies: 249 6388
-- Data for Name: demandas; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6158 (class 0 OID 2247002)
-- Dependencies: 250 6388
-- Data for Name: dicionario; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6159 (class 0 OID 2247012)
-- Dependencies: 251 6388
-- Data for Name: emailsolicitacaoservico; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6160 (class 0 OID 2247020)
-- Dependencies: 252 6388
-- Data for Name: empregadoitemconfiguracao; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6161 (class 0 OID 2247027)
-- Dependencies: 253 6388
-- Data for Name: empregados; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO empregados VALUES (1, 'Administrador', 'Administrador', '2012-01-01', 'M', '', '', NULL, 0, '', NULL, '', '', '', '', NULL, 'citsmart_instalador_mysql@centralit.com.br', NULL, NULL, '', '', NULL, NULL, '', '2012-01-01', NULL, 'E', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', 1, NULL, '3242-4433', 1, NULL, NULL);
INSERT INTO empregados VALUES (2, 'Default', 'Default', '2012-01-01', 'M', '', '', NULL, 0, '', NULL, '', '', '', '', NULL, 'citsmart_instalador_mysql@centralit.com.br', NULL, NULL, '', '', NULL, NULL, '', '2012-01-01', NULL, 'E', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', 1, NULL, '3242-4433', 2, NULL, NULL);
INSERT INTO empregados VALUES (3, 'Consultor', 'Consultor', '2012-01-01', 'M', '', '', NULL, 0, '', NULL, '', '', '', '', NULL, 'contact@citsmart.com', NULL, NULL, '', '', NULL, NULL, '', '2012-01-01', NULL, 'E', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', 1, NULL, '3242-4433', 1, NULL, NULL);


--
-- TOC entry 6162 (class 0 OID 2247057)
-- Dependencies: 254 6388
-- Data for Name: empresa; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO empresa VALUES (1, 'Default', '', '2013-03-18', NULL);


--
-- TOC entry 6163 (class 0 OID 2247066)
-- Dependencies: 255 6388
-- Data for Name: endereco; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO endereco VALUES (1, NULL, NULL, NULL, NULL, 971, 1, NULL, 4);


--
-- TOC entry 6387 (class 0 OID 2249751)
-- Dependencies: 479 6388
-- Data for Name: entregaitemrequisicao; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6164 (class 0 OID 2247079)
-- Dependencies: 256 6388
-- Data for Name: etapas; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6165 (class 0 OID 2247086)
-- Dependencies: 257 6388
-- Data for Name: evento; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6166 (class 0 OID 2247097)
-- Dependencies: 258 6388
-- Data for Name: eventoempregado; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6167 (class 0 OID 2247105)
-- Dependencies: 259 6388
-- Data for Name: eventogrupo; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6168 (class 0 OID 2247108)
-- Dependencies: 260 6388
-- Data for Name: eventoitemconfiguracao; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6169 (class 0 OID 2247116)
-- Dependencies: 261 6388
-- Data for Name: eventomonitconhecimento; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6170 (class 0 OID 2247121)
-- Dependencies: 262 6388
-- Data for Name: eventomonitoramento; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6171 (class 0 OID 2247131)
-- Dependencies: 263 6388
-- Data for Name: eventounidade; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6172 (class 0 OID 2247134)
-- Dependencies: 264 6388
-- Data for Name: excecaocalendario; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6173 (class 0 OID 2247141)
-- Dependencies: 265 6388
-- Data for Name: excecaoempregado; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6174 (class 0 OID 2247149)
-- Dependencies: 266 6388
-- Data for Name: execucaoatividadeperiodica; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6175 (class 0 OID 2247161)
-- Dependencies: 267 6388
-- Data for Name: execucaobatch; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6176 (class 0 OID 2247172)
-- Dependencies: 268 6388
-- Data for Name: execucaodemanda; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6177 (class 0 OID 2247183)
-- Dependencies: 269 6388
-- Data for Name: execucaomudanca; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6178 (class 0 OID 2247201)
-- Dependencies: 270 6388
-- Data for Name: execucaosolicitacao; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO execucaosolicitacao VALUES (1, 1, 2, 1, 3, 0, 0, NULL);
INSERT INTO execucaosolicitacao VALUES (2, 2, 2, 2, 3, 0, 0, NULL);
INSERT INTO execucaosolicitacao VALUES (3, 3, 2, 3, 3, 0, 0, NULL);
INSERT INTO execucaosolicitacao VALUES (4, 4, 2, 4, 3, 0, 0, NULL);


--
-- TOC entry 6179 (class 0 OID 2247210)
-- Dependencies: 271 6388
-- Data for Name: externalconnection; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6180 (class 0 OID 2247226)
-- Dependencies: 272 6388
-- Data for Name: faixavaloresrecurso; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6181 (class 0 OID 2247236)
-- Dependencies: 273 6388
-- Data for Name: faseservico; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO faseservico VALUES (1, 'Captura', 'S');
INSERT INTO faseservico VALUES (2, 'Execução', 'N');


--
-- TOC entry 6182 (class 0 OID 2247241)
-- Dependencies: 274 6388
-- Data for Name: fatura; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6183 (class 0 OID 2247255)
-- Dependencies: 275 6388
-- Data for Name: faturaapuracaoans; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6184 (class 0 OID 2247268)
-- Dependencies: 276 6388
-- Data for Name: faturaos; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6185 (class 0 OID 2247274)
-- Dependencies: 277 6388
-- Data for Name: feriado; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6186 (class 0 OID 2247282)
-- Dependencies: 278 6388
-- Data for Name: fluxo; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6187 (class 0 OID 2247290)
-- Dependencies: 279 6388
-- Data for Name: fluxos; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6188 (class 0 OID 2247295)
-- Dependencies: 280 6388
-- Data for Name: fluxoservico; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6189 (class 0 OID 2247304)
-- Dependencies: 281 6388
-- Data for Name: formula; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO formula VALUES (1, 'Calculo de ANS Padrão', 'Calculo de ANS Padrão', 'if (faturaDTO.getFieldANS() == "valorGlosa"){   var percGlosa = (FormulasUtil.getDoubleValueFromGrid(request,   faturaDTO.getSeqANS(),  "valorGlosa") / faturaDTO.getValorExecutadoSomaOS()) * 100;    FormulasUtil.setDoubleValueFromGrid(document,  faturaDTO.getSeqANS(),  "percentualGlosa", percGlosa );}else{   var valorGlosa = faturaDTO.getValorExecutadoSomaOS() * (FormulasUtil.getDoubleValueFromGrid(request,   faturaDTO.getSeqANS(),  "percentualGlosa") / 100);   FormulasUtil.setDoubleValueFromGrid(document,  faturaDTO.getSeqANS(),  "valorGlosa", valorGlosa);}', NULL);
INSERT INTO formula VALUES (2, 'CalculoGLOSAOS', 'Calculo Glosa OS', 'if (osDTO.getFieldANS() == "custoGlosa"){   var percGlosa = (FormulasUtil.getDoubleValueFromGrid(request,   osDTO.getSeqANS(),  "custoGlosa") / osDTO.getExecutadoOS()) * 100;    FormulasUtil.setDoubleValueFromGrid(document,  osDTO.getSeqANS(),  "percAplicado", percGlosa ); }else{    var valorGlosa = osDTO.getExecutadoOS() * (FormulasUtil.getDoubleValueFromGrid(request,   osDTO.getSeqANS(),  "percAplicado") / 100);    FormulasUtil.setDoubleValueFromGrid(document,  osDTO.getSeqANS(),  "custoGlosa", valorGlosa);}', NULL);


--
-- TOC entry 6190 (class 0 OID 2247314)
-- Dependencies: 282 6388
-- Data for Name: fornecedor; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO fornecedor VALUES (1, 'Fornecedor 1', 'Seu Fornecedor', NULL, '', '', NULL, NULL, NULL, '', '', '', 1, ' ');


--
-- TOC entry 6191 (class 0 OID 2247338)
-- Dependencies: 283 6388
-- Data for Name: fornecedorcotacao; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6192 (class 0 OID 2247355)
-- Dependencies: 284 6388
-- Data for Name: fornecedorproduto; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6193 (class 0 OID 2247368)
-- Dependencies: 285 6388
-- Data for Name: galeriaimagens; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6194 (class 0 OID 2247379)
-- Dependencies: 286 6388
-- Data for Name: glosaos; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6195 (class 0 OID 2247390)
-- Dependencies: 287 6388
-- Data for Name: glosaservicocontrato; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6196 (class 0 OID 2247395)
-- Dependencies: 288 6388
-- Data for Name: grupo; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO grupo VALUES (1, 1, 'Desenvolvimento', '2012-01-01', NULL, 'Esse grupo possui perfil de acesso Supervisão.', 'N', 'DES', NULL, NULL, NULL, '');
INSERT INTO grupo VALUES (2, 1, '1º NÍVEL', '2012-01-01', NULL, 'Atendimento de 1º Nível.', 'S', 'SDNIVEL1', NULL, NULL, NULL, '');
INSERT INTO grupo VALUES (3, 1, '2º NÍVEL', '2012-01-01', NULL, 'Atendimento de 2º Nível.', 'S', 'SDNIVEL2', NULL, NULL, NULL, '');
INSERT INTO grupo VALUES (4, 1, '3º NÍVEL - Infraestrutura', '2012-01-01', NULL, 'Atendimento de 3º Nível - Infraestrutura', 'S', 'SDNIVEL3Infra', NULL, NULL, NULL, '');
INSERT INTO grupo VALUES (5, 1, 'Qualidade', '2012-01-01', NULL, 'Alterado por valdoílo para teste.', 'S', 'QUALIDADE', NULL, NULL, NULL, '');
INSERT INTO grupo VALUES (6, 1, 'Gestores Internos', '2012-01-01', NULL, 'Gestores Internos', 'S', 'GESTORES', NULL, NULL, NULL, '');
INSERT INTO grupo VALUES (7, 1, 'Coordenadores Externos', '2012-01-01', NULL, 'Coordenadores Externos', 'N', 'COORD_EXT', NULL, NULL, NULL, '');
INSERT INTO grupo VALUES (16, 1, '3º NÍVEL - Aplicação', '2012-01-01', NULL, '3º NÍVEL - Aplicação', 'S', 'SDNIVEL3Apli', NULL, NULL, NULL, '');
INSERT INTO grupo VALUES (17, 1, '3º NÍVEL - Sistemas', '2012-01-01', NULL, '3º NÍVEL - Sistemas', 'S', 'SDNIVEL3Sist', NULL, NULL, NULL, '');
INSERT INTO grupo VALUES (18, 1, 'Coordenador', '2012-01-01', NULL, 'Coordenador de Infraestrutura', 'S', 'COORDENAÇÃO', NULL, NULL, NULL, '');
INSERT INTO grupo VALUES (19, 1, '3º NÍVEL - Telefonia', '2012-01-01', NULL, '3º NÍVEL - Telefonia', 'N', 'SDNIVEL3Telefonia', NULL, NULL, NULL, '');
INSERT INTO grupo VALUES (20, 1, 'Gerentes', '2012-01-01', NULL, '', 'S', 'GER', NULL, NULL, NULL, '');


--
-- TOC entry 6197 (class 0 OID 2247410)
-- Dependencies: 289 6388
-- Data for Name: grupoatvperiodica; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6198 (class 0 OID 2247419)
-- Dependencies: 290 6388
-- Data for Name: grupoitemconfiguracao; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6199 (class 0 OID 2247426)
-- Dependencies: 291 6388
-- Data for Name: grupoquestionario; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6200 (class 0 OID 2247432)
-- Dependencies: 292 6388
-- Data for Name: gruporecursos; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6201 (class 0 OID 2247438)
-- Dependencies: 293 6388
-- Data for Name: gruposemails; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6202 (class 0 OID 2247444)
-- Dependencies: 294 6388
-- Data for Name: gruposempregados; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO gruposempregados VALUES (2, 1, 'N');
INSERT INTO gruposempregados VALUES (2, 2, 'N');
INSERT INTO gruposempregados VALUES (2, 3, 'N');
INSERT INTO gruposempregados VALUES (3, 1, 'N');
INSERT INTO gruposempregados VALUES (3, 3, 'N');
INSERT INTO gruposempregados VALUES (4, 1, 'N');
INSERT INTO gruposempregados VALUES (4, 3, 'N');
INSERT INTO gruposempregados VALUES (16, 3, 'N');
INSERT INTO gruposempregados VALUES (17, 1, 'N');
INSERT INTO gruposempregados VALUES (17, 3, 'N');
INSERT INTO gruposempregados VALUES (18, 1, 'N');
INSERT INTO gruposempregados VALUES (19, 1, 'N');
INSERT INTO gruposempregados VALUES (19, 3, 'N');


--
-- TOC entry 6203 (class 0 OID 2247451)
-- Dependencies: 295 6388
-- Data for Name: grupovisao; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO grupovisao VALUES (3, 7, 'Visão de Empresa', '1', 0, 'A');
INSERT INTO grupovisao VALUES (7, 8, 'Listagem de Empregados', '1', 0, 'A');
INSERT INTO grupovisao VALUES (8, 9, 'Endereços', '1', 0, 'A');
INSERT INTO grupovisao VALUES (12, 10, 'Grupos de Segurança do Empregado', '1', 0, 'A');
INSERT INTO grupovisao VALUES (15, 5, 'Visão Empregados', '1', 0, 'A');
INSERT INTO grupovisao VALUES (19, 13, 'Listagem de Fluxos', '1', 0, 'A');
INSERT INTO grupovisao VALUES (114, 39, 'Pesquisa Causa de Incidentes', '1', 0, 'A');
INSERT INTO grupovisao VALUES (120, 45, '$grupo.recursos.lista', '1', 0, 'A');
INSERT INTO grupovisao VALUES (121, 46, '$nagios.conexao.listagem', '1', 0, 'A');
INSERT INTO grupovisao VALUES (122, 47, '$requisitosla.pesquisasla', '1', 0, 'A');
INSERT INTO grupovisao VALUES (123, 48, '$visao.listagemAcordoNivelServico', '1', 0, 'A');
INSERT INTO grupovisao VALUES (124, 22, '$visao.listagemClientes', '1', 0, 'A');
INSERT INTO grupovisao VALUES (125, 49, '$visao.listagemConexoesExternas', '1', 0, 'A');
INSERT INTO grupovisao VALUES (126, 25, '$visao.listagemContratos', '1', 0, 'A');
INSERT INTO grupovisao VALUES (127, 50, '$visao.listagemEmpregados', '1', 0, 'A');
INSERT INTO grupovisao VALUES (128, 51, '$visao.listagemFluxos', '1', 0, 'A');
INSERT INTO grupovisao VALUES (129, 52, '$visao.listagemFluxoTrabalho', '1', 0, 'A');
INSERT INTO grupovisao VALUES (130, 24, '$visao.listagemFornecedores', '1', 0, 'A');
INSERT INTO grupovisao VALUES (131, 35, '$visao.listagemLocalExecucaoServico', '1', 0, 'A');
INSERT INTO grupovisao VALUES (132, 18, '$visao.listagemServicosCriacao', '1', 0, 'A');
INSERT INTO grupovisao VALUES (133, 31, '$visao.listagemTipoEventoServico', '1', 0, 'A');
INSERT INTO grupovisao VALUES (134, 53, '$visao.pesquisaCategoriaSolucao', '1', 0, 'A');
INSERT INTO grupovisao VALUES (135, 41, '$visao.pesquisaCausaIncidentes', '1', 0, 'A');
INSERT INTO grupovisao VALUES (136, 43, '$visao.pesquisaGrupoAtividadePeriodica', '1', 0, 'A');
INSERT INTO grupovisao VALUES (137, 37, '$visao.pesquisaJustificativaSolicitacao', '1', 0, 'A');
INSERT INTO grupovisao VALUES (138, 33, '$visao.pesquisaTipoSolicitacaoServico', '1', 0, 'A');
INSERT INTO grupovisao VALUES (139, 54, '$contrato.historicoauditoria', '1', 0, 'A');
INSERT INTO grupovisao VALUES (140, 55, '$grupo.recursos', '1', 0, 'A');
INSERT INTO grupovisao VALUES (141, 32, '$menu.nome.tipoSolicitacaoServico', '1', 0, 'A');
INSERT INTO grupovisao VALUES (142, 56, '$nagios.conexao.titulo', '1', 0, 'A');
INSERT INTO grupovisao VALUES (143, 57, '$requisitosla.sla', '1', 0, 'A');
INSERT INTO grupovisao VALUES (144, 58, '$sla.historicoauditoria', '1', 0, 'A');
INSERT INTO grupovisao VALUES (145, 59, '$sla.listacontratosvinculadosano', '1', 0, 'A');
INSERT INTO grupovisao VALUES (146, 60, '$sla.listacontratosvinculadoscliente', '1', 0, 'A');
INSERT INTO grupovisao VALUES (147, 61, '$sla.listacontratosvinculadosterceiro', '1', 0, 'A');
INSERT INTO grupovisao VALUES (148, 62, '$slarequisitosla.titulo', '1', 0, 'A');
INSERT INTO grupovisao VALUES (149, 63, '$sla.revisar.revisar', '1', 0, 'A');
INSERT INTO grupovisao VALUES (150, 28, '$visao.acordoNivelServicoContrato', '1', 0, 'A');
INSERT INTO grupovisao VALUES (151, 14, '$visao.cadastroFluxos', '1', 0, 'A');
INSERT INTO grupovisao VALUES (152, 64, '$visao.complexidades', '1', 0, 'A');
INSERT INTO grupovisao VALUES (153, 29, '$visao.fluxoServico', '1', 0, 'A');
INSERT INTO grupovisao VALUES (154, 65, '$visao.historicoAuditoriaServico', '1', 0, 'A');
INSERT INTO grupovisao VALUES (155, 66, '$visao.vincularSlaServico', '1', 0, 'A');
INSERT INTO grupovisao VALUES (156, 67, '$visao.acordoGeral', '1', 0, 'A');
INSERT INTO grupovisao VALUES (157, 26, '$visao.acordoNivelServico', '1', 0, 'A');
INSERT INTO grupovisao VALUES (158, 15, '$visao.analiseIncidente', '1', 0, 'A');
INSERT INTO grupovisao VALUES (159, 16, '$visao.atendimento', '1', 0, 'A');
INSERT INTO grupovisao VALUES (160, 27, '$visao.atividadesServico', '1', 0, 'A');
INSERT INTO grupovisao VALUES (161, 30, '$visao.CadastroTipoEventoServico', '1', 0, 'A');
INSERT INTO grupovisao VALUES (162, 40, '$visao.categoriaSolucao', '1', 0, 'A');
INSERT INTO grupovisao VALUES (163, 38, '$visao.causaIncidentes', '1', 0, 'A');
INSERT INTO grupovisao VALUES (164, 21, '$visao.clientes', '1', 0, 'A');
INSERT INTO grupovisao VALUES (165, 68, '$visao.conexoesExternas', '1', 0, 'A');
INSERT INTO grupovisao VALUES (166, 20, '$visao.contratos', '1', 0, 'A');
INSERT INTO grupovisao VALUES (167, 17, '$visao.criacaoServicos', '1', 0, 'A');
INSERT INTO grupovisao VALUES (168, 69, '$visao.enderecos', '1', 0, 'A');
INSERT INTO grupovisao VALUES (169, 23, '$visao.fornecedores', '1', 0, 'A');
INSERT INTO grupovisao VALUES (170, 42, '$visao.grupoAtividadePeriodica', '1', 0, 'A');
INSERT INTO grupovisao VALUES (171, 70, '$visao.gruposSegurancaEmpregados', '1', 0, 'A');
INSERT INTO grupovisao VALUES (172, 12, '$visao.incidente', '1', 0, 'A');
INSERT INTO grupovisao VALUES (173, 36, '$visao.justificativaSolicitacao', '1', 0, 'A');
INSERT INTO grupovisao VALUES (174, 34, '$visao.localExecucaoServico', '1', 0, 'A');
INSERT INTO grupovisao VALUES (175, 19, '$visao.servicoContrato', '1', 0, 'A');
INSERT INTO grupovisao VALUES (176, 44, '$visao.servicoContratoMulti', '1', 0, 'A');
INSERT INTO grupovisao VALUES (177, 71, '$visao.visaoEmpregados', '1', 0, 'A');
INSERT INTO grupovisao VALUES (178, 72, '$visao.visaoEmpresa', '1', 0, 'A');


--
-- TOC entry 6204 (class 0 OID 2247460)
-- Dependencies: 296 6388
-- Data for Name: grupovisaocamposnegocio; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6205 (class 0 OID 2247470)
-- Dependencies: 297 6388
-- Data for Name: grupovisaocamposnegocioinfosql; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6206 (class 0 OID 2247480)
-- Dependencies: 298 6388
-- Data for Name: grupovisaocamposnegocioligacao; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6207 (class 0 OID 2247491)
-- Dependencies: 299 6388
-- Data for Name: hilosequences; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6208 (class 0 OID 2247496)
-- Dependencies: 300 6388
-- Data for Name: historicobaseconhecimento; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO historicobaseconhecimento VALUES (1, 1, 1, '2013-04-08', NULL, 'Conhecimento 1', 'Descri&ccedil;&atilde;o Conhecimento 1<br />', 'S', NULL, '2014-12-31', '1.0', 1, 1, 'Conhecimento 1', NULL, '2013-04-08', 'Justificativa Conhecimento 1', NULL, '1', 'N', 1, '2013-04-08 13:12:20', NULL);
INSERT INTO historicobaseconhecimento VALUES (2, 2, 2, '2013-04-08', NULL, 'Conhecimento 2', 'Descri&ccedil;&atilde;o Conhecimento 2<br />', 'S', NULL, '2014-12-31', '1.0', 1, 1, '', NULL, '2013-04-08', 'Justificativa Conhecimento 2', NULL, '1', 'N', 1, '2013-04-08 13:15:22', NULL);
INSERT INTO historicobaseconhecimento VALUES (3, 3, 1, '2013-04-08', NULL, 'FAQ 1', 'Resposta FAQ 1<br />', 'S', NULL, '2014-12-31', '1.0', 1, 1, 'FAQ 1', NULL, '2013-04-08', 'Justificativa FAQ 1', 'S', '1', 'N', 1, '2013-04-08 13:16:54', NULL);
INSERT INTO historicobaseconhecimento VALUES (4, 4, 2, '2013-04-08', NULL, 'FAQ 2', 'Resposta FAQ 2', 'S', NULL, '2014-12-31', '1.0', 1, 1, 'FAQ 2', NULL, '2013-04-08', 'Justificativa FAQ 2', 'S', '1', 'N', 1, '2013-04-08 13:19:35', NULL);


--
-- TOC entry 6209 (class 0 OID 2247512)
-- Dependencies: 301 6388
-- Data for Name: historicoexecucao; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6210 (class 0 OID 2247521)
-- Dependencies: 302 6388
-- Data for Name: historicoic; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6211 (class 0 OID 2247544)
-- Dependencies: 303 6388
-- Data for Name: historicosituacaocotacao; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6212 (class 0 OID 2247564)
-- Dependencies: 304 6388
-- Data for Name: historicotentativa; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6213 (class 0 OID 2247576)
-- Dependencies: 305 6388
-- Data for Name: historicovalor; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6214 (class 0 OID 2247591)
-- Dependencies: 306 6388
-- Data for Name: htmlcodevisao; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6215 (class 0 OID 2247600)
-- Dependencies: 307 6388
-- Data for Name: imagemhistorico; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6216 (class 0 OID 2247610)
-- Dependencies: 308 6388
-- Data for Name: imagemitemconfiguracao; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6217 (class 0 OID 2247623)
-- Dependencies: 309 6388
-- Data for Name: imagemservicorelacionado; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6218 (class 0 OID 2247636)
-- Dependencies: 310 6388
-- Data for Name: impacto; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO impacto VALUES (1, 'Altíssimo', 'AL');
INSERT INTO impacto VALUES (2, 'Alto', 'A ');
INSERT INTO impacto VALUES (3, 'Elevado', 'E ');
INSERT INTO impacto VALUES (4, 'Médio', 'M ');
INSERT INTO impacto VALUES (5, 'Baixo', 'B ');


--
-- TOC entry 6219 (class 0 OID 2247642)
-- Dependencies: 311 6388
-- Data for Name: importanciaconhecimentogrupo; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6220 (class 0 OID 2247647)
-- Dependencies: 312 6388
-- Data for Name: importanciaconhecimentousuario; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6221 (class 0 OID 2247652)
-- Dependencies: 313 6388
-- Data for Name: importancianegocio; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO importancianegocio VALUES (1, 1, 'Baixa', 'A');
INSERT INTO importancianegocio VALUES (3, 1, 'Média', 'A');
INSERT INTO importancianegocio VALUES (4, 1, 'Alta', 'A');
INSERT INTO importancianegocio VALUES (10, 1, 'A combinar', 'A');
INSERT INTO importancianegocio VALUES (11, 1, 'Normal', 'A');


--
-- TOC entry 6222 (class 0 OID 2247658)
-- Dependencies: 314 6388
-- Data for Name: importconfig; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6223 (class 0 OID 2247675)
-- Dependencies: 315 6388
-- Data for Name: importconfigcampos; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6224 (class 0 OID 2247691)
-- Dependencies: 316 6388
-- Data for Name: infocatalogoservico; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6226 (class 0 OID 2247703)
-- Dependencies: 318 6388
-- Data for Name: informacaoservico; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6505 (class 0 OID 0)
-- Dependencies: 317
-- Name: informacaoservico_idinformacaoservico_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('informacaoservico_idinformacaoservico_seq', 1, false);


--
-- TOC entry 6227 (class 0 OID 2247718)
-- Dependencies: 319 6388
-- Data for Name: informacoescontratoconfig; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6228 (class 0 OID 2247738)
-- Dependencies: 320 6388
-- Data for Name: informacoescontratoperfseg; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6229 (class 0 OID 2247744)
-- Dependencies: 321 6388
-- Data for Name: inspecaoentregaitem; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6230 (class 0 OID 2247768)
-- Dependencies: 322 6388
-- Data for Name: inspecaopedidocompra; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6231 (class 0 OID 2247792)
-- Dependencies: 323 6388
-- Data for Name: inventarioxml; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6232 (class 0 OID 2247802)
-- Dependencies: 324 6388
-- Data for Name: itemcfgsolicitacaoserv; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6233 (class 0 OID 2247807)
-- Dependencies: 325 6388
-- Data for Name: itemconfiguracao; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6234 (class 0 OID 2247843)
-- Dependencies: 326 6388
-- Data for Name: itemconfiguracaoevento; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6235 (class 0 OID 2247856)
-- Dependencies: 327 6388
-- Data for Name: itemcotacao; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6236 (class 0 OID 2247887)
-- Dependencies: 328 6388
-- Data for Name: itempedidocompra; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6237 (class 0 OID 2247905)
-- Dependencies: 329 6388
-- Data for Name: itemrequisicaoproduto; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6238 (class 0 OID 2247938)
-- Dependencies: 330 6388
-- Data for Name: jornadatrabalho; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO jornadatrabalho VALUES (1, 'Service Desk (Semana)', '08:00', '20:00', '     ', '     ', '     ', '     ', '     ', '     ', '     ', '     ', '12:00', NULL, NULL);
INSERT INTO jornadatrabalho VALUES (2, 'Service Desk (Fim de semana)', '08:00', '15:00', '     ', '     ', '     ', '     ', '     ', '     ', '     ', '     ', '07:00', NULL, NULL);


--
-- TOC entry 6239 (class 0 OID 2247954)
-- Dependencies: 331 6388
-- Data for Name: justificacaofalha; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6240 (class 0 OID 2247968)
-- Dependencies: 332 6388
-- Data for Name: justificativamudanca; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6241 (class 0 OID 2247975)
-- Dependencies: 333 6388
-- Data for Name: justificativaparecer; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6242 (class 0 OID 2247984)
-- Dependencies: 334 6388
-- Data for Name: justificativasolicitacao; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6243 (class 0 OID 2247991)
-- Dependencies: 335 6388
-- Data for Name: liberacao; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6244 (class 0 OID 2248002)
-- Dependencies: 336 6388
-- Data for Name: liberacaomudanca; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6245 (class 0 OID 2248008)
-- Dependencies: 337 6388
-- Data for Name: limitealcada; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6246 (class 0 OID 2248028)
-- Dependencies: 338 6388
-- Data for Name: lingua; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO lingua VALUES (1, 'Português', 'PT', '2013-01-30', NULL);
INSERT INTO lingua VALUES (2, 'Inglês', 'EN', '2013-01-30', NULL);
INSERT INTO lingua VALUES (3, 'Espanhol', 'ES', '2013-01-30', NULL);


--
-- TOC entry 6247 (class 0 OID 2248035)
-- Dependencies: 339 6388
-- Data for Name: localexecucaoservico; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO localexecucaoservico VALUES (1, 'Interno', 'N');
INSERT INTO localexecucaoservico VALUES (2, 'Externo', 'N');
INSERT INTO localexecucaoservico VALUES (4, 'Interno/Externo', NULL);


--
-- TOC entry 6248 (class 0 OID 2248041)
-- Dependencies: 340 6388
-- Data for Name: localidade; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6249 (class 0 OID 2248047)
-- Dependencies: 341 6388
-- Data for Name: localidadeunidade; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6251 (class 0 OID 2248060)
-- Dependencies: 343 6388
-- Data for Name: logdados; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6506 (class 0 OID 0)
-- Dependencies: 342
-- Name: logdados_idlog_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('logdados_idlog_seq', 1, false);


--
-- TOC entry 6252 (class 0 OID 2248076)
-- Dependencies: 344 6388
-- Data for Name: marca; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6253 (class 0 OID 2248087)
-- Dependencies: 345 6388
-- Data for Name: matrizprioridade; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO matrizprioridade VALUES (1, 'AL', 'B ', 2, NULL, ' ');
INSERT INTO matrizprioridade VALUES (2, 'AL', 'M ', 2, NULL, ' ');
INSERT INTO matrizprioridade VALUES (3, 'AL', 'A ', 1, NULL, ' ');
INSERT INTO matrizprioridade VALUES (4, 'AL', 'C ', 1, NULL, ' ');
INSERT INTO matrizprioridade VALUES (5, 'A ', 'B ', 3, NULL, ' ');
INSERT INTO matrizprioridade VALUES (6, 'A ', 'M ', 2, NULL, ' ');
INSERT INTO matrizprioridade VALUES (7, 'A ', 'A ', 2, NULL, ' ');
INSERT INTO matrizprioridade VALUES (8, 'A ', 'C ', 1, NULL, ' ');
INSERT INTO matrizprioridade VALUES (9, 'E ', 'B ', 3, NULL, ' ');
INSERT INTO matrizprioridade VALUES (10, 'E ', 'M ', 3, NULL, ' ');
INSERT INTO matrizprioridade VALUES (11, 'E ', 'A ', 2, NULL, ' ');
INSERT INTO matrizprioridade VALUES (12, 'E ', 'C ', 2, NULL, ' ');
INSERT INTO matrizprioridade VALUES (13, 'M ', 'B ', 4, NULL, ' ');
INSERT INTO matrizprioridade VALUES (14, 'M ', 'M ', 3, NULL, ' ');
INSERT INTO matrizprioridade VALUES (15, 'M ', 'A ', 3, NULL, ' ');
INSERT INTO matrizprioridade VALUES (16, 'M ', 'C ', 2, NULL, ' ');
INSERT INTO matrizprioridade VALUES (17, 'B ', 'B ', 5, NULL, ' ');
INSERT INTO matrizprioridade VALUES (18, 'B ', 'M ', 4, NULL, ' ');
INSERT INTO matrizprioridade VALUES (19, 'B ', 'A ', 3, NULL, ' ');
INSERT INTO matrizprioridade VALUES (20, 'B ', 'C ', 3, NULL, ' ');


--
-- TOC entry 6254 (class 0 OID 2248093)
-- Dependencies: 346 6388
-- Data for Name: matrizvisao; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6255 (class 0 OID 2248127)
-- Dependencies: 347 6388
-- Data for Name: menu; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6256 (class 0 OID 2248144)
-- Dependencies: 348 6388
-- Data for Name: meucatalogo; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6257 (class 0 OID 2248149)
-- Dependencies: 349 6388
-- Data for Name: midia; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO midia (idmidia, nome) VALUES (1, 'Blu-ray'), (2, 'Cartão de Memória'), (3, 'CD'), (4, 'Disquete'), (5, 'DVD'), (6, 'Fita Magnética'), (7, 'HD'), (8, 'Pen drive'), (9, 'Outros');

--
-- TOC entry 6258 (class 0 OID 2248156)
-- Dependencies: 350 6388
-- Data for Name: midiasoftware; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6259 (class 0 OID 2248169)
-- Dependencies: 351 6388
-- Data for Name: modelosemails; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO modelosemails VALUES (1, 'Solicitação registrada -  ${IDSOLICITACAOSERVICO}', 'Senhor(a) ${NOMECONTATO},<br /><br />Informamos que a sua solicita&ccedil;&atilde;o foi registrada em ${DATAHORASOLICITACAOSTR}, conforme os dados abaixo:<br /><br /><strong>N&uacute;mero:</strong> ${IDSOLICITACAOSERVICO}<br /><strong>Tipo:</strong> ${DEMANDA}<br /><strong>Servi&ccedil;o:</strong> ${SERVICO}<br /><br /><strong>Descri&ccedil;&atilde;o:</strong> <br />${DESCRICAO}<br /><br />Atenciosamente,<br /><br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda<br /><br /><br /><br /><br /><br />', 'A', NULL);
INSERT INTO modelosemails VALUES (2, 'Solicitação atendida - ${IDSOLICITACAOSERVICO}', 'Senhor(a) ${NOMECONTATO},<br /><br />Informamos que a sua solicita&ccedil;&atilde;o foi atendida em ${DATAHORAFIM}, conforme os dados abaixo:<br /><br /><strong>N&uacute;mero:</strong> ${IDSOLICITACAOSERVICO}<br /><strong>Tipo:</strong> ${DEMANDA}<br /><strong>Servi&ccedil;o:</strong> ${SERVICO}<br /><br /><strong>Descri&ccedil;&atilde;o:</strong> <br />${DESCRICAO}<br /><br /><strong>Resposta do grupo solucionador:</strong><br />${RESPOSTA}<br /><br />${LINKPESQUISASATISFACAO}<br />Caso a solu&ccedil;&atilde;o n&atilde;o lhe atenda, a solicita&ccedil;&atilde;o poder&aacute; ser reaberta.<br /><br />Atenciosamente,<br /><br />Central IT&nbsp;Tecnologia da Informa&ccedil;&atilde;o Ltda<br />', 'A', NULL);
INSERT INTO modelosemails VALUES (3, 'Solicitação em atendimento - ${IDSOLICITACAOSERVICO}', 'Senhor(a) ${NOMECONTATO},<br /><br />Informamos que a sua solicita&ccedil;&atilde;o registrada ${DATAHORASOLICITACAOSTR} est&aacute; em atendimento, conforme os dados abaixo:<br /><br /><strong>N&uacute;mero:</strong> ${IDSOLICITACAOSERVICO}<br /><strong>Tipo:</strong> ${DEMANDA}<br /><strong>Servi&ccedil;o:</strong> ${SERVICO}<br /><br /><strong>Descri&ccedil;&atilde;o:</strong> <br />${DESCRICAO}<br /><strong><br />Tarefa executada:</strong> ${NOMETAREFA}<br /><strong>Grupo de atendimento:</strong> ${GRUPOATUAL}<br /><br />Atenciosamente,<br /><br />Central IT&nbsp;Tecnologia da Informa&ccedil;&atilde;o Ltda<br />', 'A', NULL);
INSERT INTO modelosemails VALUES (6, 'Validade do Item configuração - ${IDENTIFICACAO}', 'Informamos que o item de configura&ccedil;&atilde;o identificado como ${IDENTIFICACAO} expirar&aacute; no dia&nbsp;${DATAEXPIRACAO}.<br /><br /><br />Atenciosamente,<br /><br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.<br />', 'A', '');
INSERT INTO modelosemails VALUES (7, 'Validade do documento - ${TITULO}', 'Informamos que o documento titulado como ${TITULO} expirar&aacute; no dia&nbsp;${DATAEXPIRACAO}.<br /><br /><br />Atenciosamente,<br /><br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.<br />', 'A', 'bc');
INSERT INTO modelosemails VALUES (8, 'Criação da Pasta - ${NOME}', 'Informamos que foi criado a pasta ${NOME}.<br /><br /><br />Atenciosamente,<br /><br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.<br />', 'A', 'cp');
INSERT INTO modelosemails VALUES (9, 'Alteração da Pasta - ${NOME}', 'Informamos que a pasta ${NOME} foi alterada.<br /><br /><br />Atenciosamente,<br /><br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.<br />', 'A', 'ap');
INSERT INTO modelosemails VALUES (10, 'Exclusão da pasta - ${NOME}', 'Informamos que a pasta ${NOME} foi exclu&iacute;da.<br /><br /><br />Atenciosamente,<br /><br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.', 'A', 'ep');
INSERT INTO modelosemails VALUES (11, 'Criação do documento - ${TITULO}', 'Informamos que foi criado o documento ${TITULO}.<br /><br /><br />Atenciosamente,<br /><br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.<br />', 'A', 'cc');
INSERT INTO modelosemails VALUES (12, 'Alteração do documento - ${TITULO}', 'Informamos que o documento ${TITULO} foi alterado.<br /><br /><br />Atenciosamente,<br /><br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.<br />', 'A', 'ac');
INSERT INTO modelosemails VALUES (13, 'Exclusão do documento - ${TITULO}', 'Informamos que o documento ${TITULO} foi exclu&iacute;do.<br /><br /><br />Atenciosamente,<br /><br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.<br />', 'A', 'ec');
INSERT INTO modelosemails VALUES (14, 'Alteração do Item configuração - ${IDENTIFICACAO}', 'Informamos que o item de configura&ccedil;&atilde;o identificado como ${IDENTIFICACAO} sofreu altera&ccedil;&atilde;o.<br /><br /><br />Atenciosamente,<br /><br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.', 'A', 'alteracaoIC');
INSERT INTO modelosemails VALUES (15, 'Alteração do Item configuração para Grupo- ${IDENTIFICACAO}', 'Informamos que o item de configura&ccedil;&atilde;o identificado como ${IDENTIFICACAO} foi alterado para o Grupo ${NOMEGRUPOITEMCONFIGURACAO}<br /><br />Atenciosamente,<br /><br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.', 'A', 'alteracaoICGrupo');
INSERT INTO modelosemails VALUES (16, 'Criação do Item configuração - ${IDENTIFICACAO}', 'Informamos a cria&ccedil;&atilde;o do item de configura&ccedil;&atilde;o identificado como ${IDENTIFICACAO} .<br /><br /><br />Atenciosamente,<br /><br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.', 'A', 'CriacaoIC');
INSERT INTO modelosemails VALUES (17, 'Alteração Serviço - ${NOMESERVICO}', 'Informamos que o servi&ccedil;o identificado como ${NOMESERVICO} sofreu altera&ccedil;&atilde;o.<br /><br /><br />Atenciosamente,<br /><br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.', 'A', 'alteracaoServico');


--
-- TOC entry 6260 (class 0 OID 2248178)
-- Dependencies: 352 6388
-- Data for Name: moedas; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO moedas VALUES (1, 'Real');
INSERT INTO moedas VALUES (2, 'UST');


--
-- TOC entry 6261 (class 0 OID 2248183)
-- Dependencies: 353 6388
-- Data for Name: motivosuspensaoativid; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6262 (class 0 OID 2248188)
-- Dependencies: 354 6388
-- Data for Name: nagiosconexao; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6263 (class 0 OID 2248200)
-- Dependencies: 355 6388
-- Data for Name: netmap; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6264 (class 0 OID 2248210)
-- Dependencies: 356 6388
-- Data for Name: notificacao; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6265 (class 0 OID 2248217)
-- Dependencies: 357 6388
-- Data for Name: notificacaogrupo; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6266 (class 0 OID 2248232)
-- Dependencies: 358 6388
-- Data for Name: notificacaoservico; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6267 (class 0 OID 2248235)
-- Dependencies: 359 6388
-- Data for Name: notificacaousuario; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6268 (class 0 OID 2248245)
-- Dependencies: 360 6388
-- Data for Name: objetivomonitoramento; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6269 (class 0 OID 2248259)
-- Dependencies: 361 6388
-- Data for Name: objetivoplanomelhoria; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6270 (class 0 OID 2248272)
-- Dependencies: 362 6388
-- Data for Name: objetonegocio; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6271 (class 0 OID 2248280)
-- Dependencies: 363 6388
-- Data for Name: ocorrenciamudanca; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6272 (class 0 OID 2248306)
-- Dependencies: 364 6388
-- Data for Name: ocorrencias; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6273 (class 0 OID 2248316)
-- Dependencies: 365 6388
-- Data for Name: ocorrenciasolicitacao; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO ocorrenciasolicitacao VALUES (1, NULL, 1, NULL, '2013-04-05', '09:40', 'Consultor', 'Registro da Solicitação', '2013-04-05', '2013-04-05', NULL, '{"idSolicitacaoServico":1,"idContatoSolicitacaoServico":1,"idServicoContrato":1,"idSolicitante":2,"idOrigem":1,"idPrioridade":5,"filtroADPesq":"","idUnidade":1,"dataHoraSolicitacao":"Apr 5, 2013 9:40:01 AM","prazoCapturaHH":0,"prazoCapturaMM":0,"prazoHH":0,"prazoMM":0,"descricao":"Descri\u0026ccedil;\u0026atilde;o do Incidente ou Requisi\u0026ccedil;\u0026atilde;o\u003cbr /\u003e","resposta":"","dataHoraInicio":"Apr 5, 2013 9:40:01 AM","situacao":"EmAndamento","seqReabertura":0,"enviaEmailCriacao":"S","enviaEmailFinalizacao":"S","slaACombinar":"S","idCalendario":1,"tempoDecorridoHH":0,"tempoDecorridoMM":0,"situacaoSLA":"N","descrSituacao":"Em andamento","atrasoSLA":0.0,"idContrato":1,"solicitante":"Default","dataHoraSolicitacaoStr":"05/04/2013 09:40","usuarioDto":{"idUsuario":3,"idEmpregado":3,"idPerfilAcessoUsuario":1,"idEmpresa":1,"login":"consultor","nomeUsuario":"Consultor","status":"A","grupos":["SDNIVEL1","SDNIVEL2","SDNIVEL3Apli","SDNIVEL3Infra","SDNIVEL3Sist","SDNIVEL3Telefonia"],"locale":"","colGrupos":[{"idGrupo":2,"nome":"1º NÍVEL","sigla":"SDNIVEL1","serviceDesk":"S"},{"idGrupo":3,"nome":"2º NÍVEL","sigla":"SDNIVEL2","serviceDesk":"S"},{"idGrupo":16,"nome":"3º NÍVEL - Aplicação","sigla":"SDNIVEL3Apli","serviceDesk":"S"},{"idGrupo":4,"nome":"3º NÍVEL - Infraestrutura","sigla":"SDNIVEL3Infra","serviceDesk":"S"},{"idGrupo":17,"nome":"3º NÍVEL - Sistemas","sigla":"SDNIVEL3Sist","serviceDesk":"S"},{"idGrupo":19,"nome":"3º NÍVEL - Telefonia","sigla":"SDNIVEL3Telefonia","serviceDesk":"N"}]},"acaoFluxo":"","idTipoDemandaServico":3,"idServico":1,"itemConfiguracao":"","messageId":"","nomecontato":"Default","telefonecontato":"3242-4433","emailcontato":"citsmart_instalador_mysql@centralit.com.br","observacao":"","reclassificar":"","escalar":"","alterarSituacao":"","detalhamentoCausa":"","solucaoTemporaria":"N","nomeServico":"Serviço 1","ramal":"","idAcordoNivelServico":1,"registradoPor":"Consultor","registroexecucao":"","impacto":"B","urgencia":"B","descricaoSemFormatacao":"Descrição do Incidente ou Requisição","idResponsavel":3,"idGrupoAtual":2,"idGrupoNivel1":2}', '{"idcontatosolicitacaoservico":1,"nomecontato":"Default","telefonecontato":"3242-4433","emailcontato":"citsmart_instalador_mysql@centralit.com.br","observacao":""}', 'Criacao', 'O', 0, NULL, NULL, NULL);
INSERT INTO ocorrenciasolicitacao VALUES (2, NULL, 1, NULL, '2013-04-05', '09:40', 'Automático', 'Inicio do SLA', '2013-04-05', '2013-04-05', NULL, '{"idSolicitacaoServico":1,"idContatoSolicitacaoServico":1,"idServicoContrato":1,"idSolicitante":2,"idOrigem":1,"idPrioridade":5,"filtroADPesq":"","idUnidade":1,"idFaseAtual":2,"dataHoraSolicitacao":"Apr 5, 2013 9:40:01 AM","prazoCapturaHH":0,"prazoCapturaMM":0,"prazoHH":0,"prazoMM":0,"descricao":"Descri\u0026ccedil;\u0026atilde;o do Incidente ou Requisi\u0026ccedil;\u0026atilde;o\u003cbr /\u003e","resposta":"","dataHoraInicio":"Apr 5, 2013 9:40:01 AM","situacao":"EmAndamento","seqReabertura":0,"enviaEmailCriacao":"S","enviaEmailFinalizacao":"S","slaACombinar":"S","idCalendario":1,"tempoDecorridoHH":0,"tempoDecorridoMM":0,"situacaoSLA":"A","dataHoraInicioSLA":"Apr 5, 2013 9:40:01 AM","descrSituacao":"Em andamento","dataHoraLimite":"Apr 5, 2013 9:40:00 AM","dataHoraLimiteStr":"05/04/2013 09:40","dataHoraInicioSLAStr":"05/04/2013 09:40:01","atrasoSLA":0.0,"idContrato":1,"solicitante":"Default","dataHoraSolicitacaoStr":"05/04/2013 09:40","usuarioDto":{"idUsuario":3,"idEmpregado":3,"idPerfilAcessoUsuario":1,"idEmpresa":1,"login":"consultor","nomeUsuario":"Consultor","status":"A","grupos":["SDNIVEL1","SDNIVEL2","SDNIVEL3Apli","SDNIVEL3Infra","SDNIVEL3Sist","SDNIVEL3Telefonia"],"locale":"","colGrupos":[{"idGrupo":2,"nome":"1º NÍVEL","sigla":"SDNIVEL1","serviceDesk":"S"},{"idGrupo":3,"nome":"2º NÍVEL","sigla":"SDNIVEL2","serviceDesk":"S"},{"idGrupo":16,"nome":"3º NÍVEL - Aplicação","sigla":"SDNIVEL3Apli","serviceDesk":"S"},{"idGrupo":4,"nome":"3º NÍVEL - Infraestrutura","sigla":"SDNIVEL3Infra","serviceDesk":"S"},{"idGrupo":17,"nome":"3º NÍVEL - Sistemas","sigla":"SDNIVEL3Sist","serviceDesk":"S"},{"idGrupo":19,"nome":"3º NÍVEL - Telefonia","sigla":"SDNIVEL3Telefonia","serviceDesk":"N"}]},"grupoAtual":"SDNIVEL1","grupoNivel1":"SDNIVEL1","acaoFluxo":"","idTipoDemandaServico":3,"idServico":1,"itemConfiguracao":"","messageId":"","nomecontato":"Default","telefonecontato":"3242-4433","emailcontato":"citsmart_instalador_mysql@centralit.com.br","observacao":"","reclassificar":"","escalar":"","alterarSituacao":"","detalhamentoCausa":"","solucaoTemporaria":"N","nomeServico":"Serviço 1","ramal":"","idAcordoNivelServico":1,"registradoPor":"Consultor","registroexecucao":"","impacto":"B","urgencia":"B","descricaoSemFormatacao":"Descrição do Incidente ou Requisição","idResponsavel":3,"idGrupoAtual":2,"idGrupoNivel1":2}', NULL, 'InicioSLA', 'O', 0, NULL, NULL, NULL);
INSERT INTO ocorrenciasolicitacao VALUES (3, NULL, 2, NULL, '2013-04-05', '09:43', 'Consultor', 'Registro da Solicitação', '2013-04-05', '2013-04-05', NULL, '{"idSolicitacaoServico":2,"idContatoSolicitacaoServico":2,"idServicoContrato":4,"idSolicitante":2,"idOrigem":1,"idPrioridade":5,"filtroADPesq":"","idUnidade":1,"dataHoraSolicitacao":"Apr 5, 2013 9:43:39 AM","prazoCapturaHH":0,"prazoCapturaMM":0,"prazoHH":0,"prazoMM":0,"descricao":"Descri\u0026ccedil;\u0026atilde;o do Incidente ou Requisi\u0026ccedil;\u0026atilde;o","resposta":"","dataHoraInicio":"Apr 5, 2013 9:43:39 AM","situacao":"EmAndamento","seqReabertura":0,"enviaEmailCriacao":"S","enviaEmailFinalizacao":"S","slaACombinar":"S","idCalendario":1,"tempoDecorridoHH":0,"tempoDecorridoMM":0,"situacaoSLA":"N","descrSituacao":"Em andamento","atrasoSLA":0.0,"idContrato":1,"solicitante":"Default","dataHoraSolicitacaoStr":"05/04/2013 09:43","usuarioDto":{"idUsuario":3,"idEmpregado":3,"idPerfilAcessoUsuario":1,"idEmpresa":1,"login":"consultor","nomeUsuario":"Consultor","status":"A","grupos":["SDNIVEL1","SDNIVEL2","SDNIVEL3Apli","SDNIVEL3Infra","SDNIVEL3Sist","SDNIVEL3Telefonia"],"locale":"","colGrupos":[{"idGrupo":2,"nome":"1º NÍVEL","sigla":"SDNIVEL1","serviceDesk":"S"},{"idGrupo":3,"nome":"2º NÍVEL","sigla":"SDNIVEL2","serviceDesk":"S"},{"idGrupo":16,"nome":"3º NÍVEL - Aplicação","sigla":"SDNIVEL3Apli","serviceDesk":"S"},{"idGrupo":4,"nome":"3º NÍVEL - Infraestrutura","sigla":"SDNIVEL3Infra","serviceDesk":"S"},{"idGrupo":17,"nome":"3º NÍVEL - Sistemas","sigla":"SDNIVEL3Sist","serviceDesk":"S"},{"idGrupo":19,"nome":"3º NÍVEL - Telefonia","sigla":"SDNIVEL3Telefonia","serviceDesk":"N"}]},"acaoFluxo":"","idTipoDemandaServico":1,"idServico":4,"itemConfiguracao":"","messageId":"","nomecontato":"Default","telefonecontato":"3242-4433","emailcontato":"citsmart_instalador_mysql@centralit.com.br","observacao":"","reclassificar":"","escalar":"","alterarSituacao":"","detalhamentoCausa":"","solucaoTemporaria":"N","nomeServico":"Serviço 4","ramal":"","idAcordoNivelServico":2,"registradoPor":"Consultor","registroexecucao":"","impacto":"B","urgencia":"B","descricaoSemFormatacao":"Descrição do Incidente ou Requisição","idResponsavel":3,"idGrupoAtual":2,"idGrupoNivel1":2}', '{"idcontatosolicitacaoservico":2,"nomecontato":"Default","telefonecontato":"3242-4433","emailcontato":"citsmart_instalador_mysql@centralit.com.br","observacao":""}', 'Criacao', 'O', 0, NULL, NULL, NULL);
INSERT INTO ocorrenciasolicitacao VALUES (4, NULL, 2, NULL, '2013-04-05', '09:43', 'Automático', 'Inicio do SLA', '2013-04-05', '2013-04-05', NULL, '{"idSolicitacaoServico":2,"idContatoSolicitacaoServico":2,"idServicoContrato":4,"idSolicitante":2,"idOrigem":1,"idPrioridade":5,"filtroADPesq":"","idUnidade":1,"idFaseAtual":2,"dataHoraSolicitacao":"Apr 5, 2013 9:43:39 AM","prazoCapturaHH":0,"prazoCapturaMM":0,"prazoHH":0,"prazoMM":0,"descricao":"Descri\u0026ccedil;\u0026atilde;o do Incidente ou Requisi\u0026ccedil;\u0026atilde;o","resposta":"","dataHoraInicio":"Apr 5, 2013 9:43:39 AM","situacao":"EmAndamento","seqReabertura":0,"enviaEmailCriacao":"S","enviaEmailFinalizacao":"S","slaACombinar":"S","idCalendario":1,"tempoDecorridoHH":0,"tempoDecorridoMM":0,"situacaoSLA":"A","dataHoraInicioSLA":"Apr 5, 2013 9:43:39 AM","descrSituacao":"Em andamento","dataHoraLimite":"Apr 5, 2013 9:43:00 AM","dataHoraLimiteStr":"05/04/2013 09:43","dataHoraInicioSLAStr":"05/04/2013 09:43:39","atrasoSLA":0.0,"idContrato":1,"solicitante":"Default","dataHoraSolicitacaoStr":"05/04/2013 09:43","usuarioDto":{"idUsuario":3,"idEmpregado":3,"idPerfilAcessoUsuario":1,"idEmpresa":1,"login":"consultor","nomeUsuario":"Consultor","status":"A","grupos":["SDNIVEL1","SDNIVEL2","SDNIVEL3Apli","SDNIVEL3Infra","SDNIVEL3Sist","SDNIVEL3Telefonia"],"locale":"","colGrupos":[{"idGrupo":2,"nome":"1º NÍVEL","sigla":"SDNIVEL1","serviceDesk":"S"},{"idGrupo":3,"nome":"2º NÍVEL","sigla":"SDNIVEL2","serviceDesk":"S"},{"idGrupo":16,"nome":"3º NÍVEL - Aplicação","sigla":"SDNIVEL3Apli","serviceDesk":"S"},{"idGrupo":4,"nome":"3º NÍVEL - Infraestrutura","sigla":"SDNIVEL3Infra","serviceDesk":"S"},{"idGrupo":17,"nome":"3º NÍVEL - Sistemas","sigla":"SDNIVEL3Sist","serviceDesk":"S"},{"idGrupo":19,"nome":"3º NÍVEL - Telefonia","sigla":"SDNIVEL3Telefonia","serviceDesk":"N"}]},"grupoAtual":"SDNIVEL1","grupoNivel1":"SDNIVEL1","acaoFluxo":"","idTipoDemandaServico":1,"idServico":4,"itemConfiguracao":"","messageId":"","nomecontato":"Default","telefonecontato":"3242-4433","emailcontato":"citsmart_instalador_mysql@centralit.com.br","observacao":"","reclassificar":"","escalar":"","alterarSituacao":"","detalhamentoCausa":"","solucaoTemporaria":"N","nomeServico":"Serviço 4","ramal":"","idAcordoNivelServico":2,"registradoPor":"Consultor","registroexecucao":"","impacto":"B","urgencia":"B","descricaoSemFormatacao":"Descrição do Incidente ou Requisição","idResponsavel":3,"idGrupoAtual":2,"idGrupoNivel1":2}', NULL, 'InicioSLA', 'O', 0, NULL, NULL, NULL);
INSERT INTO ocorrenciasolicitacao VALUES (5, NULL, 3, NULL, '2013-04-05', '09:46', 'Default', 'Registro da Solicitação', '2013-04-05', '2013-04-05', NULL, '{"idSolicitacaoServico":3,"idContatoSolicitacaoServico":3,"idServicoContrato":5,"idSolicitante":3,"idOrigem":1,"idPrioridade":5,"filtroADPesq":"","idUnidade":1,"dataHoraSolicitacao":"Apr 5, 2013 9:46:04 AM","prazoCapturaHH":0,"prazoCapturaMM":0,"prazoHH":0,"prazoMM":0,"descricao":"Descri\u0026ccedil;\u0026atilde;o do Incidente ou Requisi\u0026ccedil;\u0026atilde;o","resposta":"","dataHoraInicio":"Apr 5, 2013 9:46:04 AM","situacao":"Cancelada","seqReabertura":0,"enviaEmailCriacao":"S","enviaEmailFinalizacao":"S","slaACombinar":"S","idCalendario":1,"tempoDecorridoHH":0,"tempoDecorridoMM":0,"situacaoSLA":"N","descrSituacao":"Cancelada","atrasoSLA":0.0,"idContrato":1,"solicitante":"Consultor","dataHoraSolicitacaoStr":"05/04/2013 09:46","usuarioDto":{"idUsuario":2,"idEmpregado":2,"idPerfilAcessoUsuario":2,"idEmpresa":1,"login":"default","nomeUsuario":"Default","status":"A","grupos":["SDNIVEL1","SDNIVEL2","SDNIVEL3Apli","SDNIVEL3Infra","SDNIVEL3Sist","SDNIVEL3Telefonia"],"locale":"","colGrupos":[{"idGrupo":2,"nome":"1º NÍVEL","sigla":"SDNIVEL1","serviceDesk":"S"},{"idGrupo":3,"nome":"2º NÍVEL","sigla":"SDNIVEL2","serviceDesk":"S"},{"idGrupo":16,"nome":"3º NÍVEL - Aplicação","sigla":"SDNIVEL3Apli","serviceDesk":"S"},{"idGrupo":4,"nome":"3º NÍVEL - Infraestrutura","sigla":"SDNIVEL3Infra","serviceDesk":"S"},{"idGrupo":17,"nome":"3º NÍVEL - Sistemas","sigla":"SDNIVEL3Sist","serviceDesk":"S"},{"idGrupo":19,"nome":"3º NÍVEL - Telefonia","sigla":"SDNIVEL3Telefonia","serviceDesk":"N"}]},"acaoFluxo":"","idTipoDemandaServico":1,"idServico":5,"itemConfiguracao":"","messageId":"","nomecontato":"Consultor","telefonecontato":"3242-4433","emailcontato":"citsmart_instalador_mysql@centralit.com.br","observacao":"","reclassificar":"","escalar":"","alterarSituacao":"","detalhamentoCausa":"","solucaoTemporaria":"N","nomeServico":"Serviço 5","ramal":"","idAcordoNivelServico":3,"registradoPor":"Default","registroexecucao":"","impacto":"B","urgencia":"B","descricaoSemFormatacao":"Descrição do Incidente ou Requisição","idResponsavel":2,"idGrupoAtual":3,"idGrupoNivel1":2}', '{"idcontatosolicitacaoservico":3,"nomecontato":"Consultor","telefonecontato":"3242-4433","emailcontato":"citsmart_instalador_mysql@centralit.com.br","observacao":""}', 'Criacao', 'O', 0, NULL, NULL, NULL);
INSERT INTO ocorrenciasolicitacao VALUES (6, NULL, 3, NULL, '2013-04-05', '09:46', 'Automático', 'Encerramento da Solicitação', '2013-04-05', '2013-04-05', NULL, '{"idSolicitacaoServico":3,"idContatoSolicitacaoServico":3,"idServicoContrato":5,"idSolicitante":3,"idOrigem":1,"idPrioridade":5,"filtroADPesq":"","idUnidade":1,"idFaseAtual":2,"dataHoraSolicitacao":"Apr 5, 2013 9:46:04 AM","prazoCapturaHH":0,"prazoCapturaMM":0,"prazoHH":0,"prazoMM":0,"descricao":"Descri\u0026ccedil;\u0026atilde;o do Incidente ou Requisi\u0026ccedil;\u0026atilde;o","resposta":"","dataHoraInicio":"Apr 5, 2013 9:46:04 AM","dataHoraFim":"Apr 5, 2013 9:46:04 AM","situacao":"Cancelada","seqReabertura":0,"enviaEmailCriacao":"S","enviaEmailFinalizacao":"S","slaACombinar":"S","idCalendario":1,"tempoDecorridoHH":0,"tempoDecorridoMM":0,"situacaoSLA":"N","descrSituacao":"Cancelada","atrasoSLA":0.0,"idContrato":1,"solicitante":"Consultor","dataHoraSolicitacaoStr":"05/04/2013 09:46","usuarioDto":{"idUsuario":2,"idEmpregado":2,"idPerfilAcessoUsuario":2,"idEmpresa":1,"login":"default","nomeUsuario":"Default","status":"A","grupos":["SDNIVEL1","SDNIVEL2","SDNIVEL3Apli","SDNIVEL3Infra","SDNIVEL3Sist","SDNIVEL3Telefonia"],"locale":"","colGrupos":[{"idGrupo":2,"nome":"1º NÍVEL","sigla":"SDNIVEL1","serviceDesk":"S"},{"idGrupo":3,"nome":"2º NÍVEL","sigla":"SDNIVEL2","serviceDesk":"S"},{"idGrupo":16,"nome":"3º NÍVEL - Aplicação","sigla":"SDNIVEL3Apli","serviceDesk":"S"},{"idGrupo":4,"nome":"3º NÍVEL - Infraestrutura","sigla":"SDNIVEL3Infra","serviceDesk":"S"},{"idGrupo":17,"nome":"3º NÍVEL - Sistemas","sigla":"SDNIVEL3Sist","serviceDesk":"S"},{"idGrupo":19,"nome":"3º NÍVEL - Telefonia","sigla":"SDNIVEL3Telefonia","serviceDesk":"N"}]},"grupoAtual":"SDNIVEL2","grupoNivel1":"SDNIVEL1","acaoFluxo":"","idTipoDemandaServico":1,"idServico":5,"itemConfiguracao":"","messageId":"","nomecontato":"Consultor","telefonecontato":"3242-4433","emailcontato":"citsmart_instalador_mysql@centralit.com.br","observacao":"","reclassificar":"","escalar":"","alterarSituacao":"","detalhamentoCausa":"","solucaoTemporaria":"N","nomeServico":"Serviço 5","ramal":"","idAcordoNivelServico":3,"registradoPor":"Default","registroexecucao":"","impacto":"B","urgencia":"B","tempoCapturaHH":0,"tempoCapturaMM":0,"tempoAtrasoHH":0,"tempoAtrasoMM":0,"descricaoSemFormatacao":"Descrição do Incidente ou Requisição","idResponsavel":2,"idGrupoAtual":3,"idGrupoNivel1":2}', NULL, 'Encerramento', 'O', 0, NULL, NULL, NULL);
INSERT INTO ocorrenciasolicitacao VALUES (7, NULL, 3, NULL, '2013-04-05', '09:46', 'Automático', 'Inicio do SLA', '2013-04-05', '2013-04-05', NULL, '{"idSolicitacaoServico":3,"idContatoSolicitacaoServico":3,"idServicoContrato":5,"idSolicitante":3,"idOrigem":1,"idPrioridade":5,"filtroADPesq":"","idUnidade":1,"idFaseAtual":2,"dataHoraSolicitacao":"Apr 5, 2013 9:46:04 AM","prazoCapturaHH":0,"prazoCapturaMM":0,"prazoHH":0,"prazoMM":0,"descricao":"Descri\u0026ccedil;\u0026atilde;o do Incidente ou Requisi\u0026ccedil;\u0026atilde;o","resposta":"","dataHoraInicio":"Apr 5, 2013 9:46:04 AM","dataHoraFim":"Apr 5, 2013 9:46:04 AM","situacao":"Cancelada","seqReabertura":0,"enviaEmailCriacao":"S","enviaEmailFinalizacao":"S","slaACombinar":"S","idCalendario":1,"tempoDecorridoHH":0,"tempoDecorridoMM":0,"situacaoSLA":"A","dataHoraInicioSLA":"Apr 5, 2013 9:46:04 AM","descrSituacao":"Cancelada","dataHoraLimite":"Apr 5, 2013 9:46:00 AM","dataHoraLimiteStr":"05/04/2013 09:46","dataHoraInicioSLAStr":"05/04/2013 09:46:04","atrasoSLA":0.0,"idContrato":1,"solicitante":"Consultor","dataHoraSolicitacaoStr":"05/04/2013 09:46","usuarioDto":{"idUsuario":2,"idEmpregado":2,"idPerfilAcessoUsuario":2,"idEmpresa":1,"login":"default","nomeUsuario":"Default","status":"A","grupos":["SDNIVEL1","SDNIVEL2","SDNIVEL3Apli","SDNIVEL3Infra","SDNIVEL3Sist","SDNIVEL3Telefonia"],"locale":"","colGrupos":[{"idGrupo":2,"nome":"1º NÍVEL","sigla":"SDNIVEL1","serviceDesk":"S"},{"idGrupo":3,"nome":"2º NÍVEL","sigla":"SDNIVEL2","serviceDesk":"S"},{"idGrupo":16,"nome":"3º NÍVEL - Aplicação","sigla":"SDNIVEL3Apli","serviceDesk":"S"},{"idGrupo":4,"nome":"3º NÍVEL - Infraestrutura","sigla":"SDNIVEL3Infra","serviceDesk":"S"},{"idGrupo":17,"nome":"3º NÍVEL - Sistemas","sigla":"SDNIVEL3Sist","serviceDesk":"S"},{"idGrupo":19,"nome":"3º NÍVEL - Telefonia","sigla":"SDNIVEL3Telefonia","serviceDesk":"N"}]},"grupoAtual":"SDNIVEL2","grupoNivel1":"SDNIVEL1","acaoFluxo":"","idTipoDemandaServico":1,"idServico":5,"itemConfiguracao":"","messageId":"","nomecontato":"Consultor","telefonecontato":"3242-4433","emailcontato":"citsmart_instalador_mysql@centralit.com.br","observacao":"","reclassificar":"","escalar":"","alterarSituacao":"","detalhamentoCausa":"","solucaoTemporaria":"N","nomeServico":"Serviço 5","ramal":"","idAcordoNivelServico":3,"registradoPor":"Default","registroexecucao":"","impacto":"B","urgencia":"B","tempoCapturaHH":0,"tempoCapturaMM":0,"tempoAtrasoHH":0,"tempoAtrasoMM":0,"descricaoSemFormatacao":"Descrição do Incidente ou Requisição","idResponsavel":2,"idGrupoAtual":3,"idGrupoNivel1":2}', NULL, 'InicioSLA', 'O', 0, NULL, NULL, NULL);
INSERT INTO ocorrenciasolicitacao VALUES (8, NULL, 3, NULL, '2013-04-05', '09:46', 'Automático', 'Encerramento da Solicitação', '2013-04-05', '2013-04-05', NULL, '{"idSolicitacaoServico":3,"idContatoSolicitacaoServico":3,"idServicoContrato":5,"idSolicitante":3,"idOrigem":1,"idPrioridade":5,"filtroADPesq":"","idUnidade":1,"idFaseAtual":2,"dataHoraSolicitacao":"Apr 5, 2013 9:46:04 AM","prazoCapturaHH":0,"prazoCapturaMM":0,"prazoHH":0,"prazoMM":0,"descricao":"Descri\u0026ccedil;\u0026atilde;o do Incidente ou Requisi\u0026ccedil;\u0026atilde;o","resposta":"","dataHoraInicio":"Apr 5, 2013 9:46:04 AM","dataHoraFim":"Apr 5, 2013 9:46:04 AM","situacao":"Cancelada","seqReabertura":0,"enviaEmailCriacao":"S","enviaEmailFinalizacao":"S","slaACombinar":"S","idCalendario":1,"tempoDecorridoHH":0,"tempoDecorridoMM":0,"situacaoSLA":"A","dataHoraInicioSLA":"Apr 5, 2013 9:46:04 AM","descrSituacao":"Cancelada","dataHoraLimite":"Apr 5, 2013 9:46:00 AM","dataHoraLimiteStr":"05/04/2013 09:46","dataHoraInicioSLAStr":"05/04/2013 09:46:04","atrasoSLA":0.0,"idContrato":1,"solicitante":"Consultor","dataHoraSolicitacaoStr":"05/04/2013 09:46","usuarioDto":{"idUsuario":2,"idEmpregado":2,"idPerfilAcessoUsuario":2,"idEmpresa":1,"login":"default","nomeUsuario":"Default","status":"A","grupos":["SDNIVEL1","SDNIVEL2","SDNIVEL3Apli","SDNIVEL3Infra","SDNIVEL3Sist","SDNIVEL3Telefonia"],"locale":"","colGrupos":[{"idGrupo":2,"nome":"1º NÍVEL","sigla":"SDNIVEL1","serviceDesk":"S"},{"idGrupo":3,"nome":"2º NÍVEL","sigla":"SDNIVEL2","serviceDesk":"S"},{"idGrupo":16,"nome":"3º NÍVEL - Aplicação","sigla":"SDNIVEL3Apli","serviceDesk":"S"},{"idGrupo":4,"nome":"3º NÍVEL - Infraestrutura","sigla":"SDNIVEL3Infra","serviceDesk":"S"},{"idGrupo":17,"nome":"3º NÍVEL - Sistemas","sigla":"SDNIVEL3Sist","serviceDesk":"S"},{"idGrupo":19,"nome":"3º NÍVEL - Telefonia","sigla":"SDNIVEL3Telefonia","serviceDesk":"N"}]},"grupoAtual":"SDNIVEL2","grupoNivel1":"SDNIVEL1","acaoFluxo":"","idTipoDemandaServico":1,"idServico":5,"itemConfiguracao":"","messageId":"","nomecontato":"Consultor","telefonecontato":"3242-4433","emailcontato":"citsmart_instalador_mysql@centralit.com.br","observacao":"","reclassificar":"","escalar":"","alterarSituacao":"","detalhamentoCausa":"","solucaoTemporaria":"N","nomeServico":"Serviço 5","ramal":"","idAcordoNivelServico":3,"registradoPor":"Default","registroexecucao":"","impacto":"B","urgencia":"B","tempoCapturaHH":0,"tempoCapturaMM":0,"tempoAtrasoHH":0,"tempoAtrasoMM":0,"tempoAtendimentoHH":0,"tempoAtendimentoMM":0,"descricaoSemFormatacao":"Descrição do Incidente ou Requisição","idResponsavel":2,"idGrupoAtual":3,"idGrupoNivel1":2}', NULL, 'Encerramento', 'O', 0, NULL, NULL, NULL);
INSERT INTO ocorrenciasolicitacao VALUES (9, NULL, 4, NULL, '2013-04-05', '10:13', 'Default', 'Registro da Solicitação', '2013-04-05', '2013-04-05', NULL, '{"idSolicitacaoServico":4,"idContatoSolicitacaoServico":4,"idServicoContrato":5,"idSolicitante":3,"idOrigem":1,"idPrioridade":5,"filtroADPesq":"","idUnidade":1,"dataHoraSolicitacao":"Apr 5, 2013 10:13:17 AM","prazoCapturaHH":0,"prazoCapturaMM":0,"prazoHH":0,"prazoMM":0,"descricao":"Descri\u0026ccedil;\u0026atilde;o do Incidente ou Requisi\u0026ccedil;\u0026atilde;o\u003cbr /\u003e","resposta":"","dataHoraInicio":"Apr 5, 2013 10:13:17 AM","situacao":"EmAndamento","seqReabertura":0,"enviaEmailCriacao":"S","enviaEmailFinalizacao":"S","slaACombinar":"S","idCalendario":1,"tempoDecorridoHH":0,"tempoDecorridoMM":0,"situacaoSLA":"N","descrSituacao":"Em andamento","atrasoSLA":0.0,"idContrato":1,"solicitante":"Consultor","dataHoraSolicitacaoStr":"05/04/2013 10:13","usuarioDto":{"idUsuario":2,"idEmpregado":2,"idPerfilAcessoUsuario":2,"idEmpresa":1,"login":"default","nomeUsuario":"Default","status":"A","grupos":["SDNIVEL1","SDNIVEL2","SDNIVEL3Apli","SDNIVEL3Infra","SDNIVEL3Sist","SDNIVEL3Telefonia"],"locale":"","colGrupos":[{"idGrupo":2,"nome":"1º NÍVEL","sigla":"SDNIVEL1","serviceDesk":"S"},{"idGrupo":3,"nome":"2º NÍVEL","sigla":"SDNIVEL2","serviceDesk":"S"},{"idGrupo":16,"nome":"3º NÍVEL - Aplicação","sigla":"SDNIVEL3Apli","serviceDesk":"S"},{"idGrupo":4,"nome":"3º NÍVEL - Infraestrutura","sigla":"SDNIVEL3Infra","serviceDesk":"S"},{"idGrupo":17,"nome":"3º NÍVEL - Sistemas","sigla":"SDNIVEL3Sist","serviceDesk":"S"},{"idGrupo":19,"nome":"3º NÍVEL - Telefonia","sigla":"SDNIVEL3Telefonia","serviceDesk":"N"}]},"acaoFluxo":"","idTipoDemandaServico":1,"idServico":5,"itemConfiguracao":"","messageId":"","nomecontato":"Consultor","telefonecontato":"3242-4433","emailcontato":"citsmart_instalador_mysql@centralit.com.br","observacao":"","reclassificar":"","escalar":"","alterarSituacao":"","detalhamentoCausa":"","solucaoTemporaria":"N","nomeServico":"Serviço 5","ramal":"","idAcordoNivelServico":3,"registradoPor":"Default","registroexecucao":"","impacto":"B","urgencia":"B","descricaoSemFormatacao":"Descrição do Incidente ou Requisição","idResponsavel":2,"idGrupoAtual":3,"idGrupoNivel1":2}', '{"idcontatosolicitacaoservico":4,"nomecontato":"Consultor","telefonecontato":"3242-4433","emailcontato":"citsmart_instalador_mysql@centralit.com.br","observacao":""}', 'Criacao', 'O', 0, NULL, NULL, NULL);
INSERT INTO ocorrenciasolicitacao VALUES (10, NULL, 4, NULL, '2013-04-05', '10:13', 'Automático', 'Inicio do SLA', '2013-04-05', '2013-04-05', NULL, '{"idSolicitacaoServico":4,"idContatoSolicitacaoServico":4,"idServicoContrato":5,"idSolicitante":3,"idOrigem":1,"idPrioridade":5,"filtroADPesq":"","idUnidade":1,"idFaseAtual":2,"dataHoraSolicitacao":"Apr 5, 2013 10:13:17 AM","prazoCapturaHH":0,"prazoCapturaMM":0,"prazoHH":0,"prazoMM":0,"descricao":"Descri\u0026ccedil;\u0026atilde;o do Incidente ou Requisi\u0026ccedil;\u0026atilde;o\u003cbr /\u003e","resposta":"","dataHoraInicio":"Apr 5, 2013 10:13:17 AM","situacao":"EmAndamento","seqReabertura":0,"enviaEmailCriacao":"S","enviaEmailFinalizacao":"S","slaACombinar":"S","idCalendario":1,"tempoDecorridoHH":0,"tempoDecorridoMM":0,"situacaoSLA":"A","dataHoraInicioSLA":"Apr 5, 2013 10:13:18 AM","descrSituacao":"Em andamento","dataHoraLimite":"Apr 5, 2013 10:13:00 AM","dataHoraLimiteStr":"05/04/2013 10:13","dataHoraInicioSLAStr":"05/04/2013 10:13:18","atrasoSLA":0.0,"idContrato":1,"solicitante":"Consultor","dataHoraSolicitacaoStr":"05/04/2013 10:13","usuarioDto":{"idUsuario":2,"idEmpregado":2,"idPerfilAcessoUsuario":2,"idEmpresa":1,"login":"default","nomeUsuario":"Default","status":"A","grupos":["SDNIVEL1","SDNIVEL2","SDNIVEL3Apli","SDNIVEL3Infra","SDNIVEL3Sist","SDNIVEL3Telefonia"],"locale":"","colGrupos":[{"idGrupo":2,"nome":"1º NÍVEL","sigla":"SDNIVEL1","serviceDesk":"S"},{"idGrupo":3,"nome":"2º NÍVEL","sigla":"SDNIVEL2","serviceDesk":"S"},{"idGrupo":16,"nome":"3º NÍVEL - Aplicação","sigla":"SDNIVEL3Apli","serviceDesk":"S"},{"idGrupo":4,"nome":"3º NÍVEL - Infraestrutura","sigla":"SDNIVEL3Infra","serviceDesk":"S"},{"idGrupo":17,"nome":"3º NÍVEL - Sistemas","sigla":"SDNIVEL3Sist","serviceDesk":"S"},{"idGrupo":19,"nome":"3º NÍVEL - Telefonia","sigla":"SDNIVEL3Telefonia","serviceDesk":"N"}]},"grupoAtual":"SDNIVEL2","grupoNivel1":"SDNIVEL1","acaoFluxo":"","idTipoDemandaServico":1,"idServico":5,"itemConfiguracao":"","messageId":"","nomecontato":"Consultor","telefonecontato":"3242-4433","emailcontato":"citsmart_instalador_mysql@centralit.com.br","observacao":"","reclassificar":"","escalar":"","alterarSituacao":"","detalhamentoCausa":"","solucaoTemporaria":"N","nomeServico":"Serviço 5","ramal":"","idAcordoNivelServico":3,"registradoPor":"Default","registroexecucao":"","impacto":"B","urgencia":"B","descricaoSemFormatacao":"Descrição do Incidente ou Requisição","idResponsavel":2,"idGrupoAtual":3,"idGrupoNivel1":2}', NULL, 'InicioSLA', 'O', 0, NULL, NULL, NULL);


--
-- TOC entry 6274 (class 0 OID 2248349)
-- Dependencies: 366 6388
-- Data for Name: opcaorespostaquestionario; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6276 (class 0 OID 2248361)
-- Dependencies: 368 6388
-- Data for Name: opiniao; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6507 (class 0 OID 0)
-- Dependencies: 367
-- Name: opiniao_idopiniao_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('opiniao_idopiniao_seq', 3, false);


--
-- TOC entry 6277 (class 0 OID 2248372)
-- Dependencies: 369 6388
-- Data for Name: origematendimento; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO origematendimento VALUES (1, 'Service Desk');
INSERT INTO origematendimento VALUES (2, 'Internet');
INSERT INTO origematendimento VALUES (3, 'E-mail');
INSERT INTO origematendimento VALUES (4, 'Operador');
INSERT INTO origematendimento VALUES (5, '3º Nivel');


--
-- TOC entry 6278 (class 0 OID 2248377)
-- Dependencies: 370 6388
-- Data for Name: origemocorrencia; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6279 (class 0 OID 2248382)
-- Dependencies: 371 6388
-- Data for Name: os; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6280 (class 0 OID 2248394)
-- Dependencies: 372 6388
-- Data for Name: osatividadeperiodica; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6281 (class 0 OID 2248399)
-- Dependencies: 373 6388
-- Data for Name: pais; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO pais VALUES (1, 'Brasil');


--
-- TOC entry 6282 (class 0 OID 2248404)
-- Dependencies: 374 6388
-- Data for Name: palavragemea; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6283 (class 0 OID 2248412)
-- Dependencies: 375 6388
-- Data for Name: parametrocorpore; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO parametrocorpore VALUES (0, 'ORIGEM - Configuração de Origem de Informações (para federação de dados)', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (1, 'Diretorio Arquivo NetMap', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (2, 'Faixa de Ip', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (3, 'No Pesquisa', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (4, 'Atributo Pesquisa', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (5, 'CAMINHO_INSTALADORES', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (6, 'Diretorio XML Agente', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (7, 'Periodo para fazer inventario dias', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (8, 'Caminho Nmap', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (9, 'ID Grupo Nível 1', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (10, 'Email origem das notificações de solicitações de serviço', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (11, 'Exige autenticação para envio de email', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (12, 'Usuário para autenticação de email', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (13, 'Senha para autenticação de email', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (14, 'SMTP para envio de email', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (15, 'GED Interno (S/N)', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (16, 'GED Interno em Banco de Dados (S/N)', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (17, 'GED Externo - Classe de tratamento', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (18, 'GED Diretorio', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (19, 'Nome da Empresa', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (20, 'BASE CONHECIMENTO - Pasta de armazenamento', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (21, 'BASECONHECIMENTO - Pasta de armazenamento arquivos LUCENE', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (22, 'MÉTODO DE AUTENTICAÇÃO (1 - Próprio, 2 - LDAP)', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (23, 'SMTP LEITURA - Servidor de entrada de emails do Service Desk', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (24, 'SMTP LEITURA - Caixa de entrada de emails do Service Desk', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (25, 'SMTP LEITURA - Senha da Caixa de entrada de emails do Service Desk', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (26, 'SMTP LEITURA - Provider do servidor de emails do Service Desk (imaps, pops, imap, pop, etc)', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (27, 'SMTP LEITURA - Porta do servidor de emails do Service Desk', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (28, 'SMTP LEITURA - Pasta da caixa de entrada de emails do Service Desk', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (29, 'Nome do fluxo padrão para serviços', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (30, 'ID da fase padrão para execução de serviços', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (31, 'Envia email na execução dos fluxos de solicitações/incidentes', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (32, 'DB - nome do SCHEMA do Banco de dados', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (33, 'URL de acesso ao sistema', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (34, 'LDAP - URL de acesso ao ActiveDirectory. Exemplo: ldap://10.2.1.2:389', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (35, 'LDAP - String com dominio do AD. Exemplo: dc=empresa,dc=com,dc=br', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (36, 'Domínio de e-mail. (@empresa.com.br)', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (37, 'LDAP - Login para consultar informações de usuários do LDAP(deve-se cadastrar também a senha).', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (38, 'LDAP - Senha para consultar informações de usuários do LDAP(deve-se cadastrar também o login).', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (39, 'LDAP - Id do perfil de acesso que será setado automaticamente caso o usuário não possua nenhum.', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (40, 'Faz o controle de acessos do catalogo de serviço por unidade (S/N) ?', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (41, 'Faz o controle de vinculo de colaboradores aos contratos (S/N) ?', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (42, 'Pagina para cadastro de solicitações de serviço (será usado o padrão caso não seja informado)', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (43, 'LDAP - Sufixo dominio', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (44, 'Diretório Upload repositório path', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (45, 'LDAP - ID Grupo Padrão.', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (46, 'Página de Login usando o Portal', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (47, 'Nome do fluxo padrão para mudanças', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (48, 'Validar permissões de botões (gravar, excluir e pesquisar) (S/N).', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (49, 'Gravar nome Usuário e Nome Empregado a partir do Last Name? (S/N).', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (50, 'Aceitar Valor 0 (Zero) para quantidade e custo da atividade?', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (51, 'FORMULA GLOSA OS - Código Padrão', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (52, 'Ativar log no sistema (''true'' ou ''false'')', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (53, 'Tipos: ''CIT_LOG'' (arquivo de log), ''DB_LOG'' (grava no banco)', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (54, 'Caminho da pasta que ficará o arquivo de LOG', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (55, 'Nome do arquivo de log', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (56, 'Extensão do arquivo de log', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (57, 'ID do modelo de e-mail que será enviado para o grupo de destino ao escalar uma solicitação.', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (58, 'Notificar o grupo ao receber uma escalação de solicitação de serviço (S e N).', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (59, 'PATRIMÔNIOP - ID Tipo Item Configuração.', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (60, 'Grupo de novos itens de configuração.', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (61, 'Vincula contratos a unidade', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (62, 'Identifica o id do serviço para solicitações de serviços e incidentes (Ex: A Ser Classificado )', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (63, '[Parametro Depreciado] Pagina para cadastro de solicitações de serviço pelo Portal (Default: ''/pages/solicitacaoServicoPortal/solicitacaoServicoPortal.load'')', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (64, 'LDAP - Atributo LDAP para obter NOME DO COLABORADOR? (DisplayName, CN, SN ...).', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (65, 'Identifica o id de origem do chamado padrão da solicitação de serviço ', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (66, 'Idioma padrão do sistema(Ex: EN=Inglês)?', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (67, 'LDAP - Filtro LDAP na busca? (Default: (&(objectCategory=person)(objectClass=user))).', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (68, 'LDAP - Mostrar botão de buscar no AD na tela de incidentes.(Default: ''N'')', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (69, 'Validar campos Causa e Categoria da Solução da página solicitação serviço obrigatorios(Default: N)', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (70, 'Mostrar botões de importação e exportação do xml no cadastro de menus. (Default: S)', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (71, 'Parâmetro para ler o arquivo XML padrão de menus. (Default: N)', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (72, 'SMTP LEITURA - Limite de emails carregados em Solicitação Serviço', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (73, 'Avisar, com antecedência, a quantidade de dias que restam para a expiração da licença. (Default: 90 dias)', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (74, 'Enviar e-mail para grupo ou proprietário do item configuração. (1: Grupo 2: proprietário).', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (75, 'ID do modelo de e-mail para envio de notificação de licença próximo da expiração', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (76, 'Nome do Domínio da Rede (exemplo: EMPRESA, CORPORACAO)', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (78, 'Avisar, com antecedência, a quantidade de dias que restam para a expiração do conhecimento.  (Default: 90 dias)', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (79, 'ID do modelo de e-mail para envio de notificação de criação de pasta', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (80, 'ID do modelo de e-mail para envio de notificação de atualização de pasta', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (81, 'ID do modelo de e-mail para envio de notificação de exclusão de pasta', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (82, 'ID do modelo de e-mail para envio de notificação de criação de conhecimento', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (83, 'ID do modelo de e-mail para envio de notificação de atualização de conhecimento', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (84, 'ID do modelo de e-mail para envio de notificação de exclusão de conhecimento', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (85, 'Verificação de vinculo de mudança relacionada ao Item de configuração (Default: S)', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (86, 'Mostrar Categoria de serviço em Incidente default(S)', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (87, 'Modelo de criação de IC', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (88, 'Modelo de alteração de IC)', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (89, 'Modelo de alteração de IC de grupo', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (90, 'Envio de e-mails de Notificação de ICs (1-Grupo, 2-Proprietario, 3-Todos) (Default: 1)', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (91, 'SMTP GMAIL - Envio e recebimento de e-mails utilizando GMAIL? (S e N)', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (92, 'Nome fase ciclo de vida desenvolvimento Item Configuração (Default: ICs em Desenvolvimento)', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (93, 'Nome fase ciclo de vida produção Item Configuração (Default: ICs em Produção', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (94, 'Nome fase ciclo de vida homologação Item Configuração (Default: ICs em Homologação)', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (95, 'Nome Inventário (Default: Inventário)', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (96, 'ID do grupo de desenvolvimento Item Configuração (Ex: 1)', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (97, 'ID do grupo de produção Item Configuração (Ex: 2)', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (98, 'ID do grupo de homologação Item Configuração (Ex: 3)', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (99, 'ID do grupo de inventario Item Configuração (Ex: 4)', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (100, 'ID do grupo padrão para atendimento de requisições de produtos', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (101, 'Percentual máximo de variação de preço para cotação', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (102, 'LDAP - Número máximo de colaboradores retornados na rotina de sincronização com AD? ', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (103, 'ID do modelo de e-mail para envio de notificação de alteracao de serviço', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (104, 'Calcular a prioridade da solicitação dinamicamente usando a fórmula cadastrada. (Default: ''N'')', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (105, 'ID da origem que será setado como padrão ao criar um novo incidente', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (106, 'Determina automaticamente a urgência e impacto das requisições de produto', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (107, 'Peso padrão para critério PREÇO na cotação', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (108, 'Peso padrão para critério PRAZO DE ENTREGA na cotação', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (109, 'Peso padrão para critério PRAZO DE PAGAMENTO na cotação', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (110, 'Peso padrão para critério PRAZO DE GARANTIA na cotação', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (111, 'Peso padrão para critério TAXA DE JUROS na cotação', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (112, 'Path do Arquivo de Status do Nagios', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (113, 'ID do modelo de e-mail para escalação automática', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (114, 'Permite que um empregado da área de compras faça requisição de produto', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (115, 'Tirar vinculo de localidade física com unidade ?(S/N)(Default: N)', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (116, 'ID do modelo de e-mail para alteração da senha de acesso ao CITSmart', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (117, 'Informar o caminho para salvar a tabela LOGDADOS', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (118, '[Portal] ID do Contrato padrão para abertura de chamados.', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (119, 'Tipo de captura de solicitações/Incidentes (1-Na execução, 2-No direcionamento) (Default: 1)', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (120, 'ID do modelo de e-mail para envio de notificação para o comitê de consultivo de mudanças', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (121, 'Faz o controle de Configuração para o openLDAP (S/N)(Default: N)', ' ', 1, '2013-04-08', NULL, NULL);
INSERT INTO parametrocorpore VALUES (122, 'ID do modelo de e-mail que será enviado para o grupo de destino ao escalar uma requisição mudança', ' ', 1, '2013-04-08', NULL, NULL);


--
-- TOC entry 6284 (class 0 OID 2248417)
-- Dependencies: 376 6388
-- Data for Name: parametros; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6285 (class 0 OID 2248427)
-- Dependencies: 377 6388
-- Data for Name: parametroscontrato; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6286 (class 0 OID 2248435)
-- Dependencies: 378 6388
-- Data for Name: parecer; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6287 (class 0 OID 2248458)
-- Dependencies: 379 6388
-- Data for Name: pasta; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO pasta VALUES (1, 'Pasta 1', NULL, NULL, NULL, NULL, NULL);
INSERT INTO pasta VALUES (2, 'Pasta 2', NULL, NULL, NULL, NULL, NULL);


--
-- TOC entry 6288 (class 0 OID 2248466)
-- Dependencies: 380 6388
-- Data for Name: pedidocompra; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6289 (class 0 OID 2248497)
-- Dependencies: 381 6388
-- Data for Name: perfilacesso; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO perfilacesso VALUES (1, '2012-01-01', NULL, 'Administrador');
INSERT INTO perfilacesso VALUES (2, '2013-03-18', NULL, 'Atendimento 1º NÍVEL');
INSERT INTO perfilacesso VALUES (3, '2012-01-01', NULL, 'Supervisão');
INSERT INTO perfilacesso VALUES (4, '2012-01-01', NULL, 'Qualidade');
INSERT INTO perfilacesso VALUES (5, '2012-01-01', NULL, 'Coordenação');
INSERT INTO perfilacesso VALUES (6, '2012-01-01', NULL, 'Usuário');
INSERT INTO perfilacesso VALUES (7, '2012-01-01', NULL, 'Desenvolvimento');
INSERT INTO perfilacesso VALUES (15, '2012-01-01', NULL, 'Atendimento 3º NÍVEL');
INSERT INTO perfilacesso VALUES (18, '2012-01-01', NULL, 'Atendimento 2º NÍVEL');


--
-- TOC entry 6290 (class 0 OID 2248502)
-- Dependencies: 382 6388
-- Data for Name: perfilacessogrupo; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO perfilacessogrupo VALUES (1, 2, '2012-01-01', NULL);
INSERT INTO perfilacessogrupo VALUES (4, 5, '2012-01-01', NULL);
INSERT INTO perfilacessogrupo VALUES (5, 6, '2012-01-01', NULL);
INSERT INTO perfilacessogrupo VALUES (5, 7, '2012-01-01', NULL);
INSERT INTO perfilacessogrupo VALUES (5, 18, '2012-01-01', NULL);
INSERT INTO perfilacessogrupo VALUES (5, 20, '2012-01-01', NULL);
INSERT INTO perfilacessogrupo VALUES (7, 1, '2012-01-01', NULL);
INSERT INTO perfilacessogrupo VALUES (15, 4, '2012-01-01', NULL);
INSERT INTO perfilacessogrupo VALUES (15, 16, '2012-01-01', NULL);
INSERT INTO perfilacessogrupo VALUES (15, 17, '2012-01-01', NULL);
INSERT INTO perfilacessogrupo VALUES (15, 19, '2012-01-01', NULL);
INSERT INTO perfilacessogrupo VALUES (18, 3, '2012-01-01', NULL);


--
-- TOC entry 6291 (class 0 OID 2248508)
-- Dependencies: 383 6388
-- Data for Name: perfilacessomenu; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6292 (class 0 OID 2248514)
-- Dependencies: 384 6388
-- Data for Name: perfilacessopasta; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO perfilacessopasta VALUES (1, 1, '2013-04-05', NULL, 'S', 'N', 'S');
INSERT INTO perfilacessopasta VALUES (1, 2, '2013-04-05', NULL, 'S', 'N', 'S');
INSERT INTO perfilacessopasta VALUES (1, 3, '2013-04-05', NULL, 'S', 'N', 'S');
INSERT INTO perfilacessopasta VALUES (1, 4, '2013-04-05', NULL, 'S', 'N', 'S');
INSERT INTO perfilacessopasta VALUES (2, 1, '2013-04-05', NULL, 'N', 'S', 'N');
INSERT INTO perfilacessopasta VALUES (2, 2, '2013-04-05', NULL, 'N', 'S', 'N');
INSERT INTO perfilacessopasta VALUES (2, 3, '2013-04-05', NULL, 'N', 'S', 'N');
INSERT INTO perfilacessopasta VALUES (2, 4, '2013-04-05', NULL, 'N', 'S', 'N');
INSERT INTO perfilacessopasta VALUES (3, 1, '2013-04-05', NULL, 'S', 'N', 'S');
INSERT INTO perfilacessopasta VALUES (3, 2, '2013-04-05', NULL, 'S', 'N', 'S');
INSERT INTO perfilacessopasta VALUES (3, 3, '2013-04-05', NULL, 'S', 'N', 'S');
INSERT INTO perfilacessopasta VALUES (3, 4, '2013-04-05', NULL, 'S', 'N', 'S');
INSERT INTO perfilacessopasta VALUES (4, 1, '2013-04-05', NULL, 'N', 'S', 'N');
INSERT INTO perfilacessopasta VALUES (4, 2, '2013-04-05', NULL, 'N', 'S', 'N');
INSERT INTO perfilacessopasta VALUES (4, 3, '2013-04-05', NULL, 'N', 'S', 'N');
INSERT INTO perfilacessopasta VALUES (4, 4, '2013-04-05', NULL, 'N', 'S', 'N');
INSERT INTO perfilacessopasta VALUES (5, 1, '2013-04-05', NULL, 'S', 'N', 'S');
INSERT INTO perfilacessopasta VALUES (5, 2, '2013-04-05', NULL, 'S', 'N', 'S');
INSERT INTO perfilacessopasta VALUES (5, 3, '2013-04-05', NULL, 'S', 'N', 'S');
INSERT INTO perfilacessopasta VALUES (5, 4, '2013-04-05', NULL, 'S', 'N', 'S');
INSERT INTO perfilacessopasta VALUES (6, 1, '2013-04-05', NULL, 'N', 'S', 'N');
INSERT INTO perfilacessopasta VALUES (6, 2, '2013-04-05', NULL, 'N', 'S', 'N');
INSERT INTO perfilacessopasta VALUES (6, 3, '2013-04-05', NULL, 'N', 'S', 'N');
INSERT INTO perfilacessopasta VALUES (6, 4, '2013-04-05', NULL, 'N', 'S', 'N');
INSERT INTO perfilacessopasta VALUES (7, 1, '2013-04-05', NULL, 'N', 'S', 'N');
INSERT INTO perfilacessopasta VALUES (7, 2, '2013-04-05', NULL, 'N', 'S', 'N');
INSERT INTO perfilacessopasta VALUES (7, 3, '2013-04-05', NULL, 'N', 'S', 'N');
INSERT INTO perfilacessopasta VALUES (7, 4, '2013-04-05', NULL, 'N', 'S', 'N');
INSERT INTO perfilacessopasta VALUES (15, 1, '2013-04-05', NULL, 'N', 'S', 'N');
INSERT INTO perfilacessopasta VALUES (15, 2, '2013-04-05', NULL, 'N', 'S', 'N');
INSERT INTO perfilacessopasta VALUES (15, 3, '2013-04-05', NULL, 'N', 'S', 'N');
INSERT INTO perfilacessopasta VALUES (15, 4, '2013-04-05', NULL, 'N', 'S', 'N');
INSERT INTO perfilacessopasta VALUES (18, 1, '2013-04-05', NULL, 'N', 'S', 'N');
INSERT INTO perfilacessopasta VALUES (18, 2, '2013-04-05', NULL, 'N', 'S', 'N');
INSERT INTO perfilacessopasta VALUES (18, 3, '2013-04-05', NULL, 'N', 'S', 'N');
INSERT INTO perfilacessopasta VALUES (18, 4, '2013-04-05', NULL, 'N', 'S', 'N');


--
-- TOC entry 6293 (class 0 OID 2248523)
-- Dependencies: 385 6388
-- Data for Name: perfilacessosituacaofatura; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO perfilacessosituacaofatura VALUES (1,1,'2012-09-04',NULL);
INSERT INTO perfilacessosituacaofatura VALUES (1,2,'2012-09-04',NULL);
INSERT INTO perfilacessosituacaofatura VALUES (1,3,'2012-09-04',NULL);
INSERT INTO perfilacessosituacaofatura VALUES (1,4,'2012-09-04',NULL);
INSERT INTO perfilacessosituacaofatura VALUES (1,5,'2012-09-04',NULL);
INSERT INTO perfilacessosituacaofatura VALUES (1,6,'2012-09-04',NULL);
INSERT INTO perfilacessosituacaofatura VALUES (1,7,'2012-09-04',NULL);

--
-- TOC entry 6294 (class 0 OID 2248528)
-- Dependencies: 386 6388
-- Data for Name: perfilacessosituacaoos; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO perfilacessosituacaoos VALUES (1,1,'2012-09-04',NULL);
INSERT INTO perfilacessosituacaoos VALUES (1,2,'2012-09-04',NULL);
INSERT INTO perfilacessosituacaoos VALUES (1,3,'2012-09-04',NULL);
INSERT INTO perfilacessosituacaoos VALUES (1,4,'2012-09-04',NULL);
INSERT INTO perfilacessosituacaoos VALUES (1,5,'2012-09-04',NULL);
INSERT INTO perfilacessosituacaoos VALUES (1,6,'2012-09-04',NULL);
INSERT INTO perfilacessosituacaoos VALUES (1,7,'2012-09-04',NULL);

--
-- TOC entry 6295 (class 0 OID 2248533)
-- Dependencies: 387 6388
-- Data for Name: perfilacessousuario; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO perfilacessousuario VALUES ('2012-01-01', 1, 1, NULL);
INSERT INTO perfilacessousuario VALUES ('2012-01-01', 2, 2, NULL);
INSERT INTO perfilacessousuario VALUES ('2012-01-01', 3, 1, NULL);


--
-- TOC entry 6296 (class 0 OID 2248540)
-- Dependencies: 388 6388
-- Data for Name: perfilseguranca; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6298 (class 0 OID 2248555)
-- Dependencies: 390 6388
-- Data for Name: pesquisasatisfacao; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6299 (class 0 OID 2248564)
-- Dependencies: 391 6388
-- Data for Name: pessoa; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6300 (class 0 OID 2248571)
-- Dependencies: 392 6388
-- Data for Name: planomelhoria; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6301 (class 0 OID 2248584)
-- Dependencies: 393 6388
-- Data for Name: portal; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6302 (class 0 OID 2248592)
-- Dependencies: 394 6388
-- Data for Name: post; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6303 (class 0 OID 2248608)
-- Dependencies: 395 6388
-- Data for Name: prioridade; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO prioridade VALUES (1, 1, '1', 'A', '   ');
INSERT INTO prioridade VALUES (2, 1, '2', 'A', '   ');
INSERT INTO prioridade VALUES (3, 1, '3', 'A', '   ');
INSERT INTO prioridade VALUES (4, 1, '4', 'A', '   ');
INSERT INTO prioridade VALUES (5, 1, '5', 'A', '   ');


--
-- TOC entry 6304 (class 0 OID 2248614)
-- Dependencies: 396 6388
-- Data for Name: prioridadeacordonivelservico; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6305 (class 0 OID 2248619)
-- Dependencies: 397 6388
-- Data for Name: prioridadeservicounidade; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6306 (class 0 OID 2248626)
-- Dependencies: 398 6388
-- Data for Name: problema; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6307 (class 0 OID 2248655)
-- Dependencies: 399 6388
-- Data for Name: problemaitemconfiguracao; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6308 (class 0 OID 2248663)
-- Dependencies: 400 6388
-- Data for Name: problemamudanca; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6309 (class 0 OID 2248670)
-- Dependencies: 401 6388
-- Data for Name: procedimentotecnico; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6310 (class 0 OID 2248678)
-- Dependencies: 402 6388
-- Data for Name: processamentobatch; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO processamentobatch VALUES (1, 'Execução da Rotina de Inventario', '', 'br.com.centralit.citcorpore.quartz.job.DisparaInventario', 'C', 'A');
INSERT INTO processamentobatch VALUES (2, 'Verifica e avisa a data de expiração de um item de configuração', '', 'br.com.centralit.citcorpore.quartz.job.VerificaValidadeLicenca', 'C', 'A');
INSERT INTO processamentobatch VALUES (3, 'Backup LogDados', '', 'br.com.centralit.citcorpore.quartz.job.ExecutaBackupLogDados', 'C', 'A');
INSERT INTO processamentobatch VALUES (4, 'Replicar o conteúdo do campo descricao da tabela solicitacaoservico para o campo descricaosemformatacao', '', 'br.com.centralit.citcorpore.quartz.job.EventoPopulaDescricaoSolicitacao', 'C', 'A');
INSERT INTO processamentobatch VALUES (5, 'Replicar o conteudo do campo conteudo da  tabela base conhecimento para o campo conteudosemformatcao', '', 'br.com.centralit.citcorpore.quartz.job.EventoPopulaConteudoBaseConhecimento', 'C', 'A');


--
-- TOC entry 6311 (class 0 OID 2248687)
-- Dependencies: 403 6388
-- Data for Name: produto; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6312 (class 0 OID 2248706)
-- Dependencies: 404 6388
-- Data for Name: programacaoatividade; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6313 (class 0 OID 2248734)
-- Dependencies: 405 6388
-- Data for Name: projetos; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6314 (class 0 OID 2248744)
-- Dependencies: 406 6388
-- Data for Name: questaoquestionario; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6315 (class 0 OID 2248775)
-- Dependencies: 407 6388
-- Data for Name: questionario; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6316 (class 0 OID 2248783)
-- Dependencies: 408 6388
-- Data for Name: reaberturasolicitacao; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6317 (class 0 OID 2248795)
-- Dependencies: 409 6388
-- Data for Name: recurso; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6318 (class 0 OID 2248868)
-- Dependencies: 410 6388
-- Data for Name: regioes; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6319 (class 0 OID 2248875)
-- Dependencies: 411 6388
-- Data for Name: registro; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6320 (class 0 OID 2248883)
-- Dependencies: 412 6388
-- Data for Name: relacionamentoproduto; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6321 (class 0 OID 2248890)
-- Dependencies: 413 6388
-- Data for Name: relacobjetonegocio; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6322 (class 0 OID 2248897)
-- Dependencies: 414 6388
-- Data for Name: requisicaomudanca; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6323 (class 0 OID 2248954)
-- Dependencies: 415 6388
-- Data for Name: requisicaomudancaitemconfiguracao; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6324 (class 0 OID 2248972)
-- Dependencies: 416 6388
-- Data for Name: requisicaomudancaservico; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6325 (class 0 OID 2248984)
-- Dependencies: 417 6388
-- Data for Name: requisicaoproduto; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6326 (class 0 OID 2249007)
-- Dependencies: 418 6388
-- Data for Name: requisitosla; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6327 (class 0 OID 2249028)
-- Dependencies: 419 6388
-- Data for Name: responsabilidade; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6328 (class 0 OID 2249041)
-- Dependencies: 420 6388
-- Data for Name: respostaitemquestionario; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6329 (class 0 OID 2249062)
-- Dependencies: 421 6388
-- Data for Name: respostaitemquestionarioanexos; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6330 (class 0 OID 2249071)
-- Dependencies: 422 6388
-- Data for Name: respostaitemquestionariocids; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6331 (class 0 OID 2249078)
-- Dependencies: 423 6388
-- Data for Name: respostaitemquestionarioopcoes; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6332 (class 0 OID 2249084)
-- Dependencies: 424 6388
-- Data for Name: resultadosesperados; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6333 (class 0 OID 2249095)
-- Dependencies: 425 6388
-- Data for Name: revisarsla; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6334 (class 0 OID 2249105)
-- Dependencies: 426 6388
-- Data for Name: scripts; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6335 (class 0 OID 2249115)
-- Dependencies: 427 6388
-- Data for Name: scriptsvisao; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6336 (class 0 OID 2249125)
-- Dependencies: 428 6388
-- Data for Name: servcontratocatalogoserv; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6337 (class 0 OID 2249135)
-- Dependencies: 429 6388
-- Data for Name: servico; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO servico VALUES (1, 1, 1, 1, 10, 1, 33, 3, 4, 'Serviço 1', 'Descrição do Serviço 1', '', NULL, '2013-04-01', '', '', NULL, 'S', NULL, NULL, NULL, '', NULL, NULL, NULL);
INSERT INTO servico VALUES (2, 1, 1, 1, 10, 1, 33, 3, 4, 'Serviço 2', 'Descrição do Serviço 2', '', NULL, '2013-04-01', '', '', NULL, 'S', NULL, NULL, NULL, '', NULL, NULL, NULL);
INSERT INTO servico VALUES (3, 1, 1, 1, 10, 1, 33, 3, 4, 'Serviço 3', 'Descrição do Serviço 3', '', NULL, '2013-04-01', '', '', NULL, 'S', NULL, NULL, NULL, '', NULL, NULL, NULL);
INSERT INTO servico VALUES (4, 1, 1, 1, 10, 1, 33, 1, 4, 'Serviço 4', 'Descrição do Serviço 4', '', NULL, '2013-04-01', '', '', NULL, 'S', NULL, NULL, NULL, '', NULL, NULL, NULL);
INSERT INTO servico VALUES (5, 1, 1, 1, 10, 1, 33, 1, 4, 'Serviço 5', 'Descrição do Serviço 5', '', NULL, '2013-04-01', '', '', NULL, 'S', NULL, NULL, NULL, '', NULL, NULL, NULL);


--
-- TOC entry 6338 (class 0 OID 2249161)
-- Dependencies: 430 6388
-- Data for Name: servico_hist; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO servico_hist VALUES (1, 1, 1, 1, 1, 10, 1, 19, 3, 4, 'Seu Serviço', 'Descrição do Serviço', '', NULL, '2013-04-01', '', '', NULL, 'S', NULL, NULL, NULL, '', NULL, NULL, NULL, '2013-04-02 04:00:00', 'Administrador', '2013-04-02 04:00:00', 'Administrador', 'JSONDATA: TRUE
NOCACHE: Tue Apr 02 2013 13:24:15 GMT-0300 (Hora oficial do Brasil)
IDCATEGORIASERVICO: 1
KEYCONTROL: 
DINAMICVIEWSJSON_TEMPDATA: 
IDSITUACAOSERVICO: 1
IDTIPODEMANDASERVICO: 3
SIGLAABREV: 
LINKPROCESSO: 
IDBASECONHECIMENTO: 
IDLOCALEXECUCAOSERVICO: 4
DINAMICVIEWSTABLESVINC: 
DINAMICVIEWSACAOPESQUISASELECIONADA: 
IDSERVICO: 1
ACAOFLUXO: 
MODOEXIBICAO: N
DETALHESERVICO: Descrição do Serviço
SESSION.NUMERO_CONTRATO_EDICAO: null
NOMESERVICO: Seu Serviço
DINAMICVIEWSJSON_DATA: 
IDEMPRESA: 1
DINAMICVIEWSIDVISAOPESQUISASELECIONADA: 
IDFLUXO: 
DESCRICAOPROCESSO: 
JSONMATRIZ: 
DATAINICIO: 01/04/2013
IDIMPORTANCIANEGOCIO: 10
DINAMICVIEWSIDVISAO: 17
IDTIPOSERVICO: 1
SESSION.DINAMICVIEWS_SAVEINFO: null
OBJETIVO: 
IDTAREFA: 
DINAMICVIEWSDADOSADICIONAIS: 
DISPPORTAL: S
IDTIPOEVENTOSERVICO: 19
');
INSERT INTO servico_hist VALUES (2, 1, 1, 1, 1, 10, 1, 19, 3, 4, 'Serviço 1', 'Descrição do Serviço 1', '', NULL, '2013-04-01', '', '', NULL, 'S', NULL, NULL, NULL, '', NULL, NULL, NULL, '2013-04-03 04:00:00', 'Administrador', '2013-04-03 04:00:00', 'Administrador', 'JSONDATA: 
REMOVED: false
NOCACHE: Wed Apr 03 2013 08:54:34 GMT-0300 (Hora oficial do Brasil)
IDCATEGORIASERVICO: 1
DINAMICVIEWSJSON_TEMPDATA: 
IDSITUACAOSERVICO: 1
KEYCONTROL: 
IDTIPODEMANDASERVICO: 3
SIGLAABREV: 
LINKPROCESSO: 
IDBASECONHECIMENTO: 
IDLOCALEXECUCAOSERVICO: 4
DINAMICVIEWSTABLESVINC: 
DINAMICVIEWSACAOPESQUISASELECIONADA: 
IDSERVICO: 1
ACAOFLUXO: 
DETALHESERVICO: Descrição do Serviço 1
MODOEXIBICAO: N
SESSION.NUMERO_CONTRATO_EDICAO: null
DINAMICVIEWSJSON_DATA: 
NOMESERVICO: Serviço 1
IDFLUXO: 
IDEMPRESA: 1
DINAMICVIEWSIDVISAOPESQUISASELECIONADA: 
JSONMATRIZ: 
DESCRICAOPROCESSO: 
IDIMPORTANCIANEGOCIO: 10
DATAINICIO: 01/04/2013
DINAMICVIEWSIDVISAO: 17
IDTIPOSERVICO: 1
SESSION.DINAMICVIEWS_SAVEINFO: null
IDTAREFA: 
OBJETIVO: 
DINAMICVIEWSDADOSADICIONAIS: 
DISPPORTAL: S
IDTIPOEVENTOSERVICO: 19
');
INSERT INTO servico_hist VALUES (3, 2, 1, 1, 1, 10, 1, 33, 3, 4, 'Serviço 2', 'Descrição do Serviço 2', '', NULL, '2013-04-01', '', '', NULL, 'S', NULL, NULL, NULL, '', NULL, NULL, NULL, '2013-04-03 04:00:00', 'Administrador', '2013-04-03 04:00:00', 'Administrador', 'JSONDATA: 
NOCACHE: Wed Apr 03 2013 08:55:48 GMT-0300 (Hora oficial do Brasil)
IDCATEGORIASERVICO: 1
KEYCONTROL: 
DINAMICVIEWSJSON_TEMPDATA: 
IDSITUACAOSERVICO: 1
IDTIPODEMANDASERVICO: 3
SIGLAABREV: 
LINKPROCESSO: 
IDBASECONHECIMENTO: 
IDLOCALEXECUCAOSERVICO: 4
DINAMICVIEWSTABLESVINC: 
DINAMICVIEWSACAOPESQUISASELECIONADA: 
IDSERVICO: 2
ACAOFLUXO: 
MODOEXIBICAO: N
DETALHESERVICO: Descrição do Serviço 2
SESSION.NUMERO_CONTRATO_EDICAO: null
NOMESERVICO: Serviço 2
DINAMICVIEWSJSON_DATA: 
IDEMPRESA: 1
DINAMICVIEWSIDVISAOPESQUISASELECIONADA: 
IDFLUXO: 
DESCRICAOPROCESSO: 
JSONMATRIZ: 
DATAINICIO: 01/04/2013
IDIMPORTANCIANEGOCIO: 10
DINAMICVIEWSIDVISAO: 17
IDTIPOSERVICO: 1
SESSION.DINAMICVIEWS_SAVEINFO: null
OBJETIVO: 
IDTAREFA: 
DINAMICVIEWSDADOSADICIONAIS: 
DISPPORTAL: S
IDTIPOEVENTOSERVICO: 33
');
INSERT INTO servico_hist VALUES (4, 1, 1, 1, 1, 10, 1, 33, 3, 4, 'Serviço 1', 'Descrição do Serviço 1', '', NULL, '2013-04-01', '', '', NULL, 'S', NULL, NULL, NULL, '', NULL, NULL, NULL, '2013-04-03 04:00:00', 'Administrador', '2013-04-03 04:00:00', 'Administrador', 'JSONDATA: 
REMOVED: false
NOCACHE: Wed Apr 03 2013 08:56:03 GMT-0300 (Hora oficial do Brasil)
IDCATEGORIASERVICO: 1
DINAMICVIEWSJSON_TEMPDATA: 
IDSITUACAOSERVICO: 1
KEYCONTROL: 
IDTIPODEMANDASERVICO: 3
SIGLAABREV: 
LINKPROCESSO: 
IDBASECONHECIMENTO: 
IDLOCALEXECUCAOSERVICO: 4
DINAMICVIEWSTABLESVINC: 
DINAMICVIEWSACAOPESQUISASELECIONADA: 
IDSERVICO: 1
ACAOFLUXO: 
DETALHESERVICO: Descrição do Serviço 1
MODOEXIBICAO: N
SESSION.NUMERO_CONTRATO_EDICAO: null
DINAMICVIEWSJSON_DATA: 
NOMESERVICO: Serviço 1
IDFLUXO: 
IDEMPRESA: 1
DINAMICVIEWSIDVISAOPESQUISASELECIONADA: 
JSONMATRIZ: 
DESCRICAOPROCESSO: 
IDIMPORTANCIANEGOCIO: 10
DATAINICIO: 01/04/2013
DINAMICVIEWSIDVISAO: 17
IDTIPOSERVICO: 1
SESSION.DINAMICVIEWS_SAVEINFO: null
IDTAREFA: 
OBJETIVO: 
DINAMICVIEWSDADOSADICIONAIS: 
DISPPORTAL: S
IDTIPOEVENTOSERVICO: 33
');
INSERT INTO servico_hist VALUES (5, 3, 1, 1, 1, 10, 1, 33, 3, 4, 'Serviço 3', 'Descrição do Serviço 3', '', NULL, '2013-04-01', '', '', NULL, 'S', NULL, NULL, NULL, '', NULL, NULL, NULL, '2013-04-03 04:00:00', 'Administrador', '2013-04-03 04:00:00', 'Administrador', 'JSONDATA: 
NOCACHE: Wed Apr 03 2013 08:56:56 GMT-0300 (Hora oficial do Brasil)
IDCATEGORIASERVICO: 1
KEYCONTROL: 
DINAMICVIEWSJSON_TEMPDATA: 
IDSITUACAOSERVICO: 1
IDTIPODEMANDASERVICO: 3
SIGLAABREV: 
LINKPROCESSO: 
IDBASECONHECIMENTO: 
IDLOCALEXECUCAOSERVICO: 4
DINAMICVIEWSTABLESVINC: 
DINAMICVIEWSACAOPESQUISASELECIONADA: 
IDSERVICO: 3
ACAOFLUXO: 
MODOEXIBICAO: N
DETALHESERVICO: Descrição do Serviço 3
SESSION.NUMERO_CONTRATO_EDICAO: null
NOMESERVICO: Serviço 3
DINAMICVIEWSJSON_DATA: 
IDEMPRESA: 1
DINAMICVIEWSIDVISAOPESQUISASELECIONADA: 
IDFLUXO: 
DESCRICAOPROCESSO: 
JSONMATRIZ: 
DATAINICIO: 01/04/2013
IDIMPORTANCIANEGOCIO: 10
DINAMICVIEWSIDVISAO: 17
IDTIPOSERVICO: 1
SESSION.DINAMICVIEWS_SAVEINFO: null
OBJETIVO: 
IDTAREFA: 
DINAMICVIEWSDADOSADICIONAIS: 
DISPPORTAL: S
IDTIPOEVENTOSERVICO: 33
');
INSERT INTO servico_hist VALUES (6, 4, 1, 1, 1, 10, 1, 33, 1, 4, 'Serviço 4', 'Descrição do Serviço 4', '', NULL, '2013-04-01', '', '', NULL, 'S', NULL, NULL, NULL, '', NULL, NULL, NULL, '2013-04-03 04:00:00', 'Administrador', '2013-04-03 04:00:00', 'Administrador', 'JSONDATA: 
NOCACHE: Wed Apr 03 2013 08:57:58 GMT-0300 (Hora oficial do Brasil)
IDCATEGORIASERVICO: 1
KEYCONTROL: 
DINAMICVIEWSJSON_TEMPDATA: 
IDSITUACAOSERVICO: 1
IDTIPODEMANDASERVICO: 1
SIGLAABREV: 
LINKPROCESSO: 
IDBASECONHECIMENTO: 
IDLOCALEXECUCAOSERVICO: 4
DINAMICVIEWSTABLESVINC: 
DINAMICVIEWSACAOPESQUISASELECIONADA: 
IDSERVICO: 4
ACAOFLUXO: 
MODOEXIBICAO: N
DETALHESERVICO: Descrição do Serviço 4
SESSION.NUMERO_CONTRATO_EDICAO: null
NOMESERVICO: Serviço 4
DINAMICVIEWSJSON_DATA: 
IDEMPRESA: 1
DINAMICVIEWSIDVISAOPESQUISASELECIONADA: 
IDFLUXO: 
DESCRICAOPROCESSO: 
JSONMATRIZ: 
DATAINICIO: 01/04/2013
IDIMPORTANCIANEGOCIO: 10
DINAMICVIEWSIDVISAO: 17
IDTIPOSERVICO: 1
SESSION.DINAMICVIEWS_SAVEINFO: null
OBJETIVO: 
IDTAREFA: 
DINAMICVIEWSDADOSADICIONAIS: 
DISPPORTAL: S
IDTIPOEVENTOSERVICO: 33
');
INSERT INTO servico_hist VALUES (7, 5, 1, 1, 1, 10, 1, 33, 1, 4, 'Serviço 5', 'Descrição do Serviço 5', '', NULL, '2013-04-01', '', '', NULL, 'S', NULL, NULL, NULL, '', NULL, NULL, NULL, '2013-04-03 04:00:00', 'Administrador', '2013-04-03 04:00:00', 'Administrador', 'JSONDATA: 
NOCACHE: Wed Apr 03 2013 09:01:22 GMT-0300 (Hora oficial do Brasil)
IDCATEGORIASERVICO: 1
KEYCONTROL: 
DINAMICVIEWSJSON_TEMPDATA: 
IDSITUACAOSERVICO: 1
IDTIPODEMANDASERVICO: 1
SIGLAABREV: 
LINKPROCESSO: 
IDBASECONHECIMENTO: 
IDLOCALEXECUCAOSERVICO: 4
DINAMICVIEWSTABLESVINC: 
DINAMICVIEWSACAOPESQUISASELECIONADA: 
IDSERVICO: 5
ACAOFLUXO: 
MODOEXIBICAO: N
DETALHESERVICO: Descrição do Serviço 5
SESSION.NUMERO_CONTRATO_EDICAO: null
NOMESERVICO: Serviço 5
DINAMICVIEWSJSON_DATA: 
IDEMPRESA: 1
DINAMICVIEWSIDVISAOPESQUISASELECIONADA: 
IDFLUXO: 
DESCRICAOPROCESSO: 
JSONMATRIZ: 
DATAINICIO: 01/04/2013
IDIMPORTANCIANEGOCIO: 10
DINAMICVIEWSIDVISAO: 17
IDTIPOSERVICO: 1
SESSION.DINAMICVIEWS_SAVEINFO: null
OBJETIVO: 
IDTAREFA: 
DINAMICVIEWSDADOSADICIONAIS: 
DISPPORTAL: S
IDTIPOEVENTOSERVICO: 33
');


--
-- TOC entry 6339 (class 0 OID 2249181)
-- Dependencies: 431 6388
-- Data for Name: servicocontrato; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO servicocontrato VALUES (1, 1, 1, 2, '2013-04-01', NULL, '', NULL, '', '', NULL, '', '', NULL, NULL, '', NULL, 17, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL);
INSERT INTO servicocontrato VALUES (2, 2, 1, 2, '2013-04-01', NULL, '', NULL, '', '', NULL, '', '', NULL, NULL, '', 2, 17, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL);
INSERT INTO servicocontrato VALUES (3, 3, 1, 2, '2013-04-01', NULL, '', NULL, '', '', NULL, '', '', NULL, NULL, '', 2, 17, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL);
INSERT INTO servicocontrato VALUES (4, 4, 1, 2, '2013-04-01', NULL, '', NULL, '', '', NULL, '', '', NULL, NULL, '', 2, 17, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL);
INSERT INTO servicocontrato VALUES (5, 5, 1, 2, '2013-04-01', NULL, '', NULL, '', '', NULL, '', '', NULL, NULL, '', 2, 17, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL);


--
-- TOC entry 6341 (class 0 OID 2249209)
-- Dependencies: 433 6388
-- Data for Name: servicos; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6508 (class 0 OID 0)
-- Dependencies: 432
-- Name: servicos_idservico_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('servicos_idservico_seq', 1, false);


--
-- TOC entry 6342 (class 0 OID 2249229)
-- Dependencies: 434 6388
-- Data for Name: sistemaoperacional; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6343 (class 0 OID 2249235)
-- Dependencies: 435 6388
-- Data for Name: situacaodemanda; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO situacaodemanda VALUES (1, 'Ativo');


--
-- TOC entry 6344 (class 0 OID 2249240)
-- Dependencies: 436 6388
-- Data for Name: situacaoservico; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO situacaoservico VALUES (-999, 1, 'Em Análise', NULL, NULL);
INSERT INTO situacaoservico VALUES (1, 1, 'Ativo', NULL, NULL);
INSERT INTO situacaoservico VALUES (2, 1, 'Inativo', NULL, NULL);
INSERT INTO situacaoservico VALUES (3, 1, 'Em criação', NULL, NULL);
INSERT INTO situacaoservico VALUES (4, 1, 'Em desenho', NULL, NULL);


--
-- TOC entry 6345 (class 0 OID 2249246)
-- Dependencies: 437 6388
-- Data for Name: slarequisitosla; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6347 (class 0 OID 2249316)
-- Dependencies: 439 6388
-- Data for Name: solicitacaoservicoevtmon; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6348 (class 0 OID 2249343)
-- Dependencies: 440 6388
-- Data for Name: solicitacaoservicomudanca; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6349 (class 0 OID 2249358)
-- Dependencies: 441 6388
-- Data for Name: solicitacaoservicoproblema; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6350 (class 0 OID 2249362)
-- Dependencies: 442 6388
-- Data for Name: tabfederacaodados; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6351 (class 0 OID 2249375)
-- Dependencies: 443 6388
-- Data for Name: templatesolicitacaoservico; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO templatesolicitacaoservico VALUES (10, 'AprovacaoSolicitacaoServico', 'Aprovação da Solicitação de Serviço', 'br.com.centralit.citcorpore.bean.AprovacaoSolicitacaoServicoDTO', 'br.com.centralit.citcorpore.ajaxForms.AprovacaoSolicitacaoServico', 'br.com.centralit.citcorpore.negocio.AprovacaoSolicitacaoServicoServiceEjb', '/pages/aprovacaoSolicitacaoServico/aprovacaoSolicitacaoServico.load', NULL, 'N', 'N', 'N', 250, 'N', 'N', 'N', 'N', 'N', 'N', 'S');


--
-- TOC entry 6352 (class 0 OID 2249393)
-- Dependencies: 444 6388
-- Data for Name: tempoacordonivelservico; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO tempoacordonivelservico VALUES (1, 1, 1, 0, 0);
INSERT INTO tempoacordonivelservico VALUES (1, 1, 2, 0, 0);
INSERT INTO tempoacordonivelservico VALUES (1, 2, 1, 0, 0);
INSERT INTO tempoacordonivelservico VALUES (1, 2, 2, 0, 0);
INSERT INTO tempoacordonivelservico VALUES (1, 3, 1, 0, 0);
INSERT INTO tempoacordonivelservico VALUES (1, 3, 2, 0, 0);
INSERT INTO tempoacordonivelservico VALUES (1, 4, 1, 0, 0);
INSERT INTO tempoacordonivelservico VALUES (1, 4, 2, 0, 0);
INSERT INTO tempoacordonivelservico VALUES (1, 5, 1, 0, 0);
INSERT INTO tempoacordonivelservico VALUES (1, 5, 2, 0, 0);
INSERT INTO tempoacordonivelservico VALUES (2, 1, 1, 0, 0);
INSERT INTO tempoacordonivelservico VALUES (2, 1, 2, 0, 0);
INSERT INTO tempoacordonivelservico VALUES (2, 2, 1, 0, 0);
INSERT INTO tempoacordonivelservico VALUES (2, 2, 2, 0, 0);
INSERT INTO tempoacordonivelservico VALUES (2, 3, 1, 0, 0);
INSERT INTO tempoacordonivelservico VALUES (2, 3, 2, 0, 0);
INSERT INTO tempoacordonivelservico VALUES (2, 4, 1, 0, 0);
INSERT INTO tempoacordonivelservico VALUES (2, 4, 2, 0, 0);
INSERT INTO tempoacordonivelservico VALUES (2, 5, 1, 0, 0);
INSERT INTO tempoacordonivelservico VALUES (2, 5, 2, 0, 0);
INSERT INTO tempoacordonivelservico VALUES (3, 1, 1, 0, 0);
INSERT INTO tempoacordonivelservico VALUES (3, 1, 2, 0, 0);
INSERT INTO tempoacordonivelservico VALUES (3, 2, 1, 0, 0);
INSERT INTO tempoacordonivelservico VALUES (3, 2, 2, 0, 0);
INSERT INTO tempoacordonivelservico VALUES (3, 3, 1, 0, 0);
INSERT INTO tempoacordonivelservico VALUES (3, 3, 2, 0, 0);
INSERT INTO tempoacordonivelservico VALUES (3, 4, 1, 0, 0);
INSERT INTO tempoacordonivelservico VALUES (3, 4, 2, 0, 0);
INSERT INTO tempoacordonivelservico VALUES (3, 5, 1, 0, 0);
INSERT INTO tempoacordonivelservico VALUES (3, 5, 2, 0, 0);


--
-- TOC entry 6353 (class 0 OID 2249399)
-- Dependencies: 445 6388
-- Data for Name: timers; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6354 (class 0 OID 2249410)
-- Dependencies: 446 6388
-- Data for Name: timesheet; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6355 (class 0 OID 2249421)
-- Dependencies: 447 6388
-- Data for Name: tipocomplexidade; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6356 (class 0 OID 2249426)
-- Dependencies: 448 6388
-- Data for Name: tipodemanda; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6357 (class 0 OID 2249431)
-- Dependencies: 449 6388
-- Data for Name: tipodemandaservico; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO tipodemandaservico VALUES (1, 'Requisição', 'R', NULL);
INSERT INTO tipodemandaservico VALUES (2, 'O.S. (Ordem de Serviço)', 'O', NULL);
INSERT INTO tipodemandaservico VALUES (3, 'Incidente', 'I', NULL);


--
-- TOC entry 6358 (class 0 OID 2249438)
-- Dependencies: 450 6388
-- Data for Name: tipoeventoservico; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO tipoeventoservico VALUES (1, 'EVENTUAL', NULL);
INSERT INTO tipoeventoservico VALUES (19, 'DIÁRIO', NULL);
INSERT INTO tipoeventoservico VALUES (30, 'SEMANAL', NULL);
INSERT INTO tipoeventoservico VALUES (31, 'MENSAL', NULL);
INSERT INTO tipoeventoservico VALUES (32, 'SEMESTRAL', NULL);
INSERT INTO tipoeventoservico VALUES (33, 'ANUAL', NULL);


--
-- TOC entry 6359 (class 0 OID 2249444)
-- Dependencies: 451 6388
-- Data for Name: tipoitemcfgcaracteristica; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6360 (class 0 OID 2249453)
-- Dependencies: 452 6388
-- Data for Name: tipoitemconfiguracao; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6362 (class 0 OID 2249503)
-- Dependencies: 454 6388
-- Data for Name: tipoos; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6363 (class 0 OID 2249512)
-- Dependencies: 455 6388
-- Data for Name: tipoproblemaatendimento; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6364 (class 0 OID 2249520)
-- Dependencies: 456 6388
-- Data for Name: tipoproduto; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6365 (class 0 OID 2249532)
-- Dependencies: 457 6388
-- Data for Name: tiposatividades; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6366 (class 0 OID 2249537)
-- Dependencies: 458 6388
-- Data for Name: tiposervico; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO tiposervico VALUES (1, 1, 'A DEFINIR', 'A');


--
-- TOC entry 6367 (class 0 OID 2249543)
-- Dependencies: 459 6388
-- Data for Name: tiposoftware; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO tiposoftware (idtiposoftware, nome) VALUES (1, 'Anti-virus'), (2, 'Auxiliar de escritório'), (3, 'Comunicador Instantâneo'), (4, 'Editor de Imagem'), (5, 'Editor de Texto'), (6, 'Navegador'), (7, 'Sistema Operacional'), (8, 'Outros');

--
-- TOC entry 6368 (class 0 OID 2249549)
-- Dependencies: 460 6388
-- Data for Name: tipounidade; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6369 (class 0 OID 2249555)
-- Dependencies: 461 6388
-- Data for Name: ufs; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO ufs VALUES (0, ' -- Indefinida -- ', '--', NULL, 1);
INSERT INTO ufs VALUES (1, 'Distrito Federal', 'DF', NULL, 1);
INSERT INTO ufs VALUES (2, 'São Paulo', 'SP', NULL, 1);
INSERT INTO ufs VALUES (3, 'Rio de Janeiro', 'RJ', NULL, 1);
INSERT INTO ufs VALUES (4, 'Goiás', 'GO', NULL, 1);
INSERT INTO ufs VALUES (5, 'Tocantins', 'TO', NULL, 1);
INSERT INTO ufs VALUES (6, 'Minas Gerais', 'MG', NULL, 1);
INSERT INTO ufs VALUES (7, 'Paraná', 'PR', NULL, 1);
INSERT INTO ufs VALUES (8, 'Espirito Santo', 'ES', NULL, 1);
INSERT INTO ufs VALUES (9, 'Acre', 'AC', NULL, 1);
INSERT INTO ufs VALUES (10, 'Alagoas', 'AL', NULL, 1);
INSERT INTO ufs VALUES (11, 'Amapá', 'AP', NULL, 1);
INSERT INTO ufs VALUES (12, 'Amazonas', 'AM', NULL, 1);
INSERT INTO ufs VALUES (13, 'Bahia', 'BA', NULL, 1);
INSERT INTO ufs VALUES (14, 'Ceará', 'CE', NULL, 1);
INSERT INTO ufs VALUES (15, 'Maranhão', 'MA', NULL, 1);
INSERT INTO ufs VALUES (16, 'Mato Grosso', 'MT', NULL, 1);
INSERT INTO ufs VALUES (17, 'Mato Grosso do Sul', 'MS', NULL, 1);
INSERT INTO ufs VALUES (18, 'Paraíba', 'PB', NULL, 1);
INSERT INTO ufs VALUES (19, 'Pará', 'PA', NULL, 1);
INSERT INTO ufs VALUES (20, 'Pernambuco', 'PE', NULL, 1);
INSERT INTO ufs VALUES (21, 'Piauí', 'PI', NULL, 1);
INSERT INTO ufs VALUES (22, 'Rio Grande do Norte', 'RN', NULL, 1);
INSERT INTO ufs VALUES (23, 'Rio Grande do Sul', 'RS', NULL, 1);
INSERT INTO ufs VALUES (24, 'Rondônia', 'RO', NULL, 1);
INSERT INTO ufs VALUES (25, 'Roraima', 'RR', NULL, 1);
INSERT INTO ufs VALUES (26, 'Santa Catarina', 'SC', NULL, 1);
INSERT INTO ufs VALUES (27, 'Sergipe', 'SE', NULL, 1);


--
-- TOC entry 6370 (class 0 OID 2249568)
-- Dependencies: 462 6388
-- Data for Name: unidade; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO unidade VALUES (1, NULL, NULL, 1, 'Default', '2012-01-01', NULL, '', '', NULL, NULL);


--
-- TOC entry 6371 (class 0 OID 2249587)
-- Dependencies: 463 6388
-- Data for Name: unidadebaseitemconfiguracao; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6372 (class 0 OID 2249593)
-- Dependencies: 464 6388
-- Data for Name: unidademedida; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6373 (class 0 OID 2249598)
-- Dependencies: 465 6388
-- Data for Name: unidadesaccservicos; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6374 (class 0 OID 2249604)
-- Dependencies: 466 6388
-- Data for Name: urgencia; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO urgencia VALUES (1, 'Crítica', 'C ');
INSERT INTO urgencia VALUES (2, 'Alta', 'A ');
INSERT INTO urgencia VALUES (3, 'Média', 'M ');
INSERT INTO urgencia VALUES (4, 'Baixa', 'B ');


--
-- TOC entry 6375 (class 0 OID 2249610)
-- Dependencies: 467 6388
-- Data for Name: usuario; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO usuario VALUES (1, NULL, 1, 1, 'admin', 'Administrador', '511574e821fa42fb7d31796ab74c1c721098a0df', 'A', NULL, NULL);
INSERT INTO usuario VALUES (2, NULL, 2, 1, 'default', 'Default', '40bd001563085fc35165329ea1ff5c5ecbdbbeef', 'A', NULL, NULL);
INSERT INTO usuario VALUES (3, NULL, 3, 1, 'consultor', 'Consultor', '04a991894ac6cdd7ef06d049feb9f0b9cc6c9004', 'A', NULL, NULL);


--
-- TOC entry 6376 (class 0 OID 2249626)
-- Dependencies: 468 6388
-- Data for Name: usuarioitemconfiguracao; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6377 (class 0 OID 2249632)
-- Dependencies: 469 6388
-- Data for Name: valor; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6378 (class 0 OID 2249646)
-- Dependencies: 470 6388
-- Data for Name: valorajusteglosa; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6379 (class 0 OID 2249651)
-- Dependencies: 471 6388
-- Data for Name: valorservicocontrato; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6380 (class 0 OID 2249663)
-- Dependencies: 472 6388
-- Data for Name: valorvisaocamposnegocio; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6381 (class 0 OID 2249672)
-- Dependencies: 473 6388
-- Data for Name: versao; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO versao VALUES (1, '2.0.5');


--
-- TOC entry 6382 (class 0 OID 2249679)
-- Dependencies: 474 6388
-- Data for Name: vinculaosincidente; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6383 (class 0 OID 2249684)
-- Dependencies: 475 6388
-- Data for Name: vinculovisao; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6384 (class 0 OID 2249692)
-- Dependencies: 476 6388
-- Data for Name: visao; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 6385 (class 0 OID 2249702)
-- Dependencies: 477 6388
-- Data for Name: visaorelacionada; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 4849 (class 2606 OID 2245993)
-- Dependencies: 161 161 6389
-- Name: acaoplanomelhoria_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY acaoplanomelhoria
    ADD CONSTRAINT acaoplanomelhoria_pkey PRIMARY KEY (idacaoplanomelhoria);


--
-- TOC entry 4858 (class 2606 OID 2246041)
-- Dependencies: 163 163 6389
-- Name: acordonivelservico_hist_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY acordonivelservico_hist
    ADD CONSTRAINT acordonivelservico_hist_pkey PRIMARY KEY (idacordonivelservico_hist);


--
-- TOC entry 4854 (class 2606 OID 2246016)
-- Dependencies: 162 162 6389
-- Name: acordonivelservico_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY acordonivelservico
    ADD CONSTRAINT acordonivelservico_pkey PRIMARY KEY (idacordonivelservico);


--
-- TOC entry 4862 (class 2606 OID 2246055)
-- Dependencies: 164 164 6389
-- Name: acordonivelservicocontrato_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY acordonivelservicocontrato
    ADD CONSTRAINT acordonivelservicocontrato_pkey PRIMARY KEY (idacordonivelservicocontrato);


--
-- TOC entry 4867 (class 2606 OID 2246063)
-- Dependencies: 165 165 6389
-- Name: acordoservicocontrato_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY acordoservicocontrato
    ADD CONSTRAINT acordoservicocontrato_pkey PRIMARY KEY (idacordoservicocontrato);


--
-- TOC entry 4869 (class 2606 OID 2246077)
-- Dependencies: 166 166 6389
-- Name: alcada_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY alcada
    ADD CONSTRAINT alcada_pkey PRIMARY KEY (idalcada);


--
-- TOC entry 4874 (class 2606 OID 2246082)
-- Dependencies: 167 167 6389
-- Name: alcadacentroresultado_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY alcadacentroresultado
    ADD CONSTRAINT alcadacentroresultado_pkey PRIMARY KEY (idalcadacentroresultado);


--
-- TOC entry 4877 (class 2606 OID 2246098)
-- Dependencies: 168 168 6389
-- Name: anexo_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY anexo
    ADD CONSTRAINT anexo_pkey PRIMARY KEY (idanexo);


--
-- TOC entry 4880 (class 2606 OID 2246107)
-- Dependencies: 169 169 6389
-- Name: anexobaseconhecimento_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY anexobaseconhecimento
    ADD CONSTRAINT anexobaseconhecimento_pkey PRIMARY KEY (idanexobaseconhecimento);


--
-- TOC entry 4882 (class 2606 OID 2246117)
-- Dependencies: 170 170 6389
-- Name: anexoincidente_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY anexoincidente
    ADD CONSTRAINT anexoincidente_pkey PRIMARY KEY (idanexoincidente);


--
-- TOC entry 4884 (class 2606 OID 2246129)
-- Dependencies: 171 171 6389
-- Name: anexomudanca_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY anexomudanca
    ADD CONSTRAINT anexomudanca_pkey PRIMARY KEY (idanexomudanca);


--
-- TOC entry 4888 (class 2606 OID 2246137)
-- Dependencies: 172 172 6389
-- Name: aprovacaomudanca_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY aprovacaomudanca
    ADD CONSTRAINT aprovacaomudanca_pkey PRIMARY KEY (idaprovacaomudanca);


--
-- TOC entry 4894 (class 2606 OID 2246147)
-- Dependencies: 173 173 6389
-- Name: aprovacaosolicitacaoservico_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY aprovacaosolicitacaoservico
    ADD CONSTRAINT aprovacaosolicitacaoservico_pkey PRIMARY KEY (idaprovacaosolicitacaoservico);


--
-- TOC entry 4897 (class 2606 OID 2246157)
-- Dependencies: 174 174 6389
-- Name: apuracaovaloresrecurso_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY apuracaovaloresrecurso
    ADD CONSTRAINT apuracaovaloresrecurso_pkey PRIMARY KEY (idapuracaovaloresrecurso);


--
-- TOC entry 4901 (class 2606 OID 2246170)
-- Dependencies: 175 175 6389
-- Name: atividadeperiodica_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY atividadeperiodica
    ADD CONSTRAINT atividadeperiodica_pkey PRIMARY KEY (idatividadeperiodica);


--
-- TOC entry 4906 (class 2606 OID 2246178)
-- Dependencies: 176 176 6389
-- Name: atividades_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY atividades
    ADD CONSTRAINT atividades_pkey PRIMARY KEY (idatividade);


--
-- TOC entry 4909 (class 2606 OID 2246186)
-- Dependencies: 177 177 177 6389
-- Name: atividadesfluxos_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY atividadesfluxos
    ADD CONSTRAINT atividadesfluxos_pkey PRIMARY KEY (idatividade, idfluxo);


--
-- TOC entry 4913 (class 2606 OID 2246201)
-- Dependencies: 178 178 6389
-- Name: atividadesos_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY atividadesos
    ADD CONSTRAINT atividadesos_pkey PRIMARY KEY (idatividadesos);


--
-- TOC entry 4916 (class 2606 OID 2246218)
-- Dependencies: 179 179 6389
-- Name: atividadesservicocontrato_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY atividadesservicocontrato
    ADD CONSTRAINT atividadesservicocontrato_pkey PRIMARY KEY (idatividadeservicocontrato);


--
-- TOC entry 4920 (class 2606 OID 2246228)
-- Dependencies: 180 180 6389
-- Name: auditoria_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY auditoria
    ADD CONSTRAINT auditoria_pkey PRIMARY KEY (idauditoria);


--
-- TOC entry 4924 (class 2606 OID 2246239)
-- Dependencies: 181 181 6389
-- Name: auditoriaitemconfiguracao_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY auditoriaitemconfiguracao
    ADD CONSTRAINT auditoriaitemconfiguracao_pkey PRIMARY KEY (idauditoria);


--
-- TOC entry 4928 (class 2606 OID 2246251)
-- Dependencies: 183 183 183 183 6389
-- Name: avaliacaocotacao_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY avaliacaocotacao
    ADD CONSTRAINT avaliacaocotacao_pkey PRIMARY KEY (idcriterio, idfornecedor, iditemcotacao);


--
-- TOC entry 4932 (class 2606 OID 2246261)
-- Dependencies: 184 184 6389
-- Name: avaliacaofornecedor_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY avaliacaofornecedor
    ADD CONSTRAINT avaliacaofornecedor_pkey PRIMARY KEY (idavaliacaofornecedor);


--
-- TOC entry 5919 (class 2606 OID 2249724)
-- Dependencies: 478 478 6389
-- Name: avaliacaopedido_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY avaliacaopedido
    ADD CONSTRAINT avaliacaopedido_pkey PRIMARY KEY (idavaliacao);


--
-- TOC entry 4935 (class 2606 OID 2246274)
-- Dependencies: 185 185 185 6389
-- Name: avaliacaoreferenciafornecedor_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY avaliacaoreferenciafornecedor
    ADD CONSTRAINT avaliacaoreferenciafornecedor_pkey PRIMARY KEY (idavaliacaofornecedor, idempregado);


--
-- TOC entry 4941 (class 2606 OID 2246298)
-- Dependencies: 186 186 6389
-- Name: baseconhecimento_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY baseconhecimento
    ADD CONSTRAINT baseconhecimento_pkey PRIMARY KEY (idbaseconhecimento);


--
-- TOC entry 4943 (class 2606 OID 2246307)
-- Dependencies: 187 187 187 6389
-- Name: baseconhecimentorelacionado_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY baseconhecimentorelacionado
    ADD CONSTRAINT baseconhecimentorelacionado_pkey PRIMARY KEY (idbaseconhecimento, idbaseconhecimentorelacionado);


--
-- TOC entry 4946 (class 2606 OID 2246317)
-- Dependencies: 188 188 6389
-- Name: baseitemconfiguracao_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY baseitemconfiguracao
    ADD CONSTRAINT baseitemconfiguracao_pkey PRIMARY KEY (idbaseitemconfiguracao);


--
-- TOC entry 4948 (class 2606 OID 2246326)
-- Dependencies: 189 189 6389
-- Name: bibliotecasexternas_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY bibliotecasexternas
    ADD CONSTRAINT bibliotecasexternas_pkey PRIMARY KEY (idbibliotecasexterna);


--
-- TOC entry 4951 (class 2606 OID 2246336)
-- Dependencies: 190 190 6389
-- Name: botaoacaovisao_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY botaoacaovisao
    ADD CONSTRAINT botaoacaovisao_pkey PRIMARY KEY (idbotaoacaovisao);


--
-- TOC entry 4956 (class 2606 OID 2246344)
-- Dependencies: 191 191 6389
-- Name: bpm_atribuicaofluxo_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY bpm_atribuicaofluxo
    ADD CONSTRAINT bpm_atribuicaofluxo_pkey PRIMARY KEY (idatribuicao);


--
-- TOC entry 4959 (class 2606 OID 2246367)
-- Dependencies: 192 192 6389
-- Name: bpm_elementofluxo_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY bpm_elementofluxo
    ADD CONSTRAINT bpm_elementofluxo_pkey PRIMARY KEY (idelemento);


--
-- TOC entry 4962 (class 2606 OID 2246376)
-- Dependencies: 193 193 6389
-- Name: bpm_fluxo_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY bpm_fluxo
    ADD CONSTRAINT bpm_fluxo_pkey PRIMARY KEY (idfluxo);


--
-- TOC entry 4968 (class 2606 OID 2246386)
-- Dependencies: 194 194 6389
-- Name: bpm_historicoitemtrabalho_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY bpm_historicoitemtrabalho
    ADD CONSTRAINT bpm_historicoitemtrabalho_pkey PRIMARY KEY (idhistoricoitemtrabalho);


--
-- TOC entry 4971 (class 2606 OID 2246399)
-- Dependencies: 195 195 6389
-- Name: bpm_instanciafluxo_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY bpm_instanciafluxo
    ADD CONSTRAINT bpm_instanciafluxo_pkey PRIMARY KEY (idinstancia);


--
-- TOC entry 4976 (class 2606 OID 2246408)
-- Dependencies: 196 196 6389
-- Name: bpm_itemtrabalhofluxo_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY bpm_itemtrabalhofluxo
    ADD CONSTRAINT bpm_itemtrabalhofluxo_pkey PRIMARY KEY (iditemtrabalho);


--
-- TOC entry 4981 (class 2606 OID 2246426)
-- Dependencies: 197 197 6389
-- Name: bpm_objetoinstanciafluxo_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY bpm_objetoinstanciafluxo
    ADD CONSTRAINT bpm_objetoinstanciafluxo_pkey PRIMARY KEY (idobjetoinstancia);


--
-- TOC entry 4985 (class 2606 OID 2246441)
-- Dependencies: 198 198 198 6389
-- Name: bpm_sequenciafluxo_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY bpm_sequenciafluxo
    ADD CONSTRAINT bpm_sequenciafluxo_pkey PRIMARY KEY (idelementoorigem, idelementodestino);


--
-- TOC entry 4987 (class 2606 OID 2246452)
-- Dependencies: 199 199 6389
-- Name: bpm_tipofluxo_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY bpm_tipofluxo
    ADD CONSTRAINT bpm_tipofluxo_pkey PRIMARY KEY (idtipofluxo);


--
-- TOC entry 4989 (class 2606 OID 2246459)
-- Dependencies: 200 200 6389
-- Name: calendario_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY calendario
    ADD CONSTRAINT calendario_pkey PRIMARY KEY (idcalendario);


--
-- TOC entry 4994 (class 2606 OID 2246464)
-- Dependencies: 201 201 6389
-- Name: campoobjrelacionado_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY campoobjrelacionado
    ADD CONSTRAINT campoobjrelacionado_pkey PRIMARY KEY (idcampoobjrelacionado);


--
-- TOC entry 4997 (class 2606 OID 2246473)
-- Dependencies: 202 202 6389
-- Name: camposobjetonegocio_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY camposobjetonegocio
    ADD CONSTRAINT camposobjetonegocio_pkey PRIMARY KEY (idcamposobjetonegocio);


--
-- TOC entry 5001 (class 2606 OID 2246486)
-- Dependencies: 203 203 6389
-- Name: caracteristica_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY caracteristica
    ADD CONSTRAINT caracteristica_pkey PRIMARY KEY (idcaracteristica);


--
-- TOC entry 5003 (class 2606 OID 2246493)
-- Dependencies: 204 204 6389
-- Name: cargos_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY cargos
    ADD CONSTRAINT cargos_pkey PRIMARY KEY (idcargo);


--
-- TOC entry 5006 (class 2606 OID 2246504)
-- Dependencies: 205 205 6389
-- Name: catalogoservico_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY catalogoservico
    ADD CONSTRAINT catalogoservico_pkey PRIMARY KEY (idcatalogoservico);


--
-- TOC entry 5008 (class 2606 OID 2246510)
-- Dependencies: 206 206 6389
-- Name: categoriagaleriaimagem_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY categoriagaleriaimagem
    ADD CONSTRAINT categoriagaleriaimagem_pkey PRIMARY KEY (idcategoriagaleriaimagem);


--
-- TOC entry 5017 (class 2606 OID 2246516)
-- Dependencies: 207 207 6389
-- Name: categoriamudanca_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY categoriamudanca
    ADD CONSTRAINT categoriamudanca_pkey PRIMARY KEY (idcategoriamudanca);


--
-- TOC entry 5019 (class 2606 OID 2246538)
-- Dependencies: 208 208 6389
-- Name: categoriaocorrencia_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY categoriaocorrencia
    ADD CONSTRAINT categoriaocorrencia_pkey PRIMARY KEY (idcategoriaocorrencia);


--
-- TOC entry 5021 (class 2606 OID 2246544)
-- Dependencies: 209 209 6389
-- Name: categoriapost_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY categoriapost
    ADD CONSTRAINT categoriapost_pkey PRIMARY KEY (idcategoriapost);


--
-- TOC entry 5024 (class 2606 OID 2246549)
-- Dependencies: 210 210 6389
-- Name: categoriaproblema_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY categoriaproblema
    ADD CONSTRAINT categoriaproblema_pkey PRIMARY KEY (idcategoriaproblema);


--
-- TOC entry 5027 (class 2606 OID 2246555)
-- Dependencies: 211 211 6389
-- Name: categoriaproduto_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY categoriaproduto
    ADD CONSTRAINT categoriaproduto_pkey PRIMARY KEY (idcategoria);


--
-- TOC entry 5029 (class 2606 OID 2246567)
-- Dependencies: 212 212 6389
-- Name: categoriaquestionario_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY categoriaquestionario
    ADD CONSTRAINT categoriaquestionario_pkey PRIMARY KEY (idcategoriaquestionario);


--
-- TOC entry 5034 (class 2606 OID 2246578)
-- Dependencies: 213 213 6389
-- Name: categoriaservico_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY categoriaservico
    ADD CONSTRAINT categoriaservico_pkey PRIMARY KEY (idcategoriaservico);


--
-- TOC entry 5037 (class 2606 OID 2246587)
-- Dependencies: 214 214 6389
-- Name: categoriasolucao_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY categoriasolucao
    ADD CONSTRAINT categoriasolucao_pkey PRIMARY KEY (idcategoriasolucao);


--
-- TOC entry 5040 (class 2606 OID 2246594)
-- Dependencies: 215 215 6389
-- Name: causaincidente_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY causaincidente
    ADD CONSTRAINT causaincidente_pkey PRIMARY KEY (idcausaincidente);


--
-- TOC entry 5042 (class 2606 OID 2246601)
-- Dependencies: 216 216 6389
-- Name: centroresultado_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY centroresultado
    ADD CONSTRAINT centroresultado_pkey PRIMARY KEY (idcentroresultado);


--
-- TOC entry 5045 (class 2606 OID 2246606)
-- Dependencies: 217 217 6389
-- Name: cidades_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY cidades
    ADD CONSTRAINT cidades_pkey PRIMARY KEY (idcidade);


--
-- TOC entry 5047 (class 2606 OID 2246618)
-- Dependencies: 218 218 6389
-- Name: clientes_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY clientes
    ADD CONSTRAINT clientes_pkey PRIMARY KEY (idcliente);


--
-- TOC entry 5050 (class 2606 OID 2246624)
-- Dependencies: 219 219 6389
-- Name: colecao_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY colecao
    ADD CONSTRAINT colecao_pkey PRIMARY KEY (idcolecao);


--
-- TOC entry 5057 (class 2606 OID 2246640)
-- Dependencies: 220 220 6389
-- Name: coletapreco_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY coletapreco
    ADD CONSTRAINT coletapreco_pkey PRIMARY KEY (idcoletapreco);


--
-- TOC entry 5059 (class 2606 OID 2246650)
-- Dependencies: 221 221 6389
-- Name: comando_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY comando
    ADD CONSTRAINT comando_pkey PRIMARY KEY (id);


--
-- TOC entry 5063 (class 2606 OID 2246660)
-- Dependencies: 222 222 6389
-- Name: comandosistemaoperacional_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY comandosistemaoperacional
    ADD CONSTRAINT comandosistemaoperacional_pkey PRIMARY KEY (id);


--
-- TOC entry 5066 (class 2606 OID 2246670)
-- Dependencies: 223 223 6389
-- Name: comentarios_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY comentarios
    ADD CONSTRAINT comentarios_pkey PRIMARY KEY (idcomentario);


--
-- TOC entry 5068 (class 2606 OID 2246679)
-- Dependencies: 224 224 224 6389
-- Name: complexidade_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY complexidade
    ADD CONSTRAINT complexidade_pkey PRIMARY KEY (idcontrato, complexidade);


--
-- TOC entry 5071 (class 2606 OID 2246684)
-- Dependencies: 225 225 6389
-- Name: condicaooperacao_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY condicaooperacao
    ADD CONSTRAINT condicaooperacao_pkey PRIMARY KEY (idcondicaooperacao);


--
-- TOC entry 5074 (class 2606 OID 2246690)
-- Dependencies: 226 226 226 6389
-- Name: conhecimentoic_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY conhecimentoic
    ADD CONSTRAINT conhecimentoic_pkey PRIMARY KEY (iditemconfiguracao, idbaseconhecimento);


--
-- TOC entry 5077 (class 2606 OID 2246701)
-- Dependencies: 227 227 227 6389
-- Name: conhecimentomudanca_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY conhecimentomudanca
    ADD CONSTRAINT conhecimentomudanca_pkey PRIMARY KEY (idrequisicaomudanca, idbaseconhecimento);


--
-- TOC entry 5080 (class 2606 OID 2246712)
-- Dependencies: 228 228 228 6389
-- Name: conhecimentoproblema_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY conhecimentoproblema
    ADD CONSTRAINT conhecimentoproblema_pkey PRIMARY KEY (idproblema, idbaseconhecimento);


--
-- TOC entry 5083 (class 2606 OID 2246723)
-- Dependencies: 229 229 229 6389
-- Name: conhecimentosolicitacaoservico_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY conhecimentosolicitacaoservico
    ADD CONSTRAINT conhecimentosolicitacaoservico_pkey PRIMARY KEY (idsolicitacaoservico, idbaseconhecimento);


--
-- TOC entry 5086 (class 2606 OID 2246735)
-- Dependencies: 230 230 6389
-- Name: contadoracesso_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY contadoracesso
    ADD CONSTRAINT contadoracesso_pkey PRIMARY KEY (idcontadoracesso);


--
-- TOC entry 5089 (class 2606 OID 2246747)
-- Dependencies: 231 231 6389
-- Name: contatocliente_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY contatocliente
    ADD CONSTRAINT contatocliente_pkey PRIMARY KEY (idcontatocliente);


--
-- TOC entry 5091 (class 2606 OID 2246760)
-- Dependencies: 232 232 6389
-- Name: contatorequisicaomudanca_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY contatorequisicaomudanca
    ADD CONSTRAINT contatorequisicaomudanca_pkey PRIMARY KEY (idcontatorequisicaomudanca);


--
-- TOC entry 5094 (class 2606 OID 2246770)
-- Dependencies: 233 233 6389
-- Name: contatosolicitacaoservico_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY contatosolicitacaoservico
    ADD CONSTRAINT contatosolicitacaoservico_pkey PRIMARY KEY (idcontatosolicitacaoservico);


--
-- TOC entry 5101 (class 2606 OID 2246783)
-- Dependencies: 234 234 6389
-- Name: contratoquestionarios_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY contratoquestionarios
    ADD CONSTRAINT contratoquestionarios_pkey PRIMARY KEY (idcontratoquestionario);


--
-- TOC entry 5111 (class 2606 OID 2246821)
-- Dependencies: 236 236 6389
-- Name: contratos_hist_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY contratos_hist
    ADD CONSTRAINT contratos_hist_pkey PRIMARY KEY (idcontrato_hist);


--
-- TOC entry 5106 (class 2606 OID 2246801)
-- Dependencies: 235 235 6389
-- Name: contratos_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY contratos
    ADD CONSTRAINT contratos_pkey PRIMARY KEY (idcontrato);


--
-- TOC entry 5114 (class 2606 OID 2246831)
-- Dependencies: 237 237 237 6389
-- Name: contratoscolaboradores_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY contratoscolaboradores
    ADD CONSTRAINT contratoscolaboradores_pkey PRIMARY KEY (idempregado, idcontrato);


--
-- TOC entry 5116 (class 2606 OID 2246839)
-- Dependencies: 238 238 238 6389
-- Name: contratosgrupos_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY contratosgrupos
    ADD CONSTRAINT contratosgrupos_pkey PRIMARY KEY (idgrupo, idcontrato);


--
-- TOC entry 5118 (class 2606 OID 2246846)
-- Dependencies: 239 239 239 6389
-- Name: contratosunidades_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY contratosunidades
    ADD CONSTRAINT contratosunidades_pkey PRIMARY KEY (idunidade, idcontrato);


--
-- TOC entry 5120 (class 2606 OID 2246858)
-- Dependencies: 240 240 6389
-- Name: controleged_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY controleged
    ADD CONSTRAINT controleged_pkey PRIMARY KEY (idcontroleged);


--
-- TOC entry 5122 (class 2606 OID 2246865)
-- Dependencies: 241 241 6389
-- Name: controlequestionarios_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY controlequestionarios
    ADD CONSTRAINT controlequestionarios_pkey PRIMARY KEY (idcontrolequestionario);


--
-- TOC entry 5125 (class 2606 OID 2246875)
-- Dependencies: 242 242 6389
-- Name: cotacao_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY cotacao
    ADD CONSTRAINT cotacao_pkey PRIMARY KEY (idcotacao);


--
-- TOC entry 5133 (class 2606 OID 2246885)
-- Dependencies: 243 243 243 6389
-- Name: cotacaoitemrequisicao_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY cotacaoitemrequisicao
    ADD CONSTRAINT cotacaoitemrequisicao_pkey PRIMARY KEY (idcoletapreco, iditemrequisicaoproduto);


--
-- TOC entry 5135 (class 2606 OID 2246926)
-- Dependencies: 244 244 6389
-- Name: criterioavaliacao_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY criterioavaliacao
    ADD CONSTRAINT criterioavaliacao_pkey PRIMARY KEY (idcriterio);


--
-- TOC entry 5138 (class 2606 OID 2246936)
-- Dependencies: 245 245 245 6389
-- Name: criterioavaliacaofornecedor_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY criterioavaliacaofornecedor
    ADD CONSTRAINT criterioavaliacaofornecedor_pkey PRIMARY KEY (idavaliacaofornecedor, idcriterio);


--
-- TOC entry 5141 (class 2606 OID 2246952)
-- Dependencies: 246 246 246 6389
-- Name: criteriocotacao_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY criteriocotacao
    ADD CONSTRAINT criteriocotacao_pkey PRIMARY KEY (idcotacao, idcriterio);


--
-- TOC entry 5144 (class 2606 OID 2246968)
-- Dependencies: 247 247 247 6389
-- Name: criteriocotacaocategoria_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY criteriocotacaocategoria
    ADD CONSTRAINT criteriocotacaocategoria_pkey PRIMARY KEY (idcategoria, idcriterio);


--
-- TOC entry 5147 (class 2606 OID 2246984)
-- Dependencies: 248 248 248 6389
-- Name: criterioitemcotacao_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY criterioitemcotacao
    ADD CONSTRAINT criterioitemcotacao_pkey PRIMARY KEY (idcriterio, iditemcotacao);


--
-- TOC entry 5155 (class 2606 OID 2246995)
-- Dependencies: 249 249 6389
-- Name: demandas_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY demandas
    ADD CONSTRAINT demandas_pkey PRIMARY KEY (iddemanda);


--
-- TOC entry 5159 (class 2606 OID 2247008)
-- Dependencies: 250 250 6389
-- Name: dicionario_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY dicionario
    ADD CONSTRAINT dicionario_pkey PRIMARY KEY (iddicionario);


--
-- TOC entry 5162 (class 2606 OID 2247019)
-- Dependencies: 251 251 6389
-- Name: emailsolicitacaoservico_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY emailsolicitacaoservico
    ADD CONSTRAINT emailsolicitacaoservico_pkey PRIMARY KEY (idemailsolicitacaoservico);


--
-- TOC entry 5166 (class 2606 OID 2247024)
-- Dependencies: 252 252 252 6389
-- Name: empregadoitemconfiguracao_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY empregadoitemconfiguracao
    ADD CONSTRAINT empregadoitemconfiguracao_pkey PRIMARY KEY (idusuario, iditemconfiguracao);


--
-- TOC entry 5170 (class 2606 OID 2247054)
-- Dependencies: 253 253 6389
-- Name: empregados_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY empregados
    ADD CONSTRAINT empregados_pkey PRIMARY KEY (idempregado);


--
-- TOC entry 5172 (class 2606 OID 2247065)
-- Dependencies: 254 254 6389
-- Name: empresa_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY empresa
    ADD CONSTRAINT empresa_pkey PRIMARY KEY (idempresa);


--
-- TOC entry 5174 (class 2606 OID 2247078)
-- Dependencies: 255 255 6389
-- Name: endereco_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY endereco
    ADD CONSTRAINT endereco_pkey PRIMARY KEY (idendereco);


--
-- TOC entry 5926 (class 2606 OID 2249758)
-- Dependencies: 479 479 6389
-- Name: entregaitemrequisicao_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY entregaitemrequisicao
    ADD CONSTRAINT entregaitemrequisicao_pkey PRIMARY KEY (identrega);


--
-- TOC entry 5178 (class 2606 OID 2247083)
-- Dependencies: 256 256 6389
-- Name: etapas_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY etapas
    ADD CONSTRAINT etapas_pkey PRIMARY KEY (idetapa);


--
-- TOC entry 5181 (class 2606 OID 2247095)
-- Dependencies: 257 257 6389
-- Name: evento_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY evento
    ADD CONSTRAINT evento_pkey PRIMARY KEY (idevento);


--
-- TOC entry 5186 (class 2606 OID 2247101)
-- Dependencies: 258 258 258 6389
-- Name: eventoempregado_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY eventoempregado
    ADD CONSTRAINT eventoempregado_pkey PRIMARY KEY (idevento, idempregado);


--
-- TOC entry 5189 (class 2606 OID 2247114)
-- Dependencies: 260 260 260 6389
-- Name: eventoitemconfiguracao_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY eventoitemconfiguracao
    ADD CONSTRAINT eventoitemconfiguracao_pkey PRIMARY KEY (idevento, iditemconfiguracao);


--
-- TOC entry 5191 (class 2606 OID 2247120)
-- Dependencies: 261 261 261 6389
-- Name: eventomonitconhecimento_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY eventomonitconhecimento
    ADD CONSTRAINT eventomonitconhecimento_pkey PRIMARY KEY (ideventomonitoramento, idbaseconhecimento);


--
-- TOC entry 5193 (class 2606 OID 2247130)
-- Dependencies: 262 262 6389
-- Name: eventomonitoramento_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY eventomonitoramento
    ADD CONSTRAINT eventomonitoramento_pkey PRIMARY KEY (ideventomonitoramento);


--
-- TOC entry 5197 (class 2606 OID 2247138)
-- Dependencies: 264 264 6389
-- Name: excecaocalendario_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY excecaocalendario
    ADD CONSTRAINT excecaocalendario_pkey PRIMARY KEY (idexcecaocalendario);


--
-- TOC entry 5202 (class 2606 OID 2247145)
-- Dependencies: 265 265 265 6389
-- Name: excecaoempregado_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY excecaoempregado
    ADD CONSTRAINT excecaoempregado_pkey PRIMARY KEY (idevento, idempregado);


--
-- TOC entry 5204 (class 2606 OID 2247160)
-- Dependencies: 266 266 6389
-- Name: execucaoatividadeperiodica_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY execucaoatividadeperiodica
    ADD CONSTRAINT execucaoatividadeperiodica_pkey PRIMARY KEY (idexecucaoatividadeperiodica);


--
-- TOC entry 5206 (class 2606 OID 2247169)
-- Dependencies: 267 267 6389
-- Name: execucaobatch_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY execucaobatch
    ADD CONSTRAINT execucaobatch_pkey PRIMARY KEY (idexecucaobatch);


--
-- TOC entry 5209 (class 2606 OID 2247181)
-- Dependencies: 268 268 6389
-- Name: execucaodemanda_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY execucaodemanda
    ADD CONSTRAINT execucaodemanda_pkey PRIMARY KEY (idexecucao);


--
-- TOC entry 5214 (class 2606 OID 2247187)
-- Dependencies: 269 269 6389
-- Name: execucaomudanca_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY execucaomudanca
    ADD CONSTRAINT execucaomudanca_pkey PRIMARY KEY (idexecucao);


--
-- TOC entry 5220 (class 2606 OID 2247205)
-- Dependencies: 270 270 6389
-- Name: execucaosolicitacao_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY execucaosolicitacao
    ADD CONSTRAINT execucaosolicitacao_pkey PRIMARY KEY (idexecucao);


--
-- TOC entry 5222 (class 2606 OID 2247225)
-- Dependencies: 271 271 6389
-- Name: externalconnection_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY externalconnection
    ADD CONSTRAINT externalconnection_pkey PRIMARY KEY (idexternalconnection);


--
-- TOC entry 5225 (class 2606 OID 2247234)
-- Dependencies: 272 272 6389
-- Name: faixavaloresrecurso_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY faixavaloresrecurso
    ADD CONSTRAINT faixavaloresrecurso_pkey PRIMARY KEY (idfaixavaloresrecurso);


--
-- TOC entry 5227 (class 2606 OID 2247240)
-- Dependencies: 273 273 6389
-- Name: faseservico_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY faseservico
    ADD CONSTRAINT faseservico_pkey PRIMARY KEY (idfase);


--
-- TOC entry 5230 (class 2606 OID 2247253)
-- Dependencies: 274 274 6389
-- Name: fatura_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY fatura
    ADD CONSTRAINT fatura_pkey PRIMARY KEY (idfatura);


--
-- TOC entry 5234 (class 2606 OID 2247265)
-- Dependencies: 275 275 6389
-- Name: faturaapuracaoans_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY faturaapuracaoans
    ADD CONSTRAINT faturaapuracaoans_pkey PRIMARY KEY (idfaturaapuracaoans);


--
-- TOC entry 5237 (class 2606 OID 2247272)
-- Dependencies: 276 276 276 6389
-- Name: faturaos_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY faturaos
    ADD CONSTRAINT faturaos_pkey PRIMARY KEY (idfatura, idos);


--
-- TOC entry 5239 (class 2606 OID 2247281)
-- Dependencies: 277 277 6389
-- Name: feriado_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY feriado
    ADD CONSTRAINT feriado_pkey PRIMARY KEY (idferiado);


--
-- TOC entry 5241 (class 2606 OID 2247289)
-- Dependencies: 278 278 6389
-- Name: fluxo_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY fluxo
    ADD CONSTRAINT fluxo_pkey PRIMARY KEY (idfluxo);


--
-- TOC entry 5243 (class 2606 OID 2247294)
-- Dependencies: 279 279 6389
-- Name: fluxos_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY fluxos
    ADD CONSTRAINT fluxos_pkey PRIMARY KEY (idfluxo);


--
-- TOC entry 5247 (class 2606 OID 2247301)
-- Dependencies: 280 280 280 280 6389
-- Name: fluxoservico_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY fluxoservico
    ADD CONSTRAINT fluxoservico_pkey PRIMARY KEY (idservicocontrato, idtipofluxo, idfase);


--
-- TOC entry 5249 (class 2606 OID 2247313)
-- Dependencies: 281 281 6389
-- Name: formula_identificador_key; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY formula
    ADD CONSTRAINT formula_identificador_key UNIQUE (identificador);


--
-- TOC entry 5251 (class 2606 OID 2247311)
-- Dependencies: 281 281 6389
-- Name: formula_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY formula
    ADD CONSTRAINT formula_pkey PRIMARY KEY (idformula);


--
-- TOC entry 5254 (class 2606 OID 2247331)
-- Dependencies: 282 282 6389
-- Name: fornecedor_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY fornecedor
    ADD CONSTRAINT fornecedor_pkey PRIMARY KEY (idfornecedor);


--
-- TOC entry 5257 (class 2606 OID 2247343)
-- Dependencies: 283 283 283 6389
-- Name: fornecedorcotacao_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY fornecedorcotacao
    ADD CONSTRAINT fornecedorcotacao_pkey PRIMARY KEY (idcotacao, idfornecedor);


--
-- TOC entry 5262 (class 2606 OID 2247359)
-- Dependencies: 284 284 6389
-- Name: fornecedorproduto_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY fornecedorproduto
    ADD CONSTRAINT fornecedorproduto_pkey PRIMARY KEY (idfornecedorproduto);


--
-- TOC entry 5265 (class 2606 OID 2247377)
-- Dependencies: 285 285 6389
-- Name: galeriaimagens_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY galeriaimagens
    ADD CONSTRAINT galeriaimagens_pkey PRIMARY KEY (idimagem);


--
-- TOC entry 5269 (class 2606 OID 2247387)
-- Dependencies: 286 286 6389
-- Name: glosaos_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY glosaos
    ADD CONSTRAINT glosaos_pkey PRIMARY KEY (idglosaos);


--
-- TOC entry 5271 (class 2606 OID 2247394)
-- Dependencies: 287 287 6389
-- Name: glosaservicocontrato_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY glosaservicocontrato
    ADD CONSTRAINT glosaservicocontrato_pkey PRIMARY KEY (idglosaservicocontrato);


--
-- TOC entry 5274 (class 2606 OID 2247408)
-- Dependencies: 288 288 6389
-- Name: grupo_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY grupo
    ADD CONSTRAINT grupo_pkey PRIMARY KEY (idgrupo);


--
-- TOC entry 5276 (class 2606 OID 2247418)
-- Dependencies: 289 289 6389
-- Name: grupoatvperiodica_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY grupoatvperiodica
    ADD CONSTRAINT grupoatvperiodica_pkey PRIMARY KEY (idgrupoatvperiodica);


--
-- TOC entry 5278 (class 2606 OID 2247425)
-- Dependencies: 290 290 6389
-- Name: grupoitemconfiguracao_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY grupoitemconfiguracao
    ADD CONSTRAINT grupoitemconfiguracao_pkey PRIMARY KEY (idgrupoitemconfiguracao);


--
-- TOC entry 5281 (class 2606 OID 2247430)
-- Dependencies: 291 291 6389
-- Name: grupoquestionario_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY grupoquestionario
    ADD CONSTRAINT grupoquestionario_pkey PRIMARY KEY (idgrupoquestionario);


--
-- TOC entry 5283 (class 2606 OID 2247437)
-- Dependencies: 292 292 6389
-- Name: gruporecursos_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY gruporecursos
    ADD CONSTRAINT gruporecursos_pkey PRIMARY KEY (idgruporecurso);


--
-- TOC entry 5285 (class 2606 OID 2247443)
-- Dependencies: 293 293 293 6389
-- Name: gruposemails_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY gruposemails
    ADD CONSTRAINT gruposemails_pkey PRIMARY KEY (idgrupo, email);


--
-- TOC entry 5288 (class 2606 OID 2247449)
-- Dependencies: 294 294 294 6389
-- Name: gruposempregados_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY gruposempregados
    ADD CONSTRAINT gruposempregados_pkey PRIMARY KEY (idgrupo, idempregado);


--
-- TOC entry 5291 (class 2606 OID 2247458)
-- Dependencies: 295 295 6389
-- Name: grupovisao_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY grupovisao
    ADD CONSTRAINT grupovisao_pkey PRIMARY KEY (idgrupovisao);


--
-- TOC entry 5294 (class 2606 OID 2247468)
-- Dependencies: 296 296 296 6389
-- Name: grupovisaocamposnegocio_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY grupovisaocamposnegocio
    ADD CONSTRAINT grupovisaocamposnegocio_pkey PRIMARY KEY (idgrupovisao, idcamposobjetonegocio);


--
-- TOC entry 5297 (class 2606 OID 2247478)
-- Dependencies: 297 297 6389
-- Name: grupovisaocamposnegocioinfosql_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY grupovisaocamposnegocioinfosql
    ADD CONSTRAINT grupovisaocamposnegocioinfosql_pkey PRIMARY KEY (idgrupovisaocamposnegocioinfosql);


--
-- TOC entry 5301 (class 2606 OID 2247488)
-- Dependencies: 298 298 6389
-- Name: grupovisaocamposnegocioligacao_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY grupovisaocamposnegocioligacao
    ADD CONSTRAINT grupovisaocamposnegocioligacao_pkey PRIMARY KEY (idgrupovisaocamposnegocioligaca);


--
-- TOC entry 5303 (class 2606 OID 2247495)
-- Dependencies: 299 299 6389
-- Name: hilosequences_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY hilosequences
    ADD CONSTRAINT hilosequences_pkey PRIMARY KEY (sequencename);


--
-- TOC entry 5305 (class 2606 OID 2247511)
-- Dependencies: 300 300 300 6389
-- Name: historicobaseconhecimento_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY historicobaseconhecimento
    ADD CONSTRAINT historicobaseconhecimento_pkey PRIMARY KEY (idhistoricobaseconhecimento, idbaseconhecimento);


--
-- TOC entry 5308 (class 2606 OID 2247519)
-- Dependencies: 301 301 6389
-- Name: historicoexecucao_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY historicoexecucao
    ADD CONSTRAINT historicoexecucao_pkey PRIMARY KEY (idhistorico);


--
-- TOC entry 5314 (class 2606 OID 2247537)
-- Dependencies: 302 302 6389
-- Name: historicoic_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY historicoic
    ADD CONSTRAINT historicoic_pkey PRIMARY KEY (idhistoricoic);


--
-- TOC entry 5318 (class 2606 OID 2247549)
-- Dependencies: 303 303 6389
-- Name: historicosituacaocotacao_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY historicosituacaocotacao
    ADD CONSTRAINT historicosituacaocotacao_pkey PRIMARY KEY (idhistorico);


--
-- TOC entry 5325 (class 2606 OID 2247570)
-- Dependencies: 304 304 6389
-- Name: historicotentativa_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY historicotentativa
    ADD CONSTRAINT historicotentativa_pkey PRIMARY KEY (idhistoricotentativa);


--
-- TOC entry 5328 (class 2606 OID 2247587)
-- Dependencies: 305 305 6389
-- Name: historicovalor_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY historicovalor
    ADD CONSTRAINT historicovalor_pkey PRIMARY KEY (idhistoricovalor);


--
-- TOC entry 5331 (class 2606 OID 2247598)
-- Dependencies: 306 306 6389
-- Name: htmlcodevisao_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY htmlcodevisao
    ADD CONSTRAINT htmlcodevisao_pkey PRIMARY KEY (idhtmlcodevisao);


ALTER TABLE ONLY instalacao
    ADD CONSTRAINT instalacao_pkey PRIMARY KEY (idinstalacao);
--
-- TOC entry 5334 (class 2606 OID 2247608)
-- Dependencies: 307 307 6389
-- Name: imagemhistorico_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY imagemhistorico
    ADD CONSTRAINT imagemhistorico_pkey PRIMARY KEY (idimagem);


--
-- TOC entry 5339 (class 2606 OID 2247619)
-- Dependencies: 308 308 6389
-- Name: imagemitemconfiguracao_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY imagemitemconfiguracao
    ADD CONSTRAINT imagemitemconfiguracao_pkey PRIMARY KEY (idimagemitemconfiguracao);


--
-- TOC entry 5344 (class 2606 OID 2247632)
-- Dependencies: 309 309 6389
-- Name: imagemservicorelacionado_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY imagemservicorelacionado
    ADD CONSTRAINT imagemservicorelacionado_pkey PRIMARY KEY (idimagemservicorelacionado);


--
-- TOC entry 5346 (class 2606 OID 2247641)
-- Dependencies: 310 310 6389
-- Name: impacto_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY impacto
    ADD CONSTRAINT impacto_pkey PRIMARY KEY (idimpacto);


--
-- TOC entry 5348 (class 2606 OID 2247646)
-- Dependencies: 311 311 311 6389
-- Name: importanciaconhecimentogrupo_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY importanciaconhecimentogrupo
    ADD CONSTRAINT importanciaconhecimentogrupo_pkey PRIMARY KEY (idbaseconhecimento, idgrupo);


--
-- TOC entry 5350 (class 2606 OID 2247651)
-- Dependencies: 312 312 312 6389
-- Name: importanciaconhecimentousuario_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY importanciaconhecimentousuario
    ADD CONSTRAINT importanciaconhecimentousuario_pkey PRIMARY KEY (idbaseconhecimento, idusuario);


--
-- TOC entry 5353 (class 2606 OID 2247656)
-- Dependencies: 313 313 6389
-- Name: importancianegocio_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY importancianegocio
    ADD CONSTRAINT importancianegocio_pkey PRIMARY KEY (idimportancianegocio);


--
-- TOC entry 5356 (class 2606 OID 2247668)
-- Dependencies: 314 314 6389
-- Name: importconfig_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY importconfig
    ADD CONSTRAINT importconfig_pkey PRIMARY KEY (idimportconfig);


--
-- TOC entry 5359 (class 2606 OID 2247684)
-- Dependencies: 315 315 6389
-- Name: importconfigcampos_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY importconfigcampos
    ADD CONSTRAINT importconfigcampos_pkey PRIMARY KEY (idimportconfigcampo);


--
-- TOC entry 5362 (class 2606 OID 2247699)
-- Dependencies: 316 316 6389
-- Name: infocatalogoservico_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY infocatalogoservico
    ADD CONSTRAINT infocatalogoservico_pkey PRIMARY KEY (idinfocatalogoservico);


--
-- TOC entry 5365 (class 2606 OID 2247716)
-- Dependencies: 318 318 6389
-- Name: informacaoservico_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY informacaoservico
    ADD CONSTRAINT informacaoservico_pkey PRIMARY KEY (idinformacaoservico);


--
-- TOC entry 5370 (class 2606 OID 2247734)
-- Dependencies: 319 319 6389
-- Name: informacoescontratoconfig_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY informacoescontratoconfig
    ADD CONSTRAINT informacoescontratoconfig_pkey PRIMARY KEY (idinformacoescontratoconfig);


--
-- TOC entry 5373 (class 2606 OID 2247742)
-- Dependencies: 320 320 320 6389
-- Name: informacoescontratoperfseg_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY informacoescontratoperfseg
    ADD CONSTRAINT informacoescontratoperfseg_pkey PRIMARY KEY (idinformacoescontratoconfig, idperfilseguranca);


--
-- TOC entry 5377 (class 2606 OID 2247753)
-- Dependencies: 321 321 321 6389
-- Name: inspecaoentregaitem_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY inspecaoentregaitem
    ADD CONSTRAINT inspecaoentregaitem_pkey PRIMARY KEY (identrega, idcriterio);


--
-- TOC entry 5381 (class 2606 OID 2247777)
-- Dependencies: 322 322 322 6389
-- Name: inspecaopedidocompra_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY inspecaopedidocompra
    ADD CONSTRAINT inspecaopedidocompra_pkey PRIMARY KEY (idpedido, idcriterio);


--
-- TOC entry 5384 (class 2606 OID 2247800)
-- Dependencies: 323 323 6389
-- Name: inventarioxml_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY inventarioxml
    ADD CONSTRAINT inventarioxml_pkey PRIMARY KEY (idinventarioxml);


--
-- TOC entry 5394 (class 2606 OID 2247821)
-- Dependencies: 325 325 6389
-- Name: itemconfiguracao_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY itemconfiguracao
    ADD CONSTRAINT itemconfiguracao_pkey PRIMARY KEY (iditemconfiguracao);


--
-- TOC entry 5403 (class 2606 OID 2247870)
-- Dependencies: 327 327 6389
-- Name: itemcotacao_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY itemcotacao
    ADD CONSTRAINT itemcotacao_pkey PRIMARY KEY (iditemcotacao);


--
-- TOC entry 5408 (class 2606 OID 2247896)
-- Dependencies: 328 328 6389
-- Name: itempedidocompra_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY itempedidocompra
    ADD CONSTRAINT itempedidocompra_pkey PRIMARY KEY (iditempedido);


--
-- TOC entry 5417 (class 2606 OID 2247920)
-- Dependencies: 329 329 6389
-- Name: itemrequisicaoproduto_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY itemrequisicaoproduto
    ADD CONSTRAINT itemrequisicaoproduto_pkey PRIMARY KEY (iditemrequisicaoproduto);


--
-- TOC entry 5419 (class 2606 OID 2247953)
-- Dependencies: 330 330 6389
-- Name: jornadatrabalho_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY jornadatrabalho
    ADD CONSTRAINT jornadatrabalho_pkey PRIMARY KEY (idjornada);


--
-- TOC entry 5426 (class 2606 OID 2247962)
-- Dependencies: 331 331 6389
-- Name: justificacaofalha_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY justificacaofalha
    ADD CONSTRAINT justificacaofalha_pkey PRIMARY KEY (idjustificacaofalha);


--
-- TOC entry 5428 (class 2606 OID 2247974)
-- Dependencies: 332 332 6389
-- Name: justificativamudanca_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY justificativamudanca
    ADD CONSTRAINT justificativamudanca_pkey PRIMARY KEY (idjustificativamudanca);


--
-- TOC entry 5430 (class 2606 OID 2247983)
-- Dependencies: 333 333 6389
-- Name: justificativaparecer_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY justificativaparecer
    ADD CONSTRAINT justificativaparecer_pkey PRIMARY KEY (idjustificativa);


--
-- TOC entry 5432 (class 2606 OID 2247990)
-- Dependencies: 334 334 6389
-- Name: justificativasolicitacao_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY justificativasolicitacao
    ADD CONSTRAINT justificativasolicitacao_pkey PRIMARY KEY (idjustificativa);


--
-- TOC entry 5436 (class 2606 OID 2247999)
-- Dependencies: 335 335 6389
-- Name: liberacao_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY liberacao
    ADD CONSTRAINT liberacao_pkey PRIMARY KEY (idliberacao);


--
-- TOC entry 5439 (class 2606 OID 2248006)
-- Dependencies: 336 336 336 6389
-- Name: liberacaomudanca_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

-- ALTER TABLE ONLY liberacaomudanca
--    ADD CONSTRAINT liberacaomudanca_pkey PRIMARY KEY (idliberacao, idrequisicaomudanca);


--
-- TOC entry 5443 (class 2606 OID 2248015)
-- Dependencies: 337 337 6389
-- Name: limitealcada_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY limitealcada
    ADD CONSTRAINT limitealcada_pkey PRIMARY KEY (idlimitealcada);


--
-- TOC entry 5445 (class 2606 OID 2248034)
-- Dependencies: 338 338 6389
-- Name: lingua_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY lingua
    ADD CONSTRAINT lingua_pkey PRIMARY KEY (idlingua);


--
-- TOC entry 5447 (class 2606 OID 2248040)
-- Dependencies: 339 339 6389
-- Name: localexecucaoservico_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY localexecucaoservico
    ADD CONSTRAINT localexecucaoservico_pkey PRIMARY KEY (idlocalexecucaoservico);


--
-- TOC entry 5449 (class 2606 OID 2248046)
-- Dependencies: 340 340 6389
-- Name: localidade_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY localidade
    ADD CONSTRAINT localidade_pkey PRIMARY KEY (idlocalidade);


--
-- TOC entry 5452 (class 2606 OID 2248051)
-- Dependencies: 341 341 6389
-- Name: localidadeunidade_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY localidadeunidade
    ADD CONSTRAINT localidadeunidade_pkey PRIMARY KEY (idlocalidadeunidade);


--
-- TOC entry 5454 (class 2606 OID 2248073)
-- Dependencies: 343 343 6389
-- Name: logdados_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY logdados
    ADD CONSTRAINT logdados_pkey PRIMARY KEY (idlog);


--
-- TOC entry 5457 (class 2606 OID 2248080)
-- Dependencies: 344 344 6389
-- Name: marca_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY marca
    ADD CONSTRAINT marca_pkey PRIMARY KEY (idmarca);


--
-- TOC entry 5459 (class 2606 OID 2248092)
-- Dependencies: 345 345 6389
-- Name: matrizprioridade_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY matrizprioridade
    ADD CONSTRAINT matrizprioridade_pkey PRIMARY KEY (idmatrizprioridade);


--
-- TOC entry 5466 (class 2606 OID 2248106)
-- Dependencies: 346 346 6389
-- Name: matrizvisao_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY matrizvisao
    ADD CONSTRAINT matrizvisao_pkey PRIMARY KEY (idmatriz);


--
-- TOC entry 5472 (class 2606 OID 2248139)
-- Dependencies: 347 347 6389
-- Name: menu_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY menu
    ADD CONSTRAINT menu_pkey PRIMARY KEY (idmenu);


--
-- TOC entry 5474 (class 2606 OID 2248148)
-- Dependencies: 348 348 348 6389
-- Name: meucatalogo_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY meucatalogo
    ADD CONSTRAINT meucatalogo_pkey PRIMARY KEY (idusuario, idservico);


--
-- TOC entry 5476 (class 2606 OID 2248155)
-- Dependencies: 349 349 6389
-- Name: midia_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY midia
    ADD CONSTRAINT midia_pkey PRIMARY KEY (idmidia);


--
-- TOC entry 5480 (class 2606 OID 2248166)
-- Dependencies: 350 350 6389
-- Name: midiasoftware_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY midiasoftware
    ADD CONSTRAINT midiasoftware_pkey PRIMARY KEY (idmidiasoftware);


--
-- TOC entry 5482 (class 2606 OID 2248177)
-- Dependencies: 351 351 6389
-- Name: modelosemails_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY modelosemails
    ADD CONSTRAINT modelosemails_pkey PRIMARY KEY (idmodeloemail);


--
-- TOC entry 5484 (class 2606 OID 2248182)
-- Dependencies: 352 352 6389
-- Name: moedas_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY moedas
    ADD CONSTRAINT moedas_pkey PRIMARY KEY (idmoeda);


--
-- TOC entry 5486 (class 2606 OID 2248187)
-- Dependencies: 353 353 6389
-- Name: motivosuspensaoativid_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY motivosuspensaoativid
    ADD CONSTRAINT motivosuspensaoativid_pkey PRIMARY KEY (idmotivo);


--
-- TOC entry 5488 (class 2606 OID 2248199)
-- Dependencies: 354 354 6389
-- Name: nagiosconexao_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY nagiosconexao
    ADD CONSTRAINT nagiosconexao_pkey PRIMARY KEY (idnagiosconexao);


--
-- TOC entry 5491 (class 2606 OID 2248208)
-- Dependencies: 355 355 6389
-- Name: netmap_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY netmap
    ADD CONSTRAINT netmap_pkey PRIMARY KEY (idnetmap);


--
-- TOC entry 5493 (class 2606 OID 2248216)
-- Dependencies: 356 356 6389
-- Name: notificacao_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY notificacao
    ADD CONSTRAINT notificacao_pkey PRIMARY KEY (idnotificacao);


--
-- TOC entry 5500 (class 2606 OID 2248257)
-- Dependencies: 360 360 6389
-- Name: objetivomonitoramento_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY objetivomonitoramento
    ADD CONSTRAINT objetivomonitoramento_pkey PRIMARY KEY (idobjetivomonitoramento);


--
-- TOC entry 5503 (class 2606 OID 2248270)
-- Dependencies: 361 361 6389
-- Name: objetivoplanomelhoria_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY objetivoplanomelhoria
    ADD CONSTRAINT objetivoplanomelhoria_pkey PRIMARY KEY (idobjetivoplanomelhoria);


--
-- TOC entry 5505 (class 2606 OID 2248279)
-- Dependencies: 362 362 6389
-- Name: objetonegocio_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY objetonegocio
    ADD CONSTRAINT objetonegocio_pkey PRIMARY KEY (idobjetonegocio);


--
-- TOC entry 5510 (class 2606 OID 2248292)
-- Dependencies: 363 363 6389
-- Name: ocorrenciamudanca_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY ocorrenciamudanca
    ADD CONSTRAINT ocorrenciamudanca_pkey PRIMARY KEY (idocorrencia);


--
-- TOC entry 5514 (class 2606 OID 2248313)
-- Dependencies: 364 364 6389
-- Name: ocorrencias_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY ocorrencias
    ADD CONSTRAINT ocorrencias_pkey PRIMARY KEY (idocorrencia);


--
-- TOC entry 5521 (class 2606 OID 2248328)
-- Dependencies: 365 365 6389
-- Name: ocorrenciasolicitacao_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY ocorrenciasolicitacao
    ADD CONSTRAINT ocorrenciasolicitacao_pkey PRIMARY KEY (idocorrencia);


--
-- TOC entry 5525 (class 2606 OID 2248356)
-- Dependencies: 366 366 6389
-- Name: opcaorespostaquestionario_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY opcaorespostaquestionario
    ADD CONSTRAINT opcaorespostaquestionario_pkey PRIMARY KEY (idopcaorespostaquestionario);


--
-- TOC entry 5527 (class 2606 OID 2248369)
-- Dependencies: 368 368 6389
-- Name: opiniao_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY opiniao
    ADD CONSTRAINT opiniao_pkey PRIMARY KEY (idopiniao);


--
-- TOC entry 5529 (class 2606 OID 2248376)
-- Dependencies: 369 369 6389
-- Name: origematendimento_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY origematendimento
    ADD CONSTRAINT origematendimento_pkey PRIMARY KEY (idorigem);


--
-- TOC entry 5531 (class 2606 OID 2248381)
-- Dependencies: 370 370 6389
-- Name: origemocorrencia_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY origemocorrencia
    ADD CONSTRAINT origemocorrencia_pkey PRIMARY KEY (idorigemocorrencia);


--
-- TOC entry 5539 (class 2606 OID 2248403)
-- Dependencies: 373 373 6389
-- Name: pais_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY pais
    ADD CONSTRAINT pais_pkey PRIMARY KEY (idpais);


--
-- TOC entry 5541 (class 2606 OID 2248411)
-- Dependencies: 374 374 6389
-- Name: palavragemea_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY palavragemea
    ADD CONSTRAINT palavragemea_pkey PRIMARY KEY (idpalavragemea);


--
-- TOC entry 5543 (class 2606 OID 2248416)
-- Dependencies: 375 375 6389
-- Name: parametrocorpore_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY parametrocorpore
    ADD CONSTRAINT parametrocorpore_pkey PRIMARY KEY (idparametrocorpore);


--
-- TOC entry 5546 (class 2606 OID 2248434)
-- Dependencies: 377 377 377 6389
-- Name: parametroscontrato_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY parametroscontrato
    ADD CONSTRAINT parametroscontrato_pkey PRIMARY KEY (idcontrato, nomeparametro);


--
-- TOC entry 5550 (class 2606 OID 2248443)
-- Dependencies: 378 378 6389
-- Name: parecer_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY parecer
    ADD CONSTRAINT parecer_pkey PRIMARY KEY (idparecer);


--
-- TOC entry 5553 (class 2606 OID 2248464)
-- Dependencies: 379 379 6389
-- Name: pasta_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY pasta
    ADD CONSTRAINT pasta_pkey PRIMARY KEY (idpasta);


--
-- TOC entry 5558 (class 2606 OID 2248478)
-- Dependencies: 380 380 6389
-- Name: pedidocompra_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY pedidocompra
    ADD CONSTRAINT pedidocompra_pkey PRIMARY KEY (idpedido);


--
-- TOC entry 5560 (class 2606 OID 2248501)
-- Dependencies: 381 381 6389
-- Name: perfilacesso_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY perfilacesso
    ADD CONSTRAINT perfilacesso_pkey PRIMARY KEY (idperfil);


--
-- TOC entry 5563 (class 2606 OID 2248506)
-- Dependencies: 382 382 382 382 6389
-- Name: perfilacessogrupo_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY perfilacessogrupo
    ADD CONSTRAINT perfilacessogrupo_pkey PRIMARY KEY (idperfil, idgrupo, datainicio);


--
-- TOC entry 5569 (class 2606 OID 2248521)
-- Dependencies: 384 384 384 6389
-- Name: perfilacessopasta_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY perfilacessopasta
    ADD CONSTRAINT perfilacessopasta_pkey PRIMARY KEY (idperfil, idpasta);


--
-- TOC entry 5571 (class 2606 OID 2248527)
-- Dependencies: 385 385 385 6389
-- Name: perfilacessosituacaofatura_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY perfilacessosituacaofatura
    ADD CONSTRAINT perfilacessosituacaofatura_pkey PRIMARY KEY (idperfil, situacaofatura);


--
-- TOC entry 5573 (class 2606 OID 2248532)
-- Dependencies: 386 386 386 6389
-- Name: perfilacessosituacaoos_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY perfilacessosituacaoos
    ADD CONSTRAINT perfilacessosituacaoos_pkey PRIMARY KEY (idperfil, situacaoos);


--
-- TOC entry 5577 (class 2606 OID 2248537)
-- Dependencies: 387 387 387 6389
-- Name: perfilacessousuario_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY perfilacessousuario
    ADD CONSTRAINT perfilacessousuario_pkey PRIMARY KEY (idusuario, idperfil);


--
-- TOC entry 5579 (class 2606 OID 2248545)
-- Dependencies: 388 388 6389
-- Name: perfilseguranca_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY perfilseguranca
    ADD CONSTRAINT perfilseguranca_pkey PRIMARY KEY (idperfilseguranca);


--
-- TOC entry 5582 (class 2606 OID 2248553)
-- Dependencies: 389 389 389 6389
-- Name: permissoesfluxo_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY permissoesfluxo
    ADD CONSTRAINT permissoesfluxo_pkey PRIMARY KEY (idgrupo, idtipofluxo);


--
-- TOC entry 5585 (class 2606 OID 2248562)
-- Dependencies: 390 390 6389
-- Name: pesquisasatisfacao_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY pesquisasatisfacao
    ADD CONSTRAINT pesquisasatisfacao_pkey PRIMARY KEY (idpesquisasatisfacao);


--
-- TOC entry 5587 (class 2606 OID 2248570)
-- Dependencies: 391 391 6389
-- Name: pessoa_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY pessoa
    ADD CONSTRAINT pessoa_pkey PRIMARY KEY (tokenidentificacao);


--
-- TOC entry 5591 (class 2606 OID 2248581)
-- Dependencies: 392 392 6389
-- Name: planomelhoria_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY planomelhoria
    ADD CONSTRAINT planomelhoria_pkey PRIMARY KEY (idplanomelhoria);


--
-- TOC entry 5593 (class 2606 OID 2248589)
-- Dependencies: 393 393 6389
-- Name: portal_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY portal
    ADD CONSTRAINT portal_pkey PRIMARY KEY (idportal);


--
-- TOC entry 5596 (class 2606 OID 2248601)
-- Dependencies: 394 394 6389
-- Name: post_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY post
    ADD CONSTRAINT post_pkey PRIMARY KEY (idpost);


--
-- TOC entry 5599 (class 2606 OID 2248612)
-- Dependencies: 395 395 6389
-- Name: prioridade_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY prioridade
    ADD CONSTRAINT prioridade_pkey PRIMARY KEY (idprioridade);


--
-- TOC entry 5601 (class 2606 OID 2248618)
-- Dependencies: 396 396 396 6389
-- Name: prioridadeacordonivelservico_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY prioridadeacordonivelservico
    ADD CONSTRAINT prioridadeacordonivelservico_pkey PRIMARY KEY (idunidade, idacordonivelservico);


--
-- TOC entry 5605 (class 2606 OID 2248623)
-- Dependencies: 397 397 397 6389
-- Name: prioridadeservicounidade_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY prioridadeservicounidade
    ADD CONSTRAINT prioridadeservicounidade_pkey PRIMARY KEY (idunidade, idservicocontrato);


--
-- TOC entry 5610 (class 2606 OID 2248649)
-- Dependencies: 398 398 6389
-- Name: problema_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY problema
    ADD CONSTRAINT problema_pkey PRIMARY KEY (idproblema);


--
-- TOC entry 5614 (class 2606 OID 2248660)
-- Dependencies: 399 399 6389
-- Name: problemaitemconfiguracao_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY problemaitemconfiguracao
    ADD CONSTRAINT problemaitemconfiguracao_pkey PRIMARY KEY (idproblemaitemconfiguracao);


--
-- TOC entry 5618 (class 2606 OID 2248667)
-- Dependencies: 400 400 6389
-- Name: problemamudanca_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY problemamudanca
    ADD CONSTRAINT problemamudanca_pkey PRIMARY KEY (idproblemamudanca);


--
-- TOC entry 5620 (class 2606 OID 2248677)
-- Dependencies: 401 401 6389
-- Name: procedimentotecnico_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY procedimentotecnico
    ADD CONSTRAINT procedimentotecnico_pkey PRIMARY KEY (idprocedimentotecnico);


--
-- TOC entry 5622 (class 2606 OID 2248686)
-- Dependencies: 402 402 6389
-- Name: processamentobatch_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY processamentobatch
    ADD CONSTRAINT processamentobatch_pkey PRIMARY KEY (idprocessamentobatch);


--
-- TOC entry 5626 (class 2606 OID 2248698)
-- Dependencies: 403 403 6389
-- Name: produto_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY produto
    ADD CONSTRAINT produto_pkey PRIMARY KEY (idproduto);


--
-- TOC entry 5628 (class 2606 OID 2248733)
-- Dependencies: 404 404 6389
-- Name: programacaoatividade_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY programacaoatividade
    ADD CONSTRAINT programacaoatividade_pkey PRIMARY KEY (idprogramacaoatividade);


--
-- TOC entry 5632 (class 2606 OID 2248741)
-- Dependencies: 405 405 6389
-- Name: projetos_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY projetos
    ADD CONSTRAINT projetos_pkey PRIMARY KEY (idprojeto);


--
-- TOC entry 5640 (class 2606 OID 2248768)
-- Dependencies: 406 406 6389
-- Name: questaoquestionario_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY questaoquestionario
    ADD CONSTRAINT questaoquestionario_pkey PRIMARY KEY (idquestaoquestionario);


--
-- TOC entry 5644 (class 2606 OID 2248780)
-- Dependencies: 407 407 6389
-- Name: questionario_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY questionario
    ADD CONSTRAINT questionario_pkey PRIMARY KEY (idquestionario);


--
-- TOC entry 5647 (class 2606 OID 2248791)
-- Dependencies: 408 408 408 6389
-- Name: reaberturasolicitacao_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY reaberturasolicitacao
    ADD CONSTRAINT reaberturasolicitacao_pkey PRIMARY KEY (idsolicitacaoservico, seqreabertura);


--
-- TOC entry 5659 (class 2606 OID 2248812)
-- Dependencies: 409 409 6389
-- Name: recurso_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY recurso
    ADD CONSTRAINT recurso_pkey PRIMARY KEY (idrecurso);


--
-- TOC entry 5661 (class 2606 OID 2248874)
-- Dependencies: 410 410 6389
-- Name: regioes_nome_key; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY regioes
    ADD CONSTRAINT regioes_nome_key UNIQUE (nome);


--
-- TOC entry 5663 (class 2606 OID 2248872)
-- Dependencies: 410 410 6389
-- Name: regioes_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY regioes
    ADD CONSTRAINT regioes_pkey PRIMARY KEY (idregioes);


--
-- TOC entry 5665 (class 2606 OID 2248880)
-- Dependencies: 411 411 6389
-- Name: registro_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY registro
    ADD CONSTRAINT registro_pkey PRIMARY KEY (idregistro);


--
-- TOC entry 5668 (class 2606 OID 2248888)
-- Dependencies: 412 412 412 6389
-- Name: relacionamentoproduto_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY relacionamentoproduto
    ADD CONSTRAINT relacionamentoproduto_pkey PRIMARY KEY (idtipoproduto, idtipoprodutorelacionado);


--
-- TOC entry 5672 (class 2606 OID 2248894)
-- Dependencies: 413 413 6389
-- Name: relacobjetonegocio_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY relacobjetonegocio
    ADD CONSTRAINT relacobjetonegocio_pkey PRIMARY KEY (idrelacobjetonegocio);


--
-- TOC entry 5680 (class 2606 OID 2248922)
-- Dependencies: 414 414 6389
-- Name: requisicaomudanca_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY requisicaomudanca
    ADD CONSTRAINT requisicaomudanca_pkey PRIMARY KEY (idrequisicaomudanca);


--
-- TOC entry 5684 (class 2606 OID 2248959)
-- Dependencies: 415 415 6389
-- Name: requisicaomudancaitemconfiguracao_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY requisicaomudancaitemconfiguracao
    ADD CONSTRAINT requisicaomudancaitemconfiguracao_pkey PRIMARY KEY (idrequisicaomudancaitemconfiguracao);


--
-- TOC entry 5688 (class 2606 OID 2248976)
-- Dependencies: 416 416 6389
-- Name: requisicaomudancaservico_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY requisicaomudancaservico
    ADD CONSTRAINT requisicaomudancaservico_pkey PRIMARY KEY (idrequisicaomudancaservico);


--
-- TOC entry 5693 (class 2606 OID 2248988)
-- Dependencies: 417 417 6389
-- Name: requisicaoproduto_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY requisicaoproduto
    ADD CONSTRAINT requisicaoproduto_pkey PRIMARY KEY (idsolicitacaoservico);


--
-- TOC entry 5696 (class 2606 OID 2249019)
-- Dependencies: 418 418 6389
-- Name: requisitosla_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY requisitosla
    ADD CONSTRAINT requisitosla_pkey PRIMARY KEY (idrequisitosla);


--
-- TOC entry 5702 (class 2606 OID 2249036)
-- Dependencies: 419 419 6389
-- Name: responsabilidade_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY responsabilidade
    ADD CONSTRAINT responsabilidade_pkey PRIMARY KEY (idresponsabilidade);


--
-- TOC entry 5707 (class 2606 OID 2249058)
-- Dependencies: 420 420 6389
-- Name: respostaitemquestionario_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY respostaitemquestionario
    ADD CONSTRAINT respostaitemquestionario_pkey PRIMARY KEY (idrespostaitemquestionario);


--
-- TOC entry 5710 (class 2606 OID 2249069)
-- Dependencies: 421 421 6389
-- Name: respostaitemquestionarioanexos_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY respostaitemquestionarioanexos
    ADD CONSTRAINT respostaitemquestionarioanexos_pkey PRIMARY KEY (idrespostaitmquestionarioanexo);


--
-- TOC entry 5714 (class 2606 OID 2249075)
-- Dependencies: 422 422 6389
-- Name: respostaitemquestionariocids_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY respostaitemquestionariocids
    ADD CONSTRAINT respostaitemquestionariocids_pkey PRIMARY KEY (idrespostaitemquestionariocid);


--
-- TOC entry 5717 (class 2606 OID 2249082)
-- Dependencies: 423 423 423 6389
-- Name: respostaitemquestionarioopcoes_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY respostaitemquestionarioopcoes
    ADD CONSTRAINT respostaitemquestionarioopcoes_pkey PRIMARY KEY (idrespostaitemquestionario, idopcaorespostaquestionario);


--
-- TOC entry 5719 (class 2606 OID 2249104)
-- Dependencies: 425 425 6389
-- Name: revisarsla_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY revisarsla
    ADD CONSTRAINT revisarsla_pkey PRIMARY KEY (idrevisarsla);


--
-- TOC entry 5721 (class 2606 OID 2249114)
-- Dependencies: 426 426 6389
-- Name: scripts_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY scripts
    ADD CONSTRAINT scripts_pkey PRIMARY KEY (idscript);


--
-- TOC entry 5724 (class 2606 OID 2249123)
-- Dependencies: 427 427 6389
-- Name: scriptsvisao_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY scriptsvisao
    ADD CONSTRAINT scriptsvisao_pkey PRIMARY KEY (idscriptsvisao);


--
-- TOC entry 5742 (class 2606 OID 2249178)
-- Dependencies: 430 430 6389
-- Name: servico_hist_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY servico_hist
    ADD CONSTRAINT servico_hist_pkey PRIMARY KEY (idhistoricoservico);


--
-- TOC entry 5740 (class 2606 OID 2249148)
-- Dependencies: 429 429 6389
-- Name: servico_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY servico
    ADD CONSTRAINT servico_pkey PRIMARY KEY (idservico);


--
-- TOC entry 5753 (class 2606 OID 2249197)
-- Dependencies: 431 431 6389
-- Name: servicocontrato_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY servicocontrato
    ADD CONSTRAINT servicocontrato_pkey PRIMARY KEY (idservicocontrato);


--
-- TOC entry 5755 (class 2606 OID 2249228)
-- Dependencies: 433 433 6389
-- Name: servicos_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY servicos
    ADD CONSTRAINT servicos_pkey PRIMARY KEY (idservico);


--
-- TOC entry 5757 (class 2606 OID 2249234)
-- Dependencies: 434 434 6389
-- Name: sistemaoperacional_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY sistemaoperacional
    ADD CONSTRAINT sistemaoperacional_pkey PRIMARY KEY (id);


--
-- TOC entry 5759 (class 2606 OID 2249239)
-- Dependencies: 435 435 6389
-- Name: situacaodemanda_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY situacaodemanda
    ADD CONSTRAINT situacaodemanda_pkey PRIMARY KEY (idsituacaodemanda);


--
-- TOC entry 5762 (class 2606 OID 2249244)
-- Dependencies: 436 436 6389
-- Name: situacaoservico_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY situacaoservico
    ADD CONSTRAINT situacaoservico_pkey PRIMARY KEY (idsituacaoservico);


--
-- TOC entry 5765 (class 2606 OID 2249253)
-- Dependencies: 437 437 437 6389
-- Name: slarequisitosla_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY slarequisitosla
    ADD CONSTRAINT slarequisitosla_pkey PRIMARY KEY (idrequisitosla, idacordonivelservico);


--
-- TOC entry 5791 (class 2606 OID 2249286)
-- Dependencies: 438 438 6389
-- Name: solicitacaoservico_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY solicitacaoservico
    ADD CONSTRAINT solicitacaoservico_pkey PRIMARY KEY (idsolicitacaoservico);


--
-- TOC entry 5795 (class 2606 OID 2249325)
-- Dependencies: 439 439 439 6389
-- Name: solicitacaoservicoevtmon_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY solicitacaoservicoevtmon
    ADD CONSTRAINT solicitacaoservicoevtmon_pkey PRIMARY KEY (idsolicitacaoservico, ideventomonitoramento);


--
-- TOC entry 5801 (class 2606 OID 2249371)
-- Dependencies: 442 442 442 6389
-- Name: tabfederacaodados_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY tabfederacaodados
    ADD CONSTRAINT tabfederacaodados_pkey PRIMARY KEY (nometabela, chavefinal);


--
-- TOC entry 5803 (class 2606 OID 2249392)
-- Dependencies: 443 443 6389
-- Name: templatesolicitacaoservico_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY templatesolicitacaoservico
    ADD CONSTRAINT templatesolicitacaoservico_pkey PRIMARY KEY (idtemplate);


--
-- TOC entry 5806 (class 2606 OID 2249397)
-- Dependencies: 444 444 444 444 6389
-- Name: tempoacordonivelservico_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY tempoacordonivelservico
    ADD CONSTRAINT tempoacordonivelservico_pkey PRIMARY KEY (idacordonivelservico, idprioridade, idfase);


--
-- TOC entry 5808 (class 2606 OID 2249407)
-- Dependencies: 445 445 445 6389
-- Name: timers_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY timers
    ADD CONSTRAINT timers_pkey PRIMARY KEY (timerid, targetid);


--
-- TOC entry 5813 (class 2606 OID 2249417)
-- Dependencies: 446 446 6389
-- Name: timesheet_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY timesheet
    ADD CONSTRAINT timesheet_pkey PRIMARY KEY (idtimesheet);


--
-- TOC entry 5815 (class 2606 OID 2249425)
-- Dependencies: 447 447 6389
-- Name: tipocomplexidade_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY tipocomplexidade
    ADD CONSTRAINT tipocomplexidade_pkey PRIMARY KEY (complexidade);


--
-- TOC entry 5817 (class 2606 OID 2249430)
-- Dependencies: 448 448 6389
-- Name: tipodemanda_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY tipodemanda
    ADD CONSTRAINT tipodemanda_pkey PRIMARY KEY (idtipodemanda);


--
-- TOC entry 5819 (class 2606 OID 2249437)
-- Dependencies: 449 449 6389
-- Name: tipodemandaservico_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY tipodemandaservico
    ADD CONSTRAINT tipodemandaservico_pkey PRIMARY KEY (idtipodemandaservico);


--
-- TOC entry 5821 (class 2606 OID 2249443)
-- Dependencies: 450 450 6389
-- Name: tipoeventoservico_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY tipoeventoservico
    ADD CONSTRAINT tipoeventoservico_pkey PRIMARY KEY (idtipoeventoservico);


--
-- TOC entry 5826 (class 2606 OID 2249449)
-- Dependencies: 451 451 6389
-- Name: tipoitemcfgcaracteristica_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY tipoitemcfgcaracteristica
    ADD CONSTRAINT tipoitemcfgcaracteristica_pkey PRIMARY KEY (id);


--
-- TOC entry 5829 (class 2606 OID 2249459)
-- Dependencies: 452 452 6389
-- Name: tipoitemconfiguracao_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY tipoitemconfiguracao
    ADD CONSTRAINT tipoitemconfiguracao_pkey PRIMARY KEY (idtipoitemconfiguracao);


--
-- TOC entry 5837 (class 2606 OID 2249466)
-- Dependencies: 453 453 6389
-- Name: tipomudanca_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY tipomudanca
    ADD CONSTRAINT tipomudanca_pkey PRIMARY KEY (idtipomudanca);


--
-- TOC entry 5840 (class 2606 OID 2249510)
-- Dependencies: 454 454 6389
-- Name: tipoos_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY tipoos
    ADD CONSTRAINT tipoos_pkey PRIMARY KEY (idclassificacaoos);


--
-- TOC entry 5842 (class 2606 OID 2249519)
-- Dependencies: 455 455 6389
-- Name: tipoproblemaatendimento_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY tipoproblemaatendimento
    ADD CONSTRAINT tipoproblemaatendimento_pkey PRIMARY KEY (idtipoproblema);


--
-- TOC entry 5846 (class 2606 OID 2249524)
-- Dependencies: 456 456 6389
-- Name: tipoproduto_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY tipoproduto
    ADD CONSTRAINT tipoproduto_pkey PRIMARY KEY (idtipoproduto);


--
-- TOC entry 5848 (class 2606 OID 2249536)
-- Dependencies: 457 457 6389
-- Name: tiposatividades_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY tiposatividades
    ADD CONSTRAINT tiposatividades_pkey PRIMARY KEY (idtipoatividade);


--
-- TOC entry 5851 (class 2606 OID 2249541)
-- Dependencies: 458 458 6389
-- Name: tiposervico_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY tiposervico
    ADD CONSTRAINT tiposervico_pkey PRIMARY KEY (idtiposervico);


--
-- TOC entry 5853 (class 2606 OID 2249548)
-- Dependencies: 459 459 6389
-- Name: tiposoftware_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY tiposoftware
    ADD CONSTRAINT tiposoftware_pkey PRIMARY KEY (idtiposoftware);


--
-- TOC entry 5856 (class 2606 OID 2249553)
-- Dependencies: 460 460 6389
-- Name: tipounidade_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY tipounidade
    ADD CONSTRAINT tipounidade_pkey PRIMARY KEY (idtipounidade);


--
-- TOC entry 5860 (class 2606 OID 2249560)
-- Dependencies: 461 461 6389
-- Name: ufs_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY ufs
    ADD CONSTRAINT ufs_pkey PRIMARY KEY (iduf);


--
-- TOC entry 5866 (class 2606 OID 2249577)
-- Dependencies: 462 462 6389
-- Name: unidade_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY unidade
    ADD CONSTRAINT unidade_pkey PRIMARY KEY (idunidade);


--
-- TOC entry 5869 (class 2606 OID 2249591)
-- Dependencies: 463 463 6389
-- Name: unidadebaseitemconfiguracao_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY unidadebaseitemconfiguracao
    ADD CONSTRAINT unidadebaseitemconfiguracao_pkey PRIMARY KEY (idbaseitemconfiguracao);


--
-- TOC entry 5871 (class 2606 OID 2249597)
-- Dependencies: 464 464 6389
-- Name: unidademedida_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY unidademedida
    ADD CONSTRAINT unidademedida_pkey PRIMARY KEY (idunidademedida);


--
-- TOC entry 5874 (class 2606 OID 2249602)
-- Dependencies: 465 465 465 6389
-- Name: unidadesaccservicos_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY unidadesaccservicos
    ADD CONSTRAINT unidadesaccservicos_pkey PRIMARY KEY (idunidade, idservico);


--
-- TOC entry 5876 (class 2606 OID 2249609)
-- Dependencies: 466 466 6389
-- Name: urgencia_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY urgencia
    ADD CONSTRAINT urgencia_pkey PRIMARY KEY (idurgencia);


--
-- TOC entry 5881 (class 2606 OID 2249622)
-- Dependencies: 467 467 6389
-- Name: usuario_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY usuario
    ADD CONSTRAINT usuario_pkey PRIMARY KEY (idusuario);


--
-- TOC entry 5884 (class 2606 OID 2249630)
-- Dependencies: 468 468 468 6389
-- Name: usuarioitemconfiguracao_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY usuarioitemconfiguracao
    ADD CONSTRAINT usuarioitemconfiguracao_pkey PRIMARY KEY (idusuario, iditemconfiguracao);


--
-- TOC entry 5890 (class 2606 OID 2249641)
-- Dependencies: 469 469 6389
-- Name: valor_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY valor
    ADD CONSTRAINT valor_pkey PRIMARY KEY (idvalor);


--
-- TOC entry 5893 (class 2606 OID 2249656)
-- Dependencies: 471 471 6389
-- Name: valorservicocontrato_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY valorservicocontrato
    ADD CONSTRAINT valorservicocontrato_pkey PRIMARY KEY (idvalorservicocontrato);


--
-- TOC entry 5896 (class 2606 OID 2249670)
-- Dependencies: 472 472 6389
-- Name: valorvisaocamposnegocio_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY valorvisaocamposnegocio
    ADD CONSTRAINT valorvisaocamposnegocio_pkey PRIMARY KEY (idvalorvisaocamposnegocio);


--
-- TOC entry 5898 (class 2606 OID 2249678)
-- Dependencies: 473 473 6389
-- Name: versao_nomeversao_key; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY versao
    ADD CONSTRAINT versao_nomeversao_key UNIQUE (nomeversao);


--
-- TOC entry 5900 (class 2606 OID 2249676)
-- Dependencies: 473 473 6389
-- Name: versao_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY versao
    ADD CONSTRAINT versao_pkey PRIMARY KEY (idversao);


--
-- TOC entry 5902 (class 2606 OID 2249683)
-- Dependencies: 474 474 474 6389
-- Name: vinculaosincidente_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY vinculaosincidente
    ADD CONSTRAINT vinculaosincidente_pkey PRIMARY KEY (idos, idsolicitacaoservico);


--
-- TOC entry 5907 (class 2606 OID 2249688)
-- Dependencies: 475 475 475 6389
-- Name: vinculovisao_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY vinculovisao
    ADD CONSTRAINT vinculovisao_pkey PRIMARY KEY (idvisaorelacionada, seq);


--
-- TOC entry 5909 (class 2606 OID 2249701)
-- Dependencies: 476 476 6389
-- Name: visao_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY visao
    ADD CONSTRAINT visao_pkey PRIMARY KEY (idvisao);


--
-- TOC entry 5914 (class 2606 OID 2249710)
-- Dependencies: 477 477 6389
-- Name: visaorelacionada_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY visaorelacionada
    ADD CONSTRAINT visaorelacionada_pkey PRIMARY KEY (idvisaorelacionada);


--
-- TOC entry 4846 (class 1259 OID 2245994)
-- Dependencies: 161 6389
-- Name: acaoplanomelhoria_idobjetivoplanomelhoria_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX acaoplanomelhoria_idobjetivoplanomelhoria_idx ON acaoplanomelhoria USING btree (idobjetivoplanomelhoria);


--
-- TOC entry 4847 (class 1259 OID 2245995)
-- Dependencies: 161 6389
-- Name: acaoplanomelhoria_idplanomelhoria_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX acaoplanomelhoria_idplanomelhoria_idx ON acaoplanomelhoria USING btree (idplanomelhoria);


--
-- TOC entry 4855 (class 1259 OID 2246044)
-- Dependencies: 163 6389
-- Name: acordonivelservico_hist_idprioridadepadrao_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX acordonivelservico_hist_idprioridadepadrao_idx ON acordonivelservico_hist USING btree (idprioridadepadrao);


--
-- TOC entry 4856 (class 1259 OID 2246045)
-- Dependencies: 163 6389
-- Name: acordonivelservico_hist_idservicocontrato_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX acordonivelservico_hist_idservicocontrato_idx ON acordonivelservico_hist USING btree (idservicocontrato);


--
-- TOC entry 4850 (class 1259 OID 2246021)
-- Dependencies: 162 6389
-- Name: acordonivelservico_idformula_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX acordonivelservico_idformula_idx ON acordonivelservico USING btree (idformula);


--
-- TOC entry 4851 (class 1259 OID 2246019)
-- Dependencies: 162 6389
-- Name: acordonivelservico_idprioridadepadrao_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX acordonivelservico_idprioridadepadrao_idx ON acordonivelservico USING btree (idprioridadepadrao);


--
-- TOC entry 4852 (class 1259 OID 2246020)
-- Dependencies: 162 6389
-- Name: acordonivelservico_idservicocontrato_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX acordonivelservico_idservicocontrato_idx ON acordonivelservico USING btree (idservicocontrato);


--
-- TOC entry 4859 (class 1259 OID 2246056)
-- Dependencies: 164 6389
-- Name: acordonivelservicocontrato_idcontrato_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX acordonivelservicocontrato_idcontrato_idx ON acordonivelservicocontrato USING btree (idcontrato);


--
-- TOC entry 4860 (class 1259 OID 2246057)
-- Dependencies: 164 6389
-- Name: acordonivelservicocontrato_idformula_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX acordonivelservicocontrato_idformula_idx ON acordonivelservicocontrato USING btree (idformula);


--
-- TOC entry 4863 (class 1259 OID 2246064)
-- Dependencies: 165 6389
-- Name: acordoservicocontrato_idacordonivelservico_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX acordoservicocontrato_idacordonivelservico_idx ON acordoservicocontrato USING btree (idacordonivelservico);


--
-- TOC entry 4864 (class 1259 OID 2246066)
-- Dependencies: 165 6389
-- Name: acordoservicocontrato_idrecurso_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX acordoservicocontrato_idrecurso_idx ON acordoservicocontrato USING btree (idrecurso);


--
-- TOC entry 4865 (class 1259 OID 2246065)
-- Dependencies: 165 6389
-- Name: acordoservicocontrato_idservicocontrato_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX acordoservicocontrato_idservicocontrato_idx ON acordoservicocontrato USING btree (idservicocontrato);


--
-- TOC entry 4870 (class 1259 OID 2246085)
-- Dependencies: 167 6389
-- Name: alcadacentroresultado_idalcada_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX alcadacentroresultado_idalcada_idx ON alcadacentroresultado USING btree (idalcada);


--
-- TOC entry 4871 (class 1259 OID 2246083)
-- Dependencies: 167 6389
-- Name: alcadacentroresultado_idcentroresultado_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX alcadacentroresultado_idcentroresultado_idx ON alcadacentroresultado USING btree (idcentroresultado);


--
-- TOC entry 4872 (class 1259 OID 2246084)
-- Dependencies: 167 6389
-- Name: alcadacentroresultado_idempregado_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX alcadacentroresultado_idempregado_idx ON alcadacentroresultado USING btree (idempregado);


--
-- TOC entry 4875 (class 1259 OID 2246099)
-- Dependencies: 168 6389
-- Name: anexo_idexecucaoatividade_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX anexo_idexecucaoatividade_idx ON anexo USING btree (idexecucaoatividade);


--
-- TOC entry 4878 (class 1259 OID 2246108)
-- Dependencies: 169 6389
-- Name: anexobaseconhecimento_idbaseconhecimento_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX anexobaseconhecimento_idbaseconhecimento_idx ON anexobaseconhecimento USING btree (idbaseconhecimento);


--
-- TOC entry 4885 (class 1259 OID 2246139)
-- Dependencies: 172 6389
-- Name: aprovacaomudanca_idempregado_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX aprovacaomudanca_idempregado_idx ON aprovacaomudanca USING btree (idempregado);


--
-- TOC entry 4886 (class 1259 OID 2246138)
-- Dependencies: 172 6389
-- Name: aprovacaomudanca_idrequisicaomudanca_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX aprovacaomudanca_idrequisicaomudanca_idx ON aprovacaomudanca USING btree (idrequisicaomudanca);


--
-- TOC entry 4889 (class 1259 OID 2246150)
-- Dependencies: 173 6389
-- Name: aprovacaosolicitacaoservico_idjustificativa_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX aprovacaosolicitacaoservico_idjustificativa_idx ON aprovacaosolicitacaoservico USING btree (idjustificativa);


--
-- TOC entry 4890 (class 1259 OID 2246151)
-- Dependencies: 173 6389
-- Name: aprovacaosolicitacaoservico_idresponsavel_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX aprovacaosolicitacaoservico_idresponsavel_idx ON aprovacaosolicitacaoservico USING btree (idresponsavel);


--
-- TOC entry 4891 (class 1259 OID 2246149)
-- Dependencies: 173 6389
-- Name: aprovacaosolicitacaoservico_idsolicitacaoservico_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX aprovacaosolicitacaoservico_idsolicitacaoservico_idx ON aprovacaosolicitacaoservico USING btree (idsolicitacaoservico);


--
-- TOC entry 4892 (class 1259 OID 2246148)
-- Dependencies: 173 6389
-- Name: aprovacaosolicitacaoservico_idtarefa_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX aprovacaosolicitacaoservico_idtarefa_idx ON aprovacaosolicitacaoservico USING btree (idtarefa);


--
-- TOC entry 4895 (class 1259 OID 2246158)
-- Dependencies: 174 6389
-- Name: apuracaovaloresrecurso_idrecurso_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX apuracaovaloresrecurso_idrecurso_idx ON apuracaovaloresrecurso USING btree (idrecurso);


--
-- TOC entry 4898 (class 1259 OID 2246172)
-- Dependencies: 175 6389
-- Name: atividadeperiodica_idrequisicaomudanca_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX atividadeperiodica_idrequisicaomudanca_idx ON atividadeperiodica USING btree (idrequisicaomudanca);


--
-- TOC entry 4899 (class 1259 OID 2246171)
-- Dependencies: 175 6389
-- Name: atividadeperiodica_idsolicitacaoservico_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX atividadeperiodica_idsolicitacaoservico_idx ON atividadeperiodica USING btree (idsolicitacaoservico);


--
-- TOC entry 4902 (class 1259 OID 2246181)
-- Dependencies: 176 6389
-- Name: atividades_idatividadeproxima_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX atividades_idatividadeproxima_idx ON atividades USING btree (idatividadeproxima);


--
-- TOC entry 4903 (class 1259 OID 2246179)
-- Dependencies: 176 6389
-- Name: atividades_idetapa_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX atividades_idetapa_idx ON atividades USING btree (idetapa);


--
-- TOC entry 4904 (class 1259 OID 2246180)
-- Dependencies: 176 6389
-- Name: atividades_idtipoatividade_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX atividades_idtipoatividade_idx ON atividades USING btree (idtipoatividade);


--
-- TOC entry 4907 (class 1259 OID 2246187)
-- Dependencies: 177 6389
-- Name: atividadesfluxos_idfluxo_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX atividadesfluxos_idfluxo_idx ON atividadesfluxos USING btree (idfluxo);


--
-- TOC entry 4910 (class 1259 OID 2246203)
-- Dependencies: 178 6389
-- Name: atividadesos_idatividadeservicocontrato_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX atividadesos_idatividadeservicocontrato_idx ON atividadesos USING btree (idatividadeservicocontrato);


--
-- TOC entry 4911 (class 1259 OID 2246202)
-- Dependencies: 178 6389
-- Name: atividadesos_idos_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX atividadesos_idos_idx ON atividadesos USING btree (idos);


--
-- TOC entry 4914 (class 1259 OID 2246219)
-- Dependencies: 179 6389
-- Name: atividadesservicocontrato_idservicocontrato_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX atividadesservicocontrato_idservicocontrato_idx ON atividadesservicocontrato USING btree (idservicocontrato);


--
-- TOC entry 4917 (class 1259 OID 2246229)
-- Dependencies: 180 6389
-- Name: auditoria_iditemconfiguracao_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX auditoria_iditemconfiguracao_idx ON auditoria USING btree (iditemconfiguracao);


--
-- TOC entry 4918 (class 1259 OID 2246230)
-- Dependencies: 180 6389
-- Name: auditoria_idusuario_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX auditoria_idusuario_idx ON auditoria USING btree (idusuario);


--
-- TOC entry 4921 (class 1259 OID 2246241)
-- Dependencies: 181 6389
-- Name: auditoriaitemconfiguracao_idempregado_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX auditoriaitemconfiguracao_idempregado_idx ON auditoriaitemconfiguracao USING btree (idempregado);


--
-- TOC entry 4922 (class 1259 OID 2246240)
-- Dependencies: 181 6389
-- Name: auditoriaitemconfiguracao_iditemconfiguracao_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX auditoriaitemconfiguracao_iditemconfiguracao_idx ON auditoriaitemconfiguracao USING btree (iditemconfiguracao);


--
-- TOC entry 4925 (class 1259 OID 2246246)
-- Dependencies: 182 6389
-- Name: avaliacaocoletapreco_idcoletapreco_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX avaliacaocoletapreco_idcoletapreco_idx ON avaliacaocoletapreco USING btree (idcoletapreco);


--
-- TOC entry 4926 (class 1259 OID 2246245)
-- Dependencies: 182 6389
-- Name: avaliacaocoletapreco_idcriterio_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX avaliacaocoletapreco_idcriterio_idx ON avaliacaocoletapreco USING btree (idcriterio);


--
-- TOC entry 4929 (class 1259 OID 2246262)
-- Dependencies: 184 6389
-- Name: avaliacaofornecedor_idfornecedor_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX avaliacaofornecedor_idfornecedor_idx ON avaliacaofornecedor USING btree (idfornecedor);


--
-- TOC entry 4930 (class 1259 OID 2246263)
-- Dependencies: 184 6389
-- Name: avaliacaofornecedor_idresponsavel_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX avaliacaofornecedor_idresponsavel_idx ON avaliacaofornecedor USING btree (idresponsavel);


--
-- TOC entry 5915 (class 1259 OID 2249732)
-- Dependencies: 478 478 6389
-- Name: avaliacaopedido_1_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX avaliacaopedido_1_idx ON avaliacaopedido USING btree (idcoletapreco, iditemrequisicaoproduto);


--
-- TOC entry 5916 (class 1259 OID 2249730)
-- Dependencies: 478 6389
-- Name: avaliacaopedido_idcriterio_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX avaliacaopedido_idcriterio_idx ON avaliacaopedido USING btree (idcriterio);


--
-- TOC entry 5917 (class 1259 OID 2249731)
-- Dependencies: 478 6389
-- Name: avaliacaopedido_idpedido_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX avaliacaopedido_idpedido_idx ON avaliacaopedido USING btree (idpedido);


--
-- TOC entry 4933 (class 1259 OID 2246275)
-- Dependencies: 185 6389
-- Name: avaliacaoreferenciafornecedor_idempregado_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX avaliacaoreferenciafornecedor_idempregado_idx ON avaliacaoreferenciafornecedor USING btree (idempregado);


--
-- TOC entry 4936 (class 1259 OID 2246300)
-- Dependencies: 186 6389
-- Name: baseconhecimento_idbaseconhecimentopai_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX baseconhecimento_idbaseconhecimentopai_idx ON baseconhecimento USING btree (idbaseconhecimentopai);


--
-- TOC entry 4937 (class 1259 OID 2246302)
-- Dependencies: 186 6389
-- Name: baseconhecimento_idhistoricobaseconhecimento_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX baseconhecimento_idhistoricobaseconhecimento_idx ON baseconhecimento USING btree (idhistoricobaseconhecimento);


--
-- TOC entry 4938 (class 1259 OID 2246301)
-- Dependencies: 186 6389
-- Name: baseconhecimento_idnotificacao_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX baseconhecimento_idnotificacao_idx ON baseconhecimento USING btree (idnotificacao);


--
-- TOC entry 4939 (class 1259 OID 2246299)
-- Dependencies: 186 6389
-- Name: baseconhecimento_idpasta_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX baseconhecimento_idpasta_idx ON baseconhecimento USING btree (idpasta);


--
-- TOC entry 4944 (class 1259 OID 2246318)
-- Dependencies: 188 6389
-- Name: baseitemconfiguracao_idtipoitemconfiguracao_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX baseitemconfiguracao_idtipoitemconfiguracao_idx ON baseitemconfiguracao USING btree (idtipoitemconfiguracao);


--
-- TOC entry 4949 (class 1259 OID 2246337)
-- Dependencies: 190 6389
-- Name: botaoacaovisao_idvisao_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX botaoacaovisao_idvisao_idx ON botaoacaovisao USING btree (idvisao);


--
-- TOC entry 4952 (class 1259 OID 2246349)
-- Dependencies: 191 6389
-- Name: bpm_atribuicaofluxo_idgrupo_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX bpm_atribuicaofluxo_idgrupo_idx ON bpm_atribuicaofluxo USING btree (idgrupo);


--
-- TOC entry 4953 (class 1259 OID 2246347)
-- Dependencies: 191 6389
-- Name: bpm_atribuicaofluxo_iditemtrabalho_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX bpm_atribuicaofluxo_iditemtrabalho_idx ON bpm_atribuicaofluxo USING btree (iditemtrabalho);


--
-- TOC entry 4954 (class 1259 OID 2246348)
-- Dependencies: 191 6389
-- Name: bpm_atribuicaofluxo_idusuario_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX bpm_atribuicaofluxo_idusuario_idx ON bpm_atribuicaofluxo USING btree (idusuario);


--
-- TOC entry 4957 (class 1259 OID 2246368)
-- Dependencies: 192 6389
-- Name: bpm_elementofluxo_idfluxo_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX bpm_elementofluxo_idfluxo_idx ON bpm_elementofluxo USING btree (idfluxo);


--
-- TOC entry 4960 (class 1259 OID 2246380)
-- Dependencies: 193 6389
-- Name: bpm_fluxo_idtipofluxo_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX bpm_fluxo_idtipofluxo_idx ON bpm_fluxo USING btree (idtipofluxo);


--
-- TOC entry 4963 (class 1259 OID 2246392)
-- Dependencies: 194 6389
-- Name: bpm_historicoitemtrabalho_idgrupo_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX bpm_historicoitemtrabalho_idgrupo_idx ON bpm_historicoitemtrabalho USING btree (idgrupo);


--
-- TOC entry 4964 (class 1259 OID 2246389)
-- Dependencies: 194 6389
-- Name: bpm_historicoitemtrabalho_iditemtrabalho_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX bpm_historicoitemtrabalho_iditemtrabalho_idx ON bpm_historicoitemtrabalho USING btree (iditemtrabalho);


--
-- TOC entry 4965 (class 1259 OID 2246390)
-- Dependencies: 194 6389
-- Name: bpm_historicoitemtrabalho_idresponsavel_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX bpm_historicoitemtrabalho_idresponsavel_idx ON bpm_historicoitemtrabalho USING btree (idresponsavel);


--
-- TOC entry 4966 (class 1259 OID 2246391)
-- Dependencies: 194 6389
-- Name: bpm_historicoitemtrabalho_idusuario_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX bpm_historicoitemtrabalho_idusuario_idx ON bpm_historicoitemtrabalho USING btree (idusuario);


--
-- TOC entry 4969 (class 1259 OID 2246402)
-- Dependencies: 195 6389
-- Name: bpm_instanciafluxo_idfluxo_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX bpm_instanciafluxo_idfluxo_idx ON bpm_instanciafluxo USING btree (idfluxo);


--
-- TOC entry 4972 (class 1259 OID 2246413)
-- Dependencies: 196 6389
-- Name: bpm_itemtrabalhofluxo_idelemento_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX bpm_itemtrabalhofluxo_idelemento_idx ON bpm_itemtrabalhofluxo USING btree (idelemento);


--
-- TOC entry 4973 (class 1259 OID 2246411)
-- Dependencies: 196 6389
-- Name: bpm_itemtrabalhofluxo_idinstancia_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX bpm_itemtrabalhofluxo_idinstancia_idx ON bpm_itemtrabalhofluxo USING btree (idinstancia);


--
-- TOC entry 4974 (class 1259 OID 2246412)
-- Dependencies: 196 6389
-- Name: bpm_itemtrabalhofluxo_idresponsavelatual_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX bpm_itemtrabalhofluxo_idresponsavelatual_idx ON bpm_itemtrabalhofluxo USING btree (idresponsavelatual);


--
-- TOC entry 4977 (class 1259 OID 2246429)
-- Dependencies: 197 6389
-- Name: bpm_objetoinstanciafluxo_idinstancia_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX bpm_objetoinstanciafluxo_idinstancia_idx ON bpm_objetoinstanciafluxo USING btree (idinstancia);


--
-- TOC entry 4978 (class 1259 OID 2246428)
-- Dependencies: 197 6389
-- Name: bpm_objetoinstanciafluxo_iditemtrabalho_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX bpm_objetoinstanciafluxo_iditemtrabalho_idx ON bpm_objetoinstanciafluxo USING btree (iditemtrabalho);


--
-- TOC entry 4979 (class 1259 OID 2246427)
-- Dependencies: 197 6389
-- Name: bpm_objetoinstanciafluxo_idobjetonegocio_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX bpm_objetoinstanciafluxo_idobjetonegocio_idx ON bpm_objetoinstanciafluxo USING btree (idobjetonegocio);


--
-- TOC entry 4982 (class 1259 OID 2246442)
-- Dependencies: 198 6389
-- Name: bpm_sequenciafluxo_idelementodestino_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX bpm_sequenciafluxo_idelementodestino_idx ON bpm_sequenciafluxo USING btree (idelementodestino);


--
-- TOC entry 4983 (class 1259 OID 2246443)
-- Dependencies: 198 6389
-- Name: bpm_sequenciafluxo_idfluxo_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX bpm_sequenciafluxo_idfluxo_idx ON bpm_sequenciafluxo USING btree (idfluxo);


--
-- TOC entry 4990 (class 1259 OID 2246467)
-- Dependencies: 201 6389
-- Name: campoobjrelacionado_idcamposobjetonegociofilho_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX campoobjrelacionado_idcamposobjetonegociofilho_idx ON campoobjrelacionado USING btree (idcamposobjetonegociofilho);


--
-- TOC entry 4991 (class 1259 OID 2246466)
-- Dependencies: 201 6389
-- Name: campoobjrelacionado_idcamposobjetonegociopai_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX campoobjrelacionado_idcamposobjetonegociopai_idx ON campoobjrelacionado USING btree (idcamposobjetonegociopai);


--
-- TOC entry 4992 (class 1259 OID 2246465)
-- Dependencies: 201 6389
-- Name: campoobjrelacionado_idrelacobjetonegocio_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX campoobjrelacionado_idrelacobjetonegocio_idx ON campoobjrelacionado USING btree (idrelacobjetonegocio);


--
-- TOC entry 4995 (class 1259 OID 2246474)
-- Dependencies: 202 6389
-- Name: camposobjetonegocio_idobjetonegocio_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX camposobjetonegocio_idobjetonegocio_idx ON camposobjetonegocio USING btree (idobjetonegocio);


--
-- TOC entry 4998 (class 1259 OID 2246487)
-- Dependencies: 203 6389
-- Name: caracteristica_idempresa_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX caracteristica_idempresa_idx ON caracteristica USING btree (idempresa);


--
-- TOC entry 4999 (class 1259 OID 2246488)
-- Dependencies: 203 6389
-- Name: caracteristica_nomecaracteristica_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX caracteristica_nomecaracteristica_idx ON caracteristica USING btree (nomecaracteristica);


--
-- TOC entry 5004 (class 1259 OID 2246505)
-- Dependencies: 205 6389
-- Name: catalogoservico_idcontrato_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX catalogoservico_idcontrato_idx ON catalogoservico USING btree (idcontrato);


--
-- TOC entry 5009 (class 1259 OID 2246523)
-- Dependencies: 207 6389
-- Name: categoriamudanca_idcalendario_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX categoriamudanca_idcalendario_idx ON categoriamudanca USING btree (idcalendario);


--
-- TOC entry 5010 (class 1259 OID 2246522)
-- Dependencies: 207 6389
-- Name: categoriamudanca_idgrupoexecutor_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX categoriamudanca_idgrupoexecutor_idx ON categoriamudanca USING btree (idgrupoexecutor);


--
-- TOC entry 5011 (class 1259 OID 2246521)
-- Dependencies: 207 6389
-- Name: categoriamudanca_idgruponivel1_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX categoriamudanca_idgruponivel1_idx ON categoriamudanca USING btree (idgruponivel1);


--
-- TOC entry 5012 (class 1259 OID 2246520)
-- Dependencies: 207 6389
-- Name: categoriamudanca_idmodeloemailacoes_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX categoriamudanca_idmodeloemailacoes_idx ON categoriamudanca USING btree (idmodeloemailacoes);


--
-- TOC entry 5013 (class 1259 OID 2246518)
-- Dependencies: 207 6389
-- Name: categoriamudanca_idmodeloemailcriacao_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX categoriamudanca_idmodeloemailcriacao_idx ON categoriamudanca USING btree (idmodeloemailcriacao);


--
-- TOC entry 5014 (class 1259 OID 2246519)
-- Dependencies: 207 6389
-- Name: categoriamudanca_idmodeloemailfinalizacao_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX categoriamudanca_idmodeloemailfinalizacao_idx ON categoriamudanca USING btree (idmodeloemailfinalizacao);


--
-- TOC entry 5015 (class 1259 OID 2246517)
-- Dependencies: 207 6389
-- Name: categoriamudanca_idtipofluxo_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX categoriamudanca_idtipofluxo_idx ON categoriamudanca USING btree (idtipofluxo);


--
-- TOC entry 5022 (class 1259 OID 2246550)
-- Dependencies: 210 6389
-- Name: categoriaproblema_cat_idcategoriaproblema_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX categoriaproblema_cat_idcategoriaproblema_idx ON categoriaproblema USING btree (cat_idcategoriaproblema);


--
-- TOC entry 5025 (class 1259 OID 2246556)
-- Dependencies: 211 6389
-- Name: categoriaproduto_idcategoriapai_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX categoriaproduto_idcategoriapai_idx ON categoriaproduto USING btree (idcategoriapai);


--
-- TOC entry 5030 (class 1259 OID 2246579)
-- Dependencies: 213 6389
-- Name: categoriaservico_idcategoriaservicopai_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX categoriaservico_idcategoriaservicopai_idx ON categoriaservico USING btree (idcategoriaservicopai);


--
-- TOC entry 5031 (class 1259 OID 2246580)
-- Dependencies: 213 6389
-- Name: categoriaservico_idempresa_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX categoriaservico_idempresa_idx ON categoriaservico USING btree (idempresa);


--
-- TOC entry 5032 (class 1259 OID 2246581)
-- Dependencies: 213 6389
-- Name: categoriaservico_nomecategoriaservicoconcatenado_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX categoriaservico_nomecategoriaservicoconcatenado_idx ON categoriaservico USING btree (nomecategoriaservicoconcatenado);


--
-- TOC entry 5035 (class 1259 OID 2246588)
-- Dependencies: 214 6389
-- Name: categoriasolucao_idcategoriasolucaopai_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX categoriasolucao_idcategoriasolucaopai_idx ON categoriasolucao USING btree (idcategoriasolucaopai);


--
-- TOC entry 5038 (class 1259 OID 2246595)
-- Dependencies: 215 6389
-- Name: causaincidente_idcausaincidentepai_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX causaincidente_idcausaincidentepai_idx ON causaincidente USING btree (idcausaincidentepai);


--
-- TOC entry 5043 (class 1259 OID 2246607)
-- Dependencies: 217 6389
-- Name: cidades_iduf_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX cidades_iduf_idx ON cidades USING btree (iduf);


--
-- TOC entry 5048 (class 1259 OID 2246625)
-- Dependencies: 219 6389
-- Name: colecao_idteste_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX colecao_idteste_idx ON colecao USING btree (idteste);


--
-- TOC entry 5051 (class 1259 OID 2246643)
-- Dependencies: 220 6389
-- Name: coletapreco_idfornecedor_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX coletapreco_idfornecedor_idx ON coletapreco USING btree (idfornecedor);


--
-- TOC entry 5052 (class 1259 OID 2246641)
-- Dependencies: 220 6389
-- Name: coletapreco_iditemcotacao_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX coletapreco_iditemcotacao_idx ON coletapreco USING btree (iditemcotacao);


--
-- TOC entry 5053 (class 1259 OID 2246645)
-- Dependencies: 220 6389
-- Name: coletapreco_idjustifresultado_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX coletapreco_idjustifresultado_idx ON coletapreco USING btree (idjustifresultado);


--
-- TOC entry 5054 (class 1259 OID 2246642)
-- Dependencies: 220 6389
-- Name: coletapreco_idresponsavel_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX coletapreco_idresponsavel_idx ON coletapreco USING btree (idresponsavel);


--
-- TOC entry 5055 (class 1259 OID 2246644)
-- Dependencies: 220 6389
-- Name: coletapreco_idrespresultado_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX coletapreco_idrespresultado_idx ON coletapreco USING btree (idrespresultado);


--
-- TOC entry 5060 (class 1259 OID 2246662)
-- Dependencies: 222 6389
-- Name: comandosistemaoperacional_idcomando_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX comandosistemaoperacional_idcomando_idx ON comandosistemaoperacional USING btree (idcomando);


--
-- TOC entry 5061 (class 1259 OID 2246661)
-- Dependencies: 222 6389
-- Name: comandosistemaoperacional_idsistemaoperacional_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX comandosistemaoperacional_idsistemaoperacional_idx ON comandosistemaoperacional USING btree (idsistemaoperacional);


--
-- TOC entry 5064 (class 1259 OID 2246671)
-- Dependencies: 223 6389
-- Name: comentarios_idbaseconhecimento_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX comentarios_idbaseconhecimento_idx ON comentarios USING btree (idbaseconhecimento);


--
-- TOC entry 5069 (class 1259 OID 2246685)
-- Dependencies: 225 6389
-- Name: condicaooperacao_idempresa_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX condicaooperacao_idempresa_idx ON condicaooperacao USING btree (idempresa);


--
-- TOC entry 5072 (class 1259 OID 2246691)
-- Dependencies: 226 6389
-- Name: conhecimentoic_idbaseconhecimento_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX conhecimentoic_idbaseconhecimento_idx ON conhecimentoic USING btree (idbaseconhecimento);


--
-- TOC entry 5075 (class 1259 OID 2246702)
-- Dependencies: 227 6389
-- Name: conhecimentomudanca_idbaseconhecimento_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX conhecimentomudanca_idbaseconhecimento_idx ON conhecimentomudanca USING btree (idbaseconhecimento);


--
-- TOC entry 5078 (class 1259 OID 2246713)
-- Dependencies: 228 6389
-- Name: conhecimentoproblema_idbaseconhecimento_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX conhecimentoproblema_idbaseconhecimento_idx ON conhecimentoproblema USING btree (idbaseconhecimento);


--
-- TOC entry 5081 (class 1259 OID 2246724)
-- Dependencies: 229 6389
-- Name: conhecimentosolicitacaoservico_idbaseconhecimento_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX conhecimentosolicitacaoservico_idbaseconhecimento_idx ON conhecimentosolicitacaoservico USING btree (idbaseconhecimento);


--
-- TOC entry 5084 (class 1259 OID 2246736)
-- Dependencies: 230 6389
-- Name: contadoracesso_idusuario_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX contadoracesso_idusuario_idx ON contadoracesso USING btree (idusuario);


--
-- TOC entry 5087 (class 1259 OID 2246748)
-- Dependencies: 231 6389
-- Name: contatocliente_idcliente_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX contatocliente_idcliente_idx ON contatocliente USING btree (idcliente);


--
-- TOC entry 5092 (class 1259 OID 2246771)
-- Dependencies: 233 6389
-- Name: contatosolicitacaoservico_idlocalidade_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX contatosolicitacaoservico_idlocalidade_idx ON contatosolicitacaoservico USING btree (idlocalidade);


--
-- TOC entry 5095 (class 1259 OID 2246785)
-- Dependencies: 234 6389
-- Name: contratoquestionarios_idcontrato_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX contratoquestionarios_idcontrato_idx ON contratoquestionarios USING btree (idcontrato);


--
-- TOC entry 5096 (class 1259 OID 2246787)
-- Dependencies: 234 6389
-- Name: contratoquestionarios_idempresa_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX contratoquestionarios_idempresa_idx ON contratoquestionarios USING btree (idempresa);


--
-- TOC entry 5097 (class 1259 OID 2246788)
-- Dependencies: 234 6389
-- Name: contratoquestionarios_idmigracao_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX contratoquestionarios_idmigracao_idx ON contratoquestionarios USING btree (idmigracao);


--
-- TOC entry 5098 (class 1259 OID 2246786)
-- Dependencies: 234 6389
-- Name: contratoquestionarios_idprofissional_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX contratoquestionarios_idprofissional_idx ON contratoquestionarios USING btree (idprofissional);


--
-- TOC entry 5099 (class 1259 OID 2246784)
-- Dependencies: 234 6389
-- Name: contratoquestionarios_idquestionario_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX contratoquestionarios_idquestionario_idx ON contratoquestionarios USING btree (idquestionario);


--
-- TOC entry 5107 (class 1259 OID 2246825)
-- Dependencies: 236 6389
-- Name: contratos_hist_idcliente_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX contratos_hist_idcliente_idx ON contratos_hist USING btree (idcliente);


--
-- TOC entry 5108 (class 1259 OID 2246826)
-- Dependencies: 236 6389
-- Name: contratos_hist_idfornecedor_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX contratos_hist_idfornecedor_idx ON contratos_hist USING btree (idfornecedor);


--
-- TOC entry 5109 (class 1259 OID 2246824)
-- Dependencies: 236 6389
-- Name: contratos_hist_idmoeda_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX contratos_hist_idmoeda_idx ON contratos_hist USING btree (idmoeda);


--
-- TOC entry 5102 (class 1259 OID 2246803)
-- Dependencies: 235 6389
-- Name: contratos_idcliente_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX contratos_idcliente_idx ON contratos USING btree (idcliente);


--
-- TOC entry 5103 (class 1259 OID 2246804)
-- Dependencies: 235 6389
-- Name: contratos_idfornecedor_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX contratos_idfornecedor_idx ON contratos USING btree (idfornecedor);


--
-- TOC entry 5104 (class 1259 OID 2246802)
-- Dependencies: 235 6389
-- Name: contratos_idmoeda_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX contratos_idmoeda_idx ON contratos USING btree (idmoeda);


--
-- TOC entry 5112 (class 1259 OID 2246832)
-- Dependencies: 237 6389
-- Name: contratoscolaboradores_idcontrato_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX contratoscolaboradores_idcontrato_idx ON contratoscolaboradores USING btree (idcontrato);


--
-- TOC entry 5123 (class 1259 OID 2246878)
-- Dependencies: 242 6389
-- Name: cotacao_idempresa_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX cotacao_idempresa_idx ON cotacao USING btree (idempresa);


--
-- TOC entry 5126 (class 1259 OID 2246886)
-- Dependencies: 243 6389
-- Name: cotacaoitemrequisicao_idcotacao_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX cotacaoitemrequisicao_idcotacao_idx ON cotacaoitemrequisicao USING btree (idcotacao);


--
-- TOC entry 5127 (class 1259 OID 2246887)
-- Dependencies: 243 6389
-- Name: cotacaoitemrequisicao_iditemrequisicaoproduto_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX cotacaoitemrequisicao_iditemrequisicaoproduto_idx ON cotacaoitemrequisicao USING btree (iditemrequisicaoproduto);


--
-- TOC entry 5128 (class 1259 OID 2246891)
-- Dependencies: 243 6389
-- Name: cotacaoitemrequisicao_iditemtrabalhoaprovacao_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX cotacaoitemrequisicao_iditemtrabalhoaprovacao_idx ON cotacaoitemrequisicao USING btree (iditemtrabalhoaprovacao);


--
-- TOC entry 5129 (class 1259 OID 2246890)
-- Dependencies: 243 6389
-- Name: cotacaoitemrequisicao_iditemtrabalhoinspecao_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX cotacaoitemrequisicao_iditemtrabalhoinspecao_idx ON cotacaoitemrequisicao USING btree (iditemtrabalhoinspecao);


--
-- TOC entry 5130 (class 1259 OID 2246888)
-- Dependencies: 243 6389
-- Name: cotacaoitemrequisicao_idparecer_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX cotacaoitemrequisicao_idparecer_idx ON cotacaoitemrequisicao USING btree (idparecer);


--
-- TOC entry 5131 (class 1259 OID 2246889)
-- Dependencies: 243 6389
-- Name: cotacaoitemrequisicao_idsolicitacaoservico_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX cotacaoitemrequisicao_idsolicitacaoservico_idx ON cotacaoitemrequisicao USING btree (idsolicitacaoservico);


--
-- TOC entry 5136 (class 1259 OID 2246937)
-- Dependencies: 245 6389
-- Name: criterioavaliacaofornecedor_idcriterio_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX criterioavaliacaofornecedor_idcriterio_idx ON criterioavaliacaofornecedor USING btree (idcriterio);


--
-- TOC entry 5139 (class 1259 OID 2246953)
-- Dependencies: 246 6389
-- Name: criteriocotacao_idcriterio_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX criteriocotacao_idcriterio_idx ON criteriocotacao USING btree (idcriterio);


--
-- TOC entry 5142 (class 1259 OID 2246969)
-- Dependencies: 247 6389
-- Name: criteriocotacaocategoria_idcriterio_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX criteriocotacaocategoria_idcriterio_idx ON criteriocotacaocategoria USING btree (idcriterio);


--
-- TOC entry 5145 (class 1259 OID 2246985)
-- Dependencies: 248 6389
-- Name: criterioitemcotacao_iditemcotacao_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX criterioitemcotacao_iditemcotacao_idx ON criterioitemcotacao USING btree (iditemcotacao);


--
-- TOC entry 5148 (class 1259 OID 2246996)
-- Dependencies: 249 6389
-- Name: demandas_idcontrato_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX demandas_idcontrato_idx ON demandas USING btree (idcontrato);


--
-- TOC entry 5149 (class 1259 OID 2247000)
-- Dependencies: 249 6389
-- Name: demandas_iddemandapai_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX demandas_iddemandapai_idx ON demandas USING btree (iddemandapai);


--
-- TOC entry 5150 (class 1259 OID 2247001)
-- Dependencies: 249 6389
-- Name: demandas_idfluxo_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX demandas_idfluxo_idx ON demandas USING btree (idfluxo);


--
-- TOC entry 5151 (class 1259 OID 2246999)
-- Dependencies: 249 6389
-- Name: demandas_idprojeto_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX demandas_idprojeto_idx ON demandas USING btree (idprojeto);


--
-- TOC entry 5152 (class 1259 OID 2246997)
-- Dependencies: 249 6389
-- Name: demandas_idsituacaodemanda_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX demandas_idsituacaodemanda_idx ON demandas USING btree (idsituacaodemanda);


--
-- TOC entry 5153 (class 1259 OID 2246998)
-- Dependencies: 249 6389
-- Name: demandas_idtipodemanda_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX demandas_idtipodemanda_idx ON demandas USING btree (idtipodemanda);


--
-- TOC entry 5156 (class 1259 OID 2247009)
-- Dependencies: 250 6389
-- Name: dicionario_idlingua_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX dicionario_idlingua_idx ON dicionario USING btree (idlingua);


--
-- TOC entry 5157 (class 1259 OID 2247010)
-- Dependencies: 250 6389
-- Name: dicionario_nome_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX dicionario_nome_idx ON dicionario USING btree (nome);


--
-- TOC entry 5160 (class 1259 OID 2247011)
-- Dependencies: 250 6389
-- Name: dicionario_valor_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX dicionario_valor_idx ON dicionario USING btree (valor);


--
-- TOC entry 5163 (class 1259 OID 2247026)
-- Dependencies: 252 6389
-- Name: empregadoitemconfiguracao_idempregado_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX empregadoitemconfiguracao_idempregado_idx ON empregadoitemconfiguracao USING btree (idempregado);


--
-- TOC entry 5164 (class 1259 OID 2247025)
-- Dependencies: 252 6389
-- Name: empregadoitemconfiguracao_iditemconfiguracao_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX empregadoitemconfiguracao_iditemconfiguracao_idx ON empregadoitemconfiguracao USING btree (iditemconfiguracao);


--
-- TOC entry 5167 (class 1259 OID 2247056)
-- Dependencies: 253 6389
-- Name: empregados_idcargo_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX empregados_idcargo_idx ON empregados USING btree (idcargo);


--
-- TOC entry 5168 (class 1259 OID 2247055)
-- Dependencies: 253 6389
-- Name: empregados_idunidade_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX empregados_idunidade_idx ON empregados USING btree (idunidade);


--
-- TOC entry 5920 (class 1259 OID 2249765)
-- Dependencies: 479 479 6389
-- Name: entregaitemrequisicao_1_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX entregaitemrequisicao_1_idx ON entregaitemrequisicao USING btree (idcoletapreco, iditemrequisicaoproduto);


--
-- TOC entry 5921 (class 1259 OID 2249767)
-- Dependencies: 479 6389
-- Name: entregaitemrequisicao_iditemtrabalho_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX entregaitemrequisicao_iditemtrabalho_idx ON entregaitemrequisicao USING btree (iditemtrabalho);


--
-- TOC entry 5922 (class 1259 OID 2249768)
-- Dependencies: 479 6389
-- Name: entregaitemrequisicao_idparecer_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX entregaitemrequisicao_idparecer_idx ON entregaitemrequisicao USING btree (idparecer);


--
-- TOC entry 5923 (class 1259 OID 2249764)
-- Dependencies: 479 6389
-- Name: entregaitemrequisicao_idpedido_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX entregaitemrequisicao_idpedido_idx ON entregaitemrequisicao USING btree (idpedido);


--
-- TOC entry 5924 (class 1259 OID 2249766)
-- Dependencies: 479 6389
-- Name: entregaitemrequisicao_idsolicitacaoservico_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX entregaitemrequisicao_idsolicitacaoservico_idx ON entregaitemrequisicao USING btree (idsolicitacaoservico);


--
-- TOC entry 5175 (class 1259 OID 2247085)
-- Dependencies: 256 6389
-- Name: etapas_idetapapai_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX etapas_idetapapai_idx ON etapas USING btree (idetapapai);


--
-- TOC entry 5176 (class 1259 OID 2247084)
-- Dependencies: 256 6389
-- Name: etapas_idfluxo_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX etapas_idfluxo_idx ON etapas USING btree (idfluxo);


--
-- TOC entry 5179 (class 1259 OID 2247096)
-- Dependencies: 257 6389
-- Name: evento_idempresa_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX evento_idempresa_idx ON evento USING btree (idempresa);


--
-- TOC entry 5182 (class 1259 OID 2247102)
-- Dependencies: 258 6389
-- Name: eventoempregado_idempregado_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX eventoempregado_idempregado_idx ON eventoempregado USING btree (idempregado);


--
-- TOC entry 5183 (class 1259 OID 2247103)
-- Dependencies: 258 6389
-- Name: eventoempregado_idgrupo_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX eventoempregado_idgrupo_idx ON eventoempregado USING btree (idgrupo);


--
-- TOC entry 5184 (class 1259 OID 2247104)
-- Dependencies: 258 6389
-- Name: eventoempregado_idunidade_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX eventoempregado_idunidade_idx ON eventoempregado USING btree (idunidade);


--
-- TOC entry 5187 (class 1259 OID 2247115)
-- Dependencies: 260 6389
-- Name: eventoitemconfiguracao_iditemconfiguracao_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX eventoitemconfiguracao_iditemconfiguracao_idx ON eventoitemconfiguracao USING btree (iditemconfiguracao);


--
-- TOC entry 5194 (class 1259 OID 2247139)
-- Dependencies: 264 6389
-- Name: excecaocalendario_idcalendario_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX excecaocalendario_idcalendario_idx ON excecaocalendario USING btree (idcalendario);


--
-- TOC entry 5195 (class 1259 OID 2247140)
-- Dependencies: 264 6389
-- Name: excecaocalendario_idjornada_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX excecaocalendario_idjornada_idx ON excecaocalendario USING btree (idjornada);


--
-- TOC entry 5198 (class 1259 OID 2247146)
-- Dependencies: 265 6389
-- Name: excecaoempregado_idempregado_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX excecaoempregado_idempregado_idx ON excecaoempregado USING btree (idempregado);


--
-- TOC entry 5199 (class 1259 OID 2247147)
-- Dependencies: 265 6389
-- Name: excecaoempregado_idgrupo_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX excecaoempregado_idgrupo_idx ON excecaoempregado USING btree (idgrupo);


--
-- TOC entry 5200 (class 1259 OID 2247148)
-- Dependencies: 265 6389
-- Name: excecaoempregado_idunidade_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX excecaoempregado_idunidade_idx ON excecaoempregado USING btree (idunidade);


--
-- TOC entry 5207 (class 1259 OID 2247182)
-- Dependencies: 268 6389
-- Name: execucaodemanda_idatividade_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX execucaodemanda_idatividade_idx ON execucaodemanda USING btree (idatividade);


--
-- TOC entry 5210 (class 1259 OID 2247190)
-- Dependencies: 269 6389
-- Name: execucaomudanca_idfluxo_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX execucaomudanca_idfluxo_idx ON execucaomudanca USING btree (idfluxo);


--
-- TOC entry 5211 (class 1259 OID 2247188)
-- Dependencies: 269 6389
-- Name: execucaomudanca_idinstanciafluxo_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX execucaomudanca_idinstanciafluxo_idx ON execucaomudanca USING btree (idinstanciafluxo);


--
-- TOC entry 5212 (class 1259 OID 2247189)
-- Dependencies: 269 6389
-- Name: execucaomudanca_idrequisicaomudanca_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX execucaomudanca_idrequisicaomudanca_idx ON execucaomudanca USING btree (idrequisicaomudanca);


--
-- TOC entry 5215 (class 1259 OID 2247207)
-- Dependencies: 270 6389
-- Name: execucaosolicitacao_idfase_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX execucaosolicitacao_idfase_idx ON execucaosolicitacao USING btree (idfase);


--
-- TOC entry 5216 (class 1259 OID 2247208)
-- Dependencies: 270 6389
-- Name: execucaosolicitacao_idfluxo_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX execucaosolicitacao_idfluxo_idx ON execucaosolicitacao USING btree (idfluxo);


--
-- TOC entry 5217 (class 1259 OID 2247209)
-- Dependencies: 270 6389
-- Name: execucaosolicitacao_idinstanciafluxo_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX execucaosolicitacao_idinstanciafluxo_idx ON execucaosolicitacao USING btree (idinstanciafluxo);


--
-- TOC entry 5218 (class 1259 OID 2247206)
-- Dependencies: 270 6389
-- Name: execucaosolicitacao_idsolicitacaoservico_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX execucaosolicitacao_idsolicitacaoservico_idx ON execucaosolicitacao USING btree (idsolicitacaoservico);


--
-- TOC entry 5223 (class 1259 OID 2247235)
-- Dependencies: 272 6389
-- Name: faixavaloresrecurso_idrecurso_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX faixavaloresrecurso_idrecurso_idx ON faixavaloresrecurso USING btree (idrecurso);


--
-- TOC entry 5228 (class 1259 OID 2247254)
-- Dependencies: 274 6389
-- Name: fatura_idcontrato_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX fatura_idcontrato_idx ON fatura USING btree (idcontrato);


--
-- TOC entry 5231 (class 1259 OID 2247267)
-- Dependencies: 275 6389
-- Name: faturaapuracaoans_idacordonivelservicocontrato_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX faturaapuracaoans_idacordonivelservicocontrato_idx ON faturaapuracaoans USING btree (idacordonivelservicocontrato);


--
-- TOC entry 5232 (class 1259 OID 2247266)
-- Dependencies: 275 6389
-- Name: faturaapuracaoans_idfatura_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX faturaapuracaoans_idfatura_idx ON faturaapuracaoans USING btree (idfatura);


--
-- TOC entry 5235 (class 1259 OID 2247273)
-- Dependencies: 276 6389
-- Name: faturaos_idos_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX faturaos_idos_idx ON faturaos USING btree (idos);


--
-- TOC entry 5244 (class 1259 OID 2247302)
-- Dependencies: 280 6389
-- Name: fluxoservico_idfase_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX fluxoservico_idfase_idx ON fluxoservico USING btree (idfase);


--
-- TOC entry 5245 (class 1259 OID 2247303)
-- Dependencies: 280 6389
-- Name: fluxoservico_idtipofluxo_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX fluxoservico_idtipofluxo_idx ON fluxoservico USING btree (idtipofluxo);


--
-- TOC entry 5252 (class 1259 OID 2247332)
-- Dependencies: 282 6389
-- Name: fornecedor_idendereco_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX fornecedor_idendereco_idx ON fornecedor USING btree (idendereco);


--
-- TOC entry 5255 (class 1259 OID 2247344)
-- Dependencies: 283 6389
-- Name: fornecedorcotacao_idfornecedor_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX fornecedorcotacao_idfornecedor_idx ON fornecedorcotacao USING btree (idfornecedor);


--
-- TOC entry 5258 (class 1259 OID 2247360)
-- Dependencies: 284 6389
-- Name: fornecedorproduto_idfornecedor_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX fornecedorproduto_idfornecedor_idx ON fornecedorproduto USING btree (idfornecedor);


--
-- TOC entry 5259 (class 1259 OID 2247362)
-- Dependencies: 284 6389
-- Name: fornecedorproduto_idmarca_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX fornecedorproduto_idmarca_idx ON fornecedorproduto USING btree (idmarca);


--
-- TOC entry 5260 (class 1259 OID 2247361)
-- Dependencies: 284 6389
-- Name: fornecedorproduto_idtipoproduto_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX fornecedorproduto_idtipoproduto_idx ON fornecedorproduto USING btree (idtipoproduto);


--
-- TOC entry 5263 (class 1259 OID 2247378)
-- Dependencies: 285 6389
-- Name: galeriaimagens_idcategoriagaleriaimagem_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX galeriaimagens_idcategoriagaleriaimagem_idx ON galeriaimagens USING btree (idcategoriagaleriaimagem);


--
-- TOC entry 5266 (class 1259 OID 2247389)
-- Dependencies: 286 6389
-- Name: glosaos_idacordonivelservico_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX glosaos_idacordonivelservico_idx ON glosaos USING btree (idacordonivelservico);


--
-- TOC entry 5267 (class 1259 OID 2247388)
-- Dependencies: 286 6389
-- Name: glosaos_idos_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX glosaos_idos_idx ON glosaos USING btree (idos);


--
-- TOC entry 5272 (class 1259 OID 2247409)
-- Dependencies: 288 6389
-- Name: grupo_idempresa_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX grupo_idempresa_idx ON grupo USING btree (idempresa);


--
-- TOC entry 5279 (class 1259 OID 2247431)
-- Dependencies: 291 6389
-- Name: grupoquestionario_idquestionario_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX grupoquestionario_idquestionario_idx ON grupoquestionario USING btree (idquestionario);


--
-- TOC entry 5286 (class 1259 OID 2247450)
-- Dependencies: 294 6389
-- Name: gruposempregados_idempregado_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX gruposempregados_idempregado_idx ON gruposempregados USING btree (idempregado);


--
-- TOC entry 5289 (class 1259 OID 2247459)
-- Dependencies: 295 6389
-- Name: grupovisao_idvisao_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX grupovisao_idvisao_idx ON grupovisao USING btree (idvisao);


--
-- TOC entry 5292 (class 1259 OID 2247469)
-- Dependencies: 296 6389
-- Name: grupovisaocamposnegocio_idcamposobjetonegocio_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX grupovisaocamposnegocio_idcamposobjetonegocio_idx ON grupovisaocamposnegocio USING btree (idcamposobjetonegocio);


--
-- TOC entry 5295 (class 1259 OID 2247479)
-- Dependencies: 297 297 6389
-- Name: grupovisaocamposnegocioinfosql_1_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX grupovisaocamposnegocioinfosql_1_idx ON grupovisaocamposnegocioinfosql USING btree (idgrupovisao, idcamposobjetonegocio);


--
-- TOC entry 5298 (class 1259 OID 2247489)
-- Dependencies: 298 298 6389
-- Name: grupovisaocamposnegocioligacao_1_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX grupovisaocamposnegocioligacao_1_idx ON grupovisaocamposnegocioligacao USING btree (idgrupovisao, idcamposobjetonegocio);


--
-- TOC entry 5299 (class 1259 OID 2247490)
-- Dependencies: 298 6389
-- Name: grupovisaocamposnegocioligacao_idcamposobjetonegocioligacao_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX grupovisaocamposnegocioligacao_idcamposobjetonegocioligacao_idx ON grupovisaocamposnegocioligacao USING btree (idcamposobjetonegocioligacao);


--
-- TOC entry 5306 (class 1259 OID 2247520)
-- Dependencies: 301 6389
-- Name: historicoexecucao_idexecucao_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX historicoexecucao_idexecucao_idx ON historicoexecucao USING btree (idexecucao);


--
-- TOC entry 5309 (class 1259 OID 2247541)
-- Dependencies: 302 6389
-- Name: historicoic_idautoralteracao_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX historicoic_idautoralteracao_idx ON historicoic USING btree (idautoralteracao);


--
-- TOC entry 5310 (class 1259 OID 2247543)
-- Dependencies: 302 6389
-- Name: historicoic_idclasseitemconfiguracao_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX historicoic_idclasseitemconfiguracao_idx ON historicoic USING btree (idclasseitemconfiguracao);


--
-- TOC entry 5311 (class 1259 OID 2247542)
-- Dependencies: 302 6389
-- Name: historicoic_idfamiliaitemconfiguracao_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX historicoic_idfamiliaitemconfiguracao_idx ON historicoic USING btree (idfamiliaitemconfiguracao);


--
-- TOC entry 5312 (class 1259 OID 2247540)
-- Dependencies: 302 6389
-- Name: historicoic_iditemconfiguracao_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX historicoic_iditemconfiguracao_idx ON historicoic USING btree (iditemconfiguracao);


--
-- TOC entry 5315 (class 1259 OID 2247552)
-- Dependencies: 303 6389
-- Name: historicosituacaocotacao_idcotacao_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX historicosituacaocotacao_idcotacao_idx ON historicosituacaocotacao USING btree (idcotacao);


--
-- TOC entry 5316 (class 1259 OID 2247553)
-- Dependencies: 303 6389
-- Name: historicosituacaocotacao_idresponsavel_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX historicosituacaocotacao_idresponsavel_idx ON historicosituacaocotacao USING btree (idresponsavel);


--
-- TOC entry 5319 (class 1259 OID 2247571)
-- Dependencies: 304 304 6389
-- Name: historicotentativa_1_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX historicotentativa_1_idx ON historicotentativa USING btree (idhistoricotentativa, iditemconfiguracao);


--
-- TOC entry 5320 (class 1259 OID 2247573)
-- Dependencies: 304 6389
-- Name: historicotentativa_idbaseitemconfiguracao_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX historicotentativa_idbaseitemconfiguracao_idx ON historicotentativa USING btree (idbaseitemconfiguracao);


--
-- TOC entry 5321 (class 1259 OID 2247575)
-- Dependencies: 304 6389
-- Name: historicotentativa_idempregado_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX historicotentativa_idempregado_idx ON historicotentativa USING btree (idempregado);


--
-- TOC entry 5322 (class 1259 OID 2247574)
-- Dependencies: 304 6389
-- Name: historicotentativa_idevento_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX historicotentativa_idevento_idx ON historicotentativa USING btree (idevento);


--
-- TOC entry 5323 (class 1259 OID 2247572)
-- Dependencies: 304 6389
-- Name: historicotentativa_iditemconfiguracao_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX historicotentativa_iditemconfiguracao_idx ON historicotentativa USING btree (iditemconfiguracao);


--
-- TOC entry 5326 (class 1259 OID 2247590)
-- Dependencies: 305 6389
-- Name: historicovalor_idvalor_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX historicovalor_idvalor_idx ON historicovalor USING btree (idvalor);


--
-- TOC entry 5329 (class 1259 OID 2247599)
-- Dependencies: 306 6389
-- Name: htmlcodevisao_idvisao_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX htmlcodevisao_idvisao_idx ON htmlcodevisao USING btree (idvisao);


--
-- TOC entry 5332 (class 1259 OID 2247609)
-- Dependencies: 307 307 6389
-- Name: imagemhistorico_1_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX imagemhistorico_1_idx ON imagemhistorico USING btree (idcontrato, data);


--
-- TOC entry 5335 (class 1259 OID 2247622)
-- Dependencies: 308 6389
-- Name: imagemitemconfiguracao_idimagemitemconfiguracaopai_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX imagemitemconfiguracao_idimagemitemconfiguracaopai_idx ON imagemitemconfiguracao USING btree (idimagemitemconfiguracaopai);


--
-- TOC entry 5336 (class 1259 OID 2247621)
-- Dependencies: 308 6389
-- Name: imagemitemconfiguracao_iditemconfiguracao_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX imagemitemconfiguracao_iditemconfiguracao_idx ON imagemitemconfiguracao USING btree (iditemconfiguracao);


--
-- TOC entry 5337 (class 1259 OID 2247620)
-- Dependencies: 308 6389
-- Name: imagemitemconfiguracao_idservico_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX imagemitemconfiguracao_idservico_idx ON imagemitemconfiguracao USING btree (idservico);


--
-- TOC entry 5340 (class 1259 OID 2247635)
-- Dependencies: 309 6389
-- Name: imagemservicorelacionado_idimagemservicorelacionadopai_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX imagemservicorelacionado_idimagemservicorelacionadopai_idx ON imagemservicorelacionado USING btree (idimagemservicorelacionadopai);


--
-- TOC entry 5341 (class 1259 OID 2247633)
-- Dependencies: 309 6389
-- Name: imagemservicorelacionado_idservico_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX imagemservicorelacionado_idservico_idx ON imagemservicorelacionado USING btree (idservico);


--
-- TOC entry 5342 (class 1259 OID 2247634)
-- Dependencies: 309 6389
-- Name: imagemservicorelacionado_idservicorelacionado_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX imagemservicorelacionado_idservicorelacionado_idx ON imagemservicorelacionado USING btree (idservicorelacionado);


--
-- TOC entry 5351 (class 1259 OID 2247657)
-- Dependencies: 313 6389
-- Name: importancianegocio_idempresa_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX importancianegocio_idempresa_idx ON importancianegocio USING btree (idempresa);


--
-- TOC entry 5354 (class 1259 OID 2247669)
-- Dependencies: 314 6389
-- Name: importconfig_idexternalconnection_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX importconfig_idexternalconnection_idx ON importconfig USING btree (idexternalconnection);


--
-- TOC entry 5357 (class 1259 OID 2247685)
-- Dependencies: 315 6389
-- Name: importconfigcampos_idimportconfig_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX importconfigcampos_idimportconfig_idx ON importconfigcampos USING btree (idimportconfig);


--
-- TOC entry 5360 (class 1259 OID 2247700)
-- Dependencies: 316 6389
-- Name: infocatalogoservico_idcatalogoservico_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX infocatalogoservico_idcatalogoservico_idx ON infocatalogoservico USING btree (idcatalogoservico);


--
-- TOC entry 5363 (class 1259 OID 2247717)
-- Dependencies: 318 6389
-- Name: informacaoservico_idservico_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX informacaoservico_idservico_idx ON informacaoservico USING btree (idservico);


--
-- TOC entry 5366 (class 1259 OID 2247737)
-- Dependencies: 319 6389
-- Name: informacoescontratoconfig_idempresa_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX informacoescontratoconfig_idempresa_idx ON informacoescontratoconfig USING btree (idempresa);


--
-- TOC entry 5367 (class 1259 OID 2247735)
-- Dependencies: 319 6389
-- Name: informacoescontratoconfig_idinformacoescontratoconfigpai_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX informacoescontratoconfig_idinformacoescontratoconfigpai_idx ON informacoescontratoconfig USING btree (idinformacoescontratoconfigpai);


--
-- TOC entry 5368 (class 1259 OID 2247736)
-- Dependencies: 319 6389
-- Name: informacoescontratoconfig_idquestionario_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX informacoescontratoconfig_idquestionario_idx ON informacoescontratoconfig USING btree (idquestionario);


--
-- TOC entry 5371 (class 1259 OID 2247743)
-- Dependencies: 320 6389
-- Name: informacoescontratoperfseg_idperfilseguranca_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX informacoescontratoperfseg_idperfilseguranca_idx ON informacoescontratoperfseg USING btree (idperfilseguranca);


--
-- TOC entry 5374 (class 1259 OID 2247757)
-- Dependencies: 321 6389
-- Name: inspecaoentregaitem_idcriterio_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX inspecaoentregaitem_idcriterio_idx ON inspecaoentregaitem USING btree (idcriterio);


--
-- TOC entry 5375 (class 1259 OID 2247756)
-- Dependencies: 321 6389
-- Name: inspecaoentregaitem_idresponsavel_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX inspecaoentregaitem_idresponsavel_idx ON inspecaoentregaitem USING btree (idresponsavel);


--
-- TOC entry 5378 (class 1259 OID 2247780)
-- Dependencies: 322 6389
-- Name: inspecaopedidocompra_idcriterio_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX inspecaopedidocompra_idcriterio_idx ON inspecaopedidocompra USING btree (idcriterio);


--
-- TOC entry 5379 (class 1259 OID 2247781)
-- Dependencies: 322 6389
-- Name: inspecaopedidocompra_idresponsavel_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX inspecaopedidocompra_idresponsavel_idx ON inspecaopedidocompra USING btree (idresponsavel);


--
-- TOC entry 5382 (class 1259 OID 2247801)
-- Dependencies: 323 6389
-- Name: inventarioxml_idnetmap_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX inventarioxml_idnetmap_idx ON inventarioxml USING btree (idnetmap);


--
-- TOC entry 5385 (class 1259 OID 2247805)
-- Dependencies: 324 6389
-- Name: itemcfgsolicitacaoserv_iditemconfiguracao_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX itemcfgsolicitacaoserv_iditemconfiguracao_idx ON itemcfgsolicitacaoserv USING btree (iditemconfiguracao);


--
-- TOC entry 5386 (class 1259 OID 2247806)
-- Dependencies: 324 6389
-- Name: itemcfgsolicitacaoserv_idsolicitacaoservico_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX itemcfgsolicitacaoserv_idsolicitacaoservico_idx ON itemcfgsolicitacaoserv USING btree (idsolicitacaoservico);


--
-- TOC entry 5387 (class 1259 OID 2247822)
-- Dependencies: 325 325 6389
-- Name: itemconfiguracao_1_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX itemconfiguracao_1_idx ON itemconfiguracao USING btree (identificacao, iditemconfiguracaopai);


--
-- TOC entry 5388 (class 1259 OID 2247827)
-- Dependencies: 325 6389
-- Name: itemconfiguracao_idbaseconhecimento_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX itemconfiguracao_idbaseconhecimento_idx ON itemconfiguracao USING btree (idbaseconhecimento);


--
-- TOC entry 5389 (class 1259 OID 2247825)
-- Dependencies: 325 6389
-- Name: itemconfiguracao_idgrupoitemconfiguracao_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX itemconfiguracao_idgrupoitemconfiguracao_idx ON itemconfiguracao USING btree (idgrupoitemconfiguracao);


--
-- TOC entry 5390 (class 1259 OID 2247823)
-- Dependencies: 325 6389
-- Name: itemconfiguracao_iditemconfiguracaopai_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX itemconfiguracao_iditemconfiguracaopai_idx ON itemconfiguracao USING btree (iditemconfiguracaopai);


--
-- TOC entry 5391 (class 1259 OID 2247826)
-- Dependencies: 325 6389
-- Name: itemconfiguracao_idproprietario_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX itemconfiguracao_idproprietario_idx ON itemconfiguracao USING btree (idproprietario);


--
-- TOC entry 5392 (class 1259 OID 2247824)
-- Dependencies: 325 6389
-- Name: itemconfiguracao_idtipoitemconfiguracao_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX itemconfiguracao_idtipoitemconfiguracao_idx ON itemconfiguracao USING btree (idtipoitemconfiguracao);


--
-- TOC entry 5395 (class 1259 OID 2247853)
-- Dependencies: 326 6389
-- Name: itemconfiguracaoevento_idbaseitemconfiguracao_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX itemconfiguracaoevento_idbaseitemconfiguracao_idx ON itemconfiguracaoevento USING btree (idbaseitemconfiguracao);


--
-- TOC entry 5396 (class 1259 OID 2247855)
-- Dependencies: 326 6389
-- Name: itemconfiguracaoevento_idevento_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX itemconfiguracaoevento_idevento_idx ON itemconfiguracaoevento USING btree (idevento);


--
-- TOC entry 5397 (class 1259 OID 2247854)
-- Dependencies: 326 6389
-- Name: itemconfiguracaoevento_iditemconfiguracao_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX itemconfiguracaoevento_iditemconfiguracao_idx ON itemconfiguracaoevento USING btree (iditemconfiguracao);


--
-- TOC entry 5398 (class 1259 OID 2247876)
-- Dependencies: 327 6389
-- Name: itemcotacao_idcategoriaproduto_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX itemcotacao_idcategoriaproduto_idx ON itemcotacao USING btree (idcategoriaproduto);


--
-- TOC entry 5399 (class 1259 OID 2247873)
-- Dependencies: 327 6389
-- Name: itemcotacao_idcotacao_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX itemcotacao_idcotacao_idx ON itemcotacao USING btree (idcotacao);


--
-- TOC entry 5400 (class 1259 OID 2247874)
-- Dependencies: 327 6389
-- Name: itemcotacao_idproduto_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX itemcotacao_idproduto_idx ON itemcotacao USING btree (idproduto);


--
-- TOC entry 5401 (class 1259 OID 2247875)
-- Dependencies: 327 6389
-- Name: itemcotacao_idunidademedida_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX itemcotacao_idunidademedida_idx ON itemcotacao USING btree (idunidademedida);


--
-- TOC entry 5404 (class 1259 OID 2247897)
-- Dependencies: 328 6389
-- Name: itempedidocompra_idcoletapreco_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX itempedidocompra_idcoletapreco_idx ON itempedidocompra USING btree (idcoletapreco);


--
-- TOC entry 5405 (class 1259 OID 2247898)
-- Dependencies: 328 6389
-- Name: itempedidocompra_idpedido_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX itempedidocompra_idpedido_idx ON itempedidocompra USING btree (idpedido);


--
-- TOC entry 5406 (class 1259 OID 2247899)
-- Dependencies: 328 6389
-- Name: itempedidocompra_idproduto_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX itempedidocompra_idproduto_idx ON itempedidocompra USING btree (idproduto);


--
-- TOC entry 5409 (class 1259 OID 2247926)
-- Dependencies: 329 6389
-- Name: itemrequisicaoproduto_idcategoriaproduto_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX itemrequisicaoproduto_idcategoriaproduto_idx ON itemrequisicaoproduto USING btree (idcategoriaproduto);


--
-- TOC entry 5410 (class 1259 OID 2247927)
-- Dependencies: 329 6389
-- Name: itemrequisicaoproduto_iditemcotacao_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX itemrequisicaoproduto_iditemcotacao_idx ON itemrequisicaoproduto USING btree (iditemcotacao);


--
-- TOC entry 5411 (class 1259 OID 2247923)
-- Dependencies: 329 6389
-- Name: itemrequisicaoproduto_idparecerautorizacao_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX itemrequisicaoproduto_idparecerautorizacao_idx ON itemrequisicaoproduto USING btree (idparecerautorizacao);


--
-- TOC entry 5412 (class 1259 OID 2247922)
-- Dependencies: 329 6389
-- Name: itemrequisicaoproduto_idparecervalidacao_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX itemrequisicaoproduto_idparecervalidacao_idx ON itemrequisicaoproduto USING btree (idparecervalidacao);


--
-- TOC entry 5413 (class 1259 OID 2247924)
-- Dependencies: 329 6389
-- Name: itemrequisicaoproduto_idproduto_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX itemrequisicaoproduto_idproduto_idx ON itemrequisicaoproduto USING btree (idproduto);


--
-- TOC entry 5414 (class 1259 OID 2247921)
-- Dependencies: 329 6389
-- Name: itemrequisicaoproduto_idsolicitacaoservico_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX itemrequisicaoproduto_idsolicitacaoservico_idx ON itemrequisicaoproduto USING btree (idsolicitacaoservico);


--
-- TOC entry 5415 (class 1259 OID 2247925)
-- Dependencies: 329 6389
-- Name: itemrequisicaoproduto_idunidademedida_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX itemrequisicaoproduto_idunidademedida_idx ON itemrequisicaoproduto USING btree (idunidademedida);


--
-- TOC entry 5420 (class 1259 OID 2247964)
-- Dependencies: 331 6389
-- Name: justificacaofalha_idbaseitemconfiguracao_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX justificacaofalha_idbaseitemconfiguracao_idx ON justificacaofalha USING btree (idbaseitemconfiguracao);


--
-- TOC entry 5421 (class 1259 OID 2247966)
-- Dependencies: 331 6389
-- Name: justificacaofalha_idempregado_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX justificacaofalha_idempregado_idx ON justificacaofalha USING btree (idempregado);


--
-- TOC entry 5422 (class 1259 OID 2247965)
-- Dependencies: 331 6389
-- Name: justificacaofalha_idevento_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX justificacaofalha_idevento_idx ON justificacaofalha USING btree (idevento);


--
-- TOC entry 5423 (class 1259 OID 2247967)
-- Dependencies: 331 6389
-- Name: justificacaofalha_idhistoricotentativa_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX justificacaofalha_idhistoricotentativa_idx ON justificacaofalha USING btree (idhistoricotentativa);


--
-- TOC entry 5424 (class 1259 OID 2247963)
-- Dependencies: 331 6389
-- Name: justificacaofalha_iditemconfiguracao_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX justificacaofalha_iditemconfiguracao_idx ON justificacaofalha USING btree (iditemconfiguracao);


--
-- TOC entry 5433 (class 1259 OID 2248001)
-- Dependencies: 335 6389
-- Name: liberacao_idresponsavel_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX liberacao_idresponsavel_idx ON liberacao USING btree (idresponsavel);


--
-- TOC entry 5434 (class 1259 OID 2248000)
-- Dependencies: 335 6389
-- Name: liberacao_idsolicitante_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX liberacao_idsolicitante_idx ON liberacao USING btree (idsolicitante);


--
-- TOC entry 5437 (class 1259 OID 2248007)
-- Dependencies: 336 6389
-- Name: liberacaomudanca_idrequisicaomudanca_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

-- CREATE INDEX liberacaomudanca_idrequisicaomudanca_idx ON liberacaomudanca USING btree (idrequisicaomudanca);


--
-- TOC entry 5440 (class 1259 OID 2248016)
-- Dependencies: 337 6389
-- Name: limitealcada_idalcada_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX limitealcada_idalcada_idx ON limitealcada USING btree (idalcada);


--
-- TOC entry 5441 (class 1259 OID 2248017)
-- Dependencies: 337 6389
-- Name: limitealcada_idgrupo_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX limitealcada_idgrupo_idx ON limitealcada USING btree (idgrupo);


--
-- TOC entry 5450 (class 1259 OID 2248052)
-- Dependencies: 341 6389
-- Name: localidadeunidade_idlocalidade_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX localidadeunidade_idlocalidade_idx ON localidadeunidade USING btree (idlocalidade);


--
-- TOC entry 5455 (class 1259 OID 2248081)
-- Dependencies: 344 6389
-- Name: marca_idfabricante_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX marca_idfabricante_idx ON marca USING btree (idfabricante);


--
-- TOC entry 5460 (class 1259 OID 2248109)
-- Dependencies: 346 6389
-- Name: matrizvisao_idcamposobjetonegocio1_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX matrizvisao_idcamposobjetonegocio1_idx ON matrizvisao USING btree (idcamposobjetonegocio1);


--
-- TOC entry 5461 (class 1259 OID 2248110)
-- Dependencies: 346 6389
-- Name: matrizvisao_idcamposobjetonegocio2_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX matrizvisao_idcamposobjetonegocio2_idx ON matrizvisao USING btree (idcamposobjetonegocio2);


--
-- TOC entry 5462 (class 1259 OID 2248111)
-- Dependencies: 346 6389
-- Name: matrizvisao_idcamposobjetonegocio3_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX matrizvisao_idcamposobjetonegocio3_idx ON matrizvisao USING btree (idcamposobjetonegocio3);


--
-- TOC entry 5463 (class 1259 OID 2248108)
-- Dependencies: 346 6389
-- Name: matrizvisao_idobjetonegocio_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX matrizvisao_idobjetonegocio_idx ON matrizvisao USING btree (idobjetonegocio);


--
-- TOC entry 5464 (class 1259 OID 2248107)
-- Dependencies: 346 6389
-- Name: matrizvisao_idvisao_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX matrizvisao_idvisao_idx ON matrizvisao USING btree (idvisao);


--
-- TOC entry 5467 (class 1259 OID 2248141)
-- Dependencies: 347 347 6389
-- Name: menu_1_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX menu_1_idx ON menu USING btree (nome, ordem);


--
-- TOC entry 5468 (class 1259 OID 2248140)
-- Dependencies: 347 6389
-- Name: menu_idmenupai_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX menu_idmenupai_idx ON menu USING btree (idmenupai);


--
-- TOC entry 5469 (class 1259 OID 2248142)
-- Dependencies: 347 6389
-- Name: menu_link_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX menu_link_idx ON menu USING btree (link);


--
-- TOC entry 5470 (class 1259 OID 2248143)
-- Dependencies: 347 6389
-- Name: menu_menurapido_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX menu_menurapido_idx ON menu USING btree (menurapido);


--
-- TOC entry 5477 (class 1259 OID 2248167)
-- Dependencies: 350 6389
-- Name: midiasoftware_idmidia_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX midiasoftware_idmidia_idx ON midiasoftware USING btree (idmidia);


--
-- TOC entry 5478 (class 1259 OID 2248168)
-- Dependencies: 350 6389
-- Name: midiasoftware_idtiposoftware_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX midiasoftware_idtiposoftware_idx ON midiasoftware USING btree (idtiposoftware);


--
-- TOC entry 5489 (class 1259 OID 2248209)
-- Dependencies: 355 6389
-- Name: netmap_ip_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX netmap_ip_idx ON netmap USING btree (ip);


--
-- TOC entry 5494 (class 1259 OID 2248221)
-- Dependencies: 357 6389
-- Name: notificacaogrupo_idgrupo_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX notificacaogrupo_idgrupo_idx ON notificacaogrupo USING btree (idgrupo);


--
-- TOC entry 5495 (class 1259 OID 2248220)
-- Dependencies: 357 6389
-- Name: notificacaogrupo_idnotificacao_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX notificacaogrupo_idnotificacao_idx ON notificacaogrupo USING btree (idnotificacao);


--
-- TOC entry 5496 (class 1259 OID 2248238)
-- Dependencies: 359 6389
-- Name: notificacaousuario_idnotificacao_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX notificacaousuario_idnotificacao_idx ON notificacaousuario USING btree (idnotificacao);


--
-- TOC entry 5497 (class 1259 OID 2248239)
-- Dependencies: 359 6389
-- Name: notificacaousuario_idusuario_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX notificacaousuario_idusuario_idx ON notificacaousuario USING btree (idusuario);


--
-- TOC entry 5498 (class 1259 OID 2248258)
-- Dependencies: 360 6389
-- Name: objetivomonitoramento_idobjetivoplanomelhoria_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX objetivomonitoramento_idobjetivoplanomelhoria_idx ON objetivomonitoramento USING btree (idobjetivoplanomelhoria);


--
-- TOC entry 5501 (class 1259 OID 2248271)
-- Dependencies: 361 6389
-- Name: objetivoplanomelhoria_idplanomelhoria_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX objetivoplanomelhoria_idplanomelhoria_idx ON objetivoplanomelhoria USING btree (idplanomelhoria);


--
-- TOC entry 5506 (class 1259 OID 2248293)
-- Dependencies: 363 6389
-- Name: ocorrenciamudanca_iditemtrabalho_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX ocorrenciamudanca_iditemtrabalho_idx ON ocorrenciamudanca USING btree (iditemtrabalho);


--
-- TOC entry 5507 (class 1259 OID 2248294)
-- Dependencies: 363 6389
-- Name: ocorrenciamudanca_idjustificativa_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX ocorrenciamudanca_idjustificativa_idx ON ocorrenciamudanca USING btree (idjustificativa);


--
-- TOC entry 5508 (class 1259 OID 2248295)
-- Dependencies: 363 6389
-- Name: ocorrenciamudanca_idrequisicaomudanca_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX ocorrenciamudanca_idrequisicaomudanca_idx ON ocorrenciamudanca USING btree (idrequisicaomudanca);


--
-- TOC entry 5511 (class 1259 OID 2248314)
-- Dependencies: 364 6389
-- Name: ocorrencias_iddemanda_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX ocorrencias_iddemanda_idx ON ocorrencias USING btree (iddemanda);


--
-- TOC entry 5512 (class 1259 OID 2248315)
-- Dependencies: 364 6389
-- Name: ocorrencias_idempregado_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX ocorrencias_idempregado_idx ON ocorrencias USING btree (idempregado);


--
-- TOC entry 5515 (class 1259 OID 2248332)
-- Dependencies: 365 6389
-- Name: ocorrenciasolicitacao_idcategoriaocorrencia_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX ocorrenciasolicitacao_idcategoriaocorrencia_idx ON ocorrenciasolicitacao USING btree (idcategoriaocorrencia);


--
-- TOC entry 5516 (class 1259 OID 2248331)
-- Dependencies: 365 6389
-- Name: ocorrenciasolicitacao_iditemtrabalho_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX ocorrenciasolicitacao_iditemtrabalho_idx ON ocorrenciasolicitacao USING btree (iditemtrabalho);


--
-- TOC entry 5517 (class 1259 OID 2248329)
-- Dependencies: 365 6389
-- Name: ocorrenciasolicitacao_idjustificativa_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX ocorrenciasolicitacao_idjustificativa_idx ON ocorrenciasolicitacao USING btree (idjustificativa);


--
-- TOC entry 5518 (class 1259 OID 2248333)
-- Dependencies: 365 6389
-- Name: ocorrenciasolicitacao_idorigemocorrencia_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX ocorrenciasolicitacao_idorigemocorrencia_idx ON ocorrenciasolicitacao USING btree (idorigemocorrencia);


--
-- TOC entry 5519 (class 1259 OID 2248330)
-- Dependencies: 365 6389
-- Name: ocorrenciasolicitacao_idsolicitacaoservico_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX ocorrenciasolicitacao_idsolicitacaoservico_idx ON ocorrenciasolicitacao USING btree (idsolicitacaoservico);


--
-- TOC entry 5522 (class 1259 OID 2248358)
-- Dependencies: 366 6389
-- Name: opcaorespostaquestionario_idquestaocomplemento_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX opcaorespostaquestionario_idquestaocomplemento_idx ON opcaorespostaquestionario USING btree (idquestaocomplemento);


--
-- TOC entry 5523 (class 1259 OID 2248357)
-- Dependencies: 366 6389
-- Name: opcaorespostaquestionario_idquestaoquestionario_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX opcaorespostaquestionario_idquestaoquestionario_idx ON opcaorespostaquestionario USING btree (idquestaoquestionario);


--
-- TOC entry 5532 (class 1259 OID 2248391)
-- Dependencies: 371 6389
-- Name: os_idclassificacaoos_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX os_idclassificacaoos_idx ON os USING btree (idclassificacaoos);


--
-- TOC entry 5533 (class 1259 OID 2248390)
-- Dependencies: 371 6389
-- Name: os_idcontrato_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX os_idcontrato_idx ON os USING btree (idcontrato);


--
-- TOC entry 5534 (class 1259 OID 2248393)
-- Dependencies: 371 6389
-- Name: os_idospai_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX os_idospai_idx ON os USING btree (idospai);


--
-- TOC entry 5535 (class 1259 OID 2248392)
-- Dependencies: 371 6389
-- Name: os_idservicocontrato_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX os_idservicocontrato_idx ON os USING btree (idservicocontrato);


--
-- TOC entry 5536 (class 1259 OID 2248397)
-- Dependencies: 372 6389
-- Name: osatividadeperiodica_idatividadeperiodica_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX osatividadeperiodica_idatividadeperiodica_idx ON osatividadeperiodica USING btree (idatividadeperiodica);


--
-- TOC entry 5537 (class 1259 OID 2248398)
-- Dependencies: 372 6389
-- Name: osatividadeperiodica_idos_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX osatividadeperiodica_idos_idx ON osatividadeperiodica USING btree (idos);


--
-- TOC entry 5544 (class 1259 OID 2248426)
-- Dependencies: 376 6389
-- Name: parametros_idempresa_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX parametros_idempresa_idx ON parametros USING btree (idempresa);


--
-- TOC entry 5547 (class 1259 OID 2248447)
-- Dependencies: 378 6389
-- Name: parecer_idalcada_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX parecer_idalcada_idx ON parecer USING btree (idalcada);


--
-- TOC entry 5548 (class 1259 OID 2248446)
-- Dependencies: 378 6389
-- Name: parecer_idjustificativa_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX parecer_idjustificativa_idx ON parecer USING btree (idjustificativa);


--
-- TOC entry 5551 (class 1259 OID 2248465)
-- Dependencies: 379 6389
-- Name: pasta_idpastapai_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX pasta_idpastapai_idx ON pasta USING btree (idpastapai);


--
-- TOC entry 5554 (class 1259 OID 2248480)
-- Dependencies: 380 6389
-- Name: pedidocompra_idcotacao_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX pedidocompra_idcotacao_idx ON pedidocompra USING btree (idcotacao);


--
-- TOC entry 5555 (class 1259 OID 2248481)
-- Dependencies: 380 6389
-- Name: pedidocompra_idenderecoentrega_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX pedidocompra_idenderecoentrega_idx ON pedidocompra USING btree (idenderecoentrega);


--
-- TOC entry 5556 (class 1259 OID 2248479)
-- Dependencies: 380 6389
-- Name: pedidocompra_idfornecedor_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX pedidocompra_idfornecedor_idx ON pedidocompra USING btree (idfornecedor);


--
-- TOC entry 5561 (class 1259 OID 2248507)
-- Dependencies: 382 6389
-- Name: perfilacessogrupo_idgrupo_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX perfilacessogrupo_idgrupo_idx ON perfilacessogrupo USING btree (idgrupo);


--
-- TOC entry 5564 (class 1259 OID 2248511)
-- Dependencies: 383 6389
-- Name: perfilacessomenu_datafim_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX perfilacessomenu_datafim_idx ON perfilacessomenu USING btree (datafim);


--
-- TOC entry 5565 (class 1259 OID 2248513)
-- Dependencies: 383 6389
-- Name: perfilacessomenu_idmenu_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX perfilacessomenu_idmenu_idx ON perfilacessomenu USING btree (idmenu);


--
-- TOC entry 5566 (class 1259 OID 2248512)
-- Dependencies: 383 6389
-- Name: perfilacessomenu_idperfilacesso_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX perfilacessomenu_idperfilacesso_idx ON perfilacessomenu USING btree (idperfilacesso);


--
-- TOC entry 5567 (class 1259 OID 2248522)
-- Dependencies: 384 6389
-- Name: perfilacessopasta_idpasta_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX perfilacessopasta_idpasta_idx ON perfilacessopasta USING btree (idpasta);


--
-- TOC entry 5574 (class 1259 OID 2248539)
-- Dependencies: 387 6389
-- Name: perfilacessousuario_idperfil_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX perfilacessousuario_idperfil_idx ON perfilacessousuario USING btree (idperfil);


--
-- TOC entry 5575 (class 1259 OID 2248538)
-- Dependencies: 387 6389
-- Name: perfilacessousuario_idusuario_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX perfilacessousuario_idusuario_idx ON perfilacessousuario USING btree (idusuario);


--
-- TOC entry 5580 (class 1259 OID 2248554)
-- Dependencies: 389 6389
-- Name: permissoesfluxo_idtipofluxo_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX permissoesfluxo_idtipofluxo_idx ON permissoesfluxo USING btree (idtipofluxo);


--
-- TOC entry 5583 (class 1259 OID 2248563)
-- Dependencies: 390 6389
-- Name: pesquisasatisfacao_idsolicitacaoservico_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX pesquisasatisfacao_idsolicitacaoservico_idx ON pesquisasatisfacao USING btree (idsolicitacaoservico);


--
-- TOC entry 5588 (class 1259 OID 2248583)
-- Dependencies: 392 392 6389
-- Name: planomelhoria_1_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX planomelhoria_1_idx ON planomelhoria USING btree (idcontrato, idfornecedor);


--
-- TOC entry 5589 (class 1259 OID 2248582)
-- Dependencies: 392 6389
-- Name: planomelhoria_idfornecedor_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX planomelhoria_idfornecedor_idx ON planomelhoria USING btree (idfornecedor);


--
-- TOC entry 5594 (class 1259 OID 2248602)
-- Dependencies: 394 6389
-- Name: post_idcategoriapost_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX post_idcategoriapost_idx ON post USING btree (idcategoriapost);


--
-- TOC entry 5597 (class 1259 OID 2248613)
-- Dependencies: 395 6389
-- Name: prioridade_idempresa_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX prioridade_idempresa_idx ON prioridade USING btree (idempresa);


--
-- TOC entry 5602 (class 1259 OID 2248625)
-- Dependencies: 397 6389
-- Name: prioridadeservicounidade_idprioridade_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX prioridadeservicounidade_idprioridade_idx ON prioridadeservicounidade USING btree (idprioridade);


--
-- TOC entry 5603 (class 1259 OID 2248624)
-- Dependencies: 397 6389
-- Name: prioridadeservicounidade_idservicocontrato_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX prioridadeservicounidade_idservicocontrato_idx ON prioridadeservicounidade USING btree (idservicocontrato);


--
-- TOC entry 5606 (class 1259 OID 2248654)
-- Dependencies: 398 6389
-- Name: problema_idcategoriaproblema_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX problema_idcategoriaproblema_idx ON problema USING btree (idcategoriaproblema);


--
-- TOC entry 5607 (class 1259 OID 2248652)
-- Dependencies: 398 6389
-- Name: problema_idproblemaitemconfiguracao_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX problema_idproblemaitemconfiguracao_idx ON problema USING btree (idproblemaitemconfiguracao);


--
-- TOC entry 5608 (class 1259 OID 2248653)
-- Dependencies: 398 6389
-- Name: problema_idproblemamudanca_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX problema_idproblemamudanca_idx ON problema USING btree (idproblemamudanca);


--
-- TOC entry 5611 (class 1259 OID 2248661)
-- Dependencies: 399 6389
-- Name: problemaitemconfiguracao_iditemconfiguracao_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX problemaitemconfiguracao_iditemconfiguracao_idx ON problemaitemconfiguracao USING btree (iditemconfiguracao);


--
-- TOC entry 5612 (class 1259 OID 2248662)
-- Dependencies: 399 6389
-- Name: problemaitemconfiguracao_idproblema_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX problemaitemconfiguracao_idproblema_idx ON problemaitemconfiguracao USING btree (idproblema);


--
-- TOC entry 5615 (class 1259 OID 2248669)
-- Dependencies: 400 6389
-- Name: problemamudanca_idproblema_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX problemamudanca_idproblema_idx ON problemamudanca USING btree (idproblema);


--
-- TOC entry 5616 (class 1259 OID 2248668)
-- Dependencies: 400 6389
-- Name: problemamudanca_idrequisicaomudanca_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX problemamudanca_idrequisicaomudanca_idx ON problemamudanca USING btree (idrequisicaomudanca);


--
-- TOC entry 5623 (class 1259 OID 2248700)
-- Dependencies: 403 6389
-- Name: produto_idmarca_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX produto_idmarca_idx ON produto USING btree (idmarca);


--
-- TOC entry 5624 (class 1259 OID 2248699)
-- Dependencies: 403 6389
-- Name: produto_idtipoproduto_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX produto_idtipoproduto_idx ON produto USING btree (idtipoproduto);


--
-- TOC entry 5629 (class 1259 OID 2248742)
-- Dependencies: 405 6389
-- Name: projetos_idcliente_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX projetos_idcliente_idx ON projetos USING btree (idcliente);


--
-- TOC entry 5630 (class 1259 OID 2248743)
-- Dependencies: 405 6389
-- Name: projetos_idcontrato_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX projetos_idcontrato_idx ON projetos USING btree (idcontrato);


--
-- TOC entry 5633 (class 1259 OID 2248769)
-- Dependencies: 406 6389
-- Name: questaoquestionario_idgrupoquestionario_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX questaoquestionario_idgrupoquestionario_idx ON questaoquestionario USING btree (idgrupoquestionario);


--
-- TOC entry 5634 (class 1259 OID 2248774)
-- Dependencies: 406 6389
-- Name: questaoquestionario_idimagem_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX questaoquestionario_idimagem_idx ON questaoquestionario USING btree (idimagem);


--
-- TOC entry 5635 (class 1259 OID 2248770)
-- Dependencies: 406 6389
-- Name: questaoquestionario_idquestaoagrupadora_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX questaoquestionario_idquestaoagrupadora_idx ON questaoquestionario USING btree (idquestaoagrupadora);


--
-- TOC entry 5636 (class 1259 OID 2248771)
-- Dependencies: 406 6389
-- Name: questaoquestionario_idquestaocompartilhada_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX questaoquestionario_idquestaocompartilhada_idx ON questaoquestionario USING btree (idquestaocompartilhada);


--
-- TOC entry 5637 (class 1259 OID 2248772)
-- Dependencies: 406 6389
-- Name: questaoquestionario_idquestaoorigem_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX questaoquestionario_idquestaoorigem_idx ON questaoquestionario USING btree (idquestaoorigem);


--
-- TOC entry 5638 (class 1259 OID 2248773)
-- Dependencies: 406 6389
-- Name: questaoquestionario_idsubquestionario_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX questaoquestionario_idsubquestionario_idx ON questaoquestionario USING btree (idsubquestionario);


--
-- TOC entry 5641 (class 1259 OID 2248782)
-- Dependencies: 407 6389
-- Name: questionario_idcategoriaquestionario_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX questionario_idcategoriaquestionario_idx ON questionario USING btree (idcategoriaquestionario);


--
-- TOC entry 5642 (class 1259 OID 2248781)
-- Dependencies: 407 6389
-- Name: questionario_idquestionarioorigem_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX questionario_idquestionarioorigem_idx ON questionario USING btree (idquestionarioorigem);


--
-- TOC entry 5645 (class 1259 OID 2248794)
-- Dependencies: 408 6389
-- Name: reaberturasolicitacao_idresponsavel_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX reaberturasolicitacao_idresponsavel_idx ON reaberturasolicitacao USING btree (idresponsavel);


--
-- TOC entry 5648 (class 1259 OID 2248815)
-- Dependencies: 409 6389
-- Name: recurso_idcalendario_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX recurso_idcalendario_idx ON recurso USING btree (idcalendario);


--
-- TOC entry 5649 (class 1259 OID 2248820)
-- Dependencies: 409 6389
-- Name: recurso_ideventomonitoramento_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX recurso_ideventomonitoramento_idx ON recurso USING btree (ideventomonitoramento);


--
-- TOC entry 5650 (class 1259 OID 2248817)
-- Dependencies: 409 6389
-- Name: recurso_idgrupo_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX recurso_idgrupo_idx ON recurso USING btree (idgrupo);


--
-- TOC entry 5651 (class 1259 OID 2248822)
-- Dependencies: 409 6389
-- Name: recurso_idgruporecurso_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX recurso_idgruporecurso_idx ON recurso USING btree (idgruporecurso);


--
-- TOC entry 5652 (class 1259 OID 2248821)
-- Dependencies: 409 6389
-- Name: recurso_iditemconfiguracao_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX recurso_iditemconfiguracao_idx ON recurso USING btree (iditemconfiguracao);


--
-- TOC entry 5653 (class 1259 OID 2248814)
-- Dependencies: 409 6389
-- Name: recurso_idnagiosconexao_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX recurso_idnagiosconexao_idx ON recurso USING btree (idnagiosconexao);


--
-- TOC entry 5654 (class 1259 OID 2248818)
-- Dependencies: 409 6389
-- Name: recurso_idorigem_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX recurso_idorigem_idx ON recurso USING btree (idorigem);


--
-- TOC entry 5655 (class 1259 OID 2248813)
-- Dependencies: 409 6389
-- Name: recurso_idrecursopai_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX recurso_idrecursopai_idx ON recurso USING btree (idrecursopai);


--
-- TOC entry 5656 (class 1259 OID 2248819)
-- Dependencies: 409 6389
-- Name: recurso_idservicocontrato_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX recurso_idservicocontrato_idx ON recurso USING btree (idservicocontrato);


--
-- TOC entry 5657 (class 1259 OID 2248816)
-- Dependencies: 409 6389
-- Name: recurso_idsolicitante_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX recurso_idsolicitante_idx ON recurso USING btree (idsolicitante);


--
-- TOC entry 5666 (class 1259 OID 2248889)
-- Dependencies: 412 6389
-- Name: relacionamentoproduto_idtipoprodutorelacionado_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX relacionamentoproduto_idtipoprodutorelacionado_idx ON relacionamentoproduto USING btree (idtipoprodutorelacionado);


--
-- TOC entry 5669 (class 1259 OID 2248896)
-- Dependencies: 413 6389
-- Name: relacobjetonegocio_idobjetonegociofilho_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX relacobjetonegocio_idobjetonegociofilho_idx ON relacobjetonegocio USING btree (idobjetonegociofilho);


--
-- TOC entry 5670 (class 1259 OID 2248895)
-- Dependencies: 413 6389
-- Name: relacobjetonegocio_idobjetonegociopai_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX relacobjetonegocio_idobjetonegociopai_idx ON relacobjetonegocio USING btree (idobjetonegociopai);


--
-- TOC entry 5673 (class 1259 OID 2248927)
-- Dependencies: 414 6389
-- Name: requisicaomudanca_idbaseconhecimento_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX requisicaomudanca_idbaseconhecimento_idx ON requisicaomudanca USING btree (idbaseconhecimento);


--
-- TOC entry 5674 (class 1259 OID 2248926)
-- Dependencies: 414 6389
-- Name: requisicaomudanca_idcalendario_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX requisicaomudanca_idcalendario_idx ON requisicaomudanca USING btree (idcalendario);


--
-- TOC entry 5675 (class 1259 OID 2248925)
-- Dependencies: 414 6389
-- Name: requisicaomudanca_idgrupoatual_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX requisicaomudanca_idgrupoatual_idx ON requisicaomudanca USING btree (idgrupoatual);


--
-- TOC entry 5676 (class 1259 OID 2248928)
-- Dependencies: 414 6389
-- Name: requisicaomudanca_idgrupocomite_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX requisicaomudanca_idgrupocomite_idx ON requisicaomudanca USING btree (idgrupocomite);


--
-- TOC entry 5677 (class 1259 OID 2248924)
-- Dependencies: 414 6389
-- Name: requisicaomudanca_idgruponivel1_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX requisicaomudanca_idgruponivel1_idx ON requisicaomudanca USING btree (idgruponivel1);


--
-- TOC entry 5678 (class 1259 OID 2248923)
-- Dependencies: 414 6389
-- Name: requisicaomudanca_idtipomudanca_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX requisicaomudanca_idtipomudanca_idx ON requisicaomudanca USING btree (idtipomudanca);


--
-- TOC entry 5681 (class 1259 OID 2248961)
-- Dependencies: 415 6389
-- Name: requisicaomudancaitemconfiguracao_iditemconfiguracao_idx; Type: INDEX;