-- Revisado por: thiago.monteiro
-- Data: 29/04/2013
-- SGBD: Oracle

set define off;

-- SCRIPT SQL COMPLEMENTAR ADICIONADO EM 18:21 04-04-2013

alter table scripts modify tipo varchar2(10 char);

insert into scripts (idscript, nome, descricao, sqlquery, tipo, datainicio) values (3, 'Consulta erros de rotina de scripts', 'Consulta os erros que ocorreram durante a execuo automtica de scripts feita durante a inicializao do sistema', 'select scripts.descricao, scripts.sqlquery, versao.nomeversao from scripts inner join versao on scripts.idversao = versao.idversao where scripts.idversao is not null and scripts.descricao like ''ERRO%'';', 'consulta', to_date('2013-04-04', 'YYYY-MM-DD') );

insert into scripts (idscript, nome, descricao, sqlquery, tipo, datainicio) values (5, 'Limpa erros de rotina de scripts', 'Limpa o registro de erros que ocorreram durante a execuo automtica de scripts feita durante a inicializao do sistema', 'update scripts set descricao = concat(''CORRIGIDO '', descricao) where idversao is not null and descricao like ''ERRO%'' and idscript > 0;', 'update', to_date('2013-04-04', 'YYYY-MM-DD') );

insert into tipocomplexidade (complexidade, desctipocomplexidade) values ('B', 'Baixa');
insert into tipocomplexidade (complexidade, desctipocomplexidade) values ('I', 'Intermediria');
insert into tipocomplexidade (complexidade, desctipocomplexidade) values ('M', 'Mediana');
insert into tipocomplexidade (complexidade, desctipocomplexidade) values ('A', 'Alta');
insert into tipocomplexidade (complexidade, desctipocomplexidade) values ('E', 'Especialista');

-- INICIO - MURILO GABRIEL RODRIGUES - SENTENCAS ADICIONADAS A PEDIDO DO VALDOILO
CREATE TRIGGER "UPDATE_SLAREQ"
BEFORE INSERT OR UPDATE OF DATAULTMODIFICACAO ON SLAREQUISITOSLA 
FOR EACH ROW
BEGIN
  :NEW.DATAULTMODIFICACAO := SYSTIMESTAMP; 
END;
ALTER TRIGGER "UPDATE_SLAREQ" ENABLE;

alter table categoriagaleriaimagem add (datafim date);

alter table categoriagaleriaimagem add (datainicio date);
ALTER TRIGGER "UPDATE_SLAREQ" ENABLE;

ALTER TABLE PROCESSAMENTOBATCH MODIFY (EXPRESSAOCRON NULL);
-- FIM 

-- INICIO - MODULO DE MUDANCA
alter table requisicaomudanca add (nomecategoriamudanca varchar2(15) );

alter table grupo add (comiteconsultivomudanca varchar2(1) null);

create table tipomudanca (
    idtipomudanca number(10,0) not null,
    idtipofluxo number(10,0) null,
    idmodeloemailcriacao number(10,0) null,
    idmodeloemailfinalizacao number(10,0) null,
    idmodeloemailacoes number(10,0) null,
    idgrupoexecutor number(10,0) null,
    idcalendario number(10,0) null,
    nometipomudanca varchar2(100) null,
    datainicio date null,
    datafim date null
);

alter table tipomudanca add primary key (idtipomudanca);
alter table tipomudanca add constraint fk_tipomudanca_bpm_tipofluxo foreign key (idtipofluxo) references bpm_tipofluxo (idtipofluxo);
alter table tipomudanca add constraint fk_tipomudanca_modelosemails_c foreign key (idmodeloemailcriacao) references modelosemails (idmodeloemail);

alter table tipomudanca add constraint fk_tipomudanca_modelosemails_f foreign key (idmodeloemailfinalizacao) references modelosemails (idmodeloemail);

alter table tipomudanca add constraint fk_tipomudanca_modelosemails_a  foreign key (idmodeloemailacoes) references modelosemails (idmodeloemail);

alter table tipomudanca add constraint fk_tipomudanca_grupo foreign key (idgrupoexecutor) references grupo (idgrupo);

alter table tipomudanca add constraint fk_tipomudanca_calendario foreign key (idcalendario) references calendario (idcalendario);

alter table requisicaomudanca drop constraint fk_requisic_reference_cat;

-- alter table requisicaomudanca drop column tipo;
alter table requisicaomudanca rename column idcategoriamudanca to idtipomudanca;

alter table requisicaomudanca modify (idtipomudanca number(10,0) null);


alter table requisicaomudanca add constraint fk_requisicaomudanca_tipomudan foreign key (idtipomudanca) references tipomudanca (idtipomudanca);

alter table requisicaomudanca add (idcontrato number(10,0) not null);

alter table requisicaomudanca add (idunidade number(10,0) );

alter table requisicaomudanca add (idcontatorequisicaomudanca number(10,0) );

create table contatorequisicaomudanca (
    idcontatorequisicaomudanca number(10,0) not null,
    nomecontato varchar2(100),
    telefonecontato varchar2(100),
    emailcontato varchar2(200),
    observacao clob,
    idlocalidade number(10,0),
    ramal varchar2(5)
);

alter table contatorequisicaomudanca add primary key (idcontatorequisicaomudanca);

alter table requisicaomudanca add (idgrupocomite number(10,0) null );

alter table requisicaomudanca add constraint fk_requisicaomudanca_grupo foreign key (idgrupocomite) references grupo (idgrupo);

create table aprovacaomudanca (
    idaprovacaomudanca number(10,0) not null,
    idrequisicaomudanca number(10,0) null,
    idempregado number(10,0) null,
    nomeempregado varchar2(45) null,
    voto char(1) null,
    comentario varchar2(200) null
);

alter table aprovacaomudanca add primary key (idaprovacaomudanca);

create index fk_requisicaomudanca_idx on aprovacaomudanca (idrequisicaomudanca);

create index fk_empregado_idx on aprovacaomudanca (idempregado);

alter table aprovacaomudanca add constraint fk_requisicaomudanca foreign key (idrequisicaomudanca) references requisicaomudanca (idrequisicaomudanca);

alter table aprovacaomudanca add constraint fk_empregado foreign key (idempregado) references empregados (idempregado);

alter table requisicaomudanca add (enviaemailgrupocomite varchar2(1) null);

alter table ocorrenciamudanca add (idcategoriaocorrencia number(10,0) );

alter table ocorrenciamudanca add (idorigemocorrencia number(10,0) );

alter table requisicaomudanca add (datahorainicioagendada date default null);

alter table requisicaomudanca add (datahoraterminoagendada date default null);

alter table requisicaomudanca add (idlocalidade number(10,0) );

alter table aprovacaomudanca add (datahorainicio date null);

create table justificativamudanca (
    idjustificativamudanca number(10,0) not null,
    descricaojustificativa varchar2(100) not null,
    suspensao char(1) not null,
    situacao char(1) not null,
    aprovacao char(1) default null,
    deleted char(1) default null
);

alter table justificativamudanca add primary key (idjustificativamudanca);

create table anexomudanca (
    idanexomudanca number(10,0) not null,
    idmudanca number(10,0),
    datainicio date,
    datafim date,
    nome varchar2(256),
    link varchar2(256),
    extensao varchar2(10),
    descricao varchar2(256)
);

alter table anexomudanca add primary key (idanexomudanca);

-- No MySQL por padro  '0000-00-00 00:00:00' no Oracle no tem essa representao.
alter table requisicaomudanca modify datahoraconclusao date not null;

alter table requisicaomudanca add (fechamento clob null);

-- SCRIPT ADICIONAL PARA RESOLVER O PROBLEMA DE ADICAO DA DATA ATUAL NOS CAMPOS DA TABELA.
alter table requisicaomudanca modify datahoraconclusao date default null;

alter table requisicaomudanca modify datahorainicio date default null;

alter table requisicaomudanca modify datahoratermino date default null;

alter table requisicaomudanca modify datahoracaptura date default null;

alter table requisicaomudanca modify datahorareativacao date default null;

alter table requisicaomudanca modify datahorasuspensao date default null;

alter table requisicaomudanca modify datahorainicioagendada date default null;

alter table requisicaomudanca modify datahoraterminoagendada date default null;

-- Incio rodrigo.oliveira

alter table atividadesos add (contabilizar char(1) default null);

alter table atividadesos add (idservicocontratocontabil number(19,0) default null);

alter table atividadesservicocontrato add (contabilizar char(1) default null);

alter table atividadesservicocontrato add (idservicocontratocontabil number(19,0) default null);

create table vinculaosincidente (
   idos number(10,0) not null,
   idsolicitacaoservico number(19,0) not null,
   idatividadesos number(19,0) not null
);

alter table vinculaosincidente add primary key (idos, idsolicitacaoservico);

-- fim rodrigo.oliveira

-- INICIO - MODULO DE PROBLEMA

alter table problema modify datahoralimite date null;

alter table problema modify datahorasolicitacao date null;

-- FIM - MODULO DE PROBLEMA

-- Oracle - Flvio jnior - 15/04
-- Trigger DDL Statements

create or replace trigger trg_slareqsla_dataultmo_bf_upd
before update on slarequisitosla
for each row
begin
    select sysdate into :new.dataultmodificacao from dual; 
end trg_slareqsla_dataultmo_bf_upd;

create or replace trigger trg_slareqsla_dataultmo_bf_ins
before insert on slarequisitosla
for each row
begin
    select sysdate into :new.dataultmodificacao from dual; 
end trg_slareqsla_dataultmo_bf_ins;

alter table limitealcada rename column limitevaloritem to limiteitemusointerno;
alter table limitealcada rename column limitevalormensal to limitemensalusointerno;
alter table limitealcada add limiteitematendcliente numeric(11,2) DEFAULT NULL;
alter table limitealcada add limitemensalatendcliente numeric(11,2) DEFAULT NULL;
